import { NString } from "@magic-xpa/mscorelib";
export class TaskDefinitionId {
    constructor(ctlIndex, programIsn, taskIsn, isProgram) {
        this.CtlIndex = 0;
        this.ProgramIsn = 0;
        this.TaskIsn = 0;
        this.IsProgram = false;
        if (arguments.length === 4)
            this.constructor_0(ctlIndex, programIsn, taskIsn, isProgram);
        else
            this.constructor_1();
    }
    constructor_0(ctlIndex, programIsn, taskIsn, isProgram) {
        this.CtlIndex = ctlIndex;
        this.ProgramIsn = programIsn;
        this.IsProgram = isProgram;
        this.TaskIsn = (isProgram ? 0 : taskIsn);
    }
    constructor_1() {
    }
    IsMainProgram() {
        return this.IsProgram && this.ProgramIsn === 1;
    }
    Equals(obj) {
        if (obj === null || !(obj instanceof TaskDefinitionId))
            return false;
        return this.GetHashCode() === obj.GetHashCode();
    }
    GetHashCode() {
        let strHashCode = this.HashCodeString();
        return NString.GetHashCode(strHashCode);
    }
    HashCodeString() {
        let strHashCode = this.CtlIndex + "." + this.IsProgram + "." + this.ProgramIsn + "." + this.TaskIsn;
        return strHashCode;
    }
    toString() {
        return NString.Format("{{Task ID: {0} ctl {1}/prg {2}{3} (hash: {4})}}", [
            this.IsProgram ? "Program" : "Task",
            this.CtlIndex,
            this.ProgramIsn,
            this.IsProgram ? "" : NString.Format(" Task {0}", this.TaskIsn),
            this.HashCodeString()
        ]);
    }
    fromJSON(jsonStr) {
        let obj = JSON.parse(jsonStr);
        this.CtlIndex = obj.CtlIndex;
        this.ProgramIsn = obj.ProgramIsn;
        this.TaskIsn = obj.TaskIsn;
        this.IsProgram = obj.IsProgram;
    }
}
//# sourceMappingURL=data:application/json;base64,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