import { JSON_Utils, XMLConstants } from "@magic-xpa/utils";
import { TaskDefinitionId } from "./TaskDefinitionId";
import { Events } from "../../Events";
import { isNullOrUndefined } from "@magic-xpa/mscorelib";
export class TaskDefinitionIdTableSaxHandler {
    constructor(newTaskDefintionIdHandler) {
        this._newTaskDefinitionIdHandler = null;
        this._newTaskDefinitionIdHandler = newTaskDefintionIdHandler;
    }
    parse(xmlSerializedTaskDefinitionsTable) {
        try {
            if (xmlSerializedTaskDefinitionsTable !== null) {
                JSON_Utils.JSONFromXML(xmlSerializedTaskDefinitionsTable, this.ParseJSON.bind(this));
            }
        }
        catch (ex) {
            Events.WriteExceptionToLog(ex);
        }
    }
    ParseJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let ctlIndex = 0;
        let isPrg = false;
        let prgIsn = 0;
        let taskIsn = 0;
        let taskDefId = result['taskDefinitionId']['$'];
        if (!isNullOrUndefined(taskDefId[XMLConstants.MG_ATTR_CTL_IDX]))
            ctlIndex = +taskDefId[XMLConstants.MG_ATTR_CTL_IDX];
        if (!isNullOrUndefined(taskDefId[XMLConstants.MG_ATTR_PROGRAM_ISN]))
            prgIsn = +taskDefId[XMLConstants.MG_ATTR_PROGRAM_ISN];
        if (!isNullOrUndefined(taskDefId[XMLConstants.MG_ATTR_TASK_ISN]))
            taskIsn = +taskDefId[XMLConstants.MG_ATTR_TASK_ISN];
        if (!isNullOrUndefined(taskDefId[XMLConstants.MG_ATTR_ISPRG]))
            isPrg = taskDefId[XMLConstants.MG_ATTR_ISPRG] === '1';
        let taskDefinitionId = new TaskDefinitionId(ctlIndex, prgIsn, taskIsn, isPrg);
        this._newTaskDefinitionIdHandler(taskDefinitionId);
    }
}
//# sourceMappingURL=data:application/json;base64,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