import { Events } from "../Events";
import { JSON_Utils, XMLConstants } from "@magic-xpa/utils";
export class ObjectReference {
    constructor(ctlIndex, objectIsn) {
        this.CtlIndex = 0;
        this.ObjectISN = 0;
        this.CtlIndex = ctlIndex;
        this.ObjectISN = objectIsn;
    }
    toString() {
        return "{Object Ref: " + this.CtlIndex + "," + this.ObjectISN + "}";
    }
    static FromXML(xmlData) {
        this.ParsedReference = null;
        try {
            if (xmlData !== null) {
                JSON_Utils.JSONFromXML(xmlData, this.FillFromJSON.bind(this));
            }
        }
        catch (ex) {
            Events.WriteExceptionToLog(ex);
        }
        return this.ParsedReference;
    }
    static FillFromJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let objRefElement = result[XMLConstants.MG_TAG_OBJECT_REFERENCE]['$'];
        let ctlIndex = +objRefElement.ctl_idx;
        let objectIsn = +objRefElement.isn;
        this.ParsedReference = new ObjectReference(ctlIndex, objectIsn);
    }
}
ObjectReference.ParsedReference = null;
//# sourceMappingURL=data:application/json;base64,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