import { Debug, StringBuilder, NString, Int32, List, ApplicationException, Encoding, ISO_8859_1_Encoding, NNumber, NumberStyles, RefParam, DateTime, isNullOrUndefined, Hashtable, Exception, NChar, NumberFormatInfo, Stack, Dictionary, StackTrace, NotImplementedException } from '@magic-xpa/mscorelib';
import { OSEnvironment, MgControlType, CtrlButtonTypeGui, UtilStrByteMode, UtilImeJpn, StrUtil, Logger, StorageAttribute, PICInterface, MsgInterface, SEQ_2_HTML, HTML_2_STR, Constants, Randomizer, UtilDateJpn, DateUtil, Base64, XmlParser, StorageAttributeCheck, XMLConstants, JSON_Utils, ListboxSelectionMode, TransMode, Logger_LogLevels, Misc, MagicProperties, ChoiceUtils, SEQ_2_STR, InternalInterface, WindowType, TabbingOrderType, Rtf, HelpType } from '@magic-xpa/utils';
import { timer } from 'rxjs';

class MgValue {
    constructor() {
        this.str = null;
        this.caption = null;
        this.title = null;
        this.path = null;
        this.filter = null;
        this.boolVal = false;
        this.bool1 = false;
        this.style = 0;
        this.number = 0;
        this.obj = null;
        this.listOfIntArr = null;
    }
}

class ControlBase {
}

class GuiMgForm extends ControlBase {
}

class Events {
    static OnFocus(ctrl, line, isProduceClick, onMultiMark) {
        Debug.Assert(Events.FocusEvent !== null);
        Events.FocusEvent(ctrl, line, isProduceClick, onMultiMark);
    }
    static OnFocusOnNonMagicControl(ctrl) {
        Debug.Assert(Events.FocusOnNonMagicControlEvent !== null);
        Events.FocusOnNonMagicControlEvent(ctrl);
    }
    static OnMouseDown(guiMgForm, guiMgCtrl, dotNetArgs, leftClickWasPressed, line, onMultiMark, canProduceClick) {
        Debug.Assert(Events.MouseDownEvent !== null);
        Events.MouseDownEvent(guiMgForm, guiMgCtrl, dotNetArgs, leftClickWasPressed, line, onMultiMark, canProduceClick);
    }
    static OnNonParkableLastParkedCtrl(ctrl) {
        if (Events.NonParkableLastParkedCtrlEvent !== null) {
            Events.NonParkableLastParkedCtrlEvent(ctrl);
        }
    }
    static OnTableReorder(ctrl, tabOrderList) {
        if (Events.TableReorderEvent !== null) {
            Events.TableReorderEvent(ctrl, tabOrderList);
        }
    }
    static OnMouseUp(ctrl, line) {
        if (Events.MouseUpEvent !== null) {
            Events.MouseUpEvent(ctrl, line);
        }
    }
    static OnComboDroppingDown(ctrl, line) {
        Debug.Assert(Events.ComboDroppingDownEvent !== null);
        Events.ComboDroppingDownEvent(ctrl, line);
    }
    static OnSelection(val, ctrl, line, produceClick) {
        Debug.Assert(Events.SelectionEvent !== null);
        Events.SelectionEvent(val, ctrl, line, produceClick);
    }
    static OnDblClick(ctrl, line) {
        Debug.Assert(Events.DblClickEvent !== null);
        Events.DblClickEvent(ctrl, line);
    }
    static OnKeyDown(form, guiMgCtrlOrCtrl, modifier, keyCode, startOrSuggestedValue, endOrComboIsDropDown, textOrHandled, isActChar, suggestedValue, comboIsDropDownOrHandled, handled) {
        if (arguments.length === 11)
            Events.OnKeyDown_0(form, guiMgCtrlOrCtrl, modifier, keyCode, startOrSuggestedValue, endOrComboIsDropDown, textOrHandled, isActChar, suggestedValue, comboIsDropDownOrHandled, handled);
        else if (arguments.length === 10)
            Events.OnKeyDown_1(form, guiMgCtrlOrCtrl, modifier, keyCode, startOrSuggestedValue, endOrComboIsDropDown, textOrHandled, isActChar, suggestedValue, comboIsDropDownOrHandled);
        else
            Events.OnKeyDown_2(form, guiMgCtrlOrCtrl, modifier, keyCode, startOrSuggestedValue, endOrComboIsDropDown, textOrHandled);
    }
    static OnKeyDown_0(form, guiMgCtrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, comboIsDropDown, handled) {
        Debug.Assert(Events.KeyDownEvent !== null);
        Events.KeyDownEvent(form, guiMgCtrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, comboIsDropDown, handled);
    }
    static OnMultiMarkHit(ctrl, row, modifier) {
        Debug.Assert(Events.MultimarkHitEvent !== null);
        Events.MultimarkHitEvent(ctrl, row, modifier);
    }
    static OnKeyDown_1(form, ctrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, handled) {
        Debug.Assert(Events.KeyDownEvent !== null);
        return Events.KeyDownEvent(form, ctrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, false, handled);
    }
    static OnKeyDown_2(form, ctrl, modifier, keyCode, suggestedValue, comboIsDropDown, handled) {
        Debug.Assert(Events.KeyDownEvent !== null);
        return Events.KeyDownEvent(form, ctrl, modifier, keyCode, 0, 0, null, false, suggestedValue, comboIsDropDown, handled);
    }
    static OnFormClose(form) {
        Debug.Assert(Events.CloseFormEvent !== null);
        return Events.CloseFormEvent(form);
    }
    static OnDispose(form) {
        Debug.Assert(Events.DisposeEvent !== null);
        Events.DisposeEvent(form);
    }
    static OnTimer(mgTimer) {
        Debug.Assert(Events.TimerEvent !== null);
        Events.TimerEvent(mgTimer);
    }
    static OnTableResize(ctrl, newRowsInPage) {
        if (Events.TableResizeEvent !== null) {
            Events.TableResizeEvent(ctrl, newRowsInPage);
        }
    }
    static OnGetRowsData(ctrl, desiredTopIndex, sendAll, lastFocusedVal) {
        if (Events.GetRowsDataEvent !== null) {
            Events.GetRowsDataEvent(ctrl, desiredTopIndex, sendAll, lastFocusedVal);
        }
    }
    static OnColumnClick(columnCtrl, direction, columnHeader) {
        Debug.Assert(Events.ColumnClickEvent !== null);
        Events.ColumnClickEvent(columnCtrl, direction, columnHeader);
    }
    static RefreshTables() {
        if (Events.RefreshTablesEvent !== null) {
            Events.RefreshTablesEvent();
        }
    }
    static OnCloseHelp(activeForm) {
        if (Events.HelpCloseEvent !== null) {
            Events.HelpCloseEvent(activeForm);
        }
    }
    static IsBatchRunningInMainContext() {
        let retValue = false;
        if (Events.IsBatchRunningInMainContextEvent !== null) {
            retValue = Events.IsBatchRunningInMainContextEvent();
        }
        return retValue;
    }
    static Translate(fromString) {
        Debug.Assert(Events.TranslateEvent !== null);
        return (fromString !== null && fromString.length > 0) ? Events.TranslateEvent(fromString) : fromString;
    }
    static OnPrintPreviewStart(contextID, ioPtr, copies, enablePDlg, hWnd) {
        if (Events.PrintPreviewStartEvent !== null) {
            Events.PrintPreviewStartEvent(contextID, ioPtr, copies, enablePDlg, hWnd);
        }
    }
    static OnPrintPreviewSetCursor(printPreviewData) {
        if (Events.PrintPreviewSetCursorEvent !== null) {
            Events.PrintPreviewSetCursorEvent(printPreviewData);
        }
    }
    static InvokeUDP(contextId) {
        let ret = 0;
        if (Events.InvokeUDPEvent !== null) {
            ret = Events.InvokeUDPEvent(contextId);
        }
        return ret;
    }
    static OnPrintPreviewUpdate(prnPrevData) {
        if (Events.PrintPreviewUpdateEvent !== null) {
            Events.PrintPreviewUpdateEvent(prnPrevData);
        }
    }
    static OnCreateRichWindow(contextID, ctrlPtr, prmPtr, style, dwExStyle) {
        if (Events.CreateRichWindowEvent !== null) {
            Events.CreateRichWindowEvent(contextID, ctrlPtr, prmPtr, style, dwExStyle);
        }
    }
    static OnCreateGuiWindow(exStyle, className, windowName, style, x, y, width, height, hwndParent, hMenu, hInstance, lParam) {
        let retValue = 0;
        if (Events.CreateGuiWindowEvent !== null) {
            retValue = Events.CreateGuiWindowEvent(exStyle, className, windowName, style, x, y, width, height, hwndParent, hMenu, hInstance, lParam);
        }
        return retValue;
    }
    static OnDestroyGuiWindow(hWndPtr) {
        if (Events.DestroyGuiWindowEvent !== null) {
            Events.DestroyGuiWindowEvent(hWndPtr);
        }
    }
    static OnPrintPreviewClose(printPreviewDataPtr) {
        if (Events.PrintPreviewCloseEvent !== null) {
            Events.PrintPreviewCloseEvent(printPreviewDataPtr);
        }
    }
    static OnShowPrintDialog(gpd) {
        let retValue = 0;
        if (Events.ShowPrintDialogEvent !== null) {
            retValue = Events.ShowPrintDialogEvent(gpd);
        }
        return retValue;
    }
    static DisplaySessionStatistics() {
        if (Events.DisplaySessionStatisticsEvent !== null) {
            Events.DisplaySessionStatisticsEvent();
        }
    }
    static ShouldBlockMouseEvents(ctrl) {
        return Events.ShouldBlockMouseEventsEvent !== null && Events.ShouldBlockMouseEventsEvent(ctrl);
    }
    static PeekEndOfWork() {
        return Events.PeekEndOfWorkEvent !== null && Events.PeekEndOfWorkEvent();
    }
    static GetEventTime() {
        return (Events.GetEventTimeEvent !== null) ? Events.GetEventTimeEvent() : 0;
    }
    static OnScrollTable(guiMgObject, line, rowsToScroll, isPageScroll, isTableScroll, isRaisedByMouseWheel) {
        let handled = false;
        if (Events.ScrollTableEvent !== null) {
            handled = Events.ScrollTableEvent(guiMgObject, line, rowsToScroll, isPageScroll, isTableScroll, isRaisedByMouseWheel);
        }
        return handled;
    }
    static GetDropUserFormats() {
        Debug.Assert(Events.GetDropUserFormatsEvent !== null);
        return Events.GetDropUserFormatsEvent();
    }
    static GetContextID(guiMgForm) {
        let contextID = -1;
        Debug.Assert(guiMgForm !== null);
        if (Events.GetContextIDEvent !== null) {
            contextID = Events.GetContextIDEvent(guiMgForm);
        }
        return contextID;
    }
    static SetModal(mgForm, on) {
        if (Events.SetModalEvent !== null) {
            Events.SetModalEvent(mgForm, on);
        }
    }
    static OnShowForm(guiMgForm) {
        if (Events.ShowFormEvent !== null) {
            Events.ShowFormEvent(guiMgForm);
        }
    }
    static OnFormActivate(guiMgForm) {
        if (Events.OnFormActivateEvent !== null) {
            Events.OnFormActivateEvent(guiMgForm);
        }
    }
    static OnNCActivate(guiMgForm) {
        if (Events.OnNCActivateEvent !== null) {
            Events.OnNCActivateEvent(guiMgForm);
        }
    }
    static HandleKeyUpMessage(guiMgForm, keyCode) {
        if (Events.HandleKeyUpMessageEvent !== null) {
            Events.HandleKeyUpMessageEvent(guiMgForm, keyCode);
        }
    }
    static IsLogonRTL() {
        let isRTL = false;
        if (Events.OnIsLogonRTLEvent !== null) {
            isRTL = Events.OnIsLogonRTLEvent();
        }
        return isRTL;
    }
    static IsSpecialEngLogon() {
        let isEngLogon = false;
        if (Events.OnIsSpecialEngLogonEvent !== null) {
            isEngLogon = Events.OnIsSpecialEngLogonEvent();
        }
        return isEngLogon;
    }
    static IsSpecialIgnoreButtonFormat() {
        let isIgnoreButtonFormat = false;
        if (Events.OnIsSpecialIgnoreButtonFormatEvent !== null) {
            isIgnoreButtonFormat = Events.OnIsSpecialIgnoreButtonFormatEvent();
        }
        return isIgnoreButtonFormat;
    }
    static GetMainProgram(contextID, ctlIdx) {
        Debug.Assert(Events.GetMainProgramEvent !== null);
        return Events.GetMainProgramEvent(contextID, ctlIdx);
    }
    static TranslateLogicalName(fromString) {
        Debug.Assert(Events.TranslateLogicalNameEvent !== null);
        return Events.TranslateLogicalNameEvent(fromString);
    }
    static GetMessageString(msgId) {
        Debug.Assert(Events.GetMessageStringEvent !== null);
        let fromString = Events.GetMessageStringEvent(msgId);
        let text = Events.Translate(fromString);
        if (text !== null && text.endsWith(":")) {
            let str;
            str = new StringBuilder(text);
            str.Insert(text.length, " ");
            text = str.ToString();
        }
        return text;
    }
    static OnCtrlFocus(iTask, ctrl) {
        if (Events.CtrlFocusEvent !== null) {
            Events.CtrlFocusEvent(iTask, ctrl);
        }
    }
    static GetRuntimeContext(contextID) {
        Debug.Assert(Events.GetRuntimeContextEvent !== null);
        return Events.GetRuntimeContextEvent(contextID);
    }
    static SaveLastClickedCtrlName(guiMgControl, controlName) {
        if (Events.SaveLastClickedCtrlEvent !== null) {
            Events.SaveLastClickedCtrlEvent(controlName);
        }
    }
    static SaveLastClickInfo(guiMgForm, controlName, x, y, offsetX, offsetY, lastClickCoordinatesAreInPixels) {
        if (Events.SaveLastClickInfoEvent !== null) {
            Events.SaveLastClickInfoEvent(controlName, x, y, offsetX, offsetY, lastClickCoordinatesAreInPixels);
        }
    }
    static WriteErrorToLog(msg) {
        Debug.Assert(Events.WriteErrorToLogEvent !== null);
        Events.WriteErrorToLogEvent(msg);
    }
    static WriteExceptionToLog(msgOrEx) {
        if (arguments.length === 1 && (msgOrEx === null || msgOrEx.constructor === String)) {
            Events.WriteExceptionToLog_0(msgOrEx);
            return;
        }
        Events.WriteExceptionToLog_1(msgOrEx);
    }
    static WriteExceptionToLog_0(msg) {
        Debug.Assert(Events.WriteErrorToLogEvent !== null);
        Events.WriteErrorToLogEvent(msg);
    }
    static WriteExceptionToLog_1(ex) {
        Events.WriteExceptionToLog(NString.Format("{0} : {1}{2}{3}{4}", [
            ex.GetType(), OSEnvironment.EolSeq, ex.StackTrace, OSEnvironment.EolSeq, ex.Message
        ]));
    }
    static WriteWarningToLog(msgOrEx) {
        if (arguments.length === 1 && (msgOrEx === null || msgOrEx.constructor === String)) {
            Events.WriteWarningToLog_0(msgOrEx);
            return;
        }
        Events.WriteWarningToLog_1(msgOrEx);
    }
    static WriteWarningToLog_0(msg) {
        Debug.Assert(Events.WriteWarningToLogEvent !== null);
        Events.WriteWarningToLogEvent(msg);
    }
    static WriteWarningToLog_1(ex) {
        Events.WriteWarningToLog(ex.GetType() + " : " + OSEnvironment.EolSeq + ex.StackTrace + OSEnvironment.EolSeq + ex.Message);
    }
    static ShouldLog(logLevel) {
        Debug.Assert(Events.ShouldLogEvent !== null);
        return Events.ShouldLogEvent(logLevel);
    }
    static WriteGuiToLog(msg) {
        Debug.Assert(Events.WriteGuiToLogEvent !== null);
        Events.WriteGuiToLogEvent("GUI: " + msg);
    }
    static WriteDevToLog(msg) {
        Debug.Assert(Events.WriteDevToLogEvent !== null);
        Events.WriteDevToLogEvent(msg);
    }
    static OnClear(ctrl) {
        if (Events.ClearEvent !== null) {
            Events.ClearEvent(ctrl);
        }
    }
    static OnUndo(ctrl) {
        if (Events.UndoEvent !== null) {
            Events.UndoEvent(ctrl);
        }
    }
    static AddEnterAsKeyEvent() {
        return Events.ShouldAddEnterAsKeyEvent !== null && Events.ShouldAddEnterAsKeyEvent();
    }
    static ShowSessionStatisticsForm() {
        if (Events.ShowSessionStatisticsEvent !== null) {
            Events.ShowSessionStatisticsEvent();
        }
    }
    static OnCopyData(guiMgForm, copyData) {
        if (Events.CopyDataEvent !== null) {
            Events.CopyDataEvent(guiMgForm, copyData);
        }
    }
    constructor() {
    }
}
Events.NonParkableLastParkedCtrlEvent = null;
Events.IsBatchRunningInMainContextEvent = null;
Events.TranslateEvent = null;
Events.PrintPreviewStartEvent = null;
Events.PrintPreviewSetCursorEvent = null;
Events.InvokeUDPEvent = null;
Events.PrintPreviewUpdateEvent = null;
Events.CreateRichWindowEvent = null;
Events.CreateGuiWindowEvent = null;
Events.DestroyGuiWindowEvent = null;
Events.PrintPreviewCloseEvent = null;
Events.ShowPrintDialogEvent = null;
Events.SetModalEvent = null;
Events.CtrlFocusEvent = null;
Events.GetRuntimeContextEvent = null;
Events.SaveLastClickedCtrlEvent = null;
Events.SaveLastClickInfoEvent = null;
Events.WriteErrorToLogEvent = null;
Events.WriteExceptionToLogEvent = null;
Events.WriteWarningToLogEvent = null;
Events.ShouldLogEvent = null;
Events.WriteGuiToLogEvent = null;
Events.WriteDevToLogEvent = null;
Events.ClearEvent = null;
Events.UndoEvent = null;
Events.ShouldAddEnterAsKeyEvent = null;
Events.ShowSessionStatisticsEvent = null;
Events.CopyDataEvent = null;
Events.FocusEvent = null;
Events.FocusOnNonMagicControlEvent = null;
Events.MouseDownEvent = null;
Events.TableReorderEvent = null;
Events.MouseUpEvent = null;
Events.ComboDroppingDownEvent = null;
Events.SelectionEvent = null;
Events.DblClickEvent = null;
Events.KeyDownEvent = null;
Events.MultimarkHitEvent = null;
Events.CloseFormEvent = null;
Events.DisposeEvent = null;
Events.TimerEvent = null;
Events.TableResizeEvent = null;
Events.GetRowsDataEvent = null;
Events.EnableCutCopyEvent = null;
Events.EnablePasteEvent = null;
Events.ColumnClickEvent = null;
Events.RefreshTablesEvent = null;
Events.HelpCloseEvent = null;
Events.DisplaySessionStatisticsEvent = null;
Events.ShouldBlockMouseEventsEvent = null;
Events.PeekEndOfWorkEvent = null;
Events.GetEventTimeEvent = null;
Events.ScrollTableEvent = null;
Events.GetDropUserFormatsEvent = null;
Events.GetContextIDEvent = null;
Events.ShowFormEvent = null;
Events.OnFormActivateEvent = null;
Events.OnNCActivateEvent = null;
Events.HandleKeyUpMessageEvent = null;
Events.OnIsLogonRTLEvent = null;
Events.OnIsSpecialEngLogonEvent = null;
Events.OnIsSpecialIgnoreButtonFormatEvent = null;
Events.GetMainProgramEvent = null;
Events.TranslateLogicalNameEvent = null;
Events.GetMessageStringEvent = null;

class UIBridge {
    constructor() {
        this.getInteractiveCallback = null;
        this.executeCommandsCallback = null;
    }
    static getInstance() {
        if (!UIBridge.instance) {
            UIBridge.instance = new UIBridge();
        }
        return UIBridge.instance;
    }
    ExecuteInteractiveCommand(command) {
        if (this.getInteractiveCallback != null)
            return this.getInteractiveCallback(command);
        return "";
    }
    executeCommands(commands) {
        if (this.executeCommandsCallback != null && commands != null) {
            this.executeCommandsCallback(commands);
        }
    }
    registerInteractiveCallback(getIntractiveCallback) {
        this.getInteractiveCallback = getIntractiveCallback;
    }
    registerExecuteCommandsCallback(executeCommandsCallback) {
        this.executeCommandsCallback = executeCommandsCallback;
    }
    saveData(data) {
        console.log(data);
    }
}

class GuiCommandQueue {
    constructor() {
        this._commandsQueue = null;
        this._executingGuiCommands = false;
        this.init();
    }
    static getInstance() {
        if (GuiCommandQueue._instance === null)
            GuiCommandQueue._instance = new GuiCommandQueue();
        return GuiCommandQueue._instance;
    }
    init() {
        this._commandsQueue = new Array();
    }
    addCommand(guiCommand) {
        this.put(guiCommand);
    }
    put(guiCommand) {
        this._commandsQueue.push(guiCommand);
    }
    beginInvoke() {
        this.invoke();
    }
    invoke() {
        if (!this._executingGuiCommands) {
            this._executingGuiCommands = true;
            UIBridge.getInstance().executeCommands(this._commandsQueue);
            this._commandsQueue.length = 0;
            this._executingGuiCommands = false;
        }
    }
}
GuiCommandQueue._instance = null;

var InteractiveCommandType;
(function (InteractiveCommandType) {
    InteractiveCommandType[InteractiveCommandType["GET_VALUE"] = 0] = "GET_VALUE";
    InteractiveCommandType[InteractiveCommandType["GET_TOP_INDEX"] = 1] = "GET_TOP_INDEX";
    InteractiveCommandType[InteractiveCommandType["MESSAGE_BOX"] = 2] = "MESSAGE_BOX";
    InteractiveCommandType[InteractiveCommandType["SET_TITLE"] = 3] = "SET_TITLE";
    InteractiveCommandType[InteractiveCommandType["SET_EDIT_TEXT"] = 4] = "SET_EDIT_TEXT";
    InteractiveCommandType[InteractiveCommandType["INSERT_EDIT_TEXT"] = 5] = "INSERT_EDIT_TEXT";
    InteractiveCommandType[InteractiveCommandType["GET_CARET_POS"] = 6] = "GET_CARET_POS";
    InteractiveCommandType[InteractiveCommandType["REFRESH_PAGE"] = 7] = "REFRESH_PAGE";
    InteractiveCommandType[InteractiveCommandType["GET_ROWS_IN_PAGE"] = 8] = "GET_ROWS_IN_PAGE";
    InteractiveCommandType[InteractiveCommandType["SET_GET_SUGGESTED_VALUE_FOR_CHOICE_CONTROL_ON_TAGDATA"] = 9] = "SET_GET_SUGGESTED_VALUE_FOR_CHOICE_CONTROL_ON_TAGDATA";
    InteractiveCommandType[InteractiveCommandType["GET_IS_ROW_EDITING"] = 10] = "GET_IS_ROW_EDITING";
    InteractiveCommandType[InteractiveCommandType["GET_MAX_ROWS_IN_PAGINATED_TABLE"] = 11] = "GET_MAX_ROWS_IN_PAGINATED_TABLE";
    InteractiveCommandType[InteractiveCommandType["CALL_JS"] = 12] = "CALL_JS";
    InteractiveCommandType[InteractiveCommandType["GET_LAST_ROUTE"] = 13] = "GET_LAST_ROUTE";
})(InteractiveCommandType || (InteractiveCommandType = {}));
class GuiInteractiveBase {
    constructor() {
        this._commandType = 0;
        this.TaskTag = null;
        this.controlName = null;
        this._str = String.fromCharCode(0);
        this._intVal1 = 0;
        this._line = 0;
        this._obj1 = null;
        this._parameters = null;
        this._boolVal = false;
        this._obj2 = null;
        this._mgValue = null;
        this.resultString = String.fromCharCode(0);
    }
    setGetSuggestedValueOfChoiceControlOnTagData(ctrl, line, retSuggestedValue) {
        this._commandType = InteractiveCommandType.SET_GET_SUGGESTED_VALUE_FOR_CHOICE_CONTROL_ON_TAGDATA;
        this._obj2 = ctrl;
        this._line = line;
        this._boolVal = retSuggestedValue;
        this.Invoke();
    }
    getValue(obj, line) {
        this._commandType = InteractiveCommandType.GET_VALUE;
        this._obj2 = obj;
        this._line = line;
        this._mgValue = new MgValue();
        this.Invoke();
        return this._mgValue.obj;
    }
    getTopIndex(tablecontrol) {
        this._commandType = InteractiveCommandType.GET_TOP_INDEX;
        this._obj2 = tablecontrol;
        this.Invoke();
        return this._intVal1;
    }
    getIsRowEditing(tablecontrol, line, isLineMode) {
        this._commandType = InteractiveCommandType.GET_IS_ROW_EDITING;
        this._obj2 = tablecontrol;
        this._intVal1 = line;
        this._boolVal = isLineMode;
        this.Invoke();
        return this._boolVal;
    }
    messageBox(title, msg, style) {
        this._commandType = InteractiveCommandType.MESSAGE_BOX;
        this._mgValue = new MgValue();
        this._mgValue.title = title;
        this._mgValue.str = ((msg === null) ? '' : msg);
        this._mgValue.style = style;
        Events.RefreshTables();
        this.Invoke();
        return this._mgValue.number;
    }
    setTitle(topMostForm, title) {
        this._commandType = InteractiveCommandType.SET_TITLE;
        this._mgValue = new MgValue();
        this._obj2 = topMostForm;
        this._mgValue.title = ((title === null) ? '' : title);
        this.Invoke();
    }
    setEditText(control, line, text) {
        this._commandType = InteractiveCommandType.SET_EDIT_TEXT;
        this._obj2 = control;
        this._line = line;
        this._mgValue = new MgValue();
        this._mgValue.str = text;
        this.Invoke();
        return this._mgValue.boolVal;
    }
    insertEditText(control, line, startPosition, textToInsert) {
        this._commandType = InteractiveCommandType.INSERT_EDIT_TEXT;
        this._obj2 = control;
        this._line = line;
        this._mgValue = new MgValue();
        this._mgValue.str = textToInsert;
        this._intVal1 = startPosition;
        this.Invoke();
        return this._mgValue.boolVal;
    }
    caretPosGet(control, line) {
        this._commandType = InteractiveCommandType.GET_CARET_POS;
        this._obj2 = control;
        this._line = line;
        this._mgValue = new MgValue();
        this.Invoke();
        return this._mgValue.number;
    }
    RefreshPage(navigateToRootRoute, initialUrl) {
        this._commandType = InteractiveCommandType.REFRESH_PAGE;
        this._boolVal = navigateToRootRoute;
        this._obj1 = initialUrl;
        this.Invoke();
        return;
    }
    getRowsInPage(control) {
        this._commandType = InteractiveCommandType.GET_ROWS_IN_PAGE;
        this._obj2 = control;
        this.Invoke();
        return this._intVal1;
    }
    getMaxRowsInPaginatedTable(control) {
        this._commandType = InteractiveCommandType.GET_MAX_ROWS_IN_PAGINATED_TABLE;
        this._obj2 = control;
        this.Invoke();
        return this._intVal1;
    }
    getLastRoute() {
        this._commandType = InteractiveCommandType.GET_LAST_ROUTE;
        this.Invoke();
        return this.resultString;
    }
    ExecuteCallJS(form, formName, functionName, args) {
        this._commandType = InteractiveCommandType.CALL_JS;
        this._obj2 = form;
        this.controlName = formName;
        this._str = functionName;
        this.arguments = args;
        this.Invoke();
        return this.resultString;
    }
    Invoke() {
        GuiCommandQueue.getInstance().invoke();
        if (this._obj2 instanceof ControlBase) {
            let controlBase = this._obj2;
            this.TaskTag = controlBase.TaskTag;
            this.controlName = controlBase.UniqueName;
        }
        else if (this._obj2 instanceof GuiMgForm) {
            let guiMgForm = this._obj2;
            this.TaskTag = guiMgForm.TaskTag;
        }
        else
            this.TaskTag = '0';
        UIBridge.getInstance().ExecuteInteractiveCommand(this);
    }
    onGetRowsInPage() {
    }
}
class GuiInteractive extends GuiInteractiveBase {
}

class GuiMgControl extends ControlBase {
    constructor() {
        super(...arguments);
        this._type = MgControlType.CTRL_TYPE_NONE;
        this.ButtonStyle = CtrlButtonTypeGui.None;
        this.IsRepeatable = false;
        this.Layer = 0;
        this.Name = null;
        this.GuiMgForm = null;
    }
    set Type(value) {
        if (this._type === MgControlType.CTRL_TYPE_NONE) {
            this._type = value;
        }
        else {
            Debug.Assert(false);
        }
    }
    get Type() {
        return this._type;
    }
    get IsTableChild() {
        let parent = ((this.getParent() instanceof GuiMgControl) ? this.getParent() : null);
        let parentIsTable = parent !== null && parent.isTableControl();
        return parentIsTable && !this.isColumnControl();
    }
    get IsTableHeaderChild() {
        return !this.IsRepeatable && this.IsTableChild;
    }
    getName(line) {
        let result;
        if (this.IsRepeatable) {
            if (line > Int32.MinValue) {
                result = this.Name + "_" + line;
            }
            else {
                result = this.Name + "_0";
            }
        }
        else {
            result = this.Name;
        }
        return result;
    }
    get UniqueName() {
        return this.Name;
    }
    isStatic() {
        return this._type === MgControlType.CTRL_TYPE_LABEL || this._type === MgControlType.CTRL_TYPE_GROUP || this._type === MgControlType.CTRL_TYPE_TABLE ||
            this._type === MgControlType.CTRL_TYPE_COLUMN || this._type === MgControlType.CTRL_TYPE_STATUS_BAR || this._type === MgControlType.CTRL_TYPE_SB_IMAGE ||
            this._type === MgControlType.CTRL_TYPE_SB_LABEL || this._type === MgControlType.CTRL_TYPE_LINE;
    }
    isTableControl() {
        return this._type === MgControlType.CTRL_TYPE_TABLE;
    }
    isTabControl() {
        return this._type === MgControlType.CTRL_TYPE_TAB;
    }
    isTextControl() {
        return this._type === MgControlType.CTRL_TYPE_TEXT;
    }
    isImageControl() {
        return this._type === MgControlType.CTRL_TYPE_IMAGE;
    }
    isSubform() {
        return this._type === MgControlType.CTRL_TYPE_SUBFORM;
    }
    isRadio() {
        return this._type === MgControlType.CTRL_TYPE_RADIO;
    }
    isComboBox() {
        return this._type === MgControlType.CTRL_TYPE_COMBO;
    }
    isListBox() {
        return this._type === MgControlType.CTRL_TYPE_LIST;
    }
    isButton() {
        return this._type === MgControlType.CTRL_TYPE_BUTTON;
    }
    isLabel() {
        return this._type === MgControlType.CTRL_TYPE_LABEL;
    }
    isGroup() {
        return this._type === MgControlType.CTRL_TYPE_GROUP;
    }
    isSelectionCtrl() {
        return this._type === MgControlType.CTRL_TYPE_COMBO || this._type === MgControlType.CTRL_TYPE_LIST;
    }
    isCheckBox() {
        return this._type === MgControlType.CTRL_TYPE_CHECKBOX;
    }
    isColumnControl() {
        return this._type === MgControlType.CTRL_TYPE_COLUMN;
    }
    isChoiceControl() {
        let val = false;
        switch (this._type) {
            case MgControlType.CTRL_TYPE_TAB:
            case MgControlType.CTRL_TYPE_COMBO:
            case MgControlType.CTRL_TYPE_LIST:
            case MgControlType.CTRL_TYPE_RADIO:
                val = true;
                break;
        }
        return val;
    }
    IsImageButton() {
        let result = false;
        if (this.isButton()) {
            result = (this.ButtonStyle === CtrlButtonTypeGui.Image);
        }
        return result;
    }
    IsHyperTextButton() {
        let result = false;
        if (this.isButton()) {
            result = (this.ButtonStyle === CtrlButtonTypeGui.Hypertext);
        }
        return result;
    }
}

var DateElement;
(function (DateElement) {
    DateElement["YEAR"] = "Y";
    DateElement["MONTH"] = "M";
    DateElement["DAY"] = "D";
    DateElement["DOW"] = "W";
})(DateElement || (DateElement = {}));
var MenuEntryProgram_SrcContext;
(function (MenuEntryProgram_SrcContext) {
    MenuEntryProgram_SrcContext["Main"] = "M";
    MenuEntryProgram_SrcContext["Current"] = "C";
})(MenuEntryProgram_SrcContext || (MenuEntryProgram_SrcContext = {}));
var EditReturnCode;
(function (EditReturnCode) {
    EditReturnCode[EditReturnCode["EDIT_CONTINUE"] = 0] = "EDIT_CONTINUE";
    EditReturnCode[EditReturnCode["EDIT_AUTOSKIP"] = 1] = "EDIT_AUTOSKIP";
    EditReturnCode[EditReturnCode["EDIT_RESTART"] = 2] = "EDIT_RESTART";
})(EditReturnCode || (EditReturnCode = {}));
var GuiExpressionEvaluator_ControlsPersistencyClearOption;
(function (GuiExpressionEvaluator_ControlsPersistencyClearOption) {
    GuiExpressionEvaluator_ControlsPersistencyClearOption[GuiExpressionEvaluator_ControlsPersistencyClearOption["All"] = 1] = "All";
    GuiExpressionEvaluator_ControlsPersistencyClearOption[GuiExpressionEvaluator_ControlsPersistencyClearOption["CurrentForm"] = 2] = "CurrentForm";
})(GuiExpressionEvaluator_ControlsPersistencyClearOption || (GuiExpressionEvaluator_ControlsPersistencyClearOption = {}));
var DataModificationTypes;
(function (DataModificationTypes) {
    DataModificationTypes["Update"] = "u";
    DataModificationTypes["Insert"] = "i";
    DataModificationTypes["Delete"] = "d";
    DataModificationTypes["None"] = " ";
})(DataModificationTypes || (DataModificationTypes = {}));
var MgCheckState;
(function (MgCheckState) {
    MgCheckState[MgCheckState["UNCHECKED"] = 1] = "UNCHECKED";
    MgCheckState[MgCheckState["CHECKED"] = 2] = "CHECKED";
    MgCheckState[MgCheckState["INDETERMINATE"] = 3] = "INDETERMINATE";
})(MgCheckState || (MgCheckState = {}));
var MarkMode;
(function (MarkMode) {
    MarkMode[MarkMode["MARK_ALL_TEXT"] = 1] = "MARK_ALL_TEXT";
    MarkMode[MarkMode["UNMARK_ALL_TEXT"] = 2] = "UNMARK_ALL_TEXT";
    MarkMode[MarkMode["MARK_SELECTION_TEXT"] = 3] = "MARK_SELECTION_TEXT";
})(MarkMode || (MarkMode = {}));
var MgCursors;
(function (MgCursors) {
    MgCursors[MgCursors["ARROW"] = 1] = "ARROW";
    MgCursors[MgCursors["WAITCURSOR"] = 2] = "WAITCURSOR";
    MgCursors[MgCursors["HAND"] = 3] = "HAND";
    MgCursors[MgCursors["APPSTARTING"] = 4] = "APPSTARTING";
    MgCursors[MgCursors["CROSS"] = 5] = "CROSS";
    MgCursors[MgCursors["HELP"] = 6] = "HELP";
    MgCursors[MgCursors["IBEAM"] = 7] = "IBEAM";
    MgCursors[MgCursors["NO"] = 8] = "NO";
    MgCursors[MgCursors["SIZEALL"] = 9] = "SIZEALL";
    MgCursors[MgCursors["SIZENESW"] = 10] = "SIZENESW";
    MgCursors[MgCursors["SIZENS"] = 11] = "SIZENS";
    MgCursors[MgCursors["SIZENWSE"] = 12] = "SIZENWSE";
    MgCursors[MgCursors["SIZEWE"] = 13] = "SIZEWE";
    MgCursors[MgCursors["UPARROW"] = 14] = "UPARROW";
})(MgCursors || (MgCursors = {}));
var Modifiers;
(function (Modifiers) {
    Modifiers["MODIFIER_ALT"] = "A";
    Modifiers["MODIFIER_CTRL"] = "C";
    Modifiers["MODIFIER_SHIFT"] = "S";
    Modifiers["MODIFIER_NONE"] = " ";
    Modifiers["MODIFIER_SHIFT_CTRL"] = "X";
    Modifiers["MODIFIER_ALT_CTRL"] = "Y";
    Modifiers["MODIFIER_ALT_SHIFT"] = "Z";
})(Modifiers || (Modifiers = {}));
var CommandType;
(function (CommandType) {
    CommandType[CommandType["OPEN_FORM"] = 0] = "OPEN_FORM";
    CommandType[CommandType["CREATE_FORM"] = 1] = "CREATE_FORM";
    CommandType[CommandType["INITIAL_FORM_LAYOUT"] = 2] = "INITIAL_FORM_LAYOUT";
    CommandType[CommandType["SHOW_FORM"] = 3] = "SHOW_FORM";
    CommandType[CommandType["CREATE_LABEL"] = 4] = "CREATE_LABEL";
    CommandType[CommandType["CREATE_EDIT"] = 5] = "CREATE_EDIT";
    CommandType[CommandType["CREATE_BUTTON"] = 6] = "CREATE_BUTTON";
    CommandType[CommandType["CREATE_COMBO_BOX"] = 7] = "CREATE_COMBO_BOX";
    CommandType[CommandType["CREATE_LIST_BOX"] = 8] = "CREATE_LIST_BOX";
    CommandType[CommandType["CREATE_RADIO_CONTAINER"] = 9] = "CREATE_RADIO_CONTAINER";
    CommandType[CommandType["CREATE_RADIO_BUTTON"] = 10] = "CREATE_RADIO_BUTTON";
    CommandType[CommandType["CREATE_IMAGE"] = 11] = "CREATE_IMAGE";
    CommandType[CommandType["CREATE_CHECK_BOX"] = 12] = "CREATE_CHECK_BOX";
    CommandType[CommandType["CREATE_TAB"] = 13] = "CREATE_TAB";
    CommandType[CommandType["CREATE_TABLE"] = 14] = "CREATE_TABLE";
    CommandType[CommandType["CREATE_COLUMN"] = 15] = "CREATE_COLUMN";
    CommandType[CommandType["CREATE_SUB_FORM"] = 16] = "CREATE_SUB_FORM";
    CommandType[CommandType["CLOSE_SUB_FORM"] = 17] = "CLOSE_SUB_FORM";
    CommandType[CommandType["CREATE_BROWSER"] = 18] = "CREATE_BROWSER";
    CommandType[CommandType["CREATE_GROUP"] = 19] = "CREATE_GROUP";
    CommandType[CommandType["CREATE_RICH_EDIT"] = 20] = "CREATE_RICH_EDIT";
    CommandType[CommandType["CREATE_RICH_TEXT"] = 21] = "CREATE_RICH_TEXT";
    CommandType[CommandType["CREATE_LINE"] = 22] = "CREATE_LINE";
    CommandType[CommandType["DISPOSE_OBJECT"] = 23] = "DISPOSE_OBJECT";
    CommandType[CommandType["PROP_SET_CONTROL_NAME"] = 24] = "PROP_SET_CONTROL_NAME";
    CommandType[CommandType["PROP_SET_TEXT"] = 25] = "PROP_SET_TEXT";
    CommandType[CommandType["PROP_SET_READ_ONLY"] = 26] = "PROP_SET_READ_ONLY";
    CommandType[CommandType["PROP_SET_TEXT_SIZE_LIMIT"] = 27] = "PROP_SET_TEXT_SIZE_LIMIT";
    CommandType[CommandType["PROP_SET_ITEMS_LIST"] = 28] = "PROP_SET_ITEMS_LIST";
    CommandType[CommandType["PROP_SET_IMAGE_FILE_NAME"] = 29] = "PROP_SET_IMAGE_FILE_NAME";
    CommandType[CommandType["PROP_SET_IMAGE_DATA"] = 30] = "PROP_SET_IMAGE_DATA";
    CommandType[CommandType["PROP_SET_IMAGE_LIST"] = 31] = "PROP_SET_IMAGE_LIST";
    CommandType[CommandType["PROP_SET_TOOLTIP"] = 32] = "PROP_SET_TOOLTIP";
    CommandType[CommandType["PROP_SET_VISIBLE"] = 33] = "PROP_SET_VISIBLE";
    CommandType[CommandType["PROP_SET_ENABLE"] = 34] = "PROP_SET_ENABLE";
    CommandType[CommandType["PROP_SET_MENU_ENABLE"] = 35] = "PROP_SET_MENU_ENABLE";
    CommandType[CommandType["PROP_SET_VISIBLE_LINES"] = 36] = "PROP_SET_VISIBLE_LINES";
    CommandType[CommandType["PROP_SET_RIGHT_TO_LEFT"] = 37] = "PROP_SET_RIGHT_TO_LEFT";
    CommandType[CommandType["PROP_SET_CHECKED"] = 38] = "PROP_SET_CHECKED";
    CommandType[CommandType["PROP_SET_SELECTION"] = 39] = "PROP_SET_SELECTION";
    CommandType[CommandType["PROP_SET_LAYOUT_NUM_COLUMN"] = 40] = "PROP_SET_LAYOUT_NUM_COLUMN";
    CommandType[CommandType["PROP_SET_LINE_VISIBLE"] = 41] = "PROP_SET_LINE_VISIBLE";
    CommandType[CommandType["PROP_SET_RESIZABLE"] = 42] = "PROP_SET_RESIZABLE";
    CommandType[CommandType["PROP_SET_ALLOW_REORDER"] = 43] = "PROP_SET_ALLOW_REORDER";
    CommandType[CommandType["PROP_SET_SORTABLE_COLUMN"] = 44] = "PROP_SET_SORTABLE_COLUMN";
    CommandType[CommandType["PROP_SET_COLUMN_PLACMENT"] = 45] = "PROP_SET_COLUMN_PLACMENT";
    CommandType[CommandType["PROP_SET_ICON_FILE_NAME"] = 46] = "PROP_SET_ICON_FILE_NAME";
    CommandType[CommandType["SET_WINDOW_STATE"] = 47] = "SET_WINDOW_STATE";
    CommandType[CommandType["SET_COLUMN_ORG_WIDTH"] = 48] = "SET_COLUMN_ORG_WIDTH";
    CommandType[CommandType["SET_COLUMN_START_POS"] = 49] = "SET_COLUMN_START_POS";
    CommandType[CommandType["SET_TABLE_ITEMS_COUNT"] = 50] = "SET_TABLE_ITEMS_COUNT";
    CommandType[CommandType["SET_TABLE_VIRTUAL_ITEMS_COUNT"] = 51] = "SET_TABLE_VIRTUAL_ITEMS_COUNT";
    CommandType[CommandType["SET_TABLE_VSCROLL_THUMB_POS"] = 52] = "SET_TABLE_VSCROLL_THUMB_POS";
    CommandType[CommandType["SET_TABLE_VSCROLL_PAGE_SIZE"] = 53] = "SET_TABLE_VSCROLL_PAGE_SIZE";
    CommandType[CommandType["SET_TABLE_INCLUDES_FIRST"] = 54] = "SET_TABLE_INCLUDES_FIRST";
    CommandType[CommandType["SET_TABLE_INCLUDES_LAST"] = 55] = "SET_TABLE_INCLUDES_LAST";
    CommandType[CommandType["SET_TABLE_TOP_INDEX"] = 56] = "SET_TABLE_TOP_INDEX";
    CommandType[CommandType["SET_SELECTION_INDEX"] = 57] = "SET_SELECTION_INDEX";
    CommandType[CommandType["INVALIDATE_TABLE"] = 58] = "INVALIDATE_TABLE";
    CommandType[CommandType["REFRESH_TABLE"] = 59] = "REFRESH_TABLE";
    CommandType[CommandType["REFRESH_TMP_EDITOR"] = 60] = "REFRESH_TMP_EDITOR";
    CommandType[CommandType["UPDATE_TMP_EDITOR_INDEX"] = 61] = "UPDATE_TMP_EDITOR_INDEX";
    CommandType[CommandType["CREATE_TABLE_ROW"] = 62] = "CREATE_TABLE_ROW";
    CommandType[CommandType["UNDO_CREATE_TABLE_ROW"] = 63] = "UNDO_CREATE_TABLE_ROW";
    CommandType[CommandType["SET_TABLE_ROW_VISIBILITY"] = 64] = "SET_TABLE_ROW_VISIBILITY";
    CommandType[CommandType["VALIDATE_TABLE_ROW"] = 65] = "VALIDATE_TABLE_ROW";
    CommandType[CommandType["INSERT_ROWS"] = 66] = "INSERT_ROWS";
    CommandType[CommandType["REMOVE_ROWS"] = 67] = "REMOVE_ROWS";
    CommandType[CommandType["CLEAR_TABLE_COLUMNS_SORT_MARK"] = 68] = "CLEAR_TABLE_COLUMNS_SORT_MARK";
    CommandType[CommandType["PROP_SET_URL"] = 69] = "PROP_SET_URL";
    CommandType[CommandType["MOVE_ABOVE"] = 70] = "MOVE_ABOVE";
    CommandType[CommandType["SET_FOCUS"] = 71] = "SET_FOCUS";
    CommandType[CommandType["WRITE_TO_MESSAGE_BOX"] = 72] = "WRITE_TO_MESSAGE_BOX";
    CommandType[CommandType["CLOSE_FORM"] = 73] = "CLOSE_FORM";
    CommandType[CommandType["REMOVE_SUBFORM_CONTROLS"] = 74] = "REMOVE_SUBFORM_CONTROLS";
    CommandType[CommandType["START_TIMER"] = 75] = "START_TIMER";
    CommandType[CommandType["STOP_TIMER"] = 76] = "STOP_TIMER";
    CommandType[CommandType["BEEP"] = 77] = "BEEP";
    CommandType[CommandType["CREATE_TOOLBAR"] = 78] = "CREATE_TOOLBAR";
    CommandType[CommandType["DELETE_TOOLBAR"] = 79] = "DELETE_TOOLBAR";
    CommandType[CommandType["CREATE_TOOLBAR_ITEM"] = 80] = "CREATE_TOOLBAR_ITEM";
    CommandType[CommandType["DELETE_TOOLBAR_ITEM"] = 81] = "DELETE_TOOLBAR_ITEM";
    CommandType[CommandType["CREATE_STATUS_BAR"] = 82] = "CREATE_STATUS_BAR";
    CommandType[CommandType["PROP_SET_SB_PANE_WIDTH"] = 83] = "PROP_SET_SB_PANE_WIDTH";
    CommandType[CommandType["CREATE_SB_LABEL"] = 84] = "CREATE_SB_LABEL";
    CommandType[CommandType["CREATE_SB_IMAGE"] = 85] = "CREATE_SB_IMAGE";
    CommandType[CommandType["SHOW_TMP_EDITOR"] = 86] = "SHOW_TMP_EDITOR";
    CommandType[CommandType["PROP_SET_TRANSLATOR"] = 87] = "PROP_SET_TRANSLATOR";
    CommandType[CommandType["PROP_SET_PASSWORD_EDIT"] = 88] = "PROP_SET_PASSWORD_EDIT";
    CommandType[CommandType["PROP_SET_TITLE_BAR"] = 89] = "PROP_SET_TITLE_BAR";
    CommandType[CommandType["PROP_SHOW_FULL_ROW"] = 90] = "PROP_SHOW_FULL_ROW";
    CommandType[CommandType["PROP_SHOW_BUTTONS"] = 91] = "PROP_SHOW_BUTTONS";
    CommandType[CommandType["PROP_SHOW_LINES"] = 92] = "PROP_SHOW_LINES";
    CommandType[CommandType["PROP_SHOW_SCROLLBAR"] = 93] = "PROP_SHOW_SCROLLBAR";
    CommandType[CommandType["SET_ENV_ACCESS_TEST"] = 94] = "SET_ENV_ACCESS_TEST";
    CommandType[CommandType["SET_ENV_TOOLTIP_TIMEOUT"] = 95] = "SET_ENV_TOOLTIP_TIMEOUT";
    CommandType[CommandType["SET_ENV_SPECIAL_TEXT_SIZE_FACTORING"] = 96] = "SET_ENV_SPECIAL_TEXT_SIZE_FACTORING";
    CommandType[CommandType["SET_ENV_SPECIAL_FLAT_EDIT_ON_CLASSIC_THEME"] = 97] = "SET_ENV_SPECIAL_FLAT_EDIT_ON_CLASSIC_THEME";
    CommandType[CommandType["PROP_SET_STARTUP_POSITION"] = 98] = "PROP_SET_STARTUP_POSITION";
    CommandType[CommandType["PROP_SET_CHECK_BOX_CHECKED"] = 99] = "PROP_SET_CHECK_BOX_CHECKED";
    CommandType[CommandType["COMBO_DROP_DOWN"] = 100] = "COMBO_DROP_DOWN";
    CommandType[CommandType["SET_ACTIVETE_KEYBOARD_LAYOUT"] = 101] = "SET_ACTIVETE_KEYBOARD_LAYOUT";
    CommandType[CommandType["SET_TAG_DATA_LINK_VISITED"] = 102] = "SET_TAG_DATA_LINK_VISITED";
    CommandType[CommandType["ALLOW_UPDATE"] = 103] = "ALLOW_UPDATE";
    CommandType[CommandType["SET_ALIGNMENT"] = 104] = "SET_ALIGNMENT";
    CommandType[CommandType["BULLET"] = 105] = "BULLET";
    CommandType[CommandType["INDENT"] = 106] = "INDENT";
    CommandType[CommandType["UNINDENT"] = 107] = "UNINDENT";
    CommandType[CommandType["CHANGE_COLUMN_SORT_MARK"] = 108] = "CHANGE_COLUMN_SORT_MARK";
    CommandType[CommandType["SET_CURRENT_CURSOR"] = 109] = "SET_CURRENT_CURSOR";
    CommandType[CommandType["REORDER_COLUMNS"] = 110] = "REORDER_COLUMNS";
    CommandType[CommandType["RESTORE_COLUMNS"] = 111] = "RESTORE_COLUMNS";
    CommandType[CommandType["ACTIVATE_FORM"] = 112] = "ACTIVATE_FORM";
    CommandType[CommandType["LOCK_WINDOW_UPDATE"] = 113] = "LOCK_WINDOW_UPDATE";
    CommandType[CommandType["ENABLE_XPTHEMES"] = 114] = "ENABLE_XPTHEMES";
    CommandType[CommandType["TOGGLE_ALTERNATE_COLOR_FOR_FIRST_ROW"] = 115] = "TOGGLE_ALTERNATE_COLOR_FOR_FIRST_ROW";
    CommandType[CommandType["REGISTER_DN_CTRL_VALUE_CHANGED_EVENT"] = 116] = "REGISTER_DN_CTRL_VALUE_CHANGED_EVENT";
    CommandType[CommandType["SET_TABLE_ORG_ROW_HEIGHT"] = 117] = "SET_TABLE_ORG_ROW_HEIGHT";
    CommandType[CommandType["SET_TOOLBAR"] = 118] = "SET_TOOLBAR";
    CommandType[CommandType["CREATE_ENTRY_IN_CONTROLS_MAP"] = 119] = "CREATE_ENTRY_IN_CONTROLS_MAP";
    CommandType[CommandType["REMOVE_ENTRY_FROM_CONTROLS_MAP"] = 120] = "REMOVE_ENTRY_FROM_CONTROLS_MAP";
    CommandType[CommandType["PROCESS_PRESS_EVENT"] = 121] = "PROCESS_PRESS_EVENT";
    CommandType[CommandType["SET_MARKED_ITEM_STATE"] = 122] = "SET_MARKED_ITEM_STATE";
    CommandType[CommandType["ACCEPT_DVCONTROL_CHANGES"] = 123] = "ACCEPT_DVCONTROL_CHANGES";
    CommandType[CommandType["UPDATE_DVCONTROL_ROW"] = 124] = "UPDATE_DVCONTROL_ROW";
    CommandType[CommandType["ADD_DVCONTROL_HANDLER"] = 125] = "ADD_DVCONTROL_HANDLER";
    CommandType[CommandType["REMOVE_DVCONTROL_HANDLER"] = 126] = "REMOVE_DVCONTROL_HANDLER";
    CommandType[CommandType["CREATE_ROW_IN_DVCONTROL"] = 127] = "CREATE_ROW_IN_DVCONTROL";
    CommandType[CommandType["UPDATE_DVCONTROL_COLUMN"] = 128] = "UPDATE_DVCONTROL_COLUMN";
    CommandType[CommandType["DELETE_DVCONTROL_ROW"] = 129] = "DELETE_DVCONTROL_ROW";
    CommandType[CommandType["SET_DVCONTROL_ROW_POSITION"] = 130] = "SET_DVCONTROL_ROW_POSITION";
    CommandType[CommandType["REJECT_DVCONTROL_COLUMN_CHANGES"] = 131] = "REJECT_DVCONTROL_COLUMN_CHANGES";
    CommandType[CommandType["SET_DESIGNER_VALUES"] = 132] = "SET_DESIGNER_VALUES";
    CommandType[CommandType["PROP_SET_EDIT_HINT"] = 133] = "PROP_SET_EDIT_HINT";
    CommandType[CommandType["PROP_SET_MULTI_COLUMN_DISPLAY"] = 134] = "PROP_SET_MULTI_COLUMN_DISPLAY";
    CommandType[CommandType["SET_ENV_LAMGUAGE"] = 135] = "SET_ENV_LAMGUAGE";
    CommandType[CommandType["SET_LAST_IN_CONTEXT"] = 136] = "SET_LAST_IN_CONTEXT";
    CommandType[CommandType["SET_CARET"] = 137] = "SET_CARET";
    CommandType[CommandType["SET_RECORDS_BEFORE_CURRENT_VIEW"] = 138] = "SET_RECORDS_BEFORE_CURRENT_VIEW";
    CommandType[CommandType["SET_VALUE"] = 139] = "SET_VALUE";
    CommandType[CommandType["SET_ATTRIBUTE"] = 140] = "SET_ATTRIBUTE";
    CommandType[CommandType["SET_PROPERTY"] = 141] = "SET_PROPERTY";
    CommandType[CommandType["SET_CLASS"] = 142] = "SET_CLASS";
    CommandType[CommandType["SET_STYLE"] = 143] = "SET_STYLE";
    CommandType[CommandType["REFRESH_TASK"] = 144] = "REFRESH_TASK";
    CommandType[CommandType["PROP_SET_USER_PROPERTY"] = 145] = "PROP_SET_USER_PROPERTY";
    CommandType[CommandType["PROP_SET_CUSTOM_VALIDATOR"] = 146] = "PROP_SET_CUSTOM_VALIDATOR";
    CommandType[CommandType["SET_IS_ROW_EDITING"] = 147] = "SET_IS_ROW_EDITING";
    CommandType[CommandType["SET_NOT_IS_ROW_EDITING"] = 148] = "SET_NOT_IS_ROW_EDITING";
    CommandType[CommandType["SET_EMPTY_DATAVIEW"] = 149] = "SET_EMPTY_DATAVIEW";
    CommandType[CommandType["SET_IS_LOGGED_IN"] = 150] = "SET_IS_LOGGED_IN";
    CommandType[CommandType["RELOAD_PAGE"] = 151] = "RELOAD_PAGE";
    CommandType[CommandType["EXIT_MAGIC"] = 152] = "EXIT_MAGIC";
    CommandType[CommandType["CALL_JS"] = 153] = "CALL_JS";
    CommandType[CommandType["PROP_SET_BINDING_LEVEL"] = 154] = "PROP_SET_BINDING_LEVEL";
    CommandType[CommandType["SHOW_SPINNER"] = 155] = "SHOW_SPINNER";
    CommandType[CommandType["SHOW_HTML_ERROR"] = 156] = "SHOW_HTML_ERROR";
    CommandType[CommandType["SET_WC_IDLE"] = 157] = "SET_WC_IDLE";
    CommandType[CommandType["SET_CHUNK_SIZE"] = 158] = "SET_CHUNK_SIZE";
})(CommandType || (CommandType = {}));
var HtmlProperties;
(function (HtmlProperties) {
    HtmlProperties["Visible"] = "visible";
    HtmlProperties["Enabled"] = "enabled";
    HtmlProperties["Text"] = "text";
    HtmlProperties["ItemsList"] = "itemslist";
    HtmlProperties["Image"] = "image";
    HtmlProperties["Tooltip"] = "tooltip";
    HtmlProperties["SelectedValue"] = "selectedvalue";
    HtmlProperties["ShowBorder"] = "showborder";
    HtmlProperties["PlaceHolder"] = "placeholder";
    HtmlProperties["Password"] = "password";
    HtmlProperties["TabIndex"] = "tabindex";
    HtmlProperties["SelectedRow"] = "selectedRow";
    HtmlProperties["ReadOnly"] = "readOnly";
    HtmlProperties["MustInput"] = "mustInput";
    HtmlProperties["SelectedLayer"] = "SelectedLayer";
    HtmlProperties["BindingLevel"] = "bindingLevel";
    HtmlProperties["ZoomButtonTooltip"] = "ZoomButtonTooltip";
})(HtmlProperties || (HtmlProperties = {}));
var MenuStyle;
(function (MenuStyle) {
    MenuStyle[MenuStyle["MENU_STYLE_PULLDOWN"] = 1] = "MENU_STYLE_PULLDOWN";
    MenuStyle[MenuStyle["MENU_STYLE_CONTEXT"] = 2] = "MENU_STYLE_CONTEXT";
    MenuStyle[MenuStyle["MENU_STYLE_TOOLBAR"] = 3] = "MENU_STYLE_TOOLBAR";
})(MenuStyle || (MenuStyle = {}));
var DockingStyle;
(function (DockingStyle) {
    DockingStyle[DockingStyle["NONE"] = 0] = "NONE";
    DockingStyle[DockingStyle["BOTTOM"] = 1] = "BOTTOM";
    DockingStyle[DockingStyle["FILL"] = 2] = "FILL";
    DockingStyle[DockingStyle["LEFT"] = 3] = "LEFT";
    DockingStyle[DockingStyle["RIGHT"] = 4] = "RIGHT";
    DockingStyle[DockingStyle["TOP"] = 5] = "TOP";
})(DockingStyle || (DockingStyle = {}));
var RaisedBy;
(function (RaisedBy) {
    RaisedBy[RaisedBy["USER_ACTION"] = 0] = "USER_ACTION";
    RaisedBy[RaisedBy["CLOSE_SYSTEM_MENU"] = 1] = "CLOSE_SYSTEM_MENU";
    RaisedBy[RaisedBy["CTRL_GOTO"] = 2] = "CTRL_GOTO";
    RaisedBy[RaisedBy["MOUSE_WHEEL"] = 3] = "MOUSE_WHEEL";
    RaisedBy[RaisedBy["INTERNAL"] = 4] = "INTERNAL";
    RaisedBy[RaisedBy["KBPUT"] = 5] = "KBPUT";
})(RaisedBy || (RaisedBy = {}));
var TraverseMode;
(function (TraverseMode) {
    TraverseMode[TraverseMode["NONE"] = 1] = "NONE";
    TraverseMode[TraverseMode["WITHIN_CONTROL"] = 2] = "WITHIN_CONTROL";
    TraverseMode[TraverseMode["BETWEEN_CONTROLS"] = 3] = "BETWEEN_CONTROLS";
})(TraverseMode || (TraverseMode = {}));
var ClipFormats;
(function (ClipFormats) {
    ClipFormats[ClipFormats["FORMAT_USER"] = 0] = "FORMAT_USER";
    ClipFormats[ClipFormats["FORMAT_TEXT"] = 1] = "FORMAT_TEXT";
    ClipFormats[ClipFormats["FORMAT_OEM_TEXT"] = 2] = "FORMAT_OEM_TEXT";
    ClipFormats[ClipFormats["FORMAT_RICH_TEXT"] = 3] = "FORMAT_RICH_TEXT";
    ClipFormats[ClipFormats["FORMAT_HTML_TEXT"] = 4] = "FORMAT_HTML_TEXT";
    ClipFormats[ClipFormats["FORMAT_HYPERLINK_TEXT"] = 5] = "FORMAT_HYPERLINK_TEXT";
    ClipFormats[ClipFormats["FORMAT_DROP_FILES"] = 6] = "FORMAT_DROP_FILES";
    ClipFormats[ClipFormats["FORMAT_UNICODE_TEXT"] = 7] = "FORMAT_UNICODE_TEXT";
    ClipFormats["FORMAT_UNKNOWN"] = "c";
})(ClipFormats || (ClipFormats = {}));
var OverlayType;
(function (OverlayType) {
    OverlayType[OverlayType["Overlay"] = 0] = "Overlay";
    OverlayType[OverlayType["Alert"] = 1] = "Alert";
    OverlayType[OverlayType["ConfirmationBox"] = 2] = "ConfirmationBox";
})(OverlayType || (OverlayType = {}));

class GuiCommand {
    constructor(commandTypeOrObjOrParentObject, strOrCommandTypeOrObj, cmmandType) {
        this.TaskTag = null;
        this.CommandType = 0;
        this.options = null;
        this.Bool1 = false;
        this.params = null;
        this.fileName = null;
        this.height = 0;
        this.layer = 0;
        this.line = 0;
        this.number = 0;
        this.obj = null;
        this.parentObject = null;
        this.obj1 = null;
        this.str = null;
        this.value = null;
        this.stringList = null;
        this.style = 0;
        this.width = 0;
        this.x = 0;
        this.y = 0;
        this.userDropFormat = null;
        this.contextID = '\0';
        if (arguments.length === 1 && (commandTypeOrObjOrParentObject === null || commandTypeOrObjOrParentObject.constructor === Number)) {
            this.constructor_0(commandTypeOrObjOrParentObject);
            return;
        }
        if (arguments.length === 2 && (commandTypeOrObjOrParentObject === null || commandTypeOrObjOrParentObject.constructor === Number)
            && (strOrCommandTypeOrObj === null || strOrCommandTypeOrObj.constructor === String)) {
            this.constructor_1(commandTypeOrObjOrParentObject, strOrCommandTypeOrObj);
            return;
        }
        else if (arguments.length === 2) {
            this.constructor_2(commandTypeOrObjOrParentObject, strOrCommandTypeOrObj);
            return;
        }
        this.constructor_3(commandTypeOrObjOrParentObject, strOrCommandTypeOrObj, cmmandType);
    }
    constructor_0(commandType) {
        this.CommandType = commandType;
    }
    constructor_1(commandType, str) {
        this.constructor_0(commandType);
        this.str = str;
    }
    constructor_2(obj, commandType) {
        this.constructor_0(commandType);
        this.obj = obj;
        if (this.obj instanceof ControlBase) {
            this.CtrlName = this.obj.UniqueName;
            this.TaskTag = this.obj.TaskTag;
        }
        else if (obj === null)
            this.TaskTag = "0";
    }
    constructor_3(parentObject, obj, cmmandType) {
        this.constructor_2(obj, cmmandType);
        this.parentObject = parentObject;
    }
    toString() {
        return "{" + this.CommandType + "}";
    }
}

class GuiConstants {
    constructor() {
    }
}
GuiConstants.DEFAULT_LIST_VALUE = -1;
GuiConstants.DEFAULT_VALUE_INT = -999999;
GuiConstants.ALL_LINES = -1;
GuiConstants.NO_ROW_SELECTED = Int32.MinValue;
GuiConstants.RIA_MOBILE_UNSUPPORTED_CONTROL_ERROR = "control is not supported for mobile RIA deployment";
GuiConstants.RIA_MOBILE_UNSUPPORTED_CONTROL_ERROR_WINDOW_6 = "control is not supported for mobile RIA deployment on Window 6 standard";
GuiConstants.TOOL_HEIGHT = 17;
GuiConstants.TOOL_WIDTH = 16;
GuiConstants.STR_DISPLAY_MEMBER = "DisplayMember";
GuiConstants.STR_VALUE_MEMBER = "ValueMember";
GuiConstants.PARENT_TYPE_TASK = 'T';
GuiConstants.PARENT_TYPE_FORM = 'F';
GuiConstants.PARENT_TYPE_CONTROL = 'C';
GuiConstants.GENERIC_PROPERTY_BASE_ID = 10000;
GuiConstants.TABBING_CYCLE_REMAIN_IN_CURRENT_RECORD = 'R';
GuiConstants.TABBING_CYCLE_MOVE_TO_NEXT_RECORD = 'N';
GuiConstants.TABBING_CYCLE_MOVE_TO_PARENT_TASK = 'P';
GuiConstants.BLOB_PREFIX_ELEMENTS_COUNT = 5;
GuiConstants.KEY_DOWN = 40;
GuiConstants.KEY_RIGHT = 39;
GuiConstants.KEY_UP = 38;
GuiConstants.KEY_LEFT = 37;
GuiConstants.KEY_HOME = 36;
GuiConstants.KEY_END = 35;
GuiConstants.KEY_PG_DOWN = 34;
GuiConstants.KEY_PG_UP = 33;
GuiConstants.KEY_SPACE = 32;
GuiConstants.KEY_F12 = 123;
GuiConstants.KEY_F1 = 112;
GuiConstants.KEY_9 = 57;
GuiConstants.KEY_0 = 48;
GuiConstants.KEY_Z = 90;
GuiConstants.KEY_A = 65;
GuiConstants.KEY_DELETE = 46;
GuiConstants.KEY_INSERT = 45;
GuiConstants.KEY_BACKSPACE = 8;
GuiConstants.KEY_TAB = 9;
GuiConstants.KEY_RETURN = 13;
GuiConstants.KEY_ESC = 27;
GuiConstants.KEY_CAPS_LOCK = 20;
GuiConstants.KEY_POINT1 = 190;
GuiConstants.KEY_POINT2 = 110;
GuiConstants.KEY_COMMA = 188;
GuiConstants.KEY_CTRL = 17;
GuiConstants.KEY_ALT = 18;
GuiConstants.LOGON_CAPTION = "Logon - ";
GuiConstants.ENTER_UID_TTL = "Please enter your user ID and password.";
GuiConstants.GROUP_BOX_TITLE_MAX_SIZE = 62;
GuiConstants.MSG_CAPTION_MAX_SIZE = 56;
GuiConstants.LABEL_CAPTION_MAX_SIZE = 9;
GuiConstants.PASSWORD_CAPTION_MAX_SIZE = 19;
GuiConstants.REPLACE_ALL_TEXT = -1;
GuiConstants.STR_LOGON_RTL = "LogonRTL";
GuiConstants.STR_LOGO_WIN_ICON_URL = "LogonWindowIconURL";
GuiConstants.STR_LOGON_IMAGE_URL = "LogonImageURL";
GuiConstants.STR_LOGON_WIN_TITLE = "LogonWindowTitle";
GuiConstants.STR_LOGON_GROUP_TITLE = "LogonGroupTitle";
GuiConstants.STR_LOGON_MSG_CAPTION = "LogonMessageCaption";
GuiConstants.STR_LOGON_USER_ID_CAPTION = "LogonUserIDCaption";
GuiConstants.STR_LOGON_PASS_CAPTION = "LogonPasswordCaption";
GuiConstants.STR_LOGON_OK_CAPTION = "LogonOKCaption";
GuiConstants.STR_LOGON_CANCEL_CAPTION = "LogonCancelCaption";

class Commands {
    static SetResolveCallback(resolveCallback) {
        this.resolveCallback = resolveCallback;
    }
    static ResolvePromise(result) {
        this.resolveCallback(result);
    }
    static async messageBox(title, msg, style) {
        let guiInteractive = new GuiInteractive();
        let returnValue;
        await new Promise((resolve) => {
            this.SetResolveCallback(resolve);
            guiInteractive.messageBox(title, msg, style);
        }).then((res) => { returnValue = res; });
        return returnValue;
    }
    static setTitle(topMostForm, title) {
        let guiInteractive = new GuiInteractive();
        guiInteractive.setTitle(topMostForm, title);
    }
    static setGetSuggestedValueOfChoiceControlOnTagData(ctrl, line, retSuggestedValue) {
        let guiInteractive = new GuiInteractive();
        guiInteractive.setGetSuggestedValueOfChoiceControlOnTagData(ctrl, line, retSuggestedValue);
    }
    static getValue(obj, line) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.getValue(obj, line);
    }
    static getTopIndex(tablecontrol) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.getTopIndex(tablecontrol);
    }
    static getIsRowEditing(tablecontrol, rowIndex, isLineMode) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.getIsRowEditing(tablecontrol, rowIndex, isLineMode);
    }
    static setEditText(control, line, text) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.setEditText(control, line, text);
    }
    static insertEditText(control, line, startPosition, textToInsert) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.insertEditText(control, line, startPosition, textToInsert);
    }
    static caretPosGet(control, line) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.caretPosGet(control, line);
    }
    static addRefreshPage(navigateToRootRoute, initialUrl) {
        let guiInteractive = new GuiInteractive();
        guiInteractive.RefreshPage(navigateToRootRoute, initialUrl);
    }
    static getRowsInPage(control) {
        let guiInteractive = new GuiInteractive();
        let rowsInPage = guiInteractive.getRowsInPage(control);
        return (rowsInPage === 0 ? 1 : rowsInPage);
    }
    static getMaxRowsInPaginatedTable(control) {
        let guiInteractive = new GuiInteractive();
        let maxRows = guiInteractive.getMaxRowsInPaginatedTable(control);
        return (maxRows);
    }
    static getLastRoute() {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.getLastRoute();
    }
    static addBoolWithLine(commandType, obj, line, bool) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.Bool1 = bool;
        guiCommand.line = line;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addNoParameters(commandType, obj) {
        let guiCommand = new GuiCommand(obj, commandType);
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addWithNumber(commandType, obj, num) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.number = num;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addValueWithLine(commandType, obj, line, value) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.value = value;
        guiCommand.line = line;
        if (commandType === CommandType.SET_VALUE) {
            if (obj instanceof GuiMgControl && obj.isChoiceControl()) {
                if (value < 0)
                    if (obj.isComboBox())
                        guiCommand.value = GuiConstants.DEFAULT_LIST_VALUE;
                    else
                        guiCommand.value = '';
            }
        }
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addOperationWithLine(commandType, obj, line, operation, value) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.obj1 = value;
        guiCommand.line = line;
        guiCommand.Operation = operation;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addOpensubform(commandType, obj, calledTaskTag, subformControlName, formName, inputControls, routerPath, routerParams, inDefaultRouterOutlet) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.str = calledTaskTag;
        guiCommand.obj1 = subformControlName;
        guiCommand.userDropFormat = formName;
        guiCommand.fileName = inputControls;
        guiCommand.Bool1 = inDefaultRouterOutlet;
        guiCommand.contextID = routerPath;
        guiCommand.params = routerParams;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addClosesubform(commandType, obj, calledTaskTag, subformControlName, formName) {
        let guiCommand = new GuiCommand(obj, commandType);
        guiCommand.str = calledTaskTag;
        guiCommand.obj1 = subformControlName;
        guiCommand.userDropFormat = formName;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addOpenForm(obj, formName, handlerTaskTag, calledTaskTag, inputControls, isDialog) {
        let guiCommand = new GuiCommand(obj, CommandType.OPEN_FORM);
        guiCommand.TaskTag = handlerTaskTag;
        guiCommand.str = formName;
        guiCommand.stringList = new List();
        guiCommand.stringList.push(calledTaskTag);
        guiCommand.stringList.push(inputControls);
        guiCommand.Bool1 = isDialog;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addCloseForm(obj, handlerTaskTag, calledTaskTag) {
        let guiCommand = new GuiCommand(obj, CommandType.CLOSE_FORM);
        guiCommand.TaskTag = handlerTaskTag;
        guiCommand.str = calledTaskTag;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addCallJS(form, formName, name, args) {
        let guiInteractive = new GuiInteractive();
        return guiInteractive.ExecuteCallJS(form, formName, name, args);
    }
    static addIsLoggedIn(setBool) {
        let guiCommand = new GuiCommand(null, CommandType.SET_IS_LOGGED_IN);
        guiCommand.Bool1 = setBool;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addShowSpinner(show) {
        let guiCommand = new GuiCommand(null, CommandType.SHOW_SPINNER);
        guiCommand.Bool1 = show;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addGlobalCommand(commandType) {
        let guiCommand = new GuiCommand(null, commandType);
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static addShowHTMLError(commandType, error) {
        let guiCommand = new GuiCommand(null, commandType);
        guiCommand.str = error;
        GuiCommandQueue.getInstance().addCommand(guiCommand);
    }
    static beginInvoke() {
        GuiCommandQueue.getInstance().beginInvoke();
    }
    static invoke() {
        GuiCommandQueue.getInstance().invoke();
    }
    constructor() {
    }
}
Commands.resolveCallback = null;

var PropInterface;
(function (PropInterface) {
    PropInterface[PropInterface["PROP_TYPE_LINES_IN_TABLE"] = 3] = "PROP_TYPE_LINES_IN_TABLE";
    PropInterface[PropInterface["PROP_TYPE_HYPERLINK"] = 14] = "PROP_TYPE_HYPERLINK";
    PropInterface[PropInterface["PROP_TYPE_TEXT"] = 19] = "PROP_TYPE_TEXT";
    PropInterface[PropInterface["PROP_TYPE_PLACEMENT"] = 20] = "PROP_TYPE_PLACEMENT";
    PropInterface[PropInterface["PROP_TYPE_LEFT"] = 21] = "PROP_TYPE_LEFT";
    PropInterface[PropInterface["PROP_TYPE_TOP"] = 22] = "PROP_TYPE_TOP";
    PropInterface[PropInterface["PROP_TYPE_WIDTH"] = 23] = "PROP_TYPE_WIDTH";
    PropInterface[PropInterface["PROP_TYPE_LAYER"] = 25] = "PROP_TYPE_LAYER";
    PropInterface[PropInterface["PROP_TYPE_TITLE_BAR"] = 26] = "PROP_TYPE_TITLE_BAR";
    PropInterface[PropInterface["PROP_TYPE_SYSTEM_MENU"] = 27] = "PROP_TYPE_SYSTEM_MENU";
    PropInterface[PropInterface["PROP_TYPE_MINBOX"] = 28] = "PROP_TYPE_MINBOX";
    PropInterface[PropInterface["PROP_TYPE_MAXBOX"] = 29] = "PROP_TYPE_MAXBOX";
    PropInterface[PropInterface["PROP_TYPE_UOM"] = 33] = "PROP_TYPE_UOM";
    PropInterface[PropInterface["PROP_TYPE_VER_FAC"] = 34] = "PROP_TYPE_VER_FAC";
    PropInterface[PropInterface["PROP_TYPE_HOR_FAC"] = 35] = "PROP_TYPE_HOR_FAC";
    PropInterface[PropInterface["PROP_TYPE_WALLPAPER"] = 42] = "PROP_TYPE_WALLPAPER";
    PropInterface[PropInterface["PROP_TYPE_DATA"] = 43] = "PROP_TYPE_DATA";
    PropInterface[PropInterface["PROP_TYPE_LABEL"] = 45] = "PROP_TYPE_LABEL";
    PropInterface[PropInterface["PROP_TYPE_NAME"] = 46] = "PROP_TYPE_NAME";
    PropInterface[PropInterface["PROP_TYPE_FONT"] = 50] = "PROP_TYPE_FONT";
    PropInterface[PropInterface["PROP_TYPE_COLOR"] = 51] = "PROP_TYPE_COLOR";
    PropInterface[PropInterface["PROP_TYPE_MUST_INPUT"] = 52] = "PROP_TYPE_MUST_INPUT";
    PropInterface[PropInterface["PROP_TYPE_MODIFIABLE"] = 53] = "PROP_TYPE_MODIFIABLE";
    PropInterface[PropInterface["PROP_TYPE_HELP_SCR"] = 54] = "PROP_TYPE_HELP_SCR";
    PropInterface[PropInterface["PROP_TYPE_TOOLTIP"] = 56] = "PROP_TYPE_TOOLTIP";
    PropInterface[PropInterface["PROP_TYPE_PROMPT"] = 57] = "PROP_TYPE_PROMPT";
    PropInterface[PropInterface["PROP_TYPE_SELECT_PROGRAM"] = 58] = "PROP_TYPE_SELECT_PROGRAM";
    PropInterface[PropInterface["PROP_TYPE_SELECT_MODE"] = 59] = "PROP_TYPE_SELECT_MODE";
    PropInterface[PropInterface["PROP_TYPE_MODIFY_IN_QUERY"] = 60] = "PROP_TYPE_MODIFY_IN_QUERY";
    PropInterface[PropInterface["PROP_TYPE_VISIBLE"] = 61] = "PROP_TYPE_VISIBLE";
    PropInterface[PropInterface["PROP_TYPE_ENABLED"] = 62] = "PROP_TYPE_ENABLED";
    PropInterface[PropInterface["PROP_TYPE_STYLE_3D"] = 63] = "PROP_TYPE_STYLE_3D";
    PropInterface[PropInterface["PROP_TYPE_BORDER_STYLE"] = 64] = "PROP_TYPE_BORDER_STYLE";
    PropInterface[PropInterface["PROP_TYPE_HORIZONTAL_ALIGNMENT"] = 65] = "PROP_TYPE_HORIZONTAL_ALIGNMENT";
    PropInterface[PropInterface["PROP_TYPE_VERTICAL_ALIGNMENT"] = 66] = "PROP_TYPE_VERTICAL_ALIGNMENT";
    PropInterface[PropInterface["PROP_TYPE_CHOICE_COLUMNS"] = 67] = "PROP_TYPE_CHOICE_COLUMNS";
    PropInterface[PropInterface["PROP_TYPE_VISIBLE_LINES"] = 68] = "PROP_TYPE_VISIBLE_LINES";
    PropInterface[PropInterface["PROP_TYPE_STATIC_TYPE"] = 70] = "PROP_TYPE_STATIC_TYPE";
    PropInterface[PropInterface["PROP_TYPE_MULTILINE"] = 71] = "PROP_TYPE_MULTILINE";
    PropInterface[PropInterface["PROP_TYPE_MULTILINE_VERTICAL_SCROLL"] = 73] = "PROP_TYPE_MULTILINE_VERTICAL_SCROLL";
    PropInterface[PropInterface["PROP_TYPE_MULTILINE_ALLOW_CR"] = 74] = "PROP_TYPE_MULTILINE_ALLOW_CR";
    PropInterface[PropInterface["PROP_TYPE_LINE_STYLE"] = 75] = "PROP_TYPE_LINE_STYLE";
    PropInterface[PropInterface["PROP_TYPE_LINE_WIDTH"] = 76] = "PROP_TYPE_LINE_WIDTH";
    PropInterface[PropInterface["PROP_TYPE_SCROLL_BAR"] = 77] = "PROP_TYPE_SCROLL_BAR";
    PropInterface[PropInterface["PROP_TYPE_LINE_DIVIDER"] = 78] = "PROP_TYPE_LINE_DIVIDER";
    PropInterface[PropInterface["PROP_TYPE_TITLE_HEIGHT"] = 79] = "PROP_TYPE_TITLE_HEIGHT";
    PropInterface[PropInterface["PROP_TYPE_ROW_HEIGHT"] = 80] = "PROP_TYPE_ROW_HEIGHT";
    PropInterface[PropInterface["PROP_TYPE_FORMAT"] = 82] = "PROP_TYPE_FORMAT";
    PropInterface[PropInterface["PROP_TYPE_ATTRIBUTE"] = 83] = "PROP_TYPE_ATTRIBUTE";
    PropInterface[PropInterface["PROP_TYPE_EXPAND_WINDOW"] = 84] = "PROP_TYPE_EXPAND_WINDOW";
    PropInterface[PropInterface["PROP_TYPE_PASSWORD"] = 85] = "PROP_TYPE_PASSWORD";
    PropInterface[PropInterface["PROP_TYPE_TAB_CONTROL_SIDE"] = 87] = "PROP_TYPE_TAB_CONTROL_SIDE";
    PropInterface[PropInterface["PROP_TYPE_IMAGE_FILENAME"] = 88] = "PROP_TYPE_IMAGE_FILENAME";
    PropInterface[PropInterface["PROP_TYPE_IMAGE_STYLE"] = 89] = "PROP_TYPE_IMAGE_STYLE";
    PropInterface[PropInterface["PROP_TYPE_BUTTON_STYLE"] = 96] = "PROP_TYPE_BUTTON_STYLE";
    PropInterface[PropInterface["PROP_TYPE_RETURN_ACTION"] = 97] = "PROP_TYPE_RETURN_ACTION";
    PropInterface[PropInterface["PROP_TYPE_RANGE"] = 98] = "PROP_TYPE_RANGE";
    PropInterface[PropInterface["PROP_TYPE_PARAMETERS"] = 126] = "PROP_TYPE_PARAMETERS";
    PropInterface[PropInterface["PROP_TYPE_FRAME_NAME"] = 127] = "PROP_TYPE_FRAME_NAME";
    PropInterface[PropInterface["PROP_TYPE_HEBREW"] = 130] = "PROP_TYPE_HEBREW";
    PropInterface[PropInterface["PROP_TYPE_TRANSLATOR"] = 132] = "PROP_TYPE_TRANSLATOR";
    PropInterface[PropInterface["PROP_TYPE_SORT_COLUMN"] = 134] = "PROP_TYPE_SORT_COLUMN";
    PropInterface[PropInterface["PROP_TYPE_COLUMN_PLACEMENT"] = 138] = "PROP_TYPE_COLUMN_PLACEMENT";
    PropInterface[PropInterface["PROP_TYPE_COLUMN_TITLE"] = 139] = "PROP_TYPE_COLUMN_TITLE";
    PropInterface[PropInterface["PROP_TYPE_SUBFORM_TYPE"] = 156] = "PROP_TYPE_SUBFORM_TYPE";
    PropInterface[PropInterface["PROP_TYPE_PRGTSK_NUM"] = 183] = "PROP_TYPE_PRGTSK_NUM";
    PropInterface[PropInterface["PROP_TYPE_COLUMN_DIVIDER"] = 189] = "PROP_TYPE_COLUMN_DIVIDER";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_COL_RESIZE"] = 191] = "PROP_TYPE_ALLOW_COL_RESIZE";
    PropInterface[PropInterface["PROP_TYPE_TASK_MODE"] = 197] = "PROP_TYPE_TASK_MODE";
    PropInterface[PropInterface["PROP_TYPE_END_CONDITION"] = 198] = "PROP_TYPE_END_CONDITION";
    PropInterface[PropInterface["PROP_TYPE_EVAL_END_CONDITION"] = 199] = "PROP_TYPE_EVAL_END_CONDITION";
    PropInterface[PropInterface["PROP_TYPE_SELECTION"] = 200] = "PROP_TYPE_SELECTION";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_MODIFY"] = 201] = "PROP_TYPE_ALLOW_MODIFY";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_CREATE"] = 202] = "PROP_TYPE_ALLOW_CREATE";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_DELETE"] = 203] = "PROP_TYPE_ALLOW_DELETE";
    PropInterface[PropInterface["PROP_TYPE_CONFIRM_UPDATE"] = 204] = "PROP_TYPE_CONFIRM_UPDATE";
    PropInterface[PropInterface["PROP_TYPE_CONFIRM_CANCEL"] = 205] = "PROP_TYPE_CONFIRM_CANCEL";
    PropInterface[PropInterface["PROP_TYPE_FORCE_SUFFIX"] = 206] = "PROP_TYPE_FORCE_SUFFIX";
    PropInterface[PropInterface["PROP_TYPE_TRASACTION_BEGIN"] = 207] = "PROP_TYPE_TRASACTION_BEGIN";
    PropInterface[PropInterface["PROP_TYPE_REPEATABLE"] = 208] = "PROP_TYPE_REPEATABLE";
    PropInterface[PropInterface["PROP_TYPE_HIGHLIGHTING"] = 216] = "PROP_TYPE_HIGHLIGHTING";
    PropInterface[PropInterface["PROP_TYPE_SELECTION_ROWS"] = 217] = "PROP_TYPE_SELECTION_ROWS";
    PropInterface[PropInterface["PROP_TYPE_BEFORE_900_VERSION"] = 225] = "PROP_TYPE_BEFORE_900_VERSION";
    PropInterface[PropInterface["PROP_TYPE_FORCE_DELETE"] = 233] = "PROP_TYPE_FORCE_DELETE";
    PropInterface[PropInterface["PROP_TYPE_TRIGGER"] = 234] = "PROP_TYPE_TRIGGER";
    PropInterface[PropInterface["PROP_TYPE_TOP_BORDER"] = 237] = "PROP_TYPE_TOP_BORDER";
    PropInterface[PropInterface["PROP_TYPE_RIGHT_BORDER"] = 238] = "PROP_TYPE_RIGHT_BORDER";
    PropInterface[PropInterface["PROP_TYPE_WINDOW_WIDTH"] = 241] = "PROP_TYPE_WINDOW_WIDTH";
    PropInterface[PropInterface["PROP_TYPE_NODE_ID"] = 247] = "PROP_TYPE_NODE_ID";
    PropInterface[PropInterface["PROP_TYPE_NODE_PARENTID"] = 248] = "PROP_TYPE_NODE_PARENTID";
    PropInterface[PropInterface["PROP_TYPE_SHOW_BUTTONS"] = 249] = "PROP_TYPE_SHOW_BUTTONS";
    PropInterface[PropInterface["PROP_TYPE_SHOW_LINES"] = 250] = "PROP_TYPE_SHOW_LINES";
    PropInterface[PropInterface["PROP_TYPE_SHOW_FULL_ROW"] = 252] = "PROP_TYPE_SHOW_FULL_ROW";
    PropInterface[PropInterface["PROP_TYPE_TRACK_SELECTION"] = 253] = "PROP_TYPE_TRACK_SELECTION";
    PropInterface[PropInterface["PROP_TYPE_EXPANDED_IMAGEIDX"] = 256] = "PROP_TYPE_EXPANDED_IMAGEIDX";
    PropInterface[PropInterface["PROP_TYPE_COLLAPSED_IMAGEIDX"] = 257] = "PROP_TYPE_COLLAPSED_IMAGEIDX";
    PropInterface[PropInterface["PROP_TYPE_PARKED_IMAGEIDX"] = 258] = "PROP_TYPE_PARKED_IMAGEIDX";
    PropInterface[PropInterface["PROP_TYPE_LINES_AT_ROOT"] = 267] = "PROP_TYPE_LINES_AT_ROOT";
    PropInterface[PropInterface["PROP_TYPE_TAB_IN"] = 269] = "PROP_TYPE_TAB_IN";
    PropInterface[PropInterface["PROP_TYPE_STARTUP_POSITION"] = 275] = "PROP_TYPE_STARTUP_POSITION";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_DRAGGING"] = 283] = "PROP_TYPE_ALLOW_DRAGGING";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_DROPPING"] = 284] = "PROP_TYPE_ALLOW_DROPPING";
    PropInterface[PropInterface["PROP_TYPE_IS_CACHED"] = 286] = "PROP_TYPE_IS_CACHED";
    PropInterface[PropInterface["PROP_TYPE_SELECTION_MODE"] = 288] = "PROP_TYPE_SELECTION_MODE";
    PropInterface[PropInterface["PROP_TYPE_PARKED_COLLAPSED_IMAGEIDX"] = 290] = "PROP_TYPE_PARKED_COLLAPSED_IMAGEIDX";
    PropInterface[PropInterface["PROP_TYPE_DISPLAY_LIST"] = 303] = "PROP_TYPE_DISPLAY_LIST";
    PropInterface[PropInterface["PROP_TYPE_FORM_NAME"] = 311] = "PROP_TYPE_FORM_NAME";
    PropInterface[PropInterface["PROP_TYPE_AUTO_REFRESH"] = 312] = "PROP_TYPE_AUTO_REFRESH";
    PropInterface[PropInterface["PROP_TYPE_AUTO_FIT"] = 313] = "PROP_TYPE_AUTO_FIT";
    PropInterface[PropInterface["PROP_TYPE_TAB_ORDER"] = 314] = "PROP_TYPE_TAB_ORDER";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_PARKING"] = 315] = "PROP_TYPE_ALLOW_PARKING";
    PropInterface[PropInterface["PROP_TYPE_ALLOWED_DIRECTION"] = 317] = "PROP_TYPE_ALLOWED_DIRECTION";
    PropInterface[PropInterface["PROP_TYPE_TABBING_ORDER"] = 318] = "PROP_TYPE_TABBING_ORDER";
    PropInterface[PropInterface["PROP_TYPE_HOT_TRACK"] = 354] = "PROP_TYPE_HOT_TRACK";
    PropInterface[PropInterface["PROP_TYPE_TAB_CONTROL_TABS_WIDTH"] = 355] = "PROP_TYPE_TAB_CONTROL_TABS_WIDTH";
    PropInterface[PropInterface["PROP_TYPE_IMAGE_LIST_INDEXES"] = 356] = "PROP_TYPE_IMAGE_LIST_INDEXES";
    PropInterface[PropInterface["PROP_TYPE_WINDOW_TYPE"] = 358] = "PROP_TYPE_WINDOW_TYPE";
    PropInterface[PropInterface["PROP_TYPE_DISPLAY_TOOLBAR"] = 360] = "PROP_TYPE_DISPLAY_TOOLBAR";
    PropInterface[PropInterface["PROP_TYPE_DISPLAY_STATUS_BAR"] = 361] = "PROP_TYPE_DISPLAY_STATUS_BAR";
    PropInterface[PropInterface["PROP_TYPE_STARTUP_MODE"] = 362] = "PROP_TYPE_STARTUP_MODE";
    PropInterface[PropInterface["PROP_TYPE_THREE_STATES"] = 390] = "PROP_TYPE_THREE_STATES";
    PropInterface[PropInterface["PROP_TYPE_CHECKBOX_MAIN_STYLE"] = 391] = "PROP_TYPE_CHECKBOX_MAIN_STYLE";
    PropInterface[PropInterface["PROP_TYPE_RAISE_AT"] = 395] = "PROP_TYPE_RAISE_AT";
    PropInterface[PropInterface["PROP_TYPE_DISPLAY_MENU"] = 396] = "PROP_TYPE_DISPLAY_MENU";
    PropInterface[PropInterface["PROP_TYPE_RADIO_BUTTON_APPEARANCE"] = 401] = "PROP_TYPE_RADIO_BUTTON_APPEARANCE";
    PropInterface[PropInterface["PROP_TYPE_DEFAULT_BUTTON"] = 408] = "PROP_TYPE_DEFAULT_BUTTON";
    PropInterface[PropInterface["PROP_TYPE_ROW_HIGHLIGHT_STYLE"] = 409] = "PROP_TYPE_ROW_HIGHLIGHT_STYLE";
    PropInterface[PropInterface["PROP_TYPE_BOTTOM_POSITION_INTERVAL"] = 411] = "PROP_TYPE_BOTTOM_POSITION_INTERVAL";
    PropInterface[PropInterface["PROP_TYPE_MINIMUM_WIDTH"] = 418] = "PROP_TYPE_MINIMUM_WIDTH";
    PropInterface[PropInterface["PROP_TYPE_MINIMUM_HEIGHT"] = 419] = "PROP_TYPE_MINIMUM_HEIGHT";
    PropInterface[PropInterface["PROP_TYPE_SHOW_IN_WINDOW_MENU"] = 422] = "PROP_TYPE_SHOW_IN_WINDOW_MENU";
    PropInterface[PropInterface["PROP_TYPE_SET_COLOR_BY"] = 428] = "PROP_TYPE_SET_COLOR_BY";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_REORDER"] = 430] = "PROP_TYPE_ALLOW_REORDER";
    PropInterface[PropInterface["PROP_TYPE_PARK_ON_CLICK"] = 433] = "PROP_TYPE_PARK_ON_CLICK";
    PropInterface[PropInterface["PROP_TYPE_TASK_ID"] = 440] = "PROP_TYPE_TASK_ID";
    PropInterface[PropInterface["PROP_TYPE_PULLDOWN_MENU"] = 441] = "PROP_TYPE_PULLDOWN_MENU";
    PropInterface[PropInterface["PROP_TYPE_CONTEXT_MENU"] = 442] = "PROP_TYPE_CONTEXT_MENU";
    PropInterface[PropInterface["PROP_TYPE_DISPLAY_FIELD"] = 443] = "PROP_TYPE_DISPLAY_FIELD";
    PropInterface[PropInterface["PROP_TYPE_LINK_FIELD"] = 444] = "PROP_TYPE_LINK_FIELD";
    PropInterface[PropInterface["PROP_TYPE_INDEX"] = 445] = "PROP_TYPE_INDEX";
    PropInterface[PropInterface["PROP_TYPE_PRELOAD_VIEW"] = 446] = "PROP_TYPE_PRELOAD_VIEW";
    PropInterface[PropInterface["PROP_TYPE_WALLPAPER_STYLE"] = 448] = "PROP_TYPE_WALLPAPER_STYLE";
    PropInterface[PropInterface["PROP_TYPE_PART_OF_DATAVIEW"] = 449] = "PROP_TYPE_PART_OF_DATAVIEW";
    PropInterface[PropInterface["PROP_TYPE_BORDER"] = 452] = "PROP_TYPE_BORDER";
    PropInterface[PropInterface["PROP_TYPE_MULTILINE_WORDWRAP_SCROLL"] = 455] = "PROP_TYPE_MULTILINE_WORDWRAP_SCROLL";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_QUERY"] = 456] = "PROP_TYPE_ALLOW_QUERY";
    PropInterface[PropInterface["PROP_TYPE_MAIN_DISPLAY"] = 457] = "PROP_TYPE_MAIN_DISPLAY";
    PropInterface[PropInterface["PROP_TYPE_DEST_SUBFORM"] = 458] = "PROP_TYPE_DEST_SUBFORM";
    PropInterface[PropInterface["PROP_TYPE_HORIZONTAL_PLACEMENT"] = 459] = "PROP_TYPE_HORIZONTAL_PLACEMENT";
    PropInterface[PropInterface["PROP_TYPE_VERTICAL_PLACEMENT"] = 460] = "PROP_TYPE_VERTICAL_PLACEMENT";
    PropInterface[PropInterface["PROP_TYPE_FRAMESET_STYLE"] = 461] = "PROP_TYPE_FRAMESET_STYLE";
    PropInterface[PropInterface["PROP_TYPE_FRAME_TYPE"] = 462] = "PROP_TYPE_FRAME_TYPE";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_EMPTY_DATAVIEW"] = 463] = "PROP_TYPE_ALLOW_EMPTY_DATAVIEW";
    PropInterface[PropInterface["PROP_TYPE_SHOW_TITLE"] = 464] = "PROP_TYPE_SHOW_TITLE";
    PropInterface[PropInterface["PROP_TYPE_TABBING_CYCLE"] = 465] = "PROP_TYPE_TABBING_CYCLE";
    PropInterface[PropInterface["PROP_TYPE_REFRESH_WHEN_HIDDEN"] = 472] = "PROP_TYPE_REFRESH_WHEN_HIDDEN";
    PropInterface[PropInterface["PROP_TYPE_HOVERING_COLOR"] = 473] = "PROP_TYPE_HOVERING_COLOR";
    PropInterface[PropInterface["PROP_TYPE_VISITED_COLOR"] = 474] = "PROP_TYPE_VISITED_COLOR";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_OPTION"] = 475] = "PROP_TYPE_ALLOW_OPTION";
    PropInterface[PropInterface["PROP_TYPE_VISIBLE_LAYERS_LIST"] = 476] = "PROP_TYPE_VISIBLE_LAYERS_LIST";
    PropInterface[PropInterface["PROP_TYPE_INTERACTIVE"] = 477] = "PROP_TYPE_INTERACTIVE";
    PropInterface[PropInterface["PROP_TYPE_OBJECT_TYPE"] = 478] = "PROP_TYPE_OBJECT_TYPE";
    PropInterface[PropInterface["PROP_TYPE_OBJECT_PROPERTIES"] = 479] = "PROP_TYPE_OBJECT_PROPERTIES";
    PropInterface[PropInterface["PROP_TYPE_GRADIENT_COLOR"] = 480] = "PROP_TYPE_GRADIENT_COLOR";
    PropInterface[PropInterface["PROP_TYPE_GRADIENT_STYLE"] = 481] = "PROP_TYPE_GRADIENT_STYLE";
    PropInterface[PropInterface["PROP_TYPE_RETAIN_FOCUS"] = 482] = "PROP_TYPE_RETAIN_FOCUS";
    PropInterface[PropInterface["PROP_TYPE_REAL_OBJECT_TYPE"] = 483] = "PROP_TYPE_REAL_OBJECT_TYPE";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_LOCATE_IN_QUERY"] = 486] = "PROP_TYPE_ALLOW_LOCATE_IN_QUERY";
    PropInterface[PropInterface["PROP_TYPE_LOAD_IMAGE_FROM"] = 487] = "PROP_TYPE_LOAD_IMAGE_FROM";
    PropInterface[PropInterface["PROP_TYPE_PRINT_DATA"] = 488] = "PROP_TYPE_PRINT_DATA";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_RANGE"] = 489] = "PROP_TYPE_ALLOW_RANGE";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_LOCATE"] = 490] = "PROP_TYPE_ALLOW_LOCATE";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_SORT"] = 491] = "PROP_TYPE_ALLOW_SORT";
    PropInterface[PropInterface["PROP_TYPE_DEST_SUBFORM_NAME"] = 492] = "PROP_TYPE_DEST_SUBFORM_NAME";
    PropInterface[PropInterface["PROP_TYPE_PERSISTENT_FORMSTATE"] = 493] = "PROP_TYPE_PERSISTENT_FORMSTATE";
    PropInterface[PropInterface["PROP_TYPE_CLOSE_TASKS_BY_MDI_MENU"] = 496] = "PROP_TYPE_CLOSE_TASKS_BY_MDI_MENU";
    PropInterface[PropInterface["PROP_TYPE_ROW_PLACEMENT"] = 572] = "PROP_TYPE_ROW_PLACEMENT";
    PropInterface[PropInterface["PROP_TYPE_ADDITIONAL_INFORMATION"] = 573] = "PROP_TYPE_ADDITIONAL_INFORMATION";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_ALLOW_EVENTS"] = 592] = "PROP_TYPE_TASK_PROPERTIES_ALLOW_EVENTS";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_RETURN_VALUE"] = 596] = "PROP_TYPE_TASK_PROPERTIES_RETURN_VALUE";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_TRANSACTION_MODE"] = 604] = "PROP_TYPE_TASK_PROPERTIES_TRANSACTION_MODE";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_OPEN_TASK_WINDOW"] = 619] = "PROP_TYPE_TASK_PROPERTIES_OPEN_TASK_WINDOW";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_MAIN_DISPLAY"] = 621] = "PROP_TYPE_TASK_PROPERTIES_MAIN_DISPLAY";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_ALLOW_INDEX"] = 630] = "PROP_TYPE_TASK_PROPERTIES_ALLOW_INDEX";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_LOCATE"] = 634] = "PROP_TYPE_TASK_PROPERTIES_LOCATE";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_LOCATE_ORDER"] = 635] = "PROP_TYPE_TASK_PROPERTIES_LOCATE_ORDER";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_POSITION"] = 636] = "PROP_TYPE_TASK_PROPERTIES_POSITION";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_POSITION_USAGE"] = 637] = "PROP_TYPE_TASK_PROPERTIES_POSITION_USAGE";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_RANGE"] = 638] = "PROP_TYPE_TASK_PROPERTIES_RANGE";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_RANGE_ORDER"] = 639] = "PROP_TYPE_TASK_PROPERTIES_RANGE_ORDER";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_SQL_RANGE"] = 640] = "PROP_TYPE_TASK_PROPERTIES_SQL_RANGE";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_DB_SQL_RANGE"] = 641] = "PROP_TYPE_TASK_PROPERTIES_DB_SQL_RANGE";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_CHUNK_SIZE"] = 645] = "PROP_TYPE_TASK_PROPERTIES_CHUNK_SIZE";
    PropInterface[PropInterface["PROP_TYPE_TASK_PROPERTIES_INDEX_OPTIMIZATION"] = 653] = "PROP_TYPE_TASK_PROPERTIES_INDEX_OPTIMIZATION";
    PropInterface[PropInterface["PROP_TYPE_DATAVIEWCONTROL"] = 656] = "PROP_TYPE_DATAVIEWCONTROL";
    PropInterface[PropInterface["PROP_TYPE_DATAVIEWCONTROL_FIELDS"] = 657] = "PROP_TYPE_DATAVIEWCONTROL_FIELDS";
    PropInterface[PropInterface["PROP_TYPE_POP_UP"] = 658] = "PROP_TYPE_POP_UP";
    PropInterface[PropInterface["PROP_TYPE_ORIENTATION_LOCK"] = 659] = "PROP_TYPE_ORIENTATION_LOCK";
    PropInterface[PropInterface["PROP_TYPE_ENTER_ANIMATION"] = 660] = "PROP_TYPE_ENTER_ANIMATION";
    PropInterface[PropInterface["PROP_TYPE_EXIT_ANIMATION"] = 661] = "PROP_TYPE_EXIT_ANIMATION";
    PropInterface[PropInterface["PROP_TYPE_NAVIGATION_DRAWER_MENU"] = 662] = "PROP_TYPE_NAVIGATION_DRAWER_MENU";
    PropInterface[PropInterface["PROP_TYPE_TITLE_BAR_COLOR"] = 663] = "PROP_TYPE_TITLE_BAR_COLOR";
    PropInterface[PropInterface["PROP_TYPE_MOBILE_BORDER_WIDTH"] = 664] = "PROP_TYPE_MOBILE_BORDER_WIDTH";
    PropInterface[PropInterface["PROP_TYPE_BORDER_COLOR"] = 665] = "PROP_TYPE_BORDER_COLOR";
    PropInterface[PropInterface["PROP_TYPE_BORDER_FOCUS_WIDTH"] = 666] = "PROP_TYPE_BORDER_FOCUS_WIDTH";
    PropInterface[PropInterface["PROP_TYPE_BORDER_FOCUS_COLOR"] = 667] = "PROP_TYPE_BORDER_FOCUS_COLOR";
    PropInterface[PropInterface["PROP_TYPE_CORNER_RADIUS"] = 668] = "PROP_TYPE_CORNER_RADIUS";
    PropInterface[PropInterface["PROP_TYPE_OPEN_PICKER"] = 669] = "PROP_TYPE_OPEN_PICKER";
    PropInterface[PropInterface["PROP_TYPE_OPEN_EDIT_DIALOG"] = 670] = "PROP_TYPE_OPEN_EDIT_DIALOG";
    PropInterface[PropInterface["PROP_TYPE_DEFAULT_ALIGNMENT"] = 671] = "PROP_TYPE_DEFAULT_ALIGNMENT";
    PropInterface[PropInterface["PROP_TYPE_HINT"] = 672] = "PROP_TYPE_HINT";
    PropInterface[PropInterface["PROP_TYPE_KEYBOARD_TYPE"] = 673] = "PROP_TYPE_KEYBOARD_TYPE";
    PropInterface[PropInterface["PROP_TYPE_KEYBOARD_RETURN_KEY"] = 674] = "PROP_TYPE_KEYBOARD_RETURN_KEY";
    PropInterface[PropInterface["PROP_TYPE_ALLOW_SUGGESTIONS"] = 675] = "PROP_TYPE_ALLOW_SUGGESTIONS";
    PropInterface[PropInterface["PROP_TYPE_MOBILE_IMAGE_LIST_FILE_NAME"] = 676] = "PROP_TYPE_MOBILE_IMAGE_LIST_FILE_NAME";
    PropInterface[PropInterface["PROP_TYPE_TITLE_COLOR"] = 677] = "PROP_TYPE_TITLE_COLOR";
    PropInterface[PropInterface["PROP_TYPE_FOCUS_COLOR"] = 678] = "PROP_TYPE_FOCUS_COLOR";
    PropInterface[PropInterface["PROP_TYPE_SWIPE_REFRESH"] = 679] = "PROP_TYPE_SWIPE_REFRESH";
    PropInterface[PropInterface["PROP_TYPE_ACTION_BAR_MENU"] = 683] = "PROP_TYPE_ACTION_BAR_MENU";
    PropInterface[PropInterface["PROP_TYPE_TOP_BORDER_MARGIN"] = 684] = "PROP_TYPE_TOP_BORDER_MARGIN";
    PropInterface[PropInterface["PROP_TYPE_DIVIDER_COLOR"] = 685] = "PROP_TYPE_DIVIDER_COLOR";
    PropInterface[PropInterface["PROP_TYPE_HOT_TRACK_COLOR"] = 686] = "PROP_TYPE_HOT_TRACK_COLOR";
    PropInterface[PropInterface["PROP_TYPE_COL_ALLOW_FILTERING"] = 687] = "PROP_TYPE_COL_ALLOW_FILTERING";
    PropInterface[PropInterface["PROP_TYPE_FILL_WIDTH"] = 688] = "PROP_TYPE_FILL_WIDTH";
    PropInterface[PropInterface["PROP_TYPE_TITLE_PADDING"] = 689] = "PROP_TYPE_TITLE_PADDING";
    PropInterface[PropInterface["PROP_TYPE_HINT_COLOR"] = 691] = "PROP_TYPE_HINT_COLOR";
    PropInterface[PropInterface["PROP_TYPE_MULTI_COLUMN_DISPLAY"] = 692] = "PROP_TYPE_MULTI_COLUMN_DISPLAY";
    PropInterface[PropInterface["PROP_TYPE_SELECTED_TAB_COLOR"] = 694] = "PROP_TYPE_SELECTED_TAB_COLOR";
    PropInterface[PropInterface["PROP_TYPE_PERSISTENT_FORM_STATE_VERSION"] = 696] = "PROP_TYPE_PERSISTENT_FORM_STATE_VERSION";
    PropInterface[PropInterface["PROP_TYPE_INACTIVE_ROW_HIGHLIGHT_COLOR"] = 697] = "PROP_TYPE_INACTIVE_ROW_HIGHLIGHT_COLOR";
    PropInterface[PropInterface["PROP_TYPE_ROW_BG_COLOR"] = 698] = "PROP_TYPE_ROW_BG_COLOR";
    PropInterface[PropInterface["PROP_TYPE_SHOW_ELLIPISIS"] = 699] = "PROP_TYPE_SHOW_ELLIPISIS";
    PropInterface[PropInterface["PROP_TYPE_SCROLL_BAR_THUMB"] = 700] = "PROP_TYPE_SCROLL_BAR_THUMB";
    PropInterface[PropInterface["PROP_TYPE_IS_ROUTER_OUTLET"] = 707] = "PROP_TYPE_IS_ROUTER_OUTLET";
    PropInterface[PropInterface["PROP_TYPE_DEFAULT_OUTLET"] = 712] = "PROP_TYPE_DEFAULT_OUTLET";
    PropInterface[PropInterface["PROP_TYPE_CUSTOM_PROPERTIES"] = 713] = "PROP_TYPE_CUSTOM_PROPERTIES";
    PropInterface[PropInterface["PROP_TYPE_CONNECTED_ZOOM_CONTROL"] = 719] = "PROP_TYPE_CONNECTED_ZOOM_CONTROL";
    PropInterface[PropInterface["PROP_TYPE_CUSTOM_VALIDATORS"] = 732] = "PROP_TYPE_CUSTOM_VALIDATORS";
    PropInterface[PropInterface["PROP_TYPE_BINDING_LEVEL"] = 733] = "PROP_TYPE_BINDING_LEVEL";
    PropInterface[PropInterface["PROP_TYPE_SERVER_READ_AHEAD"] = 736] = "PROP_TYPE_SERVER_READ_AHEAD";
    PropInterface[PropInterface["PROP_TYPE_AUTO_COMPLETE_MODE_WC"] = 740] = "PROP_TYPE_AUTO_COMPLETE_MODE_WC";
})(PropInterface || (PropInterface = {}));

class GuiEnvironment {
}
GuiEnvironment.Environment = null;

class Manager {
    static SetCurrentContextID(contextID) {
        Manager._currentContextID = contextID;
    }
    static GetCurrentContextID() {
        return Manager._currentContextID;
    }
    static Init() {
        return;
    }
    static Abort(form) {
        if (form.getSubFormCtrl() === null && form.Opened) {
            if (form.isDialog()) {
                this.IsOverlayOpen = false;
                let topMostFrameForm = form.getTopMostFrameForm();
                if (topMostFrameForm !== null)
                    topMostFrameForm.UpdateModalFormsCount(form, false);
            }
            Commands.addCloseForm(form, "0", form.getTask().getTaskTag());
            Commands.beginInvoke();
        }
    }
    static GetCtrlVal(ctrl) {
        return Commands.getValue(ctrl, ctrl.getDisplayLine(true));
    }
    static async SetReadOnlyControl(ctrl, isReadOnly) {
        if (ctrl.isTextControl() || ctrl.IsRepeatable || ctrl.isComboBox() || ctrl.isListBox() || ctrl.isCheckBox() || ctrl.isRadio()) {
            if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                if (await ctrl.getForm().getTask().checkProp(PropInterface.PROP_TYPE_ALLOW_LOCATE_IN_QUERY, false))
                    return;
            }
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, ctrl, ctrl.getDisplayLine(false), HtmlProperties.ReadOnly, isReadOnly);
            Commands.beginInvoke();
        }
    }
    static OpenForm(mgForm) {
        if (!mgForm.Opened && (mgForm.getTask().IsInteractive || mgForm.getTask().isOpenWin())) {
            if (!mgForm.isSubForm()) {
                if (mgForm.isDialog()) {
                    this.IsOverlayOpen = true;
                    let topMostFrameForm = mgForm.getTopMostFrameForm();
                    if (topMostFrameForm !== null)
                        topMostFrameForm.UpdateModalFormsCount(mgForm, true);
                }
            }
            mgForm.Opened = true;
            Commands.beginInvoke();
        }
    }
    static async DoFirstRefreshTable(mgForm) {
        if (mgForm !== null && !mgForm.ignoreFirstRefreshTable) {
            mgForm.ignoreFirstRefreshTable = true;
            await mgForm.firstTableRefresh();
        }
    }
    static CleanMessagePane(task) {
        task.WriteToMessagePane(Manager.GetCurrentRuntimeContext().DefaultStatusMsg);
    }
    static GetMessage(msg) {
        if (msg === null)
            msg = "";
        else if (msg.length > 0) {
            let idxOfCarriage = msg.indexOf("\r");
            if (idxOfCarriage !== -1)
                msg = msg.substr(0, idxOfCarriage);
            let idxOfNewLine = msg.indexOf("\n");
            if (idxOfNewLine !== -1)
                msg = msg.substr(0, idxOfNewLine);
        }
        return msg;
    }
    static GetCurrentRuntimeContext() {
        return Events.GetRuntimeContext(Manager.GetCurrentContextID());
    }
    static GetSpecialValNewPolicy() {
        return GuiEnvironment.Environment.GetSpecialValNewPolicy();
    }
}
Manager.IsOverlayOpen = false;
Manager._currentContextID = '\0';
Manager.DefaultProtocol = null;
Manager.DefaultServerName = null;
Manager.UtilImeJpn = (UtilStrByteMode.isLocaleDefLangJPN() ? new UtilImeJpn() : null);
Manager.EventsManager = null;

class BlobType {
    static getContentType(blob) {
        try {
            let tokens = StrUtil.tokenize(blob, /,|;/);
            return tokens[4].charAt(0);
        }
        catch (Exception) {
            throw new ApplicationException(" in BlobType.getContentType blob is in invalid format");
        }
    }
    static getEmptyBlobPrefix(vecCellAttr) {
        return NString.Format("0,0,{0},{1},0", '\0', vecCellAttr);
    }
    static getBlobPrefixForContentType(contentType) {
        return NString.Format("0,0,{0},{0},{1};", '\0', contentType);
    }
    static getPrefix(str) {
        let idx = str.indexOf(';');
        return str.substr(0, idx + 1);
    }
    static getEncodingFromContentType(ContentType) {
        let encoding;
        if (ContentType === BlobType.CONTENT_TYPE_UNICODE)
            encoding = Encoding.Unicode;
        else if (ContentType === BlobType.CONTENT_TYPE_ANSI)
            encoding = GuiEnvironment.Environment.GetEncoding();
        else
            encoding = ISO_8859_1_Encoding.ISO_8859_1;
        return encoding;
    }
    static MbToUnicode(BytesInMb) {
        let result = null;
        try {
            let UnicodeString = GuiEnvironment.Environment.GetEncoding().GetString(BytesInMb, 0, BytesInMb.length);
            result = Encoding.Unicode.GetBytes(UnicodeString);
        }
        catch (Exception) {
            result = null;
        }
        return result;
    }
    static UnicodeToMb(BytesInUnicode) {
        let result = null;
        try {
            let UnicodeString = Encoding.Unicode.GetString(BytesInUnicode, 0, BytesInUnicode.length);
            result = GuiEnvironment.Environment.GetEncoding().GetBytes(UnicodeString);
        }
        catch (Exception) {
            result = null;
        }
        return result;
    }
    static getString(blob) {
        let result = null;
        let bytes = null;
        if (BlobType.isValidBlob(blob)) {
            let contentType = BlobType.getContentType(blob);
            if (contentType !== BlobType.CONTENT_TYPE_UNICODE)
                contentType = BlobType.CONTENT_TYPE_ANSI;
            try {
                bytes = BlobType.getBytes(blob);
                let encoding = BlobType.getEncodingFromContentType(contentType);
                result = encoding.GetString(bytes, 0, bytes.length);
                let index = result.indexOf('\0');
                if (index !== -1)
                    result = result.substr(0, index);
            }
            catch (Exception) {
                result = null;
            }
        }
        else
            Debug.Assert(false);
        return result;
    }
    static createFromString(blobStr, contentType) {
        let blob = null;
        let srcContentType = contentType;
        let bytes = null;
        if (contentType !== BlobType.CONTENT_TYPE_UNICODE)
            srcContentType = BlobType.CONTENT_TYPE_ANSI;
        try {
            if (blobStr.constructor === ArrayBuffer) {
                bytes = new Uint8Array(blobStr);
            }
            else {
                let encoding = BlobType.getEncodingFromContentType(srcContentType);
                bytes = encoding.GetBytes(blobStr);
            }
            blob = BlobType.createFromBytes(bytes, contentType);
        }
        catch (Exception) {
            blob = null;
        }
        return blob;
    }
    static getBytes(str) {
        let bytes = null;
        let data = BlobType.removeBlobPrefix(str);
        try {
            let encoding = ISO_8859_1_Encoding.ISO_8859_1;
            bytes = encoding.GetBytes(data);
        }
        catch (Exception) {
            bytes = null;
        }
        return bytes;
    }
    static createFromBytes(bytes, contentType) {
        let blobStr = '';
        let blobPrefix;
        let blobData;
        blobPrefix = BlobType.getBlobPrefixForContentType(contentType);
        try {
            let encoding = ISO_8859_1_Encoding.ISO_8859_1;
            blobData = encoding.GetString(bytes, 0, bytes.length);
        }
        catch (Exception) {
            blobData = null;
        }
        blobStr = blobPrefix + blobData;
        return blobStr;
    }
    static copyBlob(dest, src) {
        let srcBytes;
        let destBytes;
        if (src === null)
            return null;
        else if (dest === null)
            return src;
        srcBytes = BlobType.getBytes(src);
        let destContentType = BlobType.getContentType(dest);
        let srcContentType = BlobType.getContentType(src);
        if (srcContentType === BlobType.CONTENT_TYPE_ANSI && destContentType === BlobType.CONTENT_TYPE_UNICODE)
            destBytes = BlobType.MbToUnicode(srcBytes);
        else if (srcContentType === BlobType.CONTENT_TYPE_UNICODE && destContentType === BlobType.CONTENT_TYPE_ANSI)
            destBytes = BlobType.UnicodeToMb(srcBytes);
        else
            destBytes = srcBytes;
        dest = BlobType.createFromBytes(destBytes, destContentType);
        return dest;
    }
    static removeBlobPrefix(source) {
        let idx;
        if (source !== null) {
            idx = source.indexOf(';');
            if (idx < 0)
                Logger.Instance.WriteToLog("Error: invalid blob prefix", true);
            return source.substr(idx + 1);
        }
        else
            return null;
    }
    static isValidBlob(blob) {
        let isValid = true;
        if (blob === null || blob.indexOf(';') < 0)
            isValid = false;
        if (isValid) {
            let contentType = BlobType.getContentType(blob);
            if (contentType !== BlobType.CONTENT_TYPE_ANSI && contentType !== BlobType.CONTENT_TYPE_BINARY && contentType !== BlobType.CONTENT_TYPE_UNICODE && contentType !== BlobType.CONTENT_TYPE_UNKNOWN)
                isValid = false;
        }
        return isValid;
    }
    static setContentType(str, contentType) {
        let result = "";
        try {
            let prefixLastIndex = str.indexOf(";");
            let prefix = str.substr(0, prefixLastIndex);
            let dataLength = str.length - (prefix.length + 1);
            let data = str.substr(prefixLastIndex + 1, dataLength);
            let prefixTokens = StrUtil.tokenize(prefix, /,|;/);
            for (let i = 0; i < GuiConstants.BLOB_PREFIX_ELEMENTS_COUNT; i = i + 1) {
                if (i === 4)
                    result = result + contentType + ",";
                else
                    result = result + prefixTokens[i] + ",";
            }
            return result.substr(0, result.length - 1) + ";" + data;
        }
        catch (Exception) {
            throw new ApplicationException(" in BlobType.setContentType : invalid format");
        }
    }
    static SetVecCellAttr(str, vecCellAttr) {
        let result = "";
        try {
            let prefixLastIndex = str.indexOf(";");
            let prefix = str.substr(0, prefixLastIndex);
            let data = str.substr(prefixLastIndex + 1);
            let tokens = StrUtil.tokenize(prefix, /,|;/);
            for (let i = 0; i < GuiConstants.BLOB_PREFIX_ELEMENTS_COUNT; i = i + 1) {
                if (i === 3)
                    result = result + vecCellAttr + ",";
                else
                    result = result + tokens[i] + ",";
            }
            return result.substr(0, result.length - 1) + ";" + data;
        }
        catch (Exception) {
            throw new ApplicationException(" in XMLparser.blobPrefixLength invalid format");
        }
    }
    static GetVecCellAttr(blobStr) {
        try {
            let tokens = StrUtil.tokenize(blobStr, /,|;/);
            return tokens[3].charAt(0);
        }
        catch (Exception) {
            throw new ApplicationException(" in BlobType.GetVecCellAttr(): blob is in invalid format");
        }
    }
    static blobPrefixLength(blob) {
        try {
            let prefixLength = blob.indexOf(';') + 1;
            let prefix = blob.substr(0, prefixLength);
            if (prefixLength > 0) {
                let tokens = StrUtil.tokenize(prefix, ",");
                if (tokens.length === GuiConstants.BLOB_PREFIX_ELEMENTS_COUNT)
                    return prefixLength;
            }
        }
        catch (Exception) {
        }
        throw new ApplicationException(" in XMLparser.blobPrefixLength invalid format");
    }
    static getKey(blobStr) {
        let tokens = StrUtil.tokenize(blobStr, /,|;/);
        let key = 0;
        if (tokens.length > 5) {
            try {
                key = NNumber.Parse(tokens[0]);
            }
            catch (Exception) {
            }
        }
        return key;
    }
    static getBlobSize(blob) {
        let size = 0;
        try {
            let tokens = StrUtil.tokenize(blob, /,|;/);
            if (tokens.length > 5) {
                size = blob.length;
                for (let i = 0; i < 5; i = i + 1) {
                    size = size - tokens[i].length;
                    size = size - 1;
                }
            }
        }
        catch (Exception) {
        }
        return size;
    }
    static ParseContentType(contentType) {
        let newContentType = ' ';
        switch (contentType) {
            case 0:
                newContentType = BlobType.CONTENT_TYPE_UNKNOWN;
                break;
            case 1:
                newContentType = BlobType.CONTENT_TYPE_ANSI;
                break;
            case 2:
                newContentType = BlobType.CONTENT_TYPE_UNICODE;
                break;
            case 3:
                newContentType = BlobType.CONTENT_TYPE_BINARY;
        }
        return newContentType;
    }
}
BlobType.CONTENT_TYPE_UNKNOWN = '0';
BlobType.CONTENT_TYPE_ANSI = '1';
BlobType.CONTENT_TYPE_UNICODE = '2';
BlobType.CONTENT_TYPE_BINARY = '3';

class PIC {
    constructor(picStr, attr, compIdx) {
        this._mskLen = 0;
        this._negPref = new StringBuilder();
        this._negSuff = new StringBuilder();
        this._picAttr = StorageAttribute.NONE;
        this._posPref = new StringBuilder();
        this._posSuff = new StringBuilder();
        this._autoSkip_ = false;
        this._padFill = false;
        this._zeroFill = false;
        this._comma = false;
        this._decimalDigits = 0;
        this._decPointIsFirst = false;
        this._decimal = false;
        this._embeded = false;
        this._formatIdx = 0;
        this._format = null;
        this.hebrew = false;
        this._imeMode = -1;
        this._left = false;
        this._maskLength = 0;
        this._maskChars = 0;
        this._maskSize = 0;
        this._mixed = false;
        this._formatExp = false;
        this._msk = null;
        this._needLength = false;
        this._negative = false;
        this._pad = '\0';
        this._prefLen = 0;
        this._size = 0;
        this._suffLen = 0;
        this._termFlag = false;
        this._trim = false;
        this._whole = 0;
        this._zero = '\0';
        this._picAttr = attr;
        if (this._picAttr === StorageAttribute.BLOB ||
            this._picAttr === StorageAttribute.BLOB_VECTOR) {
            if (picStr.trim().length > 0) {
                Events.WriteDevToLog("PIC.PIC the picture of BLOB must be empty string");
            }
            return;
        }
        this._format = NString.ToCharArray(picStr);
        this._formatIdx = 0;
        this._mskLen = this.getMaskLen(compIdx);
        this.prs_all(compIdx);
    }
    isHebrew() {
        return this.hebrew;
    }
    isMixed() {
        return this._mixed;
    }
    embededChars() {
        return this._embeded;
    }
    isNegative() {
        return this._negative;
    }
    withComa() {
        return this._comma;
    }
    isLeft() {
        return this._left;
    }
    padFill() {
        return this._padFill;
    }
    getPad() {
        return this._pad;
    }
    zeroFill() {
        return this._zeroFill;
    }
    getZeroPad() {
        return this._zero;
    }
    isTrimed() {
        return this._trim;
    }
    autoSkip() {
        return this._autoSkip_;
    }
    withDecimal() {
        return this._decimal;
    }
    withTerm() {
        return this._termFlag;
    }
    getMaskChars() {
        return this._maskChars;
    }
    getWholes() {
        return this._whole;
    }
    getDec() {
        return this._decimalDigits;
    }
    getSize() {
        return this._size;
    }
    getMaskSize() {
        return this._maskSize;
    }
    getMaskLength() {
        return this._maskLength;
    }
    decInFirstPos() {
        return this._decPointIsFirst;
    }
    setFormatExp(val) {
        this._formatExp = val;
    }
    isFormatExp() {
        return this._formatExp;
    }
    getPosPref_() {
        return this._posPref.ToString();
    }
    getPosSuff_() {
        return this._posSuff.ToString();
    }
    getNegPref_() {
        return this._negPref.ToString();
    }
    getNegSuff_() {
        return this._negSuff.ToString();
    }
    getMask() {
        return NString.FromChars(this._msk);
    }
    getFormat() {
        return NString.FromChars(this._format);
    }
    getAttr() {
        return this._picAttr;
    }
    setAttr(set) {
        this._picAttr == set;
    }
    getImeMode() {
        return this._imeMode;
    }
    prs_all(compIdx) {
        if (!this._needLength) {
            this._msk = new Array(this._mskLen);
            for (let _ai = 0; _ai < this._msk.length; ++_ai)
                this._msk[_ai] = '\0';
        }
        switch (this._picAttr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                this.alpha_prs();
                break;
            case StorageAttribute.NUMERIC:
                this.num_prs();
                break;
            case StorageAttribute.DATE:
                this.date_prs(compIdx);
                break;
            case StorageAttribute.TIME:
                this.time_prs();
                break;
            case StorageAttribute.BOOLEAN:
                this.bool_prs();
                break;
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
                break;
        }
    }
    alpha_prs() {
        let currChr;
        let drv;
        let count;
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case 'H':
                    this._formatIdx++;
                    this.setHebrew();
                    break;
                case 'A':
                    this._autoSkip_ = true;
                    this._formatIdx++;
                    break;
                case '#':
                case 'L':
                case 'U':
                case 'X':
                    drv = 0;
                    switch (currChr) {
                        case '#':
                            drv = PICInterface.PIC_N;
                            break;
                        case 'L':
                            drv = PICInterface.PIC_L;
                            break;
                        case 'U':
                            drv = PICInterface.PIC_U;
                            break;
                        case 'X':
                            drv = PICInterface.PIC_X;
                            break;
                    }
                    this._formatIdx++;
                    count = this.pik_count();
                    this.pik_drv_fill(drv, count);
                    break;
                default:
                    if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                        let useImeJpn = UtilStrByteMode.isLocaleDefLangJPN();
                        if (currChr === 'K' && useImeJpn) {
                            if (this.pic_kanji())
                                break;
                        }
                        if (GuiEnvironment.Environment.GetLocalAs400Set()) {
                            drv = 0;
                            if (currChr === 'J')
                                drv = PICInterface.PIC_J;
                            else if (currChr === 'T')
                                drv = PICInterface.PIC_T;
                            else if (currChr === 'G')
                                drv = PICInterface.PIC_G;
                            else if (currChr === 'S')
                                drv = PICInterface.PIC_S;
                            if (drv !== 0) {
                                if (this._imeMode === -1 && useImeJpn) {
                                    if (drv === PICInterface.PIC_J || drv === PICInterface.PIC_G)
                                        this._imeMode = UtilImeJpn.IME_ZEN_HIRAGANA_ROMAN;
                                    else if (drv === PICInterface.PIC_S)
                                        this._imeMode = UtilImeJpn.IME_FORCE_OFF;
                                }
                                this._formatIdx++;
                                count = this.pik_count();
                                this.pik_drv_fill(drv, count);
                                break;
                            }
                        }
                    }
                    if (UtilStrByteMode.isDigit(currChr)) {
                        count = this.pik_count();
                        this.pik_drv_fill(PICInterface.PIC_X, count);
                    }
                    else
                        this.pik_mask();
                    break;
            }
        }
        if (this._maskSize === 0)
            this.pik_drv_fill(PICInterface.PIC_X, this._mskLen);
        this._size = this._maskSize;
        if (!this._embeded)
            this._size -= this._maskChars;
    }
    num_prs() {
        let i;
        let j;
        let currChr;
        let count;
        let tmp;
        let tmps;
        let tmp_c = 0;
        let first = true;
        this._zero = ' ';
        this._pad = ' ';
        this._negPref.Append('-');
        for (i = 0; i < this._format.length; i = i + 1) {
            if (this._format[i] === '+' || this._format[i] === '-') {
                break;
            }
            if (this._format[i] === '\\' || this._format[i] === 'P') {
                i = i + 1;
            }
            if (this._format[i] === 'C') {
                this._comma = true;
            }
        }
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case 'N':
                    this._formatIdx++;
                    this._negative = true;
                    break;
                case 'C':
                    this._formatIdx++;
                    this._comma = true;
                    break;
                case 'L':
                    this._formatIdx++;
                    this._left = true;
                    break;
                case 'P':
                    this._formatIdx++;
                    this._padFill = true;
                    if (this._formatIdx < this._format.length)
                        this._pad = this._format[this._formatIdx++];
                    break;
                case 'Z':
                    this._formatIdx++;
                    this._zeroFill = true;
                    if (this._formatIdx < this._format.length)
                        this._zero = this._format[this._formatIdx++];
                    break;
                case 'A':
                    this._formatIdx++;
                    this._autoSkip_ = true;
                    break;
                case '.':
                    this._formatIdx++;
                    if (this._needLength)
                        this._maskLength++;
                    this._decimal = true;
                    if (this._maskSize < this._mskLen)
                        this._msk[this._maskSize] = String.fromCharCode(PICInterface.PIC_N);
                    if (this._maskSize === 0)
                        this._decPointIsFirst = true;
                    this._maskSize++;
                    break;
                case '+':
                case '-':
                    this.pik_sign();
                    break;
                default:
                    if (UtilStrByteMode.isDigit(currChr) || currChr === '#') {
                        tmp = this._formatIdx;
                        if (currChr === '#')
                            this._formatIdx++;
                        count = this.pik_count();
                        this.pik_drv_fill(PICInterface.PIC_N, count);
                        if (this._format[tmp] === '#') {
                            if (count === 1) {
                                tmps = this._formatIdx;
                                this._formatIdx = tmp;
                                tmp_c = this.pik_dup();
                                this._formatIdx = tmps;
                            }
                            if (first && (tmp_c > 0 || count > 1)) {
                                if (count > 1)
                                    tmp_c = count;
                                if (this._comma && !this._decimal)
                                    this.pik_drv_fill(PICInterface.PIC_N, Math.floor((tmp_c - 1) / 3));
                                first = false;
                            }
                        }
                        else if (this._comma && !this._decimal)
                            this.pik_drv_fill(PICInterface.PIC_N, Math.floor((count - 1) / 3));
                        if (this._decimal)
                            this._decimalDigits += count;
                        else
                            this._whole += count;
                    }
                    else
                        this.pik_mask();
                    break;
            }
        }
        this._prefLen = this._posPref.Length;
        this._suffLen = this._posSuff.Length;
        if (this._negative) {
            if (this._negPref.Length > this._prefLen) {
                this._prefLen = this._negPref.Length;
            }
            if (this._negSuff.Length > this._suffLen) {
                this._suffLen = this._negSuff.Length;
            }
        }
        if (this._whole === 0 && this._decimalDigits === 0) {
            count = PICInterface.PIC_MAX_MSK_LEN - this._prefLen - this._suffLen;
            if (this._maskSize < count) {
                this._whole = count - this._maskSize;
                if (this._comma)
                    this._whole -= Math.floor(this._whole / 4);
                this.pik_drv_fill(PICInterface.PIC_N, this._whole);
            }
        }
        if (this._comma) {
            count = Math.floor((this._whole - 1) / 3);
            this.pik_drv_fill(PICInterface.PIC_N, count);
            this._maskSize -= count;
        }
        i = this._prefLen;
        if (i > 0 && this._msk != null) {
            if ((this._maskSize + i) <= this._mskLen) {
                for (j = this._maskSize - 1; j >= 0; j--)
                    this._msk[j + i] = this._msk[j];
                for (j = 0; j < i; j++)
                    if (this._msk != null && j < this._msk.length)
                        this._msk[j] = String.fromCharCode(PICInterface.PIC_N);
            }
            this._maskSize += i;
        }
        i = this._suffLen;
        if (i > 0 && this._msk != null) {
            if (this._maskSize + this._suffLen <= this._mskLen)
                for (j = 0; j < this._suffLen; j++)
                    this._msk[this._maskSize + j] = String.fromCharCode(PICInterface.PIC_N);
            this._maskSize += i;
        }
    }
    getUnformattedNumericPic() {
        let picStr = '';
        if (this.isNegative())
            picStr = this.isNegative() ? 'N' : '';
        picStr += this.getWholes().toString();
        if (this.getDec() > 0)
            picStr += '.' + this.getDec().toString();
        if (this._zeroFill)
            picStr += 'Z';
        let newPic = new PIC(picStr, StorageAttribute.NUMERIC, 0);
        return newPic;
    }
    date_prs(compIdx) {
        let i;
        let ocr;
        let count;
        let drv = 0;
        let SwitchAndExpandDate = false;
        let SWExpandDateChecked = false;
        let currChr;
        let isJpnEraYear = false;
        this._zero = ' ';
        ocr = 0;
        if (this._format.length === 0 || this._format[0] === '\0')
            this._format = NString.ToCharArray(PIC.getDefaultDateMask(GuiEnvironment.Environment.GetDateMode(compIdx)));
        for (let j = 0; j < this._format.length; j++)
            if (this._format[j] === 'H')
                this.setHebrew();
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case 'H':
                    this._formatIdx++;
                    break;
                case 'Z':
                    this._formatIdx++;
                    this._zeroFill = true;
                    if (this._formatIdx < this._format.length)
                        this._zero = this._format[this._formatIdx++];
                    break;
                case 'T':
                    this._formatIdx++;
                    this._trim = true;
                    break;
                case 'A':
                    this._formatIdx++;
                    this._autoSkip_ = true;
                    break;
                case 'L':
                    if (this.hebrew) {
                        this._formatIdx++;
                        this.pik_drv_fill(PICInterface.PIC_HL, 1);
                    }
                    else
                        this.pik_mask();
                    break;
                case 'Y':
                    count = this.pik_dup();
                    drv = 0;
                    i = count;
                    switch (count) {
                        case 1:
                            break;
                        case 2:
                            if (!this.hebrew)
                                drv = PICInterface.PIC_YY;
                            break;
                        case 4:
                            if (!this.hebrew)
                                drv = PICInterface.PIC_YYYY;
                            else
                                drv = PICInterface.PIC_HYYYYY;
                            break;
                        case 5:
                        case 6:
                            if (this.hebrew)
                                drv = PICInterface.PIC_HYYYYY;
                            break;
                    }
                    if (drv !== 0) {
                        this._formatIdx += count;
                        this.pik_drv_fill(drv, i);
                    }
                    else
                        this.pik_mask();
                    break;
                case 'M':
                    count = this.pik_dup();
                    drv = 0;
                    if (count === 2)
                        drv = PICInterface.PIC_MMD;
                    else if (count > 2) {
                        drv = PICInterface.PIC_MMM;
                        if (count > 10)
                            drv = 0;
                    }
                    if (drv !== 0) {
                        this._formatIdx += count;
                        this.pik_drv_fill(drv, count);
                    }
                    else
                        this.pik_mask();
                    break;
                case 'D':
                    count = this.pik_dup();
                    drv = 0;
                    switch (count) {
                        case 2:
                            if (!this.hebrew) {
                                drv = PICInterface.PIC_DD;
                                break;
                            }
                        case 3:
                            if (!this.hebrew)
                                drv = PICInterface.PIC_DDD;
                            else
                                drv = PICInterface.PIC_HDD;
                            break;
                        case 4:
                            if (!this.hebrew)
                                drv = PICInterface.PIC_DDDD;
                            else
                                this.pik_mask();
                            break;
                        default:
                            this.pik_mask();
                            break;
                    }
                    if (drv !== 0) {
                        this.pik_drv_fill(drv, count);
                        this._formatIdx += count;
                    }
                    break;
                case '#':
                    count = this.pik_dup();
                    if (count === 2) {
                        drv = 0;
                        ocr++;
                        if (!this.hebrew)
                            switch (GuiEnvironment.Environment.GetDateMode(compIdx)) {
                                case 'B':
                                case 'E':
                                    switch (ocr) {
                                        case 1:
                                            drv = PICInterface.PIC_DD;
                                            break;
                                        case 2:
                                            drv = PICInterface.PIC_MMD;
                                            break;
                                        case 3:
                                            drv = PICInterface.PIC_YY;
                                            break;
                                    }
                                    break;
                                case 'A':
                                    switch (ocr) {
                                        case 1:
                                            drv = PICInterface.PIC_MMD;
                                            break;
                                        case 2:
                                            drv = PICInterface.PIC_DD;
                                            break;
                                        case 3:
                                            drv = PICInterface.PIC_YY;
                                            break;
                                    }
                                    break;
                                case 'J':
                                case 'S':
                                    switch (ocr) {
                                        case 1:
                                            if (!SWExpandDateChecked) {
                                                SwitchAndExpandDate = NString.FromChars(this._format).indexOf("####") > -1;
                                                SWExpandDateChecked = true;
                                            }
                                            if (SwitchAndExpandDate)
                                                this.pik_drv_fill(PICInterface.PIC_YYYY, 4);
                                            else
                                                drv = PICInterface.PIC_YY;
                                            break;
                                        case 2:
                                            drv = PICInterface.PIC_MMD;
                                            break;
                                        case 3:
                                            drv = PICInterface.PIC_DD;
                                            break;
                                    }
                                    break;
                            }
                        if (drv !== 0)
                            this.pik_drv_fill(drv, 2);
                    }
                    else if (count === 4) {
                        drv = 0;
                        ocr++;
                        if (!this.hebrew)
                            switch (GuiEnvironment.Environment.GetDateMode(compIdx)) {
                                case 'B':
                                case 'E':
                                case 'A':
                                    if (ocr === 3)
                                        drv = PICInterface.PIC_YYYY;
                                    break;
                                case 'J':
                                case 'S':
                                    if (ocr === 1)
                                        drv = PICInterface.PIC_YYYY;
                                    else {
                                        if (!SWExpandDateChecked) {
                                            SwitchAndExpandDate = NString.FromChars(this._format).indexOf("####") > -1;
                                            SWExpandDateChecked = true;
                                        }
                                        if (SwitchAndExpandDate && ocr === 3)
                                            this.pik_drv_fill(PICInterface.PIC_DD, 2);
                                    }
                                    break;
                            }
                        if (drv !== 0)
                            this.pik_drv_fill(drv, 4);
                    }
                    this._formatIdx += count;
                    break;
                case 'W':
                    count = this.pik_dup();
                    i = count;
                    if (count === 1)
                        drv = PICInterface.PIC_W;
                    else if (this.hebrew)
                        if (count === 5)
                            drv = PICInterface.PIC_WWW;
                        else
                            i = 0;
                    else if (count > 2 && count <= 10)
                        drv = PICInterface.PIC_WWW;
                    else
                        i = 0;
                    this._formatIdx += count;
                    this.pik_drv_fill(drv, i);
                    break;
                case '/':
                    this._formatIdx++;
                    this.pik_drv_fill(GuiEnvironment.Environment.GetDate().charCodeAt(0), 1);
                    break;
                case 'S':
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        count = this.pik_dup();
                        i = count;
                        if (count !== 2 && count !== 4 && count !== 6)
                            i = 0;
                        drv = PICInterface.PIC_BB;
                        this._formatIdx += count;
                        this.pik_drv_fill(drv, i);
                    }
                    else {
                        this.pik_mask();
                    }
                    break;
                case 'J':
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        count = this.pik_dup();
                        i = count;
                        isJpnEraYear = true;
                        switch (count) {
                            case 1:
                                drv = PICInterface.PIC_JY1;
                                break;
                            case 2:
                                drv = PICInterface.PIC_JY2;
                                break;
                            case 4:
                                drv = PICInterface.PIC_JY4;
                                break;
                            default:
                                i = 0;
                                isJpnEraYear = false;
                                break;
                        }
                        this._formatIdx += count;
                        this.pik_drv_fill(drv, i);
                    }
                    else {
                        this.pik_mask();
                    }
                    break;
                default:
                    this.pik_mask();
                    break;
            }
        }
        if (!this._needLength && isJpnEraYear) {
            for (i = 0; i < this._msk.length; i++) {
                if (this._msk[i].charCodeAt(0) === PICInterface.PIC_YY)
                    this._msk[i] = String.fromCharCode(PICInterface.PIC_YJ);
                else if (this._msk[i].charCodeAt(0) === PICInterface.PIC_YYYY)
                    this._msk[i] = 'Y';
            }
        }
    }
    time_prs() {
        let drv;
        let NoFormat;
        let currChr;
        this._zero = ' ';
        if (this._format.length === 0 || this._format[0].charCodeAt(0) === 0) {
            NoFormat = "HH:MM:SS";
            if (this._mskLen < 8)
                NoFormat = NoFormat.substr(0, this._mskLen);
            this._format = NString.ToCharArray(NoFormat);
        }
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            let maskLength;
            switch (currChr) {
                case 'H':
                case 'M':
                case 'S':
                    maskLength = 2;
                    if (this._formatIdx + 1 < this._format.length && this._format[this._formatIdx] === this._format[this._formatIdx + 1]) {
                        switch (currChr) {
                            case 'H':
                                drv = PICInterface.PIC_HH;
                                break;
                            case 'M':
                                drv = PICInterface.PIC_MMT;
                                break;
                            case 'S':
                                drv = PICInterface.PIC_SS;
                                break;
                            default:
                                drv = PICInterface.NULL_CHAR;
                                break;
                        }
                        this._formatIdx += maskLength;
                        this.pik_drv_fill(drv, maskLength);
                    }
                    else
                        this.pik_mask();
                    break;
                case 'm':
                    maskLength = 3;
                    if (this._formatIdx + 2 < this._format.length &&
                        (this._format[this._formatIdx] === this._format[this._formatIdx + 1] &&
                            this._format[this._formatIdx + 1] === this._format[this._formatIdx + 2])) {
                        drv = PICInterface.PIC_MS;
                        this._formatIdx += maskLength;
                        this.pik_drv_fill(drv, maskLength);
                    }
                    else
                        this.pik_mask();
                    break;
                case ':':
                    this._formatIdx++;
                    this.pik_drv_fill(GuiEnvironment.Environment.GetTime().charCodeAt(0), 1);
                    break;
                case 'Z':
                    this._formatIdx++;
                    this._zeroFill = true;
                    if (this._formatIdx < this._format.length)
                        this._zero = this._format[this._formatIdx++];
                    break;
                case 'A':
                    this._formatIdx++;
                    this._autoSkip_ = true;
                    break;
                case 'P':
                    if (this._format[this._formatIdx + 1] === 'M') {
                        this._formatIdx += 2;
                        this.pik_drv_fill(PICInterface.PIC_PM, 2);
                    }
                    else
                        this.pik_mask();
                    break;
                default:
                    this.pik_mask();
                    break;
            }
        }
    }
    static buildPicture(type, val, compIdx, useDecimal) {
        let pic = null;
        let mask = new StringBuilder(10);
        let decimalSeparator;
        let thousands;
        let currChar;
        let counter;
        let length;
        let beforeDec;
        let afterDec;
        let decimalDelimFound;
        let isThousandsDelim;
        let isNegative;
        switch (type) {
            case StorageAttribute.NUMERIC:
                decimalSeparator = GuiEnvironment.Environment.GetDecimal();
                thousands = GuiEnvironment.Environment.GetThousands();
                beforeDec = afterDec = 0;
                decimalDelimFound = false;
                isThousandsDelim = false;
                isNegative = false;
                if (val === null || val.length === 0)
                    beforeDec = afterDec = 1;
                else {
                    length = val.length;
                    counter = 0;
                    while (counter < length) {
                        currChar = val[counter];
                        switch (currChar) {
                            case '+':
                            case '-':
                                isNegative = true;
                                break;
                            default:
                                if (useDecimal && currChar === decimalSeparator)
                                    decimalDelimFound = true;
                                else if (currChar === thousands)
                                    isThousandsDelim = true;
                                else if (decimalDelimFound)
                                    afterDec++;
                                else
                                    beforeDec++;
                                break;
                        }
                        counter++;
                    }
                    mask.Append("" + beforeDec + decimalSeparator + afterDec);
                    if (isNegative)
                        mask.Append('N');
                    if (isThousandsDelim)
                        mask.Append('C');
                }
                break;
            case StorageAttribute.DATE:
                mask.Append(this.getDefaultDateMask(GuiEnvironment.Environment.GetDateMode(compIdx)));
                break;
            case StorageAttribute.TIME:
                mask.Append("HH" + GuiEnvironment.Environment.GetTime() + "MM" + GuiEnvironment.Environment.GetTime() + "SS");
                break;
            default:
                Events.WriteDevToLog("Event.buildPicture() there is no PICTURE building for type :" + type +
                    " and value :" + val);
                return pic;
        }
        pic = new PIC(mask.ToString(), type, compIdx);
        return pic;
    }
    setHebrew() {
        if (GuiEnvironment.Environment.Language === 'H')
            this.hebrew = true;
    }
    static getDefaultDateMask(dataMode) {
        let frmt;
        switch (dataMode) {
            case 'J':
            case 'S':
                frmt = "####/##/##";
                break;
            case 'B':
            case 'E':
            case 'A':
            default:
                frmt = "##/##/####";
                break;
        }
        return frmt;
    }
    bool_prs() {
        let count;
        let currChr;
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case 'H':
                    this._formatIdx++;
                    this.setHebrew();
                    break;
                case 'A':
                    this._formatIdx++;
                    this._autoSkip_ = true;
                    break;
                case 'X':
                    this._formatIdx++;
                    count = this.pik_count();
                    this.pik_drv_fill(PICInterface.PIC_X, count);
                    break;
                default:
                    if (UtilStrByteMode.isDigit(currChr)) {
                        count = this.pik_count();
                        this.pik_drv_fill(PICInterface.PIC_X, count);
                    }
                    else
                        this.pik_mask();
                    break;
            }
        }
        if (this._maskSize === 0)
            this.pik_drv_fill(PICInterface.PIC_X, this._mskLen);
    }
    pik_sign() {
        let posSign;
        let signStr;
        let currChr;
        posSign = this._format[this._formatIdx] === '+'
            ? true
            : false;
        this._formatIdx++;
        if (posSign)
            signStr = this._posPref;
        else {
            this._negPref.Remove(0, this._negPref.Length);
            signStr = this._negPref;
        }
        while (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            switch (currChr) {
                case ';':
                    this._formatIdx++;
                    return;
                case ',':
                    this._formatIdx++;
                    if (posSign)
                        signStr = this._posSuff;
                    else
                        signStr = this._negSuff;
                    break;
                case '\\':
                    this._formatIdx++;
                    if (this._formatIdx >= this._format.length)
                        return;
                    currChr = this._format[this._formatIdx];
                default:
                    signStr.Append(currChr);
                    this._formatIdx++;
                    break;
            }
        }
    }
    pik_count() {
        let specialValNewPolicy = GuiEnvironment.Environment.GetSpecialValNewPolicy();
        let val;
        let isDigit = false;
        val = 0;
        while (this._formatIdx < this._format.length && UtilStrByteMode.isDigit(this._format[this._formatIdx])) {
            val *= 10;
            isDigit = true;
            val += this._format[this._formatIdx].charCodeAt(0) - '0'.charCodeAt(0);
            this._formatIdx++;
        }
        if (val > 32000)
            val = 32000;
        else if (val <= 0) {
            if (specialValNewPolicy && isDigit && val === 0)
                return 0;
            else
                val = 1;
        }
        if (val > Int32.MaxValue)
            throw new ApplicationException(Events.GetMessageString(MsgInterface.STR_ERR_MAX_VAR_SIZE));
        return (val);
    }
    pik_drv_fill(drv, count) {
        let MskZ;
        let i = 0;
        if (this._needLength) {
            this._maskLength += count;
            return;
        }
        MskZ = this._maskSize;
        this._maskSize += count;
        if (MskZ + count > this._mskLen)
            count = this._mskLen - MskZ;
        if (count > 0) {
            for (i = 0; i < count; i++)
                this._msk[MskZ + i] = String.fromCharCode(drv);
            return;
        }
    }
    pik_mask() {
        let currChr;
        let count;
        if (this._format[this._formatIdx] === '\\')
            this._formatIdx++;
        if (this._formatIdx < this._format.length) {
            currChr = this._format[this._formatIdx];
            this._formatIdx++;
            count = this.pik_count();
            this.pik_drv_fill(currChr.charCodeAt(0), count);
            this._maskChars += count;
        }
    }
    pik_dup() {
        let dupCount = 1;
        let c;
        let tmpIdx = this._formatIdx;
        c = this._format[tmpIdx];
        tmpIdx++;
        while (tmpIdx < this._format.length && c === this._format[tmpIdx]) {
            dupCount++;
            tmpIdx++;
        }
        return dupCount;
    }
    pic_kanji() {
        let count;
        if (this._formatIdx + 1 >= this._format.length)
            return false;
        if (!UtilStrByteMode.isDigit(this._format[this._formatIdx + 1]))
            return false;
        this._formatIdx++;
        if (this._format[this._formatIdx] === '0') {
            this._imeMode = UtilImeJpn.IME_FORCE_OFF;
            this._formatIdx++;
        }
        else {
            count = this.pik_count();
            if (1 <= count && count <= 9)
                this._imeMode = count;
        }
        return true;
    }
    getMaskLen(compIdx) {
        this._needLength = true;
        this._maskLength = 0;
        this._formatIdx = 0;
        this.prs_all(compIdx);
        if (this._picAttr === StorageAttribute.NUMERIC && (this._prefLen > 0 || this._suffLen > 0))
            this._maskLength += (this._prefLen + this._suffLen);
        this._needLength = false;
        this._formatIdx = this._maskChars = this._whole = this._decimalDigits = this._size = this._maskSize = this._prefLen = this._suffLen = 0;
        this._pad = this._zero = String.fromCharCode(0);
        this.hebrew = this._mixed = this._embeded = this._negative = this._comma = this._left = this._padFill = this._zeroFill = this._trim = this._autoSkip_ = this._decimal = this._termFlag = this._decPointIsFirst = false;
        this._posPref.Remove(0, this._posPref.Length);
        this._posSuff.Remove(0, this._posSuff.Length);
        this._negPref.Remove(0, this._negPref.Length);
        this._negSuff.Remove(0, this._negSuff.Length);
        return this._maskLength;
    }
    picIsMask(pos) {
        if (pos < 0 || pos >= this._maskLength)
            pos = 0;
        return this._msk[pos].charCodeAt(0) > PICInterface.PIC_MAX_OP;
    }
    getDirectiveLen(posOrMskPos, bufPos, buf) {
        if (arguments.length === 1)
            return this.getDirectiveLen_0(posOrMskPos);
        else
            return this.getDirectiveLen_1(posOrMskPos, bufPos, buf);
    }
    getDirectiveLen_0(pos) {
        let c = this._msk[pos];
        let num = pos;
        while (num < this._maskSize && c === this._msk[num]) {
            num = num + 1;
        }
        return num - pos;
    }
    getDirectiveLen_1(mskPos, bufPos, buf) {
        let drv = this._msk[mskPos];
        let currMskPos = mskPos;
        let currBufPos = bufPos;
        while (currMskPos < this._maskSize && drv === this._msk[currMskPos]) {
            if (currBufPos < buf.length && UtilStrByteMode.isLocaleDefLangDBCS() && this.isAttrAlphaOrDate()) {
                if (!UtilStrByteMode.isHalfWidth(buf[currBufPos++]))
                    currMskPos++;
            }
            currMskPos++;
        }
        return (currMskPos - mskPos);
    }
    validateChar(charToValidate, pos) {
        let charReturned = charToValidate;
        if (pos >= this.getMaskSize())
            return charReturned;
        while (this.picIsMask(pos))
            pos++;
        switch (this._msk[pos].charCodeAt(0)) {
            case PICInterface.PIC_U:
                charReturned = charToValidate.toUpperCase();
                break;
            case PICInterface.PIC_L:
                charReturned = charToValidate.toLowerCase();
            default:
                if (!UtilStrByteMode.isDigit(charToValidate))
                    for (let i = 0; i < PICInterface.NumDirective.length; i++)
                        if (this._msk[pos].charCodeAt(0) === PICInterface.NumDirective[i]) {
                            charReturned = this.isValidInNum(charToValidate);
                            break;
                        }
                break;
        }
        return charReturned;
    }
    isValidInNum(letter) {
        let charRet = '\0';
        let decimalChar = GuiEnvironment.Environment.GetDecimal();
        if (GuiEnvironment.Environment.CanReplaceDecimalSeparator() && this.isAttrNumeric())
            if (letter === '.')
                letter = decimalChar;
        switch (letter) {
            case ' ':
            case '-':
            case '*':
            case '+':
            case '/':
                charRet = letter;
                break;
            default:
                if (letter === decimalChar || letter === GuiEnvironment.Environment.GetThousands())
                    charRet = letter;
                break;
        }
        return charRet;
    }
    isAttrLogical() {
        return (this._picAttr === StorageAttribute.BOOLEAN);
    }
    isAttrNumeric() {
        return (this._picAttr === StorageAttribute.NUMERIC);
    }
    isAttrAlpha() {
        return (this._picAttr === StorageAttribute.ALPHA);
    }
    isAttrUnicode() {
        return (this._picAttr === StorageAttribute.UNICODE);
    }
    isAttrAlphaOrDate() {
        return (this._picAttr === StorageAttribute.ALPHA || this._picAttr === StorageAttribute.DATE);
    }
    isAttrDateOrTime() {
        return (this._picAttr === StorageAttribute.TIME || this._picAttr === StorageAttribute.DATE);
    }
    isAttrBlob() {
        return (this._picAttr === StorageAttribute.BLOB ||
            this._picAttr === StorageAttribute.BLOB_VECTOR);
    }
    isNumeric(pos) {
        return this._msk[pos] === String.fromCharCode(PICInterface.PIC_N);
    }
    isAllX() {
        return (this._msk[0] === String.fromCharCode(PICInterface.PIC_X) && this.getDirectiveLen(0) === this._maskSize);
    }
    isMaskPicEq(pos, maskPic) {
        return this._msk[pos] === String.fromCharCode(maskPic);
    }
    isValidChar_as400(charToValidate, firstChar, pos) {
        let ret = true;
        switch (this._msk[pos].charCodeAt(0)) {
            case PICInterface.PIC_J:
            case PICInterface.PIC_G:
                ret = !UtilStrByteMode.isHalfWidth(charToValidate);
                break;
            case (PICInterface.PIC_T):
                if (firstChar === '\x0000')
                    ret = true;
                else if (UtilStrByteMode.isHalfWidth(firstChar))
                    ret = UtilStrByteMode.isHalfWidth(charToValidate);
                else
                    ret = !UtilStrByteMode.isHalfWidth(charToValidate);
                break;
            case (PICInterface.PIC_S):
                ret = UtilStrByteMode.isHalfWidth(charToValidate);
                break;
            default:
                break;
        }
        return ret;
    }
    getMinimumValueLength() {
        let minLength = this.getMaskLength();
        while (minLength > 0 && !this.picIsMask(minLength - 1))
            minLength--;
        return minLength;
    }
    toString() {
        return "{Picture: " + this._format + "}";
    }
}

class ValidationDetailsBase {
    constructor(rangeStr) {
        this._continuousRangeValues = null;
        this._discreteRangeValues = null;
        this._range = null;
        if (arguments.length === 1) {
            this._range = rangeStr;
            if (this._range !== null)
                this.fillRange();
        }
    }
    fillRange() {
        this._range = StrUtil.makePrintableTokens(this._range, SEQ_2_HTML);
        let from = 0;
        let prev = 0;
        while ((from = this.findDelimeter(from, ",", this._range)) !== -1 && prev < this._range.length) {
            this.rangeForms(this._range.substr(prev, from - prev));
            from = (prev = from + 1);
        }
        if (prev < this._range.length) {
            this.rangeForms(this._range.substr(prev));
        }
        if (this._discreteRangeValues != null) {
            StrUtil.makePrintableTokens(this._discreteRangeValues, HTML_2_STR);
            Events.WriteDevToLog(this._discreteRangeValues.toString());
        }
        if (this._continuousRangeValues !== null) {
            StrUtil.makePrintableTokens(this._continuousRangeValues, HTML_2_STR);
            Events.WriteDevToLog(this._continuousRangeValues.toString());
        }
    }
    rangeForms(found) {
        let minus;
        if ((minus = this.findDelimeter(0, "-", found)) === -1) {
            found = NString.TrimStart(found);
            let todel = 0;
            while (todel < found.length && (todel = this.findDelimeter(todel, "\\", found)) !== -1) {
                found = found.substr(0, todel) + found.substr(todel = todel + 1);
                todel = todel + 1;
            }
            if (this._discreteRangeValues === null)
                this._discreteRangeValues = new List();
            this._discreteRangeValues.push(found);
        }
        else {
            let val;
            for (let i = 0; i < 2; i = i + 1) {
                if (i === 0) {
                    val = found.substr(0, minus);
                }
                else {
                    minus = minus + 1;
                    while (minus < found.length && found.charAt(minus) === " ") {
                        minus = minus + 1;
                    }
                    val = found.substr(minus);
                }
                val = this.deleteChar("\\", val);
                if (this._continuousRangeValues === null) {
                    this._continuousRangeValues = new List();
                }
                this._continuousRangeValues.push(val);
            }
        }
    }
    deleteChar(stringToDelete, from) {
        let index = 0;
        while ((index = from.indexOf(stringToDelete, index)) !== -1)
            from = from.substr(0, index) + from.substr(index + stringToDelete.length);
        return from;
    }
    findDelimeter(start, delim, str) {
        let found = str.indexOf(delim, start);
        while (found < str.length && found > 0) {
            if (str.charAt(found - 1) === "\\") {
                found = str.indexOf(delim, found + 1);
            }
            else
                break;
        }
        return found;
    }
    getDiscreteRangeValues() {
        return this._discreteRangeValues;
    }
    getContinuousRangeValues() {
        return this._continuousRangeValues;
    }
}

class NUM_TYPE {
    set Data(value) {
        this._data = value;
    }
    get Data() {
        return this._data;
    }
    constructor(recordHexStrOrByteValOrDecStrOrNumFrom, offsetOrPic, lengthOrCompIdx) {
        this.COMMACHAR = ',';
        this.DECIMALCHAR = '.';
        this.SIGNIFICANT_NUM_SIZE = 0;
        this._data = new Int8Array(NUM_TYPE.NUM_SIZE);
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        if (arguments.length === 1 && (recordHexStrOrByteValOrDecStrOrNumFrom === null || recordHexStrOrByteValOrDecStrOrNumFrom.constructor === String)) {
            this.constructor_1(recordHexStrOrByteValOrDecStrOrNumFrom);
            return;
        }
        if (arguments.length === 3 && (recordHexStrOrByteValOrDecStrOrNumFrom === null || recordHexStrOrByteValOrDecStrOrNumFrom instanceof Int8Array) && (offsetOrPic === null || offsetOrPic.constructor === Number) && (lengthOrCompIdx === null || lengthOrCompIdx.constructor === Number)) {
            this.constructor_2(recordHexStrOrByteValOrDecStrOrNumFrom, offsetOrPic, lengthOrCompIdx);
            return;
        }
        if (arguments.length === 1 && (recordHexStrOrByteValOrDecStrOrNumFrom === null || recordHexStrOrByteValOrDecStrOrNumFrom instanceof Int8Array)) {
            this.constructor_3(recordHexStrOrByteValOrDecStrOrNumFrom);
            return;
        }
        if (arguments.length === 3 && (recordHexStrOrByteValOrDecStrOrNumFrom === null || recordHexStrOrByteValOrDecStrOrNumFrom.constructor === String) && (offsetOrPic === null || offsetOrPic instanceof PIC) && (lengthOrCompIdx === null || lengthOrCompIdx.constructor === Number)) {
            this.constructor_4(recordHexStrOrByteValOrDecStrOrNumFrom, offsetOrPic, lengthOrCompIdx);
            return;
        }
        this.constructor_5(recordHexStrOrByteValOrDecStrOrNumFrom);
    }
    constructor_0() {
        this.initConst();
        this.NUM_ZERO();
    }
    constructor_1(recordHexStr) {
        let i = 0;
        let twoDigits;
        this.initConst();
        try {
            for (i = 0; i < this.SIGNIFICANT_NUM_SIZE; i = i + 1) {
                twoDigits = recordHexStr.substr(i * 2, 2);
                this._data[i] = NUM_TYPE.toSByte(NNumber.Parse(twoDigits, NumberStyles.HexNumber));
            }
        }
        catch (ex) {
            Events.WriteWarningToLog(ex);
            this.NUM_ZERO();
        }
    }
    constructor_2(byteVal, offset, length) {
        this.constructor_0();
        for (let i = 0; i < length; i = i + 1) {
            this._data[i] = byteVal[i + offset];
        }
    }
    constructor_3(byteVal) {
        this.constructor_2(byteVal, 0, byteVal.length);
    }
    constructor_4(decStr, pic, compIdx) {
        this.constructor_0();
        this.from_a(decStr, pic, compIdx);
    }
    constructor_5(numFrom) {
        this.initConst();
        this._data = new Int8Array(numFrom._data.length);
        for (let _ai = 0; _ai < this._data.length; ++_ai)
            this._data[_ai] = numFrom._data[_ai];
    }
    toDisplayValue(pic) {
        return this.to_a(pic);
    }
    initConst() {
        let env = GuiEnvironment.Environment;
        this.DECIMALCHAR = env.GetDecimal();
        this.COMMACHAR = env.GetThousands();
        this.SIGNIFICANT_NUM_SIZE = env.GetSignificantNumSize();
    }
    toXMLrecord() {
        let hexStr = new StringBuilder(this.SIGNIFICANT_NUM_SIZE * 2);
        let num;
        if (this.NUM_IS_LONG())
            num = 5;
        else
            num = this.SIGNIFICANT_NUM_SIZE;
        for (let i = 0; i < this.SIGNIFICANT_NUM_SIZE; i++) {
            if (i < num)
                hexStr.Append(('0' + (this._data[i] & 0xFF).toString(16)).slice(-2));
            else
                hexStr.Append("00");
        }
        return hexStr.ToString().toUpperCase();
    }
    from_a(Alpha, pic, compIdx) {
        let i;
        let idx;
        let dec;
        let decs;
        let digit;
        let len;
        let no_pic;
        let Pos;
        let SType;
        let SPart;
        let Signed;
        let buf;
        let mask = "";
        let c;
        let NgtvPrmt;
        let Scan = "";
        let Pbuf = "";
        let is_negative;
        let negStr;
        let negPref;
        let posPref;
        let negSuff;
        let posSuff;
        let specialValNewPolicy = GuiEnvironment.Environment.GetSpecialValNewPolicy();
        no_pic = (pic == null);
        len = 0;
        SType = false;
        SPart = false;
        if (!no_pic) {
            mask = pic.getMask();
            if (!specialValNewPolicy)
                if (Alpha.length > pic.getMaskSize())
                    Alpha = Alpha.substr(0, pic.getMaskSize());
            NgtvPrmt = pic.isNegative();
            if (NgtvPrmt) {
                negPref = pic.getNegPref_();
                posPref = pic.getPosPref_();
                negSuff = pic.getNegSuff_();
                posSuff = pic.getPosSuff_();
                if (negPref.length === posPref.length) {
                    if (negPref.length === 0 || negPref === posPref)
                        SPart = false;
                    else
                        SPart = true;
                }
                else
                    SPart = true;
                if (SPart)
                    negStr = negPref;
                else
                    negStr = negSuff;
                if (negStr.length === 0)
                    SType = true;
                else
                    SType = false;
                if (SType)
                    Scan = (SPart ? posPref : posSuff);
                else
                    Scan = (SPart ? negPref : negSuff);
                len = Scan.length;
            }
        }
        else {
            pic = new PIC("", StorageAttribute.NUMERIC, compIdx);
            NgtvPrmt = false;
        }
        dec = false;
        decs = 0;
        digit = 0;
        Signed = 0;
        for (idx = 0; idx < Alpha.length;) {
            if (no_pic || (specialValNewPolicy && idx >= pic.getMaskSize()) || mask[idx] === String.fromCharCode(PICInterface.PIC_N)) {
                c = Alpha[idx];
                if (specialValNewPolicy) {
                    if (dec && decs === pic.getDec()) {
                        break;
                    }
                }
                if (UtilStrByteMode.isDigit(c)) {
                    digit++;
                    Pbuf += c;
                    if (dec)
                        decs++;
                }
                else if (c === this.DECIMALCHAR) {
                    Pbuf += this.DECIMALCHAR;
                    dec = true;
                }
                else if (c !== this.COMMACHAR) {
                    if (NgtvPrmt && Signed === 0) {
                        Signed = 1;
                        for (i = idx, Pos = 0; i <= Alpha.length && Pos < len; i++) {
                            if (no_pic || mask[i] === String.fromCharCode(PICInterface.PIC_N)) {
                                c = Alpha[i];
                                if (c !== Scan[Pos]) {
                                    if (c === '-' && !SType)
                                        break;
                                    if (c === '+' && SType)
                                        break;
                                    Signed = -1;
                                    break;
                                }
                                Pos++;
                            }
                        }
                        if (Pos > 0 && Pos < len)
                            Signed = -1;
                    }
                    else {
                        if (idx === 0) {
                            if (pic.getNegPref_().length > 0)
                                if (Alpha.startsWith(pic.getNegPref_())) {
                                    idx += pic.getNegPref_().length;
                                    continue;
                                }
                            if (pic.getPosPref_().length > 0)
                                if (Alpha.startsWith(pic.getPosPref_())) {
                                    idx += pic.getPosPref_().length;
                                    continue;
                                }
                        }
                        else {
                            if (pic.getNegSuff_().length > 0)
                                if (Alpha.endsWith(pic.getNegSuff_())) {
                                    idx += pic.getNegSuff_().length;
                                    continue;
                                }
                            if (pic.getPosSuff_().length > 0)
                                if (Alpha.endsWith(pic.getPosSuff_())) {
                                    idx += pic.getPosSuff_().length;
                                    continue;
                                }
                        }
                    }
                }
            }
            idx++;
        }
        if (Signed === 0 && SType)
            Signed = 1;
        is_negative = (Signed === 1 && !SType) || (Signed !== 1 && SType);
        if (decs > 0 || digit > 9) {
            buf = (is_negative ? '-' : ' ') + Pbuf;
            this.num_4_a_std(buf);
        }
        else
            this.NUM_4_LONG((is_negative ? -1 : 1) * this.a_2_long(Pbuf));
    }
    num_4_a_std(str) {
        let digstr = "";
        let diglen = 0;
        let wholes = 0;
        let decs = 0;
        let isDec = false;
        let isminus = false;
        let pos;
        for (pos = 0; pos < str.length; pos++) {
            let c = str.charAt(pos);
            if (UtilStrByteMode.isDigit(c)) {
                if (diglen > 0 || c !== '0') {
                    diglen++;
                    digstr = digstr + c;
                    if (!isDec)
                        wholes++;
                }
                else if (isDec)
                    decs = decs + 1;
            }
            else if (c === this.DECIMALCHAR)
                isDec = true;
            else if (c === '-')
                isminus = true;
        }
        this.NUM_ZERO();
        if (diglen === 0)
            return;
        if (((wholes + decs) & 1) > 0) {
            this._data[1] = NUM_TYPE.toSByte(digstr.charCodeAt(0) - '0'.charCodeAt(0));
            pos = 1;
        }
        else
            pos = 0;
        let numptr = 1 + pos;
        diglen = Math.min(diglen, (this.SIGNIFICANT_NUM_SIZE - 1) * 2 - pos);
        while (pos < diglen) {
            let digit1 = NUM_TYPE.toSByte((digstr.charCodeAt(pos++) - '0'.charCodeAt(0)));
            let digit2 = NUM_TYPE.toSByte(((pos < diglen)
                ? (digstr.charCodeAt(pos++) - '0'.charCodeAt(0))
                : '\0'.charCodeAt(0)));
            this._data[numptr++] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(digit1) * 10 + NUM_TYPE.toUByte(digit2));
        }
        if (wholes > 0)
            this._data[0] = NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + ((wholes + 1) >> 1));
        else
            this._data[0] = NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS - (decs >> 1));
        if (isminus)
            this._data[0] |= NUM_TYPE.SIGN_MASK;
    }
    NUM_4_LONG(longVal) {
        let hexStr;
        this.NUM_ZERO();
        if (longVal !== 0) {
            if (longVal < 0)
                longVal = (0xFFFFFFFF + longVal + 1);
            hexStr = longVal.toString(16);
            if (longVal > 0)
                hexStr = NUM_TYPE.INT_ZERO_HEX.substr(hexStr.length) + hexStr;
            this._data[1] = NUM_TYPE.toSByte(parseInt(hexStr.substr(6, (8) - (6)), 16));
            this._data[2] = NUM_TYPE.toSByte(parseInt(hexStr.substr(4, (6) - (4)), 16));
            this._data[3] = NUM_TYPE.toSByte(parseInt(hexStr.substr(2, (4) - (2)), 16));
            this._data[4] = NUM_TYPE.toSByte(parseInt(hexStr.substr(0, (2) - (0)), 16));
        }
    }
    a_2_long(str) {
        let n = 0;
        for (let pos = 0; pos < str.length; pos++) {
            if (UtilStrByteMode.isDigit(str.charAt(pos))) {
                n = n * 10;
                n = n + str.charCodeAt(pos) - '0'.charCodeAt(0);
            }
        }
        return n;
    }
    to_a(pic) {
        return this.to_a_pic(pic);
    }
    to_a_pic(pic) {
        let buf = new Array(128);
        let remains;
        let sign_n;
        let pref_len;
        let suff_len;
        let pref_str;
        let suff_str;
        let str_pos;
        let str_len;
        let out_pos;
        let out_buf;
        let tmp_out_buf;
        let pad;
        let left;
        let pfill;
        let mask_chars;
        let len;
        let res;
        let i;
        let isOut;
        let outVal;
        len = pic.getMaskSize();
        sign_n = (pic.isNegative() && this.num_is_neg() ? false : true);
        pref_len = (sign_n ? pic.getPosPref_().length : pic.getNegPref_().length);
        suff_len = (sign_n ? pic.getPosSuff_().length : pic.getNegSuff_().length);
        left = pic.isLeft();
        pfill = pic.padFill();
        mask_chars = pic.getMaskChars();
        outVal = NString.ToCharArray(pic.getMask().substr(0, len));
        out_buf = ((left || (mask_chars > 0)) ? buf : outVal);
        if (left) {
            for (i = 0; i < out_buf.length; i++)
                out_buf[i] = '0'.toLowerCase();
        }
        isOut = ((left || (mask_chars > 0)) ? false : true);
        str_pos = pref_len;
        str_len = len - pref_len - suff_len;
        tmp_out_buf = out_buf.slice(str_pos, out_buf.length);
        if (this.NUM_IS_LONG())
            remains = this.num_l_2_str(this.NUM_LONG(), tmp_out_buf, str_len, pic);
        else
            remains = this.to_str(tmp_out_buf, str_len, pic);
        for (i = str_pos; i < out_buf.length; i++)
            out_buf[i] = tmp_out_buf[i - str_pos];
        tmp_out_buf = null;
        if (remains < mask_chars) {
            res = new Array(len);
            for (i = 0; i < len; i++)
                res[i] = (remains === NUM_TYPE.ZERO_FILL ? pic.getZeroPad() : '*');
            return NString.FromChars(res);
        }
        if (mask_chars > 0) {
            remains -= mask_chars;
            str_pos += mask_chars;
            str_len -= mask_chars;
        }
        if (pfill) {
            pad = pic.getPad();
            if (left) {
                for (i = 0; i < remains; i++)
                    out_buf[str_pos + str_len + i] = pad;
                str_pos += remains;
            }
            else {
                for (i = 0; i < remains; i++)
                    out_buf[str_pos + i] = pad;
            }
        }
        else {
            pad = ' ';
            str_pos += remains;
            str_len -= remains;
        }
        if (suff_len > 0) {
            suff_str = sign_n ? pic.getPosSuff_() : pic.getNegSuff_();
            if (suff_len === 1)
                out_buf[str_pos + str_len] = suff_str[0];
            else {
                for (i = 0; i < suff_len; i++)
                    out_buf[str_pos + str_len + i] = suff_str[i];
            }
            str_len += suff_len;
        }
        if (pref_len > 0) {
            str_pos -= pref_len;
            str_len += pref_len;
            pref_str = sign_n ? pic.getPosPref_() : pic.getNegPref_();
            if (pref_len === 1)
                out_buf[str_pos] = pref_str[0];
            else
                for (i = 0; i < pref_len; i++)
                    out_buf[str_pos + i] = pref_str[i];
        }
        if (!pfill) {
            let outBufLen = out_buf.length;
            if (left) {
                for (i = 0; i < remains && (str_pos + str_len + i < outBufLen); i++)
                    out_buf[str_pos + str_len + i] = pad;
            }
            else {
                str_pos -= remains;
                for (i = 0; i < remains && (str_pos + i < outBufLen); i++)
                    out_buf[str_pos + i] = pad;
            }
        }
        if (isOut)
            return NString.FromChars(out_buf);
        if (mask_chars === 0) {
            if (str_pos + len > out_buf.length)
                len = out_buf.length - str_pos;
            return NString.FromChars(out_buf, str_pos, len);
        }
        for (out_pos = 0; out_pos < len && str_pos < out_buf.length; out_pos++)
            if (outVal[out_pos] === String.fromCharCode(PICInterface.PIC_N))
                outVal[out_pos] = out_buf[str_pos++];
        return NString.FromChars(outVal);
    }
    num_l_2_str(num, str, len, pic) {
        let commas;
        let digits;
        let i;
        let decs;
        let j;
        if (num < 0)
            num = -num;
        commas = pic.withComa();
        decs = Math.min(pic.getDec(), len - 1);
        if (decs > 0)
            len -= (decs + 1);
        i = len;
        if (num === 0 && !pic.decInFirstPos()) {
            if (pic.zeroFill())
                return (NUM_TYPE.ZERO_FILL);
            if (len === 0)
                return (NUM_TYPE.NO_ROOM);
            if (i > str.length)
                i = str.length;
            str[--i] = '0';
        }
        if (decs > 0) {
            str[len] = this.DECIMALCHAR;
            for (j = 0; j < decs; j++)
                str[len + 1 + j] = '0';
        }
        digits = 0;
        for (; num > 0; num = Math.floor(num / 10)) {
            i--;
            if (commas) {
                if (digits === 3) {
                    if (i < 0)
                        return (NUM_TYPE.NO_ROOM);
                    digits = 0;
                    str[i--] = this.COMMACHAR;
                }
                digits++;
            }
            if (i < 0)
                return (NUM_TYPE.NO_ROOM);
            str[i] = ((num % 10).toString());
        }
        return i;
    }
    to_str(str, len, pic) {
        let tmp;
        let commas;
        let digits;
        let decpos;
        let last;
        let first;
        let j;
        let i;
        let decs;
        let num_char;
        commas = pic.withComa();
        decs = pic.getDec();
        if (decs >= len)
            decs = len - 1;
        tmp = new NUM_TYPE(this);
        tmp.round(decs);
        if (tmp.NUM_IS_LONG())
            return tmp.num_l_2_str(tmp.NUM_LONG(), str, len, pic);
        if (pic.zeroFill() && tmp._data[0] === 0)
            return (NUM_TYPE.ZERO_FILL);
        i = len - 1;
        digits = 0;
        decpos = ((tmp._data[0] & ~NUM_TYPE.SIGN_MASK) - NUM_TYPE.EXP_BIAS + 1) * 2;
        last = decpos - 1 + decs;
        first = decpos - 1;
        if (first > 2)
            first = (tmp._data[1] < 10) ? 3 : 2;
        for (j = last; j >= first; j--) {
            if (i < 0)
                return (NUM_TYPE.NO_ROOM);
            if (commas && (j < decpos)) {
                if (digits === 3) {
                    digits = 0;
                    str[i--] = this.COMMACHAR;
                }
                digits++;
            }
            if (i < 0)
                return (NUM_TYPE.NO_ROOM);
            if ((j < 2) || (j >= this.SIGNIFICANT_NUM_SIZE * 2))
                str[i--] = '0';
            else {
                if (i < 0)
                    return (NUM_TYPE.NO_ROOM);
                num_char = tmp._data[j >> 1];
                str[i--] = (((j & 1) !== 0) ? (num_char % 10) : (Math.floor(num_char / 10))).toString();
            }
            if (j === decpos) {
                if (i < 0)
                    return (NUM_TYPE.NO_ROOM);
                str[i--] = this.DECIMALCHAR;
                if (i < 0 && pic.decInFirstPos())
                    return (0);
            }
        }
        return (i + 1);
    }
    static add(num1, num2) {
        let sign1;
        let sign2;
        let l;
        let l1;
        let l2;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 === null || num2 === null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let tmpres = new NUM_TYPE();
        let res = new NUM_TYPE();
        let operData = new OperData();
        if (num1.NUM_IS_LONG()) {
            if (num2.NUM_IS_LONG()) {
                l = l1 = num1.NUM_LONG();
                if (l < 0)
                    l = -l;
                if (l < 0x40000000) {
                    l = l2 = num2.NUM_LONG();
                    if (l < 0)
                        l = -l;
                    if (l < 0x40000000) {
                        l1 += l2;
                        res.NUM_4_LONG(l1);
                        return res;
                    }
                }
                num2.num_4_std_long();
            }
            num1.num_4_std_long();
        }
        else if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        sign1 = NUM_TYPE.toSByte(num1._data[0] & NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp1_ = NUM_TYPE.toSByte(num1._data[0] & ~NUM_TYPE.SIGN_MASK);
        sign2 = NUM_TYPE.toSByte(num2._data[0] & NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp2_ = NUM_TYPE.toSByte(num2._data[0] & ~NUM_TYPE.SIGN_MASK);
        operData.NUM_Diff_ = (operData.NUM_Exp1_ - operData.NUM_Exp2_);
        let cmpval = operData.NUM_Diff_;
        if (cmpval === 0) {
            cmpval = NUM_TYPE.toUByte(num1._data[1]) - NUM_TYPE.toUByte(num2._data[1]);
            if (cmpval === 0)
                cmpval = NUM_TYPE.memcmp(num1, 2, num2, 2, SIGNIFICANT_NUM_SIZE - 2);
        }
        if (cmpval >= 0) {
            if (sign1 === sign2)
                tmpres = NUM_TYPE.add_pos(num1, num2, operData);
            else
                tmpres = NUM_TYPE.sub_pos(num1, num2, operData);
            if (tmpres._data[0] !== 0)
                tmpres._data[0] = NUM_TYPE.toSByte(tmpres._data[0] | sign1);
        }
        else {
            let exp = operData.NUM_Exp1_;
            operData.NUM_Exp1_ = operData.NUM_Exp2_;
            operData.NUM_Exp2_ = exp;
            operData.NUM_Diff_ = -operData.NUM_Diff_;
            if (sign1 === sign2)
                tmpres = NUM_TYPE.add_pos(num2, num1, operData);
            else
                tmpres = NUM_TYPE.sub_pos(num2, num1, operData);
            if (tmpres._data[0] !== 0)
                tmpres._data[0] |= sign2;
        }
        return tmpres;
    }
    static sub(num1, num2) {
        if (num1 === null || num2 === null)
            return null;
        let tmpres = new NUM_TYPE();
        let res = new NUM_TYPE();
        let operData = new OperData();
        if (num1.NUM_IS_LONG()) {
            if (num2.NUM_IS_LONG()) {
                let l;
                let l1 = l = num1.NUM_LONG();
                if (l < 0)
                    l = -l;
                if (l < 0x40000000) {
                    let l2 = l = num2.NUM_LONG();
                    if (l < 0)
                        l = -l;
                    if (l < 0x40000000) {
                        l1 -= l2;
                        res.NUM_4_LONG(l1);
                        return res;
                    }
                }
                num2.num_4_std_long();
            }
            num1.num_4_std_long();
        }
        else if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        let sign1 = NUM_TYPE.toSByte(num1._data[0] & NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp1_ = NUM_TYPE.toSByte(num1._data[0] & ~NUM_TYPE.SIGN_MASK);
        let sign2 = NUM_TYPE.toSByte(num2._data[0] & NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp2_ = NUM_TYPE.toSByte(num2._data[0] & ~NUM_TYPE.SIGN_MASK);
        operData.NUM_Diff_ = (operData.NUM_Exp1_ - operData.NUM_Exp2_);
        let cmpval = operData.NUM_Diff_;
        if (cmpval === 0) {
            cmpval = NUM_TYPE.toUByte(num1._data[1]) - NUM_TYPE.toUByte(num2._data[1]);
            if (cmpval === 0)
                cmpval = NUM_TYPE.memcmp(num1, 2, num2, 2, GuiEnvironment.Environment.GetSignificantNumSize() - 2);
        }
        if (cmpval >= 0) {
            if (sign1 === sign2)
                tmpres = NUM_TYPE.sub_pos(num1, num2, operData);
            else
                tmpres = NUM_TYPE.add_pos(num1, num2, operData);
        }
        else {
            let exp = operData.NUM_Exp1_;
            operData.NUM_Exp1_ = operData.NUM_Exp2_;
            operData.NUM_Exp2_ = exp;
            operData.NUM_Diff_ = -operData.NUM_Diff_;
            if (sign1 === sign2) {
                tmpres = NUM_TYPE.sub_pos(num2, num1, operData);
                sign1 ^= (NUM_TYPE.SIGN_MASK);
            }
            else
                tmpres = NUM_TYPE.add_pos(num2, num1, operData);
        }
        if (tmpres._data[0] !== 0)
            tmpres._data[0] |= sign1;
        return tmpres;
    }
    static mul(num1, num2) {
        let fullres = new Int8Array(38);
        let pwr;
        let len1;
        let len2;
        let pos1;
        let pos2;
        let pos;
        let digit1;
        let prod;
        let carry;
        let l;
        let l1;
        let l2;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 === null || num2 === null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let res = new NUM_TYPE();
        let operData = new OperData();
        let i;
        let tmpByte;
        if (num1.NUM_IS_LONG()) {
            if (num2.NUM_IS_LONG()) {
                l = l1 = num1.NUM_LONG();
                if (l < 0)
                    l = -l;
                if (l < 0xB000) {
                    l = l2 = num2.NUM_LONG();
                    if (l < 0)
                        l = -l;
                    if (l < 0xB000) {
                        l1 = l1 * l2;
                        res.NUM_4_LONG(l1);
                        return res;
                    }
                }
                num2.num_4_std_long();
            }
            num1.num_4_std_long();
        }
        else if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        operData.NUM_Exp1_ = NUM_TYPE.toSByte(num1._data[0] & ~NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp2_ = NUM_TYPE.toSByte(num2._data[0] & ~NUM_TYPE.SIGN_MASK);
        if (operData.NUM_Exp1_ === 0 || operData.NUM_Exp2_ === 0) {
            res.NUM_ZERO();
            return res;
        }
        for (len1 = SIGNIFICANT_NUM_SIZE - 1; num1._data[len1] === 0; len1--) {
        }
        for (len2 = SIGNIFICANT_NUM_SIZE - 1; num2._data[len2] === 0; len2--) {
        }
        for (i = 0; i < (NUM_TYPE.NUM_SIZE - 1) * 2; i++)
            fullres[i] = 0;
        pos = 0;
        for (pos1 = len1; pos1 > 0; pos1--) {
            pos = pos1 + len2 - 1;
            digit1 = num1._data[pos1];
            carry = 0;
            for (pos2 = len2; pos2 > 0; pos2--) {
                prod = NUM_TYPE.toUByte(digit1) * NUM_TYPE.toUByte(num2._data[pos2]) + carry;
                carry = Math.floor(prod / 100);
                fullres[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(fullres[pos]) + prod % 100);
                tmpByte = fullres[pos];
                pos--;
                if (NUM_TYPE.toUByte(tmpByte) >= 100) {
                    fullres[pos + 1] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(fullres[pos + 1]) - 100);
                    carry++;
                }
            }
            fullres[pos] = NUM_TYPE.toSByte(carry);
        }
        pwr = NUM_TYPE.toUByte(operData.NUM_Exp1_) - NUM_TYPE.EXP_BIAS + (NUM_TYPE.toUByte(operData.NUM_Exp2_) - NUM_TYPE.EXP_BIAS);
        if (fullres[0] === 0) {
            pos++;
            pwr--;
        }
        if ((num1._data[0] & NUM_TYPE.SIGN_MASK) === (num2._data[0] & NUM_TYPE.SIGN_MASK))
            res._data[0] = 0;
        else
            res._data[0] = NUM_TYPE.SIGN_MASK;
        res._data[0] |= NUM_TYPE.toSByte(pwr + NUM_TYPE.EXP_BIAS);
        for (i = 0; i < SIGNIFICANT_NUM_SIZE - 1; i++)
            res._data[1 + i] = fullres[pos + i];
        return res;
    }
    static mod(num1, num2) {
        if (num1 === null || num2 === null)
            return null;
        let res = new NUM_TYPE();
        if (num2.num_is_zero()) {
            res.NUM_ZERO();
            return res;
        }
        if (num1.NUM_IS_LONG())
            num1.num_4_std_long();
        if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        res = NUM_TYPE.div(num1, num2);
        res.num_trunc(0);
        res = NUM_TYPE.mul(res, num2);
        res = NUM_TYPE.sub(num1, res);
        return res;
    }
    static div(num1, num2) {
        let dividend = new Int8Array((NUM_TYPE.NUM_SIZE - 1) * 2);
        let divisor = new Int8Array(NUM_TYPE.NUM_SIZE);
        let pwr;
        let len1;
        let len2;
        let pos1;
        let pos2;
        let pos;
        let quot;
        let prod;
        let carry;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 === null || num2 === null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let res = new NUM_TYPE();
        let operData = new OperData();
        let i;
        let tmpByte;
        if (num1.NUM_IS_LONG())
            num1.num_4_std_long();
        if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        operData.NUM_Exp1_ = NUM_TYPE.toSByte(num1._data[0] & ~NUM_TYPE.SIGN_MASK);
        operData.NUM_Exp2_ = NUM_TYPE.toSByte(num2._data[0] & ~NUM_TYPE.SIGN_MASK);
        if (operData.NUM_Exp1_ === 0 || operData.NUM_Exp2_ === 0) {
            res.NUM_ZERO();
            return res;
        }
        for (len1 = SIGNIFICANT_NUM_SIZE - 1; num1._data[len1] === 0; len1--) {
        }
        for (len2 = SIGNIFICANT_NUM_SIZE - 1; num2._data[len2] === 0; len2--) {
        }
        pos = (NUM_TYPE.memcmp(num1, 1, num2, 1, len2) < 0) ? 0 : 1;
        for (i = 0; i < (NUM_TYPE.NUM_SIZE - 1) * 2; i++)
            dividend[i] = 0;
        for (i = 0; i < len1; i++)
            dividend[pos + i] = num1._data[1 + i];
        for (i = 0; i < len2; i++)
            divisor[1 + i] = num2._data[1 + i];
        res.NUM_SET_ZERO();
        pwr = NUM_TYPE.toUByte(operData.NUM_Exp1_) - NUM_TYPE.toUByte(operData.NUM_Exp2_) + pos;
        res._data[0] = NUM_TYPE.toSByte(pwr + NUM_TYPE.EXP_BIAS);
        if ((num1._data[0] & NUM_TYPE.SIGN_MASK) !== (num2._data[0] & NUM_TYPE.SIGN_MASK))
            res._data[0] |= NUM_TYPE.SIGN_MASK;
        quot = Math.floor(100 / (NUM_TYPE.toUByte(divisor[1]) + 1));
        if (quot > 1) {
            carry = 0;
            for (pos2 = len2; pos2 > 0; pos2--) {
                prod = quot * NUM_TYPE.toUByte(divisor[pos2]) + carry;
                carry = Math.floor(prod / 100);
                divisor[pos2] = NUM_TYPE.toSByte(prod % 100);
            }
            carry = 0;
            for (pos1 = len1 + pos - 1; pos1 >= 0; pos1--) {
                prod = quot * NUM_TYPE.toUByte(dividend[pos1]) + carry;
                carry = Math.floor(prod / 100);
                dividend[pos1] = NUM_TYPE.toSByte(prod % 100);
            }
        }
        for (pos1 = 1; pos1 < SIGNIFICANT_NUM_SIZE; pos1++) {
            quot = NUM_TYPE.toUByte(dividend[pos1 - 1]) * 100 + Math.floor(NUM_TYPE.toUByte(dividend[pos1]) / NUM_TYPE.toUByte(divisor[1]));
            if (quot >= 100)
                quot = 99;
            if (quot !== 0) {
                pos = pos1 + len2 - 1;
                carry = 0;
                for (pos2 = len2; pos2 > 0; pos2--) {
                    prod = quot * NUM_TYPE.toUByte(divisor[pos2]) + carry;
                    carry = Math.floor(prod / 100);
                    dividend[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos]) - prod % 100);
                    tmpByte = dividend[pos];
                    pos--;
                    if (tmpByte < 0) {
                        dividend[pos + 1] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos + 1]) + 100);
                        carry++;
                    }
                }
                dividend[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos]) - carry);
                while (dividend[pos] < 0) {
                    quot--;
                    pos = pos1 + len2 - 1;
                    for (pos2 = len2; pos2 > 0; pos2--) {
                        dividend[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos]) + NUM_TYPE.toUByte(divisor[pos2]));
                        tmpByte = dividend[pos];
                        pos--;
                        if (NUM_TYPE.toUByte(tmpByte) >= 100) {
                            dividend[pos + 1] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos + 1]) - 100);
                            dividend[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(dividend[pos]) + 1);
                        }
                    }
                }
            }
            res._data[pos1] = NUM_TYPE.toSByte(quot);
        }
        return res;
    }
    static num_cmp(num1, num2) {
        let sign1;
        let sign2;
        let cmpval;
        let l1;
        let l2;
        let tmp;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 == null || num2 == null)
            return Int32.MinValue;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        if (num1.NUM_IS_LONG()) {
            if (num2.NUM_IS_LONG()) {
                l1 = num1.NUM_LONG();
                l2 = num2.NUM_LONG();
                if (l1 >= 0 && l2 >= 0) {
                    tmp = l1 - l2;
                    if (tmp === 0)
                        return (0);
                    if (tmp > 0)
                        return (1);
                    return (-1);
                }
                num2.num_4_std_long();
            }
            num1.num_4_std_long();
        }
        else if (num2.NUM_IS_LONG())
            num2.num_4_std_long();
        sign1 = NUM_TYPE.toSByte(num1._data[0] & NUM_TYPE.SIGN_MASK);
        sign2 = NUM_TYPE.toSByte(num2._data[0] & NUM_TYPE.SIGN_MASK);
        cmpval = (sign1 === sign2)
            ? NUM_TYPE.memcmp(num1, 0, num2, 0, SIGNIFICANT_NUM_SIZE)
            : 1;
        if (sign1 !== 0)
            cmpval = -cmpval;
        return (cmpval);
    }
    static numHexStrIsLong(numHexStr) {
        return numHexStr.substr(0, 2) === "FF";
    }
    NUM_ZERO() {
        this.setZero(true);
    }
    NUM_SET_ZERO() {
        this.setZero(false);
    }
    num_is_neg() {
        if (this.NUM_IS_LONG())
            return ((this._data[4] & 0x80) !== 0);
        return ((this._data[0] & NUM_TYPE.SIGN_MASK) !== 0);
    }
    num_is_zero() {
        if (this.NUM_IS_LONG())
            return (this.NUM_LONG() === 0);
        return (this._data[0] === 0);
    }
    num_neg() {
        let l;
        if (this.NUM_IS_LONG()) {
            l = -this.NUM_LONG();
            this.NUM_4_LONG(l);
            return;
        }
        if (this._data[0] !== 0)
            this._data[0] ^= NUM_TYPE.SIGN_MASK;
    }
    NUM_IS_LONG() {
        return this._data[0] === NUM_TYPE.NUM_LONG_TYPE;
    }
    NUM_LONG() {
        if (this._data[1] === 0 && this._data[2] === 0 && this._data[3] === 0 && this._data[4] === -128)
            return Int32.MinValue;
        let dataview = new DataView(this._data.buffer);
        return dataview.getInt32(1, true);
    }
    round(decs) {
        let addval;
        if (this.NUM_IS_LONG())
            return;
        addval = new NUM_TYPE();
        addval._data[0] = NUM_TYPE.toSByte((this._data[0] & NUM_TYPE.SIGN_MASK) | (NUM_TYPE.EXP_BIAS - (decs >> 1)));
        addval._data[1] = NUM_TYPE.toSByte((decs & 1) !== 0 ? 5 : 50);
        let temp = NUM_TYPE.add(this, addval);
        this._data = new Int8Array(temp._data.length);
        this._data = temp._data;
        this.num_trunc(decs);
    }
    dbRound(whole) {
        let addval;
        let pwr;
        let num_diff;
        let i;
        if (this.NUM_IS_LONG())
            return;
        addval = new NUM_TYPE();
        addval._data[0] = NUM_TYPE.toSByte((this._data[0] & NUM_TYPE.SIGN_MASK) | (NUM_TYPE.EXP_BIAS + ((whole + 1) >> 1)));
        addval._data[1] = NUM_TYPE.toSByte(((whole & 1) !== 0) ? 5 : 50);
        let temp = NUM_TYPE.add(this, addval);
        this._data = new Int8Array(temp._data.length);
        for (let _ai = 0; _ai < this._data.length; ++_ai)
            this._data[_ai] = temp._data[_ai];
        pwr = (this._data[0] & ~NUM_TYPE.SIGN_MASK) - NUM_TYPE.EXP_BIAS;
        if ((num_diff = pwr - ((whole + 1) >> 1)) >= 0) {
            if ((whole & 1) !== 0) {
                this._data[1 + num_diff] = NUM_TYPE.toSByte(this._data[1 + num_diff] - this._data[1 + num_diff] % 10);
                num_diff++;
            }
            for (i = 0; i < this.SIGNIFICANT_NUM_SIZE - (1 + num_diff); i++)
                this._data[1 + num_diff + i] = 0;
        }
        else
            this.NUM_SET_ZERO();
    }
    num_trunc(decs) {
        let pwr;
        let num_diff;
        let i;
        if (this.NUM_IS_LONG())
            return;
        pwr = (this._data[0] & ~NUM_TYPE.SIGN_MASK) - NUM_TYPE.EXP_BIAS;
        if ((num_diff = this.SIGNIFICANT_NUM_SIZE - 1 - pwr - ((decs + 1) >> 1)) < 0)
            return;
        if ((num_diff < this.SIGNIFICANT_NUM_SIZE - 1) && ((decs & 1) !== 0)) {
            this._data[this.SIGNIFICANT_NUM_SIZE - 1 - num_diff] =
                NUM_TYPE.toSByte(this._data[this.SIGNIFICANT_NUM_SIZE - 1 - num_diff] - this._data[this.SIGNIFICANT_NUM_SIZE - 1 - num_diff] % 10);
            if (this._data[this.SIGNIFICANT_NUM_SIZE - 1 - num_diff] === 0)
                num_diff++;
        }
        if (num_diff >= this.SIGNIFICANT_NUM_SIZE - 1) {
            this.NUM_ZERO();
            return;
        }
        for (i = 0; i < num_diff; i++)
            this._data[this.SIGNIFICANT_NUM_SIZE - num_diff + i] = 0;
    }
    num_4_std_long() {
        let slong;
        slong = this.NUM_LONG();
        if (slong >= 0)
            this.num_4_ulong(slong);
        else {
            this.num_4_ulong(-slong);
            this._data[0] |= NUM_TYPE.SIGN_MASK;
        }
    }
    num_4_ulong(data) {
        let pwr;
        let pos;
        let i;
        this.NUM_SET_ZERO();
        pos = pwr = 5;
        while (data > 0) {
            this._data[pos--] = NUM_TYPE.toSByte(data % 100);
            data = Math.floor(data / 100);
        }
        if (pos < pwr) {
            if (pos > 0) {
                for (i = 0; i < pwr - pos; i++)
                    this._data[1 + i] = this._data[1 + pos + i];
                for (i = 0; i < pos; i++)
                    this._data[pwr - pos + 1 + i] = 0;
            }
            this._data[0] = NUM_TYPE.toSByte(pwr - pos + NUM_TYPE.EXP_BIAS);
        }
    }
    NUM_2_LONG() {
        if (this.NUM_IS_LONG())
            return this.NUM_LONG();
        else
            return this.num_2_long();
    }
    NUM_2_ULONG() {
        if (this.NUM_IS_LONG())
            return this.NUM_LONG();
        else
            return this.num_2_ulong();
    }
    num_2_long() {
        let slong;
        let sign;
        sign = this._data[0] & NUM_TYPE.SIGN_MASK;
        this._data[0] &= NUM_TYPE.toSByte(~NUM_TYPE.SIGN_MASK);
        if (sign !== 0) {
            if (NUM_TYPE.memcmp(this, 0, NUM_TYPE.MinLONG(), 0, this.SIGNIFICANT_NUM_SIZE) > 0)
                return 0;
        }
        else {
            if (NUM_TYPE.memcmp(this, 0, NUM_TYPE.MaxLONG(), 0, this.SIGNIFICANT_NUM_SIZE) > 0)
                return 0;
        }
        slong = this.num_2_ulong();
        if (sign !== 0) {
            slong = -slong;
            this._data[0] |= NUM_TYPE.toSByte(sign);
        }
        return (slong);
    }
    num_2_ulong() {
        let val;
        let pwr;
        let pos;
        let last;
        pwr = this._data[0] - NUM_TYPE.EXP_BIAS;
        if (pwr > 5)
            return (0);
        last = (pwr === 5);
        if (last)
            pwr = 4;
        val = 0;
        for (pos = 1; pos <= pwr; pos++)
            val = val * 100 + NUM_TYPE.toUByte(this._data[pos]);
        if (last)
            if (val <= Math.floor((0xFFFFFFFF - NUM_TYPE.toUByte(this._data[5])) / 100))
                val = val * 100 + NUM_TYPE.toUByte(this._data[5]);
            else
                val = 0;
        return (val);
    }
    static add_pos(num1, num2, operData) {
        let len1;
        let len2;
        let len;
        let pos;
        let num1ptr;
        let resptr;
        let i;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 == null || num2 == null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let res = new NUM_TYPE();
        if (operData.NUM_Exp2_ === 0 || (operData.NUM_Diff_ >= SIGNIFICANT_NUM_SIZE - 1)) {
            res = new NUM_TYPE(num1);
            res._data[0] = operData.NUM_Exp1_;
            return res;
        }
        len1 = 1;
        for (i = SIGNIFICANT_NUM_SIZE - 2; i > 0; i -= 2) {
            if (num1.SHRT_IS_ZERO(i))
                continue;
            else {
                len1 = i + 1;
                break;
            }
        }
        if (num1._data[len1] === 0)
            len1--;
        len2 = 1;
        for (i = SIGNIFICANT_NUM_SIZE - 2; i > 0; i -= 2) {
            if (num2.SHRT_IS_ZERO(i))
                continue;
            else {
                len2 = i + 1;
                break;
            }
        }
        if (num2._data[len2] === 0)
            len2--;
        if ((len = Math.max(len1, len2 + operData.NUM_Diff_)) > SIGNIFICANT_NUM_SIZE - 1)
            len = SIGNIFICANT_NUM_SIZE - 1;
        res.NUM_SET_ZERO();
        num1ptr = operData.NUM_Diff_;
        resptr = operData.NUM_Diff_;
        for (pos = len - operData.NUM_Diff_; pos > 0; pos--) {
            res._data[resptr + pos] =
                NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[resptr + pos]) + NUM_TYPE.toUByte(num1._data[num1ptr + pos]) + NUM_TYPE.toUByte(num2._data[pos]));
            if (NUM_TYPE.toUByte(res._data[resptr + pos]) >= 100) {
                res._data[resptr + pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[resptr + pos]) - 100);
                res._data[resptr + pos - 1] = 1;
            }
        }
        for (pos = operData.NUM_Diff_; pos > 0; pos--) {
            res._data[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[pos]) + NUM_TYPE.toUByte(num1._data[pos]));
            if (NUM_TYPE.toUByte(res._data[pos]) >= 100) {
                res._data[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[pos]) - 100);
                res._data[pos - 1] = 1;
            }
        }
        if (res._data[0] !== 0) {
            for (pos = Math.min(len, SIGNIFICANT_NUM_SIZE - 2); pos >= 0; pos--)
                res._data[pos + 1] = res._data[pos];
            operData.NUM_Exp1_++;
        }
        res._data[0] = operData.NUM_Exp1_;
        return res;
    }
    static sub_pos(num1, num2, operData) {
        let len1;
        let len2;
        let len;
        let pos;
        let num1ptr;
        let resptr;
        let i;
        let SIGNIFICANT_NUM_SIZE;
        if (num1 == null || num2 == null)
            return null;
        SIGNIFICANT_NUM_SIZE = GuiEnvironment.Environment.GetSignificantNumSize();
        let res = new NUM_TYPE();
        let j;
        if (operData.NUM_Exp2_ === 0 || (operData.NUM_Diff_ >= SIGNIFICANT_NUM_SIZE - 1)) {
            res = new NUM_TYPE(num1);
            res._data[0] = operData.NUM_Exp1_;
            return res;
        }
        len1 = 1;
        for (i = SIGNIFICANT_NUM_SIZE - 2; i > 0; i -= 2) {
            if (num1.SHRT_IS_ZERO(i))
                continue;
            else {
                len1 = i + 1;
                break;
            }
        }
        if (num1._data[len1] === 0)
            len1--;
        len2 = 1;
        for (i = SIGNIFICANT_NUM_SIZE - 2; i > 0; i -= 2) {
            if (num2.SHRT_IS_ZERO(i))
                continue;
            else {
                len2 = i + 1;
                break;
            }
        }
        if (num2._data[len2] === 0)
            len2--;
        if ((len = Math.max(len1, len2 + operData.NUM_Diff_)) > SIGNIFICANT_NUM_SIZE - 1)
            len = SIGNIFICANT_NUM_SIZE - 1;
        res.NUM_SET_ZERO();
        num1ptr = operData.NUM_Diff_;
        resptr = operData.NUM_Diff_;
        for (pos = len - operData.NUM_Diff_; pos > 0; pos--) {
            res._data[resptr + pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[resptr + pos]) + NUM_TYPE.toUByte(num1._data[num1ptr + pos]) - NUM_TYPE.toUByte(num2._data[pos]));
            if (res._data[resptr + pos] < 0) {
                res._data[resptr + pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[resptr + pos]) + 100);
                res._data[resptr + pos - 1] = NUM_TYPE.toSByte(0xFF);
            }
        }
        for (pos = operData.NUM_Diff_; pos > 0; pos--) {
            res._data[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[pos]) + NUM_TYPE.toUByte(num1._data[pos]));
            if (res._data[pos] < 0) {
                res._data[pos] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(res._data[pos]) + 100);
                res._data[pos - 1] = NUM_TYPE.toSByte(0xFF);
            }
        }
        while ((++pos <= len) && res._data[pos] === 0) {
        }
        if (pos <= len) {
            operData.NUM_Diff_ = pos - 1;
            if (operData.NUM_Diff_ > 0) {
                for (j = 0; j < len - operData.NUM_Diff_; j++)
                    res._data[1 + j] = res._data[pos + j];
                for (j = 0; j < operData.NUM_Diff_; j++)
                    res._data[len - operData.NUM_Diff_ + 1 + j] = 0;
            }
            res._data[0] = NUM_TYPE.toSByte(NUM_TYPE.toUByte(operData.NUM_Exp1_) - operData.NUM_Diff_);
        }
        return res;
    }
    num_fix(wholes) {
        let pwr;
        let num_diff;
        if (this.NUM_IS_LONG())
            this.num_4_std_long();
        pwr = (this._data[0] & ~NUM_TYPE.SIGN_MASK) - NUM_TYPE.EXP_BIAS;
        if ((num_diff = pwr - ((wholes + 1) >> 1)) < 0)
            return;
        if (num_diff < this.SIGNIFICANT_NUM_SIZE - 1) {
            if ((wholes & 1) === 1)
                this._data[1 + num_diff] = NUM_TYPE.toSByte(this._data[1 + num_diff] % 10);
            while ((num_diff < this.SIGNIFICANT_NUM_SIZE - 1) && this._data[1 + num_diff] === 0)
                num_diff++;
        }
        if (num_diff >= this.SIGNIFICANT_NUM_SIZE - 1) {
            this.NUM_ZERO();
            return;
        }
        if (num_diff > 0) {
            let i;
            for (i = 0; i < this.SIGNIFICANT_NUM_SIZE - 1 - num_diff; i++)
                this._data[1 + i] = this._data[1 + num_diff + i];
            for (i = 0; i < num_diff; i++)
                this._data[this.SIGNIFICANT_NUM_SIZE - num_diff + i] = 0;
            this._data[0] = NUM_TYPE.toSByte(this._data[0] - NUM_TYPE.toSByte(num_diff));
        }
    }
    SHRT_IS_ZERO(pos) {
        return this._data[pos] === 0 && this._data[pos + 1] === 0;
    }
    setZero(asLong) {
        let i;
        for (i = 0; i < NUM_TYPE.NUM_SIZE; i++)
            this._data[i] = 0;
        if (asLong)
            this._data[0] = NUM_TYPE.NUM_LONG_TYPE;
    }
    static memcmp(num1, pos1, num2, pos2, len) {
        let i = 0;
        while (i < len && num1._data[pos1] === num2._data[pos2] && pos1 < NUM_TYPE.NUM_SIZE && pos2 < NUM_TYPE.NUM_SIZE) {
            i++;
            pos1++;
            pos2++;
        }
        if (i === len)
            return 0;
        else if (this.toUByte(num1._data[pos1]) < this.toUByte(num2._data[pos2]))
            return -1;
        else
            return 1;
    }
    static toUByte(byteVal) {
        let val = byteVal;
        if (byteVal < 0)
            val = 256 + byteVal;
        return val;
    }
    static toSByte(unsignedVal) {
        let val = 0;
        if (unsignedVal > Constants.SByteMaxValue)
            val = (unsignedVal - 256);
        else
            val = unsignedVal;
        return val;
    }
    static MaxLONG() {
        let nUM_TYPE = new NUM_TYPE();
        nUM_TYPE._data[0] = NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5);
        nUM_TYPE._data[1] = 21;
        nUM_TYPE._data[2] = 47;
        nUM_TYPE._data[3] = 48;
        nUM_TYPE._data[4] = 36;
        nUM_TYPE._data[5] = 47;
        return nUM_TYPE;
    }
    static MinLONG() {
        let num = new NUM_TYPE();
        num._data[0] = NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5);
        num._data[1] = 21;
        num._data[2] = 47;
        num._data[3] = 48;
        num._data[4] = 36;
        num._data[5] = 48;
        return num;
    }
    to_double() {
        return this.storage_mg_2_float(8);
    }
    storage_mg_2_float(len) {
        let sign_pos;
        let sign;
        let compnum = new NUM_TYPE();
        let tmpnum = new NUM_TYPE();
        let divnum = new NUM_TYPE();
        let pwr;
        let bits;
        let exp;
        let long1 = 0;
        let long2 = 0;
        let fltOut = 0;
        let cout = new Int8Array([0, 0, 0, 0, 0, 0, 0, 0]);
        let Num2Pwr23_ = new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 8, 38, 86, 8]);
        let Num2Pwr52_ = new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 45, 3, 59, 96, 27, 37, 4, 96]);
        let base_Num16Pwrs = [
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 1]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 2), 2, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 2), 40, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 3), 6, 55, 36]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 1, 4, 85, 76]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 16, 77, 72, 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5), 2, 68, 43, 54, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5), 42, 94, 96, 72, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 6), 6, 87, 19, 47, 67, 36]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 7), 1, 9, 95, 11, 62, 77, 76]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 7), 17, 59, 21, 86, 4, 44, 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 2, 81, 47, 49, 76, 71, 6, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 45, 3, 59, 96, 27, 37, 4, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 9), 7, 20, 57, 59, 40, 37, 92, 79, 36])
        ];
        let base_Num2Pwrs = [
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 1]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 2]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 4]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 8])
        ];
        if (this.NUM_IS_LONG())
            this.num_4_std_long();
        if (this._data[0] === 0)
            return 0;
        sign = NUM_TYPE.toSByte(this._data[0] & NUM_TYPE.SIGN_MASK);
        this._data[0] = NUM_TYPE.toSByte(this._data[0] & (~NUM_TYPE.SIGN_MASK));
        if (len === 4) {
            bits = 24;
            compnum = new NUM_TYPE(Num2Pwr23_);
        }
        else {
            bits = 53;
            compnum = new NUM_TYPE(Num2Pwr52_);
        }
        pwr = (this._data[0] - NUM_TYPE.EXP_BIAS) << 1;
        if (pwr < 0)
            exp = pwr * 3 + Math.floor((pwr + 1) / 3);
        else
            exp = pwr * 3 + Math.floor((pwr + 2) / 3);
        pwr = bits - exp;
        if (pwr < 0) {
            pwr = -pwr;
            tmpnum = NUM_TYPE.div(this, new NUM_TYPE(base_Num16Pwrs[pwr >> 2]));
            tmpnum = NUM_TYPE.div(tmpnum, new NUM_TYPE(base_Num2Pwrs[pwr & 3]));
        }
        else {
            tmpnum = this;
            while (pwr >= 60) {
                tmpnum = NUM_TYPE.mul(tmpnum, new NUM_TYPE(base_Num16Pwrs[14]));
                pwr -= 56;
            }
            tmpnum = NUM_TYPE.mul(tmpnum, new NUM_TYPE(base_Num16Pwrs[pwr >> 2]));
            tmpnum = NUM_TYPE.mul(tmpnum, new NUM_TYPE(base_Num2Pwrs[pwr & 3]));
        }
        while (NUM_TYPE.num_cmp(tmpnum, compnum) < 0) {
            exp--;
            tmpnum = NUM_TYPE.add(tmpnum, tmpnum);
        }
        if (len === 4) {
            long1 = tmpnum.num_2_ulong();
        }
        else {
            divnum = NUM_TYPE.div(tmpnum, new NUM_TYPE(base_Num16Pwrs[8]));
            divnum.num_trunc(0);
            long1 = divnum.num_2_ulong();
            divnum = NUM_TYPE.mul(divnum, new NUM_TYPE(base_Num16Pwrs[8]));
            divnum = NUM_TYPE.sub(tmpnum, divnum);
            long2 = divnum.num_2_ulong();
        }
        sign_pos = len - 1;
        if (len === 4) {
            exp += 126;
            cout[3] = NUM_TYPE.toSByte(exp >> 1);
            cout[2] = NUM_TYPE.toSByte((this.LO_CHAR(this.HI_SHRT(long1)) & 0x7F) | ((exp & 0x01) << 7));
            cout[1] = NUM_TYPE.toSByte(this.HI_CHAR(this.LO_SHRT(long1)));
            cout[0] = NUM_TYPE.toSByte(this.LO_CHAR(this.LO_SHRT(long1)));
        }
        else {
            exp += 1022;
            cout[7] = NUM_TYPE.toSByte(exp >> 4);
            cout[6] = NUM_TYPE.toSByte((this.LO_CHAR(this.HI_SHRT(long1)) & 0x0F) | ((exp & 0x0F) << 4));
            cout[5] = NUM_TYPE.toSByte(this.HI_CHAR(this.LO_SHRT(long1)));
            cout[4] = NUM_TYPE.toSByte(this.LO_CHAR(this.LO_SHRT(long1)));
            cout[3] = NUM_TYPE.toSByte(this.HI_CHAR(this.HI_SHRT(long2)));
            cout[2] = NUM_TYPE.toSByte(this.LO_CHAR(this.HI_SHRT(long2)));
            cout[1] = NUM_TYPE.toSByte(this.HI_CHAR(this.LO_SHRT(long2)));
            cout[0] = NUM_TYPE.toSByte(this.LO_CHAR(this.LO_SHRT(long2)));
        }
        if (sign !== 0) {
            cout[sign_pos] |= NUM_TYPE.SIGN_MASK;
            this._data[0] |= NUM_TYPE.SIGN_MASK;
        }
        fltOut = this.sbyteArr_2_Double(cout);
        return fltOut;
    }
    LO_CHAR(n) {
        return n & 255;
    }
    HI_CHAR(n) {
        return (n & 65280) >> 8;
    }
    LO_SHRT(n) {
        return (n & 65535);
    }
    HI_SHRT(n) {
        return ((n & -65536) >> 16);
    }
    static MK_SHRT(c1, c2) {
        let strInt = (c1 << 8 | c2).toString();
        return NNumber.Parse(strInt);
    }
    static MK_LONG(s1, s2) {
        let l1 = s1;
        let l2 = s2;
        let strLng = (l1 << 16 | l2).toString();
        return NNumber.Parse(strLng);
    }
    sbyteArr_2_Double(array) {
        let dataview = new DataView(array.buffer);
        return dataview.getFloat64(0, true);
    }
    static double_2_sbyteArray(d) {
        let buffer = new ArrayBuffer(8);
        let dataview = new DataView(buffer);
        dataview.setFloat64(0, d, true);
        return (new Int8Array(dataview.buffer));
    }
    static eval_op_pwr(num1, num2) {
        let d0;
        let d1;
        if (num1 == null || num2 == null)
            return null;
        if (num2.NUM_IS_LONG() && !num2.num_is_neg()) {
            d1 = num2.to_double();
            let result = NUM_TYPE.from_double(1);
            for (let i = 0; i < d1; i++)
                result = this.mul(result, num1);
            return result;
        }
        else {
            d0 = num1.to_double();
            d1 = num2.to_double();
            if (d0 < 0.0 && d1 !== d1)
                d0 = 0.0;
            else if (d0 !== 0.0)
                d0 = Math.pow(d0, d1);
        }
        return NUM_TYPE.from_double(d0);
    }
    static from_double(d0) {
        let array = NUM_TYPE.double_2_sbyteArray(d0);
        return NUM_TYPE.storage_mg_4_float(8, array);
    }
    static storage_mg_4_float(len, inp) {
        let cinp;
        let sign;
        let tmp1;
        let exp;
        let bias;
        let long1;
        let long2;
        cinp = new Array(inp.length);
        for (tmp1 = 0; tmp1 < inp.length; tmp1++)
            cinp[tmp1] = NUM_TYPE.toUByte(inp[tmp1]);
        sign = cinp[len - 1];
        if (len === 4) {
            exp = ((cinp[2] >> 7) | ((cinp[3] & 0x7F) << 1));
            bias = 150;
            long1 = 0;
            long2 = NUM_TYPE.MK_LONG(NUM_TYPE.MK_SHRT(0, cinp[2] | 0x80), NUM_TYPE.MK_SHRT(cinp[1], cinp[0]));
        }
        else {
            exp = (((cinp[7] & 0x7F) << 4) | (cinp[6] >> 4));
            bias = 1075;
            long1 = NUM_TYPE.MK_LONG(NUM_TYPE.MK_SHRT(0, (cinp[6] & 0x0F) | 0x10), NUM_TYPE.MK_SHRT(cinp[5], cinp[4]));
            long2 = NUM_TYPE.MK_LONG(NUM_TYPE.MK_SHRT(cinp[3], cinp[2]), NUM_TYPE.MK_SHRT(cinp[1], cinp[0]));
        }
        return NUM_TYPE.storage_num_4_fld_flt(long1, long2, 18, sign, bias, exp);
    }
    static storage_num_4_fld_flt(long1, long2, dec, sign, bias, expr) {
        let base_Num16Pwrs = [
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 1]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 2), 2, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 2), 40, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 3), 6, 55, 36]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 1, 4, 85, 76]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 4), 16, 77, 72, 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5), 2, 68, 43, 54, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 5), 42, 94, 96, 72, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 6), 6, 87, 19, 47, 67, 36]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 7), 1, 9, 95, 11, 62, 77, 76]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 7), 17, 59, 21, 86, 4, 44, 16]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 2, 81, 47, 49, 76, 71, 6, 56]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 8), 45, 3, 59, 96, 27, 37, 4, 96]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 9), 7, 20, 57, 59, 40, 37, 92, 79, 36])
        ];
        let base_Num2Pwrs = [
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 1]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 2]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 4]),
            new Int8Array([NUM_TYPE.toSByte(NUM_TYPE.EXP_BIAS + 1), 8])
        ];
        let tmpnum = new NUM_TYPE();
        let outVal = new NUM_TYPE();
        let exp = expr;
        if (exp === 0) {
            outVal.NUM_ZERO();
            return outVal;
        }
        outVal.num_4_ulong(long2);
        if (long1 !== 0) {
            tmpnum.num_4_ulong(long1);
            tmpnum = NUM_TYPE.mul(tmpnum, new NUM_TYPE(base_Num16Pwrs[8]));
            outVal = NUM_TYPE.add(tmpnum, outVal);
        }
        exp = (exp - bias);
        if (exp < 0) {
            exp = -exp;
            while (exp >= 60) {
                outVal = NUM_TYPE.div(outVal, new NUM_TYPE(base_Num16Pwrs[14]));
                exp -= 56;
            }
            tmpnum = NUM_TYPE.mul(new NUM_TYPE(base_Num16Pwrs[exp >> 2]), new NUM_TYPE(base_Num2Pwrs[exp & 3]));
            outVal = NUM_TYPE.div(outVal, tmpnum);
        }
        else {
            if (exp >= 60) {
                outVal.NUM_ZERO();
                return outVal;
            }
            tmpnum = NUM_TYPE.mul(new NUM_TYPE(base_Num16Pwrs[exp >> 2]), new NUM_TYPE(base_Num2Pwrs[exp & 3]));
            outVal = NUM_TYPE.mul(outVal, tmpnum);
        }
        if ((sign & 0x80) !== 0)
            outVal._data[0] = outVal._data[0] | NUM_TYPE.SIGN_MASK;
        outVal.round(dec);
        return outVal;
    }
    static eval_op_log(val1) {
        if (val1 == null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        if (d > 0.0)
            resVal = NUM_TYPE.from_double(Math.log(d));
        else
            resVal.NUM_ZERO();
        return resVal;
    }
    static eval_op_exp(val1) {
        let resVal;
        if (val1 === null)
            return null;
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.exp(d));
        return resVal;
    }
    static eval_op_abs(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE(val1);
        resVal.num_abs();
        return resVal;
    }
    static eval_op_sin(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.sin(d));
        return resVal;
    }
    static eval_op_cos(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.cos(d));
        return resVal;
    }
    static eval_op_tan(val1) {
        if (val1 == null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.tan(d));
        return resVal;
    }
    static eval_op_asin(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        if (d <= 1.0 && d >= -1.0)
            resVal = NUM_TYPE.from_double(Math.asin(d));
        else
            resVal = NUM_TYPE.from_double(0.0);
        return resVal;
    }
    static eval_op_acos(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        if (d <= 1.0 && d >= -1.0)
            resVal = NUM_TYPE.from_double(Math.acos(d));
        else
            resVal = NUM_TYPE.from_double(0.0);
        return resVal;
    }
    static eval_op_atan(val1) {
        if (val1 === null)
            return null;
        let resVal = new NUM_TYPE();
        let d = val1.to_double();
        resVal = NUM_TYPE.from_double(Math.atan(d));
        return resVal;
    }
    num_abs() {
        let l;
        if (this.NUM_IS_LONG()) {
            l = this.NUM_LONG();
            if (l < 0)
                l = -l;
            this.NUM_4_LONG(l);
            return;
        }
        this._data[0] &= NUM_TYPE.toSByte(~NUM_TYPE.SIGN_MASK);
    }
    static eval_op_rand(val1) {
        if (val1 === null)
            return null;
        let rand_initialized = Randomizer.get_initialized();
        let rand_mod;
        let rand_mul;
        let rand_seed;
        let tmp_num = new NUM_TYPE();
        if (!rand_initialized) {
            Randomizer.set_initialized();
            rand_mod = new NUM_TYPE();
            rand_mul = new NUM_TYPE();
            rand_seed = new NUM_TYPE();
            rand_mod.num_4_a_std("100000007");
            rand_mul.num_4_a_std("75000007");
            rand_seed.num_4_a_std("12345678");
            Randomizer.set_mod(rand_mod.to_double());
            Randomizer.set_mul(rand_mul.to_double());
            Randomizer.set_seed(rand_seed.to_double());
        }
        else {
            rand_mod = NUM_TYPE.from_double(Randomizer.get_mod());
            rand_mul = NUM_TYPE.from_double(Randomizer.get_mul());
            rand_seed = NUM_TYPE.from_double(Randomizer.get_seed());
        }
        if (!val1.num_is_zero()) {
            if (val1.num_is_neg())
                rand_seed.NUM_4_LONG(NUM_TYPE.hash_rand());
            else
                rand_seed = new NUM_TYPE(val1);
        }
        else {
            if (rand_seed.num_is_neg()) {
                tmp_num.NUM_4_LONG(-1);
                rand_seed = NUM_TYPE.mul(rand_seed, tmp_num);
            }
        }
        rand_seed = NUM_TYPE.mul(rand_seed, rand_mul);
        rand_seed = NUM_TYPE.mod(rand_seed, rand_mod);
        tmp_num = NUM_TYPE.div(rand_seed, rand_mod);
        Randomizer.set_mod(rand_mod.to_double());
        Randomizer.set_mul(rand_mul.to_double());
        Randomizer.set_seed(rand_seed.to_double());
        return tmp_num;
    }
    static hash_rand() {
        return ((new Date().getMilliseconds()) ^ Math.random() * 12345678);
    }
}
NUM_TYPE.INT_ZERO_HEX = "00000000";
NUM_TYPE.NO_ROOM = -1;
NUM_TYPE.ZERO_FILL = -2;
NUM_TYPE.NUM_SIZE = 20;
NUM_TYPE.NUM_LONG_TYPE = -1;
NUM_TYPE.EXP_BIAS = 64;
NUM_TYPE.SIGN_MASK = -128;
class OperData {
    constructor() {
        this.NUM_Diff_ = 0;
        this.NUM_Exp1_ = 0;
        this.NUM_Exp2_ = 0;
    }
}

class MemoryUtil {
    static char_memset(charArray, pos, charToSet, len) {
        if (len <= 0)
            return;
        for (let i = 0; i < len; i = i + 1) {
            charArray[pos + i] = charToSet;
        }
    }
    static char_memcpy(to, pos1, from, pos2, len) {
        if (len <= 0)
            return;
        for (let i = 0; i < len; i = i + 1) {
            to[pos1 + i] = from[pos2 + i];
        }
    }
    static char_memmove(to, pos1, from, pos2, len) {
        if (len <= 0)
            return;
        let tmp = new Array(len);
        for (let i = 0; i < len; i = i + 1) {
            tmp[i] = from[pos2 + i];
        }
        for (let i = 0; i < len; i = i + 1) {
            to[pos1 + i] = tmp[i];
        }
    }
    static mem_trim(s, sPos, len) {
        let i;
        for (i = sPos + len - 1; len > 0 && i < s.length; i--, len--)
            if (s[i] !== " " && s[i] !== "\x0000")
                break;
        return len;
    }
}

class HebrewDate {
    static dateheb_year_is_leap(year) {
        year = year % HebrewDate.YEARS_PER_CYCLE;
        return (HebrewDate.DATEHEB_months_n[(year + 1)] - HebrewDate.DATEHEB_months_n[year] === 13);
    }
    static dateheb_days_in_month(month, leap, days_in_year) {
        let days_in_month = leap ? HebrewDate.DATEHEB_leap_days_in_month[month - 1] : HebrewDate.DATEHEB_norm_days_in_month[month - 1];
        if (leap)
            days_in_year = days_in_year - 30;
        switch (days_in_year) {
            case 353:
                if (month === HebrewDate.KISLEV)
                    days_in_month = 29;
                break;
            case 355:
                if (month === HebrewDate.HESHVAN)
                    days_in_month = 30;
                break;
        }
        return days_in_month;
    }
    static dateheb_year_start(year) {
        year = year - 1;
        let cycle = Math.floor(year / HebrewDate.YEARS_PER_CYCLE);
        year = year % HebrewDate.YEARS_PER_CYCLE;
        let months = cycle * HebrewDate.MONTHS_PER_CYCLE + HebrewDate.DATEHEB_months_n[year];
        let days = months * HebrewDate.MONTH_DAYS;
        let parts = months * HebrewDate.MONTH_EXTRA_PARTS + HebrewDate.CREATION_PARTS;
        days = days + Math.floor(parts / HebrewDate.PARTS_PER_DAY);
        parts = parts % HebrewDate.PARTS_PER_DAY;
        if (parts >= Math.floor(HebrewDate.PARTS_PER_DAY * 3 / 4)) {
            parts = 0;
            days = days + 1;
        }
        let dow = (days - 1 + HebrewDate.CREATION_DOW) % 7 + 1;
        if ((dow === 1) || (dow === 4) || (dow === 6)) {
            parts = 0;
            days = days + 1;
        }
        if (!HebrewDate.dateheb_year_is_leap(year)) {
            if (dow === 3 && parts >= (9 * HebrewDate.PARTS_PER_HOUR + 204))
                days = days + 2;
        }
        if (HebrewDate.dateheb_year_is_leap(year + HebrewDate.YEARS_PER_CYCLE - 1)) {
            if (dow === 2 && parts >= (15 * HebrewDate.PARTS_PER_HOUR + 589))
                days = days + 1;
        }
        return days;
    }
    static dateheb_4_d(date, day, month, year) {
        date = date + HebrewDate.DAYS_TIL_JESUS;
        let cycle = Math.floor(date / (HebrewDate.DAYS_PER_CYCLE + 1));
        let days = date % (HebrewDate.DAYS_PER_CYCLE + 1);
        year.value = cycle * HebrewDate.YEARS_PER_CYCLE;
        year.value = year.value + Math.floor(days / (HebrewDate.DAYS_PER_LEAP_YEAR + 1));
        let next_year_start;
        while (true) {
            next_year_start = HebrewDate.dateheb_year_start(year.value + 1);
            if (next_year_start >= date)
                break;
            year.value = year.value + 1;
        }
        let curr_year_start = HebrewDate.dateheb_year_start(year.value);
        day.value = date - curr_year_start;
        let days_in_year = next_year_start - curr_year_start;
        let leap = days_in_year > 355;
        let i;
        for (i = 1; i < 13; i = i + 1) {
            let days_in_month = HebrewDate.dateheb_days_in_month(i, leap, days_in_year);
            if (day.value <= days_in_month)
                break;
            day.value = day.value - days_in_month;
        }
        if (!leap || i <= HebrewDate.ADAR)
            month.value = i;
        else if (i === HebrewDate.ADAR + 1)
            month.value = HebrewDate.ADAR_B;
        else
            month.value = i - 1;
        return leap;
    }
    static dateheb_i_2_h(val, str, strPos, use_ending, quote) {
        let let_idx = 0;
        let len = 0;
        while (val > 0) {
            for (let_idx = HebrewDate.DATEHEB_letters.length; let_idx > 0; let_idx = let_idx - 1) {
                let letter = HebrewDate.DATEHEB_letters[let_idx - 1];
                if (val >= letter) {
                    val = val - letter;
                    str[strPos++] = String.fromCharCode(HebrewDate.ALEF.charCodeAt(0) + let_idx - 1);
                    len = len + 1;
                    break;
                }
            }
        }
        if (len > 0) {
            if (len >= 2) {
                if (str[strPos - 2] === 'י')
                    if (str[strPos - 1] === 'ה' || str[strPos - 1] === 'ו') {
                        str[strPos - 2] = String.fromCharCode(str[strPos - 2].charCodeAt(0) - 1);
                        str[strPos - 1] = str[strPos - 1] + '\u0001';
                    }
            }
            if (let_idx > 10 && use_ending) {
                if (HebrewDate.DATEHEB_letters[let_idx - 1] === HebrewDate.DATEHEB_letters[let_idx - 2]) {
                    str[strPos - 1] = String.fromCharCode(str[strPos - 1].charCodeAt(0) - 1);
                }
            }
            if (quote) {
                if (len === 1)
                    str[strPos] = '\'';
                else {
                    str[strPos] = str[strPos - 1];
                    str[strPos - 1] = '"';
                }
                len = len + 1;
            }
        }
        return len;
    }
    static dateheb_2_str(outStr, strPos, len, out_len, full_len, hyear, trim, use_ending) {
        let quote = len > full_len && outStr[strPos + full_len] === outStr[strPos];
        if (quote)
            full_len = full_len + 1;
        let heb_len = HebrewDate.dateheb_i_2_h(hyear % 1000, outStr, strPos, use_ending, quote);
        let rem_len = full_len - heb_len;
        if (rem_len > 0) {
            if (trim) {
                out_len.value = out_len.value - rem_len;
                let tmp_out_len = len - full_len;
                if (tmp_out_len > 0)
                    MemoryUtil.char_memcpy(outStr, strPos + heb_len, outStr, strPos + full_len, tmp_out_len);
                else
                    heb_len = full_len;
            }
            else {
                if (rem_len > outStr.length - strPos - heb_len)
                    rem_len = outStr.length - strPos - heb_len;
                MemoryUtil.char_memset(outStr, strPos + heb_len, ' ', rem_len);
                heb_len = full_len;
            }
        }
        return heb_len;
    }
    static GetLocalMonths() {
        let monthLen = HebrewDate.MONTH_LEN;
        if (HebrewDate._localMonths[0] === null) {
            let monthStr = Events.GetMessageString(MsgInterface.DATEHEB_MONTH_STR);
            if (monthStr !== null) {
                HebrewDate._localMonths[0] = "       ";
                for (let i = 1; i < HebrewDate._localMonths.length; i = i + 1)
                    HebrewDate._localMonths[i] = monthStr.substr((i - 1) * monthLen, i * monthLen - (i - 1) * monthLen);
            }
        }
        return HebrewDate._localMonths;
    }
    static GetLocalDows() {
        let dowLen = HebrewDate.DOW_LEN;
        if (HebrewDate._localDows[0] === null) {
            let dowsStr = Events.GetMessageString(MsgInterface.DATEHEB_DOW_STR);
            if (dowsStr !== null) {
                HebrewDate._localDows[0] = "     ";
                for (let i = 1; i < HebrewDate._localDows.length; i = i + 1)
                    HebrewDate._localDows[i] = dowsStr.substr((i - 1) * dowLen, i * dowLen - (i - 1) * dowLen);
            }
        }
        return HebrewDate._localDows;
    }
    static dateheb_h_2_i(str, len, pos) {
        let val;
        let has_1_to_9 = false;
        let has_10_to_90 = false;
        let has_100_to_300 = false;
        let cnt_400 = 0;
        let last_val = 1000;
        let let_val;
        for (val = 0; len > 0 && pos < str.length; pos++, len--)
            if (str[pos] >= HebrewDate.ALEF && str[pos] <= HebrewDate.TAV) {
                let_val = HebrewDate.DATEHEB_letters[(str[pos].charCodeAt(0) - HebrewDate.ALEF.charCodeAt(0))];
                if (let_val > last_val)
                    return 0;
                if (let_val === 400) {
                    if (cnt_400 === 2)
                        return 0;
                    cnt_400 = cnt_400 + 1;
                }
                else if (let_val >= 100) {
                    if (has_100_to_300)
                        return 0;
                    has_100_to_300 = true;
                }
                else if (let_val >= 10) {
                    if (has_10_to_90)
                        return 0;
                    has_10_to_90 = true;
                }
                else {
                    if (has_1_to_9) {
                        if (has_10_to_90 || last_val !== 9)
                            return 0;
                        if (let_val !== 6 && let_val !== 7)
                            return 0;
                    }
                    has_1_to_9 = true;
                }
                val = val + let_val;
                last_val = let_val;
            }
        return val;
    }
    static dateheb_2_d(year, month, day) {
        if (day === 0 && month === 0 && year === 0)
            return 0;
        if (day === 0 || month === 0 || year === 0)
            return 1000000000;
        let days_from_creation = HebrewDate.dateheb_year_start(year);
        let days_in_year = HebrewDate.dateheb_year_start(year + 1) - days_from_creation;
        let leap = days_in_year > 355;
        if (leap && month > HebrewDate.ADAR)
            if (month === HebrewDate.ADAR_B)
                month = HebrewDate.ADAR + 1;
            else
                month = month + 1;
        if (day > HebrewDate.dateheb_days_in_month(month, leap, days_in_year))
            return 1000000000;
        for (let i = 1; i < month; i = i + 1)
            days_from_creation = days_from_creation + HebrewDate.dateheb_days_in_month(i, leap, days_in_year);
        days_from_creation = days_from_creation + day;
        return Math.max(days_from_creation - HebrewDate.DAYS_TIL_JESUS, 0);
    }
}
HebrewDate.PARTS_PER_HOUR = 1080;
HebrewDate.HOURS_PER_DAY = 24;
HebrewDate.PARTS_PER_DAY = (HebrewDate.HOURS_PER_DAY * HebrewDate.PARTS_PER_HOUR);
HebrewDate.MONTH_DAYS = 29;
HebrewDate.MONTH_EXTRA_PARTS = (12 * HebrewDate.PARTS_PER_HOUR + 793);
HebrewDate.PARTS_PER_MONTH = (HebrewDate.MONTH_DAYS * HebrewDate.PARTS_PER_DAY + HebrewDate.MONTH_EXTRA_PARTS);
HebrewDate.MONTHS_PER_NORM_YEAR = 12;
HebrewDate.MONTHS_PER_LEAP_YEAR = 13;
HebrewDate.NORM_YEARS_PER_CYCLE = 12;
HebrewDate.LEAP_YEARS_PER_CYCLE = 7;
HebrewDate.YEARS_PER_CYCLE = (HebrewDate.NORM_YEARS_PER_CYCLE + HebrewDate.LEAP_YEARS_PER_CYCLE);
HebrewDate.MONTHS_PER_CYCLE = (HebrewDate.NORM_YEARS_PER_CYCLE * HebrewDate.MONTHS_PER_NORM_YEAR + HebrewDate.LEAP_YEARS_PER_CYCLE * HebrewDate.MONTHS_PER_LEAP_YEAR);
HebrewDate.PARTS_PER_LEAP_YEAR = (HebrewDate.MONTHS_PER_LEAP_YEAR * HebrewDate.PARTS_PER_MONTH);
HebrewDate.DAYS_PER_LEAP_YEAR = Math.floor(HebrewDate.PARTS_PER_LEAP_YEAR / HebrewDate.PARTS_PER_DAY);
HebrewDate.PARTS_PER_CYCLE = (HebrewDate.MONTHS_PER_CYCLE * HebrewDate.PARTS_PER_MONTH);
HebrewDate.DAYS_PER_CYCLE = Math.floor(HebrewDate.PARTS_PER_CYCLE / HebrewDate.PARTS_PER_DAY);
HebrewDate.CREATION_DOW = 2;
HebrewDate.CREATION_PARTS = (5 * HebrewDate.PARTS_PER_HOUR + 204);
HebrewDate.DAYS_TIL_JESUS = 1373428;
HebrewDate.HESHVAN = 2;
HebrewDate.KISLEV = 3;
HebrewDate.ADAR = 6;
HebrewDate.ADAR_B = 13;
HebrewDate.DATEHEB_letters = [
    1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 20, 20, 30, 40, 40, 50, 50, 60, 70,
    80, 80, 90, 90, 100, 200, 300, 400
];
HebrewDate.ALEF = 'א';
HebrewDate.TAV = 'ת';
HebrewDate.DATEHEB_months_n = [
    0, 12, 24, 37, 49, 61, 74, 86, 99, 111, 123, 136, 148, 160, 173, 185, 197, 210, 222,
    235
];
HebrewDate.DATEHEB_norm_days_in_month = [
    30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 0
];
HebrewDate.DATEHEB_leap_days_in_month = [
    30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 29, 30, 29
];
HebrewDate.MONTH_LEN = 5;
HebrewDate._localMonths = new Array(15);
HebrewDate.DOW_LEN = 5;
HebrewDate._localDows = new Array(8);

class DisplayConvertor {
    static get Instance() {
        if (DisplayConvertor._instance === null) {
            DisplayConvertor._instance = new DisplayConvertor();
        }
        return DisplayConvertor._instance;
    }
    constructor() {
        this._environment = null;
        this.DATECHAR = 0;
        this._environment = GuiEnvironment.Environment;
    }
    getNewDateBreakParams() {
        return new DateBreakParams();
    }
    getNewTimeBreakParams() {
        return new TimeBreakParams();
    }
    mg2disp(mgValue, rangeStr, pic, useNative, compIdxOrAlwaysFill, time_date_pic_Z_edtOrCompIdx, time_date_pic_Z_edtOrConvertCase, time_date_num_pic_Z_edt) {
        if (arguments.length === 6)
            return this.mg2disp_0(mgValue, rangeStr, pic, useNative, compIdxOrAlwaysFill, time_date_pic_Z_edtOrCompIdx);
        else if (arguments.length === 7)
            return this.mg2disp_1(mgValue, rangeStr, pic, useNative, compIdxOrAlwaysFill, time_date_pic_Z_edtOrCompIdx, time_date_pic_Z_edtOrConvertCase);
        else
            return this.mg2disp_2(mgValue, rangeStr, pic, useNative, compIdxOrAlwaysFill, time_date_pic_Z_edtOrCompIdx, time_date_pic_Z_edtOrConvertCase, time_date_num_pic_Z_edt);
    }
    mg2disp_0(mgValue, rangeStr, pic, useNative, compIdx, time_date_pic_Z_edt) {
        return this.mg2disp(mgValue, rangeStr, pic, useNative, false, compIdx, time_date_pic_Z_edt);
    }
    mg2disp_1(mgValue, rangeStr, pic, useNative, alwaysFill, compIdx, time_date_pic_Z_edt) {
        return this.mg2disp(mgValue, rangeStr, pic, useNative, alwaysFill, compIdx, false, time_date_pic_Z_edt);
    }
    mg2disp_2(mgValue, rangeStr, pic, useNative, alwaysFill, compIdx, convertCase, time_date_num_pic_Z_edt) {
        let str = "";
        let tmpRange = (rangeStr === null) ? "" : rangeStr;
        switch (pic.getAttr()) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                str = this.fromAlpha(mgValue, pic, tmpRange, alwaysFill, convertCase);
                break;
            case StorageAttribute.NUMERIC: {
                let newPic = pic.getUnformattedNumericPic();
                let dec = GuiEnvironment.Environment.GetDecimal();
                let thou = GuiEnvironment.Environment.GetThousands();
                GuiEnvironment.Environment.setDecimalSeparator('.');
                GuiEnvironment.Environment.setThousandsSeparator(',');
                str = this.fromNum(mgValue, newPic);
                GuiEnvironment.Environment.setDecimalSeparator(dec);
                GuiEnvironment.Environment.setThousandsSeparator(thou);
                if (newPic.getMaskChars() === 0 || !time_date_num_pic_Z_edt)
                    str = StrUtil.ltrim(str);
                if (useNative) {
                    if (str == "")
                        return null;
                    let dbl = Number(str);
                    return dbl;
                }
                else
                    return str;
            }
            case StorageAttribute.DATE: {
                if (useNative) {
                    let dt;
                    dt = this.fromMgDateToNativeDate(mgValue, pic, compIdx);
                    return dt;
                }
                else {
                    str = this.fromDate(mgValue, pic, compIdx, time_date_num_pic_Z_edt);
                    break;
                }
            }
            case StorageAttribute.TIME: {
                if (useNative) {
                    let dt;
                    dt = this.fromMgTimeToNativeTime(mgValue, pic);
                    return dt;
                }
                else {
                    str = this.fromTime(mgValue, pic, time_date_num_pic_Z_edt);
                    break;
                }
            }
            case StorageAttribute.BOOLEAN: {
                let logVal;
                logVal = this.fromMgLogicalToNativeLogical(mgValue);
                return logVal;
            }
            case StorageAttribute.BLOB:
                str = BlobType.getString(mgValue);
                break;
            case StorageAttribute.BLOB_VECTOR:
                str = mgValue;
                break;
        }
        return str;
    }
    disp2mg(dispValue, pic, compIdx, blobContentType) {
        let str = "";
        switch (pic.getAttr()) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                str = this.toAlpha(dispValue, pic);
                break;
            case StorageAttribute.NUMERIC:
                {
                    dispValue = String(dispValue);
                    let len = dispValue.length;
                    while (len > 0) {
                        if (!pic.picIsMask(len - 1) && dispValue[len - 1] !== (' '))
                            break;
                        len--;
                    }
                    if (dispValue.length > len)
                        dispValue = NString.Remove(dispValue, len, (dispValue.length - len));
                    if (pic.isNegative() && dispValue.trim().startsWith("-"))
                        dispValue = StrUtil.ltrim(dispValue);
                    let dec = GuiEnvironment.Environment.GetDecimal();
                    let thou = GuiEnvironment.Environment.GetThousands();
                    GuiEnvironment.Environment.setDecimalSeparator('.');
                    GuiEnvironment.Environment.setThousandsSeparator(',');
                    let newPic = pic.getUnformattedNumericPic();
                    str = this.toNum(dispValue, newPic, compIdx);
                    GuiEnvironment.Environment.setDecimalSeparator(dec);
                    GuiEnvironment.Environment.setThousandsSeparator(thou);
                }
                break;
            case StorageAttribute.DATE:
                {
                    let dt;
                    if (typeof dispValue === 'string')
                        dt = new Date(dispValue);
                    else
                        dt = dispValue;
                    str = this.fromNativeDateToMgDate(dt, pic);
                }
                break;
            case StorageAttribute.TIME:
                {
                    let dt;
                    if (typeof dispValue === 'string') {
                        dt = new Date();
                        if (dispValue !== null) {
                            dt.setHours(+String(dispValue).substr(0, 2));
                            dt.setMinutes(+String(dispValue).substr(0, 2));
                            if (String(dispValue).length > 5)
                                dt.setSeconds(+String(dispValue).substr(0, 2));
                        }
                    }
                    else
                        dt = dispValue;
                    str = this.fromNativeTimeToMgTime(dt);
                }
                break;
            case StorageAttribute.BOOLEAN:
                str = this.fromNativeLogicalToMgLogical(dispValue);
                break;
            case StorageAttribute.BLOB:
                str = BlobType.createFromString(dispValue, blobContentType);
                break;
        }
        return str;
    }
    fromNum(mgValue, pic) {
        let mgNum = new NUM_TYPE(mgValue);
        return mgNum.toDisplayValue(pic);
    }
    fromAlpha(dataStr, pic, rangeStr, alwaysFill, convertCase) {
        let len = pic.getMaskSize();
        let min_len = len;
        let maskStr = pic.getMask();
        let resStr;
        if (pic.getMaskChars() > 0) {
            resStr = this.win_data_cpy(NString.ToCharArray(maskStr), len, NString.ToCharArray(dataStr), pic.isAttrAlpha(), convertCase);
        }
        else {
            if (UtilStrByteMode.isLocaleDefLangDBCS() && pic.isAttrAlpha()) {
                let intDataStrLenB = UtilStrByteMode.lenB(dataStr);
                if (min_len > intDataStrLenB) {
                    min_len = intDataStrLenB;
                }
                resStr = UtilStrByteMode.leftB(dataStr, min_len);
            }
            else if (dataStr !== null) {
                if (min_len > dataStr.length) {
                    min_len = dataStr.length;
                }
                if (convertCase) {
                    resStr = this.win_data_cpy(NString.ToCharArray(maskStr), len, NString.ToCharArray(dataStr), pic.isAttrAlpha(), convertCase);
                }
                else {
                    resStr = dataStr.substr(0, min_len);
                }
            }
        }
        if (alwaysFill || (rangeStr !== null && rangeStr.length > 0 && resStr.length < len)) {
            let vd = new ValidationDetailsBase(rangeStr);
            let continuousRangeValues = vd.getContinuousRangeValues();
            let discreteRangeValues = vd.getDiscreteRangeValues();
            if (continuousRangeValues !== null || discreteRangeValues !== null) {
                resStr = this.fillAlphaByRange(continuousRangeValues, discreteRangeValues, resStr);
            }
        }
        return resStr;
    }
    caseConvertedChar(data, mask) {
        let ch;
        if (mask.charCodeAt(0) === PICInterface.PIC_U) {
            ch = data.toUpperCase();
        }
        else {
            if (mask.charCodeAt(0) === PICInterface.PIC_L) {
                ch = data.toLowerCase();
            }
            else {
                ch = data;
            }
        }
        return ch;
    }
    win_data_cpy(maskStr, maskLen, dataStr, isAttrAlpha, convertCase) {
        if (arguments.length === 4)
            return this.win_data_cpy_0(maskStr, maskLen, dataStr, isAttrAlpha);
        return this.win_data_cpy_1(maskStr, maskLen, dataStr, isAttrAlpha, convertCase);
    }
    win_data_cpy_0(maskStr, maskLen, dataStr, isAttrAlpha) {
        return this.win_data_cpy(maskStr, maskLen, dataStr, isAttrAlpha, false);
    }
    win_data_cpy_1(maskStr, maskLen, dataStr, isAttrAlpha, convertCase) {
        let maskIdx = 0;
        let dataIdx = 0;
        let resStr = new Array(maskLen);
        if (isAttrAlpha && UtilStrByteMode.isLocaleDefLangDBCS()) {
            let num2 = 0;
            while (maskIdx < maskLen && num2 < maskLen) {
                if (maskStr[maskIdx].charCodeAt(0) <= PICInterface.PIC_MAX_OP) {
                    if (dataIdx < dataStr.length) {
                        let strVal = NString.FromChars(dataStr, dataIdx, 1);
                        if (UtilStrByteMode.lenB(strVal) === 2) {
                            if (maskIdx + 1 < maskLen) {
                                if (maskStr[maskIdx + 1].charCodeAt(0) <= PICInterface.PIC_MAX_OP) {
                                    if (convertCase) {
                                        resStr[num2++] = this.caseConvertedChar(dataStr[dataIdx++], maskStr[maskIdx + 1]);
                                    }
                                    else {
                                        resStr[num2++] = dataStr[dataIdx++];
                                    }
                                    maskIdx = maskIdx + 1;
                                }
                                else {
                                    resStr[num2++] = ' ';
                                }
                            }
                            else {
                                resStr[num2++] = ' ';
                            }
                        }
                        else {
                            if (convertCase) {
                                resStr[num2++] = this.caseConvertedChar(dataStr[dataIdx++], maskStr[maskIdx + 1]);
                            }
                            else {
                                resStr[num2++] = dataStr[dataIdx++];
                            }
                        }
                    }
                    else {
                        resStr[num2++] = ' ';
                    }
                }
                else {
                    resStr[num2++] = maskStr[maskIdx];
                }
                maskIdx = maskIdx + 1;
            }
            return NString.FromChars(resStr).substr(0, num2);
        }
        while (maskIdx < maskLen) {
            if (maskStr[maskIdx].charCodeAt(0) <= PICInterface.PIC_MAX_OP) {
                if (dataIdx < dataStr.length) {
                    resStr[maskIdx] = dataStr[dataIdx];
                    if (convertCase) {
                        resStr[maskIdx] = this.caseConvertedChar(dataStr[dataIdx], maskStr[maskIdx]);
                    }
                    else {
                        resStr[maskIdx] = dataStr[dataIdx];
                    }
                    dataIdx = dataIdx + 1;
                }
                else {
                    resStr[maskIdx] = ' ';
                }
            }
            else {
                resStr[maskIdx] = maskStr[maskIdx];
            }
            maskIdx = maskIdx + 1;
        }
        return NString.FromChars(resStr);
    }
    fromDate(dataStr, pic, compIdx, time_date_pic_Z_edt) {
        let mask = pic.getMask();
        let maskSize = pic.getMaskSize();
        let date = new NUM_TYPE(dataStr).NUM_2_ULONG();
        return this.to_a_pic_datemode(mask, maskSize, date, pic, time_date_pic_Z_edt, false, compIdx);
    }
    fromTime(dataStr, pic, time_date_pic_Z_edt) {
        let mask = pic.getMask();
        let maskSize = pic.getMaskSize();
        let time = new NUM_TYPE(dataStr).NUM_2_ULONG();
        return this.time_2_a_pic(mask, maskSize, time, pic, time_date_pic_Z_edt, false);
    }
    fromMgDateToNativeDate(dataStr, pic, compIdx) {
        let date = new NUM_TYPE(dataStr).NUM_2_ULONG();
        let breakParams;
        breakParams = new DateBreakParams();
        this.date_break_datemode(breakParams, date, false, compIdx);
        if (breakParams.month > 0)
            breakParams.month = breakParams.month - 1;
        if (breakParams.year == 0 && breakParams.month == 0 && breakParams.day == 0)
            return null;
        let maskStr = pic.getMask();
        let outVal = NString.ToCharArray(maskStr);
        let len = pic.getMaskSize();
        let year = breakParams.year;
        let outIdx = 0;
        while (len > 0) {
            switch (outVal[outIdx].charCodeAt(0)) {
                case PICInterface.PIC_YY:
                    {
                        this.int_2_a(outVal, outIdx, 2, breakParams.year, '0');
                        let yearStr = NString.FromChars(outVal, outIdx, 2);
                        year = +yearStr;
                        outIdx += 2;
                        len -= 2;
                    }
                    break;
                case PICInterface.PIC_YYYY:
                    this.int_2_a(outVal, outIdx, 4, breakParams.year, '0');
                    let yearStr = NString.FromChars(outVal, outIdx, 4);
                    year = +yearStr;
                    outIdx += 4;
                    len -= 4;
                    break;
                default:
                    outIdx++;
                    len--;
                    break;
            }
        }
        let nativeDt = new Date(year, breakParams.month, breakParams.day);
        return nativeDt;
    }
    fromNativeDateToMgDateNumber(nativeDate, pic) {
        let numVal;
        let dateParams;
        let millenium = 0;
        let year = nativeDate.getFullYear();
        let day = nativeDate.getDate();
        let month = nativeDate.getMonth() + 1;
        if (pic.isHebrew()) {
            if (year > 0) {
                if (millenium === 0)
                    millenium = 5;
                year += millenium * 1000;
            }
            numVal = (HebrewDate.dateheb_2_d(year, month, day));
        }
        else {
            if (year === 0) {
                dateParams = this.date_sys();
                year = dateParams.year;
            }
            numVal = this.date_4_calender(year, month, day, 0, false);
        }
        return numVal;
    }
    fromNativeDateToMgDate(nativeDate, pic) {
        let mgNum = new NUM_TYPE();
        let numVal = nativeDate == null ? 0 : this.fromNativeDateToMgDateNumber(nativeDate, pic);
        mgNum.NUM_4_LONG(numVal);
        return mgNum.toXMLrecord();
    }
    to_a_pic_datemode(outStr, out_len, date, pic, date_pic_Z_edt, ignore_dt_fmt, compIdx) {
        let len;
        let day = 0;
        let doy = 0;
        let dow = 0;
        let year = 0;
        let month = 0;
        let hday = 0;
        let hyear = 0;
        let hmonth = 0;
        let leap = false;
        let i;
        let p;
        let outVal = NString.ToCharArray(outStr);
        let breakParams;
        let dateNameParams;
        let outIdx = 0;
        let strOut = null;
        if (pic.getMaskSize() > out_len) {
            for (; i < out_len; i++)
                outVal[i] = '*';
            return NString.FromChars(outVal);
        }
        out_len = len = pic.getMaskSize();
        if (pic.zeroFill() && date === 0 && !date_pic_Z_edt) {
            for (; i < out_len; i++)
                outVal[i] = pic.getZeroPad();
            return NString.FromChars(outVal);
        }
        if (pic.isHebrew() && (date === 0 || date === 1000000000)) {
            for (; i < out_len; i++)
                outVal[i] = ' ';
            return NString.FromChars(outVal);
        }
        breakParams = new DateBreakParams(year, month, day, doy, dow);
        this.date_break_datemode(breakParams, date, ignore_dt_fmt, compIdx);
        if (pic.isHebrew()) {
            let refhday = new RefParam(hday);
            let refhmonth = new RefParam(hmonth);
            let refhyear = new RefParam(hyear);
            leap = HebrewDate.dateheb_4_d(date, refhday, refhmonth, refhyear);
            hday = refhday.value;
            hmonth = refhmonth.value;
            hyear = refhyear.value;
        }
        year = breakParams.year;
        month = breakParams.month;
        day = breakParams.day;
        doy = breakParams.doy;
        dow = breakParams.dow;
        breakParams = null;
        while (len > 0) {
            let refOutLen = new RefParam(out_len);
            switch (outVal[outIdx].charCodeAt(0)) {
                case PICInterface.PIC_YY:
                    if (pic.zeroFill() && date === 0 && date_pic_Z_edt)
                        MemoryUtil.char_memset(outVal, outIdx, pic.getZeroPad(), 2);
                    else
                        this.int_2_a(outVal, outIdx, 2, year, '0');
                    outIdx += 2;
                    len -= 2;
                    break;
                case PICInterface.PIC_HYYYYY:
                    i = HebrewDate.dateheb_2_str(outVal, outIdx, len, refOutLen, 5, hyear, pic.isTrimed(), true);
                    out_len = refOutLen.value;
                    outIdx += i;
                    len -= i;
                    break;
                case PICInterface.PIC_HL:
                    i = HebrewDate.dateheb_i_2_h((hyear / 1000) % 10, outVal, outIdx, false, false);
                    outIdx++;
                    len--;
                    break;
                case PICInterface.PIC_HDD:
                    i = HebrewDate.dateheb_2_str(outVal, outIdx, len, refOutLen, 2, hday, pic.isTrimed(), false);
                    out_len = refOutLen.value;
                    outIdx += i;
                    len -= i;
                    break;
                case PICInterface.PIC_YYYY:
                    if (pic.zeroFill() && date === 0 && date_pic_Z_edt)
                        MemoryUtil.char_memset(outVal, outIdx, pic.getZeroPad(), 4);
                    else
                        this.int_2_a(outVal, outIdx, 4, year, '0');
                    outIdx += 4;
                    len -= 4;
                    break;
                case PICInterface.PIC_MMD:
                    if (pic.zeroFill() && date === 0 && date_pic_Z_edt)
                        MemoryUtil.char_memset(outVal, outIdx, pic.getZeroPad(), 2);
                    else
                        this.int_2_a(outVal, outIdx, 2, month, '0');
                    outIdx += 2;
                    len -= 2;
                    break;
                case PICInterface.PIC_MMM:
                    if (pic.isHebrew()) {
                        if (leap && hmonth === 6)
                            hmonth = 14;
                        let monthNames = HebrewDate.GetLocalMonths();
                        p = NString.ToCharArray(monthNames[hmonth]);
                    }
                    else {
                        let monthStr = Events.GetMessageString(MsgInterface.MONTHS_PTR);
                        let monthNames = DateUtil.getLocalMonths(monthStr);
                        p = NString.ToCharArray(monthNames[month]);
                    }
                    dateNameParams = new DateNameParams(outVal, outIdx, len);
                    out_len -= this.date_i_2_nm(dateNameParams, p, pic.isTrimed());
                    outIdx = dateNameParams.outIdx;
                    len = dateNameParams.len;
                    dateNameParams = null;
                    break;
                case PICInterface.PIC_DD:
                    let isZero = pic.zeroFill();
                    if (isZero && date === 0 && date_pic_Z_edt)
                        MemoryUtil.char_memset(outVal, outIdx, pic.getZeroPad(), 2);
                    else
                        this.int_2_a(outVal, outIdx, 2, day, '0');
                    outIdx += 2;
                    len -= 2;
                    break;
                case PICInterface.PIC_DDD:
                    if (pic.zeroFill() && date === 0 && date_pic_Z_edt)
                        MemoryUtil.char_memset(outVal, outIdx, pic.getZeroPad(), 3);
                    else
                        this.int_2_a(outVal, outIdx, 3, doy, '0');
                    len -= 3;
                    outIdx += 3;
                    break;
                case PICInterface.PIC_DDDD:
                    i = this.date_2_DDDD(day, outVal, outIdx, len, pic.isTrimed());
                    outIdx += i;
                    out_len += i - 4;
                    len -= 4;
                    break;
                case PICInterface.PIC_W:
                    if (pic.zeroFill() && date === 0 && date_pic_Z_edt)
                        MemoryUtil.char_memset(outVal, outIdx, pic.getZeroPad(), 1);
                    else
                        this.int_2_a(outVal, outIdx, 1, dow, '0');
                    len--;
                    outIdx++;
                    break;
                case PICInterface.PIC_WWW:
                    if (pic.isHebrew()) {
                        let dowsNames = HebrewDate.GetLocalDows();
                        p = NString.ToCharArray(dowsNames[dow]);
                    }
                    else {
                        let dayStr = Events.GetMessageString(MsgInterface.DAYS_PTR);
                        let dayNames = DateUtil.getLocalDays(dayStr);
                        p = NString.ToCharArray(dayNames[dow]);
                    }
                    dateNameParams = new DateNameParams(outVal, outIdx, len);
                    out_len -= this.date_i_2_nm(dateNameParams, p, pic.isTrimed());
                    outIdx = dateNameParams.outIdx;
                    len = dateNameParams.len;
                    dateNameParams = null;
                    break;
                case PICInterface.PIC_BB:
                    p = NString.ToCharArray(UtilDateJpn.getStrDow(dow));
                    strOut = null;
                    dateNameParams = new DateNameParams(outVal, outIdx, len);
                    strOut = this.date_i_2_nm_bytemode(strOut, dateNameParams, NString.FromChars(p), out_len);
                    outVal = new Array(strOut.length);
                    NString.CopyTo(strOut, 0, outVal, 0, strOut.length);
                    outIdx = dateNameParams.outIdx;
                    len = dateNameParams.len;
                    strOut = null;
                    dateNameParams = null;
                    break;
                case PICInterface.PIC_JY1:
                case PICInterface.PIC_JY2:
                case PICInterface.PIC_JY4:
                    let strNum = null;
                    if (outVal[outIdx].charCodeAt(0) === PICInterface.PIC_JY1)
                        strNum = UtilDateJpn.getInstance().date_jpn_yr_2_a(year, doy, false);
                    else
                        strNum = UtilDateJpn.getInstance().date_jpn_yr_2_a(year, doy, true);
                    strOut = null;
                    dateNameParams = new DateNameParams(outVal, outIdx, len);
                    strOut = this.date_i_2_nm_bytemode(strOut, dateNameParams, strNum, out_len);
                    outVal = null;
                    outVal = new Array(strOut.length);
                    NString.CopyTo(strOut, 0, outVal, 0, strOut.length);
                    outIdx = dateNameParams.outIdx;
                    len = dateNameParams.len;
                    strOut = null;
                    dateNameParams = null;
                    break;
                case PICInterface.PIC_YJ:
                    if (pic.zeroFill() && date === 0 && date_pic_Z_edt)
                        MemoryUtil.char_memset(outVal, outIdx, pic.getZeroPad(), 2);
                    else
                        this.int_2_a(outVal, outIdx, 2, UtilDateJpn.getInstance().date_jpn_year_ofs(year, doy), '0');
                    outIdx += 2;
                    len -= 2;
                    break;
                default:
                    outIdx++;
                    len--;
                    break;
            }
        }
        if (out_len < outVal.length)
            MemoryUtil.char_memset(outVal, out_len, ' ', outVal.length - out_len);
        return NString.FromChars(outVal);
    }
    date_break_datemode(breakParams, date, ignore_dt_fmt, compIdx) {
        let year = breakParams.year;
        let month = breakParams.month;
        let day = breakParams.day;
        let doy = breakParams.doy;
        let dow = breakParams.dow;
        if (date <= 0) {
            breakParams.day = 0;
            breakParams.doy = 0;
            breakParams.dow = 0;
            breakParams.year = 0;
            breakParams.month = 0;
        }
        else {
            dow = date % 7 + 1;
            date = date - 1;
            let cent4 = Math.floor(date / PICInterface.DAYSINFOURCENT);
            date = date - cent4 * PICInterface.DAYSINFOURCENT;
            let cent = Math.floor(date / PICInterface.DAYSINCENTURY);
            if (cent > 3) {
                cent = 3;
            }
            date = date - cent * PICInterface.DAYSINCENTURY;
            let year4 = Math.floor(date / PICInterface.DAYSINFOURYEAR);
            date = date - year4 * PICInterface.DAYSINFOURYEAR;
            year = Math.floor(date / PICInterface.DAYSINYEAR);
            if (year > 3) {
                year = 3;
            }
            date = date - year * PICInterface.DAYSINYEAR;
            year = cent4 * 400 + cent * 100 + year4 * 4 + year + 1;
            let leapyear = 0;
            if (year % 4 === 0) {
                if (year % 100 !== 0 || year % 400 === 0) {
                    leapyear = 1;
                }
            }
            if (!ignore_dt_fmt && this._environment.GetDateMode(compIdx) === 'B') {
                year = year + PICInterface.DATE_BUDDHIST_GAP;
            }
            month = (Math.floor(date / PICInterface.DAYSINMONTH) + 1);
            day = PICInterface.date_day_tab[month];
            if (leapyear > 0) {
                if (month > 1) {
                    day = day + 1;
                }
            }
            if (date >= day) {
                month = month + 1;
            }
            else {
                day = PICInterface.date_day_tab[month - 1];
                if (leapyear > 0) {
                    if (month > 2) {
                        day = day + 1;
                    }
                }
            }
            day = date - day + 1;
            doy = date + 1;
            breakParams.year = year;
            breakParams.month = month;
            breakParams.day = day;
            breakParams.doy = doy;
            breakParams.dow = dow;
        }
    }
    int_2_a(str, strPos, len, n, lead) {
        let neg = n < 0;
        if (len <= 0)
            return;
        n = Math.abs(n);
        let pos = len;
        do {
            str[strPos + (pos = pos - 1)] = String.fromCharCode(48 + n % 10);
            n = Math.floor(n / 10);
        } while (pos > 0 && n > 0);
        if (neg && pos > 0) {
            str[strPos + (pos = pos - 1)] = '-';
        }
        return this.lib_a_fill(str, strPos, len, pos, lead.charCodeAt(0));
    }
    lib_a_fill(str, strPos, len, pos, lead) {
        if (lead === 0) {
            len = len - pos;
            if (len > 0 && pos > 0) {
                MemoryUtil.char_memcpy(str, strPos, str, pos, len);
                MemoryUtil.char_memset(str, strPos + len, ' ', pos);
            }
        }
        else {
            if (pos > 0) {
                MemoryUtil.char_memset(str, strPos, String.fromCharCode(lead), pos);
            }
        }
        return len;
    }
    date_i_2_nm(dateNameParams, nm, trim) {
        let n = this.date_msk_cnt(dateNameParams.outVal, dateNameParams.outIdx, dateNameParams.len);
        let l;
        if (trim) {
            l = MemoryUtil.mem_trim(nm, 0, n);
        }
        else {
            l = n;
        }
        l = Math.min(l, dateNameParams.len);
        MemoryUtil.char_memcpy(dateNameParams.outVal, dateNameParams.outIdx, nm, 0, l);
        dateNameParams.outIdx = dateNameParams.outIdx + l;
        dateNameParams.len = dateNameParams.len - n;
        n = n - l;
        if (n > 0) {
            MemoryUtil.char_memcpy(dateNameParams.outVal, dateNameParams.outIdx, dateNameParams.outVal, dateNameParams.outIdx + n, dateNameParams.len);
        }
        return n;
    }
    date_i_2_nm_bytemode(strOut, dateNameParams, strNm, intOutLen) {
        let intMskCnt = this.date_msk_cnt(dateNameParams.outVal, dateNameParams.outIdx, dateNameParams.len);
        let strWork = NString.FromChars(dateNameParams.outVal);
        strWork = strWork.substr(0, dateNameParams.outIdx);
        let intOfs = UtilStrByteMode.lenB(strWork);
        strNm = UtilStrByteMode.leftB(strNm, intMskCnt);
        strOut = UtilStrByteMode.repB(NString.FromChars(dateNameParams.outVal), strNm, intOfs + 1, intMskCnt);
        dateNameParams.outIdx = dateNameParams.outIdx + strNm.length;
        dateNameParams.len = dateNameParams.len - intMskCnt;
        intOutLen = intOutLen - intMskCnt;
        return strOut;
    }
    date_msk_cnt(msk, mskPos, len) {
        let c = msk[mskPos++];
        let i = 1;
        while (i < len) {
            if (msk[mskPos] !== c) {
                break;
            }
            mskPos = mskPos + 1;
            i = i + 1;
        }
        return i;
    }
    date_2_DDDD(day, outVal, outIdx, len, trim) {
        let ret = 4;
        let ext;
        if (day > 9) {
            this.int_2_a(outVal, outIdx, 2, day, 0..toString());
            outIdx += 2;
        }
        else {
            if (trim) {
                MemoryUtil.char_memcpy(outVal, outIdx, outVal, outIdx + 1, len - 1);
                ret--;
            }
            else {
                outVal[outIdx++] = ' ';
            }
            this.int_2_a(outVal, outIdx, 1, day, 0..toString());
            outIdx++;
        }
        switch (day) {
            case 1:
            case 21:
            case 31:
                ext = NString.ToCharArray("st");
                break;
            case 2:
            case 22:
                ext = NString.ToCharArray("nd");
                break;
            case 3:
            case 23:
                ext = NString.ToCharArray("rd");
                break;
            default:
                ext = NString.ToCharArray("th");
                break;
        }
        outVal[outIdx++] = ext[0];
        outVal[outIdx] = ext[1];
        return (ret);
    }
    fromMgTimeToNativeTime(dataStr, pic) {
        let time = new NUM_TYPE(dataStr).NUM_2_ULONG();
        let breakParams = new TimeBreakParams();
        DisplayConvertor.time_break(breakParams, time);
        let nativeDt = new Date(0);
        let maskStr = pic.getMask();
        let outVal = NString.ToCharArray(maskStr);
        let len = pic.getMaskSize();
        let outIdx = 0;
        while (len > 0) {
            switch (outVal[outIdx].charCodeAt(0)) {
                case (PICInterface.PIC_HH):
                    nativeDt.setHours(breakParams.hour);
                    outIdx += 2;
                    len -= 2;
                    break;
                case (PICInterface.PIC_MMT):
                    nativeDt.setMinutes(breakParams.minute);
                    outIdx += 2;
                    len -= 2;
                    break;
                case (PICInterface.PIC_SS):
                    nativeDt.setSeconds(breakParams.second);
                    outIdx += 2;
                    len -= 2;
                    break;
                default:
                    outIdx++;
                    len--;
            }
        }
        return nativeDt;
    }
    time_2_a_pic(AsciiStr, AsciiL, time, pic, time_pic_Z_edt, milliSeconds) {
        let hour = 0;
        let minute = 0;
        let second = 0;
        let millisec = 0;
        let Ascii = NString.ToCharArray(AsciiStr);
        let breakParams = new TimeBreakParams(hour, minute, second);
        let timeSec;
        if (milliSeconds) {
            timeSec = Math.floor(time / 1000);
            millisec = time - timeSec * 1000;
        }
        else {
            timeSec = time;
        }
        DisplayConvertor.time_break(breakParams, timeSec);
        hour = breakParams.hour;
        minute = breakParams.minute;
        second = breakParams.second;
        let result;
        if (pic.getMaskSize() > AsciiL) {
            MemoryUtil.char_memset(Ascii, 0, '*', AsciiL);
            result = NString.FromChars(Ascii);
        }
        else {
            if (pic.zeroFill()) {
                if (timeSec === 0 && (!milliSeconds || millisec === 0)) {
                    if (time_pic_Z_edt) {
                        for (let intx = 0; intx < pic.getMaskSize(); intx = intx + 1) {
                            if (Ascii[intx] <= '\u001f') {
                                Ascii[intx] = pic.getZeroPad();
                            }
                        }
                        result = NString.FromChars(Ascii);
                        return result;
                    }
                    MemoryUtil.char_memset(Ascii, 0, pic.getZeroPad(), pic.getMaskSize());
                    result = NString.FromChars(Ascii);
                    return result;
                }
            }
            let I = 0;
            let am = 0;
            let len = pic.getMaskSize();
            let HourI = -1;
            while (I < len) {
                switch (Ascii[I].charCodeAt(0)) {
                    case (PICInterface.PIC_HH):
                        HourI = I;
                        I += 2;
                        break;
                    case (PICInterface.PIC_MMT):
                        this.int_2_a(Ascii, I, 2, minute, '0');
                        I += 2;
                        break;
                    case (PICInterface.PIC_SS):
                        this.int_2_a(Ascii, I, 2, second, '0');
                        I += 2;
                        break;
                    case (PICInterface.PIC_MS):
                        this.int_2_a(Ascii, I, 3, millisec, '0');
                        I += 3;
                        break;
                    case (PICInterface.PIC_PM):
                        am = 1;
                        let tmpHour = hour % 24;
                        if (tmpHour < 12 || tmpHour === 0)
                            MemoryUtil.char_memcpy(Ascii, I, NString.ToCharArray("am"), 0, 2);
                        else
                            MemoryUtil.char_memcpy(Ascii, I, NString.ToCharArray("pm"), 0, 2);
                        I += 2;
                        break;
                    default:
                        I++;
                        break;
                }
            }
            if (HourI >= 0) {
                if (am > 0) {
                    hour = hour % 24;
                    if (hour === 0) {
                        hour = 12;
                    }
                    else {
                        hour = hour % 12;
                        if (hour === 0) {
                            hour = 12;
                        }
                    }
                }
                this.int_2_a(Ascii, HourI, 2, hour, (am !== 0 && hour < 10) ? ' ' : '0');
            }
            result = NString.FromChars(Ascii);
        }
        return result;
    }
    static time_break(breakParams, time) {
        if (time <= 0) {
            breakParams.second = 0;
            breakParams.minute = 0;
            breakParams.hour = 0;
        }
        else {
            breakParams.hour = Math.floor(time / 3600);
            time = time - breakParams.hour * 3600;
            breakParams.minute = Math.floor(time / 60);
            breakParams.second = time - breakParams.minute * 60;
        }
    }
    fromMgLogicalToNativeLogical(dataStr) {
        let nativeVal;
        nativeVal = (dataStr.charAt(0) === '1') ? true : false;
        return nativeVal;
    }
    fromNativeLogicalToMgLogical(dispVal) {
        let mgVal;
        mgVal = (dispVal === true) ? "1" : "0";
        return mgVal;
    }
    win_rng_bool(rng) {
        if (rng === null || rng.length === 0) {
            rng = "True, False";
        }
        return rng;
    }
    toNum(dispValue, pic, compIdx) {
        let mgNum = new NUM_TYPE(dispValue, pic, compIdx);
        return mgNum.toXMLrecord();
    }
    a_2_date_pic_datemode(str, str_len, pic, mask, compIdx) {
        let pos = 0;
        let year_in_pic = false;
        let month_in_pic = false;
        let day_in_pic = false;
        let inp = false;
        let bYearIsZero = false;
        let era_year = 0;
        let intRef = new IntRef(0);
        let intPicIdxOfs = 0;
        let millenium = 0;
        let dateParams;
        let len = Math.min(str.length, pic.getMaskSize());
        if (str.length < mask.length)
            str.length = mask.length;
        let year = 0;
        let month = 1;
        let day = 1;
        let doy = 1;
        let usedoy = false;
        let i;
        for (i = 0; i < str_len; i = i + 1) {
            if (str[i] !== '0' && str[i] !== ' ') {
                break;
            }
        }
        if (i === str_len)
            return 0;
        while (pos < str_len && pos + intPicIdxOfs < len) {
            switch (mask[pos + intPicIdxOfs].charCodeAt(0)) {
                case PICInterface.PIC_YY:
                    year_in_pic = true;
                    inp = true;
                    year = this.date_a_2_i(str, 2, pos);
                    pos += 2;
                    if (year === 0)
                        bYearIsZero = true;
                    let century_year = this._environment.GetCentury(compIdx) % 100;
                    if (year < century_year)
                        year += 100;
                    year += this._environment.GetCentury(compIdx) - century_year;
                    if (this._environment.GetDateMode(compIdx) === 'B')
                        year -= PICInterface.DATE_BUDDHIST_GAP;
                    break;
                case (PICInterface.PIC_YYYY):
                    year_in_pic = true;
                    inp = true;
                    let YearDigitsNo;
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        for (YearDigitsNo = 0; YearDigitsNo < 4 && pos + YearDigitsNo < str.length && UtilStrByteMode.isDigit(str[pos + YearDigitsNo]); YearDigitsNo++) {
                        }
                        i = YearDigitsNo;
                    }
                    else {
                        for (i = 0; pos + i < str.length && str[pos + i] !== this.DATECHAR.toString() && i < 4; i++) {
                        }
                        for (YearDigitsNo = 0; pos + YearDigitsNo < str.length && UtilStrByteMode.isDigit(str[pos + YearDigitsNo]) &&
                            YearDigitsNo < 4; YearDigitsNo++) {
                        }
                    }
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        if (i < 4 && str.length < mask.length)
                            this.move_date(str, pos, 4 - i, str.length);
                    }
                    else {
                        if (i < 4 && len < mask.length) {
                            this.move_date(str, pos, 4 - i, len);
                            len = len + 4 - i;
                        }
                    }
                    year = this.date_a_2_i(str, 4, pos);
                    pos += 4;
                    if (year === 0)
                        bYearIsZero = true;
                    if (YearDigitsNo <= 2) {
                        century_year = this._environment.GetCentury(compIdx) % 100;
                        if (year < century_year)
                            year += 100;
                        year += this._environment.GetCentury(compIdx) - century_year;
                    }
                    if (this._environment.GetDateMode(compIdx) === 'B')
                        year -= PICInterface.DATE_BUDDHIST_GAP;
                    break;
                case PICInterface.PIC_HYYYYY:
                    inp = true;
                    let quotes = 0;
                    if (len > pos + 5 && mask[pos + 5].charCodeAt(0) === (PICInterface.PIC_HYYYYY))
                        quotes = 1;
                    year = HebrewDate.dateheb_h_2_i(str, 5 + quotes, pos);
                    pos += 5 + quotes;
                    if (year === 0)
                        bYearIsZero = true;
                    break;
                case PICInterface.PIC_HL:
                    intPicIdxOfs = HebrewDate.dateheb_h_2_i(str, 1, pos);
                    pos++;
                    break;
                case PICInterface.PIC_HDD:
                    inp = true;
                    quotes = 0;
                    if (len > pos + 2 && mask[pos + 2].charCodeAt(0) === PICInterface.PIC_HDD)
                        quotes = 1;
                    day = HebrewDate.dateheb_h_2_i(str, 2 + quotes, pos);
                    pos += 2 + quotes;
                    break;
                case PICInterface.PIC_MMD:
                    inp = true;
                    month_in_pic = true;
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        if ((str.length === pos + 1 || str[pos + 1].charCodeAt(0) === this.DATECHAR || !UtilStrByteMode.isDigit(str[pos + 1])) && str.length < mask.length)
                            this.move_date(str, pos, 1, str.length);
                    }
                    else {
                        if (str[pos + 1].charCodeAt(0) === this.DATECHAR && len < mask.length) {
                            this.move_date(str, pos, 1, len);
                            len += 1;
                        }
                    }
                    month = this.date_a_2_i(str, 2, pos);
                    pos += 2;
                    break;
                case PICInterface.PIC_MMM:
                    inp = true;
                    month_in_pic = true;
                    intRef.val = pos;
                    month = this.date_MMM_2_m(str, mask, intRef, len, pic.isHebrew());
                    pos = intRef.val;
                    if (pic.isHebrew() && month === 14)
                        month = 6;
                    break;
                case (PICInterface.PIC_DD):
                    inp = true;
                    day_in_pic = true;
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        if ((str.length === pos + 1 || str[pos + 1].charCodeAt(0) === this.DATECHAR || !UtilStrByteMode.isDigit(str[pos + 1])) && str.length < mask.length)
                            this.move_date(str, pos, 1, str.length);
                    }
                    else {
                        if (str[pos + 1].charCodeAt(0) === this.DATECHAR && len < mask.length) {
                            this.move_date(str, pos, 1, len);
                            len += 1;
                        }
                    }
                    day = this.date_a_2_i(str, 2, pos);
                    pos += 2;
                    break;
                case (PICInterface.PIC_DDD):
                    inp = true;
                    usedoy = true;
                    day_in_pic = true;
                    doy = this.date_a_2_i(str, 3, pos);
                    pos += 3;
                    break;
                case (PICInterface.PIC_DDDD):
                    inp = true;
                    day_in_pic = true;
                    day = this.date_a_2_i(str, 2, pos);
                    pos += 2 + 2;
                    break;
                case (PICInterface.PIC_YJ):
                    year_in_pic = true;
                    inp = true;
                    if (UtilStrByteMode.isLocaleDefLangJPN()) {
                        if ((str.length === pos + 1 || str[pos + 1].charCodeAt(0) === this.DATECHAR || !UtilStrByteMode.isDigit(str[pos + 1])) && str.length < mask.length)
                            this.move_date(str, pos, 1, str.length);
                    }
                    year = this.date_a_2_i(str, 2, pos);
                    pos += 2;
                    let str1 = NString.FromChars(str);
                    era_year = UtilDateJpn.getInstance().getStartYearOfEra(str1, pic.getMask());
                    if (era_year === 0)
                        return 0;
                    year += era_year - 1;
                    if (year === 0)
                        bYearIsZero = true;
                    break;
                default:
                    if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                        if (UtilStrByteMode.isHalfWidth(str[pos]) === false &&
                            UtilStrByteMode.isHalfWidth(mask[pos + intPicIdxOfs]))
                            intPicIdxOfs++;
                    }
                    pos += 1;
                    break;
            }
        }
        if (bYearIsZero) {
            if (!month_in_pic)
                month = 0;
            if (!day_in_pic && month === 0)
                day = 0;
        }
        if (day === 0 && month === 0 && (bYearIsZero || year === 0))
            return (0);
        if (!inp)
            return (0);
        if (pic.isHebrew()) {
            if (year > 0) {
                if (millenium === 0)
                    millenium = 5;
                year += millenium * 1000;
            }
            return (HebrewDate.dateheb_2_d(year, month, day));
        }
        if ((year === 0) && !year_in_pic) {
            dateParams = this.date_sys();
            year = dateParams.year;
        }
        return (this.date_4_calender(year, month, day, doy, usedoy));
    }
    date_a_2_i(s, len, pos) {
        if (arguments.length === 3 && (s === null || s instanceof Array) && (len === null || len.constructor === Number) && (pos === null || pos.constructor === Number)) {
            return this.date_a_2_i_0(s, len, pos);
        }
        return this.date_a_2_i_1(s, len, pos);
    }
    date_a_2_i_0(s, len, pos) {
        let array = new Array(len);
        let mgNum = new NUM_TYPE();
        for (let i = 0; i < len; i = i + 1) {
            array[i] = s[pos + i];
        }
        return mgNum.a_2_long(NString.FromChars(array));
    }
    move_date(str, pos, moveby, len) {
        if (arguments.length === 4 && (str === null || str instanceof Array) && (pos === null || pos.constructor === Number) && (moveby === null || moveby.constructor === Number) && (len === null || len.constructor === Number)) {
            this.move_date_0(str, pos, moveby, len);
            return;
        }
        this.move_date_1(str, pos, moveby, len);
    }
    move_date_0(str, pos, moveby, len) {
        MemoryUtil.char_memmove(str, pos + moveby, str, pos, len - (pos + moveby) + 1);
        MemoryUtil.char_memset(str, pos, '0', moveby);
    }
    date_MMM_2_m(str, mask, pos, len, isHebrew) {
        let l;
        if (UtilStrByteMode.isLocaleDefLangJPN()) {
            let maskPos = UtilStrByteMode.convPos(NString.FromChars(str), NString.FromChars(mask), pos.val, false);
            l = this.date_msk_cnt(mask, maskPos, (len - maskPos));
        }
        else {
            l = this.date_msk_cnt(mask, pos.val, (len - pos.val));
        }
        let strPos = pos.val;
        pos.val = pos.val + l;
        len = MemoryUtil.mem_trim(str, strPos, l);
        if (len === 0) {
            return 0;
        }
        else {
            let strB = NString.FromChars(str, strPos, len);
            let monthNames;
            if (isHebrew) {
                monthNames = HebrewDate.GetLocalMonths();
            }
            else {
                let months = Events.GetMessageString(MsgInterface.MONTHS_PTR);
                monthNames = DateUtil.getLocalMonths(months);
            }
            for (let i = 1; i < monthNames.length; i = i + 1) {
                if (NString.Compare(monthNames[i].substr(0, len), strB, true) === 0)
                    return i;
            }
        }
        return 0;
    }
    date_sys() {
        let date = new DateBreakParams();
        let CurrDate = DateTime.Now;
        date.year = CurrDate.Year;
        date.month = CurrDate.Month;
        date.day = CurrDate.Day;
        return date;
    }
    date_magic(utcDate) {
        let dateTime;
        if (utcDate) {
            dateTime = DateTime.UtcNow;
        }
        else {
            dateTime = DateTime.Now;
        }
        let year = dateTime.Year;
        let month = dateTime.Month;
        let day = dateTime.Day;
        return this.date_4_calender(year, month, day, 1, false);
    }
    time_magic(utcTime) {
        return DateTime.GetTotalSecondsFromMidnight(utcTime, new Date());
    }
    mtime_magic(utcTime) {
        return DateTime.GetTotalMilliSecondsFromMidnight(utcTime, new Date());
    }
    date_4_calender(year, month, day, doy, usedoy) {
        let LeapYear = year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
        if (usedoy) {
            if (doy === 0) {
                return 0;
            }
            if (doy > 366 || (!LeapYear && doy > 365)) {
                return (1000000000);
            }
        }
        else {
            if (day === 0 && month === 0 && year === 0) {
                return 0;
            }
            if (day === 0 || month === 0 || year === 0 || month > 12) {
                return 1000000000;
            }
        }
        year = year - 1;
        let num = Math.floor(year / 400);
        year = year - num * 400;
        let num2 = Math.floor(year / 100);
        year = year - num2 * 100;
        let num3 = Math.floor(year / 4);
        year = year - num3 * 4;
        if (!usedoy) {
            let num4 = PICInterface.date_day_tab[month - 1];
            let num5 = PICInterface.date_day_tab[month];
            if (LeapYear) {
                if (month > 1) {
                    num5 = num5 + 1;
                    if (month > 2) {
                        num4 = num4 + 1;
                    }
                }
            }
            if (day > num5 - num4) {
                return 1000000000;
            }
            doy = num4 + day;
        }
        return num * 146097 + num2 * 36524 + num3 * 1461 + year * 365 + doy;
    }
    fromNativeTimeToMgTime(dispValue) {
        let mgNum = new NUM_TYPE();
        let numVal = this.fromNativeTimeToMgTimeNumber(dispValue);
        mgNum.NUM_4_LONG(numVal);
        return mgNum.toXMLrecord();
    }
    fromNativeTimeToMgTimeNumber(dispValue) {
        let numVal = this.time_2_int(dispValue.getHours(), dispValue.getMinutes(), dispValue.getSeconds());
        return numVal;
    }
    a_2_time(Ascii, picOrAsciiL, milliSecondsOrMask, milliSeconds) {
        if (arguments.length === 3)
            return this.a_2_time_0(Ascii, picOrAsciiL, milliSecondsOrMask);
        return this.a_2_time_1(Ascii, picOrAsciiL, milliSecondsOrMask, milliSeconds);
    }
    a_2_time_0(Ascii, pic, milliSeconds) {
        return this.a_2_time(Ascii, Ascii.length, NString.ToCharArray(pic.getMask()), milliSeconds);
    }
    a_2_time_1(Ascii, AsciiL, mask, milliSeconds) {
        let mgNum = new NUM_TYPE();
        let I = 0;
        let len = mask.length;
        if (len > AsciiL) {
            len = AsciiL;
        }
        let ampm = 0;
        let hour = 0;
        let minute = 0;
        let second = 0;
        let millisecond = 0;
        while (I < len) {
            let maskLength;
            let maxMaskLen;
            switch (mask[I].charCodeAt(0)) {
                case (PICInterface.PIC_HH):
                case (PICInterface.PIC_MMT):
                case (PICInterface.PIC_SS):
                case (PICInterface.PIC_PM):
                    maxMaskLen = 2;
                    break;
                case (PICInterface.PIC_MS):
                    maxMaskLen = 3;
                    break;
                default:
                    maxMaskLen = 1;
                    break;
            }
            maskLength = Math.min(maxMaskLen, len - I);
            switch (mask[I].charCodeAt(0)) {
                case (PICInterface.PIC_HH):
                    {
                        hour = mgNum.a_2_long(Ascii.substr(I, maskLength));
                    }
                    break;
                case (PICInterface.PIC_MMT):
                    {
                        minute = mgNum.a_2_long(Ascii.substr(I, maskLength));
                    }
                    break;
                case (PICInterface.PIC_SS):
                    {
                        second = mgNum.a_2_long(Ascii.substr(I, maskLength));
                    }
                    break;
                case (PICInterface.PIC_MS):
                    {
                        millisecond = mgNum.a_2_long(Ascii.substr(I, maskLength));
                    }
                    break;
                case (PICInterface.PIC_PM):
                    ampm = 0;
                    let c0 = Ascii[I];
                    let c1;
                    c0 = c0.toUpperCase();
                    if (I + 1 < len) {
                        c1 = Ascii[I + 1];
                        c1 = c1.toUpperCase();
                        if (c1 === 'M') {
                            if (c0 === 'A')
                                ampm = -1;
                            if (c0 === 'P')
                                ampm = 1;
                        }
                    }
                    break;
                default:
                    break;
            }
            I += maskLength;
        }
        if (second > 59 || minute > 59)
            return (0);
        if (ampm !== 0)
            if (ampm === -1) {
                if (hour === 12)
                    hour = 0;
            }
            else if (hour < 12)
                hour += 12;
        if (milliSeconds)
            return this.time_2_int(hour, minute, second) * 1000 + millisecond;
        else
            return this.time_2_int(hour, minute, second);
    }
    time_2_int(hour, minute, second) {
        return hour * 3600 + minute * 60 + second;
    }
    static toBoolean(boolStr) {
        return boolStr !== null && boolStr === "1";
    }
    a_2_date(str, Format, compIdx) {
        return this.a_2_date_datemode(str, Format, compIdx);
    }
    a_2_date_pic(str, pic, mask, compIdx) {
        if (str === null) {
            str = "";
        }
        return this.a_2_date_pic_datemode(NString.ToCharArray(str), str.length, pic, NString.ToCharArray(mask), compIdx);
    }
    to_a(outVal, out_len, date, Format, compIdx) {
        return this.to_a_datemode(outVal, out_len, date, Format, false, compIdx);
    }
    a_2_date_datemode(str, Format, compIdx) {
        let pIC = new PIC(Format, StorageAttribute.DATE, compIdx);
        if (str === null) {
            str = "";
        }
        return this.a_2_date_pic_datemode(NString.ToCharArray(str), str.length, pIC, NString.ToCharArray(pIC.getMask()), compIdx);
    }
    to_a_datemode(outVal, out_len, date, Format, ignore_dt_fmt, compIdx) {
        let pic = new PIC(Format, StorageAttribute.DATE, compIdx);
        if (outVal === null) {
            outVal = pic.getMask();
        }
        return this.to_a_pic_datemode(outVal, out_len, date, pic, true, ignore_dt_fmt, compIdx);
    }
    date_a_2_i_1(s, len, pos) {
        let mgNum = new NUM_TYPE();
        let str;
        str = s.substr(pos, len);
        return mgNum.a_2_long(str);
    }
    move_date_1(str, pos, moveby, len) {
        str = StrUtil.memmove(str, pos + moveby, str, pos, len - pos);
        str = StrUtil.memset(str, pos, '0', moveby);
        return str;
    }
    time_2_a(Ascii, AsciiL, time, Format, compIdx, milliSeconds) {
        if (StrUtil.rtrim(Format).length === 0) {
            Format = "HH:MM:SS";
        }
        let pic = new PIC(Format, StorageAttribute.TIME, compIdx);
        if (Ascii === null) {
            Ascii = pic.getMask();
        }
        return this.time_2_a_pic(Ascii, AsciiL, time, pic, false, milliSeconds);
    }
    toLogical(dispValue, pic, rangeStr) {
        dispValue = dispValue.trim();
        if (dispValue === null || dispValue.length === 0) {
            dispValue = "False";
        }
        return this.disp_2_logical(dispValue, pic.getMask(), rangeStr);
    }
    disp_2_logical(dispValue, mask, rangeStr) {
        let strippedValue = new StringBuilder(dispValue.length);
        rangeStr = this.win_rng_bool(rangeStr);
        rangeStr = StrUtil.makePrintableTokens(rangeStr, SEQ_2_HTML);
        let i = rangeStr.indexOf(',');
        let trueStr = rangeStr.substr(0, i);
        trueStr = StrUtil.makePrintableTokens(trueStr, HTML_2_STR);
        i = 0;
        for (i = 0; i < dispValue.length && i < mask.length; i++) {
            if (mask.charCodeAt(i) === PICInterface.PIC_X) {
                strippedValue.Append(dispValue.charAt(i));
            }
        }
        let val = strippedValue.ToString();
        if (trueStr.length < val.length) {
            val = val.substr(0, trueStr.length);
        }
        else {
            if (val.length < trueStr.length) {
                trueStr = trueStr.substr(0, val.length);
            }
        }
        return (val.toUpperCase() === trueStr.toUpperCase()) ? "1" : "0";
    }
    toAlpha(dispValue, pic) {
        let picture = pic.getMask();
        let buffer = new StringBuilder(pic.getMaskSize());
        let IsAlphaDBCS = UtilStrByteMode.isLocaleDefLangDBCS() && pic.isAttrAlpha();
        let currPicture;
        let i = currPicture = 0;
        for (currPicture = i = 0; i < dispValue.length && currPicture < picture.length; i++, currPicture++) {
            if (DisplayConvertor.isAlphaPositionalDirective(picture.charAt(currPicture))) {
                buffer.Append(dispValue.charAt(i));
                if (IsAlphaDBCS) {
                    let strDspValOneChar = dispValue.substr(i, 1);
                    if (UtilStrByteMode.lenB(strDspValOneChar) === 2) {
                        currPicture = currPicture + 1;
                    }
                }
            }
        }
        return buffer.ToString();
    }
    static isAlphaPositionalDirective(toCheck) {
        let ascii = toCheck.charCodeAt(0);
        return (ascii === PICInterface.PIC_X || ascii === PICInterface.PIC_U || ascii === PICInterface.PIC_L ||
            ascii === PICInterface.PIC_N || ascii === PICInterface.PIC_J || ascii === PICInterface.PIC_G || ascii === PICInterface.PIC_S || ascii === PICInterface.PIC_T);
    }
    fillAlphaByRange(ContinuousRangeValues, discreteRangeValues, newValue) {
        let tmpBuffer = this.fillAlphaByDiscreteRangeValues(discreteRangeValues, newValue);
        if (tmpBuffer !== null) {
            return tmpBuffer;
        }
        else {
            tmpBuffer = this.fillAlphaByContinuousRangeValues(ContinuousRangeValues, newValue);
            if (tmpBuffer !== null) {
                return tmpBuffer;
            }
            else {
                if (discreteRangeValues !== null) {
                    tmpBuffer = this.completeAlphaByRange(discreteRangeValues, newValue);
                    if (tmpBuffer !== null) {
                        return tmpBuffer;
                    }
                }
            }
        }
        return newValue;
    }
    fillAlphaByDiscreteRangeValues(discreteRangeValues, newValue) {
        if (discreteRangeValues !== null) {
            for (let i = 0; i < discreteRangeValues.length; i = i + 1) {
                let discreteValue = discreteRangeValues.get_Item(i);
                let truncatedValue = discreteValue.substr(0, Math.min(newValue.length, discreteValue.length));
                if (newValue.toUpperCase() === truncatedValue.toUpperCase()) {
                    return discreteValue;
                }
            }
        }
        return null;
    }
    fillAlphaByContinuousRangeValues(ContinuousRangeValues, newValue) {
        newValue = StrUtil.rtrim(newValue);
        if (ContinuousRangeValues !== null) {
            for (let i = 0; i < ContinuousRangeValues.length; i = i + 1) {
                let from = ContinuousRangeValues.get_Item(i);
                let to = ContinuousRangeValues.get_Item(i = i + 1);
                if (NString.CompareOrdinal(newValue, from) >= 0 && NString.CompareOrdinal(newValue, to) <= 0) {
                    return newValue;
                }
            }
        }
        return null;
    }
    completeAlphaByRange(discreteRangeValues, newValue) {
        let maxCoincide = new Array(2);
        for (let _ai = 0; _ai < maxCoincide.length; ++_ai)
            maxCoincide[_ai] = 0;
        let bestItem = new Array(2);
        for (let _ai = 0; _ai < bestItem.length; ++_ai)
            bestItem[_ai] = null;
        let CHECK_CASE = 0;
        let IGNORE_CASE = 1;
        let caseLetters = CHECK_CASE;
        while (caseLetters === CHECK_CASE || caseLetters === IGNORE_CASE) {
            let lowerValue;
            if (caseLetters === CHECK_CASE) {
                lowerValue = newValue;
            }
            else {
                lowerValue = newValue.toLowerCase();
            }
            lowerValue = StrUtil.rtrim(lowerValue);
            for (let i = 0; i < discreteRangeValues.length; i = i + 1) {
                let wrongLetter = false;
                let currCoincide = 0;
                let rangeItem;
                if (caseLetters === CHECK_CASE) {
                    rangeItem = discreteRangeValues.get_Item(i);
                }
                else {
                    rangeItem = discreteRangeValues.get_Item(i).toLowerCase();
                }
                let lowLength = lowerValue.length;
                let rangeLength = rangeItem.length;
                if (lowLength < rangeLength) {
                    for (let j = 0; j < lowLength; j = j + 1) {
                        if (!(lowerValue.charAt(j) === rangeItem.charAt(j))) {
                            wrongLetter = true;
                            break;
                        }
                        currCoincide = currCoincide + 1;
                    }
                }
                else {
                    wrongLetter = true;
                }
                if (currCoincide > maxCoincide[caseLetters] && !wrongLetter) {
                    bestItem[caseLetters] = discreteRangeValues.get_Item(i);
                    maxCoincide[caseLetters] = currCoincide;
                }
            }
            caseLetters = caseLetters + 1;
        }
        if (bestItem[CHECK_CASE] !== null)
            return bestItem[CHECK_CASE];
        else {
            if (bestItem[IGNORE_CASE] !== null)
                return bestItem[IGNORE_CASE];
        }
        return null;
    }
    setDateChar(dateChar) {
        this.DATECHAR = dateChar;
    }
    getDateChar() {
        return this.DATECHAR;
    }
    static StringValueToMgValue(value, storageAttribute, filler, length) {
        switch (storageAttribute) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE: {
                let newVal = value;
                newVal = NString.PadRight(newVal, length, filler);
                return newVal;
            }
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                return new NUM_TYPE(value);
            default:
                return value;
        }
    }
}
DisplayConvertor._instance = null;
class TimeBreakParams {
    constructor(hour_, minute_, second_) {
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(hour_, minute_, second_);
    }
    constructor_0() {
    }
    constructor_1(hour_, minute_, second_) {
        this.hour = hour_;
        this.minute = minute_;
        this.second = second_;
    }
}
class IntRef {
    constructor(val_) {
        this.val = 0;
        this.val = val_;
    }
}
class DateNameParams {
    constructor(out_, outIdx_, len_) {
        this.outVal = null;
        this.len = 0;
        this.outIdx = 0;
        this.outVal = out_;
        this.outIdx = outIdx_;
        this.len = len_;
    }
}
class DateBreakParams {
    constructor(year_, month_, day_, doy_, dow_) {
        this.day = 0;
        this.dow = 0;
        this.doy = 0;
        this.month = 0;
        this.year = 0;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(year_, month_, day_, doy_, dow_);
    }
    constructor_0() {
    }
    constructor_1(year_, month_, day_, doy_, dow_) {
        this.year = year_;
        this.month = month_;
        this.day = day_;
        this.doy = doy_;
        this.dow = dow_;
    }
}

class VectorTypeBase {
    static validateBlobContents(blob) {
        let valid = false;
        if (!NString.IsNullOrEmpty(blob)) {
            let start = BlobType.blobPrefixLength(blob);
            valid = (NString.Compare(blob, (VectorTypeBase.BLOB_TABLE_STR + VectorTypeBase.VECTOR_STR), true, start, 0, (VectorTypeBase.BLOB_TABLE_STR_LEN + VectorTypeBase.VECTOR_STR_LEN)) === 0);
        }
        return valid;
    }
    static adjustAlphaStringsInFlatData(srcBlob) {
        if (VectorTypeBase.validateBlobContents(srcBlob)) {
            let destBuf = new StringBuilder();
            let pos = BlobType.blobPrefixLength(srcBlob);
            let strToken = srcBlob.substr(0, pos);
            destBuf.Append(strToken);
            let tokens = StrUtil.tokenize(srcBlob.substr(pos), ",");
            let tokenIdx = 0;
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            if (strToken.charAt(0) !== StorageAttribute.ALPHA && strToken.charAt(0) !== StorageAttribute.MEMO)
                return srcBlob;
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            let len = NNumber.Parse(strToken);
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            strToken = UtilStrByteMode.leftB(srcBlob.substr(pos), len);
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokens = StrUtil.tokenize(srcBlob.substr(pos), ",");
            tokenIdx = 0;
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx];
            let vecSize = NNumber.Parse(strToken);
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            tokenIdx++;
            strToken = tokens[tokenIdx++];
            destBuf.Append(strToken + ",");
            pos = pos + (strToken.length + 1);
            for (let i = 0; i < vecSize; i = i + 1) {
                strToken = UtilStrByteMode.leftB(srcBlob.substr(pos), len);
                destBuf.Append(strToken);
                pos = pos + strToken.length;
            }
            strToken = srcBlob.substr(pos);
            destBuf.Append(strToken);
            let destBlob = destBuf.ToString();
            return destBlob;
        }
        else
            return srcBlob;
    }
}
VectorTypeBase.BLOB_TABLE_STR = "mgbt";
VectorTypeBase.BLOB_TABLE_STR_LEN = 4;
VectorTypeBase.VECTOR_STR = "MGVEC";
VectorTypeBase.VECTOR_STR_LEN = 5;

class RecordUtils {
    static byteStreamToString(stream) {
        if (arguments.length === 1 && (stream === null || stream instanceof StringBuilder)) {
            return RecordUtils.byteStreamToString_0(stream);
        }
        return RecordUtils.byteStreamToString_1(stream);
    }
    static byteStreamToString_0(stream) {
        let currStr;
        let currChar;
        let result = new StringBuilder(Math.floor(stream.Length / 2));
        for (let indx = 0; indx < stream.Length; indx = indx + 2) {
            currStr = stream.get_Item(indx) + stream.get_Item(indx + 1);
            currChar = String.fromCharCode(NNumber.Parse(currStr, NumberStyles.HexNumber));
            result.Append(currChar);
        }
        return result.ToString();
    }
    static byteStreamToString_1(stream) {
        return RecordUtils.byteStreamToString(new StringBuilder(stream));
    }
    static serializeItemVal(itemVal, itemAttr, cellAttr, toBase64) {
        Debug.Assert(itemVal != null);
        let significantNumSize = GuiEnvironment.Environment.GetSignificantNumSize() * 2;
        let valueSize;
        let j;
        let tmpBuf = new StringBuilder();
        let pos;
        let fldValLen;
        switch (itemAttr) {
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                itemVal = !toBase64
                    ? itemVal.substr(0, significantNumSize)
                    : Base64.encode(this.byteStreamToString(itemVal.substr(0, significantNumSize)));
                break;
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                itemVal = StrUtil.rtrim(itemVal);
                pos = 0;
                fldValLen = itemVal.length;
                do {
                    let nullChrPos = itemVal.indexOf(String.fromCharCode(0), pos);
                    if (nullChrPos === -1) {
                        valueSize = (fldValLen - pos).toString(16).toUpperCase();
                        for (j = 0; j < 4 - valueSize.length; j++)
                            tmpBuf.Append('0');
                        tmpBuf.Append(valueSize);
                        if (pos > 0)
                            itemVal = itemVal.substr(pos, (fldValLen) - (pos));
                        pos = fldValLen;
                    }
                    else {
                        valueSize = (nullChrPos - pos + 0x8000).toString(16).toUpperCase();
                        tmpBuf.Append(valueSize);
                        tmpBuf.Append(itemVal.substr(pos, (nullChrPos) - (pos)));
                        for (j = 1; j < fldValLen - nullChrPos && itemVal.charCodeAt(nullChrPos + j) === 0; j++) {
                        }
                        valueSize = "0000" + (j.toString(16)).toUpperCase();
                        tmpBuf.Append(valueSize.substr(valueSize.length - 4));
                        for (pos = nullChrPos; j > 0; j--, pos++) {
                            let tmpStr = "0" + itemVal.charCodeAt(nullChrPos).toString(16);
                            tmpBuf.Append(tmpStr.substr(tmpStr.length - 2));
                        }
                        if (pos >= fldValLen) {
                            tmpBuf.Append("0000");
                            itemVal = "";
                            break;
                        }
                    }
                } while (pos < fldValLen);
                break;
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
            case StorageAttribute.DOTNET:
                pos = 0;
                fldValLen = itemVal.length;
                if (UtilStrByteMode.isLocaleDefLangDBCS() && itemAttr === StorageAttribute.BLOB_VECTOR) {
                    if (cellAttr === StorageAttribute.ALPHA || cellAttr === StorageAttribute.MEMO) {
                        itemVal = VectorTypeBase.adjustAlphaStringsInFlatData(itemVal);
                        do {
                            if (itemVal.length < pos + 0x3FFF) {
                                if (pos > 0)
                                    itemVal = itemVal.substr(pos);
                                valueSize = (UtilStrByteMode.lenB(itemVal).toString(16)).toUpperCase();
                                for (j = 0; j < 4 - valueSize.length; j++)
                                    tmpBuf.Append('0');
                                tmpBuf.Append(valueSize);
                                itemVal = !toBase64
                                    ? StrUtil.stringToHexaDump(itemVal, 4)
                                    : Base64.encode(itemVal, true, GuiEnvironment.Environment.GetEncoding());
                                pos = fldValLen;
                            }
                            else {
                                let strSub = itemVal.substr(pos, 0x3FFF);
                                valueSize = ((UtilStrByteMode.lenB(strSub) + 0x8000).toString(16)).toUpperCase();
                                tmpBuf.Append(valueSize);
                                tmpBuf.Append(!toBase64
                                    ? StrUtil.stringToHexaDump(strSub, 4)
                                    : Base64.encode(strSub, true, GuiEnvironment.Environment.GetEncoding()));
                                tmpBuf.Append("0000");
                                pos += 0x3FFF;
                            }
                        } while (pos < fldValLen);
                        break;
                    }
                }
                do {
                    if (fldValLen < pos + 0x7FFF) {
                        valueSize = ((fldValLen - pos).toString(16)).toUpperCase();
                        for (j = 0; j < 4 - valueSize.length; j++)
                            tmpBuf.Append('0');
                        tmpBuf.Append(valueSize);
                        if (pos > 0)
                            itemVal = itemVal.substr(pos, (fldValLen) - (pos));
                        itemVal = !toBase64
                            ? StrUtil.stringToHexaDump(itemVal, 4)
                            : Base64.encode(itemVal);
                        pos = fldValLen;
                    }
                    else {
                        valueSize = "FFFF";
                        tmpBuf.Append(valueSize);
                        if (!toBase64)
                            tmpBuf.Append(StrUtil.stringToHexaDump(itemVal.substr(pos, 0x7FFF), 4));
                        else
                            tmpBuf.Append(Base64.encode(itemVal.substr(pos, 0x7FFF)));
                        tmpBuf.Append("0000");
                        pos += 0x7FFF;
                    }
                } while (pos < fldValLen);
                break;
        }
        tmpBuf.Append(itemVal);
        return tmpBuf.ToString();
    }
    static deSerializeItemVal(itemVal, itemAttr, itemLen, useHex, cellAttr, parsedLen) {
        let val = null;
        let idx = 0;
        let len, endIdx;
        let suffixBuf = null;
        let tmp = null;
        if (itemAttr === StorageAttribute.ALPHA
            || itemAttr === StorageAttribute.UNICODE
            || itemAttr === StorageAttribute.BLOB
            || itemAttr === StorageAttribute.BLOB_VECTOR
            || itemAttr === StorageAttribute.DOTNET) {
            endIdx = idx + 4;
            tmp = itemVal.substr(idx, (endIdx) - (idx));
            len = NNumber.Parse(tmp, NumberStyles.HexNumber);
            idx = endIdx;
        }
        else if (itemAttr === StorageAttribute.BOOLEAN)
            len = 1;
        else {
            let significantNumSize = GuiEnvironment.Environment.GetSignificantNumSize();
            if (useHex)
                len = significantNumSize * 2;
            else
                len = (Math.floor((significantNumSize + 2) / 3) * 4);
        }
        if ((len & 0x8000) > 0) {
            suffixBuf = new StringBuilder();
            len = (len & 0x7FFF);
            if (itemAttr === StorageAttribute.BLOB || itemAttr === StorageAttribute.BLOB_VECTOR
                || itemAttr === StorageAttribute.DOTNET)
                if (useHex)
                    len *= 2;
                else
                    len = (Math.floor((len + 2) / 3) * 4);
            parsedLen.value = this.getSpannedField(itemVal, len, idx, itemAttr, suffixBuf, useHex);
            val = suffixBuf.ToString();
            endIdx = idx + parsedLen.value;
        }
        else {
            if (itemAttr === StorageAttribute.BLOB
                || itemAttr === StorageAttribute.BLOB_VECTOR
                || itemAttr === StorageAttribute.DOTNET)
                if (useHex)
                    len *= 2;
                else
                    len = (Math.floor((len + 2) / 3) * 4);
            endIdx = idx + len;
            if (endIdx > itemVal.length)
                throw new ApplicationException("in Record.fillFieldsData() data string too short:\n" + itemVal);
            if (UtilStrByteMode.isLocaleDefLangDBCS() && itemAttr === StorageAttribute.BLOB_VECTOR)
                val = this.getString(itemVal.substr(idx, (endIdx) - (idx)), itemAttr, useHex, (cellAttr === StorageAttribute.ALPHA));
            else
                val = this.getString(itemVal.substr(idx, (endIdx) - (idx)), itemAttr, useHex);
        }
        idx = endIdx;
        if (itemAttr === StorageAttribute.ALPHA || itemAttr === StorageAttribute.UNICODE) {
            len = itemLen;
            val = StrUtil.padStr(val, len);
            if (itemAttr === StorageAttribute.ALPHA && UtilStrByteMode.isLocaleDefLangDBCS())
                val = UtilStrByteMode.leftB(val, len);
        }
        parsedLen.value = endIdx;
        return val;
    }
    static getString(str, type, useHex, useEnvCharset) {
        if (arguments.length === 3)
            return RecordUtils.getString_0(str, type, useHex);
        if (arguments.length === 2)
            return RecordUtils.getString_2(str, type);
        return RecordUtils.getString_1(str, type, useHex, useEnvCharset);
    }
    static getString_0(str, type, useHex) {
        return RecordUtils.getString(str, type, useHex, false);
    }
    static getString_1(str, type, useHex, useEnvCharset) {
        let result;
        if (useHex) {
            if (type === StorageAttribute.BLOB || type === StorageAttribute.BLOB_VECTOR
                || type === StorageAttribute.DOTNET)
                result = RecordUtils.byteStreamToString(str);
            else
                result = str;
        }
        else {
            if (type === StorageAttribute.BLOB || type === StorageAttribute.BLOB_VECTOR
                || type === StorageAttribute.DOTNET)
                result = Base64.decode(str, useEnvCharset ? GuiEnvironment.Environment.GetEncoding() : null);
            else
                result = Base64.decodeToHex(str);
        }
        return result;
    }
    static getSpannedField(fldsVal, firstSegLen, idx, type, result, useHex, noOfPackets) {
        if (arguments.length === 6)
            return RecordUtils.getSpannedField_0(fldsVal, firstSegLen, idx, type, result, useHex);
        return RecordUtils.getSpannedField_1(fldsVal, firstSegLen, idx, type, result, useHex, noOfPackets);
    }
    static getSpannedField_0(fldsVal, firstSegLen, idx, type, result, useHex) {
        let endIdx = idx + firstSegLen;
        let len;
        let begin = idx;
        let asciiCode;
        let tmp;
        let suffixBuf = null;
        let parsedLen;
        if (endIdx > fldsVal.length) {
            throw new ApplicationException("in Record.getSpannedField() data string too short:\n" + fldsVal);
        }
        result.Remove(0, result.Length);
        result.Append(RecordUtils.getString(fldsVal.substr(idx, endIdx - idx), type, useHex));
        idx = idx + firstSegLen;
        endIdx = idx + 4;
        tmp = fldsVal.substr(idx, endIdx - idx);
        len = NNumber.Parse(tmp, NumberStyles.HexNumber);
        idx = endIdx;
        if (useHex)
            endIdx = idx + len * 2;
        else
            endIdx = idx + Math.floor((len + 2) / 3) * 4;
        if (endIdx > fldsVal.length)
            throw new ApplicationException("in Record.getSpannedField() data string too short:\n" + fldsVal);
        while (idx < endIdx) {
            tmp = fldsVal.substr(idx, 2);
            asciiCode = String.fromCharCode(NNumber.Parse(tmp, NumberStyles.HexNumber));
            result.Append(asciiCode);
            idx = idx + 2;
        }
        endIdx = idx + 4;
        tmp = fldsVal.substr(idx, endIdx - idx);
        len = NNumber.Parse(tmp, NumberStyles.HexNumber);
        idx = endIdx;
        if ((len & 0x8000) > 0) {
            suffixBuf = new StringBuilder();
            len = (len & 0x7FFF);
            if (type === StorageAttribute.BLOB || type === StorageAttribute.BLOB_VECTOR)
                if (useHex)
                    len = len * 2;
                else
                    len = Math.floor((len + 2) / 3) * 4;
            parsedLen = RecordUtils.getSpannedField(fldsVal, len, idx, type, suffixBuf, useHex);
            result.Append(suffixBuf.ToString());
            idx = idx + parsedLen;
        }
        else {
            if (type === StorageAttribute.BLOB || type === StorageAttribute.BLOB_VECTOR)
                if (useHex)
                    len = len * 2;
                else
                    len = Math.floor((len + 2) / 3) * 4;
            endIdx = idx + len;
            if (endIdx > fldsVal.length)
                throw new ApplicationException("in Record.fillFieldsData() data string too short:\n" + fldsVal);
            result.Append(RecordUtils.getString(fldsVal.substr(idx, endIdx - idx), type, useHex));
            idx = endIdx;
        }
        return idx - begin;
    }
    static getSpannedField_1(fldsVal, firstSegLen, idx, type, result, useHex, noOfPackets) {
        let endIdx = idx + firstSegLen;
        let len;
        let begin = idx;
        let tmp;
        let suffixBuf = null;
        let parsedLen;
        let tmpEnc;
        if (UtilStrByteMode.isLocaleDefLangDBCS())
            tmpEnc = ISO_8859_1_Encoding.ISO_8859_1;
        else
            tmpEnc = GuiEnvironment.Environment.GetEncoding();
        if (endIdx > fldsVal.length)
            throw new ApplicationException("in Record.getSpannedField() data string too short:\n" + fldsVal);
        result.Remove(0, result.Length);
        result.Append(tmpEnc.GetString(fldsVal, idx, firstSegLen));
        noOfPackets = noOfPackets - 1;
        if (noOfPackets <= 0)
            return 0;
        idx = idx + firstSegLen;
        endIdx = idx + 4;
        tmp = tmpEnc.GetString(fldsVal, idx, 4);
        len = NNumber.Parse(tmp, NumberStyles.HexNumber);
        idx = endIdx;
        if (endIdx > fldsVal.length)
            throw new ApplicationException("in Record.getSpannedField() data string too short:\n" + fldsVal);
        endIdx = idx + 4;
        tmp = tmpEnc.GetString(fldsVal, idx, 4);
        len = NNumber.Parse(tmp, NumberStyles.HexNumber);
        idx = endIdx;
        if ((len & 0x8000) > 0) {
            suffixBuf = new StringBuilder();
            parsedLen = RecordUtils.getSpannedField(fldsVal, len, idx, type, suffixBuf, useHex, noOfPackets);
            result.Append(suffixBuf.ToString());
            idx = idx + parsedLen;
        }
        else {
            endIdx = idx + len;
            if (endIdx > fldsVal.length)
                throw new ApplicationException("in Record.fillFieldsData() data string too short:\n" + fldsVal);
            result.Append(tmpEnc.GetString(fldsVal, idx, len));
            idx = endIdx;
        }
        return idx - begin;
    }
    static itemValToXML(itemVal, itemAttr, cellAttr, ToBase64) {
        let tmpBuf = RecordUtils.serializeItemVal(itemVal, itemAttr, cellAttr, ToBase64);
        return XmlParser.escape(tmpBuf).toString();
    }
    static getString_2(str, type) {
        let useHex = GuiEnvironment.Environment.GetDebugLevel() > 1 || type === StorageAttribute.ALPHA
            || type === StorageAttribute.UNICODE || StorageAttributeCheck.isTypeLogical(type);
        let tmp;
        if (type === StorageAttribute.ALPHA || type === StorageAttribute.UNICODE ||
            type === StorageAttribute.BLOB || type === StorageAttribute.BLOB_VECTOR) {
            tmp = str.substr(4);
        }
        else
            tmp = str;
        return RecordUtils.getString(tmp, type, useHex);
    }
}

class VectorType extends VectorTypeBase {
    constructor(cellsTypeOrBlobStringOrFld, contentType, defualt, isDefNull, nullAlowed, length) {
        super();
        this._cells = null;
        this._encoding = null;
        this._allowNull = false;
        this._cellContentType = null;
        this._cellSize = 0;
        this._cellsAttr = null;
        this._cellsDefaultVal = null;
        this._cellsIsNullDefault = false;
        this._dataBuf = null;
        this._initialized = false;
        this._nullBuf = null;
        this._originalflatData = null;
        if (arguments.length === 6)
            this.constructor_0(cellsTypeOrBlobStringOrFld, contentType, defualt, isDefNull, nullAlowed, length);
        else if (arguments.length === 1 && (cellsTypeOrBlobStringOrFld === null || cellsTypeOrBlobStringOrFld.constructor === String))
            this.constructor_1(cellsTypeOrBlobStringOrFld);
        else
            this.constructor_2(cellsTypeOrBlobStringOrFld);
    }
    constructor_0(cellsType, contentType, defualt, isDefNull, nullAlowed, length) {
        this._cells = new List();
        this._cellsAttr = cellsType;
        this._cellContentType = contentType;
        this._cellsDefaultVal = defualt;
        this._cellsIsNullDefault = isDefNull;
        this._cellSize = ((this._cellsAttr === StorageAttribute.UNICODE) ? (length * 2) : length);
        this._initialized = true;
        this._allowNull = nullAlowed;
        this._nullBuf = new StringBuilder();
        this._dataBuf = new StringBuilder();
        this._originalflatData = this.toString();
        this._encoding = GuiEnvironment.Environment.GetEncoding();
    }
    constructor_1(blobString) {
        this._cells = new List();
        this._initialized = false;
        this._originalflatData = blobString;
        this._encoding = GuiEnvironment.Environment.GetEncoding();
    }
    constructor_2(fld) {
        this._cells = new List();
        this._cellsAttr = fld.getCellsType();
        this._cellContentType = fld.getVecCellsContentType();
        this._cellsDefaultVal = fld.getCellDefualtValue();
        this._cellsIsNullDefault = fld.isNullDefault();
        this._cellSize = ((this._cellsAttr === StorageAttribute.UNICODE) ? (fld.getVecCellsSize() * 2) : fld.getVecCellsSize());
        this._initialized = true;
        this._allowNull = fld.NullAllowed;
        this._nullBuf = new StringBuilder();
        this._dataBuf = new StringBuilder();
        this._originalflatData = this.toString();
        this._encoding = GuiEnvironment.Environment.GetEncoding();
    }
    init() {
        let tokens = null;
        let tokenIdx = 0;
        let currentToken = null;
        let isFlatDataTranslated = this.isUnicode(this._originalflatData);
        let isDbcsAlpha = false;
        let pos = BlobType.blobPrefixLength(this._originalflatData);
        tokens = StrUtil.tokenize(this._originalflatData.substr(pos), ",");
        let vecSize = 0;
        if (!this._initialized) {
            if (VectorType.validateBlobContents(this._originalflatData)) {
                let blobPrefix = BlobType.getPrefix(this._originalflatData);
                this._cellContentType = BlobType.getContentType(blobPrefix);
                pos = (pos + 4 + 5 + 1);
                tokenIdx++;
                currentToken = tokens[tokenIdx];
                pos = pos + (currentToken.length + 1);
                tokenIdx++;
                currentToken = tokens[tokenIdx];
                pos = pos + (currentToken.length + 1);
                tokenIdx++;
                currentToken = tokens[tokenIdx];
                this._cellsAttr = currentToken.charAt(0);
                pos = pos + 2;
                tokenIdx++;
                currentToken = tokens[tokenIdx];
                this._cellSize = NNumber.Parse(currentToken);
                pos = pos + (currentToken.length + 1);
                if (this._cellsAttr === StorageAttribute.NUMERIC || this._cellsAttr === StorageAttribute.DATE || this._cellsAttr === StorageAttribute.TIME)
                    this._cellsDefaultVal = StrUtil.stringToHexaDump(this._originalflatData.substr(pos, this._cellSize), 2);
                else if (this._cellsAttr === StorageAttribute.ALPHA || this._cellsAttr === StorageAttribute.MEMO) {
                    if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                        isDbcsAlpha = true;
                        isFlatDataTranslated = true;
                        this._cellsDefaultVal = UtilStrByteMode.leftB(this._originalflatData.substr(pos), this._cellSize);
                    }
                    else
                        this._cellsDefaultVal = this._originalflatData.substr(pos, this._cellSize);
                    if (this._encoding !== null && !isFlatDataTranslated) {
                        try {
                            let ba = ISO_8859_1_Encoding.ISO_8859_1.GetBytes(this._cellsDefaultVal);
                            this._cellsDefaultVal = this._encoding.GetString(ba, 0, ba.length);
                        }
                        catch (Exception) {
                        }
                    }
                }
                else if (this._cellsAttr === StorageAttribute.UNICODE) {
                    this._cellsDefaultVal = this._originalflatData.substr(pos, this._cellSize);
                    try {
                        let ba = ISO_8859_1_Encoding.ISO_8859_1.GetBytes(this._cellsDefaultVal);
                        this._cellsDefaultVal = Encoding.Unicode.GetString(ba, 0, ba.length);
                    }
                    catch (Exception) {
                    }
                }
                else
                    this._cellsDefaultVal = this._originalflatData.substr(pos, this._cellSize);
                if (isDbcsAlpha)
                    pos = pos + this._cellsDefaultVal.length + 1;
                else
                    pos = (pos + this._cellSize + 1);
                tokens = StrUtil.tokenize(this._originalflatData.substr(pos), ",");
                tokenIdx = 0;
                currentToken = tokens[tokenIdx];
                this._cellsIsNullDefault = DisplayConvertor.toBoolean(currentToken);
                pos = pos + (currentToken.length + 1);
                tokenIdx++;
                currentToken = tokens[tokenIdx];
                this._allowNull = DisplayConvertor.toBoolean(currentToken);
                pos = pos + (currentToken.length + 1);
                tokenIdx++;
                currentToken = tokens[tokenIdx];
                pos = pos + (currentToken.length + 1);
                tokenIdx++;
                currentToken = tokens[tokenIdx];
                vecSize = NNumber.Parse(currentToken);
                pos = pos + (currentToken.length + 1);
                tokenIdx++;
                currentToken = tokens[tokenIdx];
                pos = pos + (currentToken.length + 1);
                if (this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR) {
                    tokenIdx++;
                    currentToken = tokens[tokenIdx];
                    pos = pos + (currentToken.length + 1);
                }
                let data;
                if (isDbcsAlpha) {
                    data = UtilStrByteMode.leftB(this._originalflatData.substr(pos), (vecSize * this._cellSize));
                    pos = pos + data.length + 1;
                }
                else {
                    data = this._originalflatData.substr(pos, (vecSize * this._cellSize));
                    pos = (pos + vecSize * this._cellSize + 1);
                }
                this._dataBuf = new StringBuilder(data.length);
                if (this._cellsAttr !== StorageAttribute.ALPHA && this._cellsAttr !== StorageAttribute.MEMO && this._cellsAttr !== StorageAttribute.UNICODE)
                    this._dataBuf.Append(data);
                let nullBuf = this._originalflatData.substr(pos, vecSize);
                pos = (pos + vecSize + 1);
                this._nullBuf = new StringBuilder(nullBuf);
                if (this._cellsAttr !== StorageAttribute.BLOB && this._cellsAttr !== StorageAttribute.BLOB_VECTOR) {
                    for (let i = 0; i < vecSize; i++) {
                        let isNull = nullBuf.charAt(i) > '\0';
                        if (this._cellsAttr === StorageAttribute.NUMERIC || this._cellsAttr === StorageAttribute.DATE || this._cellsAttr === StorageAttribute.TIME)
                            this._cells.push(new CellElement(StrUtil.stringToHexaDump(data.substr((i * this._cellSize), this._cellSize), 2), isNull));
                        else if (this._cellsAttr === StorageAttribute.ALPHA || this._cellsAttr === StorageAttribute.MEMO) {
                            let cellData;
                            if (isDbcsAlpha)
                                cellData = UtilStrByteMode.midB(data, (i * this._cellSize), this._cellSize);
                            else
                                cellData = data.substr((i * this._cellSize), this._cellSize);
                            if (this._encoding !== null && !isFlatDataTranslated) {
                                try {
                                    let ba = ISO_8859_1_Encoding.ISO_8859_1.GetBytes(cellData);
                                    cellData = this._encoding.GetString(ba, 0, ba.length);
                                }
                                catch (SystemException) {
                                }
                            }
                            this._dataBuf.Append(cellData);
                            this._cells.push(new CellElement(cellData, isNull));
                        }
                        else if (this._cellsAttr === StorageAttribute.UNICODE) {
                            let cellData = data.substr((i * this._cellSize), this._cellSize);
                            try {
                                let ba = ISO_8859_1_Encoding.ISO_8859_1.GetBytes(cellData);
                                cellData = Encoding.Unicode.GetString(ba, 0, ba.length);
                            }
                            catch (SystemException) {
                            }
                            this._dataBuf.Append(cellData);
                            this._cells.push(new CellElement(cellData, isNull));
                        }
                        else
                            this._cells.push(new CellElement(data.substr((i * this._cellSize), this._cellSize), isNull));
                    }
                }
                else {
                    for (let i = 0; i < vecSize; i++) {
                        tokens = StrUtil.tokenize(this._originalflatData.substr(pos), ",");
                        tokenIdx = 0;
                        tokenIdx++;
                        currentToken = tokens[tokenIdx];
                        let size = NNumber.Parse(currentToken);
                        pos = pos + (currentToken.length + 1);
                        let blobHeader = "";
                        for (let j = 0; j < GuiConstants.BLOB_PREFIX_ELEMENTS_COUNT; j++) {
                            tokenIdx++;
                            currentToken = tokens[tokenIdx];
                            blobHeader = blobHeader + currentToken;
                            pos = pos + (currentToken.length + 1);
                            if (j !== GuiConstants.BLOB_PREFIX_ELEMENTS_COUNT - 1) {
                                blobHeader = blobHeader + ",";
                            }
                        }
                        let cellData = this._originalflatData.substr(pos, size);
                        let isNull = nullBuf.charAt(i) > '\0';
                        this._cells.push(new CellElement(cellData, isNull, blobHeader));
                        pos = (pos + size + 1);
                    }
                }
                if (this._dataBuf.Length === 0)
                    this._dataBuf = new StringBuilder(data.length);
                this._initialized = true;
            }
            else
                throw new ApplicationException("in VectorType.init wrong vector format");
        }
    }
    toString() {
        let res = "";
        if (this._initialized) {
            res = res + 0 + "," + 0 + "," + "0" + "," + this._cellsAttr + "," + this._cellContentType + ";";
            res = res + this.buildHeadersString();
            if (this._cellsAttr === StorageAttribute.UNICODE) {
                let dataBufCharArry = new Array(this._dataBuf.Length * 2);
                for (let i = 0; i < this._dataBuf.Length; i = i + 1) {
                    dataBufCharArry[i * 2] = String.fromCharCode((this._dataBuf.get_Item(i).charCodeAt(0)) % 256);
                    dataBufCharArry[i * 2 + 1] = String.fromCharCode((this._dataBuf.get_Item(i).charCodeAt(0)) / 256);
                }
                res = res + NString.FromChars(dataBufCharArry) + ",";
            }
            else
                res = res + this._dataBuf + ",";
            res = res + this._nullBuf + ",";
            if (this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR)
                res = res + this.getBlobsBuf();
            res = res + VectorType.BLOB_TABLE_STR;
        }
        else
            res = this._originalflatData;
        return res;
    }
    getCellsAttr() {
        if (!this._initialized)
            return VectorType.getCellsAttr(this._originalflatData);
        else
            return this._cellsAttr;
    }
    getCellSize() {
        let retVal;
        if (!this._initialized)
            retVal = VectorType.getCellSize(this._originalflatData);
        else
            retVal = this._cellSize;
        if (this.getCellsAttr() === StorageAttribute.UNICODE)
            retVal = Math.floor(retVal / 2);
        return retVal;
    }
    getVecSize() {
        if (!this._initialized)
            return VectorType.getVecSize(this._originalflatData);
        else
            return this._cells.length;
    }
    getVecCell(idx) {
        let retVal = null;
        if (idx > 0) {
            this.init();
            if (idx <= this.getVecSize()) {
                retVal = this._cells.get_Item(idx - 1).data;
                if (this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR)
                    retVal = this._cells.get_Item(idx - 1).blobFieldPrefix + ";" + retVal;
                if (StorageAttributeCheck.isTypeLogical(this._cellsAttr))
                    retVal = ((retVal.charAt(0) === '\0') ? "0" : "1");
                if (this._cells.get_Item(idx - 1).isNull)
                    retVal = null;
            }
            else if (!this._cellsIsNullDefault)
                retVal = this._cellsDefaultVal;
        }
        return retVal;
    }
    GetCellValues() {
        let retVal = null;
        let cellValues = null;
        this.init();
        if (this.getVecSize() > 0) {
            cellValues = new Array(this.getVecSize());
            for (let idx = 0; idx < this.getVecSize(); idx++) {
                retVal = this._cells.get_Item(idx).data;
                if (this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR)
                    retVal = this._cells.get_Item(idx).blobFieldPrefix + ";" + retVal;
                if (StorageAttributeCheck.isTypeLogical(this._cellsAttr))
                    retVal = ((retVal.charAt(0) === '\0') ? "0" : "1");
                if (this._cells.get_Item(idx).isNull)
                    retVal = null;
                cellValues[idx] = retVal;
            }
        }
        else if (!this._cellsIsNullDefault) {
            cellValues = [
                this._cellsDefaultVal
            ];
        }
        return cellValues;
    }
    setVecCell(idx, newValue, isNull) {
        let res = false;
        let createBufferValForNumType = true;
        try {
            if (idx > 0) {
                this.init();
                let localCellSize = (this._cellsAttr === StorageAttribute.UNICODE) ? Math.floor(this._cellSize / 2) : this._cellSize;
                if (isNull && !this._allowNull) {
                    isNull = false;
                    newValue = this._cellsDefaultVal;
                }
                if (idx <= this._cells.length) {
                    let curr = this._cells.get_Item(idx - 1);
                    if (!isNull) {
                        if (this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR) {
                            let blobPrefixLength = BlobType.blobPrefixLength(newValue);
                            curr.blobFieldPrefix = newValue.substr(0, blobPrefixLength - 1);
                            if (newValue.length > blobPrefixLength)
                                curr.data = newValue.substr(blobPrefixLength);
                            else
                                curr.data = "";
                        }
                        else {
                            if (StorageAttributeCheck.isTypeLogical(this._cellsAttr)) {
                                curr.data = (DisplayConvertor.toBoolean(newValue) ? new StringBuilder().Append(1).ToString() : new StringBuilder().Append('\0').ToString());
                                newValue = curr.data;
                            }
                            else
                                curr.data = newValue;
                            let dataBufVal = newValue;
                            if (this._cellsAttr === StorageAttribute.NUMERIC || this._cellsAttr === StorageAttribute.DATE || this._cellsAttr === StorageAttribute.TIME)
                                dataBufVal = RecordUtils.byteStreamToString(dataBufVal);
                            if (UtilStrByteMode.isLocaleDefLangDBCS() && (this._cellsAttr === StorageAttribute.ALPHA || this._cellsAttr === StorageAttribute.MEMO)) {
                                let baDataBuf = this._encoding.GetBytes(this._dataBuf.ToString());
                                let baDataBufVal = this._encoding.GetBytes(dataBufVal);
                                for (let i = 0; i < baDataBufVal.length && i < localCellSize; i++)
                                    baDataBuf[((idx - 1) * localCellSize) + i] = baDataBufVal[i];
                                for (let i = baDataBufVal.length; i < localCellSize; i++)
                                    baDataBuf[((idx - 1) * localCellSize) + i] = ((this._cellsAttr === StorageAttribute.ALPHA) ? 32 : 0);
                                this._dataBuf = new StringBuilder(this._encoding.GetString(baDataBuf, 0, baDataBuf.length));
                                curr.data = this._encoding.GetString(baDataBuf, ((idx - 1) * localCellSize), localCellSize);
                            }
                            else {
                                for (let i = 0; i < dataBufVal.length && i < localCellSize; i++)
                                    this._dataBuf.set_Item(((idx - 1) * localCellSize) + i, dataBufVal.charAt(i));
                                for (let i = dataBufVal.length; i < localCellSize; i++)
                                    this._dataBuf.set_Item(((idx - 1) * localCellSize) + i, (this._cellsAttr === StorageAttribute.ALPHA || this._cellsAttr === StorageAttribute.UNICODE) ? ' ' : '\0');
                                if (this._cellsAttr === StorageAttribute.ALPHA || this._cellsAttr === StorageAttribute.UNICODE || this._cellsAttr === StorageAttribute.MEMO)
                                    curr.data = this._dataBuf.ToString().substr(((idx - 1) * localCellSize), localCellSize);
                            }
                        }
                        this._nullBuf.set_Item(idx - 1, '\0');
                        curr.isNull = false;
                    }
                    else {
                        curr.data = null;
                        if (this._cellsAttr === StorageAttribute.BLOB_VECTOR)
                            curr.blobFieldPrefix = BlobType.getEmptyBlobPrefix('\u0001');
                        else
                            curr.blobFieldPrefix = BlobType.getEmptyBlobPrefix('\0');
                        curr.isNull = true;
                        this._nullBuf.set_Item(idx - 1, '\u0001');
                        for (let i = 0; i < localCellSize; i++)
                            this._dataBuf.set_Item(((idx - 1) * localCellSize) + i, '\0');
                        this._nullBuf.set_Item(idx - 1, '\u0001');
                    }
                    res = true;
                }
                else {
                    let insertVal;
                    if (this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR) {
                        if (this._cellsAttr === StorageAttribute.BLOB_VECTOR)
                            insertVal = BlobType.getEmptyBlobPrefix('\u0001');
                        else
                            insertVal = BlobType.getEmptyBlobPrefix('\0');
                        if (!this._cellsIsNullDefault)
                            insertVal = insertVal + this._cellsDefaultVal;
                    }
                    else if (this._cellsIsNullDefault)
                        insertVal = null;
                    else
                        insertVal = this._cellsDefaultVal;
                    if (insertVal !== null && StorageAttributeCheck.isTypeLogical(this._cellsAttr))
                        insertVal = (DisplayConvertor.toBoolean(insertVal) ? new StringBuilder().Append('\u0001').ToString() : new StringBuilder().Append('\0').ToString());
                    let dataBufVal = insertVal;
                    while (this._cells.length < idx) {
                        if (this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR) {
                            this._cells.push(new CellElement(insertVal.substr(VectorType.EMPTY_BLOB_PREFIX_LEN), this._cellsIsNullDefault, insertVal.substr(0, VectorType.EMPTY_BLOB_PREFIX_LEN)));
                            this._dataBuf.Append(this.getNullString(VectorType.BLOB_TYPE_STRUCT_SIZE));
                        }
                        else {
                            this._cells.push(new CellElement(insertVal, this._cellsIsNullDefault));
                            if (insertVal !== null) {
                                if (this._cellsAttr === StorageAttribute.NUMERIC || this._cellsAttr === StorageAttribute.DATE || this._cellsAttr === StorageAttribute.TIME) {
                                    if (createBufferValForNumType) {
                                        createBufferValForNumType = false;
                                        dataBufVal = RecordUtils.byteStreamToString(insertVal);
                                    }
                                }
                                this._dataBuf.Append(dataBufVal);
                                let valLen;
                                if (UtilStrByteMode.isLocaleDefLangDBCS() && (this._cellsAttr === StorageAttribute.ALPHA || this._cellsAttr === StorageAttribute.MEMO))
                                    valLen = UtilStrByteMode.lenB(dataBufVal);
                                else
                                    valLen = dataBufVal.length;
                                for (let i = valLen; i < localCellSize; i++)
                                    this._dataBuf.Append((this._cellsAttr === StorageAttribute.ALPHA || this._cellsAttr === StorageAttribute.UNICODE) ? ' ' : '\0');
                            }
                            else
                                this._dataBuf.Append(this.getNullString(localCellSize));
                        }
                        this._nullBuf.Insert(this._cells.length - 1, this._cellsIsNullDefault ? '\u0001' : '\0');
                    }
                    res = this.setVecCell(idx, newValue, isNull);
                }
            }
        }
        catch (ApplicationException) {
            res = false;
        }
        return res;
    }
    adjustToFit(field) {
        if (field.getType() === StorageAttribute.BLOB_VECTOR) {
            let srcAttr = this.getCellsAttr();
            let dstAttr = field.getCellsType();
            if (StorageAttributeCheck.isTheSameType(srcAttr, dstAttr)) {
                this.init();
                if (StorageAttributeCheck.IsTypeAlphaOrUnicode(srcAttr) && StorageAttributeCheck.IsTypeAlphaOrUnicode(dstAttr)) {
                    let dstSizeInChars = field.getVecCellsSize();
                    let srcSizeInChars = ((this._cellsAttr === StorageAttribute.UNICODE) ? Math.floor(this._cellSize / 2) : this._cellSize);
                    let isByteMode = UtilStrByteMode.isLocaleDefLangDBCS() && StorageAttributeCheck.isTypeAlpha(dstAttr);
                    if (srcSizeInChars !== dstSizeInChars) {
                        let adjData = new StringBuilder();
                        for (let i = 0; i < dstSizeInChars; i = i + 1) {
                            let curr = this._cells.get_Item(i);
                            if (!curr.isNull) {
                                if (srcSizeInChars > dstSizeInChars) {
                                    if (isByteMode)
                                        curr.data = UtilStrByteMode.leftB(curr.data, dstSizeInChars);
                                    else
                                        curr.data = curr.data.substr(0, dstSizeInChars);
                                    adjData.Append(curr.data);
                                }
                                else {
                                    let tmpData = new StringBuilder();
                                    tmpData.Append(curr.data);
                                    let dataLen = isByteMode ? UtilStrByteMode.lenB(curr.data) : curr.data.length;
                                    for (let j = dataLen; j < dstSizeInChars; j = j + 1)
                                        tmpData.Append(' ');
                                    adjData.Append(tmpData.ToString());
                                    curr.data = tmpData.ToString();
                                }
                            }
                            else {
                                let tmpData = new StringBuilder();
                                for (let j = 0; j < dstSizeInChars; j = j + 1)
                                    tmpData.Append('\0');
                                adjData.Append(tmpData.ToString());
                                curr.data = tmpData.ToString();
                            }
                        }
                        this._dataBuf = adjData;
                    }
                }
                let newSize = field.getVecCellsSize();
                this._cellsAttr = field.getCellsType();
                this._cellSize = ((this._cellsAttr === StorageAttribute.UNICODE) ? (newSize * 2) : newSize);
                this._cellsDefaultVal = field.getCellDefualtValue();
                this._cellsIsNullDefault = field.isNullDefault();
                this._allowNull = field.NullAllowed;
                this._originalflatData = this.toString();
                return;
            }
            else
                throw new ApplicationException("in VectorType.adjustToFit vector basic types does not agree");
        }
        else
            throw new ApplicationException("in  VectorType.adjustToFit " + field.getName() + " is not of type vector");
    }
    buildHeadersString() {
        let res = VectorType.BLOB_TABLE_STR + VectorType.VECTOR_STR + "," + VectorType.VERSION + "," + 1 + "," + this._cellsAttr + ",";
        res = res + this._cellSize + ",";
        let def = "";
        if (this._cellsDefaultVal !== null)
            if (this._cellsAttr === StorageAttribute.NUMERIC || this._cellsAttr === StorageAttribute.DATE || this._cellsAttr === StorageAttribute.TIME)
                def = RecordUtils.byteStreamToString(this._cellsDefaultVal);
            else
                def = this._cellsDefaultVal;
        if (UtilStrByteMode.isLocaleDefLangDBCS() && (this._cellsAttr === StorageAttribute.ALPHA || this._cellsAttr === StorageAttribute.MEMO))
            def = def + this.getEmptyString(this._cellSize - UtilStrByteMode.lenB(def));
        else
            def = def + this.getEmptyString(this._cellSize - def.length);
        res = res + def + "," + (this._cellsIsNullDefault ? "1" : "0") + ",";
        res = res + (this._allowNull ? "1" : "0") + "," + this._cellSize + "," + this._cells.length + ",";
        res = res + ((this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR) ? "1" : "0") + ",";
        if (this._cellsAttr === StorageAttribute.BLOB || this._cellsAttr === StorageAttribute.BLOB_VECTOR)
            res = res + "0,";
        return res;
    }
    getNullString(size) {
        let res = new StringBuilder();
        for (let i = 0; i < size; i = i + 1)
            res.Append('\0');
        return res.ToString();
    }
    getEmptyString(size) {
        let res = new StringBuilder();
        for (let i = 0; i < size; i = i + 1)
            res.Append(' ');
        return res.ToString();
    }
    getBlobsBuf() {
        let res = new StringBuilder();
        for (let i = 0; i < this._cells.length; i = i + 1) {
            let data = "";
            let blobSize = 0;
            let curr = this._cells.get_Item(i);
            if (curr.data !== null) {
                data = curr.data;
                blobSize = data.length;
            }
            res.Append(blobSize);
            res.Append("," + curr.blobFieldPrefix + "," + data + ";");
        }
        return (res + ",");
    }
    static getCellsAttr(blob) {
        if (VectorType.validateBlobContents(blob)) {
            let tokens = StrUtil.tokenize(blob.substr(BlobType.blobPrefixLength(blob)), ",");
            return tokens[3].charAt(0);
        }
        else
            throw new ApplicationException("in static getCellsAttr the blob is in the wrong format");
    }
    static getCellSize(blob) {
        let cellsType = VectorType.getCellsAttr(blob);
        if (cellsType !== StorageAttribute.BLOB && cellsType !== StorageAttribute.BLOB_VECTOR) {
            let tokens = StrUtil.tokenize(blob.substr(BlobType.blobPrefixLength(blob)), ",");
            return NNumber.Parse(tokens[4]);
        }
        else {
            return 2147483647;
        }
    }
    static getVecSize(blob) {
        if (VectorType.validateBlobContents(blob)) {
            let pos = BlobType.blobPrefixLength(blob);
            let tokens = StrUtil.tokenize(blob.substr(pos), ",");
            pos = pos + (tokens[0].length + 1);
            pos = pos + (tokens[1].length + 1);
            pos = pos + (tokens[2].length + 1);
            pos = pos + (tokens[3].length + 1);
            let cellsSize = tokens[4];
            pos = pos + (cellsSize.length + 1);
            pos = pos + (NNumber.Parse(cellsSize) + 1);
            tokens = StrUtil.tokenize(blob.substr(pos), ",");
            return NNumber.Parse(tokens[3]);
        }
        throw new ApplicationException("in static getVecSize the blob is in the wrong format");
    }
    isUnicode(flatData) {
        let start = BlobType.blobPrefixLength(flatData);
        let catcher = flatData.substr(start, VectorType.BLOB_TABLE_STR_LEN);
        return (catcher === VectorType.BLOB_TABLE_STR);
    }
}
VectorType.VERSION = 5;
VectorType.EMPTY_BLOB_PREFIX_LEN = 7;
VectorType.BLOB_TYPE_STRUCT_SIZE = 28;
class CellElement {
    constructor(val, is_null, ctrlData) {
        this.blobFieldPrefix = null;
        this.data = null;
        this.isNull = false;
        if (arguments.length === 2)
            this.constructor_0(val, is_null);
        this.constructor_1(val, is_null, ctrlData);
    }
    constructor_0(val, is_null) {
        this.data = val;
        this.isNull = is_null;
    }
    constructor_1(val, is_null, ctrlData) {
        this.data = val;
        this.isNull = is_null;
        this.blobFieldPrefix = ctrlData;
    }
}

class FieldDef {
    set DbModifiable(value) {
        this._dbModifiable = value;
    }
    get DbModifiable() {
        return this._dbModifiable;
    }
    constructor(id) {
        this.DefaultValue = null;
        this.NullAllowed = false;
        this._nullDefault = false;
        this._nullValue = null;
        this._nullDisplay = null;
        this._dbModifiable = true;
        this._partOfDataview = true;
        this._picture = null;
        this._size = 0;
        this._varName = null;
        this._contentType = BlobType.CONTENT_TYPE_UNKNOWN;
        this._vecCellsContentType = BlobType.CONTENT_TYPE_UNKNOWN;
        this._vecCellsSize = 0;
        this._vecCellsType = StorageAttribute.NONE;
        this._type = StorageAttribute.NONE;
        this.Storage = 0;
        this.VarDisplayName = null;
        this._id = 0;
        this._spaces = null;
        this._id = id;
        this.VarDisplayName = NString.Empty;
    }
    get PartOfDataview() {
        return this._partOfDataview;
    }
    getId() {
        return this._id;
    }
    getType() {
        return this._type;
    }
    static getMagicDefaultNullDisplayValue(type) {
        let val;
        switch (type) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
            case StorageAttribute.BOOLEAN:
                val = "";
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                val = "";
                break;
        }
        return val;
    }
    static getMagicDefaultValue(type) {
        let val = null;
        switch (type) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                val = "";
                break;
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
                val = BlobType.getEmptyBlobPrefix('\0') + ";";
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.TIME:
                val = "FF00000000000000000000000000000000000000";
                break;
            case StorageAttribute.DATE:
                val = FieldDef._default_date;
                break;
            case StorageAttribute.BOOLEAN:
                val = "0";
                break;
        }
        return val;
    }
    getDefaultValue() {
        let val = null;
        if (this._type !== StorageAttribute.BLOB_VECTOR) {
            if (this._nullDefault && this._nullValue !== null)
                val = this._nullValue;
            else if (this.DefaultValue !== null)
                val = this.DefaultValue;
            else
                val = this.getMagicDefaultValue();
        }
        else
            val = this.getMagicDefaultValue();
        return val;
    }
    getCellDefualtValue() {
        let val;
        if (this._type === StorageAttribute.BLOB_VECTOR) {
            if (this._nullDefault && this._nullValue !== null)
                val = this._nullValue;
            else if (this.DefaultValue !== null)
                val = this.DefaultValue;
            else {
                val = FieldDef.getMagicDefaultValue(this._vecCellsType);
                if (this._vecCellsType === StorageAttribute.BLOB)
                    val = BlobType.setContentType(val, this._vecCellsContentType);
            }
        }
        else
            val = this.getDefaultValue();
        return val;
    }
    getMagicDefaultValue() {
        let val = FieldDef.getMagicDefaultValue(this._type);
        if (this._type === StorageAttribute.BLOB)
            val = BlobType.setContentType(val, this._contentType);
        else {
            if (this._type === StorageAttribute.BLOB_VECTOR) {
                val = BlobType.SetVecCellAttr(val, this._vecCellsType);
                if (this._vecCellsType === StorageAttribute.BLOB)
                    val = BlobType.setContentType(val, this._vecCellsContentType);
            }
        }
        return val;
    }
    getContentType() {
        return this._contentType;
    }
    hasNullDisplayValue() {
        return this._nullDisplay !== null;
    }
    getSize() {
        return this._size;
    }
    getVecCellsSize() {
        return (this._type === StorageAttribute.BLOB_VECTOR) ? this._vecCellsSize : this._size;
    }
    setLengths(type, vecCells) {
        let res = this._size;
        switch (type) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.MEMO:
            case StorageAttribute.UNICODE:
                if (vecCells) {
                    res = this._vecCellsSize;
                    this._spaces = new Array(this._vecCellsSize);
                }
                else
                    this._spaces = new Array(this._size);
                for (let i = 0; i < this._size; i = i + 1) {
                    this._spaces[i] = ' ';
                }
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                res = GuiEnvironment.Environment.GetSignificantNumSize() * 2;
                break;
            case StorageAttribute.BOOLEAN:
                res = (!vecCells ? 1 : 4);
                break;
            case StorageAttribute.BLOB:
                res = (!vecCells ? Int32.MaxValue : VectorType.BLOB_TYPE_STRUCT_SIZE);
                break;
            case StorageAttribute.BLOB_VECTOR:
                res = Int32.MaxValue;
                if (!vecCells)
                    this.setLengths(this._vecCellsType, true);
                else
                    res = VectorType.BLOB_TYPE_STRUCT_SIZE;
                break;
        }
        if (vecCells)
            this._vecCellsSize = res;
        else
            this._size = res;
    }
    getCellsType() {
        return (this._type === StorageAttribute.BLOB_VECTOR) ? this._vecCellsType : this._type;
    }
    getVecCellsContentType() {
        return this._vecCellsContentType;
    }
    getNullValue() {
        return this._nullValue;
    }
    isNullDefault() {
        return this._nullDefault;
    }
    getNullDisplay() {
        let val;
        switch (this._type) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
            case StorageAttribute.BOOLEAN:
                val = "";
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                val = null;
                break;
        }
        return val;
    }
    IsContentUnicode() {
        if (this._type === StorageAttribute.BLOB && this._contentType !== BlobType.CONTENT_TYPE_UNICODE)
            return false;
        return true;
    }
    GetPicture() {
        return this._picture;
    }
    setAttribute(attribute, valueStr) {
        let isTagProcessed = true;
        switch (attribute) {
            case XMLConstants.MG_ATTR_TYPE:
                this._type = valueStr.charAt(0);
                break;
            case XMLConstants.MG_ATTR_SIZE:
                this._size = XmlParser.getInt(valueStr);
                if (this._size <= 0)
                    Events.WriteExceptionToLog("in Field.initElements(): size must be greater than zero");
                break;
            case XMLConstants.MG_ATTR_VAR_NAME:
                this._varName = XmlParser.unescape(valueStr).toString();
                break;
            case XMLConstants.MG_ATTR_VAR_DISP_NAME:
                this.VarDisplayName = XmlParser.unescape(valueStr).toString();
                break;
            case XMLConstants.MG_ATTR_PICTURE:
                this._picture = XmlParser.unescape(valueStr).toString();
                break;
            case XMLConstants.MG_ATTR_VEC_CELLS_SIZE:
                this._vecCellsSize = NNumber.Parse(valueStr);
                break;
            case XMLConstants.MG_ATTR_VEC_CELLS_ATTR:
                this._vecCellsType = valueStr.charAt(0);
                break;
            case XMLConstants.MG_ATTR_VEC_CELLS_CONTENT:
                this._vecCellsContentType = valueStr.charAt(0);
                break;
            case XMLConstants.MG_ATTR_NULLVALUE:
                if (this._type === StorageAttribute.NUMERIC || this._type === StorageAttribute.DATE || this._type === StorageAttribute.TIME) {
                    if (GuiEnvironment.Environment.GetDebugLevel() > 1)
                        this._nullValue = XmlParser.unescape(valueStr).toString();
                    else
                        this._nullValue = Base64.decodeToHex(valueStr);
                }
                else
                    this._nullValue = XmlParser.unescape(valueStr).toString();
                break;
            case XMLConstants.MG_ATTR_NULLDISPLAY:
                this._nullDisplay = XmlParser.unescape(valueStr).toString();
                break;
            case XMLConstants.MG_ATTR_NULLDEFAULT:
                this._nullDefault = DisplayConvertor.toBoolean(valueStr);
                break;
            case XMLConstants.MG_ATTR_DB_MODIFIABLE:
                this.DbModifiable = DisplayConvertor.toBoolean(valueStr);
                break;
            case XMLConstants.MG_ATTR_DEFAULTVALUE:
                this.DefaultValue = valueStr;
                if (this._type === StorageAttribute.ALPHA || this._type === StorageAttribute.UNICODE) {
                    this.DefaultValue = XmlParser.unescape(valueStr).toString();
                    this.DefaultValue = StrUtil.padStr(this.DefaultValue, this._size);
                }
                else if (this._type !== StorageAttribute.BLOB && this._type !== StorageAttribute.BOOLEAN) {
                    if ((this._type === StorageAttribute.BLOB_VECTOR &&
                        (this._vecCellsType === StorageAttribute.NUMERIC || this._vecCellsType === StorageAttribute.DATE || this._vecCellsType === StorageAttribute.TIME)) ||
                        (this._type === StorageAttribute.NUMERIC || this._type === StorageAttribute.DATE || this._type === StorageAttribute.TIME)) {
                        if (GuiEnvironment.Environment.GetDebugLevel() < 1)
                            this.DefaultValue = Base64.decodeToHex(valueStr);
                    }
                }
                else if (this.DefaultValue.length === 0 && this._type !== StorageAttribute.BLOB)
                    this.DefaultValue = null;
                else if (this._type === StorageAttribute.BLOB)
                    this.DefaultValue = BlobType.createFromString(this.DefaultValue, this._contentType);
                break;
            case XMLConstants.MG_ATTR_NULLALLOWED:
                this.NullAllowed = DisplayConvertor.toBoolean(valueStr);
                break;
            case XMLConstants.MG_ATTR_BLOB_CONTENT:
                this._contentType = valueStr.charAt(0);
                break;
            case XMLConstants.MG_ATTR_PART_OF_DATAVIEW:
                this._partOfDataview = DisplayConvertor.toBoolean(valueStr);
                break;
            case XMLConstants.MG_ATTR_STORAGE:
                this.Storage = XmlParser.getInt(valueStr);
                break;
            default:
                isTagProcessed = false;
                break;
        }
        return isTagProcessed;
    }
    fillData(parser) {
        let text = parser.ReadToEndOfCurrentElement();
        text = text.substr(text.indexOf(XMLConstants.MG_TAG_FLDH) + XMLConstants.MG_TAG_FLDH.length);
        let tokens = XmlParser.getTokens(text, XMLConstants.XML_ATTR_DELIM);
        this.initElements(tokens);
    }
    initElements(tokensVector) {
        for (let i = 0; i < tokensVector.length; i = i + 2) {
            let attribute = tokensVector.get_Item(i);
            let valueStr = tokensVector.get_Item(i + 1);
            this.setAttribute(attribute, valueStr);
        }
        this.SetAfterParsing();
    }
    SetAfterParsing() {
        this.setLengths(this._type, false);
        if (this.NullAllowed && this._nullDisplay === null)
            this._nullDisplay = "";
    }
    getVarName() {
        return this._varName || "";
    }
    getName() {
        return this.getVarName();
    }
}
FieldDef._default_date = null;

class GuiFieldBase extends FieldDef {
    constructor(id) {
        super(id);
        this.ControlToFocus = null;
        this._controls = null;
        this._dataview = null;
    }
    getTask() {
        return this._dataview.getTask();
    }
    async updateDisplayWithValue(displayValue, isNull) {
        let ctrl = null;
        let ctrlValue = null;
        let defaultValue = GuiConstants.DEFAULT_VALUE_INT.toString();
        if (this._controls !== null) {
            let firstControlValue = null;
            let foundControlValue = false;
            let savedControlToFocus = this.ControlToFocus;
            for (let i = 0; i < this._controls.length; i = i + 1) {
                ctrl = this._controls.get_Item(i);
                if (!ctrl.getForm().inRefreshDisplay()) {
                    ctrl.resetPrevVal();
                    await ctrl.SetAndRefreshDisplayValue(displayValue, isNull);
                    if (!ctrl.isRadio())
                        if (ctrlValue === null || ctrl.Value !== null && !(ctrl.Value === defaultValue) && ctrl === savedControlToFocus)
                            ctrlValue = ctrl;
                        else {
                            if (firstControlValue === null)
                                firstControlValue = ctrl;
                            if (ctrl.Value !== null && !(ctrl.Value === defaultValue)) {
                                if (!foundControlValue) {
                                    firstControlValue = ctrl;
                                    foundControlValue = true;
                                }
                                if (ctrl === savedControlToFocus)
                                    ctrlValue = ctrl;
                                else if (ctrlValue === null)
                                    ctrlValue = firstControlValue;
                            }
                        }
                }
            }
            if (ctrlValue !== null) {
                this.ControlToFocus = ctrlValue;
                if (this._controls.length > 1) {
                    ctrlValue.resetPrevVal();
                    await ctrlValue.SetAndRefreshDisplayValue(displayValue, isNull);
                }
            }
        }
    }
    SetControl(ctrl) {
        if (this._controls === null)
            this._controls = new List();
        if (!this._controls.Contains(ctrl)) {
            this._controls.push(ctrl);
            if (this._controls.length === 1)
                this.ControlToFocus = ctrl;
        }
    }
    RemoveControl(ctrl) {
        this._controls.Remove(ctrl);
    }
    GetRadioCtrls() {
        let list = new List();
        if (this._controls !== null) {
            for (let i = 0; i < this._controls.length; i = i + 1) {
                let ctrl = this._controls[i];
                if (ctrl.isRadio())
                    list.push(ctrl);
            }
        }
        return list;
    }
    toString() {
        return NString.Format("(Field {0}-{1}) in task {2}", this._id, this._varName, this.getTask());
    }
}

class TaskDefinitionId {
    constructor(ctlIndex, programIsn, taskIsn, isProgram) {
        this.CtlIndex = 0;
        this.ProgramIsn = 0;
        this.TaskIsn = 0;
        this.IsProgram = false;
        if (arguments.length === 4)
            this.constructor_0(ctlIndex, programIsn, taskIsn, isProgram);
        else
            this.constructor_1();
    }
    constructor_0(ctlIndex, programIsn, taskIsn, isProgram) {
        this.CtlIndex = ctlIndex;
        this.ProgramIsn = programIsn;
        this.IsProgram = isProgram;
        this.TaskIsn = (isProgram ? 0 : taskIsn);
    }
    constructor_1() {
    }
    IsMainProgram() {
        return this.IsProgram && this.ProgramIsn === 1;
    }
    Equals(obj) {
        if (obj === null || !(obj instanceof TaskDefinitionId))
            return false;
        return this.GetHashCode() === obj.GetHashCode();
    }
    GetHashCode() {
        let strHashCode = this.HashCodeString();
        return NString.GetHashCode(strHashCode);
    }
    HashCodeString() {
        let strHashCode = this.CtlIndex + "." + this.IsProgram + "." + this.ProgramIsn + "." + this.TaskIsn;
        return strHashCode;
    }
    toString() {
        return NString.Format("{{Task ID: {0} ctl {1}/prg {2}{3} (hash: {4})}}", [
            this.IsProgram ? "Program" : "Task",
            this.CtlIndex,
            this.ProgramIsn,
            this.IsProgram ? "" : NString.Format(" Task {0}", this.TaskIsn),
            this.HashCodeString()
        ]);
    }
    fromJSON(jsonStr) {
        let obj = JSON.parse(jsonStr);
        this.CtlIndex = obj.CtlIndex;
        this.ProgramIsn = obj.ProgramIsn;
        this.TaskIsn = obj.TaskIsn;
        this.IsProgram = obj.IsProgram;
    }
}

class TaskDefinitionIdTableSaxHandler {
    constructor(newTaskDefintionIdHandler) {
        this._newTaskDefinitionIdHandler = null;
        this._newTaskDefinitionIdHandler = newTaskDefintionIdHandler;
    }
    parse(xmlSerializedTaskDefinitionsTable) {
        try {
            if (xmlSerializedTaskDefinitionsTable !== null) {
                JSON_Utils.JSONFromXML(xmlSerializedTaskDefinitionsTable, this.ParseJSON.bind(this));
            }
        }
        catch (ex) {
            Events.WriteExceptionToLog(ex);
        }
    }
    ParseJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let ctlIndex = 0;
        let isPrg = false;
        let prgIsn = 0;
        let taskIsn = 0;
        let taskDefId = result['taskDefinitionId']['$'];
        if (!isNullOrUndefined(taskDefId[XMLConstants.MG_ATTR_CTL_IDX]))
            ctlIndex = +taskDefId[XMLConstants.MG_ATTR_CTL_IDX];
        if (!isNullOrUndefined(taskDefId[XMLConstants.MG_ATTR_PROGRAM_ISN]))
            prgIsn = +taskDefId[XMLConstants.MG_ATTR_PROGRAM_ISN];
        if (!isNullOrUndefined(taskDefId[XMLConstants.MG_ATTR_TASK_ISN]))
            taskIsn = +taskDefId[XMLConstants.MG_ATTR_TASK_ISN];
        if (!isNullOrUndefined(taskDefId[XMLConstants.MG_ATTR_ISPRG]))
            isPrg = taskDefId[XMLConstants.MG_ATTR_ISPRG] === '1';
        let taskDefinitionId = new TaskDefinitionId(ctlIndex, prgIsn, taskIsn, isPrg);
        this._newTaskDefinitionIdHandler(taskDefinitionId);
    }
}

class GuiControlPropertyAdapter extends GuiMgControl {
    async updatePropertyLogicNesting(propId, commandType, val, updateThis) {
        return Promise.resolve();
    }
    async refreshAndSetItemsList(line, execComputeChoice) {
        return Promise.resolve();
    }
    async refreshTabForLayerList(line) {
        return Promise.resolve();
    }
    async ComputeAndRefreshDisplayValue(forceRefresh) {
        return Promise.resolve();
    }
    async refreshDispRange(execComputeChoice) {
        return Promise.resolve([]);
    }
    async isParkable(checkEnabledAndVisible) {
        return Promise.resolve(true);
    }
}

class PropDefaults {
    static getNumericMgValue(propParent, Value) {
        let pic = new PIC("3", StorageAttribute.NUMERIC, propParent.getCompIdx());
        return DisplayConvertor.Instance.disp2mg(Value, pic, propParent.getCompIdx(), BlobType.CONTENT_TYPE_UNKNOWN);
    }
    static getDefaultValueForTask(propId, handled) {
        let val = null;
        handled.value = true;
        switch (propId) {
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_EVENTS:
            case PropInterface.PROP_TYPE_ALLOW_LOCATE_IN_QUERY:
            case PropInterface.PROP_TYPE_PRINT_DATA:
            case PropInterface.PROP_TYPE_ALLOW_RANGE:
            case PropInterface.PROP_TYPE_ALLOW_LOCATE:
            case PropInterface.PROP_TYPE_ALLOW_SORT:
            case PropInterface.PROP_TYPE_PRELOAD_VIEW:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_INDEX:
                val = "1";
                break;
            case PropInterface.PROP_TYPE_CLOSE_TASKS_BY_MDI_MENU:
                val = "0";
                break;
            default:
                handled.value = false;
                break;
        }
        return val;
    }
    static getDefaultValue(propId, parentType, propParent) {
        let val = null;
        let control = null;
        if (parentType === GuiConstants.PARENT_TYPE_TASK) {
            let handled = new RefParam(false);
            val = this.getDefaultValueForTask(propId, handled);
            if (handled.value)
                return val;
        }
        switch (propId) {
            case PropInterface.PROP_TYPE_COLOR:
                val = this.getNumericMgValue(propParent, "1");
                if (parentType === GuiConstants.PARENT_TYPE_CONTROL) {
                    control = propParent;
                    if (control.Type === MgControlType.CTRL_TYPE_BUTTON && control.IsImageButton())
                        val = this.getNumericMgValue(propParent, "0");
                }
                break;
            case PropInterface.PROP_TYPE_BORDER:
                val = "0";
                if (parentType === GuiConstants.PARENT_TYPE_CONTROL) {
                    control = propParent;
                    switch (control.Type) {
                        case MgControlType.CTRL_TYPE_SUBFORM:
                            val = "0";
                            break;
                        case MgControlType.CTRL_TYPE_TEXT:
                        case MgControlType.CTRL_TYPE_TABLE:
                        case MgControlType.CTRL_TYPE_LIST:
                        case MgControlType.CTRL_TYPE_BROWSER:
                            val = "1";
                            break;
                    }
                }
                break;
            case PropInterface.PROP_TYPE_MAXBOX:
            case PropInterface.PROP_TYPE_MINBOX:
            case PropInterface.PROP_TYPE_MUST_INPUT:
            case PropInterface.PROP_TYPE_MULTILINE:
            case PropInterface.PROP_TYPE_PASSWORD:
            case PropInterface.PROP_TYPE_HEBREW:
            case PropInterface.PROP_TYPE_MULTILINE_VERTICAL_SCROLL:
            case PropInterface.PROP_TYPE_MULTILINE_ALLOW_CR:
            case PropInterface.PROP_TYPE_IS_CACHED:
            case PropInterface.PROP_TYPE_MODIFY_IN_QUERY:
            case PropInterface.PROP_TYPE_SHOW_FULL_ROW:
            case PropInterface.PROP_TYPE_TRACK_SELECTION:
            case PropInterface.PROP_TYPE_COLUMN_DIVIDER:
            case PropInterface.PROP_TYPE_LINE_DIVIDER:
            case PropInterface.PROP_TYPE_THREE_STATES:
            case PropInterface.PROP_TYPE_REFRESH_WHEN_HIDDEN:
            case PropInterface.PROP_TYPE_RETAIN_FOCUS:
            case PropInterface.PROP_TYPE_ROW_PLACEMENT:
            case PropInterface.PROP_TYPE_SHOW_IN_WINDOW_MENU:
            case PropInterface.PROP_TYPE_DATAVIEWCONTROL:
            case PropInterface.PROP_TYPE_SORT_COLUMN:
            case PropInterface.PROP_TYPE_BEFORE_900_VERSION:
            case PropInterface.PROP_TYPE_FILL_WIDTH:
            case PropInterface.PROP_TYPE_MULTI_COLUMN_DISPLAY:
            case PropInterface.PROP_TYPE_AUTO_COMPLETE_MODE_WC:
                val = "0";
                break;
            case PropInterface.PROP_TYPE_SYSTEM_MENU:
            case PropInterface.PROP_TYPE_TITLE_BAR:
            case PropInterface.PROP_TYPE_ENABLED:
            case PropInterface.PROP_TYPE_VISIBLE:
            case PropInterface.PROP_TYPE_TAB_IN:
            case PropInterface.PROP_TYPE_MODIFIABLE:
            case PropInterface.PROP_TYPE_HIGHLIGHTING:
            case PropInterface.PROP_TYPE_AUTO_REFRESH:
            case PropInterface.PROP_TYPE_PARK_ON_CLICK:
            case PropInterface.PROP_TYPE_DISPLAY_MENU:
            case PropInterface.PROP_TYPE_DISPLAY_TOOLBAR:
            case PropInterface.PROP_TYPE_SHOW_BUTTONS:
            case PropInterface.PROP_TYPE_LINES_AT_ROOT:
            case PropInterface.PROP_TYPE_SCROLL_BAR:
            case PropInterface.PROP_TYPE_SHOW_LINES:
            case PropInterface.PROP_TYPE_ALLOW_QUERY:
            case PropInterface.PROP_TYPE_RIGHT_BORDER:
            case PropInterface.PROP_TYPE_TOP_BORDER:
            case PropInterface.PROP_TYPE_TOP_BORDER_MARGIN:
            case PropInterface.PROP_TYPE_SHOW_ELLIPISIS:
                val = "1";
                break;
            case PropInterface.PROP_TYPE_TRIGGER:
            case PropInterface.PROP_TYPE_PROMPT:
            case PropInterface.PROP_TYPE_DISPLAY_LIST:
            case PropInterface.PROP_TYPE_DATA:
            case PropInterface.PROP_TYPE_IMAGE_FILENAME:
            case PropInterface.PROP_TYPE_LABEL:
            case PropInterface.PROP_TYPE_PLACEMENT:
            case PropInterface.PROP_TYPE_PULLDOWN_MENU:
            case PropInterface.PROP_TYPE_CONTEXT_MENU:
            case PropInterface.PROP_TYPE_NODE_ID:
            case PropInterface.PROP_TYPE_NODE_PARENTID:
            case PropInterface.PROP_TYPE_SELECT_PROGRAM:
            case PropInterface.PROP_TYPE_VISIBLE_LAYERS_LIST:
            case PropInterface.PROP_TYPE_EXPANDED_IMAGEIDX:
            case PropInterface.PROP_TYPE_COLLAPSED_IMAGEIDX:
            case PropInterface.PROP_TYPE_OBJECT_TYPE:
            case PropInterface.PROP_TYPE_TAB_ORDER:
            case PropInterface.PROP_TYPE_LOAD_IMAGE_FROM:
            case PropInterface.PROP_TYPE_FORM_NAME:
            case PropInterface.PROP_TYPE_COLUMN_TITLE:
            case PropInterface.PROP_TYPE_WIDTH:
            case PropInterface.PROP_TYPE_PRGTSK_NUM:
                break;
            case PropInterface.PROP_TYPE_MULTILINE_WORDWRAP_SCROLL:
            case PropInterface.PROP_TYPE_BORDER_STYLE:
                val = this.getNumericMgValue(propParent, "2");
                break;
            case PropInterface.PROP_TYPE_WINDOW_TYPE:
                val = this.getNumericMgValue(propParent, "6");
                break;
            case PropInterface.PROP_TYPE_ROW_HIGHLIGHT_STYLE:
                val = this.getNumericMgValue(propParent, "4");
                break;
            case PropInterface.PROP_TYPE_GRADIENT_STYLE:
            case PropInterface.PROP_TYPE_TABBING_ORDER:
            case PropInterface.PROP_TYPE_STARTUP_MODE:
            case PropInterface.PROP_TYPE_CHOICE_COLUMNS:
            case PropInterface.PROP_TYPE_HORIZONTAL_ALIGNMENT:
            case PropInterface.PROP_TYPE_FONT:
            case PropInterface.PROP_TYPE_WALLPAPER_STYLE:
            case PropInterface.PROP_TYPE_CHECKBOX_MAIN_STYLE:
            case PropInterface.PROP_TYPE_TAB_CONTROL_SIDE:
            case PropInterface.PROP_TYPE_RAISE_AT:
            case PropInterface.PROP_TYPE_ALLOWED_DIRECTION:
            case PropInterface.PROP_TYPE_SUBFORM_TYPE:
            case PropInterface.PROP_TYPE_UOM:
            case PropInterface.PROP_TYPE_BOTTOM_POSITION_INTERVAL:
                val = this.getNumericMgValue(propParent, "1");
                break;
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_TRANSACTION_MODE:
                val = TransMode.Physical;
                break;
            case PropInterface.PROP_TYPE_PARKED_COLLAPSED_IMAGEIDX:
            case PropInterface.PROP_TYPE_PARKED_IMAGEIDX:
            case PropInterface.PROP_TYPE_MINIMUM_HEIGHT:
            case PropInterface.PROP_TYPE_TOP:
            case PropInterface.PROP_TYPE_LEFT:
            case PropInterface.PROP_TYPE_TITLE_HEIGHT:
            case PropInterface.PROP_TYPE_LAYER:
            case PropInterface.PROP_TYPE_VISIBLE_LINES:
            case PropInterface.PROP_TYPE_FRAMESET_STYLE:
            case PropInterface.PROP_TYPE_TRANSLATOR:
            case PropInterface.PROP_TYPE_HOR_FAC:
            case PropInterface.PROP_TYPE_VER_FAC:
            case PropInterface.PROP_TYPE_FOCUS_COLOR:
                val = this.getNumericMgValue(propParent, "0");
                break;
            case PropInterface.PROP_TYPE_STYLE_3D:
                if (parentType === GuiConstants.PARENT_TYPE_CONTROL) {
                    control = propParent;
                    switch (control.Type) {
                        case MgControlType.CTRL_TYPE_COMBO:
                            val = this.getNumericMgValue(propParent, "2");
                            break;
                        case MgControlType.CTRL_TYPE_RADIO:
                        case MgControlType.CTRL_TYPE_CHECKBOX:
                            val = this.getNumericMgValue(propParent, "3");
                            break;
                    }
                }
                break;
            case PropInterface.PROP_TYPE_IMAGE_LIST_INDEXES:
            case PropInterface.PROP_TYPE_WALLPAPER:
            case PropInterface.PROP_TYPE_TEXT:
            case PropInterface.PROP_TYPE_TOOLTIP:
            case PropInterface.PROP_TYPE_FORMAT:
                val = NString.Empty;
                break;
            case PropInterface.PROP_TYPE_IMAGE_STYLE:
                val = this.getNumericMgValue(propParent, "2");
                break;
            case PropInterface.PROP_TYPE_SELECTION_MODE:
                val = this.getNumericMgValue(propParent, String(ListboxSelectionMode.Single));
                break;
            case PropInterface.PROP_TYPE_INDEX:
            case PropInterface.PROP_TYPE_LINK_FIELD:
            case PropInterface.PROP_TYPE_DISPLAY_FIELD:
            case PropInterface.PROP_TYPE_PERSISTENT_FORM_STATE_VERSION:
                val = this.getNumericMgValue(propParent, "0");
                break;
            default:
                Debug.Assert(false, "Undefined default value");
                break;
        }
        return val;
    }
    static GetPropertyName(propTypeId) {
        return "{Field ID " + propTypeId + "}";
    }
}

class CustomValidatorProp {
}
;
class CustomValidator {
    constructor(valid, errMessage) {
        this._valid = valid;
        this._errorMessage = errMessage;
    }
    isValid() { return this._valid; }
    getErrMessage() { return this._errorMessage; }
}
class Property {
    get TaskDefinitionId() {
        return this._taskDefinitionId;
    }
    constructor(cId, cParentObj, parType, val) {
        this._id = Int32.MinValue;
        this._dataType = StorageAttribute.NONE;
        this._val = null;
        this._pic = null;
        this._expId = 0;
        this._parentObj = null;
        this._parentType = null;
        this._prevValues = null;
        this._orgValue = null;
        this._taskDefinitionId = null;
        this.StudioValue = null;
        this._expAlreadyComputedOnce = false;
        this.customProperties = new Map();
        this.customPropertiesValues = new Map();
        this.customValidatorProperties = new Map();
        this.customValidatorValues = new Map();
        if (arguments.length === 0)
            this.constructor_0();
        else if (arguments.length === 3)
            this.constructor_1(cId, cParentObj, parType);
        else
            this.constructor_2(cId, cParentObj, parType, val);
    }
    constructor_0() {
        this._prevValues = new List();
    }
    constructor_1(cId, cParentObj, parType) {
        this.constructor_0();
        this.setId(cId);
        this._parentObj = cParentObj;
        this._parentType = parType;
        this.setDataType();
    }
    constructor_2(cId, cParentObj, parType, val) {
        this.constructor_1(cId, cParentObj, parType);
        this.setValue(val);
        this.setOrgValue();
    }
    setId(cId) {
        this._id = cId;
    }
    fillData(parentRef, parType, parser) {
        let endContext = parser.getXMLdata().indexOf(">", parser.getCurrIndex());
        if (this._parentObj === null && parentRef !== null) {
            this._parentObj = parentRef;
            this._parentType = parType;
        }
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(XMLConstants.MG_TAG_PROP) + XMLConstants.MG_TAG_PROP.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            if (Events.ShouldLog(Logger_LogLevels.Development)) {
                Events.WriteDevToLog(NString.Format("In Prop.FillData(): {0}", tokensVector.toString()));
            }
            this.initElements(tokensVector);
            parser.setCurrIndex(endContext + XMLConstants.TAG_CLOSE.length);
            this.InitInnerObjects(parser);
            if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL)
                this.setControlAttributes();
            else if (this._parentType === GuiConstants.PARENT_TYPE_FORM)
                this._prevValues.SetSize(1);
        }
        else
            Events.WriteExceptionToLog("In Property.FillData(): Out of string bounds");
    }
    InitInnerObjects(xmlParser) {
        let nextTag = xmlParser.getNextTag();
        if (nextTag === XMLConstants.MG_TAG_TASKDEFINITIONID_ENTRY) {
            let xmlBuffer = xmlParser.ReadToEndOfCurrentElement();
            this.InitTaskDefinitionId(xmlBuffer);
            let endContext = xmlParser.getXMLdata().indexOf(XMLConstants.MG_TAG_PROP + XMLConstants.TAG_CLOSE, xmlParser.getCurrIndex());
            xmlParser.setCurrIndex(endContext + (XMLConstants.MG_TAG_PROP + XMLConstants.TAG_CLOSE).length);
        }
    }
    initElements(tokensVector) {
        for (let j = 0; j < tokensVector.length; j += 2) {
            let attribute = (tokensVector.get_Item(j));
            let valueStr = (tokensVector.get_Item(j + 1));
            switch (attribute) {
                case XMLConstants.MG_ATTR_ID:
                    this.setId(XmlParser.getInt(valueStr));
                    this.setDataType();
                    break;
                case XMLConstants.MG_ATTR_STUDIO_VALUE:
                    this.StudioValue = XmlParser.unescape(valueStr);
                    break;
                case XMLConstants.MG_ATTR_VALUE:
                    if (this._id === PropInterface.PROP_TYPE_CUSTOM_PROPERTIES) {
                        this.InitCustomProperties(XmlParser.unescape(valueStr));
                    }
                    if (this._id === PropInterface.PROP_TYPE_CUSTOM_VALIDATORS) {
                        this.InitCustomValidationProperties(XmlParser.unescape(valueStr));
                    }
                    else {
                        this._val = XmlParser.unescape(valueStr);
                        this._orgValue = this._val;
                    }
                    break;
                case XMLConstants.MG_ATTR_EXP:
                    this._expId = XmlParser.getInt(valueStr);
                    if (this._expId > 0 && this._id === PropInterface.PROP_TYPE_TOOLTIP)
                        this.setDataType();
                    break;
                case XMLConstants.MG_ATTR_NAME:
                    break;
                case XMLConstants.MG_ATTR_CTL_IDX:
                    this._taskDefinitionId.CtlIndex = XmlParser.getInt(valueStr);
                    break;
                case XMLConstants.MG_ATTR_PROGRAM_ISN:
                    this._taskDefinitionId.ProgramIsn = XmlParser.getInt(valueStr);
                    break;
                default:
                    Events.WriteExceptionToLog(NString.Format("There is no such tag in Property class. Insert case to Property.initElements for {0}", attribute));
                    break;
            }
            if (this.IsComputedOnceOnServer())
                this._expAlreadyComputedOnce = true;
        }
    }
    InitCustomProperties(customProprtiesStr) {
        this.customProperties = new Map(JSON.parse(customProprtiesStr));
        if (this._parentObj.IsFirstRefreshOfProps())
            this.SetFirstValueForCustomProperties();
    }
    InitCustomValidator(parser) {
        let text = parser.ReadToEndOfCurrentElement();
        text = text.substr(text.indexOf(XMLConstants.MG_TAG_CUSTOM_VALIDATOR) + XMLConstants.MG_TAG_CUSTOM_VALIDATOR.length);
        let tokens = XmlParser.getTokens(text, XMLConstants.XML_ATTR_DELIM);
        let c = new CustomValidatorProp();
        let key;
        for (let j = 0; j < tokens.length; j += 2) {
            let attribute = tokens.get_Item(j);
            let valueStr = tokens.get_Item(j + 1);
            switch (attribute) {
                case XMLConstants.MG_ATTR_EXP:
                    c._exp = XmlParser.getInt(valueStr);
                    break;
                case XMLConstants.MG_ATTR_NAME:
                    key = XmlParser.unescape(valueStr);
                    break;
                case XMLConstants.MG_ATTR_ERROR_EXP:
                    c._errorMessageExp = XmlParser.getInt(valueStr);
                    break;
                case XMLConstants.MG_ATTR_ERROR:
                    c._errorMessage = XmlParser.unescape(valueStr);
                    break;
            }
        }
        this.customValidatorProperties.set(key, c);
    }
    InitCustomValidationProperties(customProprtiesStr) {
        let parser = new XmlParser(customProprtiesStr);
        let currTagName = parser.getNextTag();
        while (currTagName != null) {
            switch (currTagName) {
                case XMLConstants.MG_TAG_CUSTOM_VALIDATORS:
                    parser.setCurrIndex2EndOfTag();
                    this.customValidatorProperties = new Map();
                    break;
                case XMLConstants.MG_TAG_CUSTOM_VALIDATOR:
                    this.InitCustomValidator(parser);
                    break;
                default:
                    parser.setCurrIndex2EndOfTag();
                    break;
            }
            currTagName = parser.getNextTag();
        }
        if (this._parentObj.IsFirstRefreshOfProps())
            this.SetFirstValueForCustomValidationProperties();
    }
    SetFirstValueForCustomValidationProperties() {
        for (let customProperty of this.customValidatorProperties.keys()) {
            this.customValidatorValues.set(customProperty, new CustomValidator(true, ""));
        }
        this._val = this.GetArrayValuesForCustomValidationProperties();
        this._orgValue = this._val;
    }
    GetArrayValuesForCustomValidationProperties() {
        let values = Array.from(this.customValidatorValues.values());
        let valuesStr = JSON.stringify(values);
        return valuesStr;
    }
    GetArrayValuesForCustomProperties() {
        let values = Array.from(this.customPropertiesValues.values());
        let valuesStr = JSON.stringify(values);
        return valuesStr;
    }
    SetFirstValueForCustomProperties() {
        for (let customProperty of this.customProperties.keys())
            this.customPropertiesValues.set(customProperty, "");
        this._val = this.GetArrayValuesForCustomProperties();
        this._orgValue = this._val;
    }
    InitTaskDefinitionId(xmlBuffer) {
        let taskDefinitionIdTableSaxHandler = new TaskDefinitionIdTableSaxHandler(this.SetTaskDefinitionId);
        taskDefinitionIdTableSaxHandler.parse(xmlBuffer);
    }
    SetTaskDefinitionId(taskDefinitionId) {
        this._taskDefinitionId = taskDefinitionId;
    }
    setDataType() {
        let compIdx = this._parentObj.getCompIdx();
        this._pic = null;
        if (this._id === Int32.MinValue) {
            Events.WriteExceptionToLog(NString.Format("To fill dataType member in Property.FillDataType must id!={0}", Int32.MinValue));
            return;
        }
        switch (this._id) {
            case PropInterface.PROP_TYPE_TITLE_BAR:
            case PropInterface.PROP_TYPE_DISPLAY_MENU:
            case PropInterface.PROP_TYPE_BORDER:
            case PropInterface.PROP_TYPE_HEBREW:
            case PropInterface.PROP_TYPE_MODIFY_IN_QUERY:
            case PropInterface.PROP_TYPE_SYSTEM_MENU:
            case PropInterface.PROP_TYPE_END_CONDITION:
            case PropInterface.PROP_TYPE_SELECTION:
            case PropInterface.PROP_TYPE_ALLOW_MODIFY:
            case PropInterface.PROP_TYPE_ALLOW_CREATE:
            case PropInterface.PROP_TYPE_ALLOW_DELETE:
            case PropInterface.PROP_TYPE_ALLOW_QUERY:
            case PropInterface.PROP_TYPE_ALLOW_RANGE:
            case PropInterface.PROP_TYPE_ALLOW_LOCATE:
            case PropInterface.PROP_TYPE_ALLOW_SORT:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_INDEX:
            case PropInterface.PROP_TYPE_ALLOW_LOCATE_IN_QUERY:
            case PropInterface.PROP_TYPE_CONFIRM_UPDATE:
            case PropInterface.PROP_TYPE_FORCE_SUFFIX:
            case PropInterface.PROP_TYPE_FORCE_DELETE:
            case PropInterface.PROP_TYPE_MUST_INPUT:
            case PropInterface.PROP_TYPE_MODIFIABLE:
            case PropInterface.PROP_TYPE_VISIBLE:
            case PropInterface.PROP_TYPE_ENABLED:
            case PropInterface.PROP_TYPE_CONFIRM_CANCEL:
            case PropInterface.PROP_TYPE_REPEATABLE:
            case PropInterface.PROP_TYPE_HIGHLIGHTING:
            case PropInterface.PROP_TYPE_PASSWORD:
            case PropInterface.PROP_TYPE_MULTILINE:
            case PropInterface.PROP_TYPE_IS_CACHED:
            case PropInterface.PROP_TYPE_PRELOAD_VIEW:
            case PropInterface.PROP_TYPE_MULTILINE_VERTICAL_SCROLL:
            case PropInterface.PROP_TYPE_MULTILINE_ALLOW_CR:
            case PropInterface.PROP_TYPE_ALLOW_COL_RESIZE:
            case PropInterface.PROP_TYPE_ALLOW_REORDER:
            case PropInterface.PROP_TYPE_SHOW_LINES:
            case PropInterface.PROP_TYPE_SORT_COLUMN:
            case PropInterface.PROP_TYPE_COL_ALLOW_FILTERING:
            case PropInterface.PROP_TYPE_DISPLAY_STATUS_BAR:
            case PropInterface.PROP_TYPE_AUTO_REFRESH:
            case PropInterface.PROP_TYPE_PARK_ON_CLICK:
            case PropInterface.PROP_TYPE_SHOW_FULL_ROW:
            case PropInterface.PROP_TYPE_TRACK_SELECTION:
            case PropInterface.PROP_TYPE_SHOW_BUTTONS:
            case PropInterface.PROP_TYPE_LINES_AT_ROOT:
            case PropInterface.PROP_TYPE_ALLOW_EMPTY_DATAVIEW:
            case PropInterface.PROP_TYPE_SCROLL_BAR:
            case PropInterface.PROP_TYPE_COLUMN_DIVIDER:
            case PropInterface.PROP_TYPE_LINE_DIVIDER:
            case PropInterface.PROP_TYPE_THREE_STATES:
            case PropInterface.PROP_TYPE_REFRESH_WHEN_HIDDEN:
            case PropInterface.PROP_TYPE_ALLOW_OPTION:
            case PropInterface.PROP_TYPE_RETAIN_FOCUS:
            case PropInterface.PROP_TYPE_PRINT_DATA:
            case PropInterface.PROP_TYPE_CLOSE_TASKS_BY_MDI_MENU:
            case PropInterface.PROP_TYPE_DATAVIEWCONTROL:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_OPEN_TASK_WINDOW:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_EVENTS:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_INDEX_OPTIMIZATION:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_RANGE:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_LOCATE:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_POSITION:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_SQL_RANGE:
            case PropInterface.PROP_TYPE_BEFORE_900_VERSION:
            case PropInterface.PROP_TYPE_FILL_WIDTH:
            case PropInterface.PROP_TYPE_MULTI_COLUMN_DISPLAY:
            case PropInterface.PROP_TYPE_IS_ROUTER_OUTLET:
            case PropInterface.PROP_TYPE_DEFAULT_OUTLET:
            case PropInterface.PROP_TYPE_SERVER_READ_AHEAD:
            case PropInterface.PROP_TYPE_AUTO_COMPLETE_MODE_WC:
                this._dataType = StorageAttribute.BOOLEAN;
                break;
            case PropInterface.PROP_TYPE_IMAGE_FILENAME:
            case PropInterface.PROP_TYPE_EVAL_END_CONDITION:
            case PropInterface.PROP_TYPE_FRAME_NAME:
            case PropInterface.PROP_TYPE_NAME:
            case PropInterface.PROP_TYPE_TRASACTION_BEGIN:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_TRANSACTION_MODE:
            case PropInterface.PROP_TYPE_WALLPAPER:
            case PropInterface.PROP_TYPE_ATTRIBUTE:
            case PropInterface.PROP_TYPE_TRIGGER:
            case PropInterface.PROP_TYPE_SELECT_MODE:
            case PropInterface.PROP_TYPE_TASK_ID:
            case PropInterface.PROP_TYPE_TABBING_CYCLE:
            case PropInterface.PROP_TYPE_PARAMETERS:
            case PropInterface.PROP_TYPE_IMAGE_LIST_INDEXES:
            case PropInterface.PROP_TYPE_VISIBLE_LAYERS_LIST:
            case PropInterface.PROP_TYPE_OBJECT_TYPE:
            case PropInterface.PROP_TYPE_REAL_OBJECT_TYPE:
            case PropInterface.PROP_TYPE_DATAVIEWCONTROL_FIELDS:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_RANGE_ORDER:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_LOCATE_ORDER:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_POSITION_USAGE:
            case PropInterface.PROP_TYPE_TASK_MODE:
            case PropInterface.PROP_TYPE_CUSTOM_PROPERTIES:
            case PropInterface.PROP_TYPE_CUSTOM_VALIDATORS:
                this._dataType = StorageAttribute.ALPHA;
                break;
            case PropInterface.PROP_TYPE_COLUMN_TITLE:
            case PropInterface.PROP_TYPE_DISPLAY_LIST:
            case PropInterface.PROP_TYPE_LABEL:
            case PropInterface.PROP_TYPE_FORMAT:
            case PropInterface.PROP_TYPE_RANGE:
            case PropInterface.PROP_TYPE_FORM_NAME:
            case PropInterface.PROP_TYPE_ADDITIONAL_INFORMATION:
            case PropInterface.PROP_TYPE_TEXT:
            case PropInterface.PROP_TYPE_HINT:
                this._dataType = StorageAttribute.UNICODE;
                break;
            case PropInterface.PROP_TYPE_UOM:
            case PropInterface.PROP_TYPE_HOR_FAC:
            case PropInterface.PROP_TYPE_VER_FAC:
            case PropInterface.PROP_TYPE_TAB_ORDER:
            case PropInterface.PROP_TYPE_WALLPAPER_STYLE:
            case PropInterface.PROP_TYPE_INDEX:
            case PropInterface.PROP_TYPE_LINK_FIELD:
            case PropInterface.PROP_TYPE_DISPLAY_FIELD:
            case PropInterface.PROP_TYPE_PULLDOWN_MENU:
            case PropInterface.PROP_TYPE_WINDOW_TYPE:
            case PropInterface.PROP_TYPE_IMAGE_STYLE:
            case PropInterface.PROP_TYPE_AUTO_FIT:
            case PropInterface.PROP_TYPE_RAISE_AT:
            case PropInterface.PROP_TYPE_EXPAND_WINDOW:
            case PropInterface.PROP_TYPE_VISIBLE_LINES:
            case PropInterface.PROP_TYPE_CHOICE_COLUMNS:
            case PropInterface.PROP_TYPE_STYLE_3D:
            case PropInterface.PROP_TYPE_FONT:
            case PropInterface.PROP_TYPE_LAYER:
            case PropInterface.PROP_TYPE_WIDTH:
            case PropInterface.PROP_TYPE_TITLE_HEIGHT:
            case PropInterface.PROP_TYPE_COLOR:
            case PropInterface.PROP_TYPE_LEFT:
            case PropInterface.PROP_TYPE_TOP:
            case PropInterface.PROP_TYPE_TOOLTIP:
            case PropInterface.PROP_TYPE_HELP_SCR:
            case PropInterface.PROP_TYPE_LINES_IN_TABLE:
            case PropInterface.PROP_TYPE_SELECTION_ROWS:
            case PropInterface.PROP_TYPE_HORIZONTAL_ALIGNMENT:
            case PropInterface.PROP_TYPE_MULTILINE_WORDWRAP_SCROLL:
            case PropInterface.PROP_TYPE_ROW_HEIGHT:
            case PropInterface.PROP_TYPE_WINDOW_WIDTH:
            case PropInterface.PROP_TYPE_MAIN_DISPLAY:
            case PropInterface.PROP_TYPE_TRANSLATOR:
            case PropInterface.PROP_TYPE_FRAMESET_STYLE:
            case PropInterface.PROP_TYPE_FRAME_TYPE:
            case PropInterface.PROP_TYPE_ALLOWED_DIRECTION:
            case PropInterface.PROP_TYPE_ROW_HIGHLIGHT_STYLE:
            case PropInterface.PROP_TYPE_VERTICAL_ALIGNMENT:
            case PropInterface.PROP_TYPE_TABBING_ORDER:
            case PropInterface.PROP_TYPE_STATIC_TYPE:
            case PropInterface.PROP_TYPE_BUTTON_STYLE:
            case PropInterface.PROP_TYPE_LOAD_IMAGE_FROM:
            case PropInterface.PROP_TYPE_SUBFORM_TYPE:
            case PropInterface.PROP_TYPE_BOTTOM_POSITION_INTERVAL:
            case PropInterface.PROP_TYPE_SELECTION_MODE:
            case PropInterface.PROP_TYPE_PRGTSK_NUM:
            case PropInterface.PROP_TYPE_PERSISTENT_FORM_STATE_VERSION:
            case PropInterface.PROP_TYPE_SCROLL_BAR_THUMB:
            case PropInterface.PROP_TYPE_BINDING_LEVEL:
            case PropInterface.PROP_TYPE_CONNECTED_ZOOM_CONTROL:
            case PropInterface.PROP_TYPE_SELECT_PROGRAM:
                if (this._id === PropInterface.PROP_TYPE_TOOLTIP && this._expId > 0)
                    this._dataType = StorageAttribute.UNICODE;
                else {
                    this._dataType = StorageAttribute.NUMERIC;
                    if (Property._numericPropertyPic == null)
                        Property._numericPropertyPic = new PIC("N6", StorageAttribute.NUMERIC, compIdx);
                    this._pic = Property._numericPropertyPic;
                }
                break;
            case PropInterface.PROP_TYPE_RETURN_ACTION:
                this._dataType = StorageAttribute.NONE;
                break;
            case PropInterface.PROP_TYPE_DATA:
                this._dataType = this._parentObj.DataType;
                break;
            case PropInterface.PROP_TYPE_POP_UP:
            case PropInterface.PROP_TYPE_ORIENTATION_LOCK:
            case PropInterface.PROP_TYPE_ENTER_ANIMATION:
            case PropInterface.PROP_TYPE_EXIT_ANIMATION:
            case PropInterface.PROP_TYPE_NAVIGATION_DRAWER_MENU:
            case PropInterface.PROP_TYPE_ACTION_BAR_MENU:
            case PropInterface.PROP_TYPE_OPEN_PICKER:
            case PropInterface.PROP_TYPE_OPEN_EDIT_DIALOG:
            case PropInterface.PROP_TYPE_DEFAULT_ALIGNMENT:
            case PropInterface.PROP_TYPE_KEYBOARD_TYPE:
            case PropInterface.PROP_TYPE_KEYBOARD_RETURN_KEY:
            case PropInterface.PROP_TYPE_ALLOW_SUGGESTIONS:
            case PropInterface.PROP_TYPE_MOBILE_IMAGE_LIST_FILE_NAME:
            case PropInterface.PROP_TYPE_SWIPE_REFRESH:
                break;
            default:
                Events.WriteExceptionToLog(NString.Format("in Property.setDataType() no case for: {0}", this._id));
                break;
        }
    }
    setControlAttributes() {
        if (this._parentObj == null || this._parentType !== GuiConstants.PARENT_TYPE_CONTROL) {
            Events.WriteExceptionToLog("in Property.setControlAttributes() there is no parent or the parent is not a control");
            return;
        }
        let parentControl = this._parentObj;
        switch (this._id) {
            case PropInterface.PROP_TYPE_FRAME_NAME:
            case PropInterface.PROP_TYPE_NAME:
                parentControl.Name = this._val;
                break;
            case PropInterface.PROP_TYPE_ATTRIBUTE:
                parentControl.DataType = this._val[0];
                break;
            case PropInterface.PROP_TYPE_FORMAT:
                parentControl.setPicStr(this._val, this._expId);
                break;
            case PropInterface.PROP_TYPE_RANGE:
                parentControl.setRange(this._val);
                break;
            case PropInterface.PROP_TYPE_DATA:
                if (this._expId > 0)
                    parentControl.setValExp(this._expId);
                else if (this._val != null)
                    parentControl.setField(this._val);
                break;
            case PropInterface.PROP_TYPE_BUTTON_STYLE:
                if (this._val != null)
                    parentControl.ButtonStyle = this.GetComputedValueInteger();
                break;
            case PropInterface.PROP_TYPE_LAYER:
                if (this._val != null)
                    parentControl.Layer = this.GetComputedValueInteger();
                break;
            default:
                break;
        }
    }
    getID() {
        return this._id;
    }
    setValue(mgVal) {
        let compIdx = this._parentObj.getCompIdx();
        if (this._id === PropInterface.PROP_TYPE_DATA || this._id === PropInterface.PROP_TYPE_NODE_ID || this._id === PropInterface.PROP_TYPE_NODE_PARENTID)
            return;
        if (this._dataType === StorageAttribute.NONE)
            this.setDataType();
        switch (this._dataType) {
            case StorageAttribute.NUMERIC:
                if (mgVal == null)
                    mgVal = "FF00000000000000000000000000000000000000";
                this._val = DisplayConvertor.Instance.mg2disp(mgVal, "", this._pic, false, compIdx, false).trim();
                break;
            case StorageAttribute.ALPHA:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
            case StorageAttribute.BOOLEAN:
            case StorageAttribute.UNICODE:
                this._val = mgVal;
                break;
            default:
                throw new ApplicationException("in Property.setValue() illegal data type: " + this._dataType);
        }
    }
    SetValue(val) {
        this._val = String(val);
    }
    setOrgValue() {
        this._orgValue = this._val;
    }
    GetTaskByParentObject() {
        let task = null;
        if (this._parentType === GuiConstants.PARENT_TYPE_FORM)
            task = this._parentObj.getTask();
        else if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL)
            task = this._parentObj.getForm().getTask();
        else if (this._parentType === GuiConstants.PARENT_TYPE_TASK)
            task = this._parentObj;
        return task;
    }
    async RefreshDisplay(forceRefresh) {
        await this.RefreshDisplayWithCurrentLine(forceRefresh, Int32.MinValue);
    }
    ShouldSkipRefreshControl() {
        let skip = false;
        let mgControl = this._parentObj;
        switch (this._id) {
            case PropInterface.PROP_TYPE_HEBREW:
                if (mgControl.isTableControl())
                    skip = true;
                break;
            case PropInterface.PROP_TYPE_NODE_ID:
            case PropInterface.PROP_TYPE_NODE_PARENTID:
            case PropInterface.PROP_TYPE_DATA:
            case PropInterface.PROP_TYPE_HIGHLIGHTING:
            case PropInterface.PROP_TYPE_MUST_INPUT:
            case PropInterface.PROP_TYPE_HELP_SCR:
            case PropInterface.PROP_TYPE_SELECT_PROGRAM:
            case PropInterface.PROP_TYPE_SELECT_MODE:
            case PropInterface.PROP_TYPE_ALLOWED_DIRECTION:
            case PropInterface.PROP_TYPE_RETURN_ACTION:
            case PropInterface.PROP_TYPE_ATTRIBUTE:
            case PropInterface.PROP_TYPE_REPEATABLE:
            case PropInterface.PROP_TYPE_FRAME_NAME:
            case PropInterface.PROP_TYPE_TRIGGER:
            case PropInterface.PROP_TYPE_TAB_ORDER:
            case PropInterface.PROP_TYPE_IS_CACHED:
            case PropInterface.PROP_TYPE_LAYER:
            case PropInterface.PROP_TYPE_AUTO_FIT:
            case PropInterface.PROP_TYPE_RAISE_AT:
            case PropInterface.PROP_TYPE_FRAMESET_STYLE:
            case PropInterface.PROP_TYPE_FRAME_TYPE:
            case PropInterface.PROP_TYPE_RANGE:
            case PropInterface.PROP_TYPE_WINDOW_WIDTH:
            case PropInterface.PROP_TYPE_TABBING_ORDER:
            case PropInterface.PROP_TYPE_AUTO_REFRESH:
            case PropInterface.PROP_TYPE_PARAMETERS:
            case PropInterface.PROP_TYPE_OBJECT_TYPE:
            case PropInterface.PROP_TYPE_RETAIN_FOCUS:
            case PropInterface.PROP_TYPE_SUBFORM_TYPE:
            case PropInterface.PROP_TYPE_REAL_OBJECT_TYPE:
            case PropInterface.PROP_TYPE_ADDITIONAL_INFORMATION:
            case PropInterface.PROP_TYPE_DATAVIEWCONTROL:
            case PropInterface.PROP_TYPE_DATAVIEWCONTROL_FIELDS:
            case PropInterface.PROP_TYPE_PRGTSK_NUM:
            case PropInterface.PROP_TYPE_INDEX:
            case PropInterface.PROP_TYPE_DISPLAY_FIELD:
            case PropInterface.PROP_TYPE_LINK_FIELD:
            case PropInterface.PROP_TYPE_BEFORE_900_VERSION:
            case PropInterface.PROP_TYPE_REFRESH_WHEN_HIDDEN:
            case PropInterface.PROP_TYPE_SERVER_READ_AHEAD:
                skip = true;
                break;
            case PropInterface.PROP_TYPE_BUTTON_STYLE:
                if (!this._parentObj.isRadio())
                    skip = true;
                break;
            default:
                break;
        }
        return skip;
    }
    ShouldSkipRefreshForm() {
        Debug.Assert(this._parentType === GuiConstants.PARENT_TYPE_FORM);
        let skip = false;
        let mgFormBase = this._parentObj;
        switch (this._id) {
            case PropInterface.PROP_TYPE_WINDOW_TYPE:
                if (!this._parentObj.IsFirstRefreshOfProps())
                    skip = true;
                break;
            case PropInterface.PROP_TYPE_LINES_IN_TABLE:
            case PropInterface.PROP_TYPE_HELP_SCR:
            case PropInterface.PROP_TYPE_TABBING_ORDER:
            case PropInterface.PROP_TYPE_PERSISTENT_FORM_STATE_VERSION:
                skip = true;
                break;
            default:
                break;
        }
        if (!skip && mgFormBase.isSubForm()) {
            skip = true;
            switch (this._id) {
                case PropInterface.PROP_TYPE_CUSTOM_PROPERTIES:
                case PropInterface.PROP_TYPE_CUSTOM_VALIDATORS:
                    skip = false;
                    break;
            }
        }
        return skip;
    }
    ShouldSkipRefreshTask() {
        let skip = false;
        switch (this._id) {
            case PropInterface.PROP_TYPE_ALLOW_CREATE:
            case PropInterface.PROP_TYPE_ALLOW_DELETE:
            case PropInterface.PROP_TYPE_ALLOW_MODIFY:
            case PropInterface.PROP_TYPE_ALLOW_QUERY:
            case PropInterface.PROP_TYPE_ALLOW_RANGE:
            case PropInterface.PROP_TYPE_ALLOW_LOCATE:
            case PropInterface.PROP_TYPE_ALLOW_SORT:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_INDEX:
            case PropInterface.PROP_TYPE_TABBING_CYCLE:
            case PropInterface.PROP_TYPE_CONFIRM_CANCEL:
            case PropInterface.PROP_TYPE_CONFIRM_UPDATE:
            case PropInterface.PROP_TYPE_END_CONDITION:
            case PropInterface.PROP_TYPE_EVAL_END_CONDITION:
            case PropInterface.PROP_TYPE_FORCE_SUFFIX:
            case PropInterface.PROP_TYPE_FORCE_DELETE:
            case PropInterface.PROP_TYPE_TASK_MODE:
            case PropInterface.PROP_TYPE_SELECTION:
            case PropInterface.PROP_TYPE_TRASACTION_BEGIN:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_TRANSACTION_MODE:
            case PropInterface.PROP_TYPE_PRINT_DATA:
            case PropInterface.PROP_TYPE_CLOSE_TASKS_BY_MDI_MENU:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_OPEN_TASK_WINDOW:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_EVENTS:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_CHUNK_SIZE:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_INDEX_OPTIMIZATION:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_RANGE:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_RANGE_ORDER:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_LOCATE:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_LOCATE_ORDER:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_POSITION:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_POSITION_USAGE:
            case PropInterface.PROP_TYPE_TASK_PROPERTIES_SQL_RANGE:
                skip = true;
                break;
            default:
                break;
        }
        return skip;
    }
    ShouldSkipRefresh() {
        let skip = false;
        switch (this._parentType) {
            case GuiConstants.PARENT_TYPE_CONTROL:
                skip = this.ShouldSkipRefreshControl();
                break;
            case GuiConstants.PARENT_TYPE_FORM:
                skip = this.ShouldSkipRefreshForm();
                break;
            case GuiConstants.PARENT_TYPE_TASK:
                skip = this.ShouldSkipRefreshTask();
                break;
            default:
                break;
        }
        switch (this._id) {
            case PropInterface.PROP_TYPE_POP_UP:
            case PropInterface.PROP_TYPE_ORIENTATION_LOCK:
            case PropInterface.PROP_TYPE_ENTER_ANIMATION:
            case PropInterface.PROP_TYPE_EXIT_ANIMATION:
            case PropInterface.PROP_TYPE_NAVIGATION_DRAWER_MENU:
            case PropInterface.PROP_TYPE_ACTION_BAR_MENU:
            case PropInterface.PROP_TYPE_OPEN_PICKER:
            case PropInterface.PROP_TYPE_OPEN_EDIT_DIALOG:
            case PropInterface.PROP_TYPE_DEFAULT_ALIGNMENT:
            case PropInterface.PROP_TYPE_KEYBOARD_TYPE:
            case PropInterface.PROP_TYPE_KEYBOARD_RETURN_KEY:
            case PropInterface.PROP_TYPE_ALLOW_SUGGESTIONS:
            case PropInterface.PROP_TYPE_MOBILE_IMAGE_LIST_FILE_NAME:
                skip = true;
                break;
        }
        return skip;
    }
    async RefreshDisplayWithCurrentLine(forceRefresh, currLine) {
        await this.RefreshDisplayWithCurrLineAndCheckSkipRefresh(forceRefresh, currLine, true);
    }
    SkipWhenNoExpression() {
        let skipWhenNoExpression = true;
        let ctrl = ((this._parentObj instanceof GuiControlPropertyAdapter) ? this._parentObj : null);
        if ((ctrl != null && ctrl.isButton() && this._id === PropInterface.PROP_TYPE_FORMAT) ||
            (ctrl != null && ctrl.isComboBox() && this._id === PropInterface.PROP_TYPE_LABEL) ||
            (ctrl != null && ctrl.isListBox() && this._id === PropInterface.PROP_TYPE_LABEL) ||
            (ctrl != null && ctrl.isRadio() && this._id === PropInterface.PROP_TYPE_LABEL) ||
            (ctrl != null && ctrl.isCheckBox() && this._id === PropInterface.PROP_TYPE_LABEL) ||
            (ctrl != null && ctrl.isTabControl() && this._id === PropInterface.PROP_TYPE_LABEL) ||
            (ctrl != null && ctrl.isImageControl() && this._id === PropInterface.PROP_TYPE_IMAGE_FILENAME) ||
            (ctrl != null && ctrl.IsImageButton() && this._id === PropInterface.PROP_TYPE_IMAGE_FILENAME) ||
            (ctrl != null && ctrl.isColumnControl() && this._id === PropInterface.PROP_TYPE_COLUMN_TITLE) ||
            (this._id === PropInterface.PROP_TYPE_DISPLAY_LIST) ||
            (this._id === PropInterface.PROP_TYPE_TEXT) ||
            (this._id === PropInterface.PROP_TYPE_TOOLTIP) ||
            (this._id === PropInterface.PROP_TYPE_HINT) ||
            (this._id === PropInterface.PROP_TYPE_PASSWORD) ||
            (this._id === PropInterface.PROP_TYPE_CUSTOM_PROPERTIES) ||
            (this._id === PropInterface.PROP_TYPE_CUSTOM_VALIDATORS) ||
            (this._id === PropInterface.PROP_TYPE_VISIBLE) ||
            (this._id === PropInterface.PROP_TYPE_ENABLED) ||
            (this._id === PropInterface.PROP_TYPE_BINDING_LEVEL))
            skipWhenNoExpression = false;
        return skipWhenNoExpression;
    }
    async RefreshDisplayWithCurrLineAndCheckSkipRefresh(forceRefresh, currLine, checkSkipRefresh) {
        let ctrl = null;
        let line = 0;
        let prevValue;
        let valChanged = true;
        if (this._val === null && this._expId === 0) {
            Events.WriteExceptionToLog("in Property.RefreshDisplay() null value and expression");
            return;
        }
        if (checkSkipRefresh && this.ShouldSkipRefresh())
            return;
        if (this._expId === 0 && this.SkipWhenNoExpression())
            return;
        if (this._prevValues.length === 0)
            this.setPrevArraySize();
        await this.ComputeValue();
        switch (this._parentType) {
            case GuiConstants.PARENT_TYPE_CONTROL:
                ctrl = this._parentObj;
                if (this._id === PropInterface.PROP_TYPE_FORMAT && this._expId > 0)
                    ctrl.computePIC(this._val);
                if (ctrl.IsRepeatable && !ctrl.getForm().isRefreshRepeatableAllowed())
                    return;
                if (currLine === Int32.MinValue)
                    line = this.getLine();
                else
                    line = currLine;
                prevValue = this._prevValues.get_Item(line);
                if (!forceRefresh && (this._val === prevValue)
                    && this._id !== PropInterface.PROP_TYPE_MODIFIABLE
                    && this._id !== PropInterface.PROP_TYPE_VISIBLE
                    && this._id !== PropInterface.PROP_TYPE_ENABLED)
                    return;
                if (ctrl.Type === MgControlType.CTRL_TYPE_COLUMN
                    && this._id === PropInterface.PROP_TYPE_VISIBLE
                    && this._val === prevValue)
                    return;
                if (this._val === prevValue)
                    valChanged = false;
                this._prevValues.set_Item(line, this._val);
                break;
            case GuiConstants.PARENT_TYPE_FORM:
                prevValue = this._prevValues.get_Item(0);
                if (!forceRefresh && (this._val === prevValue))
                    return;
                this._prevValues.set_Item(0, this._val);
                break;
            case GuiConstants.PARENT_TYPE_TASK:
                Events.WriteExceptionToLog(NString.Format("Property.RefreshDisplay(): task property {0} wasn't handled", this._id));
                return;
            default:
                Events.WriteExceptionToLog(NString.Format("Property.RefreshDisplay(): parentType unknown, property {0} wasn't handled", this._id));
                return;
        }
        switch (this._id) {
            case PropInterface.PROP_TYPE_IMAGE_FILENAME:
                this.onImageFileName();
                break;
            case PropInterface.PROP_TYPE_ENABLED:
                this.onEnable(valChanged);
                break;
            case PropInterface.PROP_TYPE_VISIBLE:
                await this.onVisible(valChanged);
                break;
            case PropInterface.PROP_TYPE_NAME:
                this.OnControlName();
                break;
            case PropInterface.PROP_TYPE_FORM_NAME:
                this.onFormName();
                break;
            case PropInterface.PROP_TYPE_COLUMN_TITLE:
                this.onText(0);
                break;
            case PropInterface.PROP_TYPE_TEXT:
                this.onText(line);
                break;
            case PropInterface.PROP_TYPE_HINT:
                this.onHint();
                break;
            case PropInterface.PROP_TYPE_MODIFIABLE:
                await this.onModifiable();
                break;
            case PropInterface.PROP_TYPE_TOOLTIP:
                this.onTooltip();
                break;
            case PropInterface.PROP_TYPE_DISPLAY_LIST:
                await this.onDisplayList(line);
                break;
            case PropInterface.PROP_TYPE_AUTO_COMPLETE_MODE_WC:
                this.onAutoCompleteMode();
                break;
            case PropInterface.PROP_TYPE_VISIBLE_LAYERS_LIST:
                await this.onVisibleLayerList(line);
                break;
            case PropInterface.PROP_TYPE_FORMAT:
                this.onFormat();
                break;
            case PropInterface.PROP_TYPE_LABEL:
                await this.onLabel(line);
                break;
            case PropInterface.PROP_TYPE_PASSWORD:
                this.onPassword();
                break;
            case PropInterface.PROP_TYPE_MODIFY_IN_QUERY:
            case PropInterface.PROP_TYPE_TAB_IN:
            case PropInterface.PROP_TYPE_PARK_ON_CLICK:
            case PropInterface.PROP_TYPE_LOAD_IMAGE_FROM:
                break;
            case PropInterface.PROP_TYPE_CUSTOM_PROPERTIES:
                this.onCustomProperties();
                break;
            case PropInterface.PROP_TYPE_CUSTOM_VALIDATORS:
                this.onCustomValidators();
                break;
            case PropInterface.PROP_TYPE_BINDING_LEVEL:
                this.onBindingLevel();
                break;
            default:
                Events.WriteExceptionToLog(NString.Format("Property.RefreshDisplay(): Property {0} wasn't handled", this._id));
                break;
        }
    }
    ShouldBeComputedOnce() {
        if (this._parentType === GuiConstants.PARENT_TYPE_TASK) {
            switch (this._id) {
                case PropInterface.PROP_TYPE_TASK_MODE:
                case PropInterface.PROP_TYPE_PRELOAD_VIEW:
                case PropInterface.PROP_TYPE_TABBING_CYCLE:
                case PropInterface.PROP_TYPE_TASK_PROPERTIES_OPEN_TASK_WINDOW:
                case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_EVENTS:
                case PropInterface.PROP_TYPE_ALLOW_LOCATE_IN_QUERY:
                case PropInterface.PROP_TYPE_PRINT_DATA:
                case PropInterface.PROP_TYPE_ALLOW_RANGE:
                case PropInterface.PROP_TYPE_ALLOW_LOCATE:
                case PropInterface.PROP_TYPE_ALLOW_SORT:
                case PropInterface.PROP_TYPE_TASK_PROPERTIES_ALLOW_INDEX:
                case PropInterface.PROP_TYPE_MAIN_DISPLAY:
                    return true;
            }
        }
        else if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            if (this._id === PropInterface.PROP_TYPE_IS_CACHED || this._id === PropInterface.PROP_TYPE_MULTILINE)
                return true;
        }
        return false;
    }
    IsComputedOnceOnServer() {
        if (this.ShouldBeComputedOnce()) {
            let task = this.GetTaskByParentObject();
            if (task != null)
                return !task.ShouldEvaluatePropertyLocally(this._id);
        }
        return false;
    }
    async ComputeValue() {
        let result = null;
        let len = 255;
        let wasEvaluated = new RefParam(false);
        if (this._id === PropInterface.PROP_TYPE_CUSTOM_PROPERTIES) {
            await this.computeCustomPropertiesValues();
            result = this.GetArrayValuesForCustomProperties();
            this.setValue(result);
        }
        if (this._id === PropInterface.PROP_TYPE_CUSTOM_VALIDATORS) {
            let evaluated = await this.computeCustomValidators();
            if (evaluated) {
                result = this.GetArrayValuesForCustomValidationProperties();
                this.setValue(result);
            }
        }
        else if (this._expId > 0) {
            if (this.ShouldBeComputedOnce() && this._expAlreadyComputedOnce)
                return;
            this._expAlreadyComputedOnce = true;
            let alwaysEvaluate = false;
            if (this._parentType === GuiConstants.PARENT_TYPE_TASK)
                alwaysEvaluate = true;
            if (this._id === PropInterface.PROP_TYPE_FORMAT) {
                len = 65535;
                result = StrUtil.rtrim(await this._parentObj.EvaluateExpression(this._expId, this._dataType, len, true, StorageAttribute.SKIP, alwaysEvaluate, wasEvaluated));
            }
            else {
                try {
                    result = await this._parentObj.EvaluateExpression(this._expId, this._dataType, len, true, StorageAttribute.SKIP, alwaysEvaluate, wasEvaluated);
                }
                catch (e) {
                    let warningMsg = new StringBuilder("Exception: " + e.Message);
                    if (this._parentObj instanceof GuiControlPropertyAdapter)
                        warningMsg.Append(" Control: " + this._parentObj.Name);
                    Events.WriteWarningToLog(warningMsg.ToString());
                }
            }
            if (wasEvaluated.value) {
                result = this.updateResult(result);
                this.setValue(result);
            }
            else if (this._val == null && this._parentType !== GuiConstants.PARENT_TYPE_CONTROL) {
                result = PropDefaults.getDefaultValue(this._id, this._parentType, this._parentObj);
                this.setValue(result);
            }
        }
    }
    updateResult(result) {
        switch (this._id) {
            case PropInterface.PROP_TYPE_FORMAT:
                if (result == null)
                    result = NString.Empty;
                break;
            case PropInterface.PROP_TYPE_TASK_MODE:
                result = Property.updateTaskModeResult(result);
                break;
            default:
                return result;
        }
        return result;
    }
    static updateTaskModeResult(result) {
        let code = ' ';
        if (!NString.IsNullOrEmpty(result)) {
            code = result[0].toUpperCase();
            switch (code) {
                case 'Q':
                    code = 'E';
                    break;
                case 'F':
                    code = 'O';
                    break;
                case 'O':
                    code = 'N';
                    break;
            }
        }
        return code;
    }
    async getValue() {
        await this.ComputeValue();
        return this._val;
    }
    async getValueInt() {
        let result = 0;
        await this.ComputeValue();
        if (this._val !== null)
            result = NNumber.Parse(this._val);
        return result;
    }
    GetComputedValueInteger() {
        return NNumber.Parse(this._val);
    }
    async getValueBoolean() {
        if (this._dataType === StorageAttribute.BOOLEAN) {
            await this.getValue();
            return DisplayConvertor.toBoolean(this._val);
        }
        else {
            Events.WriteExceptionToLog(NString.Format("Property.getValueBoolean() was called for non boolean type property: {0}", this._id));
        }
    }
    GetComputedValue() {
        return this._val;
    }
    GetComputedValueBoolean() {
        if (this._dataType === StorageAttribute.BOOLEAN) {
            return DisplayConvertor.toBoolean(this._val);
        }
        else {
            Events.WriteExceptionToLog(NString.Format("Property.getValueBoolean() was called for non boolean type property: {0}", this._id));
        }
    }
    getPrevValue(line) {
        if (line < this._prevValues.length)
            return this._prevValues.get_Item(line);
        return null;
    }
    isExpression() {
        return this._expId > 0;
    }
    GetExpressionId() {
        return this._expId;
    }
    onImageFileName() {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let mgControlBase = this._parentObj;
            if (mgControlBase.isTabControl()) {
                mgControlBase.setImageList(this.GetComputedValue());
            }
            else if (mgControlBase.isImageControl() || mgControlBase.isRadio() || mgControlBase.isCheckBox() || mgControlBase.IsImageButton()) {
                mgControlBase.setImageWithFileName(this.GetComputedValue());
            }
        }
        else
            throw new ApplicationException("in onImageFileName.onEnable()");
    }
    onEnable(valChanged) {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let ctrl = this._parentObj;
            let currentEditingControl = ctrl.getForm().getTask().CurrentEditingControl;
            if (this._val !== null && this._val === "0" && valChanged && currentEditingControl !== null &&
                (ctrl === currentEditingControl || currentEditingControl.isDescendentOfControl(ctrl) || ctrl === currentEditingControl.getLinkedParent(false))) {
                let parkedControl = ctrl.getForm().getTask().getLastParkedCtrl();
                if (parkedControl !== null && parkedControl.InControl && (ctrl === parkedControl || parkedControl.isDescendentOfControl(ctrl))) {
                    Events.OnNonParkableLastParkedCtrl(ctrl);
                    ctrl.getForm().getTask().CurrentEditingControl = null;
                }
            }
            ctrl.SetEnabled(this.GetComputedValueBoolean());
        }
        else
            throw new ApplicationException("in Property.onEnable()");
    }
    async onVisible(valChanged) {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let ctrl = this._parentObj;
            let currentEditingControl = ctrl.getForm().getTask().CurrentEditingControl;
            if (this._val !== null && this._val === "0" && valChanged && currentEditingControl !== null &&
                (ctrl === currentEditingControl || currentEditingControl.isDescendentOfControl(ctrl) || ctrl === currentEditingControl.getLinkedParent(false))) {
                let parkedControl = ctrl.getForm().getTask().getLastParkedCtrl();
                if (parkedControl !== null && parkedControl.InControl && (ctrl === parkedControl || parkedControl.isDescendentOfControl(ctrl))) {
                    Events.OnNonParkableLastParkedCtrl(ctrl);
                    ctrl.getForm().getTask().CurrentEditingControl = null;
                }
            }
            await ctrl.updatePropertyLogicNesting(PropInterface.PROP_TYPE_VISIBLE, CommandType.PROP_SET_VISIBLE, this.GetComputedValueBoolean(), true);
        }
    }
    OnControlName() {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
        }
        else
            throw new ApplicationException("in Property.OnControlName()");
    }
    onHint() {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let control = this.getObjectByParentObj();
            let translatedString = Events.Translate(this.GetComputedValue());
            if (!control.IsDateTimePicture() && (!control.IsTableChild || control.IsTableHeaderChild)) {
                Commands.addOperationWithLine(CommandType.SET_PROPERTY, this.getObjectByParentObj(), this.getLine(), HtmlProperties.PlaceHolder, translatedString);
            }
        }
        else
            throw new ApplicationException("inProperty.onHint()");
    }
    onFormName() {
        if (this._parentType === GuiConstants.PARENT_TYPE_FORM)
            this.addCommandTypeText(0);
        else
            throw new ApplicationException("in Property.onFormName()");
    }
    addCommandTypeText(line) {
        let mlsTransValue = Events.Translate(this.GetComputedValue());
        if (this._parentType === GuiConstants.PARENT_TYPE_FORM ||
            (this._parentType === GuiConstants.PARENT_TYPE_CONTROL && this._parentObj.isColumnControl())) {
            mlsTransValue = StrUtil.rtrim(mlsTransValue);
            if (this._parentType === GuiConstants.PARENT_TYPE_FORM && mlsTransValue === NString.Empty) {
                mlsTransValue = " ";
            }
        }
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL && (this._parentObj.isTextControl()
            || (this._parentObj.isButton())))
            Commands.addValueWithLine(CommandType.SET_VALUE, this._parentObj, line, mlsTransValue);
        else
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this._parentObj, line, HtmlProperties.Text, mlsTransValue);
    }
    onText(line) {
        this.addCommandTypeText(line);
    }
    async onModifiable() {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let ctrl = this._parentObj;
            if (ctrl.isTextControl() || ctrl.isChoiceControl() || ctrl.isCheckBox()) {
                let task = this.GetTaskByParentObject();
                let readOnlyValue = !this.GetComputedValueBoolean();
                if ((readOnlyValue || task.getMode() !== Constants.TASK_MODE_QUERY) && ctrl.GetCurrReadOnly() !== readOnlyValue) {
                    ctrl.SetCurrReadOnly(readOnlyValue);
                    if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                        if (await ctrl.getForm().getTask().checkProp(PropInterface.PROP_TYPE_ALLOW_LOCATE_IN_QUERY, false)) {
                            return;
                        }
                    }
                    Commands.addOperationWithLine(CommandType.SET_PROPERTY, this.getObjectByParentObj(), this.getLine(), HtmlProperties.ReadOnly, readOnlyValue);
                }
            }
        }
        else
            throw new ApplicationException("in Property.onModifiable()");
    }
    onTooltip() {
        let toolTip;
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let ctrl = this._parentObj;
            if (this._expId === 0)
                toolTip = ctrl.getForm().getTask().getHelpItem(NNumber.Parse(this._val)).tooltipHelpText;
            else
                toolTip = this._val;
            toolTip = StrUtil.rtrim(toolTip);
            if (ctrl.isButton() && ctrl.ConnectedControl)
                Commands.addOperationWithLine(CommandType.SET_PROPERTY, ctrl.ConnectedControl, this.getLine(), HtmlProperties.ZoomButtonTooltip, toolTip);
            else
                Commands.addOperationWithLine(CommandType.SET_PROPERTY, ctrl, this.getLine(), HtmlProperties.Tooltip, toolTip);
        }
        else
            throw new ApplicationException("in Property.onTooltip()");
    }
    async onDisplayList(currLine) {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let ctrl = this._parentObj;
            if (ctrl.isSelectionCtrl() || ctrl.isTabControl() || ctrl.isRadio() || ctrl.HasAutocomplete()) {
                let line = (currLine === Int32.MinValue) ? ctrl.getDisplayLine(false) : currLine;
                await ctrl.refreshAndSetItemsList(line, true);
            }
        }
        else
            throw new ApplicationException("in Property.onDisplayList()");
    }
    async onVisibleLayerList(currLine) {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let ctrl = this._parentObj;
            let line = 0;
            if (currLine === Int32.MinValue)
                line = ctrl.getDisplayLine(false);
            else
                line = currLine;
            await ctrl.refreshTabForLayerList(line);
        }
        else
            throw new ApplicationException("in Property.onVisibleLayerList()");
    }
    onFormat() {
        let ctrl = null;
        let ctrlPic;
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            ctrl = this._parentObj;
            ctrlPic = ctrl.getPIC();
            ctrl.resetPrevVal();
            switch (ctrl.Type) {
                case MgControlType.CTRL_TYPE_BUTTON:
                    if (ctrl.getField() == null && !ctrl.expressionSetAsData() || ctrl.IsImageButton() || (this._parentObj.IsFirstRefreshOfProps()))
                        this.addCommandTypeText(this.getLine());
                    break;
                case MgControlType.CTRL_TYPE_TEXT:
                    if (ctrl.Type === MgControlType.CTRL_TYPE_TEXT) {
                        if (ctrlPic.getAttr() !== StorageAttribute.NUMERIC) {
                        }
                    }
                    break;
            }
        }
        else
            throw new ApplicationException("in Property.onFormat()");
    }
    async onLabel(currLine) {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let ctrl = this._parentObj;
            let line;
            if (currLine === Int32.MinValue)
                line = ctrl.getDisplayLine(false);
            else
                line = currLine;
            if (ctrl.Type === MgControlType.CTRL_TYPE_CHECKBOX)
                this.addCommandTypeText(line);
            else if (ctrl.isSelectionCtrl() || ctrl.isTabControl() || ctrl.isRadio()) {
                ctrl.setRange(await this.getValue());
                ctrl.clearRange(line);
                await ctrl.refreshAndSetItemsList(line, true);
                if (this._expId > 0)
                    await ctrl.ComputeAndRefreshDisplayValue(false);
            }
            else if (ctrl.HasAutocomplete())
                await ctrl.refreshAndSetItemsList(line, true);
            else
                throw new ApplicationException("Property.onLabel(), not support control");
        }
        else
            throw new ApplicationException("in Property.onLabel()");
    }
    getObjectByParentObj() {
        let result = this._parentObj;
        if (this._parentType === GuiConstants.PARENT_TYPE_FORM) {
            let form = this._parentObj;
            if (form.isSubForm())
                result = form.getSubFormCtrl();
        }
        return result;
    }
    static isRepeatableInTable() {
        return false;
    }
    getLine() {
        let line = 0;
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let ctrl = this._parentObj;
            let displayLineForTreeOrTable = ctrl.isPropertyRepeatable(this._id);
            line = ctrl.getDisplayLine(displayLineForTreeOrTable);
        }
        return line;
    }
    getOrgValue() {
        return this._orgValue;
    }
    updatePrevValueArray(newSize) {
        if (!this.ShouldSkipRefresh())
            this._prevValues.SetSize(newSize);
    }
    clearPrevValueArray() {
        this._prevValues.Clear();
    }
    ResetPrevValueArray() {
        let count = this._prevValues.length;
        this._prevValues.Clear();
        this._prevValues.SetSize(count);
    }
    setPrevArraySize() {
        if (this._parentType === GuiConstants.PARENT_TYPE_FORM || this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
            let size = 1;
            if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL) {
                let mgControlBase = this._parentObj;
                if (mgControlBase.IsRepeatable)
                    size = mgControlBase.getForm().getTableItemsCount();
                else if (mgControlBase.isTableControl() && Property.isRepeatableInTable())
                    size = mgControlBase.getForm().getTableItemsCount();
            }
            this._prevValues.SetSize(size);
        }
    }
    onPassword() {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL)
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this.getObjectByParentObj(), this.getLine(), HtmlProperties.Password, this.GetComputedValueBoolean());
        else
            throw new ApplicationException("in Property.onPassword()");
    }
    async computeCustomPropertiesValues() {
        for (let [customPropertyKey, customPropertyValue] of this.customProperties) {
            let expression = customPropertyValue;
            let retExpressionValue = await this.GetRetrunValueForCustomPropertyExpression(expression);
            this.customPropertiesValues.set(customPropertyKey, retExpressionValue);
        }
    }
    async computeCustomValidators() {
        let mgControl = this._parentObj;
        let evaluated = true;
        if (mgControl.ModifiedByUser || mgControl.ValidateControl || this.GetTaskByParentObject().IsInRecompute()) {
            for (let [customPropertyKey, customValidatorProperty] of this.customValidatorProperties) {
                let expression = customValidatorProperty._exp;
                let isInValid = await this.GetRetrunValueForCustomPropertyExpression(expression);
                let errString = "";
                let InValid = (isInValid === "1") ? true : false;
                if (InValid) {
                    expression = customValidatorProperty._errorMessageExp;
                    if (expression > 0)
                        errString = await this.GetRetrunValueForCustomPropertyExpression(expression);
                    else
                        errString = customValidatorProperty._errorMessage;
                }
                evaluated = true;
                this.customValidatorValues.set(customPropertyKey, new CustomValidator(!InValid, errString));
            }
        }
        else {
            if (mgControl.isRepeatable()) {
                this.customValidatorValues.clear();
                evaluated = false;
            }
        }
        return evaluated;
    }
    onCustomProperties() {
        for (let [customPropertyKey, customPropertyValue] of this.customPropertiesValues) {
            Commands.addOperationWithLine(CommandType.PROP_SET_USER_PROPERTY, this._parentObj, this.getLine(), customPropertyKey, customPropertyValue);
        }
    }
    onCustomValidators() {
        for (let [customPropertyKey, customPropertyValue] of this.customValidatorValues) {
            Commands.addOperationWithLine(CommandType.PROP_SET_CUSTOM_VALIDATOR, this._parentObj, this.getLine(), customPropertyKey, customPropertyValue);
        }
    }
    onBindingLevel() {
        if (this._parentType === GuiConstants.PARENT_TYPE_CONTROL)
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this.getObjectByParentObj(), this.getLine(), HtmlProperties.BindingLevel, this.GetComputedValueInteger());
        else
            throw new ApplicationException("in Property.BindingLevel()");
    }
    onAutoCompleteMode() {
    }
    async GetRetrunValueForCustomPropertyExpression(expression) {
        let len = 255;
        let expStorageAttribute = this._parentObj.GetExpressionStorage(expression);
        let wasEvaluated = new RefParam(false);
        let returnValue = await this._parentObj.EvaluateExpression(expression, expStorageAttribute, len, true, StorageAttribute.SKIP, false, wasEvaluated);
        expStorageAttribute = this._parentObj.GetExpressionStorage(expression);
        let compIdx = this._parentObj.getCompIdx();
        switch (expStorageAttribute) {
            case StorageAttribute.NUMERIC:
                let tempPic = new PIC("N6.2", StorageAttribute.NUMERIC, this._parentObj.getCompIdx());
                if (returnValue == null)
                    returnValue = "FF00000000000000000000000000000000000000";
                returnValue = DisplayConvertor.Instance.mg2disp(returnValue, "", tempPic, false, compIdx, false).trim();
                break;
            case StorageAttribute.DATE:
                tempPic = new PIC("##/##/####", expStorageAttribute, compIdx);
                returnValue = DisplayConvertor.Instance.mg2disp(returnValue, "", tempPic, true, false, compIdx, true);
                break;
            case StorageAttribute.TIME:
                tempPic = new PIC("##:##/####", expStorageAttribute, compIdx);
                returnValue = DisplayConvertor.Instance.mg2disp(returnValue, "", tempPic, true, false, compIdx, true);
                break;
            case StorageAttribute.ALPHA:
            case StorageAttribute.BOOLEAN:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
            case StorageAttribute.UNICODE:
            case StorageAttribute.NONE:
                break;
            default:
                throw new ApplicationException("in Property.GetRetrunValueForCustomPropertyExpression() illegal data type: " + expStorageAttribute);
        }
        return returnValue;
    }
    RemovePrevValIndexAt(idx) {
        if (this._prevValues.length > idx) {
            this._prevValues.RemoveAt(idx);
        }
    }
    InsertPrevValAt(idx) {
        this._prevValues.Insert(idx, null);
    }
    resetPrevValAt(idx) {
        if (idx >= 0 && idx < this._prevValues.length)
            this._prevValues.set_Item(idx, null);
    }
    toString() {
        return NString.Format("{0} = {1} (exp={2}, studio value={3})", [
            PropDefaults.GetPropertyName(this._id), (this._val === null) ? "is null" : this._val, this._expId, this.StudioValue
        ]);
    }
    static getDefaultProp(propId, parentType, propParent) {
        let prop = null;
        let mgVal = PropDefaults.getDefaultValue(propId, parentType, propParent);
        if (mgVal !== null)
            prop = new Property(propId, propParent, parentType, mgVal);
        return prop;
    }
    InsertPrevValueArray(count) {
        if (!this.ShouldSkipRefresh())
            this._prevValues.InsertRange(new Array(count));
    }
}
Property._numericPropertyPic = null;
Property.UtilImeJpn = (UtilStrByteMode.isLocaleDefLangJPN() ? new UtilImeJpn() : null);

class GuiFormPropertyAdapter extends GuiMgForm {
    static IsFormTag(tagName) {
        return tagName === XMLConstants.MG_TAG_FORM || tagName === XMLConstants.MG_TAG_FORM_PROPERTIES;
    }
    static IsEndFormTag(tagName) {
        return tagName === ("/" + XMLConstants.MG_TAG_FORM) || tagName === ("/" + XMLConstants.MG_TAG_FORM_PROPERTIES);
    }
}

class PropTable {
    constructor(parent_) {
        this._hashTab = null;
        this._props = null;
        this._parent = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(parent_);
    }
    constructor_0() {
        this._props = new List();
        this._hashTab = new Hashtable(20);
    }
    constructor_1(parent_) {
        this.constructor_0();
        this._parent = parent_;
    }
    fillData(parentObj, parType, parser) {
        while (this.initInnerObjects(parser.getNextTag(), parentObj, parType, parser)) {
        }
    }
    fillDataByExists(task, parser) {
        while (this.fillExistInnerObjects(parser.getNextTag(), task, parser)) {
        }
    }
    initInnerObjects(foundTagName, parentObj, parType, parser) {
        if (foundTagName !== null && foundTagName === XMLConstants.MG_TAG_PROP) {
            let property = new Property();
            property.fillData(parentObj, parType, parser);
            this.addProp(property);
        }
        else
            return false;
        return true;
    }
    addProp(prop) {
        this._hashTab.set_Item(prop.getID(), prop);
        this._props.push(prop);
    }
    delPropById(id) {
        if (this._props === null)
            return;
        let existingProp = this._hashTab.get_Item(id);
        if (existingProp !== null) {
            this._props.Remove(existingProp);
            this._hashTab.Remove(id);
        }
    }
    fillExistInnerObjects(nameOfFound, task, parser) {
        let tokensVector = new List();
        let endContext = -1;
        if (nameOfFound == null)
            return false;
        if (nameOfFound === XMLConstants.MG_TAG_CONTROL)
            endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        else if (nameOfFound === XMLConstants.MG_TAG_PROP)
            endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
        else if (nameOfFound === ('/' + XMLConstants.MG_TAG_CONTROL) ||
            GuiFormPropertyAdapter.IsEndFormTag(nameOfFound)) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(nameOfFound) + nameOfFound.length);
            tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            if (nameOfFound === XMLConstants.MG_TAG_CONTROL) {
                this._parent = task.getCtrl(NNumber.Parse(this.fillName(tokensVector)));
                parser.setCurrIndex(++endContext);
                return true;
            }
            else if (nameOfFound === XMLConstants.MG_TAG_PROP) {
                if (this._parent != null) {
                    let strPropId = this.fillName(tokensVector);
                    let propId = NNumber.Parse(strPropId);
                    let prop = null;
                    if (this._parent != null)
                        prop = this._parent.getProp(propId);
                    if (prop == null)
                        Events.WriteExceptionToLog(NString.Format("in PropTable.fillExistInnerObjects() no property with id={0}", strPropId));
                    else
                        this.addProp(prop);
                    parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
                    return true;
                }
                else
                    Events.WriteExceptionToLog("in PropTable.fillExistInnerObjects() missing control");
            }
            else {
                Events.WriteExceptionToLog(NString.Format("in PropTable.fillExistInnerObjects() illegal tag name: {0}", nameOfFound));
                parser.setCurrIndex(++endContext);
                return true;
            }
        }
        if (nameOfFound === XMLConstants.MG_TAG_CONTROL) {
            parser.setCurrIndex(++endContext);
            return true;
        }
        else if (GuiFormPropertyAdapter.IsFormTag(nameOfFound)) {
            this._parent = task.getForm();
            this._parent.fillName(nameOfFound);
            return true;
        }
        else if (nameOfFound === ('/' + XMLConstants.MG_TAG_FLD))
            return false;
        parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
        return true;
    }
    fillName(tokensVector) {
        let attribute = null;
        let valueStr;
        for (let j = 0; j < tokensVector.length; j = j + 2) {
            attribute = tokensVector.get_Item(j);
            valueStr = tokensVector.get_Item(j + 1);
            if (attribute === XMLConstants.MG_ATTR_DITIDX || attribute === XMLConstants.MG_ATTR_ID)
                return valueStr;
        }
        Events.WriteExceptionToLog(NString.Format("Unrecognized attribute: '{0}'", attribute));
        return null;
    }
    getSize() {
        return this._props.length;
    }
    getProp(idx) {
        if (idx < 0 || idx >= this._props.length)
            return null;
        return this._props.get_Item(idx);
    }
    getPropById(id) {
        return this._hashTab.get_Item(id);
    }
    propExists(id) {
        return this.getPropById(id) !== null;
    }
    setProp(propId, val, parent, parentType) {
        let prop = this.getPropById(propId);
        if (prop === null) {
            prop = new Property(propId, parent, parentType);
            this.addProp(prop);
        }
        prop.setValue(val);
        prop.setOrgValue();
    }
    async RefreshDisplay(forceRefresh, onlyRepeatableProps) {
        let allPropsRefreshed = true;
        let prop;
        let i = 0;
        let form = null;
        let visibleProps = new List();
        if (this._parent != null && this._parent instanceof GuiControlPropertyAdapter)
            form = this._parent.getForm();
        if (form != null)
            form.checkAndCreateRow(form.DisplayLine);
        for (i = 0; i < this.getSize(); i++) {
            prop = this.getProp(i);
            try {
                if (onlyRepeatableProps && !Property.isRepeatableInTable())
                    continue;
                if (prop.getID() === PropInterface.PROP_TYPE_VISIBLE)
                    visibleProps.push(prop);
                else
                    await prop.RefreshDisplay(forceRefresh);
            }
            catch (ex) {
                if (ex instanceof ApplicationException) {
                    Events.WriteExceptionToLog(ex);
                    allPropsRefreshed = false;
                }
                else
                    throw ex;
            }
        }
        for (let i = 0; i < visibleProps.length; i++) {
            let visibleProp = visibleProps[i];
            await visibleProp.RefreshDisplay(forceRefresh);
        }
        return allPropsRefreshed;
    }
    updatePrevValueArray(newSize) {
        for (let i = 0; i < this._props.length; i = i + 1) {
            let property = this._props.get_Item(i);
            property.updatePrevValueArray(newSize);
        }
    }
    resetPrevValueArray() {
        for (let i = 0; i < this._props.length; i = i + 1) {
            let property = this._props.get_Item(i);
            property.ResetPrevValueArray();
        }
    }
    resetPrevValAt(index) {
        for (let i = 0; i < this._props.length; i = i + 1) {
            let property = this._props.get_Item(i);
            property.resetPrevValAt(index);
        }
    }
    clearLabelPrevValueArray() {
        let labelProperty = this.getPropById(45);
        if (labelProperty !== null)
            labelProperty.clearPrevValueArray();
    }
    getCtrlRef() {
        return ((this._parent instanceof GuiControlPropertyAdapter) ? this._parent : null);
    }
    InsertPrevValueArray(count) {
        for (let i = 0; i < this._props.length; i++) {
            let prop = this._props[i];
            prop.InsertPrevValueArray(count);
        }
    }
}

class WrongFormatException extends Exception {
    constructor(type) {
        super(type);
        this._type = null;
        this.name = "WrongFormatException";
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(type);
    }
    initialize() {
        this._type = null;
    }
    constructor_0() {
        this.initialize();
        this._type = MsgInterface.STR_RNG_TXT;
    }
    constructor_1(type) {
        this.initialize();
        this._type = type;
    }
    getType() {
        return this._type;
    }
}

class FieldValidator {
    constructor() {
        this._newvalue = null;
        this._oldvalue = null;
        this._pictureReal = null;
        this._pictureEnable = null;
        this._valDet = null;
        this._picture = null;
        this._decimal = null;
        this._environment = null;
        this._environment = GuiEnvironment.Environment;
        this._decimal = (this._environment.GetDecimal() || "");
    }
    checkVal(valDet) {
        this._newvalue = (this._oldvalue = (this._pictureReal = (this._pictureEnable = null)));
        this.init(valDet);
        valDet.setValidationFailed(false);
        let ctrl = valDet.getControl();
        let modInQueuy = ctrl.isRepeatable() ? false : ctrl.GetComputedBooleanProperty(PropInterface.PROP_TYPE_MODIFY_IN_QUERY, false, ctrl.getDisplayLine(false));
        let useNative = ctrl.isModifiable();
        if (ctrl.getForm().getTask().getMode() === 'E' && !modInQueuy) {
            valDet.setValue(this._oldvalue);
            return valDet;
        }
        if (ctrl.Type === MgControlType.CTRL_TYPE_RADIO || ctrl.Type === MgControlType.CTRL_TYPE_CHECKBOX || ctrl.Type === MgControlType.CTRL_TYPE_TAB || ctrl.isSelectionCtrl()) {
            try {
                if (ctrl.Type === MgControlType.CTRL_TYPE_CHECKBOX) {
                    valDet.setNull(ctrl.isNullValue(this._newvalue));
                }
                if (this._newvalue !== null && ctrl.isSelectionCtrl()) {
                    let idx = NNumber.Parse(this._newvalue);
                    if (ctrl.isChoiceNull(idx)) {
                        valDet.setNull(true);
                    }
                }
            }
            catch (ex_111) {
                if (ex_111 instanceof Exception) {
                }
                else
                    throw ex_111;
            }
            valDet.setValue(this._newvalue);
            return valDet;
        }
        if (ctrl.DataType !== StorageAttribute.ALPHA && ctrl.DataType !== StorageAttribute.UNICODE && ctrl.DataType !== StorageAttribute.BLOB) {
            if ((typeof this._newvalue === 'string' && this._newvalue.trim().length === 0) || (ctrl.DataType == StorageAttribute.NUMERIC && this._newvalue == null) || (ctrl.DataType === StorageAttribute.DATE && (ctrl.isDateZero(this._newvalue) || this.isNullDisplayVal()))) {
                let field = ctrl.getField();
                let defaultValue = field.getDefaultValue();
                let text = null;
                if (field.isNullDefault()) {
                    valDet.setNull(true);
                    text = field.getNullDisplay();
                    if (NString.IsNullOrEmpty(text) && ctrl.DataType === StorageAttribute.DATE) {
                        text = DisplayConvertor.Instance.mg2disp(defaultValue, valDet.getRange(), valDet.getPIC(), useNative, field.getTask().getCompIdx(), false);
                    }
                }
                if (text === null) {
                    text = DisplayConvertor.Instance.mg2disp(defaultValue, valDet.getRange(), valDet.getPIC(), useNative, field.getTask().getCompIdx(), false);
                }
                if ((!field.isNullDefault() && (this._valDet.getContinuousRangeValues() !== null || this._valDet.getDiscreteRangeValues() !== null)))
                    this._newvalue = text;
                else {
                    valDet.setValue(text);
                    return valDet;
                }
            }
        }
        if ((typeof this._newvalue === 'string' && !(StrUtil.rtrim(this._newvalue) === StrUtil.rtrim(this._oldvalue))) || ctrl.ModifiedByUser) {
            try {
                switch (valDet.getType()) {
                    case StorageAttribute.ALPHA:
                    case StorageAttribute.UNICODE:
                        valDet.setValue(this.checkAlphaField());
                        break;
                    case StorageAttribute.NUMERIC:
                        this._pictureReal = valDet.getPictureReal();
                        this._pictureEnable = valDet.getPictureEnable();
                        this.checkNumericPicture();
                        valDet.setValue(this.checkNumericField());
                        break;
                    case StorageAttribute.BOOLEAN:
                        valDet.setValue(this.checkLogicalField());
                        break;
                    case StorageAttribute.DATE:
                        valDet.setValue(this.checkDateField());
                        break;
                    case StorageAttribute.TIME:
                        valDet.setValue(this.checkTimeField());
                        break;
                    case StorageAttribute.BLOB:
                    case StorageAttribute.BLOB_VECTOR:
                        valDet.setValue(this._newvalue);
                        break;
                    case StorageAttribute.NONE:
                    default:
                        Events.WriteExceptionToLog("FieldValidator.checkVal: Type of the field " + valDet.getType());
                        break;
                }
            }
            catch (goBack) {
                if (goBack instanceof WrongFormatException) {
                    valDet.setValue(this._oldvalue);
                    this.setValidationFailed(true);
                    if (goBack.getType() !== MsgInterface.STR_RNG_TXT) {
                        this.printMessage(goBack.getType(), false);
                        this.setValidationFailed(true);
                    }
                    else
                        this.printMessage(MsgInterface.STR_RNG_TXT, true);
                }
            }
        }
        return valDet;
    }
    checkAlphaField() {
        let control = this._valDet.getControl();
        let IsAttrAlpha = this._valDet.getType() === StorageAttribute.ALPHA;
        if (this._newvalue.length === 0 && this._valDet.getContinuousRangeValues() === null && this._valDet.getDiscreteRangeValues() === null) {
            this.setValidationFailed(false);
            return this._newvalue;
        }
        if (IsAttrAlpha && UtilStrByteMode.isLocaleDefLangDBCS()) {
            let picLenB = UtilStrByteMode.lenB(this._picture);
            if (UtilStrByteMode.lenB(this._newvalue) > picLenB) {
                this._newvalue = UtilStrByteMode.leftB(this._newvalue, picLenB);
            }
        }
        else {
            if (this._newvalue.length > this._picture.length) {
                this._newvalue = this._newvalue.substr(0, this._picture.length);
            }
        }
        let stringBuilder = new StringBuilder();
        let currPicture;
        let i = currPicture = 0;
        for (currPicture = i = 0; i < this._newvalue.length && currPicture < this._picture.length;) {
            if (!DisplayConvertor.isAlphaPositionalDirective(this._picture.charAt(currPicture)) && this._newvalue.charAt(i) === this._picture.charAt(currPicture)) {
                stringBuilder.Append(this._picture.charAt(currPicture));
                i = i + 1;
                currPicture = currPicture + 1;
            }
            else {
                if (!DisplayConvertor.isAlphaPositionalDirective(this._picture.charAt(currPicture)) && this._newvalue.charAt(i) !== this._picture.charAt(currPicture)) {
                    stringBuilder.Append(this._picture.charAt(currPicture));
                    currPicture = currPicture + 1;
                }
                else {
                    if (DisplayConvertor.isAlphaPositionalDirective(this._picture.charAt(currPicture)) && this.isPossibleAlphaLetter(i, currPicture)) {
                        if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                            let strVal = this._newvalue.substr(i, 1);
                            if (UtilStrByteMode.lenB(strVal) === 2) {
                                if (IsAttrAlpha) {
                                    if (currPicture + 1 < this._picture.length) {
                                        if (DisplayConvertor.isAlphaPositionalDirective(this._picture.charAt(currPicture + 1)) && this.isPossibleAlphaLetter(i, currPicture + 1)) {
                                            stringBuilder.Append(this._newvalue.charAt(i));
                                            i = i + 1;
                                            currPicture = currPicture + 2;
                                        }
                                        else {
                                            stringBuilder.Append(' ');
                                            currPicture = currPicture + 1;
                                        }
                                    }
                                    else {
                                        stringBuilder.Append(' ');
                                        currPicture = currPicture + 1;
                                    }
                                }
                                else {
                                    stringBuilder.Append(this._newvalue.charAt(i));
                                    i = i + 1;
                                    currPicture = currPicture + 1;
                                }
                            }
                            else {
                                stringBuilder.Append(this._newvalue.charAt(i));
                                i = i + 1;
                                currPicture = currPicture + 1;
                            }
                        }
                        else {
                            stringBuilder.Append(this._newvalue.charAt(i));
                            i = i + 1;
                            currPicture = currPicture + 1;
                        }
                    }
                    else {
                        stringBuilder.Append(' ');
                        currPicture = currPicture + 1;
                        if (this._valDet.getControl() !== null) {
                            let type = control.Type;
                            if (type !== MgControlType.CTRL_TYPE_BUTTON) {
                                this.printMessage(MsgInterface.STR_ERR_NUM, false);
                            }
                        }
                    }
                }
            }
        }
        this._newvalue = stringBuilder.ToString();
        if (this._valDet.getContinuousRangeValues() !== null || this._valDet.getDiscreteRangeValues() !== null) {
            this._newvalue = this.fillAlphaByRange(this._valDet.getContinuousRangeValues(), this._valDet.getDiscreteRangeValues());
        }
        return this._newvalue;
    }
    isPossibleAlphaLetter(indexInput, indexPicture) {
        switch (this._picture.charCodeAt(indexPicture)) {
            case PICInterface.PIC_X:
            case PICInterface.PIC_J:
            case PICInterface.PIC_G:
            case PICInterface.PIC_S:
            case PICInterface.PIC_T:
                return true;
            case PICInterface.PIC_U:
                let upper = this._newvalue[indexInput].toUpperCase();
                if (upper !== this._newvalue[indexInput])
                    this.changeStringInside("" + upper, indexInput);
                return true;
            case PICInterface.PIC_L:
                let lower = this._newvalue[indexInput].toLowerCase();
                if (lower !== this._newvalue[indexInput])
                    this.changeStringInside("" + lower, indexInput);
                return true;
            case PICInterface.PIC_N:
                let number1 = this._newvalue[indexInput];
                if (UtilStrByteMode.isDigit(number1) || NChar.IsWhiteSpace(number1) || UtilStrByteMode.asNumeric(number1))
                    return true;
                else {
                    Events.WriteErrorToLog("Bad Alpha value. Should be number only on place Num. " + indexInput);
                    return false;
                }
            default:
                Events.WriteErrorToLog("FieldValidator.isPossibleAlphaLetter: illegal Char Directive: " + this._picture.indexOf(String.fromCharCode(indexPicture)) + " for " + this._newvalue[indexInput]);
                return false;
        }
    }
    fillAlphaByRange(ContinuousRangeValues, DiscreteRangeValues) {
        let tmpBuffer = DisplayConvertor.Instance.fillAlphaByDiscreteRangeValues(DiscreteRangeValues, this._newvalue);
        if (tmpBuffer !== null) {
            return tmpBuffer;
        }
        tmpBuffer = DisplayConvertor.Instance.fillAlphaByContinuousRangeValues(ContinuousRangeValues, this._newvalue);
        if (tmpBuffer !== null)
            return tmpBuffer;
        if (DiscreteRangeValues !== null)
            return this.CompleteAlphaByRange(DiscreteRangeValues);
        this.printMessage(MsgInterface.STR_RNG_TXT, true);
        return this._oldvalue;
    }
    CompleteAlphaByRange(DiscreteRangeValues) {
        let tmpNewValue = DisplayConvertor.Instance.completeAlphaByRange(DiscreteRangeValues, this._newvalue);
        if (tmpNewValue !== null) {
            return tmpNewValue;
        }
        this.printMessage(MsgInterface.STR_RNG_TXT, true);
        return this._oldvalue;
    }
    checkLogicalField() {
        if (this._newvalue.length === 0 && this._valDet.getContinuousRangeValues() === null && this._valDet.getDiscreteRangeValues() === null) {
            throw new WrongFormatException(MsgInterface.STR_RNG_TXT);
        }
        if (this._valDet.getContinuousRangeValues() !== null || this._valDet.getDiscreteRangeValues() !== null) {
            this._newvalue = this.fillAlphaByRange(this._valDet.getContinuousRangeValues(), this._valDet.getDiscreteRangeValues());
        }
        this.setValidationFailed(false);
        return this._newvalue;
    }
    checkNumericField() {
        let evaluated;
        if (typeof this._newvalue === 'string') {
            if (this._newvalue.length === 0) {
                this._newvalue = "0";
            }
            let delimeterRealIndex = this._newvalue.indexOf(this._decimal);
            let delimeterPictIndex = this._pictureReal.indexOf(this._decimal);
            evaluated = "";
            let evaluatedLeft;
            let evaluatedRight;
            this.setValidationFailed(false);
            if (!this.checkNumericInDecFormat())
                throw new WrongFormatException(MsgInterface.EDT_ERR_STR_1);
            if (delimeterPictIndex !== -1 && delimeterRealIndex !== -1) {
                evaluatedLeft = this.checkNumericLeft(delimeterPictIndex, delimeterRealIndex);
                evaluatedRight = this.checkNumericRight(delimeterPictIndex, delimeterRealIndex);
                evaluated = evaluatedLeft + this._decimal + evaluatedRight;
            }
            else {
                if (delimeterPictIndex !== -1 && delimeterRealIndex === -1) {
                    evaluatedLeft = this.checkNumericLeft(delimeterPictIndex, Math.min(delimeterPictIndex, this._newvalue.length));
                    evaluatedRight = this.checkNumericRight(delimeterPictIndex, delimeterPictIndex - 1);
                    evaluated = evaluatedLeft + this._decimal + evaluatedRight;
                }
                else {
                    if (delimeterPictIndex === -1 && delimeterRealIndex === -1) {
                        evaluated = this.checkNumericRight(-1, -1);
                        evaluatedLeft = evaluated;
                    }
                    else {
                        if (delimeterRealIndex > 0) {
                            this._newvalue = this._newvalue.substr(0, delimeterRealIndex);
                        }
                        else {
                            this._newvalue = "0";
                        }
                        evaluated = this.checkNumericRight(-1, -1);
                        evaluatedLeft = evaluated;
                    }
                }
            }
            if ((evaluatedRight.length === 0 && evaluatedLeft.length === 0) || (evaluated.length === 0 && this._newvalue.length > 0)) {
                let ctrl;
                ctrl = this._valDet.getControl();
                let field = ctrl.getField();
                let defValue = field.getDefaultValue();
                let dispDefValue = null;
                if (field.isNullDefault()) {
                    this._valDet.setNull(true);
                    dispDefValue = field.getNullDisplay();
                }
                if (dispDefValue == null)
                    dispDefValue = DisplayConvertor.Instance.mg2disp(defValue, this._valDet.getRange(), this._valDet.getPIC(), true, field.getTask().getCompIdx(), false);
            }
            let wholeDigitdiff = this.digitsBeforeDelimeter(evaluated, 0, this._decimal) - this._valDet.getPIC().getWholes();
            if (wholeDigitdiff > 0) {
                let padCharOnly = false;
                if (this._valDet.getIsPadFill()) {
                    padCharOnly = true;
                    for (let i = 0; i < wholeDigitdiff && padCharOnly; i++)
                        if (evaluated[i] !== this._valDet.getPadFillChar())
                            padCharOnly = false;
                }
                if (!padCharOnly)
                    throw new WrongFormatException(MsgInterface.EDT_ERR_STR_1);
            }
            if (this._valDet.getIsNegative() && (this._newvalue.trim().startsWith("-") || (this._valDet.getNegativeSignPref().length !== 0 && this._newvalue.trim().startsWith(this._valDet.getNegativeSignPref())))) {
                evaluated = "-" + evaluated;
            }
            evaluated = DisplayConvertor.Instance.disp2mg(this._newvalue, this._valDet.getPIC(), this._valDet.getControl().getForm().getTask().getCompIdx(), BlobType.CONTENT_TYPE_UNKNOWN);
            evaluated = DisplayConvertor.Instance.mg2disp(evaluated, "", this._valDet.getPIC(), true, this._valDet.getControl().getForm().getTask().getCompIdx(), true);
            let tempDispVal = StrUtil.ltrim(evaluated);
            if (tempDispVal.length === 0 && this._valDet.getPIC().zeroFill() && this._valDet.getPIC().getZeroPad() === ' ')
                evaluated = "0";
        }
        else {
            evaluated = DisplayConvertor.Instance.disp2mg(this._newvalue, this._valDet.getPIC(), this._valDet.getControl().getForm().getTask().getCompIdx(), BlobType.CONTENT_TYPE_UNKNOWN);
            evaluated = DisplayConvertor.Instance.mg2disp(evaluated, "", this._valDet.getPIC(), true, this._valDet.getControl().getForm().getTask().getCompIdx(), true);
        }
        if (this._valDet.getContinuousRangeValues() != null || this._valDet.getDiscreteRangeValues() != null) {
            this._newvalue = evaluated;
            evaluated = this.fillNumericByRange();
        }
        return evaluated;
    }
    checkNumericLeft(delimeterPictIndex, delimeterRealIndex) {
        let buffer = new StringBuilder();
        let RealIndex = delimeterRealIndex - 1;
        let PictIndex;
        let isFound;
        for (PictIndex = delimeterPictIndex - 1; PictIndex >= 0 && RealIndex >= 0; PictIndex--) {
            if (this._pictureEnable[PictIndex] === '1') {
                let tmpstorage = RealIndex;
                isFound = false;
                for (; RealIndex >= 0; RealIndex--) {
                    if (this._pictureReal[PictIndex] === this._newvalue[RealIndex]) {
                        isFound = true;
                        RealIndex--;
                        break;
                    }
                }
                if (!isFound)
                    RealIndex = tmpstorage;
                buffer.Append(this._pictureReal[PictIndex]);
            }
            else {
                for (; RealIndex >= 0; RealIndex--) {
                    if (UtilStrByteMode.isDigit(this._newvalue[RealIndex])) {
                        buffer.Append(this._newvalue[RealIndex]);
                        RealIndex--;
                        break;
                    }
                }
            }
        }
        if (RealIndex < 0 && PictIndex >= 0)
            for (; PictIndex >= 0; PictIndex--) {
                if (this._pictureEnable[PictIndex] === '1')
                    buffer.Append(this._pictureReal[PictIndex]);
                else {
                    if (this._valDet.getIsPadFill())
                        buffer.Append(this._valDet.getPadFillChar());
                }
            }
        return StrUtil.ReverseString(buffer).ToString();
    }
    checkNumericRight(delimeterPictIndex, delimeterRealIndex) {
        let buffer = new StringBuilder();
        let RealIndex = delimeterRealIndex + 1;
        let PictIndex;
        let pic = this._valDet.getPIC();
        for (PictIndex = delimeterPictIndex + 1; PictIndex < this._pictureEnable.length && RealIndex < this._newvalue.length; PictIndex++) {
            if (this._pictureEnable[PictIndex] === '1') {
                if (RealIndex < PictIndex)
                    RealIndex = PictIndex;
                buffer.Append(this._pictureReal[PictIndex]);
            }
            else {
                for (; RealIndex < this._newvalue.length; RealIndex++) {
                    if (UtilStrByteMode.isDigit(this._newvalue[RealIndex]) && !pic.picIsMask(RealIndex)) {
                        buffer.Append(this._newvalue[RealIndex]);
                        RealIndex++;
                        break;
                    }
                }
            }
        }
        if (buffer.Length > 0) {
            if (RealIndex >= this._newvalue.length && PictIndex < this._pictureReal.length)
                for (; PictIndex < this._pictureReal.length; PictIndex++) {
                    if (this._pictureEnable[PictIndex] === '1')
                        buffer.Append(this._pictureReal[PictIndex]);
                }
        }
        return buffer.ToString();
    }
    checkNumericPicture() {
        let indexOfDec;
        let lastDec;
        let maxLength;
        let currIndx;
        let POINT_DEC = ".";
        let pic = this._valDet.getPIC();
        if (this._pictureReal == null || this._pictureEnable == null || pic.getAttr() !== StorageAttribute.NUMERIC || !pic.withDecimal())
            return;
        lastDec = this._pictureReal.lastIndexOf(POINT_DEC);
        maxLength = this._pictureEnable.length;
        currIndx = 0;
        while (currIndx < lastDec) {
            indexOfDec = this._pictureEnable.indexOf("1", currIndx);
            if (indexOfDec === -1)
                return;
            else {
                if (indexOfDec === this._pictureReal.indexOf(POINT_DEC, currIndx)) {
                    let first;
                    let second;
                    first = second = "";
                    if (indexOfDec === 0) {
                        if (indexOfDec + 1 < maxLength)
                            second = this._pictureReal.substr(indexOfDec + 1);
                    }
                    else if (indexOfDec === maxLength) {
                        first = this._pictureReal.substr(0, indexOfDec);
                    }
                    else {
                        first = this._pictureReal.substr(0, indexOfDec);
                        second = this._pictureReal.substr(indexOfDec + 1);
                    }
                    this._pictureReal = first + this._decimal + second;
                    break;
                }
                else {
                    currIndx = ++indexOfDec;
                }
            }
        }
    }
    fillNumericByRange() {
        let controlPic = this._valDet.getControl().getPIC();
        let continuousRangeValues = this._valDet.getContinuousRangeValues();
        let discreteRangeValues = this._valDet.getDiscreteRangeValues();
        this.setValidationFailed(false);
        let checkedStr = this.setNumericValueWithoutPicture(this._newvalue.toString());
        if (checkedStr.length === 0) {
            this.printMessage(MsgInterface.STR_RNG_TXT, true);
            return this._oldvalue;
        }
        let checkedNum = new NUM_TYPE(this._newvalue.toString(), this._valDet.getControl().getPIC(), 0);
        if (discreteRangeValues !== null) {
            for (let i = 0; i < discreteRangeValues.length; i = i + 1) {
                let rangeItemValue1 = new NUM_TYPE(discreteRangeValues.get_Item(i), controlPic, 0);
                try {
                    if (NUM_TYPE.num_cmp(checkedNum, rangeItemValue1) === 0) {
                        return this._newvalue;
                    }
                }
                catch (ex_CC) {
                }
            }
        }
        if (continuousRangeValues !== null) {
            for (let i = 0; i < continuousRangeValues.length; i = i + 1) {
                let rangeItemValue1 = new NUM_TYPE();
                let rangeItemValue2 = new NUM_TYPE();
                rangeItemValue1.num_4_a_std(continuousRangeValues.get_Item(i++));
                rangeItemValue2.num_4_a_std(continuousRangeValues.get_Item(i));
                try {
                    if (NUM_TYPE.num_cmp(checkedNum, rangeItemValue1) !== -1 && NUM_TYPE.num_cmp(rangeItemValue2, checkedNum) !== -1) {
                        return this._newvalue;
                    }
                }
                catch (ex_15B) {
                }
            }
        }
        throw new WrongFormatException();
    }
    setNumericValueWithoutPicture(val) {
        let checkedStr = new StringBuilder(val.length);
        let isFirstDecimal = false;
        let currChar;
        for (let i = 0; i < this._pictureReal.length && i < val.length; i++) {
            currChar = val[i];
            if (UtilStrByteMode.isDigit(currChar))
                checkedStr.Append(currChar);
            else if (currChar === this._environment.GetDecimal() && !isFirstDecimal) {
                checkedStr.Append(NString.ToCharArray(NumberFormatInfo.NumberDecimalSeparator).toString());
                isFirstDecimal = true;
            }
            else if (currChar === '-' && this._valDet.getIsNegative())
                checkedStr.Append(NString.ToCharArray(NumberFormatInfo.NegativeSign).toString());
        }
        if (checkedStr.ToString().length === 0) {
            this.printMessage(MsgInterface.STR_ERR_NUM, false);
            this.setValidationFailed(true);
        }
        return checkedStr.ToString();
    }
    checkNumericInDecFormat() {
        let pic = this._valDet.getPIC();
        let i;
        let Dec;
        let Whole;
        let DecPos;
        let decimalChar = this._environment.GetDecimal();
        Dec = 0;
        Whole = 0;
        DecPos = -1;
        for (i = 0; i < this._newvalue.length; i++)
            if (pic.isNumeric(i))
                if (UtilStrByteMode.isDigit(this._newvalue[i]))
                    if (DecPos >= 0)
                        Dec++;
                    else
                        Whole++;
                else if (this._newvalue[i] === decimalChar)
                    DecPos = i;
        if (pic.getWholes() < Whole || pic.getDec() < Dec)
            return false;
        else
            return true;
    }
    checkDateField() {
        let newDate = (this._newvalue == null ? null : new Date(this._newvalue));
        this.setValidationFailed(false);
        if (this._valDet.getControl().isDateZero(this._newvalue)) {
            let defaultMgValue = this._valDet.getControl().getField().getDefaultValue();
            newDate = DisplayConvertor.Instance.mg2disp(defaultMgValue, "", this._valDet.getPIC(), true, this._valDet.getControl().getForm().getTask().getCompIdx(), false);
        }
        else {
            if (this._valDet.getContinuousRangeValues() != null || this._valDet.getDiscreteRangeValues() != null)
                newDate = this.fillDateByRange(this._valDet.getContinuousRangeValues(), this._valDet.getDiscreteRangeValues(), this._newvalue);
        }
        return newDate;
    }
    fillDateByRange(ContinuousRange, DiscreteRange, buffer) {
        let pic = this._valDet.getPIC();
        let i;
        let downDate;
        let topDate;
        let currDate = DisplayConvertor.Instance.fromNativeDateToMgDateNumber(buffer, pic);
        this.setValidationFailed(false);
        if (ContinuousRange != null) {
            for (i = 0; i < ContinuousRange.length - 1; i++) {
                downDate = DisplayConvertor.Instance.a_2_date_pic(ContinuousRange.get_Item(i), pic, pic.getMask(), this._valDet.getControl().getForm().getTask().getCompIdx());
                topDate = DisplayConvertor.Instance.a_2_date_pic(ContinuousRange.get_Item(++i), pic, pic.getMask(), this._valDet.getControl().getForm().getTask().getCompIdx());
                if (currDate >= downDate && currDate <= topDate)
                    return new Date(buffer);
            }
        }
        if (DiscreteRange != null) {
            for (i = 0; i < DiscreteRange.length; i++) {
                if (currDate === DisplayConvertor.Instance.a_2_date_pic(DiscreteRange.get_Item(i), pic, pic.getMask(), this._valDet.getControl().getForm().getTask().getCompIdx())) {
                    return new Date(buffer);
                }
            }
        }
        throw new WrongFormatException();
    }
    checkTimeField() {
        let newTime = new Date(this._newvalue);
        this.setValidationFailed(false);
        if (this._valDet.getControl().isDateZero(this._newvalue)) {
            let defaultMgValue = this._valDet.getControl().getField().getDefaultValue();
            newTime = DisplayConvertor.Instance.mg2disp(defaultMgValue, "", this._valDet.getPIC(), true, this._valDet.getControl().getForm().getTask().getCompIdx(), false);
        }
        else {
            if (this._valDet.getContinuousRangeValues() != null || this._valDet.getDiscreteRangeValues() != null)
                newTime = this.fillTimeByRange(this._valDet.getContinuousRangeValues(), this._valDet.getDiscreteRangeValues(), this._newvalue);
        }
        return newTime;
    }
    fillTimeByRange(ContinuousRange, DiscreteRange, buffer) {
        let pic = this._valDet.getPIC();
        let currTime = DisplayConvertor.Instance.fromNativeTimeToMgTimeNumber(buffer);
        let downTime, topTime;
        let i;
        this.setValidationFailed(false);
        if (ContinuousRange != null) {
            for (i = 0; i < ContinuousRange.length - 1; i++) {
                downTime = DisplayConvertor.Instance.a_2_time(ContinuousRange.get_Item(i), pic, false);
                topTime = DisplayConvertor.Instance.a_2_time(ContinuousRange.get_Item(++i), pic, false);
                if (currTime >= downTime && currTime <= topTime)
                    return new Date(buffer);
            }
        }
        if (DiscreteRange != null) {
            for (i = 0; i < DiscreteRange.length; i++) {
                if (currTime === DisplayConvertor.Instance.a_2_time(DiscreteRange.get_Item(i), pic, false))
                    return new Date(buffer);
            }
        }
        throw new WrongFormatException();
    }
    printMessage(msgId, setValidationFaild) {
        let message = new StringBuilder("");
        let ctrlType;
        if (msgId === MsgInterface.EDT_ERR_STR_1) {
            let pic = this._valDet.getPIC();
            let token = "%d";
            let messageString = Events.GetMessageString(msgId);
            messageString = StrUtil.replaceStringTokens(messageString, token, 1, pic.getWholes().toString());
            messageString = StrUtil.replaceStringTokens(messageString, token, 1, pic.getDec().toString());
            message.Append(messageString);
        }
        else {
            message.Append(Events.GetMessageString(msgId));
            if (msgId === MsgInterface.STR_RNG_TXT && this._valDet.getRange() != null)
                message.Append(StrUtil.makePrintableTokens(this._valDet.getRange(), HTML_2_STR));
        }
        if (this._valDet.getControl() != null) {
            ctrlType = this._valDet.getControl().Type;
            if (ctrlType !== MgControlType.CTRL_TYPE_BUTTON && ctrlType !== MgControlType.CTRL_TYPE_RADIO && !this._valDet.getControl().isSelectionCtrl()) {
                let msgString = message.ToString();
                this._valDet.getControl().getForm().getTask().WriteToMessagePane(StrUtil.makePrintable2(msgString));
                this._valDet.getControl().getForm().ErrorOccured = !NString.IsNullOrEmpty(msgString);
                this._valDet.ErrorMessage = message.ToString();
            }
        }
        if (setValidationFaild)
            this.setValidationFailed(true);
    }
    changeStringInside(to, index) {
        this._newvalue = this._newvalue.substr(0, index) + to + this._newvalue.substr(index + to.length);
    }
    init(validationDetails) {
        this._valDet = validationDetails;
        this._valDet.setNull(false);
        let pIC = this._valDet.getPIC();
        this._oldvalue = this._valDet.getOldValue();
        this._newvalue = this._valDet.getDispValue();
        if (this._newvalue === null) {
            if (pIC == null || pIC.getAttr() != StorageAttribute.DATE)
                this._newvalue = "";
        }
        if (this._oldvalue === null) {
            this._oldvalue = "";
        }
        if (!(pIC === null || pIC.getAttr() === StorageAttribute.BLOB || pIC.getAttr() === StorageAttribute.BLOB_VECTOR)) {
            this._picture = pIC.getMask();
            this._picture = this._picture.substr(0, pIC.getMaskSize());
        }
    }
    setValidationFailed(val) {
        if (this._valDet.ValidationFailed)
            return;
        else
            this._valDet.setValidationFailed(val);
    }
    digitsBeforeDelimeter(inputString, searchStart, delimeter) {
        let counter = 0;
        let searchEndPos = inputString.indexOf(delimeter, searchStart);
        if (searchEndPos < 0)
            searchEndPos = inputString.length;
        for (let i = searchStart; i < searchEndPos; i++)
            if (NChar.IsDigit(inputString[i]))
                counter++;
        return counter;
    }
    isNullDisplayVal() {
        let isNullDisplayVal = false;
        let field = this._valDet.getControl().getField();
        if (field.NullAllowed && field.hasNullDisplayValue()) {
            let dispDefValue = field.getNullDisplay();
            if (dispDefValue !== null)
                isNullDisplayVal = (dispDefValue.toString() === this._newvalue);
            else
                isNullDisplayVal = (this._newvalue === null);
        }
        return isNullDisplayVal;
    }
}

class ValidationDetails extends ValidationDetailsBase {
    get ErrorMessage() {
        return this.errMessage;
    }
    set ErrorMessage(msg) {
        this.errMessage = msg;
    }
    get ValidationFailed() {
        return this._validationFailed;
    }
    constructor(oldvalueOrRangeStrOrVd, val, range, pic, control) {
        super();
        this._control = null;
        this._fieldValidator = null;
        this._picData = null;
        this._pictureEnable = null;
        this._pictureReal = null;
        this._isNull = false;
        this._oldvalue = null;
        this._val = null;
        this._validationFailed = false;
        this.errMessage = null;
        this.constructor_3();
        if (arguments.length === 5)
            this.constructor_0(oldvalueOrRangeStrOrVd, val, range, pic, control);
        else if (arguments.length === 1 && (oldvalueOrRangeStrOrVd === null || oldvalueOrRangeStrOrVd.constructor === String))
            this.constructor_1(oldvalueOrRangeStrOrVd);
        else if (arguments.length === 1 && (oldvalueOrRangeStrOrVd === null || oldvalueOrRangeStrOrVd instanceof ValidationDetails))
            this.constructor_2(oldvalueOrRangeStrOrVd);
    }
    constructor_0(oldvalue, val, range, pic, control) {
        this._picData = pic;
        this._oldvalue = oldvalue;
        this._val = val;
        this._range = range;
        this._control = control;
        switch (pic.getAttr()) {
            case StorageAttribute.NUMERIC:
                this._pictureReal = new StringBuilder(this._picData.getMaskSize());
                this._pictureEnable = new StringBuilder(this._picData.getMaskSize());
                this.getRealNumericPicture();
                break;
            case StorageAttribute.BOOLEAN:
                if (this._range == null)
                    this._range = "True,False";
                break;
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
            case StorageAttribute.ALPHA:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
            case StorageAttribute.UNICODE:
                break;
            default:
                Events.WriteExceptionToLog("ValidationDetails.ValidationDetails: There is no type " +
                    this._picData.getAttr());
                break;
        }
        if (this._range != null)
            this.fillRange();
        range = null;
    }
    constructor_1(rangeStr) {
        this.constructor_3();
        this._range = rangeStr;
        if (this._range !== null)
            this.fillRange();
    }
    constructor_2(vd) {
        this.constructor_3();
        this._oldvalue = vd.getOldValue();
        this._val = vd._val;
        this._range = vd.getRange();
        this._control = vd.getControl();
        this._validationFailed = false;
        if (vd._pictureReal !== null) {
            this._pictureReal = new StringBuilder(vd._pictureReal.ToString());
        }
        if (vd._pictureEnable !== null) {
            this._pictureEnable = new StringBuilder(vd._pictureEnable.ToString());
        }
        if (vd.getDiscreteRangeValues() !== null) {
            this._discreteRangeValues = vd.CloneDiscreteRangeValues();
        }
        if (vd.getContinuousRangeValues() != null) {
            this._continuousRangeValues = vd.CloneContinuousRangeValues();
        }
        this._picData = vd.getPIC();
        this._isNull = vd.getIsNull();
    }
    constructor_3() {
        this._fieldValidator = new FieldValidator();
    }
    getRealNumericPicture() {
        let mask = this._picData.getMask();
        let dec_ = this._picData.getDec();
        let whole_ = this._picData.getWholes();
        let decimal_ = this._picData.withDecimal();
        let dec_pnt_in_first = this._picData.decInFirstPos();
        let isNegative = this._picData.isNegative();
        let isFirstPic_N = true;
        let isPointInserted = false;
        let currChar = 0;
        for (let i = 0; i < this._picData.getMaskSize(); i = i + 1) {
            currChar = +mask.charAt(i);
            switch (currChar) {
                case PICInterface.PIC_N:
                    if (isFirstPic_N) {
                        if (isNegative)
                            this.setPictures('-', '0');
                        if (dec_pnt_in_first) {
                            this.setPictures('.', '1');
                            isPointInserted = true;
                        }
                        else if (whole_ > 0) {
                            whole_--;
                            this.setPictures('#', '0');
                        }
                        isFirstPic_N = false;
                        break;
                    }
                    if (decimal_) {
                        if (whole_ > 0) {
                            whole_--;
                            this.setPictures('#', '0');
                        }
                        else if (whole_ === 0 && !isPointInserted) {
                            this.setPictures('.', '1');
                            isPointInserted = true;
                        }
                        else if (dec_ > 0) {
                            dec_--;
                            this.setPictures('#', '0');
                        }
                    }
                    else {
                        if (whole_ > 0) {
                            whole_--;
                            this.setPictures('#', '0');
                        }
                    }
                    break;
                default:
                    this.setPictures(currChar.toString(), '1');
                    break;
            }
        }
        Events.WriteDevToLog(this._pictureReal.ToString());
        Events.WriteDevToLog(this._pictureEnable.ToString());
    }
    setPictures(Real, Enable) {
        this._pictureEnable.Append(Enable);
        this._pictureReal.Append(Real);
    }
    setValue(val) {
        this._val = val;
    }
    setOldValue(oldvalue) {
        this._oldvalue = oldvalue;
    }
    setRange(range) {
        this._range = range;
    }
    setValidationFailed(val) {
        this._validationFailed = val;
    }
    setNull(isNull_) {
        this._isNull = isNull_;
    }
    getDispValue() {
        if (typeof this._val === 'string') {
            let minimumValueLength = this._picData.getMinimumValueLength();
            if (this._val.length > minimumValueLength) {
                if (minimumValueLength > 0 || StrUtil.rtrim(this._val).length > 0) {
                    let str = this._val.substr(minimumValueLength);
                    this._val = this._val.substr(0, minimumValueLength);
                    this._val = this._val + StrUtil.rtrim(str);
                }
            }
        }
        else {
            if (this._control != null && this._control.isChoiceControl())
                this._val = this._val.toString();
        }
        return this._val;
    }
    getOldValue() {
        return this._oldvalue;
    }
    getType() {
        return this._picData.getAttr();
    }
    getPictureReal() {
        return this._pictureReal.ToString();
    }
    getPictureEnable() {
        return this._pictureEnable.ToString();
    }
    getIsNegative() {
        return this._picData.isNegative();
    }
    getIsPadFill() {
        return this._picData.padFill();
    }
    getPadFillChar() {
        return this._picData.getPad();
    }
    getIsZeroFill() {
        return this._picData.zeroFill();
    }
    getZeroFillChar() {
        return this._picData.getZeroPad();
    }
    getNegativeSignPref() {
        return this._picData.getNegPref_();
    }
    getRange() {
        return this._range;
    }
    getControl() {
        return this._control;
    }
    getPIC() {
        return this._picData;
    }
    getIsNull() {
        return this._isNull;
    }
    evaluate() {
        return this._fieldValidator.checkVal(this);
    }
    CloneDiscreteRangeValues() {
        let clone = new List();
        clone.AddRange(this._discreteRangeValues.GetEnumerator());
        return clone;
    }
    CloneContinuousRangeValues() {
        let clone = new List();
        clone.AddRange(this._continuousRangeValues.GetEnumerator());
        return clone;
    }
}

const EMPTY_DCREF = -2;
const NOT_FOUND = GuiConstants.DEFAULT_VALUE_INT;
class DcValues {
    get HasReferences() {
        return this._refCount > 0;
    }
    constructor(empty) {
        this._id = 0;
        this._type = StorageAttribute.NONE;
        this._refCount = 0;
        this._nullFlags = null;
        this._isNumericType = false;
        this._numVals = null;
        this._linkVals = null;
        this._dispVals = null;
        if (empty) {
            this._id = EMPTY_DCREF;
        }
        this._isNumericType = false;
    }
    GetAttr() {
        return this._type;
    }
    setType(type) {
        this._type = type;
        if (this._type === StorageAttribute.MEMO)
            this._type = StorageAttribute.ALPHA;
        if (this._type === StorageAttribute.NUMERIC || this._type === StorageAttribute.DATE ||
            this._type === StorageAttribute.TIME) {
            this._isNumericType = true;
        }
    }
    SetID(newId) {
        this._id = newId;
    }
    SetDisplayValues(displayValues) {
        if (displayValues !== null)
            this._dispVals = displayValues.slice();
        else
            this._dispVals = null;
    }
    SetLinkValues(linkValues) {
        if (linkValues !== null)
            this._linkVals = linkValues.slice();
        else
            this._linkVals = null;
        this.setNumericVals();
    }
    setNullFlags(nullFlags) {
        if (nullFlags !== null)
            this._nullFlags = nullFlags.slice();
        else
            this._nullFlags = null;
    }
    setNumericVals() {
        if (this._isNumericType && this._linkVals !== null) {
            this._numVals = new Array(this._linkVals.length);
            for (let i = 0; i < this._linkVals.length; i = i + 1) {
                this._numVals[i] = new NUM_TYPE(this._linkVals[i]);
            }
        }
        else {
            this._numVals = null;
        }
    }
    getId() {
        return this._id;
    }
    getDispVals() {
        return this._dispVals;
    }
    GetLinkVals() {
        return this._linkVals;
    }
    getIndexOf(mgVal, isVectorValue, isNull, extraVals, extraNums, splitCommaSeperatedVals) {
        let result = NOT_FOUND;
        let tmpMgVal;
        let ctrlNumVal;
        let trimmedVal;
        let vals = null;
        let nums = null;
        let offset = 0;
        let firstFitMatchIdx;
        let firstFitMatchLength = -1;
        let minLength = -1;
        let compStr = "";
        let indice = null;
        let values = null;
        if (isNull) {
            let i = 0;
            indice = [
                NOT_FOUND
            ];
            for (i = 0; this._nullFlags !== null && i < this._nullFlags.length; i++) {
                if (this._nullFlags[i]) {
                    indice[0] = i;
                    break;
                }
            }
            return indice;
        }
        if (!isVectorValue) {
            if (splitCommaSeperatedVals) {
                values = mgVal.split(',');
            }
            else {
                values = [
                    mgVal
                ];
            }
        }
        else {
            let vectorType = new VectorType(mgVal);
            values = vectorType.GetCellValues();
        }
        indice = new Array(values.length);
        for (let iCtr = 0; iCtr < values.length; iCtr = iCtr + 1) {
            result = NOT_FOUND;
            firstFitMatchIdx = NOT_FOUND;
            tmpMgVal = values[iCtr];
            if (this._isNumericType || extraNums !== null) {
                ctrlNumVal = new NUM_TYPE(tmpMgVal);
                trimmedVal = tmpMgVal;
            }
            else {
                ctrlNumVal = null;
                trimmedVal = StrUtil.rtrim(tmpMgVal);
            }
            for (let i = 0; i < 2 && result === NOT_FOUND; i++) {
                switch (i) {
                    case 0:
                        vals = extraVals;
                        nums = extraNums;
                        offset = 0;
                        break;
                    case 1:
                    default:
                        if (this._isNumericType || nums != null)
                            offset = (nums == null ? 0 : nums.length);
                        else
                            offset = (vals == null ? 0 : vals.length);
                        vals = this._linkVals;
                        nums = this._numVals;
                        break;
                }
                if (vals != null) {
                    for (let j = 0; j < vals.length && result === NOT_FOUND; j++) {
                        if (this._isNumericType || nums != null) {
                            if (NUM_TYPE.num_cmp(ctrlNumVal, nums[j]) === 0 || tmpMgVal === vals[j] ||
                                tmpMgVal === vals[j]) {
                                result = j + offset;
                                break;
                            }
                        }
                        else {
                            if (vals[j] === tmpMgVal || trimmedVal.length > 0 && StrUtil.rtrim(vals[j]) === trimmedVal) {
                                result = j + offset;
                                break;
                            }
                            if (trimmedVal.length === 0 && StrUtil.rtrim(vals[j]).length === 0) {
                                result = j + offset;
                                break;
                            }
                            if (result === NOT_FOUND && trimmedVal.length > 0) {
                                minLength = Math.min(trimmedVal.length, vals[j].length);
                                compStr = trimmedVal.substr(0, minLength);
                                if (compStr.length > 0 && vals[j].startsWith(compStr)) {
                                    if (minLength > firstFitMatchLength) {
                                        firstFitMatchIdx = j + offset;
                                        firstFitMatchLength = minLength;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (result === NOT_FOUND)
                result = firstFitMatchIdx;
            indice[iCtr] = result;
        }
        return indice;
    }
    getLinkValue(idx) {
        let lnkVal = null;
        if (this._linkVals !== null) {
            lnkVal = this._linkVals[idx];
        }
        return lnkVal;
    }
    isNull(idx) {
        if (this._nullFlags == null)
            return false;
        return this._nullFlags[idx];
    }
    AddReference() {
        this._refCount++;
    }
    RemoveReference() {
        this._refCount--;
        if (this._refCount < 0) {
            throw new ApplicationException("in dcVals.decrease() references count is less than zero");
        }
    }
    ToString() {
        return NString.Format("{{DCValues 0x{0:X8}, {1} refs}}", this._id, this._refCount);
    }
}

class ObjectReference {
    constructor(ctlIndex, objectIsn) {
        this.CtlIndex = 0;
        this.ObjectISN = 0;
        this.CtlIndex = ctlIndex;
        this.ObjectISN = objectIsn;
    }
    toString() {
        return "{Object Ref: " + this.CtlIndex + "," + this.ObjectISN + "}";
    }
    static FromXML(xmlData) {
        this.ParsedReference = null;
        try {
            if (xmlData !== null) {
                JSON_Utils.JSONFromXML(xmlData, this.FillFromJSON.bind(this));
            }
        }
        catch (ex) {
            Events.WriteExceptionToLog(ex);
        }
        return this.ParsedReference;
    }
    static FillFromJSON(error, result) {
        if (error != null) {
            throw error;
        }
        let objRefElement = result[XMLConstants.MG_TAG_OBJECT_REFERENCE]['$'];
        let ctlIndex = +objRefElement.ctl_idx;
        let objectIsn = +objRefElement.isn;
        this.ParsedReference = new ObjectReference(ctlIndex, objectIsn);
    }
}
ObjectReference.ParsedReference = null;

class FocusManager {
    static async SetFocus(ctrlOrItask, lineOrCtrl, line, activateForm) {
        if (ctrlOrItask instanceof GuiControlPropertyAdapter) {
            await FocusManager.SetFocus_0(ctrlOrItask, lineOrCtrl);
            return;
        }
        await FocusManager.SetFocus_1(ctrlOrItask, lineOrCtrl, line, activateForm);
    }
    static async SetFocus_0(ctrl, line) {
        await FocusManager.SetFocus(ctrl.getForm().getTask(), ctrl, line, true);
    }
    static async SetFocus_1(itask, ctrl, line, activateForm) {
        let task = itask;
        if (task.isAborting())
            return;
        Events.OnCtrlFocus(itask, ctrl);
        if (ctrl !== null) {
            if (!await ctrl.isParkable(true))
                return;
            Commands.addBoolWithLine(CommandType.SET_FOCUS, ctrl, (line >= 0) ? line : ctrl.getDisplayLine(false), activateForm);
        }
        else {
            let formObject = task.IsSubForm
                ? task.getForm().getSubFormCtrl()
                : task.getForm();
            Commands.addBoolWithLine(CommandType.SET_FOCUS, formObject, 0, activateForm);
        }
    }
}

class MgControlBase extends GuiControlPropertyAdapter {
    set Form(value) {
        this._form = value;
        this.GuiMgForm = value;
    }
    get Form() {
        return this._form;
    }
    get ControlIsn() {
        return this._controlIsn;
    }
    constructor(type, parentMgForm, parentControl) {
        super();
        this._ditIdx = 0;
        this._linkedControls = null;
        this._field = null;
        this._picStr = null;
        this._choiceDisps = null;
        this._choiceLayerList = null;
        this._choiceLinks = null;
        this._choiceNums = null;
        this._containerDitIdx = -1;
        this._currReadOnly = null;
        this._dataCtrl = false;
        this._dcTableRefs = null;
        this._firstRefreshProperties = true;
        this._form = null;
        this._hasValidItmAndDispVal = false;
        this._controlIsn = -1;
        this._linkedParentDitIdx = -1;
        this._orgChoiceDisps = null;
        this._parentTable = null;
        this._pic = null;
        this._picExpExists = false;
        this._prevIsNulls = null;
        this._prevPicExpResult = null;
        this._prevValues = null;
        this._propTab = null;
        this._range = null;
        this._rangeChanged = false;
        this._valExpId = 0;
        this._vd = null;
        this._dcValId = -2;
        this.parent = 0;
        this.veeIndx = 0;
        this.SourceTableReference = null;
        this.ClipBoardDataExists = false;
        this.DataType = StorageAttribute.NONE;
        this.KeyStrokeOn = false;
        this.ModifiedByUser = false;
        this.Value = null;
        this.IsNull = false;
        this.forceRefresh = false;
        this.RefreshOnVisible = false;
        this.InControl = false;
        this.ValidateControl = false;
        this.PromptHelp = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(type, parentMgForm, parentControl);
    }
    constructor_0() {
        this._linkedControls = new List();
        this.DataType = StorageAttribute.NONE;
    }
    constructor_1(type, parentMgForm, parentControl) {
        this.constructor_0();
        this.initReferences(parentMgForm);
        this.Type = type;
        this._containerDitIdx = parentControl;
        this._linkedParentDitIdx = parentControl;
        this._propTab = new PropTable(this);
        this.createArrays(false);
    }
    get UniqueName() {
        return this.Name;
    }
    get TaskTag() {
        return this.Form.getTask().getTaskTag();
    }
    checkIfExistProp(propId) {
        let exist = false;
        if (this._propTab !== null) {
            let propById = this._propTab.getPropById(propId);
            exist = (propById !== null);
        }
        return exist;
    }
    getProp(propId) {
        let prop = null;
        if (this._propTab !== null) {
            prop = this._propTab.getPropById(propId);
            if (prop === null) {
                prop = Property.getDefaultProp(propId, 'C', this);
                if (prop !== null) {
                    this._propTab.addProp(prop);
                }
            }
        }
        return prop;
    }
    getForm() {
        return this.Form;
    }
    getCompIdx() {
        return this.getForm().getTask().getCompIdx();
    }
    IsFirstRefreshOfProps() {
        return this._firstRefreshProperties;
    }
    async EvaluateExpression(expId, resType, length, contentTypeUnicode, resCellType, alwaysEvaluate, wasEvaluated) {
        return await this.getForm().getTask().EvaluateExpression(expId, resType, length, contentTypeUnicode, resCellType, alwaysEvaluate, wasEvaluated);
    }
    GetExpressionStorage(expId) {
        return this.getForm().getTask().GetExpressionStorage(expId);
    }
    GetComputedProperty(propId) {
        let prop = null;
        if (this._propTab !== null)
            prop = this._propTab.getPropById(propId);
        return prop;
    }
    initReferences(mgForm) {
        this.Form = mgForm;
    }
    createArrays(forceCreateArrays) {
        if (this._firstRefreshProperties || forceCreateArrays) {
            if (this.SupportsDataSource()) {
                this._dcTableRefs = new List();
            }
            this._prevValues = new List();
            if (!forceCreateArrays) {
                this._currReadOnly = new List();
            }
            this._choiceDisps = new List();
            this._orgChoiceDisps = new List();
            this._choiceLinks = new List();
            this._choiceNums = new List();
            this._prevIsNulls = new List();
            this._choiceLayerList = new List();
            if (!this.IsRepeatable && !super.isTableControl()) {
                this.updateArrays(1);
            }
        }
    }
    async SetFocus(ctrl, line, activateForm) {
        await FocusManager.SetFocus(ctrl.getForm().getTask(), ctrl, line, activateForm);
    }
    InsertArrays(idx, count) {
        this._prevValues.InsertRange(new Array(count));
        this._prevIsNulls.InsertRange(new Array(count));
        this._currReadOnly.InsertRange(new Array(count));
        this._choiceDisps.InsertRange(new Array(count));
        this._orgChoiceDisps.InsertRange(new Array(count));
        this._choiceLinks.InsertRange(new Array(count));
        this._choiceLayerList.InsertRange(new Array(count));
        this._choiceNums.InsertRange(new Array(count));
        if (this.SupportsDataSource())
            this._dcTableRefs.InsertRange(new Array(count));
        this._propTab.InsertPrevValueArray(count);
    }
    updateArrays(newSize) {
        this._prevValues.SetSize(newSize);
        this._prevIsNulls.SetSize(newSize);
        this._currReadOnly.SetSize(newSize);
        this._choiceDisps.SetSize(newSize);
        this._orgChoiceDisps.SetSize(newSize);
        this._choiceLinks.SetSize(newSize);
        this._choiceLayerList.SetSize(newSize);
        this._choiceNums.SetSize(newSize);
        if (this.SupportsDataSource()) {
            this._dcTableRefs.SetSize(newSize);
        }
        this._propTab.updatePrevValueArray(newSize);
    }
    updatePrevValArrays(newSize) {
        this._propTab.updatePrevValueArray(newSize);
    }
    fillData(mgForm, ditIdx, parser) {
        if (this.Form === null) {
            this.initReferences(mgForm);
        }
        this._ditIdx = ditIdx;
        while (this.initInnerObjects(parser.getNextTag(), parser)) {
        }
        if (this.DataType === StorageAttribute.BLOB && this._picStr === null) {
            this._picStr = "";
        }
        if (this._picStr !== null && typeof this.DataType !== "undefined") {
            this.setPIC(this._picStr);
        }
        else {
            switch (this.Type) {
                case MgControlType.CTRL_TYPE_IMAGE:
                case MgControlType.CTRL_TYPE_BROWSER:
                case MgControlType.CTRL_TYPE_BUTTON:
                    if (this.DataType === StorageAttribute.NONE)
                        this.DataType = StorageAttribute.ALPHA;
                    break;
                case MgControlType.CTRL_TYPE_TABLE:
                case MgControlType.CTRL_TYPE_COLUMN:
                case MgControlType.CTRL_TYPE_SUBFORM:
                case MgControlType.CTRL_TYPE_GROUP:
                case MgControlType.CTRL_TYPE_FRAME_SET:
                case MgControlType.CTRL_TYPE_FRAME_FORM:
                case MgControlType.CTRL_TYPE_CONTAINER:
                case MgControlType.CTRL_TYPE_LINE:
                    break;
                default:
                    Events.WriteExceptionToLog(NString.Format("in Control.fillData(): missing datatype or picture string for control: {0}", this.Name));
                    break;
            }
        }
        if (super.isTableControl()) {
            this.Form.setTableCtrl(this);
        }
        this.createArrays(false);
    }
    initInnerObjects(foundTagName, parser) {
        if (foundTagName === null)
            return false;
        if (foundTagName === XMLConstants.MG_TAG_PROP) {
            if (this._propTab === null)
                this._propTab = new PropTable(this);
            this._propTab.fillData(this, 'C', parser);
        }
        else if (foundTagName === XMLConstants.MG_TAG_CONTROL)
            this.parseAttributes(parser);
        else if (foundTagName === "SourceTable")
            this.ParseSourceTable(parser);
        else if (foundTagName === "/" + XMLConstants.MG_TAG_CONTROL) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Events.WriteExceptionToLog(NString.Format("There is no such tag in Control. Insert else if to Control.initInnerObjects for {0}", foundTagName));
            return false;
        }
        return true;
    }
    ParseSourceTable(parser) {
        parser.setCurrIndex2EndOfTag();
        let objRefStr = parser.ReadToEndOfCurrentElement();
        let sourceTableReference = ObjectReference.FromXML(objRefStr.trim());
        this.SourceTableReference = sourceTableReference;
        parser.setCurrIndex2EndOfTag();
    }
    parseAttributes(parser) {
        let endContext = parser.getXMLdata().indexOf(">", parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(XMLConstants.MG_TAG_CONTROL) + XMLConstants.MG_TAG_CONTROL.length);
            let tokens = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let i = 0; i < tokens.length; i = i + 2) {
                let attribute = tokens.get_Item(i);
                let valueStr = tokens.get_Item(i + 1);
                this.SetAttribute(attribute, valueStr);
            }
            parser.setCurrIndex(endContext + 1);
        }
        else {
            Events.WriteExceptionToLog("in Control.FillName() out of string bounds");
        }
    }
    SetAttribute(attribute, valueStr) {
        let isTagProcessed = true;
        switch (attribute) {
            case XMLConstants.MG_ATTR_TYPE:
                this.Type = valueStr[0];
                break;
            case XMLConstants.MG_ATTR_DATA_CTRL:
                this._dataCtrl = XmlParser.getBoolean(valueStr);
                break;
            case XMLConstants.MG_ATTR_LINKED_PARENT:
                this.setLinkedParentIdx(XmlParser.getInt(valueStr));
                break;
            case XMLConstants.MG_ATTR_CONTAINER:
                this.setContainer(XmlParser.getInt(valueStr));
                break;
            case XMLConstants.MG_ATTR_CONTROL_ISN:
                this._controlIsn = XmlParser.getInt(valueStr);
                break;
            case XMLConstants.MG_ATTR_IS_MODAL:
                this._isModal = XmlParser.getBoolean(valueStr);
                break;
            case XMLConstants.MG_ATTR_CONTROL_Z_ORDER:
                break;
            case XMLConstants.MG_HOR_ALIGMENT_IS_INHERITED:
                break;
            default:
                isTagProcessed = false;
                break;
        }
        return isTagProcessed;
    }
    setImage() {
        let newVal = this.Value;
        if (newVal === null || this.IsNull) {
            newVal = "";
        }
        if (this.DataType === StorageAttribute.BLOB) {
        }
        else {
            this.setImageWithFileName(newVal);
        }
    }
    setImageWithFileName(fileName) {
        if (fileName === null) {
            fileName = "";
        }
        fileName = Events.TranslateLogicalName(fileName);
        if (!Misc.IsWebUrl(fileName))
            fileName = "./assets/images/" + fileName;
        if (this.IsImageButton()) {
            Commands.addOperationWithLine(CommandType.SET_STYLE, this, 0, MagicProperties.ImageFile, fileName);
        }
        else {
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, this.getDisplayLine(false), HtmlProperties.Image, fileName);
            Commands.addValueWithLine(CommandType.SET_VALUE, this, this.getDisplayLine(false), fileName);
        }
    }
    setContainer(containerIdx) {
        this._containerDitIdx = containerIdx;
        let container = null;
        if (this._containerDitIdx !== -1) {
            container = this.Form.getCtrl(this._containerDitIdx);
        }
        if (container !== null && container.Type === MgControlType.CTRL_TYPE_TABLE) {
            this._parentTable = container;
        }
        this.IsRepeatable = (this._parentTable !== null && !super.isColumnControl());
    }
    getName() {
        return this.Name;
    }
    getLinkedControls() {
        return this._linkedControls;
    }
    isRepeatable() {
        return this.IsRepeatable;
    }
    IsModal() {
        return this._isModal;
    }
    getDisplayLine(useLineForItems) {
        let line = 0;
        if (this.IsRepeatable || (useLineForItems && super.isTableControl())) {
            line = this.Form.DisplayLine;
        }
        return line;
    }
    isVisible() {
        let result = this.GetComputedBooleanProperty(PropInterface.PROP_TYPE_VISIBLE, true);
        if (result) {
            result = this.isParentPropValue(PropInterface.PROP_TYPE_VISIBLE);
        }
        return result;
    }
    isEnabled() {
        return this.GetComputedBooleanProperty(PropInterface.PROP_TYPE_ENABLED, true);
    }
    isModifiable() {
        let modifiable = this.GetComputedBooleanProperty(PropInterface.PROP_TYPE_MODIFIABLE, true);
        let taskInQuery = this.getForm().getTask().getMode() === Constants.TASK_MODE_QUERY;
        let modifyInQuery = this.GetComputedBooleanProperty(PropInterface.PROP_TYPE_MODIFY_IN_QUERY, false);
        let result = modifiable && (modifyInQuery || !taskInQuery);
        if (result && this._field != null) {
            result = (this._field.DbModifiable || this.getForm().getTask().getMode() === Constants.TASK_MODE_CREATE);
        }
        return result;
    }
    getDcVals() {
        let dataView = this.getForm().getTask().DataView;
        let dcv = null;
        if (this._dcValId === EMPTY_DCREF) {
            dcv = ((this.DataType === StorageAttribute.BLOB_VECTOR) ? dataView.getEmptyChoiceForVectors() : dataView.getEmptyChoice());
        }
        else {
            if (this._dcValId > -1) {
                dcv = dataView.getDcValues(this._dcValId);
            }
        }
        return dcv;
    }
    getPrevIsNull() {
        let line = this.getDisplayLine(true);
        let currObj = this._prevIsNulls.get_Item(line);
        let curr;
        if (currObj === null) {
            curr = false;
            this._prevIsNulls.set_Item(line, curr);
        }
        else {
            curr = currObj;
        }
        return curr;
    }
    setPrevIsNull(newValue) {
        this._prevIsNulls.set_Item(this.getDisplayLine(true), newValue);
    }
    setPIC(picStr) {
        if (super.isButton()) {
            this._picStr = (super.IsImageButton() ? "" + XMLConstants.FILE_NAME_SIZE.toString() : Events.Translate(picStr));
        }
        else {
            this._picStr = picStr;
        }
        this._pic = new PIC(this._picStr, this.DataType, this.getForm().getTask().getCompIdx());
        if (this._dataCtrl && this._picStr.indexOf('H') > -1) {
            this._pic.setHebrew();
        }
    }
    getPIC() {
        if (this._picExpExists)
            this._pic.setFormatExp(this._picExpExists);
        return this._pic;
    }
    getParent() {
        let retParent = this.Form;
        if (this._containerDitIdx !== -1) {
            retParent = this.Form.getCtrl(this._containerDitIdx);
        }
        else {
            if (this.Form.isSubForm()) {
                retParent = this.Form.getSubFormCtrl();
            }
        }
        return retParent;
    }
    getField() {
        return this._field;
    }
    setField(fieldOrFieldStrID) {
        if (fieldOrFieldStrID === null || fieldOrFieldStrID instanceof GuiFieldBase) {
            this.setField_0(fieldOrFieldStrID);
            return;
        }
        this.setField_1(fieldOrFieldStrID);
    }
    setField_0(field) {
        this._field = field;
        if (field !== null) {
            this._field.SetControl(this);
        }
    }
    setField_1(fieldStrID) {
        let returnField = this.getFieldByValueStr(fieldStrID);
        if (returnField !== null) {
            this._field = returnField;
            this._field.SetControl(this);
            return;
        }
        throw new ApplicationException("in Control.setField(): illegal field identifier: " + fieldStrID);
    }
    setPicStr(format, expId) {
        this._picStr = format;
        if (expId > 0) {
            this._picExpExists = true;
        }
    }
    setRange(newRange) {
        this._range = newRange;
        this._vd = null;
    }
    setValExp(expId) {
        this._valExpId = expId;
    }
    buildCopyPicture(oldVal, newVal) {
        if (super.isTableControl() || super.isColumnControl()) {
            return null;
        }
        else {
            let copyVD = this.getCopyOfVD();
            copyVD.setValue(newVal);
            copyVD.setOldValue(oldVal);
            return copyVD;
        }
    }
    getCopyOfVD() {
        let result;
        if (this._vd === null) {
            result = new ValidationDetails(this.Value, this.Value, this._range, this._pic, this);
        }
        else {
            result = new ValidationDetails(this._vd);
        }
        return result;
    }
    getRanges() {
        return this._range;
    }
    getRangedValue(newVal) {
        let vd;
        vd = this.buildPicture(this.Value, newVal);
        vd.evaluate();
        this.ModifiedByUser = true;
        let val = vd.getDispValue();
        return (val.toString());
    }
    validate(newVal) {
        let vd;
        let modified = this.ModifiedByUser;
        this.ModifiedByUser = true;
        vd = this.buildPicture(this.Value, newVal);
        vd.evaluate();
        this.ModifiedByUser = modified;
        if (vd.ValidationFailed)
            return vd.ErrorMessage;
        else
            return null;
    }
    getFieldByValueStr(valueStr) {
        let refParent = new RefParam(this.parent);
        let refVeeIndx = new RefParam(this.veeIndx);
        let ret = this.getForm().getTask().getFieldByValueStr(valueStr, refParent, refVeeIndx);
        this.parent = refParent.value;
        this.veeIndx = refVeeIndx.value;
        return ret;
    }
    hasContainer() {
        return this._containerDitIdx !== -1;
    }
    getLayer() {
        return this.Layer;
    }
    computePIC(picExpResult) {
        let picResult = (picExpResult !== null && super.isButton()) ? Events.Translate(picExpResult) : picExpResult;
        if (this._prevPicExpResult === null || !(this._prevPicExpResult === picResult)) {
            this._pic = new PIC(picResult, this.DataType, this.getForm().getTask().getCompIdx());
            this._prevPicExpResult = picResult;
        }
        return this._pic;
    }
    getCurrentIndexOfChoice() {
        let selectedIndice = [-1];
        let val = this.Value;
        if (!NString.IsNullOrEmpty(val)) {
            let array2 = val.split(',');
            selectedIndice = new Array(array2.length);
            for (let iCtr = 0; iCtr < array2.length; iCtr = iCtr + 1) {
                let num = NNumber.Parse(array2[iCtr]);
                selectedIndice[iCtr] = ((num >= 0) ? num : -1);
            }
        }
        return selectedIndice;
    }
    IsMultipleSelectionListBox() {
        return super.isListBox();
    }
    IsDateTimePicture() {
        return this._pic.getAttr() === StorageAttribute.DATE || this._pic.getAttr() === StorageAttribute.TIME;
    }
    SupportsDataSource() {
        return super.isSelectionCtrl() || super.isTabControl() || super.isRadio() || this.HasAutocomplete();
    }
    HasAutocomplete() {
        if (super.isTextControl())
            return this.getProp(PropInterface.PROP_TYPE_AUTO_COMPLETE_MODE_WC).GetComputedValueBoolean();
        return false;
    }
    async getIndexOfChoice(mgVal, line, isNull) {
        let splitCommaSeperatedVals = this.IsMultipleSelectionListBox();
        await this.computeChoice(line);
        let isVectorValue = this.getField() !== null && this.getField().getType() === StorageAttribute.BLOB_VECTOR;
        return this.getDcVals().getIndexOf(mgVal, isVectorValue, isNull, this._choiceLinks.get_Item(line), this._choiceNums.get_Item(line), splitCommaSeperatedVals);
    }
    async getDispVals(line, execComputeChoice) {
        if (execComputeChoice) {
            await this.computeChoice(line);
        }
        if (super.isTabControl()) {
            return this._orgChoiceDisps.get_Item(line);
        }
        else {
            return this._choiceDisps.get_Item(line);
        }
    }
    emptyChoice(line) {
        let value = new Array(0);
        this._choiceDisps.set_Item(line, value);
        this._orgChoiceDisps.set_Item(line, value);
        this._choiceLinks.set_Item(line, value);
        this._choiceLayerList.set_Item(line, value);
    }
    async computeChoice(line) {
        let fromHelp = [
            "\\\\", "\\-", "\\,"
        ];
        let toHelp = [
            "XX", "XX", "XX"
        ];
        let task = this.getForm().getTask();
        let dataView = task.DataView;
        let dcv = dataView.getDcValues(this._dcValId);
        let currDcId = this.getDcRef();
        let choiceDispStr = null;
        let choiceLinkStr = "";
        let optionsValid = true;
        let trimToLength = -1;
        let dataType = this.DataType;
        let isItemsListTreatedAsDisplayList = false;
        try {
            if (this._choiceLinks.get_Item(line) === null || (this.isDataCtrl() && currDcId !== this._dcValId)) {
                if (dataType === StorageAttribute.BLOB_VECTOR) {
                    dataType = this.getField().getCellsType();
                }
                let dispVals = dcv.getDispVals();
                let dispProp = this.getProp(PropInterface.PROP_TYPE_DISPLAY_LIST);
                let linkProp = this.getProp(PropInterface.PROP_TYPE_LABEL);
                if (dispProp !== null) {
                    choiceDispStr = await dispProp.getValue();
                }
                if (linkProp !== null) {
                    choiceLinkStr = await linkProp.getValue();
                }
                if (choiceLinkStr === null || StrUtil.rtrim(choiceLinkStr).length === 0) {
                    choiceLinkStr = "";
                }
                if (choiceDispStr === null || StrUtil.rtrim(choiceDispStr).length === 0) {
                    if (!this.isDataCtrl() || dispVals === null || dispVals.length === 0) {
                        choiceDispStr = choiceLinkStr;
                    }
                    else {
                        choiceDispStr = (choiceLinkStr = "");
                    }
                    isItemsListTreatedAsDisplayList = true;
                }
                choiceDispStr = Events.Translate(choiceDispStr);
                if (dataType === StorageAttribute.NUMERIC) {
                    choiceLinkStr = StrUtil.searchAndReplace(choiceLinkStr, "\\-", "-");
                }
                let helpStr = StrUtil.searchAndReplace(choiceLinkStr, fromHelp, toHelp);
                let sTok = StrUtil.tokenize(helpStr, ",");
                let linkSize = (helpStr !== "") ? sTok.length : 0;
                let helpStrDisp = StrUtil.searchAndReplace(choiceDispStr, fromHelp, toHelp);
                sTok = StrUtil.tokenize(helpStrDisp, ",");
                let displaySize = (helpStrDisp !== "") ? sTok.length : 0;
                if (linkSize !== displaySize && displaySize > 0) {
                    choiceDispStr = choiceLinkStr;
                    isItemsListTreatedAsDisplayList = true;
                }
                let size = linkSize;
                let choiceLink = new Array(size);
                this._choiceLinks.set_Item(line, choiceLink);
                if (dataType === StorageAttribute.NUMERIC || dataType === StorageAttribute.DATE || dataType === StorageAttribute.TIME) {
                    this._choiceNums.set_Item(line, new Array(size));
                }
                let orgChoiceDisp = ChoiceUtils.GetDisplayListFromString(choiceDispStr, false, true, !isItemsListTreatedAsDisplayList);
                this._orgChoiceDisps.set_Item(line, orgChoiceDisp);
                let choiceDisp = ChoiceUtils.GetDisplayListFromString(choiceDispStr, super.isSelectionCtrl() || super.isTabControl(), true, !isItemsListTreatedAsDisplayList);
                this._choiceDisps.set_Item(line, choiceDisp);
                if (this.getField() !== null) {
                    trimToLength = this.getField().getSize();
                }
                let token = null;
                let helpToken = null;
                let tokenBuffer;
                for (let i = 0, currPos = 0, nextPos = 0; i < size && optionsValid; i++) {
                    nextPos = currPos;
                    nextPos = helpStr.indexOf(',', nextPos);
                    if (nextPos === currPos)
                        token = helpToken = "";
                    else if (nextPos === -1) {
                        token = choiceLinkStr.substr(currPos);
                        helpToken = helpStr.substr(currPos);
                    }
                    else {
                        token = choiceLinkStr.substr(currPos, (nextPos) - (currPos));
                        helpToken = helpStr.substr(currPos, (nextPos) - (currPos));
                    }
                    currPos = nextPos + 1;
                    switch (dataType) {
                        case StorageAttribute.ALPHA:
                        case StorageAttribute.MEMO:
                        case StorageAttribute.UNICODE:
                        case StorageAttribute.BLOB_VECTOR:
                            token = StrUtil.ltrim(token);
                            helpToken = StrUtil.ltrim(helpToken);
                            if (helpToken.indexOf('\\') >= 0) {
                                tokenBuffer = new StringBuilder();
                                for (let tokenPos = 0; tokenPos < helpToken.length; tokenPos++)
                                    if (helpToken[tokenPos] !== '\\')
                                        tokenBuffer.Append(token[tokenPos]);
                                    else if (tokenPos === helpToken.length - 1)
                                        tokenBuffer.Append(' ');
                                token = tokenBuffer.ToString();
                            }
                            token = StrUtil.makePrintableTokens(token, SEQ_2_STR);
                            if (this.isSelectionCtrl() || this.isTabControl())
                                token = ChoiceUtils.RemoveAcclCharFromOptions(new StringBuilder(token));
                            if (UtilStrByteMode.isLocaleDefLangDBCS() && dataType === StorageAttribute.ALPHA) {
                                if (trimToLength !== -1 && UtilStrByteMode.lenB(token) > trimToLength)
                                    token = UtilStrByteMode.leftB(token, trimToLength);
                            }
                            else {
                                if (trimToLength !== -1 && token.length > trimToLength)
                                    token = token.substr(0, trimToLength);
                            }
                            choiceLink[i] = token;
                            break;
                        case StorageAttribute.NUMERIC:
                        case StorageAttribute.DATE:
                        case StorageAttribute.TIME:
                            let picture = PIC.buildPicture(dataType, token, task.getCompIdx(), false);
                            optionsValid = this.optionIsValid(token);
                            choiceLink[i] = DisplayConvertor.Instance.disp2mg(token.trim(), picture, task.getCompIdx(), BlobType.CONTENT_TYPE_UNKNOWN);
                            ((this._choiceNums.get_Item(line)))[i] = new NUM_TYPE(choiceLink[i]);
                            break;
                        case StorageAttribute.BOOLEAN:
                            choiceLink[i] = (1 - i).toString();
                            break;
                        default:
                            break;
                    }
                }
                if (!optionsValid)
                    this.emptyChoice(line);
            }
        }
        catch (ex) {
            if (ex instanceof Exception) {
                optionsValid = false;
                this.emptyChoice(line);
                Events.WriteExceptionToLog(NString.Format("{0} : {1}", ex.GetType(), ex.Message));
            }
            else
                throw ex;
        }
        this._hasValidItmAndDispVal = optionsValid;
    }
    getTopMostForm() {
        return this.getForm().getTopMostForm();
    }
    setUrl() {
        Commands.addValueWithLine(CommandType.SET_VALUE, this, 0, this.Value);
    }
    async getMgValue(dispVal) {
        let mgVal = null;
        if (super.isCheckBox()) {
            mgVal = dispVal ? "1" : "0";
        }
        else {
            if (super.isSelectionCtrl() || super.isTabControl() || super.isRadio()) {
                let line = this.getDisplayLine(true);
                if (line < 0)
                    line = 0;
                if (typeof dispVal === "number")
                    dispVal = dispVal.toString();
                if (Array.isArray(dispVal))
                    dispVal = dispVal.join(',').toString();
                if (dispVal === "") {
                    mgVal = dispVal;
                }
                else {
                    mgVal = await this.getLinkValue(dispVal, line);
                }
                if (mgVal === null) {
                    let refMgVal = new RefParam(mgVal);
                    if (this._field !== null) {
                        mgVal = refMgVal.value;
                    }
                }
            }
            else {
                let blobContentType = (this._field !== null) ? this._field.getContentType() : BlobType.CONTENT_TYPE_UNKNOWN;
                mgVal = DisplayConvertor.Instance.disp2mg(dispVal, this._pic, this.getForm().getTask().getCompIdx(), blobContentType);
            }
        }
        return mgVal;
    }
    async getLinkValue(selectedIndice, line) {
        let size = 0;
        let result = NString.Empty;
        let temp = new List();
        await this.computeChoice(line);
        let choiceLink = this._choiceLinks.get_Item(line);
        if (choiceLink !== null) {
            size = choiceLink.length;
        }
        let linkIndice = this.getLinkIdxFromLayer(Misc.GetIntArray(selectedIndice));
        let array2 = linkIndice;
        for (let i = 0; i < array2.length; i = i + 1) {
            let idx = array2[i];
            if (idx >= size) {
                let dcVals = this.getDcVals();
                temp.push(dcVals.getLinkValue(idx - size));
            }
            else {
                if (idx >= 0 && idx < choiceLink.length) {
                    temp.push(choiceLink[idx]);
                }
                else {
                    temp.push(null);
                }
            }
        }
        if (this.DataType === StorageAttribute.BLOB_VECTOR) {
            let vectorType = new VectorType(this.getField());
            for (let indx = 0; indx < temp.length; indx = indx + 1) {
                vectorType.setVecCell(indx + 1, temp.get_Item(indx), temp.get_Item(indx) === null);
            }
            result = vectorType.toString();
        }
        else {
            if (temp.length > 1) {
                result = temp.join(",");
            }
            else {
                result = temp.get_Item(0);
            }
        }
        return result;
    }
    setText() {
        let displayLine = this.getDisplayLine(true);
        let mlsTranslatedValue = this.Value;
        if (super.isButton()) {
            mlsTranslatedValue = Events.Translate(this.Value);
        }
        if (this.isTextControl() || this.isButton())
            Commands.addValueWithLine(CommandType.SET_VALUE, this, displayLine, mlsTranslatedValue);
        else
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, displayLine, HtmlProperties.Text, mlsTranslatedValue);
    }
    setRadioChecked(index) {
        Commands.addValueWithLine(CommandType.SET_VALUE, this, this.getDisplayLine(false), index);
        Commands.beginInvoke();
        if (index !== GuiConstants.DEFAULT_VALUE_INT) {
            this.setControlToFocus();
        }
    }
    setControlToFocus() {
        if (this.getField() !== null) {
            this.getField().ControlToFocus = this;
        }
    }
    setCheckBoxValue(line, mgVal) {
        let checkState = DisplayConvertor.toBoolean(mgVal);
        Commands.addValueWithLine(CommandType.SET_VALUE, this, line, checkState);
    }
    async refreshAndSetItemListByDataSource(line, valueChanged) {
        if (this.SupportsDataSource()) {
            let currDcId = this.getDcRef();
            if (this._rangeChanged) {
                valueChanged = true;
            }
            this._rangeChanged = false;
            if (this.isDataCtrl() && currDcId !== this._dcValId) {
                valueChanged = true;
                await this.refreshAndSetItemsList(line, true);
                this.setDcRef(this._dcValId);
            }
        }
        return valueChanged;
    }
    setDcRef(dcId) {
        this._dcTableRefs.set_Item(this.getDcLineNum(), dcId);
    }
    setImageList(url) {
    }
    async updatePropertyLogicNesting(propId, commandType, val, updateThis) {
        if (updateThis) {
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, this.getDisplayLine(false), commandType === CommandType.PROP_SET_VISIBLE ? HtmlProperties.Visible : HtmlProperties.Enabled, val);
        }
        await this.updateChildrenPropValue(propId, commandType, val);
    }
    SetEnabled(val) {
        Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, this.getDisplayLine(false), HtmlProperties.Enabled, val);
    }
    async updateChildrenPropValue(propId, commandType, val) {
        if (!super.isTableControl()) {
            for (let i = 0; i < this._linkedControls.length; i = i + 1) {
                let child = this._linkedControls.get_Item(i);
                if (child.IsFirstRefreshOfProps())
                    continue;
                let childValue = (child.GetComputedBooleanProperty(propId, true));
                childValue = childValue && val;
                let childOnCurrentLayer = this.isChildOnCurrentLayer(child);
                if (commandType === CommandType.PROP_SET_VISIBLE) {
                    if (childValue) {
                        childValue = childOnCurrentLayer;
                    }
                    await child.updateChildrenPropValue(propId, commandType, childValue);
                }
            }
            if (super.isSubform()) {
                await this.updateSubformChildrenPropValue(propId, commandType, val);
            }
        }
    }
    isDescendentOfControl(control) {
        let isContained = false;
        if (control !== null) {
            let parent = this.getParent();
            if (parent instanceof MgControlBase) {
                if (parent === control) {
                    isContained = true;
                }
                else {
                    let parentControl = ((parent instanceof MgControlBase) ? parent : null);
                    if (control.Type === MgControlType.CTRL_TYPE_COLUMN && parentControl !== null && parentControl.Type === MgControlType.CTRL_TYPE_TABLE && control.Layer === this.Layer)
                        isContained = true;
                    else
                        isContained = (parent.isDescendentOfControl(control));
                }
            }
        }
        return isContained;
    }
    updateSubformChildrenPropValue(propId, commandType, val) {
    }
    isChildOnCurrentLayer(child) {
        let ret = true;
        if (super.isChoiceControl()) {
            let parentLayer = 0;
            if (this.Value !== null) {
                parentLayer = this.getCurrentLinkIdx() + 1;
            }
            let layer = child.getLayer();
            if (parentLayer !== layer && layer > 0) {
                ret = false;
            }
        }
        return ret;
    }
    getCurrentLinkIdx() {
        let currLinkIdx = 0;
        if (super.isChoiceControl() || this.HasAutocomplete()) {
            let currentLayers = this.getCurrentIndexOfChoice();
            let currLinkIndice = this.getLinkIdxFromLayer(currentLayers);
            currLinkIdx = currLinkIndice[0];
        }
        return currLinkIdx;
    }
    getLayerFromLinkIdx(indice) {
        let layers = new Array(indice.length);
        for (let iCtr = 0; iCtr < indice.length; iCtr = iCtr + 1) {
            let idx = indice[iCtr];
            layers[iCtr] = idx;
            if (super.isTabControl() && idx >= 0) {
                let line = this.getDisplayLine(false);
                if (line < 0) {
                    line = 0;
                }
                let layerList = this._choiceLayerList.get_Item(line);
                if (layerList !== null && layerList.length > 0) {
                    layers[iCtr] = layerList.indexOf((idx + 1).toString());
                }
            }
        }
        return layers;
    }
    getLinkIdxFromLayer(layers) {
        let linkIndice = new Array(layers.length);
        for (let iCtr = 0; iCtr < layers.length; iCtr = iCtr + 1) {
            let layer = layers[iCtr];
            linkIndice[iCtr] = layer;
            if (super.isTabControl()) {
                if (layer < 0) {
                    linkIndice[iCtr] = 0;
                }
                else {
                    let line = this.getDisplayLine(false);
                    if (line < 0) {
                        line = 0;
                    }
                    let layerList = this._choiceLayerList.get_Item(line);
                    if (layerList !== null && typeof layerList !== "undefined" && layerList.length !== 0 && layer < layerList.length) {
                        linkIndice[iCtr] = NNumber.Parse(layerList[layer]) - 1;
                    }
                }
            }
        }
        return linkIndice;
    }
    isParentPropValue(propId) {
        let column = this.Form.getControlColumn(this);
        let parent = this.getLinkedParent(true);
        let result;
        if (parent === null) {
            result = true;
        }
        else {
            if (!parent.GetComputedBooleanProperty(propId, true)) {
                result = false;
            }
            else {
                if (!parent.isChildOnCurrentLayer(this)) {
                    result = false;
                }
                else {
                    result = (!(column !== null && !column.GetComputedBooleanProperty(propId, true)) && parent.isParentPropValue(propId));
                }
            }
        }
        return result;
    }
    getLinkedParent(checkSubformFather) {
        if (this._linkedParentDitIdx !== -1) {
            return this.Form.getCtrl(this._linkedParentDitIdx);
        }
        else {
            if (checkSubformFather && this.Form.isSubForm()) {
                return this.Form.getSubFormCtrl();
            }
            else {
                return null;
            }
        }
    }
    SetCurrReadOnly(newVal) {
        this._currReadOnly.set_Item(this.getDisplayLine(true), newVal);
    }
    GetCurrReadOnly() {
        let line = super.isTableControl() ? 0 : this.getDisplayLine(true);
        let currObj = this._currReadOnly.get_Item(line);
        let curr;
        if (currObj === null) {
            curr = false;
            this._currReadOnly.set_Item(line, curr);
        }
        else {
            curr = currObj;
        }
        return curr;
    }
    isDataCtrl() {
        return this._dataCtrl;
    }
    getDcRef() {
        let line = this.getDcLineNum();
        let obj = this._dcTableRefs.get_Item(this.getDcLineNum());
        let dcId;
        if (obj === null) {
            dcId = -2;
            this._dcTableRefs.set_Item(line, dcId);
        }
        else {
            dcId = obj;
        }
        return dcId;
    }
    getDcLineNum() {
        return this.IsRepeatable ? this.Form.DisplayLine : 0;
    }
    optionIsValid(option) {
        let isValid = true;
        if (this.DataType === StorageAttribute.NUMERIC && option.length > 0 && option.indexOf('0') === -1) {
            let convertNum = new NUM_TYPE();
            convertNum.num_4_a_std(option);
            if (convertNum.num_is_zero()) {
                isValid = false;
            }
        }
        return isValid;
    }
    async getOrderedDispList(choiceDispList, line) {
        let choiceLayerStr = "";
        let dispArryList = new List();
        let layerArryList = new List();
        let layerProp = this.getProp(PropInterface.PROP_TYPE_VISIBLE_LAYERS_LIST);
        if (layerProp !== null) {
            choiceLayerStr = await layerProp.getValue();
        }
        if (choiceLayerStr === null || StrUtil.rtrim(choiceLayerStr).length === 0) {
            choiceLayerStr = "";
        }
        if (choiceLayerStr.length > 0 && choiceDispList.length > 0) {
            let layerList = choiceLayerStr.split(",");
            let posCopyIndex = -1;
            for (let index = 0; index < layerList.length; index = index + 1) {
                let currLayerListVal = layerList[index].trim();
                if (!(layerArryList.indexOf(currLayerListVal) !== -1)) {
                    let refPosCopyIndex = new RefParam(posCopyIndex);
                    let isNumber = NNumber.TryParse(currLayerListVal, refPosCopyIndex);
                    posCopyIndex = refPosCopyIndex.value;
                    if (isNumber && posCopyIndex > 0 && posCopyIndex <= choiceDispList.length) {
                        dispArryList.push((choiceDispList[posCopyIndex - 1]).trim());
                        layerArryList.push(currLayerListVal);
                    }
                }
            }
        }
        let result;
        if (dispArryList.length === 0) {
            result = choiceDispList;
            this._choiceLayerList.set_Item(line, new Array(0));
        }
        else {
            result = new Array(dispArryList.length);
            for (let _ai = 0; _ai < result.length; ++_ai)
                result[_ai] = null;
            result = dispArryList.ToArray();
            this._choiceLayerList.set_Item(line, layerArryList.ToArray());
        }
        return result;
    }
    resetPrevVal() {
        let line = this.getDisplayLine(true);
        if (line < 0) {
            line = 0;
        }
        this._prevValues.set_Item(line, null);
        this.setPrevIsNull_ToNull();
    }
    setPrevIsNull_ToNull() {
        this._prevIsNulls.set_Item(this.getDisplayLine(true), null);
    }
    expressionSetAsData() {
        return this._valExpId > 0;
    }
    clearRange(line) {
        this._orgChoiceDisps.set_Item(line, null);
        this._choiceDisps.set_Item(line, null);
        this._choiceLinks.set_Item(line, null);
        this._choiceLayerList.set_Item(line, null);
    }
    haveToCheckParentValue() {
        let ret = false;
        if (this._linkedParentDitIdx !== -1) {
            if (!this.isContainedInLinkedParent()) {
                ret = true;
            }
            else {
                if (this.Form.getCtrl(this._linkedParentDitIdx).isTabControl() || this.Form.getCtrl(this._linkedParentDitIdx).isGroup()) {
                    ret = true;
                }
            }
        }
        else {
            if (this.Form.isSubForm()) {
                ret = true;
            }
        }
        return ret;
    }
    isContainedInLinkedParent() {
        return this._containerDitIdx !== -1 && this._containerDitIdx === this._linkedParentDitIdx;
    }
    static combineStringArrays(firstStrings, lastStrings) {
        let result = new Array();
        if (firstStrings !== null)
            result = result.concat(firstStrings);
        if (lastStrings !== null)
            result = result.concat(lastStrings);
        return result;
    }
    GetComputedBooleanProperty(propId, defaultRetVal, line) {
        if (arguments.length === 2 && (propId === null || propId.constructor === Number) && (defaultRetVal === null || defaultRetVal.constructor === Boolean)) {
            return this.GetComputedBooleanProperty_0(propId, defaultRetVal);
        }
        return this.GetComputedBooleanProperty_1(propId, defaultRetVal, line);
    }
    GetComputedBooleanProperty_0(propId, defaultRetVal) {
        let result = defaultRetVal;
        let prop = this.GetComputedProperty(propId);
        if (prop !== null) {
            result = prop.GetComputedValueBoolean();
        }
        return result;
    }
    GetComputedBooleanProperty_1(propId, defaultRetVal, line) {
        let result = defaultRetVal;
        if (this.isPropertyRepeatable(propId) && this.Form.DisplayLine !== line) {
            let prop = this.GetComputedProperty(propId);
            if (prop !== null) {
                let val = prop.getPrevValue(line);
                if (val !== null) {
                    result = DisplayConvertor.toBoolean(val);
                }
            }
        }
        else {
            result = this.GetComputedBooleanProperty(propId, defaultRetVal);
        }
        return result;
    }
    async checkPropWithLine(propId, defaultRetVal, line) {
        let result = defaultRetVal;
        if (this.isPropertyRepeatable(propId) && this.Form.DisplayLine !== line) {
            let prop = this.getProp(propId);
            if (prop !== null) {
                let val = prop.getPrevValue(line);
                if (val !== null) {
                    result = DisplayConvertor.toBoolean(val);
                }
            }
        }
        else {
            result = await this.checkProp(propId, defaultRetVal);
        }
        return result;
    }
    async checkProp(propId, defaultRetVal) {
        let result = defaultRetVal;
        let prop = this.getProp(propId);
        if (prop !== null) {
            result = await prop.getValueBoolean();
        }
        return result;
    }
    isPropertyRepeatable(propId) {
        let isRepeatable = this.IsRepeatable;
        if (isRepeatable) {
            return true;
        }
        else {
            return super.isTableControl() && Property.isRepeatableInTable();
        }
    }
    async SetAndRefreshDisplayValue(mgVal, isNull) {
        let dcRangeIsEmpty = true;
        if (mgVal === null) {
            this.Value = "";
            if (!isNull)
                mgVal = FieldDef.getMagicDefaultValue(this.DataType);
        }
        else {
            if (super.isChoiceControl()) {
                let line = this.getDisplayLine(true);
                if (line < 0) {
                    line = 0;
                }
                let layers = this.getLayerFromLinkIdx(await this.getIndexOfChoice(mgVal, line, isNull));
                if (layers[0] < 0 && super.isTabControl()) {
                    layers[0] = 0;
                    mgVal = await this.getLinkValue(layers[0].toString(), line);
                    isNull = false;
                    if (this._field !== null && mgVal !== null) {
                        await this._field.getTask().UpdateFieldValueAndStartRecompute(this._field, mgVal, isNull);
                    }
                }
                this.Value = Misc.GetCommaSeperatedString(layers);
                dcRangeIsEmpty = false;
            }
        }
        if (dcRangeIsEmpty) {
            if (!super.isCheckBox() && (this._field === null || !isNull || !this._field.hasNullDisplayValue())) {
                try {
                    if ((super.isImageControl() && this.DataType === StorageAttribute.BLOB) || super.IsImageButton()) {
                        this.Value = mgVal;
                    }
                    else {
                        if ((this._field === null && isNull) && (this.DataType === StorageAttribute.NUMERIC || this.DataType === StorageAttribute.DATE || this.DataType === StorageAttribute.TIME || this.DataType === StorageAttribute.BOOLEAN)) {
                            this.Value = mgVal;
                        }
                        else {
                            let inControl = this.InControl;
                            this.Value = DisplayConvertor.Instance.mg2disp(mgVal, this._range, this._pic, true, super.isSelectionCtrl(), this.getForm().getTask().getCompIdx(), inControl);
                        }
                    }
                    if (typeof this.Value === 'string' && (!this._pic.isAttrNumeric() || this._pic.isLeft())) {
                        this.rtrimValue();
                    }
                }
                catch (innerException) {
                    if (innerException instanceof ApplicationException) {
                        Events.WriteExceptionToLog(new ApplicationException(NString.Format("Control: '{0}', mgval: {1}", this.Name, mgVal), innerException));
                        this.Value = "";
                        mgVal = FieldDef.getMagicDefaultValue(this.DataType);
                    }
                    else
                        throw innerException;
                }
            }
            else {
                if (this.isCheckBox())
                    this.Value = DisplayConvertor.toBoolean(mgVal);
                else
                    this.Value = mgVal;
            }
        }
        if ((super.isImageControl() && this.DataType !== StorageAttribute.BLOB) || super.IsImageButton()) {
            mgVal = Events.TranslateLogicalName(mgVal);
        }
        this.IsNull = isNull;
        await this.RefreshDisplayValue(mgVal);
    }
    UpdateModifiedByUser(newValue) {
        if (!(super.isButton() || super.isImageControl())) {
            let ctrlCurrIsNull = this.IsNull;
            let valChanged = (this.isDifferentValue(newValue, false, false));
            if (!valChanged) {
                if (this.CanGetNullFromControlValue()) {
                    valChanged = (ctrlCurrIsNull !== this.isNullValue(newValue));
                }
            }
            if (valChanged || this.KeyStrokeOn) {
                this.ModifiedByUser = true;
            }
        }
    }
    rtrimValue() {
        if ((super.isImageControl() && this.DataType === StorageAttribute.BLOB) || super.IsImageButton()) {
            this.Value = NString.TrimEnd(this.Value);
        }
        else {
            let minimumValueLength = this.getMinimumValueLength();
            if (this.Value.length > minimumValueLength) {
                let str = this.Value.substr(minimumValueLength);
                this.Value = this.Value.substr(0, minimumValueLength);
                this.Value = this.Value + StrUtil.rtrimWithNull(str, true);
            }
            if (super.isTextControl() && this.DataType === StorageAttribute.NUMERIC) {
                this.Value = NString.TrimEnd(this.Value);
            }
        }
    }
    getMinimumValueLength() {
        let minLength = this._pic.getMaskLength();
        while (minLength > 0 && !this._pic.picIsMask(minLength - 1)) {
            minLength = minLength - 1;
        }
        return minLength;
    }
    isNullValue(str) {
        let retIsNullControl = false;
        if (this.CanGetNullFromControlValue() && str === "") {
            retIsNullControl = true;
        }
        return retIsNullControl;
    }
    CanGetNullFromControlValue() {
        return false;
    }
    isChoiceNull(idx) {
        let result;
        if (idx >= 0) {
            let dcVals = this.getDcVals();
            return dcVals.isNull(idx);
        }
        else {
            return result;
        }
    }
    async ComputeAndRefreshDisplayValue(forceRefresh) {
        if (forceRefresh) {
            this.resetPrevVal();
        }
        if (this._valExpId > 0) {
            let wasEvaluated;
            let refWasEvaluated = new RefParam(wasEvaluated);
            let retExp = await this.EvaluateExpression(this._valExpId, this.DataType, this._pic.getSize(), true, StorageAttribute.SKIP, false, refWasEvaluated);
            wasEvaluated = refWasEvaluated.value;
            if (wasEvaluated) {
                await this.SetAndRefreshDisplayValue(retExp, retExp === null);
            }
        }
        else {
            if (this._field !== null) {
                let value = NString.Empty;
                let isNull = false;
                let refValue = new RefParam(value);
                let refIsNull = new RefParam(isNull);
                this._field.getTask().getFieldDisplayValue(this._field, refValue, refIsNull);
                value = refValue.value;
                isNull = refIsNull.value;
                await this.SetAndRefreshDisplayValue(value, isNull);
            }
            else {
                if (!super.isTableControl() && !super.isColumnControl()) {
                    await this.RefreshDisplayValue(this.Value);
                }
            }
        }
    }
    ShouldRefreshOnControlEnter() {
        return this.Type === MgControlType.CTRL_TYPE_TEXT && this.getField() !== null && (this.getField().getType() === StorageAttribute.DATE ||
            this.getField().getType() === StorageAttribute.TIME || this.getField().getType() === StorageAttribute.NUMERIC);
    }
    async RefreshDisplayValue(mgVal) {
        let line = this.getDisplayLine(true);
        let valueChanged = true;
        let saveValueChanged = valueChanged;
        if (line < 0) {
            line = 0;
        }
        try {
            let prevValue = this._prevValues.get_Item(line);
            let prevNull = this.getPrevIsNull();
            if (StorageAttributeCheck.IsTypeAlphaOrUnicode(this.DataType)) {
                if (StrUtil.rtrim(mgVal) === StrUtil.rtrim(prevValue) ||
                    (mgVal !== null && StrUtil.rtrim(mgVal) === StrUtil.rtrim(prevValue))) {
                    valueChanged = false;
                }
                if (prevNull !== this.IsNull) {
                    valueChanged = true;
                }
            }
            else {
                ;
                if (mgVal === prevValue || (mgVal !== null && mgVal === prevValue))
                    valueChanged = false;
                if (prevNull !== this.IsNull)
                    valueChanged = true;
            }
            this._prevValues.set_Item(line, mgVal);
            this.setPrevIsNull(this.IsNull);
            switch (this.Type) {
                case MgControlType.CTRL_TYPE_TABLE:
                case MgControlType.CTRL_TYPE_COLUMN:
                case MgControlType.CTRL_TYPE_LABEL:
                case MgControlType.CTRL_TYPE_SUBFORM:
                case MgControlType.CTRL_TYPE_GROUP:
                case MgControlType.CTRL_TYPE_STATUS_BAR:
                case MgControlType.CTRL_TYPE_FRAME_SET:
                case MgControlType.CTRL_TYPE_CONTAINER:
                case MgControlType.CTRL_TYPE_FRAME_FORM:
                case MgControlType.CTRL_TYPE_SB_LABEL:
                case MgControlType.CTRL_TYPE_LINE:
                    return;
                case MgControlType.CTRL_TYPE_BROWSER:
                    if (valueChanged && this.Value != null)
                        this.setUrl();
                    return;
                case MgControlType.CTRL_TYPE_IMAGE:
                case MgControlType.CTRL_TYPE_SB_IMAGE:
                    if (valueChanged && this.Value != null)
                        this.setImage();
                    return;
                case MgControlType.CTRL_TYPE_CHECKBOX:
                    if (valueChanged || this.forceRefresh)
                        this.setCheckBoxValue(line, mgVal);
                    return;
                case MgControlType.CTRL_TYPE_TAB:
                case MgControlType.CTRL_TYPE_COMBO:
                case MgControlType.CTRL_TYPE_LIST:
                    saveValueChanged = valueChanged;
                    valueChanged = await this.refreshAndSetItemListByDataSource(line, valueChanged);
                    if (valueChanged) {
                        let prevDisplayValue = null;
                        if (saveValueChanged === valueChanged) {
                            if (prevValue !== null) {
                                prevDisplayValue = this.getLayerFromLinkIdx(await this.getIndexOfChoice(prevValue, line, prevNull));
                                for (let i = 0; i < prevDisplayValue.length; i = i + 1) {
                                    if (prevDisplayValue[i] === GuiConstants.DEFAULT_VALUE_INT) {
                                        prevDisplayValue[i] = GuiConstants.DEFAULT_LIST_VALUE;
                                    }
                                }
                            }
                        }
                        let indice = Misc.GetIntArray(this.Value);
                        if (this.isTabControl()) {
                            let currentLayer = this.getCurrentLinkIdx();
                            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, line, HtmlProperties.SelectedValue, indice[0].toString());
                            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, line, HtmlProperties.SelectedLayer, currentLayer.toString());
                        }
                        if (this.IsMultipleSelectionListBox()) {
                            Commands.addValueWithLine(CommandType.SET_VALUE, this, line, indice);
                        }
                        else
                            Commands.addValueWithLine(CommandType.SET_VALUE, this, line, +this.Value);
                    }
                    break;
                case MgControlType.CTRL_TYPE_BUTTON:
                case MgControlType.CTRL_TYPE_TEXT:
                    if (this.HasAutocomplete())
                        await this.refreshAndSetItemListByDataSource(line, valueChanged);
                    if (valueChanged) {
                        if (this.IsImageButton()) {
                            this.setImageWithFileName(this.Value);
                        }
                        else
                            this.setText();
                    }
                    else
                        return;
                    break;
                case MgControlType.CTRL_TYPE_RADIO:
                    valueChanged = await this.refreshAndSetItemListByDataSource(line, valueChanged);
                    if (!valueChanged)
                        return;
                    this.setRadioChecked(+this.Value);
                    break;
                default:
                    Events.WriteExceptionToLog(NString.Format("in Control.RefreshDisplayValue() unknown type: {0}", this.Type));
                    return;
            }
            if (super.isChoiceControl() && valueChanged)
                await this.updatePropertyLogicNesting(PropInterface.PROP_TYPE_VISIBLE, CommandType.PROP_SET_VISIBLE, await this.checkProp(PropInterface.PROP_TYPE_VISIBLE, true), false);
        }
        catch (ex_360) {
            if (ex_360 instanceof Exception) {
                Events.WriteExceptionToLog(NString.Format("in Control.RefreshDisplayValue() for control: {0}", this.Name));
            }
            else
                throw ex_360;
        }
    }
    async RefreshDisplay(onlyRepeatableProps) {
        if (isNullOrUndefined(onlyRepeatableProps))
            onlyRepeatableProps = false;
        await this.RefreshDisplay_1(onlyRepeatableProps);
    }
    async RefreshDisplay_1(onlyRepeatableProps) {
        if (!(super.isSubform() && this.GetSubformMgForm() !== null && this.GetSubformMgForm().inRefreshDisplay())) {
            await this.refreshProperties(onlyRepeatableProps);
            if (this.ShouldComputeAndRefreshOnClosedForm()) {
                await this.ComputeAndRefreshDisplayValue(false);
            }
            let isParkableCtrl = !(await this.isParkable(false)) || !await this.isModifiable();
            if (this.GetCurrReadOnly() !== isParkableCtrl) {
                this.SetCurrReadOnly(isParkableCtrl);
                await Manager.SetReadOnlyControl(this, isParkableCtrl);
            }
            let mustInputProperty = this.GetComputedProperty(PropInterface.PROP_TYPE_MUST_INPUT);
            if (mustInputProperty != null && mustInputProperty.isExpression()) {
                let prevMustInput = this.GetComputedBooleanProperty(PropInterface.PROP_TYPE_MUST_INPUT, false);
                if (prevMustInput !== await this.checkProp(PropInterface.PROP_TYPE_MUST_INPUT, false))
                    Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, this.getDisplayLine(false), HtmlProperties.MustInput, !prevMustInput);
            }
            else if (mustInputProperty != null) {
                let mustInputVal = this.GetComputedBooleanProperty(PropInterface.PROP_TYPE_MUST_INPUT, false);
                if (mustInputVal)
                    Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, this.getDisplayLine(false), HtmlProperties.MustInput, mustInputVal);
            }
            if (!this.GetComputedBooleanProperty(PropInterface.PROP_TYPE_TAB_IN, true))
                Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, this.getDisplayLine(false), HtmlProperties.TabIndex, -1);
        }
    }
    ShouldComputeAndRefreshOnClosedForm() {
        return true;
    }
    async refreshProperties(onlyRepeatableProps) {
        if (this._field !== null && this.DataType !== StorageAttribute.NONE && this._firstRefreshProperties)
            Commands.addWithNumber(CommandType.SET_ATTRIBUTE, this, this.DataType.charCodeAt(0));
        if (this._propTab !== null) {
            try {
                if (this._firstRefreshProperties) {
                    this.createDefaultProps();
                    await this.ZoomButtonInitialization();
                }
                if (!(await this._propTab.RefreshDisplay(false, onlyRepeatableProps))) {
                    Events.WriteExceptionToLog(NString.Format("Control '{0}': Not all properties could be set", this.getName()));
                }
                if (this._firstRefreshProperties) {
                    if (!onlyRepeatableProps) {
                        this._firstRefreshProperties = false;
                    }
                }
            }
            catch (ex) {
                if (ex instanceof Exception) {
                    let msg = new StringBuilder(NString.Format("Control '{0}': {1}", this.getName(), ex.Message));
                    Events.WriteExceptionToLog(msg.ToString());
                }
                else
                    throw ex;
            }
        }
    }
    async refreshTabForLayerList(line) {
        let currentLinkValue = null;
        if (this.getForm().Opened) {
            let indice = this.getCurrentIndexOfChoice();
            let currentLayer = indice[0];
            currentLinkValue = await this.getLinkValue(currentLayer.toString(), line);
        }
        await this.refreshAndSetItemsList(line, false);
        if (this.getForm().Opened) {
            await this.SetAndRefreshDisplayValue(currentLinkValue, this.IsNull);
        }
    }
    async refreshAndSetItemsList(line, execComputeChoice) {
        if (execComputeChoice) {
            this.clearRange(line);
        }
        let optionsStrings = await this.refreshDispRange(execComputeChoice);
        if (super.isChoiceControl() || this.HasAutocomplete()) {
            let options = optionsStrings.map((displayValue, index) => {
                return { index, displayValue };
            });
            Commands.addOperationWithLine(CommandType.SET_PROPERTY, this, line, HtmlProperties.ItemsList, options);
        }
    }
    async refreshDispRange(execComputeChoice) {
        let selectCmd = new Array(0);
        let line = this.getDisplayLine(true);
        if (line < 0) {
            line = 0;
        }
        if (this.SupportsDataSource()) {
            let dataView = this.getForm().getTask().DataView;
            let dcv = dataView.getDcValues(this._dcValId);
            let dispVals = await this.getDispVals(line, execComputeChoice);
            if (this._hasValidItmAndDispVal) {
                selectCmd = MgControlBase.combineStringArrays(dispVals, dcv.getDispVals());
            }
        }
        else {
            selectCmd = await this.getDispVals(line, execComputeChoice);
        }
        this._rangeChanged = true;
        return await this.getOrderedDispList(selectCmd, line);
    }
    async refreshItmRange(execComputeChoice) {
        Debug.Assert(this.SupportsDataSource());
        let orderedItmList = new Array(0);
        let line = this.getDisplayLine(false);
        if (line < 0) {
            line = 0;
        }
        if (execComputeChoice) {
            await this.computeChoice(line);
        }
        let linkVals = this._choiceLinks.get_Item(line);
        let dataView = this.getForm().getTask().DataView;
        let dcv = dataView.getDcValues(this._dcValId);
        if (this._hasValidItmAndDispVal) {
            orderedItmList = MgControlBase.combineStringArrays(linkVals, dcv.GetLinkVals());
        }
        return await this.getOrderedDispList(orderedItmList, line);
    }
    async GetItemsRange() {
        return await this.refreshItmRange(false);
    }
    async GetDisplayRange() {
        return await this.refreshDispRange(false);
    }
    createDefaultProps() {
        this.getProp(PropInterface.PROP_TYPE_VISIBLE);
        this.getProp(PropInterface.PROP_TYPE_ENABLED);
        if (super.isTableControl()) {
            this.getProp(PropInterface.PROP_TYPE_SCROLL_BAR);
        }
    }
    setLinkedParentIdx(linkedParentDitIdx) {
        this._linkedParentDitIdx = linkedParentDitIdx;
    }
    buildPicture(oldVal, val) {
        if (super.isTableControl() || super.isColumnControl())
            return null;
        if (this._picExpExists) {
            this._vd = null;
        }
        if (this._vd === null) {
            this._vd = new ValidationDetails(oldVal, val, this._range, this._pic, this);
        }
        else {
            this._vd.setValue(val);
            this._vd.setOldValue(oldVal);
        }
        return this._vd;
    }
    isDifferentValue(newValue, isNull, checkNullValue) {
        let ctrlCurrValue = this.Value;
        let valChanged = false;
        if (newValue instanceof Date) {
            if (this.DataType === StorageAttribute.DATE)
                valChanged = !this.CompareDate(newValue, ctrlCurrValue);
            else
                valChanged = !this.CompareTime(newValue, ctrlCurrValue);
        }
        if (typeof newValue === 'boolean' || typeof newValue === 'number') {
            if (this.isSelectionCtrl() && typeof ctrlCurrValue === 'string') {
                let newValuestr = newValue.toString();
                valChanged = (newValuestr !== ctrlCurrValue);
            }
            else {
                valChanged = (newValue !== ctrlCurrValue);
            }
        }
        else {
            if (this.isSelectionCtrl() && typeof ctrlCurrValue === 'string' && Array.isArray(newValue)) {
                let newValueStr = newValue.join(',').toString();
                valChanged = !(StrUtil.rtrim(newValueStr) === StrUtil.rtrim(ctrlCurrValue));
            }
            else {
                let ctrlCurrIsNull = this.IsNull;
                valChanged = !(StrUtil.rtrim(newValue) === StrUtil.rtrim(ctrlCurrValue));
                if (!valChanged && checkNullValue) {
                    valChanged = (isNull !== ctrlCurrIsNull);
                }
            }
        }
        return valChanged;
    }
    CompareDate(d1, d2) {
        let retval;
        if (d1 === null && d2 === null)
            retval = true;
        else if ((d1 === null && d2 !== null) || (d1 !== null && d2 === null))
            retval = false;
        else if (d1.getFullYear() === d2.getFullYear()
            && d1.getDate() === d2.getDate()
            && d1.getMonth() === d2.getMonth())
            retval = true;
        return retval;
    }
    CompareTime(d1, d2) {
        let retval;
        if (d1 === null && d2 === null)
            retval = true;
        else if ((d1 === null && d2 !== null) || (d1 !== null && d2 === null))
            retval = false;
        else if (d1.getHours() === d2.getHours()
            && d1.getMinutes() === d2.getMinutes()
            && d1.getSeconds() === d2.getSeconds())
            retval = true;
        return retval;
    }
    isColumnSortable() {
        let isSortable = false;
        if (this.Type === MgControlType.CTRL_TYPE_COLUMN && this._propTab.propExists(PropInterface.PROP_TYPE_SORT_COLUMN)) {
            isSortable = this.GetComputedProperty(PropInterface.PROP_TYPE_SORT_COLUMN).GetComputedValueBoolean();
        }
        return isSortable;
    }
    getColumnChildControl() {
        if (this.Type !== MgControlType.CTRL_TYPE_COLUMN)
            return null;
        let linkedControls = this._parentTable.getLinkedControls();
        return linkedControls.find((control) => (control.getLayer() === this.getLayer() && control.Type !== MgControlType.CTRL_TYPE_COLUMN && !control.IsTableHeaderChild));
    }
    getControlNameForHandlerSearch() {
        let childControl = this.getColumnChildControl();
        if (childControl !== null) {
            return childControl.Name;
        }
        else
            return this.Name;
    }
    linkCtrl(ctrl) {
        this._linkedControls.push(ctrl);
    }
    removeRefFromField() {
        if (this._field !== null) {
            this._field.RemoveControl(this);
        }
    }
    getDitIdx() {
        return this._ditIdx;
    }
    setDcValId(dcValId) {
        this._dcValId = dcValId;
    }
    SetKeyboardLanguage() {
        Commands.beginInvoke();
    }
    Init() {
    }
    async IsParkable() {
        return await this.isParkable(true);
    }
    HasExpOrParentTaskField() {
        let task = this.getForm().getTask();
        return (this.getField() === null || this.getField().getTask() !== task);
    }
    async isParkable(checkEnabledAndVisible) {
        let result;
        result = !super.isTableControl() && !super.isColumnControl();
        let task = this.getForm().getTask();
        if (result) {
            result = task.IsInteractive;
        }
        if (result && task.DataView.isEmptyDataview() && this._field !== null && this._field.PartOfDataview) {
            result = false;
        }
        if (result) {
            if (!super.isSubform()) {
                result = ((this._field !== null && this._field.getTask() === task) || this.isButton());
            }
            if (result && checkEnabledAndVisible) {
                result = (this.isEnabled() && this.isVisible());
            }
            if ((result && this._parentTable !== null) && checkEnabledAndVisible) {
                result = (this._parentTable.GetComputedBooleanProperty(PropInterface.PROP_TYPE_ENABLED, true) && this._parentTable.GetComputedBooleanProperty(PropInterface.PROP_TYPE_VISIBLE, true));
            }
        }
        return result;
    }
    RaiseControlHitOnLeftClickOfMouseDown() {
        let raiseCtrlHit = false;
        if (!super.IsHyperTextButton() && !super.isRadio() && !super.isTabControl()) {
            raiseCtrlHit = true;
        }
        return raiseCtrlHit;
    }
    GetVarIndex() {
        return 0;
    }
    RaiseControlHitOnMouseDown(leftClickWasPressed) {
        let raiseCtrlHit = false;
        if (leftClickWasPressed) {
            if (this.RaiseControlHitOnLeftClickOfMouseDown()) {
                raiseCtrlHit = true;
            }
        }
        return raiseCtrlHit;
    }
    OnSubformClick() {
        Manager.EventsManager.addGuiTriggeredEventWithTaskAndCode(this.getForm().getTask(), InternalInterface.MG_ACT_HIT);
    }
    GetSubformMgForm() {
        return null;
    }
    PropertyExists(id) {
        return this._propTab.propExists(id);
    }
    toString() {
        return "{" + this.constructor.name + ": " + MgControlType[this.Type] + "}";
    }
    isDateZero(val) {
        let zeroDate = false;
        if (val instanceof Date) {
            if (val.getMonth() === 0 && val.getFullYear() === 0 && val.getDay() === 0)
                zeroDate = true;
        }
        return zeroDate;
    }
    IsDefaultRouterOutlet() {
        return (this.Type === MgControlType.CTRL_TYPE_SUBFORM && this.GetComputedBooleanProperty_0(PropInterface.PROP_TYPE_DEFAULT_OUTLET, false));
    }
    IsRouterOutlet() {
        return (this.Type === MgControlType.CTRL_TYPE_SUBFORM && this.GetComputedBooleanProperty_0(PropInterface.PROP_TYPE_IS_ROUTER_OUTLET, false));
    }
    async ZoomButtonInitialization() {
        if (this.isTextControl() && this.checkIfExistProp(PropInterface.PROP_TYPE_CONNECTED_ZOOM_CONTROL)) {
            let connectedButton = this.Form.CtrlTab.GetControlByIsn((await (await this.getProp(PropInterface.PROP_TYPE_CONNECTED_ZOOM_CONTROL)).getValueInt()));
            if (connectedButton) {
                let imageFileName = null;
                if (connectedButton.IsImageButton() && connectedButton.PropertyExists(PropInterface.PROP_TYPE_IMAGE_FILENAME)) {
                    imageFileName = await (await connectedButton.getProp(PropInterface.PROP_TYPE_IMAGE_FILENAME)).getValue();
                    if (!Misc.IsWebUrl(imageFileName))
                        imageFileName = "./assets/images/" + imageFileName;
                    Commands.addOperationWithLine(CommandType.SET_STYLE, this, 0, MagicProperties.ImageFile, imageFileName);
                }
                this.ConnectedControl = connectedButton;
                connectedButton.ConnectedControl = this;
            }
        }
    }
}

class ControlTable {
    constructor() {
        this._controls = null;
        this._mgForm = null;
        this._controls = new List();
    }
    fillData(mgForm, parser) {
        this._mgForm = mgForm;
        while (this.initInnerObjects(parser.getNextTag(), parser)) {
        }
    }
    initInnerObjects(foundTagName, parser) {
        if (foundTagName === null)
            return false;
        if (foundTagName === XMLConstants.MG_TAG_CONTROL) {
            let control = this._mgForm.ConstructMgControl();
            control.fillData(this._mgForm, this._controls.length, parser);
            this._controls.push(control);
        }
        else if (foundTagName === ("/" + XMLConstants.MG_TAG_CONTROL)) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else
            return false;
        return true;
    }
    getSize() {
        return this._controls.length;
    }
    getCtrl(idxOrCtrlName) {
        if (arguments.length === 1 && (idxOrCtrlName === null || typeof idxOrCtrlName === "undefined" || idxOrCtrlName.constructor === Number)) {
            return this.getCtrl_0(idxOrCtrlName);
        }
        return this.getCtrl_1(idxOrCtrlName);
    }
    getCtrl_0(idx) {
        if (idx < this.getSize())
            return this._controls.get_Item(idx);
        return null;
    }
    getCtrl_1(ctrlName) {
        if (!NString.IsNullOrEmpty(ctrlName)) {
            return this._controls.find(ctrl => {
                return (NString.Equals(ctrlName, ctrl.getName(), true) ||
                    NString.Equals(ctrlName, ctrl.Name, true));
            });
        }
        return null;
    }
    getCtrlByName(ctrlName, ctrlType) {
        if (!NString.IsNullOrEmpty(ctrlName)) {
            return this._controls.find(ctrl => {
                return ((ctrl.Type === ctrlType) && NString.Equals(ctrlName, ctrl.getName(), true) ||
                    NString.Equals(ctrlName, ctrl.Name, true));
            });
        }
        return null;
    }
    GetControlByIsn(isn) {
        let ctrlByIsn = null;
        ctrlByIsn = this._controls.find(ctrl => {
            return (ctrl.ControlIsn === isn);
        });
        return ctrlByIsn;
    }
    GetControl(predicate) {
        return this._controls.find(predicate);
    }
    filter(callackFuntion) {
        return this._controls.filter(callackFuntion);
    }
    contains(ctrl) {
        let contains = false;
        if (ctrl !== null)
            contains = this._controls.Contains(ctrl);
        return contains;
    }
    addControl(ctrl) {
        this._controls.push(ctrl);
    }
    setControlAt(ctrl, index) {
        if (this._controls.length <= index)
            this._controls.SetSize(index + 1);
        this._controls.set_Item(index, ctrl);
    }
    deleteControlAt(index) {
        this._controls.set_Item(index, null);
    }
    Remove(ctrlOrIdx) {
        if (arguments.length === 1 && (ctrlOrIdx === null || ctrlOrIdx instanceof MgControlBase)) {
            return this.Remove_0(ctrlOrIdx);
        }
        this.Remove_1(ctrlOrIdx);
    }
    Remove_0(ctrl) {
        this._controls.Remove(ctrl);
        return this._controls.Contains(ctrl);
    }
    Remove_1(idx) {
        this._controls.RemoveAt(idx);
    }
    getControlIdx(inCtrl, includeSubs) {
        let counter = 0;
        for (let i = 0; i < this._controls.length; i++) {
            let ctrl = this._controls.get_Item(i);
            if (inCtrl === ctrl)
                return counter;
            else if (includeSubs || !ctrl.isSubform())
                counter++;
        }
        return -1;
    }
}

const delimiter = ', ';
class MgFormBase extends GuiFormPropertyAdapter {
    constructor() {
        super();
        this.InInitForm = false;
        this.CtrlTab = null;
        this.FormRefreshed = false;
        this.RefreshRepeatableAllowed = false;
        this.Rows = null;
        this.ModalFormsCount = 0;
        this.ErrorOccured = false;
        this.FormIsn = 0;
        this.Name = null;
        this.Opened = false;
        this.isLegalForm = false;
        this.PBImagesNumber = 0;
        this.ignoreFirstRefreshTable = false;
        this.ParentForm = null;
        this._destTblRow = Int32.MinValue;
        this._firstTableTabOrder = 0;
        this._inRefreshDisp = false;
        this._inRestore = false;
        this._lastRowSent = -1;
        this._prevGuiTopIndex = -1;
        this._propTab = null;
        this._rowsInPage = 1;
        this._maxRowsInPaginatedTable = 0;
        this._subFormCtrl = null;
        this._tableMgControl = null;
        this._tableItemsCount = 0;
        this._tableRefreshed = false;
        this._task = null;
        this._topIndexUpdated = false;
        this._transferingData = false;
        this._allowedSubformRecompute = true;
        this._concreteWindowType = 0;
        this._containerCtrl = null;
        this._firstRefreshOfProps = true;
        this._prevSelIndex = -1;
        this._shouldCreateToolbar = false;
        this._tableChildren = null;
        this._tableColumns = null;
        this._userStateId = '';
        this.displayLine = 0;
        this.defaultRouterOutlet = null;
        this._propTab = new PropTable(this);
        this.CtrlTab = new ControlTable();
        this.Rows = new List();
        this._concreteWindowType = 0;
        this.ParentForm = null;
    }
    get DisplayLine() {
        return this.displayLine;
    }
    set DisplayLine(value) {
        this.displayLine = value;
    }
    get UniqueName() {
        if (this.GetComputedProperty(PropInterface.PROP_TYPE_FORM_NAME) != null)
            return this.GetComputedProperty(PropInterface.PROP_TYPE_FORM_NAME).GetComputedValue();
        else
            return null;
    }
    get TaskTag() {
        return this.getTask().getTaskTag();
    }
    get TableChildren() {
        if (this._tableChildren === null)
            this.buildTableChildren();
        return this._tableChildren;
    }
    set TableChildren(value) {
        this._tableChildren = value;
    }
    get ShouldCreateToolbar() {
        return this._shouldCreateToolbar;
    }
    get AllowedSubformRecompute() {
        return this._allowedSubformRecompute;
    }
    set AllowedSubformRecompute(value) {
        this._allowedSubformRecompute = value;
    }
    get ConcreteWindowType() {
        if (this._concreteWindowType === 0) {
            let windowType = this.GetComputedProperty(PropInterface.PROP_TYPE_WINDOW_TYPE).GetComputedValueInteger();
            if (this.ParentForm === null || windowType !== WindowType.Overlay)
                windowType = WindowType.Default;
            this._concreteWindowType = windowType;
        }
        return this._concreteWindowType;
    }
    set ConcreteWindowType(value) {
        this._concreteWindowType = value;
    }
    static ShouldPutActOnFormClose() {
        return false;
    }
    static ShouldBehaveAsModal() {
        return false;
    }
    static ConvertArrayListToString(items, isItemNumType) {
        let from = ['\\', '-', ','];
        let to = ['\\\\', '\\-', '\\,'];
        let stringBuilder = new StringBuilder();
        let nUM_TYPE;
        for (let index = 0; index < items.length; index = index + 1) {
            if (isItemNumType) {
                nUM_TYPE = new NUM_TYPE(items.get_Item(index));
                items.set_Item(index, nUM_TYPE.to_double().toString());
            }
            stringBuilder.Append(StrUtil.searchAndReplace(items.get_Item(index), from, to));
            if (index < items.length - 1)
                stringBuilder.Append(delimiter);
        }
        return stringBuilder.ToString();
    }
    UpdateModalFormsCount(mgFormBase, increase) {
        if (increase)
            this.ModalFormsCount += 1;
        else
            this.ModalFormsCount -= 1;
        Events.SetModal(mgFormBase, increase);
    }
    async EvaluateExpression(expId, resType, length, contentTypeUnicode, resCellType, alwaysEvaluate, wasEvaluated) {
        return await this._task.EvaluateExpression(expId, resType, length, contentTypeUnicode, resCellType, true, wasEvaluated);
    }
    GetExpressionStorage(expId) {
        return this._task.GetExpressionStorage(expId);
    }
    checkIfExistProp(propId) {
        let exist = false;
        if (this._propTab !== null) {
            let propById = this._propTab.getPropById(propId);
            exist = (propById !== null);
        }
        return exist;
    }
    getProp(propId) {
        let prop = null;
        if (this._propTab !== null) {
            prop = this._propTab.getPropById(propId);
            if (prop === null) {
                prop = Property.getDefaultProp(propId, GuiConstants.PARENT_TYPE_FORM, this);
                if (prop !== null)
                    this._propTab.addProp(prop);
            }
        }
        return prop;
    }
    GetComputedProperty(propId) {
        let prop = null;
        if (this._propTab !== null)
            prop = this._propTab.getPropById(propId);
        return prop;
    }
    PropertyHasExpression(propId) {
        let prop = this._propTab.getPropById(propId);
        return prop !== null && prop.isExpression();
    }
    getCompIdx() {
        return (this.getTask() === null) ? 0 : this.getTask().getCompIdx();
    }
    IsFirstRefreshOfProps() {
        return this._firstRefreshOfProps;
    }
    getForm() {
        return this;
    }
    fillData(taskRef) {
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (this._task === null && taskRef !== null)
            this._task = taskRef;
        while (this.initInnerObjects(parser.getNextTag())) {
        }
    }
    init() {
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            let ctrl = this.CtrlTab.getCtrl(i);
            ctrl.Init();
        }
        this.buildLinkedControlsLists();
        this.buildTableColumnsList();
        this.createForm();
        this._task.setKeyboardMappingState(Constants.ACT_STT_TBL_SCREEN_MODE, this.isScreenMode());
        this._task.setKeyboardMappingState(Constants.ACT_STT_TBL_LEFT_TO_RIGHT, !this.GetComputedProperty(PropInterface.PROP_TYPE_HEBREW).GetComputedValueBoolean());
    }
    fillName(formTag) {
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(formTag) + formTag.length);
            let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            let attribute;
            let valueStr;
            for (let i = 0; i < tokensVector.length; i = i + 2) {
                attribute = tokensVector.get_Item(i);
                valueStr = tokensVector.get_Item(i + 1);
                switch (attribute) {
                    case XMLConstants.MG_ATTR_NAME:
                        this.Name = XmlParser.unescape(valueStr).toString();
                        if (Events.ShouldLog(Logger_LogLevels.Gui))
                            Events.WriteGuiToLog(NString.Format('Parsing form "{0}"', this.Name));
                        break;
                    case XMLConstants.MG_ATTR_IS_FRAMESET:
                        break;
                    case XMLConstants.MG_ATTR_IS_LIGAL_RC_FORM:
                        this.isLegalForm = XmlParser.getBoolean(valueStr);
                        break;
                    case XMLConstants.MG_ATTR_PB_IMAGES_NUMBER:
                        this.PBImagesNumber = XmlParser.getInt(valueStr);
                        break;
                    case XMLConstants.MG_ATTR_FORM_ISN:
                        this.FormIsn = XmlParser.getInt(valueStr);
                        break;
                    case XMLConstants.MG_ATTR_USERSTATE_ID:
                        this._userStateId = XmlParser.unescape(valueStr).toString();
                        break;
                    default:
                        Events.WriteExceptionToLog(NString.Format('Unhandled attribute \'{0}\'.', attribute));
                        break;
                }
            }
            parser.setCurrIndex(endContext + 1);
            return;
        }
        Events.WriteExceptionToLog('in Form.FillName() out of bounds');
    }
    createForm() {
        let inputControls = this.GetListOfInputControls();
        let formName = this.buildFormName();
        if (!this.isSubForm()) {
            Commands.addOpenForm(this, formName, '0', this.getTask().getTaskTag(), inputControls, this.isDialog());
        }
        else {
            Commands.addOpensubform(CommandType.CREATE_SUB_FORM, this.getSubFormCtrl(), this.getTask().getTaskTag(), this.getSubFormCtrl().getName(), formName, inputControls, this.getTask().RouterPath, this.getTask().GetRouterParams(), this.getTask().InDefaultRouterOutlet);
        }
        if (this.HasTable())
            this.InitTableControl();
        Commands.beginInvoke();
    }
    async CallJS(methodName, args) {
        return Commands.addCallJS(this, this.UniqueName, methodName, args);
    }
    isAutomaticTabbingOrder() {
        return this.GetComputedProperty(PropInterface.PROP_TYPE_TABBING_ORDER).GetComputedValueInteger() === TabbingOrderType.Automatically;
    }
    isRefreshRepeatableAllowed() {
        return this.RefreshRepeatableAllowed;
    }
    isScreenMode() {
        return !this.isLineMode();
    }
    isLineMode() {
        return this.getMainControl() !== null;
    }
    hasTable() {
        return this._tableMgControl !== null;
    }
    isDialog() {
        let isDialog = false;
        let windowType = this.ConcreteWindowType;
        if (windowType === WindowType.Overlay)
            isDialog = true;
        else if (MgFormBase.ShouldBehaveAsModal())
            isDialog = true;
        return isDialog;
    }
    isSubForm() {
        return this._subFormCtrl !== null;
    }
    HasTable() {
        return this._tableMgControl !== null;
    }
    getTopMostForm() {
        let topMostForm = this;
        while (topMostForm.isSubForm() && topMostForm.ParentForm !== null)
            topMostForm = topMostForm.ParentForm;
        return topMostForm;
    }
    getTopMostFrameForm() {
        let topMostForm = this;
        while (topMostForm !== null)
            topMostForm = ((topMostForm.ParentForm !== null) ? topMostForm.ParentForm : null);
        return topMostForm;
    }
    getSubFormCtrl() {
        return this._subFormCtrl;
    }
    getCtrl(ctrlIdx) {
        return this.CtrlTab.getCtrl(ctrlIdx);
    }
    GetCtrl(ctrlName) {
        return this.CtrlTab.getCtrl(ctrlName);
    }
    get DefaultRouterOutlet() {
        if (this.defaultRouterOutlet == null) {
            this.defaultRouterOutlet = this.CtrlTab.GetControl((x) => {
                return x.IsDefaultRouterOutlet();
            });
        }
        return this.defaultRouterOutlet;
    }
    async GetChoiceControlItemList(mgControl) {
        Debug.Assert(mgControl.isChoiceControl());
        let items = new List();
        let fld = mgControl.getField();
        let storageAttribute = fld.getCellsType();
        if (storageAttribute !== StorageAttribute.DATE && storageAttribute !== StorageAttribute.TIME) {
            if (mgControl.isRadio()) {
                for (let i = 0; i < fld.GetRadioCtrls().length; i++) {
                    let radioControl = fld.GetRadioCtrls().get_Item(i);
                    items.AddRange(await radioControl.GetItemsRange());
                }
            }
            else {
                items.AddRange(await mgControl.GetItemsRange());
            }
            return MgFormBase.ConvertArrayListToString(items, storageAttribute === StorageAttribute.NUMERIC);
        }
        return NString.Empty;
    }
    async GetChoiceControlDisplayList(mgControl) {
        Debug.Assert(mgControl.isChoiceControl());
        let items = new List();
        let fld = mgControl.getField();
        let storageAttribute = fld.getCellsType();
        if (storageAttribute !== StorageAttribute.DATE && storageAttribute !== StorageAttribute.TIME) {
            if (mgControl.isRadio()) {
                for (let i = 0; i < fld.GetRadioCtrls().length; i++) {
                    let radioControl = fld.GetRadioCtrls().get_Item(i);
                    items.AddRange(await radioControl.GetDisplayRange());
                }
            }
            else {
                items.AddRange(await mgControl.GetDisplayRange());
            }
            return MgFormBase.ConvertArrayListToString(items, false);
        }
        return NString.Empty;
    }
    getControlColumn(ctrl) {
        let column = null;
        if ((ctrl.IsRepeatable || ctrl.IsTableHeaderChild) && this._tableColumns !== null)
            column = this._tableColumns.get_Item(ctrl.getLayer() - 1);
        return column;
    }
    getContainerCtrl() {
        return this._containerCtrl;
    }
    getColumnControls() {
        let columnControlsList = null;
        if (this.CtrlTab !== null) {
            for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
                let ctrl = this.CtrlTab.getCtrl(i);
                if (ctrl.Type === MgControlType.CTRL_TYPE_COLUMN) {
                    if (columnControlsList === null)
                        columnControlsList = new List();
                    columnControlsList.push(ctrl);
                }
            }
        }
        return columnControlsList;
    }
    getTask() {
        return this._task;
    }
    getTableCtrl() {
        return this._tableMgControl;
    }
    getMainControl() {
        return this._tableMgControl;
    }
    getCtrlByName(ctrlName, ctrlType) {
        return this.CtrlTab.getCtrlByName(ctrlName, ctrlType);
    }
    checkAndCreateRow(idx) {
        if (this._tableMgControl !== null && !this.isRowCreated(idx))
            this.createRow(idx);
    }
    IsValidRow(idx) {
        let validRow = false;
        if (this._tableMgControl !== null && idx >= 0 && idx < this.Rows.length) {
            let row = this.Rows.get_Item(idx);
            validRow = (row !== null && row.Validated);
        }
        return validRow;
    }
    async refreshProps() {
        if (this._firstRefreshOfProps) {
            this.getProp(PropInterface.PROP_TYPE_TITLE_BAR);
        }
        await this._propTab.RefreshDisplay(false, false);
        if (this._firstRefreshOfProps)
            this._firstRefreshOfProps = false;
    }
    async refreshControls(repeatableOnly) {
        let ctrl;
        if (this.DisplayLine === Int32.MinValue)
            return;
        if (this._tableMgControl !== null && !repeatableOnly)
            await this._tableMgControl.RefreshDisplay();
        if (this._tableColumns !== null && !repeatableOnly) {
            for (let i = 0; i < this._tableColumns.length; i = i + 1) {
                let mgControlBase = this._tableColumns.get_Item(i);
                await mgControlBase.RefreshDisplay();
            }
        }
        this.checkAndCreateRow(this.DisplayLine);
        let tabAndGroupControls = new Stack();
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            ctrl = this.CtrlTab.getCtrl(i);
            if ((ctrl.isTabControl() || ctrl.isGroup()) && !repeatableOnly) {
                tabAndGroupControls.push(ctrl);
            }
            if (ctrl.Type !== MgControlType.CTRL_TYPE_TABLE && ctrl.Type !== MgControlType.CTRL_TYPE_COLUMN) {
                if (ctrl.IsRepeatable || !repeatableOnly)
                    await ctrl.RefreshDisplay();
            }
            else if (ctrl.Type === MgControlType.CTRL_TYPE_TABLE && repeatableOnly)
                await ctrl.RefreshDisplay(repeatableOnly);
        }
    }
    markRowNOTCreated(idx) {
        Commands.addWithNumber(CommandType.UNDO_CREATE_TABLE_ROW, this._tableMgControl, idx);
        if (idx >= 0 && idx < this.Rows.length)
            this.Rows.set_Item(idx, new Row(false, false));
    }
    SelectRow() {
        this.SelectRowByIdx(this.DisplayLine);
    }
    getRowsInPage() {
        return this._rowsInPage;
    }
    getMaxRowsInPaginatedTable() {
        return this._maxRowsInPaginatedTable;
    }
    setRowsInPage(size) {
        this._rowsInPage = size;
    }
    getColumnsCount() {
        let columnsCount = 0;
        if (this.CtrlTab !== null) {
            for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
                let control = this.CtrlTab.getCtrl(i);
                if (control.Type === MgControlType.CTRL_TYPE_COLUMN)
                    columnsCount = columnsCount + 1;
            }
        }
        return columnsCount;
    }
    inRefreshDisplay() {
        return this._inRefreshDisp;
    }
    setTitle(newTitle) {
        Commands.setTitle(this, newTitle);
    }
    getControlIdx(ctrl) {
        return this.CtrlTab.getControlIdx(ctrl, true);
    }
    getTopIndexFromGUI() {
        let topDisplayLine = 0;
        if (this.hasTable())
            topDisplayLine = Commands.getTopIndex(this.getMainControl());
        return topDisplayLine;
    }
    getTableItemsCount() {
        return this._tableItemsCount;
    }
    removeRefsToCtrls() {
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            this.CtrlTab.getCtrl(i).removeRefFromField();
        }
    }
    buildTableChildren() {
        if (this._tableChildren === null) {
            this._tableChildren = new List();
            if (this.CtrlTab !== null) {
                let minTabOrder = 2147483647;
                let automaticTabbingOrder = this.isAutomaticTabbingOrder();
                for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
                    let ctrl = this.CtrlTab.getCtrl(i);
                    if (ctrl.IsRepeatable || ctrl.IsTableHeaderChild) {
                        this._tableChildren.push(ctrl);
                        if (automaticTabbingOrder) {
                            let prop = ctrl.GetComputedProperty(PropInterface.PROP_TYPE_TAB_ORDER);
                            if (prop !== null) {
                                let valueInt = prop.GetComputedValueInteger();
                                if (valueInt < minTabOrder)
                                    minTabOrder = valueInt;
                            }
                        }
                    }
                }
                if (minTabOrder !== Int32.MaxValue && automaticTabbingOrder) {
                    this._firstTableTabOrder = minTabOrder;
                }
            }
        }
    }
    setTableCtrl(tableCtrl) {
        this._tableMgControl = tableCtrl;
    }
    getCtrlCount() {
        return this.CtrlTab.getSize();
    }
    GetControlsCountExcludingStatusBar() {
        return this.CtrlTab.getSize();
    }
    async refreshPropsOnExpression() {
        let i;
        let size = (this._propTab == null ? 0 : this._propTab.getSize());
        let prop;
        let refresh = false;
        for (i = 0; i < size && !refresh; i++) {
            prop = this._propTab.getProp(i);
            if (prop.isExpression()) {
                refresh = true;
                await this.refreshProps();
            }
        }
    }
    getTabControl(ctrl) {
        let obj;
        let result = null;
        obj = ctrl;
        while (obj instanceof MgControlBase) {
            let currCtrl = obj;
            if (currCtrl.isTabControl()) {
                result = currCtrl;
                break;
            }
            obj = currCtrl.getParent();
        }
        if (result == null) {
            for (let i = 0; i < this.CtrlTab.getSize(); i++) {
                obj = this.CtrlTab.getCtrl(i);
                if (obj.isTabControl()) {
                    result = obj;
                    break;
                }
            }
        }
        return result;
    }
    IsInputType(ctrl) {
        switch (ctrl.Type) {
            case MgControlType.CTRL_TYPE_CHECKBOX:
            case MgControlType.CTRL_TYPE_TEXT:
            case MgControlType.CTRL_TYPE_COMBO:
            case MgControlType.CTRL_TYPE_LIST:
            case MgControlType.CTRL_TYPE_RADIO:
                return true;
            default:
                return false;
        }
    }
    GetListOfInputControls() {
        let filterterList = this.CtrlTab.filter(((c) => this.IsInputType(c)));
        let names = filterterList.reduce((pre, ctrl) => {
            pre[ctrl.UniqueName] = ctrl.IsRepeatable ? '1' : '0';
            return pre;
        }, {});
        return names;
    }
    firstTableRefresh() {
        if (this._tableMgControl !== null) {
            this._rowsInPage = Commands.getRowsInPage(this._tableMgControl);
            this.RefreshRepeatableAllowed = true;
        }
    }
    SetTableItemsCount(dvsize, tableItemsCountOrRemoveAll, removeAll) {
        if (typeof tableItemsCountOrRemoveAll == 'boolean') {
            this.SetTableItemsCount_0(dvsize, tableItemsCountOrRemoveAll);
        }
        else
            this.SetTableItemsCount_1(dvsize, tableItemsCountOrRemoveAll, removeAll);
    }
    SetTableItemsCount_0(dvsize, removeAll) {
        this.SetTableItemsCount_1(dvsize, dvsize, removeAll);
    }
    SetTableItemsCount_1(dvsize, tableItemsCount, removeAll) {
        this.InitTableControl(dvsize, tableItemsCount, removeAll);
    }
    InitTableControl(dvSize, tableItemsCount, removeAll) {
        if (arguments.length === 0) {
            this.InitTableControl_0();
            return;
        }
        this.InitTableControl_1(dvSize, tableItemsCount);
    }
    UpdateTableChildrenArraysSize(size) {
        let children = this.TableChildren;
        if (children != null) {
            for (let i = 0; i < children.length; i++) {
                let control = children.get_Item(i);
                control.updateArrays(size);
            }
        }
        if (this._tableMgControl != null)
            this._tableMgControl.updateArrays(size);
    }
    toString() {
        return '{GuiMgForm' + ': Id=' + this._userStateId + '}';
    }
    IncludeControlInTabbingOrder(control) {
        if (!control.PropertyExists(PropInterface.PROP_TYPE_TAB_ORDER))
            return false;
        return true;
    }
    GetHashCode() {
        return this.FormIsn;
    }
    initInnerObjects(foundTagName) {
        if (foundTagName === null)
            return false;
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (MgFormBase.IsFormTag(foundTagName))
            this.fillName(foundTagName);
        else if (foundTagName === XMLConstants.MG_TAG_PROP)
            this._propTab.fillData(this, 'F', parser);
        else if (foundTagName === XMLConstants.MG_TAG_CONTROL) {
            this.CtrlTab.fillData(this, parser);
            if (!this.HasTable())
                this.RefreshRepeatableAllowed = true;
        }
        else if (MgFormBase.IsEndFormTag(foundTagName)) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else
            return false;
        return true;
    }
    isRowCreated(idx) {
        if (this.Rows.length <= idx || idx < 0) {
            return false;
        }
        let row = this.Rows.get_Item(idx);
        if (row === null)
            return false;
        return row.Created;
    }
    buildLinkedControlsLists() {
        for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
            let ctrl = this.CtrlTab.getCtrl(i);
            let linkedParent = ctrl.getLinkedParent(false);
            if (linkedParent !== null)
                linkedParent.linkCtrl(ctrl);
        }
    }
    buildTableColumnsList() {
        if (this._tableMgControl !== null) {
            this._tableColumns = new List();
            for (let i = 0; i < this.CtrlTab.getSize(); i = i + 1) {
                let control = this.CtrlTab.getCtrl(i);
                if (control.Type === MgControlType.CTRL_TYPE_COLUMN)
                    this._tableColumns.push(control);
            }
        }
    }
    createRow(idx) {
        Commands.addWithNumber(CommandType.CREATE_TABLE_ROW, this._tableMgControl, idx);
        if (this.Rows.length <= idx)
            this.Rows.SetSize(idx + 1);
        this.Rows.set_Item(idx, new Row(true, true));
    }
    SelectRowByIdx(rowIdx) {
        let mainControl = this.getMainControl();
        if (mainControl !== null && this.RefreshRepeatableAllowed) {
            let index = rowIdx;
            if (this._task.DataView.isEmptyDataview())
                index = GuiConstants.NO_ROW_SELECTED;
            if (index !== this._prevSelIndex) {
                this._prevSelIndex = index;
                Commands.addOperationWithLine(CommandType.SET_PROPERTY, mainControl, 0, HtmlProperties.SelectedRow, index);
            }
        }
    }
    InitTableControl_0() {
        this.InitTableControl(1, 1, false);
    }
    InitTableControl_1(dvSize, tableItemsCount) {
        if (this._tableMgControl != null) {
            Commands.addWithNumber(CommandType.SET_TABLE_ITEMS_COUNT, this._tableMgControl, tableItemsCount);
            Commands.addWithNumber(CommandType.SET_CHUNK_SIZE, this._tableMgControl, (this._task.DataView).getChunkSize());
            this._tableItemsCount = tableItemsCount;
            this.Rows.SetSize(dvSize);
            this._prevGuiTopIndex = -2;
            this._prevSelIndex = -2;
            this.UpdateTableChildrenArraysSize(dvSize);
            this._maxRowsInPaginatedTable = Commands.getMaxRowsInPaginatedTable(this._tableMgControl);
        }
    }
    InsertTableChildrenArrays(idx, count) {
        let children = this.TableChildren;
        if (children != null) {
            for (let i = 0; i < children.length; i++) {
                let control = children[i];
                control.InsertArrays(idx, count);
            }
        }
    }
}
class Row {
    constructor(created, validated) {
        this.Created = false;
        this.Validated = false;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(created, validated);
    }
    constructor_0() {
        this.Validated = true;
    }
    constructor_1(created, validated) {
        this.Created = created;
        this.Validated = validated;
    }
}

class EventsProcessor {
    constructor() {
        this.RegisterHandlers();
        this.RegisterSubclassHandlers();
    }
    RegisterHandlers() {
        Events.KeyDownEvent = this.processKeyDown.bind(this);
        Events.MouseDownEvent = this.processMouseDown;
        Events.DblClickEvent = this.processDblClick;
        Events.CloseFormEvent = this.processFormClose;
        Events.ColumnClickEvent = this.ProcessColumnClick;
    }
    processKeyDown(guiMgForm, guiMgCtrl, modifier, keyCode, start, end, text, isActChar, suggestedValue, handled) {
        let eventHandled = handled;
        let mgControlBase = guiMgCtrl;
        let mgFormBase = guiMgForm;
        Manager.EventsManager.AddKeyboardEvent(mgFormBase, mgControlBase, modifier, keyCode, start, end, text, isActChar, suggestedValue, InternalInterface.MG_ACT_CTRL_KEYDOWN);
        return eventHandled;
    }
    processFormClose(guiMgForm) {
        let clrHandledEvent = false;
        let mgFormBase = guiMgForm;
        if (MgFormBase.ShouldPutActOnFormClose())
            Manager.EventsManager.addGuiTriggeredEventTaskAndCodeAndRaisedBy(mgFormBase.getTask(), InternalInterface.MG_ACT_HIT);
        Manager.EventsManager.addGuiTriggeredEventWithTaskAndCode(mgFormBase.getTask(), InternalInterface.MG_ACT_CLOSE);
        return clrHandledEvent;
    }
    processMouseDown(guiMgForm, guiMgCtrl, dotNetArgs, leftClickWasPressed, line, onMultiMark, canProduceClick) {
        let mgControl = guiMgCtrl;
        if (mgControl === null) {
            Debug.Assert(guiMgForm !== null);
            Manager.EventsManager.addGuiTriggeredEventWithTaskAndCodeAndOnMultiMark(guiMgForm.getTask(), InternalInterface.MG_ACT_HIT);
        }
        else {
            if (mgControl.isSubform()) {
                mgControl.OnSubformClick();
            }
            else {
                if (mgControl.RaiseControlHitOnMouseDown(leftClickWasPressed)) {
                    Manager.EventsManager.addGuiTriggeredEventWithCtrlAndCodeAndLine(mgControl, InternalInterface.MG_ACT_CTRL_HIT, line);
                }
                if (leftClickWasPressed && canProduceClick) {
                    if (mgControl.Type !== MgControlType.CTRL_TYPE_BUTTON && mgControl.Type !== MgControlType.CTRL_TYPE_CHECKBOX) {
                        Manager.EventsManager.addGuiTriggeredEventWithCtrlAndCodeAndLine(mgControl, InternalInterface.MG_ACT_WEB_CLICK, line);
                    }
                }
            }
        }
    }
    processDblClick(guiMgCtrl, line) {
        let mgControl = guiMgCtrl;
        if (!mgControl.GetComputedBooleanProperty(PropInterface.PROP_TYPE_ENABLED, true, line))
            return;
        Manager.EventsManager.addGuiTriggeredEventWithCtrlAndCodeAndLine(mgControl, InternalInterface.MG_ACT_WEB_ON_DBLICK, line);
    }
    ProcessColumnClick(guiColumnCtrl, direction, columnHeader) {
        let mgColumnControl = guiColumnCtrl;
        Manager.EventsManager.AddColumnClickEvent(mgColumnControl, direction, columnHeader);
    }
}

class KeyboardItem {
    constructor(cKeyCodeOrActionId_, cModifierOrKeyCode_, modifier_, states_) {
        this._keyCode = 0;
        this._modifier = Modifiers.MODIFIER_NONE;
        this._states = 0;
        this._actionId = 0;
        if (arguments.length === 2)
            this.constructor_1(cKeyCodeOrActionId_, cModifierOrKeyCode_);
        else
            this.constructor_2(cKeyCodeOrActionId_, cModifierOrKeyCode_, modifier_, states_);
    }
    constructor_1(cKeyCode, cModifier) {
        this._keyCode = cKeyCode;
        this._modifier = cModifier;
    }
    constructor_2(actionId_, keyCode_, modifier_, states_) {
        this._actionId = actionId_;
        this._keyCode = keyCode_;
        this._modifier = modifier_;
        this._states = states_;
    }
    getKeyCode() {
        return this._keyCode;
    }
    getModifier() {
        return this._modifier;
    }
    getStates() {
        return this._states;
    }
    equals(kbdItm) {
        return this === kbdItm || (kbdItm !== null && this._keyCode === kbdItm._keyCode && this._modifier === kbdItm._modifier);
    }
    getAction() {
        return this._actionId;
    }
    setAction(actionId) {
        this._actionId = actionId;
    }
    ToString() {
        let buffer = new StringBuilder();
        let counter = 0;
        switch (this._modifier) {
            case Modifiers.MODIFIER_ALT:
                buffer.Append("Alt+");
                break;
            case Modifiers.MODIFIER_CTRL:
                buffer.Append("Ctrl+");
                break;
            case Modifiers.MODIFIER_SHIFT:
                buffer.Append("Shift+");
                break;
            case Modifiers.MODIFIER_SHIFT_CTRL:
                buffer.Append("Shift+Ctrl+");
                break;
            case Modifiers.MODIFIER_ALT_CTRL:
                buffer.Append("Alt+Ctrl+");
                break;
            case Modifiers.MODIFIER_ALT_SHIFT:
                buffer.Append("Shift+Alt+");
                break;
            case Modifiers.MODIFIER_NONE:
            default:
                break;
        }
        switch (this._keyCode) {
            case GuiConstants.KEY_SPACE:
                buffer.Append("Space");
                break;
            case GuiConstants.KEY_PG_UP:
                buffer.Append("PgUp");
                break;
            case GuiConstants.KEY_PG_DOWN:
                buffer.Append("PgDn");
                break;
            case GuiConstants.KEY_END:
                buffer.Append("End");
                break;
            case GuiConstants.KEY_HOME:
                buffer.Append("Home");
                break;
            case GuiConstants.KEY_LEFT:
                buffer.Append("Left");
                break;
            case GuiConstants.KEY_UP:
                buffer.Append("Up");
                break;
            case GuiConstants.KEY_RIGHT:
                buffer.Append("Rght");
                break;
            case GuiConstants.KEY_DOWN:
                buffer.Append("Down");
                break;
            case GuiConstants.KEY_TAB:
                buffer.Append("Tab");
                break;
            case GuiConstants.KEY_INSERT:
                buffer.Append("Ins");
                break;
            case GuiConstants.KEY_DELETE:
                buffer.Append("Del");
                break;
            case GuiConstants.KEY_RETURN:
                buffer.Append("Ent");
                break;
            case GuiConstants.KEY_ESC:
                buffer.Append("Esc");
                break;
            case GuiConstants.KEY_BACKSPACE:
                buffer.Append("Back");
                break;
            default:
                if (this._keyCode >= GuiConstants.KEY_F1 && this._keyCode <= GuiConstants.KEY_F12) {
                    counter = this._keyCode - GuiConstants.KEY_F1 + 1;
                    buffer.Append("F" + counter);
                }
                else if (this._keyCode >= GuiConstants.KEY_0 && this._keyCode <= GuiConstants.KEY_9) {
                    counter = this._keyCode - GuiConstants.KEY_0;
                    buffer.Append(counter);
                }
                else if (this._keyCode >= GuiConstants.KEY_A && this._keyCode <= GuiConstants.KEY_Z) {
                    counter = this._keyCode - GuiConstants.KEY_A + ('A').charCodeAt(0);
                    buffer.Append(String.fromCharCode(counter));
                }
                else
                    buffer.Append("? (" + this._keyCode + ")");
                break;
        }
        return buffer.ToString();
    }
}

class LastFocusedVal {
    constructor(guiMgControl, line, val) {
        this.guiMgControl = null;
        this.Line = 0;
        this.Val = null;
        this.guiMgControl = guiMgControl;
        this.Line = line;
        this.Val = val;
    }
}

class DialogHandler {
    closeDialog() {
    }
    constructor() {
    }
}

class Styles {
}
Styles.MSGBOX_BUTTON_OK = 0x00000000;
Styles.MSGBOX_BUTTON_OK_CANCEL = 0x00000001;
Styles.MSGBOX_BUTTON_ABORT_RETRY_IGNORE = 0x00000002;
Styles.MSGBOX_BUTTON_YES_NO_CANCEL = 0x00000003;
Styles.MSGBOX_BUTTON_YES_NO = 0x00000004;
Styles.MSGBOX_BUTTON_RETRY_CANCEL = 0x00000005;
Styles.MSGBOX_ICON_ERROR = 0x00000010;
Styles.MSGBOX_ICON_QUESTION = 0x00000020;
Styles.MSGBOX_ICON_EXCLAMATION = 0x00000030;
Styles.MSGBOX_ICON_INFORMATION = 0x00000040;
Styles.MSGBOX_ICON_WARNING = Styles.MSGBOX_ICON_EXCLAMATION;
Styles.MSGBOX_RESULT_OK = 1;
Styles.MSGBOX_RESULT_CANCEL = 2;
Styles.MSGBOX_RESULT_ABORT = 3;
Styles.MSGBOX_RESULT_RETRY = 4;
Styles.MSGBOX_RESULT_YES = 6;
Styles.MSGBOX_RESULT_NO = 7;

class RuntimeContextBase {
    constructor() {
        this._insertMode = false;
        this._lastCoordinates = new Array(4);
        this.ContextID = '\0';
        this.Parser = null;
        this.FrameForm = null;
        this.LastClickedCtrlName = null;
        this.RemovedContextFromServer = false;
        this.RemovingContextFromServer = false;
        this.CurrentClickedCtrl = null;
        this.CurrentClickedRadio = null;
        this.DefaultStatusMsg = null;
        this.LastClickCoordinatesAreInPixels = false;
    }
    Init(contextID) {
        this.ContextID = contextID;
        this.LastClickedCtrlName = "";
        this._insertMode = true;
        Manager.SetCurrentContextID(contextID);
        this.Parser = new XmlParser();
    }
    SaveLastClickInfo(controlName, clientX, clientY, offsetX, offsetY, isInPixels) {
        this._lastCoordinates[0] = offsetX;
        this._lastCoordinates[1] = offsetY;
        this._lastCoordinates[2] = clientX;
        this._lastCoordinates[3] = clientY;
        this.LastClickCoordinatesAreInPixels = isInPixels;
        this.LastClickedCtrlName = "";
        if (!NString.IsNullOrEmpty(controlName)) {
            this.LastClickedCtrlName = controlName;
        }
    }
    ToggleInsertMode() {
        this._insertMode = !this._insertMode;
    }
}
RuntimeContextBase.noContextId = null;
RuntimeContextBase.Instance = new RuntimeContextBase();

class DcValuesBuilderBase {
    CreateDcValues() {
        return new DcValues(false);
    }
    SetId(dcValues, newId) {
        dcValues.SetID(newId);
    }
    SetType(dcValues, type) {
        dcValues.setType(type);
    }
    SetDisplayValues(dcValues, displayValues) {
        dcValues.SetDisplayValues(displayValues);
    }
    SetLinkValues(dcValues, linkValues) {
        dcValues.SetLinkValues(linkValues);
    }
    SetNullFlags(dcValues, nullFlagsStringOrNullFlags) {
        if (arguments.length === 2 && (dcValues === null || dcValues instanceof DcValues) && (nullFlagsStringOrNullFlags === null || nullFlagsStringOrNullFlags.constructor === String)) {
            this.SetNullFlags_0(dcValues, nullFlagsStringOrNullFlags);
            return;
        }
        this.SetNullFlags_1(dcValues, nullFlagsStringOrNullFlags);
    }
    SetNullFlags_0(dcValues, nullFlagsString) {
        let nullFlags = this.ParseNullFlags(nullFlagsString);
        dcValues.setNullFlags(nullFlags);
    }
    SetNullFlags_1(dcValues, nullFlags) {
        dcValues.setNullFlags(nullFlags);
    }
    ParseValues(valueStr, dataType, useHex) {
        let snumber;
        let tmpValue = null;
        let buffer = new List();
        let len;
        let nextIdx;
        let endIdx;
        let suffixBuf = null;
        switch (dataType) {
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                if (useHex)
                    len = GuiEnvironment.Environment.GetSignificantNumSize() * 2;
                else
                    len = Math.floor((GuiEnvironment.Environment.GetSignificantNumSize() + 2) / 3) * 4;
                break;
            case StorageAttribute.BOOLEAN:
                len = 1;
                break;
            default:
                len = 0;
                break;
        }
        nextIdx = 0;
        while (nextIdx < valueStr.length) {
            if (dataType === StorageAttribute.ALPHA || dataType === StorageAttribute.UNICODE ||
                dataType === StorageAttribute.BLOB || dataType === StorageAttribute.BLOB_VECTOR) {
                snumber = valueStr.substr(nextIdx, 4);
                len = NNumber.Parse(snumber, NumberStyles.HexNumber);
                nextIdx += 4;
            }
            if (len >= 0x8000) {
                suffixBuf = new StringBuilder();
                len -= 0x8000;
                nextIdx += RecordUtils.getSpannedField(valueStr, len, nextIdx, dataType, suffixBuf, useHex);
                buffer.push(suffixBuf.ToString());
            }
            else {
                endIdx = nextIdx + len;
                if (useHex)
                    tmpValue = valueStr.substr(nextIdx, (endIdx) - (nextIdx));
                else
                    tmpValue = Base64.decodeToHex(valueStr.substr(nextIdx, (endIdx) - (nextIdx)));
                buffer.push(tmpValue);
                nextIdx = endIdx;
            }
        }
        return buffer.ToArray();
    }
    ParseNullFlags(nullFlagsString) {
        let array = new Array(nullFlagsString.length);
        for (let i = 0; i < nullFlagsString.length; i = i + 1) {
            array[i] = (nullFlagsString.charAt(i) !== '0');
        }
        return array;
    }
    constructor() {
    }
}

class FieldsTable {
    constructor() {
        this._fields = null;
        this._fields = new List();
    }
    getField(idxOrFldName) {
        if ((idxOrFldName === null || idxOrFldName.constructor === Number)) {
            return this.getField_0(idxOrFldName);
        }
        return this.getField_1(idxOrFldName);
    }
    getField_0(idx) {
        let fld = null;
        if (idx >= 0 && idx < this._fields.length)
            fld = this._fields.get_Item(idx);
        return fld;
    }
    getSize() {
        return this._fields.length;
    }
    fillData(parser, dataview) {
        while (this.initInnerObjects(parser.getNextTag(), dataview)) {
        }
    }
    initInnerObjects(foundTagName, dataview) {
        if (foundTagName === null)
            return false;
        let parser = Manager.GetCurrentRuntimeContext().Parser;
        if (foundTagName === XMLConstants.MG_TAG_FLDH) {
            let field = this.initField(parser, dataview);
            this._fields.push(field);
        }
        else if (foundTagName === XMLConstants.MG_TAG_DVHEADER)
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) +
                1);
        else if (foundTagName === "/" + XMLConstants.MG_TAG_DVHEADER) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Events.WriteExceptionToLog("There is no such tag in FieldsTable. Insert else if to FieldsTable.initInnerObjects for " + foundTagName);
            return false;
        }
        return true;
    }
    getField_1(fldName) {
        return this._fields.find((field) => (field.getVarName() === fldName));
    }
}

class GuiDataViewBase {
    constructor() {
        this._dcValsCollection = new Dictionary();
        this._emptyDataview = false;
        this._fieldsTab = null;
        this._task = null;
        this._emptyChoice = new DcValues(true);
        this._emptyChoiceForVectors = new DcValues(true);
    }
    getField(id) {
        if (this._fieldsTab != null)
            return this._fieldsTab.getField(id);
        Events.WriteExceptionToLog("in DataView.getFieldDef(int): There is no fieldsTab object");
        return null;
    }
    isEmptyDataview() {
        return this._emptyDataview;
    }
    setEmptyDataview(emptyDataview) {
        this._emptyDataview = emptyDataview;
        Commands.addBoolWithLine(CommandType.SET_EMPTY_DATAVIEW, this._task.getForm(), 0, emptyDataview);
    }
    getTask() {
        return this._task;
    }
    getDcValues(dcId) {
        if (dcId === EMPTY_DCREF)
            return this.getEmptyChoice();
        let dcValues;
        let dcv = new RefParam(dcValues);
        this._dcValsCollection.TryGetValue(dcId.toString(), dcv);
        return dcv.value;
    }
    getEmptyChoice() {
        return this._emptyChoice;
    }
    getEmptyChoiceForVectors() {
        return this._emptyChoiceForVectors;
    }
    GetFieldsTab() {
        return this._fieldsTab;
    }
    GetRouteParams() {
        let params = new List();
        for (let i = 0; i < this._fieldsTab.getSize(); i++) {
            let field = this._fieldsTab.getField(i);
            let val;
            if (field.IsExposedRouteParam && !field.isNull()) {
                switch (field.getType()) {
                    case StorageAttribute.ALPHA:
                    case StorageAttribute.UNICODE:
                        {
                            val = field.getDispValue();
                            if (field.isNull())
                                val = field.getNullDisplay();
                            params.push(val.trim());
                        }
                        break;
                    case StorageAttribute.BOOLEAN:
                        {
                            if (field.isNull())
                                params.push(false);
                            else
                                params.push(field.getDispValue().charAt(0) === '1' ? true : false);
                        }
                        break;
                    case StorageAttribute.NUMERIC: {
                        val = field.getDispValue();
                        if (field.isNull())
                            val = field.getNullDisplay();
                        let pic = new PIC(field.getPicture(), field.getType(), this.getTask().getCompIdx());
                        val = DisplayConvertor.Instance.mg2disp(val, "", pic, true, 0, false);
                        params.push(val);
                        break;
                    }
                }
            }
        }
        return (params.length > 0) ? params : null;
    }
}

class ObjectReferenceBase {
    constructor(referent) {
        this.Referent = null;
        this.isDisposed = false;
        this.id = 0;
        this._instantiationTrace = null;
        this.id = (ObjectReferenceBase.LastId = ObjectReferenceBase.LastId + 1);
        this.isDisposed = false;
        this.Referent = referent;
        if (Logger.Instance.LogLevel >= Logger_LogLevels.Development) {
            Logger.Instance.WriteDevToLog("Creating " + this.toString());
            this._instantiationTrace = new StackTrace();
        }
        referent.AddReference();
    }
    Dispose(isDisposing) {
        if (arguments.length === 0) {
            this.Dispose_0();
            return;
        }
        this.Dispose_1();
    }
    Dispose_0() {
        Logger.Instance.WriteDevToLog("Disposing " + this);
        this.Dispose(true);
    }
    Dispose_1() {
        if (!this.isDisposed) {
            if (!this.Referent.HasReferences) {
                if (Logger.Instance.LogLevel >= Logger_LogLevels.Development) {
                    Logger.Instance.WriteSupportToLog("Referent does not have any more references: " + this.Referent, false);
                    Logger.Instance.WriteStackTrace(this._instantiationTrace, 15, "Instantiation trace:");
                }
                Debug.Assert(false, "Referent does not have any more references. See DEV level log.");
            }
            else
                this.Referent.RemoveReference();
        }
        this.isDisposed = true;
    }
    toString() {
        return "{Reference " + this.id + " to: " + this.Referent + "}";
    }
}
ObjectReferenceBase.LastId = 0;

class ObjectReferencesCollection {
    constructor() {
        this._refs = new List();
    }
    get_Item(i) {
        return this._refs.get_Item(i);
    }
    Add(objRef) {
        this._refs.push(objRef);
    }
    Dispose() {
        for (let i = 0; i < this._refs.length; i = i + 1) {
            (this._refs.get_Item(i)).Dispose();
        }
    }
    Clone() {
        let objectReferencesCollection = new ObjectReferencesCollection();
        for (let i = 0; i < this._refs.length; i = i + 1) {
            let objRef = this.get_Item(i).Clone();
            objectReferencesCollection.Add(objRef);
        }
        return objectReferencesCollection;
    }
    get Refs() {
        return this._refs;
    }
}

class ExpressionInterface {
    constructor() {
    }
}
ExpressionInterface.EXP_OPER_LEN = 2;
ExpressionInterface.EXP_OPER_FUNC_PTR_LEN = 4;
ExpressionInterface.EXP_OP_NONE = 0;
ExpressionInterface.EXP_OP_V = 1;
ExpressionInterface.EXP_OP_VAR = 2;
ExpressionInterface.EXP_OP_A = 3;
ExpressionInterface.EXP_OP_H = 4;
ExpressionInterface.EXP_OP_N = 5;
ExpressionInterface.EXP_OP_D = 6;
ExpressionInterface.EXP_OP_T = 7;
ExpressionInterface.EXP_OP_L = 8;
ExpressionInterface.EXP_OP_F = 9;
ExpressionInterface.EXP_OP_K = 10;
ExpressionInterface.EXP_OP_P = 11;
ExpressionInterface.EXP_OP_M = 12;
ExpressionInterface.EXP_OP_ACT = 13;
ExpressionInterface.EXP_OP_KBD = 14;
ExpressionInterface.EXP_OP_ADD = 15;
ExpressionInterface.EXP_OP_SUB = 16;
ExpressionInterface.EXP_OP_MUL = 17;
ExpressionInterface.EXP_OP_DIV = 18;
ExpressionInterface.EXP_OP_MOD = 19;
ExpressionInterface.EXP_OP_NEG = 20;
ExpressionInterface.EXP_OP_FIX = 21;
ExpressionInterface.EXP_OP_ROUND = 22;
ExpressionInterface.EXP_OP_EQ = 23;
ExpressionInterface.EXP_OP_NE = 24;
ExpressionInterface.EXP_OP_LE = 25;
ExpressionInterface.EXP_OP_LT = 26;
ExpressionInterface.EXP_OP_GE = 27;
ExpressionInterface.EXP_OP_GT = 28;
ExpressionInterface.EXP_OP_NOT = 29;
ExpressionInterface.EXP_OP_OR = 30;
ExpressionInterface.EXP_OP_AND = 31;
ExpressionInterface.EXP_OP_IF = 32;
ExpressionInterface.EXP_OP_LEN = 33;
ExpressionInterface.EXP_OP_CON = 34;
ExpressionInterface.EXP_OP_MID = 35;
ExpressionInterface.EXP_OP_LEFT = 36;
ExpressionInterface.EXP_OP_RIGHT = 37;
ExpressionInterface.EXP_OP_FILL = 38;
ExpressionInterface.EXP_OP_INSTR = 39;
ExpressionInterface.EXP_OP_TRIM = 40;
ExpressionInterface.EXP_OP_LTRIM = 41;
ExpressionInterface.EXP_OP_RTRIM = 42;
ExpressionInterface.EXP_OP_STR = 43;
ExpressionInterface.EXP_OP_VAL = 44;
ExpressionInterface.EXP_OP_STAT = 45;
ExpressionInterface.EXP_OP_LEVEL = 46;
ExpressionInterface.EXP_OP_COUNTER = 47;
ExpressionInterface.EXP_OP_VARPREV = 48;
ExpressionInterface.EXP_OP_VARCURR = 49;
ExpressionInterface.EXP_OP_VARMOD = 50;
ExpressionInterface.EXP_OP_VARINP = 51;
ExpressionInterface.EXP_OP_VARNAME = 52;
ExpressionInterface.EXP_OP_VIEWMOD = 53;
ExpressionInterface.EXP_OP_ENV = 54;
ExpressionInterface.EXP_OP_INIGET = 55;
ExpressionInterface.EXP_OP_INIPUT = 56;
ExpressionInterface.EXP_OP_TERM = 59;
ExpressionInterface.EXP_OP_DATE = 61;
ExpressionInterface.EXP_OP_TIME = 62;
ExpressionInterface.EXP_OP_SYS = 63;
ExpressionInterface.EXP_OP_PROG = 66;
ExpressionInterface.EXP_OP_PWR = 68;
ExpressionInterface.EXP_OP_LOG = 69;
ExpressionInterface.EXP_OP_EXP = 70;
ExpressionInterface.EXP_OP_ABS = 71;
ExpressionInterface.EXP_OP_SIN = 72;
ExpressionInterface.EXP_OP_COS = 73;
ExpressionInterface.EXP_OP_TAN = 74;
ExpressionInterface.EXP_OP_ASIN = 75;
ExpressionInterface.EXP_OP_ACOS = 76;
ExpressionInterface.EXP_OP_ATAN = 77;
ExpressionInterface.EXP_OP_RAND = 78;
ExpressionInterface.EXP_OP_MIN = 79;
ExpressionInterface.EXP_OP_MAX = 80;
ExpressionInterface.EXP_OP_RANGE = 81;
ExpressionInterface.EXP_OP_REP = 82;
ExpressionInterface.EXP_OP_INS = 83;
ExpressionInterface.EXP_OP_DEL = 84;
ExpressionInterface.EXP_OP_FLIP = 85;
ExpressionInterface.EXP_OP_UPPER = 86;
ExpressionInterface.EXP_OP_LOWER = 87;
ExpressionInterface.EXP_OP_CRC = 88;
ExpressionInterface.EXP_OP_CHKDGT = 89;
ExpressionInterface.EXP_OP_SOUNDX = 90;
ExpressionInterface.EXP_OP_HSTR = 91;
ExpressionInterface.EXP_OP_HVAL = 92;
ExpressionInterface.EXP_OP_CHR = 93;
ExpressionInterface.EXP_OP_ASC = 94;
ExpressionInterface.EXP_OP_MSTR = 103;
ExpressionInterface.EXP_OP_MVAL = 104;
ExpressionInterface.EXP_OP_DSTR = 105;
ExpressionInterface.EXP_OP_DVAL = 106;
ExpressionInterface.EXP_OP_TSTR = 107;
ExpressionInterface.EXP_OP_TVAL = 108;
ExpressionInterface.EXP_OP_DAY = 109;
ExpressionInterface.EXP_OP_MONTH = 110;
ExpressionInterface.EXP_OP_YEAR = 111;
ExpressionInterface.EXP_OP_DOW = 112;
ExpressionInterface.EXP_OP_CDOW = 113;
ExpressionInterface.EXP_OP_CMONTH = 114;
ExpressionInterface.EXP_OP_NDOW = 115;
ExpressionInterface.EXP_OP_NMONTH = 116;
ExpressionInterface.EXP_OP_SECOND = 117;
ExpressionInterface.EXP_OP_MINUTE = 118;
ExpressionInterface.EXP_OP_HOUR = 119;
ExpressionInterface.EXP_OP_DELAY = 120;
ExpressionInterface.EXP_OP_IDLE = 121;
ExpressionInterface.EXP_OP_LOGICAL = 138;
ExpressionInterface.EXP_OP_VISUAL = 139;
ExpressionInterface.EXP_OP_ADDDATE = 156;
ExpressionInterface.EXP_OP_ADDTIME = 157;
ExpressionInterface.EXP_OP_OWNER = 158;
ExpressionInterface.EXP_OP_VARATTR = 159;
ExpressionInterface.EXP_OP_BOM = 160;
ExpressionInterface.EXP_OP_BOY = 161;
ExpressionInterface.EXP_OP_EOM = 162;
ExpressionInterface.EXP_OP_EOY = 163;
ExpressionInterface.EXP_OP_RIGHT_LITERAL = 165;
ExpressionInterface.EXP_OP_ROLLBACK = 167;
ExpressionInterface.EXP_OP_VARSET = 168;
ExpressionInterface.EXP_OP_EVALX = 171;
ExpressionInterface.EXP_OP_IGNORE = 172;
ExpressionInterface.EXP_OP_NULL = 173;
ExpressionInterface.EXP_OP_NULL_A = 174;
ExpressionInterface.EXP_OP_NULL_N = 175;
ExpressionInterface.EXP_OP_NULL_B = 176;
ExpressionInterface.EXP_OP_NULL_D = 177;
ExpressionInterface.EXP_OP_NULL_T = 178;
ExpressionInterface.EXP_OP_ISNULL = 179;
ExpressionInterface.EXP_OP_TDEPTH = 180;
ExpressionInterface.EXP_OP_MINMAGIC = 193;
ExpressionInterface.EXP_OP_MAXMAGIC = 194;
ExpressionInterface.EXP_OP_RESMAGIC = 195;
ExpressionInterface.EXP_OP_FILEDLG = 196;
ExpressionInterface.EXP_OP_MLS_TRANS = 199;
ExpressionInterface.EXP_OP_CTRL_NAME = 200;
ExpressionInterface.EXP_OP_GETLANG = 206;
ExpressionInterface.EXP_OP_NULL_O = 210;
ExpressionInterface.EXP_OP_GETPARAM = 212;
ExpressionInterface.EXP_OP_SETPARAM = 213;
ExpressionInterface.EXP_OP_CND_RANGE = 219;
ExpressionInterface.EXP_OP_ISDEFAULT = 235;
ExpressionInterface.EXP_OP_FORM = 236;
ExpressionInterface.EXP_OP_STRTOKEN = 237;
ExpressionInterface.EXP_OP_INIGETLN = 241;
ExpressionInterface.EXP_OP_EXPCALC = 242;
ExpressionInterface.EXP_OP_E = 243;
ExpressionInterface.EXP_OP_WEB_REFERENCE = 267;
ExpressionInterface.EXP_OP_CASE = 273;
ExpressionInterface.EXP_OP_LIKE = 275;
ExpressionInterface.EXP_OP_CALLJS = 283;
ExpressionInterface.EXP_OP_THIS = 290;
ExpressionInterface.EXP_OP_REPSTR = 303;
ExpressionInterface.EXP_OP_DBROUND = 306;
ExpressionInterface.EXP_OP_VARPIC = 307;
ExpressionInterface.EXP_OP_STRTOK_CNT = 309;
ExpressionInterface.EXP_OP_VARCURRN = 310;
ExpressionInterface.EXP_OP_VARINDEX = 311;
ExpressionInterface.EXP_OP_JCDOW = 343;
ExpressionInterface.EXP_OP_JMONTH = 344;
ExpressionInterface.EXP_OP_JNDOW = 345;
ExpressionInterface.EXP_OP_JYEAR = 346;
ExpressionInterface.EXP_OP_JGENGO = 347;
ExpressionInterface.EXP_OP_HAN = 350;
ExpressionInterface.EXP_OP_ZEN = 351;
ExpressionInterface.EXP_OP_ZENS = 352;
ExpressionInterface.EXP_OP_ZIMEREAD = 353;
ExpressionInterface.EXP_OP_ZKANA = 354;
ExpressionInterface.EXP_OP_GOTO_CTRL = 368;
ExpressionInterface.EXP_OP_TRANSLATE = 373;
ExpressionInterface.EXP_OP_ASTR = 374;
ExpressionInterface.EXP_OP_LOOPCOUNTER = 401;
ExpressionInterface.EXP_OP_VECGET = 417;
ExpressionInterface.EXP_OP_VECSET = 418;
ExpressionInterface.EXP_OP_VECSIZE = 419;
ExpressionInterface.EXP_OP_VECCELLATTR = 420;
ExpressionInterface.EXP_OP_BLOBSIZE = 442;
ExpressionInterface.EXP_OP_STRTOKEN_IDX = 448;
ExpressionInterface.EXP_OP_MTIME = 449;
ExpressionInterface.EXP_OP_MTVAL = 450;
ExpressionInterface.EXP_OP_MTSTR = 451;
ExpressionInterface.EXP_OP_IN = 462;
ExpressionInterface.EXP_OP_ISCOMPONENT = 465;
ExpressionInterface.EXP_OP_EXT_A = 485;
ExpressionInterface.EXP_OP_NULL_U = 491;
ExpressionInterface.EXP_OP_USER_DEFINED_FUNC = 496;
ExpressionInterface.EXP_OP_SUBFORM_EXEC_MODE = 497;
ExpressionInterface.EXP_OP_UNICODEASC = 506;
ExpressionInterface.EXP_OP_ADDDT = 509;
ExpressionInterface.EXP_OP_DIFDT = 510;
ExpressionInterface.EXP_OP_ISFIRSTRECORDCYCLE = 511;
ExpressionInterface.EXP_OP_MAINLEVEL = 512;
ExpressionInterface.EXP_OP_MAINDISPLAY = 515;
ExpressionInterface.EXP_OP_DBVIEWSIZE = 539;
ExpressionInterface.EXP_OP_DBVIEWROWIDX = 540;
ExpressionInterface.EXP_OP_PROJECTDIR = 541;
ExpressionInterface.EXP_OP_FORMSTATECLEAR = 542;
ExpressionInterface.EXP_OP_PUBLICNAME = 543;
ExpressionInterface.EXP_OP_TASKID = 544;
ExpressionInterface.EXP_OP_STR_BUILD = 549;
ExpressionInterface.EXP_OP_EMPTY_DATA_VIEW = 561;
ExpressionInterface.EXP_OP_STATUSBARSETTEXT = 568;
ExpressionInterface.EXP_OP_CLIENT_DIRDLG = 574;
ExpressionInterface.EXP_OP_CLIENT_REDIRECT = 577;
ExpressionInterface.EXP_OP_IS_MOBILE_CLIENT = 593;
ExpressionInterface.EXP_OP_CLIENT_SESSION_STATISTICS_GET = 594;
ExpressionInterface.EXP_OP_TASKTYPE = 612;
ExpressionInterface.EXP_OP_CLIENT_FILE_TO_SERVER = 615;
ExpressionInterface.EXP_OP_RANGE_ADD = 616;
ExpressionInterface.EXP_OP_RANGE_RESET = 617;
ExpressionInterface.EXP_OP_LOCATE_ADD = 618;
ExpressionInterface.EXP_OP_LOCATE_RESET = 619;
ExpressionInterface.EXP_OP_SORT_ADD = 620;
ExpressionInterface.EXP_OP_SORT_RESET = 621;
ExpressionInterface.EXP_OP_TSK_INSTANCE = 622;
ExpressionInterface.EXP_OP_CLIENTSESSION_SET = 632;
ExpressionInterface.EXP_OP_UTCDATE = 633;
ExpressionInterface.EXP_OP_UTCTIME = 634;
ExpressionInterface.EXP_OP_UTCMTIME = 635;
ExpressionInterface.EXP_OP_CLIENT_DB_DISCONNECT = 636;
ExpressionInterface.EXP_OP_DATAVIEW_TO_DATASOURCE = 637;
ExpressionInterface.EXP_OP_CLIENT_DB_DEL = 638;
ExpressionInterface.EXP_OP_VARDISPLAYNAME = 647;
ExpressionInterface.EXP_OP_CONTROL_ITEMS_REFRESH = 649;
ExpressionInterface.EXP_OP_VARCONTROLID = 650;
ExpressionInterface.EXP_OP_CONTROLITEMSLIST = 651;
ExpressionInterface.EXP_OP_CONTROLDISPLAYLIST = 652;
ExpressionInterface.EXP_OP_CLIENT_SQL_EXECUTE = 653;
ExpressionInterface.EXP_OP_CONTROL_SELECT_PROGRAM = 656;
ExpressionInterface.EXP_OP_SET_TITLE = 687;
ExpressionInterface.EXP_OP_IS_ROW_EDITING = 689;
ExpressionInterface.EXP_OP_IS_LOGGED_IN = 690;
ExpressionInterface.EXP_OP_SET_COOKIE = 701;
ExpressionInterface.EXP_OP_GET_COOKIE = 702;
ExpressionInterface.EXP_OP_DELETE_COOKIE = 703;
ExpressionInterface.EXP_OP_ROUTEGET = 705;

class GuiExpressionEvaluator {
    constructor() {
        this.ExpTask = null;
        this.Events = null;
    }
    eval_op_statusbar_set_text(resVal, statusBarText) {
        resVal.Attr = StorageAttribute.UNICODE;
        resVal.StrVal = Manager.GetCurrentRuntimeContext().DefaultStatusMsg;
        if (Manager.GetCurrentRuntimeContext().DefaultStatusMsg === null) {
            resVal.StrVal = '';
        }
        else {
            resVal.StrVal = Manager.GetCurrentRuntimeContext().DefaultStatusMsg;
        }
        resVal.IsNull = false;
        if (!(statusBarText.Attr !== StorageAttribute.ALPHA && statusBarText.Attr !== StorageAttribute.UNICODE)) {
            if (!statusBarText.IsNull) {
                let text = statusBarText.StrVal;
                let task = this.ExpTask.GetContextTask();
                if (task.getForm() === null && Manager.GetCurrentRuntimeContext().FrameForm !== null) {
                    task = Manager.GetCurrentRuntimeContext().FrameForm.getTask();
                }
                task.WriteToMessagePane(text);
                Manager.GetCurrentRuntimeContext().DefaultStatusMsg = text;
            }
        }
    }
    IsParallel() {
        return false;
    }
    eval_op_ctrl_name(resVal) {
        let lastClickedCtrlName = Manager.GetCurrentRuntimeContext().LastClickedCtrlName;
        resVal.StrVal = (NString.IsNullOrEmpty(lastClickedCtrlName) ? '' : lastClickedCtrlName);
        resVal.Attr = StorageAttribute.ALPHA;
    }
    eval_op_gotoCtrl(ctrlName, rowNum, generation, retVal) {
        retVal.Attr = StorageAttribute.BOOLEAN;
        retVal.BoolVal = false;
        let task = this.GetContextTask(generation.MgNumVal.NUM_2_LONG());
        if (task === null || task.getForm() === null)
            return;
        let iRowNum = rowNum.MgNumVal.NUM_2_LONG();
        let sCtrlName = StrUtil.rtrim(ctrlName.StrVal);
        let ctrl = task.getForm().GetCtrl(sCtrlName);
        retVal.BoolVal = this.HandleControlGoto(task, ctrl, iRowNum);
    }
    static GetContextTask(currTask, generation) {
        let task = null;
        let taskBase = currTask.GetContextTask();
        if (generation === GuiExpressionEvaluator.TRIGGER_TASK) {
            task = taskBase;
        }
        else {
            if (generation < taskBase.GetTaskDepth()) {
                task = taskBase.GetTaskAncestor(generation);
            }
        }
        return task;
    }
    GetContextTask(generation) {
        return GuiExpressionEvaluator.GetContextTask(this.ExpTask, generation);
    }
    ConstructMagicNum(resVal, i, attr) {
        resVal.MgNumVal = new NUM_TYPE();
        resVal.MgNumVal.NUM_4_LONG(i);
        resVal.Attr = attr;
    }
    SetNULL(resVal, attr) {
        resVal.IsNull = true;
        resVal.Attr = attr;
        switch (attr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                resVal.StrVal = null;
                break;
            case StorageAttribute.TIME:
            case StorageAttribute.DATE:
            case StorageAttribute.NUMERIC:
                resVal.MgNumVal = null;
                break;
            case StorageAttribute.BOOLEAN:
                resVal.BoolVal = false;
                break;
            default:
                break;
        }
    }
    GetValidatedValue(currCtrl, oldValue, newValue) {
        let vd = currCtrl.buildCopyPicture(oldValue, newValue);
        vd.evaluate();
        let validationFailed = vd.ValidationFailed;
        let ctrlValue;
        if (validationFailed) {
            let field = currCtrl.getField();
            ctrlValue = ((field.getType() === StorageAttribute.BLOB_VECTOR) ? field.getCellDefualtValue() : field.getDefaultValue());
        }
        else {
            ctrlValue = vd.getDispValue();
        }
        return ctrlValue;
    }
    SetVal(resVal, type, val, pic) {
        switch (type) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
            case StorageAttribute.UNICODE:
                resVal.Attr = type;
                resVal.StrVal = val;
                if (type === StorageAttribute.BLOB || type === StorageAttribute.BLOB_VECTOR)
                    resVal.IncludeBlobPrefix = true;
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                resVal.Attr = type;
                if (val == null)
                    resVal.MgNumVal = null;
                else if (pic == null)
                    resVal.MgNumVal = new NUM_TYPE(val);
                else
                    resVal.MgNumVal = new NUM_TYPE(val, pic, (this.ExpTask).getCompIdx());
                break;
            case StorageAttribute.BOOLEAN:
                resVal.Attr = type;
                resVal.BoolVal = DisplayConvertor.toBoolean(val);
                break;
            default:
                this.SetNULL(resVal, type);
                this.Events.WriteExceptionToLog('ExpressionEvaluator.SetVal() there is no such type : ' + type);
                break;
        }
    }
    static exp_build_string(val) {
        let name = '';
        if (val.StrVal !== null) {
            let len = val.StrVal.length;
            if (len > 0) {
                name = StrUtil.ZstringMake(val.StrVal, len);
            }
        }
        return name;
    }
    static isExpVal(obj) {
        return obj instanceof ExpVal;
    }
    BlobStringConversion(val, expectedType) {
        if (StorageAttributeCheck.IsTypeAlphaOrUnicode(expectedType)) {
            if (val.Attr === StorageAttribute.BLOB) {
                let includeBlobPrefix = val.IncludeBlobPrefix;
                if (includeBlobPrefix) {
                    let contentType = BlobType.getContentType(val.StrVal);
                    val.StrVal = BlobType.getString(val.StrVal);
                    val.IncludeBlobPrefix = false;
                    if (contentType !== BlobType.CONTENT_TYPE_BINARY && Rtf.isRtf(val.StrVal)) {
                        val.StrVal = StrUtil.GetPlainTextfromRtf(val.StrVal);
                    }
                }
                val.Attr = expectedType;
            }
            else {
                if (val.Attr === StorageAttribute.BLOB_VECTOR) {
                    let includeBlobPrefix2 = val.IncludeBlobPrefix;
                    if (includeBlobPrefix2) {
                        val.StrVal = BlobType.removeBlobPrefix(val.StrVal);
                        val.IncludeBlobPrefix = false;
                    }
                    val.Attr = expectedType;
                }
            }
        }
        else {
            if (expectedType === StorageAttribute.BLOB) {
                if (StorageAttributeCheck.IsTypeAlphaOrUnicode(val.Attr)) {
                    let contentType = (val.Attr === StorageAttribute.ALPHA) ? BlobType.CONTENT_TYPE_ANSI : BlobType.CONTENT_TYPE_UNICODE;
                    val.StrVal = BlobType.createFromString(val.StrVal, contentType);
                    val.IncludeBlobPrefix = true;
                    val.Attr = expectedType;
                }
            }
        }
    }
    eval_op_zimeread(resVal) {
        resVal.Attr = StorageAttribute.ALPHA;
        resVal.StrVal = '';
        let utilImeJpn = Manager.UtilImeJpn;
        if (utilImeJpn !== null) {
            let strImeRead = utilImeJpn.StrImeRead;
            if (!NString.IsNullOrEmpty(utilImeJpn.StrImeRead)) {
                resVal.StrVal = strImeRead;
            }
        }
    }
    ConvertExpVal(val, expectedType) {
        if (StorageAttributeCheck.StorageFldAlphaUnicodeOrBlob(val.Attr, expectedType)) {
            this.BlobStringConversion(val, expectedType);
        }
    }
}
GuiExpressionEvaluator.TRIGGER_TASK = 500000;
class ExpVal {
    constructor(attr, isNull, mgVal) {
        this.Attr = StorageAttribute.NONE;
        this.IsNull = false;
        this.MgNumVal = null;
        this.StrVal = null;
        this.BoolVal = false;
        this.IncludeBlobPrefix = false;
        this.OriginalNull = false;
        this.VectorField = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(attr, isNull, mgVal);
    }
    constructor_0() {
        this.Attr = StorageAttribute.NONE;
    }
    constructor_1(attr, isNull, mgVal) {
        this.Init(attr, isNull, mgVal);
    }
    Copy(src) {
        this.Attr = src.Attr;
        this.BoolVal = src.BoolVal;
        this.IncludeBlobPrefix = src.IncludeBlobPrefix;
        this.IsNull = src.IsNull;
        this.MgNumVal = src.MgNumVal;
        this.StrVal = src.StrVal;
        this.VectorField = src.VectorField;
        this.OriginalNull = src.OriginalNull;
    }
    Nullify() {
        this.Init(StorageAttribute.NONE, true, null);
    }
    Init(attr, isNull, mgVal) {
        this.Attr = attr;
        this.IsNull = isNull;
        switch (this.Attr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                this.StrVal = mgVal;
                break;
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
                this.StrVal = mgVal;
                this.IncludeBlobPrefix = true;
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                this.MgNumVal = ((mgVal !== null) ? new NUM_TYPE(mgVal) : null);
                break;
            case StorageAttribute.BOOLEAN:
                this.BoolVal = (mgVal !== null && mgVal === '1');
                break;
            case StorageAttribute.NONE:
                this.BoolVal = false;
                this.StrVal = null;
                this.MgNumVal = null;
                this.OriginalNull = true;
                this.VectorField = null;
                this.IncludeBlobPrefix = false;
                break;
            case StorageAttribute.DOTNET:
                this.StrVal = mgVal;
                break;
            default:
                throw new ApplicationException('in ExpVal.ExpVal() illegal attribute: \'' + this.Attr + '\'');
        }
    }
    ToMgVal() {
        let str;
        switch (this.Attr) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.BLOB:
            case StorageAttribute.BLOB_VECTOR:
            case StorageAttribute.UNICODE:
                str = this.StrVal;
                break;
            case StorageAttribute.NUMERIC:
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                str = this.MgNumVal.toXMLrecord();
                break;
            case StorageAttribute.BOOLEAN:
                str = this.BoolVal
                    ? '1'
                    : '0';
                break;
            default:
                str = '[illegal attribute: ' + this.Attr + ']';
                break;
        }
        return str;
    }
    isEmptyString() {
        return (this.Attr === StorageAttribute.ALPHA || this.Attr === StorageAttribute.UNICODE) && this.StrVal === '';
    }
}

class MagicHelp {
}
class InternalHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.Internal;
    }
    constructor() {
        super();
        this.val = null;
        this.Name = null;
        this.FrameX = 0;
        this.FrameY = 0;
        this.FrameDx = 0;
        this.FrameDy = 0;
        this.SizedX = 0;
        this.SizedY = 0;
        this.FactorX = 0;
        this.FactorY = 0;
        this.Borderstyle = 0;
        this.TitleBar = 0;
        this.FontTableIndex = 0;
    }
}
class PromptpHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.Prompt;
    }
    constructor() {
        super();
        this.PromptHelpText = null;
    }
}
class ToolTipHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.Tooltip;
    }
    constructor() {
        super();
        this.tooltipHelpText = null;
    }
}
class URLHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.URL;
    }
    constructor() {
        super();
        this.urlHelpText = null;
    }
}
class WindowsHelp extends MagicHelp {
    GetHelpType() {
        return HelpType.Windows;
    }
    constructor() {
        super();
        this.FilePath = null;
        this.HelpCommand = 0;
        this.HelpKey = null;
    }
}
class Helps {
    constructor() {
        this._helps = null;
        this._helps = new List();
    }
    fillData(parser) {
        while (this.initInnerObjects(parser.getNextTag(), parser)) {
        }
    }
    initInnerObjects(foundTagName, parser) {
        if (foundTagName === null)
            return false;
        if (foundTagName === XMLConstants.MG_TAG_HELPTABLE) {
            let currrentIndex = parser.getCurrIndex();
            let encoded = parser.ReadContentOfCurrentElement().trim();
            let decoded = Base64.decode(encoded.substr(0, encoded.length).trim(), Encoding.UTF8);
            let newXmlData = parser.getXMLdata().replace(encoded.trim(), decoded);
            parser.setXMLdata(newXmlData);
            parser.setCurrIndex(currrentIndex);
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) +
                1);
        }
        else if (foundTagName === XMLConstants.MG_TAG_HELPITEM) {
            let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_TERM, parser.getCurrIndex());
            if (endContext !== -1 && endContext < parser.getXMLdata().length) {
                let tag = parser.getXMLsubstring(endContext);
                parser.add2CurrIndex(tag.indexOf(XMLConstants.MG_TAG_HELPITEM) +
                    XMLConstants.MG_TAG_HELPITEM.length);
                let tokensVector = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
                this.fillHelpItem(tokensVector);
                parser.setCurrIndex(endContext + XMLConstants.TAG_TERM.length);
                return true;
            }
        }
        else if (foundTagName === "/" + XMLConstants.MG_TAG_HELPTABLE) {
            parser.setCurrIndex2EndOfTag();
            return false;
        }
        else {
            Events.WriteExceptionToLog("in Command.FillData() out of string bounds");
            return false;
        }
        return true;
    }
    fillHelpItem(tokensVector) {
        let j = 0;
        let attribute = tokensVector.get_Item(j);
        let valueStr = tokensVector.get_Item(j + 1);
        let hlpType = XmlParser.unescape(valueStr).toString();
        switch (hlpType) {
            case XMLConstants.MG_ATTR_HLP_TYP_TOOLTIP:
                let toolTipHelp = new ToolTipHelp();
                for (j = 2; j < tokensVector.length; j = j + 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_VALUE) {
                        toolTipHelp.tooltipHelpText = XmlParser.unescape(valueStr).toString();
                    }
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(toolTipHelp);
                break;
            case XMLConstants.MG_ATTR_HLP_TYP_PROMPT:
                let promptpHelp = new PromptpHelp();
                for (j = 2; j < tokensVector.length; j = j + 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_VALUE) {
                        promptpHelp.PromptHelpText = XmlParser.unescape(valueStr).toString();
                    }
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(promptpHelp);
                break;
            case XMLConstants.MG_ATTR_HLP_TYP_URL:
                let urlHelp = new URLHelp();
                for (j = 2; j < tokensVector.length; j = j + 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_VALUE)
                        urlHelp.urlHelpText = valueStr;
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(urlHelp);
                break;
            case XMLConstants.MG_ATTR_HLP_TYP_INTERNAL:
                let internalHelpWindowDetails = new InternalHelp();
                for (j = 2; j < tokensVector.length; j += 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_VALUE) {
                        internalHelpWindowDetails.val = XmlParser.unescape(valueStr).toString();
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_NAME) {
                        internalHelpWindowDetails.Name = XmlParser.unescape(valueStr).toString();
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEX) {
                        internalHelpWindowDetails.FrameX = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEY) {
                        internalHelpWindowDetails.FrameY = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEDX) {
                        internalHelpWindowDetails.FrameDx = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEDY) {
                        internalHelpWindowDetails.FrameDy = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_SIZEDX) {
                        internalHelpWindowDetails.SizedX = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_SIZEDY) {
                        internalHelpWindowDetails.SizedY = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FACTORX) {
                        internalHelpWindowDetails.FactorX = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FACTORY) {
                        internalHelpWindowDetails.FactorY = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_BORDERSTYLE) {
                        internalHelpWindowDetails.Borderstyle = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_TITLE_BAR) {
                        internalHelpWindowDetails.TitleBar = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_SYSTEM_MENU) {
                    }
                    else if (attribute === XMLConstants.MG_ATTR_INTERNAL_HELP_FONT_TABLE_INDEX) {
                        internalHelpWindowDetails.FontTableIndex = NNumber.Parse(XmlParser.unescape(valueStr));
                    }
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(internalHelpWindowDetails);
                break;
            case XMLConstants.MG_ATTR_HLP_TYP_WINDOWS:
                let wndHelpDetails = new WindowsHelp();
                for (j = 2; j < tokensVector.length; j = j + 2) {
                    attribute = tokensVector.get_Item(j);
                    valueStr = tokensVector.get_Item(j + 1);
                    if (attribute === XMLConstants.MG_ATTR_WINDOWS_HELP_FILE) {
                        wndHelpDetails.FilePath = valueStr;
                    }
                    else if (attribute === XMLConstants.MG_ATTR_WINDOWS_HELP_COMMAND) {
                        wndHelpDetails.HelpCommand = NNumber.Parse(valueStr);
                    }
                    else if (attribute === XMLConstants.MG_ATTR_WINDOWS_HELP_KEY) {
                        wndHelpDetails.HelpKey = XmlParser.unescape(valueStr).toString();
                    }
                    else
                        Events.WriteExceptionToLog(NString.Format("There is no such tag in <helptable><helpitem ..>.Insert case to HelpTable.FillHelpItem for {0}", attribute));
                }
                this._helps.push(wndHelpDetails);
                break;
        }
    }
    getHelp(idx) {
        let flag = idx < 0 || idx >= this._helps.length;
        let result;
        if (flag) {
            result = null;
        }
        else {
            result = this._helps.get_Item(idx);
        }
        return result;
    }
}

class GuiDataCollection {
}
GuiDataCollection.MGDataTable = null;

class GuiTaskBase {
    Init() {
        this.DataView.Init();
    }
    get RouterPath() {
        return this.routerPath;
    }
    get RouterParams() {
        return this.routeParams;
    }
    get InDefaultRouterOutlet() {
        return this.inDefaultRouterOutlet;
    }
    get IsBlockingBatch() {
        return !this._isMainPrg && this.isOpenWin() && !this._allowEvents && !this.IsInteractive;
    }
    constructor() {
        this._flowMonitor = null;
        this._keyboardMappingState = 0xFFFF0000;
        this._refreshType = "T";
        this._lastParkedCtrl = null;
        this._brkLevel = null;
        this._brkLevelIndex = -1;
        this._mainLevel = null;
        this._level = "\0";
        this._enteredRecLevel = false;
        this._currParkedFld = null;
        this.isInRecompute = false;
        this.CurrentEditingControl = null;
        this.shouldResumeSubformLayout = true;
        this.ApplicationGuid = null;
        this.ProgramIsn = 0;
        this.TaskIsn = 0;
        this.ContextID = 0;
        this.IsSubForm = false;
        this._ctlIdx = 0;
        this._compIdx = 0;
        this._isPrg = false;
        this._isMainPrg = false;
        this.IsInteractive = false;
        this._taskTag = null;
        this._openWin = false;
        this._allowEvents = false;
        this.Form = null;
        this._propTab = null;
        this._helpTab = null;
        this.IconFileName = null;
        this.IsParallel = false;
        this.DataView = null;
        this.ActionManager = null;
        this.StudioParentTask = null;
        this.routerPath = null;
        this.routeParams = null;
        this.inDefaultRouterOutlet = false;
        this.IsSubtask = false;
        this.DataViewWasRetrieved = false;
        this.TaskPrefixExecuted = false;
        this._nullArithmetic = Constants.NULL_ARITH_USE_DEF;
        this._propTab = new PropTable(this);
    }
    getTaskTag() {
        return this._taskTag;
    }
    getCtlIdx() {
        return this._ctlIdx;
    }
    isMainProg() {
        return this._isMainPrg;
    }
    getTopMostForm() {
        let form = null;
        if (this.Form !== null)
            form = this.Form.getTopMostForm();
        return form;
    }
    getCtrl(ctrlIdx) {
        return this.Form.getCtrl(ctrlIdx);
    }
    setMode(val) {
        if (this.getMode() !== val) {
            this.setProp(PropInterface.PROP_TYPE_TASK_MODE, val);
            if (this._flowMonitor !== null)
                this._flowMonitor.addTaskCngMode(val, this.GetTaskDetails());
        }
    }
    getMode() {
        let taskMode = Constants.TASK_MODE_MODIFY;
        let prop = this._propTab.getPropById(PropInterface.PROP_TYPE_TASK_MODE);
        if (prop !== null) {
            taskMode = prop.GetComputedValue();
        }
        return taskMode;
    }
    SetInRecompute(inRecompute) {
        this.isInRecompute = inRecompute;
    }
    IsInRecompute() {
        return this.isInRecompute;
    }
    resetRefreshType() {
        this._refreshType = Constants.TASK_REFRESH_NONE;
    }
    getRefreshType() {
        return this._refreshType;
    }
    SetRefreshType(refreshType) {
        switch (refreshType) {
            case Constants.TASK_REFRESH_FORM:
            case Constants.TASK_REFRESH_TABLE:
            case Constants.TASK_REFRESH_CURR_REC:
                this._refreshType = refreshType;
                break;
            default:
                break;
        }
    }
    GetRouterParams() {
        return this.routeParams;
    }
    getLastParkedCtrl() {
        return this._lastParkedCtrl;
    }
    isOpenWin() {
        return this._openWin;
    }
    async checkProp(propId, defaultRetVal) {
        let prop = this.getProp(propId);
        if (prop !== null)
            return await prop.getValueBoolean();
        return defaultRetVal;
    }
    getClickedControl() {
        let clickedCtrl = Events.GetRuntimeContext(null).CurrentClickedCtrl;
        if (clickedCtrl !== null && clickedCtrl.getForm().getTask() !== this)
            clickedCtrl = null;
        return clickedCtrl;
    }
    getKeyboardMappingState() {
        return this._keyboardMappingState;
    }
    isStateEnabled(state) {
        return (state & this._keyboardMappingState) > 0;
    }
    setKeyboardMappingState(state, on) {
        this._keyboardMappingState = on
            ? GuiTaskBase.mkInt(GuiTaskBase.hiShrt(this._keyboardMappingState) & ~state, GuiTaskBase.loShrt(this._keyboardMappingState) | state)
            : GuiTaskBase.mkInt(GuiTaskBase.hiShrt(this._keyboardMappingState) | state, GuiTaskBase.loShrt(this._keyboardMappingState) & ~state);
    }
    static hiShrt(n) {
        return (n & 0xffff0000) >> 16;
    }
    static loShrt(n) {
        return n & 0x0000ffff;
    }
    static mkInt(n1, n2) {
        return n1 << 16 | n2;
    }
    getHelpItem(idx) {
        if (this._helpTab !== null)
            return this._helpTab.getHelp(idx);
    }
    setProp(propId, val) {
        this._propTab.setProp(propId, val, this, "T");
    }
    setBrkLevel(cBrkLevel, NewBrkLevelIndex) {
        this._brkLevel = cBrkLevel;
        this._brkLevelIndex = NewBrkLevelIndex;
        this.setMainLevel(cBrkLevel);
    }
    getBrkLevel() {
        return this._brkLevel;
    }
    getBrkLevelIndex() {
        return this._brkLevelIndex;
    }
    setMainLevel(cBrkLevel) {
        if (cBrkLevel !== null && cBrkLevel.length > 0) {
            let level = cBrkLevel.charAt(0);
            if (level === Constants.TASK_LEVEL_NONE || level === Constants.TASK_LEVEL_TASK ||
                level === Constants.TASK_LEVEL_RECORD)
                this._mainLevel = cBrkLevel;
        }
    }
    getMainLevel() {
        return this._mainLevel;
    }
    setLevel(cLevel) {
        this._level = cLevel;
        if (this._level === Constants.TASK_LEVEL_RECORD)
            this._enteredRecLevel = true;
    }
    getLevel() {
        return this._level;
    }
    setDataSynced(synced) {
    }
    getNullArithmetic() {
        return this._nullArithmetic;
    }
    setLastParkedCtrl(ctrl) {
        this._lastParkedCtrl = ctrl;
        this._currParkedFld = ((this._lastParkedCtrl !== null)
            ? this._lastParkedCtrl.getField()
            : null);
        this.CurrentEditingControl = ctrl;
    }
    getCurrField() {
        return this._currParkedFld;
    }
    setCurrField(currField) {
        this._currParkedFld = currField;
    }
    getCurrFieldIdx() {
        if (this._currParkedFld !== null)
            return this._currParkedFld.getId();
        return -1;
    }
    getFieldByValueStr(valueStr, parent, vee) {
        if (arguments.length === 1)
            return this.getFieldByValueStr_0(valueStr);
        else
            return this.getFieldByValueStr_1(valueStr, parent, vee);
    }
    getFieldByValueStr_0(valueStr) {
        let parent;
        let vee;
        let refParent = new RefParam(parent);
        let refVee = new RefParam(vee);
        return this.getFieldByValueStr_1(valueStr, refParent, refVee);
    }
    getFieldByValueStr_1(valueStr, parent, vee) {
        parent.value = vee.value = 0;
        let tempField = null;
        let comma = valueStr.indexOf(",");
        if (comma > 0) {
            let parentId = NNumber.Parse(valueStr.substr(0, comma));
            let fldIdx = NNumber.Parse(valueStr.substr(comma + 1));
            tempField = ((parentId !== 0)
                ? this.getFieldDef(parentId, fldIdx)
                : this.getFieldDef(fldIdx));
            parent.value = parentId;
            vee.value = fldIdx;
        }
        return tempField;
    }
    getMainProgFieldByValueStr(valueStr) {
        let fldIdx = NNumber.Parse(valueStr) - 1;
        return this.getFieldDef(fldIdx);
    }
    getFieldDef(fldIdOrParent, fldIdx) {
        if (arguments.length === 1)
            return this.getField_0(fldIdOrParent);
        else
            return this.getField_1(fldIdOrParent, fldIdx);
    }
    getField_0(fldId) {
        return this.DataView.getField(fldId);
    }
    async InitForm() {
        if (this.Form !== null && this.isOpenWin()) {
            this.Form.InInitForm = true;
            this.Form.init();
            this.SetRefreshType(Constants.TASK_REFRESH_FORM);
            await this.RefreshDisplay();
            Commands.beginInvoke();
            this.Form.InInitForm = false;
        }
    }
    ResumeSubformLayout() {
        if (this.Form !== null) {
            let subFormCtrl = this.Form.getSubFormCtrl();
            if (subFormCtrl !== null && this.shouldResumeSubformLayout) {
                Commands.addOperationWithLine(CommandType.SET_PROPERTY, subFormCtrl, 0, HtmlProperties.Visible, subFormCtrl.isVisible());
                this.shouldResumeSubformLayout = false;
            }
        }
    }
    GetLastParkedCtrlName(depth) {
        let ancestor = this.GetTaskAncestor(depth);
        if (ancestor === null || ancestor._lastParkedCtrl === null)
            return "";
        return ancestor._lastParkedCtrl.Name;
    }
    getForm() {
        return this.Form;
    }
    SetForm(value) {
        this.Form = value;
        return value;
    }
    checkIfExistProp(propId) {
        let exist = false;
        if (this._propTab !== null) {
            let prop = this._propTab.getPropById(propId);
            exist = (prop !== null);
        }
        return exist;
    }
    getProp(propId) {
        let prop = null;
        if (this._propTab !== null) {
            prop = this._propTab.getPropById(propId);
            if (prop === null) {
                prop = Property.getDefaultProp(propId, GuiConstants.PARENT_TYPE_TASK, this);
                if (prop !== null) {
                    prop.StudioValue = prop.getOrgValue();
                    this._propTab.addProp(prop);
                }
            }
        }
        return prop;
    }
    GetComputedProperty(propId) {
        let prop = null;
        if (this._propTab !== null)
            prop = this._propTab.getPropById(propId);
        return prop;
    }
    getCompIdx() {
        return this._compIdx;
    }
    IsFirstRefreshOfProps() {
        throw new NotImplementedException();
    }
    async EvaluateExpression(expId, resType, length, contentTypeUnicode, resCellType, alwaysEvaluate, wasEvaluated) {
        let result = null;
        wasEvaluated.value = false;
        if (alwaysEvaluate || this.DataViewWasRetrieved) {
            result = await this.CalculateExpression(expId, resType, length);
            wasEvaluated.value = true;
        }
        return result;
    }
    GetExpressionStorage(expId) {
        return this.GetExpressionStorage(expId);
    }
    async CalculateExpression(expId, resType, length) {
        return Promise.resolve("");
    }
    isStarted() {
        return true;
    }
    isAborting() {
        return false;
    }
    getField_1(parent, fldIdx) {
        switch (parent) {
            case 0:
                return this.getFieldDef(fldIdx);
            case GuiTaskBase.MAIN_PRG_PARENT_ID:
                let compMainProg = GuiDataCollection.MGDataTable.GetMainProgByCtlIdx(this.ContextID, this._ctlIdx);
                return compMainProg.getFieldDef(fldIdx);
            default:
                parent--;
                if (this.StudioParentTask != null)
                    return this.StudioParentTask.getFieldDef(parent, fldIdx);
                return null;
        }
    }
    fillAttributes(parser) {
        let endContext = parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex());
        if (endContext !== -1 && endContext < parser.getXMLdata().length) {
            let tag = parser.getXMLsubstring(endContext);
            parser.add2CurrIndex(tag.indexOf(XMLConstants.MG_TAG_TASK) + XMLConstants.MG_TAG_TASK.length);
            let tokens = XmlParser.getTokens(parser.getXMLsubstring(endContext), XMLConstants.XML_ATTR_DELIM);
            for (let j = 0; j < tokens.length; j = j + 2) {
                let attribute = tokens.get_Item(j);
                let valueStr = tokens.get_Item(j + 1);
                if (!this.setAttribute(attribute, valueStr) && Events.ShouldLog(Logger_LogLevels.Development))
                    Events.WriteDevToLog(NString.Format("In TaskBase.fillAttributes(): Unprocessed(!) attribute: '{0}' = '{1}'", attribute, valueStr));
            }
            parser.setCurrIndex(parser.getXMLdata().indexOf(XMLConstants.TAG_CLOSE, parser.getCurrIndex()) + 1);
        }
    }
    setAttribute(attribute, valueStr) {
        let isTagProcessed = true;
        switch (attribute) {
            case XMLConstants.MG_ATTR_APPL_GUID:
                this.ApplicationGuid = valueStr;
                break;
            case XMLConstants.MG_ATTR_PROGRAM_ISN:
                this.ProgramIsn = NNumber.Parse(valueStr);
                break;
            case XMLConstants.MG_ATTR_TASK_ISN:
                this.TaskIsn = NNumber.Parse(valueStr);
                break;
            case XMLConstants.MG_ATTR_TOOLKIT_PARENT_TASK:
                if (NNumber.Parse(valueStr) !== 0)
                    this.StudioParentTask = GuiDataCollection.MGDataTable.GetTaskByID(valueStr);
                this.IsSubtask = true;
                break;
            case XMLConstants.MG_ATTR_TASKID:
                this.setTaskId(valueStr);
                if (Events.ShouldLog(Logger_LogLevels.Development))
                    Events.WriteDevToLog("TASK: " + this._taskTag);
                break;
            case XMLConstants.MG_ATTR_CTL_IDX:
                this.setCtlAndCompIdx(valueStr);
                break;
            case XMLConstants.MG_ATTR_MAINPRG:
                this.setMainPrg(valueStr);
                break;
            case XMLConstants.MG_ATTR_NULL_ARITHMETIC:
                this.setNullArithmetic(valueStr);
                break;
            case XMLConstants.MG_ATTR_INTERACTIVE:
                this.setIsInteracive(valueStr);
                break;
            case XMLConstants.MG_ATTR_OPEN_WIN:
                this.setOpenWin(valueStr);
                break;
            case XMLConstants.MG_ATTR_ALLOW_EVENTS:
                this.SetAllowEvents(valueStr);
                break;
            case XMLConstants.MG_ATTR_ISPRG:
                this.setIsPrg(valueStr);
                break;
            case XMLConstants.MG_ATTR_ICON_FILE_NAME:
                this.IconFileName = valueStr;
                break;
            case XMLConstants.MG_ATTR_PARALLEL:
                this.IsParallel = XmlParser.getBoolean(valueStr);
                break;
            case XMLConstants.MG_ATTR_ROUTER_PATH:
                if (valueStr.trim() != "")
                    this.routerPath = valueStr;
                break;
            case XMLConstants.MG_ATTR_IN_DEFAULT_ROUTER_OUTLET:
                this.inDefaultRouterOutlet = XmlParser.getBoolean(valueStr);
                break;
            default:
                isTagProcessed = false;
                break;
        }
        return isTagProcessed;
    }
    FormInitData(parentForm) {
        let alreadySetParentForm = false;
        let refAlreadySetParentForm = new RefParam(alreadySetParentForm);
        if (this.Form === null)
            this.Form = this.ConstructMgForm(refAlreadySetParentForm);
        if (!alreadySetParentForm)
            this.Form.ParentForm = parentForm;
        if (Events.ShouldLog(Logger_LogLevels.Development))
            Events.WriteDevToLog("form");
        this.Form.fillData(this);
        return this.Form;
    }
    setTaskId(valueStr) {
        this._taskTag = valueStr;
    }
    setCtlAndCompIdx(valueStr) {
        let i = valueStr.indexOf(",");
        if (i > -1) {
            this._ctlIdx = NNumber.Parse(valueStr.substr(0, i));
            this._compIdx = NNumber.Parse(valueStr.substr(i + 1));
        }
    }
    GetAncestorTaskContainingForm() {
        let parentTask = this.GetTaskAncestor(1);
        while (parentTask !== null && parentTask.getForm() === null) {
            parentTask = parentTask.GetTaskAncestor(1);
        }
        return parentTask;
    }
    setMainPrg(valueStr) {
        this._isMainPrg = XmlParser.getBoolean(valueStr);
    }
    setNullArithmetic(valueStr) {
        this._nullArithmetic = valueStr.charAt(0);
    }
    setIsInteracive(valueStr) {
        this.IsInteractive = XmlParser.getBoolean(valueStr);
    }
    setOpenWin(valueStr) {
        this._openWin = XmlParser.getBoolean(valueStr);
    }
    SetOpenWin(valuebool) {
        this._openWin = valuebool;
    }
    SetAllowEvents(valueStr) {
        this._allowEvents = XmlParser.getBoolean(valueStr);
    }
    setIsPrg(valueStr) {
        this._isPrg = XmlParser.getBoolean(valueStr);
    }
    ShouldEvaluatePropertyLocally(propId) {
        return false;
    }
    WriteToMessagePane(msg) {
        if (msg != null)
            console.log(msg);
    }
    WriteToMessagePanebyMsgId(msgId) {
        let msg = Events.GetMessageString(msgId);
        this.WriteToMessagePane(msg);
    }
}
GuiTaskBase.MAIN_PRG_PARENT_ID = 32768;

class MgTimer {
    constructor(timerIntervalMilliSeconds) {
        this._timerIntervalMilliSeconds = 0;
        this._threadTimer = null;
        this._timerIntervalMilliSeconds = timerIntervalMilliSeconds;
    }
    static Run(state) {
        Events.OnTimer(state);
    }
    Start() {
        var timer1 = timer(this._timerIntervalMilliSeconds, this._timerIntervalMilliSeconds);
        this._threadTimer = timer1.subscribe(() => MgTimer.Run(this));
    }
    Stop() {
        this._threadTimer.unsubscribe();
        this._threadTimer = null;
    }
}

class UsernamePasswordCredentials {
    constructor(userName, password) {
        this.Username = null;
        this.Password = null;
        if (arguments.length === 0) {
            this.constructor_0();
            return;
        }
        this.constructor_1(userName, password);
    }
    constructor_0() {
    }
    constructor_1(userName, password) {
        this.Username = userName;
        this.Password = password;
    }
    toString() {
        let result = new StringBuilder();
        result.Append(this.Username);
        result.Append(":");
        result.Append(this.Password || "null");
        return result.ToString();
    }
}
class ChangePasswordCredentials extends UsernamePasswordCredentials {
    constructor(oldUserName, newUserName, password) {
        super(oldUserName, password);
        this.NewUserName = null;
        this.NewPassword = null;
        if (arguments.length === 0) {
            this.constructor_2();
            return;
        }
        this.constructor_3(newUserName);
    }
    constructor_2() {
    }
    constructor_3(newUserName) {
        this.NewUserName = newUserName;
    }
    ToString() {
        let result = new StringBuilder();
        result.Append(this.Username);
        result.Append(":");
        result.Append(this.NewUserName);
        result.Append(":");
        result.Append(this.Password || "null");
        return result.ToString();
    }
}

export { BlobType, CellElement, ChangePasswordCredentials, ClipFormats, CommandType, Commands, ControlBase, ControlTable, CustomValidator, CustomValidatorProp, DataModificationTypes, DateBreakParams, DateElement, DcValues, DcValuesBuilderBase, DialogHandler, DisplayConvertor, DockingStyle, EMPTY_DCREF, EditReturnCode, Events, EventsProcessor, ExpVal, ExpressionInterface, FieldDef, FieldValidator, FieldsTable, FocusManager, GuiCommand, GuiCommandQueue, GuiConstants, GuiControlPropertyAdapter, GuiDataCollection, GuiDataViewBase, GuiEnvironment, GuiExpressionEvaluator, GuiExpressionEvaluator_ControlsPersistencyClearOption, GuiFieldBase, GuiFormPropertyAdapter, GuiInteractive, GuiInteractiveBase, GuiMgControl, GuiMgForm, GuiTaskBase, HebrewDate, Helps, HtmlProperties, InteractiveCommandType, InternalHelp, KeyboardItem, LastFocusedVal, MagicHelp, Manager, MarkMode, MemoryUtil, MenuEntryProgram_SrcContext, MenuStyle, MgCheckState, MgControlBase, MgCursors, MgFormBase, MgTimer, MgValue, Modifiers, NOT_FOUND, NUM_TYPE, ObjectReference, ObjectReferenceBase, ObjectReferencesCollection, OperData, OverlayType, PIC, PromptpHelp, PropDefaults, PropInterface, PropTable, Property, RaisedBy, RecordUtils, Row, RuntimeContextBase, Styles, TaskDefinitionId, TaskDefinitionIdTableSaxHandler, TimeBreakParams, ToolTipHelp, TraverseMode, UIBridge, URLHelp, UsernamePasswordCredentials, ValidationDetails, ValidationDetailsBase, VectorType, VectorTypeBase, WindowsHelp, WrongFormatException };
//# sourceMappingURL=magic-xpa-gui.mjs.map
