import { GuiMgControl } from "./gui/GuiMgControl";
import { MgFormBase } from "./management/gui/MgFormBase";
import { ITask } from "./management/tasks/ITask";
import { MgControlBase } from "./management/gui/MgControlBase";
import { RuntimeContextBase } from "./management/RuntimeContextBase";
import { GuiMgForm } from "./gui/GuiMgForm";
import { GuiTaskBase } from "./management/tasks/GuiTaskBase";
import { Exception, List } from "@magic-xpa/mscorelib";
import { Modifiers } from "./GuiEnums";
import { MgTimer } from "./management/tasks/MgTimer";
import { LastFocusedVal } from "./gui/LastFocusedVal";
import { Logger_LogLevels } from "@magic-xpa/utils";
import { GuiControlPropertyAdapter } from "./management/gui/GuiControlPropertyAdapter";
export declare class Events {
    static NonParkableLastParkedCtrlEvent: (ctrl: GuiMgControl) => void;
    static IsBatchRunningInMainContextEvent: () => boolean;
    static TranslateEvent: (fromString: string) => string;
    static PrintPreviewStartEvent: (contextID: number, ioPtr: number, copies: number, enablePDlg: boolean, hWnd: number) => void;
    static PrintPreviewSetCursorEvent: (printPreviewData: number) => void;
    static InvokeUDPEvent: (contextId: number) => number;
    static PrintPreviewUpdateEvent: (prnPrevData: number) => void;
    static CreateRichWindowEvent: (contextID: number, ctrlPtr: number, prmPtr: number, style: number, dwExStyle: number) => void;
    static CreateGuiWindowEvent: (exStyle: number, className: string, windowName: string, style: number, x: number, y: number, width: number, height: number, hwndParent: number, hMenu: number, hInstance: number, lParam: number) => number;
    static DestroyGuiWindowEvent: (hWndPtr: number) => void;
    static PrintPreviewCloseEvent: (hWndPtr: number) => void;
    static ShowPrintDialogEvent: (gpd: number) => number;
    static SetModalEvent: (mgForm: MgFormBase, on: boolean) => void;
    static CtrlFocusEvent: (iTask: ITask, ctrl: MgControlBase) => void;
    static GetRuntimeContextEvent: (contextID: string) => RuntimeContextBase;
    static SaveLastClickedCtrlEvent: (controlName: string) => void;
    static SaveLastClickInfoEvent: (controlName: string, x: number, y: number, offsetX: number, offsetY: number, lastClickCoordinatesAreInPixels: boolean) => void;
    static WriteErrorToLogEvent: (msg: string) => void;
    static WriteExceptionToLogEvent: (msg: string) => void;
    static WriteWarningToLogEvent: (msg: string) => void;
    static ShouldLogEvent: (logLevel: Logger_LogLevels) => boolean;
    static WriteGuiToLogEvent: (msg: string) => void;
    static WriteDevToLogEvent: (msg: string) => void;
    static ClearEvent: (ctrl: GuiMgControl) => void;
    static UndoEvent: (ctrl: GuiMgControl) => void;
    static ShouldAddEnterAsKeyEvent: () => boolean;
    static ShowSessionStatisticsEvent: () => void;
    static CopyDataEvent: (guiMgForm: GuiMgForm, copyData: number) => void;
    static FocusEvent: (ctrl: GuiMgControl, line: number, isProduceClick: boolean, onMultiMark: boolean) => void;
    static FocusOnNonMagicControlEvent: (ctrl: GuiMgControl) => void;
    static MouseDownEvent: (guiMgForm: GuiMgForm, guiMgCtrl: GuiMgControl, dotNetArgs: Object[], leftClickWasPressed: boolean, line: number, onMultiMark: boolean, canProduceClick: boolean) => void;
    static TableReorderEvent: (ctrl: GuiMgControl, tabOrderList: List<GuiMgControl>) => void;
    static MouseUpEvent: (ctrl: GuiMgControl, line: number) => void;
    static ComboDroppingDownEvent: (ctrl: GuiMgControl, line: number) => void;
    static SelectionEvent: (val: string, ctrl: GuiMgControl, line: number, produceClick: boolean) => void;
    static DblClickEvent: (ctrl: GuiMgControl, line: number) => void;
    static KeyDownEvent: (form: GuiMgForm, guiMgCtrl: GuiMgControl, modifier: Modifiers, keyCode: number, start: number, end: number, text: string, isActChar: boolean, suggestedValue: string, comboIsDropDown: boolean, handled: boolean) => boolean;
    static MultimarkHitEvent: (guiMgCtrl: GuiMgControl, row: number, modifier: Modifiers) => void;
    static CloseFormEvent: (form: GuiMgForm) => boolean;
    static DisposeEvent: (form: GuiMgForm) => void;
    static TimerEvent: (mgTimer: MgTimer) => void;
    static TableResizeEvent: (ctrl: GuiMgControl, newRowsInPage: number) => void;
    static GetRowsDataEvent: (ctrl: GuiMgControl, desiredTopIndex: number, sendAll: boolean, lastFocusedVal: LastFocusedVal) => void;
    static EnableCutCopyEvent: (ctrl: GuiMgControl, enable: boolean) => void;
    static EnablePasteEvent: (ctrl: GuiMgControl, enable: boolean) => void;
    static ColumnClickEvent: (columnCtrl: GuiMgControl, direction: number, columnHeader: string) => void;
    static RefreshTablesEvent: () => void;
    static HelpCloseEvent: (activeForm: GuiMgForm) => void;
    static DisplaySessionStatisticsEvent: () => void;
    static ShouldBlockMouseEventsEvent: (ctrl: GuiMgControl) => boolean;
    static PeekEndOfWorkEvent: () => boolean;
    static GetEventTimeEvent: () => number;
    static ScrollTableEvent: (guiMgObject: any, line: number, rowsToScroll: number, isPageScroll: boolean, isTableScroll: boolean, isRaisedByMouseWheel: boolean) => boolean;
    static GetDropUserFormatsEvent: () => string;
    static GetContextIDEvent: (guiMgForm: GuiMgForm) => number;
    static ShowFormEvent: (guiMgForm: GuiMgForm) => void;
    static OnFormActivateEvent: (guiMgForm: GuiMgForm) => void;
    static OnNCActivateEvent: (guiMgForm: GuiMgForm) => void;
    static HandleKeyUpMessageEvent: (guiMgForm: GuiMgForm, keyCode: number) => void;
    static OnIsLogonRTLEvent: () => boolean;
    static OnIsSpecialEngLogonEvent: () => boolean;
    static OnIsSpecialIgnoreButtonFormatEvent: () => boolean;
    static GetMainProgramEvent: (contextID: number, ctlIdx: number) => GuiTaskBase;
    static TranslateLogicalNameEvent: (fromString: string) => string;
    static GetMessageStringEvent: (msgId: string) => string;
    static OnFocus(ctrl: GuiMgControl, line: number, isProduceClick: boolean, onMultiMark: boolean): void;
    static OnFocusOnNonMagicControl(ctrl: GuiMgControl): void;
    static OnMouseDown(guiMgForm: GuiMgForm, guiMgCtrl: GuiMgControl, dotNetArgs: any[], leftClickWasPressed: boolean, line: number, onMultiMark: boolean, canProduceClick: boolean): void;
    static OnNonParkableLastParkedCtrl(ctrl: GuiMgControl): void;
    static OnTableReorder(ctrl: GuiMgControl, tabOrderList: List<GuiMgControl>): void;
    static OnMouseUp(ctrl: GuiMgControl, line: number): void;
    static OnComboDroppingDown(ctrl: GuiMgControl, line: number): void;
    static OnSelection(val: string, ctrl: GuiMgControl, line: number, produceClick: boolean): void;
    static OnDblClick(ctrl: GuiMgControl, line: number): void;
    static OnKeyDown(form: GuiMgForm, guiMgCtrl: GuiMgControl, modifier: Modifiers, keyCode: number, start: number, end: number, text: string, isActChar: boolean, suggestedValue: string, comboIsDropDown: boolean, handled: boolean): void;
    static OnKeyDown(form: GuiMgForm, ctrl: GuiMgControl, modifier: Modifiers, keyCode: number, start: number, end: number, text: string, isActChar: boolean, suggestedValue: string, handled: boolean): void;
    static OnKeyDown(form: GuiMgForm, ctrl: GuiMgControl, modifier: Modifiers, keyCode: number, suggestedValue: string, comboIsDropDown: boolean, handled: boolean): void;
    private static OnKeyDown_0;
    static OnMultiMarkHit(ctrl: GuiMgControl, row: number, modifier: Modifiers): void;
    private static OnKeyDown_1;
    private static OnKeyDown_2;
    static OnFormClose(form: GuiMgForm): boolean;
    static OnDispose(form: GuiMgForm): void;
    static OnTimer(mgTimer: MgTimer): void;
    static OnTableResize(ctrl: GuiMgControl, newRowsInPage: number): void;
    static OnGetRowsData(ctrl: GuiMgControl, desiredTopIndex: number, sendAll: boolean, lastFocusedVal: LastFocusedVal): void;
    static OnColumnClick(columnCtrl: GuiMgControl, direction: number, columnHeader: string): void;
    static RefreshTables(): void;
    static OnCloseHelp(activeForm: GuiMgForm): void;
    static IsBatchRunningInMainContext(): boolean;
    static Translate(fromString: string): string;
    static OnPrintPreviewStart(contextID: number, ioPtr: number, copies: number, enablePDlg: boolean, hWnd: number): void;
    static OnPrintPreviewSetCursor(printPreviewData: number): void;
    static InvokeUDP(contextId: number): number;
    static OnPrintPreviewUpdate(prnPrevData: number): void;
    static OnCreateRichWindow(contextID: number, ctrlPtr: number, prmPtr: number, style: number, dwExStyle: number): void;
    static OnCreateGuiWindow(exStyle: number, className: string, windowName: string, style: number, x: number, y: number, width: number, height: number, hwndParent: number, hMenu: number, hInstance: number, lParam: number): number;
    static OnDestroyGuiWindow(hWndPtr: number): void;
    static OnPrintPreviewClose(printPreviewDataPtr: number): void;
    static OnShowPrintDialog(gpd: number): number;
    static DisplaySessionStatistics(): void;
    static ShouldBlockMouseEvents(ctrl: GuiMgControl): boolean;
    static PeekEndOfWork(): boolean;
    static GetEventTime(): number;
    static OnScrollTable(guiMgObject: any, line: number, rowsToScroll: number, isPageScroll: boolean, isTableScroll: boolean, isRaisedByMouseWheel: boolean): boolean;
    static GetDropUserFormats(): string;
    static GetContextID(guiMgForm: GuiMgForm): number;
    static SetModal(mgForm: MgFormBase, on: boolean): void;
    static OnShowForm(guiMgForm: GuiMgForm): void;
    static OnFormActivate(guiMgForm: GuiMgForm): void;
    static OnNCActivate(guiMgForm: GuiMgForm): void;
    static HandleKeyUpMessage(guiMgForm: GuiMgForm, keyCode: number): void;
    static IsLogonRTL(): boolean;
    static IsSpecialEngLogon(): boolean;
    static IsSpecialIgnoreButtonFormat(): boolean;
    static GetMainProgram(contextID: number, ctlIdx: number): GuiTaskBase;
    static TranslateLogicalName(fromString: string): string;
    static GetMessageString(msgId: string): string;
    static OnCtrlFocus(iTask: ITask, ctrl: GuiControlPropertyAdapter): void;
    static GetRuntimeContext(contextID: string): RuntimeContextBase;
    static SaveLastClickedCtrlName(guiMgControl: GuiMgControl, controlName: string): void;
    static SaveLastClickInfo(guiMgForm: GuiMgForm, controlName: string, x: number, y: number, offsetX: number, offsetY: number, lastClickCoordinatesAreInPixels: boolean): void;
    static WriteErrorToLog(msg: string): void;
    static WriteExceptionToLog(msg: string): void;
    static WriteExceptionToLog(ex: Exception): void;
    private static WriteExceptionToLog_0;
    private static WriteExceptionToLog_1;
    static WriteWarningToLog(msg: string): void;
    static WriteWarningToLog(ex: Exception): void;
    private static WriteWarningToLog_0;
    private static WriteWarningToLog_1;
    static ShouldLog(logLevel: Logger_LogLevels): boolean;
    static WriteGuiToLog(msg: string): void;
    static WriteDevToLog(msg: string): void;
    static OnClear(ctrl: GuiMgControl): void;
    static OnUndo(ctrl: GuiMgControl): void;
    static AddEnterAsKeyEvent(): boolean;
    static ShowSessionStatisticsForm(): void;
    static OnCopyData(guiMgForm: GuiMgForm, copyData: number): void;
    constructor();
}
