import { UtilImeJpn } from "@magic-xpa/utils";
import { IGuiEventsManager } from "./management/events/IGuiEventsManager";
import { GuiTaskBase } from "./management/tasks/GuiTaskBase";
import { MgControlBase } from "./management/gui/MgControlBase";
import { MgFormBase } from "./management/gui/MgFormBase";
import { RuntimeContextBase } from "./management/RuntimeContextBase";
export declare class Manager {
    static IsOverlayOpen: boolean;
    private static _currentContextID;
    static DefaultProtocol: string;
    static DefaultServerName: string;
    static UtilImeJpn: UtilImeJpn;
    static EventsManager: IGuiEventsManager;
    static SetCurrentContextID(contextID: string): void;
    static GetCurrentContextID(): string;
    static Init(): void;
    static Abort(form: MgFormBase): void;
    static GetCtrlVal(ctrl: MgControlBase): string;
    static SetReadOnlyControl(ctrl: MgControlBase, isReadOnly: boolean): Promise<void>;
    static OpenForm(mgForm: MgFormBase): void;
    static DoFirstRefreshTable(mgForm: MgFormBase): Promise<void>;
    static CleanMessagePane(task: GuiTaskBase): void;
    static GetMessage(msg: string): string;
    static GetCurrentRuntimeContext(): RuntimeContextBase;
    static GetSpecialValNewPolicy(): boolean;
}
