import { GuiMgControl } from '../GuiMgControl';
import { MgValue } from '../MgValue';
import { GuiMgForm } from '../GuiMgForm';
export declare enum InteractiveCommandType {
    GET_VALUE = 0,
    GET_TOP_INDEX = 1,
    MESSAGE_BOX = 2,
    SET_TITLE = 3,
    SET_EDIT_TEXT = 4,
    INSERT_EDIT_TEXT = 5,
    GET_CARET_POS = 6,
    REFRESH_PAGE = 7,
    GET_ROWS_IN_PAGE = 8,
    SET_GET_SUGGESTED_VALUE_FOR_CHOICE_CONTROL_ON_TAGDATA = 9,
    GET_IS_ROW_EDITING = 10,
    GET_MAX_ROWS_IN_PAGINATED_TABLE = 11,
    CALL_JS = 12,
    GET_LAST_ROUTE = 13
}
export declare abstract class GuiInteractiveBase {
    _commandType: InteractiveCommandType;
    TaskTag: string;
    controlName: string;
    _str: string;
    _intVal1: number;
    _line: number;
    _obj1: any;
    _parameters: any[];
    _boolVal: boolean;
    _obj2: any;
    _mgValue: MgValue;
    arguments: Array<any>;
    resultString: string;
    constructor();
    setGetSuggestedValueOfChoiceControlOnTagData(ctrl: GuiMgControl, line: number, retSuggestedValue: boolean): void;
    getValue(obj: any, line: number): string;
    getTopIndex(tablecontrol: GuiMgControl): number;
    getIsRowEditing(tablecontrol: GuiMgControl, line: number, isLineMode: boolean): boolean;
    messageBox(title: string, msg: string, style: number): number;
    setTitle(topMostForm: GuiMgForm, title: string): void;
    setEditText(control: GuiMgControl, line: number, text: string): boolean;
    insertEditText(control: GuiMgControl, line: number, startPosition: number, textToInsert: string): boolean;
    caretPosGet(control: GuiMgControl, line: number): number;
    RefreshPage(navigateToRootRoute: boolean, initialUrl: string): void;
    getRowsInPage(control: GuiMgControl): number;
    getMaxRowsInPaginatedTable(control: GuiMgControl): number;
    getLastRoute(): string;
    ExecuteCallJS(form: any, formName: string, functionName: string, args: Array<any>): string;
    private Invoke;
    onGetRowsInPage(): void;
}
export declare class GuiInteractive extends GuiInteractiveBase {
}
