import { StorageAttribute } from '@magic-xpa/utils';
import { Encoding } from '@magic-xpa/mscorelib';
export declare class BlobType {
    static CONTENT_TYPE_UNKNOWN: string;
    static CONTENT_TYPE_ANSI: string;
    static CONTENT_TYPE_UNICODE: string;
    static CONTENT_TYPE_BINARY: string;
    static getContentType(blob: string): string;
    static getEmptyBlobPrefix(vecCellAttr: string): string;
    static getBlobPrefixForContentType(contentType: string): string;
    static getPrefix(str: string): string;
    static getEncodingFromContentType(ContentType: string): Encoding;
    private static MbToUnicode;
    private static UnicodeToMb;
    static getString(blob: string): string;
    static createFromString(blobStr: string, contentType: string): string;
    static getBytes(str: string): Uint8Array;
    static createFromBytes(bytes: Uint8Array, contentType: string): string;
    static copyBlob(dest: string, src: string): string;
    static removeBlobPrefix(source: string): string;
    static isValidBlob(blob: string): boolean;
    static setContentType(str: string, contentType: string): string;
    static SetVecCellAttr(str: string, vecCellAttr: StorageAttribute): string;
    static GetVecCellAttr(blobStr: string): string;
    static blobPrefixLength(blob: string): number;
    static getKey(blobStr: string): number;
    static getBlobSize(blob: string): number;
    static ParseContentType(contentType: number): string;
}
