import { Dictionary, List } from "@magic-xpa/mscorelib";
import { DcValues } from "./DcValues";
import { FieldsTable } from "./FieldsTable";
import { GuiTaskBase } from "../tasks/GuiTaskBase";
import { FieldDef } from "./FieldDef";
import { ITask } from "../tasks/ITask";
import { XmlParser } from "@magic-xpa/utils";
export declare abstract class GuiDataViewBase {
    _dcValsCollection: Dictionary<DcValues>;
    private _emptyDataview;
    _fieldsTab: FieldsTable;
    _task: GuiTaskBase;
    private _emptyChoice;
    private _emptyChoiceForVectors;
    abstract Init(): void;
    abstract fillHeaderData(parser: XmlParser): void;
    abstract getChunkSize(): number;
    getField(id: number): FieldDef;
    isEmptyDataview(): boolean;
    setEmptyDataview(emptyDataview: boolean): void;
    getTask(): ITask;
    getDcValues(dcId: number): DcValues;
    getEmptyChoice(): DcValues;
    getEmptyChoiceForVectors(): DcValues;
    GetFieldsTab(): FieldsTable;
    GetRouteParams(): List<any>;
}
