import { MgControlBase } from "../gui/MgControlBase";
import { Priority } from "@magic-xpa/utils";
import { MgFormBase } from "../gui/MgFormBase";
import { Modifiers } from "../../GuiEnums";
import { ITask } from "../tasks/ITask";
import { KeyboardItem } from "../../gui/KeyboardItem";
export interface IGuiEventsManager {
    addInternalEventWithCtrlAndDisplayLineAndCode(ctrl: MgControlBase, DisplayLine: number, code: number): void;
    addInternalEventWithCtrlAndCodeAndPriority(ctrl: MgControlBase, code: number, priority: Priority): void;
    AddKeyboardEvent(form: MgFormBase, ctrl: MgControlBase, modifier: Modifiers, keyCode: number, start: number, end: number, text: string, isActChar: boolean, suggestedValue: string, code: number): void;
    addGuiTriggeredEventWithCtrlAndCodeAndLine(ctrl: MgControlBase, code: number, line: number): void;
    addGuiTriggeredEventWithCtrlAndCodeAndLineAndModifier(ctrl: MgControlBase, code: number, line: number): void;
    addGuiTriggeredEventWithTaskAndCode(task: ITask, code: number): void;
    addGuiTriggeredEventWithTaskAndCodeAndLine(task: ITask, code: number, line: number): void;
    addGuiTriggeredEventWithTaskAndCodeAndOnMultiMark(task: ITask, code: number): void;
    addGuiTriggeredEventTaskAndCodeAndRaisedBy(task: ITask, code: number): void;
    AddColumnClickEvent(columnCtrl: MgControlBase, direction: number, columnHeader: string): void;
    getMatchingAction(kbItm: KeyboardItem): number;
    ignoreUnknownAbort(): boolean;
}
