import { StorageAttribute } from '@magic-xpa/utils';
import { GuiTaskBase } from '../tasks/GuiTaskBase';
import { ITask } from '../tasks/ITask';
import { MgControlBase } from '../gui/MgControlBase';
import { NUM_TYPE } from '../data/NUM_TYPE';
import { GuiFieldBase } from '../data/GuiFieldBase';
import { PIC } from '../gui/PIC';
export declare abstract class GuiExpressionEvaluator {
    static TRIGGER_TASK: number;
    ExpTask: GuiTaskBase;
    private Events;
    abstract HandleControlGoto(task: ITask, ctrl: MgControlBase, rowNo: number): boolean;
    eval_op_statusbar_set_text(resVal: ExpVal, statusBarText: ExpVal): void;
    IsParallel(): boolean;
    eval_op_ctrl_name(resVal: ExpVal): void;
    eval_op_gotoCtrl(ctrlName: ExpVal, rowNum: ExpVal, generation: ExpVal, retVal: ExpVal): void;
    static GetContextTask(currTask: GuiTaskBase, generation: number): GuiTaskBase;
    GetContextTask(generation: number): GuiTaskBase;
    ConstructMagicNum(resVal: ExpVal, i: number, attr: StorageAttribute): void;
    SetNULL(resVal: ExpVal, attr: StorageAttribute): void;
    GetValidatedValue(currCtrl: MgControlBase, oldValue: string, newValue: string): string;
    SetVal(resVal: ExpVal, type: StorageAttribute, val: string, pic: PIC): void;
    static exp_build_string(val: ExpVal): string;
    static isExpVal(obj: any): boolean;
    private BlobStringConversion;
    eval_op_zimeread(resVal: ExpVal): void;
    ConvertExpVal(val: ExpVal, expectedType: StorageAttribute): void;
}
export declare class ExpVal {
    Attr: StorageAttribute;
    IsNull: boolean;
    MgNumVal: NUM_TYPE;
    StrVal: string;
    BoolVal: boolean;
    IncludeBlobPrefix: boolean;
    OriginalNull: boolean;
    VectorField: GuiFieldBase;
    constructor();
    constructor(attr: StorageAttribute, isNull: boolean, mgVal: string);
    private constructor_0;
    private constructor_1;
    Copy(src: ExpVal): void;
    Nullify(): void;
    Init(attr: StorageAttribute, isNull: boolean, mgVal: string): void;
    ToMgVal(): string;
    isEmptyString(): boolean;
}
