import { StorageAttribute } from "@magic-xpa/utils";
import { PIC } from "./PIC";
import { GuiFieldBase } from "../data/GuiFieldBase";
import { CommandType } from "../../GuiEnums";
import { GuiMgControl } from "../../gui/GuiMgControl";
import { GuiFormPropertyAdapter } from "./GuiFormPropertyAdapter";
export declare abstract class GuiControlPropertyAdapter extends GuiMgControl {
    DataType: StorageAttribute;
    InControl: boolean;
    abstract setPicStr(format: string, expId: number): void;
    abstract setRange(newRange: string): void;
    abstract setValExp(expId: number): void;
    abstract setField(fieldOrFieldStrID: any): void;
    abstract getForm(): GuiFormPropertyAdapter;
    abstract getLayer(): number;
    abstract computePIC(picExpResult: string): PIC;
    abstract setImageList(url: string): void;
    abstract setImageWithFileName(fileName: string): void;
    abstract isDescendentOfControl(control: GuiControlPropertyAdapter): boolean;
    abstract getLinkedParent(checkSubformFather: boolean): GuiControlPropertyAdapter;
    abstract SetEnabled(val: boolean): void;
    updatePropertyLogicNesting(propId: number, commandType: CommandType, val: boolean, updateThis: boolean): Promise<void>;
    abstract IsDateTimePicture(): boolean;
    abstract GetCurrReadOnly(): boolean;
    abstract SetCurrReadOnly(newVal: boolean): void;
    abstract getDisplayLine(useLineForItems: boolean): number;
    refreshAndSetItemsList(line: number, execComputeChoice: boolean): Promise<void>;
    refreshTabForLayerList(line: number): Promise<void>;
    abstract getPIC(): PIC;
    abstract resetPrevVal(): void;
    abstract getField(): GuiFieldBase;
    abstract expressionSetAsData(): boolean;
    abstract clearRange(line: number): void;
    ComputeAndRefreshDisplayValue(forceRefresh: boolean): Promise<void>;
    refreshDispRange(execComputeChoice: boolean): Promise<string[]>;
    abstract isPropertyRepeatable(propId: number): boolean;
    abstract isVisible(): boolean;
    abstract getProp(propId: number): any;
    isParkable(checkEnabledAndVisible: boolean): Promise<boolean>;
}
