import { HelpCommand, HelpType, XmlParser } from "@magic-xpa/utils";
export declare abstract class MagicHelp {
    abstract GetHelpType(): HelpType;
}
export declare class InternalHelp extends MagicHelp {
    val: string;
    Name: string;
    FrameX: number;
    FrameY: number;
    FrameDx: number;
    FrameDy: number;
    SizedX: number;
    SizedY: number;
    FactorX: number;
    FactorY: number;
    Borderstyle: number;
    TitleBar: number;
    FontTableIndex: number;
    GetHelpType(): HelpType;
    constructor();
}
export declare class PromptpHelp extends MagicHelp {
    PromptHelpText: string;
    GetHelpType(): HelpType;
    constructor();
}
export declare class ToolTipHelp extends MagicHelp {
    tooltipHelpText: string;
    GetHelpType(): HelpType;
    constructor();
}
export declare class URLHelp extends MagicHelp {
    urlHelpText: string;
    GetHelpType(): HelpType;
    constructor();
}
export declare class WindowsHelp extends MagicHelp {
    FilePath: string;
    HelpCommand: HelpCommand;
    HelpKey: string;
    GetHelpType(): HelpType;
    constructor();
}
export declare class Helps {
    private _helps;
    constructor();
    fillData(parser: XmlParser): void;
    private initInnerObjects;
    private fillHelpItem;
    getHelp(idx: number): MagicHelp;
}
