import { List, RefParam } from '@magic-xpa/mscorelib';
import { GuiMgControl } from '../../gui/GuiMgControl';
import { PropParentInterface } from '../../gui/PropParentInterface';
import { GuiFieldBase } from '../data/GuiFieldBase';
import { MgControlType, StorageAttribute, XmlParser } from '@magic-xpa/utils';
import { MgFormBase } from './MgFormBase';
import { PIC } from './PIC';
import { PropTable } from './PropTable';
import { ValidationDetails } from './ValidationDetails';
import { Property } from './Property';
import { CommandType } from '../../GuiEnums';
import { NUM_TYPE } from '../data/NUM_TYPE';
import { DcValues } from '../data/DcValues';
import { ObjectReference } from '../../util/ObjectReference';
import { GuiControlPropertyAdapter } from './GuiControlPropertyAdapter';
export declare abstract class MgControlBase extends GuiControlPropertyAdapter implements PropParentInterface {
    _ditIdx: number;
    private _linkedControls;
    _field: GuiFieldBase;
    private _picStr;
    _choiceDisps: List<string[]>;
    _choiceLayerList: List<string[]>;
    _choiceLinks: List<string[]>;
    _choiceNums: List<NUM_TYPE[]>;
    private _containerDitIdx;
    _currReadOnly: List<boolean>;
    private _dataCtrl;
    _dcTableRefs: List<number>;
    private _firstRefreshProperties;
    private _form;
    private _hasValidItmAndDispVal;
    private _controlIsn;
    private _linkedParentDitIdx;
    _orgChoiceDisps: List<string[]>;
    _parentTable: MgControlBase;
    _pic: PIC;
    private _picExpExists;
    _prevIsNulls: List<boolean>;
    private _prevPicExpResult;
    _prevValues: List<string>;
    _propTab: PropTable;
    private _range;
    private _rangeChanged;
    _valExpId: number;
    private _vd;
    private _dcValId;
    parent: number;
    veeIndx: number;
    SourceTableReference: ObjectReference;
    ClipBoardDataExists: boolean;
    DataType: StorageAttribute;
    KeyStrokeOn: boolean;
    ModifiedByUser: boolean;
    Value: any;
    IsNull: boolean;
    forceRefresh: boolean;
    private _isModal;
    protected set Form(value: MgFormBase);
    protected get Form(): MgFormBase;
    get ControlIsn(): number;
    RefreshOnVisible: boolean;
    InControl: boolean;
    ValidateControl: boolean;
    PromptHelp: string;
    constructor();
    constructor(type: MgControlType, parentMgForm: MgFormBase, parentControl: number);
    private constructor_0;
    private constructor_1;
    get UniqueName(): string;
    get TaskTag(): string;
    checkIfExistProp(propId: number): boolean;
    getProp(propId: number): Property;
    getForm(): MgFormBase;
    getCompIdx(): number;
    IsFirstRefreshOfProps(): boolean;
    EvaluateExpression(expId: number, resType: StorageAttribute, length: number, contentTypeUnicode: boolean, resCellType: StorageAttribute, alwaysEvaluate: boolean, wasEvaluated: RefParam<boolean>): Promise<string>;
    GetExpressionStorage(expId: number): StorageAttribute;
    GetComputedProperty(propId: number): Property;
    private initReferences;
    createArrays(forceCreateArrays: boolean): void;
    SetFocus(ctrl: MgControlBase, line: number, activateForm: boolean): Promise<void>;
    InsertArrays(idx: number, count: number): void;
    updateArrays(newSize: number): void;
    updatePrevValArrays(newSize: number): void;
    fillData(mgForm: MgFormBase, ditIdx: number, parser: XmlParser): void;
    initInnerObjects(foundTagName: string, parser: XmlParser): boolean;
    private ParseSourceTable;
    private parseAttributes;
    SetAttribute(attribute: string, valueStr: string): boolean;
    setImage(): void;
    setImageWithFileName(fileName: string): void;
    private setContainer;
    getName(): string;
    getLinkedControls(): List<MgControlBase>;
    isRepeatable(): boolean;
    IsModal(): boolean;
    getDisplayLine(useLineForItems: boolean): number;
    isVisible(): boolean;
    isEnabled(): boolean;
    isModifiable(): boolean;
    getDcVals(): DcValues;
    getPrevIsNull(): boolean;
    setPrevIsNull(newValue: boolean): void;
    setPIC(picStr: string): void;
    getPIC(): PIC;
    getParent(): any;
    getField(): GuiFieldBase;
    setField(fieldOrFieldStrID: any): void;
    private setField_0;
    private setField_1;
    setPicStr(format: string, expId: number): void;
    setRange(newRange: string): void;
    setValExp(expId: number): void;
    buildCopyPicture(oldVal: string, newVal: string): ValidationDetails;
    private getCopyOfVD;
    getRanges(): string;
    getRangedValue(newVal: any): string;
    validate(newVal: any): string;
    private getFieldByValueStr;
    hasContainer(): boolean;
    getLayer(): number;
    computePIC(picExpResult: string): PIC;
    getCurrentIndexOfChoice(): number[];
    IsMultipleSelectionListBox(): boolean;
    IsDateTimePicture(): boolean;
    SupportsDataSource(): boolean;
    HasAutocomplete(): boolean;
    getIndexOfChoice(mgVal: string, line: number, isNull: boolean): Promise<number[]>;
    getDispVals(line: number, execComputeChoice: boolean): Promise<string[]>;
    private emptyChoice;
    private computeChoice;
    getTopMostForm(): MgFormBase;
    private setUrl;
    getMgValue(dispVal: any): Promise<string>;
    getLinkValue(selectedIndice: string, line: number): Promise<string>;
    private setText;
    private setRadioChecked;
    setControlToFocus(): void;
    private setCheckBoxValue;
    private refreshAndSetItemListByDataSource;
    setDcRef(dcId: number): void;
    setImageList(url: string): void;
    updatePropertyLogicNesting(propId: number, commandType: CommandType, val: boolean, updateThis: boolean): Promise<void>;
    SetEnabled(val: boolean): void;
    updateChildrenPropValue(propId: number, commandType: CommandType, val: boolean): Promise<void>;
    isDescendentOfControl(control: GuiMgControl): boolean;
    updateSubformChildrenPropValue(propId: number, commandType: CommandType, val: boolean): void;
    isChildOnCurrentLayer(child: MgControlBase): boolean;
    getCurrentLinkIdx(): number;
    getLayerFromLinkIdx(indice: number[]): number[];
    private getLinkIdxFromLayer;
    isParentPropValue(propId: number): boolean;
    getLinkedParent(checkSubformFather: boolean): GuiControlPropertyAdapter;
    SetCurrReadOnly(newVal: boolean): void;
    GetCurrReadOnly(): boolean;
    isDataCtrl(): boolean;
    getDcRef(): number;
    private getDcLineNum;
    private optionIsValid;
    private getOrderedDispList;
    resetPrevVal(): void;
    setPrevIsNull_ToNull(): void;
    expressionSetAsData(): boolean;
    clearRange(line: number): void;
    haveToCheckParentValue(): boolean;
    isContainedInLinkedParent(): boolean;
    private static combineStringArrays;
    GetComputedBooleanProperty(propId: number, defaultRetVal: boolean, line?: number): boolean;
    private GetComputedBooleanProperty_0;
    private GetComputedBooleanProperty_1;
    checkPropWithLine(propId: number, defaultRetVal: boolean, line: number): Promise<boolean>;
    checkProp(propId: number, defaultRetVal: boolean): Promise<boolean>;
    isPropertyRepeatable(propId: number): boolean;
    SetAndRefreshDisplayValue(mgVal: string, isNull: boolean): Promise<void>;
    UpdateModifiedByUser(newValue: string): void;
    private rtrimValue;
    private getMinimumValueLength;
    isNullValue(str: string): boolean;
    CanGetNullFromControlValue(): boolean;
    isChoiceNull(idx: number): boolean;
    ComputeAndRefreshDisplayValue(forceRefresh: boolean): Promise<void>;
    ShouldRefreshOnControlEnter(): boolean;
    RefreshDisplayValue(mgVal: string): Promise<void>;
    RefreshDisplay(onlyRepeatableProps?: boolean): Promise<void>;
    private RefreshDisplay_1;
    ShouldComputeAndRefreshOnClosedForm(): boolean;
    refreshProperties(onlyRepeatableProps: boolean): Promise<void>;
    refreshTabForLayerList(line: number): Promise<void>;
    refreshAndSetItemsList(line: number, execComputeChoice: boolean): Promise<void>;
    refreshDispRange(execComputeChoice: boolean): Promise<string[]>;
    refreshItmRange(execComputeChoice: boolean): Promise<string[]>;
    GetItemsRange(): Promise<string[]>;
    GetDisplayRange(): Promise<string[]>;
    private createDefaultProps;
    private setLinkedParentIdx;
    buildPicture(oldVal: any, val: any): ValidationDetails;
    isDifferentValue(newValue: any, isNull: boolean, checkNullValue: boolean): boolean;
    CompareDate(d1: Date, d2: Date): boolean;
    CompareTime(d1: Date, d2: Date): boolean;
    isColumnSortable(): boolean;
    getColumnChildControl(): MgControlBase;
    getControlNameForHandlerSearch(): string;
    linkCtrl(ctrl: MgControlBase): void;
    removeRefFromField(): void;
    getDitIdx(): number;
    setDcValId(dcValId: number): void;
    SetKeyboardLanguage(): void;
    Init(): void;
    IsParkable(): Promise<boolean>;
    HasExpOrParentTaskField(): boolean;
    isParkable(checkEnabledAndVisible: boolean): Promise<boolean>;
    RaiseControlHitOnLeftClickOfMouseDown(): boolean;
    GetVarIndex(): number;
    RaiseControlHitOnMouseDown(leftClickWasPressed: boolean): boolean;
    OnSubformClick(): void;
    GetSubformMgForm(): MgFormBase;
    PropertyExists(id: number): boolean;
    toString(): string;
    isDateZero(val: Date): boolean;
    IsDefaultRouterOutlet(): boolean;
    IsRouterOutlet(): boolean;
    ZoomButtonInitialization(): Promise<void>;
}
