import { PropParentInterface } from '../../gui/PropParentInterface';
import { MgControlType, StorageAttribute, WindowType } from '@magic-xpa/utils';
import { IHashCode, List, RefParam } from '@magic-xpa/mscorelib';
import { MgControlBase } from './MgControlBase';
import { PropTable } from './PropTable';
import { GuiTaskBase } from '../tasks/GuiTaskBase';
import { ControlTable } from './ControlTable';
import { Property } from './Property';
import { GuiFormPropertyAdapter } from './GuiFormPropertyAdapter';
import { GuiControlPropertyAdapter } from './GuiControlPropertyAdapter';
export declare abstract class MgFormBase extends GuiFormPropertyAdapter implements PropParentInterface, IHashCode {
    InInitForm: boolean;
    CtrlTab: ControlTable;
    FormRefreshed: boolean;
    RefreshRepeatableAllowed: boolean;
    Rows: List<Row>;
    ModalFormsCount: number;
    ErrorOccured: boolean;
    FormIsn: number;
    Name: string;
    Opened: boolean;
    isLegalForm: boolean;
    PBImagesNumber: number;
    ignoreFirstRefreshTable: boolean;
    ParentForm: MgFormBase;
    protected _destTblRow: number;
    protected _firstTableTabOrder: number;
    protected _inRefreshDisp: boolean;
    protected _inRestore: boolean;
    protected _lastRowSent: number;
    protected _prevGuiTopIndex: number;
    protected _propTab: PropTable;
    protected _rowsInPage: number;
    protected _maxRowsInPaginatedTable: number;
    protected _subFormCtrl: MgControlBase;
    protected _tableMgControl: MgControlBase;
    protected _tableItemsCount: number;
    protected _tableRefreshed: boolean;
    protected _task: GuiTaskBase;
    protected _topIndexUpdated: boolean;
    protected _transferingData: boolean;
    private _allowedSubformRecompute;
    private _concreteWindowType;
    private _containerCtrl;
    private _firstRefreshOfProps;
    private _prevSelIndex;
    private _shouldCreateToolbar;
    private _tableChildren;
    private _tableColumns;
    protected _userStateId: string;
    private displayLine;
    constructor();
    get DisplayLine(): number;
    set DisplayLine(value: number);
    get UniqueName(): string;
    get TaskTag(): string;
    get TableChildren(): List<MgControlBase>;
    set TableChildren(value: List<MgControlBase>);
    get ShouldCreateToolbar(): boolean;
    get AllowedSubformRecompute(): boolean;
    set AllowedSubformRecompute(value: boolean);
    get ConcreteWindowType(): WindowType;
    set ConcreteWindowType(value: WindowType);
    static ShouldPutActOnFormClose(): boolean;
    protected static ShouldBehaveAsModal(): boolean;
    private static ConvertArrayListToString;
    UpdateModalFormsCount(mgFormBase: MgFormBase, increase: boolean): void;
    EvaluateExpression(expId: number, resType: StorageAttribute, length: number, contentTypeUnicode: boolean, resCellType: StorageAttribute, alwaysEvaluate: boolean, wasEvaluated: RefParam<boolean>): Promise<string>;
    GetExpressionStorage(expId: number): StorageAttribute;
    checkIfExistProp(propId: number): boolean;
    getProp(propId: number): Property;
    GetComputedProperty(propId: number): Property;
    PropertyHasExpression(propId: number): boolean;
    getCompIdx(): number;
    IsFirstRefreshOfProps(): boolean;
    getForm(): MgFormBase;
    fillData(taskRef: GuiTaskBase): void;
    init(): void;
    fillName(formTag: string): void;
    abstract buildFormName(): string;
    createForm(): void;
    CallJS(methodName: string, args: Array<any>): Promise<string>;
    isAutomaticTabbingOrder(): boolean;
    isRefreshRepeatableAllowed(): boolean;
    isScreenMode(): boolean;
    isLineMode(): boolean;
    hasTable(): boolean;
    isDialog(): boolean;
    isSubForm(): boolean;
    HasTable(): boolean;
    getTopMostForm(): MgFormBase;
    getTopMostFrameForm(): MgFormBase;
    getSubFormCtrl(): GuiControlPropertyAdapter;
    getCtrl(ctrlIdx: number): MgControlBase;
    GetCtrl(ctrlName: string): MgControlBase;
    private defaultRouterOutlet;
    get DefaultRouterOutlet(): MgControlBase;
    GetChoiceControlItemList(mgControl: MgControlBase): Promise<string>;
    GetChoiceControlDisplayList(mgControl: MgControlBase): Promise<string>;
    getControlColumn(ctrl: MgControlBase): MgControlBase;
    getContainerCtrl(): MgControlBase;
    getColumnControls(): List<MgControlBase>;
    getTask(): GuiTaskBase;
    getTableCtrl(): MgControlBase;
    getMainControl(): MgControlBase;
    getCtrlByName(ctrlName: string, ctrlType: MgControlType): MgControlBase;
    checkAndCreateRow(idx: number): void;
    IsValidRow(idx: number): boolean;
    refreshProps(): Promise<void>;
    refreshControls(repeatableOnly: boolean): Promise<void>;
    markRowNOTCreated(idx: number): void;
    SelectRow(): void;
    getRowsInPage(): number;
    getMaxRowsInPaginatedTable(): number;
    setRowsInPage(size: number): void;
    getColumnsCount(): number;
    inRefreshDisplay(): boolean;
    setTitle(newTitle: string): void;
    getControlIdx(ctrl: MgControlBase): number;
    getTopIndexFromGUI(): number;
    getTableItemsCount(): number;
    removeRefsToCtrls(): void;
    buildTableChildren(): void;
    setTableCtrl(tableCtrl: MgControlBase): void;
    getCtrlCount(): number;
    GetControlsCountExcludingStatusBar(): number;
    refreshPropsOnExpression(): Promise<void>;
    getTabControl(ctrl: MgControlBase): MgControlBase;
    IsInputType(ctrl: MgControlBase): boolean;
    GetListOfInputControls(): any;
    abstract ConstructMgControl(): MgControlBase;
    firstTableRefresh(): void;
    SetTableItemsCount(dvsize: number, removeAll: boolean): void;
    SetTableItemsCount(dvsize: number, tableItemsCount: number, removeAll: boolean): void;
    private SetTableItemsCount_0;
    private SetTableItemsCount_1;
    InitTableControl(): void;
    InitTableControl(dvSize: number, tableItemsCount: number, removeAll: boolean): void;
    UpdateTableChildrenArraysSize(size: number): void;
    toString(): string;
    IncludeControlInTabbingOrder(control: MgControlBase): boolean;
    GetHashCode(): number;
    protected initInnerObjects(foundTagName: string): boolean;
    isRowCreated(idx: number): boolean;
    private buildLinkedControlsLists;
    private buildTableColumnsList;
    private createRow;
    private SelectRowByIdx;
    private InitTableControl_0;
    private InitTableControl_1;
    InsertTableChildrenArrays(idx: number, count: number): void;
}
export declare class Row {
    Created: boolean;
    Validated: boolean;
    constructor();
    constructor(created: boolean, validated: boolean);
    private constructor_0;
    private constructor_1;
}
