import { List, RefParam } from "@magic-xpa/mscorelib";
import { StorageAttribute, XmlParser } from "@magic-xpa/utils";
import { ITask } from "./ITask";
import { PropParentInterface } from "../../gui/PropParentInterface";
import { IFlowMonitorQueue } from "../../IFlowMonitorQueue";
import { MgControlBase } from "../gui/MgControlBase";
import { GuiFieldBase } from "../data/GuiFieldBase";
import { MgFormBase } from "../gui/MgFormBase";
import { PropTable } from "../gui/PropTable";
import { Helps, MagicHelp } from "../gui/Helps";
import { GuiDataViewBase } from "../data/GuiDataViewBase";
import { IActionManager } from "../events/IActionManager";
import { Property } from "../gui/Property";
import { FieldDef } from "../data/FieldDef";
export declare abstract class GuiTaskBase implements ITask, PropParentInterface {
    protected static MAIN_PRG_PARENT_ID: number;
    _flowMonitor: IFlowMonitorQueue;
    private _keyboardMappingState;
    _refreshType: string;
    _lastParkedCtrl: MgControlBase;
    private _brkLevel;
    private _brkLevelIndex;
    private _mainLevel;
    private _level;
    _enteredRecLevel: boolean;
    _currParkedFld: GuiFieldBase;
    private isInRecompute;
    CurrentEditingControl: MgControlBase;
    private shouldResumeSubformLayout;
    ApplicationGuid: string;
    ProgramIsn: number;
    TaskIsn: number;
    ContextID: number;
    IsSubForm: boolean;
    _ctlIdx: number;
    _compIdx: number;
    _isPrg: boolean;
    _isMainPrg: boolean;
    IsInteractive: boolean;
    _taskTag: string;
    _openWin: boolean;
    private _allowEvents;
    Form: MgFormBase;
    _propTab: PropTable;
    _helpTab: Helps;
    _nullArithmetic: string;
    IconFileName: string;
    IsParallel: boolean;
    DataView: GuiDataViewBase;
    ActionManager: IActionManager;
    StudioParentTask: GuiTaskBase;
    private routerPath;
    protected routeParams: List<any>;
    private inDefaultRouterOutlet;
    Init(): void;
    get RouterPath(): string;
    get RouterParams(): List<any>;
    get InDefaultRouterOutlet(): boolean;
    IsSubtask: boolean;
    DataViewWasRetrieved: boolean;
    TaskPrefixExecuted: boolean;
    get IsBlockingBatch(): boolean;
    constructor();
    getTaskTag(): string;
    getCtlIdx(): number;
    isMainProg(): boolean;
    getTopMostForm(): MgFormBase;
    getCtrl(ctrlIdx: number): MgControlBase;
    setMode(val: string): void;
    getMode(): string;
    SetInRecompute(inRecompute: boolean): void;
    IsInRecompute(): boolean;
    resetRefreshType(): void;
    getRefreshType(): string;
    SetRefreshType(refreshType: string): void;
    GetRouterParams(): List<any>;
    getLastParkedCtrl(): MgControlBase;
    isOpenWin(): boolean;
    checkProp(propId: number, defaultRetVal: boolean): Promise<boolean>;
    getClickedControl(): MgControlBase;
    getKeyboardMappingState(): number;
    isStateEnabled(state: number): boolean;
    setKeyboardMappingState(state: number, on: boolean): void;
    static hiShrt(n: number): number;
    static loShrt(n: number): number;
    static mkInt(n1: number, n2: number): number;
    getHelpItem(idx: number): MagicHelp;
    setProp(propId: number, val: string): void;
    setBrkLevel(cBrkLevel: string, NewBrkLevelIndex: number): void;
    getBrkLevel(): string;
    getBrkLevelIndex(): number;
    setMainLevel(cBrkLevel: string): void;
    getMainLevel(): string;
    setLevel(cLevel: string): void;
    getLevel(): string;
    setDataSynced(synced: boolean): void;
    getNullArithmetic(): string;
    setLastParkedCtrl(ctrl: MgControlBase): void;
    getCurrField(): GuiFieldBase;
    setCurrField(currField: GuiFieldBase): void;
    getCurrFieldIdx(): number;
    getFieldByValueStr(valueStr: string): FieldDef;
    getFieldByValueStr(valueStr: string, parent: RefParam<number>, vee: RefParam<number>): FieldDef;
    private getFieldByValueStr_0;
    private getFieldByValueStr_1;
    getMainProgFieldByValueStr(valueStr: string): FieldDef;
    getFieldDef(fldId: number): FieldDef;
    getFieldDef(parent: number, fldIdx: number): FieldDef;
    private getField_0;
    InitForm(): Promise<void>;
    ResumeSubformLayout(): void;
    GetLastParkedCtrlName(depth: number): string;
    getForm(): MgFormBase;
    SetForm(value: MgFormBase): MgFormBase;
    checkIfExistProp(propId: number): boolean;
    getProp(propId: number): Property;
    GetComputedProperty(propId: number): Property;
    getCompIdx(): number;
    IsFirstRefreshOfProps(): boolean;
    EvaluateExpression(expId: number, resType: StorageAttribute, length: number, contentTypeUnicode: boolean, resCellType: StorageAttribute, alwaysEvaluate: boolean, wasEvaluated: RefParam<boolean>): Promise<string>;
    GetExpressionStorage(expId: number): StorageAttribute;
    CalculateExpression(expId: number, resType: StorageAttribute, length: number): Promise<string>;
    abstract ConstructMgForm(alreadySetParentForm: RefParam<boolean>): MgFormBase;
    isStarted(): boolean;
    isAborting(): boolean;
    abstract GetTaskAncestor(generation: number): ITask;
    abstract GetContextTask(): ITask;
    abstract GetTaskDepth(): number;
    abstract RefreshDisplay(): void;
    abstract getFieldDisplayValue(fieldDef: FieldDef, value: RefParam<string>, isNull: RefParam<boolean>): void;
    abstract UpdateFieldValueAndStartRecompute(fieldDef: FieldDef, value: string, isNull: boolean): void;
    private getField_1;
    fillAttributes(parser: XmlParser): void;
    setAttribute(attribute: string, valueStr: string): boolean;
    FormInitData(parentForm: MgFormBase): MgFormBase;
    setTaskId(valueStr: string): void;
    private setCtlAndCompIdx;
    GetAncestorTaskContainingForm(): GuiTaskBase;
    private setMainPrg;
    private setNullArithmetic;
    private setIsInteracive;
    private setOpenWin;
    SetOpenWin(valuebool: boolean): void;
    SetAllowEvents(valueStr: string): void;
    private setIsPrg;
    ShouldEvaluatePropertyLocally(propId: number): boolean;
    abstract GetTaskDetails(): string;
    WriteToMessagePane(msg: string): void;
    WriteToMessagePanebyMsgId(msgId: string): void;
}
