import moment from 'moment';
export var DateTimeKind;
(function (DateTimeKind) {
    DateTimeKind[DateTimeKind["Local"] = 0] = "Local";
    DateTimeKind[DateTimeKind["Utc"] = 1] = "Utc";
})(DateTimeKind || (DateTimeKind = {}));
export class DateTime {
    get Ticks() {
        return ((this.dt.getTime() * this.ticksPerMillisecond) + this.epochTicks) - (this.dt.getTimezoneOffset() * 600000000);
    }
    get Year() {
        return this.kind === DateTimeKind.Utc ? this.dt.getUTCFullYear() : this.dt.getFullYear();
    }
    get Month() {
        return this.kind === DateTimeKind.Utc ? this.dt.getUTCMonth() + 1 : this.dt.getMonth() + 1;
    }
    get Day() {
        return this.kind === DateTimeKind.Utc ? this.dt.getUTCDate() : this.dt.getDate();
    }
    get Hour() {
        return this.kind === DateTimeKind.Utc ? this.dt.getUTCHours() : this.dt.getHours();
    }
    get Minute() {
        return this.kind === DateTimeKind.Utc ? this.dt.getUTCMinutes() : this.dt.getMinutes();
    }
    get Second() {
        return this.kind === DateTimeKind.Utc ? this.dt.getUTCSeconds() : this.dt.getSeconds();
    }
    get Millisecond() {
        return this.kind === DateTimeKind.Utc ? this.dt.getUTCMilliseconds() : this.dt.getMilliseconds();
    }
    constructor(yearOrDate, month, day, hour, minute, second) {
        this.dt = null;
        this.kind = null;
        this.epochTicks = 621355968000000000;
        this.ticksPerMillisecond = 10000;
        if (arguments.length === 1) {
            this.dt = yearOrDate;
        }
        if (arguments.length === 3) {
            this.dt = new Date(yearOrDate, month - 1, day);
        }
        if (arguments.length === 6) {
            this.dt = new Date(yearOrDate, month - 1, day, hour, minute, second);
        }
        this.kind = DateTimeKind.Local;
    }
    Format(formatString) {
        return moment(this.dt).format(formatString);
    }
    static get UtcNow() {
        let d = new DateTime(new Date());
        d.kind = DateTimeKind.Utc;
        return d;
    }
    static get Now() {
        let d = new DateTime(new Date());
        d.kind = DateTimeKind.Local;
        return d;
    }
    static GetTotalSecondsFromMidnight(utcTime, date) {
        let hh = utcTime ? date.getUTCHours() : date.getHours();
        let mm = utcTime ? date.getUTCMinutes() : date.getMinutes();
        let ss = utcTime ? date.getUTCSeconds() : date.getSeconds();
        return hh * 60 * 60 + mm * 60 + ss;
    }
    static GetTotalMilliSecondsFromMidnight(utcTime, date) {
        let hh = utcTime ? date.getUTCHours() : date.getHours();
        let mm = utcTime ? date.getUTCMinutes() : date.getMinutes();
        let ss = utcTime ? date.getUTCSeconds() : date.getSeconds();
        let ms = utcTime ? date.getUTCSeconds() : date.getMilliseconds();
        return (hh * 60 * 60 + mm * 60 + ss) * 1000 + ms;
    }
}
//# sourceMappingURL=data:application/json;base64,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