import { Exception } from "./Exception";
export class Dictionary {
    constructor() {
        this.values = new Array();
    }
    get_Item(key) {
        if (this.values.hasOwnProperty(key))
            return this.values[key];
        else
            return null;
    }
    set_Item(key, value) {
        this.values[key] = value;
    }
    Add(key, value) {
        if (this.values.hasOwnProperty(key))
            throw new Exception("An item with the same key has already been added");
        else
            this.values[key] = value;
    }
    ContainsKey(key) {
        return this.values.hasOwnProperty(key);
    }
    TryGetValue(key, pvalue) {
        if (this.values.hasOwnProperty(key)) {
            pvalue.value = this.values[key];
            return true;
        }
        else {
            pvalue.value = null;
            return false;
        }
    }
    Remove(key) {
        delete this.values[key];
    }
    get Keys() {
        return Object.keys(this.values);
    }
}
//# sourceMappingURL=data:application/json;base64,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