import { isNullOrUndefined } from "./Utils";
export class Exception {
    constructor(messageOrError) {
        this.name = "Exception";
        this.message = "";
        this.stack = "";
        this.errorLevel = 1;
        if (!isNullOrUndefined(messageOrError)) {
            if (messageOrError instanceof Error) {
                this.stack = messageOrError.stack;
                this.message = messageOrError.message;
            }
            else {
                this.message = messageOrError;
                this.stack = new Error().stack;
            }
        }
    }
    get Message() {
        return this.message;
    }
    get StackTrace() {
        let stackTrace = this.stack || '';
        let stackLines = stackTrace.split("\n").map(function (line) { return line.trim(); });
        stackTrace = stackLines.splice(stackLines[0] === 'Error' ? this.errorLevel + 1 : this.errorLevel).join("\n");
        return "\n" + stackTrace;
    }
    GetType() {
        return this.name;
    }
}
//# sourceMappingURL=data:application/json;base64,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