import { Encoding } from "./Encoding";
export class ISO_8859_1_Encoding extends Encoding {
    constructor(label) {
        super(label);
    }
    GetBytes(str) {
        if (str === null)
            throw new Error("Argument is null");
        let bytes = null;
        bytes = new Uint8Array(str.length * 3);
        let bytesCount = 0;
        for (let i = 0; i < str.length; i++) {
            bytes[bytesCount++] = str[i].charCodeAt(0);
        }
        bytes = bytes.subarray(0, 0 + bytesCount);
        return bytes;
    }
    GetString(bytes, index, count) {
        let str = null;
        if (bytes === null)
            throw new Error("Argument is null");
        if (index < 0 || count < 0 || (index + count) > bytes.length)
            throw new Error("Argument out of range");
        bytes = bytes.subarray(index, index + count);
        try {
            str = '';
            for (let i = 0; i < bytes.length; i++) {
                str += String.fromCharCode(bytes[i]);
            }
            ;
        }
        catch (ex) {
        }
        return str;
    }
}
ISO_8859_1_Encoding.ISO_8859_1 = new ISO_8859_1_Encoding("iso_8859-1");
//# sourceMappingURL=data:application/json;base64,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