import { Array_Enumerator } from "./ArrayEnumerator";
import { isUndefined } from "./Utils";
export class List extends Array {
    constructor(arrayEnumerator) {
        super();
        Object.setPrototypeOf(this, List.prototype);
        if (arguments.length === 1 && arrayEnumerator.constructor === Array_Enumerator) {
            this.AddRange(arrayEnumerator);
        }
    }
    AddRange(arrayEnumeratorOrArray) {
        if (arrayEnumeratorOrArray.constructor === Array) {
            arrayEnumeratorOrArray.forEach((item) => {
                this.push(item);
            });
        }
        else {
            let e = arrayEnumeratorOrArray;
            while (e.MoveNext()) {
                this.push(e.Current);
            }
        }
    }
    get_Item(index) {
        if (isUndefined(this[index]))
            this[index] = null;
        return this[index];
    }
    set_Item(index, value) {
        if (index >= 0 && index < this.length)
            this[index] = value;
        else
            throw new Error("index out of bounds");
    }
    GetEnumerator() {
        return new Array_Enumerator(this);
    }
    Remove(object) {
        let index = this.indexOf(object);
        if (index > -1)
            this.RemoveAt(index);
    }
    RemoveAt(index) {
        this.RemoveRange(index, 1);
    }
    RemoveRange(index, count) {
        this.splice(index, count);
    }
    Insert(index, item) {
        if (index >= 0 && index < this.length)
            this.splice(index, 0, item);
        else if (index === this.length)
            this.push(item);
        else
            throw new Error("index out of bounds");
    }
    InsertRange(items) {
        let idx = 0;
        while (idx < items.length) {
            this.Insert(idx, items[idx]);
            idx++;
        }
    }
    Clear() {
        this.splice(0, this.length);
    }
    ToArray() {
        return this.slice(0);
    }
    Contains(object) {
        return this.indexOf(object) > -1;
    }
    find(predicate) {
        let foundItem = super.find(predicate);
        if (isUndefined(foundItem))
            foundItem = null;
        return foundItem;
    }
    SetSize(size) {
        if (this.length > size) {
            this.RemoveRange(size, this.length - size);
        }
        else
            this.length = size;
    }
}
//# sourceMappingURL=data:application/json;base64,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