import { NotImplementedException } from "./NotImplementedException";
export var NumberStyles;
(function (NumberStyles) {
    NumberStyles[NumberStyles["HexNumber"] = 0] = "HexNumber";
})(NumberStyles || (NumberStyles = {}));
export class NNumber {
    static Parse(text, style) {
        if (arguments.length === 2) {
            if (style === NumberStyles.HexNumber)
                return parseInt(text, 16);
            else
                throw new NotImplementedException();
        }
        return +text;
    }
    static TryParse(str, pvalue) {
        pvalue.value = +str;
        return !isNaN(pvalue.value);
    }
    static ToString(num, format) {
        if (format === 'X2') {
            let res = num.toString(16);
            return res.length === 1 ? '0' + res : res;
        }
        throw new NotImplementedException();
    }
}
//# sourceMappingURL=data:application/json;base64,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