import { isNullOrUndefined } from "./Utils";
import { Exception } from "./Exception";
export class NString {
    static IndexOf(str, searchStr, startIndex, count) {
        let index = str.substr(startIndex, count).indexOf(searchStr);
        return index > -1 ? startIndex + index : index;
    }
    static IndexOfAny(str, subs, startIndex, count) {
        for (let i = 0; i < count; ++i) {
            let c = str.charAt(startIndex + i);
            for (let j = 0; j < subs.length; ++j) {
                if (c === subs[j])
                    return (startIndex + i);
            }
        }
        return -1;
    }
    static CopyTo(source, sourceIndex, destination, destinationIndex, count) {
        for (let i = 0; i < count; i++) {
            destination[destinationIndex + i] = source[sourceIndex + i];
        }
    }
    static Compare(strA, strB, ignoreCase, indexA, indexB, length) {
        if (arguments.length = 6) {
            strA = strA.substr(indexA, length);
            strB = strB.substr(indexB, length);
        }
        if (ignoreCase) {
            strA = strA.toLowerCase();
            strB = strB.toLowerCase();
        }
        return strA.localeCompare(strB);
    }
    static Equals(strA, strB, ignoreCase) {
        if (!NString.IsNullOrEmpty(strA) && !NString.IsNullOrEmpty(strB)) {
            if (ignoreCase) {
                strA = strA.toLowerCase();
                strB = strB.toLowerCase();
            }
            return strA === strB;
        }
        return false;
    }
    static GetHashCode(str) {
        var hash = 0, i, l, ch;
        if (str.length === 0)
            return hash;
        for (i = 0, l = str.length; i < l; i++) {
            ch = str.charCodeAt(i);
            hash = ((hash << 5) - hash) + ch;
            hash |= 0;
        }
        return hash;
    }
    static Remove(str, startIndex, length) {
        return str.substr(0, startIndex - 1) + str.substr(startIndex + length - 1);
    }
    static TrimStart(str) {
        return str.replace(/^\s\s*/, '');
    }
    static TrimEnd(string, trimChars) {
        if (arguments.length === 1)
            return string.replace(/\s\s*$/, '');
        for (let j = 0; j < trimChars.length; j++) {
            let trimChar = trimChars[j];
            let i = string.length - 1;
            while (!isNullOrUndefined(string[i]) && string[i].endsWith(trimChar)) {
                string = NString.Remove(string, string.length, 1);
                i--;
            }
        }
        return string;
    }
    static Format(format, arg0, arg1, arg2, arg3, arg4, arg5) {
        if (!isNullOrUndefined(arg0) && arg0.constructor === Array) {
            var s = format, i = arg0.length;
            while (i--) {
                s = s.replace(new RegExp('\\{' + i + '\\}', 'gm'), arg0[i]);
            }
            return s;
        }
        else {
            var args = [arg0, arg1, arg2, arg3, arg4, arg5];
            return NString.Format(format, args);
        }
    }
    static IsNullOrEmpty(str1) {
        return !str1;
    }
    static FromChars(chOrChars, startIndex, len) {
        let str = chOrChars.join('');
        if (arguments.length === 3)
            return str.substr(startIndex, len);
        return str;
    }
    static FromChar(ch, count) {
        return (new Array(count).fill(ch)).join('');
    }
    static ToCharArray(str) {
        return Array.from(str);
    }
    static CompareOrdinal(strA, strB) {
        let lenA = strA.length;
        let lenB = strB.length;
        let len = Math.min(lenA, lenB);
        for (let i = 0; i < len; i++) {
            if (strA[i].charCodeAt(0) !== strB[i].charCodeAt(0)) {
                return strA[i].charCodeAt(0) - strB[i].charCodeAt(0);
            }
        }
        if (lenA !== lenB) {
            return lenA - lenB;
        }
        return 0;
    }
    static PadRight(source, maxLength, fillString) {
        if (source.length >= maxLength)
            return source;
        let fillLen = maxLength - source.length;
        let timesToRepeat = Math.ceil(fillLen / fillString.length);
        let truncatedStringFiller = fillString.repeat(timesToRepeat).slice(0, fillLen);
        return source + truncatedStringFiller;
    }
    static Insert(str, index, ch) {
        return str.substr(0, index) + ch + str.substr(index, str.length - index);
    }
    static Replace(str, orgSubStr, newSubStr) {
        let resultStr = '';
        orgSubStr = orgSubStr.replace(new RegExp("\\\\", 'g'), "\\\\");
        orgSubStr = orgSubStr.replace(new RegExp("\\*", 'g'), "\\\*");
        orgSubStr = orgSubStr.replace(new RegExp("\\$", 'g'), "\\\$");
        orgSubStr = orgSubStr.replace(new RegExp("\\^", 'g'), "\\\^");
        orgSubStr = orgSubStr.replace(new RegExp("\\.", 'g'), "\\\.");
        orgSubStr = orgSubStr.replace(new RegExp("\\?", 'g'), "\\\?");
        orgSubStr = orgSubStr.replace(new RegExp("\\+", 'g'), "\\\+");
        orgSubStr = orgSubStr.replace(new RegExp("\\,", 'g'), "\\\,");
        orgSubStr = orgSubStr.replace(new RegExp("\\[", 'g'), "\\\[");
        orgSubStr = orgSubStr.replace(new RegExp("\\|", 'g'), "\\\|");
        try {
            resultStr = str.replace(new RegExp(orgSubStr, 'g'), newSubStr);
        }
        catch (e) {
            throw new Exception(e.message);
        }
        return resultStr;
    }
}
NString.Empty = "";
//# sourceMappingURL=data:application/json;base64,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