import * as StackTrace from 'stacktrace-js';
export class StackFrame {
    constructor(skipFrames) {
        this.stackFrame = null;
        let stackFrames = StackTrace.getSync();
        if (skipFrames < 0 || skipFrames >= stackFrames.length)
            throw new Error("Argument out of range");
        this.stackFrame = stackFrames[skipFrames];
    }
    GetFileName() {
        return this.stackFrame.fileName;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RhY2tGcmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL21zY29yZWxpYi9zcmMvU3RhY2tGcmFtZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEtBQUssVUFBVSxNQUFNLGVBQWUsQ0FBQztBQUs1QyxNQUFNLE9BQU8sVUFBVTtJQUdyQixZQUFZLFVBQWtCO1FBRnRCLGVBQVUsR0FBaUIsSUFBSSxDQUFDO1FBSXRDLElBQUksV0FBVyxHQUFtQixVQUFVLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDdkQsSUFBSSxVQUFVLEdBQUcsQ0FBQyxJQUFJLFVBQVUsSUFBSSxXQUFXLENBQUMsTUFBTTtZQUNwRCxNQUFPLElBQUksS0FBSyxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFFNUMsSUFBSSxDQUFDLFVBQVUsR0FBRyxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUVNLFdBQVc7UUFDaEIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztJQUNsQyxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBTdGFja1RyYWNlIGZyb20gJ3N0YWNrdHJhY2UtanMnO1xyXG5pbXBvcnQgSlNTdGFja0ZyYW1lID0gU3RhY2tUcmFjZS5TdGFja0ZyYW1lO1xyXG5cclxuLy8gU3RhY2tGcmFtZSB1c2VzIFN0YWNrVHJhY2UgdXRpbGl0eSB1c2luZyBzdGFja3RyYWNlLWpzIHV0aWxpdHkgZnJvbSBucG1cclxuLy8gaHR0cHM6Ly93d3cubnBtanMuY29tL3BhY2thZ2Uvc3RhY2t0cmFjZS1qc1xyXG5leHBvcnQgY2xhc3MgU3RhY2tGcmFtZSB7XHJcbiAgcHJpdmF0ZSBzdGFja0ZyYW1lOiBKU1N0YWNrRnJhbWUgPSBudWxsO1xyXG5cclxuICBjb25zdHJ1Y3Rvcihza2lwRnJhbWVzOiBudW1iZXIpIHtcclxuXHJcbiAgICBsZXQgc3RhY2tGcmFtZXM6IEpTU3RhY2tGcmFtZVtdID0gU3RhY2tUcmFjZS5nZXRTeW5jKCk7XHJcbiAgICBpZiAoc2tpcEZyYW1lcyA8IDAgfHwgc2tpcEZyYW1lcyA+PSBzdGFja0ZyYW1lcy5sZW5ndGgpXHJcbiAgICAgIHRocm93ICBuZXcgRXJyb3IoXCJBcmd1bWVudCBvdXQgb2YgcmFuZ2VcIik7XHJcblxyXG4gICAgdGhpcy5zdGFja0ZyYW1lID0gc3RhY2tGcmFtZXNbc2tpcEZyYW1lc107XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgR2V0RmlsZU5hbWUoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLnN0YWNrRnJhbWUuZmlsZU5hbWU7XHJcbiAgfVxyXG59XHJcbiJdfQ==