import { Debug } from "./Debug";
import { NString } from "./NString";
export class StringBuilder {
    constructor(valueOrLength, length) {
        this.part = "";
        if (arguments.length > 0) {
            if (valueOrLength != null && valueOrLength.constructor === Number) {
            }
            else if (valueOrLength != null && valueOrLength.constructor === String) {
                this.part = valueOrLength.toString();
            }
        }
    }
    Append(textOrNum, startIndexOrNumberOfCharacters, charCount) {
        if (textOrNum === null)
            return this;
        if (textOrNum.constructor === String) {
            if (arguments.length === 1)
                this.AppendString(textOrNum.toString());
            else if (arguments.length === 2) {
                Debug.Assert(textOrNum.length === 1, "character is expected not string");
                this.AppendString(textOrNum.charAt(0).repeat(startIndexOrNumberOfCharacters));
            }
            else
                this.AppendString(textOrNum.toString(), startIndexOrNumberOfCharacters, charCount);
        }
        else
            this.AppendNumber(textOrNum, startIndexOrNumberOfCharacters);
        return this;
    }
    AppendString(text, startIndex = 0, charCount = text.length) {
        this.part = this.part + text.substr(startIndex, charCount);
    }
    AppendNumber(num, numberOfCharacters = 1) {
        if (numberOfCharacters <= 0)
            throw new Error("numberOfCharacters cannot be less than or equal to zero");
        this.part = this.part + num.toString().repeat(numberOfCharacters);
    }
    AppendLine(text = null) {
        if (text !== null)
            this.part = this.part + text;
        this.part = this.part + '\n';
    }
    AppendFormat(format, arg0, arg1, arg2) {
        this.part = this.part + NString.Format(format, arg0, arg1, arg2);
        return this;
    }
    ToString(startIndex, length) {
        if (arguments.length === 2) {
            if (startIndex < 0 || length < 0 || (startIndex + length) > this.part.length)
                throw new Error("Argument out of range");
            return this.part.substr(startIndex, length);
        }
        return this.part;
    }
    get Length() {
        return this.part.length;
    }
    get_Item(index) {
        if (index < 0 || index >= this.part.length)
            throw new Error("Index out of range");
        return this.part.charAt(index);
    }
    set_Item(index, value) {
        if (index < 0 || index >= this.part.length)
            throw new Error("Index out of range");
        Debug.Assert(value.length <= 1, "Length of string cannot be more than 1. Only character is expected");
        let leftPart = this.part.substring(0, index);
        let rightPart = this.part.substring(index + 1, this.part.length);
        this.part = leftPart + value.charAt(0) + rightPart;
    }
    Insert(index, value) {
        if (index < 0 || index > this.part.length)
            throw new Error("Argument out of range");
        let leftPart = this.part.substring(0, index);
        let rightPart = this.part.substring(index, this.part.length);
        this.part = leftPart + value + rightPart;
        return this;
    }
    Remove(startIndex, length) {
        if (startIndex < 0 || length < 0 || (startIndex + length) > this.part.length)
            throw new Error("Argument out of range");
        let leftPart = this.part.substring(0, startIndex);
        let rightPart = this.part.substring(startIndex + length, this.part.length);
        this.part = leftPart + rightPart;
        return this;
    }
    Replace(oldValue, newValue, startIndex, count) {
        if (oldValue === null)
            throw new Error("oldValue cannot be null");
        else if (oldValue.length === 0)
            throw new Error("Length of oldValue cannot be 0");
        if (arguments.length === 4) {
            if (startIndex < 0 || count < 0 || (startIndex + count) > this.part.length)
                throw new Error("Argument out of range");
        }
        if (arguments.length === 2)
            this.part = this.part.replace(new RegExp(oldValue, 'g'), newValue);
        else if (arguments.length === 4) {
            let substr = this.part.substring(startIndex, startIndex + count);
            substr = substr.replace(new RegExp(oldValue, 'g'), newValue);
            let leftPart = this.part.substring(0, startIndex);
            let rightPart = this.part.substring(startIndex + count, this.part.length);
            this.part = leftPart + substr + rightPart;
        }
        return this;
    }
    toString() {
        return this.ToString();
    }
}
//# sourceMappingURL=data:application/json;base64,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