export declare enum DateTimeKind {
    Local = 0,
    Utc = 1
}
export declare class DateTime {
    private dt;
    private kind;
    private readonly epochTicks;
    private readonly ticksPerMillisecond;
    get Ticks(): number;
    get Year(): number;
    get Month(): number;
    get Day(): number;
    get Hour(): number;
    get Minute(): number;
    get Second(): number;
    get Millisecond(): number;
    constructor(date: Date);
    constructor(year: number, month: number, day: number);
    constructor(year: number, month: number, day: number, hour: number, minute: number, second: number);
    Format(formatString: string): string;
    static get UtcNow(): DateTime;
    static get Now(): DateTime;
    static GetTotalSecondsFromMidnight(utcTime: boolean, date: Date): number;
    static GetTotalMilliSecondsFromMidnight(utcTime: boolean, date: Date): number;
}
