export declare class Encoding {
    private label;
    static readonly ASCII: Encoding;
    static readonly UTF8: Encoding;
    static readonly Unicode: Encoding;
    static readonly CodePageToEncodingMap: any;
    private readonly textEncoder;
    private readonly textDecoder;
    constructor(label: string);
    GetBytes(str: string): Uint8Array;
    GetByteCount(str: string): number;
    GetString(bytes: Uint8Array, index: number, count: number): string;
    static GetEncoding(codepage: number): Encoding;
    private static PopulateCodePageToEncodingMap;
    toString(): string;
}
