import { Array_Enumerator } from "./ArrayEnumerator";
export declare class HashUtils {
    static GetHashCode(str: string): number;
    private static getHashCode;
}
export interface IHashCode {
    GetHashCode(): number;
}
export declare class Hashtable<TKey extends (IHashCode | string | number), TValue> {
    private _buckets;
    private _elementsCount;
    private _bucketCount;
    private _loadFactor;
    constructor(bucketCount?: number, loadFactor?: number);
    private HashFunction;
    get Count(): number;
    get Values(): Array_Enumerator<TValue>;
    get Keys(): Array_Enumerator<TKey>;
    Add(key: TKey, value: TValue): void;
    set_Item(key: TKey, value: TValue): void;
    private Insert;
    get_Item(key: TKey): TValue;
    ContainsKey(key: TKey): boolean;
    Remove(key: TKey): void;
    private Resize;
    private GetBucketIndex;
    Clear(): void;
}
