import { NString, StringBuilder } from "@magic-xpa/mscorelib";
import { SEQ_2_STR, StrUtil } from "./StrUtil";
export class ChoiceUtils {
    static GetDisplayListFromString(choiceDispStr, removeAccelerators, shouldMakePrintable, shouldTrimOptions) {
        let fromHelp = new Array("\\\\", "\\-", "\\,");
        let toHelp = new Array("XX", "XX", "XX");
        choiceDispStr = NString.TrimEnd(choiceDispStr);
        let helpStrDisp = StrUtil.searchAndReplace(choiceDispStr, fromHelp, toHelp);
        let sTok = StrUtil.tokenize(helpStrDisp, ",");
        let size = (helpStrDisp !== "" ? sTok.length : 0);
        let tokenBuffer;
        let helpTokenDisp, token;
        let currPosDisp = 0, nextPosDisp = 0, tokenPosDisp, i = 0;
        let choiceDisp = new Array(size);
        for (; i < size; i++) {
            nextPosDisp = currPosDisp;
            nextPosDisp = helpStrDisp.indexOf(',', nextPosDisp);
            if (nextPosDisp === currPosDisp)
                token = helpTokenDisp = "";
            else if (nextPosDisp === -1) {
                token = choiceDispStr.substr(currPosDisp);
                helpTokenDisp = helpStrDisp.substr(currPosDisp);
            }
            else {
                token = choiceDispStr.substr(currPosDisp, (nextPosDisp) - (currPosDisp));
                helpTokenDisp = helpStrDisp.substr(currPosDisp, (nextPosDisp) - (currPosDisp));
            }
            currPosDisp = nextPosDisp + 1;
            if (token != null) {
                token = StrUtil.ltrim(token);
                if (removeAccelerators)
                    token = ChoiceUtils.RemoveAcclCharFromOptions(new StringBuilder(token));
                helpTokenDisp = StrUtil.ltrim(helpTokenDisp);
                if (removeAccelerators)
                    helpTokenDisp = ChoiceUtils.RemoveAcclCharFromOptions(new StringBuilder(helpTokenDisp));
            }
            if (helpTokenDisp.indexOf('\\') >= 0) {
                tokenBuffer = new StringBuilder();
                for (; tokenPosDisp < helpTokenDisp.length; tokenPosDisp++)
                    if (helpTokenDisp[tokenPosDisp] !== '\\')
                        tokenBuffer.Append(token[tokenPosDisp]);
                    else if (tokenPosDisp === helpTokenDisp.length - 1)
                        tokenBuffer.Append(' ');
                token = tokenBuffer.ToString();
            }
            if (shouldMakePrintable) {
                token = StrUtil.makePrintableTokens(token, SEQ_2_STR);
                if (shouldTrimOptions) {
                    let temp = NString.TrimEnd(token);
                    if (temp.length === 0)
                        choiceDisp[i] = " ";
                    else
                        choiceDisp[i] = NString.TrimEnd(token);
                }
                else
                    choiceDisp[i] = token;
            }
            else
                choiceDisp[i] = token;
        }
        return choiceDisp;
    }
    static RemoveAcclCharFromOptions(OptionStr) {
        let i = 0;
        if (OptionStr != null) {
            for (; i < OptionStr.Length;) {
                if (OptionStr.get_Item(i) === '&') {
                    if (i < OptionStr.Length - 1 && OptionStr.get_Item(i + 1) === ('&'))
                        i++;
                    OptionStr = OptionStr.Remove(i, 1);
                }
                else
                    i++;
            }
        }
        return (OptionStr != null ? OptionStr.ToString() : null);
    }
}
//# sourceMappingURL=data:application/json;base64,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