import { Exception, StringBuilder } from "@magic-xpa/mscorelib";
import { XMLConstants } from "./XMLConstants";
export class DateTimeUtils {
    static int2str(n) {
        return (n > 9) ? n.toString() : ("0" + n);
    }
    static ToString(dateTime, format, logger) {
        let dateTimeString;
        try {
            dateTimeString = dateTime.Format(format);
        }
        catch (ex) {
            if (ex instanceof Exception) {
                if (format === XMLConstants.CACHED_DATE_TIME_FORMAT) {
                    dateTimeString = DateTimeUtils.int2str(dateTime.Day) + "/" + DateTimeUtils.int2str(dateTime.Month) + "/" + dateTime.Year + " " +
                        DateTimeUtils.int2str(dateTime.Hour) + ":" + DateTimeUtils.int2str(dateTime.Minute) + ":" +
                        DateTimeUtils.int2str(dateTime.Second);
                }
                else {
                    if (format === XMLConstants.ERROR_LOG_TIME_FORMAT) {
                        dateTimeString = DateTimeUtils.int2str(dateTime.Hour) + ":" +
                            DateTimeUtils.int2str(dateTime.Minute) + ":" +
                            DateTimeUtils.int2str(dateTime.Second) + ".";
                        if (dateTime.Millisecond % 100 > 50) {
                            dateTimeString = dateTimeString + (Math.floor(dateTime.Millisecond / 100) + 1);
                        }
                        else {
                            dateTimeString = dateTimeString + Math.floor(dateTime.Millisecond / 100);
                        }
                    }
                    else {
                        if (format === XMLConstants.ERROR_LOG_DATE_FORMAT) {
                            dateTimeString = DateTimeUtils.int2str(dateTime.Day) + "/" + DateTimeUtils.int2str(dateTime.Month) + "/" + dateTime.Year;
                        }
                        else {
                            if (format === XMLConstants.HTTP_ERROR_TIME_FORMAT) {
                                dateTimeString = DateTimeUtils.int2str(dateTime.Hour) + ":" + DateTimeUtils.int2str(dateTime.Minute) + ":" + DateTimeUtils.int2str(dateTime.Second) + ".";
                            }
                            else {
                                logger.WriteExceptionToLogWithMsg(ex.Message);
                                let dateTimeTmpString = new StringBuilder();
                                dateTimeString = dateTimeTmpString.ToString();
                            }
                        }
                    }
                }
            }
            else
                throw ex;
        }
        return dateTimeString;
    }
}
//# sourceMappingURL=data:application/json;base64,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