import { PICInterface } from "./PICInterface";
const DATE_MONTH_LEN = 10;
const DATE_DOW_LEN = 10;
export class DateUtil {
    static getLocalMonths(names) {
        let monthLen = DATE_MONTH_LEN;
        if (typeof DateUtil._localMonths[0] === "undefined") {
            if (names !== null) {
                DateUtil._localMonths[0] = PICInterface.date_month_str[0];
                for (let i = 1; i < DateUtil._localMonths.length; i = i + 1) {
                    if (i * monthLen >= names.length) {
                        DateUtil._localMonths[i] = names.substr((i - 1) * monthLen);
                        while (monthLen - DateUtil._localMonths[i].length > 0) {
                            DateUtil._localMonths[i] = DateUtil._localMonths[i] + " ";
                        }
                    }
                    else {
                        DateUtil._localMonths[i] = names.substr((i - 1) * monthLen, i * monthLen - (i - 1) * monthLen);
                    }
                }
            }
            else {
                for (let i = 0; i < DateUtil._localMonths.length; i = i + 1) {
                    DateUtil._localMonths[i] = PICInterface.date_month_str[i];
                }
            }
        }
        return DateUtil._localMonths;
    }
    static getLocalDays(names) {
        let dowLen = DATE_DOW_LEN;
        if (typeof DateUtil._localDays[0] === "undefined") {
            if (names !== null) {
                DateUtil._localDays[0] = PICInterface.date_dow_str[0];
                for (let i = 1; i < DateUtil._localDays.length; i = i + 1) {
                    if (i * dowLen >= names.length) {
                        DateUtil._localDays[i] = names.substr((i - 1) * dowLen);
                        while (dowLen - DateUtil._localDays[i].length > 0) {
                            DateUtil._localDays[i] = DateUtil._localDays[i] + " ";
                        }
                    }
                    else {
                        DateUtil._localDays[i] = names.substr((i - 1) * dowLen, i * dowLen - (i - 1) * dowLen);
                    }
                }
            }
            else {
                for (let i = 0; i < DateUtil._localMonths.length; i = i + 1) {
                    DateUtil._localMonths[i] = PICInterface.date_dow_str[i];
                }
            }
        }
        return DateUtil._localDays;
    }
}
DateUtil._localMonths = new Array(13);
DateUtil._localDays = new Array(8);
//# sourceMappingURL=data:application/json;base64,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