import { StringBuilder, NString, NNumber, DateTime, RefParam } from "@magic-xpa/mscorelib";
export class Misc {
    static WriteStackTrace(throwable) {
        console.log(throwable.Message);
        console.log(throwable.StackTrace);
    }
    static ToSByteArray(byteArray) {
        let sbyteArray = null;
        if (byteArray !== null) {
            sbyteArray = new Int8Array(byteArray.length);
            for (let i = 0; i < byteArray.length; i = i + 1) {
                sbyteArray[i] = byteArray[i];
            }
        }
        return sbyteArray;
    }
    static ToByteArray(sbyteArray) {
        let byteArray = null;
        if (sbyteArray !== null) {
            byteArray = new Uint8Array(sbyteArray.length);
            for (let i = 0; i < sbyteArray.length; i = i + 1) {
                byteArray[i] = sbyteArray[i];
            }
        }
        return byteArray;
    }
    static CompareByteArray(source, destination, numberOfBytes) {
        if (source.length >= numberOfBytes && destination.length >= numberOfBytes) {
            for (let len = 0; len < numberOfBytes; len++) {
                if (source[len] !== destination[len])
                    return false;
            }
        }
        else
            return false;
        return true;
    }
    static URShift(number, bits) {
        let result;
        if (number >= 0) {
            result = number >> bits;
        }
        else {
            result = (number >> bits) + (2 << ~bits);
        }
        return result;
    }
    static getSystemMilliseconds() {
        return Math.floor((DateTime.Now.Ticks - 621355968000000000) / 10000);
    }
    static CompareIntArrays(arrayOne, arrayTwo) {
        let areEqual = false;
        if (arrayOne === arrayTwo) {
            areEqual = true;
        }
        else {
            if (arrayOne !== null && arrayTwo !== null) {
                if (arrayOne.length === arrayTwo.length) {
                    for (let i = 0; i < arrayOne.length; i = i + 1) {
                        if (arrayOne[i] !== arrayTwo[i]) {
                            break;
                        }
                        areEqual = true;
                    }
                }
            }
        }
        return areEqual;
    }
    static GetCommaSeperatedString(intArray) {
        let temp = new StringBuilder();
        for (let val = 0; val < intArray.length; val = val + 1) {
            let value = intArray[val];
            if (temp.Length > 0) {
                temp.Append(",");
            }
            temp.Append(value);
        }
        return temp.ToString();
    }
    static GetIntArray(commaSeparatedValue) {
        let intArray = new Array(0);
        if (!NString.IsNullOrEmpty(commaSeparatedValue)) {
            let vals = commaSeparatedValue.split(',');
            intArray = new Array(vals.length);
            let outInt = new RefParam(0);
            for (let iCtr = 0; iCtr < vals.length; iCtr = iCtr + 1) {
                NNumber.TryParse(vals[iCtr], outInt);
                intArray[iCtr] = outInt.value;
            }
        }
        return intArray;
    }
    static IsWebUrl(fileName) {
        return fileName.toLowerCase().startsWith("http");
    }
}
//# sourceMappingURL=data:application/json;base64,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