import { List } from "@magic-xpa/mscorelib";
export class RequestInfo {
    constructor() {
        this.runtimeTaskTree = new List();
        this.roundtripTime = null;
        this.extraInfo = { contentLength: 0, contextID: null, sessionCounter: 0, timeStamp: null };
    }
    static clone(requestInfo) {
        let requestInfoClone = new RequestInfo();
        if (requestInfo) {
            requestInfoClone.serverCallAt = requestInfo.serverCallAt;
            requestInfoClone.runtimeTaskTree = requestInfo.runtimeTaskTree;
            requestInfoClone.roundtripTime = requestInfo.roundtripTime;
            requestInfoClone.extraInfo = { contentLength: requestInfo.extraInfo.contentLength, contextID: requestInfo.extraInfo.contextID,
                sessionCounter: requestInfo.extraInfo.sessionCounter, timeStamp: requestInfo.extraInfo.timeStamp };
        }
        return requestInfoClone;
    }
    clear() {
        this.roundtripTime = null;
        this.serverCallAt = null;
        this.extraInfo = { contentLength: 0, contextID: null, sessionCounter: 0, timeStamp: null };
        this.runtimeTaskTree = null;
    }
}
//# sourceMappingURL=data:application/json;base64,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