import { Encoding, Hashtable, NChar, NNumber, Stack } from "@magic-xpa/mscorelib";
import { UtilStrByteMode } from "./UtilStrByteMode";
export class Rtf_SYMBOL {
    constructor(keyWord, kwd, idxInRgprop) {
        this.szKeyword = null;
        this.kwd = null;
        this.idxInRgprop = null;
        this.szKeyword = keyWord;
        this.kwd = kwd;
        this.idxInRgprop = idxInRgprop;
    }
}
export class Rtf_PROP {
    constructor(actn, prop) {
        this.actn = null;
        this.prop = null;
        this.actn = actn;
        this.prop = prop;
    }
}
class Rtf_StackSave {
    constructor() {
        this.rds = null;
        this.ris = null;
    }
}
export var Rtf_KWD;
(function (Rtf_KWD) {
    Rtf_KWD[Rtf_KWD["CHAR"] = 0] = "CHAR";
    Rtf_KWD[Rtf_KWD["DEST"] = 1] = "DEST";
    Rtf_KWD[Rtf_KWD["PROP"] = 2] = "PROP";
    Rtf_KWD[Rtf_KWD["SPEC"] = 3] = "SPEC";
})(Rtf_KWD || (Rtf_KWD = {}));
export var Rtf_PROPTYPE;
(function (Rtf_PROPTYPE) {
    Rtf_PROPTYPE[Rtf_PROPTYPE["CHP"] = 0] = "CHP";
    Rtf_PROPTYPE[Rtf_PROPTYPE["PAP"] = 1] = "PAP";
    Rtf_PROPTYPE[Rtf_PROPTYPE["SEP"] = 2] = "SEP";
    Rtf_PROPTYPE[Rtf_PROPTYPE["DOP"] = 3] = "DOP";
})(Rtf_PROPTYPE || (Rtf_PROPTYPE = {}));
export var Rtf_ACTN;
(function (Rtf_ACTN) {
    Rtf_ACTN[Rtf_ACTN["SPEC"] = 0] = "SPEC";
    Rtf_ACTN[Rtf_ACTN["BYTE"] = 1] = "BYTE";
    Rtf_ACTN[Rtf_ACTN["WORD"] = 2] = "WORD";
})(Rtf_ACTN || (Rtf_ACTN = {}));
export var Rtf_IPFN;
(function (Rtf_IPFN) {
    Rtf_IPFN[Rtf_IPFN["BIN"] = 0] = "BIN";
    Rtf_IPFN[Rtf_IPFN["HEX"] = 1] = "HEX";
    Rtf_IPFN[Rtf_IPFN["SKIP_DEST"] = 2] = "SKIP_DEST";
    Rtf_IPFN[Rtf_IPFN["BREAK"] = 3] = "BREAK";
    Rtf_IPFN[Rtf_IPFN["NEW"] = 4] = "NEW";
    Rtf_IPFN[Rtf_IPFN["FONT"] = 5] = "FONT";
    Rtf_IPFN[Rtf_IPFN["CHARSET"] = 6] = "CHARSET";
    Rtf_IPFN[Rtf_IPFN["UNICODE"] = 7] = "UNICODE";
})(Rtf_IPFN || (Rtf_IPFN = {}));
export var Rtf_IDEST;
(function (Rtf_IDEST) {
    Rtf_IDEST[Rtf_IDEST["PICT"] = 0] = "PICT";
    Rtf_IDEST[Rtf_IDEST["COLOR"] = 1] = "COLOR";
    Rtf_IDEST[Rtf_IDEST["SKIP"] = 2] = "SKIP";
})(Rtf_IDEST || (Rtf_IDEST = {}));
export var Rtf_IPROP;
(function (Rtf_IPROP) {
    Rtf_IPROP[Rtf_IPROP["BOLD"] = 0] = "BOLD";
    Rtf_IPROP[Rtf_IPROP["ITALIC"] = 1] = "ITALIC";
    Rtf_IPROP[Rtf_IPROP["UNDERLINE"] = 2] = "UNDERLINE";
    Rtf_IPROP[Rtf_IPROP["FONT"] = 3] = "FONT";
    Rtf_IPROP[Rtf_IPROP["SIZE"] = 4] = "SIZE";
    Rtf_IPROP[Rtf_IPROP["COLOR"] = 5] = "COLOR";
    Rtf_IPROP[Rtf_IPROP["RED"] = 6] = "RED";
    Rtf_IPROP[Rtf_IPROP["GREEN"] = 7] = "GREEN";
    Rtf_IPROP[Rtf_IPROP["BLUE"] = 8] = "BLUE";
    Rtf_IPROP[Rtf_IPROP["LEFT_IND"] = 9] = "LEFT_IND";
    Rtf_IPROP[Rtf_IPROP["RIGHT_IND"] = 10] = "RIGHT_IND";
    Rtf_IPROP[Rtf_IPROP["FIRST_IND"] = 11] = "FIRST_IND";
    Rtf_IPROP[Rtf_IPROP["COLS"] = 12] = "COLS";
    Rtf_IPROP[Rtf_IPROP["PGN_X"] = 13] = "PGN_X";
    Rtf_IPROP[Rtf_IPROP["PGN_Y"] = 14] = "PGN_Y";
    Rtf_IPROP[Rtf_IPROP["XA_PAGE"] = 15] = "XA_PAGE";
    Rtf_IPROP[Rtf_IPROP["YA_PAGE"] = 16] = "YA_PAGE";
    Rtf_IPROP[Rtf_IPROP["XA_LEFT"] = 17] = "XA_LEFT";
    Rtf_IPROP[Rtf_IPROP["XA_RIGHT"] = 18] = "XA_RIGHT";
    Rtf_IPROP[Rtf_IPROP["YA_TOP"] = 19] = "YA_TOP";
    Rtf_IPROP[Rtf_IPROP["YA_BOTTOM"] = 20] = "YA_BOTTOM";
    Rtf_IPROP[Rtf_IPROP["PGN_START"] = 21] = "PGN_START";
    Rtf_IPROP[Rtf_IPROP["SBK"] = 22] = "SBK";
    Rtf_IPROP[Rtf_IPROP["PGN_FORMAT"] = 23] = "PGN_FORMAT";
    Rtf_IPROP[Rtf_IPROP["FACING_P"] = 24] = "FACING_P";
    Rtf_IPROP[Rtf_IPROP["LANDSCAPE"] = 25] = "LANDSCAPE";
    Rtf_IPROP[Rtf_IPROP["JUST"] = 26] = "JUST";
    Rtf_IPROP[Rtf_IPROP["PARD"] = 27] = "PARD";
    Rtf_IPROP[Rtf_IPROP["PLAIN"] = 28] = "PLAIN";
    Rtf_IPROP[Rtf_IPROP["SECTD"] = 29] = "SECTD";
    Rtf_IPROP[Rtf_IPROP["BULLET"] = 30] = "BULLET";
    Rtf_IPROP[Rtf_IPROP["XA_BULLET"] = 31] = "XA_BULLET";
    Rtf_IPROP[Rtf_IPROP["MAX"] = 32] = "MAX";
})(Rtf_IPROP || (Rtf_IPROP = {}));
export var Rtf_RDS;
(function (Rtf_RDS) {
    Rtf_RDS[Rtf_RDS["NORM"] = 0] = "NORM";
    Rtf_RDS[Rtf_RDS["COLOR"] = 1] = "COLOR";
    Rtf_RDS[Rtf_RDS["SKIP"] = 2] = "SKIP";
    Rtf_RDS[Rtf_RDS["NEW"] = 3] = "NEW";
})(Rtf_RDS || (Rtf_RDS = {}));
export var Rtf_ErrorRtf;
(function (Rtf_ErrorRtf) {
    Rtf_ErrorRtf[Rtf_ErrorRtf["OK"] = 0] = "OK";
    Rtf_ErrorRtf[Rtf_ErrorRtf["STACK_UNDERFLOW"] = 1] = "STACK_UNDERFLOW";
    Rtf_ErrorRtf[Rtf_ErrorRtf["STACK_OVERFLOW"] = 2] = "STACK_OVERFLOW";
    Rtf_ErrorRtf[Rtf_ErrorRtf["UNMATCHED_BRACE"] = 3] = "UNMATCHED_BRACE";
    Rtf_ErrorRtf[Rtf_ErrorRtf["INVALID_HEX"] = 4] = "INVALID_HEX";
    Rtf_ErrorRtf[Rtf_ErrorRtf["BAD_TABLE"] = 5] = "BAD_TABLE";
    Rtf_ErrorRtf[Rtf_ErrorRtf["ASSERTION"] = 6] = "ASSERTION";
    Rtf_ErrorRtf[Rtf_ErrorRtf["END_OF_FILE"] = 7] = "END_OF_FILE";
    Rtf_ErrorRtf[Rtf_ErrorRtf["BUFFER_TOO_SMALL"] = 8] = "BUFFER_TOO_SMALL";
})(Rtf_ErrorRtf || (Rtf_ErrorRtf = {}));
export class Rtf_RtfChar {
}
Rtf_RtfChar.CR = String.fromCharCode(0x0d);
Rtf_RtfChar.LF = String.fromCharCode(0x0A);
Rtf_RtfChar.TAB = String.fromCharCode(0x09);
Rtf_RtfChar.BULLET = String.fromCharCode(0x95);
Rtf_RtfChar.TILDA = String.fromCharCode(0xA0);
Rtf_RtfChar.DASH = String.fromCharCode(0xAD);
Rtf_RtfChar.DASH_CHAR = '-';
Rtf_RtfChar.QUOTE = '\'';
Rtf_RtfChar.DBLQUOTE = '"';
Rtf_RtfChar.OPENINGBRACE = '{';
Rtf_RtfChar.CLOSINGBRACE = '}';
Rtf_RtfChar.BACKSLASH = '\\';
export var Rtf_RIS;
(function (Rtf_RIS) {
    Rtf_RIS[Rtf_RIS["NORM"] = 0] = "NORM";
    Rtf_RIS[Rtf_RIS["BIN"] = 1] = "BIN";
    Rtf_RIS[Rtf_RIS["HEX"] = 2] = "HEX";
    Rtf_RIS[Rtf_RIS["UNICODE"] = 3] = "UNICODE";
})(Rtf_RIS || (Rtf_RIS = {}));
export class Rtf {
    constructor() {
        this._group = 0;
        this._cbBin = 0;
        this._lParam = 0;
        this._skipDestIfUnk = false;
        this._outputOnce = false;
        this._processCrlfSpecial = false;
        this._destState = null;
        this._internalState = null;
        this._stack = null;
        this._index = 0;
        this._fontNum = 0;
        this._charsetTable = new Hashtable();
        this._codePageTable = new Hashtable();
        this._stack = new Stack();
        this._group = 0;
        this._cbBin = 0;
        this._lParam = 0;
        this._outputOnce = false;
        this._skipDestIfUnk = false;
        this._processCrlfSpecial = false;
        this._destState = Rtf_RDS.NORM;
        this._internalState = Rtf_RIS.NORM;
        this._fontNum = 0;
        if (UtilStrByteMode.isLocaleDefLangDBCS()) {
            this.setCodePageTable();
        }
    }
    static isRtf(str) {
        let isRtf = false;
        if (str !== null && str.startsWith(this.RTF_PREFIX)) {
            isRtf = true;
        }
        return isRtf;
    }
    toTxt(rtfTxt, outputTxt) {
        let cNibble = 2;
        let b = 0;
        let currPos = 0;
        let skipNewline = false;
        let blobStrLen;
        let blobChar;
        let ec;
        let dbcsBytes = new Uint8Array(2);
        let skipParseChar = false;
        let charset = 0;
        let codePage = 0;
        this._outputOnce = false;
        this._processCrlfSpecial = false;
        blobStrLen = rtfTxt.length;
        this._index = 0;
        this._destState = Rtf_RDS.NORM;
        if (rtfTxt === null || blobStrLen === 0 || !Rtf.isRtf(rtfTxt)) {
            return Rtf_ErrorRtf.OK;
        }
        while (this._index < blobStrLen) {
            blobChar = rtfTxt[this._index];
            this._index++;
            if (this._group < 0)
                return Rtf_ErrorRtf.STACK_UNDERFLOW;
            if (this._internalState === Rtf_RIS.BIN) {
                if ((ec = this.ParseChar(blobChar, outputTxt)) !== Rtf_ErrorRtf.OK)
                    return ec;
            }
            else {
                switch (blobChar) {
                    case Rtf_RtfChar.OPENINGBRACE:
                        skipNewline = false;
                        if ((ec = this.PushState()) !== Rtf_ErrorRtf.OK)
                            return ec;
                        break;
                    case Rtf_RtfChar.CLOSINGBRACE:
                        skipNewline = true;
                        if ((ec = this.PopState()) !== Rtf_ErrorRtf.OK)
                            return ec;
                        break;
                    case Rtf_RtfChar.BACKSLASH:
                        skipNewline = false;
                        if ((ec = this.ParseKeyword(rtfTxt, outputTxt)) !== Rtf_ErrorRtf.OK)
                            return ec;
                        break;
                    case Rtf_RtfChar.LF:
                    case Rtf_RtfChar.CR:
                        if (this._processCrlfSpecial) {
                            if (blobChar === Rtf_RtfChar.LF) {
                                this._processCrlfSpecial = false;
                            }
                        }
                        else {
                            if (blobChar === Rtf_RtfChar.LF || (blobChar === Rtf_RtfChar.CR && skipNewline && !this._outputOnce))
                                break;
                        }
                    default:
                        if (blobChar !== Rtf_RtfChar.CR)
                            skipNewline = false;
                        if (this._internalState === Rtf_RIS.NORM) {
                            if ((ec = this.ParseChar(blobChar, outputTxt)) !== Rtf_ErrorRtf.OK)
                                return ec;
                        }
                        else if (this._internalState === Rtf_RIS.UNICODE) {
                            if ((ec = this.ParseChar(String.fromCharCode(this._lParam), outputTxt)) !== Rtf_ErrorRtf.OK)
                                return ec;
                            this._internalState = Rtf_RIS.NORM;
                        }
                        else {
                            if (this._internalState !== Rtf_RIS.HEX)
                                return Rtf_ErrorRtf.ASSERTION;
                            b = b << 4;
                            if (NChar.IsDigit(blobChar))
                                b += blobChar.charCodeAt(0) - '0'.charCodeAt(0);
                            else {
                                if (NChar.IsLower(blobChar)) {
                                    if (blobChar < 'a' || blobChar > 'f')
                                        return Rtf_ErrorRtf.INVALID_HEX;
                                    b += 10 + blobChar.charCodeAt(0) - 'a'.charCodeAt(0);
                                }
                                else {
                                    if (blobChar < 'A' || blobChar > 'F')
                                        return Rtf_ErrorRtf.INVALID_HEX;
                                    b += 10 + blobChar.charCodeAt(0) - 'A'.charCodeAt(0);
                                }
                            }
                            cNibble--;
                            if (cNibble === 0) {
                                if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                                    charset = this.getCharset(this._fontNum);
                                    if (!skipParseChar && Rtf.is1stByte(b, charset)) {
                                        dbcsBytes[0] = b;
                                        dbcsBytes[1] = 0;
                                        skipParseChar = true;
                                    }
                                    else {
                                        if (skipParseChar && Rtf.is2ndByte(b, charset))
                                            dbcsBytes[1] = b;
                                        else {
                                            dbcsBytes[0] = b;
                                            dbcsBytes[1] = 0;
                                        }
                                        codePage = this.getCodePage(charset);
                                        let workStr = Encoding.GetEncoding(codePage).GetString(dbcsBytes, 0, 2);
                                        b = workStr.charCodeAt(0);
                                        skipParseChar = false;
                                    }
                                }
                                if (!skipParseChar) {
                                    if ((ec = this.ParseChar(String.fromCharCode(b), outputTxt)) !== Rtf_ErrorRtf.OK)
                                        return ec;
                                }
                                cNibble = 2;
                                b = 0;
                                this._internalState = Rtf_RIS.NORM;
                            }
                        }
                        break;
                }
            }
        }
        if (this._group < 0)
            return Rtf_ErrorRtf.STACK_UNDERFLOW;
        if (this._group > 0)
            return Rtf_ErrorRtf.UNMATCHED_BRACE;
        currPos = outputTxt.Length;
        if (currPos >= 3 && (outputTxt.get_Item(currPos - 3) === Rtf_RtfChar.CR && outputTxt.get_Item(currPos - 2) === Rtf_RtfChar.LF && outputTxt.get_Item(currPos - 1) === Rtf_RtfChar.CR || outputTxt.get_Item(currPos - 3) === Rtf_RtfChar.LF && outputTxt.get_Item(currPos - 2) === Rtf_RtfChar.CR && outputTxt.get_Item(currPos - 1) === Rtf_RtfChar.CR))
            outputTxt.Remove(currPos - 3, 3);
        return Rtf_ErrorRtf.OK;
    }
    ParseChar(ch, outputTxt) {
        let ret = Rtf_ErrorRtf.OK;
        if (this._internalState === Rtf_RIS.BIN && --this._cbBin <= 0) {
            this._internalState = Rtf_RIS.NORM;
        }
        if (this._destState === Rtf_RDS.SKIP) {
        }
        else if (this._destState === Rtf_RDS.NORM) {
            ret = this.PrintChar(ch, outputTxt);
        }
        else {
        }
        return ret;
    }
    PrintChar(ch, outputTxt) {
        if ((ch >= ' ' || ch === Rtf_RtfChar.CR || ch === Rtf_RtfChar.LF) && ch !== String.fromCharCode(183)) {
            outputTxt.Append(ch);
        }
        if (ch >= ' ') {
            this._outputOnce = true;
        }
        return Rtf_ErrorRtf.OK;
    }
    PushState() {
        let stackSave = new Rtf_StackSave();
        if (stackSave === null) {
            return Rtf_ErrorRtf.STACK_OVERFLOW;
        }
        stackSave.rds = this._destState;
        stackSave.ris = this._internalState;
        this._internalState = Rtf_RIS.NORM;
        this._stack.push(stackSave);
        this._group++;
        return Rtf_ErrorRtf.OK;
    }
    PopState() {
        let savedPop = this._stack.pop();
        if (savedPop === null) {
            return Rtf_ErrorRtf.STACK_UNDERFLOW;
        }
        this._destState = savedPop.rds;
        this._internalState = savedPop.ris;
        this._group--;
        return Rtf_ErrorRtf.OK;
    }
    ParseKeyword(rtfTxt, outputTxt) {
        let ch;
        let fNeg = false;
        let szKeyword = "";
        let szParameter = "";
        if ((ch = rtfTxt[this._index++]) === String.fromCharCode(0)) {
            return Rtf_ErrorRtf.END_OF_FILE;
        }
        if (!NChar.IsLetter(ch)) {
            szKeyword = szKeyword + ch;
            return this.TranslateKeyword(szKeyword, outputTxt);
        }
        for (; NChar.IsLetter(ch); ch = rtfTxt[this._index++])
            szKeyword = szKeyword + ch;
        if (ch === '-') {
            fNeg = true;
            if ((ch = rtfTxt[this._index++]) === String.fromCharCode(0))
                return Rtf_ErrorRtf.END_OF_FILE;
        }
        if (NChar.IsDigit(ch)) {
            for (; NChar.IsDigit(ch); ch = rtfTxt[this._index++])
                szParameter = szParameter + ch;
            this._lParam = NNumber.Parse(szParameter);
            if (fNeg)
                this._lParam = -this._lParam;
        }
        if (ch !== ' ')
            this._index--;
        if (szKeyword === Rtf.CHAR_PAR) {
            if (rtfTxt[this._index] === Rtf_RtfChar.CR && rtfTxt[this._index + 1] === Rtf_RtfChar.LF)
                this._processCrlfSpecial = true;
        }
        if (this._processCrlfSpecial) {
            return Rtf_ErrorRtf.OK;
        }
        else {
            return this.TranslateKeyword(szKeyword, outputTxt);
        }
    }
    TranslateKeyword(szKeyword, outputTxt) {
        let result = Rtf_ErrorRtf.OK;
        let isym;
        for (isym = 0; isym < Rtf.rgsymRtf.length; isym++) {
            if (szKeyword === Rtf.rgsymRtf[isym].szKeyword) {
                break;
            }
        }
        if (isym === Rtf.rgsymRtf.length) {
            if (this._skipDestIfUnk) {
                this._destState = Rtf_RDS.SKIP;
            }
            this._skipDestIfUnk = false;
        }
        else {
            result = Rtf_ErrorRtf.BAD_TABLE;
            this._skipDestIfUnk = false;
            if (Rtf.rgsymRtf[isym].kwd === Rtf_KWD.PROP) {
                result = this.validateProp(Rtf.rgsymRtf[isym].idxInRgprop);
            }
            else if (Rtf.rgsymRtf[isym].kwd === Rtf_KWD.CHAR) {
                result = this.ParseChar((Rtf.rgsymRtf[isym].idxInRgprop), outputTxt);
            }
            else if (Rtf.rgsymRtf[isym].kwd === Rtf_KWD.DEST) {
                result = this.changeDestState();
            }
            else if (Rtf.rgsymRtf[isym].kwd === Rtf_KWD.SPEC) {
                result = this.ParseSpecialKeyword(Rtf.rgsymRtf[isym].idxInRgprop);
            }
        }
        return result;
    }
    validateProp(iprop) {
        let ret = Rtf_ErrorRtf.OK;
        if (this._destState === Rtf_RDS.SKIP) {
            return ret;
        }
        if (Rtf.rgprop[iprop].prop !== Rtf_PROPTYPE.DOP && Rtf.rgprop[iprop].prop !== Rtf_PROPTYPE.SEP &&
            Rtf.rgprop[iprop].prop !== Rtf_PROPTYPE.PAP && Rtf.rgprop[iprop].prop !== Rtf_PROPTYPE.CHP &&
            Rtf.rgprop[iprop].actn !== Rtf_ACTN.SPEC) {
            ret = Rtf_ErrorRtf.BAD_TABLE;
        }
        if (Rtf.rgprop[iprop].actn !== Rtf_ACTN.BYTE && Rtf.rgprop[iprop].actn !== Rtf_ACTN.WORD && Rtf.rgprop[iprop].actn !== Rtf_ACTN.SPEC) {
            ret = Rtf_ErrorRtf.BAD_TABLE;
        }
        return ret;
    }
    changeDestState() {
        if (this._destState === Rtf_RDS.SKIP) {
            return Rtf_ErrorRtf.OK;
        }
        this._destState = Rtf_RDS.SKIP;
        return Rtf_ErrorRtf.OK;
    }
    ParseSpecialKeyword(ipfn) {
        let ret = Rtf_ErrorRtf.OK;
        if (!UtilStrByteMode.isLocaleDefLangDBCS()) {
            if (this._destState === Rtf_RDS.SKIP && ipfn !== Rtf_IPFN.BIN) {
                return ret;
            }
            if (ipfn === Rtf_IPFN.FONT || ipfn === Rtf_IPFN.CHARSET || ipfn === Rtf_IPFN.UNICODE) {
                return ret;
            }
        }
        else {
            if (this._destState === Rtf_RDS.SKIP && ipfn !== Rtf_IPFN.BIN && ipfn !== Rtf_IPFN.FONT &&
                ipfn !== Rtf_IPFN.CHARSET && ipfn !== Rtf_IPFN.UNICODE) {
                return ret;
            }
        }
        if (ipfn === Rtf_IPFN.BIN) {
            this._internalState = Rtf_RIS.BIN;
            this._cbBin = this._lParam;
        }
        else if (ipfn === Rtf_IPFN.SKIP_DEST) {
            this._skipDestIfUnk = true;
        }
        else if (ipfn === Rtf_IPFN.HEX) {
            this._internalState = Rtf_RIS.HEX;
        }
        else if (ipfn === Rtf_IPFN.FONT) {
            this._fontNum = this._lParam;
        }
        else if (ipfn === Rtf_IPFN.CHARSET) {
            this._charsetTable.set_Item(this._fontNum, this._lParam);
        }
        else if (ipfn === Rtf_IPFN.UNICODE) {
            this._internalState = Rtf_RIS.UNICODE;
        }
        else {
            ret = Rtf_ErrorRtf.BAD_TABLE;
        }
        return ret;
    }
    static is1stByte(dbcsBytes, charset) {
        let ret = false;
        if (dbcsBytes > 255)
            return ret;
        switch (charset) {
            case 128:
                ret = (129 <= dbcsBytes && dbcsBytes <= 159) || (224 <= dbcsBytes && dbcsBytes <= 254);
                break;
            case 129:
            case 134:
            case 136:
                ret = (129 <= dbcsBytes);
                break;
            default:
                break;
        }
        return ret;
    }
    static is2ndByte(dbcsBytes, charset) {
        let ret = false;
        if (dbcsBytes > 255)
            return ret;
        switch (charset) {
            case 128:
                ret = (dbcsBytes !== 127) && (64 <= dbcsBytes && dbcsBytes <= 252);
                break;
            case 129:
            case 134:
            case 136:
                ret = (64 <= dbcsBytes);
                break;
            default:
                break;
        }
        return ret;
    }
    setCodePageTable() {
        this._codePageTable.set_Item(0, 1252);
        this._codePageTable.set_Item(128, 932);
        this._codePageTable.set_Item(129, 949);
        this._codePageTable.set_Item(134, 936);
        this._codePageTable.set_Item(136, 950);
        this._codePageTable.set_Item(161, 1253);
        this._codePageTable.set_Item(162, 1254);
        this._codePageTable.set_Item(177, 1255);
        this._codePageTable.set_Item(178, 1256);
        this._codePageTable.set_Item(186, 1257);
        this._codePageTable.set_Item(204, 1251);
        this._codePageTable.set_Item(222, 874);
        this._codePageTable.set_Item(238, 1250);
    }
    getCodePage(charset) {
        let codePage = 0;
        if (this._codePageTable.ContainsKey(charset)) {
            codePage = this._codePageTable.get_Item(charset);
        }
        return codePage;
    }
    getCharset(font) {
        let charset = 0;
        if (this._charsetTable.ContainsKey(font)) {
            charset = this._charsetTable.get_Item(font);
        }
        return charset;
    }
}
Rtf.RTF_PREFIX = "{\\rtf";
Rtf.CHAR_PAR = "par";
Rtf.rgprop = [
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.PAP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.PAP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.PAP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.SEP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.SEP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.SEP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.SEP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.SEP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.DOP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.PAP), new Rtf_PROP(Rtf_ACTN.SPEC, Rtf_PROPTYPE.PAP),
    new Rtf_PROP(Rtf_ACTN.SPEC, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.SPEC, Rtf_PROPTYPE.SEP)
];
Rtf.rgsymRtf = [
    new Rtf_SYMBOL("b", Rtf_KWD.PROP, Rtf_IPROP.BOLD), new Rtf_SYMBOL("ul", Rtf_KWD.PROP, Rtf_IPROP.UNDERLINE),
    new Rtf_SYMBOL("i", Rtf_KWD.PROP, Rtf_IPROP.ITALIC), new Rtf_SYMBOL("li", Rtf_KWD.PROP, Rtf_IPROP.LEFT_IND),
    new Rtf_SYMBOL("ri", Rtf_KWD.PROP, Rtf_IPROP.RIGHT_IND), new Rtf_SYMBOL("fi", Rtf_KWD.PROP, Rtf_IPROP.FIRST_IND),
    new Rtf_SYMBOL("cols", Rtf_KWD.PROP, Rtf_IPROP.COLS), new Rtf_SYMBOL("sbknone", Rtf_KWD.PROP, Rtf_IPROP.SBK),
    new Rtf_SYMBOL("sbkcol", Rtf_KWD.PROP, Rtf_IPROP.SBK), new Rtf_SYMBOL("sbkeven", Rtf_KWD.PROP, Rtf_IPROP.SBK),
    new Rtf_SYMBOL("sbkodd", Rtf_KWD.PROP, Rtf_IPROP.SBK), new Rtf_SYMBOL("sbkpage", Rtf_KWD.PROP, Rtf_IPROP.SBK),
    new Rtf_SYMBOL("pgnx", Rtf_KWD.PROP, Rtf_IPROP.PGN_X), new Rtf_SYMBOL("pgny", Rtf_KWD.PROP, Rtf_IPROP.PGN_Y),
    new Rtf_SYMBOL("pgndec", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT), new Rtf_SYMBOL("pgnucrm", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT),
    new Rtf_SYMBOL("pgnlcrm", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT), new Rtf_SYMBOL("pgnucltr", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT),
    new Rtf_SYMBOL("pgnlcltr", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT), new Rtf_SYMBOL("qc", Rtf_KWD.PROP, Rtf_IPROP.JUST),
    new Rtf_SYMBOL("ql", Rtf_KWD.PROP, Rtf_IPROP.JUST), new Rtf_SYMBOL("qr", Rtf_KWD.PROP, Rtf_IPROP.JUST),
    new Rtf_SYMBOL("qj", Rtf_KWD.PROP, Rtf_IPROP.JUST), new Rtf_SYMBOL("paperw", Rtf_KWD.PROP, Rtf_IPROP.XA_PAGE),
    new Rtf_SYMBOL("paperh", Rtf_KWD.PROP, Rtf_IPROP.YA_PAGE), new Rtf_SYMBOL("margl", Rtf_KWD.PROP, Rtf_IPROP.XA_LEFT),
    new Rtf_SYMBOL("margr", Rtf_KWD.PROP, Rtf_IPROP.XA_RIGHT), new Rtf_SYMBOL("margt", Rtf_KWD.PROP, Rtf_IPROP.YA_TOP),
    new Rtf_SYMBOL("margb", Rtf_KWD.PROP, Rtf_IPROP.YA_BOTTOM), new Rtf_SYMBOL("pgnstart", Rtf_KWD.PROP, Rtf_IPROP.PGN_START),
    new Rtf_SYMBOL("facingp", Rtf_KWD.PROP, Rtf_IPROP.FACING_P), new Rtf_SYMBOL("landscape", Rtf_KWD.PROP, Rtf_IPROP.LANDSCAPE),
    new Rtf_SYMBOL("par", Rtf_KWD.CHAR, Rtf_RtfChar.LF), new Rtf_SYMBOL("\0x0a", Rtf_KWD.CHAR, Rtf_RtfChar.LF),
    new Rtf_SYMBOL("\0x0d", Rtf_KWD.CHAR, Rtf_RtfChar.LF), new Rtf_SYMBOL("tab", Rtf_KWD.CHAR, Rtf_RtfChar.TAB),
    new Rtf_SYMBOL("ldblquote", Rtf_KWD.CHAR, Rtf_RtfChar.DBLQUOTE), new Rtf_SYMBOL("rdblquote", Rtf_KWD.CHAR, Rtf_RtfChar.DBLQUOTE),
    new Rtf_SYMBOL("lquote", Rtf_KWD.CHAR, Rtf_RtfChar.QUOTE), new Rtf_SYMBOL("rquote", Rtf_KWD.CHAR, Rtf_RtfChar.QUOTE),
    new Rtf_SYMBOL("bullet", Rtf_KWD.CHAR, Rtf_RtfChar.BULLET), new Rtf_SYMBOL("endash", Rtf_KWD.CHAR, Rtf_RtfChar.DASH_CHAR),
    new Rtf_SYMBOL("emdash", Rtf_KWD.CHAR, Rtf_RtfChar.DASH_CHAR), new Rtf_SYMBOL("~", Rtf_KWD.CHAR, Rtf_RtfChar.TILDA),
    new Rtf_SYMBOL("-", Rtf_KWD.CHAR, Rtf_RtfChar.DASH), new Rtf_SYMBOL("{", Rtf_KWD.CHAR, Rtf_RtfChar.OPENINGBRACE),
    new Rtf_SYMBOL("}", Rtf_KWD.CHAR, Rtf_RtfChar.CLOSINGBRACE), new Rtf_SYMBOL("\\", Rtf_KWD.CHAR, Rtf_RtfChar.BACKSLASH),
    new Rtf_SYMBOL("bin", Rtf_KWD.SPEC, Rtf_IPFN.BIN), new Rtf_SYMBOL("*", Rtf_KWD.SPEC, Rtf_IPFN.SKIP_DEST),
    new Rtf_SYMBOL("'", Rtf_KWD.SPEC, Rtf_IPFN.HEX), new Rtf_SYMBOL("f", Rtf_KWD.SPEC, Rtf_IPFN.FONT),
    new Rtf_SYMBOL("fcharset", Rtf_KWD.SPEC, Rtf_IPFN.CHARSET), new Rtf_SYMBOL("u", Rtf_KWD.SPEC, Rtf_IPFN.UNICODE),
    new Rtf_SYMBOL("author", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("buptim", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("colortbl", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("comment", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("creatim", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("doccomm", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("fonttbl", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("footer", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("footerf", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("footerl", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("footerr", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("footnote", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("ftncn", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("ftnsep", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("ftnsepc", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("header", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("headerf", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("headerl", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("headerr", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("info", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("keywords", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("operator", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("pict", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("printim", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("private1", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("revtim", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("rxe", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("stylesheet", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("subject", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("tc", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("title", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("txe", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("xe", Rtf_KWD.DEST, Rtf_IDEST.SKIP)
];
//# sourceMappingURL=data:application/json;base64,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