import { StorageAttribute } from "./enums";
export class StorageAttributeCheck {
    static isTheSameType(type1, type2) {
        return type1 === type2 || (StorageAttributeCheck.isTypeNumeric(type1) && StorageAttributeCheck.isTypeNumeric(type2)) || (StorageAttributeCheck.isTypeLogical(type1) && StorageAttributeCheck.isTypeLogical(type2)) || (StorageAttributeCheck.IsTypeAlphaOrUnicode(type1) && StorageAttributeCheck.IsTypeAlphaOrUnicode(type2)) || (StorageAttributeCheck.isTypeBlob(type1) && StorageAttributeCheck.isTypeBlob(type2)) || (StorageAttributeCheck.isTypeDotNet(type1) && StorageAttributeCheck.isTypeDotNet(type2));
    }
    static isTypeBlob(type) {
        return type === StorageAttribute.BLOB || type === StorageAttribute.BLOB_VECTOR;
    }
    static isTypeAlpha(type) {
        return type === StorageAttribute.ALPHA || type === StorageAttribute.MEMO;
    }
    static isTypeNumeric(type) {
        return type === StorageAttribute.DATE || type === StorageAttribute.TIME || type === StorageAttribute.NUMERIC;
    }
    static isTypeLogical(type) {
        return type === StorageAttribute.BOOLEAN;
    }
    static isTypeDotNet(type) {
        return type === StorageAttribute.DOTNET;
    }
    static IsTypeAlphaOrUnicode(type) {
        return type === StorageAttribute.ALPHA || type === StorageAttribute.UNICODE;
    }
    static StorageFldAlphaOrUnicode(type1, type2) {
        return StorageAttributeCheck.IsTypeAlphaOrUnicode(type1) && StorageAttributeCheck.IsTypeAlphaOrUnicode(type2);
    }
    static StorageFldAlphaUnicodeOrBlob(type1, type2) {
        let type1AlphaOrUnicode = StorageAttributeCheck.IsTypeAlphaOrUnicode(type1);
        let type2AlphaOrUnicode = StorageAttributeCheck.IsTypeAlphaOrUnicode(type2);
        if (type1AlphaOrUnicode && type2AlphaOrUnicode) {
            return true;
        }
        else {
            let type1Blob = type1 === StorageAttribute.BLOB;
            let type2Blob = type2 === StorageAttribute.BLOB;
            return ((type1AlphaOrUnicode && type2Blob) || (type2AlphaOrUnicode && type1Blob));
        }
    }
    static IsTypeCompatibile(sourceAttribute, destinationAttribute) {
        let isTypeCompatible = false;
        switch (sourceAttribute) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                if (destinationAttribute === StorageAttribute.ALPHA || destinationAttribute === StorageAttribute.UNICODE ||
                    destinationAttribute === StorageAttribute.DATE || destinationAttribute === StorageAttribute.TIME ||
                    destinationAttribute === StorageAttribute.NUMERIC) {
                    isTypeCompatible = true;
                }
                break;
            case StorageAttribute.NUMERIC:
                if (destinationAttribute === StorageAttribute.NUMERIC || destinationAttribute === StorageAttribute.ALPHA ||
                    destinationAttribute === StorageAttribute.UNICODE || destinationAttribute === StorageAttribute.BOOLEAN ||
                    destinationAttribute === StorageAttribute.DATE || destinationAttribute === StorageAttribute.TIME) {
                    isTypeCompatible = true;
                }
                break;
            case StorageAttribute.BOOLEAN:
                {
                    if (destinationAttribute === StorageAttribute.BOOLEAN || destinationAttribute === StorageAttribute.ALPHA ||
                        destinationAttribute === StorageAttribute.UNICODE || destinationAttribute === StorageAttribute.NUMERIC) {
                        isTypeCompatible = true;
                    }
                }
                break;
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                if (destinationAttribute === StorageAttribute.ALPHA || destinationAttribute === StorageAttribute.UNICODE ||
                    destinationAttribute === StorageAttribute.NUMERIC || destinationAttribute === StorageAttribute.BOOLEAN ||
                    destinationAttribute === StorageAttribute.DATE || destinationAttribute === StorageAttribute.TIME) {
                    isTypeCompatible = true;
                }
                break;
            case StorageAttribute.BLOB:
                if (destinationAttribute === StorageAttribute.BLOB) {
                    isTypeCompatible = true;
                }
                break;
        }
        return isTypeCompatible;
    }
    constructor() {
    }
}
//# sourceMappingURL=data:application/json;base64,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