import { NString, RefParam, StringBuilder, isNullOrUndefined } from "@magic-xpa/mscorelib";
import { UtilStrByteMode } from "./UtilStrByteMode";
import { Rtf } from "./Rtf";
const HTML_BACKSLASH = "&#092;";
const HTML_COMMA = "&#044;";
const HTML_HYPHEN = "&#045;";
const STR_2_HTML = 1;
const TASK_PATH_DELIMITER = "@@||@@";
export const SEQ_2_HTML = 2;
export const HTML_2_STR = 3;
const HTML_2_SEQ = 4;
export const SEQ_2_STR = 5;
export class StrUtil {
    static mem_trim(str, len) {
        let result;
        if (len > 0) {
            if (len > str.length) {
                result = -1;
                return result;
            }
            while (len > 0 && str[len - 1] === ' ') {
                len = len - 1;
            }
        }
        result = len;
        return result;
    }
    static memmove(dest, destCount, src, srcCount, len) {
        let stringBuilder = new StringBuilder(dest.length + len);
        if (UtilStrByteMode.isLocaleDefLangJPN() && dest.length < destCount) {
            stringBuilder.Append(NString.FromChar(' ', destCount));
        }
        else {
            stringBuilder.Append(dest.substr(0, destCount));
        }
        stringBuilder.Append(src.substr(srcCount, len));
        if (stringBuilder.Length < dest.length) {
            stringBuilder.Append(dest.substr(stringBuilder.Length));
        }
        return stringBuilder.ToString();
    }
    static memcpy(dest, destCount, src, scrCountOrSrcCount, count) {
        if (arguments.length === 5 && (dest === null || dest.constructor === String) && (destCount === null || destCount.constructor === Number) && (src === null || src.constructor === String) && (scrCountOrSrcCount === null || scrCountOrSrcCount.constructor === Number) && (count === null || count.constructor === Number)) {
            return StrUtil.memcpy_0(dest, destCount, src, scrCountOrSrcCount, count);
        }
        StrUtil.memcpy_1(dest, destCount, src, scrCountOrSrcCount, count);
    }
    static memcpy_0(dest, destCount, src, scrCount, count) {
        let stringBuilder = new StringBuilder(dest.substr(0, destCount));
        if (scrCount + count < src.length) {
            stringBuilder.Append(src.substr(scrCount, count - scrCount));
        }
        else {
            stringBuilder.Append(src.substr(scrCount));
        }
        let size = dest.length - destCount - count;
        if (size > 0) {
            stringBuilder.Append(dest.substr(destCount + count));
        }
        return stringBuilder.ToString();
    }
    static memcpy_1(dest, destCount, src, srcCount, count) {
        while (count > 0 && destCount < dest.length && srcCount < src.length) {
            dest[destCount++] = src[srcCount++];
            count = count - 1;
        }
    }
    static memset(dest, destCount, inVal, counter) {
        if (arguments.length === 4 && (dest === null || dest.constructor === String) && (destCount === null || destCount.constructor === Number) && (inVal === null || inVal.constructor === Number) && (counter === null || counter.constructor === Number)) {
            return StrUtil.memset_0(dest, destCount, inVal, counter);
        }
        StrUtil.memset_1(dest, destCount, inVal, counter);
    }
    static memset_0(dest, destCount, inVal, counter) {
        let first = new StringBuilder(dest.substr(0, destCount));
        while (counter > 0) {
            first.Append(inVal);
            counter = counter - 1;
        }
        if (first.Length < dest.length) {
            first.Append(dest.substr(first.Length));
        }
        return first.ToString();
    }
    static memset_1(dest, destCount, inVal, counter) {
        while (counter > 0 && destCount < dest.length) {
            dest[destCount++] = inVal;
            counter = counter - 1;
        }
    }
    static strstr(str, substr) {
        let from = str.indexOf(substr);
        let result;
        if (from < 0) {
            result = null;
        }
        else {
            result = str.substr(from);
        }
        return result;
    }
    static ReverseString(text) {
        let array = NString.ToCharArray(text.ToString());
        array.reverse();
        return new StringBuilder(NString.FromChars(array));
    }
    static rtrim(str) {
        return StrUtil.rtrimWithNull(str, false);
    }
    static rtrimWithNull(str, trimNullChars) {
        let result;
        if (typeof str === "undefined" || str === null || str.length === 0) {
            result = str;
        }
        else {
            let idx = str.length - 1;
            if (trimNullChars) {
                while (idx >= 0 && (str[idx] === ' ' || str[idx] === String.fromCharCode(0))) {
                    idx = idx - 1;
                }
            }
            else {
                while (idx >= 0 && str[idx] === ' ') {
                    idx = idx - 1;
                }
            }
            idx = idx + 1;
            if (idx < str.length) {
                result = str.substr(0, idx);
            }
            else {
                result = str;
            }
        }
        return result;
    }
    static ltrim(str) {
        let length = str.length;
        let i = 0;
        let result;
        if (str === null || length === 0) {
            result = str;
        }
        else {
            while (i < length && str[i] === ' ') {
                i = i + 1;
            }
            if (i > 0) {
                str = str.substr(i);
            }
            result = str;
        }
        return result;
    }
    static DeleteStringsFromEnds(str, strToDelete) {
        if (str.startsWith(strToDelete)) {
            str = str.substr(strToDelete.length);
        }
        if (str.endsWith(strToDelete)) {
            str = str.substr(0, str.length - strToDelete.length);
        }
        let result;
        if (str.length === 0) {
            result = null;
        }
        else {
            result = str;
        }
        return result;
    }
    static padStr(str, len) {
        let padLen = len - str.length;
        if (padLen > 0) {
            if (StrUtil._paddingSpaces === null || StrUtil._paddingSpaces.length < padLen) {
                StrUtil._paddingSpaces = NString.FromChar(' ', padLen);
            }
            let stringBuilder = new StringBuilder(len);
            stringBuilder.Append(str);
            stringBuilder.Append(StrUtil._paddingSpaces, 0, padLen);
            str = stringBuilder.ToString();
        }
        return str;
    }
    static tokenize(source, delim) {
        return source.split(delim);
    }
    static stringToHexaDump(str, minLength) {
        let stringBuilder = new StringBuilder(str.length * minLength);
        for (let indx = 0; indx < str.length; indx = indx + 1) {
            let currInt = str.charCodeAt(indx);
            let hexStr = currInt.toString(16);
            while (hexStr.length < minLength) {
                hexStr = "0" + hexStr;
            }
            stringBuilder.Append(hexStr);
        }
        return stringBuilder.ToString().toUpperCase();
    }
    static searchAndReplace(str, from, to) {
        if (arguments.length === 3 && (str === null || str.constructor === String) && (from === null || from.constructor === String) && (to === null || to.constructor === String)) {
            return StrUtil.searchAndReplace_0(str, from, to);
        }
        return StrUtil.searchAndReplace_1(str, from, to);
    }
    static searchAndReplace_0(str, from, to) {
        let lastSubStr = 0;
        let startSubStr;
        let result;
        if ((startSubStr = str.indexOf(from)) === -1) {
            result = str;
        }
        else {
            let stringBuilder = new StringBuilder(str.length);
            while (startSubStr !== -1) {
                stringBuilder.Append(str.substr(lastSubStr, startSubStr - lastSubStr) + to);
                startSubStr = startSubStr + from.length;
                lastSubStr = startSubStr;
                startSubStr = str.indexOf(from, lastSubStr);
            }
            stringBuilder.Append(str.substr(lastSubStr));
            result = stringBuilder.ToString();
        }
        return result;
    }
    static searchAndReplace_1(str, from, to) {
        let lastSubStr = 0;
        let sarIndex = 0;
        let fromCopy = from.slice();
        let startSubStr;
        let SARindex = new RefParam(0);
        startSubStr = StrUtil.indexOf(str, fromCopy, lastSubStr, SARindex);
        sarIndex = SARindex.value;
        if (startSubStr === -1)
            return str;
        let result;
        let tmpBuf = new StringBuilder(str.length);
        while (startSubStr !== -1) {
            tmpBuf.Append(str.substr(lastSubStr, startSubStr - lastSubStr) + to[sarIndex]);
            startSubStr += fromCopy[sarIndex].length;
            lastSubStr = startSubStr;
            startSubStr = StrUtil.indexOf(str, fromCopy, lastSubStr, SARindex);
            sarIndex = SARindex.value;
        }
        ;
        tmpBuf.Append(str.substr(lastSubStr));
        result = tmpBuf.ToString();
        return result;
    }
    static indexOf(str, strings, offset, SARindex) {
        let minOffset = -1;
        for (let i = 0; i < strings.length; i = i + 1) {
            if (!(strings[i] === null)) {
                let resultOffset = str.indexOf(strings[i], offset);
                if (resultOffset === -1) {
                    strings[i] = null;
                }
                else {
                    if (resultOffset < minOffset || minOffset === -1) {
                        minOffset = resultOffset;
                        SARindex.value = i;
                    }
                }
            }
        }
        let result;
        if (minOffset > -1) {
            result = minOffset;
        }
        else {
            SARindex.value = -1;
            result = -1;
        }
        return result;
    }
    static replaceStringTokens(userString, token, occurrence, val) {
        let tokenLen = token.length;
        let currPosition = 0;
        let newString = userString;
        if (val !== null) {
            let num2 = 0;
            while (num2 < occurrence && currPosition !== -1) {
                currPosition = userString.indexOf(token, currPosition + ((num2 === 0) ? 0 : tokenLen));
                num2 = num2 + 1;
            }
            if (currPosition !== -1) {
                newString = userString.substr(0, currPosition) + val + userString.substr(currPosition + tokenLen, userString.length - (currPosition + tokenLen));
            }
        }
        return newString;
    }
    static makePrintableTokens(source, type) {
        if (arguments.length === 2 && (source === null || source.constructor === String) && (type === null || type.constructor === Number)) {
            return StrUtil.makePrintableTokens_0(source, type);
        }
        StrUtil.makePrintableTokens_1(source, type);
    }
    static makePrintableTokens_0(source, type) {
        let escStr = [
            "\\", "-", ","
        ];
        let escSeq = [
            "\\\\", "\\-", "\\,"
        ];
        let escHtm = [
            HTML_BACKSLASH, HTML_HYPHEN, HTML_COMMA
        ];
        let result;
        switch (type) {
            case STR_2_HTML:
                result = StrUtil.searchAndReplace(source, escStr, escHtm);
                break;
            case SEQ_2_HTML:
                result = StrUtil.searchAndReplace(source, escSeq, escHtm);
                break;
            case HTML_2_SEQ:
                result = StrUtil.searchAndReplace(source, escHtm, escSeq);
                break;
            case HTML_2_STR:
                result = StrUtil.searchAndReplace(source, escHtm, escStr);
                break;
            case SEQ_2_STR:
                result = StrUtil.searchAndReplace(source, escSeq, escStr);
                break;
            default:
                result = source;
                break;
        }
        return result;
    }
    static makePrintableTokens_1(source, type) {
        if (source !== null) {
            let length = source.length;
            for (let i = 0; i < length; i = i + 1) {
                let currElm = source.get_Item(i);
                source.set_Item(i, StrUtil.makePrintableTokens_0(currElm, type));
            }
        }
    }
    static makePrintable(source) {
        let from = [
            "\n", "\r", "'", "\\", "\"", "\0"
        ];
        let to = [
            "\\n", "\\r", "\\'", "\\\\", "\\\"", "\\0"
        ];
        return StrUtil.searchAndReplace(source, from, to);
    }
    static makePrintable2(source) {
        let from = [
            "\n", "\r", "\0"
        ];
        let to = [
            "\\n", "\\r", "\\0"
        ];
        return StrUtil.searchAndReplace(source, from, to);
    }
    static ZstringMake(s, len) {
        len = StrUtil.mem_trim(s, len);
        return s.substr(0, len);
    }
    static GetPlainTextfromRtf(rtfText) {
        if (Rtf.isRtf(rtfText)) {
            let rtf = new Rtf();
            let outputTxt = new StringBuilder("");
            rtf.toTxt(rtfText, outputTxt);
            rtfText = outputTxt.ToString();
        }
        return rtfText;
    }
    static StringsArraysEqual(str1, str2) {
        let result;
        if (str1 === null && str2 === null) {
            result = true;
        }
        else {
            if (str1 === null || str2 === null) {
                result = false;
            }
            else {
                if (str1.length !== str2.length) {
                    result = false;
                }
                else {
                    for (let index = 0; index < str1.length; index = index + 1) {
                        if ((str1[index] !== str2[index])) {
                            result = false;
                            return result;
                        }
                    }
                    result = true;
                }
            }
        }
        return result;
    }
    static SearchAndReplaceWildChars(buf, len, filler) {
        buf = NString.PadRight(buf, len);
        let escChar = false;
        let tmpBuf = new StringBuilder(len);
        for (let i = 0; i < len; i = i + 1) {
            switch (buf[i]) {
                case ('\\'):
                    {
                        let isNextCharWild = true;
                        if ((i + 1 < len) && (buf[i + 1] != '*' && buf[i + 1] != '\\'))
                            isNextCharWild = false;
                        if (escChar || !isNextCharWild)
                            tmpBuf.Append(buf[i]);
                        escChar = !escChar;
                    }
                    break;
                case ('*'):
                    if (escChar)
                        tmpBuf.Append(buf[i]);
                    else {
                        tmpBuf.Append(filler, len - tmpBuf.Length);
                    }
                    escChar = false;
                    break;
                case '?':
                    tmpBuf.Append(filler);
                    escChar = false;
                    break;
                default:
                    tmpBuf.Append(buf[i]);
                    escChar = false;
                    break;
            }
        }
        let text = tmpBuf.ToString();
        return NString.TrimEnd(NString.TrimEnd(text, ['\0']));
    }
    static getConsoleErorString(source) {
        let consoleErorString = "";
        if (!isNullOrUndefined(source))
            consoleErorString = this.searchAndReplace(source, TASK_PATH_DELIMITER, "");
        return consoleErorString;
    }
    static getMsgBoxErorString(source) {
        let tokens;
        let msgBoxErorString = new StringBuilder("");
        if (!isNullOrUndefined(source)) {
            tokens = this.tokenize(source, TASK_PATH_DELIMITER);
            for (let i = 0; i < tokens.length; i++) {
                msgBoxErorString.Append(tokens[i]);
                i++;
            }
        }
        return msgBoxErorString.toString();
    }
}
StrUtil._paddingSpaces = null;
//# sourceMappingURL=data:application/json;base64,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