import { PICInterface } from "./PICInterface";
import { UtilStrByteMode } from "./UtilStrByteMode";
import { NNumber } from "@magic-xpa/mscorelib";
const MAX_GENGO = 6;
export class UtilDateJpn {
    constructor() {
        this.MaxGengo = MAX_GENGO;
    }
    static getInstance() {
        if (UtilDateJpn._instance === null) {
            UtilDateJpn._instance = new UtilDateJpn();
        }
        return UtilDateJpn._instance;
    }
    static getArrayDow() {
        return UtilDateJpn.JweekStr;
    }
    static getStrDow(intIdx) {
        let flag = intIdx < 0 || 7 < intIdx;
        if (flag) {
            intIdx = 0;
        }
        return UtilDateJpn.JweekStr[intIdx];
    }
    static convertStrMonth(month) {
        let flag = month < 0 || 12 < month;
        if (flag) {
            month = 0;
        }
        return UtilDateJpn.JmonthStr[month];
    }
    date_jpn_year_ofs(intYear, intDoy) {
        let result;
        if (intYear < 1 || intDoy < 1) {
            result = 0;
        }
        else {
            let num = this.MaxGengo - 1;
            while (intYear < UtilDateJpn.StartDayOfGengo[num][0]) {
                num = num - 1;
            }
            if (intYear === UtilDateJpn.StartDayOfGengo[num][0] && intDoy < UtilDateJpn.StartDayOfGengo[num][3]) {
                num = num - 1;
            }
            result = intYear - UtilDateJpn.StartDayOfGengo[num][0] + 1;
        }
        return result;
    }
    date_jpn_yr_2_a(intYear, intDoy, isKanji) {
        let num;
        if (intYear < 1 || intDoy < 1) {
            num = 0;
        }
        else {
            num = this.MaxGengo - 1;
            while (intYear < UtilDateJpn.StartDayOfGengo[num][0]) {
                num = num - 1;
            }
            if (intYear === UtilDateJpn.StartDayOfGengo[num][0] && intDoy < UtilDateJpn.StartDayOfGengo[num][3]) {
                num = num - 1;
            }
        }
        let result;
        if (isKanji) {
            result = UtilDateJpn.GengoStr[num][2];
        }
        else {
            result = UtilDateJpn.GengoStr[num][0];
        }
        return result;
    }
    date_jpn_yr_4_a(ucp_str, s_len) {
        let i = this.MaxGengo - 1;
        if (s_len > 0) {
            if (s_len > 1) {
                ucp_str = UtilStrByteMode.leftB(ucp_str, s_len);
            }
            while (i > 0) {
                if (s_len === 1) {
                    if (ucp_str === UtilDateJpn.GengoStr[i][0] || ucp_str === UtilDateJpn.GengoStr[i][1]) {
                        break;
                    }
                }
                else {
                    if (s_len > 1) {
                        let text = UtilStrByteMode.leftB(UtilDateJpn.GengoStr[i][2], s_len);
                        if (ucp_str === text) {
                            break;
                        }
                    }
                }
                i = i - 1;
            }
        }
        let result;
        if (i > 0) {
            result = UtilDateJpn.StartDayOfGengo[i][0];
        }
        else {
            const text = ucp_str.substr(0, 1);
            if (text === " " || text === "?") {
                result = 1;
            }
            else {
                result = 0;
            }
        }
        return result;
    }
    static getEraNameStrInDate(strDate, strPicture, intStartPos) {
        let result = null;
        let intPicIdxOfs = 0;
        let i = intStartPos;
        while (i + intPicIdxOfs < strPicture.length) {
            let intLetters;
            if (strPicture.charCodeAt(i + intPicIdxOfs) === PICInterface.PIC_JY1) {
                intLetters = 1;
            }
            else {
                if (strPicture.charCodeAt(i + intPicIdxOfs) === PICInterface.PIC_JY2) {
                    intLetters = 1;
                }
                else {
                    if (strPicture.charCodeAt(i + intPicIdxOfs) === PICInterface.PIC_JY4) {
                        intLetters = 2;
                    }
                    else {
                        if (i < strDate.length) {
                            if (!UtilStrByteMode.isHalfWidth(strDate[i]) && UtilStrByteMode.isHalfWidth(strPicture[i + intPicIdxOfs])) {
                                intPicIdxOfs = intPicIdxOfs + 1;
                            }
                        }
                        i = i + 1;
                        continue;
                    }
                }
            }
            result = strDate.substr(i, intLetters);
            break;
        }
        return result;
    }
    static getEraNameLenInPicture(strPicture, intStartPos) {
        let intLetters = 0;
        for (let i = intStartPos; i < strPicture.length; i = i + 1) {
            if (strPicture.charCodeAt(i) === PICInterface.PIC_JY1) {
                intLetters = 1;
            }
            else {
                if (strPicture.charCodeAt(i) === PICInterface.PIC_JY2) {
                    intLetters = 2;
                }
                else {
                    if (strPicture.charCodeAt(i) === PICInterface.PIC_JY4) {
                        intLetters = 4;
                    }
                }
            }
            if (intLetters > 0) {
                break;
            }
        }
        return intLetters;
    }
    getStartYearOfEra(strDate, strPicture) {
        let eraNameStrInDate = UtilDateJpn.getEraNameStrInDate(strDate, strPicture, 0);
        let result;
        if (eraNameStrInDate === null) {
            result = 0;
        }
        else {
            let eraNameLenInPicture = UtilDateJpn.getEraNameLenInPicture(strPicture, 0);
            if (eraNameLenInPicture === 0) {
                result = 0;
            }
            else {
                let intStartYearOfEra = this.date_jpn_yr_4_a(eraNameStrInDate, eraNameLenInPicture);
                result = intStartYearOfEra;
            }
        }
        return result;
    }
    addExtraGengo(strExtraGengo) {
        let strGengoInfo = strExtraGengo.split(';');
        for (let i = 0; i < strGengoInfo.length; i = i + 1) {
            if (strGengoInfo[i].length > 0) {
                let strTok = strGengoInfo[i].split(',');
                if (strTok.length === 3 && strTok[0].length > 0 && strTok[1].length > 0 && strTok[2].length > 0) {
                    let strDate = strTok[0].split('/');
                    if (strDate.length === 3 && strDate[0].length > 0 && strDate[1].length > 0 && strDate[2].length > 0) {
                        UtilDateJpn.GengoStr[MAX_GENGO + i][0] = strTok[2].substr(0, 1);
                        UtilDateJpn.GengoStr[MAX_GENGO + i][1] = strTok[2].substr(1, 1);
                        UtilDateJpn.GengoStr[MAX_GENGO + i][2] = strTok[2].substr(2);
                        UtilDateJpn.StartDayOfGengo[MAX_GENGO + i][0] = NNumber.Parse(strDate[0]);
                        UtilDateJpn.StartDayOfGengo[MAX_GENGO + i][1] = NNumber.Parse(strDate[1]);
                        UtilDateJpn.StartDayOfGengo[MAX_GENGO + i][2] = NNumber.Parse(strDate[2]);
                        UtilDateJpn.StartDayOfGengo[MAX_GENGO + i][3] = NNumber.Parse(strTok[1]);
                        this.MaxGengo++;
                    }
                }
            }
        }
    }
}
UtilDateJpn._instance = null;
UtilDateJpn.JweekStr = [
    "   ", "日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"
];
UtilDateJpn.JmonthStr = [
    "", " 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"
];
UtilDateJpn.GengoStr = [
    ["?", "?", "????"],
    ["M", "m", "明治"],
    ["T", "t", "大正"],
    ["S", "s", "昭和"],
    ["H", "h", "平成"],
    ["R", "r", "令和"],
    ["?", "?", "？？"],
    ["?", "?", "？？"],
    ["?", "?", "？？"]
];
UtilDateJpn.StartDayOfGengo = [
    [1, 1, 1, 1],
    [1868, 9, 8, 252],
    [1912, 6, 30, 212],
    [1926, 12, 25, 359],
    [1989, 1, 8, 8],
    [2019, 5, 1, 121],
    [0, 0, 0, 0],
    [0, 0, 0, 0],
    [0, 0, 0, 0]
];
//# sourceMappingURL=data:application/json;base64,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