import { Encoding, StringBuilder } from "@magic-xpa/mscorelib";
export class UtilStrByteMode {
    static isLocaleDefLangDBCS() {
        return UtilStrByteMode._bLocaleDefLangJPN || UtilStrByteMode._bLocaleDefLangCHN || UtilStrByteMode._bLocaleDefLangKOR;
    }
    static isLocaleDefLangJPN() {
        return UtilStrByteMode._bLocaleDefLangJPN;
    }
    static isLocaleDefLangKOR() {
        return UtilStrByteMode._bLocaleDefLangKOR;
    }
    static isKoreanCharacter(c) {
        return (44032 <= c && c <= 55203) || (4352 <= c && c <= 4607) || (12592 <= c && c <= 12687) || (43360 <= c && c <= 43391) || (55216 <= c && c <= 55295);
    }
    static lenB(strVal) {
        return UtilStrByteMode.Encoding.GetByteCount(strVal);
    }
    static midB(strVal, ofs, len) {
        let intValidMaxIndex = -1;
        let intValidMinIndex = -1;
        let bHeadSpace = false;
        let bEndSpace = false;
        let strRet;
        if (len <= 0)
            return "";
        if (ofs <= 0) {
            ofs = 0;
            intValidMinIndex = 0;
            bHeadSpace = false;
        }
        let intByteLength = UtilStrByteMode.lenB(strVal);
        if (intByteLength < ofs)
            return "";
        let LenMax = intByteLength - ofs;
        if (LenMax < len)
            len = LenMax;
        intByteLength = 0;
        for (let intIndex = 0; intIndex < strVal.length; intIndex = intIndex + 1) {
            let s = strVal.substr(intIndex, 1);
            intByteLength = intByteLength + UtilStrByteMode.Encoding.GetByteCount(s);
            if (intValidMinIndex === -1) {
                if (intByteLength === ofs) {
                    intValidMinIndex = intIndex + 1;
                    bHeadSpace = false;
                }
                else if (intByteLength > ofs) {
                    intValidMinIndex = intIndex + 1;
                    bHeadSpace = true;
                }
            }
            if (intValidMaxIndex === -1) {
                if (intByteLength === ofs + len) {
                    intValidMaxIndex = intIndex;
                    bEndSpace = false;
                    break;
                }
                else if (intByteLength > ofs + len) {
                    intValidMaxIndex = intIndex - 1;
                    bEndSpace = true;
                    break;
                }
            }
        }
        let strbufAddingBuf = new StringBuilder(len);
        if (bHeadSpace) {
            strbufAddingBuf.Append(' ');
        }
        if (intValidMinIndex <= intValidMaxIndex) {
            strbufAddingBuf.Append(strVal.substr(intValidMinIndex, intValidMaxIndex + 1 - intValidMinIndex));
        }
        if (bEndSpace) {
            strbufAddingBuf.Append(' ');
        }
        strRet = strbufAddingBuf.ToString();
        strbufAddingBuf = null;
        return strRet;
    }
    static leftB(strVal, len) {
        return UtilStrByteMode.midB(strVal, 0, len);
    }
    static rightB(strVal, len) {
        let byteFldsValLen = UtilStrByteMode.lenB(strVal);
        if (len < 0) {
            len = 0;
        }
        let ofs = byteFldsValLen - len;
        if (ofs < 0) {
            ofs = 0;
        }
        return UtilStrByteMode.midB(strVal, ofs, len);
    }
    static insB(strTarget, strSource, ofs, len) {
        if (ofs < 0) {
            ofs = 0;
        }
        else {
            if (ofs >= 1) {
                ofs = ofs - 1;
            }
        }
        if (len < 0) {
            len = 0;
        }
        let intTargetLenB = UtilStrByteMode.lenB(strTarget);
        let intSourceLenB = UtilStrByteMode.lenB(strSource);
        let strbufRetVal = new StringBuilder(ofs + len);
        strbufRetVal.Append(UtilStrByteMode.leftB(strTarget, ofs));
        for (let intAddSpaceLen = ofs - intTargetLenB; intAddSpaceLen > 0; intAddSpaceLen = intAddSpaceLen - 1) {
            strbufRetVal.Append(' ');
        }
        strbufRetVal.Append(UtilStrByteMode.leftB(strSource, len));
        for (let i = len - intSourceLenB; i > 0; i = i - 1) {
            strbufRetVal.Append(' ');
        }
        strbufRetVal.Append(UtilStrByteMode.rightB(strTarget, intTargetLenB - ofs));
        return strbufRetVal.ToString();
    }
    static delB(strVal, ofs, len) {
        if (ofs < 0) {
            ofs = 0;
        }
        else {
            if (ofs >= 1) {
                ofs = ofs - 1;
            }
        }
        let intValLenB = UtilStrByteMode.lenB(strVal);
        if (ofs + len > intValLenB) {
            len = intValLenB - ofs;
        }
        let strRet;
        if (len <= 0) {
            strRet = strVal;
        }
        else {
            let intRightSideLenB = intValLenB - ofs - len;
            if (intRightSideLenB < 0) {
                strRet = strVal;
            }
            else {
                let strbufRetVal = new StringBuilder(ofs + intRightSideLenB);
                strbufRetVal.Append(UtilStrByteMode.leftB(strVal, ofs));
                strbufRetVal.Append(UtilStrByteMode.rightB(strVal, intRightSideLenB));
                strRet = strbufRetVal.ToString();
            }
        }
        return strRet;
    }
    static instrB(strTarget, strSearch) {
        if (strSearch.length === 0) {
            return 0;
        }
        let ofs = strTarget.indexOf(strSearch);
        if (ofs < 0) {
            return 0;
        }
        return UtilStrByteMode.lenB(strTarget.substr(0, ofs)) + 1;
    }
    static repB(strTarget, strOrigin, ofs, len) {
        let strbufAddingBuf = new StringBuilder();
        if (ofs < 0) {
            ofs = 0;
        }
        else {
            if (ofs >= 1) {
                ofs = ofs - 1;
            }
        }
        if (len < 0) {
            len = 0;
        }
        strbufAddingBuf.Append(UtilStrByteMode.leftB(strTarget, ofs));
        let intAddSpaceLen = ofs - UtilStrByteMode.lenB(strTarget);
        for (; intAddSpaceLen > 0; intAddSpaceLen--)
            strbufAddingBuf.Append(' ');
        strbufAddingBuf.Append(UtilStrByteMode.leftB(strOrigin, len));
        let intRightLen = UtilStrByteMode.lenB(strTarget) - (ofs + len);
        if (intRightLen > 0) {
            strbufAddingBuf.Append(UtilStrByteMode.rightB(strTarget, intRightLen));
        }
        intAddSpaceLen = len - UtilStrByteMode.lenB(strOrigin);
        for (; intAddSpaceLen > 0; intAddSpaceLen--) {
            strbufAddingBuf.Append(' ');
        }
        return strbufAddingBuf.ToString();
    }
    static repC(strTarget, strOrigin, ofs, len) {
        let strbufAddingBuf = new StringBuilder();
        if (ofs < 0) {
            ofs = 0;
        }
        else {
            if (ofs >= 1) {
                ofs = ofs - 1;
            }
        }
        if (len < 0) {
            len = 0;
        }
        strbufAddingBuf.Append(strTarget.substr(0, ofs));
        let intAddSpaceLen = ofs - strTarget.length;
        for (; intAddSpaceLen > 0; intAddSpaceLen--)
            strbufAddingBuf.Append(' ');
        strbufAddingBuf.Append(strOrigin.substr(0, len));
        let intRightLen = strTarget.length - (ofs + len);
        if (intRightLen > 0) {
            strbufAddingBuf.Append(strTarget.substr(ofs + len));
        }
        for (let i = len - strOrigin.length; i > 0; i = i - 1) {
            strbufAddingBuf.Append(' ');
        }
        return strbufAddingBuf.ToString();
    }
    static isHalfWidth(str) {
        let letter = str.charCodeAt(0);
        if (32 <= letter && letter <= 126) {
            return true;
        }
        else {
            let len = UtilStrByteMode.lenB(str);
            if (len === 1)
                return true;
        }
        return false;
    }
    static isDigit(letter) {
        return 48 <= letter.charCodeAt(0) && letter.charCodeAt(0) <= 57;
    }
    static asNumeric(letter) {
        let result;
        switch (letter.charCodeAt(0)) {
            case 42:
            case 43:
            case 44:
            case 45:
            case 46:
            case 47:
                result = true;
                break;
            default:
                result = false;
                break;
        }
        return result;
    }
    static convPos(strSource, strDest, pos, isAdvance) {
        let retPos;
        if (pos < 0)
            return 0;
        if (pos > strSource.length)
            pos = strSource.length;
        let diffLen = UtilStrByteMode.lenB(strSource) - UtilStrByteMode.lenB(strDest);
        if (diffLen > 0) {
            let stringBuilder = new StringBuilder(strDest);
            for (; diffLen > 0; diffLen--)
                stringBuilder.Append(' ');
            strDest = stringBuilder.ToString();
        }
        let byteSource = UtilStrByteMode.Encoding.GetBytes(strSource.substr(0, pos));
        let strLeftB = UtilStrByteMode.leftB(strDest, byteSource.length);
        retPos = strLeftB.length;
        if (!isAdvance && retPos > 0 && strLeftB.charCodeAt(retPos - 1) === 32 && strDest.charCodeAt(retPos - 1) !== 32) {
            retPos = retPos - 1;
        }
        return retPos;
    }
    static getMinLenPicture(str, picture) {
        let len = 0;
        if (UtilStrByteMode.lenB(picture) - UtilStrByteMode.lenB(str) > 0) {
            len = UtilStrByteMode.convPos(str, picture, str.length, false);
        }
        else
            len = picture.length;
        return len;
    }
    static strcmp(str1, str2) {
        let array1 = UtilStrByteMode.Encoding.GetBytes(str1);
        let array2 = UtilStrByteMode.Encoding.GetBytes(str2);
        for (let i = 0; i < array1.length && i < array2.length; i++) {
            if (array1[i] > array2[i]) {
                return 1;
            }
            else if (array1[i] < array2[i]) {
                return -1;
            }
        }
        if (array1.length > array2.length)
            return 1;
        if (array1.length < array2.length)
            return -1;
        else
            return 0;
    }
}
UtilStrByteMode.Encoding = Encoding.UTF8;
UtilStrByteMode.strNavigatorLang = window.navigator.language;
UtilStrByteMode._bLocaleDefLangJPN = UtilStrByteMode.strNavigatorLang.startsWith('ja');
UtilStrByteMode._bLocaleDefLangCHN = UtilStrByteMode.strNavigatorLang.startsWith('zh');
UtilStrByteMode._bLocaleDefLangKOR = UtilStrByteMode.strNavigatorLang.startsWith('ko');
//# sourceMappingURL=data:application/json;base64,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