import { StringBuilder, Encoding, Hashtable, Stack, NChar, NNumber, NString, RefParam, isNullOrUndefined, DateTime, ISO_8859_1_Encoding, ApplicationException, Int32, Exception, List, Thread, Debug } from '@magic-xpa/mscorelib';
import { parseString } from 'xml2js';

class UtilStrByteMode {
    static isLocaleDefLangDBCS() {
        return UtilStrByteMode._bLocaleDefLangJPN || UtilStrByteMode._bLocaleDefLangCHN || UtilStrByteMode._bLocaleDefLangKOR;
    }
    static isLocaleDefLangJPN() {
        return UtilStrByteMode._bLocaleDefLangJPN;
    }
    static isLocaleDefLangKOR() {
        return UtilStrByteMode._bLocaleDefLangKOR;
    }
    static isKoreanCharacter(c) {
        return (44032 <= c && c <= 55203) || (4352 <= c && c <= 4607) || (12592 <= c && c <= 12687) || (43360 <= c && c <= 43391) || (55216 <= c && c <= 55295);
    }
    static lenB(strVal) {
        return UtilStrByteMode.Encoding.GetByteCount(strVal);
    }
    static midB(strVal, ofs, len) {
        let intValidMaxIndex = -1;
        let intValidMinIndex = -1;
        let bHeadSpace = false;
        let bEndSpace = false;
        let strRet;
        if (len <= 0)
            return "";
        if (ofs <= 0) {
            ofs = 0;
            intValidMinIndex = 0;
            bHeadSpace = false;
        }
        let intByteLength = UtilStrByteMode.lenB(strVal);
        if (intByteLength < ofs)
            return "";
        let LenMax = intByteLength - ofs;
        if (LenMax < len)
            len = LenMax;
        intByteLength = 0;
        for (let intIndex = 0; intIndex < strVal.length; intIndex = intIndex + 1) {
            let s = strVal.substr(intIndex, 1);
            intByteLength = intByteLength + UtilStrByteMode.Encoding.GetByteCount(s);
            if (intValidMinIndex === -1) {
                if (intByteLength === ofs) {
                    intValidMinIndex = intIndex + 1;
                    bHeadSpace = false;
                }
                else if (intByteLength > ofs) {
                    intValidMinIndex = intIndex + 1;
                    bHeadSpace = true;
                }
            }
            if (intValidMaxIndex === -1) {
                if (intByteLength === ofs + len) {
                    intValidMaxIndex = intIndex;
                    bEndSpace = false;
                    break;
                }
                else if (intByteLength > ofs + len) {
                    intValidMaxIndex = intIndex - 1;
                    bEndSpace = true;
                    break;
                }
            }
        }
        let strbufAddingBuf = new StringBuilder(len);
        if (bHeadSpace) {
            strbufAddingBuf.Append(' ');
        }
        if (intValidMinIndex <= intValidMaxIndex) {
            strbufAddingBuf.Append(strVal.substr(intValidMinIndex, intValidMaxIndex + 1 - intValidMinIndex));
        }
        if (bEndSpace) {
            strbufAddingBuf.Append(' ');
        }
        strRet = strbufAddingBuf.ToString();
        strbufAddingBuf = null;
        return strRet;
    }
    static leftB(strVal, len) {
        return UtilStrByteMode.midB(strVal, 0, len);
    }
    static rightB(strVal, len) {
        let byteFldsValLen = UtilStrByteMode.lenB(strVal);
        if (len < 0) {
            len = 0;
        }
        let ofs = byteFldsValLen - len;
        if (ofs < 0) {
            ofs = 0;
        }
        return UtilStrByteMode.midB(strVal, ofs, len);
    }
    static insB(strTarget, strSource, ofs, len) {
        if (ofs < 0) {
            ofs = 0;
        }
        else {
            if (ofs >= 1) {
                ofs = ofs - 1;
            }
        }
        if (len < 0) {
            len = 0;
        }
        let intTargetLenB = UtilStrByteMode.lenB(strTarget);
        let intSourceLenB = UtilStrByteMode.lenB(strSource);
        let strbufRetVal = new StringBuilder(ofs + len);
        strbufRetVal.Append(UtilStrByteMode.leftB(strTarget, ofs));
        for (let intAddSpaceLen = ofs - intTargetLenB; intAddSpaceLen > 0; intAddSpaceLen = intAddSpaceLen - 1) {
            strbufRetVal.Append(' ');
        }
        strbufRetVal.Append(UtilStrByteMode.leftB(strSource, len));
        for (let i = len - intSourceLenB; i > 0; i = i - 1) {
            strbufRetVal.Append(' ');
        }
        strbufRetVal.Append(UtilStrByteMode.rightB(strTarget, intTargetLenB - ofs));
        return strbufRetVal.ToString();
    }
    static delB(strVal, ofs, len) {
        if (ofs < 0) {
            ofs = 0;
        }
        else {
            if (ofs >= 1) {
                ofs = ofs - 1;
            }
        }
        let intValLenB = UtilStrByteMode.lenB(strVal);
        if (ofs + len > intValLenB) {
            len = intValLenB - ofs;
        }
        let strRet;
        if (len <= 0) {
            strRet = strVal;
        }
        else {
            let intRightSideLenB = intValLenB - ofs - len;
            if (intRightSideLenB < 0) {
                strRet = strVal;
            }
            else {
                let strbufRetVal = new StringBuilder(ofs + intRightSideLenB);
                strbufRetVal.Append(UtilStrByteMode.leftB(strVal, ofs));
                strbufRetVal.Append(UtilStrByteMode.rightB(strVal, intRightSideLenB));
                strRet = strbufRetVal.ToString();
            }
        }
        return strRet;
    }
    static instrB(strTarget, strSearch) {
        if (strSearch.length === 0) {
            return 0;
        }
        let ofs = strTarget.indexOf(strSearch);
        if (ofs < 0) {
            return 0;
        }
        return UtilStrByteMode.lenB(strTarget.substr(0, ofs)) + 1;
    }
    static repB(strTarget, strOrigin, ofs, len) {
        let strbufAddingBuf = new StringBuilder();
        if (ofs < 0) {
            ofs = 0;
        }
        else {
            if (ofs >= 1) {
                ofs = ofs - 1;
            }
        }
        if (len < 0) {
            len = 0;
        }
        strbufAddingBuf.Append(UtilStrByteMode.leftB(strTarget, ofs));
        let intAddSpaceLen = ofs - UtilStrByteMode.lenB(strTarget);
        for (; intAddSpaceLen > 0; intAddSpaceLen--)
            strbufAddingBuf.Append(' ');
        strbufAddingBuf.Append(UtilStrByteMode.leftB(strOrigin, len));
        let intRightLen = UtilStrByteMode.lenB(strTarget) - (ofs + len);
        if (intRightLen > 0) {
            strbufAddingBuf.Append(UtilStrByteMode.rightB(strTarget, intRightLen));
        }
        intAddSpaceLen = len - UtilStrByteMode.lenB(strOrigin);
        for (; intAddSpaceLen > 0; intAddSpaceLen--) {
            strbufAddingBuf.Append(' ');
        }
        return strbufAddingBuf.ToString();
    }
    static repC(strTarget, strOrigin, ofs, len) {
        let strbufAddingBuf = new StringBuilder();
        if (ofs < 0) {
            ofs = 0;
        }
        else {
            if (ofs >= 1) {
                ofs = ofs - 1;
            }
        }
        if (len < 0) {
            len = 0;
        }
        strbufAddingBuf.Append(strTarget.substr(0, ofs));
        let intAddSpaceLen = ofs - strTarget.length;
        for (; intAddSpaceLen > 0; intAddSpaceLen--)
            strbufAddingBuf.Append(' ');
        strbufAddingBuf.Append(strOrigin.substr(0, len));
        let intRightLen = strTarget.length - (ofs + len);
        if (intRightLen > 0) {
            strbufAddingBuf.Append(strTarget.substr(ofs + len));
        }
        for (let i = len - strOrigin.length; i > 0; i = i - 1) {
            strbufAddingBuf.Append(' ');
        }
        return strbufAddingBuf.ToString();
    }
    static isHalfWidth(str) {
        let letter = str.charCodeAt(0);
        if (32 <= letter && letter <= 126) {
            return true;
        }
        else {
            let len = UtilStrByteMode.lenB(str);
            if (len === 1)
                return true;
        }
        return false;
    }
    static isDigit(letter) {
        return 48 <= letter.charCodeAt(0) && letter.charCodeAt(0) <= 57;
    }
    static asNumeric(letter) {
        let result;
        switch (letter.charCodeAt(0)) {
            case 42:
            case 43:
            case 44:
            case 45:
            case 46:
            case 47:
                result = true;
                break;
            default:
                result = false;
                break;
        }
        return result;
    }
    static convPos(strSource, strDest, pos, isAdvance) {
        let retPos;
        if (pos < 0)
            return 0;
        if (pos > strSource.length)
            pos = strSource.length;
        let diffLen = UtilStrByteMode.lenB(strSource) - UtilStrByteMode.lenB(strDest);
        if (diffLen > 0) {
            let stringBuilder = new StringBuilder(strDest);
            for (; diffLen > 0; diffLen--)
                stringBuilder.Append(' ');
            strDest = stringBuilder.ToString();
        }
        let byteSource = UtilStrByteMode.Encoding.GetBytes(strSource.substr(0, pos));
        let strLeftB = UtilStrByteMode.leftB(strDest, byteSource.length);
        retPos = strLeftB.length;
        if (!isAdvance && retPos > 0 && strLeftB.charCodeAt(retPos - 1) === 32 && strDest.charCodeAt(retPos - 1) !== 32) {
            retPos = retPos - 1;
        }
        return retPos;
    }
    static getMinLenPicture(str, picture) {
        let len = 0;
        if (UtilStrByteMode.lenB(picture) - UtilStrByteMode.lenB(str) > 0) {
            len = UtilStrByteMode.convPos(str, picture, str.length, false);
        }
        else
            len = picture.length;
        return len;
    }
    static strcmp(str1, str2) {
        let array1 = UtilStrByteMode.Encoding.GetBytes(str1);
        let array2 = UtilStrByteMode.Encoding.GetBytes(str2);
        for (let i = 0; i < array1.length && i < array2.length; i++) {
            if (array1[i] > array2[i]) {
                return 1;
            }
            else if (array1[i] < array2[i]) {
                return -1;
            }
        }
        if (array1.length > array2.length)
            return 1;
        if (array1.length < array2.length)
            return -1;
        else
            return 0;
    }
}
UtilStrByteMode.Encoding = Encoding.UTF8;
UtilStrByteMode.strNavigatorLang = window.navigator.language;
UtilStrByteMode._bLocaleDefLangJPN = UtilStrByteMode.strNavigatorLang.startsWith('ja');
UtilStrByteMode._bLocaleDefLangCHN = UtilStrByteMode.strNavigatorLang.startsWith('zh');
UtilStrByteMode._bLocaleDefLangKOR = UtilStrByteMode.strNavigatorLang.startsWith('ko');

class Rtf_SYMBOL {
    constructor(keyWord, kwd, idxInRgprop) {
        this.szKeyword = null;
        this.kwd = null;
        this.idxInRgprop = null;
        this.szKeyword = keyWord;
        this.kwd = kwd;
        this.idxInRgprop = idxInRgprop;
    }
}
class Rtf_PROP {
    constructor(actn, prop) {
        this.actn = null;
        this.prop = null;
        this.actn = actn;
        this.prop = prop;
    }
}
class Rtf_StackSave {
    constructor() {
        this.rds = null;
        this.ris = null;
    }
}
var Rtf_KWD;
(function (Rtf_KWD) {
    Rtf_KWD[Rtf_KWD["CHAR"] = 0] = "CHAR";
    Rtf_KWD[Rtf_KWD["DEST"] = 1] = "DEST";
    Rtf_KWD[Rtf_KWD["PROP"] = 2] = "PROP";
    Rtf_KWD[Rtf_KWD["SPEC"] = 3] = "SPEC";
})(Rtf_KWD || (Rtf_KWD = {}));
var Rtf_PROPTYPE;
(function (Rtf_PROPTYPE) {
    Rtf_PROPTYPE[Rtf_PROPTYPE["CHP"] = 0] = "CHP";
    Rtf_PROPTYPE[Rtf_PROPTYPE["PAP"] = 1] = "PAP";
    Rtf_PROPTYPE[Rtf_PROPTYPE["SEP"] = 2] = "SEP";
    Rtf_PROPTYPE[Rtf_PROPTYPE["DOP"] = 3] = "DOP";
})(Rtf_PROPTYPE || (Rtf_PROPTYPE = {}));
var Rtf_ACTN;
(function (Rtf_ACTN) {
    Rtf_ACTN[Rtf_ACTN["SPEC"] = 0] = "SPEC";
    Rtf_ACTN[Rtf_ACTN["BYTE"] = 1] = "BYTE";
    Rtf_ACTN[Rtf_ACTN["WORD"] = 2] = "WORD";
})(Rtf_ACTN || (Rtf_ACTN = {}));
var Rtf_IPFN;
(function (Rtf_IPFN) {
    Rtf_IPFN[Rtf_IPFN["BIN"] = 0] = "BIN";
    Rtf_IPFN[Rtf_IPFN["HEX"] = 1] = "HEX";
    Rtf_IPFN[Rtf_IPFN["SKIP_DEST"] = 2] = "SKIP_DEST";
    Rtf_IPFN[Rtf_IPFN["BREAK"] = 3] = "BREAK";
    Rtf_IPFN[Rtf_IPFN["NEW"] = 4] = "NEW";
    Rtf_IPFN[Rtf_IPFN["FONT"] = 5] = "FONT";
    Rtf_IPFN[Rtf_IPFN["CHARSET"] = 6] = "CHARSET";
    Rtf_IPFN[Rtf_IPFN["UNICODE"] = 7] = "UNICODE";
})(Rtf_IPFN || (Rtf_IPFN = {}));
var Rtf_IDEST;
(function (Rtf_IDEST) {
    Rtf_IDEST[Rtf_IDEST["PICT"] = 0] = "PICT";
    Rtf_IDEST[Rtf_IDEST["COLOR"] = 1] = "COLOR";
    Rtf_IDEST[Rtf_IDEST["SKIP"] = 2] = "SKIP";
})(Rtf_IDEST || (Rtf_IDEST = {}));
var Rtf_IPROP;
(function (Rtf_IPROP) {
    Rtf_IPROP[Rtf_IPROP["BOLD"] = 0] = "BOLD";
    Rtf_IPROP[Rtf_IPROP["ITALIC"] = 1] = "ITALIC";
    Rtf_IPROP[Rtf_IPROP["UNDERLINE"] = 2] = "UNDERLINE";
    Rtf_IPROP[Rtf_IPROP["FONT"] = 3] = "FONT";
    Rtf_IPROP[Rtf_IPROP["SIZE"] = 4] = "SIZE";
    Rtf_IPROP[Rtf_IPROP["COLOR"] = 5] = "COLOR";
    Rtf_IPROP[Rtf_IPROP["RED"] = 6] = "RED";
    Rtf_IPROP[Rtf_IPROP["GREEN"] = 7] = "GREEN";
    Rtf_IPROP[Rtf_IPROP["BLUE"] = 8] = "BLUE";
    Rtf_IPROP[Rtf_IPROP["LEFT_IND"] = 9] = "LEFT_IND";
    Rtf_IPROP[Rtf_IPROP["RIGHT_IND"] = 10] = "RIGHT_IND";
    Rtf_IPROP[Rtf_IPROP["FIRST_IND"] = 11] = "FIRST_IND";
    Rtf_IPROP[Rtf_IPROP["COLS"] = 12] = "COLS";
    Rtf_IPROP[Rtf_IPROP["PGN_X"] = 13] = "PGN_X";
    Rtf_IPROP[Rtf_IPROP["PGN_Y"] = 14] = "PGN_Y";
    Rtf_IPROP[Rtf_IPROP["XA_PAGE"] = 15] = "XA_PAGE";
    Rtf_IPROP[Rtf_IPROP["YA_PAGE"] = 16] = "YA_PAGE";
    Rtf_IPROP[Rtf_IPROP["XA_LEFT"] = 17] = "XA_LEFT";
    Rtf_IPROP[Rtf_IPROP["XA_RIGHT"] = 18] = "XA_RIGHT";
    Rtf_IPROP[Rtf_IPROP["YA_TOP"] = 19] = "YA_TOP";
    Rtf_IPROP[Rtf_IPROP["YA_BOTTOM"] = 20] = "YA_BOTTOM";
    Rtf_IPROP[Rtf_IPROP["PGN_START"] = 21] = "PGN_START";
    Rtf_IPROP[Rtf_IPROP["SBK"] = 22] = "SBK";
    Rtf_IPROP[Rtf_IPROP["PGN_FORMAT"] = 23] = "PGN_FORMAT";
    Rtf_IPROP[Rtf_IPROP["FACING_P"] = 24] = "FACING_P";
    Rtf_IPROP[Rtf_IPROP["LANDSCAPE"] = 25] = "LANDSCAPE";
    Rtf_IPROP[Rtf_IPROP["JUST"] = 26] = "JUST";
    Rtf_IPROP[Rtf_IPROP["PARD"] = 27] = "PARD";
    Rtf_IPROP[Rtf_IPROP["PLAIN"] = 28] = "PLAIN";
    Rtf_IPROP[Rtf_IPROP["SECTD"] = 29] = "SECTD";
    Rtf_IPROP[Rtf_IPROP["BULLET"] = 30] = "BULLET";
    Rtf_IPROP[Rtf_IPROP["XA_BULLET"] = 31] = "XA_BULLET";
    Rtf_IPROP[Rtf_IPROP["MAX"] = 32] = "MAX";
})(Rtf_IPROP || (Rtf_IPROP = {}));
var Rtf_RDS;
(function (Rtf_RDS) {
    Rtf_RDS[Rtf_RDS["NORM"] = 0] = "NORM";
    Rtf_RDS[Rtf_RDS["COLOR"] = 1] = "COLOR";
    Rtf_RDS[Rtf_RDS["SKIP"] = 2] = "SKIP";
    Rtf_RDS[Rtf_RDS["NEW"] = 3] = "NEW";
})(Rtf_RDS || (Rtf_RDS = {}));
var Rtf_ErrorRtf;
(function (Rtf_ErrorRtf) {
    Rtf_ErrorRtf[Rtf_ErrorRtf["OK"] = 0] = "OK";
    Rtf_ErrorRtf[Rtf_ErrorRtf["STACK_UNDERFLOW"] = 1] = "STACK_UNDERFLOW";
    Rtf_ErrorRtf[Rtf_ErrorRtf["STACK_OVERFLOW"] = 2] = "STACK_OVERFLOW";
    Rtf_ErrorRtf[Rtf_ErrorRtf["UNMATCHED_BRACE"] = 3] = "UNMATCHED_BRACE";
    Rtf_ErrorRtf[Rtf_ErrorRtf["INVALID_HEX"] = 4] = "INVALID_HEX";
    Rtf_ErrorRtf[Rtf_ErrorRtf["BAD_TABLE"] = 5] = "BAD_TABLE";
    Rtf_ErrorRtf[Rtf_ErrorRtf["ASSERTION"] = 6] = "ASSERTION";
    Rtf_ErrorRtf[Rtf_ErrorRtf["END_OF_FILE"] = 7] = "END_OF_FILE";
    Rtf_ErrorRtf[Rtf_ErrorRtf["BUFFER_TOO_SMALL"] = 8] = "BUFFER_TOO_SMALL";
})(Rtf_ErrorRtf || (Rtf_ErrorRtf = {}));
class Rtf_RtfChar {
}
Rtf_RtfChar.CR = String.fromCharCode(0x0d);
Rtf_RtfChar.LF = String.fromCharCode(0x0A);
Rtf_RtfChar.TAB = String.fromCharCode(0x09);
Rtf_RtfChar.BULLET = String.fromCharCode(0x95);
Rtf_RtfChar.TILDA = String.fromCharCode(0xA0);
Rtf_RtfChar.DASH = String.fromCharCode(0xAD);
Rtf_RtfChar.DASH_CHAR = '-';
Rtf_RtfChar.QUOTE = '\'';
Rtf_RtfChar.DBLQUOTE = '"';
Rtf_RtfChar.OPENINGBRACE = '{';
Rtf_RtfChar.CLOSINGBRACE = '}';
Rtf_RtfChar.BACKSLASH = '\\';
var Rtf_RIS;
(function (Rtf_RIS) {
    Rtf_RIS[Rtf_RIS["NORM"] = 0] = "NORM";
    Rtf_RIS[Rtf_RIS["BIN"] = 1] = "BIN";
    Rtf_RIS[Rtf_RIS["HEX"] = 2] = "HEX";
    Rtf_RIS[Rtf_RIS["UNICODE"] = 3] = "UNICODE";
})(Rtf_RIS || (Rtf_RIS = {}));
class Rtf {
    constructor() {
        this._group = 0;
        this._cbBin = 0;
        this._lParam = 0;
        this._skipDestIfUnk = false;
        this._outputOnce = false;
        this._processCrlfSpecial = false;
        this._destState = null;
        this._internalState = null;
        this._stack = null;
        this._index = 0;
        this._fontNum = 0;
        this._charsetTable = new Hashtable();
        this._codePageTable = new Hashtable();
        this._stack = new Stack();
        this._group = 0;
        this._cbBin = 0;
        this._lParam = 0;
        this._outputOnce = false;
        this._skipDestIfUnk = false;
        this._processCrlfSpecial = false;
        this._destState = Rtf_RDS.NORM;
        this._internalState = Rtf_RIS.NORM;
        this._fontNum = 0;
        if (UtilStrByteMode.isLocaleDefLangDBCS()) {
            this.setCodePageTable();
        }
    }
    static isRtf(str) {
        let isRtf = false;
        if (str !== null && str.startsWith(this.RTF_PREFIX)) {
            isRtf = true;
        }
        return isRtf;
    }
    toTxt(rtfTxt, outputTxt) {
        let cNibble = 2;
        let b = 0;
        let currPos = 0;
        let skipNewline = false;
        let blobStrLen;
        let blobChar;
        let ec;
        let dbcsBytes = new Uint8Array(2);
        let skipParseChar = false;
        let charset = 0;
        let codePage = 0;
        this._outputOnce = false;
        this._processCrlfSpecial = false;
        blobStrLen = rtfTxt.length;
        this._index = 0;
        this._destState = Rtf_RDS.NORM;
        if (rtfTxt === null || blobStrLen === 0 || !Rtf.isRtf(rtfTxt)) {
            return Rtf_ErrorRtf.OK;
        }
        while (this._index < blobStrLen) {
            blobChar = rtfTxt[this._index];
            this._index++;
            if (this._group < 0)
                return Rtf_ErrorRtf.STACK_UNDERFLOW;
            if (this._internalState === Rtf_RIS.BIN) {
                if ((ec = this.ParseChar(blobChar, outputTxt)) !== Rtf_ErrorRtf.OK)
                    return ec;
            }
            else {
                switch (blobChar) {
                    case Rtf_RtfChar.OPENINGBRACE:
                        skipNewline = false;
                        if ((ec = this.PushState()) !== Rtf_ErrorRtf.OK)
                            return ec;
                        break;
                    case Rtf_RtfChar.CLOSINGBRACE:
                        skipNewline = true;
                        if ((ec = this.PopState()) !== Rtf_ErrorRtf.OK)
                            return ec;
                        break;
                    case Rtf_RtfChar.BACKSLASH:
                        skipNewline = false;
                        if ((ec = this.ParseKeyword(rtfTxt, outputTxt)) !== Rtf_ErrorRtf.OK)
                            return ec;
                        break;
                    case Rtf_RtfChar.LF:
                    case Rtf_RtfChar.CR:
                        if (this._processCrlfSpecial) {
                            if (blobChar === Rtf_RtfChar.LF) {
                                this._processCrlfSpecial = false;
                            }
                        }
                        else {
                            if (blobChar === Rtf_RtfChar.LF || (blobChar === Rtf_RtfChar.CR && skipNewline && !this._outputOnce))
                                break;
                        }
                    default:
                        if (blobChar !== Rtf_RtfChar.CR)
                            skipNewline = false;
                        if (this._internalState === Rtf_RIS.NORM) {
                            if ((ec = this.ParseChar(blobChar, outputTxt)) !== Rtf_ErrorRtf.OK)
                                return ec;
                        }
                        else if (this._internalState === Rtf_RIS.UNICODE) {
                            if ((ec = this.ParseChar(String.fromCharCode(this._lParam), outputTxt)) !== Rtf_ErrorRtf.OK)
                                return ec;
                            this._internalState = Rtf_RIS.NORM;
                        }
                        else {
                            if (this._internalState !== Rtf_RIS.HEX)
                                return Rtf_ErrorRtf.ASSERTION;
                            b = b << 4;
                            if (NChar.IsDigit(blobChar))
                                b += blobChar.charCodeAt(0) - '0'.charCodeAt(0);
                            else {
                                if (NChar.IsLower(blobChar)) {
                                    if (blobChar < 'a' || blobChar > 'f')
                                        return Rtf_ErrorRtf.INVALID_HEX;
                                    b += 10 + blobChar.charCodeAt(0) - 'a'.charCodeAt(0);
                                }
                                else {
                                    if (blobChar < 'A' || blobChar > 'F')
                                        return Rtf_ErrorRtf.INVALID_HEX;
                                    b += 10 + blobChar.charCodeAt(0) - 'A'.charCodeAt(0);
                                }
                            }
                            cNibble--;
                            if (cNibble === 0) {
                                if (UtilStrByteMode.isLocaleDefLangDBCS()) {
                                    charset = this.getCharset(this._fontNum);
                                    if (!skipParseChar && Rtf.is1stByte(b, charset)) {
                                        dbcsBytes[0] = b;
                                        dbcsBytes[1] = 0;
                                        skipParseChar = true;
                                    }
                                    else {
                                        if (skipParseChar && Rtf.is2ndByte(b, charset))
                                            dbcsBytes[1] = b;
                                        else {
                                            dbcsBytes[0] = b;
                                            dbcsBytes[1] = 0;
                                        }
                                        codePage = this.getCodePage(charset);
                                        let workStr = Encoding.GetEncoding(codePage).GetString(dbcsBytes, 0, 2);
                                        b = workStr.charCodeAt(0);
                                        skipParseChar = false;
                                    }
                                }
                                if (!skipParseChar) {
                                    if ((ec = this.ParseChar(String.fromCharCode(b), outputTxt)) !== Rtf_ErrorRtf.OK)
                                        return ec;
                                }
                                cNibble = 2;
                                b = 0;
                                this._internalState = Rtf_RIS.NORM;
                            }
                        }
                        break;
                }
            }
        }
        if (this._group < 0)
            return Rtf_ErrorRtf.STACK_UNDERFLOW;
        if (this._group > 0)
            return Rtf_ErrorRtf.UNMATCHED_BRACE;
        currPos = outputTxt.Length;
        if (currPos >= 3 && (outputTxt.get_Item(currPos - 3) === Rtf_RtfChar.CR && outputTxt.get_Item(currPos - 2) === Rtf_RtfChar.LF && outputTxt.get_Item(currPos - 1) === Rtf_RtfChar.CR || outputTxt.get_Item(currPos - 3) === Rtf_RtfChar.LF && outputTxt.get_Item(currPos - 2) === Rtf_RtfChar.CR && outputTxt.get_Item(currPos - 1) === Rtf_RtfChar.CR))
            outputTxt.Remove(currPos - 3, 3);
        return Rtf_ErrorRtf.OK;
    }
    ParseChar(ch, outputTxt) {
        let ret = Rtf_ErrorRtf.OK;
        if (this._internalState === Rtf_RIS.BIN && --this._cbBin <= 0) {
            this._internalState = Rtf_RIS.NORM;
        }
        if (this._destState === Rtf_RDS.SKIP) {
        }
        else if (this._destState === Rtf_RDS.NORM) {
            ret = this.PrintChar(ch, outputTxt);
        }
        else {
        }
        return ret;
    }
    PrintChar(ch, outputTxt) {
        if ((ch >= ' ' || ch === Rtf_RtfChar.CR || ch === Rtf_RtfChar.LF) && ch !== String.fromCharCode(183)) {
            outputTxt.Append(ch);
        }
        if (ch >= ' ') {
            this._outputOnce = true;
        }
        return Rtf_ErrorRtf.OK;
    }
    PushState() {
        let stackSave = new Rtf_StackSave();
        if (stackSave === null) {
            return Rtf_ErrorRtf.STACK_OVERFLOW;
        }
        stackSave.rds = this._destState;
        stackSave.ris = this._internalState;
        this._internalState = Rtf_RIS.NORM;
        this._stack.push(stackSave);
        this._group++;
        return Rtf_ErrorRtf.OK;
    }
    PopState() {
        let savedPop = this._stack.pop();
        if (savedPop === null) {
            return Rtf_ErrorRtf.STACK_UNDERFLOW;
        }
        this._destState = savedPop.rds;
        this._internalState = savedPop.ris;
        this._group--;
        return Rtf_ErrorRtf.OK;
    }
    ParseKeyword(rtfTxt, outputTxt) {
        let ch;
        let fNeg = false;
        let szKeyword = "";
        let szParameter = "";
        if ((ch = rtfTxt[this._index++]) === String.fromCharCode(0)) {
            return Rtf_ErrorRtf.END_OF_FILE;
        }
        if (!NChar.IsLetter(ch)) {
            szKeyword = szKeyword + ch;
            return this.TranslateKeyword(szKeyword, outputTxt);
        }
        for (; NChar.IsLetter(ch); ch = rtfTxt[this._index++])
            szKeyword = szKeyword + ch;
        if (ch === '-') {
            fNeg = true;
            if ((ch = rtfTxt[this._index++]) === String.fromCharCode(0))
                return Rtf_ErrorRtf.END_OF_FILE;
        }
        if (NChar.IsDigit(ch)) {
            for (; NChar.IsDigit(ch); ch = rtfTxt[this._index++])
                szParameter = szParameter + ch;
            this._lParam = NNumber.Parse(szParameter);
            if (fNeg)
                this._lParam = -this._lParam;
        }
        if (ch !== ' ')
            this._index--;
        if (szKeyword === Rtf.CHAR_PAR) {
            if (rtfTxt[this._index] === Rtf_RtfChar.CR && rtfTxt[this._index + 1] === Rtf_RtfChar.LF)
                this._processCrlfSpecial = true;
        }
        if (this._processCrlfSpecial) {
            return Rtf_ErrorRtf.OK;
        }
        else {
            return this.TranslateKeyword(szKeyword, outputTxt);
        }
    }
    TranslateKeyword(szKeyword, outputTxt) {
        let result = Rtf_ErrorRtf.OK;
        let isym;
        for (isym = 0; isym < Rtf.rgsymRtf.length; isym++) {
            if (szKeyword === Rtf.rgsymRtf[isym].szKeyword) {
                break;
            }
        }
        if (isym === Rtf.rgsymRtf.length) {
            if (this._skipDestIfUnk) {
                this._destState = Rtf_RDS.SKIP;
            }
            this._skipDestIfUnk = false;
        }
        else {
            result = Rtf_ErrorRtf.BAD_TABLE;
            this._skipDestIfUnk = false;
            if (Rtf.rgsymRtf[isym].kwd === Rtf_KWD.PROP) {
                result = this.validateProp(Rtf.rgsymRtf[isym].idxInRgprop);
            }
            else if (Rtf.rgsymRtf[isym].kwd === Rtf_KWD.CHAR) {
                result = this.ParseChar((Rtf.rgsymRtf[isym].idxInRgprop), outputTxt);
            }
            else if (Rtf.rgsymRtf[isym].kwd === Rtf_KWD.DEST) {
                result = this.changeDestState();
            }
            else if (Rtf.rgsymRtf[isym].kwd === Rtf_KWD.SPEC) {
                result = this.ParseSpecialKeyword(Rtf.rgsymRtf[isym].idxInRgprop);
            }
        }
        return result;
    }
    validateProp(iprop) {
        let ret = Rtf_ErrorRtf.OK;
        if (this._destState === Rtf_RDS.SKIP) {
            return ret;
        }
        if (Rtf.rgprop[iprop].prop !== Rtf_PROPTYPE.DOP && Rtf.rgprop[iprop].prop !== Rtf_PROPTYPE.SEP &&
            Rtf.rgprop[iprop].prop !== Rtf_PROPTYPE.PAP && Rtf.rgprop[iprop].prop !== Rtf_PROPTYPE.CHP &&
            Rtf.rgprop[iprop].actn !== Rtf_ACTN.SPEC) {
            ret = Rtf_ErrorRtf.BAD_TABLE;
        }
        if (Rtf.rgprop[iprop].actn !== Rtf_ACTN.BYTE && Rtf.rgprop[iprop].actn !== Rtf_ACTN.WORD && Rtf.rgprop[iprop].actn !== Rtf_ACTN.SPEC) {
            ret = Rtf_ErrorRtf.BAD_TABLE;
        }
        return ret;
    }
    changeDestState() {
        if (this._destState === Rtf_RDS.SKIP) {
            return Rtf_ErrorRtf.OK;
        }
        this._destState = Rtf_RDS.SKIP;
        return Rtf_ErrorRtf.OK;
    }
    ParseSpecialKeyword(ipfn) {
        let ret = Rtf_ErrorRtf.OK;
        if (!UtilStrByteMode.isLocaleDefLangDBCS()) {
            if (this._destState === Rtf_RDS.SKIP && ipfn !== Rtf_IPFN.BIN) {
                return ret;
            }
            if (ipfn === Rtf_IPFN.FONT || ipfn === Rtf_IPFN.CHARSET || ipfn === Rtf_IPFN.UNICODE) {
                return ret;
            }
        }
        else {
            if (this._destState === Rtf_RDS.SKIP && ipfn !== Rtf_IPFN.BIN && ipfn !== Rtf_IPFN.FONT &&
                ipfn !== Rtf_IPFN.CHARSET && ipfn !== Rtf_IPFN.UNICODE) {
                return ret;
            }
        }
        if (ipfn === Rtf_IPFN.BIN) {
            this._internalState = Rtf_RIS.BIN;
            this._cbBin = this._lParam;
        }
        else if (ipfn === Rtf_IPFN.SKIP_DEST) {
            this._skipDestIfUnk = true;
        }
        else if (ipfn === Rtf_IPFN.HEX) {
            this._internalState = Rtf_RIS.HEX;
        }
        else if (ipfn === Rtf_IPFN.FONT) {
            this._fontNum = this._lParam;
        }
        else if (ipfn === Rtf_IPFN.CHARSET) {
            this._charsetTable.set_Item(this._fontNum, this._lParam);
        }
        else if (ipfn === Rtf_IPFN.UNICODE) {
            this._internalState = Rtf_RIS.UNICODE;
        }
        else {
            ret = Rtf_ErrorRtf.BAD_TABLE;
        }
        return ret;
    }
    static is1stByte(dbcsBytes, charset) {
        let ret = false;
        if (dbcsBytes > 255)
            return ret;
        switch (charset) {
            case 128:
                ret = (129 <= dbcsBytes && dbcsBytes <= 159) || (224 <= dbcsBytes && dbcsBytes <= 254);
                break;
            case 129:
            case 134:
            case 136:
                ret = (129 <= dbcsBytes);
                break;
            default:
                break;
        }
        return ret;
    }
    static is2ndByte(dbcsBytes, charset) {
        let ret = false;
        if (dbcsBytes > 255)
            return ret;
        switch (charset) {
            case 128:
                ret = (dbcsBytes !== 127) && (64 <= dbcsBytes && dbcsBytes <= 252);
                break;
            case 129:
            case 134:
            case 136:
                ret = (64 <= dbcsBytes);
                break;
            default:
                break;
        }
        return ret;
    }
    setCodePageTable() {
        this._codePageTable.set_Item(0, 1252);
        this._codePageTable.set_Item(128, 932);
        this._codePageTable.set_Item(129, 949);
        this._codePageTable.set_Item(134, 936);
        this._codePageTable.set_Item(136, 950);
        this._codePageTable.set_Item(161, 1253);
        this._codePageTable.set_Item(162, 1254);
        this._codePageTable.set_Item(177, 1255);
        this._codePageTable.set_Item(178, 1256);
        this._codePageTable.set_Item(186, 1257);
        this._codePageTable.set_Item(204, 1251);
        this._codePageTable.set_Item(222, 874);
        this._codePageTable.set_Item(238, 1250);
    }
    getCodePage(charset) {
        let codePage = 0;
        if (this._codePageTable.ContainsKey(charset)) {
            codePage = this._codePageTable.get_Item(charset);
        }
        return codePage;
    }
    getCharset(font) {
        let charset = 0;
        if (this._charsetTable.ContainsKey(font)) {
            charset = this._charsetTable.get_Item(font);
        }
        return charset;
    }
}
Rtf.RTF_PREFIX = "{\\rtf";
Rtf.CHAR_PAR = "par";
Rtf.rgprop = [
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.PAP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.PAP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.PAP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.SEP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.SEP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.SEP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP), new Rtf_PROP(Rtf_ACTN.WORD, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.SEP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.SEP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.DOP), new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.DOP),
    new Rtf_PROP(Rtf_ACTN.BYTE, Rtf_PROPTYPE.PAP), new Rtf_PROP(Rtf_ACTN.SPEC, Rtf_PROPTYPE.PAP),
    new Rtf_PROP(Rtf_ACTN.SPEC, Rtf_PROPTYPE.CHP), new Rtf_PROP(Rtf_ACTN.SPEC, Rtf_PROPTYPE.SEP)
];
Rtf.rgsymRtf = [
    new Rtf_SYMBOL("b", Rtf_KWD.PROP, Rtf_IPROP.BOLD), new Rtf_SYMBOL("ul", Rtf_KWD.PROP, Rtf_IPROP.UNDERLINE),
    new Rtf_SYMBOL("i", Rtf_KWD.PROP, Rtf_IPROP.ITALIC), new Rtf_SYMBOL("li", Rtf_KWD.PROP, Rtf_IPROP.LEFT_IND),
    new Rtf_SYMBOL("ri", Rtf_KWD.PROP, Rtf_IPROP.RIGHT_IND), new Rtf_SYMBOL("fi", Rtf_KWD.PROP, Rtf_IPROP.FIRST_IND),
    new Rtf_SYMBOL("cols", Rtf_KWD.PROP, Rtf_IPROP.COLS), new Rtf_SYMBOL("sbknone", Rtf_KWD.PROP, Rtf_IPROP.SBK),
    new Rtf_SYMBOL("sbkcol", Rtf_KWD.PROP, Rtf_IPROP.SBK), new Rtf_SYMBOL("sbkeven", Rtf_KWD.PROP, Rtf_IPROP.SBK),
    new Rtf_SYMBOL("sbkodd", Rtf_KWD.PROP, Rtf_IPROP.SBK), new Rtf_SYMBOL("sbkpage", Rtf_KWD.PROP, Rtf_IPROP.SBK),
    new Rtf_SYMBOL("pgnx", Rtf_KWD.PROP, Rtf_IPROP.PGN_X), new Rtf_SYMBOL("pgny", Rtf_KWD.PROP, Rtf_IPROP.PGN_Y),
    new Rtf_SYMBOL("pgndec", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT), new Rtf_SYMBOL("pgnucrm", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT),
    new Rtf_SYMBOL("pgnlcrm", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT), new Rtf_SYMBOL("pgnucltr", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT),
    new Rtf_SYMBOL("pgnlcltr", Rtf_KWD.PROP, Rtf_IPROP.PGN_FORMAT), new Rtf_SYMBOL("qc", Rtf_KWD.PROP, Rtf_IPROP.JUST),
    new Rtf_SYMBOL("ql", Rtf_KWD.PROP, Rtf_IPROP.JUST), new Rtf_SYMBOL("qr", Rtf_KWD.PROP, Rtf_IPROP.JUST),
    new Rtf_SYMBOL("qj", Rtf_KWD.PROP, Rtf_IPROP.JUST), new Rtf_SYMBOL("paperw", Rtf_KWD.PROP, Rtf_IPROP.XA_PAGE),
    new Rtf_SYMBOL("paperh", Rtf_KWD.PROP, Rtf_IPROP.YA_PAGE), new Rtf_SYMBOL("margl", Rtf_KWD.PROP, Rtf_IPROP.XA_LEFT),
    new Rtf_SYMBOL("margr", Rtf_KWD.PROP, Rtf_IPROP.XA_RIGHT), new Rtf_SYMBOL("margt", Rtf_KWD.PROP, Rtf_IPROP.YA_TOP),
    new Rtf_SYMBOL("margb", Rtf_KWD.PROP, Rtf_IPROP.YA_BOTTOM), new Rtf_SYMBOL("pgnstart", Rtf_KWD.PROP, Rtf_IPROP.PGN_START),
    new Rtf_SYMBOL("facingp", Rtf_KWD.PROP, Rtf_IPROP.FACING_P), new Rtf_SYMBOL("landscape", Rtf_KWD.PROP, Rtf_IPROP.LANDSCAPE),
    new Rtf_SYMBOL("par", Rtf_KWD.CHAR, Rtf_RtfChar.LF), new Rtf_SYMBOL("\0x0a", Rtf_KWD.CHAR, Rtf_RtfChar.LF),
    new Rtf_SYMBOL("\0x0d", Rtf_KWD.CHAR, Rtf_RtfChar.LF), new Rtf_SYMBOL("tab", Rtf_KWD.CHAR, Rtf_RtfChar.TAB),
    new Rtf_SYMBOL("ldblquote", Rtf_KWD.CHAR, Rtf_RtfChar.DBLQUOTE), new Rtf_SYMBOL("rdblquote", Rtf_KWD.CHAR, Rtf_RtfChar.DBLQUOTE),
    new Rtf_SYMBOL("lquote", Rtf_KWD.CHAR, Rtf_RtfChar.QUOTE), new Rtf_SYMBOL("rquote", Rtf_KWD.CHAR, Rtf_RtfChar.QUOTE),
    new Rtf_SYMBOL("bullet", Rtf_KWD.CHAR, Rtf_RtfChar.BULLET), new Rtf_SYMBOL("endash", Rtf_KWD.CHAR, Rtf_RtfChar.DASH_CHAR),
    new Rtf_SYMBOL("emdash", Rtf_KWD.CHAR, Rtf_RtfChar.DASH_CHAR), new Rtf_SYMBOL("~", Rtf_KWD.CHAR, Rtf_RtfChar.TILDA),
    new Rtf_SYMBOL("-", Rtf_KWD.CHAR, Rtf_RtfChar.DASH), new Rtf_SYMBOL("{", Rtf_KWD.CHAR, Rtf_RtfChar.OPENINGBRACE),
    new Rtf_SYMBOL("}", Rtf_KWD.CHAR, Rtf_RtfChar.CLOSINGBRACE), new Rtf_SYMBOL("\\", Rtf_KWD.CHAR, Rtf_RtfChar.BACKSLASH),
    new Rtf_SYMBOL("bin", Rtf_KWD.SPEC, Rtf_IPFN.BIN), new Rtf_SYMBOL("*", Rtf_KWD.SPEC, Rtf_IPFN.SKIP_DEST),
    new Rtf_SYMBOL("'", Rtf_KWD.SPEC, Rtf_IPFN.HEX), new Rtf_SYMBOL("f", Rtf_KWD.SPEC, Rtf_IPFN.FONT),
    new Rtf_SYMBOL("fcharset", Rtf_KWD.SPEC, Rtf_IPFN.CHARSET), new Rtf_SYMBOL("u", Rtf_KWD.SPEC, Rtf_IPFN.UNICODE),
    new Rtf_SYMBOL("author", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("buptim", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("colortbl", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("comment", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("creatim", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("doccomm", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("fonttbl", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("footer", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("footerf", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("footerl", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("footerr", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("footnote", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("ftncn", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("ftnsep", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("ftnsepc", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("header", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("headerf", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("headerl", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("headerr", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("info", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("keywords", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("operator", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("pict", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("printim", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("private1", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("revtim", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("rxe", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("stylesheet", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("subject", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("tc", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("title", Rtf_KWD.DEST, Rtf_IDEST.SKIP), new Rtf_SYMBOL("txe", Rtf_KWD.DEST, Rtf_IDEST.SKIP),
    new Rtf_SYMBOL("xe", Rtf_KWD.DEST, Rtf_IDEST.SKIP)
];

const HTML_BACKSLASH = "&#092;";
const HTML_COMMA = "&#044;";
const HTML_HYPHEN = "&#045;";
const STR_2_HTML = 1;
const TASK_PATH_DELIMITER = "@@||@@";
const SEQ_2_HTML = 2;
const HTML_2_STR = 3;
const HTML_2_SEQ = 4;
const SEQ_2_STR = 5;
class StrUtil {
    static mem_trim(str, len) {
        let result;
        if (len > 0) {
            if (len > str.length) {
                result = -1;
                return result;
            }
            while (len > 0 && str[len - 1] === ' ') {
                len = len - 1;
            }
        }
        result = len;
        return result;
    }
    static memmove(dest, destCount, src, srcCount, len) {
        let stringBuilder = new StringBuilder(dest.length + len);
        if (UtilStrByteMode.isLocaleDefLangJPN() && dest.length < destCount) {
            stringBuilder.Append(NString.FromChar(' ', destCount));
        }
        else {
            stringBuilder.Append(dest.substr(0, destCount));
        }
        stringBuilder.Append(src.substr(srcCount, len));
        if (stringBuilder.Length < dest.length) {
            stringBuilder.Append(dest.substr(stringBuilder.Length));
        }
        return stringBuilder.ToString();
    }
    static memcpy(dest, destCount, src, scrCountOrSrcCount, count) {
        if (arguments.length === 5 && (dest === null || dest.constructor === String) && (destCount === null || destCount.constructor === Number) && (src === null || src.constructor === String) && (scrCountOrSrcCount === null || scrCountOrSrcCount.constructor === Number) && (count === null || count.constructor === Number)) {
            return StrUtil.memcpy_0(dest, destCount, src, scrCountOrSrcCount, count);
        }
        StrUtil.memcpy_1(dest, destCount, src, scrCountOrSrcCount, count);
    }
    static memcpy_0(dest, destCount, src, scrCount, count) {
        let stringBuilder = new StringBuilder(dest.substr(0, destCount));
        if (scrCount + count < src.length) {
            stringBuilder.Append(src.substr(scrCount, count - scrCount));
        }
        else {
            stringBuilder.Append(src.substr(scrCount));
        }
        let size = dest.length - destCount - count;
        if (size > 0) {
            stringBuilder.Append(dest.substr(destCount + count));
        }
        return stringBuilder.ToString();
    }
    static memcpy_1(dest, destCount, src, srcCount, count) {
        while (count > 0 && destCount < dest.length && srcCount < src.length) {
            dest[destCount++] = src[srcCount++];
            count = count - 1;
        }
    }
    static memset(dest, destCount, inVal, counter) {
        if (arguments.length === 4 && (dest === null || dest.constructor === String) && (destCount === null || destCount.constructor === Number) && (inVal === null || inVal.constructor === Number) && (counter === null || counter.constructor === Number)) {
            return StrUtil.memset_0(dest, destCount, inVal, counter);
        }
        StrUtil.memset_1(dest, destCount, inVal, counter);
    }
    static memset_0(dest, destCount, inVal, counter) {
        let first = new StringBuilder(dest.substr(0, destCount));
        while (counter > 0) {
            first.Append(inVal);
            counter = counter - 1;
        }
        if (first.Length < dest.length) {
            first.Append(dest.substr(first.Length));
        }
        return first.ToString();
    }
    static memset_1(dest, destCount, inVal, counter) {
        while (counter > 0 && destCount < dest.length) {
            dest[destCount++] = inVal;
            counter = counter - 1;
        }
    }
    static strstr(str, substr) {
        let from = str.indexOf(substr);
        let result;
        if (from < 0) {
            result = null;
        }
        else {
            result = str.substr(from);
        }
        return result;
    }
    static ReverseString(text) {
        let array = NString.ToCharArray(text.ToString());
        array.reverse();
        return new StringBuilder(NString.FromChars(array));
    }
    static rtrim(str) {
        return StrUtil.rtrimWithNull(str, false);
    }
    static rtrimWithNull(str, trimNullChars) {
        let result;
        if (typeof str === "undefined" || str === null || str.length === 0) {
            result = str;
        }
        else {
            let idx = str.length - 1;
            if (trimNullChars) {
                while (idx >= 0 && (str[idx] === ' ' || str[idx] === String.fromCharCode(0))) {
                    idx = idx - 1;
                }
            }
            else {
                while (idx >= 0 && str[idx] === ' ') {
                    idx = idx - 1;
                }
            }
            idx = idx + 1;
            if (idx < str.length) {
                result = str.substr(0, idx);
            }
            else {
                result = str;
            }
        }
        return result;
    }
    static ltrim(str) {
        let length = str.length;
        let i = 0;
        let result;
        if (str === null || length === 0) {
            result = str;
        }
        else {
            while (i < length && str[i] === ' ') {
                i = i + 1;
            }
            if (i > 0) {
                str = str.substr(i);
            }
            result = str;
        }
        return result;
    }
    static DeleteStringsFromEnds(str, strToDelete) {
        if (str.startsWith(strToDelete)) {
            str = str.substr(strToDelete.length);
        }
        if (str.endsWith(strToDelete)) {
            str = str.substr(0, str.length - strToDelete.length);
        }
        let result;
        if (str.length === 0) {
            result = null;
        }
        else {
            result = str;
        }
        return result;
    }
    static padStr(str, len) {
        let padLen = len - str.length;
        if (padLen > 0) {
            if (StrUtil._paddingSpaces === null || StrUtil._paddingSpaces.length < padLen) {
                StrUtil._paddingSpaces = NString.FromChar(' ', padLen);
            }
            let stringBuilder = new StringBuilder(len);
            stringBuilder.Append(str);
            stringBuilder.Append(StrUtil._paddingSpaces, 0, padLen);
            str = stringBuilder.ToString();
        }
        return str;
    }
    static tokenize(source, delim) {
        return source.split(delim);
    }
    static stringToHexaDump(str, minLength) {
        let stringBuilder = new StringBuilder(str.length * minLength);
        for (let indx = 0; indx < str.length; indx = indx + 1) {
            let currInt = str.charCodeAt(indx);
            let hexStr = currInt.toString(16);
            while (hexStr.length < minLength) {
                hexStr = "0" + hexStr;
            }
            stringBuilder.Append(hexStr);
        }
        return stringBuilder.ToString().toUpperCase();
    }
    static searchAndReplace(str, from, to) {
        if (arguments.length === 3 && (str === null || str.constructor === String) && (from === null || from.constructor === String) && (to === null || to.constructor === String)) {
            return StrUtil.searchAndReplace_0(str, from, to);
        }
        return StrUtil.searchAndReplace_1(str, from, to);
    }
    static searchAndReplace_0(str, from, to) {
        let lastSubStr = 0;
        let startSubStr;
        let result;
        if ((startSubStr = str.indexOf(from)) === -1) {
            result = str;
        }
        else {
            let stringBuilder = new StringBuilder(str.length);
            while (startSubStr !== -1) {
                stringBuilder.Append(str.substr(lastSubStr, startSubStr - lastSubStr) + to);
                startSubStr = startSubStr + from.length;
                lastSubStr = startSubStr;
                startSubStr = str.indexOf(from, lastSubStr);
            }
            stringBuilder.Append(str.substr(lastSubStr));
            result = stringBuilder.ToString();
        }
        return result;
    }
    static searchAndReplace_1(str, from, to) {
        let lastSubStr = 0;
        let sarIndex = 0;
        let fromCopy = from.slice();
        let startSubStr;
        let SARindex = new RefParam(0);
        startSubStr = StrUtil.indexOf(str, fromCopy, lastSubStr, SARindex);
        sarIndex = SARindex.value;
        if (startSubStr === -1)
            return str;
        let result;
        let tmpBuf = new StringBuilder(str.length);
        while (startSubStr !== -1) {
            tmpBuf.Append(str.substr(lastSubStr, startSubStr - lastSubStr) + to[sarIndex]);
            startSubStr += fromCopy[sarIndex].length;
            lastSubStr = startSubStr;
            startSubStr = StrUtil.indexOf(str, fromCopy, lastSubStr, SARindex);
            sarIndex = SARindex.value;
        }
        ;
        tmpBuf.Append(str.substr(lastSubStr));
        result = tmpBuf.ToString();
        return result;
    }
    static indexOf(str, strings, offset, SARindex) {
        let minOffset = -1;
        for (let i = 0; i < strings.length; i = i + 1) {
            if (!(strings[i] === null)) {
                let resultOffset = str.indexOf(strings[i], offset);
                if (resultOffset === -1) {
                    strings[i] = null;
                }
                else {
                    if (resultOffset < minOffset || minOffset === -1) {
                        minOffset = resultOffset;
                        SARindex.value = i;
                    }
                }
            }
        }
        let result;
        if (minOffset > -1) {
            result = minOffset;
        }
        else {
            SARindex.value = -1;
            result = -1;
        }
        return result;
    }
    static replaceStringTokens(userString, token, occurrence, val) {
        let tokenLen = token.length;
        let currPosition = 0;
        let newString = userString;
        if (val !== null) {
            let num2 = 0;
            while (num2 < occurrence && currPosition !== -1) {
                currPosition = userString.indexOf(token, currPosition + ((num2 === 0) ? 0 : tokenLen));
                num2 = num2 + 1;
            }
            if (currPosition !== -1) {
                newString = userString.substr(0, currPosition) + val + userString.substr(currPosition + tokenLen, userString.length - (currPosition + tokenLen));
            }
        }
        return newString;
    }
    static makePrintableTokens(source, type) {
        if (arguments.length === 2 && (source === null || source.constructor === String) && (type === null || type.constructor === Number)) {
            return StrUtil.makePrintableTokens_0(source, type);
        }
        StrUtil.makePrintableTokens_1(source, type);
    }
    static makePrintableTokens_0(source, type) {
        let escStr = [
            "\\", "-", ","
        ];
        let escSeq = [
            "\\\\", "\\-", "\\,"
        ];
        let escHtm = [
            HTML_BACKSLASH, HTML_HYPHEN, HTML_COMMA
        ];
        let result;
        switch (type) {
            case STR_2_HTML:
                result = StrUtil.searchAndReplace(source, escStr, escHtm);
                break;
            case SEQ_2_HTML:
                result = StrUtil.searchAndReplace(source, escSeq, escHtm);
                break;
            case HTML_2_SEQ:
                result = StrUtil.searchAndReplace(source, escHtm, escSeq);
                break;
            case HTML_2_STR:
                result = StrUtil.searchAndReplace(source, escHtm, escStr);
                break;
            case SEQ_2_STR:
                result = StrUtil.searchAndReplace(source, escSeq, escStr);
                break;
            default:
                result = source;
                break;
        }
        return result;
    }
    static makePrintableTokens_1(source, type) {
        if (source !== null) {
            let length = source.length;
            for (let i = 0; i < length; i = i + 1) {
                let currElm = source.get_Item(i);
                source.set_Item(i, StrUtil.makePrintableTokens_0(currElm, type));
            }
        }
    }
    static makePrintable(source) {
        let from = [
            "\n", "\r", "'", "\\", "\"", "\0"
        ];
        let to = [
            "\\n", "\\r", "\\'", "\\\\", "\\\"", "\\0"
        ];
        return StrUtil.searchAndReplace(source, from, to);
    }
    static makePrintable2(source) {
        let from = [
            "\n", "\r", "\0"
        ];
        let to = [
            "\\n", "\\r", "\\0"
        ];
        return StrUtil.searchAndReplace(source, from, to);
    }
    static ZstringMake(s, len) {
        len = StrUtil.mem_trim(s, len);
        return s.substr(0, len);
    }
    static GetPlainTextfromRtf(rtfText) {
        if (Rtf.isRtf(rtfText)) {
            let rtf = new Rtf();
            let outputTxt = new StringBuilder("");
            rtf.toTxt(rtfText, outputTxt);
            rtfText = outputTxt.ToString();
        }
        return rtfText;
    }
    static StringsArraysEqual(str1, str2) {
        let result;
        if (str1 === null && str2 === null) {
            result = true;
        }
        else {
            if (str1 === null || str2 === null) {
                result = false;
            }
            else {
                if (str1.length !== str2.length) {
                    result = false;
                }
                else {
                    for (let index = 0; index < str1.length; index = index + 1) {
                        if ((str1[index] !== str2[index])) {
                            result = false;
                            return result;
                        }
                    }
                    result = true;
                }
            }
        }
        return result;
    }
    static SearchAndReplaceWildChars(buf, len, filler) {
        buf = NString.PadRight(buf, len);
        let escChar = false;
        let tmpBuf = new StringBuilder(len);
        for (let i = 0; i < len; i = i + 1) {
            switch (buf[i]) {
                case ('\\'):
                    {
                        let isNextCharWild = true;
                        if ((i + 1 < len) && (buf[i + 1] != '*' && buf[i + 1] != '\\'))
                            isNextCharWild = false;
                        if (escChar || !isNextCharWild)
                            tmpBuf.Append(buf[i]);
                        escChar = !escChar;
                    }
                    break;
                case ('*'):
                    if (escChar)
                        tmpBuf.Append(buf[i]);
                    else {
                        tmpBuf.Append(filler, len - tmpBuf.Length);
                    }
                    escChar = false;
                    break;
                case '?':
                    tmpBuf.Append(filler);
                    escChar = false;
                    break;
                default:
                    tmpBuf.Append(buf[i]);
                    escChar = false;
                    break;
            }
        }
        let text = tmpBuf.ToString();
        return NString.TrimEnd(NString.TrimEnd(text, ['\0']));
    }
    static getConsoleErorString(source) {
        let consoleErorString = "";
        if (!isNullOrUndefined(source))
            consoleErorString = this.searchAndReplace(source, TASK_PATH_DELIMITER, "");
        return consoleErorString;
    }
    static getMsgBoxErorString(source) {
        let tokens;
        let msgBoxErorString = new StringBuilder("");
        if (!isNullOrUndefined(source)) {
            tokens = this.tokenize(source, TASK_PATH_DELIMITER);
            for (let i = 0; i < tokens.length; i++) {
                msgBoxErorString.Append(tokens[i]);
                i++;
            }
        }
        return msgBoxErorString.toString();
    }
}
StrUtil._paddingSpaces = null;

class Misc {
    static WriteStackTrace(throwable) {
        console.log(throwable.Message);
        console.log(throwable.StackTrace);
    }
    static ToSByteArray(byteArray) {
        let sbyteArray = null;
        if (byteArray !== null) {
            sbyteArray = new Int8Array(byteArray.length);
            for (let i = 0; i < byteArray.length; i = i + 1) {
                sbyteArray[i] = byteArray[i];
            }
        }
        return sbyteArray;
    }
    static ToByteArray(sbyteArray) {
        let byteArray = null;
        if (sbyteArray !== null) {
            byteArray = new Uint8Array(sbyteArray.length);
            for (let i = 0; i < sbyteArray.length; i = i + 1) {
                byteArray[i] = sbyteArray[i];
            }
        }
        return byteArray;
    }
    static CompareByteArray(source, destination, numberOfBytes) {
        if (source.length >= numberOfBytes && destination.length >= numberOfBytes) {
            for (let len = 0; len < numberOfBytes; len++) {
                if (source[len] !== destination[len])
                    return false;
            }
        }
        else
            return false;
        return true;
    }
    static URShift(number, bits) {
        let result;
        if (number >= 0) {
            result = number >> bits;
        }
        else {
            result = (number >> bits) + (2 << ~bits);
        }
        return result;
    }
    static getSystemMilliseconds() {
        return Math.floor((DateTime.Now.Ticks - 621355968000000000) / 10000);
    }
    static CompareIntArrays(arrayOne, arrayTwo) {
        let areEqual = false;
        if (arrayOne === arrayTwo) {
            areEqual = true;
        }
        else {
            if (arrayOne !== null && arrayTwo !== null) {
                if (arrayOne.length === arrayTwo.length) {
                    for (let i = 0; i < arrayOne.length; i = i + 1) {
                        if (arrayOne[i] !== arrayTwo[i]) {
                            break;
                        }
                        areEqual = true;
                    }
                }
            }
        }
        return areEqual;
    }
    static GetCommaSeperatedString(intArray) {
        let temp = new StringBuilder();
        for (let val = 0; val < intArray.length; val = val + 1) {
            let value = intArray[val];
            if (temp.Length > 0) {
                temp.Append(",");
            }
            temp.Append(value);
        }
        return temp.ToString();
    }
    static GetIntArray(commaSeparatedValue) {
        let intArray = new Array(0);
        if (!NString.IsNullOrEmpty(commaSeparatedValue)) {
            let vals = commaSeparatedValue.split(',');
            intArray = new Array(vals.length);
            let outInt = new RefParam(0);
            for (let iCtr = 0; iCtr < vals.length; iCtr = iCtr + 1) {
                NNumber.TryParse(vals[iCtr], outInt);
                intArray[iCtr] = outInt.value;
            }
        }
        return intArray;
    }
    static IsWebUrl(fileName) {
        return fileName.toLowerCase().startsWith("http");
    }
}

class Base64 {
    static encode(str, isUseEnvCharset, encoding) {
        if (arguments.length === 1)
            return Base64.encode_1(str, false, null);
        else
            return Base64.encode_1(str, isUseEnvCharset, encoding);
    }
    static encode_1(str, isUseEnvCharset, encoding) {
        let result;
        if (str === null) {
            result = null;
        }
        else {
            if (str === "") {
                result = str;
            }
            else {
                try {
                    if (isUseEnvCharset === false) {
                        result = btoa(str);
                    }
                    else {
                        let instance = ISO_8859_1_Encoding.ISO_8859_1;
                        let encoding2 = isUseEnvCharset ? encoding : instance;
                        let ba = Base64.encodeBytes(encoding2.GetBytes(str));
                        result = instance.GetString(ba, 0, ba.length);
                    }
                }
                catch (ex) {
                    throw new ApplicationException(ex.Message);
                }
            }
        }
        return result;
    }
    static encodeBytes(data) {
        if (data === null)
            return null;
        let dest = new Uint8Array(Math.floor((data.length + 2) / 3) * 4);
        let sidx = 0;
        let didx = 0;
        while (sidx < data.length - 2) {
            dest[didx++] = Base64._base64EncMap[Misc.URShift(data[sidx], 2) & 63];
            dest[didx++] = Base64._base64EncMap[(Misc.URShift(data[sidx + 1], 4) & 15) | (data[sidx] << 4 & 63)];
            dest[didx++] = Base64._base64EncMap[(Misc.URShift(data[sidx + 2], 6) & 3) | (data[sidx + 1] << 2 & 63)];
            dest[didx++] = Base64._base64EncMap[(data[sidx + 2] & 63)];
            sidx = sidx + 3;
        }
        if (sidx < data.length) {
            dest[didx++] = Base64._base64EncMap[Misc.URShift(data[sidx], 2) & 63];
            if (sidx < data.length - 1) {
                dest[didx++] = Base64._base64EncMap[(Misc.URShift(data[sidx + 1], 4) & 15) | (data[sidx] << 4 & 63)];
                dest[didx++] = Base64._base64EncMap[data[sidx + 1] << 2 & 63];
            }
            else {
                dest[didx++] = Base64._base64EncMap[data[sidx] << 4 & 63];
            }
        }
        while (didx < dest.length) {
            dest[didx] = 61;
            didx = didx + 1;
        }
        return dest;
    }
    static decode(str, encoding) {
        if (arguments.length === 1)
            encoding = null;
        return Base64.decode_1(str, encoding);
    }
    static decode_1(str, encoding) {
        let result;
        if (str === null) {
            result = null;
        }
        else {
            if (str === "") {
                result = str;
            }
            else {
                try {
                    if (encoding === null || encoding === undefined) {
                        result = atob(str);
                    }
                    else {
                        let instance = ISO_8859_1_Encoding.ISO_8859_1;
                        let array = Base64.decodeBytes(instance.GetBytes(str));
                        let encoding2 = (encoding !== null) ? encoding : instance;
                        result = encoding2.GetString(array, 0, array.length);
                    }
                }
                catch (ex) {
                    throw new ApplicationException(ex.Message);
                }
            }
        }
        return result;
    }
    static decodeBytes(data) {
        if (data === null)
            return null;
        let tail = data.length;
        while (data[tail - 1] === '='.charCodeAt(0)) {
            tail = tail - 1;
        }
        let dest = new Uint8Array(tail - Math.floor(data.length / 4));
        for (let idx = 0; idx < data.length; idx = idx + 1) {
            data[idx] = Base64._base64DecMap[data[idx]];
        }
        let sidx = 0;
        let didx;
        for (didx = 0; didx < dest.length - 2; didx = didx + 3) {
            dest[didx] = (((data[sidx] << 2) & 255) | (Misc.URShift(data[sidx + 1], 4) & 3));
            dest[didx + 1] = (((data[sidx + 1] << 4) & 255) | (Misc.URShift(data[sidx + 2], 2) & 15));
            dest[didx + 2] = (((data[sidx + 2] << 6) & 255) | (data[sidx + 3] & 63));
            sidx = sidx + 4;
        }
        if (didx < dest.length)
            dest[didx] = (((data[sidx] << 2) & 255) | (Misc.URShift(data[sidx + 1], 4) & 3));
        if ((didx = didx + 1) < dest.length)
            dest[didx] = (((data[sidx + 1] << 4) & 255) | (Misc.URShift(data[sidx + 2], 2) & 15));
        return dest;
    }
    static decodeToHex(str) {
        if (str === null)
            return null;
        if (str === "")
            return str;
        return StrUtil.stringToHexaDump(Base64.decode(str), 2);
    }
    static decodeToByte(str) {
        if (str === null)
            return null;
        if (str === "" || str === " ")
            return new Uint8Array(0);
        try {
            let instance = ISO_8859_1_Encoding.ISO_8859_1;
            return Base64.decodeBytes(instance.GetBytes(str));
        }
        catch (ex) {
            throw new ApplicationException(ex.Message);
        }
    }
    static initializeEncMap() {
        return new Uint8Array([
            65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
            84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
            110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54,
            55, 56, 57, 43, 47
        ]);
    }
    static initializeDecMap() {
        let decMap = new Uint8Array(128);
        for (let i = 0; i < Base64._base64EncMap.length; i = i + 1) {
            decMap[Base64._base64EncMap[i]] = i;
        }
        return decMap;
    }
}
Base64._base64EncMap = Base64.initializeEncMap();
Base64._base64DecMap = Base64.initializeDecMap();

class ChoiceUtils {
    static GetDisplayListFromString(choiceDispStr, removeAccelerators, shouldMakePrintable, shouldTrimOptions) {
        let fromHelp = new Array("\\\\", "\\-", "\\,");
        let toHelp = new Array("XX", "XX", "XX");
        choiceDispStr = NString.TrimEnd(choiceDispStr);
        let helpStrDisp = StrUtil.searchAndReplace(choiceDispStr, fromHelp, toHelp);
        let sTok = StrUtil.tokenize(helpStrDisp, ",");
        let size = (helpStrDisp !== "" ? sTok.length : 0);
        let tokenBuffer;
        let helpTokenDisp, token;
        let currPosDisp = 0, nextPosDisp = 0, tokenPosDisp, i = 0;
        let choiceDisp = new Array(size);
        for (; i < size; i++) {
            nextPosDisp = currPosDisp;
            nextPosDisp = helpStrDisp.indexOf(',', nextPosDisp);
            if (nextPosDisp === currPosDisp)
                token = helpTokenDisp = "";
            else if (nextPosDisp === -1) {
                token = choiceDispStr.substr(currPosDisp);
                helpTokenDisp = helpStrDisp.substr(currPosDisp);
            }
            else {
                token = choiceDispStr.substr(currPosDisp, (nextPosDisp) - (currPosDisp));
                helpTokenDisp = helpStrDisp.substr(currPosDisp, (nextPosDisp) - (currPosDisp));
            }
            currPosDisp = nextPosDisp + 1;
            if (token != null) {
                token = StrUtil.ltrim(token);
                if (removeAccelerators)
                    token = ChoiceUtils.RemoveAcclCharFromOptions(new StringBuilder(token));
                helpTokenDisp = StrUtil.ltrim(helpTokenDisp);
                if (removeAccelerators)
                    helpTokenDisp = ChoiceUtils.RemoveAcclCharFromOptions(new StringBuilder(helpTokenDisp));
            }
            if (helpTokenDisp.indexOf('\\') >= 0) {
                tokenBuffer = new StringBuilder();
                for (; tokenPosDisp < helpTokenDisp.length; tokenPosDisp++)
                    if (helpTokenDisp[tokenPosDisp] !== '\\')
                        tokenBuffer.Append(token[tokenPosDisp]);
                    else if (tokenPosDisp === helpTokenDisp.length - 1)
                        tokenBuffer.Append(' ');
                token = tokenBuffer.ToString();
            }
            if (shouldMakePrintable) {
                token = StrUtil.makePrintableTokens(token, SEQ_2_STR);
                if (shouldTrimOptions) {
                    let temp = NString.TrimEnd(token);
                    if (temp.length === 0)
                        choiceDisp[i] = " ";
                    else
                        choiceDisp[i] = NString.TrimEnd(token);
                }
                else
                    choiceDisp[i] = token;
            }
            else
                choiceDisp[i] = token;
        }
        return choiceDisp;
    }
    static RemoveAcclCharFromOptions(OptionStr) {
        let i = 0;
        if (OptionStr != null) {
            for (; i < OptionStr.Length;) {
                if (OptionStr.get_Item(i) === '&') {
                    if (i < OptionStr.Length - 1 && OptionStr.get_Item(i + 1) === ('&'))
                        i++;
                    OptionStr = OptionStr.Remove(i, 1);
                }
                else
                    i++;
            }
        }
        return (OptionStr != null ? OptionStr.ToString() : null);
    }
}

class Constants {
    constructor() {
    }
}
Constants.NULL_ARITH_NULLIFY = 'N';
Constants.NULL_ARITH_USE_DEF = 'U';
Constants.SELPRG_MODE_BEFORE = 'B';
Constants.SELPRG_MODE_AFTER = 'A';
Constants.SELPRG_MODE_PROMPT = 'P';
Constants.MOVE_UNIT_TABLE = 'T';
Constants.MOVE_UNIT_PAGE = 'P';
Constants.MOVE_UNIT_ROW = 'R';
Constants.MOVE_UNIT_TREE_NODE = 'E';
Constants.MOVE_DIRECTION_NONE = ' ';
Constants.MOVE_DIRECTION_BEGIN = 'B';
Constants.MOVE_DIRECTION_PREV = 'P';
Constants.MOVE_DIRECTION_NEXT = 'N';
Constants.MOVE_DIRECTION_END = 'E';
Constants.MOVE_DIRECTION_PARENT = 'A';
Constants.MOVE_DIRECTION_FIRST_SON = 'F';
Constants.MOVE_DIRECTION_NEXT_SIBLING = 'X';
Constants.MOVE_DIRECTION_PREV_SIBLING = 'V';
Constants.TASK_REFRESH_FORM = 'F';
Constants.TASK_REFRESH_TABLE = 'T';
Constants.TASK_REFRESH_TREE_AND_FORM = 'R';
Constants.TASK_REFRESH_CURR_REC = 'C';
Constants.TASK_REFRESH_NONE = 'N';
Constants.TASK_MODE_QUERY = 'E';
Constants.TASK_MODE_MODIFY = 'M';
Constants.TASK_MODE_CREATE = 'C';
Constants.TASK_MODE_DELETE = 'D';
Constants.TASK_MODE_NONE = ' ';
Constants.TASK_LEVEL_NONE = ' ';
Constants.TASK_LEVEL_TASK = 'T';
Constants.TASK_LEVEL_RECORD = 'R';
Constants.TASK_LEVEL_CONTROL = 'C';
Constants.MG_DATAVIEW_FIRST_RECORD = Int32.MinValue;
Constants.MG_DATAVIEW_LAST_RECORD = Int32.MaxValue;
Constants.ACT_STT_TBL_SCREEN_MODE = 0x0001;
Constants.ACT_STT_TBL_LEFT_TO_RIGHT = 0x0002;
Constants.ACT_STT_TBL_SCREEN_TOP = 0x0004;
Constants.ACT_STT_TBL_SCREEN_END = 0x0008;
Constants.ACT_STT_TBL_ROW_START = 0x0010;
Constants.ACT_STT_TBL_ROW_END = 0x0020;
Constants.ACT_STT_EDT_LEFT_TO_RIGHT = 0x0040;
Constants.ACT_STT_EDT_FORM_TOP = 0x0080;
Constants.ACT_STT_EDT_FORM_END = 0x0100;
Constants.ACT_STT_EDT_LINE_START = 0x0200;
Constants.ACT_STT_EDT_LINE_END = 0x0400;
Constants.ACT_STT_EDT_EDITING = 0x0800;
Constants.ACT_STT_TREE_PARK = 0x1000;
Constants.ACT_STT_TREE_EDITING = 0x2000;
Constants.ForwardSlashWebUsage = "web";
Constants.HTTP_PROTOCOL = "http://";
Constants.HTTPS_PROTOCOL = "https://";
Constants.FILE_PROTOCOL = "file://";
Constants.MG_GUI_THREAD = "MG_GUI_THREAD";
Constants.MG_WORK_THREAD = "MG_WORK_THREAD";
Constants.MG_TIMER_THREAD = "MG_TIMER_THREAD";
Constants.ConfigurationFilePropertyName = "Configuration file";
Constants.WinPropText = "Text";
Constants.WinPropLayer = "Layer";
Constants.WinPropX1 = "X1";
Constants.WinPropX2 = "X2";
Constants.WinPropY1 = "Y1";
Constants.WinPropY2 = "Y2";
Constants.WinPropIsTransparent = "IsTransparent";
Constants.WinPropName = "Name";
Constants.WinPropVisible = "Visible";
Constants.WinPropVisibleLayerList = "VisibleLayerList";
Constants.TabOrderPropertyTermination = "ForTabOrder";
Constants.SByteMaxValue = 127;

class XMLConstants {
    constructor() {
    }
}
XMLConstants.MG_TAG_XML = "xml";
XMLConstants.MG_TAG_XML_END = "/xml";
XMLConstants.TAG_TERM = "/>";
XMLConstants.TAG_OPEN = "<";
XMLConstants.TAG_CLOSE = ">";
XMLConstants.XML_ATTR_DELIM = "\"";
XMLConstants.START_TAG = "\n   <";
XMLConstants.END_TAG = "</";
XMLConstants.XML_TAB = "   ";
XMLConstants.MG_ATTR_ID = "id";
XMLConstants.MG_TAG_XML_END_TAGGED = XMLConstants.END_TAG + XMLConstants.MG_TAG_XML + XMLConstants.TAG_CLOSE;
XMLConstants.MG_TAG_OPEN = XMLConstants.TAG_OPEN + XMLConstants.MG_TAG_XML + " " + XMLConstants.MG_ATTR_ID + "=\"MGDATA\">";
XMLConstants.MG_TAG_TASK = "task";
XMLConstants.MG_TAG_TASK_END = "/task";
XMLConstants.MG_TAG_RECOMPUTE = "recompute";
XMLConstants.MG_ATTR_VB_VIEW_ROWIDX = "db_view_rowidx";
XMLConstants.MG_ATTR_CONTROL_ISN = "controlIsn";
XMLConstants.MG_HOR_ALIGMENT_IS_INHERITED = "horizontalAlignmentIsFromSystemDefault";
XMLConstants.MAX_PATH = 260;
XMLConstants.FILE_NAME_SIZE = XMLConstants.MAX_PATH + 1;
XMLConstants.CDATA_START = "<![CDATA[";
XMLConstants.CDATA_END = "]]>";
XMLConstants.MG_ATTR_VALUE = "val";
XMLConstants.MG_ATTR_STUDIO_VALUE = "studioValue";
XMLConstants.MG_ATTR_NAME = "name";
XMLConstants.MG_ATTR_TYPE = "type";
XMLConstants.MG_ATTR_SIZE = "size";
XMLConstants.MG_ATTR_VAR_NAME = "var_name";
XMLConstants.MG_ATTR_VAR_DISP_NAME = "var_disp_name";
XMLConstants.MG_ATTR_VEC_CELLS_SIZE = "vecCellsSize";
XMLConstants.MG_ATTR_VEC_CELLS_ATTR = "vec_cells_attr";
XMLConstants.MG_ATTR_VEC_CELLS_CONTENT = "CellContentType";
XMLConstants.MG_ATTR_NULLVALUE = "nullvalue";
XMLConstants.MG_ATTR_NULLDISPLAY = "nulldisplay";
XMLConstants.MG_ATTR_NULLDEFAULT = "nulldefault";
XMLConstants.MG_ATTR_DB_MODIFIABLE = "db_modifiable";
XMLConstants.MG_ATTR_DEFAULTVALUE = "defaultvalue";
XMLConstants.MG_ATTR_NULLALLOWED = "nullallowed";
XMLConstants.MG_ATTR_BLOB_CONTENT = "ContentType";
XMLConstants.MG_ATTR_PART_OF_DATAVIEW = "partOfDataview";
XMLConstants.MG_ATTR_DATA_TYPE = "dataType";
XMLConstants.MG_ATTR_DATA_CTRL = "data_ctrl";
XMLConstants.MG_ATTR_LINKED_PARENT = "linked_parent";
XMLConstants.MG_ATTR_CONTAINER = "container";
XMLConstants.MG_ATTR_IS_FRAMESET = "isFrameSet";
XMLConstants.MG_ATTR_IS_LIGAL_RC_FORM = "isLegalRcForm";
XMLConstants.MG_ATTR_USERSTATE_ID = "userStateId";
XMLConstants.MG_ATTR_PB_IMAGES_NUMBER = "PBImagesNumber";
XMLConstants.MG_ATTR_FORM_ISN = "formIsn";
XMLConstants.MG_ATTR_TASKID = "taskid";
XMLConstants.MG_ATTR_IS_MODAL = "IsModal";
XMLConstants.MG_ATTR_TASK_IS_SERIALIZATION_PARTIAL = "isSerializationPartial";
XMLConstants.MG_ATTR_XML_TRUE = "1";
XMLConstants.MG_ATTR_XML_FALSE = "0";
XMLConstants.MG_ATTR_TOOLKIT_PARENT_TASK = "toolkit_parent_task";
XMLConstants.MG_ATTR_CTL_IDX = "ctl_idx";
XMLConstants.MG_ATTR_MAINPRG = "mainprg";
XMLConstants.MG_ATTR_NULL_ARITHMETIC = "nullArithmetic";
XMLConstants.MG_ATTR_INTERACTIVE = "interactive";
XMLConstants.MG_ATTR_IS_OFFLINE = "IsOffline";
XMLConstants.MG_ATTR_RETURN_VALUE_EXP = "returnValueExp";
XMLConstants.MG_ATTR_PARALLEL = "ParallelExecution";
XMLConstants.MG_ATTR_OPEN_WIN = "OpenWin";
XMLConstants.MG_ATTR_ALLOW_EVENTS = "AllowEvents";
XMLConstants.MG_ATTR_ISPRG = "isPrg";
XMLConstants.MG_ATTR_APPL_GUID = "applicationGuid";
XMLConstants.MG_ATTR_PROGRAM_ISN = "programIsn";
XMLConstants.MG_ATTR_TASK_ISN = "taskIsn";
XMLConstants.MG_ATTR_ROUTER_PATH = "RouterPath";
XMLConstants.MG_ATTR_IN_DEFAULT_ROUTER_OUTLET = "InDefaultRouterOutlet";
XMLConstants.MG_ATTR_EXPAND = "expand";
XMLConstants.MG_ATTR_EXP = "exp";
XMLConstants.MG_ATTR_ERROR_EXP = "errorExp";
XMLConstants.MG_ATTR_ERROR = "errorMsg";
XMLConstants.MG_ATTR_IS_GENERIC = "isGeneric";
XMLConstants.MG_ATTR_HASHCODE = "hashCode";
XMLConstants.MG_ATTR_PICTURE = "picture";
XMLConstants.MG_ATTR_STORAGE = "storage";
XMLConstants.MG_ATTR_DITIDX = "ditidx";
XMLConstants.MG_ATTR_ICON_FILE_NAME = "iconFileName";
XMLConstants.MG_ATTR_SYS_CONTEXT_MENU = "systemContextMenu";
XMLConstants.MG_TAG_FLDH = "fldh";
XMLConstants.MG_TAG_DVHEADER = "dvheader";
XMLConstants.MG_ATTR_MENUS_FILE_NAME = "menusFileName";
XMLConstants.MG_ATTR_MENU_CONTENT = "MenusContent";
XMLConstants.MG_ATTR_SORT_BY_RECENTLY_USED = "SortWindowListByRecentlyUsed";
XMLConstants.MG_ATTR_CONTROL_Z_ORDER = "zorder";
XMLConstants.MG_TAG_PROP = "prop";
XMLConstants.MG_TAG_CONTROL = "control";
XMLConstants.MG_TAG_FORM = "form";
XMLConstants.MG_TAG_FORM_PROPERTIES = "propertiesForm";
XMLConstants.MG_TAG_FORMS = "forms";
XMLConstants.MG_TAG_TREE = "tree";
XMLConstants.MG_TAG_NODE = "node";
XMLConstants.MG_TAG_FLD = "fld";
XMLConstants.MG_ATTR_CHILDREN_RETRIEVED = "children_retrieved";
XMLConstants.MG_TAG_HELPTABLE = "helptable";
XMLConstants.MG_TAG_HELPITEM = "helpitem";
XMLConstants.MG_ATTR_FULLNAME = "fullname";
XMLConstants.MG_ATTR_ISSPECIFIC = "isSpecific";
XMLConstants.MG_ATTR_IS_GUI_THREAD_EXECUTION = "isGuiThreadExecution";
XMLConstants.MG_TAG_TASKDEFINITIONID_ENTRY = "taskDefinitionId";
XMLConstants.MG_TAG_OBJECT_REFERENCE = "objectRef";
XMLConstants.MG_ATTR_HLP_TYP_TOOLTIP = "T";
XMLConstants.MG_ATTR_HLP_TYP_PROMPT = "P";
XMLConstants.MG_ATTR_HLP_TYP_URL = "U";
XMLConstants.MG_ATTR_HLP_TYP_INTERNAL = "I";
XMLConstants.MG_ATTR_HLP_TYP_WINDOWS = "W";
XMLConstants.MG_ATTR_INTERNAL_HELP_TYPE = "type";
XMLConstants.MG_ATTR_INTERNAL_HELP_NAME = "name";
XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEX = "framex";
XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEY = "framey";
XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEDX = "famedx";
XMLConstants.MG_ATTR_INTERNAL_HELP_FRAMEDY = "framedy";
XMLConstants.MG_ATTR_INTERNAL_HELP_SIZEDX = "sizedx";
XMLConstants.MG_ATTR_INTERNAL_HELP_SIZEDY = "sizedy";
XMLConstants.MG_ATTR_INTERNAL_HELP_FACTORX = "factorx";
XMLConstants.MG_ATTR_INTERNAL_HELP_FACTORY = "factory";
XMLConstants.MG_ATTR_INTERNAL_HELP_BORDERSTYLE = "borderstyle";
XMLConstants.MG_ATTR_INTERNAL_TITLE_BAR = "titlebar";
XMLConstants.MG_ATTR_INTERNAL_HELP_SYSTEM_MENU = "sysmenu";
XMLConstants.MG_ATTR_INTERNAL_HELP_FONT_TABLE_INDEX = "fonttableindex";
XMLConstants.MG_ATTR_WINDOWS_HELP_FILE = "file";
XMLConstants.MG_ATTR_WINDOWS_HELP_COMMAND = "command";
XMLConstants.MG_ATTR_WINDOWS_HELP_KEY = "key";
XMLConstants.MG_TAG_PRINT_DATA = "Print_data";
XMLConstants.MG_TAG_PRINT_DATA_END = "/Print_data";
XMLConstants.MG_TAG_RECORD = "Record";
XMLConstants.MG_TAG_RECORD_END = "/Record";
XMLConstants.MG_TAG_CUSTOM_VALIDATORS = "CustomValidators";
XMLConstants.MG_TAG_CUSTOM_VALIDATORS_END = "/CustomValidators";
XMLConstants.MG_TAG_CUSTOM_VALIDATOR = "CustomValidator";
XMLConstants.ERROR_LOG_TIME_FORMAT = "HH:mm:ss.S";
XMLConstants.ERROR_LOG_DATE_FORMAT = "DD/MM/YYYY";
XMLConstants.HTTP_ERROR_TIME_FORMAT = "HH:mm:ss";
XMLConstants.CACHED_DATE_TIME_FORMAT = "DD/MM/YYYY HH:mm:ss";
XMLConstants.MG_TAG_WS_READ_REQUEST = "Read";
XMLConstants.MG_TAG_WS_CREATE_REQUEST = "Create";
XMLConstants.MG_TAG_WS_CREATE_REQUEST_END = "/Create";
XMLConstants.MG_TAG_WS_UPDATE_REQUEST = "Update";
XMLConstants.MG_TAG_WS_UPDATE_REQUEST_END = "/Update";
XMLConstants.MG_TAG_WS_DELETE_REQUEST = "Delete";
XMLConstants.MG_TAG_WS_DELETE_REQUEST_END = "/Delete";
XMLConstants.MG_TAG_WS_MANIPULATE_REQUEST = "Manipulate";
XMLConstants.MG_TAG_WS_MANIPULATE_REQUEST_END = "/Manipulate";
XMLConstants.MG_TAG_WS_DATABASE = "Database";
XMLConstants.MG_TAG_WS_DATASOURCE = "Datasource";
XMLConstants.MG_TAG_WS_COLUMNS = "Columns";
XMLConstants.MG_TAG_WS_COLUMN = "string";
XMLConstants.MG_TAG_WS_RANGES = "Ranges";
XMLConstants.MG_TAG_WS_RANGES_END = "/Ranges";
XMLConstants.MG_TAG_WS_MIN = "Min";
XMLConstants.MG_TAG_WS_MAX = "Max";
XMLConstants.MG_TAG_WS_RECORD = "Row";
XMLConstants.MG_TAG_WS_RECORD_END = "/Row";
XMLConstants.MG_TAG_WS_WHERE = "Where";
XMLConstants.MG_TAG_WS_WHERE_END = "/Where";
XMLConstants.MG_TAG_WS_RESPONSE = "Response";
XMLConstants.MG_TAG_WS_ERROR = "Error";
XMLConstants.MG_TAG_WS_ERROR_CODE = "errorCode";
XMLConstants.MG_TAG_WS_DESCRIPTION = "description";
XMLConstants.MG_TAG_MENUS_OPEN = "Menus";
XMLConstants.MG_TAG_MENUS_CLOSE = "/Menus";
XMLConstants.MG_TAG_MENU = "Menu";

class DateTimeUtils {
    static int2str(n) {
        return (n > 9) ? n.toString() : ("0" + n);
    }
    static ToString(dateTime, format, logger) {
        let dateTimeString;
        try {
            dateTimeString = dateTime.Format(format);
        }
        catch (ex) {
            if (ex instanceof Exception) {
                if (format === XMLConstants.CACHED_DATE_TIME_FORMAT) {
                    dateTimeString = DateTimeUtils.int2str(dateTime.Day) + "/" + DateTimeUtils.int2str(dateTime.Month) + "/" + dateTime.Year + " " +
                        DateTimeUtils.int2str(dateTime.Hour) + ":" + DateTimeUtils.int2str(dateTime.Minute) + ":" +
                        DateTimeUtils.int2str(dateTime.Second);
                }
                else {
                    if (format === XMLConstants.ERROR_LOG_TIME_FORMAT) {
                        dateTimeString = DateTimeUtils.int2str(dateTime.Hour) + ":" +
                            DateTimeUtils.int2str(dateTime.Minute) + ":" +
                            DateTimeUtils.int2str(dateTime.Second) + ".";
                        if (dateTime.Millisecond % 100 > 50) {
                            dateTimeString = dateTimeString + (Math.floor(dateTime.Millisecond / 100) + 1);
                        }
                        else {
                            dateTimeString = dateTimeString + Math.floor(dateTime.Millisecond / 100);
                        }
                    }
                    else {
                        if (format === XMLConstants.ERROR_LOG_DATE_FORMAT) {
                            dateTimeString = DateTimeUtils.int2str(dateTime.Day) + "/" + DateTimeUtils.int2str(dateTime.Month) + "/" + dateTime.Year;
                        }
                        else {
                            if (format === XMLConstants.HTTP_ERROR_TIME_FORMAT) {
                                dateTimeString = DateTimeUtils.int2str(dateTime.Hour) + ":" + DateTimeUtils.int2str(dateTime.Minute) + ":" + DateTimeUtils.int2str(dateTime.Second) + ".";
                            }
                            else {
                                logger.WriteExceptionToLogWithMsg(ex.Message);
                                let dateTimeTmpString = new StringBuilder();
                                dateTimeString = dateTimeTmpString.ToString();
                            }
                        }
                    }
                }
            }
            else
                throw ex;
        }
        return dateTimeString;
    }
}

class PICInterface {
    constructor() {
    }
}
PICInterface.PIC_X = 1;
PICInterface.PIC_U = 2;
PICInterface.PIC_L = 3;
PICInterface.PIC_N = 4;
PICInterface.PIC_YY = 5;
PICInterface.PIC_YYYY = 6;
PICInterface.PIC_MMD = 7;
PICInterface.PIC_MMM = 8;
PICInterface.PIC_DD = 9;
PICInterface.PIC_DDD = 10;
PICInterface.PIC_DDDD = 11;
PICInterface.PIC_W = 12;
PICInterface.PIC_WWW = 13;
PICInterface.PIC_HH = 14;
PICInterface.PIC_MMT = 15;
PICInterface.PIC_SS = 16;
PICInterface.PIC_PM = 17;
PICInterface.PIC_HYYYYY = 18;
PICInterface.PIC_HL = 19;
PICInterface.PIC_HDD = 20;
PICInterface.PIC_MS = 21;
PICInterface.PIC_LOCAL = 23;
PICInterface.PIC_MAX_MSK_LEN = 100;
PICInterface.PIC_JY1 = PICInterface.PIC_LOCAL + 0;
PICInterface.PIC_JY2 = PICInterface.PIC_LOCAL + 1;
PICInterface.PIC_JY4 = PICInterface.PIC_LOCAL + 2;
PICInterface.PIC_YJ = PICInterface.PIC_LOCAL + 3;
PICInterface.PIC_BB = PICInterface.PIC_LOCAL + 4;
PICInterface.PIC_J = PICInterface.PIC_LOCAL + 5;
PICInterface.PIC_T = PICInterface.PIC_LOCAL + 6;
PICInterface.PIC_G = PICInterface.PIC_LOCAL + 7;
PICInterface.PIC_S = PICInterface.PIC_LOCAL + 8;
PICInterface.PIC_MAX_OP = 31;
PICInterface.NULL_CHAR = -1;
PICInterface.DB_STR_MAX = 255;
PICInterface.DAYSINFOURCENT = 146097;
PICInterface.DAYSINCENTURY = 36524;
PICInterface.DAYSINFOURYEAR = 1461;
PICInterface.DAYSINYEAR = 365;
PICInterface.DAYSINMONTH = 31;
PICInterface.DATE_BUDDHIST_GAP = 543;
PICInterface.DEFAULT_DATE = "693961";
PICInterface.DEFAULT_TIME = "0";
PICInterface.date_day_tab = [
    0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365
];
PICInterface.date_month_str = [
    "          ", "January   ", "February  ", "March     ", "April     ", "May       ", "June      ", "July      ", "August    ", "September ", "October   ", "November  ", "December  "
];
PICInterface.date_dow_str = [
    "          ", "Sunday    ", "Monday    ", "Tuesday   ", "Wednesday ", "Thursday  ", "Friday    ", "Saturday  "
];
PICInterface.NumDirective = [
    4, 5, 6, 7, 9, 10, 11, 12, 14, 15, 16
];

const DATE_MONTH_LEN = 10;
const DATE_DOW_LEN = 10;
class DateUtil {
    static getLocalMonths(names) {
        let monthLen = DATE_MONTH_LEN;
        if (typeof DateUtil._localMonths[0] === "undefined") {
            if (names !== null) {
                DateUtil._localMonths[0] = PICInterface.date_month_str[0];
                for (let i = 1; i < DateUtil._localMonths.length; i = i + 1) {
                    if (i * monthLen >= names.length) {
                        DateUtil._localMonths[i] = names.substr((i - 1) * monthLen);
                        while (monthLen - DateUtil._localMonths[i].length > 0) {
                            DateUtil._localMonths[i] = DateUtil._localMonths[i] + " ";
                        }
                    }
                    else {
                        DateUtil._localMonths[i] = names.substr((i - 1) * monthLen, i * monthLen - (i - 1) * monthLen);
                    }
                }
            }
            else {
                for (let i = 0; i < DateUtil._localMonths.length; i = i + 1) {
                    DateUtil._localMonths[i] = PICInterface.date_month_str[i];
                }
            }
        }
        return DateUtil._localMonths;
    }
    static getLocalDays(names) {
        let dowLen = DATE_DOW_LEN;
        if (typeof DateUtil._localDays[0] === "undefined") {
            if (names !== null) {
                DateUtil._localDays[0] = PICInterface.date_dow_str[0];
                for (let i = 1; i < DateUtil._localDays.length; i = i + 1) {
                    if (i * dowLen >= names.length) {
                        DateUtil._localDays[i] = names.substr((i - 1) * dowLen);
                        while (dowLen - DateUtil._localDays[i].length > 0) {
                            DateUtil._localDays[i] = DateUtil._localDays[i] + " ";
                        }
                    }
                    else {
                        DateUtil._localDays[i] = names.substr((i - 1) * dowLen, i * dowLen - (i - 1) * dowLen);
                    }
                }
            }
            else {
                for (let i = 0; i < DateUtil._localMonths.length; i = i + 1) {
                    DateUtil._localMonths[i] = PICInterface.date_dow_str[i];
                }
            }
        }
        return DateUtil._localDays;
    }
}
DateUtil._localMonths = new Array(13);
DateUtil._localDays = new Array(8);

var Logger_MessageDirection;
(function (Logger_MessageDirection) {
    Logger_MessageDirection[Logger_MessageDirection["MessageLeaving"] = 0] = "MessageLeaving";
    Logger_MessageDirection[Logger_MessageDirection["MessageEntering"] = 1] = "MessageEntering";
})(Logger_MessageDirection || (Logger_MessageDirection = {}));
var Logger_LogLevels;
(function (Logger_LogLevels) {
    Logger_LogLevels[Logger_LogLevels["None"] = 0] = "None";
    Logger_LogLevels[Logger_LogLevels["RequestInfo"] = 1] = "RequestInfo";
    Logger_LogLevels[Logger_LogLevels["Server"] = 2] = "Server";
    Logger_LogLevels[Logger_LogLevels["ServerMessages"] = 3] = "ServerMessages";
    Logger_LogLevels[Logger_LogLevels["Support"] = 4] = "Support";
    Logger_LogLevels[Logger_LogLevels["Gui"] = 5] = "Gui";
    Logger_LogLevels[Logger_LogLevels["Development"] = 6] = "Development";
    Logger_LogLevels[Logger_LogLevels["Basic"] = 7] = "Basic";
})(Logger_LogLevels || (Logger_LogLevels = {}));
var Priority;
(function (Priority) {
    Priority[Priority["LOWEST"] = 1] = "LOWEST";
    Priority[Priority["LOW"] = 2] = "LOW";
    Priority[Priority["HIGH"] = 3] = "HIGH";
})(Priority || (Priority = {}));
var TableBehaviour;
(function (TableBehaviour) {
    TableBehaviour[TableBehaviour["LimitedItems"] = 1] = "LimitedItems";
    TableBehaviour[TableBehaviour["UnlimitedItems"] = 2] = "UnlimitedItems";
})(TableBehaviour || (TableBehaviour = {}));
var HttpStatusCode;
(function (HttpStatusCode) {
    HttpStatusCode[HttpStatusCode["Unused"] = 0] = "Unused";
})(HttpStatusCode || (HttpStatusCode = {}));
var MgControlType;
(function (MgControlType) {
    MgControlType["CTRL_TYPE_NONE"] = "0";
    MgControlType["CTRL_TYPE_BUTTON"] = "B";
    MgControlType["CTRL_TYPE_CHECKBOX"] = "C";
    MgControlType["CTRL_TYPE_RADIO"] = "R";
    MgControlType["CTRL_TYPE_COMBO"] = "D";
    MgControlType["CTRL_TYPE_LIST"] = "E";
    MgControlType["CTRL_TYPE_TEXT"] = "T";
    MgControlType["CTRL_TYPE_GROUP"] = "G";
    MgControlType["CTRL_TYPE_TAB"] = "J";
    MgControlType["CTRL_TYPE_TABLE"] = "A";
    MgControlType["CTRL_TYPE_COLUMN"] = "K";
    MgControlType["CTRL_TYPE_LABEL"] = "L";
    MgControlType["CTRL_TYPE_IMAGE"] = "I";
    MgControlType["CTRL_TYPE_SUBFORM"] = "F";
    MgControlType["CTRL_TYPE_BROWSER"] = "W";
    MgControlType["CTRL_TYPE_STATUS_BAR"] = "1";
    MgControlType["CTRL_TYPE_SB_LABEL"] = "2";
    MgControlType["CTRL_TYPE_SB_IMAGE"] = "3";
    MgControlType["CTRL_TYPE_FRAME_SET"] = "P";
    MgControlType["CTRL_TYPE_CONTAINER"] = "Q";
    MgControlType["CTRL_TYPE_FRAME_FORM"] = "U";
    MgControlType["CTRL_TYPE_LINE"] = "X";
})(MgControlType || (MgControlType = {}));
var DitType;
(function (DitType) {
    DitType[DitType["None"] = 1] = "None";
    DitType[DitType["Edit"] = 2] = "Edit";
    DitType[DitType["Button"] = 3] = "Button";
    DitType[DitType["Combobox"] = 4] = "Combobox";
    DitType[DitType["Listbox"] = 5] = "Listbox";
    DitType[DitType["Radiobox"] = 6] = "Radiobox";
    DitType[DitType["Tab"] = 7] = "Tab";
    DitType[DitType["Checkbox"] = 8] = "Checkbox";
    DitType[DitType["Image"] = 9] = "Image";
    DitType[DitType["Static"] = 10] = "Static";
    DitType[DitType["Line"] = 11] = "Line";
    DitType[DitType["Group"] = 12] = "Group";
    DitType[DitType["Table"] = 13] = "Table";
    DitType[DitType["Slider"] = 14] = "Slider";
    DitType[DitType["Ole"] = 15] = "Ole";
    DitType[DitType["Hotspot"] = 16] = "Hotspot";
    DitType[DitType["StaticTable"] = 17] = "StaticTable";
    DitType[DitType["Sound"] = 18] = "Sound";
    DitType[DitType["Html"] = 19] = "Html";
    DitType[DitType["Java"] = 20] = "Java";
    DitType[DitType["Activex"] = 21] = "Activex";
    DitType[DitType["Frame"] = 22] = "Frame";
    DitType[DitType["Subform"] = 23] = "Subform";
    DitType[DitType["Hypertext"] = 24] = "Hypertext";
    DitType[DitType["Browser"] = 25] = "Browser";
    DitType[DitType["Opaque"] = 26] = "Opaque";
})(DitType || (DitType = {}));
var BorderType;
(function (BorderType) {
    BorderType[BorderType["Thin"] = 1] = "Thin";
    BorderType[BorderType["Thick"] = 2] = "Thick";
    BorderType[BorderType["NoBorder"] = 3] = "NoBorder";
})(BorderType || (BorderType = {}));
var GradientStyle;
(function (GradientStyle) {
    GradientStyle[GradientStyle["None"] = 1] = "None";
    GradientStyle[GradientStyle["Horizontal"] = 2] = "Horizontal";
    GradientStyle[GradientStyle["HorizontalSymmetric"] = 3] = "HorizontalSymmetric";
    GradientStyle[GradientStyle["HorizontalWide"] = 4] = "HorizontalWide";
    GradientStyle[GradientStyle["Vertical"] = 5] = "Vertical";
    GradientStyle[GradientStyle["VerticalSymmetric"] = 6] = "VerticalSymmetric";
    GradientStyle[GradientStyle["VerticalWide"] = 7] = "VerticalWide";
    GradientStyle[GradientStyle["DiagonalLeft"] = 8] = "DiagonalLeft";
    GradientStyle[GradientStyle["DiagonalLeftSymmetric"] = 9] = "DiagonalLeftSymmetric";
    GradientStyle[GradientStyle["DiagonalRight"] = 10] = "DiagonalRight";
    GradientStyle[GradientStyle["DiagonalRightSymmetric"] = 11] = "DiagonalRightSymmetric";
    GradientStyle[GradientStyle["CornerTopLeft"] = 12] = "CornerTopLeft";
    GradientStyle[GradientStyle["CornerTopRight"] = 13] = "CornerTopRight";
    GradientStyle[GradientStyle["CornerBottomLeft"] = 14] = "CornerBottomLeft";
    GradientStyle[GradientStyle["CornerBottomRight"] = 15] = "CornerBottomRight";
    GradientStyle[GradientStyle["Center"] = 16] = "Center";
})(GradientStyle || (GradientStyle = {}));
var AlignmentTypeHori;
(function (AlignmentTypeHori) {
    AlignmentTypeHori[AlignmentTypeHori["Left"] = 1] = "Left";
    AlignmentTypeHori[AlignmentTypeHori["Center"] = 2] = "Center";
    AlignmentTypeHori[AlignmentTypeHori["Right"] = 3] = "Right";
})(AlignmentTypeHori || (AlignmentTypeHori = {}));
var TabbingOrderType;
(function (TabbingOrderType) {
    TabbingOrderType[TabbingOrderType["Automatically"] = 1] = "Automatically";
    TabbingOrderType[TabbingOrderType["Manual"] = 2] = "Manual";
})(TabbingOrderType || (TabbingOrderType = {}));
var AllowedDirectionType;
(function (AllowedDirectionType) {
    AllowedDirectionType[AllowedDirectionType["Both"] = 1] = "Both";
    AllowedDirectionType[AllowedDirectionType["Foreword"] = 2] = "Foreword";
    AllowedDirectionType[AllowedDirectionType["Backward"] = 3] = "Backward";
})(AllowedDirectionType || (AllowedDirectionType = {}));
var AlignmentTypeVert;
(function (AlignmentTypeVert) {
    AlignmentTypeVert[AlignmentTypeVert["Top"] = 1] = "Top";
    AlignmentTypeVert[AlignmentTypeVert["Center"] = 2] = "Center";
    AlignmentTypeVert[AlignmentTypeVert["Bottom"] = 3] = "Bottom";
})(AlignmentTypeVert || (AlignmentTypeVert = {}));
var HtmlAlignmentType;
(function (HtmlAlignmentType) {
    HtmlAlignmentType[HtmlAlignmentType["TextVertTop"] = 1] = "TextVertTop";
    HtmlAlignmentType[HtmlAlignmentType["TextVertCenter"] = 2] = "TextVertCenter";
    HtmlAlignmentType[HtmlAlignmentType["TextVertBottom"] = 3] = "TextVertBottom";
    HtmlAlignmentType[HtmlAlignmentType["TextHoriLeft"] = 4] = "TextHoriLeft";
    HtmlAlignmentType[HtmlAlignmentType["TextHoriRight"] = 5] = "TextHoriRight";
})(HtmlAlignmentType || (HtmlAlignmentType = {}));
var SideType;
(function (SideType) {
    SideType[SideType["Top"] = 1] = "Top";
    SideType[SideType["Right"] = 2] = "Right";
    SideType[SideType["Bottom"] = 3] = "Bottom";
    SideType[SideType["Left"] = 4] = "Left";
})(SideType || (SideType = {}));
var SelprgMode;
(function (SelprgMode) {
    SelprgMode["Before"] = "B";
    SelprgMode["After"] = "A";
    SelprgMode["Prompt"] = "P";
})(SelprgMode || (SelprgMode = {}));
var WinCptn;
(function (WinCptn) {
    WinCptn[WinCptn["Half"] = 1] = "Half";
    WinCptn[WinCptn["On"] = 2] = "On";
    WinCptn[WinCptn["Off"] = 3] = "Off";
})(WinCptn || (WinCptn = {}));
var WinHtmlType;
(function (WinHtmlType) {
    WinHtmlType[WinHtmlType["Get"] = 1] = "Get";
    WinHtmlType[WinHtmlType["Post"] = 2] = "Post";
    WinHtmlType[WinHtmlType["Link"] = 3] = "Link";
})(WinHtmlType || (WinHtmlType = {}));
var WinUom;
(function (WinUom) {
    WinUom[WinUom["Dlg"] = 1] = "Dlg";
    WinUom[WinUom["Mm"] = 2] = "Mm";
    WinUom[WinUom["Inch"] = 3] = "Inch";
    WinUom[WinUom["Pix"] = 4] = "Pix";
})(WinUom || (WinUom = {}));
var ControlStyle;
(function (ControlStyle) {
    ControlStyle[ControlStyle["TwoD"] = 1] = "TwoD";
    ControlStyle[ControlStyle["ThreeD"] = 2] = "ThreeD";
    ControlStyle[ControlStyle["ThreeDSunken"] = 3] = "ThreeDSunken";
    ControlStyle[ControlStyle["Windows3d"] = 4] = "Windows3d";
    ControlStyle[ControlStyle["Windows"] = 5] = "Windows";
    ControlStyle[ControlStyle["Emboss"] = 6] = "Emboss";
    ControlStyle[ControlStyle["NoBorder"] = 7] = "NoBorder";
})(ControlStyle || (ControlStyle = {}));
var CtrlLineType;
(function (CtrlLineType) {
    CtrlLineType[CtrlLineType["Normal"] = 1] = "Normal";
    CtrlLineType[CtrlLineType["Dash"] = 2] = "Dash";
    CtrlLineType[CtrlLineType["Dot"] = 3] = "Dot";
    CtrlLineType[CtrlLineType["Dashdot"] = 4] = "Dashdot";
    CtrlLineType[CtrlLineType["Dashdotdot"] = 5] = "Dashdotdot";
})(CtrlLineType || (CtrlLineType = {}));
var CtrlTextType;
(function (CtrlTextType) {
    CtrlTextType[CtrlTextType["Default"] = 1] = "Default";
    CtrlTextType[CtrlTextType["Bullet"] = 2] = "Bullet";
    CtrlTextType[CtrlTextType["Number"] = 3] = "Number";
})(CtrlTextType || (CtrlTextType = {}));
var CtrlLineDirection;
(function (CtrlLineDirection) {
    CtrlLineDirection[CtrlLineDirection["Asc"] = 1] = "Asc";
    CtrlLineDirection[CtrlLineDirection["Des"] = 2] = "Des";
})(CtrlLineDirection || (CtrlLineDirection = {}));
var CtrlOleDisplayType;
(function (CtrlOleDisplayType) {
    CtrlOleDisplayType[CtrlOleDisplayType["Icon"] = 1] = "Icon";
    CtrlOleDisplayType[CtrlOleDisplayType["Content"] = 2] = "Content";
    CtrlOleDisplayType[CtrlOleDisplayType["Any"] = 3] = "Any";
})(CtrlOleDisplayType || (CtrlOleDisplayType = {}));
var CtrlOleStoreType;
(function (CtrlOleStoreType) {
    CtrlOleStoreType[CtrlOleStoreType["Link"] = 1] = "Link";
    CtrlOleStoreType[CtrlOleStoreType["Embeded"] = 2] = "Embeded";
    CtrlOleStoreType[CtrlOleStoreType["Any"] = 3] = "Any";
})(CtrlOleStoreType || (CtrlOleStoreType = {}));
var CtrlButtonType;
(function (CtrlButtonType) {
    CtrlButtonType[CtrlButtonType["Submit"] = 1] = "Submit";
    CtrlButtonType[CtrlButtonType["Clear"] = 2] = "Clear";
    CtrlButtonType[CtrlButtonType["Default"] = 3] = "Default";
})(CtrlButtonType || (CtrlButtonType = {}));
var CtrlImageStyle;
(function (CtrlImageStyle) {
    CtrlImageStyle[CtrlImageStyle["Tiled"] = 1] = "Tiled";
    CtrlImageStyle[CtrlImageStyle["Copied"] = 2] = "Copied";
    CtrlImageStyle[CtrlImageStyle["ScaleFit"] = 3] = "ScaleFit";
    CtrlImageStyle[CtrlImageStyle["ScaleFill"] = 4] = "ScaleFill";
    CtrlImageStyle[CtrlImageStyle["Distorted"] = 5] = "Distorted";
})(CtrlImageStyle || (CtrlImageStyle = {}));
var TabControlTabsWidth;
(function (TabControlTabsWidth) {
    TabControlTabsWidth[TabControlTabsWidth["FitToText"] = 1] = "FitToText";
    TabControlTabsWidth[TabControlTabsWidth["Fixed"] = 2] = "Fixed";
    TabControlTabsWidth[TabControlTabsWidth["FillToRight"] = 3] = "FillToRight";
    TabControlTabsWidth[TabControlTabsWidth["FixedInLine"] = 4] = "FixedInLine";
})(TabControlTabsWidth || (TabControlTabsWidth = {}));
var CheckboxMainStyle;
(function (CheckboxMainStyle) {
    CheckboxMainStyle[CheckboxMainStyle["None"] = 0] = "None";
    CheckboxMainStyle[CheckboxMainStyle["Box"] = 1] = "Box";
    CheckboxMainStyle[CheckboxMainStyle["Button"] = 2] = "Button";
    CheckboxMainStyle[CheckboxMainStyle["Switch"] = 3] = "Switch";
})(CheckboxMainStyle || (CheckboxMainStyle = {}));
var RbAppearance;
(function (RbAppearance) {
    RbAppearance[RbAppearance["None"] = 0] = "None";
    RbAppearance[RbAppearance["Radio"] = 1] = "Radio";
    RbAppearance[RbAppearance["Button"] = 2] = "Button";
})(RbAppearance || (RbAppearance = {}));
var HelpCommand;
(function (HelpCommand) {
    HelpCommand[HelpCommand["Context"] = 1] = "Context";
    HelpCommand[HelpCommand["Contents"] = 2] = "Contents";
    HelpCommand[HelpCommand["Setcontents"] = 3] = "Setcontents";
    HelpCommand[HelpCommand["Contextpopup"] = 4] = "Contextpopup";
    HelpCommand[HelpCommand["Key"] = 5] = "Key";
    HelpCommand[HelpCommand["Command"] = 6] = "Command";
    HelpCommand[HelpCommand["Forcefile"] = 7] = "Forcefile";
    HelpCommand[HelpCommand["Helponhelp"] = 8] = "Helponhelp";
    HelpCommand[HelpCommand["Quit"] = 9] = "Quit";
})(HelpCommand || (HelpCommand = {}));
var FormExpandType;
(function (FormExpandType) {
    FormExpandType[FormExpandType["None"] = 1] = "None";
    FormExpandType[FormExpandType["OnePage"] = 2] = "OnePage";
    FormExpandType[FormExpandType["MultiPage"] = 3] = "MultiPage";
})(FormExpandType || (FormExpandType = {}));
var DitAttribute;
(function (DitAttribute) {
    DitAttribute[DitAttribute["Alpha"] = 1] = "Alpha";
    DitAttribute[DitAttribute["Unicode"] = 2] = "Unicode";
    DitAttribute[DitAttribute["Numeric"] = 3] = "Numeric";
    DitAttribute[DitAttribute["Boolean"] = 4] = "Boolean";
    DitAttribute[DitAttribute["Date"] = 5] = "Date";
    DitAttribute[DitAttribute["Time"] = 6] = "Time";
    DitAttribute[DitAttribute["Memo"] = 7] = "Memo";
    DitAttribute[DitAttribute["Blob"] = 8] = "Blob";
})(DitAttribute || (DitAttribute = {}));
var DspInterface;
(function (DspInterface) {
    DspInterface[DspInterface["Text"] = 1] = "Text";
    DspInterface[DspInterface["Gui"] = 2] = "Gui";
    DspInterface[DspInterface["Html"] = 3] = "Html";
    DspInterface[DspInterface["Java"] = 4] = "Java";
    DspInterface[DspInterface["Frame"] = 5] = "Frame";
    DspInterface[DspInterface["Merge"] = 6] = "Merge";
    DspInterface[DspInterface["Webonline"] = 7] = "Webonline";
    DspInterface[DspInterface["Browser"] = 8] = "Browser";
})(DspInterface || (DspInterface = {}));
var PrgExecPlace;
(function (PrgExecPlace) {
    PrgExecPlace[PrgExecPlace["Before"] = 1] = "Before";
    PrgExecPlace[PrgExecPlace["After"] = 2] = "After";
    PrgExecPlace[PrgExecPlace["Prompt"] = 3] = "Prompt";
})(PrgExecPlace || (PrgExecPlace = {}));
var SliderType;
(function (SliderType) {
    SliderType[SliderType["Vertical"] = 1] = "Vertical";
    SliderType[SliderType["Horizontal"] = 2] = "Horizontal";
})(SliderType || (SliderType = {}));
var CtrlButtonTypeGui;
(function (CtrlButtonTypeGui) {
    CtrlButtonTypeGui[CtrlButtonTypeGui["None"] = 0] = "None";
    CtrlButtonTypeGui[CtrlButtonTypeGui["Push"] = 1] = "Push";
    CtrlButtonTypeGui[CtrlButtonTypeGui["Image"] = 2] = "Image";
    CtrlButtonTypeGui[CtrlButtonTypeGui["Hypertext"] = 3] = "Hypertext";
    CtrlButtonTypeGui[CtrlButtonTypeGui["TextOnImage"] = 4] = "TextOnImage";
})(CtrlButtonTypeGui || (CtrlButtonTypeGui = {}));
var ImageEffects;
(function (ImageEffects) {
    ImageEffects[ImageEffects["Normal"] = 1] = "Normal";
    ImageEffects[ImageEffects["WipeDown"] = 2] = "WipeDown";
    ImageEffects[ImageEffects["WipeUp"] = 3] = "WipeUp";
    ImageEffects[ImageEffects["WipeRight"] = 4] = "WipeRight";
    ImageEffects[ImageEffects["WipeLeft"] = 5] = "WipeLeft";
    ImageEffects[ImageEffects["Pixel"] = 6] = "Pixel";
    ImageEffects[ImageEffects["SmallBox"] = 7] = "SmallBox";
    ImageEffects[ImageEffects["MediumBox"] = 8] = "MediumBox";
    ImageEffects[ImageEffects["LargeBox"] = 9] = "LargeBox";
    ImageEffects[ImageEffects["Hline"] = 10] = "Hline";
    ImageEffects[ImageEffects["Vline"] = 11] = "Vline";
    ImageEffects[ImageEffects["Vmiddle"] = 12] = "Vmiddle";
    ImageEffects[ImageEffects["Hmiddle"] = 13] = "Hmiddle";
    ImageEffects[ImageEffects["Hinterlace"] = 14] = "Hinterlace";
    ImageEffects[ImageEffects["Vinterlace"] = 15] = "Vinterlace";
    ImageEffects[ImageEffects["OutToIn"] = 16] = "OutToIn";
    ImageEffects[ImageEffects["InToOut"] = 17] = "InToOut";
    ImageEffects[ImageEffects["OtiInterlace1"] = 18] = "OtiInterlace1";
    ImageEffects[ImageEffects["ItoInterlace2"] = 19] = "ItoInterlace2";
    ImageEffects[ImageEffects["SpiralIn3"] = 20] = "SpiralIn3";
    ImageEffects[ImageEffects["SpiralOut4"] = 21] = "SpiralOut4";
})(ImageEffects || (ImageEffects = {}));
var CtrlHotspotType;
(function (CtrlHotspotType) {
    CtrlHotspotType[CtrlHotspotType["Square"] = 1] = "Square";
    CtrlHotspotType[CtrlHotspotType["Circle"] = 2] = "Circle";
})(CtrlHotspotType || (CtrlHotspotType = {}));
var SubformType;
(function (SubformType) {
    SubformType[SubformType["Program"] = 1] = "Program";
    SubformType[SubformType["Subtask"] = 2] = "Subtask";
    SubformType[SubformType["Form"] = 3] = "Form";
    SubformType[SubformType["None"] = 4] = "None";
})(SubformType || (SubformType = {}));
var DatabaseDefinitionType;
(function (DatabaseDefinitionType) {
    DatabaseDefinitionType[DatabaseDefinitionType["String"] = 1] = "String";
    DatabaseDefinitionType[DatabaseDefinitionType["Normal"] = 2] = "Normal";
})(DatabaseDefinitionType || (DatabaseDefinitionType = {}));
var DatabaseOperations;
(function (DatabaseOperations) {
    DatabaseOperations[DatabaseOperations["Insert"] = 1] = "Insert";
    DatabaseOperations[DatabaseOperations["Update"] = 2] = "Update";
    DatabaseOperations[DatabaseOperations["Delete"] = 3] = "Delete";
    DatabaseOperations[DatabaseOperations["Where"] = 4] = "Where";
    DatabaseOperations[DatabaseOperations["None"] = 5] = "None";
})(DatabaseOperations || (DatabaseOperations = {}));
var DataTranslation;
(function (DataTranslation) {
    DataTranslation[DataTranslation["Ansi"] = 1] = "Ansi";
    DataTranslation[DataTranslation["Oem"] = 2] = "Oem";
    DataTranslation[DataTranslation["Unicode"] = 3] = "Unicode";
})(DataTranslation || (DataTranslation = {}));
var WindowPosition;
(function (WindowPosition) {
    WindowPosition[WindowPosition["Customized"] = 1] = "Customized";
    WindowPosition[WindowPosition["DefaultBounds"] = 2] = "DefaultBounds";
    WindowPosition[WindowPosition["CenteredToParent"] = 3] = "CenteredToParent";
    WindowPosition[WindowPosition["CenteredToMagic"] = 4] = "CenteredToMagic";
    WindowPosition[WindowPosition["CenteredToDesktop"] = 5] = "CenteredToDesktop";
    WindowPosition[WindowPosition["DefaultLocation"] = 6] = "DefaultLocation";
    WindowPosition[WindowPosition["CenteredToWindow"] = 7] = "CenteredToWindow";
})(WindowPosition || (WindowPosition = {}));
var FldStyle;
(function (FldStyle) {
    FldStyle[FldStyle["None"] = 1] = "None";
    FldStyle[FldStyle["Activex"] = 2] = "Activex";
    FldStyle[FldStyle["Ole"] = 3] = "Ole";
    FldStyle[FldStyle["Vector"] = 4] = "Vector";
    FldStyle[FldStyle["Dotnet"] = 5] = "Dotnet";
})(FldStyle || (FldStyle = {}));
var FieldComType;
(function (FieldComType) {
    FieldComType[FieldComType["Obj"] = 1] = "Obj";
    FieldComType[FieldComType["Ref"] = 2] = "Ref";
})(FieldComType || (FieldComType = {}));
var ListboxSelectionMode;
(function (ListboxSelectionMode) {
    ListboxSelectionMode[ListboxSelectionMode["Single"] = 1] = "Single";
    ListboxSelectionMode[ListboxSelectionMode["Multiple"] = 2] = "Multiple";
})(ListboxSelectionMode || (ListboxSelectionMode = {}));
var SplitWindowType;
(function (SplitWindowType) {
    SplitWindowType[SplitWindowType["None"] = 1] = "None";
    SplitWindowType[SplitWindowType["Vertical"] = 2] = "Vertical";
    SplitWindowType[SplitWindowType["Horizontal"] = 3] = "Horizontal";
})(SplitWindowType || (SplitWindowType = {}));
var SplitPrimaryDisplay;
(function (SplitPrimaryDisplay) {
    SplitPrimaryDisplay[SplitPrimaryDisplay["Default"] = 1] = "Default";
    SplitPrimaryDisplay[SplitPrimaryDisplay["Left"] = 2] = "Left";
    SplitPrimaryDisplay[SplitPrimaryDisplay["Right"] = 3] = "Right";
    SplitPrimaryDisplay[SplitPrimaryDisplay["Top"] = 4] = "Top";
    SplitPrimaryDisplay[SplitPrimaryDisplay["Bottom"] = 5] = "Bottom";
})(SplitPrimaryDisplay || (SplitPrimaryDisplay = {}));
var AutoFit;
(function (AutoFit) {
    AutoFit[AutoFit["None"] = 1] = "None";
    AutoFit[AutoFit["AsControl"] = 2] = "AsControl";
    AutoFit[AutoFit["AsCalledForm"] = 3] = "AsCalledForm";
})(AutoFit || (AutoFit = {}));
var WindowType;
(function (WindowType) {
    WindowType[WindowType["Default"] = 1] = "Default";
    WindowType[WindowType["Sdi"] = 2] = "Sdi";
    WindowType[WindowType["ChildWindow"] = 3] = "ChildWindow";
    WindowType[WindowType["SplitterChildWindow"] = 4] = "SplitterChildWindow";
    WindowType[WindowType["Floating"] = 5] = "Floating";
    WindowType[WindowType["Modal"] = 6] = "Modal";
    WindowType[WindowType["ApplicationModal"] = 7] = "ApplicationModal";
    WindowType[WindowType["Tool"] = 8] = "Tool";
    WindowType[WindowType["FitToMdi"] = 9] = "FitToMdi";
    WindowType[WindowType["MdiChild"] = 10] = "MdiChild";
    WindowType[WindowType["MdiFrame"] = 11] = "MdiFrame";
    WindowType[WindowType["Overlay"] = 12] = "Overlay";
    WindowType["LogonApplicationWindow"] = "a";
    WindowType["TkDockChild"] = "b";
})(WindowType || (WindowType = {}));
var StartupMode;
(function (StartupMode) {
    StartupMode[StartupMode["Default"] = 1] = "Default";
    StartupMode[StartupMode["Maximize"] = 2] = "Maximize";
    StartupMode[StartupMode["Minimize"] = 3] = "Minimize";
})(StartupMode || (StartupMode = {}));
var ColumnUpdateStyle;
(function (ColumnUpdateStyle) {
    ColumnUpdateStyle[ColumnUpdateStyle["Absolute"] = 1] = "Absolute";
    ColumnUpdateStyle[ColumnUpdateStyle["Differential"] = 2] = "Differential";
    ColumnUpdateStyle[ColumnUpdateStyle["AsTable"] = 3] = "AsTable";
})(ColumnUpdateStyle || (ColumnUpdateStyle = {}));
var CallUdpConvention;
(function (CallUdpConvention) {
    CallUdpConvention["C"] = "C";
    CallUdpConvention["Standard"] = "S";
    CallUdpConvention["Fast"] = "F";
})(CallUdpConvention || (CallUdpConvention = {}));
var CallUDPType;
(function (CallUDPType) {
    CallUDPType["Background"] = "B";
    CallUDPType["GUI"] = "G";
})(CallUDPType || (CallUDPType = {}));
var VerifyMode;
(function (VerifyMode) {
    VerifyMode["Error"] = "E";
    VerifyMode["Warning"] = "W";
    VerifyMode["Revert"] = "R";
})(VerifyMode || (VerifyMode = {}));
var VerifyDisplay;
(function (VerifyDisplay) {
    VerifyDisplay["Box"] = "B";
    VerifyDisplay["Status"] = "S";
    VerifyDisplay["None"] = "N";
})(VerifyDisplay || (VerifyDisplay = {}));
var VerifyImage;
(function (VerifyImage) {
    VerifyImage["Exclamation"] = "E";
    VerifyImage["Critical"] = "C";
    VerifyImage["Question"] = "Q";
    VerifyImage["Information"] = "I";
    VerifyImage["None"] = "N";
})(VerifyImage || (VerifyImage = {}));
var VerifyButtons;
(function (VerifyButtons) {
    VerifyButtons["Ok"] = "O";
    VerifyButtons["OkCancel"] = "K";
    VerifyButtons["AbortRetryIgnore"] = "A";
    VerifyButtons["YesNoCancel"] = "Y";
    VerifyButtons["YesNo"] = "N";
    VerifyButtons["RetryCancel"] = "R";
})(VerifyButtons || (VerifyButtons = {}));
var CallComOption;
(function (CallComOption) {
    CallComOption[CallComOption["Method"] = 1] = "Method";
    CallComOption[CallComOption["GetProp"] = 2] = "GetProp";
    CallComOption[CallComOption["SetProp"] = 3] = "SetProp";
})(CallComOption || (CallComOption = {}));
var CallWsStyle;
(function (CallWsStyle) {
    CallWsStyle[CallWsStyle["Rpc"] = 1] = "Rpc";
    CallWsStyle[CallWsStyle["Document"] = 2] = "Document";
})(CallWsStyle || (CallWsStyle = {}));
var CallOsShow;
(function (CallOsShow) {
    CallOsShow[CallOsShow["Hide"] = 1] = "Hide";
    CallOsShow[CallOsShow["Normal"] = 2] = "Normal";
    CallOsShow[CallOsShow["Maximize"] = 3] = "Maximize";
    CallOsShow[CallOsShow["Minimize"] = 4] = "Minimize";
})(CallOsShow || (CallOsShow = {}));
var LogicUnit;
(function (LogicUnit) {
    LogicUnit[LogicUnit["Remark"] = 1] = "Remark";
    LogicUnit[LogicUnit["Task"] = 2] = "Task";
    LogicUnit[LogicUnit["Group"] = 3] = "Group";
    LogicUnit[LogicUnit["Record"] = 4] = "Record";
    LogicUnit[LogicUnit["Variable"] = 5] = "Variable";
    LogicUnit[LogicUnit["Control"] = 6] = "Control";
    LogicUnit[LogicUnit["Event"] = 7] = "Event";
    LogicUnit[LogicUnit["Function"] = 8] = "Function";
    LogicUnit[LogicUnit["SeqFlow"] = 9] = "SeqFlow";
})(LogicUnit || (LogicUnit = {}));
var LogicLevel;
(function (LogicLevel) {
    LogicLevel["Prefix"] = "P";
    LogicLevel["Suffix"] = "S";
    LogicLevel["Verification"] = "V";
    LogicLevel["Change"] = "C";
})(LogicLevel || (LogicLevel = {}));
var BrkScope;
(function (BrkScope) {
    BrkScope["Task"] = "T";
    BrkScope["Subtree"] = "S";
    BrkScope["Global"] = "G";
})(BrkScope || (BrkScope = {}));
var LDir;
(function (LDir) {
    LDir["Default"] = "A";
    LDir["Reversed"] = "D";
})(LDir || (LDir = {}));
var Order;
(function (Order) {
    Order["Ascending"] = "A";
    Order["Descending"] = "D";
})(Order || (Order = {}));
var LnkEval_Cond;
(function (LnkEval_Cond) {
    LnkEval_Cond["Record"] = "R";
    LnkEval_Cond["Task"] = "T";
})(LnkEval_Cond || (LnkEval_Cond = {}));
var Access;
(function (Access) {
    Access["NoAccess"] = " ";
    Access["Read"] = "R";
    Access["Write"] = "W";
})(Access || (Access = {}));
var DbShare;
(function (DbShare) {
    DbShare["NoShare"] = " ";
    DbShare["Write"] = "W";
    DbShare["Read"] = "R";
    DbShare["None"] = "N";
})(DbShare || (DbShare = {}));
var DbOpen;
(function (DbOpen) {
    DbOpen["Normal"] = "N";
    DbOpen["Fast"] = "F";
    DbOpen["Damaged"] = "D";
    DbOpen["Reindex"] = "R";
})(DbOpen || (DbOpen = {}));
var DbDelUpdMode;
(function (DbDelUpdMode) {
    DbDelUpdMode["Position"] = "P";
    DbDelUpdMode["PositionAndSelectedFields"] = "S";
    DbDelUpdMode["PositionAndUpdatedFields"] = "U";
    DbDelUpdMode["AsTable"] = "T";
    DbDelUpdMode["None"] = "N";
})(DbDelUpdMode || (DbDelUpdMode = {}));
var RaiseAt;
(function (RaiseAt) {
    RaiseAt[RaiseAt["Container"] = 1] = "Container";
    RaiseAt[RaiseAt["TaskInFocus"] = 2] = "TaskInFocus";
})(RaiseAt || (RaiseAt = {}));
var EngineDirect;
(function (EngineDirect) {
    EngineDirect["None"] = " ";
    EngineDirect["AbortTask"] = "A";
    EngineDirect["Rollback"] = "B";
    EngineDirect["AutoRetry"] = "R";
    EngineDirect["UserRetry"] = "U";
    EngineDirect["Ignore"] = "I";
    EngineDirect["AsStrategy"] = "S";
    EngineDirect["Continue"] = "C";
})(EngineDirect || (EngineDirect = {}));
var FlowDirection;
(function (FlowDirection) {
    FlowDirection["Forward"] = "F";
    FlowDirection["Backward"] = "B";
    FlowDirection["Combined"] = "C";
})(FlowDirection || (FlowDirection = {}));
var FlwMode;
(function (FlwMode) {
    FlwMode["Fast"] = "F";
    FlwMode["Step"] = "S";
    FlwMode["Combine"] = "B";
    FlwMode["Before"] = "J";
    FlwMode["After"] = "Z";
})(FlwMode || (FlwMode = {}));
var BottomPositionInterval;
(function (BottomPositionInterval) {
    BottomPositionInterval[BottomPositionInterval["NoneRowHeight"] = 1] = "NoneRowHeight";
    BottomPositionInterval[BottomPositionInterval["RowHeight"] = 2] = "RowHeight";
})(BottomPositionInterval || (BottomPositionInterval = {}));
var ExecOn;
(function (ExecOn) {
    ExecOn[ExecOn["None"] = 0] = "None";
    ExecOn[ExecOn["Optimized"] = 1] = "Optimized";
    ExecOn[ExecOn["Client"] = 2] = "Client";
    ExecOn[ExecOn["Server"] = 3] = "Server";
})(ExecOn || (ExecOn = {}));
var Storage;
(function (Storage) {
    Storage[Storage["AlphaString"] = 1] = "AlphaString";
    Storage[Storage["AlphaLstring"] = 2] = "AlphaLstring";
    Storage[Storage["AlphaZtring"] = 3] = "AlphaZtring";
    Storage[Storage["NumericSigned"] = 4] = "NumericSigned";
    Storage[Storage["NumericUnsigned"] = 5] = "NumericUnsigned";
    Storage[Storage["NumericFloat"] = 6] = "NumericFloat";
    Storage[Storage["NumericFloatMs"] = 7] = "NumericFloatMs";
    Storage[Storage["NumericFloatDec"] = 8] = "NumericFloatDec";
    Storage[Storage["NumericPackedDec"] = 9] = "NumericPackedDec";
    Storage[Storage["NumericNumeric"] = 10] = "NumericNumeric";
    Storage[Storage["NumericCharDec"] = 11] = "NumericCharDec";
    Storage[Storage["NumericString"] = 12] = "NumericString";
    Storage[Storage["NumericMagic"] = 13] = "NumericMagic";
    Storage[Storage["NumericCisam"] = 14] = "NumericCisam";
    Storage[Storage["BooleanInteger"] = 15] = "BooleanInteger";
    Storage[Storage["BooleanDbase"] = 16] = "BooleanDbase";
    Storage[Storage["DateInteger"] = 17] = "DateInteger";
    Storage[Storage["DateInteger1901"] = 18] = "DateInteger1901";
    Storage[Storage["DateString"] = 19] = "DateString";
    Storage[Storage["DateYymd"] = 20] = "DateYymd";
    Storage[Storage["DateMagic"] = 21] = "DateMagic";
    Storage[Storage["DateMagic1901"] = 22] = "DateMagic1901";
    Storage[Storage["TimeInteger"] = 23] = "TimeInteger";
    Storage[Storage["TimeString"] = 24] = "TimeString";
    Storage[Storage["TimeHmsh"] = 25] = "TimeHmsh";
    Storage[Storage["TimeMagic"] = 26] = "TimeMagic";
    Storage[Storage["MemoString"] = 27] = "MemoString";
    Storage[Storage["MemoMagic"] = 28] = "MemoMagic";
    Storage[Storage["Blob"] = 29] = "Blob";
    Storage[Storage["NumericExtFloat"] = 30] = "NumericExtFloat";
    Storage[Storage["UnicodeString"] = 31] = "UnicodeString";
    Storage[Storage["UnicodeZstring"] = 32] = "UnicodeZstring";
    Storage[Storage["AnsiBlob"] = 33] = "AnsiBlob";
    Storage[Storage["UnicodeBlob"] = 34] = "UnicodeBlob";
})(Storage || (Storage = {}));
var StorageAttributeType;
(function (StorageAttributeType) {
    StorageAttributeType["Alpha"] = "A";
    StorageAttributeType["Numeric"] = "N";
    StorageAttributeType["Boolean"] = "B";
    StorageAttributeType["Date"] = "D";
    StorageAttributeType["Time"] = "T";
    StorageAttributeType["Blob"] = "O";
    StorageAttributeType["Unicode"] = "U";
    StorageAttributeType["String"] = "S";
    StorageAttributeType["BlobOle"] = "L";
    StorageAttributeType["BlobActiveX"] = "X";
    StorageAttributeType["BlobVector"] = "V";
    StorageAttributeType["BlobDotNet"] = "E";
    StorageAttributeType["BlobJava"] = "J";
    StorageAttributeType["None"] = " ";
})(StorageAttributeType || (StorageAttributeType = {}));
var BrkLevel;
(function (BrkLevel) {
    BrkLevel["Task"] = "T";
    BrkLevel["Group"] = "G";
    BrkLevel["All"] = "A";
    BrkLevel["Record"] = "R";
    BrkLevel["Control"] = "C";
    BrkLevel["Handler"] = "H";
    BrkLevel["MainProgram"] = "M";
    BrkLevel["Variable"] = "V";
    BrkLevel["Function"] = "F";
    BrkLevel["Remark"] = "K";
    BrkLevel["RM_Compat"] = "M";
    BrkLevel["SubForm"] = "U";
    BrkLevel["Event"] = "E";
    BrkLevel["OPStatOnChange"] = "O";
})(BrkLevel || (BrkLevel = {}));
var MediaOrientation;
(function (MediaOrientation) {
    MediaOrientation["Portrait"] = "P";
    MediaOrientation["Landscape"] = "L";
})(MediaOrientation || (MediaOrientation = {}));
var MediaFormat;
(function (MediaFormat) {
    MediaFormat["Page"] = "P";
    MediaFormat["Line"] = "L";
    MediaFormat["None"] = "N";
})(MediaFormat || (MediaFormat = {}));
var CharacterSet;
(function (CharacterSet) {
    CharacterSet[CharacterSet["Ansi"] = 0] = "Ansi";
    CharacterSet[CharacterSet["Oem"] = 1] = "Oem";
    CharacterSet[CharacterSet["Unicode"] = 3] = "Unicode";
    CharacterSet[CharacterSet["Utf8"] = 4] = "Utf8";
})(CharacterSet || (CharacterSet = {}));
var MediaAccess;
(function (MediaAccess) {
    MediaAccess["Read"] = "R";
    MediaAccess["Write"] = "W";
    MediaAccess["Append"] = "A";
    MediaAccess["Direct"] = "D";
    MediaAccess["AppendFlush"] = "F";
    MediaAccess["Create"] = "C";
})(MediaAccess || (MediaAccess = {}));
var PaperSize;
(function (PaperSize) {
    PaperSize["Default"] = "D";
    PaperSize["Letter"] = "L";
    PaperSize["A4"] = "A";
    PaperSize["Folio"] = "F";
    PaperSize["Quarto"] = "Q";
    PaperSize["Tabloid"] = "T";
    PaperSize["Ledger"] = "R";
    PaperSize["Legal_8_14"] = "G";
    PaperSize["Statement"] = "S";
    PaperSize["Executive_7_10"] = "X";
    PaperSize["A3"] = "3";
    PaperSize["A5"] = "5";
    PaperSize["Note"] = "N";
    PaperSize["Envelope_3_8"] = "E";
    PaperSize["B4"] = "B";
    PaperSize["B5_v"] = "V";
    PaperSize["UserDefined"] = "U";
    PaperSize["B5"] = "W";
    PaperSize["C5"] = "C";
    PaperSize["Legal"] = "g";
    PaperSize["Multipurpose"] = "M";
    PaperSize["Executive"] = "x";
    PaperSize["EnvelopeB4"] = "v";
    PaperSize["EnvelopeB5"] = "p";
    PaperSize["EnvelopeC6"] = "6";
    PaperSize["EnvelopeDL"] = "o";
    PaperSize["EnvelopeMonarch"] = "h";
    PaperSize["Envelope9"] = "9";
    PaperSize["Envelope10"] = "0";
    PaperSize["Envelope11"] = "1";
})(PaperSize || (PaperSize = {}));
var PaperSizePdfDisabled;
(function (PaperSizePdfDisabled) {
    PaperSizePdfDisabled["Default"] = "D";
    PaperSizePdfDisabled["Letter"] = "L";
    PaperSizePdfDisabled["A4"] = "A";
    PaperSizePdfDisabled["Folio"] = "F";
    PaperSizePdfDisabled["Quarto"] = "Q";
    PaperSizePdfDisabled["Tabloid"] = "T";
    PaperSizePdfDisabled["Ledger"] = "R";
    PaperSizePdfDisabled["Legal_8_14"] = "G";
    PaperSizePdfDisabled["Statement"] = "S";
    PaperSizePdfDisabled["Executive_7_10"] = "X";
    PaperSizePdfDisabled["A3"] = "3";
    PaperSizePdfDisabled["A5"] = "5";
    PaperSizePdfDisabled["Note"] = "N";
    PaperSizePdfDisabled["Envelope_3_8"] = "E";
    PaperSizePdfDisabled["B4"] = "B";
    PaperSizePdfDisabled["B5_v"] = "V";
})(PaperSizePdfDisabled || (PaperSizePdfDisabled = {}));
var PaperSizePdfEnabled;
(function (PaperSizePdfEnabled) {
    PaperSizePdfEnabled["Default"] = "D";
    PaperSizePdfEnabled["UserDefined"] = "U";
    PaperSizePdfEnabled["Letter"] = "L";
    PaperSizePdfEnabled["A4"] = "A";
    PaperSizePdfEnabled["A3"] = "3";
    PaperSizePdfEnabled["Legal"] = "g";
    PaperSizePdfEnabled["B5"] = "B";
    PaperSizePdfEnabled["C5"] = "C";
    PaperSizePdfEnabled["Multipurpose"] = "M";
    PaperSizePdfEnabled["B4"] = "4";
    PaperSizePdfEnabled["A5"] = "5";
    PaperSizePdfEnabled["Folio"] = "F";
    PaperSizePdfEnabled["Executive"] = "x";
    PaperSizePdfEnabled["EnvelopeB4"] = "v";
    PaperSizePdfEnabled["EnvelopeB5"] = "p";
    PaperSizePdfEnabled["EnvelopeC6"] = "6";
    PaperSizePdfEnabled["EnvelopeDL"] = "o";
    PaperSizePdfEnabled["EnvelopeMonarch"] = "h";
    PaperSizePdfEnabled["Envelope9"] = "9";
    PaperSizePdfEnabled["Envelope10"] = "0";
    PaperSizePdfEnabled["Envelope11"] = "1";
})(PaperSizePdfEnabled || (PaperSizePdfEnabled = {}));
var Area;
(function (Area) {
    Area["Detail"] = "N";
    Area["Header"] = "H";
    Area["Footer"] = "F";
    Area["PageHeader"] = "P";
    Area["PageFooter"] = "G";
})(Area || (Area = {}));
var DisplayTextType;
(function (DisplayTextType) {
    DisplayTextType[DisplayTextType["Edit"] = 0] = "Edit";
    DisplayTextType[DisplayTextType["Query"] = 1] = "Query";
})(DisplayTextType || (DisplayTextType = {}));
var LogicHeaderType;
(function (LogicHeaderType) {
    LogicHeaderType["None"] = " ";
    LogicHeaderType["Remark"] = "K";
    LogicHeaderType["Task"] = "T";
    LogicHeaderType["Function"] = "F";
    LogicHeaderType["Handler"] = "H";
    LogicHeaderType["Record"] = "R";
    LogicHeaderType["Variable"] = "V";
    LogicHeaderType["Control"] = "C";
    LogicHeaderType["Group"] = "G";
    LogicHeaderType["All"] = "A";
    LogicHeaderType["MainProgram"] = "P";
    LogicHeaderType["RecordCompat"] = "M";
    LogicHeaderType["SubForm"] = "U";
    LogicHeaderType["Event"] = "E";
})(LogicHeaderType || (LogicHeaderType = {}));
var LogicOperationType;
(function (LogicOperationType) {
    LogicOperationType["None"] = "x";
    LogicOperationType["Remark"] = " ";
    LogicOperationType["Update"] = "U";
    LogicOperationType["Call"] = "C";
    LogicOperationType["Invoke"] = "I";
    LogicOperationType["RaiseEvent"] = "R";
    LogicOperationType["Evaluate"] = "A";
    LogicOperationType["Block"] = "B";
    LogicOperationType["Verify"] = "E";
    LogicOperationType["Form"] = "F";
    LogicOperationType["Variable"] = "V";
})(LogicOperationType || (LogicOperationType = {}));
var Opr;
(function (Opr) {
    Opr[Opr["Remark"] = 0] = "Remark";
    Opr[Opr["SelFld"] = 1] = "SelFld";
    Opr[Opr["Stop"] = 2] = "Stop";
    Opr[Opr["BeginLink"] = 3] = "BeginLink";
    Opr[Opr["EndLink"] = 4] = "EndLink";
    Opr[Opr["BeginBlock"] = 5] = "BeginBlock";
    Opr[Opr["EndBlock"] = 6] = "EndBlock";
    Opr[Opr["Call"] = 7] = "Call";
    Opr[Opr["EvaluateExpression"] = 8] = "EvaluateExpression";
    Opr[Opr["UpdateFld"] = 9] = "UpdateFld";
    Opr[Opr["WriteFile"] = 10] = "WriteFile";
    Opr[Opr["ReadFile"] = 11] = "ReadFile";
    Opr[Opr["DataviewSrc"] = 12] = "DataviewSrc";
    Opr[Opr["UserExit"] = 13] = "UserExit";
    Opr[Opr["RaiseEvent"] = 14] = "RaiseEvent";
})(Opr || (Opr = {}));
var DataViewHeaderType;
(function (DataViewHeaderType) {
    DataViewHeaderType["None"] = " ";
    DataViewHeaderType["Remark"] = "R";
    DataViewHeaderType["Declare"] = "D";
    DataViewHeaderType["MainSource"] = "M";
    DataViewHeaderType["DirectSQL"] = "Q";
    DataViewHeaderType["LinkQuery"] = "L";
    DataViewHeaderType["LinkWrite"] = "W";
    DataViewHeaderType["LinkCreate"] = "C";
    DataViewHeaderType["LinkIJoin"] = "I";
    DataViewHeaderType["LinkOJoin"] = "O";
    DataViewHeaderType["EndLink"] = "E";
})(DataViewHeaderType || (DataViewHeaderType = {}));
var DataViewOperationType;
(function (DataViewOperationType) {
    DataViewOperationType["Remark"] = " ";
    DataViewOperationType["Column"] = "C";
    DataViewOperationType["Virtual"] = "V";
    DataViewOperationType["Parameter"] = "P";
    DataViewOperationType["LinkedColumn"] = "L";
})(DataViewOperationType || (DataViewOperationType = {}));
var LoadedValues;
(function (LoadedValues) {
    LoadedValues[LoadedValues["None"] = 0] = "None";
    LoadedValues[LoadedValues["HeaderOnly"] = 1] = "HeaderOnly";
    LoadedValues[LoadedValues["Failed"] = 2] = "Failed";
    LoadedValues[LoadedValues["Full"] = 3] = "Full";
})(LoadedValues || (LoadedValues = {}));
var YesNoValues;
(function (YesNoValues) {
    YesNoValues[YesNoValues["Yes"] = 1] = "Yes";
    YesNoValues[YesNoValues["No"] = 0] = "No";
})(YesNoValues || (YesNoValues = {}));
var TrueFalseValues;
(function (TrueFalseValues) {
    TrueFalseValues[TrueFalseValues["True"] = 1] = "True";
    TrueFalseValues[TrueFalseValues["False"] = 0] = "False";
})(TrueFalseValues || (TrueFalseValues = {}));
var HelpType;
(function (HelpType) {
    HelpType["Internal"] = "I";
    HelpType["Prompt"] = "P";
    HelpType["Windows"] = "W";
    HelpType["Tooltip"] = "T";
    HelpType["URL"] = "U";
})(HelpType || (HelpType = {}));
var NullArithmetic;
(function (NullArithmetic) {
    NullArithmetic[NullArithmetic["Nullify"] = 0] = "Nullify";
    NullArithmetic[NullArithmetic["UseDefault"] = 1] = "UseDefault";
})(NullArithmetic || (NullArithmetic = {}));
var ModelClass;
(function (ModelClass) {
    ModelClass["Help"] = "A";
    ModelClass["Field"] = "B";
    ModelClass["Browser"] = "C";
    ModelClass["GUI0"] = "D";
    ModelClass["GUI1"] = "E";
    ModelClass["TextBased"] = "F";
    ModelClass["Frameset"] = "G";
    ModelClass["Merge"] = "H";
    ModelClass["RCDisplay"] = "I";
    ModelClass["RCFrame"] = "J";
    ModelClass["GuiFrame"] = "K";
})(ModelClass || (ModelClass = {}));
var CompTypes;
(function (CompTypes) {
    CompTypes["Magicxpa"] = "U";
    CompTypes["DotNet"] = "D";
})(CompTypes || (CompTypes = {}));
var TaskFlow;
(function (TaskFlow) {
    TaskFlow["Undefined"] = "U";
    TaskFlow["Online"] = "O";
    TaskFlow["Batch"] = "B";
    TaskFlow["Browser"] = "R";
    TaskFlow["RichClient"] = "C";
})(TaskFlow || (TaskFlow = {}));
var RemarkType;
(function (RemarkType) {
    RemarkType[RemarkType["RegularOperation"] = 0] = "RegularOperation";
    RemarkType[RemarkType["Dataviewheader"] = 1] = "Dataviewheader";
    RemarkType[RemarkType["TaskLogic"] = 2] = "TaskLogic";
})(RemarkType || (RemarkType = {}));
var VeeMode;
(function (VeeMode) {
    VeeMode["None"] = " ";
    VeeMode["Parameter"] = "P";
    VeeMode["Virtual"] = "V";
    VeeMode["Real"] = "R";
    VeeMode["Column"] = "C";
    VeeMode["LinkCol"] = "L";
})(VeeMode || (VeeMode = {}));
var VeeDiffUpdate;
(function (VeeDiffUpdate) {
    VeeDiffUpdate["AsTable"] = "T";
    VeeDiffUpdate["Absolute"] = "N";
    VeeDiffUpdate["Differential"] = "Y";
    VeeDiffUpdate[VeeDiffUpdate["None"] = 0] = "None";
})(VeeDiffUpdate || (VeeDiffUpdate = {}));
var VeePartOfDataview;
(function (VeePartOfDataview) {
    VeePartOfDataview["Undefined"] = "U";
})(VeePartOfDataview || (VeePartOfDataview = {}));
var DataviewType;
(function (DataviewType) {
    DataviewType["MainTable"] = "M";
    DataviewType["DSQL"] = "Q";
    DataviewType["Declaration"] = "D";
})(DataviewType || (DataviewType = {}));
var TabbingCycleType;
(function (TabbingCycleType) {
    TabbingCycleType["RemainInCurrentRecord"] = "R";
    TabbingCycleType["MoveToNextRecord"] = "N";
    TabbingCycleType["MoveToParentTask"] = "P";
})(TabbingCycleType || (TabbingCycleType = {}));
var LockingStrategy;
(function (LockingStrategy) {
    LockingStrategy["Immediate"] = "I";
    LockingStrategy["OnModify"] = "O";
    LockingStrategy["AfterModify"] = "A";
    LockingStrategy["BeforeUpdate"] = "B";
    LockingStrategy["Minimum"] = "M";
})(LockingStrategy || (LockingStrategy = {}));
var TransBegin;
(function (TransBegin) {
    TransBegin["Update"] = "U";
    TransBegin["Prefix"] = "P";
    TransBegin["Suffix"] = "S";
    TransBegin["OnLock"] = "L";
    TransBegin["None"] = "N";
    TransBegin["BeforeTask"] = "T";
    TransBegin["Group"] = "G";
})(TransBegin || (TransBegin = {}));
var ErrStrategy;
(function (ErrStrategy) {
    ErrStrategy["Recover"] = "R";
    ErrStrategy["Abort"] = "A";
})(ErrStrategy || (ErrStrategy = {}));
var CacheStrategy;
(function (CacheStrategy) {
    CacheStrategy["Pos"] = "P";
    CacheStrategy["PosData"] = "D";
    CacheStrategy["None"] = "N";
    CacheStrategy["AsTable"] = "T";
})(CacheStrategy || (CacheStrategy = {}));
var ExeState;
(function (ExeState) {
    ExeState["Prefix"] = "P";
    ExeState["Suffix"] = "S";
    ExeState["Update"] = "U";
    ExeState["Main"] = "M";
    ExeState["Before"] = "B";
    ExeState["AfterOnChange"] = "O";
    ExeState["Verify"] = "V";
    ExeState["Change"] = "C";
})(ExeState || (ExeState = {}));
var TransMode;
(function (TransMode) {
    TransMode["Deferred"] = "D";
    TransMode["NestedDeffered"] = "N";
    TransMode["Physical"] = "P";
    TransMode["WithinActiveTrans"] = "W";
    TransMode["None"] = "O";
})(TransMode || (TransMode = {}));
var PositionUsage;
(function (PositionUsage) {
    PositionUsage["RangeOn"] = "O";
    PositionUsage["RangeFrom"] = "F";
    PositionUsage["Locate"] = "L";
})(PositionUsage || (PositionUsage = {}));
var LnkMode;
(function (LnkMode) {
    LnkMode["Query"] = "R";
    LnkMode["Write"] = "W";
    LnkMode["Create"] = "A";
    LnkMode["IJoin"] = "J";
    LnkMode["OJoin"] = "O";
})(LnkMode || (LnkMode = {}));
var InitialMode;
(function (InitialMode) {
    InitialMode["Modify"] = "M";
    InitialMode["Create"] = "C";
    InitialMode["Delete"] = "D";
    InitialMode["Query"] = "E";
    InitialMode["AsParent"] = "P";
    InitialMode["Locate"] = "L";
    InitialMode["Range"] = "R";
    InitialMode["Key"] = "K";
    InitialMode["Sort"] = "S";
    InitialMode["Files"] = "O";
    InitialMode["Options"] = "N";
    InitialMode["ByExp"] = "B";
})(InitialMode || (InitialMode = {}));
var KeyMode;
(function (KeyMode) {
    KeyMode["Normal"] = "N";
    KeyMode["Insert"] = "I";
    KeyMode["Append"] = "A";
})(KeyMode || (KeyMode = {}));
var BoxDir;
(function (BoxDir) {
    BoxDir["Vertical"] = "V";
    BoxDir["Horizontal"] = "H";
})(BoxDir || (BoxDir = {}));
var EndMode;
(function (EndMode) {
    EndMode["Before"] = "B";
    EndMode["After"] = "A";
    EndMode["Immediate"] = "I";
})(EndMode || (EndMode = {}));
var UniqueTskSort;
(function (UniqueTskSort) {
    UniqueTskSort["AccordingToIndex"] = "A";
    UniqueTskSort["Unique"] = "U";
})(UniqueTskSort || (UniqueTskSort = {}));
var BrkType;
(function (BrkType) {
    BrkType["Prefix"] = "P";
    BrkType["Suffix"] = "S";
    BrkType["Main"] = "M";
    BrkType["User"] = "U";
    BrkType["Error"] = "E";
    BrkType["Verify"] = "V";
    BrkType["ChoiceChange"] = "C";
})(BrkType || (BrkType = {}));
var ErrorClassific;
(function (ErrorClassific) {
    ErrorClassific[ErrorClassific["Any"] = 0] = "Any";
    ErrorClassific[ErrorClassific["RecLocked"] = 1] = "RecLocked";
    ErrorClassific[ErrorClassific["DupKey"] = 2] = "DupKey";
    ErrorClassific[ErrorClassific["ConstrFail"] = 3] = "ConstrFail";
    ErrorClassific[ErrorClassific["TriggerFail"] = 4] = "TriggerFail";
    ErrorClassific[ErrorClassific["RecUpdated"] = 5] = "RecUpdated";
    ErrorClassific[ErrorClassific["RowsAffected"] = 6] = "RowsAffected";
    ErrorClassific[ErrorClassific["UpdateFail"] = 7] = "UpdateFail";
    ErrorClassific[ErrorClassific["Unmapped"] = 8] = "Unmapped";
    ErrorClassific[ErrorClassific["ExecSql"] = 9] = "ExecSql";
    ErrorClassific[ErrorClassific["BadSqlCmd"] = 10] = "BadSqlCmd";
    ErrorClassific[ErrorClassific["BadIni"] = 11] = "BadIni";
    ErrorClassific[ErrorClassific["BaName"] = 12] = "BaName";
    ErrorClassific[ErrorClassific["Damaged"] = 13] = "Damaged";
    ErrorClassific[ErrorClassific["Unlocked"] = 14] = "Unlocked";
    ErrorClassific[ErrorClassific["BadOpen"] = 15] = "BadOpen";
    ErrorClassific[ErrorClassific["BadClose"] = 16] = "BadClose";
    ErrorClassific[ErrorClassific["RsrcLocked"] = 17] = "RsrcLocked";
    ErrorClassific[ErrorClassific["RecLockedNoBuf"] = 18] = "RecLockedNoBuf";
    ErrorClassific[ErrorClassific["NoDef"] = 19] = "NoDef";
    ErrorClassific[ErrorClassific["RecLockedNow"] = 20] = "RecLockedNow";
    ErrorClassific[ErrorClassific["WrnRetry"] = 21] = "WrnRetry";
    ErrorClassific[ErrorClassific["RecLockedMagic"] = 22] = "RecLockedMagic";
    ErrorClassific[ErrorClassific["ReadOnly"] = 23] = "ReadOnly";
    ErrorClassific[ErrorClassific["WrnCreated"] = 24] = "WrnCreated";
    ErrorClassific[ErrorClassific["Capacity"] = 25] = "Capacity";
    ErrorClassific[ErrorClassific["TransCommit"] = 26] = "TransCommit";
    ErrorClassific[ErrorClassific["TransOpen"] = 27] = "TransOpen";
    ErrorClassific[ErrorClassific["TransAbort"] = 28] = "TransAbort";
    ErrorClassific[ErrorClassific["BadDef"] = 29] = "BadDef";
    ErrorClassific[ErrorClassific["InvalidOwnr"] = 30] = "InvalidOwnr";
    ErrorClassific[ErrorClassific["ClrOwnrFail"] = 31] = "ClrOwnrFail";
    ErrorClassific[ErrorClassific["AlterTbl"] = 32] = "AlterTbl";
    ErrorClassific[ErrorClassific["SortTbl"] = 33] = "SortTbl";
    ErrorClassific[ErrorClassific["CanotRemove"] = 34] = "CanotRemove";
    ErrorClassific[ErrorClassific["CanotRename"] = 35] = "CanotRename";
    ErrorClassific[ErrorClassific["WrnLogActive"] = 36] = "WrnLogActive";
    ErrorClassific[ErrorClassific["TargetFileExist"] = 37] = "TargetFileExist";
    ErrorClassific[ErrorClassific["FileIsView"] = 38] = "FileIsView";
    ErrorClassific[ErrorClassific["CanotCopy"] = 39] = "CanotCopy";
    ErrorClassific[ErrorClassific["Stop"] = 40] = "Stop";
    ErrorClassific[ErrorClassific["StrBadName"] = 41] = "StrBadName";
    ErrorClassific[ErrorClassific["InsertIntoAll"] = 42] = "InsertIntoAll";
    ErrorClassific[ErrorClassific["BadQry"] = 43] = "BadQry";
    ErrorClassific[ErrorClassific["FilterAfterInsert"] = 44] = "FilterAfterInsert";
    ErrorClassific[ErrorClassific["GetUserPwdDst"] = 45] = "GetUserPwdDst";
    ErrorClassific[ErrorClassific["WrnCacheTooBig"] = 46] = "WrnCacheTooBig";
    ErrorClassific[ErrorClassific["LostRec"] = 47] = "LostRec";
    ErrorClassific[ErrorClassific["FileLocked"] = 48] = "FileLocked";
    ErrorClassific[ErrorClassific["MaxConnEx"] = 49] = "MaxConnEx";
    ErrorClassific[ErrorClassific["Deadlock"] = 50] = "Deadlock";
    ErrorClassific[ErrorClassific["BadCreate"] = 51] = "BadCreate";
    ErrorClassific[ErrorClassific["FilNotExist"] = 52] = "FilNotExist";
    ErrorClassific[ErrorClassific["Unused"] = 53] = "Unused";
    ErrorClassific[ErrorClassific["IdxCreateFail"] = 54] = "IdxCreateFail";
    ErrorClassific[ErrorClassific["ConnectFail"] = 55] = "ConnectFail";
    ErrorClassific[ErrorClassific["Fatal"] = 56] = "Fatal";
    ErrorClassific[ErrorClassific["InsertFail"] = 57] = "InsertFail";
    ErrorClassific[ErrorClassific["DeleteFail"] = 58] = "DeleteFail";
    ErrorClassific[ErrorClassific["InErrorZone"] = 59] = "InErrorZone";
    ErrorClassific[ErrorClassific["NoRec"] = 60] = "NoRec";
    ErrorClassific[ErrorClassific["NotExist"] = 61] = "NotExist";
    ErrorClassific[ErrorClassific["GetUserPwd"] = 62] = "GetUserPwd";
    ErrorClassific[ErrorClassific["WrnCancel"] = 63] = "WrnCancel";
    ErrorClassific[ErrorClassific["NotSupportedFunc"] = 64] = "NotSupportedFunc";
    ErrorClassific[ErrorClassific["ModifyWithinTrans"] = 65] = "ModifyWithinTrans";
    ErrorClassific[ErrorClassific["LoginPwd"] = 66] = "LoginPwd";
    ErrorClassific[ErrorClassific["None"] = 67] = "None";
})(ErrorClassific || (ErrorClassific = {}));
var ComponentItemType;
(function (ComponentItemType) {
    ComponentItemType[ComponentItemType["Models"] = 0] = "Models";
    ComponentItemType[ComponentItemType["DataSources"] = 1] = "DataSources";
    ComponentItemType[ComponentItemType["Programs"] = 2] = "Programs";
    ComponentItemType[ComponentItemType["Helps"] = 3] = "Helps";
    ComponentItemType[ComponentItemType["Rights"] = 4] = "Rights";
    ComponentItemType[ComponentItemType["Events"] = 5] = "Events";
    ComponentItemType[ComponentItemType["Functions"] = 6] = "Functions";
})(ComponentItemType || (ComponentItemType = {}));
var FieldComAlloc;
(function (FieldComAlloc) {
    FieldComAlloc[FieldComAlloc["Auto"] = 1] = "Auto";
    FieldComAlloc[FieldComAlloc["None"] = 2] = "None";
})(FieldComAlloc || (FieldComAlloc = {}));
var BlobContent;
(function (BlobContent) {
    BlobContent["Unknown"] = "0";
    BlobContent["Ansi"] = "1";
    BlobContent["Unicode"] = "2";
    BlobContent["Binary"] = "3";
})(BlobContent || (BlobContent = {}));
var DBHRowIdentifier;
(function (DBHRowIdentifier) {
    DBHRowIdentifier["RowId"] = "R";
    DBHRowIdentifier["Default"] = "D";
    DBHRowIdentifier["UniqueKey"] = "U";
})(DBHRowIdentifier || (DBHRowIdentifier = {}));
var UseSQLCursor;
(function (UseSQLCursor) {
    UseSQLCursor["Yes"] = "Y";
    UseSQLCursor["No"] = "N";
    UseSQLCursor["Default"] = "D";
})(UseSQLCursor || (UseSQLCursor = {}));
var DBHCache;
(function (DBHCache) {
    DBHCache["Pos"] = "P";
    DBHCache["PosData"] = "D";
    DBHCache["None"] = "N";
    DBHCache["AsTable"] = "T";
})(DBHCache || (DBHCache = {}));
var Resident;
(function (Resident) {
    Resident["No"] = "N";
    Resident["Immediate"] = "I";
    Resident["OnDemand"] = "D";
    Resident["ImmediateAndClient"] = "C";
    Resident["ImmediateAndBrowser"] = "B";
})(Resident || (Resident = {}));
var CheckExist;
(function (CheckExist) {
    CheckExist["CheckYes"] = "Y";
    CheckExist["CheckNo"] = "N";
    CheckExist["CheckDB"] = "D";
})(CheckExist || (CheckExist = {}));
var ValType;
(function (ValType) {
    ValType[ValType["ZString"] = 1] = "ZString";
    ValType[ValType["MagicNum"] = 2] = "MagicNum";
    ValType[ValType["Boolean"] = 3] = "Boolean";
    ValType[ValType["UString"] = 4] = "UString";
})(ValType || (ValType = {}));
var FldStorage;
(function (FldStorage) {
    FldStorage[FldStorage["AlphaString"] = 1] = "AlphaString";
    FldStorage[FldStorage["AlphaLString"] = 2] = "AlphaLString";
    FldStorage[FldStorage["AlphaZString"] = 3] = "AlphaZString";
    FldStorage[FldStorage["NumericSigned"] = 4] = "NumericSigned";
    FldStorage[FldStorage["NumericUnsigned"] = 5] = "NumericUnsigned";
    FldStorage[FldStorage["NumericFloat"] = 6] = "NumericFloat";
    FldStorage[FldStorage["NumericFloatMS"] = 7] = "NumericFloatMS";
    FldStorage[FldStorage["NumericFloatDec"] = 8] = "NumericFloatDec";
    FldStorage[FldStorage["NumericPackedDec"] = 9] = "NumericPackedDec";
    FldStorage[FldStorage["NumericNumeric"] = 10] = "NumericNumeric";
    FldStorage[FldStorage["NumericCharDec"] = 11] = "NumericCharDec";
    FldStorage[FldStorage["NumericString"] = 12] = "NumericString";
    FldStorage[FldStorage["NumericMagic"] = 13] = "NumericMagic";
    FldStorage[FldStorage["NumericCisam"] = 14] = "NumericCisam";
    FldStorage[FldStorage["NumericExtFloat"] = 30] = "NumericExtFloat";
    FldStorage[FldStorage["BooleanInteger"] = 15] = "BooleanInteger";
    FldStorage[FldStorage["BooleanDBase"] = 16] = "BooleanDBase";
    FldStorage[FldStorage["DateInteger"] = 17] = "DateInteger";
    FldStorage[FldStorage["DateInteger1901"] = 18] = "DateInteger1901";
    FldStorage[FldStorage["DateString"] = 19] = "DateString";
    FldStorage[FldStorage["DateYYMD"] = 20] = "DateYYMD";
    FldStorage[FldStorage["DateMagic"] = 21] = "DateMagic";
    FldStorage[FldStorage["DateMagic1901"] = 22] = "DateMagic1901";
    FldStorage[FldStorage["TimeInteger"] = 23] = "TimeInteger";
    FldStorage[FldStorage["TimeString"] = 24] = "TimeString";
    FldStorage[FldStorage["TimeHMSH"] = 25] = "TimeHMSH";
    FldStorage[FldStorage["TimeMagic"] = 26] = "TimeMagic";
    FldStorage[FldStorage["MemoString"] = 27] = "MemoString";
    FldStorage[FldStorage["MemoMagic"] = 28] = "MemoMagic";
    FldStorage[FldStorage["Blob"] = 29] = "Blob";
    FldStorage[FldStorage["UnicodeString"] = 31] = "UnicodeString";
    FldStorage[FldStorage["UnicodeZString"] = 32] = "UnicodeZString";
    FldStorage[FldStorage["AnsiBlob"] = 33] = "AnsiBlob";
    FldStorage[FldStorage["UnicodeBlob"] = 34] = "UnicodeBlob";
})(FldStorage || (FldStorage = {}));
var DriverDB;
(function (DriverDB) {
    DriverDB[DriverDB["Btrv"] = 0] = "Btrv";
    DriverDB[DriverDB["Prevesive2000"] = 1] = "Prevesive2000";
    DriverDB[DriverDB["RMS"] = 2] = "RMS";
    DriverDB[DriverDB["MySQL"] = 3] = "MySQL";
    DriverDB[DriverDB["DBase"] = 4] = "DBase";
    DriverDB[DriverDB["Cache"] = 5] = "Cache";
    DriverDB[DriverDB["DB2AS400"] = 6] = "DB2AS400";
    DriverDB[DriverDB["FoxBase"] = 7] = "FoxBase";
    DriverDB[DriverDB["Clipper"] = 8] = "Clipper";
    DriverDB[DriverDB["SyBase"] = 9] = "SyBase";
    DriverDB[DriverDB["Cics"] = 12] = "Cics";
    DriverDB[DriverDB["Oracle"] = 13] = "Oracle";
    DriverDB[DriverDB["Informix"] = 14] = "Informix";
    DriverDB[DriverDB["Ingres"] = 15] = "Ingres";
    DriverDB[DriverDB["AS400"] = 16] = "AS400";
    DriverDB[DriverDB["DB2"] = 18] = "DB2";
    DriverDB[DriverDB["Odbc"] = 19] = "Odbc";
    DriverDB[DriverDB["MS6"] = 20] = "MS6";
    DriverDB[DriverDB["Memory"] = 21] = "Memory";
    DriverDB[DriverDB["RMCOB"] = 22] = "RMCOB";
})(DriverDB || (DriverDB = {}));
var ExportType;
(function (ExportType) {
    ExportType["EntireProject"] = "A";
    ExportType["Models"] = "E";
    ExportType["DataSources"] = "F";
    ExportType["Programs"] = "P";
    ExportType["Helps"] = "H";
    ExportType["Rights"] = "R";
    ExportType["Menus"] = "M";
    ExportType["CompositeResources"] = "O";
    ExportType["ApplicationProperties"] = "C";
})(ExportType || (ExportType = {}));
var TriggerType;
(function (TriggerType) {
    TriggerType["System"] = "S";
    TriggerType["Timer"] = "T";
    TriggerType["Expression"] = "E";
    TriggerType["Internal"] = "I";
    TriggerType["None"] = "N";
    TriggerType["Component"] = "C";
    TriggerType["User"] = "U";
    TriggerType["Error"] = "R";
    TriggerType["ComEvent"] = "X";
    TriggerType["DotNetEvent"] = "D";
    TriggerType["PublicUserEvent"] = "P";
    TriggerType["UserFunc"] = "F";
})(TriggerType || (TriggerType = {}));
var ItemMasks;
(function (ItemMasks) {
    ItemMasks[ItemMasks["Undefined"] = 0] = "Undefined";
    ItemMasks[ItemMasks["ActiveInClient"] = 1] = "ActiveInClient";
    ItemMasks[ItemMasks["MagicSqlFunc"] = 4] = "MagicSqlFunc";
    ItemMasks[ItemMasks["CacheAlways"] = 8] = "CacheAlways";
    ItemMasks[ItemMasks["CacheSometimes"] = 16] = "CacheSometimes";
    ItemMasks["RtSearchExecAllowed"] = " ";
    ItemMasks["ArgAttrAsResult"] = "@";
    ItemMasks[ItemMasks["CalcResAttr"] = 128] = "CalcResAttr";
    ItemMasks[ItemMasks["PossibleReentrance"] = 256] = "PossibleReentrance";
    ItemMasks[ItemMasks["ForceClientExecBrowserClient"] = 512] = "ForceClientExecBrowserClient";
    ItemMasks[ItemMasks["ForceServerExecBrowserClient"] = 1024] = "ForceServerExecBrowserClient";
    ItemMasks[ItemMasks["FuncNotSupportedBrowserClient"] = 2048] = "FuncNotSupportedBrowserClient";
    ItemMasks[ItemMasks["ForceClientExecRichClient"] = 4096] = "ForceClientExecRichClient";
    ItemMasks[ItemMasks["ForceServerExecRichClient"] = 8192] = "ForceServerExecRichClient";
    ItemMasks[ItemMasks["FuncNotSupportedRichClient"] = 16384] = "FuncNotSupportedRichClient";
    ItemMasks[ItemMasks["FuncNotSupportedOnlineBatch"] = 32768] = "FuncNotSupportedOnlineBatch";
    ItemMasks[ItemMasks["ForceMixExecRichClient"] = 65536] = "ForceMixExecRichClient";
    ItemMasks[ItemMasks["ForceUnknownExecRichClient"] = 131072] = "ForceUnknownExecRichClient";
})(ItemMasks || (ItemMasks = {}));
var UpdateMode;
(function (UpdateMode) {
    UpdateMode["Incremental"] = "I";
    UpdateMode["Normal"] = "N";
})(UpdateMode || (UpdateMode = {}));
var BlockTypes;
(function (BlockTypes) {
    BlockTypes["If"] = "I";
    BlockTypes["Else"] = "E";
    BlockTypes["EndBlock"] = "N";
    BlockTypes["Loop"] = "L";
})(BlockTypes || (BlockTypes = {}));
var FormOperationType;
(function (FormOperationType) {
    FormOperationType["Input"] = "I";
    FormOperationType["Output"] = "O";
})(FormOperationType || (FormOperationType = {}));
var FormPage;
(function (FormPage) {
    FormPage["Skip"] = "S";
    FormPage["Auto"] = "A";
    FormPage["Top"] = "T";
})(FormPage || (FormPage = {}));
var FormDelimiter;
(function (FormDelimiter) {
    FormDelimiter["Column"] = "C";
    FormDelimiter["Single"] = "S";
    FormDelimiter["Double"] = "D";
})(FormDelimiter || (FormDelimiter = {}));
var CallOperationMode;
(function (CallOperationMode) {
    CallOperationMode["Program"] = "P";
    CallOperationMode["SubTask"] = "T";
    CallOperationMode["ByExp"] = "E";
    CallOperationMode["ByName"] = "B";
    CallOperationMode["Remote"] = "R";
    CallOperationMode["Com"] = "C";
    CallOperationMode["OsCommand"] = "O";
    CallOperationMode["UDP"] = "U";
    CallOperationMode["WebS"] = "W";
    CallOperationMode["WebSLite"] = "L";
    CallOperationMode[CallOperationMode["DotNet"] = 46] = "DotNet";
})(CallOperationMode || (CallOperationMode = {}));
var RowType;
(function (RowType) {
    RowType[RowType["Header"] = 1] = "Header";
    RowType[RowType["Operation"] = 2] = "Operation";
})(RowType || (RowType = {}));
var ForceExit;
(function (ForceExit) {
    ForceExit["None"] = "N";
    ForceExit["Control"] = "C";
    ForceExit["PreRecordUpdate"] = "R";
    ForceExit["PostRecordUpdate"] = "P";
    ForceExit["Ignore"] = "I";
    ForceExit["Editing"] = "E";
})(ForceExit || (ForceExit = {}));
var MediaType;
(function (MediaType) {
    MediaType["None"] = "N";
    MediaType["GraphicalPrinter"] = "G";
    MediaType["Printer"] = "P";
    MediaType["Console"] = "C";
    MediaType["File"] = "F";
    MediaType["Requester"] = "R";
    MediaType["XMLDirect"] = "D";
    MediaType["Variable"] = "V";
})(MediaType || (MediaType = {}));
var OSType;
(function (OSType) {
    OSType["Android"] = "A";
    OSType["IOS"] = "I";
})(OSType || (OSType = {}));
var APGMode;
(function (APGMode) {
    APGMode["Execute"] = "E";
    APGMode["Generate"] = "G";
})(APGMode || (APGMode = {}));
var APGOption;
(function (APGOption) {
    APGOption["Browse"] = "B";
    APGOption["Export"] = "E";
    APGOption["Import"] = "I";
    APGOption["Print"] = "P";
    APGOption["Browser"] = "R";
    APGOption["RichClient"] = "H";
})(APGOption || (APGOption = {}));
var APGDisplayMode;
(function (APGDisplayMode) {
    APGDisplayMode["Line"] = "L";
    APGDisplayMode["Screen"] = "S";
    APGDisplayMode["None"] = "N";
})(APGDisplayMode || (APGDisplayMode = {}));
var APGFormSize;
(function (APGFormSize) {
    APGFormSize["AsModel"] = "M";
    APGFormSize["AsContent"] = "C";
    APGFormSize["AsContentWithinMDI"] = "D";
})(APGFormSize || (APGFormSize = {}));
var APGType;
(function (APGType) {
    APGType["Single"] = "S";
    APGType["Multiple"] = "M";
    APGType["Program"] = "P";
})(APGType || (APGType = {}));
var APGInvokedFrom;
(function (APGInvokedFrom) {
    APGInvokedFrom[APGInvokedFrom["TablesRepository"] = 1] = "TablesRepository";
    APGInvokedFrom[APGInvokedFrom["ProgramsRepository"] = 2] = "ProgramsRepository";
})(APGInvokedFrom || (APGInvokedFrom = {}));
var MgModelType;
(function (MgModelType) {
    MgModelType["Model"] = "M";
    MgModelType["Var"] = "V";
})(MgModelType || (MgModelType = {}));
var CallbackType;
(function (CallbackType) {
    CallbackType[CallbackType["ProgressBar"] = 0] = "ProgressBar";
    CallbackType[CallbackType["Import"] = 1] = "Import";
    CallbackType[CallbackType["FormEditor"] = 2] = "FormEditor";
    CallbackType[CallbackType["CollectionChanges"] = 3] = "CollectionChanges";
})(CallbackType || (CallbackType = {}));
var Axis;
(function (Axis) {
    Axis[Axis["X"] = 0] = "X";
    Axis[Axis["Y"] = 1] = "Y";
})(Axis || (Axis = {}));
var ModelAttrHelp;
(function (ModelAttrHelp) {
    ModelAttrHelp["Internal"] = "A";
    ModelAttrHelp["Windows"] = "B";
})(ModelAttrHelp || (ModelAttrHelp = {}));
var ModelAttrField;
(function (ModelAttrField) {
    ModelAttrField["Alpha"] = "A";
    ModelAttrField["Numeric"] = "C";
    ModelAttrField["Unicode"] = "B";
    ModelAttrField["Logical"] = "D";
    ModelAttrField["Date"] = "E";
    ModelAttrField["Time"] = "F";
    ModelAttrField["Blob"] = "G";
    ModelAttrField["OLE"] = "H";
    ModelAttrField["ActiveX"] = "I";
    ModelAttrField["Vector"] = "J";
    ModelAttrField["DotNet"] = "K";
})(ModelAttrField || (ModelAttrField = {}));
var ModelAttrGui0;
(function (ModelAttrGui0) {
    ModelAttrGui0["Form"] = "A";
    ModelAttrGui0["Edit"] = "B";
    ModelAttrGui0["Static"] = "C";
    ModelAttrGui0["Button"] = "D";
    ModelAttrGui0["Check"] = "E";
    ModelAttrGui0["Radio"] = "F";
    ModelAttrGui0["Tab"] = "G";
    ModelAttrGui0["List"] = "H";
    ModelAttrGui0["Combo"] = "I";
    ModelAttrGui0["Line"] = "J";
    ModelAttrGui0["Slider"] = "K";
    ModelAttrGui0["Table"] = "L";
    ModelAttrGui0["Column"] = "M";
    ModelAttrGui0["Image"] = "N";
    ModelAttrGui0["Ole"] = "O";
    ModelAttrGui0["Redit"] = "P";
    ModelAttrGui0["Activex"] = "R";
    ModelAttrGui0["Subform"] = "S";
    ModelAttrGui0["Browser"] = "O";
})(ModelAttrGui0 || (ModelAttrGui0 = {}));
var ModelAttrGui1;
(function (ModelAttrGui1) {
    ModelAttrGui1["Form"] = "A";
    ModelAttrGui1["Edit"] = "B";
    ModelAttrGui1["Static"] = "C";
    ModelAttrGui1["Line"] = "D";
    ModelAttrGui1["Table"] = "E";
    ModelAttrGui1["Column"] = "F";
    ModelAttrGui1["Image"] = "G";
    ModelAttrGui1["Redit"] = "H";
})(ModelAttrGui1 || (ModelAttrGui1 = {}));
var ModelAttrText;
(function (ModelAttrText) {
    ModelAttrText["Form"] = "A";
    ModelAttrText["Edit"] = "B";
    ModelAttrText["Static"] = "C";
    ModelAttrText["Line"] = "D";
})(ModelAttrText || (ModelAttrText = {}));
var ModelAttrRichClient;
(function (ModelAttrRichClient) {
    ModelAttrRichClient["Form"] = "A";
    ModelAttrRichClient["Edit"] = "B";
    ModelAttrRichClient["Label"] = "C";
    ModelAttrRichClient["Button"] = "D";
    ModelAttrRichClient["Check"] = "E";
    ModelAttrRichClient["Radio"] = "F";
    ModelAttrRichClient["Tab"] = "G";
    ModelAttrRichClient["List"] = "H";
    ModelAttrRichClient["Combo"] = "I";
    ModelAttrRichClient["Group"] = "J";
    ModelAttrRichClient["Table"] = "K";
    ModelAttrRichClient["Column"] = "L";
    ModelAttrRichClient["Image"] = "M";
    ModelAttrRichClient["Subform"] = "N";
    ModelAttrRichClient["Browser"] = "O";
    ModelAttrRichClient["Line"] = "Q";
})(ModelAttrRichClient || (ModelAttrRichClient = {}));
var ModelAttrFramesetForm;
(function (ModelAttrFramesetForm) {
    ModelAttrFramesetForm["Form"] = "A";
    ModelAttrFramesetForm["Frame"] = "B";
})(ModelAttrFramesetForm || (ModelAttrFramesetForm = {}));
var ModelAttRichClientFrameSet;
(function (ModelAttRichClientFrameSet) {
    ModelAttRichClientFrameSet["Form"] = "A";
    ModelAttRichClientFrameSet["Frame"] = "B";
})(ModelAttRichClientFrameSet || (ModelAttRichClientFrameSet = {}));
var ModelAttrBrowser;
(function (ModelAttrBrowser) {
    ModelAttrBrowser["Form"] = "A";
    ModelAttrBrowser["Edit"] = "B";
    ModelAttrBrowser["Static"] = "C";
    ModelAttrBrowser["Button"] = "D";
    ModelAttrBrowser["Check"] = "E";
    ModelAttrBrowser["Radio"] = "F";
    ModelAttrBrowser["List"] = "G";
    ModelAttrBrowser["Combo"] = "H";
    ModelAttrBrowser["Table"] = "I";
    ModelAttrBrowser["Image"] = "J";
    ModelAttrBrowser["Subform"] = "K";
    ModelAttrBrowser["Iframe"] = "L";
    ModelAttrBrowser["Opaque"] = "M";
})(ModelAttrBrowser || (ModelAttrBrowser = {}));
var ModelAttGuiFrame;
(function (ModelAttGuiFrame) {
    ModelAttGuiFrame["Form"] = "A";
    ModelAttGuiFrame["Frame"] = "B";
})(ModelAttGuiFrame || (ModelAttGuiFrame = {}));
var ModelAttMerge;
(function (ModelAttMerge) {
    ModelAttMerge["Form"] = "A";
})(ModelAttMerge || (ModelAttMerge = {}));
var DbhKeyMode;
(function (DbhKeyMode) {
    DbhKeyMode["Unique"] = "S";
    DbhKeyMode["NonUnique"] = "N";
})(DbhKeyMode || (DbhKeyMode = {}));
var DbhKeyDirection;
(function (DbhKeyDirection) {
    DbhKeyDirection["OneWay"] = "A";
    DbhKeyDirection["TwoWay"] = "B";
})(DbhKeyDirection || (DbhKeyDirection = {}));
var DbhKeyRangeMode;
(function (DbhKeyRangeMode) {
    DbhKeyRangeMode["Quick"] = "Q";
    DbhKeyRangeMode["Full"] = "F";
})(DbhKeyRangeMode || (DbhKeyRangeMode = {}));
var DbhKeyIndexType;
(function (DbhKeyIndexType) {
    DbhKeyIndexType["Real"] = "R";
    DbhKeyIndexType["Virtual"] = "V";
})(DbhKeyIndexType || (DbhKeyIndexType = {}));
var DbhSegmentDirection;
(function (DbhSegmentDirection) {
    DbhSegmentDirection["Ascending"] = "A";
    DbhSegmentDirection["Descending"] = "D";
})(DbhSegmentDirection || (DbhSegmentDirection = {}));
var ChoiceControlStyle;
(function (ChoiceControlStyle) {
    ChoiceControlStyle[ChoiceControlStyle["ListBox"] = 1] = "ListBox";
    ChoiceControlStyle[ChoiceControlStyle["ComboBox"] = 2] = "ComboBox";
    ChoiceControlStyle[ChoiceControlStyle["Tab"] = 3] = "Tab";
    ChoiceControlStyle[ChoiceControlStyle["RadioButton"] = 4] = "RadioButton";
})(ChoiceControlStyle || (ChoiceControlStyle = {}));
var Recursion;
(function (Recursion) {
    Recursion[Recursion["None"] = 0] = "None";
    Recursion[Recursion["First"] = 1] = "First";
    Recursion[Recursion["Second"] = 2] = "Second";
    Recursion[Recursion["FirstOpen"] = 3] = "FirstOpen";
})(Recursion || (Recursion = {}));
var ViewSelectType;
(function (ViewSelectType) {
    ViewSelectType[ViewSelectType["IncludeInView"] = 0] = "IncludeInView";
    ViewSelectType[ViewSelectType["ExcludeFromView"] = 1] = "ExcludeFromView";
})(ViewSelectType || (ViewSelectType = {}));
var RangeMode;
(function (RangeMode) {
    RangeMode["From"] = "F";
    RangeMode["To"] = "T";
    RangeMode["Equal"] = "E";
})(RangeMode || (RangeMode = {}));
var TableType;
(function (TableType) {
    TableType["Table"] = "T";
    TableType["View"] = "V";
    TableType["Undefined"] = "U";
})(TableType || (TableType = {}));
var DatabaseDataType;
(function (DatabaseDataType) {
    DatabaseDataType["XmlDataSource"] = "X";
    DatabaseDataType["DatabaseDataSource"] = "D";
})(DatabaseDataType || (DatabaseDataType = {}));
var LogicHeaderAction;
(function (LogicHeaderAction) {
    LogicHeaderAction[LogicHeaderAction["None"] = 0] = "None";
    LogicHeaderAction[LogicHeaderAction["CreateVariableChangeParameters"] = 1] = "CreateVariableChangeParameters";
    LogicHeaderAction[LogicHeaderAction["DeleteVariableChangeParameters"] = 2] = "DeleteVariableChangeParameters";
    LogicHeaderAction[LogicHeaderAction["ReplaceVariableChangeParameters"] = 3] = "ReplaceVariableChangeParameters";
    LogicHeaderAction[LogicHeaderAction["CreateEventParameters"] = 4] = "CreateEventParameters";
})(LogicHeaderAction || (LogicHeaderAction = {}));
var DatabaseFilters;
(function (DatabaseFilters) {
    DatabaseFilters["EnvironmentDatabaseAll"] = "A";
    DatabaseFilters["EnvironmentDatabaseSql"] = "S";
    DatabaseFilters["EnvironmentDatabaseCanLoadDefinition"] = "D";
    DatabaseFilters["EnvironmentDatabaseIsam"] = "I";
    DatabaseFilters["EnvironmentDatabaseXmlOnly"] = "X";
    DatabaseFilters["EnvironmentDatabaseOnly"] = "O";
    DatabaseFilters["EnvironmentDatabaseCanLoadDefinitionAndXml"] = "G";
})(DatabaseFilters || (DatabaseFilters = {}));
var FieldViewModelType;
(function (FieldViewModelType) {
    FieldViewModelType[FieldViewModelType["DataSource"] = 0] = "DataSource";
    FieldViewModelType[FieldViewModelType["DataView"] = 1] = "DataView";
    FieldViewModelType[FieldViewModelType["Logic"] = 2] = "Logic";
})(FieldViewModelType || (FieldViewModelType = {}));
var SourceContextType;
(function (SourceContextType) {
    SourceContextType["CurrentContext"] = "C";
    SourceContextType["MainContext"] = "M";
})(SourceContextType || (SourceContextType = {}));
var ViewRefreshMode;
(function (ViewRefreshMode) {
    ViewRefreshMode[ViewRefreshMode["None"] = 0] = "None";
    ViewRefreshMode[ViewRefreshMode["CurrentLocation"] = 1] = "CurrentLocation";
    ViewRefreshMode[ViewRefreshMode["UseTaskLocate"] = 2] = "UseTaskLocate";
    ViewRefreshMode[ViewRefreshMode["FirstRecord"] = 3] = "FirstRecord";
})(ViewRefreshMode || (ViewRefreshMode = {}));
var LineManipulationType;
(function (LineManipulationType) {
    LineManipulationType[LineManipulationType["None"] = 0] = "None";
    LineManipulationType[LineManipulationType["RepeatEntries"] = 1] = "RepeatEntries";
    LineManipulationType[LineManipulationType["MoveEntries"] = 2] = "MoveEntries";
    LineManipulationType[LineManipulationType["OverwriteCurrent"] = 3] = "OverwriteCurrent";
})(LineManipulationType || (LineManipulationType = {}));
var DataViewOutputType;
(function (DataViewOutputType) {
    DataViewOutputType["Xml"] = "X";
    DataViewOutputType["ClientFile"] = "C";
})(DataViewOutputType || (DataViewOutputType = {}));
var UndoRedoAction;
(function (UndoRedoAction) {
    UndoRedoAction[UndoRedoAction["Undo"] = 0] = "Undo";
    UndoRedoAction[UndoRedoAction["Redo"] = 1] = "Redo";
})(UndoRedoAction || (UndoRedoAction = {}));
var OrientationLock;
(function (OrientationLock) {
    OrientationLock[OrientationLock["No"] = 1] = "No";
    OrientationLock[OrientationLock["Portrait"] = 2] = "Portrait";
    OrientationLock[OrientationLock["Landscape"] = 3] = "Landscape";
})(OrientationLock || (OrientationLock = {}));
var EnterAnimation;
(function (EnterAnimation) {
    EnterAnimation[EnterAnimation["Default"] = 1] = "Default";
    EnterAnimation[EnterAnimation["Left"] = 2] = "Left";
    EnterAnimation[EnterAnimation["Right"] = 3] = "Right";
    EnterAnimation[EnterAnimation["Top"] = 4] = "Top";
    EnterAnimation[EnterAnimation["Bottom"] = 5] = "Bottom";
    EnterAnimation[EnterAnimation["Flip"] = 6] = "Flip";
    EnterAnimation[EnterAnimation["Fade"] = 7] = "Fade";
    EnterAnimation[EnterAnimation["None"] = 8] = "None";
})(EnterAnimation || (EnterAnimation = {}));
var ExitAnimation;
(function (ExitAnimation) {
    ExitAnimation[ExitAnimation["Default"] = 1] = "Default";
    ExitAnimation[ExitAnimation["Left"] = 2] = "Left";
    ExitAnimation[ExitAnimation["Right"] = 3] = "Right";
    ExitAnimation[ExitAnimation["Top"] = 4] = "Top";
    ExitAnimation[ExitAnimation["Bottom"] = 5] = "Bottom";
    ExitAnimation[ExitAnimation["Flip"] = 6] = "Flip";
    ExitAnimation[ExitAnimation["Fade"] = 7] = "Fade";
    ExitAnimation[ExitAnimation["None"] = 8] = "None";
})(ExitAnimation || (ExitAnimation = {}));
var KeyboardTypes;
(function (KeyboardTypes) {
    KeyboardTypes[KeyboardTypes["Default"] = 1] = "Default";
    KeyboardTypes[KeyboardTypes["Numeric"] = 2] = "Numeric";
    KeyboardTypes[KeyboardTypes["URL"] = 3] = "URL";
    KeyboardTypes[KeyboardTypes["NumberPad"] = 4] = "NumberPad";
    KeyboardTypes[KeyboardTypes["PhonePad"] = 5] = "PhonePad";
    KeyboardTypes[KeyboardTypes["NamePhonePad"] = 6] = "NamePhonePad";
    KeyboardTypes[KeyboardTypes["Email"] = 7] = "Email";
})(KeyboardTypes || (KeyboardTypes = {}));
var KeyboardReturnKeys;
(function (KeyboardReturnKeys) {
    KeyboardReturnKeys[KeyboardReturnKeys["Default"] = 1] = "Default";
    KeyboardReturnKeys[KeyboardReturnKeys["Go"] = 2] = "Go";
    KeyboardReturnKeys[KeyboardReturnKeys["Next"] = 3] = "Next";
    KeyboardReturnKeys[KeyboardReturnKeys["Previous"] = 4] = "Previous";
    KeyboardReturnKeys[KeyboardReturnKeys["Search"] = 5] = "Search";
    KeyboardReturnKeys[KeyboardReturnKeys["Done"] = 6] = "Done";
})(KeyboardReturnKeys || (KeyboardReturnKeys = {}));
var OpenEditDialog;
(function (OpenEditDialog) {
    OpenEditDialog[OpenEditDialog["Default"] = 1] = "Default";
    OpenEditDialog[OpenEditDialog["Yes"] = 2] = "Yes";
    OpenEditDialog[OpenEditDialog["No"] = 3] = "No";
})(OpenEditDialog || (OpenEditDialog = {}));
var FrameLayoutTypes;
(function (FrameLayoutTypes) {
    FrameLayoutTypes[FrameLayoutTypes["TwoFramesHorizontal"] = 7901] = "TwoFramesHorizontal";
    FrameLayoutTypes[FrameLayoutTypes["TwoFramesVertical"] = 7902] = "TwoFramesVertical";
    FrameLayoutTypes[FrameLayoutTypes["ThreeFramesBottom"] = 7903] = "ThreeFramesBottom";
    FrameLayoutTypes[FrameLayoutTypes["ThreeFramesRight"] = 7904] = "ThreeFramesRight";
    FrameLayoutTypes[FrameLayoutTypes["ThreeFramesTop"] = 7905] = "ThreeFramesTop";
    FrameLayoutTypes[FrameLayoutTypes["ThreeFramesLeft"] = 7906] = "ThreeFramesLeft";
})(FrameLayoutTypes || (FrameLayoutTypes = {}));
var LineDirection;
(function (LineDirection) {
    LineDirection[LineDirection["Horizontal"] = 0] = "Horizontal";
    LineDirection[LineDirection["Vertical"] = 1] = "Vertical";
    LineDirection[LineDirection["NESW"] = 2] = "NESW";
    LineDirection[LineDirection["NWSE"] = 3] = "NWSE";
})(LineDirection || (LineDirection = {}));
var ScrollBarThumbType;
(function (ScrollBarThumbType) {
    ScrollBarThumbType[ScrollBarThumbType["Incremental"] = 1] = "Incremental";
    ScrollBarThumbType[ScrollBarThumbType["Absolute"] = 2] = "Absolute";
})(ScrollBarThumbType || (ScrollBarThumbType = {}));
var StorageAttribute;
(function (StorageAttribute) {
    StorageAttribute["NONE"] = " ";
    StorageAttribute["ALPHA"] = "A";
    StorageAttribute["NUMERIC"] = "N";
    StorageAttribute["DATE"] = "D";
    StorageAttribute["TIME"] = "T";
    StorageAttribute["BOOLEAN"] = "B";
    StorageAttribute["MEMO"] = "M";
    StorageAttribute["BLOB"] = "O";
    StorageAttribute["BLOB_VECTOR"] = "V";
    StorageAttribute["UNICODE"] = "U";
    StorageAttribute["SKIP"] = "0";
    StorageAttribute["DOTNET"] = "E";
})(StorageAttribute || (StorageAttribute = {}));
var NotifyCollectionChangedAction;
(function (NotifyCollectionChangedAction) {
    NotifyCollectionChangedAction[NotifyCollectionChangedAction["Add"] = 0] = "Add";
    NotifyCollectionChangedAction[NotifyCollectionChangedAction["Remove"] = 1] = "Remove";
    NotifyCollectionChangedAction[NotifyCollectionChangedAction["Replace"] = 2] = "Replace";
    NotifyCollectionChangedAction[NotifyCollectionChangedAction["Move"] = 3] = "Move";
    NotifyCollectionChangedAction[NotifyCollectionChangedAction["Reset"] = 4] = "Reset";
})(NotifyCollectionChangedAction || (NotifyCollectionChangedAction = {}));

class InternalInterface {
    static BuiltinEvent(eventCode) {
        return eventCode >= 1000 || eventCode === InternalInterface.MG_ACT_POST_REFRESH_BY_PARENT;
    }
    constructor() {
    }
}
InternalInterface.MG_ACT_NONE = 0;
InternalInterface.MG_ACT_CHAR = 1;
InternalInterface.MG_ACT_OLE2 = 3;
InternalInterface.MG_ACT_EDT_MARKPRVCH = 4;
InternalInterface.MG_ACT_EDT_MARKNXTCH = 5;
InternalInterface.MG_ACT_EDT_MARKTOBEG = 6;
InternalInterface.MG_ACT_EDT_MARKTOEND = 7;
InternalInterface.MG_ACT_MENU_BAR = 8;
InternalInterface.MG_ACT_EDT_BEGFLD = 9;
InternalInterface.MG_ACT_EDT_ENDFLD = 10;
InternalInterface.MG_ACT_CUT = 11;
InternalInterface.MG_ACT_CLOSE = 13;
InternalInterface.MG_ACT_EXIT = 14;
InternalInterface.MG_ACT_DISPLAY_REFRESH = 15;
InternalInterface.MG_ACT_RESTORE_DEFAULTS = 16;
InternalInterface.MG_ACT_BUTTON = 18;
InternalInterface.MG_ACT_JUMP_TO_ROW = 19;
InternalInterface.MG_ACT_COMMUNICATIONS = 22;
InternalInterface.MG_ACT_OPEN_APPLICATION = 23;
InternalInterface.MG_ACT_ACT_CLOSE_APPL = 24;
InternalInterface.MG_ACT_TOOLKIT_RUNTIME = 25;
InternalInterface.MG_ACT_KEYBOARD_MAPPING = 26;
InternalInterface.MG_ACT_SHELL_TO_OS = 27;
InternalInterface.MG_ACT_EXIT_SYSTEM = 28;
InternalInterface.MG_ACT_RTO_MODIFY = 30;
InternalInterface.MG_ACT_RTO_CREATE = 31;
InternalInterface.MG_ACT_RTO_QUERY = 32;
InternalInterface.MG_ACT_CANCEL = 33;
InternalInterface.MG_ACT_ZOOM = 34;
InternalInterface.MG_ACT_DELLINE = 36;
InternalInterface.MG_ACT_CRELINE = 37;
InternalInterface.MG_ACT_REPEAT_ENTRY = 39;
InternalInterface.MG_ACT_MOVE_ENTRY = 40;
InternalInterface.MG_ACT_OVERWRITE_ENTRY = 41;
InternalInterface.MG_ACT_SELECT = 42;
InternalInterface.MG_ACT_EDT_PRVCHAR = 43;
InternalInterface.MG_ACT_EDT_NXTCHAR = 44;
InternalInterface.MG_ACT_EDT_PRVTAB = 45;
InternalInterface.MG_ACT_EDT_NXTTAB = 46;
InternalInterface.MG_ACT_EDT_PRVWORD = 47;
InternalInterface.MG_ACT_EDT_NXTWORD = 48;
InternalInterface.MG_ACT_EDT_PRVLINE = 49;
InternalInterface.MG_ACT_EDT_NXTLINE = 50;
InternalInterface.MG_ACT_EDT_PRVPAGE = 51;
InternalInterface.MG_ACT_EDT_NXTPAGE = 52;
InternalInterface.MG_ACT_EDT_BEGLINE = 53;
InternalInterface.MG_ACT_EDT_ENDLINE = 54;
InternalInterface.MG_ACT_EDT_BEGPAGE = 55;
InternalInterface.MG_ACT_EDT_ENDPAGE = 56;
InternalInterface.MG_ACT_EDT_BEGFORM = 57;
InternalInterface.MG_ACT_EDT_ENDFORM = 58;
InternalInterface.MG_ACT_EDT_DELCURCH = 59;
InternalInterface.MG_ACT_EDT_DELPRVCH = 60;
InternalInterface.MG_ACT_EDT_BEGNXTLINE = 61;
InternalInterface.MG_ACT_TBL_PRVFLD = 62;
InternalInterface.MG_ACT_TBL_NXTFLD = 63;
InternalInterface.MG_ACT_TBL_PRVLINE = 64;
InternalInterface.MG_ACT_TBL_NXTLINE = 65;
InternalInterface.MG_ACT_TBL_PRVPAGE = 66;
InternalInterface.MG_ACT_TBL_NXTPAGE = 67;
InternalInterface.MG_ACT_TBL_BEGLINE = 68;
InternalInterface.MG_ACT_TBL_ENDLINE = 69;
InternalInterface.MG_ACT_TBL_BEGPAGE = 70;
InternalInterface.MG_ACT_TBL_ENDPAGE = 71;
InternalInterface.MG_ACT_TBL_BEGTBL = 72;
InternalInterface.MG_ACT_TBL_ENDTBL = 73;
InternalInterface.MG_ACT_TAB_NEXT = 75;
InternalInterface.MG_ACT_RT_COPYFLD = 77;
InternalInterface.MG_ACT_ENVIRONMENT = 78;
InternalInterface.MG_ACT_SERVERS = 80;
InternalInterface.MG_ACT_DATABASES = 81;
InternalInterface.MG_ACT_LOGICALPNAMES = 82;
InternalInterface.MG_ACT_PRINTERS = 83;
InternalInterface.MG_ACT_TASK_EVENTS = 85;
InternalInterface.MG_ACT_MENUS = 86;
InternalInterface.MG_ACT_TYPES = 87;
InternalInterface.MG_ACT_TABLES = 88;
InternalInterface.MG_ACT_PROGRAMS = 89;
InternalInterface.MG_ACT_HELP_SCREENS = 90;
InternalInterface.MG_ACT_USER_IDS = 91;
InternalInterface.MG_ACT_EXPORT_IMPORT = 93;
InternalInterface.MG_ACT_MARK_SUBTREE = 95;
InternalInterface.MG_ACT_REPEAT_SUBTREE = 96;
InternalInterface.MG_ACT_MOVE_SUBTREE = 97;
InternalInterface.MG_ACT_OVERWRITE_SUBTREE = 98;
InternalInterface.MG_ACT_CREATE_PARENT = 99;
InternalInterface.MG_ACT_CREATE_SUBTASK = 100;
InternalInterface.MG_ACT_DELETE_SUBTREE = 101;
InternalInterface.MG_ACT_EXPAND_TREE = 103;
InternalInterface.MG_ACT_SHRINK_TREE = 104;
InternalInterface.MG_ACT_AUTHORIZE = 105;
InternalInterface.MG_ACT_PROPERTIES = 106;
InternalInterface.MG_ACT_VIRTUAL_VARIABLES = 107;
InternalInterface.MG_ACT_EXPRESSION_RULES = 108;
InternalInterface.MG_ACT_FORMS = 109;
InternalInterface.MG_ACT_DB_TABLES = 110;
InternalInterface.MG_ACT_I_O_FILES = 111;
InternalInterface.MG_ACT_SORT = 112;
InternalInterface.MG_ACT_EDT_MARKPRVLINE = 113;
InternalInterface.MG_ACT_TASK_CONTROL = 114;
InternalInterface.MG_ACT_CHECK_SYNTAX = 115;
InternalInterface.MG_ACT_EXECUTE_PROGRAM = 116;
InternalInterface.MG_ACT_CROSS_REFERENCE = 117;
InternalInterface.MG_ACT_GENERATE_PROGRAM = 118;
InternalInterface.MG_ACT_GENERATE_FORM = 119;
InternalInterface.MG_ACT_EDIT_MAIN_FORM = 120;
InternalInterface.MG_ACT_MARK_NEXT_LINE = 121;
InternalInterface.MG_ACT_RTO_LOCATE = 122;
InternalInterface.MG_ACT_RTO_RANGE = 123;
InternalInterface.MG_ACT_VIEW_BY_KEY = 124;
InternalInterface.MG_ACT_SORT_RECORDS = 125;
InternalInterface.MG_ACT_REDIRECT_FILES = 126;
InternalInterface.MG_ACT_REPORT_GENERATOR = 127;
InternalInterface.MG_ACT_CLEAR_TEMPLATE = 128;
InternalInterface.MG_ACT_CLEAR_VALUE = 129;
InternalInterface.MG_ACT_DEFINE_EXPRESSION = 130;
InternalInterface.MG_ACT_FROM_VALUE = 131;
InternalInterface.MG_ACT_TO_VALUE = 132;
InternalInterface.MG_ACT_REDRAW_LAYOUT = 134;
InternalInterface.MG_ACT_DEFAULT_LAYOUT = 135;
InternalInterface.MG_ACT_COPY_LAYOUT = 136;
InternalInterface.MG_ACT_SHOW_FULL_LAYOUT = 137;
InternalInterface.MG_ACT_LEFT = 138;
InternalInterface.MG_ACT_RIGHT = 139;
InternalInterface.MG_ACT_TOP = 140;
InternalInterface.MG_ACT_BOTTOM = 141;
InternalInterface.MG_ACT_H_CENTER_OF_FORM = 142;
InternalInterface.MG_ACT_V_CENTER_OF_FORM = 143;
InternalInterface.MG_ACT_HORIZ_CENTER = 144;
InternalInterface.MG_ACT_VERTICAL_CENTER = 145;
InternalInterface.MG_ACT_ATTACH_TO_TABLE = 146;
InternalInterface.MG_ACT_MAXIMUM_WIDTH = 147;
InternalInterface.MG_ACT_EXTERNAL_EDITOR = 148;
InternalInterface.MG_ACT_MAXIMUM_HEIGHT = 153;
InternalInterface.MG_ACT_MINIMUM_WIDTH = 154;
InternalInterface.MG_ACT_USING_HELP = 155;
InternalInterface.MG_ACT_HELP = 156;
InternalInterface.MG_ACT_ABOUT = 157;
InternalInterface.MG_ACT_PRINT_DATA = 160;
InternalInterface.MG_ACT_RIGHTS = 161;
InternalInterface.MG_ACT_PRINTER_SETUP = 162;
InternalInterface.MG_ACT_RTO_SEARCH = 165;
InternalInterface.MG_ACT_SHOW_EXPRESSION = 166;
InternalInterface.MG_ACT_ACTION_LIST = 167;
InternalInterface.MG_ACT_KEYBOARD_LIST = 168;
InternalInterface.MG_ACT_APPLICATIONS = 173;
InternalInterface.MG_ACT_APPL_PROPERTIES = 174;
InternalInterface.MG_ACT_MINIMUM_HEIGHT = 176;
InternalInterface.MG_ACT_EDT_UNDO = 180;
InternalInterface.MG_ACT_RETURN_TO_TREE = 181;
InternalInterface.MG_ACT_GO_TO_TOP = 182;
InternalInterface.MG_ACT_FUNCTION_LIST = 183;
InternalInterface.MG_ACT_LOGON = 185;
InternalInterface.MG_ACT_EXECUTE_REPORT = 188;
InternalInterface.MG_ACT_OK = 189;
InternalInterface.MG_ACT_APPLICATIONS_LIST = 191;
InternalInterface.MG_ACT_SECRET_NAMES = 192;
InternalInterface.MG_ACT_RIGHTS_LIST = 193;
InternalInterface.MG_ACT_CHECK_TO_END = 194;
InternalInterface.MG_ACT_SQL_COMMAND = 195;
InternalInterface.MG_ACT_USER_GROUPS = 196;
InternalInterface.MG_ACT_TABLE_LOCATE = 197;
InternalInterface.MG_ACT_TABLE_LOCATE_NEXT = 198;
InternalInterface.MG_ACT_DBMS = 199;
InternalInterface.MG_ACT_SQL_KEYWORDS = 201;
InternalInterface.MG_ACT_SQL_OPERATORS = 202;
InternalInterface.MG_ACT_SQL_TABLES = 203;
InternalInterface.MG_ACT_SQL_COLUMNS = 204;
InternalInterface.MG_ACT_SQL_FLIP_DESC = 205;
InternalInterface.MG_ACT_SQL_ASSIST = 206;
InternalInterface.MG_ACT_PPD = 207;
InternalInterface.MG_ACT_NULL_SETTINGS = 208;
InternalInterface.MG_ACT_RT_EDT_NULL = 209;
InternalInterface.MG_ACT_PRINT_ATTRIBUTES = 211;
InternalInterface.MG_ACT_NORMAL = 212;
InternalInterface.MG_ACT_INDENT = 215;
InternalInterface.MG_ACT_BULLET = 216;
InternalInterface.MG_ACT_USER_ACTION_1 = 219;
InternalInterface.MG_ACT_USER_ACTION_2 = 220;
InternalInterface.MG_ACT_USER_ACTION_3 = 221;
InternalInterface.MG_ACT_USER_ACTION_4 = 222;
InternalInterface.MG_ACT_USER_ACTION_5 = 223;
InternalInterface.MG_ACT_USER_ACTION_6 = 224;
InternalInterface.MG_ACT_USER_ACTION_7 = 225;
InternalInterface.MG_ACT_USER_ACTION_8 = 226;
InternalInterface.MG_ACT_USER_ACTION_9 = 227;
InternalInterface.MG_ACT_USER_ACTION_10 = 228;
InternalInterface.MG_ACT_USER_ACTION_11 = 229;
InternalInterface.MG_ACT_USER_ACTION_12 = 230;
InternalInterface.MG_ACT_USER_ACTION_13 = 231;
InternalInterface.MG_ACT_USER_ACTION_14 = 232;
InternalInterface.MG_ACT_USER_ACTION_15 = 233;
InternalInterface.MG_ACT_USER_ACTION_16 = 234;
InternalInterface.MG_ACT_USER_ACTION_17 = 235;
InternalInterface.MG_ACT_USER_ACTION_18 = 236;
InternalInterface.MG_ACT_USER_ACTION_19 = 237;
InternalInterface.MG_ACT_USER_ACTION_20 = 238;
InternalInterface.MG_ACT_CLIP_COPY = 239;
InternalInterface.MG_ACT_CLIP_PASTE = 240;
InternalInterface.MG_ACT_CTRL_HIT = 242;
InternalInterface.MG_ACT_PAGE_HEADER = 243;
InternalInterface.MG_ACT_PAGE_FOOTER = 244;
InternalInterface.MG_ACT_HIT = 245;
InternalInterface.MG_ACT_INSERT_OBJECT = 246;
InternalInterface.MG_ACT_PASTE_LINK = 247;
InternalInterface.MG_ACT_CONTROL_NAME_LIST = 248;
InternalInterface.MG_ACT_WINSIZE = 249;
InternalInterface.MG_ACT_WINMOVE = 250;
InternalInterface.MG_ACT_LANGUAGES = 251;
InternalInterface.MG_ACT_DDF_MAKE = 252;
InternalInterface.MG_ACT_UPDATE_LINK = 253;
InternalInterface.MG_ACT_HTML_STYLES = 254;
InternalInterface.MG_ACT_UNINDENT = 255;
InternalInterface.MG_ACT_ALIGN_LEFT = 256;
InternalInterface.MG_ACT_ALIGN_RIGHT = 257;
InternalInterface.MG_ACT_CENTER = 258;
InternalInterface.MG_ACT_ADD_HYPERLINK = 259;
InternalInterface.MG_ACT_DELETE_HYPERLINK = 260;
InternalInterface.MG_ACT_CHECK_OBJECT_LIST = 265;
InternalInterface.MG_ACT_TBL_PLACEMENT = 267;
InternalInterface.MG_ACT_COL_SORT = 268;
InternalInterface.MG_ACT_USERS_LIST = 269;
InternalInterface.MG_ACT_SERVICES = 270;
InternalInterface.MG_ACT_COPY_SUBTREE = 271;
InternalInterface.MG_ACT_PASTE_SUBTREE = 272;
InternalInterface.MG_ACT_VISUAL_CONNECTION = 273;
InternalInterface.MG_ACT_SQL_WHERE_CLAUSE = 274;
InternalInterface.MG_ACT_LOCKING_ABORT = 276;
InternalInterface.MG_ACT_TAB_PREV = 275;
InternalInterface.MG_ACT_LOCKING_RETRY = 277;
InternalInterface.MG_ACT_LOCKING_DETAILS = 278;
InternalInterface.MG_ACT_EDT_MARKALL = 286;
InternalInterface.MG_ACT_MONITOR_DEBUGGER = 287;
InternalInterface.MG_ACT_RT_REFRESH_RECORD = 293;
InternalInterface.MG_ACT_RT_REFRESH_SCREEN = 294;
InternalInterface.MG_ACT_RT_REFRESH_VIEW = 295;
InternalInterface.MG_ACT_COMPONENTS = 297;
InternalInterface.MG_ACT_MODELS = 299;
InternalInterface.MG_ACT_WEB_ON_DBLICK = 301;
InternalInterface.MG_ACT_WEB_CLICK = 302;
InternalInterface.MG_ACT_MM_CTRL_TBL_NXTLINE = 314;
InternalInterface.MG_ACT_MM_CTRL_TBL_PRVLINE = 315;
InternalInterface.MG_ACT_MM_CTRL_TBL_PRVPAGE = 316;
InternalInterface.MG_ACT_MM_CTRL_TBL_NXTPAGE = 317;
InternalInterface.MG_ACT_MM_SHIFT_TBL_NXTLINE = 318;
InternalInterface.MG_ACT_MM_SHIFT_TBL_PRVLINE = 319;
InternalInterface.MG_ACT_MM_SHIFT_TBL_PRVPAGE = 320;
InternalInterface.MG_ACT_MM_SHIFT_TBL_NXTPAGE = 321;
InternalInterface.MG_ACT_BROWSER_ESC = 340;
InternalInterface.MG_ACT_CLOSE_ALL_WIN = 370;
InternalInterface.MG_ACT_EXT_EVENT = 377;
InternalInterface.MG_ACT_TREE_EXPAND = 378;
InternalInterface.MG_ACT_TREE_COLLAPSE = 379;
InternalInterface.MG_ACT_TREE_CRE_SON = 380;
InternalInterface.MG_ACT_TREE_SELCHANGING = 381;
InternalInterface.MG_ACT_TREE_RENAME_RT = 382;
InternalInterface.MG_ACT_TREE_MOVETO_PARENT = 383;
InternalInterface.MG_ACT_TREE_MOVETO_FIRSTCHILD = 384;
InternalInterface.MG_ACT_TREE_MOVETO_PREVSIBLING = 385;
InternalInterface.MG_ACT_TREE_MOVETO_NEXTSIBLING = 386;
InternalInterface.MG_ACT_ROLLBACK = 387;
InternalInterface.MG_ACT_RT_QUIT = 393;
InternalInterface.MG_ACT_TREE_RENAME_RT_EXIT = 413;
InternalInterface.MG_ACT_SERVER_TERMINATION = 420;
InternalInterface.MG_ACT_SUBFORM_REFRESH = 432;
InternalInterface.MG_ACT_CONTEXT_MENU = 439;
InternalInterface.MG_ACT_NEXT_RT_WINDOW = 462;
InternalInterface.MG_ACT_PREV_RT_WINDOW = 463;
InternalInterface.MG_ACT_EMPTY_DATAVIEW = 521;
InternalInterface.MG_ACT_BROWSER_STS_TEXT_CHANGE = 529;
InternalInterface.MG_ACT_TBL_REORDER = 539;
InternalInterface.MG_ACT_CTRL_MODIFY = 544;
InternalInterface.MG_ACT_SUBFORM_OPEN = 545;
InternalInterface.MG_ACT_COL_CLICK = 555;
InternalInterface.MG_ACT_POST_REFRESH_BY_PARENT = 559;
InternalInterface.MG_ACT_COMBO_DROP_DOWN = 560;
InternalInterface.MG_ACT_RAISE_BUTTON_EVENT = 561;
InternalInterface.MG_ACT_UPDATE_DN_CONTROL_VALUE = 562;
InternalInterface.MG_ACT_GET_DATAVIEW_CONTENT = 563;
InternalInterface.MG_ACT_PRESS = 564;
InternalInterface.MG_ACT_MULTI_MARK_HIT = 565;
InternalInterface.MG_ACT_DVCONTROL_ROW_CHANGE = 566;
InternalInterface.MG_ACT_DVCONTROL_UPDATE_COLUMN_VALUE = 567;
InternalInterface.MG_ACT_SWITCH_TO_OFFLINE = 568;
InternalInterface.MG_ACT_UNAVAILABLE_SERVER = 569;
InternalInterface.MG_ACT_UPDATE_DATAVIEW_TO_DATASOURCE = 571;
InternalInterface.MG_ACT_ENABLE_EVENTS = 573;
InternalInterface.MG_ACT_WRITE_ERROR_TO_SERVER_LOG = 574;
InternalInterface.MG_ACT_OPEN_FORM_DESIGNER = 578;
InternalInterface.MG_ACT_FETCH_DATA_CONTROL_VALUES = 579;
InternalInterface.MG_ACT_COL_FILTER = 580;
InternalInterface.MG_ACT_INDEX_CHANGE = 585;
InternalInterface.MG_ACT_WEBCLIENT_ROUTE = 594;
InternalInterface.MG_ACT_ENTER_ROW_EDITING = 595;
InternalInterface.MG_ACT_SUBFORM_CLOSE = 597;
InternalInterface.MG_ACT_NO_PROG_EXE_RIGHTS = 619;
InternalInterface.MG_ACT_CRELINE_ABOVE = 634;
InternalInterface.MG_ACT_CONTEXT_TERMINATION = 635;
InternalInterface.MG_ACT_CONTEXT_TIMEOUT_RESET = 636;
InternalInterface.MG_ACT_CONTEXT_REMOVE = 647;
InternalInterface.MG_ACT_DUMP_ENVIRONMENT = 653;
InternalInterface.MG_ACT_TOT_CNT = 654;
InternalInterface.MG_ACT_TASK_PREFIX = 1001;
InternalInterface.MG_ACT_TASK_SUFFIX = 1002;
InternalInterface.MG_ACT_REC_PREFIX = 1003;
InternalInterface.MG_ACT_REC_SUFFIX = 1004;
InternalInterface.MG_ACT_CTRL_PREFIX = 1005;
InternalInterface.MG_ACT_CTRL_SUFFIX = 1006;
InternalInterface.MG_ACT_CTRL_VERIFICATION = 1007;
InternalInterface.MG_ACT_VARIABLE = 1008;
InternalInterface.MG_ACT_DATAVIEW_TOP = 1013;
InternalInterface.MG_ACT_DATAVIEW_BOTTOM = 1014;
InternalInterface.MG_ACT_CACHE_PREV = 1015;
InternalInterface.MG_ACT_CACHE_NEXT = 1016;
InternalInterface.MG_ACT_CYCLE_NEXT_REC = 1017;
InternalInterface.MG_ACT_CYCLE_NEXT_DELETE_REC = 1018;
InternalInterface.MG_ACT_COMPUTE = 1020;
InternalInterface.MG_ACT_DUMMY = 1111;
InternalInterface.MG_ACT_CTRL_FOCUS = 2001;
InternalInterface.MG_ACT_CTRL_MOUSEUP = 2002;
InternalInterface.MG_ACT_CTRL_KEYDOWN = 2003;
InternalInterface.MG_ACT_TIMER = 2004;
InternalInterface.MG_ACT_SELECTION = 2005;
InternalInterface.MG_ACT_RESIZE = 2006;
InternalInterface.MG_ACT_ROW_DATA_CURR_PAGE = 2007;
InternalInterface.MG_ACT_DV_TO_GUI = 2008;
InternalInterface.MG_ACT_DISABLE_EVENTS = 2010;
InternalInterface.MG_ACT_TOGGLE_INSERT = 2011;
InternalInterface.MG_ACT_INCREMENTAL_LOCATE = 2017;
InternalInterface.MG_ACT_MOVE_TO_FIRST_CTRL = 2018;
InternalInterface.MG_ACT_SET_EXTERNAL_VALUE = 2019;
InternalInterface.MG_ACT_CTRL_FOCUS_ON_NON_MAGIC_CONTROL = 2020;
InternalInterface.MG_ACT_FETCH_RECORDS_AHEAD_FROM_SERVER = 2021;

class JSON_Utils {
    static JSONFromXML(xml, onComplete) {
        parseString(xml, onComplete);
    }
}

class OSEnvironment {
    static getStackTrace() {
        let ex = new Exception();
        ex.errorLevel++;
        return ex.StackTrace;
    }
}
OSEnvironment.EolSeq = "\n";
OSEnvironment.TabSeq = "\t";

class RequestInfo {
    constructor() {
        this.runtimeTaskTree = new List();
        this.roundtripTime = null;
        this.extraInfo = { contentLength: 0, contextID: null, sessionCounter: 0, timeStamp: null };
    }
    static clone(requestInfo) {
        let requestInfoClone = new RequestInfo();
        if (requestInfo) {
            requestInfoClone.serverCallAt = requestInfo.serverCallAt;
            requestInfoClone.runtimeTaskTree = requestInfo.runtimeTaskTree;
            requestInfoClone.roundtripTime = requestInfo.roundtripTime;
            requestInfoClone.extraInfo = { contentLength: requestInfo.extraInfo.contentLength, contextID: requestInfo.extraInfo.contextID,
                sessionCounter: requestInfo.extraInfo.sessionCounter, timeStamp: requestInfo.extraInfo.timeStamp };
        }
        return requestInfoClone;
    }
    clear() {
        this.roundtripTime = null;
        this.serverCallAt = null;
        this.extraInfo = { contentLength: 0, contextID: null, sessionCounter: 0, timeStamp: null };
        this.runtimeTaskTree = null;
    }
}

var LogType;
(function (LogType) {
    LogType[LogType["info"] = 1] = "info";
    LogType[LogType["warning"] = 2] = "warning";
    LogType[LogType["error"] = 3] = "error";
})(LogType || (LogType = {}));
class Logger {
    static set Instance(value) {
        Logger.instance = value;
    }
    static get Instance() {
        if (Logger.instance === null) {
            Logger.instance = new Logger();
        }
        return Logger.instance;
    }
    Initialize(logLevel, shouldBeep) {
        try {
            this.LogLevel = logLevel;
            this.ShouldBeep = shouldBeep;
        }
        catch (e) {
            this.WriteDevToLog("ClientManager.init(): " + e.Message);
        }
    }
    ShouldLog(logLevel) {
        if (arguments.length === 1)
            return this.ShouldLog_0(logLevel);
        else
            return this.ShouldLog_1();
    }
    ShouldLog_0(logLevel) {
        return this.LogLevel === logLevel;
    }
    ShouldLog_1() {
        return this.LogLevel > Logger_LogLevels.None;
    }
    ShouldLogServerRelatedMessages() {
        return (this.ShouldLogExtendedServerRelatedMessages() || Logger.Instance.ShouldLog(Logger_LogLevels.Server)) && this.LogLevel !== Logger_LogLevels.Basic;
    }
    ShouldLogExtendedServerRelatedMessages() {
        return (Logger.Instance.ShouldLog(Logger_LogLevels.ServerMessages) || Logger.Instance.ShouldLog(Logger_LogLevels.Support) || Logger.Instance.ShouldLog(Logger_LogLevels.Development)) && this.LogLevel !== Logger_LogLevels.Basic;
    }
    WriteToLog(msg, openIfNecessary, logType = LogType.info) {
        if (this.LogLevel > Logger_LogLevels.None || openIfNecessary) {
            msg = NString.Format("{0} {1}", (this.LogLevel === Logger_LogLevels.Basic) ? new Date().toISOString() : DateTimeUtils.ToString(DateTime.Now, XMLConstants.ERROR_LOG_TIME_FORMAT, this), msg);
            switch (logType) {
                case LogType.error:
                    console.error(msg);
                    break;
                case LogType.warning:
                    console.warn(msg);
                    break;
                default:
                    console.log(msg);
            }
        }
    }
    WriteServerToLog(msg) {
        if (this.ShouldLogServerRelatedMessages()) {
            this.WriteToLog(NString.Format("Server, Thread={0}: ", Thread.CurrentThread.ManagedThreadId) + msg, false, LogType.info);
        }
    }
    WriteServerMessagesToLog(msg) {
        if (this.ShouldLogExtendedServerRelatedMessages()) {
            this.WriteToLog("Server#: " + msg, false, LogType.info);
        }
    }
    WriteSupportToLog(msg, skipLine) {
        if (this.LogLevel >= Logger_LogLevels.Support && this.LogLevel !== Logger_LogLevels.Basic) {
            if (skipLine) {
                this.WriteToLog("SUPPORT: " + msg, false, LogType.info);
            }
            else {
                this.WriteToLog("SUPPORT: " + msg + OSEnvironment.EolSeq + "-----------------------------------------------------------------------------------------------------------", false, LogType.info);
            }
        }
    }
    WriteGuiToLog(msg) {
        if (this.LogLevel >= Logger_LogLevels.Gui && this.LogLevel !== Logger_LogLevels.Basic) {
            this.WriteToLog(msg, false, LogType.info);
        }
    }
    WriteDevToLog(msg) {
        if (this.LogLevel >= Logger_LogLevels.Development && this.LogLevel !== Logger_LogLevels.Basic) {
            this.WriteToLog("DEV: " + msg, false, LogType.info);
        }
    }
    WriteBasicToLog(messageDirection, contextID, sessionCounter, clientID, serverID, responseTime, statusCode, httpHeaders, contentLength) {
        if (this.LogLevel === Logger_LogLevels.Basic) {
            let text = httpHeaders;
            text = text.trim();
            text = NString.Replace(text, "\r\n", "|");
            let arg_E4_0 = "RIA,{0}_{1},{2},{3},{4},{5},-,{6},{7},{8},{9},{10},{11}";
            let expr_3E = new Array(12);
            expr_3E[1] = Thread.CurrentThread.ManagedThreadId;
            expr_3E[2] = new Date().toISOString();
            expr_3E[3] = ((messageDirection === Logger_MessageDirection.MessageLeaving) ? "MSGL" : "MSGE");
            expr_3E[4] = contextID;
            expr_3E[5] = sessionCounter;
            expr_3E[6] = clientID;
            expr_3E[7] = serverID;
            expr_3E[8] = ((responseTime !== 0) ? responseTime.toString() : "-");
            let arg_D3_1 = 9;
            let arg_D3_2;
            arg_D3_2 = statusCode;
            expr_3E[arg_D3_1] = arg_D3_2;
            expr_3E[10] = text;
            expr_3E[11] = contentLength;
            let value = NString.Format(arg_E4_0, expr_3E);
            console.log(value);
        }
    }
    WriteRequestInfoToLog(requestInfo, extraMessageStr) {
        if (this.LogLevel === Logger_LogLevels.RequestInfo) {
            console.log(extraMessageStr, RequestInfo.clone(requestInfo));
        }
    }
    WriteBasicErrorToLog() {
        Debug.Assert(this.LogLevel === Logger_LogLevels.Basic);
    }
    WriteErrorToLog(msg) {
        this.WriteToLog("MagicWeb [ERROR]: " + StrUtil.getConsoleErorString(msg), true, LogType.error);
    }
    WriteExceptionToLog(msgOrEx, msg) {
        if (msgOrEx instanceof Error) {
            this.WriteExceptionToLog_2(msgOrEx, msg);
            return;
        }
        if (arguments.length === 1 && (msgOrEx !== null || msgOrEx instanceof Exception)) {
            this.WriteExceptionToLog_1(msgOrEx);
            return;
        }
        this.WriteExceptionToLog_3(msgOrEx, msg);
    }
    WriteExceptionToLogWithMsg(msg) {
        this.WriteToLog("MagicWeb [ERROR]: " + StrUtil.getConsoleErorString(msg), true, LogType.error);
    }
    WriteExceptionToLog_1(ex) {
        this.WriteExceptionToLogWithMsg(NString.Format("{0} : {1}{2}{3}{4}", [
            ex.GetType(), OSEnvironment.EolSeq, ex.StackTrace, OSEnvironment.EolSeq, ex.Message
        ]));
    }
    WriteExceptionToLog_2(ex, message) {
        if (isNullOrUndefined(message))
            this.WriteExceptionToLogWithMsg(NString.Format("{0}{1}{2}", [ex.stack, OSEnvironment.EolSeq, ex.message]));
        else
            this.WriteExceptionToLogWithMsg(NString.Format("{0}{1}{2}{4}{5}", [message, OSEnvironment.EolSeq, ex.stack, OSEnvironment.EolSeq, ex.message]));
    }
    WriteExceptionToLog_3(ex, msg) {
        this.WriteExceptionToLogWithMsg(NString.Format("{0}, {1} : {2}{3}{4}{5}", [
            ex.GetType(), msg, OSEnvironment.EolSeq, ex.StackTrace, OSEnvironment.EolSeq, ex.Message
        ]));
    }
    WriteWarningToLog(msgOrEx, msg) {
        if (arguments.length === 1 && msgOrEx !== null) {
            if (msgOrEx instanceof Exception)
                this.WriteWarningToLog_1(msgOrEx);
            else if (msgOrEx instanceof Error)
                this.WriteWarningToLog_2(msgOrEx);
        }
        else
            this.WriteWarningToLog_3(msgOrEx, msg);
    }
    WriteWarningToLogWithMsg(msg) {
        if (this.LogLevel !== Logger_LogLevels.Basic) {
            this.WriteToLog("MagicWeb [WARNING]: " + msg, true, LogType.warning);
        }
    }
    WriteWarningToLog_1(ex) {
        this.WriteWarningToLogWithMsg(ex.GetType() + " : " + OSEnvironment.EolSeq + ex.StackTrace + OSEnvironment.EolSeq + ex.Message);
    }
    WriteWarningToLog_2(ex) {
        this.WriteWarningToLogWithMsg(NString.Format("{0}{1}{2}", [
            ex.stack, OSEnvironment.EolSeq, ex.message
        ]));
    }
    WriteWarningToLog_3(ex, msg) {
        this.WriteWarningToLogWithMsg(NString.Format("{0}, {1} : {2}{3}{4}{5}", [
            ex.GetType(), msg, OSEnvironment.EolSeq, ex.StackTrace, OSEnvironment.EolSeq, ex.Message
        ]));
    }
    WriteStackTrace(stackTrace, framesToPrint, traceTitle) {
        if (traceTitle === null) {
            traceTitle = "Stack trace:";
        }
        let stringBuilder = new StringBuilder(traceTitle + OSEnvironment.EolSeq);
        let frames = stackTrace.GetFrames();
        let array = frames;
        for (let i = 0; i < array.length; i = i + 1) {
            let stackFrame = array[i];
            framesToPrint = framesToPrint - 1;
            stringBuilder.Append(stackFrame.toString());
            if (framesToPrint === 0) {
                stringBuilder.Append("\t... more stack frames ...\n");
                break;
            }
        }
        this.WriteToLog(stringBuilder.ToString(), true);
    }
    Flush() {
    }
    constructor() {
        this.LogLevel = 0;
        this.ShouldBeep = false;
    }
}
Logger.instance = null;

var MagicProperties;
(function (MagicProperties) {
    MagicProperties["LineDivider"] = "line_divider";
    MagicProperties["ImageFile"] = "image_file";
    MagicProperties["Wallpaper"] = "wallpaper";
})(MagicProperties || (MagicProperties = {}));
var BindingLevel;
(function (BindingLevel) {
    BindingLevel[BindingLevel["Control"] = 1] = "Control";
    BindingLevel[BindingLevel["Character"] = 2] = "Character";
})(BindingLevel || (BindingLevel = {}));

class DefaultMsgDetails {
    constructor(ID, MsgStr) {
        this.MsgID = null;
        this.MsgString = null;
        this.MsgID = ID;
        this.MsgString = MsgStr;
    }
}
class MsgInterface {
    constructor() {
    }
}
MsgInterface.STR_ERR_NUM = "STR_ERR_NUM";
MsgInterface.STR_ERR_DATE = "STR_ERR_DATE";
MsgInterface.STR_ERR_TIME = "STR_ERR_TIME";
MsgInterface.MONTHS_PTR = "MONTHS_PTR";
MsgInterface.DAYS_PTR = "DAYS_PTR";
MsgInterface.STR_ERR_NEGETIVE = "STR_ERR_NEGETIVE";
MsgInterface.STR_RNG_TXT = "STR_RNG_TXT";
MsgInterface.EDT_ERR_STR_1 = "EDT_ERR_STR_1";
MsgInterface.STR_ERR_PIPE_CONNECTION = "STR_ERR_PIPE_CONNECTION";
MsgInterface.FMERROR_STR_BAD_NAME = "FMERROR_STR_BAD_NAME";
MsgInterface.FMERROR_STR_BAD_DAMAGED = "FMERROR_STR_BAD_DAMAGED";
MsgInterface.FMERROR_STR_BAD_BADCREATE = "FMERROR_STR_BAD_BADCREATE";
MsgInterface.FMERROR_STR_FILE_LOCKED = "FMERROR_STR_FILE_LOCKED";
MsgInterface.FMERROR_STR_BAD_UNEXPECTED = "FMERROR_STR_BAD_UNEXPECTED";
MsgInterface.FMERROR_STR_BAD_SERVER_NOTFOUND = "FMERROR_STR_BAD_SERVER_NOTFOUND";
MsgInterface.FMERROR_STR_BAD_SERVER_INIT_FAILED = "FMERROR_STR_BAD_SERVER_INIT_FAILED";
MsgInterface.FMERROR_STR_UNLOCKED = "FMERROR_STR_UNLOCKED";
MsgInterface.FMERROR_STR_BAD_DB_INIT_FAILED = "FMERROR_STR_BAD_DB_INIT_FAILED";
MsgInterface.FMERROR_STR_BAD_LOCK_OPEN = "FMERROR_STR_BAD_LOCK_OPEN";
MsgInterface.FMERROR_STR_BAD_BADOPEN = "FMERROR_STR_BAD_BADOPEN";
MsgInterface.FMERROR_STR_BAD_BADDEF = "FMERROR_STR_BAD_BADDEF";
MsgInterface.FMERROR_STR_DUP_KEY = "FMERROR_STR_DUP_KEY";
MsgInterface.FMERROR_STR_COMM_LOADED = "FMERROR_STR_COMM_LOADED";
MsgInterface.FMERROR_STR_COMM_CONNECT = "FMERROR_STR_COMM_CONNECT";
MsgInterface.FMERROR_STR_READONLY = "FMERROR_STR_READONLY";
MsgInterface.FMERROR_STR_BAD_BADCLOSE = "FMERROR_STR_BAD_BADCLOSE";
MsgInterface.FMERROR_STR_REC_LOCKED = "FMERROR_STR_REC_LOCKED";
MsgInterface.FMERROR_STR_TRANS_OPEN = "FMERROR_STR_TRANS_OPEN";
MsgInterface.FMERROR_STR_COMMIT = "FMERROR_STR_COMMIT";
MsgInterface.FMERROR_STR_ABORT = "FMERROR_STR_ABORT";
MsgInterface.FMERROR_STR_RSRC_LOCKED = "FMERROR_STR_RSRC_LOCKED";
MsgInterface.FMERROR_STR_NODEF = "FMERROR_STR_NODEF";
MsgInterface.FMERROR_STR_DEADLOCK = "FMERROR_STR_DEADLOCK";
MsgInterface.FMERROR_STR_DB_PROT = "FMERROR_STR_DB_PROT";
MsgInterface.FMERROR_STR_OWNR_ALRDY_SET = "FMERROR_STR_OWNR_ALRDY_SET";
MsgInterface.FMERROR_STR_INVALID_OWNR = "FMERROR_STR_INVALID_OWNR";
MsgInterface.FMERROR_STR_CLR_OWNR_FAIL = "FMERROR_STR_CLR_OWNR_FAIL";
MsgInterface.FMERROR_STR_NO_DATABASE = "FMERROR_STR_NO_DATABASE";
MsgInterface.FMERROR_STR_DBMS_ALTER_FAIL = "FMERROR_STR_DBMS_ALTER_FAIL";
MsgInterface.FMERROR_STR_TRANS_LOCK = "FMERROR_STR_TRANS_LOCK";
MsgInterface.FMERROR_STR_EXTUSE_MULU_CNFLCT = "FMERROR_STR_EXTUSE_MULU_CNFLCT";
MsgInterface.FMERROR_STR_DB_GW_VERSION_CNFLCT = "FMERROR_STR_DB_GW_VERSION_CNFLCT";
MsgInterface.FMERROR_STR_DB_CANOT_REMOVE = "FMERROR_STR_DB_CANOT_REMOVE";
MsgInterface.FMERROR_STR_DB_CANOT_RENAME = "FMERROR_STR_DB_CANOT_RENAME";
MsgInterface.FMERROR_STR_DB_BAD_SQL_CMD = "FMERROR_STR_DB_BAD_SQL_CMD";
MsgInterface.FMERROR_STR_REC_LOCKED_NOBUF = "FMERROR_STR_REC_LOCKED_NOBUF";
MsgInterface.FMERROR_STR_REOPEN = "FMERROR_STR_REOPEN";
MsgInterface.FMERROR_STR_REC_LOCKED_NOW = "FMERROR_STR_REC_LOCKED_NOW";
MsgInterface.FMERROR_STR_DBMS_SORT_FAIL = "FMERROR_STR_DBMS_SORT_FAIL";
MsgInterface.FMERROR_STR_NO_OLD_DATABASE_DBMS = "FMERROR_STR_NO_OLD_DATABASE_DBMS";
MsgInterface.FMERROR_STR_BAD_LOGIN = "FMERROR_STR_BAD_LOGIN";
MsgInterface.FMERROR_STR_ERR_EXEC_SQL = "FMERROR_STR_ERR_EXEC_SQL";
MsgInterface.FMERROR_STR_ERR_UPDATE_FAIL = "FMERROR_STR_ERR_UPDATE_FAIL";
MsgInterface.FMERROR_STR_ERR_INSERT_FAIL = "FMERROR_STR_ERR_INSERT_FAIL";
MsgInterface.FMERROR_STR_ERR_DELETE_FAIL = "FMERROR_STR_ERR_DELETE_FAIL";
MsgInterface.FMERROR_STR_PRINTER = "FMERROR_STR_PRINTER";
MsgInterface.FMERROR_STR_FIL_NOT_EXIST = "FMERROR_STR_FIL_NOT_EXIST";
MsgInterface.FMERROR_STR_COMM_GWY_COMPTABILITY = "FMERROR_STR_COMM_GWY_COMPTABILITY";
MsgInterface.FMERROR_STR_CACHE_TOO_BIG = "FMERROR_STR_CACHE_TOO_BIG";
MsgInterface.FMERROR_STR_NO_ROWS_AFFECTED = "FMERROR_STR_NO_ROWS_AFFECTED";
MsgInterface.FMERROR_STR_TARGET_FILE_EXIST = "FMERROR_STR_TARGET_FILE_EXIST";
MsgInterface.FMERROR_STR_FILE_IS_VIEW = "FMERROR_STR_FILE_IS_VIEW";
MsgInterface.FMERROR_STR_DB_CANOT_COPY = "FMERROR_STR_DB_CANOT_COPY";
MsgInterface.FMERROR_STR_HLP_NOT_EXIST = "FMERROR_STR_HLP_NOT_EXIST";
MsgInterface.FMERROR_STR_UNUSABLE_FILE = "FMERROR_STR_UNUSABLE_FILE";
MsgInterface.FMERROR_STR_DB_BAD_QUERY = "FMERROR_STR_DB_BAD_QUERY";
MsgInterface.FMERROR_STR_NO_HDLS = "FMERROR_STR_NO_HDLS";
MsgInterface.FMERROR_STR_MAX_CONNS_REACHED = "FMERROR_STR_MAX_CONNS_REACHED";
MsgInterface.FMERROR_STR_CONSTRAINT_FAIL = "FMERROR_STR_CONSTRAINT_FAIL";
MsgInterface.FMERROR_STR_TRIGGER_FAIL = "FMERROR_STR_TRIGGER_FAIL";
MsgInterface.FMERROR_STR_MODIFY_WITHIN_TRANS = "FMERROR_STR_MODIFY_WITHIN_TRANS";
MsgInterface.EXPTAB_TSK_MODE_RT = "EXPTAB_TSK_MODE_RT";
MsgInterface.EXPTAB_ERR_CALL_MAIN_PRG_1 = "EXPTAB_ERR_CALL_MAIN_PRG_1";
MsgInterface.LOCATE_STR_ERR_EOF = "LOCATE_STR_ERR_EOF";
MsgInterface.RT_STR_REC_NOTFOUND = "RT_STR_REC_NOTFOUND";
MsgInterface.RT_STR_PRG_NOTFOUND = "RT_STR_PRG_NOTFOUND";
MsgInterface.RT_STR_NO_RECS_IN_RNG = "RT_STR_NO_RECS_IN_RNG";
MsgInterface.RT_STR_FLD_MUST_UPDATED = "RT_STR_FLD_MUST_UPDATED";
MsgInterface.RT_STR_TSK_NO_SCREEN = "RT_STR_TSK_NO_SCREEN";
MsgInterface.RT_STR_CRSR_CANT_PARK = "RT_STR_CRSR_CANT_PARK";
MsgInterface.RT_STR_MODE_NOTALLOWED = "RT_STR_MODE_NOTALLOWED";
MsgInterface.RT_STR_NON_MODIFIABLE = "RT_STR_NON_MODIFIABLE";
MsgInterface.RT_STR_UPDATE_IN_QUERY = "RT_STR_UPDATE_IN_QUERY";
MsgInterface.RT_STR_LOAD_RES_FAIL = "RT_STR_LOAD_RES_FAIL";
MsgInterface.RT_STR_NO_CREATE_ON_TREE = "RT_STR_NO_CREATE_ON_TREE";
MsgInterface.TSKR_ERR_NOTEXIST_COMP = "TSKR_ERR_NOTEXIST_COMP";
MsgInterface.TSK_ERR_BCSUBFORM_WRONG_EXP = "TSK_ERR_BCSUBFORM_WRONG_EXP";
MsgInterface.TSK_ERR_NESTED_BCSUBFORM = "TSK_ERR_NESTED_BCSUBFORM";
MsgInterface.TSK_ERR_CHANGE_CACHED_NESTED_BCSUBFORM = "TSK_ERR_CHANGE_CACHED_NESTED_BCSUBFORM";
MsgInterface.TSK_ERR_SUBFORM_DSQL = "TSK_ERR_SUBFORM_DSQL";
MsgInterface.TSK_ERR_DSQL_SELECT_ONLY = "TSK_ERR_DSQL_SELECT_ONLY";
MsgInterface.CSTIO_STR_ERR2 = "CSTIO_STR_ERR2";
MsgInterface.CONFIRM_STR_DELETE = "CONFIRM_STR_DELETE";
MsgInterface.CONFIRM_STR_CANCEL = "CONFIRM_STR_CANCEL";
MsgInterface.CONFIRM_STR_WINDOW_TITLE = "CONFIRM_STR_WINDOW_TITLE";
MsgInterface.WARNING_STR_WINDOW_TITLE = "WARNING_STR_WINDOW_TITLE";
MsgInterface.BRKTAB_STR_ERROR = "BRKTAB_STR_ERROR";
MsgInterface.USRINP_STR_BADPASSW = "USRINP_STR_BADPASSW";
MsgInterface.USRINP_STR_BADPASSW_WEBSERVER = "USRINP_STR_BADPASSW_WEBSERVER";
MsgInterface.USRINP_STR_BADPASSW_PROXYSERVER = "USRINP_STR_BADPASSW_PROXYSERVER";
MsgInterface.CRF_STR_CONF_UPD = "CRF_STR_CONF_UPD";
MsgInterface.MENU_STR_ERROR_ENABLE = "MENU_STR_ERROR_ENABLE";
MsgInterface.GUI_OK_BUTTON = "GUI_OK_BUTTON";
MsgInterface.GUI_CANCEL_BUTTON = "GUI_CANCEL_BUTTON";
MsgInterface.BRKTAB_STOP_MODE_TITLE = "BRKTAB_STOP_MODE_TITLE";
MsgInterface.BRKTAB_STR_ERR_FORM = "BRKTAB_STR_ERR_FORM";
MsgInterface.BROWSER_OPT_INFO_SERVER_STR = "BROWSER_OPT_INFO_SERVER_STR";
MsgInterface.STR_ERR_PIC_J = "STR_ERR_PIC_J";
MsgInterface.STR_ERR_PIC_S = "STR_ERR_PIC_S";
MsgInterface.STR_ERR_PIC_T = "STR_ERR_PIC_T";
MsgInterface.TASKRULE_STR_APPLICATION = "TASKRULE_STR_APPLICATION";
MsgInterface.DITDEF_STR_ERR_WINDOW_TYPE = "DITDEF_STR_ERR_WINDOW_TYPE";
MsgInterface.DITDEF_STR_ERR_SUBFORM_PROG_PARALLEL = "DITDEF_STR_ERR_SUBFORM_PROG_PARALLEL";
MsgInterface.DATEHEB_MONTH_STR = "DATEHEB_MONTH_STR";
MsgInterface.DATEHEB_DOW_STR = "DATEHEB_DOW_STR";
MsgInterface.CHK_ERR_CALL_FROM_RICH_CLIENT = "CHK_ERR_CALL_FROM_RICH_CLIENT";
MsgInterface.RC_STR_F7_UNEXPECTED_ERR = "RC_STR_F7_UNEXPECTED_ERR";
MsgInterface.STR_ERR_MAX_VAR_SIZE = "STR_ERR_MAX_VAR_SIZE";
MsgInterface.STR_RC_RECENT_ACTIVITY_TOOLTIP_HDR = "STR_RC_RECENT_ACTIVITY_TOOLTIP_HDR";
MsgInterface.STR_RC_RECENT_ACTIVITY_TIME_LBL = "STR_RC_RECENT_ACTIVITY_TIME_LBL";
MsgInterface.STR_RC_RECENT_ACTIVITY_DATA_UNIT = "STR_RC_RECENT_ACTIVITY_DATA_UNIT";
MsgInterface.STR_RC_RECENT_ACTIVITY_TIME_UNIT = "STR_RC_RECENT_ACTIVITY_TIME_UNIT";
MsgInterface.STR_PAGE_LOADING_IN_PROGRESS = "STR_PAGE_LOADING_IN_PROGRESS";
MsgInterface.STR_CANNOT_PARK = "STR_CANNOT_PARK";
MsgInterface.STR_RESTART_SESSION = "STR_RESTART_SESSION";
MsgInterface.STR_ERR_INACCESSIBLE_URL = "STR_ERR_INACCESSIBLE_URL";
MsgInterface.STR_ERR_SESSION_CLOSED = "STR_ERR_SESSION_CLOSED";
MsgInterface.STR_ERR_SESSION_CLOSED_INACTIVITY = "STR_ERR_SESSION_CLOSED_INACTIVITY";
MsgInterface.STR_MINUTES = "STR_MINUTES";
MsgInterface.STR_HOURS = "STR_HOURS";
MsgInterface.STR_ERR_AUTHORIZATION_FAILURE = "STR_ERR_AUTHORIZATION_FAILURE";
MsgInterface.STR_WARN_UNLOAD_TIMEOUT = "STR_WARN_UNLOAD_TIMEOUT";
MsgInterface.STR_WARN_PARALLEL_NOT_SUPPORTED = "STR_WARN_PARALLEL_NOT_SUPPORTED";
MsgInterface.DN_ERR_MDI_FRAME_ISNOT_OPENED = "DN_ERR_MDI_FRAME_ISNOT_OPENED";
MsgInterface.ERR_CANNOT_HANDLE_WEB_REQUEST = "ERR_CANNOT_HANDLE_WEB_REQUEST";
MsgInterface.STR_MDI_FRAME_MISMATCH = "STR_MDI_FRAME_MISMATCH";
MsgInterface.CHK_ERR_OFFLINE_NOT_SUPPORT_FRAME_INTERFACE = "CHK_ERR_OFFLINE_NOT_SUPPORT_FRAME_INTERFACE";
MsgInterface.STR_USER_ID = "STR_USER_ID";
MsgInterface.STR_PASSWORD = "STR_PASSWORD";
MsgInterface.STR_LOGON_PARAMETERS = "STR_LOGON_PARAMETERS";
MsgInterface.STR_LOGON_CAPTION = "STR_LOGON_CAPTION";
MsgInterface.STR_LOGON_INSTRUCTION = "STR_LOGON_INSTRUCTION";
MsgInterface.STR_GENERIC_ERROR_MESSAGE = "STR_GENERIC_ERROR_MESSAGE";
MsgInterface.STR_GENERIC_ERROR_CONNECTION_PROBLEM_TITLE = "STR_GENERIC_ERROR_CONNECTION_PROBLEM_TITLE";
MsgInterface.STR_GENERIC_ERROR_CONNECTION_PROBLEM_MESSAGE = "STR_GENERIC_ERROR_CONNECTION_PROBLEM_MESSAGE";
MsgInterface.FMERROR_STR_TRANS_OPEN_FAILED = "FMERROR_STR_TRANS_OPEN_FAILED";
MsgInterface.STR_ERR_CANNOT_CALL_OFFLINE_BYNAME_OR_BYEXP = "STR_ERR_CANNOT_CALL_OFFLINE_BYNAME_OR_BYEXP";
MsgInterface.RT_STR_DELETE_MODE_WITHOUT_MAINSOURCE_NOTALLOWED = "RT_STR_DELETE_MODE_WITHOUT_MAINSOURCE_NOTALLOWED";
MsgInterface.RC_ERROR_INCOMPATIBLE_DATASOURCES = "RC_ERROR_INCOMPATIBLE_DATASOURCES";
MsgInterface.RC_ERROR_INVALID_SOURCES = "RC_ERROR_INVALID_SOURCES";
MsgInterface.RC_ERROR_OFFLINE_NEXT_EXECUTION_INVALID_SOURCES = "RC_ERROR_OFFLINE_NEXT_EXECUTION_INVALID_SOURCES";
MsgInterface.RC_ERR_ANDROID_LOAD_FROM_URL = "RC_ERR_ANDROID_LOAD_FROM_URL";
MsgInterface.STR_CLIENT_DB_DEL_OPERATION_FAILED = "STR_CLIENT_DB_DEL_OPERATION_FAILED";
MsgInterface.STR_DATAVIEW_TO_DATASOURCE_OPERATION_FAILED = "STR_DATAVIEW_TO_DATASOURCE_OPERATION_FAILED";
MsgInterface.STR_CLIENT_DB_DISCONNECT_DATASOURCE_OPEN = "STR_CLIENT_DB_DISCONNECT_DATASOURCE_OPEN";
MsgInterface.STR_CLIENT_DB_DISCONNECT_DATASOURCE_NOT_EXIST = "STR_CLIENT_DB_DISCONNECT_DATASOURCE_NOT_EXIST";
MsgInterface.FMERROR_STR_INVALID_PASSWORD = "FMERROR_STR_INVALID_PASSWORD";
MsgInterface.STR_MOBILE_TAB_CONTROL_CANNOT_BE_USED = "STR_MOBILE_TAB_CONTROL_CANNOT_BE_USED";
MsgInterface.STR_MOBILE_CONTROLS_CANNOT_BE_OUTSIDE_TAB = "STR_MOBILE_CONTROLS_CANNOT_BE_OUTSIDE_TAB";
MsgInterface.STR_MOBILE_TAB_CONTROL_LAYER_0 = "STR_MOBILE_TAB_CONTROL_LAYER_0";
MsgInterface.STR_MOBILE_TAB_DISPLAY_LIST_ERROR = "STR_MOBILE_TAB_DISPLAY_LIST_ERROR";
MsgInterface.RC_ERROR_ARG_TYPE_STRING_NUMBER_MISMATCH = "RC_ERROR_ARG_TYPE_STRING_NUMBER_MISMATCH";
MsgInterface.RC_ERROR_ILLEGAL_ARG_ATTR_TYPE = "RC_ERROR_ILLEGAL_ARG_ATTR_TYPE";
MsgInterface.RC_ERROR_ILLEGAL_RETURN_VAL_ATTR_TYPE = "RC_ERROR_ILLEGAL_RETURN_VAL_ATTR_TYPE";
MsgInterface.STR_ERR_WEBCLIENT_PROGRAM_RELOADED = "STR_ERR_WEBCLIENT_PROGRAM_RELOADED";
MsgInterface.STR_ERR_EXECUTED_PROGRAM_CHANGED = "STR_ERR_EXECUTED_PROGRAM_CHANGED";
MsgInterface.DefaultMessages = [
    new DefaultMsgDetails("STR_ERR_NUM", "Invalid number"), new DefaultMsgDetails("STR_ERR_DATE", "Invalid date"), new DefaultMsgDetails("STR_ERR_TIME", "Invalid time"), new DefaultMsgDetails("MONTHS_PTR", "January   February  March     April     May       June      July      August    September October   November  December"), new DefaultMsgDetails("DAYS_PTR", "Sunday    Monday    Tuesday   Wednesday Thursday  Friday    Saturday"), new DefaultMsgDetails("STR_ERR_NEGETIVE", "Control value must be non-negative"), new DefaultMsgDetails("STR_RNG_TXT", "Valid control input range is:"), new DefaultMsgDetails("EDT_ERR_STR_1", "Numeric format is limited to %d.%d digits"), new DefaultMsgDetails("STR_ERR_PIPE_CONNECTION", "The connection to the runtime engine was lost. Process ID "), new DefaultMsgDetails("FMERROR_STR_BAD_NAME", "Invalid data source name:"), new DefaultMsgDetails("FMERROR_STR_BAD_DAMAGED", "Damaged data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_BADCREATE", "Create error:"), new DefaultMsgDetails("FMERROR_STR_FILE_LOCKED", "Unable to lock the data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_UNEXPECTED", "Unexpected error, data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_SERVER_NOTFOUND", "Server not found, data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_SERVER_INIT_FAILED", "Server initialization failed, data source:"), new DefaultMsgDetails("FMERROR_STR_UNLOCKED", "Releasing failed, data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_DB_INIT_FAILED", "Database initialization error, data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_LOCK_OPEN", "Failed to open lock file, data source:"),
    new DefaultMsgDetails("FMERROR_STR_BAD_BADOPEN", "Failed to open, data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_BADDEF", "Definition mismatch, data source:"), new DefaultMsgDetails("FMERROR_STR_DUP_KEY", "Duplicate index, data source:"), new DefaultMsgDetails("FMERROR_STR_COMM_LOADED", "Communication Gateway not loaded, data source:"), new DefaultMsgDetails("FMERROR_STR_COMM_CONNECT", "Failed to connect to server, data source:"), new DefaultMsgDetails("FMERROR_STR_READONLY", "Cannot modify Read Only, data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_BADCLOSE", "Failed to close, data source:"), new DefaultMsgDetails("FMERROR_STR_REC_LOCKED", "Waiting for locked row, data source:"), new DefaultMsgDetails("FMERROR_STR_TRANS_OPEN", "Failed to open transaction, data source:"), new DefaultMsgDetails("FMERROR_STR_COMMIT", "Failed to commit transaction"), new DefaultMsgDetails("FMERROR_STR_ABORT", "Failed to abort transaction"), new DefaultMsgDetails("FMERROR_STR_RSRC_LOCKED", "Waiting for lock in database:"), new DefaultMsgDetails("FMERROR_STR_NODEF", "Database definition cannot be loaded, data source:"), new DefaultMsgDetails("FMERROR_STR_DEADLOCK", "Deadlock error, data source:"), new DefaultMsgDetails("FMERROR_STR_DB_PROT", "Exceeded database protection limits, data source:"), new DefaultMsgDetails("FMERROR_STR_OWNR_ALRDY_SET", "Access Key already set, data source:"), new DefaultMsgDetails("FMERROR_STR_INVALID_OWNR", "Invalid Access Key, data source:"), new DefaultMsgDetails("FMERROR_STR_CLR_OWNR_FAIL", "Failed to clear Access Key, data source:"), new DefaultMsgDetails("FMERROR_STR_NO_DATABASE", "Unknown database, data source:"), new DefaultMsgDetails("FMERROR_STR_DBMS_ALTER_FAIL", "Warning - Database failed to alter, data source:"),
    new DefaultMsgDetails("FMERROR_STR_TRANS_LOCK", "Waiting to open transaction"), new DefaultMsgDetails("FMERROR_STR_EXTUSE_MULU_CNFLCT", "Access External Use Database when MultiUser flag is No, data source:"), new DefaultMsgDetails("FMERROR_STR_DB_GW_VERSION_CNFLCT", "Database gateway version mismatch, data source:"), new DefaultMsgDetails("FMERROR_STR_DB_CANOT_REMOVE", "Failed to delete, data source:"), new DefaultMsgDetails("FMERROR_STR_DB_CANOT_RENAME", "Failed to rename, data source:"), new DefaultMsgDetails("FMERROR_STR_DB_BAD_SQL_CMD", "Invalid SQL command, database:"), new DefaultMsgDetails("FMERROR_STR_REC_LOCKED_NOBUF", "Waiting to fetch locked row, data source:"), new DefaultMsgDetails("FMERROR_STR_REOPEN", "Failed to reopen, data source:"), new DefaultMsgDetails("FMERROR_STR_REC_LOCKED_NOW", "Row locked in data source:"), new DefaultMsgDetails("FMERROR_STR_DBMS_SORT_FAIL", "Warning - Database failed to sort, data source:"), new DefaultMsgDetails("FMERROR_STR_NO_OLD_DATABASE_DBMS", "Warning - Previous DBMS or database unknown, data source:"), new DefaultMsgDetails("FMERROR_STR_BAD_LOGIN", "Server login failed. Invalid user/password, data source:"), new DefaultMsgDetails("FMERROR_STR_ERR_EXEC_SQL", "Error in executing SQL command:"), new DefaultMsgDetails("FMERROR_STR_ERR_UPDATE_FAIL", "Update operation failed, data source:"), new DefaultMsgDetails("FMERROR_STR_ERR_INSERT_FAIL", "Insert operation failed, data source:"), new DefaultMsgDetails("FMERROR_STR_ERR_DELETE_FAIL", "Delete operation failed, data source:"), new DefaultMsgDetails("FMERROR_STR_PRINTER", "Incorrect printer setup"), new DefaultMsgDetails("FMERROR_STR_FIL_NOT_EXIST", "Data source does not exist:"), new DefaultMsgDetails("FMERROR_STR_COMM_GWY_COMPTABILITY", "Communication gateways are not compatible:"), new DefaultMsgDetails("FMERROR_STR_CACHE_TOO_BIG", "Not enough memory - Cache not started, data source:"),
    new DefaultMsgDetails("FMERROR_STR_NO_ROWS_AFFECTED", "Operation failed. Record has been changed by another user or process, data source:"), new DefaultMsgDetails("FMERROR_STR_TARGET_FILE_EXIST", "Target data source exists. Create failed for data source:"), new DefaultMsgDetails("FMERROR_STR_FILE_IS_VIEW", "Cannot create/drop/copy a view, view:"), new DefaultMsgDetails("FMERROR_STR_DB_CANOT_COPY", "Failed to copy, data source:"), new DefaultMsgDetails("FMERROR_STR_HLP_NOT_EXIST", "Failed to open, file:"), new DefaultMsgDetails("FMERROR_STR_UNUSABLE_FILE", "Team Development: Data source inaccessible due to maintenance:"), new DefaultMsgDetails("FMERROR_STR_DB_BAD_QUERY", "Bad Open Query Selection Expression:"), new DefaultMsgDetails("FMERROR_STR_NO_HDLS", "Reached maximum Magic xpa file handlers. No available handlers left."), new DefaultMsgDetails("FMERROR_STR_MAX_CONNS_REACHED", "Unable to connect to Server: Maximum connections reached."), new DefaultMsgDetails("FMERROR_STR_CONSTRAINT_FAIL", "Constraint failure, data source:"), new DefaultMsgDetails("FMERROR_STR_TRIGGER_FAIL", "Trigger failure, data source:"), new DefaultMsgDetails("FMERROR_STR_MODIFY_WITHIN_TRANS", "Data source can be modified only from within a transaction, data source:"), new DefaultMsgDetails("EXPTAB_TSK_MODE_RT", "&Modify,&Create,&Delete,&Query,As &Parent,&Locate,&Range,&Key,&Sort,&Files,&Options,By &Exp "), new DefaultMsgDetails("EXPTAB_ERR_CALL_MAIN_PRG_1", "Cannot call Main Program"), new DefaultMsgDetails("LOCATE_STR_ERR_EOF", "Record not found - positioned at beginning"), new DefaultMsgDetails("RT_STR_REC_NOTFOUND", "Row not found in data source:"), new DefaultMsgDetails("RT_STR_PRG_NOTFOUND", "Program not found"), new DefaultMsgDetails("RT_STR_NO_RECS_IN_RNG", "No records within defined range"), new DefaultMsgDetails("RT_STR_FLD_MUST_UPDATED", "Control must be updated"), new DefaultMsgDetails("RT_STR_TSK_NO_SCREEN", "Task without screen"),
    new DefaultMsgDetails("RT_STR_CRSR_CANT_PARK", "Cursor cannot park on any control"), new DefaultMsgDetails("RT_STR_MODE_NOTALLOWED", "Initial Task mode not allowed"), new DefaultMsgDetails("RT_STR_NON_MODIFIABLE", "Non-modifiable control"), new DefaultMsgDetails("RT_STR_UPDATE_IN_QUERY", "Warning - Modify operation canceled due to task Query mode"), new DefaultMsgDetails("RT_STR_LOAD_RES_FAIL", "Failed to load resident data source, data source:"), new DefaultMsgDetails("RT_STR_NO_CREATE_ON_TREE", "Cannot open a task having a tree control with no data to display."), new DefaultMsgDetails("TSKR_ERR_NOTEXIST_COMP", "Component used by the task does not exist or could not be opened"), new DefaultMsgDetails("TSK_ERR_BCSUBFORM_WRONG_EXP", "a cached sub-form has server side expression in Range/Locate/SqlWhere"), new DefaultMsgDetails("TSK_ERR_NESTED_BCSUBFORM", "A cached sub-form can not have a non-cached nested sub-form"), new DefaultMsgDetails("TSK_ERR_CHANGE_CACHED_NESTED_BCSUBFORM", "A cached sub-form can not have a non-cached nested sub-form. The nested subform cache was changed since it uses server side range expression"), new DefaultMsgDetails("TSK_ERR_SUBFORM_DSQL", "DSQL task is not supported as a sub-form"), new DefaultMsgDetails("TSK_ERR_DSQL_SELECT_ONLY", "Only statements that retrieve data are allowed in a DSQL deferred transaction task"), new DefaultMsgDetails("CSTIO_STR_ERR2", "User not authorized for this operation"), new DefaultMsgDetails("CONFIRM_STR_DELETE", "Confirm Delete operation"), new DefaultMsgDetails("CONFIRM_STR_CANCEL", "Confirm Cancel operation"), new DefaultMsgDetails("CONFIRM_STR_WINDOW_TITLE", "Confirmation"), new DefaultMsgDetails("WARNING_STR_WINDOW_TITLE", "Warning"), new DefaultMsgDetails("BRKTAB_STR_ERROR", "Error"), new DefaultMsgDetails("USRINP_STR_BADPASSW", "The application could not log you on. Make sure your user ID and password are correct"), new DefaultMsgDetails("USRINP_STR_BADPASSW_WEBSERVER", "The Web Server could not log you on. Make sure your user ID and password are correct"),
    new DefaultMsgDetails("USRINP_STR_BADPASSW_PROXYSERVER", "The Proxy Server could not log you on. Make sure your user ID and password are correct"), new DefaultMsgDetails("CRF_STR_CONF_UPD", "Confirm update"), new DefaultMsgDetails("MENU_STR_ERROR_ENABLE", "Enable/Disable of system action is not allowed"), new DefaultMsgDetails("GUI_OK_BUTTON", "&OK"), new DefaultMsgDetails("GUI_CANCEL_BUTTON", "&Cancel"), new DefaultMsgDetails("BRKTAB_STOP_MODE_TITLE", "Error,Warning"), new DefaultMsgDetails("BRKTAB_STR_ERR_FORM", "Invalid form"), new DefaultMsgDetails("BROWSER_OPT_INFO_SERVER_STR", "Server"), new DefaultMsgDetails("STR_ERR_PIC_J", "Single byte characters are not allowed"), new DefaultMsgDetails("STR_ERR_PIC_S", "Double byte characters are not allowed"), new DefaultMsgDetails("STR_ERR_PIC_T", "Mixed data of double byte and single byte are not allowed"), new DefaultMsgDetails("TASKRULE_STR_APPLICATION", "Application"), new DefaultMsgDetails("DITDEF_STR_ERR_WINDOW_TYPE", "Invalid Window Type."), new DefaultMsgDetails("DITDEF_STR_ERR_SUBFORM_PROG_PARALLEL", "A parallel program cannot be used as subform or frame program."), new DefaultMsgDetails("DATEHEB_MONTH_STR", "תשרי חשון כסלו טבת  שבט  אדר  ניסן אייר סיון תמוז אב   אלול אדר באדר א"), new DefaultMsgDetails("DATEHEB_DOW_STR", "ראשוןשני  שלישירביעיחמישישישי שבת  "), new DefaultMsgDetails("CHK_ERR_CALL_FROM_RICH_CLIENT", "Rich Client task/program can only call a Rich Client or batch task/program"), new DefaultMsgDetails("RC_STR_F7_UNEXPECTED_ERR", "Unexpected error, Rich client could not be started"), new DefaultMsgDetails("STR_ERR_MAX_VAR_SIZE", "Rich client task supports up to 2147483647 bytes variables"), new DefaultMsgDetails("STR_RC_RECENT_ACTIVITY_TOOLTIP_HDR", "Recent Network Activities:"),
    new DefaultMsgDetails("STR_RC_RECENT_ACTIVITY_TIME_LBL", "At"), new DefaultMsgDetails("STR_RC_RECENT_ACTIVITY_DATA_UNIT", "KB."), new DefaultMsgDetails("STR_RC_RECENT_ACTIVITY_TIME_UNIT", "ms."), new DefaultMsgDetails("STR_PAGE_LOADING_IN_PROGRESS", "The loading of the page is still in progress. Press OK to wait for its completion or Cancel to abort."), new DefaultMsgDetails("STR_CANNOT_PARK", "Cannot park on control:"), new DefaultMsgDetails("STR_RESTART_SESSION", "Would you like to start a new session?"), new DefaultMsgDetails("STR_ERR_INACCESSIBLE_URL", "Inaccessible URL: "), new DefaultMsgDetails("STR_ERR_SESSION_CLOSED", "This session was closed by the server"), new DefaultMsgDetails("STR_ERR_SESSION_CLOSED_INACTIVITY", "This session was closed due to inactivity timeout"), new DefaultMsgDetails("STR_MINUTES", "minutes"), new DefaultMsgDetails("STR_HOURS", "hours"), new DefaultMsgDetails("STR_ERR_AUTHORIZATION_FAILURE", "You do not have access rights to the application. Please contact your system administrator."), new DefaultMsgDetails("STR_WARN_UNLOAD_TIMEOUT", "This session was closed due to unload timeout"), new DefaultMsgDetails("STR_WARN_PARALLEL_NOT_SUPPORTED", "Parallel program is not supported on mobile. Property ignored"), new DefaultMsgDetails("DN_ERR_MDI_FRAME_ISNOT_OPENED", "MDI frame is not opened"), new DefaultMsgDetails("ERR_CANNOT_HANDLE_RC_REQUEST", "Rich client requests cannot be handled when the online MDI is open"),
    new DefaultMsgDetails("ERR_CANNOT_HANDLE_WEB_REQUEST", "Web client requests cannot be handled when the online MDI is open"),
    new DefaultMsgDetails("STR_MDI_FRAME_MISMATCH", "The selected MDI Frame form cannot be used for the current task"), new DefaultMsgDetails("CHK_ERR_OFFLINE_NOT_SUPPORT_FRAME_INTERFACE", "Frames interface is not supported in an offline task"), new DefaultMsgDetails("STR_USER_ID", "User ID:"), new DefaultMsgDetails("STR_PASSWORD", "Password:"),
    new DefaultMsgDetails("STR_LOGON_PARAMETERS", "Logon Parameters"), new DefaultMsgDetails("STR_LOGON_CAPTION", "Logon"), new DefaultMsgDetails("STR_LOGON_INSTRUCTION", "Please enter your user ID and password."), new DefaultMsgDetails("STR_GENERIC_ERROR_MESSAGE", "An error occurred (%d). Please contact your system administrator."), new DefaultMsgDetails("STR_GENERIC_ERROR_CONNECTION_PROBLEM_TITLE", "Connection problem:"), new DefaultMsgDetails("STR_GENERIC_ERROR_CONNECTION_PROBLEM_MESSAGE", "Try to reconnect?"), new DefaultMsgDetails("FMERROR_STR_TRANS_OPEN_FAILED", "The transaction was already opened by another task"), new DefaultMsgDetails("STR_ERR_CANNOT_CALL_OFFLINE_BYNAME_OR_BYEXP", "Offline programs cannot be called using the Call By Name or Call By Expression operations"), new DefaultMsgDetails("RT_STR_DELETE_MODE_WITHOUT_MAINSOURCE_NOTALLOWED", "Deleted task mode is not allowed without main source"), new DefaultMsgDetails("RC_ERROR_INCOMPATIBLE_DATASOURCES", "Failed to update the local data. Please clear the application cache or reinstall the application."), new DefaultMsgDetails("RC_ERROR_INVALID_SOURCES", "Failed to update the application."), new DefaultMsgDetails("RC_ERROR_OFFLINE_NEXT_EXECUTION_INVALID_SOURCES", "Failed to start the application. Please restart while the application is connected to the server."), new DefaultMsgDetails("RC_ERR_ANDROID_LOAD_FROM_URL", "Cannot access the server."), new DefaultMsgDetails("STR_CLIENT_DB_DEL_OPERATION_FAILED", "ClientDbDel opeartion failed."), new DefaultMsgDetails("STR_DATAVIEW_TO_DATASOURCE_OPERATION_FAILED", "DataViewToDataSource operation failed."), new DefaultMsgDetails("STR_CLIENT_DB_DISCONNECT_DATASOURCE_OPEN", "Failed to disconnect, data source is open."), new DefaultMsgDetails("STR_CLIENT_DB_DISCONNECT_DATASOURCE_NOT_EXIST", "Failed to disconnect, database does not exist."), new DefaultMsgDetails("FMERROR_STR_INVALID_PASSWORD", "Invalid Password, data source:"), new DefaultMsgDetails("STR_MOBILE_TAB_CONTROL_CANNOT_BE_USED", "Tab control cannot be used in a container control."), new DefaultMsgDetails("STR_MOBILE_CONTROLS_CANNOT_BE_OUTSIDE_TAB", "Controls cannot be placed outside a tab control."),
    new DefaultMsgDetails("STR_MOBILE_TAB_CONTROL_LAYER_0", "Controls cannot be linked to layer 0 of the tab control."), new DefaultMsgDetails("STR_MOBILE_TAB_DISPLAY_LIST_ERROR", "The number of entries in the Display List property must be zero or match the number of entries in the Items List property."), new DefaultMsgDetails("RC_ERROR_ARG_TYPE_STRING_NUMBER_MISMATCH", "The number of characters in the argument type string does not match the number of total arguments"), new DefaultMsgDetails("RC_ERROR_ILLEGAL_ARG_ATTR_TYPE", "Illegal argument attribute type"), new DefaultMsgDetails("RC_ERROR_ILLEGAL_RETURN_VAL_ATTR_TYPE", "Illegal return value attribute type"), new DefaultMsgDetails("STR_ERR_WEBCLIENT_PROGRAM_RELOADED", "Changes were done at the server side. Browser will be refreshed in order to get the latest changes."), new DefaultMsgDetails("STR_ERR_EXECUTED_PROGRAM_CHANGED", "Executed program changed at the server side. Browser will be refreshed in order to get the latest changes.")
];

class Queue {
    constructor() {
        this._queueVec = null;
        this._queueVec = new List();
    }
    get() {
        let returnValue = null;
        if (this._queueVec.length > 0) {
            returnValue = this._queueVec.get_Item(0);
            this._queueVec.RemoveAt(0);
        }
        return returnValue;
    }
    put(obj) {
        this._queueVec.push(obj);
    }
    clear() {
        this._queueVec.Clear();
    }
    isEmpty() {
        return this._queueVec.length === 0;
    }
    Size() {
        return this._queueVec.length;
    }
}

class Randomizer {
    static get_initialized() {
        return Randomizer._initialized;
    }
    static get_mod() {
        return Randomizer._mod;
    }
    static get_mul() {
        return Randomizer._mul;
    }
    static get_seed() {
        return Randomizer._seed;
    }
    static set_initialized() {
        Randomizer._initialized = true;
    }
    static set_mod(randMod) {
        Randomizer._mod = randMod;
        return Randomizer._mod;
    }
    static set_mul(randMul) {
        Randomizer._mul = randMul;
        return Randomizer._mul;
    }
    static set_seed(randSeed) {
        Randomizer._seed = randSeed;
        return Randomizer._seed;
    }
}
Randomizer._initialized = false;
Randomizer._mod = 0.0;
Randomizer._mul = 0.0;
Randomizer._seed = 0.0;

class StorageAttributeCheck {
    static isTheSameType(type1, type2) {
        return type1 === type2 || (StorageAttributeCheck.isTypeNumeric(type1) && StorageAttributeCheck.isTypeNumeric(type2)) || (StorageAttributeCheck.isTypeLogical(type1) && StorageAttributeCheck.isTypeLogical(type2)) || (StorageAttributeCheck.IsTypeAlphaOrUnicode(type1) && StorageAttributeCheck.IsTypeAlphaOrUnicode(type2)) || (StorageAttributeCheck.isTypeBlob(type1) && StorageAttributeCheck.isTypeBlob(type2)) || (StorageAttributeCheck.isTypeDotNet(type1) && StorageAttributeCheck.isTypeDotNet(type2));
    }
    static isTypeBlob(type) {
        return type === StorageAttribute.BLOB || type === StorageAttribute.BLOB_VECTOR;
    }
    static isTypeAlpha(type) {
        return type === StorageAttribute.ALPHA || type === StorageAttribute.MEMO;
    }
    static isTypeNumeric(type) {
        return type === StorageAttribute.DATE || type === StorageAttribute.TIME || type === StorageAttribute.NUMERIC;
    }
    static isTypeLogical(type) {
        return type === StorageAttribute.BOOLEAN;
    }
    static isTypeDotNet(type) {
        return type === StorageAttribute.DOTNET;
    }
    static IsTypeAlphaOrUnicode(type) {
        return type === StorageAttribute.ALPHA || type === StorageAttribute.UNICODE;
    }
    static StorageFldAlphaOrUnicode(type1, type2) {
        return StorageAttributeCheck.IsTypeAlphaOrUnicode(type1) && StorageAttributeCheck.IsTypeAlphaOrUnicode(type2);
    }
    static StorageFldAlphaUnicodeOrBlob(type1, type2) {
        let type1AlphaOrUnicode = StorageAttributeCheck.IsTypeAlphaOrUnicode(type1);
        let type2AlphaOrUnicode = StorageAttributeCheck.IsTypeAlphaOrUnicode(type2);
        if (type1AlphaOrUnicode && type2AlphaOrUnicode) {
            return true;
        }
        else {
            let type1Blob = type1 === StorageAttribute.BLOB;
            let type2Blob = type2 === StorageAttribute.BLOB;
            return ((type1AlphaOrUnicode && type2Blob) || (type2AlphaOrUnicode && type1Blob));
        }
    }
    static IsTypeCompatibile(sourceAttribute, destinationAttribute) {
        let isTypeCompatible = false;
        switch (sourceAttribute) {
            case StorageAttribute.ALPHA:
            case StorageAttribute.UNICODE:
                if (destinationAttribute === StorageAttribute.ALPHA || destinationAttribute === StorageAttribute.UNICODE ||
                    destinationAttribute === StorageAttribute.DATE || destinationAttribute === StorageAttribute.TIME ||
                    destinationAttribute === StorageAttribute.NUMERIC) {
                    isTypeCompatible = true;
                }
                break;
            case StorageAttribute.NUMERIC:
                if (destinationAttribute === StorageAttribute.NUMERIC || destinationAttribute === StorageAttribute.ALPHA ||
                    destinationAttribute === StorageAttribute.UNICODE || destinationAttribute === StorageAttribute.BOOLEAN ||
                    destinationAttribute === StorageAttribute.DATE || destinationAttribute === StorageAttribute.TIME) {
                    isTypeCompatible = true;
                }
                break;
            case StorageAttribute.BOOLEAN:
                {
                    if (destinationAttribute === StorageAttribute.BOOLEAN || destinationAttribute === StorageAttribute.ALPHA ||
                        destinationAttribute === StorageAttribute.UNICODE || destinationAttribute === StorageAttribute.NUMERIC) {
                        isTypeCompatible = true;
                    }
                }
                break;
            case StorageAttribute.DATE:
            case StorageAttribute.TIME:
                if (destinationAttribute === StorageAttribute.ALPHA || destinationAttribute === StorageAttribute.UNICODE ||
                    destinationAttribute === StorageAttribute.NUMERIC || destinationAttribute === StorageAttribute.BOOLEAN ||
                    destinationAttribute === StorageAttribute.DATE || destinationAttribute === StorageAttribute.TIME) {
                    isTypeCompatible = true;
                }
                break;
            case StorageAttribute.BLOB:
                if (destinationAttribute === StorageAttribute.BLOB) {
                    isTypeCompatible = true;
                }
                break;
        }
        return isTypeCompatible;
    }
    constructor() {
    }
}

class SyncExecutionHelper {
    constructor() {
        this.resolver = null;
    }
    static get Instance() {
        if (SyncExecutionHelper._instance === null)
            SyncExecutionHelper._instance = new SyncExecutionHelper();
        return SyncExecutionHelper._instance;
    }
    Wait() {
        return new Promise((resolve) => {
            this.resolver = resolve;
        }).then();
    }
    Pulse() {
        let resolver = this.resolver;
        if (resolver != null) {
            resolver();
        }
    }
}
SyncExecutionHelper._instance = null;

const MAX_GENGO = 6;
class UtilDateJpn {
    constructor() {
        this.MaxGengo = MAX_GENGO;
    }
    static getInstance() {
        if (UtilDateJpn._instance === null) {
            UtilDateJpn._instance = new UtilDateJpn();
        }
        return UtilDateJpn._instance;
    }
    static getArrayDow() {
        return UtilDateJpn.JweekStr;
    }
    static getStrDow(intIdx) {
        let flag = intIdx < 0 || 7 < intIdx;
        if (flag) {
            intIdx = 0;
        }
        return UtilDateJpn.JweekStr[intIdx];
    }
    static convertStrMonth(month) {
        let flag = month < 0 || 12 < month;
        if (flag) {
            month = 0;
        }
        return UtilDateJpn.JmonthStr[month];
    }
    date_jpn_year_ofs(intYear, intDoy) {
        let result;
        if (intYear < 1 || intDoy < 1) {
            result = 0;
        }
        else {
            let num = this.MaxGengo - 1;
            while (intYear < UtilDateJpn.StartDayOfGengo[num][0]) {
                num = num - 1;
            }
            if (intYear === UtilDateJpn.StartDayOfGengo[num][0] && intDoy < UtilDateJpn.StartDayOfGengo[num][3]) {
                num = num - 1;
            }
            result = intYear - UtilDateJpn.StartDayOfGengo[num][0] + 1;
        }
        return result;
    }
    date_jpn_yr_2_a(intYear, intDoy, isKanji) {
        let num;
        if (intYear < 1 || intDoy < 1) {
            num = 0;
        }
        else {
            num = this.MaxGengo - 1;
            while (intYear < UtilDateJpn.StartDayOfGengo[num][0]) {
                num = num - 1;
            }
            if (intYear === UtilDateJpn.StartDayOfGengo[num][0] && intDoy < UtilDateJpn.StartDayOfGengo[num][3]) {
                num = num - 1;
            }
        }
        let result;
        if (isKanji) {
            result = UtilDateJpn.GengoStr[num][2];
        }
        else {
            result = UtilDateJpn.GengoStr[num][0];
        }
        return result;
    }
    date_jpn_yr_4_a(ucp_str, s_len) {
        let i = this.MaxGengo - 1;
        if (s_len > 0) {
            if (s_len > 1) {
                ucp_str = UtilStrByteMode.leftB(ucp_str, s_len);
            }
            while (i > 0) {
                if (s_len === 1) {
                    if (ucp_str === UtilDateJpn.GengoStr[i][0] || ucp_str === UtilDateJpn.GengoStr[i][1]) {
                        break;
                    }
                }
                else {
                    if (s_len > 1) {
                        let text = UtilStrByteMode.leftB(UtilDateJpn.GengoStr[i][2], s_len);
                        if (ucp_str === text) {
                            break;
                        }
                    }
                }
                i = i - 1;
            }
        }
        let result;
        if (i > 0) {
            result = UtilDateJpn.StartDayOfGengo[i][0];
        }
        else {
            const text = ucp_str.substr(0, 1);
            if (text === " " || text === "?") {
                result = 1;
            }
            else {
                result = 0;
            }
        }
        return result;
    }
    static getEraNameStrInDate(strDate, strPicture, intStartPos) {
        let result = null;
        let intPicIdxOfs = 0;
        let i = intStartPos;
        while (i + intPicIdxOfs < strPicture.length) {
            let intLetters;
            if (strPicture.charCodeAt(i + intPicIdxOfs) === PICInterface.PIC_JY1) {
                intLetters = 1;
            }
            else {
                if (strPicture.charCodeAt(i + intPicIdxOfs) === PICInterface.PIC_JY2) {
                    intLetters = 1;
                }
                else {
                    if (strPicture.charCodeAt(i + intPicIdxOfs) === PICInterface.PIC_JY4) {
                        intLetters = 2;
                    }
                    else {
                        if (i < strDate.length) {
                            if (!UtilStrByteMode.isHalfWidth(strDate[i]) && UtilStrByteMode.isHalfWidth(strPicture[i + intPicIdxOfs])) {
                                intPicIdxOfs = intPicIdxOfs + 1;
                            }
                        }
                        i = i + 1;
                        continue;
                    }
                }
            }
            result = strDate.substr(i, intLetters);
            break;
        }
        return result;
    }
    static getEraNameLenInPicture(strPicture, intStartPos) {
        let intLetters = 0;
        for (let i = intStartPos; i < strPicture.length; i = i + 1) {
            if (strPicture.charCodeAt(i) === PICInterface.PIC_JY1) {
                intLetters = 1;
            }
            else {
                if (strPicture.charCodeAt(i) === PICInterface.PIC_JY2) {
                    intLetters = 2;
                }
                else {
                    if (strPicture.charCodeAt(i) === PICInterface.PIC_JY4) {
                        intLetters = 4;
                    }
                }
            }
            if (intLetters > 0) {
                break;
            }
        }
        return intLetters;
    }
    getStartYearOfEra(strDate, strPicture) {
        let eraNameStrInDate = UtilDateJpn.getEraNameStrInDate(strDate, strPicture, 0);
        let result;
        if (eraNameStrInDate === null) {
            result = 0;
        }
        else {
            let eraNameLenInPicture = UtilDateJpn.getEraNameLenInPicture(strPicture, 0);
            if (eraNameLenInPicture === 0) {
                result = 0;
            }
            else {
                let intStartYearOfEra = this.date_jpn_yr_4_a(eraNameStrInDate, eraNameLenInPicture);
                result = intStartYearOfEra;
            }
        }
        return result;
    }
    addExtraGengo(strExtraGengo) {
        let strGengoInfo = strExtraGengo.split(';');
        for (let i = 0; i < strGengoInfo.length; i = i + 1) {
            if (strGengoInfo[i].length > 0) {
                let strTok = strGengoInfo[i].split(',');
                if (strTok.length === 3 && strTok[0].length > 0 && strTok[1].length > 0 && strTok[2].length > 0) {
                    let strDate = strTok[0].split('/');
                    if (strDate.length === 3 && strDate[0].length > 0 && strDate[1].length > 0 && strDate[2].length > 0) {
                        UtilDateJpn.GengoStr[MAX_GENGO + i][0] = strTok[2].substr(0, 1);
                        UtilDateJpn.GengoStr[MAX_GENGO + i][1] = strTok[2].substr(1, 1);
                        UtilDateJpn.GengoStr[MAX_GENGO + i][2] = strTok[2].substr(2);
                        UtilDateJpn.StartDayOfGengo[MAX_GENGO + i][0] = NNumber.Parse(strDate[0]);
                        UtilDateJpn.StartDayOfGengo[MAX_GENGO + i][1] = NNumber.Parse(strDate[1]);
                        UtilDateJpn.StartDayOfGengo[MAX_GENGO + i][2] = NNumber.Parse(strDate[2]);
                        UtilDateJpn.StartDayOfGengo[MAX_GENGO + i][3] = NNumber.Parse(strTok[1]);
                        this.MaxGengo++;
                    }
                }
            }
        }
    }
}
UtilDateJpn._instance = null;
UtilDateJpn.JweekStr = [
    "   ", "日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"
];
UtilDateJpn.JmonthStr = [
    "", " 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"
];
UtilDateJpn.GengoStr = [
    ["?", "?", "????"],
    ["M", "m", "明治"],
    ["T", "t", "大正"],
    ["S", "s", "昭和"],
    ["H", "h", "平成"],
    ["R", "r", "令和"],
    ["?", "?", "？？"],
    ["?", "?", "？？"],
    ["?", "?", "？？"]
];
UtilDateJpn.StartDayOfGengo = [
    [1, 1, 1, 1],
    [1868, 9, 8, 252],
    [1912, 6, 30, 212],
    [1926, 12, 25, 359],
    [1989, 1, 8, 8],
    [2019, 5, 1, 121],
    [0, 0, 0, 0],
    [0, 0, 0, 0],
    [0, 0, 0, 0]
];

class UtilImeJpn {
    isValid(imeMode) {
        return (0 <= imeMode && imeMode <= 9) || imeMode === 15 || imeMode === 10;
    }
    constructor() {
        this.ImeAutoOff = false;
        this.StrImeRead = null;
    }
}
UtilImeJpn.IME_ZEN_HIRAGANA_ROMAN = 1;
UtilImeJpn.IME_FORCE_OFF = 15;
UtilImeJpn.IME_DISABLE = 10;

class XmlParser {
    constructor(data = NString.Empty) {
        this._currIndex = 0;
        this._xmLdata = "";
        this._history = new List();
        this.setXMLdata(data);
        this.setCurrIndex(0);
    }
    static getTokens(str, delimiter, isMagicXML = true) {
        let tokensVec = new List();
        let token = null;
        if (isMagicXML) {
            str = str.trim();
        }
        let strTok = str.split(delimiter.charAt(0));
        for (let i = 0; i < strTok.length; i = i + 1) {
            if (isMagicXML && i === strTok.length - 1 && strTok.length % 2 === 1) {
                break;
            }
            token = strTok[i];
            if (isMagicXML) {
                if (i % 2 === 0) {
                    token = token.trim();
                    if (token.endsWith("=")) {
                        token = token.substr(0, token.length - 1);
                    }
                }
                else if (token === "")
                    token = " ";
            }
            if (token === null)
                throw new ApplicationException("in ClientManager.Instance.XMLParser.getTokens() null token value");
            tokensVec.push(token);
        }
        return tokensVec;
    }
    static unescape(str) {
        let unescapedString = new StringBuilder(str.length);
        for (let i = 0; i < str.length; i++) {
            if (str[i] !== '\\') {
                unescapedString.Append(str[i]);
                continue;
            }
            switch (str[++i]) {
                case 'q':
                    unescapedString.Append('\"');
                    break;
                case 'o':
                    unescapedString.Append('\'');
                    break;
                case 'l':
                    unescapedString.Append('<');
                    break;
                case 'g':
                    unescapedString.Append('>');
                    break;
                case 'e':
                    unescapedString.Append('=');
                    break;
                case 'r':
                    unescapedString.Append('\r');
                    break;
                case 'n':
                    unescapedString.Append('\n');
                    break;
                default:
                    unescapedString.Append(str[i]);
                    break;
            }
        }
        return (unescapedString.ToString());
    }
    static escape(str) {
        let escapedString = new StringBuilder(str.length * 2);
        for (let i = 0; i < str.length; i++) {
            switch (str[i]) {
                case '\\':
                    escapedString.Append("\\\\");
                    break;
                case '"':
                    escapedString.Append("\\q");
                    break;
                case '\'':
                    escapedString.Append("\\o");
                    break;
                case '<':
                    escapedString.Append("\\l");
                    break;
                case '>':
                    escapedString.Append("\\g");
                    break;
                case '=':
                    escapedString.Append("\\e");
                    break;
                case '\r':
                    escapedString.Append("\r");
                    break;
                case '\n':
                    escapedString.Append("\n");
                    break;
                default:
                    escapedString.Append(str[i]);
                    break;
            }
        }
        return (escapedString.ToString());
    }
    static escapeUrl(str) {
        return NString.Replace(str, "&", "&amp;");
    }
    getNextTag() {
        if (this._xmLdata.length - this._currIndex <= 1) {
            return null;
        }
        for (let tmpIndx = this._currIndex + 1; tmpIndx < this._xmLdata.length; tmpIndx++) {
            let tmpChar = this._xmLdata[tmpIndx];
            if (NChar.IsLetter(tmpChar) || tmpChar === '/') {
                let endOfTag = NString.IndexOfAny(this._xmLdata, XmlParser.endOfNameChar, tmpIndx, this._xmLdata.length - tmpIndx);
                if (endOfTag === -1)
                    return null;
                else
                    return this._xmLdata.substr(tmpIndx, endOfTag - tmpIndx);
            }
        }
        return null;
    }
    getXMLsubstring(endContext) {
        return this._xmLdata.substr(this._currIndex, endContext - this._currIndex);
    }
    GetCurrentElementValue() {
        this.setCurrIndex2EndOfTag();
        let endContext = this.getXMLdata().indexOf(XMLConstants.TAG_OPEN, this.getCurrIndex());
        let value = this.getXMLsubstring(endContext);
        this.setCurrIndex2EndOfTag();
        return value;
    }
    setCurrIndex2EndOfTag() {
        this._currIndex = this._xmLdata.indexOf(XMLConstants.TAG_CLOSE, this._currIndex) + 1;
    }
    static getInt(valueStr) {
        return NNumber.Parse(valueStr.trim());
    }
    static getBoolean(valueStr) {
        return valueStr[0] === '1';
    }
    getCurrIndex() {
        return this._currIndex;
    }
    getXMLdata() {
        return this._xmLdata;
    }
    add2CurrIndex(add) {
        this._currIndex = this._currIndex + add;
    }
    setCurrIndex(index) {
        this._currIndex = index;
    }
    setXMLdata(data) {
        if (data !== null)
            this._xmLdata = data.trim();
        else {
            this._xmLdata = null;
            this.setCurrIndex(0);
        }
    }
    PrepareFormReadString(newXmlString) {
        this.setXMLdata(newXmlString);
        this.setCurrIndex(0);
    }
    push() {
        this._history.push(this._currIndex);
        this._history.push(this._xmLdata);
    }
    pop() {
        let count = this._history.length;
        this._xmLdata = this._history.get_Item(count - 1);
        this._currIndex = this._history.get_Item(count - 2);
        this._history.SetSize(count - 2);
    }
    loadTableCacheData(data) {
        this.setXMLdata(data);
        this.setCurrIndex(0);
    }
    ReadToEndOfCurrentElement() {
        let currentTag = this.getNextTag();
        let currentTagIndex = this._xmLdata.indexOf(XMLConstants.TAG_OPEN + currentTag, this.getCurrIndex());
        let nextOpenTagIndex = this._xmLdata.indexOf(XMLConstants.TAG_OPEN, currentTagIndex + 1);
        if (nextOpenTagIndex === -1)
            nextOpenTagIndex = this._xmLdata.length;
        let elementEndIndex = NString.IndexOf(this._xmLdata, XMLConstants.TAG_TERM, this.getCurrIndex(), nextOpenTagIndex - this.getCurrIndex());
        if (elementEndIndex === -1)
            elementEndIndex = this._xmLdata.indexOf("/" + currentTag, this.getCurrIndex()) + currentTag.length + XMLConstants.TAG_TERM.length;
        else
            elementEndIndex = elementEndIndex + XMLConstants.TAG_TERM.length;
        let elementBlock = this.getXMLsubstring(elementEndIndex);
        this.setCurrIndex(elementEndIndex);
        return elementBlock;
    }
    ReadContentOfCurrentElement() {
        let currentTag = this.getNextTag();
        let elementEndIndex = this._xmLdata.indexOf("</" + currentTag + ">", this.getCurrIndex());
        if (elementEndIndex === -1)
            return NString.Empty;
        this.setCurrIndex2EndOfTag();
        let elementBlock = this.getXMLsubstring(elementEndIndex);
        this.setCurrIndex(elementEndIndex);
        this.setCurrIndex2EndOfTag();
        return elementBlock;
    }
    toString(headCharCount, tailCharCount) {
        if (arguments.length === 0) {
            return this.ToString_0();
        }
        return this.ToString_1(headCharCount, tailCharCount);
    }
    ToString_0() {
        return this.toString(20, 50);
    }
    ToString_1(headCharCount, tailCharCount) {
        let markerPosition = Math.min(this._currIndex, this._xmLdata.length);
        let segmentStartIndex = Math.max(0, markerPosition - headCharCount);
        let segmentEndIndex = Math.min(this._xmLdata.length, markerPosition + tailCharCount);
        let headLength = markerPosition - segmentStartIndex;
        let tailLength = segmentEndIndex - markerPosition;
        let segment = new StringBuilder();
        if (segmentStartIndex > 0)
            segment.Append("...");
        if (headLength > 0)
            segment.Append(this._xmLdata, segmentStartIndex, headLength);
        segment.Append("|-{").Append(this._currIndex).Append("}-|");
        if (tailLength > 0)
            segment.Append(this._xmLdata, this._currIndex, tailLength);
        if (segmentEndIndex < this._xmLdata.length)
            segment.Append("...");
        return segment.ToString();
    }
    SkipXMLElement() {
        let endContext = this.getXMLdata().indexOf(XMLConstants.TAG_TERM, this.getCurrIndex());
        if (endContext !== -1 && endContext < this.getXMLdata().length) {
            this.setCurrIndex2EndOfTag();
        }
    }
}
XmlParser.endOfNameChar = [' ', '>'];

export { APGDisplayMode, APGFormSize, APGInvokedFrom, APGMode, APGOption, APGType, Access, AlignmentTypeHori, AlignmentTypeVert, AllowedDirectionType, Area, AutoFit, Axis, Base64, BindingLevel, BlobContent, BlockTypes, BorderType, BottomPositionInterval, BoxDir, BrkLevel, BrkScope, BrkType, CacheStrategy, CallComOption, CallOperationMode, CallOsShow, CallUDPType, CallUdpConvention, CallWsStyle, CallbackType, CharacterSet, CheckExist, CheckboxMainStyle, ChoiceControlStyle, ChoiceUtils, ColumnUpdateStyle, CompTypes, ComponentItemType, Constants, ControlStyle, CtrlButtonType, CtrlButtonTypeGui, CtrlHotspotType, CtrlImageStyle, CtrlLineDirection, CtrlLineType, CtrlOleDisplayType, CtrlOleStoreType, CtrlTextType, DBHCache, DBHRowIdentifier, DataTranslation, DataViewHeaderType, DataViewOperationType, DataViewOutputType, DatabaseDataType, DatabaseDefinitionType, DatabaseFilters, DatabaseOperations, DataviewType, DateTimeUtils, DateUtil, DbDelUpdMode, DbOpen, DbShare, DbhKeyDirection, DbhKeyIndexType, DbhKeyMode, DbhKeyRangeMode, DbhSegmentDirection, DefaultMsgDetails, DisplayTextType, DitAttribute, DitType, DriverDB, DspInterface, EndMode, EngineDirect, EnterAnimation, ErrStrategy, ErrorClassific, ExeState, ExecOn, ExitAnimation, ExportType, FieldComAlloc, FieldComType, FieldViewModelType, FldStorage, FldStyle, FlowDirection, FlwMode, ForceExit, FormDelimiter, FormExpandType, FormOperationType, FormPage, FrameLayoutTypes, GradientStyle, HTML_2_STR, HelpCommand, HelpType, HtmlAlignmentType, HttpStatusCode, ImageEffects, InitialMode, InternalInterface, ItemMasks, JSON_Utils, KeyMode, KeyboardReturnKeys, KeyboardTypes, LDir, LineDirection, LineManipulationType, ListboxSelectionMode, LnkEval_Cond, LnkMode, LoadedValues, LockingStrategy, LogType, Logger, Logger_LogLevels, Logger_MessageDirection, LogicHeaderAction, LogicHeaderType, LogicLevel, LogicOperationType, LogicUnit, MagicProperties, MediaAccess, MediaFormat, MediaOrientation, MediaType, MgControlType, MgModelType, Misc, ModelAttGuiFrame, ModelAttMerge, ModelAttRichClientFrameSet, ModelAttrBrowser, ModelAttrField, ModelAttrFramesetForm, ModelAttrGui0, ModelAttrGui1, ModelAttrHelp, ModelAttrRichClient, ModelAttrText, ModelClass, MsgInterface, NotifyCollectionChangedAction, NullArithmetic, OSEnvironment, OSType, OpenEditDialog, Opr, Order, OrientationLock, PICInterface, PaperSize, PaperSizePdfDisabled, PaperSizePdfEnabled, PositionUsage, PrgExecPlace, Priority, Queue, RaiseAt, Randomizer, RangeMode, RbAppearance, Recursion, RemarkType, RequestInfo, Resident, RowType, Rtf, Rtf_ACTN, Rtf_ErrorRtf, Rtf_IDEST, Rtf_IPFN, Rtf_IPROP, Rtf_KWD, Rtf_PROP, Rtf_PROPTYPE, Rtf_RDS, Rtf_RIS, Rtf_RtfChar, Rtf_SYMBOL, SEQ_2_HTML, SEQ_2_STR, ScrollBarThumbType, SelprgMode, SideType, SliderType, SourceContextType, SplitPrimaryDisplay, SplitWindowType, StartupMode, Storage, StorageAttribute, StorageAttributeCheck, StorageAttributeType, StrUtil, SubformType, SyncExecutionHelper, TabControlTabsWidth, TabbingCycleType, TabbingOrderType, TableBehaviour, TableType, TaskFlow, TransBegin, TransMode, TriggerType, TrueFalseValues, UndoRedoAction, UniqueTskSort, UpdateMode, UseSQLCursor, UtilDateJpn, UtilImeJpn, UtilStrByteMode, ValType, VeeDiffUpdate, VeeMode, VeePartOfDataview, VerifyButtons, VerifyDisplay, VerifyImage, VerifyMode, ViewRefreshMode, ViewSelectType, WinCptn, WinHtmlType, WinUom, WindowPosition, WindowType, XMLConstants, XmlParser, YesNoValues };
//# sourceMappingURL=magic-xpa-utils.mjs.map
