import { Logger_LogLevels, Logger_MessageDirection } from "./enums";
import { Exception, StackTrace } from "@magic-xpa/mscorelib";
import { RequestInfo } from "./RequestInfo";
export declare enum LogType {
    info = 1,
    warning = 2,
    error = 3
}
export declare class Logger {
    static instance: Logger;
    LogLevel: Logger_LogLevels;
    ShouldBeep: boolean;
    static set Instance(value: Logger);
    static get Instance(): Logger;
    Initialize(logLevel: Logger_LogLevels, shouldBeep: boolean): void;
    ShouldLog(logLevel: Logger_LogLevels): boolean;
    ShouldLog(): boolean;
    private ShouldLog_0;
    private ShouldLog_1;
    ShouldLogServerRelatedMessages(): boolean;
    ShouldLogExtendedServerRelatedMessages(): boolean;
    WriteToLog(msg: string, openIfNecessary: boolean, logType?: LogType): void;
    WriteServerToLog(msg: string): void;
    WriteServerMessagesToLog(msg: string): void;
    WriteSupportToLog(msg: string, skipLine: boolean): void;
    WriteGuiToLog(msg: string): void;
    WriteDevToLog(msg: string): void;
    WriteBasicToLog(messageDirection: Logger_MessageDirection, contextID: string, sessionCounter: number, clientID: string, serverID: string, responseTime: number, statusCode: string, httpHeaders: string, contentLength: number): void;
    WriteRequestInfoToLog(requestInfo: RequestInfo, extraMessageStr: string): void;
    WriteBasicErrorToLog(): void;
    WriteErrorToLog(msg: string): void;
    WriteExceptionToLog(ex: Exception): void;
    WriteExceptionToLog(ex: Error): void;
    WriteExceptionToLog(ex: Exception, msg: string): void;
    WriteExceptionToLogWithMsg(msg: string): void;
    private WriteExceptionToLog_1;
    private WriteExceptionToLog_2;
    private WriteExceptionToLog_3;
    WriteWarningToLog(ex: Exception): void;
    WriteWarningToLog(ex: Exception, msg: string): void;
    WriteWarningToLog(ex: Error): void;
    WriteWarningToLogWithMsg(msg: string): void;
    private WriteWarningToLog_1;
    private WriteWarningToLog_2;
    private WriteWarningToLog_3;
    WriteStackTrace(stackTrace: StackTrace, framesToPrint: number, traceTitle: string): void;
    Flush(): void;
    constructor();
}
