import { StringBuilder } from "@magic-xpa/mscorelib";
export declare class Rtf_SYMBOL {
    szKeyword: string;
    kwd: Rtf_KWD;
    idxInRgprop: any;
    constructor(keyWord: string, kwd: Rtf_KWD, idxInRgprop: any);
}
export declare class Rtf_PROP {
    actn: Rtf_ACTN;
    prop: Rtf_PROPTYPE;
    constructor(actn: Rtf_ACTN, prop: Rtf_PROPTYPE);
}
export declare enum Rtf_KWD {
    CHAR = 0,
    DEST = 1,
    PROP = 2,
    SPEC = 3
}
export declare enum Rtf_PROPTYPE {
    CHP = 0,
    PAP = 1,
    SEP = 2,
    DOP = 3
}
export declare enum Rtf_ACTN {
    SPEC = 0,
    BYTE = 1,
    WORD = 2
}
export declare enum Rtf_IPFN {
    BIN = 0,
    HEX = 1,
    SKIP_DEST = 2,
    BREAK = 3,
    NEW = 4,
    FONT = 5,
    CHARSET = 6,
    UNICODE = 7
}
export declare enum Rtf_IDEST {
    PICT = 0,
    COLOR = 1,
    SKIP = 2
}
export declare enum Rtf_IPROP {
    BOLD = 0,
    ITALIC = 1,
    UNDERLINE = 2,
    FONT = 3,
    SIZE = 4,
    COLOR = 5,
    RED = 6,
    GREEN = 7,
    BLUE = 8,
    LEFT_IND = 9,
    RIGHT_IND = 10,
    FIRST_IND = 11,
    COLS = 12,
    PGN_X = 13,
    PGN_Y = 14,
    XA_PAGE = 15,
    YA_PAGE = 16,
    XA_LEFT = 17,
    XA_RIGHT = 18,
    YA_TOP = 19,
    YA_BOTTOM = 20,
    PGN_START = 21,
    SBK = 22,
    PGN_FORMAT = 23,
    FACING_P = 24,
    LANDSCAPE = 25,
    JUST = 26,
    PARD = 27,
    PLAIN = 28,
    SECTD = 29,
    BULLET = 30,
    XA_BULLET = 31,
    MAX = 32
}
export declare enum Rtf_RDS {
    NORM = 0,
    COLOR = 1,
    SKIP = 2,
    NEW = 3
}
export declare enum Rtf_ErrorRtf {
    OK = 0,
    STACK_UNDERFLOW = 1,
    STACK_OVERFLOW = 2,
    UNMATCHED_BRACE = 3,
    INVALID_HEX = 4,
    BAD_TABLE = 5,
    ASSERTION = 6,
    END_OF_FILE = 7,
    BUFFER_TOO_SMALL = 8
}
export declare class Rtf_RtfChar {
    static readonly CR: string;
    static readonly LF: string;
    static readonly TAB: string;
    static readonly BULLET: string;
    static readonly TILDA: string;
    static readonly DASH: string;
    static readonly DASH_CHAR = "-";
    static readonly QUOTE = "'";
    static readonly DBLQUOTE = "\"";
    static readonly OPENINGBRACE = "{";
    static readonly CLOSINGBRACE = "}";
    static readonly BACKSLASH = "\\";
}
export declare enum Rtf_RIS {
    NORM = 0,
    BIN = 1,
    HEX = 2,
    UNICODE = 3
}
export declare class Rtf {
    private _group;
    private _cbBin;
    private _lParam;
    private _skipDestIfUnk;
    private _outputOnce;
    private _processCrlfSpecial;
    private _destState;
    private _internalState;
    private _stack;
    private _index;
    private _fontNum;
    private readonly _charsetTable;
    private readonly _codePageTable;
    private static readonly RTF_PREFIX;
    private static readonly CHAR_PAR;
    private static readonly rgprop;
    private static readonly rgsymRtf;
    constructor();
    static isRtf(str: string): boolean;
    toTxt(rtfTxt: string, outputTxt: StringBuilder): Rtf_ErrorRtf;
    private ParseChar;
    private PrintChar;
    private PushState;
    private PopState;
    private ParseKeyword;
    private TranslateKeyword;
    private validateProp;
    private changeDestState;
    private ParseSpecialKeyword;
    private static is1stByte;
    private static is2ndByte;
    private setCodePageTable;
    private getCodePage;
    private getCharset;
}
