import { __awaiter } from "tslib";
import { Directive, ElementRef, Inject, Input, NgZone, } from '@angular/core';
import { Maskito, MASKITO_DEFAULT_ELEMENT_PREDICATE, MASKITO_DEFAULT_OPTIONS, } from '@maskito/core';
import * as i0 from "@angular/core";
export class MaskitoDirective {
    constructor(ngZone, elementRef) {
        this.ngZone = ngZone;
        this.elementRef = elementRef;
        this.maskedElement = null;
        this.maskito = MASKITO_DEFAULT_OPTIONS;
        this.maskitoElement = MASKITO_DEFAULT_ELEMENT_PREDICATE;
    }
    ngOnChanges() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            (_a = this.maskedElement) === null || _a === void 0 ? void 0 : _a.destroy();
            const predicate = this.maskitoElement;
            const predicateResult = yield predicate(this.elementRef.nativeElement);
            if (this.maskitoElement !== predicate) {
                // Ignore the result of the predicate if the
                // maskito element has changed before the predicate was resolved.
                return;
            }
            this.ngZone.runOutsideAngular(() => {
                var _a;
                this.maskedElement = new Maskito(predicateResult, (_a = this.maskito) !== null && _a !== void 0 ? _a : MASKITO_DEFAULT_OPTIONS);
            });
        });
    }
    ngOnDestroy() {
        var _a;
        (_a = this.maskedElement) === null || _a === void 0 ? void 0 : _a.destroy();
    }
}
MaskitoDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoDirective, deps: [{ token: NgZone }, { token: ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
MaskitoDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: MaskitoDirective, selector: "[maskito]", inputs: { maskito: "maskito", maskitoElement: "maskitoElement" }, usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[maskito]',
                }]
        }], ctorParameters: function () { return [{ type: i0.NgZone, decorators: [{
                    type: Inject,
                    args: [NgZone]
                }] }, { type: i0.ElementRef, decorators: [{
                    type: Inject,
                    args: [ElementRef]
                }] }]; }, propDecorators: { maskito: [{
                type: Input
            }], maskitoElement: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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