import * as i0 from '@angular/core';
import { Directive, Input, NgZone, ElementRef, Inject, Pipe, NgModule } from '@angular/core';
import * as i1 from '@angular/forms';
import { DefaultValueAccessor, NG_VALUE_ACCESSOR } from '@angular/forms';
import { MASKITO_DEFAULT_OPTIONS, maskitoTransform, MASKITO_DEFAULT_ELEMENT_PREDICATE, Maskito } from '@maskito/core';
import { __awaiter } from 'tslib';

class MaskitoCva {
    constructor(accessor) {
        this.accessor = accessor;
        this.maskito = MASKITO_DEFAULT_OPTIONS;
        const original = accessor.writeValue.bind(accessor);
        accessor.writeValue = (value) => {
            var _a;
            original(maskitoTransform(String(value !== null && value !== void 0 ? value : ''), (_a = this.maskito) !== null && _a !== void 0 ? _a : MASKITO_DEFAULT_OPTIONS));
        };
    }
}
MaskitoCva.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoCva, deps: [{ token: i1.DefaultValueAccessor }], target: i0.ɵɵFactoryTarget.Directive });
MaskitoCva.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: MaskitoCva, selector: "input[maskito], textarea[maskito]", inputs: { maskito: "maskito" }, host: { listeners: { "input": "$any(this.accessor)._handleInput($event.target.value)", "blur": "accessor.onTouched()", "compositionstart": "$any(this.accessor)._compositionStart()", "compositionend": "$any(this.accessor)._compositionEnd($event.target.value)" } }, providers: [
        DefaultValueAccessor,
        {
            provide: NG_VALUE_ACCESSOR,
            multi: true,
            useExisting: DefaultValueAccessor,
        },
    ], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoCva, decorators: [{
            type: Directive,
            args: [{
                    selector: 'input[maskito], textarea[maskito]',
                    providers: [
                        DefaultValueAccessor,
                        {
                            provide: NG_VALUE_ACCESSOR,
                            multi: true,
                            useExisting: DefaultValueAccessor,
                        },
                    ],
                    host: {
                        '(input)': '$any(this.accessor)._handleInput($event.target.value)',
                        '(blur)': 'accessor.onTouched()',
                        '(compositionstart)': '$any(this.accessor)._compositionStart()',
                        '(compositionend)': '$any(this.accessor)._compositionEnd($event.target.value)',
                    },
                }]
        }], ctorParameters: function () { return [{ type: i1.DefaultValueAccessor }]; }, propDecorators: { maskito: [{
                type: Input
            }] } });

class MaskitoDirective {
    constructor(ngZone, elementRef) {
        this.ngZone = ngZone;
        this.elementRef = elementRef;
        this.maskedElement = null;
        this.maskito = MASKITO_DEFAULT_OPTIONS;
        this.maskitoElement = MASKITO_DEFAULT_ELEMENT_PREDICATE;
    }
    ngOnChanges() {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            (_a = this.maskedElement) === null || _a === void 0 ? void 0 : _a.destroy();
            const predicate = this.maskitoElement;
            const predicateResult = yield predicate(this.elementRef.nativeElement);
            if (this.maskitoElement !== predicate) {
                // Ignore the result of the predicate if the
                // maskito element has changed before the predicate was resolved.
                return;
            }
            this.ngZone.runOutsideAngular(() => {
                var _a;
                this.maskedElement = new Maskito(predicateResult, (_a = this.maskito) !== null && _a !== void 0 ? _a : MASKITO_DEFAULT_OPTIONS);
            });
        });
    }
    ngOnDestroy() {
        var _a;
        (_a = this.maskedElement) === null || _a === void 0 ? void 0 : _a.destroy();
    }
}
MaskitoDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoDirective, deps: [{ token: NgZone }, { token: ElementRef }], target: i0.ɵɵFactoryTarget.Directive });
MaskitoDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.17", type: MaskitoDirective, selector: "[maskito]", inputs: { maskito: "maskito", maskitoElement: "maskitoElement" }, usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[maskito]',
                }]
        }], ctorParameters: function () { return [{ type: i0.NgZone, decorators: [{
                    type: Inject,
                    args: [NgZone]
                }] }, { type: i0.ElementRef, decorators: [{
                    type: Inject,
                    args: [ElementRef]
                }] }]; }, propDecorators: { maskito: [{
                type: Input
            }], maskitoElement: [{
                type: Input
            }] } });

class MaskitoPipe {
    transform(value, maskitoOptions) {
        return maskitoTransform(String(value !== null && value !== void 0 ? value : ''), maskitoOptions !== null && maskitoOptions !== void 0 ? maskitoOptions : MASKITO_DEFAULT_OPTIONS);
    }
}
MaskitoPipe.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoPipe, deps: [], target: i0.ɵɵFactoryTarget.Pipe });
MaskitoPipe.ɵpipe = i0.ɵɵngDeclarePipe({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoPipe, name: "maskito" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoPipe, decorators: [{
            type: Pipe,
            args: [{
                    name: 'maskito',
                }]
        }] });

class MaskitoModule {
}
MaskitoModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
MaskitoModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoModule, declarations: [MaskitoDirective, MaskitoCva, MaskitoPipe], exports: [MaskitoDirective, MaskitoCva, MaskitoPipe] });
MaskitoModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoModule });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.17", ngImport: i0, type: MaskitoModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [MaskitoDirective, MaskitoCva, MaskitoPipe],
                    exports: [MaskitoDirective, MaskitoCva, MaskitoPipe],
                }]
        }] });

/**
 * Generated bundle index. Do not edit.
 */

export { MaskitoCva, MaskitoDirective, MaskitoModule, MaskitoPipe };
//# sourceMappingURL=maskito-angular.js.map
