(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@maskito/core')) :
    typeof define === 'function' && define.amd ? define(['exports', '@maskito/core'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.Kit = {}, global.core));
})(this, (function (exports, core) { 'use strict';

    /******************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m) return m.call(o);
        if (o && typeof o.length === "number") return {
            next: function () {
                if (o && i >= o.length) o = void 0;
                return { value: o && o[i++], done: !o };
            }
        };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }

    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m) return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
        }
        catch (error) { e = { error: error }; }
        finally {
            try {
                if (r && !r.done && (m = i["return"])) m.call(i);
            }
            finally { if (e) throw e.error; }
        }
        return ar;
    }

    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
                if (!ar) ar = Array.prototype.slice.call(from, 0, i);
                ar[i] = from[i];
            }
        }
        return to.concat(ar || Array.prototype.slice.call(from));
    }

    typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
        var e = new Error(message);
        return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };

    var DEFAULT_DECIMAL_PSEUDO_SEPARATORS = ['.', ',', 'б', 'ю'];

    var DEFAULT_MIN_DATE = new Date('0001-01-01');
    var DEFAULT_MAX_DATE = new Date('9999-12-31');

    var DEFAULT_TIME_SEGMENT_MAX_VALUES = {
      hours: 23,
      minutes: 59,
      seconds: 59,
      milliseconds: 999
    };

    /**
     * {@link https://unicode-table.com/en/00A0/ Non-breaking space}.
     */
    var CHAR_NO_BREAK_SPACE = '\u00A0';
    /**
     * {@link https://unicode-table.com/en/2013/ EN dash}
     * is used to indicate a range of numbers or a span of time.
     * @example 2006–2022
     */

    var CHAR_EN_DASH = '\u2013';
    /**
     * {@link https://unicode-table.com/en/2014/ EM dash}
     * is used to mark a break in a sentence.
     * @example Taiga UI — powerful set of open source components for Angular
     * ___
     * Don't confuse with {@link CHAR_EN_DASH} or {@link CHAR_HYPHEN}!
     */

    var CHAR_EM_DASH = '\u2014';
    /**
     * {@link https://unicode-table.com/en/002D/ Hyphen (minus sign)}
     * is used to combine words.
     * @example well-behaved
     * ___
     * Don't confuse with {@link CHAR_EN_DASH} or {@link CHAR_EM_DASH}!
     */

    var CHAR_HYPHEN = '\u002D';
    /**
     * {@link https://unicode-table.com/en/2212/ Minus}
     * is used as math operator symbol or before negative digits.
     * ---
     * Can be used as `&minus;`. Don't confuse with {@link CHAR_HYPHEN}
     */

    var CHAR_MINUS = '\u2212';

    var POSSIBLE_DATE_RANGE_SEPARATOR = [CHAR_HYPHEN, CHAR_EN_DASH, CHAR_EM_DASH, CHAR_MINUS];
    var POSSIBLE_DATE_TIME_SEPARATOR = [',', ' '];

    var TIME_FIXED_CHARACTERS = [':', '.'];

    var TIME_SEGMENT_VALUE_LENGTHS = {
      hours: 2,
      minutes: 2,
      seconds: 2,
      milliseconds: 3
    };

    /**
     * Clamps a value between two inclusive limits
     *
     * @param value
     * @param min lower limit
     * @param max upper limit
     */
    function clamp(value, min, max) {
      var clampedValue = Math.min(Number(max), Math.max(Number(min), Number(value)));
      return value instanceof Date ? new Date(clampedValue) : clampedValue;
    }

    function appendDate(initialDate, _a) {
      var _b = _a === void 0 ? {} : _a,
          day = _b.day,
          month = _b.month,
          year = _b.year;

      var date = new Date(initialDate);

      if (day) {
        date.setDate(date.getDate() + day);
      }

      if (month) {
        date.setMonth(date.getMonth() + month);
      }

      if (year) {
        date.setFullYear(date.getFullYear() + year);
      }

      return date;
    }

    var getDateSegmentValueLength = function (dateString) {
      var _a, _b, _c;

      return {
        day: ((_a = dateString.match(/d/g)) === null || _a === void 0 ? void 0 : _a.length) || 0,
        month: ((_b = dateString.match(/m/g)) === null || _b === void 0 ? void 0 : _b.length) || 0,
        year: ((_c = dateString.match(/y/g)) === null || _c === void 0 ? void 0 : _c.length) || 0
      };
    };

    function dateToSegments(date) {
      return {
        day: String(date.getDate()).padStart(2, '0'),
        month: String(date.getMonth() + 1).padStart(2, '0'),
        year: String(date.getFullYear()).padStart(4, '0'),
        hours: String(date.getHours()).padStart(2, '0'),
        minutes: String(date.getMinutes()).padStart(2, '0'),
        seconds: String(date.getSeconds()).padStart(2, '0'),
        milliseconds: String(date.getMilliseconds()).padStart(3, '0')
      };
    }

    function isDateStringComplete(dateString, dateModeTemplate) {
      if (dateString.length < dateModeTemplate.length) {
        return false;
      }

      return dateString.split(/\D/).every(function (segment) {
        return !segment.match(/^0+$/);
      });
    }

    function parseDateRangeString(dateRange, dateModeTemplate, rangeSeparator) {
      var digitsInDate = dateModeTemplate.replace(/\W/g, '').length;
      return dateRange.replace(rangeSeparator, '').match(new RegExp("(\\D*\\d[^\\d\\s]*){1," + digitsInDate + "}", 'g')) || [];
    }

    /**
     * @deprecated use `Object.fromEntries` instead
     * (check browser support first https://caniuse.com/mdn-javascript_builtins_object_fromentries)
     * ___
     * TODO: after we bump Firefox to 63+ replace this function with `Object.fromEntries`.
     * TODO: Add `es2019.object` to `tsconfig.json` => `compilerOptions.lib`.
     *
     */

    function getObjectFromEntries(keyValuePairs) {
      return keyValuePairs.reduce(function (obj, _a) {
        var _b;

        var _c = __read(_a, 2),
            key = _c[0],
            val = _c[1];

        return __assign(__assign({}, obj), (_b = {}, _b[key] = val, _b));
      }, {});
    }

    function parseDateString(dateString, fullMode) {
      var cleanMode = fullMode.replace(/[^dmy]/g, '');
      var onlyDigitsDate = dateString.replace(/\D+/g, '');
      var dateSegments = {
        day: onlyDigitsDate.slice(cleanMode.indexOf('d'), cleanMode.lastIndexOf('d') + 1),
        month: onlyDigitsDate.slice(cleanMode.indexOf('m'), cleanMode.lastIndexOf('m') + 1),
        year: onlyDigitsDate.slice(cleanMode.indexOf('y'), cleanMode.lastIndexOf('y') + 1)
      };
      return getObjectFromEntries(Object.entries(dateSegments).filter(function (_a) {
        var _b = __read(_a, 2);
            _b[0];
            var value = _b[1];

        return Boolean(value);
      }).sort(function (_a, _b) {
        var _c = __read(_a, 1),
            a = _c[0];

        var _d = __read(_b, 1),
            b = _d[0];

        return fullMode.toLowerCase().indexOf(a[0]) > fullMode.toLowerCase().indexOf(b[0]) ? 1 : -1;
      }));
    }

    function segmentsToDate(parsedDate, parsedTime) {
      var _a, _b, _c, _d, _e, _f, _g;

      var year = ((_a = parsedDate.year) === null || _a === void 0 ? void 0 : _a.length) === 2 ? "20" + parsedDate.year : parsedDate.year;
      var date = new Date(Number(year !== null && year !== void 0 ? year : '0'), Number((_b = parsedDate.month) !== null && _b !== void 0 ? _b : '1') - 1, Number((_c = parsedDate.day) !== null && _c !== void 0 ? _c : '1'), Number((_d = parsedTime === null || parsedTime === void 0 ? void 0 : parsedTime.hours) !== null && _d !== void 0 ? _d : '0'), Number((_e = parsedTime === null || parsedTime === void 0 ? void 0 : parsedTime.minutes) !== null && _e !== void 0 ? _e : '0'), Number((_f = parsedTime === null || parsedTime === void 0 ? void 0 : parsedTime.seconds) !== null && _f !== void 0 ? _f : '0'), Number((_g = parsedTime === null || parsedTime === void 0 ? void 0 : parsedTime.milliseconds) !== null && _g !== void 0 ? _g : '0')); // needed for years less than 1900

      date.setFullYear(Number(year !== null && year !== void 0 ? year : '0'));
      return date;
    }

    var DATE_TIME_SEPARATOR = ', ';

    function toDateString(_a, dateMode, timeMode) {
      var _b;

      var day = _a.day,
          month = _a.month,
          year = _a.year,
          hours = _a.hours,
          minutes = _a.minutes,
          seconds = _a.seconds,
          milliseconds = _a.milliseconds;
      var safeYear = ((_b = dateMode.match(/y/g)) === null || _b === void 0 ? void 0 : _b.length) === 2 ? year === null || year === void 0 ? void 0 : year.slice(-2) : year;
      var fullMode = dateMode + (timeMode ? DATE_TIME_SEPARATOR + timeMode : '');
      return fullMode.replace(/d+/g, day !== null && day !== void 0 ? day : '').replace(/m+/g, month !== null && month !== void 0 ? month : '').replace(/y+/g, safeYear !== null && safeYear !== void 0 ? safeYear : '').replace(/H+/g, hours !== null && hours !== void 0 ? hours : '').replace(/MSS/g, milliseconds !== null && milliseconds !== void 0 ? milliseconds : '').replace(/M+/g, minutes !== null && minutes !== void 0 ? minutes : '').replace(/S+/g, seconds !== null && seconds !== void 0 ? seconds : '').replace(/^\D+/g, '').replace(/\D+$/g, '');
    }

    function padWithZeroesUntilValid(segmentValue, paddedMaxValue, prefixedZeroesCount) {
      if (prefixedZeroesCount === void 0) {
        prefixedZeroesCount = 0;
      }

      if (Number(segmentValue.padEnd(paddedMaxValue.length, '0')) <= Number(paddedMaxValue)) {
        return {
          validatedSegmentValue: segmentValue,
          prefixedZeroesCount: prefixedZeroesCount
        };
      }

      if (segmentValue.endsWith('0')) {
        // 00:|00 => Type 9 => 00:09|
        return padWithZeroesUntilValid("0" + segmentValue.slice(0, paddedMaxValue.length - 1), paddedMaxValue, prefixedZeroesCount + 1);
      } // |19:00 => Type 2 => 2|0:00


      return padWithZeroesUntilValid(segmentValue.slice(0, paddedMaxValue.length - 1) + "0", paddedMaxValue, prefixedZeroesCount);
    }

    var dateMaxValues = {
      day: 31,
      month: 12,
      year: 9999
    };
    function validateDateString(_a) {
      var e_1, _b;

      var dateString = _a.dateString,
          dateModeTemplate = _a.dateModeTemplate,
          offset = _a.offset,
          _c = __read(_a.selection, 2),
          from = _c[0],
          to = _c[1];

      var parsedDate = parseDateString(dateString, dateModeTemplate);
      var dateSegments = Object.entries(parsedDate);
      var validatedDateSegments = {};
      var paddedZeroes = 0;

      try {
        for (var dateSegments_1 = __values(dateSegments), dateSegments_1_1 = dateSegments_1.next(); !dateSegments_1_1.done; dateSegments_1_1 = dateSegments_1.next()) {
          var _d = __read(dateSegments_1_1.value, 2),
              segmentName = _d[0],
              segmentValue = _d[1];

          var validatedDate = toDateString(validatedDateSegments, dateModeTemplate);
          var maxSegmentValue = dateMaxValues[segmentName];
          var fantomSeparator = validatedDate.length && 1;
          var lastSegmentDigitIndex = offset + validatedDate.length + fantomSeparator + getDateSegmentValueLength(dateModeTemplate)[segmentName];
          var isLastSegmentDigitAdded = lastSegmentDigitIndex >= from && lastSegmentDigitIndex === to;

          if (isLastSegmentDigitAdded && Number(segmentValue) > Number(maxSegmentValue)) {
            // 3|1.10.2010 => Type 9 => 3|1.10.2010
            return {
              validatedDateString: '',
              updatedSelection: [from, to]
            }; // prevent changes
          }

          if (isLastSegmentDigitAdded && Number(segmentValue) < 1) {
            // 31.0|1.2010 => Type 0 => 31.0|1.2010
            return {
              validatedDateString: '',
              updatedSelection: [from, to]
            }; // prevent changes
          }

          var _e = padWithZeroesUntilValid(segmentValue, "" + maxSegmentValue),
              validatedSegmentValue = _e.validatedSegmentValue,
              prefixedZeroesCount = _e.prefixedZeroesCount;

          paddedZeroes += prefixedZeroesCount;
          validatedDateSegments[segmentName] = validatedSegmentValue;
        }
      } catch (e_1_1) {
        e_1 = {
          error: e_1_1
        };
      } finally {
        try {
          if (dateSegments_1_1 && !dateSegments_1_1.done && (_b = dateSegments_1.return)) _b.call(dateSegments_1);
        } finally {
          if (e_1) throw e_1.error;
        }
      }

      var validatedDateString = toDateString(validatedDateSegments, dateModeTemplate);
      var addedDateSegmentSeparators = validatedDateString.length - dateString.length;
      return {
        validatedDateString: validatedDateString,
        updatedSelection: [from + paddedZeroes + addedDateSegmentSeparators, to + paddedZeroes + addedDateSegmentSeparators]
      };
    }

    /**
     * Copy-pasted solution from lodash
     * @see https://lodash.com/docs/4.17.15#escapeRegExp
     */
    var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
    var reHasRegExpChar = new RegExp(reRegExpChar.source);
    function escapeRegExp(str) {
      return str && reHasRegExpChar.test(str) ? str.replace(reRegExpChar, '\\$&') : str;
    }

    function findCommonBeginningSubstr(a, b) {
      var res = '';

      for (var i = 0; i < a.length; i++) {
        if (a[i] !== b[i]) {
          return res;
        }

        res += a[i];
      }

      return res;
    }

    /**
     * Returns current active element, including shadow dom
     *
     * @return element or null
     */
    function getFocused(_a) {
      var activeElement = _a.activeElement;

      if (!(activeElement === null || activeElement === void 0 ? void 0 : activeElement.shadowRoot)) {
        return activeElement;
      }

      var element = activeElement.shadowRoot.activeElement;

      while (element === null || element === void 0 ? void 0 : element.shadowRoot) {
        element = element.shadowRoot.activeElement;
      }

      return element;
    }

    function identity(x) {
      return x;
    }

    function isEmpty(entity) {
      return !entity || typeof entity === 'object' && Object.keys(entity).length === 0;
    }

    function raiseSegmentValueToMin(segments, fullMode) {
      var segmentsLength = getDateSegmentValueLength(fullMode);
      return getObjectFromEntries(Object.entries(segments).map(function (_a) {
        var _b = __read(_a, 2),
            key = _b[0],
            value = _b[1];

        var segmentLength = segmentsLength[key];
        return [key, value.length === segmentLength && value.match(/^0+$/) ? '1'.padStart(segmentLength, '0') : value];
      }));
    }

    function createMinMaxDatePostprocessor(_a) {
      var dateModeTemplate = _a.dateModeTemplate,
          _b = _a.min,
          min = _b === void 0 ? DEFAULT_MIN_DATE : _b,
          _c = _a.max,
          max = _c === void 0 ? DEFAULT_MAX_DATE : _c,
          _d = _a.rangeSeparator,
          rangeSeparator = _d === void 0 ? '' : _d,
          _e = _a.dateSegmentSeparator,
          dateSegmentSeparator = _e === void 0 ? '.' : _e;
      return function (_a) {
        var e_1, _b;

        var value = _a.value,
            selection = _a.selection;
        var endsWithRangeSeparator = rangeSeparator && value.endsWith(rangeSeparator);
        var dateStrings = parseDateRangeString(value, dateModeTemplate, rangeSeparator);
        var validatedValue = '';

        try {
          for (var dateStrings_1 = __values(dateStrings), dateStrings_1_1 = dateStrings_1.next(); !dateStrings_1_1.done; dateStrings_1_1 = dateStrings_1.next()) {
            var dateString = dateStrings_1_1.value;
            validatedValue += validatedValue ? rangeSeparator : '';
            var parsedDate = parseDateString(dateString, dateModeTemplate);

            if (!isDateStringComplete(dateString, dateModeTemplate)) {
              var fixedDate = raiseSegmentValueToMin(parsedDate, dateModeTemplate);
              var fixedValue = toDateString(fixedDate, dateModeTemplate);
              var tail = dateString.endsWith(dateSegmentSeparator) ? dateSegmentSeparator : '';
              validatedValue += fixedValue + tail;
              continue;
            }

            var date = segmentsToDate(parsedDate);
            var clampedDate = clamp(date, min, max);
            validatedValue += toDateString(dateToSegments(clampedDate), dateModeTemplate);
          }
        } catch (e_1_1) {
          e_1 = {
            error: e_1_1
          };
        } finally {
          try {
            if (dateStrings_1_1 && !dateStrings_1_1.done && (_b = dateStrings_1.return)) _b.call(dateStrings_1);
          } finally {
            if (e_1) throw e_1.error;
          }
        }

        return {
          selection: selection,
          value: validatedValue + (endsWithRangeSeparator ? rangeSeparator : '')
        };
      };
    }

    function normalizeDatePreprocessor(_a) {
      var dateModeTemplate = _a.dateModeTemplate,
          dateSegmentsSeparator = _a.dateSegmentsSeparator,
          _b = _a.rangeSeparator,
          rangeSeparator = _b === void 0 ? '' : _b;
      return function (_a) {
        var elementState = _a.elementState,
            data = _a.data;
        var separator = rangeSeparator ? new RegExp(rangeSeparator + "|-") : DATE_TIME_SEPARATOR;
        var possibleDates = data.split(separator);
        var dates = data.includes(DATE_TIME_SEPARATOR) ? [possibleDates[0]] : possibleDates;

        if (dates.every(function (date) {
          return date.trim().split(/\D/).length === dateModeTemplate.split(dateSegmentsSeparator).length;
        })) {
          var newData = dates.map(function (date) {
            return normalizeDateString(date, dateModeTemplate, dateSegmentsSeparator);
          }).join(rangeSeparator);
          return {
            elementState: elementState,
            data: "" + newData + (data.includes(DATE_TIME_SEPARATOR) ? DATE_TIME_SEPARATOR + possibleDates[1] || '' : '')
          };
        }

        return {
          elementState: elementState,
          data: data
        };
      };
    }

    function normalizeDateString(dateString, template, separator) {
      var dateSegments = dateString.split(/\D/);
      var templateSegments = template.split(separator);
      var normalizedSegments = dateSegments.map(function (segment, index) {
        return index === templateSegments.length - 1 ? segment : segment.padStart(templateSegments[index].length, '0');
      });
      return normalizedSegments.join(separator);
    }

    function maskitoPostfixPostprocessorGenerator(postfix) {
      var postfixRE = new RegExp(escapeRegExp(postfix) + "$");
      return postfix ? function (_a, initialElementState) {
        var value = _a.value,
            selection = _a.selection;

        if (!value && !initialElementState.value.endsWith(postfix)) {
          // cases when developer wants input to be empty (programmatically)
          return {
            value: value,
            selection: selection
          };
        }

        if (!value.endsWith(postfix) && !initialElementState.value.endsWith(postfix)) {
          return {
            selection: selection,
            value: value + postfix
          };
        }

        var initialValueBeforePostfix = initialElementState.value.replace(postfixRE, '');
        var postfixWasModified = initialElementState.selection[1] >= initialValueBeforePostfix.length;
        var alreadyExistedValueBeforePostfix = findCommonBeginningSubstr(initialValueBeforePostfix, value);
        return {
          selection: selection,
          value: Array.from(postfix).reverse().reduce(function (newValue, char, index) {
            var i = newValue.length - 1 - index;
            var isInitiallyMirroredChar = alreadyExistedValueBeforePostfix[i] === char && postfixWasModified;
            return newValue[i] !== char || isInitiallyMirroredChar ? newValue.slice(0, i + 1) + char + newValue.slice(i + 1) : newValue;
          }, value)
        };
      } : identity;
    }

    function maskitoPrefixPostprocessorGenerator(prefix) {
      return prefix ? function (_a, initialElementState) {
        var value = _a.value,
            selection = _a.selection;

        if (value.startsWith(prefix) || // already valid
        !value && !initialElementState.value.startsWith(prefix) // cases when developer wants input to be empty
        ) {
          return {
            value: value,
            selection: selection
          };
        }

        var _b = __read(selection, 2),
            from = _b[0],
            to = _b[1];

        var prefixedValue = Array.from(prefix).reduce(function (modifiedValue, char, i) {
          return modifiedValue[i] === char ? modifiedValue : modifiedValue.slice(0, i) + char + modifiedValue.slice(i);
        }, value);
        var addedCharsCount = prefixedValue.length - value.length;
        return {
          selection: [from + addedCharsCount, to + addedCharsCount],
          value: prefixedValue
        };
      } : identity;
    }

    function createValidDatePreprocessor(_a) {
      var dateModeTemplate = _a.dateModeTemplate,
          dateSegmentsSeparator = _a.dateSegmentsSeparator,
          _b = _a.rangeSeparator,
          rangeSeparator = _b === void 0 ? '' : _b;
      return function (_a) {
        var e_1, _b;

        var elementState = _a.elementState,
            data = _a.data;
        var value = elementState.value,
            selection = elementState.selection;

        if (data === dateSegmentsSeparator) {
          return {
            elementState: elementState,
            data: selection[0] === value.length ? data : ''
          };
        }

        if (POSSIBLE_DATE_RANGE_SEPARATOR.includes(data)) {
          return {
            elementState: elementState,
            data: rangeSeparator
          };
        }

        var newCharacters = data.replace(new RegExp("[^\\d" + escapeRegExp(dateSegmentsSeparator) + rangeSeparator + "]", 'g'), '');

        if (!newCharacters) {
          return {
            elementState: elementState,
            data: ''
          };
        }

        var _c = __read(selection, 2),
            from = _c[0],
            rawTo = _c[1];

        var to = rawTo + data.length;
        var newPossibleValue = value.slice(0, from) + newCharacters + value.slice(to);
        var dateStrings = parseDateRangeString(newPossibleValue, dateModeTemplate, rangeSeparator);
        var validatedValue = '';
        var hasRangeSeparator = Boolean(rangeSeparator) && newPossibleValue.includes(rangeSeparator);

        try {
          for (var dateStrings_1 = __values(dateStrings), dateStrings_1_1 = dateStrings_1.next(); !dateStrings_1_1.done; dateStrings_1_1 = dateStrings_1.next()) {
            var dateString = dateStrings_1_1.value;

            var _d = validateDateString({
              dateString: dateString,
              dateModeTemplate: dateModeTemplate,
              offset: validatedValue ? validatedValue.length + rangeSeparator.length : 0,
              selection: [from, to]
            }),
                validatedDateString = _d.validatedDateString,
                updatedSelection = _d.updatedSelection;

            if (dateString && !validatedDateString) {
              return {
                elementState: elementState,
                data: ''
              }; // prevent changes
            }

            to = updatedSelection[1];
            validatedValue += hasRangeSeparator && validatedValue ? rangeSeparator + validatedDateString : validatedDateString;
          }
        } catch (e_1_1) {
          e_1 = {
            error: e_1_1
          };
        } finally {
          try {
            if (dateStrings_1_1 && !dateStrings_1_1.done && (_b = dateStrings_1.return)) _b.call(dateStrings_1);
          } finally {
            if (e_1) throw e_1.error;
          }
        }

        var newData = validatedValue.slice(from, to);
        return {
          elementState: {
            selection: selection,
            value: validatedValue.slice(0, from) + newData.split(dateSegmentsSeparator).map(function (segment) {
              return '0'.repeat(segment.length);
            }).join(dateSegmentsSeparator) + validatedValue.slice(to)
          },
          data: newData
        };
      };
    }

    function maskitoEventHandler(name, handler, eventListenerOptions) {
      return function (element, maskitoOptions) {
        var listener = function () {
          return handler(element, maskitoOptions);
        };

        element.addEventListener(name, listener, eventListenerOptions);
        return function () {
          return element.removeEventListener(name, listener, eventListenerOptions);
        };
      };
    }

    function maskitoAddOnFocusPlugin(value) {
      return maskitoEventHandler('focus', function (element) {
        if (!element.value) {
          element.value = value;
          element.dispatchEvent(new Event('input'));
        }
      });
    }

    function maskitoCaretGuard(guard) {
      return function (element) {
        var document = element.ownerDocument;
        var isPointerDown = 0;

        var onPointerDown = function () {
          return isPointerDown++;
        };

        var onPointerUp = function () {
          isPointerDown = Math.max(--isPointerDown, 0);
        };

        var listener = function () {
          if (getFocused(document) !== element) {
            return;
          }

          if (isPointerDown) {
            return document.addEventListener('mouseup', listener, {
              once: true,
              passive: true
            });
          }

          var start = element.selectionStart || 0;
          var end = element.selectionEnd || 0;

          var _a = __read(guard(element.value, [start, end]), 2),
              fromLimit = _a[0],
              toLimit = _a[1];

          if (fromLimit > start || toLimit < end) {
            element.setSelectionRange(clamp(start, fromLimit, toLimit), clamp(end, fromLimit, toLimit));
          }
        };

        document.addEventListener('selectionchange', listener, {
          passive: true
        });
        element.addEventListener('mousedown', onPointerDown, {
          passive: true
        });
        document.addEventListener('mouseup', onPointerUp, {
          passive: true
        });
        return function () {
          document.removeEventListener('selectionchange', listener);
          document.removeEventListener('mousedown', onPointerDown);
          document.removeEventListener('mouseup', onPointerUp);
        };
      };
    }

    function maskitoRejectEvent(element) {
      var listener = function () {
        var value = element.value;
        element.addEventListener('beforeinput', function (event) {
          if (event.defaultPrevented && value === element.value) {
            element.dispatchEvent(new CustomEvent('maskitoReject', {
              bubbles: true
            }));
          }
        }, {
          once: true
        });
      };

      element.addEventListener('beforeinput', listener, true);
      return function () {
        return element.removeEventListener('beforeinput', listener, true);
      };
    }

    function maskitoRemoveOnBlurPlugin(value) {
      return maskitoEventHandler('blur', function (element) {
        if (element.value === value) {
          element.value = '';
          element.dispatchEvent(new Event('input'));
        }
      });
    }

    function maskitoWithPlaceholder(placeholder, focusedOnly) {
      if (focusedOnly === void 0) {
        focusedOnly = false;
      }

      var removePlaceholder = function (value) {
        for (var i = value.length - 1; i >= 0; i--) {
          if (value[i] !== placeholder[i]) {
            return value.slice(0, i + 1);
          }
        }

        return '';
      };

      var plugins = [maskitoCaretGuard(function (value) {
        return [0, removePlaceholder(value).length];
      })];
      var focused = false;

      if (focusedOnly) {
        var focus_1 = maskitoEventHandler('focus', function (element) {
          focused = true;
          element.value += placeholder.slice(element.value.length);
          element.dispatchEvent(new Event('input'));
        }, {
          capture: true
        });
        var blur_1 = maskitoEventHandler('blur', function (element) {
          focused = false;
          element.value = removePlaceholder(element.value);
          element.dispatchEvent(new Event('input'));
        }, {
          capture: true
        });
        plugins.push(focus_1, blur_1);
      }

      return {
        plugins: plugins,
        removePlaceholder: removePlaceholder,
        preprocessors: [function (_a) {
          var elementState = _a.elementState,
              data = _a.data;
          var value = elementState.value,
              selection = elementState.selection;
          return {
            elementState: {
              selection: selection,
              value: removePlaceholder(value)
            },
            data: data
          };
        }],
        postprocessors: [function (_a, initialElementState) {
          var value = _a.value,
              selection = _a.selection;
          return initialElementState.value && (focused || !focusedOnly) ? {
            value: value + placeholder.slice(value.length),
            selection: selection
          } : {
            value: value,
            selection: selection
          };
        }]
      };
    }

    function createZeroPlaceholdersPreprocessor() {
      return function (_a, actionType) {
        var elementState = _a.elementState;
        var value = elementState.value,
            selection = elementState.selection;

        if (!value || isLastChar(value, selection)) {
          return {
            elementState: elementState
          };
        }

        var _b = __read(selection, 2),
            from = _b[0],
            to = _b[1];

        var zeroes = value.slice(from, to).replace(/\d/g, '0');
        var newValue = value.slice(0, from) + zeroes + value.slice(to);

        if (actionType === 'validation' || actionType === 'insert' && from === to) {
          return {
            elementState: {
              selection: selection,
              value: newValue
            }
          };
        }

        return {
          elementState: {
            selection: actionType === 'deleteBackward' || actionType === 'insert' ? [from, from] : [to, to],
            value: newValue
          }
        };
      };
    }

    function isLastChar(value, _a) {
      var _b = __read(_a, 2);
          _b[0];
          var to = _b[1];

      return to === value.length;
    }

    function maskitoDateOptionsGenerator(_a) {
      var mode = _a.mode,
          _b = _a.separator,
          separator = _b === void 0 ? '.' : _b,
          max = _a.max,
          min = _a.min;
      var dateModeTemplate = mode.split('/').join(separator);
      return __assign(__assign({}, core.MASKITO_DEFAULT_OPTIONS), {
        mask: Array.from(dateModeTemplate).map(function (char) {
          return char === separator ? char : /\d/;
        }),
        overwriteMode: 'replace',
        preprocessors: [createZeroPlaceholdersPreprocessor(), normalizeDatePreprocessor({
          dateModeTemplate: dateModeTemplate,
          dateSegmentsSeparator: separator
        }), createValidDatePreprocessor({
          dateModeTemplate: dateModeTemplate,
          dateSegmentsSeparator: separator
        })],
        postprocessors: [createMinMaxDatePostprocessor({
          min: min,
          max: max,
          dateModeTemplate: dateModeTemplate,
          dateSegmentSeparator: separator
        })]
      });
    }

    function createMinMaxRangeLengthPostprocessor(_a) {
      var dateModeTemplate = _a.dateModeTemplate,
          rangeSeparator = _a.rangeSeparator,
          minLength = _a.minLength,
          maxLength = _a.maxLength,
          _b = _a.max,
          max = _b === void 0 ? DEFAULT_MAX_DATE : _b;

      if (isEmpty(minLength) && isEmpty(maxLength)) {
        return identity;
      }

      return function (_a) {
        var value = _a.value,
            selection = _a.selection;
        var dateStrings = parseDateRangeString(value, dateModeTemplate, rangeSeparator);

        if (dateStrings.length !== 2 || dateStrings.some(function (date) {
          return !isDateStringComplete(date, dateModeTemplate);
        })) {
          return {
            value: value,
            selection: selection
          };
        }

        var _b = __read(dateStrings.map(function (dateString) {
          return segmentsToDate(parseDateString(dateString, dateModeTemplate));
        }), 2),
            fromDate = _b[0],
            toDate = _b[1];

        var minDistantToDate = appendDate(fromDate, __assign(__assign({}, minLength), {
          // 06.02.2023 - 07.02.2023 => {minLength: {day: 3}} => 06.02.2023 - 08.02.2023
          // "from"-day is included in the range
          day: (minLength === null || minLength === void 0 ? void 0 : minLength.day) && minLength.day - 1
        }));
        var maxDistantToDate = !isEmpty(maxLength) ? appendDate(fromDate, __assign(__assign({}, maxLength), {
          day: (maxLength === null || maxLength === void 0 ? void 0 : maxLength.day) && maxLength.day - 1
        })) : max;
        var minLengthClampedToDate = clamp(toDate, minDistantToDate, max);
        var minMaxLengthClampedToDate = minLengthClampedToDate > maxDistantToDate ? maxDistantToDate : minLengthClampedToDate;
        return {
          selection: selection,
          value: dateStrings[0] + rangeSeparator + toDateString(dateToSegments(minMaxLengthClampedToDate), dateModeTemplate)
        };
      };
    }

    function createSwapDatesPostprocessor(_a) {
      var dateModeTemplate = _a.dateModeTemplate,
          rangeSeparator = _a.rangeSeparator;
      return function (_a) {
        var value = _a.value,
            selection = _a.selection;
        var dateStrings = parseDateRangeString(value, dateModeTemplate, rangeSeparator);
        var isDateRangeComplete = dateStrings.length === 2 && dateStrings.every(function (date) {
          return isDateStringComplete(date, dateModeTemplate);
        });

        var _b = __read(selection, 2),
            from = _b[0],
            to = _b[1];

        var caretAtTheEnd = from >= value.length;
        var allValueSelected = from === 0 && to >= value.length; // dropping text inside with a pointer

        if (!(caretAtTheEnd || allValueSelected) || !isDateRangeComplete) {
          return {
            value: value,
            selection: selection
          };
        }

        var _c = __read(dateStrings.map(function (dateString) {
          return segmentsToDate(parseDateString(dateString, dateModeTemplate));
        }), 2),
            fromDate = _c[0],
            toDate = _c[1];

        return {
          selection: selection,
          value: fromDate > toDate ? dateStrings.reverse().join(rangeSeparator) : value
        };
      };
    }

    function maskitoDateRangeOptionsGenerator(_a) {
      var mode = _a.mode,
          _b = _a.separator,
          separator = _b === void 0 ? '.' : _b,
          min = _a.min,
          max = _a.max,
          minLength = _a.minLength,
          maxLength = _a.maxLength,
          _c = _a.dateSeparator,
          dateSeparator = _c === void 0 ? separator : _c,
          _d = _a.rangeSeparator,
          rangeSeparator = _d === void 0 ? "" + CHAR_NO_BREAK_SPACE + CHAR_EN_DASH + CHAR_NO_BREAK_SPACE : _d;
      var dateModeTemplate = mode.split('/').join(dateSeparator);
      var dateMask = Array.from(dateModeTemplate).map(function (char) {
        return char === dateSeparator ? char : /\d/;
      });
      return __assign(__assign({}, core.MASKITO_DEFAULT_OPTIONS), {
        mask: __spreadArray(__spreadArray(__spreadArray([], __read(dateMask)), __read(Array.from(rangeSeparator))), __read(dateMask)),
        overwriteMode: 'replace',
        preprocessors: [createZeroPlaceholdersPreprocessor(), normalizeDatePreprocessor({
          dateModeTemplate: dateModeTemplate,
          rangeSeparator: rangeSeparator,
          dateSegmentsSeparator: dateSeparator
        }), createValidDatePreprocessor({
          dateModeTemplate: dateModeTemplate,
          rangeSeparator: rangeSeparator,
          dateSegmentsSeparator: dateSeparator
        })],
        postprocessors: [createMinMaxDatePostprocessor({
          min: min,
          max: max,
          dateModeTemplate: dateModeTemplate,
          rangeSeparator: rangeSeparator,
          dateSegmentSeparator: dateSeparator
        }), createMinMaxRangeLengthPostprocessor({
          dateModeTemplate: dateModeTemplate,
          minLength: minLength,
          maxLength: maxLength,
          max: max,
          rangeSeparator: rangeSeparator
        }), createSwapDatesPostprocessor({
          dateModeTemplate: dateModeTemplate,
          rangeSeparator: rangeSeparator
        })]
      });
    }

    function padTimeSegments(timeSegments) {
      return getObjectFromEntries(Object.entries(timeSegments).map(function (_a) {
        var _b = __read(_a, 2),
            segmentName = _b[0],
            segmentValue = _b[1];

        return [segmentName, ("" + segmentValue).padEnd(TIME_SEGMENT_VALUE_LENGTHS[segmentName], '0')];
      }));
    }

    /**
     * @param timeString can be with/without fixed characters
     */

    function parseTimeString(timeString) {
      var onlyDigits = timeString.replace(/\D+/g, '');
      var timeSegments = {
        hours: onlyDigits.slice(0, 2),
        minutes: onlyDigits.slice(2, 4),
        seconds: onlyDigits.slice(4, 6),
        milliseconds: onlyDigits.slice(6, 9)
      };
      return getObjectFromEntries(Object.entries(timeSegments).filter(function (_a) {
        var _b = __read(_a, 2);
            _b[0];
            var value = _b[1];

        return Boolean(value);
      }));
    }

    function toTimeString(_a) {
      var _b = _a.hours,
          hours = _b === void 0 ? '' : _b,
          _c = _a.minutes,
          minutes = _c === void 0 ? '' : _c,
          _d = _a.seconds,
          seconds = _d === void 0 ? '' : _d,
          _e = _a.milliseconds,
          milliseconds = _e === void 0 ? '' : _e;
      var mm = minutes && ":" + minutes;
      var ss = seconds && ":" + seconds;
      var ms = milliseconds && "." + milliseconds;
      return "" + hours + mm + ss + ms;
    }

    var TRAILING_TIME_SEGMENT_SEPARATOR_REG = new RegExp("[" + TIME_FIXED_CHARACTERS.map(escapeRegExp).join('') + "]$");
    function validateTimeString(_a) {
      var e_1, _b;

      var timeString = _a.timeString,
          paddedMaxValues = _a.paddedMaxValues,
          offset = _a.offset,
          _c = __read(_a.selection, 2),
          from = _c[0],
          to = _c[1];

      var parsedTime = parseTimeString(timeString);
      var possibleTimeSegments = Object.entries(parsedTime);
      var validatedTimeSegments = {};
      var paddedZeroes = 0;

      try {
        for (var possibleTimeSegments_1 = __values(possibleTimeSegments), possibleTimeSegments_1_1 = possibleTimeSegments_1.next(); !possibleTimeSegments_1_1.done; possibleTimeSegments_1_1 = possibleTimeSegments_1.next()) {
          var _d = __read(possibleTimeSegments_1_1.value, 2),
              segmentName = _d[0],
              segmentValue = _d[1];

          var validatedTime = toTimeString(validatedTimeSegments);
          var maxSegmentValue = paddedMaxValues[segmentName];
          var fantomSeparator = validatedTime.length && 1;
          var lastSegmentDigitIndex = offset + validatedTime.length + fantomSeparator + TIME_SEGMENT_VALUE_LENGTHS[segmentName];
          var isLastSegmentDigitAdded = lastSegmentDigitIndex >= from && lastSegmentDigitIndex <= to;

          if (isLastSegmentDigitAdded && Number(segmentValue) > Number(maxSegmentValue)) {
            // 2|0:00 => Type 9 => 2|0:00
            return {
              validatedTimeString: '',
              updatedTimeSelection: [from, to]
            }; // prevent changes
          }

          var _e = padWithZeroesUntilValid(segmentValue, "" + maxSegmentValue),
              validatedSegmentValue = _e.validatedSegmentValue,
              prefixedZeroesCount = _e.prefixedZeroesCount;

          paddedZeroes += prefixedZeroesCount;
          validatedTimeSegments[segmentName] = validatedSegmentValue;
        }
      } catch (e_1_1) {
        e_1 = {
          error: e_1_1
        };
      } finally {
        try {
          if (possibleTimeSegments_1_1 && !possibleTimeSegments_1_1.done && (_b = possibleTimeSegments_1.return)) _b.call(possibleTimeSegments_1);
        } finally {
          if (e_1) throw e_1.error;
        }
      }

      var _f = __read(timeString.match(TRAILING_TIME_SEGMENT_SEPARATOR_REG) || [], 1),
          _g = _f[0],
          trailingSegmentSeparator = _g === void 0 ? '' : _g;

      var validatedTimeString = toTimeString(validatedTimeSegments) + trailingSegmentSeparator;
      var addedDateSegmentSeparators = Math.max(validatedTimeString.length - timeString.length, 0);
      return {
        validatedTimeString: validatedTimeString,
        updatedTimeSelection: [from + paddedZeroes + addedDateSegmentSeparators, to + paddedZeroes + addedDateSegmentSeparators]
      };
    }

    function isDateTimeStringComplete(dateTimeString, dateMode, timeMode) {
      return dateTimeString.length >= dateMode.length + timeMode.length + DATE_TIME_SEPARATOR.length && dateTimeString.split(DATE_TIME_SEPARATOR)[0].split(/\D/).every(function (segment) {
        return !segment.match(/^0+$/);
      });
    }

    function parseDateTimeString(dateTime, dateModeTemplate) {
      var hasSeparator = dateTime.includes(DATE_TIME_SEPARATOR);
      return [dateTime.slice(0, dateModeTemplate.length), dateTime.slice(hasSeparator ? dateModeTemplate.length + DATE_TIME_SEPARATOR.length : dateModeTemplate.length)];
    }

    function createMinMaxDateTimePostprocessor(_a) {
      var dateModeTemplate = _a.dateModeTemplate,
          timeMode = _a.timeMode,
          _b = _a.min,
          min = _b === void 0 ? DEFAULT_MIN_DATE : _b,
          _c = _a.max,
          max = _c === void 0 ? DEFAULT_MAX_DATE : _c;
      return function (_a) {
        var value = _a.value,
            selection = _a.selection;

        var _b = __read(parseDateTimeString(value, dateModeTemplate), 2),
            dateString = _b[0],
            timeString = _b[1];

        var parsedDate = parseDateString(dateString, dateModeTemplate);
        var parsedTime = parseTimeString(timeString);

        if (!isDateTimeStringComplete(value, dateModeTemplate, timeMode)) {
          var fixedDate = raiseSegmentValueToMin(parsedDate, dateModeTemplate);

          var _c = isDateStringComplete(dateString, dateModeTemplate) ? dateToSegments(clamp(segmentsToDate(fixedDate), min, max)) : fixedDate,
              year = _c.year,
              month = _c.month,
              day = _c.day;

          var fixedValue = toDateString(__assign({
            year: year,
            month: month,
            day: day
          }, parsedTime), dateModeTemplate, timeMode);
          var tail = value.slice(fixedValue.length);
          return {
            selection: selection,
            value: fixedValue + tail
          };
        }

        var date = segmentsToDate(parsedDate, parsedTime);
        var clampedDate = clamp(date, min, max);
        var validatedValue = toDateString(dateToSegments(clampedDate), dateModeTemplate, timeMode);
        return {
          selection: selection,
          value: validatedValue
        };
      };
    }

    function createValidDateTimePreprocessor(_a) {
      var dateModeTemplate = _a.dateModeTemplate,
          dateSegmentsSeparator = _a.dateSegmentsSeparator;
      var invalidCharsRegExp = new RegExp("[^\\d" + TIME_FIXED_CHARACTERS.map(escapeRegExp).join('') + escapeRegExp(dateSegmentsSeparator) + "]+");
      return function (_a) {
        var elementState = _a.elementState,
            data = _a.data;
        var value = elementState.value,
            selection = elementState.selection;

        if (data === dateSegmentsSeparator) {
          return {
            elementState: elementState,
            data: selection[0] === value.length ? data : ''
          };
        }

        if (POSSIBLE_DATE_TIME_SEPARATOR.includes(data)) {
          return {
            elementState: elementState,
            data: DATE_TIME_SEPARATOR
          };
        }

        var newCharacters = data.replace(invalidCharsRegExp, '');

        if (!newCharacters) {
          return {
            elementState: elementState,
            data: ''
          };
        }

        var _b = __read(selection, 2),
            from = _b[0],
            rawTo = _b[1];

        var to = rawTo + data.length;
        var newPossibleValue = value.slice(0, from) + newCharacters + value.slice(to);

        var _c = __read(parseDateTimeString(newPossibleValue, dateModeTemplate), 2),
            dateString = _c[0],
            timeString = _c[1];

        var validatedValue = '';
        var hasDateTimeSeparator = newPossibleValue.includes(DATE_TIME_SEPARATOR);

        var _d = validateDateString({
          dateString: dateString,
          dateModeTemplate: dateModeTemplate,
          offset: 0,
          selection: [from, to]
        }),
            validatedDateString = _d.validatedDateString,
            updatedSelection = _d.updatedSelection;

        if (dateString && !validatedDateString) {
          return {
            elementState: elementState,
            data: ''
          }; // prevent changes
        }

        to = updatedSelection[1];
        validatedValue += validatedDateString;
        var paddedMaxValues = padTimeSegments(DEFAULT_TIME_SEGMENT_MAX_VALUES);

        var _e = validateTimeString({
          timeString: timeString,
          paddedMaxValues: paddedMaxValues,
          offset: validatedValue.length + DATE_TIME_SEPARATOR.length,
          selection: [from, to]
        }),
            validatedTimeString = _e.validatedTimeString,
            updatedTimeSelection = _e.updatedTimeSelection;

        if (timeString && !validatedTimeString) {
          return {
            elementState: elementState,
            data: ''
          }; // prevent changes
        }

        to = updatedTimeSelection[1];
        validatedValue += hasDateTimeSeparator ? DATE_TIME_SEPARATOR + validatedTimeString : validatedTimeString;
        var newData = validatedValue.slice(from, to);
        return {
          elementState: {
            selection: selection,
            value: validatedValue.slice(0, from) + newData.split(dateSegmentsSeparator).map(function (segment) {
              return '0'.repeat(segment.length);
            }).join(dateSegmentsSeparator) + validatedValue.slice(to)
          },
          data: newData
        };
      };
    }

    function maskitoDateTimeOptionsGenerator(_a) {
      var dateMode = _a.dateMode,
          timeMode = _a.timeMode,
          _b = _a.dateSeparator,
          dateSeparator = _b === void 0 ? '.' : _b,
          min = _a.min,
          max = _a.max;
      var dateModeTemplate = dateMode.split('/').join(dateSeparator);
      return __assign(__assign({}, core.MASKITO_DEFAULT_OPTIONS), {
        mask: __spreadArray(__spreadArray(__spreadArray([], __read(Array.from(dateModeTemplate).map(function (char) {
          return char === dateSeparator ? char : /\d/;
        }))), __read(DATE_TIME_SEPARATOR.split(''))), __read(Array.from(timeMode).map(function (char) {
          return TIME_FIXED_CHARACTERS.includes(char) ? char : /\d/;
        }))),
        overwriteMode: 'replace',
        preprocessors: [createZeroPlaceholdersPreprocessor(), normalizeDatePreprocessor({
          dateModeTemplate: dateModeTemplate,
          dateSegmentsSeparator: dateSeparator
        }), createValidDateTimePreprocessor({
          dateModeTemplate: dateModeTemplate,
          dateSegmentsSeparator: dateSeparator
        })],
        postprocessors: [createMinMaxDateTimePostprocessor({
          min: min,
          max: max,
          dateModeTemplate: dateModeTemplate,
          timeMode: timeMode
        })]
      });
    }

    function generateMaskExpression(_a) {
      var decimalSeparator = _a.decimalSeparator,
          isNegativeAllowed = _a.isNegativeAllowed,
          precision = _a.precision,
          thousandSeparator = _a.thousandSeparator,
          prefix = _a.prefix,
          postfix = _a.postfix,
          _b = _a.decimalPseudoSeparators,
          decimalPseudoSeparators = _b === void 0 ? [] : _b,
          _c = _a.pseudoMinuses,
          pseudoMinuses = _c === void 0 ? [] : _c;
      var computedPrefix = computeAllOptionalCharsRegExp(prefix);
      var digit = '\\d';
      var optionalMinus = isNegativeAllowed ? "[" + CHAR_MINUS + pseudoMinuses.map(function (x) {
        return "\\" + x;
      }).join('') + "]?" : '';
      var integerPart = thousandSeparator ? "[" + digit + escapeRegExp(thousandSeparator).replace(/\s/g, '\\s') + "]*" : "[" + digit + "]*";
      var decimalPart = precision > 0 ? "([" + escapeRegExp(decimalSeparator) + decimalPseudoSeparators.map(escapeRegExp).join('') + "]" + digit + "{0," + (Number.isFinite(precision) ? precision : '') + "})?" : '';
      var computedPostfix = computeAllOptionalCharsRegExp(postfix);
      return new RegExp("^" + computedPrefix + optionalMinus + integerPart + decimalPart + computedPostfix + "$");
    }

    function computeAllOptionalCharsRegExp(str) {
      return str ? "" + str.split('').map(function (char) {
        return escapeRegExp(char) + "?";
      }).join('') : '';
    }

    function maskitoParseNumber(maskedNumber, decimalSeparator) {
      if (decimalSeparator === void 0) {
        decimalSeparator = '.';
      }

      var hasNegativeSign = !!maskedNumber.match(new RegExp("^\\D*[" + CHAR_MINUS + "\\" + CHAR_HYPHEN + CHAR_EN_DASH + CHAR_EM_DASH + "]"));
      var unmaskedNumber = maskedNumber.replace(new RegExp("[^\\d" + escapeRegExp(decimalSeparator) + "]", 'g'), '').replace(decimalSeparator, '.');
      return unmaskedNumber ? Number((hasNegativeSign ? CHAR_HYPHEN : '') + unmaskedNumber) : NaN;
    }

    /**
     * Convert number to string with replacing exponent part on decimals
     *
     * @param value the number
     * @return string representation of a number
     */

    function stringifyNumberWithoutExp(value) {
      var valueAsString = String(value);

      var _a = __read(valueAsString.split('e-'), 2),
          numberPart = _a[0],
          expPart = _a[1];

      var valueWithoutExp = valueAsString;

      if (expPart) {
        var _b = __read(numberPart.split('.'), 2),
            fractionalPart = _b[1];

        var decimalDigits = Number(expPart) + ((fractionalPart === null || fractionalPart === void 0 ? void 0 : fractionalPart.length) || 0);
        valueWithoutExp = value.toFixed(decimalDigits);
      }

      return valueWithoutExp;
    }

    function validateDecimalPseudoSeparators(_a) {
      var decimalSeparator = _a.decimalSeparator,
          thousandSeparator = _a.thousandSeparator,
          _b = _a.decimalPseudoSeparators,
          decimalPseudoSeparators = _b === void 0 ? DEFAULT_DECIMAL_PSEUDO_SEPARATORS : _b;
      return decimalPseudoSeparators.filter(function (char) {
        return char !== thousandSeparator && char !== decimalSeparator;
      });
    }

    /**
     * If `decimalZeroPadding` is `true`, it pads decimal part with zeroes
     * (until number of digits after decimalSeparator is equal to the `precision`).
     * @example 1,42 => (`precision` is equal to 4) => 1,4200.
     */

    function createDecimalZeroPaddingPostprocessor(_a) {
      var decimalSeparator = _a.decimalSeparator,
          precision = _a.precision,
          decimalZeroPadding = _a.decimalZeroPadding,
          postfix = _a.postfix;

      if (precision <= 0 || !decimalZeroPadding) {
        return identity;
      }

      var trailingPostfixRegExp = new RegExp(escapeRegExp(postfix) + "$");
      return function (_a) {
        var value = _a.value,
            selection = _a.selection;

        if (Number.isNaN(maskitoParseNumber(value, decimalSeparator))) {
          return {
            value: value,
            selection: selection
          };
        }

        var _b = __read(value.replace(trailingPostfixRegExp, '').split(decimalSeparator), 2),
            integerPart = _b[0],
            _c = _b[1],
            decimalPart = _c === void 0 ? '' : _c;

        return {
          value: integerPart + decimalSeparator + decimalPart.padEnd(precision, '0') + postfix,
          selection: selection
        };
      };
    }

    /**
     * This preprocessor works only once at initialization phase (when `new Maskito(...)` is executed).
     * This preprocessor helps to avoid conflicts during transition from one mask to another (for the same input).
     * For example, the developer changes postfix (or other mask's props) during run-time.
     * ```
     * let maskitoOptions = maskitoNumberOptionsGenerator({postfix: ' year'});
     * // [3 seconds later]
     * maskitoOptions = maskitoNumberOptionsGenerator({postfix: ' years'});
     * ```
     */

    function createInitializationOnlyPreprocessor(_a) {
      var decimalSeparator = _a.decimalSeparator,
          decimalPseudoSeparators = _a.decimalPseudoSeparators,
          pseudoMinuses = _a.pseudoMinuses;
      var isInitializationPhase = true;
      var cleanNumberMask = generateMaskExpression({
        decimalSeparator: decimalSeparator,
        decimalPseudoSeparators: decimalPseudoSeparators,
        pseudoMinuses: pseudoMinuses,
        prefix: '',
        postfix: '',
        thousandSeparator: '',
        precision: Infinity,
        isNegativeAllowed: true
      });
      return function (_a) {
        var elementState = _a.elementState,
            data = _a.data;

        if (!isInitializationPhase) {
          return {
            elementState: elementState,
            data: data
          };
        }

        isInitializationPhase = false;
        return {
          elementState: core.maskitoTransform(elementState, {
            mask: cleanNumberMask
          }),
          data: data
        };
      };
    }

    /**
     * It removes repeated leading zeroes for integer part.
     * @example 0,|00005 => Backspace => |5
     * @example -0,|00005 => Backspace => -|5
     * @example User types "000000" => 0|
     * @example 0| => User types "5" => 5|
     */

    function createLeadingZeroesValidationPostprocessor(decimalSeparator, thousandSeparator) {
      var trimLeadingZeroes = function (value) {
        var escapedThousandSeparator = escapeRegExp(thousandSeparator);
        return value.replace( // all leading zeroes followed by another zero
        new RegExp("^(\\D+)?[0" + escapedThousandSeparator + "]+(?=0)"), '$1').replace( // zero followed by not-zero digit
        new RegExp("^(\\D+)?[0" + escapedThousandSeparator + "]+(?=[1-9])"), '$1');
      };

      var countTrimmedZeroesBefore = function (value, index) {
        var valueBefore = value.slice(0, index);
        var followedByZero = value.slice(index).startsWith('0');
        return valueBefore.length - trimLeadingZeroes(valueBefore).length + (followedByZero ? 1 : 0);
      };

      return function (_a) {
        var value = _a.value,
            selection = _a.selection;

        var _b = __read(selection, 2),
            from = _b[0],
            to = _b[1];

        var hasDecimalSeparator = value.includes(decimalSeparator);

        var _c = __read(value.split(decimalSeparator), 2),
            integerPart = _c[0],
            _d = _c[1],
            decimalPart = _d === void 0 ? '' : _d;

        var zeroTrimmedIntegerPart = trimLeadingZeroes(integerPart);

        if (integerPart === zeroTrimmedIntegerPart) {
          return {
            value: value,
            selection: selection
          };
        }

        var newFrom = from - countTrimmedZeroesBefore(value, from);
        var newTo = to - countTrimmedZeroesBefore(value, to);
        return {
          value: zeroTrimmedIntegerPart + (hasDecimalSeparator ? decimalSeparator : '') + decimalPart,
          selection: [Math.max(newFrom, 0), Math.max(newTo, 0)]
        };
      };
    }

    /**
     * This postprocessor is connected with {@link createMinMaxPlugin}:
     * both validate `min`/`max` bounds of entered value (but at the different point of time).
     */

    function createMinMaxPostprocessor(_a) {
      var min = _a.min,
          max = _a.max,
          decimalSeparator = _a.decimalSeparator;
      return function (_a) {
        var value = _a.value,
            selection = _a.selection;
        var parsedNumber = maskitoParseNumber(value, decimalSeparator);
        var limitedValue =
        /**
         * We cannot limit lower bound if user enters positive number.
         * The same for upper bound and negative number.
         * ___
         * @example (min = 5)
         * Empty input => Without this condition user cannot type 42 (the first digit will be rejected)
         * ___
         * @example (max = -10)
         * Value is -10 => Without this condition user cannot delete 0 to enter another digit
         */
        parsedNumber > 0 ? Math.min(parsedNumber, max) : Math.max(parsedNumber, min);

        if (!Number.isNaN(parsedNumber) && limitedValue !== parsedNumber) {
          var newValue = ("" + limitedValue).replace('.', decimalSeparator).replace(CHAR_HYPHEN, CHAR_MINUS);
          return {
            value: newValue,
            selection: [newValue.length, newValue.length]
          };
        }

        return {
          value: value,
          selection: selection
        };
      };
    }

    /**
     * Manage caret-navigation when user "deletes" non-removable digits or separators
     * @example 1,|42 => Backspace => 1|,42 (only if `decimalZeroPadding` is `true`)
     * @example 1|,42 => Delete => 1,|42 (only if `decimalZeroPadding` is `true`)
     * @example 0,|00 => Delete => 0,0|0 (only if `decimalZeroPadding` is `true`)
     * @example 1 |000 => Backspace => 1| 000 (always)
     */

    function createNonRemovableCharsDeletionPreprocessor(_a) {
      var decimalSeparator = _a.decimalSeparator,
          thousandSeparator = _a.thousandSeparator,
          decimalZeroPadding = _a.decimalZeroPadding;
      return function (_a, actionType) {
        var elementState = _a.elementState,
            data = _a.data;
        var value = elementState.value,
            selection = elementState.selection;

        var _b = __read(selection, 2),
            from = _b[0],
            to = _b[1];

        var selectedCharacters = value.slice(from, to);
        var nonRemovableSeparators = decimalZeroPadding ? [decimalSeparator, thousandSeparator] : [thousandSeparator];
        var areNonRemovableZeroesSelected = decimalZeroPadding && from > value.indexOf(decimalSeparator) && Boolean(selectedCharacters.match(/^0+$/gi));

        if (actionType !== 'deleteBackward' && actionType !== 'deleteForward' || !nonRemovableSeparators.includes(selectedCharacters) && !areNonRemovableZeroesSelected) {
          return {
            elementState: elementState,
            data: data
          };
        }

        return {
          elementState: {
            value: value,
            selection: actionType === 'deleteForward' ? [to, to] : [from, from]
          },
          data: data
        };
      };
    }

    /**
     * It pads integer part with zero if user types decimal separator (for empty input).
     * @example Empty input => User types "," (decimal separator) => 0,|
     */

    function createNotEmptyIntegerPartPreprocessor(_a) {
      var decimalSeparator = _a.decimalSeparator,
          precision = _a.precision;
      var startWithDecimalSepRegExp = new RegExp("^\\D*" + escapeRegExp(decimalSeparator));
      return function (_a) {
        var elementState = _a.elementState,
            data = _a.data;
        var value = elementState.value,
            selection = elementState.selection;

        var _b = __read(selection, 1),
            from = _b[0];

        if (precision <= 0 || value.includes(decimalSeparator) || !data.match(startWithDecimalSepRegExp)) {
          return {
            elementState: elementState,
            data: data
          };
        }

        var digitsBeforeCursor = value.slice(0, from).match(/\d+/);
        return {
          elementState: elementState,
          data: digitsBeforeCursor ? data : "0" + data
        };
      };
    }

    /**
     * It replaces pseudo characters with valid one.
     * @example User types '.' (but separator is equal to comma) => dot is replaced with comma.
     * @example User types hyphen / en-dash / em-dash => it is replaced with minus.
     */
    function createPseudoCharactersPreprocessor(validCharacter, pseudoCharacters) {
      var pseudoCharactersRegExp = new RegExp("[" + pseudoCharacters.join('') + "]", 'gi');
      return function (_a) {
        var elementState = _a.elementState,
            data = _a.data;
        var value = elementState.value,
            selection = elementState.selection;
        return {
          elementState: {
            selection: selection,
            value: value.replace(pseudoCharactersRegExp, validCharacter)
          },
          data: data.replace(pseudoCharactersRegExp, validCharacter)
        };
      };
    }

    /**
     * It rejects new typed decimal separator if it already exists in text field.
     * Behaviour is similar to native <input type="number"> (Chrome).
     * @example 1|23,45 => Press comma (decimal separator) => 1|23,45 (do nothing).
     */

    function createRepeatedDecimalSeparatorPreprocessor(decimalSeparator) {
      return function (_a) {
        var elementState = _a.elementState,
            data = _a.data;
        var value = elementState.value,
            selection = elementState.selection;

        var _b = __read(selection, 2),
            from = _b[0],
            to = _b[1];

        return {
          elementState: elementState,
          data: !value.includes(decimalSeparator) || value.slice(from, to + 1).includes(decimalSeparator) ? data : data.replace(new RegExp(escapeRegExp(decimalSeparator), 'gi'), '')
        };
      };
    }

    /**
     * It adds symbol for separating thousands.
     * @example 1000000 => (thousandSeparator is equal to space) => 1 000 000.
     */

    function createThousandSeparatorPostprocessor(_a) {
      var thousandSeparator = _a.thousandSeparator,
          decimalSeparator = _a.decimalSeparator,
          prefix = _a.prefix,
          postfix = _a.postfix;

      if (!thousandSeparator) {
        return identity;
      }

      var prefixReg = new RegExp("^" + escapeRegExp(prefix) + CHAR_MINUS + "?");
      var postfixReg = new RegExp(escapeRegExp(postfix) + "$");

      var isAllSpaces = function () {
        var chars = [];

        for (var _i = 0; _i < arguments.length; _i++) {
          chars[_i] = arguments[_i];
        }

        return chars.every(function (x) {
          return /\s/.test(x);
        });
      };

      return function (_a) {
        var value = _a.value,
            selection = _a.selection;

        var _b = __read(value.split(decimalSeparator), 2),
            integerPart = _b[0],
            _c = _b[1],
            decimalPart = _c === void 0 ? '' : _c;

        var _d = __read(selection, 2),
            initialFrom = _d[0],
            initialTo = _d[1];

        var _e = __read(selection, 2),
            from = _e[0],
            to = _e[1];

        var cleanIntegerPart = integerPart.replace(prefixReg, '').replace(postfixReg, '');

        var _f = __read(integerPart.match(prefixReg) || [], 1),
            _g = _f[0],
            integerPartPrefix = _g === void 0 ? '' : _g;

        var _h = __read(integerPart.match(postfixReg) || [], 1),
            _j = _h[0],
            integerPartPostfix = _j === void 0 ? '' : _j;

        var processedIntegerPart = Array.from(cleanIntegerPart).reduceRight(function (formattedValuePart, char, i) {
          var isLeadingThousandSeparator = !i && char === thousandSeparator;
          var isPositionForSeparator = !isLeadingThousandSeparator && formattedValuePart.length && (formattedValuePart.length + 1) % 4 === 0;

          if (isPositionForSeparator && (char === thousandSeparator || isAllSpaces(char, thousandSeparator))) {
            return thousandSeparator + formattedValuePart;
          }

          if (char === thousandSeparator && !isPositionForSeparator) {
            if (i && i <= initialFrom) {
              from--;
            }

            if (i && i <= initialTo) {
              to--;
            }

            return formattedValuePart;
          }

          if (!isPositionForSeparator) {
            return char + formattedValuePart;
          }

          if (i <= initialFrom) {
            from++;
          }

          if (i <= initialTo) {
            to++;
          }

          return char + thousandSeparator + formattedValuePart;
        }, '');
        return {
          value: integerPartPrefix + processedIntegerPart + integerPartPostfix + (value.includes(decimalSeparator) ? decimalSeparator : '') + decimalPart,
          selection: [from, to]
        };
      };
    }

    /**
     * It drops decimal part if precision is zero.
     * @example User pastes '123.45' (but precision is zero) => 123
     */

    function createZeroPrecisionPreprocessor(precision, decimalSeparator) {
      if (precision > 0) {
        return identity;
      }

      var decimalPartRegExp = new RegExp(escapeRegExp(decimalSeparator) + ".*$", 'g');
      return function (_a) {
        var elementState = _a.elementState,
            data = _a.data;
        var value = elementState.value,
            selection = elementState.selection;

        var _b = __read(selection, 2),
            from = _b[0],
            to = _b[1];

        var newValue = value.replace(decimalPartRegExp, '');
        return {
          elementState: {
            selection: [Math.min(from, newValue.length), Math.min(to, newValue.length)],
            value: newValue
          },
          data: data.replace(decimalPartRegExp, '')
        };
      };
    }

    var DUMMY_SELECTION = [0, 0];
    /**
     * It removes repeated leading zeroes for integer part on blur-event.
     * @example 000000 => blur => 0
     * @example 00005 => blur => 5
     */

    function createLeadingZeroesValidationPlugin(decimalSeparator, thousandSeparator) {
      var dropRepeatedLeadingZeroes = createLeadingZeroesValidationPostprocessor(decimalSeparator, thousandSeparator);
      return maskitoEventHandler('blur', function (element) {
        var newValue = dropRepeatedLeadingZeroes({
          value: element.value,
          selection: DUMMY_SELECTION
        }, {
          value: '',
          selection: DUMMY_SELECTION
        }).value;

        if (element.value !== newValue) {
          element.value = newValue;
          element.dispatchEvent(new Event('input'));
        }
      }, {
        capture: true
      });
    }

    /**
     * This plugin is connected with {@link createMinMaxPostprocessor}:
     * both validate `min`/`max` bounds of entered value (but at the different point of time).
     */

    function createMinMaxPlugin(_a) {
      var min = _a.min,
          max = _a.max,
          decimalSeparator = _a.decimalSeparator;
      return maskitoEventHandler('blur', function (element, options) {
        var parsedNumber = maskitoParseNumber(element.value, decimalSeparator);
        var clampedNumber = clamp(parsedNumber, min, max);

        if (!Number.isNaN(parsedNumber) && parsedNumber !== clampedNumber) {
          element.value = core.maskitoTransform(stringifyNumberWithoutExp(clampedNumber), options);
          element.dispatchEvent(new Event('input'));
        }
      }, {
        capture: true
      });
    }

    /**
     * It pads EMPTY integer part with zero if decimal parts exists.
     * It works on blur event only!
     * @example 1|,23 => Backspace => Blur => 0,23
     */

    function createNotEmptyIntegerPlugin(decimalSeparator) {
      return maskitoEventHandler('blur', function (element) {
        var newValue = element.value.replace(new RegExp("^(\\D+)?" + escapeRegExp(decimalSeparator)), "$10" + decimalSeparator);

        if (newValue !== element.value) {
          element.value = newValue;
          element.dispatchEvent(new Event('input'));
        }
      }, {
        capture: true
      });
    }

    function maskitoNumberOptionsGenerator(_a) {
      var _b = _a === void 0 ? {} : _a,
          _c = _b.max,
          max = _c === void 0 ? Number.MAX_SAFE_INTEGER : _c,
          _d = _b.min,
          min = _d === void 0 ? Number.MIN_SAFE_INTEGER : _d,
          _e = _b.precision,
          precision = _e === void 0 ? 0 : _e,
          _f = _b.thousandSeparator,
          thousandSeparator = _f === void 0 ? CHAR_NO_BREAK_SPACE : _f,
          _g = _b.decimalSeparator,
          decimalSeparator = _g === void 0 ? '.' : _g,
          decimalPseudoSeparators = _b.decimalPseudoSeparators,
          _h = _b.decimalZeroPadding,
          decimalZeroPadding = _h === void 0 ? false : _h,
          _j = _b.prefix,
          prefix = _j === void 0 ? '' : _j,
          _k = _b.postfix,
          postfix = _k === void 0 ? '' : _k;

      var pseudoMinuses = [CHAR_HYPHEN, CHAR_EN_DASH, CHAR_EM_DASH].filter(function (char) {
        return char !== thousandSeparator && char !== decimalSeparator;
      });
      var validatedDecimalPseudoSeparators = validateDecimalPseudoSeparators({
        decimalSeparator: decimalSeparator,
        thousandSeparator: thousandSeparator,
        decimalPseudoSeparators: decimalPseudoSeparators
      });
      return __assign(__assign({}, core.MASKITO_DEFAULT_OPTIONS), {
        mask: generateMaskExpression({
          decimalSeparator: decimalSeparator,
          precision: precision,
          thousandSeparator: thousandSeparator,
          prefix: prefix,
          postfix: postfix,
          isNegativeAllowed: min < 0
        }),
        preprocessors: [createInitializationOnlyPreprocessor({
          decimalSeparator: decimalSeparator,
          decimalPseudoSeparators: validatedDecimalPseudoSeparators,
          pseudoMinuses: pseudoMinuses
        }), createPseudoCharactersPreprocessor(CHAR_MINUS, pseudoMinuses), createPseudoCharactersPreprocessor(decimalSeparator, validatedDecimalPseudoSeparators), createNotEmptyIntegerPartPreprocessor({
          decimalSeparator: decimalSeparator,
          precision: precision
        }), createNonRemovableCharsDeletionPreprocessor({
          decimalSeparator: decimalSeparator,
          decimalZeroPadding: decimalZeroPadding,
          thousandSeparator: thousandSeparator
        }), createZeroPrecisionPreprocessor(precision, decimalSeparator), createRepeatedDecimalSeparatorPreprocessor(decimalSeparator)],
        postprocessors: [createMinMaxPostprocessor({
          decimalSeparator: decimalSeparator,
          min: min,
          max: max
        }), maskitoPrefixPostprocessorGenerator(prefix), maskitoPostfixPostprocessorGenerator(postfix), createThousandSeparatorPostprocessor({
          decimalSeparator: decimalSeparator,
          thousandSeparator: thousandSeparator,
          prefix: prefix,
          postfix: postfix
        }), createDecimalZeroPaddingPostprocessor({
          decimalSeparator: decimalSeparator,
          decimalZeroPadding: decimalZeroPadding,
          precision: precision,
          postfix: postfix
        })],
        plugins: [createLeadingZeroesValidationPlugin(decimalSeparator, thousandSeparator), createNotEmptyIntegerPlugin(decimalSeparator), createMinMaxPlugin({
          min: min,
          max: max,
          decimalSeparator: decimalSeparator
        })],
        overwriteMode: decimalZeroPadding ? function (_a) {
          var value = _a.value,
              _b = __read(_a.selection, 1),
              from = _b[0];

          return from <= value.indexOf(decimalSeparator) ? 'shift' : 'replace';
        } : 'shift'
      });
    }

    function createMaxValidationPreprocessor(timeSegmentMaxValues) {
      var paddedMaxValues = padTimeSegments(timeSegmentMaxValues);
      var invalidCharsRegExp = new RegExp("[^\\d" + TIME_FIXED_CHARACTERS.map(escapeRegExp).join('') + "]+");
      return function (_a, actionType) {
        var elementState = _a.elementState,
            data = _a.data;

        if (actionType === 'deleteBackward' || actionType === 'deleteForward') {
          return {
            elementState: elementState,
            data: data
          };
        }

        var value = elementState.value,
            selection = elementState.selection;

        if (actionType === 'validation') {
          var _b = validateTimeString({
            timeString: value,
            paddedMaxValues: paddedMaxValues,
            offset: 0,
            selection: selection
          }),
              validatedTimeString_1 = _b.validatedTimeString,
              updatedTimeSelection_1 = _b.updatedTimeSelection;

          return {
            elementState: {
              value: validatedTimeString_1,
              selection: updatedTimeSelection_1
            },
            data: data
          };
        }

        var newCharacters = data.replace(invalidCharsRegExp, '');

        var _c = __read(selection, 2),
            from = _c[0],
            rawTo = _c[1];

        var to = rawTo + newCharacters.length; // to be conformed with `overwriteMode: replace`

        var newPossibleValue = value.slice(0, from) + newCharacters + value.slice(to);

        var _d = validateTimeString({
          timeString: newPossibleValue,
          paddedMaxValues: paddedMaxValues,
          offset: 0,
          selection: [from, to]
        }),
            validatedTimeString = _d.validatedTimeString,
            updatedTimeSelection = _d.updatedTimeSelection;

        if (newPossibleValue && !validatedTimeString) {
          return {
            elementState: elementState,
            data: ''
          }; // prevent changes
        }

        to = updatedTimeSelection[1];
        var newData = validatedTimeString.slice(from, to);
        return {
          elementState: {
            selection: selection,
            value: validatedTimeString.slice(0, from) + '0'.repeat(newData.length) + validatedTimeString.slice(to)
          },
          data: newData
        };
      };
    }

    function maskitoTimeOptionsGenerator(_a) {
      var mode = _a.mode,
          _b = _a.timeSegmentMaxValues,
          timeSegmentMaxValues = _b === void 0 ? {} : _b;

      var enrichedTimeSegmentMaxValues = __assign(__assign({}, DEFAULT_TIME_SEGMENT_MAX_VALUES), timeSegmentMaxValues);

      return __assign(__assign({}, core.MASKITO_DEFAULT_OPTIONS), {
        mask: Array.from(mode).map(function (char) {
          return TIME_FIXED_CHARACTERS.includes(char) ? char : /\d/;
        }),
        preprocessors: [createZeroPlaceholdersPreprocessor(), createMaxValidationPreprocessor(enrichedTimeSegmentMaxValues)],
        overwriteMode: 'replace'
      });
    }

    exports.maskitoAddOnFocusPlugin = maskitoAddOnFocusPlugin;
    exports.maskitoCaretGuard = maskitoCaretGuard;
    exports.maskitoDateOptionsGenerator = maskitoDateOptionsGenerator;
    exports.maskitoDateRangeOptionsGenerator = maskitoDateRangeOptionsGenerator;
    exports.maskitoDateTimeOptionsGenerator = maskitoDateTimeOptionsGenerator;
    exports.maskitoEventHandler = maskitoEventHandler;
    exports.maskitoNumberOptionsGenerator = maskitoNumberOptionsGenerator;
    exports.maskitoParseNumber = maskitoParseNumber;
    exports.maskitoPostfixPostprocessorGenerator = maskitoPostfixPostprocessorGenerator;
    exports.maskitoPrefixPostprocessorGenerator = maskitoPrefixPostprocessorGenerator;
    exports.maskitoRejectEvent = maskitoRejectEvent;
    exports.maskitoRemoveOnBlurPlugin = maskitoRemoveOnBlurPlugin;
    exports.maskitoTimeOptionsGenerator = maskitoTimeOptionsGenerator;
    exports.maskitoWithPlaceholder = maskitoWithPlaceholder;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
