import { MaskitoPreprocessor } from '@maskito/core';
/**
 * Manage caret-navigation when user "deletes" non-removable digits or separators
 * @example 1,|42 => Backspace => 1|,42 (only if `decimalZeroPadding` is `true`)
 * @example 1|,42 => Delete => 1,|42 (only if `decimalZeroPadding` is `true`)
 * @example 0,|00 => Delete => 0,0|0 (only if `decimalZeroPadding` is `true`)
 * @example 1 |000 => Backspace => 1| 000 (always)
 */
export declare function createNonRemovableCharsDeletionPreprocessor({ decimalSeparator, thousandSeparator, decimalZeroPadding, }: {
    decimalSeparator: string;
    thousandSeparator: string;
    decimalZeroPadding: boolean;
}): MaskitoPreprocessor;
//# sourceMappingURL=non-removable-chars-deletion-preprocessor.d.ts.map