import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { MagicBridge } from '@magic-xpa/engine';
import { EngineMagicService } from '@magic-xpa/angular';
import * as i0 from "@angular/core";
/**
 * @ignore
 */
export class EngineLivePreviewMagicService extends EngineMagicService {
    constructor() {
        super();
        this.magicBridge = MagicBridge;
        this.isStub = false;
        // true when user is logged in magic
        this.isLoggedIn = false;
        // TODO - unregister
        this.refreshDom = new Subject();
        this.interactiveCommands = new Subject();
    }
    startMagicEngine(httpClient) {
        // alert('EngineLivePreviewMagicService');
        this.magicBridge.registerExecuteCommandsCallback(data => {
            if (!this.isStub) {
                try {
                    const list = data;
                    for (const c of list) {
                        if (window.parent) {
                            window.parent.postMessage({
                                event: 'command',
                                command: {
                                    CommandType: c.CommandType,
                                    str: c.str,
                                    stringList: c.stringList,
                                    Bool1: c.Bool1,
                                    TaskTag: c.TaskTag,
                                    line: c.line,
                                    CtrlName: c.CtrlName,
                                    obj: c.obj ? { IsTableChild: c.obj.IsTableChild } : null,
                                    number: c.number,
                                    value: c.value,
                                    Operation: c.Operation,
                                    obj1: c.obj1,
                                    userDropFormat: c.userDropFormat,
                                    fileName: c.fileName,
                                    contextID: c.contextID,
                                    params: c.params
                                }
                            }, '*');
                        }
                        this.refreshDom.next(c);
                    }
                }
                catch (e) {
                    console.dir(e);
                    console.log('magic engine not found');
                    console.log('moving to stub mode');
                    this.isStub = true;
                }
            }
        });
        this.magicBridge.registerInteractiveCallback(data => {
            if (!this.isStub) {
                this.interactiveCommands.next(data);
            }
        });
        this.magicBridge.Initialize(httpClient);
    }
}
EngineLivePreviewMagicService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: EngineLivePreviewMagicService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
EngineLivePreviewMagicService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: EngineLivePreviewMagicService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: EngineLivePreviewMagicService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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