import * as i0 from '@angular/core';
import { Injectable, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { EngineMagicService } from '@magic-xpa/angular';
import { Subject } from 'rxjs';
import { MagicBridge } from '@magic-xpa/engine';

/**
 * @ignore
 */
class EngineLivePreviewMagicService extends EngineMagicService {
    constructor() {
        super();
        this.magicBridge = MagicBridge;
        this.isStub = false;
        // true when user is logged in magic
        this.isLoggedIn = false;
        // TODO - unregister
        this.refreshDom = new Subject();
        this.interactiveCommands = new Subject();
    }
    startMagicEngine(httpClient) {
        // alert('EngineLivePreviewMagicService');
        this.magicBridge.registerExecuteCommandsCallback(data => {
            if (!this.isStub) {
                try {
                    const list = data;
                    for (const c of list) {
                        if (window.parent) {
                            window.parent.postMessage({
                                event: 'command',
                                command: {
                                    CommandType: c.CommandType,
                                    str: c.str,
                                    stringList: c.stringList,
                                    Bool1: c.Bool1,
                                    TaskTag: c.TaskTag,
                                    line: c.line,
                                    CtrlName: c.CtrlName,
                                    obj: c.obj ? { IsTableChild: c.obj.IsTableChild } : null,
                                    number: c.number,
                                    value: c.value,
                                    Operation: c.Operation,
                                    obj1: c.obj1,
                                    userDropFormat: c.userDropFormat,
                                    fileName: c.fileName,
                                    contextID: c.contextID,
                                    params: c.params
                                }
                            }, '*');
                        }
                        this.refreshDom.next(c);
                    }
                }
                catch (e) {
                    console.dir(e);
                    console.log('magic engine not found');
                    console.log('moving to stub mode');
                    this.isStub = true;
                }
            }
        });
        this.magicBridge.registerInteractiveCallback(data => {
            if (!this.isStub) {
                this.interactiveCommands.next(data);
            }
        });
        this.magicBridge.Initialize(httpClient);
    }
}
EngineLivePreviewMagicService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: EngineLivePreviewMagicService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
EngineLivePreviewMagicService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: EngineLivePreviewMagicService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: EngineLivePreviewMagicService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

const EngineServiceProviderFactory = () => {
    // TODO: move to .css file
    document.body.style.margin = '0';
    document.body.style.position = 'relative';
    const modeIndex = window.location.search.indexOf('mode=');
    const mode = modeIndex >= 0 ? window.location.search.substring(modeIndex + 5) : '';
    let engineService;
    if (mode.indexOf('livepreview') === 0) {
        // live preview
        engineService = new EngineLivePreviewMagicService();
    }
    else {
        // default
        engineService = new EngineMagicService();
    }
    return engineService;
};

const getProvider = () => {
    return {
        provide: EngineMagicService,
        useFactory: EngineServiceProviderFactory,
        deps: []
    };
};
class SmartuxXpaBridgeModule {
}
SmartuxXpaBridgeModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: SmartuxXpaBridgeModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
SmartuxXpaBridgeModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "15.2.10", ngImport: i0, type: SmartuxXpaBridgeModule, imports: [CommonModule] });
SmartuxXpaBridgeModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: SmartuxXpaBridgeModule, imports: [CommonModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.2.10", ngImport: i0, type: SmartuxXpaBridgeModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [],
                    imports: [
                        CommonModule
                    ],
                    providers: []
                }]
        }] });

/*
 * Public API Surface of xpa-bridge
 */

/**
 * Generated bundle index. Do not edit.
 */

export { EngineLivePreviewMagicService, EngineServiceProviderFactory, SmartuxXpaBridgeModule, getProvider };
//# sourceMappingURL=smartux-xpa-bridge.mjs.map
