// Generated by dts-bundle v0.7.3

declare module '@angular/animations' {
    
    
    /**
        * Defines an animation step that combines styling information with timing information.
        *
        * @param timings Sets `AnimateTimings` for the parent animation.
        * A string in the format "duration [delay] [easing]".
        *  - Duration and delay are expressed as a number and optional time unit,
        * such as "1s" or "10ms" for one second and 10 milliseconds, respectively.
        * The default unit is milliseconds.
        *  - The easing value controls how the animation accelerates and decelerates
        * during its runtime. Value is one of  `ease`, `ease-in`, `ease-out`,
        * `ease-in-out`, or a `cubic-bezier()` function call.
        * If not supplied, no easing is applied.
        *
        * For example, the string "1s 100ms ease-out" specifies a duration of
        * 1000 milliseconds, and delay of 100 ms, and the "ease-out" easing style,
        * which decelerates near the end of the duration.
        * @param styles Sets AnimationStyles for the parent animation.
        * A function call to either `style()` or `keyframes()`
        * that returns a collection of CSS style entries to be applied to the parent animation.
        * When null, uses the styles from the destination state.
        * This is useful when describing an animation step that will complete an animation;
        * see "Animating to the final state" in `transitions()`.
        * @returns An object that encapsulates the animation step.
        *
        * @usageNotes
        * Call within an animation `sequence()`, `{@link animations/group group()}`, or
        * `transition()` call to specify an animation step
        * that applies given style data to the parent animation for a given amount of time.
        *
        * ### Syntax Examples
        * **Timing examples**
        *
        * The following examples show various `timings` specifications.
        * - `animate(500)` : Duration is 500 milliseconds.
        * - `animate("1s")` : Duration is 1000 milliseconds.
        * - `animate("100ms 0.5s")` : Duration is 100 milliseconds, delay is 500 milliseconds.
        * - `animate("5s ease-in")` : Duration is 5000 milliseconds, easing in.
        * - `animate("5s 10ms cubic-bezier(.17,.67,.88,.1)")` : Duration is 5000 milliseconds, delay is 10
        * milliseconds, easing according to a bezier curve.
        *
        * **Style examples**
        *
        * The following example calls `style()` to set a single CSS style.
        * ```typescript
        * animate(500, style({ background: "red" }))
        * ```
        * The following example calls `keyframes()` to set a CSS style
        * to different values for successive keyframes.
        * ```typescript
        * animate(500, keyframes(
        *  [
        *   style({ background: "blue" }),
        *   style({ background: "red" })
        *  ])
        * ```
        *
        * @publicApi
        */
    export function animate(timings: string | number, styles?: AnimationStyleMetadata | AnimationKeyframesSequenceMetadata | null): AnimationAnimateMetadata;
    
    /**
        * Executes a queried inner animation element within an animation sequence.
        *
        * @param options An options object that can contain a delay value for the start of the
        * animation, and additional override values for developer-defined parameters.
        * @return An object that encapsulates the child animation data.
        *
        * @usageNotes
        * Each time an animation is triggered in Angular, the parent animation
        * has priority and any child animations are blocked. In order
        * for a child animation to run, the parent animation must query each of the elements
        * containing child animations, and run them using this function.
        *
        * Note that this feature is designed to be used with `query()` and it will only work
        * with animations that are assigned using the Angular animation library. CSS keyframes
        * and transitions are not handled by this API.
        *
        * @publicApi
        */
    export function animateChild(options?: AnimateChildOptions | null): AnimationAnimateChildMetadata;
    
    /**
        * Adds duration options to control animation styling and timing for a child animation.
        *
        * @see `animateChild()`
        *
        * @publicApi
        */
    export interface AnimateChildOptions extends AnimationOptions {
            duration?: number | string;
    }
    
    /**
        * Represents animation-step timing parameters for an animation step.
        * @see `animate()`
        *
        * @publicApi
        */
    export type AnimateTimings = {
            /**
                * The full duration of an animation step. A number and optional time unit,
                * such as "1s" or "10ms" for one second and 10 milliseconds, respectively.
                * The default unit is milliseconds.
                */
            duration: number;
            /**
                * The delay in applying an animation step. A number and optional time unit.
                * The default unit is milliseconds.
                */
            delay: number;
            /**
                * An easing style that controls how an animations step accelerates
                * and decelerates during its run time. An easing function such as `cubic-bezier()`,
                * or one of the following constants:
                * - `ease-in`
                * - `ease-out`
                * - `ease-in-and-out`
                */
            easing: string | null;
    };
    
    /**
        * Produces a reusable animation that can be invoked in another animation or sequence,
        * by calling the `useAnimation()` function.
        *
        * @param steps One or more animation objects, as returned by the `animate()`
        * or `sequence()` function, that form a transformation from one state to another.
        * A sequence is used by default when you pass an array.
        * @param options An options object that can contain a delay value for the start of the
        * animation, and additional developer-defined parameters.
        * Provided values for additional parameters are used as defaults,
        * and override values can be passed to the caller on invocation.
        * @returns An object that encapsulates the animation data.
        *
        * @usageNotes
        * The following example defines a reusable animation, providing some default parameter
        * values.
        *
        * ```typescript
        * var fadeAnimation = animation([
        *   style({ opacity: '{{ start }}' }),
        *   animate('{{ time }}',
        *   style({ opacity: '{{ end }}'}))
        *   ],
        *   { params: { time: '1000ms', start: 0, end: 1 }});
        * ```
        *
        * The following invokes the defined animation with a call to `useAnimation()`,
        * passing in override parameter values.
        *
        * ```js
        * useAnimation(fadeAnimation, {
        *   params: {
        *     time: '2s',
        *     start: 1,
        *     end: 0
        *   }
        * })
        * ```
        *
        * If any of the passed-in parameter values are missing from this call,
        * the default values are used. If one or more parameter values are missing before a step is
        * animated, `useAnimation()` throws an error.
        *
        * @publicApi
        */
    export function animation(steps: AnimationMetadata | AnimationMetadata[], options?: AnimationOptions | null): AnimationReferenceMetadata;
    
    /**
        * Encapsulates a child animation, that can be run explicitly when the parent is run.
        * Instantiated and returned by the `animateChild` function.
        *
        * @publicApi
        */
    export interface AnimationAnimateChildMetadata extends AnimationMetadata {
            /**
                * An options object containing a delay and
                * developer-defined parameters that provide styling defaults and
                * can be overridden on invocation. Default delay is 0.
                */
            options: AnimationOptions | null;
    }
    
    /**
        * Encapsulates an animation step. Instantiated and returned by
        * the `animate()` function.
        *
        * @publicApi
        */
    export interface AnimationAnimateMetadata extends AnimationMetadata {
            /**
                * The timing data for the step.
                */
            timings: string | number | AnimateTimings;
            /**
                * A set of styles used in the step.
                */
            styles: AnimationStyleMetadata | AnimationKeyframesSequenceMetadata | null;
    }
    
    /**
        * Encapsulates a reusable animation.
        * Instantiated and returned by the `useAnimation()` function.
        *
        * @publicApi
        */
    export interface AnimationAnimateRefMetadata extends AnimationMetadata {
            /**
                * An animation reference object.
                */
            animation: AnimationReferenceMetadata;
            /**
                * An options object containing a delay and
                * developer-defined parameters that provide styling defaults and
                * can be overridden on invocation. Default delay is 0.
                */
            options: AnimationOptions | null;
    }
    
    /**
        * An injectable service that produces an animation sequence programmatically within an
        * Angular component or directive.
        * Provided by the `BrowserAnimationsModule` or `NoopAnimationsModule`.
        *
        * @usageNotes
        *
        * To use this service, add it to your component or directive as a dependency.
        * The service is instantiated along with your component.
        *
        * Apps do not typically need to create their own animation players, but if you
        * do need to, follow these steps:
        *
        * 1. Use the <code>[AnimationBuilder.build](api/animations/AnimationBuilder#build)()</code> method
        * to create a programmatic animation. The method returns an `AnimationFactory` instance.
        *
        * 2. Use the factory object to create an `AnimationPlayer` and attach it to a DOM element.
        *
        * 3. Use the player object to control the animation programmatically.
        *
        * For example:
        *
        * ```ts
        * // import the service from BrowserAnimationsModule
        * import {AnimationBuilder} from '@angular/animations';
        * // require the service as a dependency
        * class MyCmp {
        *   constructor(private _builder: AnimationBuilder) {}
        *
        *   makeAnimation(element: any) {
        *     // first define a reusable animation
        *     const myAnimation = this._builder.build([
        *       style({ width: 0 }),
        *       animate(1000, style({ width: '100px' }))
        *     ]);
        *
        *     // use the returned factory object to create a player
        *     const player = myAnimation.create(element);
        *
        *     player.play();
        *   }
        * }
        * ```
        *
        * @publicApi
        */
    export abstract class AnimationBuilder {
            /**
                * Builds a factory for producing a defined animation.
                * @param animation A reusable animation definition.
                * @returns A factory object that can create a player for the defined animation.
                * @see `animate()`
                */
            abstract build(animation: AnimationMetadata | AnimationMetadata[]): AnimationFactory;
    }
    
    
    /**
        * An instance of this class is returned as an event parameter when an animation
        * callback is captured for an animation either during the start or done phase.
        *
        * ```typescript
        * @Component({
        *   host: {
        *     '[@myAnimationTrigger]': 'someExpression',
        *     '(@myAnimationTrigger.start)': 'captureStartEvent($event)',
        *     '(@myAnimationTrigger.done)': 'captureDoneEvent($event)',
        *   },
        *   animations: [
        *     trigger("myAnimationTrigger", [
        *        // ...
        *     ])
        *   ]
        * })
        * class MyComponent {
        *   someExpression: any = false;
        *   captureStartEvent(event: AnimationEvent) {
        *     // the toState, fromState and totalTime data is accessible from the event variable
        *   }
        *
        *   captureDoneEvent(event: AnimationEvent) {
        *     // the toState, fromState and totalTime data is accessible from the event variable
        *   }
        * }
        * ```
        *
        * @publicApi
        */
    interface AnimationEvent_2 {
            /**
                * The name of the state from which the animation is triggered.
                */
            fromState: string;
            /**
                * The name of the state in which the animation completes.
                */
            toState: string;
            /**
                * The time it takes the animation to complete, in milliseconds.
                */
            totalTime: number;
            /**
                * The animation phase in which the callback was invoked, one of
                * "start" or "done".
                */
            phaseName: string;
            /**
                * The element to which the animation is attached.
                */
            element: any;
            /**
                * Internal.
                */
            triggerName: string;
            /**
                * Internal.
                */
            disabled: boolean;
    }
    export { AnimationEvent_2 as AnimationEvent }
    
    /**
        * A factory object returned from the
        * <code>[AnimationBuilder.build](api/animations/AnimationBuilder#build)()</code>
        * method.
        *
        * @publicApi
        */
    export abstract class AnimationFactory {
            /**
                * Creates an `AnimationPlayer` instance for the reusable animation defined by
                * the <code>[AnimationBuilder.build](api/animations/AnimationBuilder#build)()</code>
                * method that created this factory and attaches the new player a DOM element.
                *
                * @param element The DOM element to which to attach the player.
                * @param options A set of options that can include a time delay and
                * additional developer-defined parameters.
                */
            abstract create(element: any, options?: AnimationOptions): AnimationPlayer;
    }
    
    /**
        * Encapsulates an animation group.
        * Instantiated and returned by the `{@link animations/group group()}` function.
        *
        * @publicApi
        */
    export interface AnimationGroupMetadata extends AnimationMetadata {
            /**
                * One or more animation or style steps that form this group.
                */
            steps: AnimationMetadata[];
            /**
                * An options object containing a delay and
                * developer-defined parameters that provide styling defaults and
                * can be overridden on invocation. Default delay is 0.
                */
            options: AnimationOptions | null;
    }
    
    /**
        * Encapsulates a keyframes sequence. Instantiated and returned by
        * the `keyframes()` function.
        *
        * @publicApi
        */
    export interface AnimationKeyframesSequenceMetadata extends AnimationMetadata {
            /**
                * An array of animation styles.
                */
            steps: AnimationStyleMetadata[];
    }
    
    /**
        * Base for animation data structures.
        *
        * @publicApi
        */
    export interface AnimationMetadata {
            type: AnimationMetadataType;
    }
    
    /**
        * @description Constants for the categories of parameters that can be defined for animations.
        *
        * A corresponding function defines a set of parameters for each category, and
        * collects them into a corresponding `AnimationMetadata` object.
        *
        * @publicApi
        */
    export const enum AnimationMetadataType {
            /**
                * Associates a named animation state with a set of CSS styles.
                * See [`state()`](api/animations/state)
                */
            State = 0,
            /**
                * Data for a transition from one animation state to another.
                * See `transition()`
                */
            Transition = 1,
            /**
                * Contains a set of animation steps.
                * See `sequence()`
                */
            Sequence = 2,
            /**
                * Contains a set of animation steps.
                * See `{@link animations/group group()}`
                */
            Group = 3,
            /**
                * Contains an animation step.
                * See `animate()`
                */
            Animate = 4,
            /**
                * Contains a set of animation steps.
                * See `keyframes()`
                */
            Keyframes = 5,
            /**
                * Contains a set of CSS property-value pairs into a named style.
                * See `style()`
                */
            Style = 6,
            /**
                * Associates an animation with an entry trigger that can be attached to an element.
                * See `trigger()`
                */
            Trigger = 7,
            /**
                * Contains a re-usable animation.
                * See `animation()`
                */
            Reference = 8,
            /**
                * Contains data to use in executing child animations returned by a query.
                * See `animateChild()`
                */
            AnimateChild = 9,
            /**
                * Contains animation parameters for a re-usable animation.
                * See `useAnimation()`
                */
            AnimateRef = 10,
            /**
                * Contains child-animation query data.
                * See `query()`
                */
            Query = 11,
            /**
                * Contains data for staggering an animation sequence.
                * See `stagger()`
                */
            Stagger = 12
    }
    
    /**
        * @description Options that control animation styling and timing.
        *
        * The following animation functions accept `AnimationOptions` data:
        *
        * - `transition()`
        * - `sequence()`
        * - `{@link animations/group group()}`
        * - `query()`
        * - `animation()`
        * - `useAnimation()`
        * - `animateChild()`
        *
        * Programmatic animations built using the `AnimationBuilder` service also
        * make use of `AnimationOptions`.
        *
        * @publicApi
        */
    export interface AnimationOptions {
            /**
                * Sets a time-delay for initiating an animation action.
                * A number and optional time unit, such as "1s" or "10ms" for one second
                * and 10 milliseconds, respectively.The default unit is milliseconds.
                * Default value is 0, meaning no delay.
                */
            delay?: number | string;
            /**
                * A set of developer-defined parameters that modify styling and timing
                * when an animation action starts. An array of key-value pairs, where the provided value
                * is used as a default.
                */
            params?: {
                    [name: string]: any;
            };
    }
    
    /**
        * Provides programmatic control of a reusable animation sequence,
        * built using the <code>[AnimationBuilder.build](api/animations/AnimationBuilder#build)()</code>
        * method which returns an `AnimationFactory`, whose
        * <code>[create](api/animations/AnimationFactory#create)()</code> method instantiates and
        * initializes this interface.
        *
        * @see `AnimationBuilder`
        * @see `AnimationFactory`
        * @see `animate()`
        *
        * @publicApi
        */
    export interface AnimationPlayer {
            /**
                * Provides a callback to invoke when the animation finishes.
                * @param fn The callback function.
                * @see `finish()`
                */
            onDone(fn: () => void): void;
            /**
                * Provides a callback to invoke when the animation starts.
                * @param fn The callback function.
                * @see `run()`
                */
            onStart(fn: () => void): void;
            /**
                * Provides a callback to invoke after the animation is destroyed.
                * @param fn The callback function.
                * @see `destroy()`
                * @see `beforeDestroy()`
                */
            onDestroy(fn: () => void): void;
            /**
                * Initializes the animation.
                */
            init(): void;
            /**
                * Reports whether the animation has started.
                * @returns True if the animation has started, false otherwise.
                */
            hasStarted(): boolean;
            /**
                * Runs the animation, invoking the `onStart()` callback.
                */
            play(): void;
            /**
                * Pauses the animation.
                */
            pause(): void;
            /**
                * Restarts the paused animation.
                */
            restart(): void;
            /**
                * Ends the animation, invoking the `onDone()` callback.
                */
            finish(): void;
            /**
                * Destroys the animation, after invoking the `beforeDestroy()` callback.
                * Calls the `onDestroy()` callback when destruction is completed.
                */
            destroy(): void;
            /**
                * Resets the animation to its initial state.
                */
            reset(): void;
            /**
                * Sets the position of the animation.
                * @param position A 0-based offset into the duration, in milliseconds.
                */
            setPosition(position: any /** TODO #9100 */): void;
            /**
                * Reports the current position of the animation.
                * @returns A 0-based offset into the duration, in milliseconds.
                */
            getPosition(): number;
            /**
                * The parent of this player, if any.
                */
            parentPlayer: AnimationPlayer | null;
            /**
                * The total run time of the animation, in milliseconds.
                */
            readonly totalTime: number;
            /**
                * Provides a callback to invoke before the animation is destroyed.
                */
            beforeDestroy?: () => any;
    }
    
    /**
        * Encapsulates an animation query. Instantiated and returned by
        * the `query()` function.
        *
        * @publicApi
        */
    export interface AnimationQueryMetadata extends AnimationMetadata {
            /**
                *  The CSS selector for this query.
                */
            selector: string;
            /**
                * One or more animation step objects.
                */
            animation: AnimationMetadata | AnimationMetadata[];
            /**
                * A query options object.
                */
            options: AnimationQueryOptions | null;
    }
    
    /**
        * Encapsulates animation query options.
        * Passed to the `query()` function.
        *
        * @publicApi
        */
    export interface AnimationQueryOptions extends AnimationOptions {
            /**
                * True if this query is optional, false if it is required. Default is false.
                * A required query throws an error if no elements are retrieved when
                * the query is executed. An optional query does not.
                *
                */
            optional?: boolean;
            /**
                * A maximum total number of results to return from the query.
                * If negative, results are limited from the end of the query list towards the beginning.
                * By default, results are not limited.
                */
            limit?: number;
    }
    
    /**
        * Encapsulates a reusable animation, which is a collection of individual animation steps.
        * Instantiated and returned by the `animation()` function, and
        * passed to the `useAnimation()` function.
        *
        * @publicApi
        */
    export interface AnimationReferenceMetadata extends AnimationMetadata {
            /**
                *  One or more animation step objects.
                */
            animation: AnimationMetadata | AnimationMetadata[];
            /**
                * An options object containing a delay and
                * developer-defined parameters that provide styling defaults and
                * can be overridden on invocation. Default delay is 0.
                */
            options: AnimationOptions | null;
    }
    
    /**
        * Encapsulates an animation sequence.
        * Instantiated and returned by the `sequence()` function.
        *
        * @publicApi
        */
    export interface AnimationSequenceMetadata extends AnimationMetadata {
            /**
                *  An array of animation step objects.
                */
            steps: AnimationMetadata[];
            /**
                * An options object containing a delay and
                * developer-defined parameters that provide styling defaults and
                * can be overridden on invocation. Default delay is 0.
                */
            options: AnimationOptions | null;
    }
    
    /**
        * Encapsulates parameters for staggering the start times of a set of animation steps.
        * Instantiated and returned by the `stagger()` function.
        *
        * @publicApi
        **/
    export interface AnimationStaggerMetadata extends AnimationMetadata {
            /**
                * The timing data for the steps.
                */
            timings: string | number;
            /**
                * One or more animation steps.
                */
            animation: AnimationMetadata | AnimationMetadata[];
    }
    
    /**
        * Encapsulates an animation state by associating a state name with a set of CSS styles.
        * Instantiated and returned by the [`state()`](api/animations/state) function.
        *
        * @publicApi
        */
    export interface AnimationStateMetadata extends AnimationMetadata {
            /**
                * The state name, unique within the component.
                */
            name: string;
            /**
                *  The CSS styles associated with this state.
                */
            styles: AnimationStyleMetadata;
            /**
                * An options object containing
                * developer-defined parameters that provide styling defaults and
                * can be overridden on invocation.
                */
            options?: {
                    params: {
                            [name: string]: any;
                    };
            };
    }
    
    /**
        * Encapsulates an animation style. Instantiated and returned by
        * the `style()` function.
        *
        * @publicApi
        */
    export interface AnimationStyleMetadata extends AnimationMetadata {
            /**
                * A set of CSS style properties.
                */
            styles: '*' | {
                    [key: string]: string | number;
            } | Array<{
                    [key: string]: string | number;
            } | '*'>;
            /**
                * A percentage of the total animate time at which the style is to be applied.
                */
            offset: number | null;
    }
    
    /**
        * Encapsulates an animation transition. Instantiated and returned by the
        * `transition()` function.
        *
        * @publicApi
        */
    export interface AnimationTransitionMetadata extends AnimationMetadata {
            /**
                * An expression that describes a state change.
                */
            expr: string | ((fromState: string, toState: string, element?: any, params?: {
                    [key: string]: any;
            }) => boolean);
            /**
                * One or more animation objects to which this transition applies.
                */
            animation: AnimationMetadata | AnimationMetadata[];
            /**
                * An options object containing a delay and
                * developer-defined parameters that provide styling defaults and
                * can be overridden on invocation. Default delay is 0.
                */
            options: AnimationOptions | null;
    }
    
    /**
        * Contains an animation trigger. Instantiated and returned by the
        * `trigger()` function.
        *
        * @publicApi
        */
    export interface AnimationTriggerMetadata extends AnimationMetadata {
            /**
                * The trigger name, used to associate it with an element. Unique within the component.
                */
            name: string;
            /**
                * An animation definition object, containing an array of state and transition declarations.
                */
            definitions: AnimationMetadata[];
            /**
                * An options object containing a delay and
                * developer-defined parameters that provide styling defaults and
                * can be overridden on invocation. Default delay is 0.
                */
            options: {
                    params?: {
                            [name: string]: any;
                    };
            } | null;
    }
    
    /**
        * Specifies automatic styling.
        *
        * @publicApi
        */
    export const AUTO_STYLE = "*";
    
    /**
        * @description Defines a list of animation steps to be run in parallel.
        *
        * @param steps An array of animation step objects.
        * - When steps are defined by `style()` or `animate()`
        * function calls, each call within the group is executed instantly.
        * - To specify offset styles to be applied at a later time, define steps with
        * `keyframes()`, or use `animate()` calls with a delay value.
        * For example:
        *
        * ```typescript
        * group([
        *   animate("1s", style({ background: "black" })),
        *   animate("2s", style({ color: "white" }))
        * ])
        * ```
        *
        * @param options An options object containing a delay and
        * developer-defined parameters that provide styling defaults and
        * can be overridden on invocation.
        *
        * @return An object that encapsulates the group data.
        *
        * @usageNotes
        * Grouped animations are useful when a series of styles must be
        * animated at different starting times and closed off at different ending times.
        *
        * When called within a `sequence()` or a
        * `transition()` call, does not continue to the next
        * instruction until all of the inner animation steps have completed.
        *
        * @publicApi
        */
    export function group(steps: AnimationMetadata[], options?: AnimationOptions | null): AnimationGroupMetadata;
    
    /**
        * Defines a set of animation styles, associating each style with an optional `offset` value.
        *
        * @param steps A set of animation styles with optional offset data.
        * The optional `offset` value for a style specifies a percentage of the total animation
        * time at which that style is applied.
        * @returns An object that encapsulates the keyframes data.
        *
        * @usageNotes
        * Use with the `animate()` call. Instead of applying animations
        * from the current state
        * to the destination state, keyframes describe how each style entry is applied and at what point
        * within the animation arc.
        * Compare [CSS Keyframe Animations](https://www.w3schools.com/css/css3_animations.asp).
        *
        * ### Usage
        *
        * In the following example, the offset values describe
        * when each `backgroundColor` value is applied. The color is red at the start, and changes to
        * blue when 20% of the total time has elapsed.
        *
        * ```typescript
        * // the provided offset values
        * animate("5s", keyframes([
        *   style({ backgroundColor: "red", offset: 0 }),
        *   style({ backgroundColor: "blue", offset: 0.2 }),
        *   style({ backgroundColor: "orange", offset: 0.3 }),
        *   style({ backgroundColor: "black", offset: 1 })
        * ]))
        * ```
        *
        * If there are no `offset` values specified in the style entries, the offsets
        * are calculated automatically.
        *
        * ```typescript
        * animate("5s", keyframes([
        *   style({ backgroundColor: "red" }) // offset = 0
        *   style({ backgroundColor: "blue" }) // offset = 0.33
        *   style({ backgroundColor: "orange" }) // offset = 0.66
        *   style({ backgroundColor: "black" }) // offset = 1
        * ]))
        *```
    
        * @publicApi
        */
    export function keyframes(steps: AnimationStyleMetadata[]): AnimationKeyframesSequenceMetadata;
    
    /**
        * An empty programmatic controller for reusable animations.
        * Used internally when animations are disabled, to avoid
        * checking for the null case when an animation player is expected.
        *
        * @see `animate()`
        * @see `AnimationPlayer`
        * @see `GroupPlayer`
        *
        * @publicApi
        */
    export class NoopAnimationPlayer implements AnimationPlayer {
            parentPlayer: AnimationPlayer | null;
            readonly totalTime: number;
            constructor(duration?: number, delay?: number);
            onStart(fn: () => void): void;
            onDone(fn: () => void): void;
            onDestroy(fn: () => void): void;
            hasStarted(): boolean;
            init(): void;
            play(): void;
            pause(): void;
            restart(): void;
            finish(): void;
            destroy(): void;
            reset(): void;
            setPosition(position: number): void;
            getPosition(): number;
    }
    
    /**
        * Finds one or more inner elements within the current element that is
        * being animated within a sequence. Use with `animate()`.
        *
        * @param selector The element to query, or a set of elements that contain Angular-specific
        * characteristics, specified with one or more of the following tokens.
        *  - `query(":enter")` or `query(":leave")` : Query for newly inserted/removed elements (not
        *     all elements can be queried via these tokens, see
        *     [Entering and Leaving Elements](#entering-and-leaving-elements))
        *  - `query(":animating")` : Query all currently animating elements.
        *  - `query("@triggerName")` : Query elements that contain an animation trigger.
        *  - `query("@*")` : Query all elements that contain an animation triggers.
        *  - `query(":self")` : Include the current element into the animation sequence.
        *
        * @param animation One or more animation steps to apply to the queried element or elements.
        * An array is treated as an animation sequence.
        * @param options An options object. Use the 'limit' field to limit the total number of
        * items to collect.
        * @return An object that encapsulates the query data.
        *
        * @usageNotes
        *
        * ### Multiple Tokens
        *
        * Tokens can be merged into a combined query selector string. For example:
        *
        * ```typescript
        *  query(':self, .record:enter, .record:leave, @subTrigger', [...])
        * ```
        *
        * The `query()` function collects multiple elements and works internally by using
        * `element.querySelectorAll`. Use the `limit` field of an options object to limit
        * the total number of items to be collected. For example:
        *
        * ```js
        * query('div', [
        *   animate(...),
        *   animate(...)
        * ], { limit: 1 })
        * ```
        *
        * By default, throws an error when zero items are found. Set the
        * `optional` flag to ignore this error. For example:
        *
        * ```js
        * query('.some-element-that-may-not-be-there', [
        *   animate(...),
        *   animate(...)
        * ], { optional: true })
        * ```
        *
        * ### Entering and Leaving Elements
        *
        * Not all elements can be queried via the `:enter` and `:leave` tokens, the only ones
        * that can are those that Angular assumes can enter/leave based on their own logic
        * (if their insertion/removal is simply a consequence of that of their parent they
        * should be queried via a different token in their parent's `:enter`/`:leave` transitions).
        *
        * The only elements Angular assumes can enter/leave based on their own logic (thus the only
        * ones that can be queried via the `:enter` and `:leave` tokens) are:
        *  - Those inserted dynamically (via `ViewContainerRef`)
        *  - Those that have a structural directive (which, under the hood, are a subset of the above ones)
        *
        * <div class="alert is-helpful">
        *
        *  Note that elements will be successfully queried via `:enter`/`:leave` even if their
        *  insertion/removal is not done manually via `ViewContainerRef`or caused by their structural
        *  directive (e.g. they enter/exit alongside their parent).
        *
        * </div>
        *
        * <div class="alert is-important">
        *
        *  There is an exception to what previously mentioned, besides elements entering/leaving based on
        *  their own logic, elements with an animation trigger can always be queried via `:leave` when
        * their parent is also leaving.
        *
        * </div>
        *
        * ### Usage Example
        *
        * The following example queries for inner elements and animates them
        * individually using `animate()`.
        *
        * ```typescript
        * @Component({
        *   selector: 'inner',
        *   template: `
        *     <div [@queryAnimation]="exp">
        *       <h1>Title</h1>
        *       <div class="content">
        *         Blah blah blah
        *       </div>
        *     </div>
        *   `,
        *   animations: [
        *    trigger('queryAnimation', [
        *      transition('* => goAnimate', [
        *        // hide the inner elements
        *        query('h1', style({ opacity: 0 })),
        *        query('.content', style({ opacity: 0 })),
        *
        *        // animate the inner elements in, one by one
        *        query('h1', animate(1000, style({ opacity: 1 }))),
        *        query('.content', animate(1000, style({ opacity: 1 }))),
        *      ])
        *    ])
        *  ]
        * })
        * class Cmp {
        *   exp = '';
        *
        *   goAnimate() {
        *     this.exp = 'goAnimate';
        *   }
        * }
        * ```
        *
        * @publicApi
        */
    export function query(selector: string, animation: AnimationMetadata | AnimationMetadata[], options?: AnimationQueryOptions | null): AnimationQueryMetadata;
    
    /**
        * Defines a list of animation steps to be run sequentially, one by one.
        *
        * @param steps An array of animation step objects.
        * - Steps defined by `style()` calls apply the styling data immediately.
        * - Steps defined by `animate()` calls apply the styling data over time
        *   as specified by the timing data.
        *
        * ```typescript
        * sequence([
        *   style({ opacity: 0 }),
        *   animate("1s", style({ opacity: 1 }))
        * ])
        * ```
        *
        * @param options An options object containing a delay and
        * developer-defined parameters that provide styling defaults and
        * can be overridden on invocation.
        *
        * @return An object that encapsulates the sequence data.
        *
        * @usageNotes
        * When you pass an array of steps to a
        * `transition()` call, the steps run sequentially by default.
        * Compare this to the `{@link animations/group group()}` call, which runs animation steps in
        *parallel.
        *
        * When a sequence is used within a `{@link animations/group group()}` or a `transition()` call,
        * execution continues to the next instruction only after each of the inner animation
        * steps have completed.
        *
        * @publicApi
        **/
    export function sequence(steps: AnimationMetadata[], options?: AnimationOptions | null): AnimationSequenceMetadata;
    
    /**
        * Use within an animation `query()` call to issue a timing gap after
        * each queried item is animated.
        *
        * @param timings A delay value.
        * @param animation One ore more animation steps.
        * @returns An object that encapsulates the stagger data.
        *
        * @usageNotes
        * In the following example, a container element wraps a list of items stamped out
        * by an `ngFor`. The container element contains an animation trigger that will later be set
        * to query for each of the inner items.
        *
        * Each time items are added, the opacity fade-in animation runs,
        * and each removed item is faded out.
        * When either of these animations occur, the stagger effect is
        * applied after each item's animation is started.
        *
        * ```html
        * <!-- list.component.html -->
        * <button (click)="toggle()">Show / Hide Items</button>
        * <hr />
        * <div [@listAnimation]="items.length">
        *   <div *ngFor="let item of items">
        *     {{ item }}
        *   </div>
        * </div>
        * ```
        *
        * Here is the component code:
        *
        * ```typescript
        * import {trigger, transition, style, animate, query, stagger} from '@angular/animations';
        * @Component({
        *   templateUrl: 'list.component.html',
        *   animations: [
        *     trigger('listAnimation', [
        *     ...
        *     ])
        *   ]
        * })
        * class ListComponent {
        *   items = [];
        *
        *   showItems() {
        *     this.items = [0,1,2,3,4];
        *   }
        *
        *   hideItems() {
        *     this.items = [];
        *   }
        *
        *   toggle() {
        *     this.items.length ? this.hideItems() : this.showItems();
        *    }
        *  }
        * ```
        *
        * Here is the animation trigger code:
        *
        * ```typescript
        * trigger('listAnimation', [
        *   transition('* => *', [ // each time the binding value changes
        *     query(':leave', [
        *       stagger(100, [
        *         animate('0.5s', style({ opacity: 0 }))
        *       ])
        *     ]),
        *     query(':enter', [
        *       style({ opacity: 0 }),
        *       stagger(100, [
        *         animate('0.5s', style({ opacity: 1 }))
        *       ])
        *     ])
        *   ])
        * ])
        * ```
        *
        * @publicApi
        */
    export function stagger(timings: string | number, animation: AnimationMetadata | AnimationMetadata[]): AnimationStaggerMetadata;
    
    /**
        * Declares an animation state within a trigger attached to an element.
        *
        * @param name One or more names for the defined state in a comma-separated string.
        * The following reserved state names can be supplied to define a style for specific use
        * cases:
        *
        * - `void` You can associate styles with this name to be used when
        * the element is detached from the application. For example, when an `ngIf` evaluates
        * to false, the state of the associated element is void.
        *  - `*` (asterisk) Indicates the default state. You can associate styles with this name
        * to be used as the fallback when the state that is being animated is not declared
        * within the trigger.
        *
        * @param styles A set of CSS styles associated with this state, created using the
        * `style()` function.
        * This set of styles persists on the element once the state has been reached.
        * @param options Parameters that can be passed to the state when it is invoked.
        * 0 or more key-value pairs.
        * @return An object that encapsulates the new state data.
        *
        * @usageNotes
        * Use the `trigger()` function to register states to an animation trigger.
        * Use the `transition()` function to animate between states.
        * When a state is active within a component, its associated styles persist on the element,
        * even when the animation ends.
        *
        * @publicApi
        **/
    export function state(name: string, styles: AnimationStyleMetadata, options?: {
            params: {
                    [name: string]: any;
            };
    }): AnimationStateMetadata;
    
    /**
        * Declares a key/value object containing CSS properties/styles that
        * can then be used for an animation [`state`](api/animations/state), within an animation
        *`sequence`, or as styling data for calls to `animate()` and `keyframes()`.
        *
        * @param tokens A set of CSS styles or HTML styles associated with an animation state.
        * The value can be any of the following:
        * - A key-value style pair associating a CSS property with a value.
        * - An array of key-value style pairs.
        * - An asterisk (*), to use auto-styling, where styles are derived from the element
        * being animated and applied to the animation when it starts.
        *
        * Auto-styling can be used to define a state that depends on layout or other
        * environmental factors.
        *
        * @return An object that encapsulates the style data.
        *
        * @usageNotes
        * The following examples create animation styles that collect a set of
        * CSS property values:
        *
        * ```typescript
        * // string values for CSS properties
        * style({ background: "red", color: "blue" })
        *
        * // numerical pixel values
        * style({ width: 100, height: 0 })
        * ```
        *
        * The following example uses auto-styling to allow an element to animate from
        * a height of 0 up to its full height:
        *
        * ```
        * style({ height: 0 }),
        * animate("1s", style({ height: "*" }))
        * ```
        *
        * @publicApi
        **/
    export function style(tokens: '*' | {
            [key: string]: string | number;
    } | Array<'*' | {
            [key: string]: string | number;
    }>): AnimationStyleMetadata;
    
    /**
        * Declares an animation transition which is played when a certain specified condition is met.
        *
        * @param stateChangeExpr A string with a specific format or a function that specifies when the
        * animation transition should occur (see [State Change Expression](#state-change-expression)).
        *
        * @param steps One or more animation objects that represent the animation's instructions.
        *
        * @param options An options object that can be used to specify a delay for the animation or provide
        * custom parameters for it.
        *
        * @returns An object that encapsulates the transition data.
        *
        * @usageNotes
        *
        * ### State Change Expression
        *
        * The State Change Expression instructs Angular when to run the transition's animations, it can
        *either be
        *  - a string with a specific syntax
        *  - or a function that compares the previous and current state (value of the expression bound to
        *    the element's trigger) and returns `true` if the transition should occur or `false` otherwise
        *
        * The string format can be:
        *  - `fromState => toState`, which indicates that the transition's animations should occur then the
        *    expression bound to the trigger's element goes from `fromState` to `toState`
        *
        *    _Example:_
        *      ```typescript
        *        transition('open => closed', animate('.5s ease-out', style({ height: 0 }) ))
        *      ```
        *
        *  - `fromState <=> toState`, which indicates that the transition's animations should occur then
        *    the expression bound to the trigger's element goes from `fromState` to `toState` or vice versa
        *
        *    _Example:_
        *      ```typescript
        *        transition('enabled <=> disabled', animate('1s cubic-bezier(0.8,0.3,0,1)'))
        *      ```
        *
        *  - `:enter`/`:leave`, which indicates that the transition's animations should occur when the
        *    element enters or exists the DOM
        *
        *    _Example:_
        *      ```typescript
        *        transition(':enter', [
        *          style({ opacity: 0 }),
        *          animate('500ms', style({ opacity: 1 }))
        *        ])
        *      ```
        *
        *  - `:increment`/`:decrement`, which indicates that the transition's animations should occur when
        *    the numerical expression bound to the trigger's element has increased in value or decreased
        *
        *    _Example:_
        *      ```typescript
        *        transition(':increment', query('@counter', animateChild()))
        *      ```
        *
        *  - a sequence of any of the above divided by commas, which indicates that transition's animations
        *    should occur whenever one of the state change expressions matches
        *
        *    _Example:_
        *      ```typescript
        *        transition(':increment, * => enabled, :enter', animate('1s ease', keyframes([
        *          style({ transform: 'scale(1)', offset: 0}),
        *          style({ transform: 'scale(1.1)', offset: 0.7}),
        *          style({ transform: 'scale(1)', offset: 1})
        *        ]))),
        *      ```
        *
        * Also note that in such context:
        *  - `void` can be used to indicate the absence of the element
        *  - asterisks can be used as wildcards that match any state
        *  - (as a consequence of the above, `void => *` is equivalent to `:enter` and `* => void` is
        *    equivalent to `:leave`)
        *  - `true` and `false` also match expression values of `1` and `0` respectively (but do not match
        *    _truthy_ and _falsy_ values)
        *
        * <div class="alert is-helpful">
        *
        *  Be careful about entering end leaving elements as their transitions present a common
        *  pitfall for developers.
        *
        *  Note that when an element with a trigger enters the DOM its `:enter` transition always
        *  gets executed, but its `:leave` transition will not be executed if the element is removed
        *  alongside its parent (as it will be removed "without warning" before its transition has
        *  a chance to be executed, the only way that such transition can occur is if the element
        *  is exiting the DOM on its own).
        *
        *
        * </div>
        *
        * ### Animating to a Final State
        *
        * If the final step in a transition is a call to `animate()` that uses a timing value
        * with no `style` data, that step is automatically considered the final animation arc,
        * for the element to reach the final state, in such case Angular automatically adds or removes
        * CSS styles to ensure that the element is in the correct final state.
        *
        *
        * ### Usage Examples
        *
        *  - Transition animations applied based on
        *    the trigger's expression value
        *
        *   ```HTML
        *   <div [@myAnimationTrigger]="myStatusExp">
        *    ...
        *   </div>
        *   ```
        *
        *   ```typescript
        *   trigger("myAnimationTrigger", [
        *     ..., // states
        *     transition("on => off, open => closed", animate(500)),
        *     transition("* <=> error", query('.indicator', animateChild()))
        *   ])
        *   ```
        *
        *  - Transition animations applied based on custom logic dependent
        *    on the trigger's expression value and provided parameters
        *
        *    ```HTML
        *    <div [@myAnimationTrigger]="{
        *     value: stepName,
        *     params: { target: currentTarget }
        *    }">
        *     ...
        *    </div>
        *    ```
        *
        *    ```typescript
        *    trigger("myAnimationTrigger", [
        *      ..., // states
        *      transition(
        *        (fromState, toState, _element, params) =>
        *          ['firststep', 'laststep'].includes(fromState.toLowerCase())
        *          && toState === params?.['target'],
        *        animate('1s')
        *      )
        *    ])
        *    ```
        *
        * @publicApi
        **/
    export function transition(stateChangeExpr: string | ((fromState: string, toState: string, element?: any, params?: {
            [key: string]: any;
    }) => boolean), steps: AnimationMetadata | AnimationMetadata[], options?: AnimationOptions | null): AnimationTransitionMetadata;
    
    /**
        * Creates a named animation trigger, containing a  list of [`state()`](api/animations/state)
        * and `transition()` entries to be evaluated when the expression
        * bound to the trigger changes.
        *
        * @param name An identifying string.
        * @param definitions  An animation definition object, containing an array of
        * [`state()`](api/animations/state) and `transition()` declarations.
        *
        * @return An object that encapsulates the trigger data.
        *
        * @usageNotes
        * Define an animation trigger in the `animations` section of `@Component` metadata.
        * In the template, reference the trigger by name and bind it to a trigger expression that
        * evaluates to a defined animation state, using the following format:
        *
        * `[@triggerName]="expression"`
        *
        * Animation trigger bindings convert all values to strings, and then match the
        * previous and current values against any linked transitions.
        * Booleans can be specified as `1` or `true` and `0` or `false`.
        *
        * ### Usage Example
        *
        * The following example creates an animation trigger reference based on the provided
        * name value.
        * The provided animation value is expected to be an array consisting of state and
        * transition declarations.
        *
        * ```typescript
        * @Component({
        *   selector: "my-component",
        *   templateUrl: "my-component-tpl.html",
        *   animations: [
        *     trigger("myAnimationTrigger", [
        *       state(...),
        *       state(...),
        *       transition(...),
        *       transition(...)
        *     ])
        *   ]
        * })
        * class MyComponent {
        *   myStatusExp = "something";
        * }
        * ```
        *
        * The template associated with this component makes use of the defined trigger
        * by binding to an element within its template code.
        *
        * ```html
        * <!-- somewhere inside of my-component-tpl.html -->
        * <div [@myAnimationTrigger]="myStatusExp">...</div>
        * ```
        *
        * ### Using an inline function
        * The `transition` animation method also supports reading an inline function which can decide
        * if its associated animation should be run.
        *
        * ```typescript
        * // this method is run each time the `myAnimationTrigger` trigger value changes.
        * function myInlineMatcherFn(fromState: string, toState: string, element: any, params: {[key:
     string]: any}): boolean {
        *   // notice that `element` and `params` are also available here
        *   return toState == 'yes-please-animate';
        * }
        *
        * @Component({
        *   selector: 'my-component',
        *   templateUrl: 'my-component-tpl.html',
        *   animations: [
        *     trigger('myAnimationTrigger', [
        *       transition(myInlineMatcherFn, [
        *         // the animation sequence code
        *       ]),
        *     ])
        *   ]
        * })
        * class MyComponent {
        *   myStatusExp = "yes-please-animate";
        * }
        * ```
        *
        * ### Disabling Animations
        * When true, the special animation control binding `@.disabled` binding prevents
        * all animations from rendering.
        * Place the  `@.disabled` binding on an element to disable
        * animations on the element itself, as well as any inner animation triggers
        * within the element.
        *
        * The following example shows how to use this feature:
        *
        * ```typescript
        * @Component({
        *   selector: 'my-component',
        *   template: `
        *     <div [@.disabled]="isDisabled">
        *       <div [@childAnimation]="exp"></div>
        *     </div>
        *   `,
        *   animations: [
        *     trigger("childAnimation", [
        *       // ...
        *     ])
        *   ]
        * })
        * class MyComponent {
        *   isDisabled = true;
        *   exp = '...';
        * }
        * ```
        *
        * When `@.disabled` is true, it prevents the `@childAnimation` trigger from animating,
        * along with any inner animations.
        *
        * ### Disable animations application-wide
        * When an area of the template is set to have animations disabled,
        * **all** inner components have their animations disabled as well.
        * This means that you can disable all animations for an app
        * by placing a host binding set on `@.disabled` on the topmost Angular component.
        *
        * ```typescript
        * import {Component, HostBinding} from '@angular/core';
        *
        * @Component({
        *   selector: 'app-component',
        *   templateUrl: 'app.component.html',
        * })
        * class AppComponent {
        *   @HostBinding('@.disabled')
        *   public animationsDisabled = true;
        * }
        * ```
        *
        * ### Overriding disablement of inner animations
        * Despite inner animations being disabled, a parent animation can `query()`
        * for inner elements located in disabled areas of the template and still animate
        * them if needed. This is also the case for when a sub animation is
        * queried by a parent and then later animated using `animateChild()`.
        *
        * ### Detecting when an animation is disabled
        * If a region of the DOM (or the entire application) has its animations disabled, the animation
        * trigger callbacks still fire, but for zero seconds. When the callback fires, it provides
        * an instance of an `AnimationEvent`. If animations are disabled,
        * the `.disabled` flag on the event is true.
        *
        * @publicApi
        */
    export function trigger(name: string, definitions: AnimationMetadata[]): AnimationTriggerMetadata;
    
    /**
        * Starts a reusable animation that is created using the `animation()` function.
        *
        * @param animation The reusable animation to start.
        * @param options An options object that can contain a delay value for the start of
        * the animation, and additional override values for developer-defined parameters.
        * @return An object that contains the animation parameters.
        *
        * @publicApi
        */
    export function useAnimation(animation: AnimationReferenceMetadata, options?: AnimationOptions | null): AnimationAnimateRefMetadata;
    
    /**
        * A programmatic controller for a group of reusable animations.
        * Used internally to control animations.
        *
        * @see `AnimationPlayer`
        * @see `{@link animations/group group()}`
        *
        */
    export class ɵAnimationGroupPlayer implements AnimationPlayer {
            parentPlayer: AnimationPlayer | null;
            totalTime: number;
            readonly players: AnimationPlayer[];
            constructor(_players: AnimationPlayer[]);
            init(): void;
            onStart(fn: () => void): void;
            onDone(fn: () => void): void;
            onDestroy(fn: () => void): void;
            hasStarted(): boolean;
            play(): void;
            pause(): void;
            restart(): void;
            finish(): void;
            destroy(): void;
            reset(): void;
            setPosition(p: number): void;
            getPosition(): number;
            beforeDestroy(): void;
    }
    
    export const ɵPRE_STYLE = "!";
    
    
    /**
        * Represents a set of CSS styles for use in an animation style as a generic.
        */
    export interface ɵStyleData {
            [key: string]: string | number;
    }
    
    /**
        * Represents a set of CSS styles for use in an animation style as a Map.
        */
    export type ɵStyleDataMap = Map<string, string | number>;
    
    export { }
}

// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../../../../@angular/core

declare module '@angular/cdk' {
    import { Version } from '@angular/core';
    
    /** Current version of the Angular Component Development Kit. */
    export const VERSION: Version;
    
    export { }
}

// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../../../../@angular/core
//   ../../../../../rxjs

declare module '@angular/common' {
    
    
    /**
        * @license Angular v15.2.10
        * (c) 2010-2022 Google LLC. https://angular.io/
        * License: MIT
        */
    import { ChangeDetectorRef } from '@angular/core';
    import { DoCheck } from '@angular/core';
    import { ElementRef } from '@angular/core';
    import * as i0 from '@angular/core';
    import { InjectionToken } from '@angular/core';
    import { Injector } from '@angular/core';
    import { IterableDiffers } from '@angular/core';
    import { KeyValueDiffers } from '@angular/core';
    import { NgIterable } from '@angular/core';
    import { NgModuleFactory } from '@angular/core';
    import { Observable } from 'rxjs';
    import { OnChanges } from '@angular/core';
    import { OnDestroy } from '@angular/core';
    import { OnInit } from '@angular/core';
    import { PipeTransform } from '@angular/core';
    import { Provider } from '@angular/core';
    import { Renderer2 } from '@angular/core';
    import { SimpleChanges } from '@angular/core';
    import { Subscribable } from 'rxjs';
    import { SubscriptionLike } from 'rxjs';
    import { TemplateRef } from '@angular/core';
    import { TrackByFunction } from '@angular/core';
    import { Type } from '@angular/core';
    import { Version } from '@angular/core';
    import { ViewContainerRef } from '@angular/core';
    
    /**
        * A predefined [DI token](guide/glossary#di-token) for the base href
        * to be used with the `PathLocationStrategy`.
        * The base href is the URL prefix that should be preserved when generating
        * and recognizing URLs.
        *
        * @usageNotes
        *
        * The following example shows how to use this token to configure the root app injector
        * with a base href value, so that the DI framework can supply the dependency anywhere in the app.
        *
        * ```typescript
        * import {Component, NgModule} from '@angular/core';
        * import {APP_BASE_HREF} from '@angular/common';
        *
        * @NgModule({
        *   providers: [{provide: APP_BASE_HREF, useValue: '/my/app'}]
        * })
        * class AppModule {}
        * ```
        *
        * @publicApi
        */
    export const APP_BASE_HREF: InjectionToken<string>;
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Unwraps a value from an asynchronous primitive.
        *
        * The `async` pipe subscribes to an `Observable` or `Promise` and returns the latest value it has
        * emitted. When a new value is emitted, the `async` pipe marks the component to be checked for
        * changes. When the component gets destroyed, the `async` pipe unsubscribes automatically to avoid
        * potential memory leaks. When the reference of the expression changes, the `async` pipe
        * automatically unsubscribes from the old `Observable` or `Promise` and subscribes to the new one.
        *
        * @usageNotes
        *
        * ### Examples
        *
        * This example binds a `Promise` to the view. Clicking the `Resolve` button resolves the
        * promise.
        *
        * {@example common/pipes/ts/async_pipe.ts region='AsyncPipePromise'}
        *
        * It's also possible to use `async` with Observables. The example below binds the `time` Observable
        * to the view. The Observable continuously updates the view with the current time.
        *
        * {@example common/pipes/ts/async_pipe.ts region='AsyncPipeObservable'}
        *
        * @publicApi
        */
    export class AsyncPipe implements OnDestroy, PipeTransform {
            constructor(ref: ChangeDetectorRef);
            ngOnDestroy(): void;
            transform<T>(obj: Observable<T> | Subscribable<T> | Promise<T>): T | null;
            transform<T>(obj: null | undefined): null;
            transform<T>(obj: Observable<T> | Subscribable<T> | Promise<T> | null | undefined): T | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<AsyncPipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<AsyncPipe, "async", true>;
    }
    
    /**
        * `PlatformLocation` encapsulates all of the direct calls to platform APIs.
        * This class should not be used directly by an application developer. Instead, use
        * {@link Location}.
        *
        * @publicApi
        */
    export class BrowserPlatformLocation extends PlatformLocation {
            constructor(_doc: any);
            getBaseHrefFromDOM(): string;
            onPopState(fn: LocationChangeListener): VoidFunction;
            onHashChange(fn: LocationChangeListener): VoidFunction;
            get href(): string;
            get protocol(): string;
            get hostname(): string;
            get port(): string;
            get pathname(): string;
            get search(): string;
            get hash(): string;
            set pathname(newPath: string);
            pushState(state: any, title: string, url: string): void;
            replaceState(state: any, title: string, url: string): void;
            forward(): void;
            back(): void;
            historyGo(relativePosition?: number): void;
            getState(): unknown;
            static ɵfac: i0.ɵɵFactoryDeclaration<BrowserPlatformLocation, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<BrowserPlatformLocation>;
    }
    
    /**
        * Exports all the basic Angular directives and pipes,
        * such as `NgIf`, `NgForOf`, `DecimalPipe`, and so on.
        * Re-exported by `BrowserModule`, which is included automatically in the root
        * `AppModule` when you create a new app with the CLI `new` command.
        *
        * @publicApi
        */
    export class CommonModule {
            static ɵfac: i0.ɵɵFactoryDeclaration<CommonModule, never>;
            static ɵmod: i0.ɵɵNgModuleDeclaration<CommonModule, never, [typeof i1.NgClass, typeof i2.NgComponentOutlet, typeof i3.NgForOf, typeof i4.NgIf, typeof i5.NgTemplateOutlet, typeof i6.NgStyle, typeof i7.NgSwitch, typeof i7.NgSwitchCase, typeof i7.NgSwitchDefault, typeof i8.NgPlural, typeof i8.NgPluralCase, typeof i9.AsyncPipe, typeof i10.UpperCasePipe, typeof i10.LowerCasePipe, typeof i11.JsonPipe, typeof i12.SlicePipe, typeof i13.DecimalPipe, typeof i13.PercentPipe, typeof i10.TitleCasePipe, typeof i13.CurrencyPipe, typeof i14.DatePipe, typeof i15.I18nPluralPipe, typeof i16.I18nSelectPipe, typeof i17.KeyValuePipe], [typeof i1.NgClass, typeof i2.NgComponentOutlet, typeof i3.NgForOf, typeof i4.NgIf, typeof i5.NgTemplateOutlet, typeof i6.NgStyle, typeof i7.NgSwitch, typeof i7.NgSwitchCase, typeof i7.NgSwitchDefault, typeof i8.NgPlural, typeof i8.NgPluralCase, typeof i9.AsyncPipe, typeof i10.UpperCasePipe, typeof i10.LowerCasePipe, typeof i11.JsonPipe, typeof i12.SlicePipe, typeof i13.DecimalPipe, typeof i13.PercentPipe, typeof i10.TitleCasePipe, typeof i13.CurrencyPipe, typeof i14.DatePipe, typeof i15.I18nPluralPipe, typeof i16.I18nSelectPipe, typeof i17.KeyValuePipe]>;
            static ɵinj: i0.ɵɵInjectorDeclaration<CommonModule>;
    }
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Transforms a number to a currency string, formatted according to locale rules
        * that determine group sizing and separator, decimal-point character,
        * and other locale-specific configurations.
        *
        *
        * @see `getCurrencySymbol()`
        * @see `formatCurrency()`
        *
        * @usageNotes
        * The following code shows how the pipe transforms numbers
        * into text strings, according to various format specifications,
        * where the caller's default locale is `en-US`.
        *
        * <code-example path="common/pipes/ts/currency_pipe.ts" region='CurrencyPipe'></code-example>
        *
        * @publicApi
        */
    export class CurrencyPipe implements PipeTransform {
            constructor(_locale: string, _defaultCurrencyCode?: string);
            transform(value: number | string, currencyCode?: string, display?: 'code' | 'symbol' | 'symbol-narrow' | string | boolean, digitsInfo?: string, locale?: string): string | null;
            transform(value: null | undefined, currencyCode?: string, display?: 'code' | 'symbol' | 'symbol-narrow' | string | boolean, digitsInfo?: string, locale?: string): null;
            transform(value: number | string | null | undefined, currencyCode?: string, display?: 'code' | 'symbol' | 'symbol-narrow' | string | boolean, digitsInfo?: string, locale?: string): string | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<CurrencyPipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<CurrencyPipe, "currency", true>;
    }
    
    /**
        * DI token that allows to provide default configuration for the `DatePipe` instances in an
        * application. The value is an object which can include the following fields:
        * - `dateFormat`: configures the default date format. If not provided, the `DatePipe`
        * will use the 'mediumDate' as a value.
        * - `timezone`: configures the default timezone. If not provided, the `DatePipe` will
        * use the end-user's local system timezone.
        *
        * @see `DatePipeConfig`
        *
        * @usageNotes
        *
        * Various date pipe default values can be overwritten by providing this token with
        * the value that has this interface.
        *
        * For example:
        *
        * Override the default date format by providing a value using the token:
        * ```typescript
        * providers: [
        *   {provide: DATE_PIPE_DEFAULT_OPTIONS, useValue: {dateFormat: 'shortDate'}}
        * ]
        * ```
        *
        * Override the default timezone by providing a value using the token:
        * ```typescript
        * providers: [
        *   {provide: DATE_PIPE_DEFAULT_OPTIONS, useValue: {timezone: '-1200'}}
        * ]
        * ```
        */
    export const DATE_PIPE_DEFAULT_OPTIONS: InjectionToken<DatePipeConfig>;
    
    /**
        * Optionally-provided default timezone to use for all instances of `DatePipe` (such as `'+0430'`).
        * If the value isn't provided, the `DatePipe` will use the end-user's local system timezone.
        *
        * @deprecated use DATE_PIPE_DEFAULT_OPTIONS token to configure DatePipe
        */
    export const DATE_PIPE_DEFAULT_TIMEZONE: InjectionToken<string>;
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Formats a date value according to locale rules.
        *
        * `DatePipe` is executed only when it detects a pure change to the input value.
        * A pure change is either a change to a primitive input value
        * (such as `String`, `Number`, `Boolean`, or `Symbol`),
        * or a changed object reference (such as `Date`, `Array`, `Function`, or `Object`).
        *
        * Note that mutating a `Date` object does not cause the pipe to be rendered again.
        * To ensure that the pipe is executed, you must create a new `Date` object.
        *
        * Only the `en-US` locale data comes with Angular. To localize dates
        * in another language, you must import the corresponding locale data.
        * See the [I18n guide](guide/i18n-common-format-data-locale) for more information.
        *
        * The time zone of the formatted value can be specified either by passing it in as the second
        * parameter of the pipe, or by setting the default through the `DATE_PIPE_DEFAULT_OPTIONS`
        * injection token. The value that is passed in as the second parameter takes precedence over
        * the one defined using the injection token.
        *
        * @see `formatDate()`
        *
        *
        * @usageNotes
        *
        * The result of this pipe is not reevaluated when the input is mutated. To avoid the need to
        * reformat the date on every change-detection cycle, treat the date as an immutable object
        * and change the reference when the pipe needs to run again.
        *
        * ### Pre-defined format options
        *
        * | Option        | Equivalent to                       | Examples (given in `en-US` locale)              |
        * |---------------|-------------------------------------|-------------------------------------------------|
        * | `'short'`     | `'M/d/yy, h:mm a'`                  | `6/15/15, 9:03 AM`                              |
        * | `'medium'`    | `'MMM d, y, h:mm:ss a'`             | `Jun 15, 2015, 9:03:01 AM`                      |
        * | `'long'`      | `'MMMM d, y, h:mm:ss a z'`          | `June 15, 2015 at 9:03:01 AM GMT+1`             |
        * | `'full'`      | `'EEEE, MMMM d, y, h:mm:ss a zzzz'` | `Monday, June 15, 2015 at 9:03:01 AM GMT+01:00` |
        * | `'shortDate'` | `'M/d/yy'`                          | `6/15/15`                                       |
        * | `'mediumDate'`| `'MMM d, y'`                        | `Jun 15, 2015`                                  |
        * | `'longDate'`  | `'MMMM d, y'`                       | `June 15, 2015`                                 |
        * | `'fullDate'`  | `'EEEE, MMMM d, y'`                 | `Monday, June 15, 2015`                         |
        * | `'shortTime'` | `'h:mm a'`                          | `9:03 AM`                                       |
        * | `'mediumTime'`| `'h:mm:ss a'`                       | `9:03:01 AM`                                    |
        * | `'longTime'`  | `'h:mm:ss a z'`                     | `9:03:01 AM GMT+1`                              |
        * | `'fullTime'`  | `'h:mm:ss a zzzz'`                  | `9:03:01 AM GMT+01:00`                          |
        *
        * ### Custom format options
        *
        * You can construct a format string using symbols to specify the components
        * of a date-time value, as described in the following table.
        * Format details depend on the locale.
        * Fields marked with (*) are only available in the extra data set for the given locale.
        *
        *  | Field type          | Format      | Description                                                   | Example Value                                              |
        *  |-------------------- |-------------|---------------------------------------------------------------|------------------------------------------------------------|
        *  | Era                 | G, GG & GGG | Abbreviated                                                   | AD                                                         |
        *  |                     | GGGG        | Wide                                                          | Anno Domini                                                |
        *  |                     | GGGGG       | Narrow                                                        | A                                                          |
        *  | Year                | y           | Numeric: minimum digits                                       | 2, 20, 201, 2017, 20173                                    |
        *  |                     | yy          | Numeric: 2 digits + zero padded                               | 02, 20, 01, 17, 73                                         |
        *  |                     | yyy         | Numeric: 3 digits + zero padded                               | 002, 020, 201, 2017, 20173                                 |
        *  |                     | yyyy        | Numeric: 4 digits or more + zero padded                       | 0002, 0020, 0201, 2017, 20173                              |
        *  | Week-numbering year | Y           | Numeric: minimum digits                                       | 2, 20, 201, 2017, 20173                                    |
        *  |                     | YY          | Numeric: 2 digits + zero padded                               | 02, 20, 01, 17, 73                                         |
        *  |                     | YYY         | Numeric: 3 digits + zero padded                               | 002, 020, 201, 2017, 20173                                 |
        *  |                     | YYYY        | Numeric: 4 digits or more + zero padded                       | 0002, 0020, 0201, 2017, 20173                              |
        *  | Month               | M           | Numeric: 1 digit                                              | 9, 12                                                      |
        *  |                     | MM          | Numeric: 2 digits + zero padded                               | 09, 12                                                     |
        *  |                     | MMM         | Abbreviated                                                   | Sep                                                        |
        *  |                     | MMMM        | Wide                                                          | September                                                  |
        *  |                     | MMMMM       | Narrow                                                        | S                                                          |
        *  | Month standalone    | L           | Numeric: 1 digit                                              | 9, 12                                                      |
        *  |                     | LL          | Numeric: 2 digits + zero padded                               | 09, 12                                                     |
        *  |                     | LLL         | Abbreviated                                                   | Sep                                                        |
        *  |                     | LLLL        | Wide                                                          | September                                                  |
        *  |                     | LLLLL       | Narrow                                                        | S                                                          |
        *  | Week of year        | w           | Numeric: minimum digits                                       | 1... 53                                                    |
        *  |                     | ww          | Numeric: 2 digits + zero padded                               | 01... 53                                                   |
        *  | Week of month       | W           | Numeric: 1 digit                                              | 1... 5                                                     |
        *  | Day of month        | d           | Numeric: minimum digits                                       | 1                                                          |
        *  |                     | dd          | Numeric: 2 digits + zero padded                               | 01                                                         |
        *  | Week day            | E, EE & EEE | Abbreviated                                                   | Tue                                                        |
        *  |                     | EEEE        | Wide                                                          | Tuesday                                                    |
        *  |                     | EEEEE       | Narrow                                                        | T                                                          |
        *  |                     | EEEEEE      | Short                                                         | Tu                                                         |
        *  | Week day standalone | c, cc       | Numeric: 1 digit                                              | 2                                                          |
        *  |                     | ccc         | Abbreviated                                                   | Tue                                                        |
        *  |                     | cccc        | Wide                                                          | Tuesday                                                    |
        *  |                     | ccccc       | Narrow                                                        | T                                                          |
        *  |                     | cccccc      | Short                                                         | Tu                                                         |
        *  | Period              | a, aa & aaa | Abbreviated                                                   | am/pm or AM/PM                                             |
        *  |                     | aaaa        | Wide (fallback to `a` when missing)                           | ante meridiem/post meridiem                                |
        *  |                     | aaaaa       | Narrow                                                        | a/p                                                        |
        *  | Period*             | B, BB & BBB | Abbreviated                                                   | mid.                                                       |
        *  |                     | BBBB        | Wide                                                          | am, pm, midnight, noon, morning, afternoon, evening, night |
        *  |                     | BBBBB       | Narrow                                                        | md                                                         |
        *  | Period standalone*  | b, bb & bbb | Abbreviated                                                   | mid.                                                       |
        *  |                     | bbbb        | Wide                                                          | am, pm, midnight, noon, morning, afternoon, evening, night |
        *  |                     | bbbbb       | Narrow                                                        | md                                                         |
        *  | Hour 1-12           | h           | Numeric: minimum digits                                       | 1, 12                                                      |
        *  |                     | hh          | Numeric: 2 digits + zero padded                               | 01, 12                                                     |
        *  | Hour 0-23           | H           | Numeric: minimum digits                                       | 0, 23                                                      |
        *  |                     | HH          | Numeric: 2 digits + zero padded                               | 00, 23                                                     |
        *  | Minute              | m           | Numeric: minimum digits                                       | 8, 59                                                      |
        *  |                     | mm          | Numeric: 2 digits + zero padded                               | 08, 59                                                     |
        *  | Second              | s           | Numeric: minimum digits                                       | 0... 59                                                    |
        *  |                     | ss          | Numeric: 2 digits + zero padded                               | 00... 59                                                   |
        *  | Fractional seconds  | S           | Numeric: 1 digit                                              | 0... 9                                                     |
        *  |                     | SS          | Numeric: 2 digits + zero padded                               | 00... 99                                                   |
        *  |                     | SSS         | Numeric: 3 digits + zero padded (= milliseconds)              | 000... 999                                                 |
        *  | Zone                | z, zz & zzz | Short specific non location format (fallback to O)            | GMT-8                                                      |
        *  |                     | zzzz        | Long specific non location format (fallback to OOOO)          | GMT-08:00                                                  |
        *  |                     | Z, ZZ & ZZZ | ISO8601 basic format                                          | -0800                                                      |
        *  |                     | ZZZZ        | Long localized GMT format                                     | GMT-8:00                                                   |
        *  |                     | ZZZZZ       | ISO8601 extended format + Z indicator for offset 0 (= XXXXX)  | -08:00                                                     |
        *  |                     | O, OO & OOO | Short localized GMT format                                    | GMT-8                                                      |
        *  |                     | OOOO        | Long localized GMT format                                     | GMT-08:00                                                  |
        *
        *
        * ### Format examples
        *
        * These examples transform a date into various formats,
        * assuming that `dateObj` is a JavaScript `Date` object for
        * year: 2015, month: 6, day: 15, hour: 21, minute: 43, second: 11,
        * given in the local time for the `en-US` locale.
        *
        * ```
        * {{ dateObj | date }}               // output is 'Jun 15, 2015'
        * {{ dateObj | date:'medium' }}      // output is 'Jun 15, 2015, 9:43:11 PM'
        * {{ dateObj | date:'shortTime' }}   // output is '9:43 PM'
        * {{ dateObj | date:'mm:ss' }}       // output is '43:11'
        * ```
        *
        * ### Usage example
        *
        * The following component uses a date pipe to display the current date in different formats.
        *
        * ```
        * @Component({
        *  selector: 'date-pipe',
        *  template: `<div>
        *    <p>Today is {{today | date}}</p>
        *    <p>Or if you prefer, {{today | date:'fullDate'}}</p>
        *    <p>The time is {{today | date:'h:mm a z'}}</p>
        *  </div>`
        * })
        * // Get the current date and time as a date-time value.
        * export class DatePipeComponent {
        *   today: number = Date.now();
        * }
        * ```
        *
        * @publicApi
        */
    export class DatePipe implements PipeTransform {
            constructor(locale: string, defaultTimezone?: string | null | undefined, defaultOptions?: DatePipeConfig | null | undefined);
            /**
                * @param value The date expression: a `Date` object,  a number
                * (milliseconds since UTC epoch), or an ISO string (https://www.w3.org/TR/NOTE-datetime).
                * @param format The date/time components to include, using predefined options or a
                * custom format string.  When not provided, the `DatePipe` looks for the value using the
                * `DATE_PIPE_DEFAULT_OPTIONS` injection token (and reads the `dateFormat` property).
                * If the token is not configured, the `mediumDate` is used as a value.
                * @param timezone A timezone offset (such as `'+0430'`), or a standard UTC/GMT, or continental US
                * timezone abbreviation. When not provided, the `DatePipe` looks for the value using the
                * `DATE_PIPE_DEFAULT_OPTIONS` injection token (and reads the `timezone` property). If the token
                * is not configured, the end-user's local system timezone is used as a value.
                * @param locale A locale code for the locale format rules to use.
                * When not supplied, uses the value of `LOCALE_ID`, which is `en-US` by default.
                * See [Setting your app locale](guide/i18n-common-locale-id).
                *
                * @see `DATE_PIPE_DEFAULT_OPTIONS`
                *
                * @returns A date string in the desired format.
                */
            transform(value: Date | string | number, format?: string, timezone?: string, locale?: string): string | null;
            transform(value: null | undefined, format?: string, timezone?: string, locale?: string): null;
            transform(value: Date | string | number | null | undefined, format?: string, timezone?: string, locale?: string): string | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<DatePipe, [null, { optional: true; }, { optional: true; }]>;
            static ɵpipe: i0.ɵɵPipeDeclaration<DatePipe, "date", true>;
    }
    
    
    /**
        * An interface that describes the date pipe configuration, which can be provided using the
        * `DATE_PIPE_DEFAULT_OPTIONS` token.
        *
        * @see `DATE_PIPE_DEFAULT_OPTIONS`
        *
        * @publicApi
        */
    export interface DatePipeConfig {
            dateFormat: string;
            timezone: string;
    }
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Formats a value according to digit options and locale rules.
        * Locale determines group sizing and separator,
        * decimal point character, and other locale-specific configurations.
        *
        * @see `formatNumber()`
        *
        * @usageNotes
        *
        * ### digitsInfo
        *
        * The value's decimal representation is specified by the `digitsInfo`
        * parameter, written in the following format:<br>
        *
        * ```
        * {minIntegerDigits}.{minFractionDigits}-{maxFractionDigits}
        * ```
        *
        *  - `minIntegerDigits`:
        * The minimum number of integer digits before the decimal point.
        * Default is 1.
        *
        * - `minFractionDigits`:
        * The minimum number of digits after the decimal point.
        * Default is 0.
        *
        *  - `maxFractionDigits`:
        * The maximum number of digits after the decimal point.
        * Default is 3.
        *
        * If the formatted value is truncated it will be rounded using the "to-nearest" method:
        *
        * ```
        * {{3.6 | number: '1.0-0'}}
        * <!--will output '4'-->
        *
        * {{-3.6 | number:'1.0-0'}}
        * <!--will output '-4'-->
        * ```
        *
        * ### locale
        *
        * `locale` will format a value according to locale rules.
        * Locale determines group sizing and separator,
        * decimal point character, and other locale-specific configurations.
        *
        * When not supplied, uses the value of `LOCALE_ID`, which is `en-US` by default.
        *
        * See [Setting your app locale](guide/i18n-common-locale-id).
        *
        * ### Example
        *
        * The following code shows how the pipe transforms values
        * according to various format specifications,
        * where the caller's default locale is `en-US`.
        *
        * <code-example path="common/pipes/ts/number_pipe.ts" region='NumberPipe'></code-example>
        *
        * @publicApi
        */
    export class DecimalPipe implements PipeTransform {
            constructor(_locale: string);
            transform(value: number | string, digitsInfo?: string, locale?: string): string | null;
            transform(value: null | undefined, digitsInfo?: string, locale?: string): null;
            transform(value: number | string | null | undefined, digitsInfo?: string, locale?: string): string | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<DecimalPipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<DecimalPipe, "number", true>;
    }
    
    function defaultComparator<K, V>(keyValueA: KeyValue<K, V>, keyValueB: KeyValue<K, V>): number;
    
    /**
        * A DI Token representing the main rendering context.
        * In a browser and SSR this is the DOM Document.
        * When using SSR, that document is created by [Domino](https://github.com/angular/domino).
        *
        * @publicApi
        */
    export const DOCUMENT: InjectionToken<Document>;
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Formats a number as currency using locale rules.
        *
        * @param value The number to format.
        * @param locale A locale code for the locale format rules to use.
        * @param currency A string containing the currency symbol or its name,
        * such as "$" or "Canadian Dollar". Used in output string, but does not affect the operation
        * of the function.
        * @param currencyCode The [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)
        * currency code, such as `USD` for the US dollar and `EUR` for the euro.
        * Used to determine the number of digits in the decimal part.
        * @param digitsInfo Decimal representation options, specified by a string in the following format:
        * `{minIntegerDigits}.{minFractionDigits}-{maxFractionDigits}`. See `DecimalPipe` for more details.
        *
        * @returns The formatted currency value.
        *
        * @see `formatNumber()`
        * @see `DecimalPipe`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function formatCurrency(value: number, locale: string, currency: string, currencyCode?: string, digitsInfo?: string): string;
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Formats a date according to locale rules.
        *
        * @param value The date to format, as a Date, or a number (milliseconds since UTC epoch)
        * or an [ISO date-time string](https://www.w3.org/TR/NOTE-datetime).
        * @param format The date-time components to include. See `DatePipe` for details.
        * @param locale A locale code for the locale format rules to use.
        * @param timezone The time zone. A time zone offset from GMT (such as `'+0430'`),
        * or a standard UTC/GMT or continental US time zone abbreviation.
        * If not specified, uses host system settings.
        *
        * @returns The formatted date string.
        *
        * @see `DatePipe`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function formatDate(value: string | number | Date, format: string, locale: string, timezone?: string): string;
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Formats a number as text, with group sizing, separator, and other
        * parameters based on the locale.
        *
        * @param value The number to format.
        * @param locale A locale code for the locale format rules to use.
        * @param digitsInfo Decimal representation options, specified by a string in the following format:
        * `{minIntegerDigits}.{minFractionDigits}-{maxFractionDigits}`. See `DecimalPipe` for more details.
        *
        * @returns The formatted text string.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function formatNumber(value: number, locale: string, digitsInfo?: string): string;
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Formats a number as a percentage according to locale rules.
        *
        * @param value The number to format.
        * @param locale A locale code for the locale format rules to use.
        * @param digitsInfo Decimal representation options, specified by a string in the following format:
        * `{minIntegerDigits}.{minFractionDigits}-{maxFractionDigits}`. See `DecimalPipe` for more details.
        *
        * @returns The formatted percentage value.
        *
        * @see `formatNumber()`
        * @see `DecimalPipe`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        * @publicApi
        *
        */
    export function formatPercent(value: number, locale: string, digitsInfo?: string): string;
    
    /**
        * String widths available for date-time formats.
        * The specific character widths are locale-specific.
        * Examples are given for `en-US`.
        *
        * @see `getLocaleDateFormat()`
        * @see `getLocaleTimeFormat()`
        * @see `getLocaleDateTimeFormat()`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        * @publicApi
        */
    export enum FormatWidth {
            /**
                * For `en-US`, 'M/d/yy, h:mm a'`
                * (Example: `6/15/15, 9:03 AM`)
                */
            Short = 0,
            /**
                * For `en-US`, `'MMM d, y, h:mm:ss a'`
                * (Example: `Jun 15, 2015, 9:03:01 AM`)
                */
            Medium = 1,
            /**
                * For `en-US`, `'MMMM d, y, h:mm:ss a z'`
                * (Example: `June 15, 2015 at 9:03:01 AM GMT+1`)
                */
            Long = 2,
            /**
                * For `en-US`, `'EEEE, MMMM d, y, h:mm:ss a zzzz'`
                * (Example: `Monday, June 15, 2015 at 9:03:01 AM GMT+01:00`)
                */
            Full = 3
    }
    
    /**
        * Context-dependant translation forms for strings.
        * Typically the standalone version is for the nominative form of the word,
        * and the format version is used for the genitive case.
        * @see [CLDR website](http://cldr.unicode.org/translation/date-time-1/date-time#TOC-Standalone-vs.-Format-Styles)
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export enum FormStyle {
            Format = 0,
            Standalone = 1
    }
    
    /**
        * Retrieves the currency symbol for a given currency code.
        *
        * For example, for the default `en-US` locale, the code `USD` can
        * be represented by the narrow symbol `$` or the wide symbol `US$`.
        *
        * @param code The currency code.
        * @param format The format, `wide` or `narrow`.
        * @param locale A locale code for the locale format rules to use.
        *
        * @returns The symbol, or the currency code if no symbol is available.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getCurrencySymbol(code: string, format: 'wide' | 'narrow', locale?: string): string;
    
    /**
        * Retrieves the default currency code for the given locale.
        *
        * The default is defined as the first currency which is still in use.
        *
        * @param locale The code of the locale whose currency code we want.
        * @returns The code of the default currency for the given locale.
        *
        * @publicApi
        */
    export function getLocaleCurrencyCode(locale: string): string | null;
    
    /**
        * Retrieves the name of the currency for the main country corresponding
        * to a given locale. For example, 'US Dollar' for `en-US`.
        * @param locale A locale code for the locale format rules to use.
        * @returns The currency name,
        * or `null` if the main country cannot be determined.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleCurrencyName(locale: string): string | null;
    
    /**
        * Retrieves the symbol used to represent the currency for the main country
        * corresponding to a given locale. For example, '$' for `en-US`.
        *
        * @param locale A locale code for the locale format rules to use.
        * @returns The localized symbol character,
        * or `null` if the main country cannot be determined.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleCurrencySymbol(locale: string): string | null;
    
    /**
        * Retrieves a localized date-value formatting string.
        *
        * @param locale A locale code for the locale format rules to use.
        * @param width The format type.
        * @returns The localized formatting string.
        * @see `FormatWidth`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleDateFormat(locale: string, width: FormatWidth): string;
    
    /**
        * Retrieves a localized date-time formatting string.
        *
        * @param locale A locale code for the locale format rules to use.
        * @param width The format type.
        * @returns The localized formatting string.
        * @see `FormatWidth`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleDateTimeFormat(locale: string, width: FormatWidth): string;
    
    /**
        * Retrieves days of the week for the given locale, using the Gregorian calendar.
        *
        * @param locale A locale code for the locale format rules to use.
        * @param formStyle The required grammatical form.
        * @param width The required character width.
        * @returns An array of localized name strings.
        * For example,`[Sunday, Monday, ... Saturday]` for `en-US`.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleDayNames(locale: string, formStyle: FormStyle, width: TranslationWidth): ReadonlyArray<string>;
    
    /**
        * Retrieves day period strings for the given locale.
        *
        * @param locale A locale code for the locale format rules to use.
        * @param formStyle The required grammatical form.
        * @param width The required character width.
        * @returns An array of localized period strings. For example, `[AM, PM]` for `en-US`.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleDayPeriods(locale: string, formStyle: FormStyle, width: TranslationWidth): Readonly<[string, string]>;
    
    /**
        * Retrieves the writing direction of a specified locale
        * @param locale A locale code for the locale format rules to use.
        * @publicApi
        * @returns 'rtl' or 'ltr'
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        */
    export function getLocaleDirection(locale: string): 'ltr' | 'rtl';
    
    /**
        * Retrieves Gregorian-calendar eras for the given locale.
        * @param locale A locale code for the locale format rules to use.
        * @param width The required character width.
    
        * @returns An array of localized era strings.
        * For example, `[AD, BC]` for `en-US`.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleEraNames(locale: string, width: TranslationWidth): Readonly<[string, string]>;
    
    /**
        * Retrieves locale-specific rules used to determine which day period to use
        * when more than one period is defined for a locale.
        *
        * There is a rule for each defined day period. The
        * first rule is applied to the first day period and so on.
        * Fall back to AM/PM when no rules are available.
        *
        * A rule can specify a period as time range, or as a single time value.
        *
        * This functionality is only available when you have loaded the full locale data.
        * See the ["I18n guide"](guide/i18n-common-format-data-locale).
        *
        * @param locale A locale code for the locale format rules to use.
        * @returns The rules for the locale, a single time value or array of *from-time, to-time*,
        * or null if no periods are available.
        *
        * @see `getLocaleExtraDayPeriods()`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleExtraDayPeriodRules(locale: string): (Time | [Time, Time])[];
    
    /**
        * Retrieves locale-specific day periods, which indicate roughly how a day is broken up
        * in different languages.
        * For example, for `en-US`, periods are morning, noon, afternoon, evening, and midnight.
        *
        * This functionality is only available when you have loaded the full locale data.
        * See the ["I18n guide"](guide/i18n-common-format-data-locale).
        *
        * @param locale A locale code for the locale format rules to use.
        * @param formStyle The required grammatical form.
        * @param width The required character width.
        * @returns The translated day-period strings.
        * @see `getLocaleExtraDayPeriodRules()`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleExtraDayPeriods(locale: string, formStyle: FormStyle, width: TranslationWidth): string[];
    
    /**
        * Retrieves the first day of the week for the given locale.
        *
        * @param locale A locale code for the locale format rules to use.
        * @returns A day index number, using the 0-based week-day index for `en-US`
        * (Sunday = 0, Monday = 1, ...).
        * For example, for `fr-FR`, returns 1 to indicate that the first day is Monday.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleFirstDayOfWeek(locale: string): WeekDay;
    
    /**
        * Retrieves the locale ID from the currently loaded locale.
        * The loaded locale could be, for example, a global one rather than a regional one.
        * @param locale A locale code, such as `fr-FR`.
        * @returns The locale code. For example, `fr`.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleId(locale: string): string;
    
    /**
        * Retrieves months of the year for the given locale, using the Gregorian calendar.
        *
        * @param locale A locale code for the locale format rules to use.
        * @param formStyle The required grammatical form.
        * @param width The required character width.
        * @returns An array of localized name strings.
        * For example,  `[January, February, ...]` for `en-US`.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleMonthNames(locale: string, formStyle: FormStyle, width: TranslationWidth): ReadonlyArray<string>;
    
    /**
        * Retrieves a number format for a given locale.
        *
        * Numbers are formatted using patterns, like `#,###.00`. For example, the pattern `#,###.00`
        * when used to format the number 12345.678 could result in "12'345,678". That would happen if the
        * grouping separator for your language is an apostrophe, and the decimal separator is a comma.
        *
        * <b>Important:</b> The characters `.` `,` `0` `#` (and others below) are special placeholders
        * that stand for the decimal separator, and so on, and are NOT real characters.
        * You must NOT "translate" the placeholders. For example, don't change `.` to `,` even though in
        * your language the decimal point is written with a comma. The symbols should be replaced by the
        * local equivalents, using the appropriate `NumberSymbol` for your language.
        *
        * Here are the special characters used in number patterns:
        *
        * | Symbol | Meaning |
        * |--------|---------|
        * | . | Replaced automatically by the character used for the decimal point. |
        * | , | Replaced by the "grouping" (thousands) separator. |
        * | 0 | Replaced by a digit (or zero if there aren't enough digits). |
        * | # | Replaced by a digit (or nothing if there aren't enough). |
        * | ¤ | Replaced by a currency symbol, such as $ or USD. |
        * | % | Marks a percent format. The % symbol may change position, but must be retained. |
        * | E | Marks a scientific format. The E symbol may change position, but must be retained. |
        * | ' | Special characters used as literal characters are quoted with ASCII single quotes. |
        *
        * @param locale A locale code for the locale format rules to use.
        * @param type The type of numeric value to be formatted (such as `Decimal` or `Currency`.)
        * @returns The localized format string.
        * @see `NumberFormatStyle`
        * @see [CLDR website](http://cldr.unicode.org/translation/number-patterns)
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleNumberFormat(locale: string, type: NumberFormatStyle): string;
    
    /**
        * Retrieves a localized number symbol that can be used to replace placeholders in number formats.
        * @param locale The locale code.
        * @param symbol The symbol to localize.
        * @returns The character for the localized symbol.
        * @see `NumberSymbol`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleNumberSymbol(locale: string, symbol: NumberSymbol): string;
    
    /**
        * @alias core/ɵgetLocalePluralCase
        * @publicApi
        */
    export const getLocalePluralCase: (locale: string) => ((value: number) => Plural);
    
    /**
        * Retrieves a localized time-value formatting string.
        *
        * @param locale A locale code for the locale format rules to use.
        * @param width The format type.
        * @returns The localized formatting string.
        * @see `FormatWidth`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
    
        * @publicApi
        */
    export function getLocaleTimeFormat(locale: string, width: FormatWidth): string;
    
    /**
        * Range of week days that are considered the week-end for the given locale.
        *
        * @param locale A locale code for the locale format rules to use.
        * @returns The range of day values, `[startDay, endDay]`.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getLocaleWeekEndRange(locale: string): [WeekDay, WeekDay];
    
    /**
        * Reports the number of decimal digits for a given currency.
        * The value depends upon the presence of cents in that particular currency.
        *
        * @param code The currency code.
        * @returns The number of decimal digits, typically 0 or 2.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export function getNumberOfCurrencyDigits(code: string): number;
    
    /**
        * @description
        * A {@link LocationStrategy} used to configure the {@link Location} service to
        * represent its state in the
        * [hash fragment](https://en.wikipedia.org/wiki/Uniform_Resource_Locator#Syntax)
        * of the browser's URL.
        *
        * For instance, if you call `location.go('/foo')`, the browser's URL will become
        * `example.com#/foo`.
        *
        * @usageNotes
        *
        * ### Example
        *
        * {@example common/location/ts/hash_location_component.ts region='LocationComponent'}
        *
        * @publicApi
        */
    export class HashLocationStrategy extends LocationStrategy implements OnDestroy {
            constructor(_platformLocation: PlatformLocation, _baseHref?: string);
            /** @nodoc */
            ngOnDestroy(): void;
            onPopState(fn: LocationChangeListener): void;
            getBaseHref(): string;
            path(includeHash?: boolean): string;
            prepareExternalUrl(internal: string): string;
            pushState(state: any, title: string, path: string, queryParams: string): void;
            replaceState(state: any, title: string, path: string, queryParams: string): void;
            forward(): void;
            back(): void;
            getState(): unknown;
            historyGo(relativePosition?: number): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<HashLocationStrategy, [null, { optional: true; }]>;
            static ɵprov: i0.ɵɵInjectableDeclaration<HashLocationStrategy>;
    }
    
    namespace i1 {
            export {
                    NgClass
            }
    }
    
    namespace i10 {
            export {
                    LowerCasePipe,
                    TitleCasePipe,
                    UpperCasePipe
            }
    }
    
    namespace i11 {
            export {
                    JsonPipe
            }
    }
    
    namespace i12 {
            export {
                    SlicePipe
            }
    }
    
    namespace i13 {
            export {
                    DecimalPipe,
                    PercentPipe,
                    CurrencyPipe
            }
    }
    
    namespace i14 {
            export {
                    DATE_PIPE_DEFAULT_TIMEZONE,
                    DATE_PIPE_DEFAULT_OPTIONS,
                    DatePipe
            }
    }
    
    namespace i15 {
            export {
                    I18nPluralPipe
            }
    }
    
    namespace i16 {
            export {
                    I18nSelectPipe
            }
    }
    
    namespace i17 {
            export {
                    defaultComparator,
                    KeyValue,
                    KeyValuePipe
            }
    }
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Maps a value to a string that pluralizes the value according to locale rules.
        *
        * @usageNotes
        *
        * ### Example
        *
        * {@example common/pipes/ts/i18n_pipe.ts region='I18nPluralPipeComponent'}
        *
        * @publicApi
        */
    export class I18nPluralPipe implements PipeTransform {
            constructor(_localization: NgLocalization);
            /**
                * @param value the number to be formatted
                * @param pluralMap an object that mimics the ICU format, see
                * https://unicode-org.github.io/icu/userguide/format_parse/messages/.
                * @param locale a `string` defining the locale to use (uses the current {@link LOCALE_ID} by
                * default).
                */
            transform(value: number | null | undefined, pluralMap: {
                    [count: string]: string;
            }, locale?: string): string;
            static ɵfac: i0.ɵɵFactoryDeclaration<I18nPluralPipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<I18nPluralPipe, "i18nPlural", true>;
    }
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Generic selector that displays the string that matches the current value.
        *
        * If none of the keys of the `mapping` match the `value`, then the content
        * of the `other` key is returned when present, otherwise an empty string is returned.
        *
        * @usageNotes
        *
        * ### Example
        *
        * {@example common/pipes/ts/i18n_pipe.ts region='I18nSelectPipeComponent'}
        *
        * @publicApi
        */
    export class I18nSelectPipe implements PipeTransform {
            /**
                * @param value a string to be internationalized.
                * @param mapping an object that indicates the text that should be displayed
                * for different values of the provided `value`.
                */
            transform(value: string | null | undefined, mapping: {
                    [key: string]: string;
            }): string;
            static ɵfac: i0.ɵɵFactoryDeclaration<I18nSelectPipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<I18nSelectPipe, "i18nSelect", true>;
    }
    
    namespace i2 {
            export {
                    NgComponentOutlet
            }
    }
    
    namespace i3 {
            export {
                    NgForOfContext,
                    NgForOf,
                    NgForOf as NgFor
            }
    }
    
    namespace i4 {
            export {
                    NgIf,
                    NgIfContext
            }
    }
    
    namespace i5 {
            export {
                    NgTemplateOutlet
            }
    }
    
    namespace i6 {
            export {
                    NgStyle
            }
    }
    
    namespace i7 {
            export {
                    SwitchView,
                    NgSwitch,
                    NgSwitchCase,
                    NgSwitchDefault
            }
    }
    
    namespace i8 {
            export {
                    NgPlural,
                    NgPluralCase
            }
    }
    
    namespace i9 {
            export {
                    AsyncPipe
            }
    }
    
    /**
        * Injection token that configures the image optimized image functionality.
        *
        * @see `NgOptimizedImage`
        * @publicApi
        * @developerPreview
        */
    export const IMAGE_CONFIG: InjectionToken<ImageConfig>;
    
    /**
        * Injection token that configures the image loader function.
        *
        * @see `ImageLoader`
        * @see `NgOptimizedImage`
        * @publicApi
        */
    export const IMAGE_LOADER: InjectionToken<ImageLoader>;
    
    /**
        * A configuration object for the NgOptimizedImage directive. Contains:
        * - breakpoints: An array of integer breakpoints used to generate
        *      srcsets for responsive images.
        *
        * Learn more about the responsive image configuration in [the NgOptimizedImage
        * guide](guide/image-directive).
        * @publicApi
        * @developerPreview
        */
    export type ImageConfig = {
            breakpoints?: number[];
    };
    
    /**
        * Represents an image loader function. Image loader functions are used by the
        * NgOptimizedImage directive to produce full image URL based on the image name and its width.
        *
        * @publicApi
        */
    export type ImageLoader = (config: ImageLoaderConfig) => string;
    
    /**
        * Config options recognized by the image loader function.
        *
        * @see `ImageLoader`
        * @see `NgOptimizedImage`
        * @publicApi
        */
    export interface ImageLoaderConfig {
            /**
                * Image file name to be added to the image request URL.
                */
            src: string;
            /**
                * Width of the requested image (to be used when generating srcset).
                */
            width?: number;
            /**
                * Additional user-provided parameters for use by the ImageLoader.
                */
            loaderParams?: {
                    [key: string]: any;
            };
    }
    
    /**
        * Returns whether a platform id represents a browser platform.
        * @publicApi
        */
    export function isPlatformBrowser(platformId: Object): boolean;
    
    /**
        * Returns whether a platform id represents a server platform.
        * @publicApi
        */
    export function isPlatformServer(platformId: Object): boolean;
    
    /**
        * Returns whether a platform id represents a web worker app platform.
        * @publicApi
        */
    export function isPlatformWorkerApp(platformId: Object): boolean;
    
    /**
        * Returns whether a platform id represents a web worker UI platform.
        * @publicApi
        */
    export function isPlatformWorkerUi(platformId: Object): boolean;
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Converts a value into its JSON-format representation.  Useful for debugging.
        *
        * @usageNotes
        *
        * The following component uses a JSON pipe to convert an object
        * to JSON format, and displays the string in both formats for comparison.
        *
        * {@example common/pipes/ts/json_pipe.ts region='JsonPipe'}
        *
        * @publicApi
        */
    export class JsonPipe implements PipeTransform {
            /**
                * @param value A value of any type to convert into a JSON-format string.
                */
            transform(value: any): string;
            static ɵfac: i0.ɵɵFactoryDeclaration<JsonPipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<JsonPipe, "json", true>;
    }
    
    /**
        * A key value pair.
        * Usually used to represent the key value pairs from a Map or Object.
        *
        * @publicApi
        */
    export interface KeyValue<K, V> {
            key: K;
            value: V;
    }
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Transforms Object or Map into an array of key value pairs.
        *
        * The output array will be ordered by keys.
        * By default the comparator will be by Unicode point value.
        * You can optionally pass a compareFn if your keys are complex types.
        *
        * @usageNotes
        * ### Examples
        *
        * This examples show how an Object or a Map can be iterated by ngFor with the use of this
        * keyvalue pipe.
        *
        * {@example common/pipes/ts/keyvalue_pipe.ts region='KeyValuePipe'}
        *
        * @publicApi
        */
    export class KeyValuePipe implements PipeTransform {
            constructor(differs: KeyValueDiffers);
            transform<K, V>(input: ReadonlyMap<K, V>, compareFn?: (a: KeyValue<K, V>, b: KeyValue<K, V>) => number): Array<KeyValue<K, V>>;
            transform<K extends number, V>(input: Record<K, V>, compareFn?: (a: KeyValue<string, V>, b: KeyValue<string, V>) => number): Array<KeyValue<string, V>>;
            transform<K extends string, V>(input: Record<K, V> | ReadonlyMap<K, V>, compareFn?: (a: KeyValue<K, V>, b: KeyValue<K, V>) => number): Array<KeyValue<K, V>>;
            transform(input: null | undefined, compareFn?: (a: KeyValue<unknown, unknown>, b: KeyValue<unknown, unknown>) => number): null;
            transform<K, V>(input: ReadonlyMap<K, V> | null | undefined, compareFn?: (a: KeyValue<K, V>, b: KeyValue<K, V>) => number): Array<KeyValue<K, V>> | null;
            transform<K extends number, V>(input: Record<K, V> | null | undefined, compareFn?: (a: KeyValue<string, V>, b: KeyValue<string, V>) => number): Array<KeyValue<string, V>> | null;
            transform<K extends string, V>(input: Record<K, V> | ReadonlyMap<K, V> | null | undefined, compareFn?: (a: KeyValue<K, V>, b: KeyValue<K, V>) => number): Array<KeyValue<K, V>> | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<KeyValuePipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<KeyValuePipe, "keyvalue", true>;
    }
    
    /**
        * @description
        *
        * A service that applications can use to interact with a browser's URL.
        *
        * Depending on the `LocationStrategy` used, `Location` persists
        * to the URL's path or the URL's hash segment.
        *
        * @usageNotes
        *
        * It's better to use the `Router.navigate()` service to trigger route changes. Use
        * `Location` only if you need to interact with or create normalized URLs outside of
        * routing.
        *
        * `Location` is responsible for normalizing the URL against the application's base href.
        * A normalized URL is absolute from the URL host, includes the application's base href, and has no
        * trailing slash:
        * - `/my/app/user/123` is normalized
        * - `my/app/user/123` **is not** normalized
        * - `/my/app/user/123/` **is not** normalized
        *
        * ### Example
        *
        * <code-example path='common/location/ts/path_location_component.ts'
        * region='LocationComponent'></code-example>
        *
        * @publicApi
        */
    class Location_2 implements OnDestroy {
            constructor(locationStrategy: LocationStrategy);
            /** @nodoc */
            ngOnDestroy(): void;
            /**
                * Normalizes the URL path for this location.
                *
                * @param includeHash True to include an anchor fragment in the path.
                *
                * @returns The normalized URL path.
                */
            path(includeHash?: boolean): string;
            /**
                * Reports the current state of the location history.
                * @returns The current value of the `history.state` object.
                */
            getState(): unknown;
            /**
                * Normalizes the given path and compares to the current normalized path.
                *
                * @param path The given URL path.
                * @param query Query parameters.
                *
                * @returns True if the given URL path is equal to the current normalized path, false
                * otherwise.
                */
            isCurrentPathEqualTo(path: string, query?: string): boolean;
            /**
                * Normalizes a URL path by stripping any trailing slashes.
                *
                * @param url String representing a URL.
                *
                * @returns The normalized URL string.
                */
            normalize(url: string): string;
            /**
                * Normalizes an external URL path.
                * If the given URL doesn't begin with a leading slash (`'/'`), adds one
                * before normalizing. Adds a hash if `HashLocationStrategy` is
                * in use, or the `APP_BASE_HREF` if the `PathLocationStrategy` is in use.
                *
                * @param url String representing a URL.
                *
                * @returns  A normalized platform-specific URL.
                */
            prepareExternalUrl(url: string): string;
            /**
                * Changes the browser's URL to a normalized version of a given URL, and pushes a
                * new item onto the platform's history.
                *
                * @param path  URL path to normalize.
                * @param query Query parameters.
                * @param state Location history state.
                *
                */
            go(path: string, query?: string, state?: any): void;
            /**
                * Changes the browser's URL to a normalized version of the given URL, and replaces
                * the top item on the platform's history stack.
                *
                * @param path  URL path to normalize.
                * @param query Query parameters.
                * @param state Location history state.
                */
            replaceState(path: string, query?: string, state?: any): void;
            /**
                * Navigates forward in the platform's history.
                */
            forward(): void;
            /**
                * Navigates back in the platform's history.
                */
            back(): void;
            /**
                * Navigate to a specific page from session history, identified by its relative position to the
                * current page.
                *
                * @param relativePosition  Position of the target page in the history relative to the current
                *     page.
                * A negative value moves backwards, a positive value moves forwards, e.g. `location.historyGo(2)`
                * moves forward two pages and `location.historyGo(-2)` moves back two pages. When we try to go
                * beyond what's stored in the history session, we stay in the current page. Same behaviour occurs
                * when `relativePosition` equals 0.
                * @see https://developer.mozilla.org/en-US/docs/Web/API/History_API#Moving_to_a_specific_point_in_history
                */
            historyGo(relativePosition?: number): void;
            /**
                * Registers a URL change listener. Use to catch updates performed by the Angular
                * framework that are not detectible through "popstate" or "hashchange" events.
                *
                * @param fn The change handler function, which take a URL and a location history state.
                * @returns A function that, when executed, unregisters a URL change listener.
                */
            onUrlChange(fn: (url: string, state: unknown) => void): VoidFunction;
            /**
                * Subscribes to the platform's `popState` events.
                *
                * Note: `Location.go()` does not trigger the `popState` event in the browser. Use
                * `Location.onUrlChange()` to subscribe to URL changes instead.
                *
                * @param value Event that is triggered when the state history changes.
                * @param exception The exception to throw.
                *
                * @see [onpopstate](https://developer.mozilla.org/en-US/docs/Web/API/WindowEventHandlers/onpopstate)
                *
                * @returns Subscribed events.
                */
            subscribe(onNext: (value: PopStateEvent_2) => void, onThrow?: ((exception: any) => void) | null, onReturn?: (() => void) | null): SubscriptionLike;
            /**
                * Normalizes URL parameters by prepending with `?` if needed.
                *
                * @param  params String of URL parameters.
                *
                * @returns The normalized URL parameters string.
                */
            static normalizeQueryParams: (params: string) => string;
            /**
                * Joins two parts of a URL with a slash if needed.
                *
                * @param start  URL string
                * @param end    URL string
                *
                *
                * @returns The joined URL string.
                */
            static joinWithSlash: (start: string, end: string) => string;
            /**
                * Removes a trailing slash from a URL string if needed.
                * Looks for the first occurrence of either `#`, `?`, or the end of the
                * line as `/` characters and removes the trailing slash if one exists.
                *
                * @param url URL string.
                *
                * @returns The URL string, modified if needed.
                */
            static stripTrailingSlash: (url: string) => string;
            static ɵfac: i0.ɵɵFactoryDeclaration<Location_2, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<Location_2>;
    }
    export { Location_2 as Location }
    
    /**
        * @description
        * Indicates when a location is initialized.
        *
        * @publicApi
        */
    export const LOCATION_INITIALIZED: InjectionToken<Promise<any>>;
    
    /**
        * @description
        * A serializable version of the event from `onPopState` or `onHashChange`
        *
        * @publicApi
        */
    export interface LocationChangeEvent {
            type: string;
            state: any;
    }
    
    /**
        * @publicApi
        */
    export interface LocationChangeListener {
            (event: LocationChangeEvent): any;
    }
    
    /**
        * Enables the `Location` service to read route state from the browser's URL.
        * Angular provides two strategies:
        * `HashLocationStrategy` and `PathLocationStrategy`.
        *
        * Applications should use the `Router` or `Location` services to
        * interact with application route state.
        *
        * For instance, `HashLocationStrategy` produces URLs like
        * <code class="no-auto-link">http://example.com#/foo</code>,
        * and `PathLocationStrategy` produces
        * <code class="no-auto-link">http://example.com/foo</code> as an equivalent URL.
        *
        * See these two classes for more.
        *
        * @publicApi
        */
    export abstract class LocationStrategy {
            abstract path(includeHash?: boolean): string;
            abstract prepareExternalUrl(internal: string): string;
            abstract getState(): unknown;
            abstract pushState(state: any, title: string, url: string, queryParams: string): void;
            abstract replaceState(state: any, title: string, url: string, queryParams: string): void;
            abstract forward(): void;
            abstract back(): void;
            historyGo?(relativePosition: number): void;
            abstract onPopState(fn: LocationChangeListener): void;
            abstract getBaseHref(): string;
            static ɵfac: i0.ɵɵFactoryDeclaration<LocationStrategy, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<LocationStrategy>;
    }
    
    /**
        * Transforms text to all lower case.
        *
        * @see `UpperCasePipe`
        * @see `TitleCasePipe`
        * @usageNotes
        *
        * The following example defines a view that allows the user to enter
        * text, and then uses the pipe to convert the input text to all lower case.
        *
        * <code-example path="common/pipes/ts/lowerupper_pipe.ts" region='LowerUpperPipe'></code-example>
        *
        * @ngModule CommonModule
        * @publicApi
        */
    export class LowerCasePipe implements PipeTransform {
            /**
                * @param value The string to transform to lower case.
                */
            transform(value: string): string;
            transform(value: null | undefined): null;
            transform(value: string | null | undefined): string | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<LowerCasePipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<LowerCasePipe, "lowercase", true>;
    }
    
    /**
        * @ngModule CommonModule
        *
        * @usageNotes
        * ```
        *     <some-element [ngClass]="'first second'">...</some-element>
        *
        *     <some-element [ngClass]="['first', 'second']">...</some-element>
        *
        *     <some-element [ngClass]="{'first': true, 'second': true, 'third': false}">...</some-element>
        *
        *     <some-element [ngClass]="stringExp|arrayExp|objExp">...</some-element>
        *
        *     <some-element [ngClass]="{'class1 class2 class3' : true}">...</some-element>
        * ```
        *
        * @description
        *
        * Adds and removes CSS classes on an HTML element.
        *
        * The CSS classes are updated as follows, depending on the type of the expression evaluation:
        * - `string` - the CSS classes listed in the string (space delimited) are added,
        * - `Array` - the CSS classes declared as Array elements are added,
        * - `Object` - keys are CSS classes that get added when the expression given in the value
        *              evaluates to a truthy value, otherwise they are removed.
        *
        * @publicApi
        */
    export class NgClass implements DoCheck {
            constructor(_iterableDiffers: IterableDiffers, _keyValueDiffers: KeyValueDiffers, _ngEl: ElementRef, _renderer: Renderer2);
            set klass(value: string);
            set ngClass(value: string | string[] | Set<string> | {
                    [klass: string]: any;
            } | null | undefined);
            ngDoCheck(): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgClass, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgClass, "[ngClass]", never, { "klass": "class"; "ngClass": "ngClass"; }, {}, never, never, true, never>;
    }
    
    /**
        * Instantiates a {@link Component} type and inserts its Host View into the current View.
        * `NgComponentOutlet` provides a declarative approach for dynamic component creation.
        *
        * `NgComponentOutlet` requires a component type, if a falsy value is set the view will clear and
        * any existing component will be destroyed.
        *
        * @usageNotes
        *
        * ### Fine tune control
        *
        * You can control the component creation process by using the following optional attributes:
        *
        * * `ngComponentOutletInjector`: Optional custom {@link Injector} that will be used as parent for
        * the Component. Defaults to the injector of the current view container.
        *
        * * `ngComponentOutletContent`: Optional list of projectable nodes to insert into the content
        * section of the component, if it exists.
        *
        * * `ngComponentOutletNgModule`: Optional NgModule class reference to allow loading another
        * module dynamically, then loading a component from that module.
        *
        * * `ngComponentOutletNgModuleFactory`: Deprecated config option that allows providing optional
        * NgModule factory to allow loading another module dynamically, then loading a component from that
        * module. Use `ngComponentOutletNgModule` instead.
        *
        * ### Syntax
        *
        * Simple
        * ```
        * <ng-container *ngComponentOutlet="componentTypeExpression"></ng-container>
        * ```
        *
        * Customized injector/content
        * ```
        * <ng-container *ngComponentOutlet="componentTypeExpression;
        *                                   injector: injectorExpression;
        *                                   content: contentNodesExpression;">
        * </ng-container>
        * ```
        *
        * Customized NgModule reference
        * ```
        * <ng-container *ngComponentOutlet="componentTypeExpression;
        *                                   ngModule: ngModuleClass;">
        * </ng-container>
        * ```
        *
        * ### A simple example
        *
        * {@example common/ngComponentOutlet/ts/module.ts region='SimpleExample'}
        *
        * A more complete example with additional options:
        *
        * {@example common/ngComponentOutlet/ts/module.ts region='CompleteExample'}
        *
        * @publicApi
        * @ngModule CommonModule
        */
    export class NgComponentOutlet implements OnChanges, OnDestroy {
            ngComponentOutlet: Type<any> | null;
            ngComponentOutletInjector?: Injector;
            ngComponentOutletContent?: any[][];
            ngComponentOutletNgModule?: Type<any>;
            /**
                * @deprecated This input is deprecated, use `ngComponentOutletNgModule` instead.
                */
            ngComponentOutletNgModuleFactory?: NgModuleFactory<any>;
            constructor(_viewContainerRef: ViewContainerRef);
            /** @nodoc */
            ngOnChanges(changes: SimpleChanges): void;
            /** @nodoc */
            ngOnDestroy(): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgComponentOutlet, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgComponentOutlet, "[ngComponentOutlet]", never, { "ngComponentOutlet": "ngComponentOutlet"; "ngComponentOutletInjector": "ngComponentOutletInjector"; "ngComponentOutletContent": "ngComponentOutletContent"; "ngComponentOutletNgModule": "ngComponentOutletNgModule"; "ngComponentOutletNgModuleFactory": "ngComponentOutletNgModuleFactory"; }, {}, never, never, true, never>;
    }
    
    /**
        * A [structural directive](guide/structural-directives) that renders
        * a template for each item in a collection.
        * The directive is placed on an element, which becomes the parent
        * of the cloned templates.
        *
        * The `ngForOf` directive is generally used in the
        * [shorthand form](guide/structural-directives#asterisk) `*ngFor`.
        * In this form, the template to be rendered for each iteration is the content
        * of an anchor element containing the directive.
        *
        * The following example shows the shorthand syntax with some options,
        * contained in an `<li>` element.
        *
        * ```
        * <li *ngFor="let item of items; index as i; trackBy: trackByFn">...</li>
        * ```
        *
        * The shorthand form expands into a long form that uses the `ngForOf` selector
        * on an `<ng-template>` element.
        * The content of the `<ng-template>` element is the `<li>` element that held the
        * short-form directive.
        *
        * Here is the expanded version of the short-form example.
        *
        * ```
        * <ng-template ngFor let-item [ngForOf]="items" let-i="index" [ngForTrackBy]="trackByFn">
        *   <li>...</li>
        * </ng-template>
        * ```
        *
        * Angular automatically expands the shorthand syntax as it compiles the template.
        * The context for each embedded view is logically merged to the current component
        * context according to its lexical position.
        *
        * When using the shorthand syntax, Angular allows only [one structural directive
        * on an element](guide/structural-directives#one-per-element).
        * If you want to iterate conditionally, for example,
        * put the `*ngIf` on a container element that wraps the `*ngFor` element.
        * For further discussion, see
        * [Structural Directives](guide/structural-directives#one-per-element).
        *
        * @usageNotes
        *
        * ### Local variables
        *
        * `NgForOf` provides exported values that can be aliased to local variables.
        * For example:
        *
        *  ```
        * <li *ngFor="let user of users; index as i; first as isFirst">
        *    {{i}}/{{users.length}}. {{user}} <span *ngIf="isFirst">default</span>
        * </li>
        * ```
        *
        * The following exported values can be aliased to local variables:
        *
        * - `$implicit: T`: The value of the individual items in the iterable (`ngForOf`).
        * - `ngForOf: NgIterable<T>`: The value of the iterable expression. Useful when the expression is
        * more complex then a property access, for example when using the async pipe (`userStreams |
        * async`).
        * - `index: number`: The index of the current item in the iterable.
        * - `count: number`: The length of the iterable.
        * - `first: boolean`: True when the item is the first item in the iterable.
        * - `last: boolean`: True when the item is the last item in the iterable.
        * - `even: boolean`: True when the item has an even index in the iterable.
        * - `odd: boolean`: True when the item has an odd index in the iterable.
        *
        * ### Change propagation
        *
        * When the contents of the iterator changes, `NgForOf` makes the corresponding changes to the DOM:
        *
        * * When an item is added, a new instance of the template is added to the DOM.
        * * When an item is removed, its template instance is removed from the DOM.
        * * When items are reordered, their respective templates are reordered in the DOM.
        *
        * Angular uses object identity to track insertions and deletions within the iterator and reproduce
        * those changes in the DOM. This has important implications for animations and any stateful
        * controls that are present, such as `<input>` elements that accept user input. Inserted rows can
        * be animated in, deleted rows can be animated out, and unchanged rows retain any unsaved state
        * such as user input.
        * For more on animations, see [Transitions and Triggers](guide/transition-and-triggers).
        *
        * The identities of elements in the iterator can change while the data does not.
        * This can happen, for example, if the iterator is produced from an RPC to the server, and that
        * RPC is re-run. Even if the data hasn't changed, the second response produces objects with
        * different identities, and Angular must tear down the entire DOM and rebuild it (as if all old
        * elements were deleted and all new elements inserted).
        *
        * To avoid this expensive operation, you can customize the default tracking algorithm.
        * by supplying the `trackBy` option to `NgForOf`.
        * `trackBy` takes a function that has two arguments: `index` and `item`.
        * If `trackBy` is given, Angular tracks changes by the return value of the function.
        *
        * @see [Structural Directives](guide/structural-directives)
        * @ngModule CommonModule
        * @publicApi
        */
    class NgForOf<T, U extends NgIterable<T> = NgIterable<T>> implements DoCheck {
            /**
                * The value of the iterable expression, which can be used as a
                * [template input variable](guide/structural-directives#shorthand).
                */
            set ngForOf(ngForOf: U & NgIterable<T> | undefined | null);
            /**
                * Specifies a custom `TrackByFunction` to compute the identity of items in an iterable.
                *
                * If a custom `TrackByFunction` is not provided, `NgForOf` will use the item's [object
                * identity](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is)
                * as the key.
                *
                * `NgForOf` uses the computed key to associate items in an iterable with DOM elements
                * it produces for these items.
                *
                * A custom `TrackByFunction` is useful to provide good user experience in cases when items in an
                * iterable rendered using `NgForOf` have a natural identifier (for example, custom ID or a
                * primary key), and this iterable could be updated with new object instances that still
                * represent the same underlying entity (for example, when data is re-fetched from the server,
                * and the iterable is recreated and re-rendered, but most of the data is still the same).
                *
                * @see `TrackByFunction`
                */
            set ngForTrackBy(fn: TrackByFunction<T>);
            get ngForTrackBy(): TrackByFunction<T>;
            constructor(_viewContainer: ViewContainerRef, _template: TemplateRef<NgForOfContext<T, U>>, _differs: IterableDiffers);
            /**
                * A reference to the template that is stamped out for each item in the iterable.
                * @see [template reference variable](guide/template-reference-variables)
                */
            set ngForTemplate(value: TemplateRef<NgForOfContext<T, U>>);
            /**
                * Applies the changes when needed.
                * @nodoc
                */
            ngDoCheck(): void;
            /**
                * Asserts the correct type of the context for the template that `NgForOf` will render.
                *
                * The presence of this method is a signal to the Ivy template type-check compiler that the
                * `NgForOf` structural directive renders its template with a specific context type.
                */
            static ngTemplateContextGuard<T, U extends NgIterable<T>>(dir: NgForOf<T, U>, ctx: any): ctx is NgForOfContext<T, U>;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgForOf<any, any>, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgForOf<any, any>, "[ngFor][ngForOf]", never, { "ngForOf": "ngForOf"; "ngForTrackBy": "ngForTrackBy"; "ngForTemplate": "ngForTemplate"; }, {}, never, never, true, never>;
    }
    export { NgForOf as NgFor }
    export { NgForOf }
    
    /**
        * @publicApi
        */
    export class NgForOfContext<T, U extends NgIterable<T> = NgIterable<T>> {
            $implicit: T;
            ngForOf: U;
            index: number;
            count: number;
            constructor($implicit: T, ngForOf: U, index: number, count: number);
            get first(): boolean;
            get last(): boolean;
            get even(): boolean;
            get odd(): boolean;
    }
    
    /**
        * A structural directive that conditionally includes a template based on the value of
        * an expression coerced to Boolean.
        * When the expression evaluates to true, Angular renders the template
        * provided in a `then` clause, and when  false or null,
        * Angular renders the template provided in an optional `else` clause. The default
        * template for the `else` clause is blank.
        *
        * A [shorthand form](guide/structural-directives#asterisk) of the directive,
        * `*ngIf="condition"`, is generally used, provided
        * as an attribute of the anchor element for the inserted template.
        * Angular expands this into a more explicit version, in which the anchor element
        * is contained in an `<ng-template>` element.
        *
        * Simple form with shorthand syntax:
        *
        * ```
        * <div *ngIf="condition">Content to render when condition is true.</div>
        * ```
        *
        * Simple form with expanded syntax:
        *
        * ```
        * <ng-template [ngIf]="condition"><div>Content to render when condition is
        * true.</div></ng-template>
        * ```
        *
        * Form with an "else" block:
        *
        * ```
        * <div *ngIf="condition; else elseBlock">Content to render when condition is true.</div>
        * <ng-template #elseBlock>Content to render when condition is false.</ng-template>
        * ```
        *
        * Shorthand form with "then" and "else" blocks:
        *
        * ```
        * <div *ngIf="condition; then thenBlock else elseBlock"></div>
        * <ng-template #thenBlock>Content to render when condition is true.</ng-template>
        * <ng-template #elseBlock>Content to render when condition is false.</ng-template>
        * ```
        *
        * Form with storing the value locally:
        *
        * ```
        * <div *ngIf="condition as value; else elseBlock">{{value}}</div>
        * <ng-template #elseBlock>Content to render when value is null.</ng-template>
        * ```
        *
        * @usageNotes
        *
        * The `*ngIf` directive is most commonly used to conditionally show an inline template,
        * as seen in the following  example.
        * The default `else` template is blank.
        *
        * {@example common/ngIf/ts/module.ts region='NgIfSimple'}
        *
        * ### Showing an alternative template using `else`
        *
        * To display a template when `expression` evaluates to false, use an `else` template
        * binding as shown in the following example.
        * The `else` binding points to an `<ng-template>`  element labeled `#elseBlock`.
        * The template can be defined anywhere in the component view, but is typically placed right after
        * `ngIf` for readability.
        *
        * {@example common/ngIf/ts/module.ts region='NgIfElse'}
        *
        * ### Using an external `then` template
        *
        * In the previous example, the then-clause template is specified inline, as the content of the
        * tag that contains the `ngIf` directive. You can also specify a template that is defined
        * externally, by referencing a labeled `<ng-template>` element. When you do this, you can
        * change which template to use at runtime, as shown in the following example.
        *
        * {@example common/ngIf/ts/module.ts region='NgIfThenElse'}
        *
        * ### Storing a conditional result in a variable
        *
        * You might want to show a set of properties from the same object. If you are waiting
        * for asynchronous data, the object can be undefined.
        * In this case, you can use `ngIf` and store the result of the condition in a local
        * variable as shown in the following example.
        *
        * {@example common/ngIf/ts/module.ts region='NgIfAs'}
        *
        * This code uses only one `AsyncPipe`, so only one subscription is created.
        * The conditional statement stores the result of `userStream|async` in the local variable `user`.
        * You can then bind the local `user` repeatedly.
        *
        * The conditional displays the data only if `userStream` returns a value,
        * so you don't need to use the
        * safe-navigation-operator (`?.`)
        * to guard against null values when accessing properties.
        * You can display an alternative template while waiting for the data.
        *
        * ### Shorthand syntax
        *
        * The shorthand syntax `*ngIf` expands into two separate template specifications
        * for the "then" and "else" clauses. For example, consider the following shorthand statement,
        * that is meant to show a loading page while waiting for data to be loaded.
        *
        * ```
        * <div class="hero-list" *ngIf="heroes else loading">
        *  ...
        * </div>
        *
        * <ng-template #loading>
        *  <div>Loading...</div>
        * </ng-template>
        * ```
        *
        * You can see that the "else" clause references the `<ng-template>`
        * with the `#loading` label, and the template for the "then" clause
        * is provided as the content of the anchor element.
        *
        * However, when Angular expands the shorthand syntax, it creates
        * another `<ng-template>` tag, with `ngIf` and `ngIfElse` directives.
        * The anchor element containing the template for the "then" clause becomes
        * the content of this unlabeled `<ng-template>` tag.
        *
        * ```
        * <ng-template [ngIf]="heroes" [ngIfElse]="loading">
        *  <div class="hero-list">
        *   ...
        *  </div>
        * </ng-template>
        *
        * <ng-template #loading>
        *  <div>Loading...</div>
        * </ng-template>
        * ```
        *
        * The presence of the implicit template object has implications for the nesting of
        * structural directives. For more on this subject, see
        * [Structural Directives](guide/structural-directives#one-per-element).
        *
        * @ngModule CommonModule
        * @publicApi
        */
    export class NgIf<T = unknown> {
            constructor(_viewContainer: ViewContainerRef, templateRef: TemplateRef<NgIfContext<T>>);
            /**
                * The Boolean expression to evaluate as the condition for showing a template.
                */
            set ngIf(condition: T);
            /**
                * A template to show if the condition expression evaluates to true.
                */
            set ngIfThen(templateRef: TemplateRef<NgIfContext<T>> | null);
            /**
                * A template to show if the condition expression evaluates to false.
                */
            set ngIfElse(templateRef: TemplateRef<NgIfContext<T>> | null);
            /**
                * Assert the correct type of the expression bound to the `ngIf` input within the template.
                *
                * The presence of this static field is a signal to the Ivy template type check compiler that
                * when the `NgIf` structural directive renders its template, the type of the expression bound
                * to `ngIf` should be narrowed in some way. For `NgIf`, the binding expression itself is used to
                * narrow its type, which allows the strictNullChecks feature of TypeScript to work with `NgIf`.
                */
            static ngTemplateGuard_ngIf: 'binding';
            /**
                * Asserts the correct type of the context for the template that `NgIf` will render.
                *
                * The presence of this method is a signal to the Ivy template type-check compiler that the
                * `NgIf` structural directive renders its template with a specific context type.
                */
            static ngTemplateContextGuard<T>(dir: NgIf<T>, ctx: any): ctx is NgIfContext<Exclude<T, false | 0 | '' | null | undefined>>;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgIf<any>, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgIf<any>, "[ngIf]", never, { "ngIf": "ngIf"; "ngIfThen": "ngIfThen"; "ngIfElse": "ngIfElse"; }, {}, never, never, true, never>;
    }
    
    /**
        * @publicApi
        */
    export class NgIfContext<T = unknown> {
            $implicit: T;
            ngIf: T;
    }
    
    /**
        * Returns the plural case based on the locale
        *
        * @publicApi
        */
    export class NgLocaleLocalization extends NgLocalization {
            protected locale: string;
            constructor(locale: string);
            getPluralCategory(value: any, locale?: string): string;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgLocaleLocalization, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<NgLocaleLocalization>;
    }
    
    /**
        * @publicApi
        */
    export abstract class NgLocalization {
            abstract getPluralCategory(value: any, locale?: string): string;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgLocalization, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<NgLocalization>;
    }
    
    /**
        * Directive that improves image loading performance by enforcing best practices.
        *
        * `NgOptimizedImage` ensures that the loading of the Largest Contentful Paint (LCP) image is
        * prioritized by:
        * - Automatically setting the `fetchpriority` attribute on the `<img>` tag
        * - Lazy loading non-priority images by default
        * - Asserting that there is a corresponding preconnect link tag in the document head
        *
        * In addition, the directive:
        * - Generates appropriate asset URLs if a corresponding `ImageLoader` function is provided
        * - Automatically generates a srcset
        * - Requires that `width` and `height` are set
        * - Warns if `width` or `height` have been set incorrectly
        * - Warns if the image will be visually distorted when rendered
        *
        * @usageNotes
        * The `NgOptimizedImage` directive is marked as [standalone](guide/standalone-components) and can
        * be imported directly.
        *
        * Follow the steps below to enable and use the directive:
        * 1. Import it into the necessary NgModule or a standalone Component.
        * 2. Optionally provide an `ImageLoader` if you use an image hosting service.
        * 3. Update the necessary `<img>` tags in templates and replace `src` attributes with `ngSrc`.
        * Using a `ngSrc` allows the directive to control when the `src` gets set, which triggers an image
        * download.
        *
        * Step 1: import the `NgOptimizedImage` directive.
        *
        * ```typescript
        * import { NgOptimizedImage } from '@angular/common';
        *
        * // Include it into the necessary NgModule
        * @NgModule({
        *   imports: [NgOptimizedImage],
        * })
        * class AppModule {}
        *
        * // ... or a standalone Component
        * @Component({
        *   standalone: true
        *   imports: [NgOptimizedImage],
        * })
        * class MyStandaloneComponent {}
        * ```
        *
        * Step 2: configure a loader.
        *
        * To use the **default loader**: no additional code changes are necessary. The URL returned by the
        * generic loader will always match the value of "src". In other words, this loader applies no
        * transformations to the resource URL and the value of the `ngSrc` attribute will be used as is.
        *
        * To use an existing loader for a **third-party image service**: add the provider factory for your
        * chosen service to the `providers` array. In the example below, the Imgix loader is used:
        *
        * ```typescript
        * import {provideImgixLoader} from '@angular/common';
        *
        * // Call the function and add the result to the `providers` array:
        * providers: [
        *   provideImgixLoader("https://my.base.url/"),
        * ],
        * ```
        *
        * The `NgOptimizedImage` directive provides the following functions:
        * - `provideCloudflareLoader`
        * - `provideCloudinaryLoader`
        * - `provideImageKitLoader`
        * - `provideImgixLoader`
        *
        * If you use a different image provider, you can create a custom loader function as described
        * below.
        *
        * To use a **custom loader**: provide your loader function as a value for the `IMAGE_LOADER` DI
        * token.
        *
        * ```typescript
        * import {IMAGE_LOADER, ImageLoaderConfig} from '@angular/common';
        *
        * // Configure the loader using the `IMAGE_LOADER` token.
        * providers: [
        *   {
        *      provide: IMAGE_LOADER,
        *      useValue: (config: ImageLoaderConfig) => {
        *        return `https://example.com/${config.src}-${config.width}.jpg}`;
        *      }
        *   },
        * ],
        * ```
        *
        * Step 3: update `<img>` tags in templates to use `ngSrc` instead of `src`.
        *
        * ```
        * <img ngSrc="logo.png" width="200" height="100">
        * ```
        *
        * @publicApi
        */
    export class NgOptimizedImage implements OnInit, OnChanges, OnDestroy {
            /**
                * Name of the source image.
                * Image name will be processed by the image loader and the final URL will be applied as the `src`
                * property of the image.
                */
            ngSrc: string;
            /**
                * A comma separated list of width or density descriptors.
                * The image name will be taken from `ngSrc` and combined with the list of width or density
                * descriptors to generate the final `srcset` property of the image.
                *
                * Example:
                * ```
                * <img ngSrc="hello.jpg" ngSrcset="100w, 200w" />  =>
                * <img src="path/hello.jpg" srcset="path/hello.jpg?w=100 100w, path/hello.jpg?w=200 200w" />
                * ```
                */
            ngSrcset: string;
            /**
                * The base `sizes` attribute passed through to the `<img>` element.
                * Providing sizes causes the image to create an automatic responsive srcset.
                */
            sizes?: string;
            /**
                * For responsive images: the intrinsic width of the image in pixels.
                * For fixed size images: the desired rendered width of the image in pixels.
                */
            set width(value: string | number | undefined);
            get width(): number | undefined;
            /**
                * For responsive images: the intrinsic height of the image in pixels.
                * For fixed size images: the desired rendered height of the image in pixels.* The intrinsic
                * height of the image in pixels.
                */
            set height(value: string | number | undefined);
            get height(): number | undefined;
            /**
                * The desired loading behavior (lazy, eager, or auto).
                *
                * Setting images as loading='eager' or loading='auto' marks them
                * as non-priority images. Avoid changing this input for priority images.
                */
            loading?: 'lazy' | 'eager' | 'auto';
            /**
                * Indicates whether this image should have a high priority.
                */
            set priority(value: string | boolean | undefined);
            get priority(): boolean;
            /**
                * Data to pass through to custom loaders.
                */
            loaderParams?: {
                    [key: string]: any;
            };
            /**
                * Disables automatic srcset generation for this image.
                */
            set disableOptimizedSrcset(value: string | boolean | undefined);
            get disableOptimizedSrcset(): boolean;
            /**
                * Sets the image to "fill mode", which eliminates the height/width requirement and adds
                * styles such that the image fills its containing element.
                *
                * @developerPreview
                */
            set fill(value: string | boolean | undefined);
            get fill(): boolean;
            /** @nodoc */
            ngOnInit(): void;
            /** @nodoc */
            ngOnChanges(changes: SimpleChanges): void;
            /** @nodoc */
            ngOnDestroy(): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgOptimizedImage, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgOptimizedImage, "img[ngSrc]", never, { "ngSrc": "ngSrc"; "ngSrcset": "ngSrcset"; "sizes": "sizes"; "width": "width"; "height": "height"; "loading": "loading"; "priority": "priority"; "loaderParams": "loaderParams"; "disableOptimizedSrcset": "disableOptimizedSrcset"; "fill": "fill"; "src": "src"; "srcset": "srcset"; }, {}, never, never, true, never>;
    }
    
    /**
        * @ngModule CommonModule
        *
        * @usageNotes
        * ```
        * <some-element [ngPlural]="value">
        *   <ng-template ngPluralCase="=0">there is nothing</ng-template>
        *   <ng-template ngPluralCase="=1">there is one</ng-template>
        *   <ng-template ngPluralCase="few">there are a few</ng-template>
        * </some-element>
        * ```
        *
        * @description
        *
        * Adds / removes DOM sub-trees based on a numeric value. Tailored for pluralization.
        *
        * Displays DOM sub-trees that match the switch expression value, or failing that, DOM sub-trees
        * that match the switch expression's pluralization category.
        *
        * To use this directive you must provide a container element that sets the `[ngPlural]` attribute
        * to a switch expression. Inner elements with a `[ngPluralCase]` will display based on their
        * expression:
        * - if `[ngPluralCase]` is set to a value starting with `=`, it will only display if the value
        *   matches the switch expression exactly,
        * - otherwise, the view will be treated as a "category match", and will only display if exact
        *   value matches aren't found and the value maps to its category for the defined locale.
        *
        * See http://cldr.unicode.org/index/cldr-spec/plural-rules
        *
        * @publicApi
        */
    export class NgPlural {
            constructor(_localization: NgLocalization);
            set ngPlural(value: number);
            addCase(value: string, switchView: SwitchView): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgPlural, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgPlural, "[ngPlural]", never, { "ngPlural": "ngPlural"; }, {}, never, never, true, never>;
    }
    
    /**
        * @ngModule CommonModule
        *
        * @description
        *
        * Creates a view that will be added/removed from the parent {@link NgPlural} when the
        * given expression matches the plural expression according to CLDR rules.
        *
        * @usageNotes
        * ```
        * <some-element [ngPlural]="value">
        *   <ng-template ngPluralCase="=0">...</ng-template>
        *   <ng-template ngPluralCase="other">...</ng-template>
        * </some-element>
        *```
        *
        * See {@link NgPlural} for more details and example.
        *
        * @publicApi
        */
    export class NgPluralCase {
            value: string;
            constructor(value: string, template: TemplateRef<Object>, viewContainer: ViewContainerRef, ngPlural: NgPlural);
            static ɵfac: i0.ɵɵFactoryDeclaration<NgPluralCase, [{ attribute: "ngPluralCase"; }, null, null, { host: true; }]>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgPluralCase, "[ngPluralCase]", never, {}, {}, never, never, true, never>;
    }
    
    /**
        * @ngModule CommonModule
        *
        * @usageNotes
        *
        * Set the font of the containing element to the result of an expression.
        *
        * ```
        * <some-element [ngStyle]="{'font-style': styleExp}">...</some-element>
        * ```
        *
        * Set the width of the containing element to a pixel value returned by an expression.
        *
        * ```
        * <some-element [ngStyle]="{'max-width.px': widthExp}">...</some-element>
        * ```
        *
        * Set a collection of style values using an expression that returns key-value pairs.
        *
        * ```
        * <some-element [ngStyle]="objExp">...</some-element>
        * ```
        *
        * @description
        *
        * An attribute directive that updates styles for the containing HTML element.
        * Sets one or more style properties, specified as colon-separated key-value pairs.
        * The key is a style name, with an optional `.<unit>` suffix
        * (such as 'top.px', 'font-style.em').
        * The value is an expression to be evaluated.
        * The resulting non-null value, expressed in the given unit,
        * is assigned to the given style property.
        * If the result of evaluation is null, the corresponding style is removed.
        *
        * @publicApi
        */
    export class NgStyle implements DoCheck {
            constructor(_ngEl: ElementRef, _differs: KeyValueDiffers, _renderer: Renderer2);
            set ngStyle(values: {
                    [klass: string]: any;
            } | null | undefined);
            ngDoCheck(): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgStyle, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgStyle, "[ngStyle]", never, { "ngStyle": "ngStyle"; }, {}, never, never, true, never>;
    }
    
    /**
        * @ngModule CommonModule
        *
        * @description
        * The `[ngSwitch]` directive on a container specifies an expression to match against.
        * The expressions to match are provided by `ngSwitchCase` directives on views within the container.
        * - Every view that matches is rendered.
        * - If there are no matches, a view with the `ngSwitchDefault` directive is rendered.
        * - Elements within the `[NgSwitch]` statement but outside of any `NgSwitchCase`
        * or `ngSwitchDefault` directive are preserved at the location.
        *
        * @usageNotes
        * Define a container element for the directive, and specify the switch expression
        * to match against as an attribute:
        *
        * ```
        * <container-element [ngSwitch]="switch_expression">
        * ```
        *
        * Within the container, `*ngSwitchCase` statements specify the match expressions
        * as attributes. Include `*ngSwitchDefault` as the final case.
        *
        * ```
        * <container-element [ngSwitch]="switch_expression">
        *    <some-element *ngSwitchCase="match_expression_1">...</some-element>
        * ...
        *    <some-element *ngSwitchDefault>...</some-element>
        * </container-element>
        * ```
        *
        * ### Usage Examples
        *
        * The following example shows how to use more than one case to display the same view:
        *
        * ```
        * <container-element [ngSwitch]="switch_expression">
        *   <!-- the same view can be shown in more than one case -->
        *   <some-element *ngSwitchCase="match_expression_1">...</some-element>
        *   <some-element *ngSwitchCase="match_expression_2">...</some-element>
        *   <some-other-element *ngSwitchCase="match_expression_3">...</some-other-element>
        *   <!--default case when there are no matches -->
        *   <some-element *ngSwitchDefault>...</some-element>
        * </container-element>
        * ```
        *
        * The following example shows how cases can be nested:
        * ```
        * <container-element [ngSwitch]="switch_expression">
        *       <some-element *ngSwitchCase="match_expression_1">...</some-element>
        *       <some-element *ngSwitchCase="match_expression_2">...</some-element>
        *       <some-other-element *ngSwitchCase="match_expression_3">...</some-other-element>
        *       <ng-container *ngSwitchCase="match_expression_3">
        *         <!-- use a ng-container to group multiple root nodes -->
        *         <inner-element></inner-element>
        *         <inner-other-element></inner-other-element>
        *       </ng-container>
        *       <some-element *ngSwitchDefault>...</some-element>
        *     </container-element>
        * ```
        *
        * @publicApi
        * @see `NgSwitchCase`
        * @see `NgSwitchDefault`
        * @see [Structural Directives](guide/structural-directives)
        *
        */
    export class NgSwitch {
            set ngSwitch(newValue: any);
            static ɵfac: i0.ɵɵFactoryDeclaration<NgSwitch, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgSwitch, "[ngSwitch]", never, { "ngSwitch": "ngSwitch"; }, {}, never, never, true, never>;
    }
    
    /**
        * @ngModule CommonModule
        *
        * @description
        * Provides a switch case expression to match against an enclosing `ngSwitch` expression.
        * When the expressions match, the given `NgSwitchCase` template is rendered.
        * If multiple match expressions match the switch expression value, all of them are displayed.
        *
        * @usageNotes
        *
        * Within a switch container, `*ngSwitchCase` statements specify the match expressions
        * as attributes. Include `*ngSwitchDefault` as the final case.
        *
        * ```
        * <container-element [ngSwitch]="switch_expression">
        *   <some-element *ngSwitchCase="match_expression_1">...</some-element>
        *   ...
        *   <some-element *ngSwitchDefault>...</some-element>
        * </container-element>
        * ```
        *
        * Each switch-case statement contains an in-line HTML template or template reference
        * that defines the subtree to be selected if the value of the match expression
        * matches the value of the switch expression.
        *
        * Unlike JavaScript, which uses strict equality, Angular uses loose equality.
        * This means that the empty string, `""` matches 0.
        *
        * @publicApi
        * @see `NgSwitch`
        * @see `NgSwitchDefault`
        *
        */
    export class NgSwitchCase implements DoCheck {
            /**
                * Stores the HTML template to be selected on match.
                */
            ngSwitchCase: any;
            constructor(viewContainer: ViewContainerRef, templateRef: TemplateRef<Object>, ngSwitch: NgSwitch);
            /**
                * Performs case matching. For internal use only.
                * @nodoc
                */
            ngDoCheck(): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgSwitchCase, [null, null, { optional: true; host: true; }]>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgSwitchCase, "[ngSwitchCase]", never, { "ngSwitchCase": "ngSwitchCase"; }, {}, never, never, true, never>;
    }
    
    /**
        * @ngModule CommonModule
        *
        * @description
        *
        * Creates a view that is rendered when no `NgSwitchCase` expressions
        * match the `NgSwitch` expression.
        * This statement should be the final case in an `NgSwitch`.
        *
        * @publicApi
        * @see `NgSwitch`
        * @see `NgSwitchCase`
        *
        */
    export class NgSwitchDefault {
            constructor(viewContainer: ViewContainerRef, templateRef: TemplateRef<Object>, ngSwitch: NgSwitch);
            static ɵfac: i0.ɵɵFactoryDeclaration<NgSwitchDefault, [null, null, { optional: true; host: true; }]>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgSwitchDefault, "[ngSwitchDefault]", never, {}, {}, never, never, true, never>;
    }
    
    /**
        * @ngModule CommonModule
        *
        * @description
        *
        * Inserts an embedded view from a prepared `TemplateRef`.
        *
        * You can attach a context object to the `EmbeddedViewRef` by setting `[ngTemplateOutletContext]`.
        * `[ngTemplateOutletContext]` should be an object, the object's keys will be available for binding
        * by the local template `let` declarations.
        *
        * @usageNotes
        * ```
        * <ng-container *ngTemplateOutlet="templateRefExp; context: contextExp"></ng-container>
        * ```
        *
        * Using the key `$implicit` in the context object will set its value as default.
        *
        * ### Example
        *
        * {@example common/ngTemplateOutlet/ts/module.ts region='NgTemplateOutlet'}
        *
        * @publicApi
        */
    export class NgTemplateOutlet implements OnChanges {
            /**
                * A context object to attach to the {@link EmbeddedViewRef}. This should be an
                * object, the object's keys will be available for binding by the local template `let`
                * declarations.
                * Using the key `$implicit` in the context object will set its value as default.
                */
            ngTemplateOutletContext: Object | null;
            /**
                * A string defining the template reference and optionally the context object for the template.
                */
            ngTemplateOutlet: TemplateRef<any> | null;
            /** Injector to be used within the embedded view. */
            ngTemplateOutletInjector: Injector | null;
            constructor(_viewContainerRef: ViewContainerRef);
            /** @nodoc */
            ngOnChanges(changes: SimpleChanges): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<NgTemplateOutlet, never>;
            static ɵdir: i0.ɵɵDirectiveDeclaration<NgTemplateOutlet, "[ngTemplateOutlet]", never, { "ngTemplateOutletContext": "ngTemplateOutletContext"; "ngTemplateOutlet": "ngTemplateOutlet"; "ngTemplateOutletInjector": "ngTemplateOutletInjector"; }, {}, never, never, true, never>;
    }
    
    
    /**
        * Format styles that can be used to represent numbers.
        * @see `getLocaleNumberFormat()`.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export enum NumberFormatStyle {
            Decimal = 0,
            Percent = 1,
            Currency = 2,
            Scientific = 3
    }
    
    /**
        * Symbols that can be used to replace placeholders in number patterns.
        * Examples are based on `en-US` values.
        *
        * @see `getLocaleNumberSymbol()`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export enum NumberSymbol {
            /**
                * Decimal separator.
                * For `en-US`, the dot character.
                * Example: 2,345`.`67
                */
            Decimal = 0,
            /**
                * Grouping separator, typically for thousands.
                * For `en-US`, the comma character.
                * Example: 2`,`345.67
                */
            Group = 1,
            /**
                * List-item separator.
                * Example: "one, two, and three"
                */
            List = 2,
            /**
                * Sign for percentage (out of 100).
                * Example: 23.4%
                */
            PercentSign = 3,
            /**
                * Sign for positive numbers.
                * Example: +23
                */
            PlusSign = 4,
            /**
                * Sign for negative numbers.
                * Example: -23
                */
            MinusSign = 5,
            /**
                * Computer notation for exponential value (n times a power of 10).
                * Example: 1.2E3
                */
            Exponential = 6,
            /**
                * Human-readable format of exponential.
                * Example: 1.2x103
                */
            SuperscriptingExponent = 7,
            /**
                * Sign for permille (out of 1000).
                * Example: 23.4‰
                */
            PerMille = 8,
            /**
                * Infinity, can be used with plus and minus.
                * Example: ∞, +∞, -∞
                */
            Infinity = 9,
            /**
                * Not a number.
                * Example: NaN
                */
            NaN = 10,
            /**
                * Symbol used between time units.
                * Example: 10:52
                */
            TimeSeparator = 11,
            /**
                * Decimal separator for currency values (fallback to `Decimal`).
                * Example: $2,345.67
                */
            CurrencyDecimal = 12,
            /**
                * Group separator for currency values (fallback to `Group`).
                * Example: $2,345.67
                */
            CurrencyGroup = 13
    }
    
    /**
        * @description
        * A {@link LocationStrategy} used to configure the {@link Location} service to
        * represent its state in the
        * [path](https://en.wikipedia.org/wiki/Uniform_Resource_Locator#Syntax) of the
        * browser's URL.
        *
        * If you're using `PathLocationStrategy`, you may provide a {@link APP_BASE_HREF}
        * or add a `<base href>` element to the document to override the default.
        *
        * For instance, if you provide an `APP_BASE_HREF` of `'/my/app/'` and call
        * `location.go('/foo')`, the browser's URL will become
        * `example.com/my/app/foo`. To ensure all relative URIs resolve correctly,
        * the `<base href>` and/or `APP_BASE_HREF` should end with a `/`.
        *
        * Similarly, if you add `<base href='/my/app/'/>` to the document and call
        * `location.go('/foo')`, the browser's URL will become
        * `example.com/my/app/foo`.
        *
        * Note that when using `PathLocationStrategy`, neither the query nor
        * the fragment in the `<base href>` will be preserved, as outlined
        * by the [RFC](https://tools.ietf.org/html/rfc3986#section-5.2.2).
        *
        * @usageNotes
        *
        * ### Example
        *
        * {@example common/location/ts/path_location_component.ts region='LocationComponent'}
        *
        * @publicApi
        */
    export class PathLocationStrategy extends LocationStrategy implements OnDestroy {
            constructor(_platformLocation: PlatformLocation, href?: string);
            /** @nodoc */
            ngOnDestroy(): void;
            onPopState(fn: LocationChangeListener): void;
            getBaseHref(): string;
            prepareExternalUrl(internal: string): string;
            path(includeHash?: boolean): string;
            pushState(state: any, title: string, url: string, queryParams: string): void;
            replaceState(state: any, title: string, url: string, queryParams: string): void;
            forward(): void;
            back(): void;
            getState(): unknown;
            historyGo(relativePosition?: number): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<PathLocationStrategy, [null, { optional: true; }]>;
            static ɵprov: i0.ɵɵInjectableDeclaration<PathLocationStrategy>;
    }
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Transforms a number to a percentage
        * string, formatted according to locale rules that determine group sizing and
        * separator, decimal-point character, and other locale-specific
        * configurations.
        *
        * @see `formatPercent()`
        *
        * @usageNotes
        * The following code shows how the pipe transforms numbers
        * into text strings, according to various format specifications,
        * where the caller's default locale is `en-US`.
        *
        * <code-example path="common/pipes/ts/percent_pipe.ts" region='PercentPipe'></code-example>
        *
        * @publicApi
        */
    export class PercentPipe implements PipeTransform {
            constructor(_locale: string);
            transform(value: number | string, digitsInfo?: string, locale?: string): string | null;
            transform(value: null | undefined, digitsInfo?: string, locale?: string): null;
            transform(value: number | string | null | undefined, digitsInfo?: string, locale?: string): string | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<PercentPipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<PercentPipe, "percent", true>;
    }
    
    /**
        * This class should not be used directly by an application developer. Instead, use
        * {@link Location}.
        *
        * `PlatformLocation` encapsulates all calls to DOM APIs, which allows the Router to be
        * platform-agnostic.
        * This means that we can have different implementation of `PlatformLocation` for the different
        * platforms that Angular supports. For example, `@angular/platform-browser` provides an
        * implementation specific to the browser environment, while `@angular/platform-server` provides
        * one suitable for use with server-side rendering.
        *
        * The `PlatformLocation` class is used directly by all implementations of {@link LocationStrategy}
        * when they need to interact with the DOM APIs like pushState, popState, etc.
        *
        * {@link LocationStrategy} in turn is used by the {@link Location} service which is used directly
        * by the {@link Router} in order to navigate between routes. Since all interactions between {@link
        * Router} /
        * {@link Location} / {@link LocationStrategy} and DOM APIs flow through the `PlatformLocation`
        * class, they are all platform-agnostic.
        *
        * @publicApi
        */
    export abstract class PlatformLocation {
            abstract getBaseHrefFromDOM(): string;
            abstract getState(): unknown;
            /**
                * Returns a function that, when executed, removes the `popstate` event handler.
                */
            abstract onPopState(fn: LocationChangeListener): VoidFunction;
            /**
                * Returns a function that, when executed, removes the `hashchange` event handler.
                */
            abstract onHashChange(fn: LocationChangeListener): VoidFunction;
            abstract get href(): string;
            abstract get protocol(): string;
            abstract get hostname(): string;
            abstract get port(): string;
            abstract get pathname(): string;
            abstract get search(): string;
            abstract get hash(): string;
            abstract replaceState(state: any, title: string, url: string): void;
            abstract pushState(state: any, title: string, url: string): void;
            abstract forward(): void;
            abstract back(): void;
            historyGo?(relativePosition: number): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<PlatformLocation, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<PlatformLocation>;
    }
    
    /**
        * Plurality cases used for translating plurals to different languages.
        *
        * @see `NgPlural`
        * @see `NgPluralCase`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        *
        * @publicApi
        */
    export enum Plural {
            Zero = 0,
            One = 1,
            Two = 2,
            Few = 3,
            Many = 4,
            Other = 5
    }
    
    /** @publicApi */
    interface PopStateEvent_2 {
            pop?: boolean;
            state?: any;
            type?: string;
            url?: string;
    }
    export { PopStateEvent_2 as PopStateEvent }
    
    /**
        * Injection token to configure which origins should be excluded
        * from the preconnect checks. It can either be a single string or an array of strings
        * to represent a group of origins, for example:
        *
        * ```typescript
        *  {provide: PRECONNECT_CHECK_BLOCKLIST, useValue: 'https://your-domain.com'}
        * ```
        *
        * or:
        *
        * ```typescript
        *  {provide: PRECONNECT_CHECK_BLOCKLIST,
        *   useValue: ['https://your-domain-1.com', 'https://your-domain-2.com']}
        * ```
        *
        * @publicApi
        */
    export const PRECONNECT_CHECK_BLOCKLIST: InjectionToken<(string | string[])[]>;
    
    /**
        * Function that generates an ImageLoader for [Cloudflare Image
        * Resizing](https://developers.cloudflare.com/images/image-resizing/) and turns it into an Angular
        * provider. Note: Cloudflare has multiple image products - this provider is specifically for
        * Cloudflare Image Resizing; it will not work with Cloudflare Images or Cloudflare Polish.
        *
        * @param path Your domain name, e.g. https://mysite.com
        * @returns Provider that provides an ImageLoader function
        *
        * @publicApi
        */
    export const provideCloudflareLoader: (path: string) => Provider[];
    
    /**
        * Function that generates an ImageLoader for Cloudinary and turns it into an Angular provider.
        *
        * @param path Base URL of your Cloudinary images
        * This URL should match one of the following formats:
        * https://res.cloudinary.com/mysite
        * https://mysite.cloudinary.com
        * https://subdomain.mysite.com
        * @returns Set of providers to configure the Cloudinary loader.
        *
        * @publicApi
        */
    export const provideCloudinaryLoader: (path: string) => Provider[];
    
    /**
        * Function that generates an ImageLoader for ImageKit and turns it into an Angular provider.
        *
        * @param path Base URL of your ImageKit images
        * This URL should match one of the following formats:
        * https://ik.imagekit.io/myaccount
        * https://subdomain.mysite.com
        * @returns Set of providers to configure the ImageKit loader.
        *
        * @publicApi
        */
    export const provideImageKitLoader: (path: string) => Provider[];
    
    /**
        * Function that generates an ImageLoader for Imgix and turns it into an Angular provider.
        *
        * @param path path to the desired Imgix origin,
        * e.g. https://somepath.imgix.net or https://images.mysite.com
        * @returns Set of providers to configure the Imgix loader.
        *
        * @publicApi
        */
    export const provideImgixLoader: (path: string) => Provider[];
    
    
    /**
        * Register global data to be used internally by Angular. See the
        * ["I18n guide"](guide/i18n-common-format-data-locale) to know how to import additional locale
        * data.
        *
        * The signature registerLocaleData(data: any, extraData?: any) is deprecated since v5.1
        *
        * @publicApi
        */
    export function registerLocaleData(data: any, localeId?: string | any, extraData?: any): void;
    
    /**
        * @ngModule CommonModule
        * @description
        *
        * Creates a new `Array` or `String` containing a subset (slice) of the elements.
        *
        * @usageNotes
        *
        * All behavior is based on the expected behavior of the JavaScript API `Array.prototype.slice()`
        * and `String.prototype.slice()`.
        *
        * When operating on an `Array`, the returned `Array` is always a copy even when all
        * the elements are being returned.
        *
        * When operating on a blank value, the pipe returns the blank value.
        *
        * ### List Example
        *
        * This `ngFor` example:
        *
        * {@example common/pipes/ts/slice_pipe.ts region='SlicePipe_list'}
        *
        * produces the following:
        *
        * ```html
        * <li>b</li>
        * <li>c</li>
        * ```
        *
        * ### String Examples
        *
        * {@example common/pipes/ts/slice_pipe.ts region='SlicePipe_string'}
        *
        * @publicApi
        */
    export class SlicePipe implements PipeTransform {
            /**
                * @param value a list or a string to be sliced.
                * @param start the starting index of the subset to return:
                *   - **a positive integer**: return the item at `start` index and all items after
                *     in the list or string expression.
                *   - **a negative integer**: return the item at `start` index from the end and all items after
                *     in the list or string expression.
                *   - **if positive and greater than the size of the expression**: return an empty list or
                * string.
                *   - **if negative and greater than the size of the expression**: return entire list or string.
                * @param end the ending index of the subset to return:
                *   - **omitted**: return all items until the end.
                *   - **if positive**: return all items before `end` index of the list or string.
                *   - **if negative**: return all items before `end` index from the end of the list or string.
                */
            transform<T>(value: ReadonlyArray<T>, start: number, end?: number): Array<T>;
            transform(value: null | undefined, start: number, end?: number): null;
            transform<T>(value: ReadonlyArray<T> | null | undefined, start: number, end?: number): Array<T> | null;
            transform(value: string, start: number, end?: number): string;
            transform(value: string | null | undefined, start: number, end?: number): string | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<SlicePipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<SlicePipe, "slice", true>;
    }
    
    class SwitchView {
            constructor(_viewContainerRef: ViewContainerRef, _templateRef: TemplateRef<Object>);
            create(): void;
            destroy(): void;
            enforceState(created: boolean): void;
    }
    
    /**
        * Represents a time value with hours and minutes.
        *
        * @publicApi
        */
    export type Time = {
            hours: number;
            minutes: number;
    };
    
    /**
        * Transforms text to title case.
        * Capitalizes the first letter of each word and transforms the
        * rest of the word to lower case.
        * Words are delimited by any whitespace character, such as a space, tab, or line-feed character.
        *
        * @see `LowerCasePipe`
        * @see `UpperCasePipe`
        *
        * @usageNotes
        * The following example shows the result of transforming various strings into title case.
        *
        * <code-example path="common/pipes/ts/titlecase_pipe.ts" region='TitleCasePipe'></code-example>
        *
        * @ngModule CommonModule
        * @publicApi
        */
    export class TitleCasePipe implements PipeTransform {
            /**
                * @param value The string to transform to title case.
                */
            transform(value: string): string;
            transform(value: null | undefined): null;
            transform(value: string | null | undefined): string | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<TitleCasePipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<TitleCasePipe, "titlecase", true>;
    }
    
    /**
        * String widths available for translations.
        * The specific character widths are locale-specific.
        * Examples are given for the word "Sunday" in English.
        *
        * @publicApi
        */
    export enum TranslationWidth {
            /** 1 character for `en-US`. For example: 'S' */
            Narrow = 0,
            /** 3 characters for `en-US`. For example: 'Sun' */
            Abbreviated = 1,
            /** Full length for `en-US`. For example: "Sunday" */
            Wide = 2,
            /** 2 characters for `en-US`, For example: "Su" */
            Short = 3
    }
    
    /**
        * Transforms text to all upper case.
        * @see `LowerCasePipe`
        * @see `TitleCasePipe`
        *
        * @ngModule CommonModule
        * @publicApi
        */
    export class UpperCasePipe implements PipeTransform {
            /**
                * @param value The string to transform to upper case.
                */
            transform(value: string): string;
            transform(value: null | undefined): null;
            transform(value: string | null | undefined): string | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<UpperCasePipe, never>;
            static ɵpipe: i0.ɵɵPipeDeclaration<UpperCasePipe, "uppercase", true>;
    }
    
    /**
        * @publicApi
        */
    export const VERSION: Version;
    
    
    /**
        * Defines a scroll position manager. Implemented by `BrowserViewportScroller`.
        *
        * @publicApi
        */
    export abstract class ViewportScroller {
            /** @nocollapse */
            static ɵprov: unknown;
            /**
                * Configures the top offset used when scrolling to an anchor.
                * @param offset A position in screen coordinates (a tuple with x and y values)
                * or a function that returns the top offset position.
                *
                */
            abstract setOffset(offset: [number, number] | (() => [number, number])): void;
            /**
                * Retrieves the current scroll position.
                * @returns A position in screen coordinates (a tuple with x and y values).
                */
            abstract getScrollPosition(): [number, number];
            /**
                * Scrolls to a specified position.
                * @param position A position in screen coordinates (a tuple with x and y values).
                */
            abstract scrollToPosition(position: [number, number]): void;
            /**
                * Scrolls to an anchor element.
                * @param anchor The ID of the anchor element.
                */
            abstract scrollToAnchor(anchor: string): void;
            /**
                * Disables automatic scroll restoration provided by the browser.
                * See also [window.history.scrollRestoration
                * info](https://developers.google.com/web/updates/2015/09/history-api-scroll-restoration).
                */
            abstract setHistoryScrollRestoration(scrollRestoration: 'auto' | 'manual'): void;
    }
    
    /**
        * The value for each day of the week, based on the `en-US` locale
        *
        * @publicApi
        */
    export enum WeekDay {
            Sunday = 0,
            Monday = 1,
            Tuesday = 2,
            Wednesday = 3,
            Thursday = 4,
            Friday = 5,
            Saturday = 6
    }
    
    
    /**
        * A wrapper around the `XMLHttpRequest` constructor.
        *
        * @publicApi
        */
    export abstract class XhrFactory {
            abstract build(): XMLHttpRequest;
    }
    
    /**
        * Provides DOM operations in an environment-agnostic way.
        *
        * @security Tread carefully! Interacting with the DOM directly is dangerous and
        * can introduce XSS risks.
        */
    export abstract class ɵDomAdapter {
            abstract dispatchEvent(el: any, evt: any): any;
            abstract readonly supportsDOMEvents: boolean;
            abstract remove(el: any): void;
            abstract createElement(tagName: any, doc?: any): HTMLElement;
            abstract createHtmlDocument(): Document;
            abstract getDefaultDocument(): Document;
            abstract isElementNode(node: any): boolean;
            abstract isShadowRoot(node: any): boolean;
            abstract onAndCancel(el: any, evt: any, listener: any): Function;
            abstract getGlobalEventTarget(doc: Document, target: string): any;
            abstract getBaseHref(doc: Document): string | null;
            abstract resetBaseElement(): void;
            abstract getUserAgent(): string;
            abstract getCookie(name: string): string | null;
    }
    
    
    export function ɵgetDOM(): ɵDomAdapter;
    
    /**
        * Provides an empty implementation of the viewport scroller.
        */
    export class ɵNullViewportScroller implements ViewportScroller {
            /**
                * Empty implementation
                */
            setOffset(offset: [number, number] | (() => [number, number])): void;
            /**
                * Empty implementation
                */
            getScrollPosition(): [number, number];
            /**
                * Empty implementation
                */
            scrollToPosition(position: [number, number]): void;
            /**
                * Empty implementation
                */
            scrollToAnchor(anchor: string): void;
            /**
                * Empty implementation
                */
            setHistoryScrollRestoration(scrollRestoration: 'auto' | 'manual'): void;
    }
    
    
    export function ɵparseCookieValue(cookieStr: string, name: string): string | null;
    
    
    export const ɵPLATFORM_BROWSER_ID = "browser";
    
    export const ɵPLATFORM_SERVER_ID = "server";
    
    export const ɵPLATFORM_WORKER_APP_ID = "browserWorkerApp";
    
    export const ɵPLATFORM_WORKER_UI_ID = "browserWorkerUi";
    
    export function ɵsetRootDomAdapter(adapter: ɵDomAdapter): void;
    
    export { }
}

// Generated by dts-bundle v0.7.3

declare module '@angular/compiler' {
    
    
    /**
        * Records the absolute position of a text span in a source file, where `start` and `end` are the
        * starting and ending byte offsets, respectively, of the text span in a source file.
        */
    export class AbsoluteSourceSpan {
            readonly start: number;
            readonly end: number;
            constructor(start: number, end: number);
    }
    
    /**
        * A data structure which captures the animation trigger names that are statically resolvable
        * and whether some names could not be statically evaluated.
        */
    export interface AnimationTriggerNames {
            includesDynamicAnimations: boolean;
            staticTriggerNames: string[];
    }
    
    function areAllEquivalent<T extends {
            isEquivalent(other: T): boolean;
    }>(base: T[], other: T[]): boolean;
    
    export class ArrayType extends Type {
            of: Type;
            constructor(of: Type, modifiers?: TypeModifier);
            visitType(visitor: TypeVisitor, context: any): any;
    }
    
    export abstract class AST {
            span: ParseSpan;
            /**
                * Absolute location of the expression AST in a source code file.
                */
            sourceSpan: AbsoluteSourceSpan;
            constructor(span: ParseSpan, 
            /**
                * Absolute location of the expression AST in a source code file.
                */
            sourceSpan: AbsoluteSourceSpan);
            abstract visit(visitor: AstVisitor, context?: any): any;
            toString(): string;
    }
    
    export class AstMemoryEfficientTransformer implements AstVisitor {
            visitImplicitReceiver(ast: ImplicitReceiver, context: any): AST;
            visitThisReceiver(ast: ThisReceiver, context: any): AST;
            visitInterpolation(ast: Interpolation, context: any): Interpolation;
            visitLiteralPrimitive(ast: LiteralPrimitive, context: any): AST;
            visitPropertyRead(ast: PropertyRead, context: any): AST;
            visitPropertyWrite(ast: PropertyWrite, context: any): AST;
            visitSafePropertyRead(ast: SafePropertyRead, context: any): AST;
            visitLiteralArray(ast: LiteralArray, context: any): AST;
            visitLiteralMap(ast: LiteralMap, context: any): AST;
            visitUnary(ast: Unary, context: any): AST;
            visitBinary(ast: Binary, context: any): AST;
            visitPrefixNot(ast: PrefixNot, context: any): AST;
            visitNonNullAssert(ast: NonNullAssert, context: any): AST;
            visitConditional(ast: Conditional, context: any): AST;
            visitPipe(ast: BindingPipe, context: any): AST;
            visitKeyedRead(ast: KeyedRead, context: any): AST;
            visitKeyedWrite(ast: KeyedWrite, context: any): AST;
            visitAll(asts: any[]): any[];
            visitChain(ast: Chain, context: any): AST;
            visitCall(ast: Call, context: any): AST;
            visitSafeCall(ast: SafeCall, context: any): AST;
            visitSafeKeyedRead(ast: SafeKeyedRead, context: any): AST;
    }
    
    export class AstTransformer implements AstVisitor {
            visitImplicitReceiver(ast: ImplicitReceiver, context: any): AST;
            visitThisReceiver(ast: ThisReceiver, context: any): AST;
            visitInterpolation(ast: Interpolation, context: any): AST;
            visitLiteralPrimitive(ast: LiteralPrimitive, context: any): AST;
            visitPropertyRead(ast: PropertyRead, context: any): AST;
            visitPropertyWrite(ast: PropertyWrite, context: any): AST;
            visitSafePropertyRead(ast: SafePropertyRead, context: any): AST;
            visitLiteralArray(ast: LiteralArray, context: any): AST;
            visitLiteralMap(ast: LiteralMap, context: any): AST;
            visitUnary(ast: Unary, context: any): AST;
            visitBinary(ast: Binary, context: any): AST;
            visitPrefixNot(ast: PrefixNot, context: any): AST;
            visitNonNullAssert(ast: NonNullAssert, context: any): AST;
            visitConditional(ast: Conditional, context: any): AST;
            visitPipe(ast: BindingPipe, context: any): AST;
            visitKeyedRead(ast: KeyedRead, context: any): AST;
            visitKeyedWrite(ast: KeyedWrite, context: any): AST;
            visitCall(ast: Call, context: any): AST;
            visitSafeCall(ast: SafeCall, context: any): AST;
            visitAll(asts: any[]): any[];
            visitChain(ast: Chain, context: any): AST;
            visitSafeKeyedRead(ast: SafeKeyedRead, context: any): AST;
    }
    
    export interface AstVisitor {
            /**
                * The `visitUnary` method is declared as optional for backwards compatibility. In an upcoming
                * major release, this method will be made required.
                */
            visitUnary?(ast: Unary, context: any): any;
            visitBinary(ast: Binary, context: any): any;
            visitChain(ast: Chain, context: any): any;
            visitConditional(ast: Conditional, context: any): any;
            /**
                * The `visitThisReceiver` method is declared as optional for backwards compatibility.
                * In an upcoming major release, this method will be made required.
                */
            visitThisReceiver?(ast: ThisReceiver, context: any): any;
            visitImplicitReceiver(ast: ImplicitReceiver, context: any): any;
            visitInterpolation(ast: Interpolation, context: any): any;
            visitKeyedRead(ast: KeyedRead, context: any): any;
            visitKeyedWrite(ast: KeyedWrite, context: any): any;
            visitLiteralArray(ast: LiteralArray, context: any): any;
            visitLiteralMap(ast: LiteralMap, context: any): any;
            visitLiteralPrimitive(ast: LiteralPrimitive, context: any): any;
            visitPipe(ast: BindingPipe, context: any): any;
            visitPrefixNot(ast: PrefixNot, context: any): any;
            visitNonNullAssert(ast: NonNullAssert, context: any): any;
            visitPropertyRead(ast: PropertyRead, context: any): any;
            visitPropertyWrite(ast: PropertyWrite, context: any): any;
            visitSafePropertyRead(ast: SafePropertyRead, context: any): any;
            visitSafeKeyedRead(ast: SafeKeyedRead, context: any): any;
            visitCall(ast: Call, context: any): any;
            visitSafeCall(ast: SafeCall, context: any): any;
            visitASTWithSource?(ast: ASTWithSource, context: any): any;
            /**
                * This function is optionally defined to allow classes that implement this
                * interface to selectively decide if the specified `ast` should be visited.
                * @param ast node to visit
                * @param context context that gets passed to the node and all its children
                */
            visit?(ast: AST, context?: any): any;
    }
    
    export abstract class ASTWithName extends AST {
            nameSpan: AbsoluteSourceSpan;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, nameSpan: AbsoluteSourceSpan);
    }
    
    export class ASTWithSource extends AST {
            ast: AST;
            source: string | null;
            location: string;
            errors: ParserError[];
            constructor(ast: AST, source: string | null, location: string, absoluteOffset: number, errors: ParserError[]);
            visit(visitor: AstVisitor, context?: any): any;
            toString(): string;
    }
    
    export class Attribute extends NodeWithI18n {
            name: string;
            value: string;
            readonly keySpan: ParseSourceSpan | undefined;
            valueSpan: ParseSourceSpan | undefined;
            valueTokens: InterpolatedAttributeToken[] | undefined;
            constructor(name: string, value: string, sourceSpan: ParseSourceSpan, keySpan: ParseSourceSpan | undefined, valueSpan: ParseSourceSpan | undefined, valueTokens: InterpolatedAttributeToken[] | undefined, i18n: I18nMeta_2 | undefined);
            visit(visitor: Visitor, context: any): any;
    }
    
    /**
        * A set of marker values to be used in the attributes arrays. These markers indicate that some
        * items are not regular attributes and the processing should be adapted accordingly.
        */
    const enum AttributeMarker {
            /**
                * Marker indicates that the following 3 values in the attributes array are:
                * namespaceUri, attributeName, attributeValue
                * in that order.
                */
            NamespaceURI = 0,
            /**
                * Signals class declaration.
                *
                * Each value following `Classes` designates a class name to include on the element.
                * ## Example:
                *
                * Given:
                * ```
                * <div class="foo bar baz">...<d/vi>
                * ```
                *
                * the generated code is:
                * ```
                * var _c1 = [AttributeMarker.Classes, 'foo', 'bar', 'baz'];
                * ```
                */
            Classes = 1,
            /**
                * Signals style declaration.
                *
                * Each pair of values following `Styles` designates a style name and value to include on the
                * element.
                * ## Example:
                *
                * Given:
                * ```
                * <div style="width:100px; height:200px; color:red">...</div>
                * ```
                *
                * the generated code is:
                * ```
                * var _c1 = [AttributeMarker.Styles, 'width', '100px', 'height'. '200px', 'color', 'red'];
                * ```
                */
            Styles = 2,
            /**
                * Signals that the following attribute names were extracted from input or output bindings.
                *
                * For example, given the following HTML:
                *
                * ```
                * <div moo="car" [foo]="exp" (bar)="doSth()">
                * ```
                *
                * the generated code is:
                *
                * ```
                * var _c1 = ['moo', 'car', AttributeMarker.Bindings, 'foo', 'bar'];
                * ```
                */
            Bindings = 3,
            /**
                * Signals that the following attribute names were hoisted from an inline-template declaration.
                *
                * For example, given the following HTML:
                *
                * ```
                * <div *ngFor="let value of values; trackBy:trackBy" dirA [dirB]="value">
                * ```
                *
                * the generated code for the `template()` instruction would include:
                *
                * ```
                * ['dirA', '', AttributeMarker.Bindings, 'dirB', AttributeMarker.Template, 'ngFor', 'ngForOf',
                * 'ngForTrackBy', 'let-value']
                * ```
                *
                * while the generated code for the `element()` instruction inside the template function would
                * include:
                *
                * ```
                * ['dirA', '', AttributeMarker.Bindings, 'dirB']
                * ```
                */
            Template = 4,
            /**
                * Signals that the following attribute is `ngProjectAs` and its value is a parsed `CssSelector`.
                *
                * For example, given the following HTML:
                *
                * ```
                * <h1 attr="value" ngProjectAs="[title]">
                * ```
                *
                * the generated code for the `element()` instruction would include:
                *
                * ```
                * ['attr', 'value', AttributeMarker.ProjectAs, ['', 'title', '']]
                * ```
                */
            ProjectAs = 5,
            /**
                * Signals that the following attribute will be translated by runtime i18n
                *
                * For example, given the following HTML:
                *
                * ```
                * <div moo="car" foo="value" i18n-foo [bar]="binding" i18n-bar>
                * ```
                *
                * the generated code is:
                *
                * ```
                * var _c1 = ['moo', 'car', AttributeMarker.I18n, 'foo', 'bar'];
                */
            I18n = 6
    }
    
    interface AttributeValueInterpolationToken extends TokenBase {
            type: TokenType_2.ATTR_VALUE_INTERPOLATION;
            parts: [startMarker: string, expression: string, endMarker: string] | [
            startMarker: string,
            expression: string
            ];
    }
    
    interface AttributeValueTextToken extends TokenBase {
            type: TokenType_2.ATTR_VALUE_TEXT;
            parts: [value: string];
    }
    
    interface BaseNode {
            sourceSpan: ParseSourceSpan;
            visit(visitor: Visitor, context: any): any;
    }
    
    export class Binary extends AST {
            operation: string;
            left: AST;
            right: AST;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, operation: string, left: AST, right: AST);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export enum BinaryOperator {
            Equals = 0,
            NotEquals = 1,
            Identical = 2,
            NotIdentical = 3,
            Minus = 4,
            Plus = 5,
            Divide = 6,
            Multiply = 7,
            Modulo = 8,
            And = 9,
            Or = 10,
            BitwiseAnd = 11,
            Lower = 12,
            LowerEquals = 13,
            Bigger = 14,
            BiggerEquals = 15,
            NullishCoalesce = 16
    }
    
    export class BinaryOperatorExpr extends Expression {
            operator: BinaryOperator;
            rhs: Expression;
            parens: boolean;
            lhs: Expression;
            constructor(operator: BinaryOperator, lhs: Expression, rhs: Expression, type?: Type | null, sourceSpan?: ParseSourceSpan | null, parens?: boolean);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    /**
        * Parses bindings in templates and in the directive host area.
        */
    class BindingParser {
            errors: ParseError[];
            constructor(_exprParser: Parser, _interpolationConfig: InterpolationConfig, _schemaRegistry: ElementSchemaRegistry, errors: ParseError[]);
            get interpolationConfig(): InterpolationConfig;
            createBoundHostProperties(properties: HostProperties, sourceSpan: ParseSourceSpan): ParsedProperty[] | null;
            createDirectiveHostEventAsts(hostListeners: HostListeners, sourceSpan: ParseSourceSpan): ParsedEvent[] | null;
            parseInterpolation(value: string, sourceSpan: ParseSourceSpan, interpolatedTokens: InterpolatedAttributeToken[] | InterpolatedTextToken[] | null): ASTWithSource;
            /**
                * Similar to `parseInterpolation`, but treats the provided string as a single expression
                * element that would normally appear within the interpolation prefix and suffix (`{{` and `}}`).
                * This is used for parsing the switch expression in ICUs.
                */
            parseInterpolationExpression(expression: string, sourceSpan: ParseSourceSpan): ASTWithSource;
            /**
                * Parses the bindings in a microsyntax expression, and converts them to
                * `ParsedProperty` or `ParsedVariable`.
                *
                * @param tplKey template binding name
                * @param tplValue template binding value
                * @param sourceSpan span of template binding relative to entire the template
                * @param absoluteValueOffset start of the tplValue relative to the entire template
                * @param targetMatchableAttrs potential attributes to match in the template
                * @param targetProps target property bindings in the template
                * @param targetVars target variables in the template
                */
            parseInlineTemplateBinding(tplKey: string, tplValue: string, sourceSpan: ParseSourceSpan, absoluteValueOffset: number, targetMatchableAttrs: string[][], targetProps: ParsedProperty[], targetVars: ParsedVariable[], isIvyAst: boolean): void;
            parseLiteralAttr(name: string, value: string | null, sourceSpan: ParseSourceSpan, absoluteOffset: number, valueSpan: ParseSourceSpan | undefined, targetMatchableAttrs: string[][], targetProps: ParsedProperty[], keySpan: ParseSourceSpan): void;
            parsePropertyBinding(name: string, expression: string, isHost: boolean, sourceSpan: ParseSourceSpan, absoluteOffset: number, valueSpan: ParseSourceSpan | undefined, targetMatchableAttrs: string[][], targetProps: ParsedProperty[], keySpan: ParseSourceSpan): void;
            parsePropertyInterpolation(name: string, value: string, sourceSpan: ParseSourceSpan, valueSpan: ParseSourceSpan | undefined, targetMatchableAttrs: string[][], targetProps: ParsedProperty[], keySpan: ParseSourceSpan, interpolatedTokens: InterpolatedAttributeToken[] | InterpolatedTextToken[] | null): boolean;
            createBoundElementProperty(elementSelector: string, boundProp: ParsedProperty, skipValidation?: boolean, mapPropertyName?: boolean): BoundElementProperty;
            parseEvent(name: string, expression: string, isAssignmentEvent: boolean, sourceSpan: ParseSourceSpan, handlerSpan: ParseSourceSpan, targetMatchableAttrs: string[][], targetEvents: ParsedEvent[], keySpan: ParseSourceSpan): void;
            calcPossibleSecurityContexts(selector: string, propName: string, isAttribute: boolean): SecurityContext[];
    }
    
    export class BindingPipe extends ASTWithName {
            exp: AST;
            name: string;
            args: any[];
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, exp: AST, name: string, args: any[], nameSpan: AbsoluteSourceSpan);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export const enum BindingType {
            Property = 0,
            Attribute = 1,
            Class = 2,
            Style = 3,
            Animation = 4
    }
    
    const BOOL_TYPE: BuiltinType;
    
    export class BoundElementProperty {
            name: string;
            type: BindingType;
            securityContext: SecurityContext;
            value: ASTWithSource;
            unit: string | null;
            sourceSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan | undefined;
            valueSpan: ParseSourceSpan | undefined;
            constructor(name: string, type: BindingType, securityContext: SecurityContext, value: ASTWithSource, unit: string | null, sourceSpan: ParseSourceSpan, keySpan: ParseSourceSpan | undefined, valueSpan: ParseSourceSpan | undefined);
    }
    
    /**
        * Result of performing the binding operation against a `Target`.
        *
        * The original `Target` is accessible, as well as a suite of methods for extracting binding
        * information regarding the `Target`.
        *
        * @param DirectiveT directive metadata type
        */
    export interface BoundTarget<DirectiveT extends DirectiveMeta> {
            /**
                * Get the original `Target` that was bound.
                */
            readonly target: Target;
            /**
                * For a given template node (either an `Element` or a `Template`), get the set of directives
                * which matched the node, if any.
                */
            getDirectivesOfNode(node: TmplAstElement | TmplAstTemplate): DirectiveT[] | null;
            /**
                * For a given `Reference`, get the reference's target - either an `Element`, a `Template`, or
                * a directive on a particular node.
                */
            getReferenceTarget(ref: TmplAstReference): {
                    directive: DirectiveT;
                    node: TmplAstElement | TmplAstTemplate;
            } | TmplAstElement | TmplAstTemplate | null;
            /**
                * For a given binding, get the entity to which the binding is being made.
                *
                * This will either be a directive or the node itself.
                */
            getConsumerOfBinding(binding: TmplAstBoundAttribute | TmplAstBoundEvent | TmplAstTextAttribute): DirectiveT | TmplAstElement | TmplAstTemplate | null;
            /**
                * If the given `AST` expression refers to a `Reference` or `Variable` within the `Target`, then
                * return that.
                *
                * Otherwise, returns `null`.
                *
                * This is only defined for `AST` expressions that read or write to a property of an
                * `ImplicitReceiver`.
                */
            getExpressionTarget(expr: AST): TmplAstReference | TmplAstVariable | null;
            /**
                * Given a particular `Reference` or `Variable`, get the `Template` which created it.
                *
                * All `Variable`s are defined on templates, so this will always return a value for a `Variable`
                * from the `Target`. For `Reference`s this only returns a value if the `Reference` points to a
                * `Template`. Returns `null` otherwise.
                */
            getTemplateOfSymbol(symbol: TmplAstReference | TmplAstVariable): TmplAstTemplate | null;
            /**
                * Get the nesting level of a particular `Template`.
                *
                * This starts at 1 for top-level `Template`s within the `Target` and increases for `Template`s
                * nested at deeper levels.
                */
            getNestingLevel(template: TmplAstTemplate): number;
            /**
                * Get all `Reference`s and `Variables` visible within the given `Template` (or at the top level,
                * if `null` is passed).
                */
            getEntitiesInTemplateScope(template: TmplAstTemplate | null): ReadonlySet<TmplAstReference | TmplAstVariable>;
            /**
                * Get a list of all the directives used by the target.
                */
            getUsedDirectives(): DirectiveT[];
            /**
                * Get a list of all the pipes used by the target.
                */
            getUsedPipes(): string[];
    }
    
    export class BuiltinType extends Type {
            name: BuiltinTypeName;
            constructor(name: BuiltinTypeName, modifiers?: TypeModifier);
            visitType(visitor: TypeVisitor, context: any): any;
    }
    
    export enum BuiltinTypeName {
            Dynamic = 0,
            Bool = 1,
            String = 2,
            Int = 3,
            Number = 4,
            Function = 5,
            Inferred = 6,
            None = 7
    }
    
    export class Call extends AST {
            receiver: AST;
            args: AST[];
            argumentSpan: AbsoluteSourceSpan;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, receiver: AST, args: AST[], argumentSpan: AbsoluteSourceSpan);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    /**
        * Multiple expressions separated by a semicolon.
        */
    export class Chain extends AST {
            expressions: any[];
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, expressions: any[]);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export enum ChangeDetectionStrategy {
            OnPush = 0,
            Default = 1
    }
    
    class CloneVisitor implements Visitor_2 {
            visitText(text: Text_3, context?: any): Text_3;
            visitContainer(container: Container, context?: any): Container;
            visitIcu(icu: Icu, context?: any): Icu;
            visitTagPlaceholder(ph: TagPlaceholder, context?: any): TagPlaceholder;
            visitPlaceholder(ph: Placeholder, context?: any): Placeholder;
            visitIcuPlaceholder(ph: IcuPlaceholder, context?: any): IcuPlaceholder;
    }
    
    export class CommaExpr extends Expression {
            parts: Expression[];
            constructor(parts: Expression[], sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    class Comment_2 implements BaseNode {
            value: string | null;
            sourceSpan: ParseSourceSpan;
            constructor(value: string | null, sourceSpan: ParseSourceSpan);
            visit(visitor: Visitor, context: any): any;
    }
    export { Comment_2 as Comment }
    
    /**
        * This is an R3 `Node`-like wrapper for a raw `html.Comment` node. We do not currently
        * require the implementation of a visitor for Comments as they are only collected at
        * the top-level of the R3 AST, and only if `Render3ParseOptions['collectCommentNodes']`
        * is true.
        */
    class Comment_3 implements TmplAstNode {
            value: string;
            sourceSpan: ParseSourceSpan;
            constructor(value: string, sourceSpan: ParseSourceSpan);
            visit<Result>(_visitor: Visitor_3<Result>): Result;
    }
    
    export function compileClassMetadata(metadata: R3ClassMetadata): outputAst.Expression;
    
    export type CompileClassMetadataFn = (metadata: R3ClassMetadata) => outputAst.Expression;
    
    /**
        * Compile a component for the render3 runtime as defined by the `R3ComponentMetadata`.
        */
    export function compileComponentFromMetadata(meta: R3ComponentMetadata<R3TemplateDependency>, constantPool: ConstantPool, bindingParser: BindingParser): R3CompiledExpression;
    
    export function compileDeclareClassMetadata(metadata: R3ClassMetadata): outputAst.Expression;
    
    /**
        * Compile a component declaration defined by the `R3ComponentMetadata`.
        */
    export function compileDeclareComponentFromMetadata(meta: R3ComponentMetadata<R3TemplateDependencyMetadata>, template: ParsedTemplate, additionalTemplateInfo: DeclareComponentTemplateInfo): R3CompiledExpression;
    
    /**
        * Compile a directive declaration defined by the `R3DirectiveMetadata`.
        */
    export function compileDeclareDirectiveFromMetadata(meta: R3DirectiveMetadata): R3CompiledExpression;
    
    export function compileDeclareFactoryFunction(meta: R3FactoryMetadata): R3CompiledExpression;
    
    /**
        * Compile a Injectable declaration defined by the `R3InjectableMetadata`.
        */
    export function compileDeclareInjectableFromMetadata(meta: R3InjectableMetadata): R3CompiledExpression;
    
    export function compileDeclareInjectorFromMetadata(meta: R3InjectorMetadata): R3CompiledExpression;
    
    export function compileDeclareNgModuleFromMetadata(meta: R3NgModuleMetadata): R3CompiledExpression;
    
    /**
        * Compile a Pipe declaration defined by the `R3PipeMetadata`.
        */
    export function compileDeclarePipeFromMetadata(meta: R3PipeMetadata): R3CompiledExpression;
    
    /**
        * Compile a directive for the render3 runtime as defined by the `R3DirectiveMetadata`.
        */
    export function compileDirectiveFromMetadata(meta: R3DirectiveMetadata, constantPool: ConstantPool, bindingParser: BindingParser): R3CompiledExpression;
    
    /**
        * Construct a factory function expression for the given `R3FactoryMetadata`.
        */
    export function compileFactoryFunction(meta: R3FactoryMetadata): R3CompiledExpression;
    
    export interface CompileIdentifierMetadata {
            reference: any;
    }
    
    export function compileInjectable(meta: R3InjectableMetadata, resolveForwardRefs: boolean): R3CompiledExpression;
    
    export function compileInjector(meta: R3InjectorMetadata): R3CompiledExpression;
    
    /**
        * Construct an `R3NgModuleDef` for the given `R3NgModuleMetadata`.
        */
    export function compileNgModule(meta: R3NgModuleMetadata): R3CompiledExpression;
    
    export function compilePipeFromMetadata(metadata: R3PipeMetadata): R3CompiledExpression;
    
    export class CompilerConfig {
            defaultEncapsulation: ViewEncapsulation | null;
            useJit: boolean;
            missingTranslation: MissingTranslationStrategy | null;
            preserveWhitespaces: boolean;
            strictInjectionParameters: boolean;
            constructor({ defaultEncapsulation, useJit, missingTranslation, preserveWhitespaces, strictInjectionParameters }?: {
                    defaultEncapsulation?: ViewEncapsulation;
                    useJit?: boolean;
                    missingTranslation?: MissingTranslationStrategy | null;
                    preserveWhitespaces?: boolean;
                    strictInjectionParameters?: boolean;
            });
    }
    
    export function computeMsgId(msg: string, meaning?: string): string;
    
    export class Conditional extends AST {
            condition: AST;
            trueExp: AST;
            falseExp: AST;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, condition: AST, trueExp: AST, falseExp: AST);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class ConditionalExpr extends Expression {
            condition: Expression;
            falseCase: Expression | null;
            trueCase: Expression;
            constructor(condition: Expression, trueCase: Expression, falseCase?: Expression | null, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    interface Console_2 {
            log(message: string): void;
            warn(message: string): void;
    }
    
    /**
        * A constant pool allows a code emitter to share constant in an output context.
        *
        * The constant pool also supports sharing access to ivy definitions references.
        */
    export class ConstantPool {
            statements: outputAst.Statement[];
            constructor(isClosureCompilerEnabled?: boolean);
            getConstLiteral(literal: outputAst.Expression, forceShared?: boolean): outputAst.Expression;
            getLiteralFactory(literal: outputAst.LiteralArrayExpr | outputAst.LiteralMapExpr): {
                    literalFactory: outputAst.Expression;
                    literalFactoryArguments: outputAst.Expression[];
            };
            /**
                * Produce a unique name.
                *
                * The name might be unique among different prefixes if any of the prefixes end in
                * a digit so the prefix should be a constant string (not based on user input) and
                * must not end in a digit.
                */
            uniqueName(prefix: string): string;
    }
    
    class Container implements Node_3 {
            children: Node_3[];
            sourceSpan: ParseSourceSpan;
            constructor(children: Node_3[], sourceSpan: ParseSourceSpan);
            visit(visitor: Visitor_2, context?: any): any;
    }
    
    /**
        * A structure to hold the cooked and raw strings of a template literal element, along with its
        * source-span range.
        */
    interface CookedRawString {
            cooked: string;
            raw: string;
            range: ParseSourceSpan | null;
    }
    
    namespace core {
            export {
                    parseSelectorToR3Selector,
                    emitDistinctChangesOnlyDefaultValue,
                    ViewEncapsulation,
                    ChangeDetectionStrategy,
                    Input,
                    Output,
                    HostBinding,
                    HostListener,
                    SchemaMetadata,
                    CUSTOM_ELEMENTS_SCHEMA,
                    NO_ERRORS_SCHEMA,
                    Type_2 as Type,
                    SecurityContext,
                    InjectFlags,
                    MissingTranslationStrategy,
                    SelectorFlags,
                    R3CssSelector,
                    R3CssSelectorList,
                    RenderFlags,
                    AttributeMarker
            }
    }
    export { core }
    
    export function createInjectableType(meta: R3InjectableMetadata): outputAst.ExpressionType;
    
    export function createMayBeForwardRefExpression<T extends outputAst.Expression>(expression: T, forwardRef: ForwardRefHandling): MaybeForwardRefExpression<T>;
    
    
    /**
        * A css selector contains an element name,
        * css classes and attribute/value pairs with the purpose
        * of selecting subsets out of them.
        */
    export class CssSelector {
            element: string | null;
            classNames: string[];
            /**
                * The selectors are encoded in pairs where:
                * - even locations are attribute names
                * - odd locations are attribute values.
                *
                * Example:
                * Selector: `[key1=value1][key2]` would parse to:
                * ```
                * ['key1', 'value1', 'key2', '']
                * ```
                */
            attrs: string[];
            notSelectors: CssSelector[];
            static parse(selector: string): CssSelector[];
            /**
                * Unescape `\$` sequences from the CSS attribute selector.
                *
                * This is needed because `$` can have a special meaning in CSS selectors,
                * but we might want to match an attribute that contains `$`.
                * [MDN web link for more
                * info](https://developer.mozilla.org/en-US/docs/Web/CSS/Attribute_selectors).
                * @param attr the attribute to unescape.
                * @returns the unescaped string.
                */
            unescapeAttribute(attr: string): string;
            /**
                * Escape `$` sequences from the CSS attribute selector.
                *
                * This is needed because `$` can have a special meaning in CSS selectors,
                * with this method we are escaping `$` with `\$'.
                * [MDN web link for more
                * info](https://developer.mozilla.org/en-US/docs/Web/CSS/Attribute_selectors).
                * @param attr the attribute to escape.
                * @returns the escaped string.
                */
            escapeAttribute(attr: string): string;
            isElementSelector(): boolean;
            hasElementSelector(): boolean;
            setElement(element?: string | null): void;
            getAttrs(): string[];
            addAttribute(name: string, value?: string): void;
            addClassName(name: string): void;
            toString(): string;
    }
    
    export const CUSTOM_ELEMENTS_SCHEMA: SchemaMetadata;
    
    /**
        * Specifies how a list of declaration type references should be emitted into the generated code.
        */
    export const enum DeclarationListEmitMode {
            /**
                * The list of declarations is emitted into the generated code as is.
                *
                * ```
                * directives: [MyDir],
                * ```
                */
            Direct = 0,
            /**
                * The list of declarations is emitted into the generated code wrapped inside a closure, which
                * is needed when at least one declaration is a forward reference.
                *
                * ```
                * directives: function () { return [MyDir, ForwardDir]; },
                * ```
                */
            Closure = 1,
            /**
                * Similar to `Closure`, with the addition that the list of declarations can contain individual
                * items that are themselves forward references. This is relevant for JIT compilations, as
                * unwrapping the forwardRef cannot be done statically so must be deferred. This mode emits
                * the declaration list using a mapping transform through `resolveForwardRef` to ensure that
                * any forward references within the list are resolved when the outer closure is invoked.
                *
                * Consider the case where the runtime has captured two declarations in two distinct values:
                * ```
                * const dirA = MyDir;
                * const dirB = forwardRef(function() { return ForwardRef; });
                * ```
                *
                * This mode would emit the declarations captured in `dirA` and `dirB` as follows:
                * ```
                * directives: function () { return [dirA, dirB].map(ng.resolveForwardRef); },
                * ```
                */
            ClosureResolved = 2
    }
    
    export interface DeclareComponentTemplateInfo {
            /**
                * The string contents of the template.
                *
                * This is the "logical" template string, after expansion of any escaped characters (for inline
                * templates). This may differ from the actual template bytes as they appear in the .ts file.
                */
            content: string;
            /**
                * A full path to the file which contains the template.
                *
                * This can be either the original .ts file if the template is inline, or the .html file if an
                * external file was used.
                */
            sourceUrl: string;
            /**
                * Whether the template was inline (using `template`) or external (using `templateUrl`).
                */
            isInline: boolean;
            /**
                * If the template was defined inline by a direct string literal, then this is that literal
                * expression. Otherwise `null`, if the template was not defined inline or was not a literal.
                */
            inlineTemplateLiteralExpression: outputAst.Expression | null;
    }
    
    export class DeclareFunctionStmt extends Statement {
            name: string;
            params: FnParam[];
            statements: Statement[];
            type: Type | null;
            constructor(name: string, params: FnParam[], statements: Statement[], type?: Type | null, modifiers?: StmtModifier, sourceSpan?: ParseSourceSpan | null, leadingComments?: LeadingComment[]);
            isEquivalent(stmt: Statement): boolean;
            visitStatement(visitor: StatementVisitor, context: any): any;
    }
    
    export class DeclareVarStmt extends Statement {
            name: string;
            value?: Expression | undefined;
            type: Type | null;
            constructor(name: string, value?: Expression | undefined, type?: Type | null, modifiers?: StmtModifier, sourceSpan?: ParseSourceSpan | null, leadingComments?: LeadingComment[]);
            isEquivalent(stmt: Statement): boolean;
            visitStatement(visitor: StatementVisitor, context: any): any;
    }
    
    export const DEFAULT_INTERPOLATION_CONFIG: InterpolationConfig;
    
    export function devOnlyGuardedExpression(expr: outputAst.Expression): outputAst.Expression;
    
    /**
        * Metadata regarding a directive that's needed to match it against template elements. This is
        * provided by a consumer of the t2 APIs.
        */
    export interface DirectiveMeta {
            /**
                * Name of the directive class (used for debugging).
                */
            name: string;
            /** The selector for the directive or `null` if there isn't one. */
            selector: string | null;
            /**
                * Whether the directive is a component.
                */
            isComponent: boolean;
            /**
                * Set of inputs which this directive claims.
                *
                * Goes from property names to field names.
                */
            inputs: InputOutputPropertySet;
            /**
                * Set of outputs which this directive claims.
                *
                * Goes from property names to field names.
                */
            outputs: InputOutputPropertySet;
            /**
                * Name under which the directive is exported, if any (exportAs in Angular).
                *
                * Null otherwise
                */
            exportAs: string[] | null;
            isStructural: boolean;
            /**
                * The name of animations that the user defines in the component.
                * Only includes the animation names.
                */
            animationTriggerNames: AnimationTriggerNames | null;
    }
    
    export class DomElementSchemaRegistry extends ElementSchemaRegistry {
            constructor();
            hasProperty(tagName: string, propName: string, schemaMetas: SchemaMetadata[]): boolean;
            hasElement(tagName: string, schemaMetas: SchemaMetadata[]): boolean;
            /**
                * securityContext returns the security context for the given property on the given DOM tag.
                *
                * Tag and property name are statically known and cannot change at runtime, i.e. it is not
                * possible to bind a value into a changing attribute or tag name.
                *
                * The filtering is based on a list of allowed tags|attributes. All attributes in the schema
                * above are assumed to have the 'NONE' security context, i.e. that they are safe inert
                * string values. Only specific well known attack vectors are assigned their appropriate context.
                */
            securityContext(tagName: string, propName: string, isAttribute: boolean): SecurityContext;
            getMappedPropName(propName: string): string;
            getDefaultComponentElementName(): string;
            validateProperty(name: string): {
                    error: boolean;
                    msg?: string;
            };
            validateAttribute(name: string): {
                    error: boolean;
                    msg?: string;
            };
            allKnownElementNames(): string[];
            allKnownAttributesOfElement(tagName: string): string[];
            allKnownEventsOfElement(tagName: string): string[];
            normalizeAnimationStyleProperty(propName: string): string;
            normalizeAnimationStyleValue(camelCaseProp: string, userProvidedProp: string, val: string | number): {
                    error: string;
                    value: string;
            };
    }
    
    export const DYNAMIC_TYPE: BuiltinType;
    
    class Element_2 extends NodeWithI18n {
            name: string;
            attrs: Attribute[];
            children: Node_2[];
            startSourceSpan: ParseSourceSpan;
            endSourceSpan: ParseSourceSpan | null;
            constructor(name: string, attrs: Attribute[], children: Node_2[], sourceSpan: ParseSourceSpan, startSourceSpan: ParseSourceSpan, endSourceSpan?: ParseSourceSpan | null, i18n?: I18nMeta_2);
            visit(visitor: Visitor, context: any): any;
    }
    export { Element_2 as Element }
    
    export abstract class ElementSchemaRegistry {
            abstract hasProperty(tagName: string, propName: string, schemaMetas: SchemaMetadata[]): boolean;
            abstract hasElement(tagName: string, schemaMetas: SchemaMetadata[]): boolean;
            abstract securityContext(elementName: string, propName: string, isAttribute: boolean): SecurityContext;
            abstract allKnownElementNames(): string[];
            abstract getMappedPropName(propName: string): string;
            abstract getDefaultComponentElementName(): string;
            abstract validateProperty(name: string): {
                    error: boolean;
                    msg?: string;
            };
            abstract validateAttribute(name: string): {
                    error: boolean;
                    msg?: string;
            };
            abstract normalizeAnimationStyleProperty(propName: string): string;
            abstract normalizeAnimationStyleValue(camelCaseProp: string, userProvidedProp: string, val: string | number): {
                    error: string;
                    value: string;
            };
    }
    
    
    export const emitDistinctChangesOnlyDefaultValue = true;
    
    export class EmitterVisitorContext {
            static createRoot(): EmitterVisitorContext;
            constructor(_indent: number);
            println(from?: {
                    sourceSpan: ParseSourceSpan | null;
            } | null, lastPart?: string): void;
            lineIsEmpty(): boolean;
            lineLength(): number;
            print(from: {
                    sourceSpan: ParseSourceSpan | null;
            } | null, part: string, newLine?: boolean): void;
            removeEmptyLastLine(): void;
            incIndent(): void;
            decIndent(): void;
            toSource(): string;
            toSourceMapGenerator(genFilePath: string, startsAtLine?: number): SourceMapGenerator;
            spanOf(line: number, column: number): ParseSourceSpan | null;
    }
    
    export class EmptyExpr extends AST {
            visit(visitor: AstVisitor, context?: any): void;
    }
    
    interface EncodedEntityToken extends TokenBase {
            type: TokenType_2.ENCODED_ENTITY;
            parts: [decoded: string, encoded: string];
    }
    
    export const EOF: Token;
    
    export class Expansion extends NodeWithI18n {
            switchValue: string;
            type: string;
            cases: ExpansionCase[];
            switchValueSourceSpan: ParseSourceSpan;
            constructor(switchValue: string, type: string, cases: ExpansionCase[], sourceSpan: ParseSourceSpan, switchValueSourceSpan: ParseSourceSpan, i18n?: I18nMeta_2);
            visit(visitor: Visitor, context: any): any;
    }
    
    export class ExpansionCase implements BaseNode {
            value: string;
            expression: Node_2[];
            sourceSpan: ParseSourceSpan;
            valueSourceSpan: ParseSourceSpan;
            expSourceSpan: ParseSourceSpan;
            constructor(value: string, expression: Node_2[], sourceSpan: ParseSourceSpan, valueSourceSpan: ParseSourceSpan, expSourceSpan: ParseSourceSpan);
            visit(visitor: Visitor, context: any): any;
    }
    
    export abstract class Expression {
            type: Type | null;
            sourceSpan: ParseSourceSpan | null;
            constructor(type: Type | null | undefined, sourceSpan?: ParseSourceSpan | null);
            abstract visitExpression(visitor: ExpressionVisitor, context: any): any;
            /**
                * Calculates whether this expression produces the same value as the given expression.
                * Note: We don't check Types nor ParseSourceSpans nor function arguments.
                */
            abstract isEquivalent(e: Expression): boolean;
            /**
                * Return true if the expression is constant.
                */
            abstract isConstant(): boolean;
            prop(name: string, sourceSpan?: ParseSourceSpan | null): ReadPropExpr;
            key(index: Expression, type?: Type | null, sourceSpan?: ParseSourceSpan | null): ReadKeyExpr;
            callFn(params: Expression[], sourceSpan?: ParseSourceSpan | null, pure?: boolean): InvokeFunctionExpr;
            instantiate(params: Expression[], type?: Type | null, sourceSpan?: ParseSourceSpan | null): InstantiateExpr;
            conditional(trueCase: Expression, falseCase?: Expression | null, sourceSpan?: ParseSourceSpan | null): ConditionalExpr;
            equals(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            notEquals(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            identical(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            notIdentical(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            minus(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            plus(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            divide(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            multiply(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            modulo(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            and(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            bitwiseAnd(rhs: Expression, sourceSpan?: ParseSourceSpan | null, parens?: boolean): BinaryOperatorExpr;
            or(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            lower(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            lowerEquals(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            bigger(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            biggerEquals(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            isBlank(sourceSpan?: ParseSourceSpan | null): Expression;
            nullishCoalesce(rhs: Expression, sourceSpan?: ParseSourceSpan | null): BinaryOperatorExpr;
            toStmt(): Statement;
    }
    
    export class ExpressionBinding {
            readonly sourceSpan: AbsoluteSourceSpan;
            readonly key: TemplateBindingIdentifier;
            readonly value: ASTWithSource | null;
            /**
                * @param sourceSpan entire span of the binding.
                * @param key binding name, like ngForOf, ngForTrackBy, ngIf, along with its
                * span. Note that the length of the span may not be the same as
                * `key.source.length`. For example,
                * 1. key.source = ngFor, key.span is for "ngFor"
                * 2. key.source = ngForOf, key.span is for "of"
                * 3. key.source = ngForTrackBy, key.span is for "trackBy"
                * @param value optional expression for the RHS.
                */
            constructor(sourceSpan: AbsoluteSourceSpan, key: TemplateBindingIdentifier, value: ASTWithSource | null);
    }
    
    export class ExpressionStatement extends Statement {
            expr: Expression;
            constructor(expr: Expression, sourceSpan?: ParseSourceSpan | null, leadingComments?: LeadingComment[]);
            isEquivalent(stmt: Statement): boolean;
            visitStatement(visitor: StatementVisitor, context: any): any;
    }
    
    export class ExpressionType extends Type {
            value: Expression;
            typeParams: Type[] | null;
            constructor(value: Expression, modifiers?: TypeModifier, typeParams?: Type[] | null);
            visitType(visitor: TypeVisitor, context: any): any;
    }
    
    function expressionType(expr: Expression, typeModifiers?: TypeModifier, typeParams?: Type[] | null): ExpressionType;
    
    export interface ExpressionVisitor {
            visitReadVarExpr(ast: ReadVarExpr, context: any): any;
            visitWriteVarExpr(expr: WriteVarExpr, context: any): any;
            visitWriteKeyExpr(expr: WriteKeyExpr, context: any): any;
            visitWritePropExpr(expr: WritePropExpr, context: any): any;
            visitInvokeFunctionExpr(ast: InvokeFunctionExpr, context: any): any;
            visitTaggedTemplateExpr(ast: TaggedTemplateExpr, context: any): any;
            visitInstantiateExpr(ast: InstantiateExpr, context: any): any;
            visitLiteralExpr(ast: LiteralExpr, context: any): any;
            visitLocalizedString(ast: LocalizedString, context: any): any;
            visitExternalExpr(ast: ExternalExpr, context: any): any;
            visitConditionalExpr(ast: ConditionalExpr, context: any): any;
            visitNotExpr(ast: NotExpr, context: any): any;
            visitFunctionExpr(ast: FunctionExpr, context: any): any;
            visitUnaryOperatorExpr(ast: UnaryOperatorExpr, context: any): any;
            visitBinaryOperatorExpr(ast: BinaryOperatorExpr, context: any): any;
            visitReadPropExpr(ast: ReadPropExpr, context: any): any;
            visitReadKeyExpr(ast: ReadKeyExpr, context: any): any;
            visitLiteralArrayExpr(ast: LiteralArrayExpr, context: any): any;
            visitLiteralMapExpr(ast: LiteralMapExpr, context: any): any;
            visitCommaExpr(ast: CommaExpr, context: any): any;
            visitWrappedNodeExpr(ast: WrappedNodeExpr<any>, context: any): any;
            visitTypeofExpr(ast: TypeofExpr, context: any): any;
    }
    
    export class ExternalExpr extends Expression {
            value: ExternalReference;
            typeParams: Type[] | null;
            constructor(value: ExternalReference, type?: Type | null, typeParams?: Type[] | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    export class ExternalReference {
            moduleName: string | null;
            name: string | null;
            runtime?: any;
            constructor(moduleName: string | null, name: string | null, runtime?: any);
    }
    
    interface ExternalReferenceResolver {
            resolveExternalReference(ref: outputAst.ExternalReference): unknown;
    }
    
    export enum FactoryTarget {
            Directive = 0,
            Component = 1,
            Injectable = 2,
            Pipe = 3,
            NgModule = 4
    }
    
    enum FactoryTarget_2 {
            Directive = 0,
            Component = 1,
            Injectable = 2,
            Pipe = 3,
            NgModule = 4
    }
    
    function fn(params: FnParam[], body: Statement[], type?: Type | null, sourceSpan?: ParseSourceSpan | null, name?: string | null): FunctionExpr;
    
    class FnParam {
            name: string;
            type: Type | null;
            constructor(name: string, type?: Type | null);
            isEquivalent(param: FnParam): boolean;
    }
    
    /**
        * Specifies how a forward ref has been handled in a MaybeForwardRefExpression
        */
    export const enum ForwardRefHandling {
            /** The expression was not wrapped in a `forwardRef()` call in the first place. */
            None = 0,
            /** The expression is still wrapped in a `forwardRef()` call. */
            Wrapped = 1,
            /** The expression was wrapped in a `forwardRef()` call but has since been unwrapped. */
            Unwrapped = 2
    }
    
    const FUNCTION_TYPE: BuiltinType;
    
    export class FunctionExpr extends Expression {
            params: FnParam[];
            statements: Statement[];
            name?: string | null | undefined;
            constructor(params: FnParam[], statements: Statement[], type?: Type | null, sourceSpan?: ParseSourceSpan | null, name?: string | null | undefined);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
            toDeclStmt(name: string, modifiers?: StmtModifier): DeclareFunctionStmt;
    }
    
    export function getHtmlTagDefinition(tagName: string): HtmlTagDefinition;
    
    export function getNsPrefix(fullName: string): string;
    
    export function getNsPrefix(fullName: null): null;
    
    export function getSafePropertyAccessString(accessor: string, name: string): string;
    
    interface HostBinding {
            hostPropertyName?: string;
    }
    
    interface HostListener {
            eventName?: string;
            args?: string[];
    }
    
    interface HostListeners {
            [key: string]: string;
    }
    
    interface HostProperties {
            [key: string]: string;
    }
    
    namespace html {
            export {
                    visitAll,
                    Node_2 as Node,
                    NodeWithI18n,
                    Text_2 as Text,
                    Expansion,
                    ExpansionCase,
                    Attribute,
                    Element_2 as Element,
                    Comment_2 as Comment,
                    Visitor,
                    RecursiveVisitor
            }
    }
    
    export class HtmlParser extends Parser_2 {
            constructor();
            parse(source: string, url: string, options?: TokenizeOptions): ParseTreeResult;
    }
    
    export class HtmlTagDefinition implements TagDefinition {
            closedByParent: boolean;
            implicitNamespacePrefix: string | null;
            isVoid: boolean;
            ignoreFirstLf: boolean;
            canSelfClose: boolean;
            preventNamespaceInheritance: boolean;
            constructor({ closedByChildren, implicitNamespacePrefix, contentType, closedByParent, isVoid, ignoreFirstLf, preventNamespaceInheritance, canSelfClose, }?: {
                    closedByChildren?: string[];
                    closedByParent?: boolean;
                    implicitNamespacePrefix?: string;
                    contentType?: TagContentType | {
                            default: TagContentType;
                            [namespace: string]: TagContentType;
                    };
                    isVoid?: boolean;
                    ignoreFirstLf?: boolean;
                    preventNamespaceInheritance?: boolean;
                    canSelfClose?: boolean;
            });
            isClosedByChild(name: string): boolean;
            getContentType(prefix?: string): TagContentType;
    }
    
    namespace i18n {
            export {
                    MessagePlaceholder,
                    Message,
                    MessageSpan,
                    Node_3 as Node,
                    Text_3 as Text,
                    Container,
                    Icu,
                    TagPlaceholder,
                    Placeholder,
                    IcuPlaceholder,
                    I18nMeta_2 as I18nMeta,
                    Visitor_2 as Visitor,
                    CloneVisitor,
                    RecurseVisitor
            }
    }
    
    export class I18NHtmlParser implements HtmlParser {
            getTagDefinition: any;
            constructor(_htmlParser: HtmlParser, translations?: string, translationsFormat?: string, missingTranslation?: MissingTranslationStrategy, console?: Console_2);
            parse(source: string, url: string, options?: TokenizeOptions): ParseTreeResult;
    }
    
    type I18nMeta = {
            id?: string;
            customId?: string;
            legacyIds?: string[];
            description?: string;
            meaning?: string;
    };
    
    /**
        * Each HTML node that is affect by an i18n tag will also have an `i18n` property that is of type
        * `I18nMeta`.
        * This information is either a `Message`, which indicates it is the root of an i18n message, or a
        * `Node`, which indicates is it part of a containing `Message`.
        */
    type I18nMeta_2 = Message | Node_3;
    
    class Icu implements Node_3 {
            expression: string;
            type: string;
            cases: {
                    [k: string]: Node_3;
            };
            sourceSpan: ParseSourceSpan;
            expressionPlaceholder: string;
            constructor(expression: string, type: string, cases: {
                    [k: string]: Node_3;
            }, sourceSpan: ParseSourceSpan);
            visit(visitor: Visitor_2, context?: any): any;
    }
    
    class IcuPlaceholder implements Node_3 {
            value: Icu;
            name: string;
            sourceSpan: ParseSourceSpan;
            /** Used to capture a message computed from a previous processing pass (see `setI18nRefs()`). */
            previousMessage?: Message;
            constructor(value: Icu, name: string, sourceSpan: ParseSourceSpan);
            visit(visitor: Visitor_2, context?: any): any;
    }
    
    export function identifierName(compileIdentifier: CompileIdentifierMetadata | null | undefined): string | null;
    
    export class IfStmt extends Statement {
            condition: Expression;
            trueCase: Statement[];
            falseCase: Statement[];
            constructor(condition: Expression, trueCase: Statement[], falseCase?: Statement[], sourceSpan?: ParseSourceSpan | null, leadingComments?: LeadingComment[]);
            isEquivalent(stmt: Statement): boolean;
            visitStatement(visitor: StatementVisitor, context: any): any;
    }
    
    function ifStmt(condition: Expression, thenClause: Statement[], elseClause?: Statement[], sourceSpan?: ParseSourceSpan, leadingComments?: LeadingComment[]): IfStmt;
    
    export class ImplicitReceiver extends AST {
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    function importExpr(id: ExternalReference, typeParams?: Type[] | null, sourceSpan?: ParseSourceSpan | null): ExternalExpr;
    
    function importType(id: ExternalReference, typeParams?: Type[] | null, typeModifiers?: TypeModifier): ExpressionType | null;
    
    const INFERRED_TYPE: BuiltinType;
    
    /**
        * Injection flags for DI.
        */
    const enum InjectFlags {
            Default = 0,
            /**
                * Specifies that an injector should retrieve a dependency from any injector until reaching the
                * host element of the current component. (Only used with Element Injector)
                */
            Host = 1,
            /** Don't descend into ancestors of the node requesting injection. */
            Self = 2,
            /** Skip the node that is requesting injection. */
            SkipSelf = 4,
            /** Inject `defaultValue` instead if token not found. */
            Optional = 8
    }
    
    interface Input {
            bindingPropertyName?: string;
    }
    
    /**
        * A data structure which can indicate whether a given property name is present or not.
        *
        * This is used to represent the set of inputs or outputs present on a directive, and allows the
        * binder to query for the presence of a mapping for property names.
        */
    export interface InputOutputPropertySet {
            hasBindingPropertyName(propertyName: string): boolean;
    }
    
    export class InstantiateExpr extends Expression {
            classExpr: Expression;
            args: Expression[];
            constructor(classExpr: Expression, args: Expression[], type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    const INT_TYPE: BuiltinType;
    
    type InterpolatedAttributeToken = AttributeValueTextToken | AttributeValueInterpolationToken | EncodedEntityToken;
    
    type InterpolatedTextToken = TextToken | InterpolationToken | EncodedEntityToken;
    
    export class Interpolation extends AST {
            strings: any[];
            expressions: any[];
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, strings: any[], expressions: any[]);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    
    export class InterpolationConfig {
            start: string;
            end: string;
            static fromArray(markers: [string, string] | null): InterpolationConfig;
            constructor(start: string, end: string);
    }
    
    export interface InterpolationPiece {
            text: string;
            start: number;
            end: number;
    }
    
    interface InterpolationToken extends TokenBase {
            type: TokenType_2.INTERPOLATION;
            parts: [startMarker: string, expression: string, endMarker: string] | [
            startMarker: string,
            expression: string
            ];
    }
    
    export class InvokeFunctionExpr extends Expression {
            fn: Expression;
            args: Expression[];
            pure: boolean;
            constructor(fn: Expression, args: Expression[], type?: Type | null, sourceSpan?: ParseSourceSpan | null, pure?: boolean);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    export function isIdentifier(input: string): boolean;
    
    export function isNgContainer(tagName: string): boolean;
    
    export function isNgContent(tagName: string): boolean;
    
    export function isNgTemplate(tagName: string): boolean;
    
    function isNull(exp: Expression): boolean;
    
    /**
        * A helper class to manage the evaluation of JIT generated code.
        */
    export class JitEvaluator {
            /**
                *
                * @param sourceUrl The URL of the generated code.
                * @param statements An array of Angular statement AST nodes to be evaluated.
                * @param refResolver Resolves `o.ExternalReference`s into values.
                * @param createSourceMaps If true then create a source-map for the generated code and include it
                * inline as a source-map comment.
                * @returns A map of all the variables in the generated code.
                */
            evaluateStatements(sourceUrl: string, statements: outputAst.Statement[], refResolver: ExternalReferenceResolver, createSourceMaps: boolean): {
                    [key: string]: any;
            };
            /**
                * Evaluate a piece of JIT generated code.
                * @param sourceUrl The URL of this generated code.
                * @param ctx A context object that contains an AST of the code to be evaluated.
                * @param vars A map containing the names and values of variables that the evaluated code might
                * reference.
                * @param createSourceMap If true then create a source-map for the generated code and include it
                * inline as a source-map comment.
                * @returns The result of evaluating the code.
                */
            evaluateCode(sourceUrl: string, ctx: EmitterVisitorContext, vars: {
                    [key: string]: any;
            }, createSourceMap: boolean): any;
            /**
                * Execute a JIT generated function by calling it.
                *
                * This method can be overridden in tests to capture the functions that are generated
                * by this `JitEvaluator` class.
                *
                * @param fn A function to execute.
                * @param args The arguments to pass to the function being executed.
                * @returns The return value of the executed function.
                */
            executeFunction(fn: Function, args: any[]): any;
    }
    
    export class JSDocComment extends LeadingComment {
            tags: JSDocTag[];
            constructor(tags: JSDocTag[]);
            toString(): string;
    }
    
    export function jsDocComment(tags?: JSDocTag[]): JSDocComment;
    
    type JSDocTag = {
            tagName: JSDocTagName | string;
            text?: string;
    } | {
            tagName?: undefined;
            text: string;
    };
    
    const enum JSDocTagName {
            Desc = "desc",
            Id = "id",
            Meaning = "meaning",
            Suppress = "suppress"
    }
    
    export class KeyedRead extends AST {
            receiver: AST;
            key: AST;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, receiver: AST, key: AST);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class KeyedWrite extends AST {
            receiver: AST;
            key: AST;
            value: AST;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, receiver: AST, key: AST, value: AST);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class LeadingComment {
            text: string;
            multiline: boolean;
            trailingNewline: boolean;
            constructor(text: string, multiline: boolean, trailingNewline: boolean);
            toString(): string;
    }
    
    export function leadingComment(text: string, multiline?: boolean, trailingNewline?: boolean): LeadingComment;
    
    export class Lexer {
            tokenize(text: string): Token[];
    }
    
    export interface LexerRange {
            startPos: number;
            startLine: number;
            startCol: number;
            endPos: number;
    }
    
    function literal(value: any, type?: Type | null, sourceSpan?: ParseSourceSpan | null): LiteralExpr;
    
    function literalArr(values: Expression[], type?: Type | null, sourceSpan?: ParseSourceSpan | null): LiteralArrayExpr;
    
    export class LiteralArray extends AST {
            expressions: any[];
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, expressions: any[]);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class LiteralArrayExpr extends Expression {
            entries: Expression[];
            constructor(entries: Expression[], type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isConstant(): boolean;
            isEquivalent(e: Expression): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    export class LiteralExpr extends Expression {
            value: number | string | boolean | null | undefined;
            constructor(value: number | string | boolean | null | undefined, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    export class LiteralMap extends AST {
            keys: LiteralMapKey[];
            values: any[];
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, keys: LiteralMapKey[], values: any[]);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export function literalMap(values: {
            key: string;
            quoted: boolean;
            value: Expression;
    }[], type?: MapType | null): LiteralMapExpr;
    
    class LiteralMapEntry {
            key: string;
            value: Expression;
            quoted: boolean;
            constructor(key: string, value: Expression, quoted: boolean);
            isEquivalent(e: LiteralMapEntry): boolean;
    }
    
    export class LiteralMapExpr extends Expression {
            entries: LiteralMapEntry[];
            valueType: Type | null;
            constructor(entries: LiteralMapEntry[], type?: MapType | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    export type LiteralMapKey = {
            key: string;
            quoted: boolean;
    };
    
    class LiteralPiece {
            text: string;
            sourceSpan: ParseSourceSpan;
            constructor(text: string, sourceSpan: ParseSourceSpan);
    }
    
    export class LiteralPrimitive extends AST {
            value: any;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, value: any);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class LocalizedString extends Expression {
            readonly metaBlock: I18nMeta;
            readonly messageParts: LiteralPiece[];
            readonly placeHolderNames: PlaceholderPiece[];
            readonly expressions: Expression[];
            constructor(metaBlock: I18nMeta, messageParts: LiteralPiece[], placeHolderNames: PlaceholderPiece[], expressions: Expression[], sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
            /**
                * Serialize the given `meta` and `messagePart` into "cooked" and "raw" strings that can be used
                * in a `$localize` tagged string. The format of the metadata is the same as that parsed by
                * `parseI18nMeta()`.
                *
                * @param meta The metadata to serialize
                * @param messagePart The first part of the tagged string
                */
            serializeI18nHead(): CookedRawString;
            getMessagePartSourceSpan(i: number): ParseSourceSpan | null;
            getPlaceholderSourceSpan(i: number): ParseSourceSpan;
            /**
                * Serialize the given `placeholderName` and `messagePart` into "cooked" and "raw" strings that
                * can be used in a `$localize` tagged string.
                *
                * The format is `:<placeholder-name>[@@<associated-id>]:`.
                *
                * The `associated-id` is the message id of the (usually an ICU) message to which this placeholder
                * refers.
                *
                * @param partIndex The index of the message part to serialize.
                */
            serializeI18nTemplatePart(partIndex: number): CookedRawString;
    }
    
    function localizedString(metaBlock: I18nMeta, messageParts: LiteralPiece[], placeholderNames: PlaceholderPiece[], expressions: Expression[], sourceSpan?: ParseSourceSpan | null): LocalizedString;
    
    /**
        * Construct a `BindingParser` with a default configuration.
        */
    export function makeBindingParser(interpolationConfig?: InterpolationConfig): BindingParser;
    
    export class MapType extends Type {
            valueType: Type | null;
            constructor(valueType: Type | null | undefined, modifiers?: TypeModifier);
            visitType(visitor: TypeVisitor, context: any): any;
    }
    
    /**
        * Describes an expression that may have been wrapped in a `forwardRef()` guard.
        *
        * This is used when describing expressions that can refer to types that may eagerly reference types
        * that have not yet been defined.
        */
    export interface MaybeForwardRefExpression<T extends outputAst.Expression = outputAst.Expression> {
            /**
                * The unwrapped expression.
                */
            expression: T;
            /**
                * Specified whether the `expression` contains a reference to something that has not yet been
                * defined, and whether the expression is still wrapped in a `forwardRef()` call.
                *
                * If this value is `ForwardRefHandling.None` then the `expression` is safe to use as-is.
                *
                * Otherwise the `expression` was wrapped in a call to `forwardRef()` and must not be eagerly
                * evaluated. Instead it must be wrapped in a function closure that will be evaluated lazily to
                * allow the definition of the expression to be evaluated first.
                *
                * In full AOT compilation it can be safe to unwrap the `forwardRef()` call up front if the
                * expression will actually be evaluated lazily inside a function call after the value of
                * `expression` has been defined.
                *
                * But in other cases, such as partial AOT compilation or JIT compilation the expression will be
                * evaluated eagerly in top level code so will need to continue to be wrapped in a `forwardRef()`
                * call.
                *
                */
            forwardRef: ForwardRefHandling;
    }
    
    export function mergeNsAndName(prefix: string, localName: string): string;
    
    class Message {
            nodes: Node_3[];
            placeholders: {
                    [phName: string]: MessagePlaceholder;
            };
            placeholderToMessage: {
                    [phName: string]: Message;
            };
            meaning: string;
            description: string;
            customId: string;
            sources: MessageSpan[];
            id: string;
            /** The ids to use if there are no custom id and if `i18nLegacyMessageIdFormat` is not empty */
            legacyIds: string[];
            messageString: string;
            /**
                * @param nodes message AST
                * @param placeholders maps placeholder names to static content and their source spans
                * @param placeholderToMessage maps placeholder names to messages (used for nested ICU messages)
                * @param meaning
                * @param description
                * @param customId
                */
            constructor(nodes: Node_3[], placeholders: {
                    [phName: string]: MessagePlaceholder;
            }, placeholderToMessage: {
                    [phName: string]: Message;
            }, meaning: string, description: string, customId: string);
    }
    
    /**
        * A container for message extracted from the templates.
        */
    export class MessageBundle {
            constructor(_htmlParser: HtmlParser, _implicitTags: string[], _implicitAttrs: {
                    [k: string]: string[];
            }, _locale?: string | null);
            updateFromTemplate(html: string, url: string, interpolationConfig: InterpolationConfig): ParseError[];
            getMessages(): i18n.Message[];
            write(serializer: Serializer, filterSources?: (path: string) => string): string;
    }
    
    type MessagePiece = LiteralPiece | PlaceholderPiece;
    
    /**
        * Describes the text contents of a placeholder as it appears in an ICU expression, including its
        * source span information.
        */
    interface MessagePlaceholder {
            /** The text contents of the placeholder */
            text: string;
            /** The source span of the placeholder */
            sourceSpan: ParseSourceSpan;
    }
    
    interface MessageSpan {
            filePath: string;
            startLine: number;
            startCol: number;
            endLine: number;
            endCol: number;
    }
    
    enum MissingTranslationStrategy {
            Error = 0,
            Warning = 1,
            Ignore = 2
    }
    
    export const NO_ERRORS_SCHEMA: SchemaMetadata;
    
    type Node_2 = Attribute | Comment_2 | Element_2 | Expansion | ExpansionCase | Text_2;
    export { Node_2 as Node }
    
    interface Node_3 {
            sourceSpan: ParseSourceSpan;
            visit(visitor: Visitor_2, context?: any): any;
    }
    
    export abstract class NodeWithI18n implements BaseNode {
            sourceSpan: ParseSourceSpan;
            i18n?: I18nMeta_2 | undefined;
            constructor(sourceSpan: ParseSourceSpan, i18n?: I18nMeta_2 | undefined);
            abstract visit(visitor: Visitor, context: any): any;
    }
    
    export const NONE_TYPE: BuiltinType;
    
    export class NonNullAssert extends AST {
            expression: AST;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, expression: AST);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    function not(expr: Expression, sourceSpan?: ParseSourceSpan | null): NotExpr;
    
    export class NotExpr extends Expression {
            condition: Expression;
            constructor(condition: Expression, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    const NULL_EXPR: LiteralExpr;
    
    function nullSafeIsEquivalent<T extends {
            isEquivalent(other: T): boolean;
    }>(base: T | null, other: T | null): boolean;
    
    class NullVisitor implements Visitor_3<void> {
            visitElement(element: TmplAstElement): void;
            visitTemplate(template: TmplAstTemplate): void;
            visitContent(content: TmplAstContent): void;
            visitVariable(variable: TmplAstVariable): void;
            visitReference(reference: TmplAstReference): void;
            visitTextAttribute(attribute: TmplAstTextAttribute): void;
            visitBoundAttribute(attribute: TmplAstBoundAttribute): void;
            visitBoundEvent(attribute: TmplAstBoundEvent): void;
            visitText(text: TmplAstText): void;
            visitBoundText(text: TmplAstBoundText): void;
            visitIcu(icu: TmplAstIcu): void;
    }
    
    const NUMBER_TYPE: BuiltinType;
    
    interface Output {
            bindingPropertyName?: string;
    }
    
    namespace outputAst {
            export {
                    nullSafeIsEquivalent,
                    areAllEquivalent,
                    leadingComment,
                    jsDocComment,
                    variable,
                    importExpr,
                    importType,
                    expressionType,
                    typeofExpr,
                    literalArr,
                    literalMap,
                    unary,
                    not,
                    fn,
                    ifStmt,
                    taggedTemplate,
                    literal,
                    localizedString,
                    isNull,
                    TypeModifier,
                    Type,
                    BuiltinTypeName,
                    BuiltinType,
                    ExpressionType,
                    ArrayType,
                    MapType,
                    DYNAMIC_TYPE,
                    INFERRED_TYPE,
                    BOOL_TYPE,
                    INT_TYPE,
                    NUMBER_TYPE,
                    STRING_TYPE,
                    FUNCTION_TYPE,
                    NONE_TYPE,
                    TypeVisitor,
                    UnaryOperator,
                    BinaryOperator,
                    Expression,
                    ReadVarExpr,
                    TypeofExpr,
                    WrappedNodeExpr,
                    WriteVarExpr,
                    WriteKeyExpr,
                    WritePropExpr,
                    InvokeFunctionExpr,
                    TaggedTemplateExpr,
                    InstantiateExpr,
                    LiteralExpr,
                    TemplateLiteral,
                    TemplateLiteralElement,
                    LiteralPiece,
                    PlaceholderPiece,
                    MessagePiece,
                    LocalizedString,
                    CookedRawString,
                    ExternalExpr,
                    ExternalReference,
                    ConditionalExpr,
                    NotExpr,
                    FnParam,
                    FunctionExpr,
                    UnaryOperatorExpr,
                    BinaryOperatorExpr,
                    ReadPropExpr,
                    ReadKeyExpr,
                    LiteralArrayExpr,
                    LiteralMapEntry,
                    LiteralMapExpr,
                    CommaExpr,
                    ExpressionVisitor,
                    NULL_EXPR,
                    TYPED_NULL_EXPR,
                    StmtModifier,
                    LeadingComment,
                    JSDocComment,
                    Statement,
                    DeclareVarStmt,
                    DeclareFunctionStmt,
                    ExpressionStatement,
                    ReturnStatement,
                    IfStmt,
                    StatementVisitor,
                    RecursiveAstVisitor_2 as RecursiveAstVisitor,
                    JSDocTagName,
                    JSDocTag
            }
    }
    export { outputAst }
    
    export class _ParseAST {
            input: string;
            location: string;
            absoluteOffset: number;
            tokens: Token[];
            parseFlags: ParseFlags;
            index: number;
            constructor(input: string, location: string, absoluteOffset: number, tokens: Token[], parseFlags: ParseFlags, errors: ParserError[], offset: number);
            peek(offset: number): Token;
            get next(): Token;
            /** Whether all the parser input has been processed. */
            get atEOF(): boolean;
            /**
                * Index of the next token to be processed, or the end of the last token if all have been
                * processed.
                */
            get inputIndex(): number;
            /**
                * End index of the last processed token, or the start of the first token if none have been
                * processed.
                */
            get currentEndIndex(): number;
            /**
                * Returns the absolute offset of the start of the current token.
                */
            get currentAbsoluteOffset(): number;
            /**
                * Retrieve a `ParseSpan` from `start` to the current position (or to `artificialEndIndex` if
                * provided).
                *
                * @param start Position from which the `ParseSpan` will start.
                * @param artificialEndIndex Optional ending index to be used if provided (and if greater than the
                *     natural ending index)
                */
            span(start: number, artificialEndIndex?: number): ParseSpan;
            sourceSpan(start: number, artificialEndIndex?: number): AbsoluteSourceSpan;
            advance(): void;
            consumeOptionalCharacter(code: number): boolean;
            peekKeywordLet(): boolean;
            peekKeywordAs(): boolean;
            /**
                * Consumes an expected character, otherwise emits an error about the missing expected character
                * and skips over the token stream until reaching a recoverable point.
                *
                * See `this.error` and `this.skip` for more details.
                */
            expectCharacter(code: number): void;
            consumeOptionalOperator(op: string): boolean;
            expectOperator(operator: string): void;
            prettyPrintToken(tok: Token): string;
            expectIdentifierOrKeyword(): string | null;
            expectIdentifierOrKeywordOrString(): string;
            parseChain(): AST;
            parsePipe(): AST;
            parseExpression(): AST;
            parseConditional(): AST;
            parseLogicalOr(): AST;
            parseLogicalAnd(): AST;
            parseNullishCoalescing(): AST;
            parseEquality(): AST;
            parseRelational(): AST;
            parseAdditive(): AST;
            parseMultiplicative(): AST;
            parsePrefix(): AST;
            parseCallChain(): AST;
            parsePrimary(): AST;
            parseExpressionList(terminator: number): AST[];
            parseLiteralMap(): LiteralMap;
            parseAccessMember(readReceiver: AST, start: number, isSafe: boolean): AST;
            parseCall(receiver: AST, start: number, isSafe: boolean): AST;
            parseCallArguments(): BindingPipe[];
            /**
                * Parses an identifier, a keyword, a string with an optional `-` in between,
                * and returns the string along with its absolute source span.
                */
            expectTemplateBindingKey(): TemplateBindingIdentifier;
            /**
                * Parse microsyntax template expression and return a list of bindings or
                * parsing errors in case the given expression is invalid.
                *
                * For example,
                * ```
                *   <div *ngFor="let item of items; index as i; trackBy: func">
                * ```
                * contains five bindings:
                * 1. ngFor -> null
                * 2. item -> NgForOfContext.$implicit
                * 3. ngForOf -> items
                * 4. i -> NgForOfContext.index
                * 5. ngForTrackBy -> func
                *
                * For a full description of the microsyntax grammar, see
                * https://gist.github.com/mhevery/d3530294cff2e4a1b3fe15ff75d08855
                *
                * @param templateKey name of the microsyntax directive, like ngIf, ngFor,
                * without the *, along with its absolute span.
                */
            parseTemplateBindings(templateKey: TemplateBindingIdentifier): TemplateBindingParseResult;
            parseKeyedReadOrWrite(receiver: AST, start: number, isSafe: boolean): AST;
            /**
                * Records an error and skips over the token stream until reaching a recoverable point. See
                * `this.skip` for more details on token skipping.
                */
            error(message: string, index?: number | null): void;
    }
    
    export class ParsedEvent {
            name: string;
            targetOrPhase: string;
            type: ParsedEventType;
            handler: ASTWithSource;
            sourceSpan: ParseSourceSpan;
            handlerSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan;
            constructor(name: string, targetOrPhase: string, type: ParsedEventType, handler: ASTWithSource, sourceSpan: ParseSourceSpan, handlerSpan: ParseSourceSpan, keySpan: ParseSourceSpan);
    }
    
    export const enum ParsedEventType {
            Regular = 0,
            Animation = 1
    }
    
    export interface ParsedHostBindings {
            attributes: {
                    [key: string]: outputAst.Expression;
            };
            listeners: {
                    [key: string]: string;
            };
            properties: {
                    [key: string]: string;
            };
            specialAttributes: {
                    styleAttr?: string;
                    classAttr?: string;
            };
    }
    
    export class ParsedProperty {
            name: string;
            expression: ASTWithSource;
            type: ParsedPropertyType;
            sourceSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan;
            valueSpan: ParseSourceSpan | undefined;
            readonly isLiteral: boolean;
            readonly isAnimation: boolean;
            constructor(name: string, expression: ASTWithSource, type: ParsedPropertyType, sourceSpan: ParseSourceSpan, keySpan: ParseSourceSpan, valueSpan: ParseSourceSpan | undefined);
    }
    
    export enum ParsedPropertyType {
            DEFAULT = 0,
            LITERAL_ATTR = 1,
            ANIMATION = 2
    }
    
    /**
        * Information about the template which was extracted during parsing.
        *
        * This contains the actual parsed template as well as any metadata collected during its parsing,
        * some of which might be useful for re-parsing the template with different options.
        */
    export interface ParsedTemplate {
            /**
                * Include whitespace nodes in the parsed output.
                */
            preserveWhitespaces?: boolean;
            /**
                * How to parse interpolation markers.
                */
            interpolationConfig?: InterpolationConfig;
            /**
                * Any errors from parsing the template the first time.
                *
                * `null` if there are no errors. Otherwise, the array of errors is guaranteed to be non-empty.
                */
            errors: ParseError[] | null;
            /**
                * The template AST, parsed from the template.
                */
            nodes: t.Node[];
            /**
                * Any styleUrls extracted from the metadata.
                */
            styleUrls: string[];
            /**
                * Any inline styles extracted from the metadata.
                */
            styles: string[];
            /**
                * Any ng-content selectors extracted from the template.
                */
            ngContentSelectors: string[];
            /**
                * Any R3 Comment Nodes extracted from the template when the `collectCommentNodes` parse template
                * option is enabled.
                */
            commentNodes?: t.Comment[];
    }
    
    /**
        * ParsedVariable represents a variable declaration in a microsyntax expression.
        */
    export class ParsedVariable {
            readonly name: string;
            readonly value: string;
            readonly sourceSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan;
            readonly valueSpan?: ParseSourceSpan | undefined;
            constructor(name: string, value: string, sourceSpan: ParseSourceSpan, keySpan: ParseSourceSpan, valueSpan?: ParseSourceSpan | undefined);
    }
    
    export class ParseError {
            span: ParseSourceSpan;
            msg: string;
            level: ParseErrorLevel;
            constructor(span: ParseSourceSpan, msg: string, level?: ParseErrorLevel);
            contextualMessage(): string;
            toString(): string;
    }
    
    export enum ParseErrorLevel {
            WARNING = 0,
            ERROR = 1
    }
    
    /**
        * Represents the possible parse modes to be used as a bitmask.
        */
    export const enum ParseFlags {
            None = 0,
            /**
                * Whether an output binding is being parsed.
                */
            Action = 1,
            /**
                * Whether an assignment event is being parsed, i.e. an expression originating from
                * two-way-binding aka banana-in-a-box syntax.
                */
            AssignmentEvent = 2
    }
    
    export function parseHostBindings(host: {
            [key: string]: string | outputAst.Expression;
    }): ParsedHostBindings;
    
    export class ParseLocation {
            file: ParseSourceFile;
            offset: number;
            line: number;
            col: number;
            constructor(file: ParseSourceFile, offset: number, line: number, col: number);
            toString(): string;
            moveBy(delta: number): ParseLocation;
            getContext(maxChars: number, maxLines: number): {
                    before: string;
                    after: string;
            } | null;
    }
    
    export class Parser {
            constructor(_lexer: Lexer);
            parseAction(input: string, isAssignmentEvent: boolean, location: string, absoluteOffset: number, interpolationConfig?: InterpolationConfig): ASTWithSource;
            parseBinding(input: string, location: string, absoluteOffset: number, interpolationConfig?: InterpolationConfig): ASTWithSource;
            parseSimpleBinding(input: string, location: string, absoluteOffset: number, interpolationConfig?: InterpolationConfig): ASTWithSource;
            /**
                * Parse microsyntax template expression and return a list of bindings or
                * parsing errors in case the given expression is invalid.
                *
                * For example,
                * ```
                *   <div *ngFor="let item of items">
                *         ^      ^ absoluteValueOffset for `templateValue`
                *         absoluteKeyOffset for `templateKey`
                * ```
                * contains three bindings:
                * 1. ngFor -> null
                * 2. item -> NgForOfContext.$implicit
                * 3. ngForOf -> items
                *
                * This is apparent from the de-sugared template:
                * ```
                *   <ng-template ngFor let-item [ngForOf]="items">
                * ```
                *
                * @param templateKey name of directive, without the * prefix. For example: ngIf, ngFor
                * @param templateValue RHS of the microsyntax attribute
                * @param templateUrl template filename if it's external, component filename if it's inline
                * @param absoluteKeyOffset start of the `templateKey`
                * @param absoluteValueOffset start of the `templateValue`
                */
            parseTemplateBindings(templateKey: string, templateValue: string, templateUrl: string, absoluteKeyOffset: number, absoluteValueOffset: number): TemplateBindingParseResult;
            parseInterpolation(input: string, location: string, absoluteOffset: number, interpolatedTokens: InterpolatedAttributeToken[] | InterpolatedTextToken[] | null, interpolationConfig?: InterpolationConfig): ASTWithSource | null;
            /**
                * Similar to `parseInterpolation`, but treats the provided string as a single expression
                * element that would normally appear within the interpolation prefix and suffix (`{{` and `}}`).
                * This is used for parsing the switch expression in ICUs.
                */
            parseInterpolationExpression(expression: string, location: string, absoluteOffset: number): ASTWithSource;
            /**
                * Splits a string of text into "raw" text segments and expressions present in interpolations in
                * the string.
                * Returns `null` if there are no interpolations, otherwise a
                * `SplitInterpolation` with splits that look like
                *   <raw text> <expression> <raw text> ... <raw text> <expression> <raw text>
                */
            splitInterpolation(input: string, location: string, interpolatedTokens: InterpolatedAttributeToken[] | InterpolatedTextToken[] | null, interpolationConfig?: InterpolationConfig): SplitInterpolation;
            wrapLiteralPrimitive(input: string | null, location: string, absoluteOffset: number): ASTWithSource;
    }
    
    class Parser_2 {
            getTagDefinition: (tagName: string) => TagDefinition;
            constructor(getTagDefinition: (tagName: string) => TagDefinition);
            parse(source: string, url: string, options?: TokenizeOptions): ParseTreeResult;
    }
    
    export class ParserError {
            input: string;
            errLocation: string;
            ctxLocation?: any;
            message: string;
            constructor(message: string, input: string, errLocation: string, ctxLocation?: any);
    }
    
    function parseSelectorToR3Selector(selector: string | null): R3CssSelectorList;
    
    export class ParseSourceFile {
            content: string;
            url: string;
            constructor(content: string, url: string);
    }
    
    export class ParseSourceSpan {
            start: ParseLocation;
            end: ParseLocation;
            fullStart: ParseLocation;
            details: string | null;
            /**
                * Create an object that holds information about spans of tokens/nodes captured during
                * lexing/parsing of text.
                *
                * @param start
                * The location of the start of the span (having skipped leading trivia).
                * Skipping leading trivia makes source-spans more "user friendly", since things like HTML
                * elements will appear to begin at the start of the opening tag, rather than at the start of any
                * leading trivia, which could include newlines.
                *
                * @param end
                * The location of the end of the span.
                *
                * @param fullStart
                * The start of the token without skipping the leading trivia.
                * This is used by tooling that splits tokens further, such as extracting Angular interpolations
                * from text tokens. Such tooling creates new source-spans relative to the original token's
                * source-span. If leading trivia characters have been skipped then the new source-spans may be
                * incorrectly offset.
                *
                * @param details
                * Additional information (such as identifier names) that should be associated with the span.
                */
            constructor(start: ParseLocation, end: ParseLocation, fullStart?: ParseLocation, details?: string | null);
            toString(): string;
    }
    
    export class ParseSpan {
            start: number;
            end: number;
            constructor(start: number, end: number);
            toAbsolute(absoluteOffset: number): AbsoluteSourceSpan;
    }
    
    /**
        * Parse a template into render3 `Node`s and additional metadata, with no other dependencies.
        *
        * @param template text of the template to parse
        * @param templateUrl URL to use for source mapping of the parsed template
        * @param options options to modify how the template is parsed
        */
    export function parseTemplate(template: string, templateUrl: string, options?: ParseTemplateOptions): ParsedTemplate;
    
    /**
        * Options that can be used to modify how a template is parsed by `parseTemplate()`.
        */
    export interface ParseTemplateOptions {
            /**
                * Include whitespace nodes in the parsed output.
                */
            preserveWhitespaces?: boolean;
            /**
                * Preserve original line endings instead of normalizing '\r\n' endings to '\n'.
                */
            preserveLineEndings?: boolean;
            /**
                * How to parse interpolation markers.
                */
            interpolationConfig?: InterpolationConfig;
            /**
                * The start and end point of the text to parse within the `source` string.
                * The entire `source` string is parsed if this is not provided.
                * */
            range?: LexerRange;
            /**
                * If this text is stored in a JavaScript string, then we have to deal with escape sequences.
                *
                * **Example 1:**
                *
                * ```
                * "abc\"def\nghi"
                * ```
                *
                * - The `\"` must be converted to `"`.
                * - The `\n` must be converted to a new line character in a token,
                *   but it should not increment the current line for source mapping.
                *
                * **Example 2:**
                *
                * ```
                * "abc\
                *  def"
                * ```
                *
                * The line continuation (`\` followed by a newline) should be removed from a token
                * but the new line should increment the current line for source mapping.
                */
            escapedString?: boolean;
            /**
                * An array of characters that should be considered as leading trivia.
                * Leading trivia are characters that are not important to the developer, and so should not be
                * included in source-map segments.  A common example is whitespace.
                */
            leadingTriviaChars?: string[];
            /**
                * Render `$localize` message ids with additional legacy message ids.
                *
                * This option defaults to `true` but in the future the default will be flipped.
                *
                * For now set this option to false if you have migrated the translation files to use the new
                * `$localize` message id format and you are not using compile time translation merging.
                */
            enableI18nLegacyMessageIdFormat?: boolean;
            /**
                * If this text is stored in an external template (e.g. via `templateUrl`) then we need to decide
                * whether or not to normalize the line-endings (from `\r\n` to `\n`) when processing ICU
                * expressions.
                *
                * If `true` then we will normalize ICU expression line endings.
                * The default is `false`, but this will be switched in a future major release.
                */
            i18nNormalizeLineEndingsInICUs?: boolean;
            /**
                * Whether to always attempt to convert the parsed HTML AST to an R3 AST, despite HTML or i18n
                * Meta parse errors.
                *
                *
                * This option is useful in the context of the language service, where we want to get as much
                * information as possible, despite any errors in the HTML. As an example, a user may be adding
                * a new tag and expecting autocomplete on that tag. In this scenario, the HTML is in an errored
                * state, as there is an incomplete open tag. However, we're still able to convert the HTML AST
                * nodes to R3 AST nodes in order to provide information for the language service.
                *
                * Note that even when `true` the HTML parse and i18n errors are still appended to the errors
                * output, but this is done after converting the HTML AST to R3 AST.
                */
            alwaysAttemptHtmlToR3AstConversion?: boolean;
            /**
                * Include HTML Comment nodes in a top-level comments array on the returned R3 AST.
                *
                * This option is required by tooling that needs to know the location of comment nodes within the
                * AST. A concrete example is @angular-eslint which requires this in order to enable
                * "eslint-disable" comments within HTML templates, which then allows users to turn off specific
                * rules on a case by case basis, instead of for their whole project within a configuration file.
                */
            collectCommentNodes?: boolean;
    }
    
    export class ParseTreeResult {
            rootNodes: html.Node[];
            errors: ParseError[];
            constructor(rootNodes: html.Node[], errors: ParseError[]);
    }
    
    class Placeholder implements Node_3 {
            value: string;
            name: string;
            sourceSpan: ParseSourceSpan;
            constructor(value: string, name: string, sourceSpan: ParseSourceSpan);
            visit(visitor: Visitor_2, context?: any): any;
    }
    
    /**
        * A `PlaceholderMapper` converts placeholder names from internal to serialized representation and
        * back.
        *
        * It should be used for serialization format that put constraints on the placeholder names.
        */
    interface PlaceholderMapper {
            toPublicName(internalName: string): string | null;
            toInternalName(publicName: string): string | null;
    }
    
    class PlaceholderPiece {
            text: string;
            sourceSpan: ParseSourceSpan;
            associatedMessage?: Message | undefined;
            /**
                * Create a new instance of a `PlaceholderPiece`.
                *
                * @param text the name of this placeholder (e.g. `PH_1`).
                * @param sourceSpan the location of this placeholder in its localized message the source code.
                * @param associatedMessage reference to another message that this placeholder is associated with.
                * The `associatedMessage` is mainly used to provide a relationship to an ICU message that has
                * been extracted out from the message containing the placeholder.
                */
            constructor(text: string, sourceSpan: ParseSourceSpan, associatedMessage?: Message | undefined);
    }
    
    export class PrefixNot extends AST {
            expression: AST;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, expression: AST);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export function preserveWhitespacesDefault(preserveWhitespacesOption: boolean | null, defaultSetting?: boolean): boolean;
    
    export class PropertyRead extends ASTWithName {
            receiver: AST;
            name: string;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, nameSpan: AbsoluteSourceSpan, receiver: AST, name: string);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class PropertyWrite extends ASTWithName {
            receiver: AST;
            name: string;
            value: AST;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, nameSpan: AbsoluteSourceSpan, receiver: AST, name: string, value: AST);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export function publishFacade(global: any): void;
    
    /**
        * Metadata container for a `Target` that allows queries for specific bits of metadata.
        *
        * See `BoundTarget` for documentation on the individual methods.
        */
    export class R3BoundTarget<DirectiveT extends DirectiveMeta> implements BoundTarget<DirectiveT> {
            readonly target: Target;
            constructor(target: Target, directives: Map<TmplAstElement | TmplAstTemplate, DirectiveT[]>, bindings: Map<TmplAstBoundAttribute | TmplAstBoundEvent | TmplAstTextAttribute, DirectiveT | TmplAstElement | TmplAstTemplate>, references: Map<TmplAstBoundAttribute | TmplAstBoundEvent | TmplAstReference | TmplAstTextAttribute, {
                    directive: DirectiveT;
                    node: TmplAstElement | TmplAstTemplate;
            } | TmplAstElement | TmplAstTemplate>, exprTargets: Map<AST, TmplAstReference | TmplAstVariable>, symbols: Map<TmplAstReference | TmplAstVariable, TmplAstTemplate>, nestingLevel: Map<TmplAstTemplate, number>, templateEntities: Map<TmplAstTemplate | null, ReadonlySet<TmplAstReference | TmplAstVariable>>, usedPipes: Set<string>);
            getEntitiesInTemplateScope(template: TmplAstTemplate | null): ReadonlySet<TmplAstReference | TmplAstVariable>;
            getDirectivesOfNode(node: TmplAstElement | TmplAstTemplate): DirectiveT[] | null;
            getReferenceTarget(ref: TmplAstReference): {
                    directive: DirectiveT;
                    node: TmplAstElement | TmplAstTemplate;
            } | TmplAstElement | TmplAstTemplate | null;
            getConsumerOfBinding(binding: TmplAstBoundAttribute | TmplAstBoundEvent | TmplAstTextAttribute): DirectiveT | TmplAstElement | TmplAstTemplate | null;
            getExpressionTarget(expr: AST): TmplAstReference | TmplAstVariable | null;
            getTemplateOfSymbol(symbol: TmplAstReference | TmplAstVariable): TmplAstTemplate | null;
            getNestingLevel(template: TmplAstTemplate): number;
            getUsedDirectives(): DirectiveT[];
            getUsedPipes(): string[];
    }
    
    /**
        * Metadata of a class which captures the original Angular decorators of a class. The original
        * decorators are preserved in the generated code to allow TestBed APIs to recompile the class
        * using the original decorator with a set of overrides applied.
        */
    export interface R3ClassMetadata {
            /**
                * The class type for which the metadata is captured.
                */
            type: outputAst.Expression;
            /**
                * An expression representing the Angular decorators that were applied on the class.
                */
            decorators: outputAst.Expression;
            /**
                * An expression representing the Angular decorators applied to constructor parameters, or `null`
                * if there is no constructor.
                */
            ctorParameters: outputAst.Expression | null;
            /**
                * An expression representing the Angular decorators that were applied on the properties of the
                * class, or `null` if no properties have decorators.
                */
            propDecorators: outputAst.Expression | null;
    }
    
    /**
        * Result of compilation of a render3 code unit, e.g. component, directive, pipe, etc.
        */
    export interface R3CompiledExpression {
            expression: outputAst.Expression;
            type: outputAst.Type;
            statements: outputAst.Statement[];
    }
    
    /**
        * Information needed to compile a component for the render3 runtime.
        */
    export interface R3ComponentMetadata<DeclarationT extends R3TemplateDependency> extends R3DirectiveMetadata {
            /**
                * Information about the component's template.
                */
            template: {
                    /**
                        * Parsed nodes of the template.
                        */
                    nodes: t.Node[];
                    /**
                        * Any ng-content selectors extracted from the template. Contains `*` when an ng-content
                        * element without selector is present.
                        */
                    ngContentSelectors: string[];
            };
            declarations: DeclarationT[];
            /**
                * Specifies how the 'directives' and/or `pipes` array, if generated, need to be emitted.
                */
            declarationListEmitMode: DeclarationListEmitMode;
            /**
                * A collection of styling data that will be applied and scoped to the component.
                */
            styles: string[];
            /**
                * An encapsulation policy for the component's styling.
                * Possible values:
                * - `ViewEncapsulation.Emulated`: Apply modified component styles in order to emulate
                *                                 a native Shadow DOM CSS encapsulation behavior.
                * - `ViewEncapsulation.None`: Apply component styles globally without any sort of encapsulation.
                * - `ViewEncapsulation.ShadowDom`: Use the browser's native Shadow DOM API to encapsulate styles.
                */
            encapsulation: ViewEncapsulation;
            /**
                * A collection of animation triggers that will be used in the component template.
                */
            animations: outputAst.Expression | null;
            /**
                * The list of view providers defined in the component.
                */
            viewProviders: outputAst.Expression | null;
            /**
                * Path to the .ts file in which this template's generated code will be included, relative to
                * the compilation root. This will be used to generate identifiers that need to be globally
                * unique in certain contexts (such as g3).
                */
            relativeContextFilePath: string;
            /**
                * Whether translation variable name should contain external message id
                * (used by Closure Compiler's output of `goog.getMsg` for transition period).
                */
            i18nUseExternalIds: boolean;
            /**
                * Overrides the default interpolation start and end delimiters ({{ and }}).
                */
            interpolation: InterpolationConfig;
            /**
                * Strategy used for detecting changes in the component.
                */
            changeDetection?: ChangeDetectionStrategy;
    }
    
    /**
        * Metadata required by the factory generator to generate a `factory` function for a type.
        */
    interface R3ConstructorFactoryMetadata {
            /**
                * String name of the type being generated (used to name the factory function).
                */
            name: string;
            /**
                * An expression representing the interface type being constructed.
                */
            type: R3Reference;
            /**
                * An expression representing the constructor type, intended for use within a class definition
                * itself.
                *
                * This can differ from the outer `type` if the class is being compiled by ngcc and is inside
                * an IIFE structure that uses a different name internally.
                */
            internalType: outputAst.Expression;
            /** Number of arguments for the `type`. */
            typeArgumentCount: number;
            /**
                * Regardless of whether `fnOrClass` is a constructor function or a user-defined factory, it
                * may have 0 or more parameters, which will be injected according to the `R3DependencyMetadata`
                * for those parameters. If this is `null`, then the type's constructor is nonexistent and will
                * be inherited from `fnOrClass` which is interpreted as the current type. If this is `'invalid'`,
                * then one or more of the parameters wasn't resolvable and any attempt to use these deps will
                * result in a runtime error.
                */
            deps: R3DependencyMetadata[] | 'invalid' | null;
            /**
                * Type of the target being created by the factory.
                */
            target: FactoryTarget;
    }
    
    type R3CssSelector = (string | SelectorFlags)[];
    
    type R3CssSelectorList = R3CssSelector[];
    
    /**
        * Describes the shape of the object that the `ɵɵngDeclareClassMetadata()` function accepts.
        *
        * This interface serves primarily as documentation, as conformance to this interface is not
        * enforced during linking.
        */
    export interface R3DeclareClassMetadata extends R3PartialDeclaration {
            /**
                * The Angular decorators of the class.
                */
            decorators: outputAst.Expression;
            /**
                * Optionally specifies the constructor parameters, their types and the Angular decorators of each
                * parameter. This property is omitted if the class does not have a constructor.
                */
            ctorParameters?: outputAst.Expression;
            /**
                * Optionally specifies the Angular decorators applied to the class properties. This property is
                * omitted if no properties have any decorators.
                */
            propDecorators?: outputAst.Expression;
    }
    
    /**
        * Describes the shape of the object that the `ɵɵngDeclareComponent()` function accepts.
        */
    export interface R3DeclareComponentMetadata extends R3DeclareDirectiveMetadata {
            /**
                * The component's unparsed template string as opaque expression. The template is represented
                * using either a string literal or template literal without substitutions, but its value is
                * not read directly. Instead, the template parser is given the full source file's text and
                * the range of this expression to parse directly from source.
                */
            template: outputAst.Expression;
            /**
                * Whether the template was inline (using `template`) or external (using `templateUrl`).
                * Defaults to false.
                */
            isInline?: boolean;
            /**
                * CSS from inline styles and included styleUrls.
                */
            styles?: string[];
            /**
                * List of components which matched in the template, including sufficient
                * metadata for each directive to attribute bindings and references within
                * the template to each directive specifically, if the runtime instructions
                * support this.
                */
            components?: R3DeclareDirectiveDependencyMetadata[];
            /**
                * List of directives which matched in the template, including sufficient
                * metadata for each directive to attribute bindings and references within
                * the template to each directive specifically, if the runtime instructions
                * support this.
                */
            directives?: R3DeclareDirectiveDependencyMetadata[];
            /**
                * List of dependencies which matched in the template, including sufficient
                * metadata for each directive/pipe to attribute bindings and references within
                * the template to each directive specifically, if the runtime instructions
                * support this.
                */
            dependencies?: R3DeclareTemplateDependencyMetadata[];
            /**
                * A map of pipe names to an expression referencing the pipe type (possibly a forward reference
                * wrapped in a `forwardRef` invocation) which are used in the template.
                */
            pipes?: {
                    [pipeName: string]: outputAst.Expression | (() => outputAst.Expression);
            };
            /**
                * The list of view providers defined in the component.
                */
            viewProviders?: outputAst.Expression;
            /**
                * A collection of animation triggers that will be used in the component template.
                */
            animations?: outputAst.Expression;
            /**
                * Strategy used for detecting changes in the component.
                * Defaults to `ChangeDetectionStrategy.Default`.
                */
            changeDetection?: ChangeDetectionStrategy;
            /**
                * An encapsulation policy for the component's styling.
                * Defaults to `ViewEncapsulation.Emulated`.
                */
            encapsulation?: ViewEncapsulation;
            /**
                * Overrides the default interpolation start and end delimiters. Defaults to {{ and }}.
                */
            interpolation?: [string, string];
            /**
                * Whether whitespace in the template should be preserved. Defaults to false.
                */
            preserveWhitespaces?: boolean;
    }
    
    /**
        * Metadata indicating how a dependency should be injected into a factory.
        */
    export interface R3DeclareDependencyMetadata {
            /**
                * An expression representing the token or value to be injected, or `null` if the dependency is
                * not valid.
                *
                * If this dependency is due to the `@Attribute()` decorator, then this is an expression
                * evaluating to the name of the attribute.
                */
            token: outputAst.Expression | null;
            /**
                * Whether the dependency is injecting an attribute value.
                * Default: false.
                */
            attribute?: boolean;
            /**
                * Whether the dependency has an @Host qualifier.
                * Default: false,
                */
            host?: boolean;
            /**
                * Whether the dependency has an @Optional qualifier.
                * Default: false,
                */
            optional?: boolean;
            /**
                * Whether the dependency has an @Self qualifier.
                * Default: false,
                */
            self?: boolean;
            /**
                * Whether the dependency has an @SkipSelf qualifier.
                * Default: false,
                */
            skipSelf?: boolean;
    }
    
    export interface R3DeclareDirectiveDependencyMetadata {
            kind: 'directive' | 'component';
            /**
                * Selector of the directive.
                */
            selector: string;
            /**
                * Reference to the directive class (possibly a forward reference wrapped in a `forwardRef`
                * invocation).
                */
            type: outputAst.Expression | (() => outputAst.Expression);
            /**
                * Property names of the directive's inputs.
                */
            inputs?: string[];
            /**
                * Event names of the directive's outputs.
                */
            outputs?: string[];
            /**
                * Names by which this directive exports itself for references.
                */
            exportAs?: string[];
    }
    
    /**
        * Describes the shape of the object that the `ɵɵngDeclareDirective()` function accepts.
        */
    export interface R3DeclareDirectiveMetadata extends R3PartialDeclaration {
            /**
                * Unparsed selector of the directive.
                */
            selector?: string;
            /**
                * A mapping of inputs from class property names to binding property names, or to a tuple of
                * binding property name and class property name if the names are different.
                */
            inputs?: {
                    [classPropertyName: string]: string | [string, string];
            };
            /**
                * A mapping of outputs from class property names to binding property names.
                */
            outputs?: {
                    [classPropertyName: string]: string;
            };
            /**
                * Information about host bindings present on the component.
                */
            host?: {
                    /**
                        * A mapping of attribute names to their value expression.
                        */
                    attributes?: {
                            [key: string]: outputAst.Expression;
                    };
                    /**
                        * A mapping of event names to their unparsed event handler expression.
                        */
                    listeners: {
                            [key: string]: string;
                    };
                    /**
                        * A mapping of bound properties to their unparsed binding expression.
                        */
                    properties?: {
                            [key: string]: string;
                    };
                    /**
                        * The value of the class attribute, if present. This is stored outside of `attributes` as its
                        * string value must be known statically.
                        */
                    classAttribute?: string;
                    /**
                        * The value of the style attribute, if present. This is stored outside of `attributes` as its
                        * string value must be known statically.
                        */
                    styleAttribute?: string;
            };
            /**
                * Information about the content queries made by the directive.
                */
            queries?: R3DeclareQueryMetadata[];
            /**
                * Information about the view queries made by the directive.
                */
            viewQueries?: R3DeclareQueryMetadata[];
            /**
                * The list of providers provided by the directive.
                */
            providers?: outputAst.Expression;
            /**
                * The names by which the directive is exported.
                */
            exportAs?: string[];
            /**
                * Whether the directive has an inheritance clause. Defaults to false.
                */
            usesInheritance?: boolean;
            /**
                * Whether the directive implements the `ngOnChanges` hook. Defaults to false.
                */
            usesOnChanges?: boolean;
            /**
                * Whether the directive is standalone. Defaults to false.
                */
            isStandalone?: boolean;
            /**
                * Additional directives applied to the directive host.
                */
            hostDirectives?: R3DeclareHostDirectiveMetadata[];
    }
    
    /**
        * Describes the shape of the object that the `ɵɵngDeclareFactory()` function accepts.
        *
        * This interface serves primarily as documentation, as conformance to this interface is not
        * enforced during linking.
        */
    export interface R3DeclareFactoryMetadata extends R3PartialDeclaration {
            /**
                * A collection of dependencies that this factory relies upon.
                *
                * If this is `null`, then the type's constructor is nonexistent and will be inherited from an
                * ancestor of the type.
                *
                * If this is `'invalid'`, then one or more of the parameters wasn't resolvable and any attempt to
                * use these deps will result in a runtime error.
                */
            deps: R3DeclareDependencyMetadata[] | 'invalid' | null;
            /**
                * Type of the target being created by the factory.
                */
            target: FactoryTarget_2;
    }
    
    /**
        * Describes the shape of the object literal that can be
        * passed in as a part of the `hostDirectives` array.
        */
    export interface R3DeclareHostDirectiveMetadata {
            directive: outputAst.Expression;
            inputs?: string[];
            outputs?: string[];
    }
    
    /**
        * Describes the shape of the object that the `ɵɵngDeclareInjectable()` function accepts.
        *
        * This interface serves primarily as documentation, as conformance to this interface is not
        * enforced during linking.
        */
    export interface R3DeclareInjectableMetadata extends R3PartialDeclaration {
            /**
                * If provided, specifies that the declared injectable belongs to a particular injector:
                * - `InjectorType` such as `NgModule`,
                * - `'root'` the root injector
                * - `'any'` all injectors.
                * If not provided, then it does not belong to any injector. Must be explicitly listed in the
                * providers of an injector.
                */
            providedIn?: outputAst.Expression;
            /**
                * If provided, an expression that evaluates to a class to use when creating an instance of this
                * injectable.
                */
            useClass?: outputAst.Expression;
            /**
                * If provided, an expression that evaluates to a function to use when creating an instance of
                * this injectable.
                */
            useFactory?: outputAst.Expression;
            /**
                * If provided, an expression that evaluates to a token of another injectable that this injectable
                * aliases.
                */
            useExisting?: outputAst.Expression;
            /**
                * If provided, an expression that evaluates to the value of the instance of this injectable.
                */
            useValue?: outputAst.Expression;
            /**
                * An array of dependencies to support instantiating this injectable via `useClass` or
                * `useFactory`.
                */
            deps?: R3DeclareDependencyMetadata[];
    }
    
    /**
        * Describes the shape of the objects that the `ɵɵngDeclareInjector()` accepts.
        */
    export interface R3DeclareInjectorMetadata extends R3PartialDeclaration {
            /**
                * The list of providers provided by the injector.
                */
            providers?: outputAst.Expression;
            /**
                * The list of imports into the injector.
                */
            imports?: outputAst.Expression[];
    }
    
    export interface R3DeclareNgModuleDependencyMetadata {
            kind: 'ngmodule';
            type: outputAst.Expression | (() => outputAst.Expression);
    }
    
    /**
        * Describes the shape of the objects that the `ɵɵngDeclareNgModule()` accepts.
        */
    export interface R3DeclareNgModuleMetadata extends R3PartialDeclaration {
            /**
                * An array of expressions representing the bootstrap components specified by the module.
                */
            bootstrap?: outputAst.Expression[];
            /**
                * An array of expressions representing the directives and pipes declared by the module.
                */
            declarations?: outputAst.Expression[];
            /**
                * An array of expressions representing the imports of the module.
                */
            imports?: outputAst.Expression[];
            /**
                * An array of expressions representing the exports of the module.
                */
            exports?: outputAst.Expression[];
            /**
                * The set of schemas that declare elements to be allowed in the NgModule.
                */
            schemas?: outputAst.Expression[];
            /** Unique ID or expression representing the unique ID of an NgModule. */
            id?: outputAst.Expression;
    }
    
    export interface R3DeclarePipeDependencyMetadata {
            kind: 'pipe';
            name: string;
            /**
                * Reference to the pipe class (possibly a forward reference wrapped in a `forwardRef`
                * invocation).
                */
            type: outputAst.Expression | (() => outputAst.Expression);
    }
    
    /**
        * Describes the shape of the object that the `ɵɵngDeclarePipe()` function accepts.
        *
        * This interface serves primarily as documentation, as conformance to this interface is not
        * enforced during linking.
        */
    export interface R3DeclarePipeMetadata extends R3PartialDeclaration {
            /**
                * The name to use in templates to refer to this pipe.
                */
            name: string;
            /**
                * Whether this pipe is "pure".
                *
                * A pure pipe's `transform()` method is only invoked when its input arguments change.
                *
                * Default: true.
                */
            pure?: boolean;
            /**
                * Whether the pipe is standalone.
                *
                * Default: false.
                */
            isStandalone?: boolean;
    }
    
    export interface R3DeclareQueryMetadata {
            /**
                * Name of the property on the class to update with query results.
                */
            propertyName: string;
            /**
                * Whether to read only the first matching result, or an array of results. Defaults to false.
                */
            first?: boolean;
            /**
                * Either an expression representing a type (possibly wrapped in a `forwardRef()`) or
                * `InjectionToken` for the query predicate, or a set of string selectors.
                */
            predicate: outputAst.Expression | string[];
            /**
                * Whether to include only direct children or all descendants. Defaults to false.
                */
            descendants?: boolean;
            /**
                * True to only fire changes if there are underlying changes to the query.
                */
            emitDistinctChangesOnly?: boolean;
            /**
                * An expression representing a type to read from each matched node, or null if the default value
                * for a given node is to be returned.
                */
            read?: outputAst.Expression;
            /**
                * Whether or not this query should collect only static results. Defaults to false.
                *
                * If static is true, the query's results will be set on the component after nodes are created,
                * but before change detection runs. This means that any results that relied upon change detection
                * to run (e.g. results inside *ngIf or *ngFor views) will not be collected. Query results are
                * available in the ngOnInit hook.
                *
                * If static is false, the query's results will be set on the component after change detection
                * runs. This means that the query results can contain nodes inside *ngIf or *ngFor views, but
                * the results will not be available in the ngOnInit hook (only in the ngAfterContentInit for
                * content hooks and ngAfterViewInit for view hooks).
                */
            static?: boolean;
    }
    
    export type R3DeclareTemplateDependencyMetadata = R3DeclareDirectiveDependencyMetadata | R3DeclarePipeDependencyMetadata | R3DeclareNgModuleDependencyMetadata;
    
    interface R3DelegatedFnOrClassMetadata extends R3ConstructorFactoryMetadata {
            delegate: outputAst.Expression;
            delegateType: R3FactoryDelegateType;
            delegateDeps: R3DependencyMetadata[];
    }
    
    export interface R3DependencyMetadata {
            /**
                * An expression representing the token or value to be injected.
                * Or `null` if the dependency could not be resolved - making it invalid.
                */
            token: outputAst.Expression | null;
            /**
                * If an @Attribute decorator is present, this is the literal type of the attribute name, or
                * the unknown type if no literal type is available (e.g. the attribute name is an expression).
                * Otherwise it is null;
                */
            attributeNameType: outputAst.Expression | null;
            /**
                * Whether the dependency has an @Host qualifier.
                */
            host: boolean;
            /**
                * Whether the dependency has an @Optional qualifier.
                */
            optional: boolean;
            /**
                * Whether the dependency has an @Self qualifier.
                */
            self: boolean;
            /**
                * Whether the dependency has an @SkipSelf qualifier.
                */
            skipSelf: boolean;
    }
    
    /**
        * Information about a directive that is used in a component template. Only the stable, public
        * facing information of the directive is stored here.
        */
    export interface R3DirectiveDependencyMetadata extends R3TemplateDependency {
            kind: R3TemplateDependencyKind.Directive;
            /**
                * The selector of the directive.
                */
            selector: string;
            /**
                * The binding property names of the inputs of the directive.
                */
            inputs: string[];
            /**
                * The binding property names of the outputs of the directive.
                */
            outputs: string[];
            /**
                * Name under which the directive is exported, if any (exportAs in Angular). Null otherwise.
                */
            exportAs: string[] | null;
            /**
                * If true then this directive is actually a component; otherwise it is not.
                */
            isComponent: boolean;
    }
    
    /**
        * Information needed to compile a directive for the render3 runtime.
        */
    export interface R3DirectiveMetadata {
            /**
                * Name of the directive type.
                */
            name: string;
            /**
                * An expression representing a reference to the directive itself.
                */
            type: R3Reference;
            /**
                * An expression representing a reference to the directive being compiled, intended for use within
                * a class definition itself.
                *
                * This can differ from the outer `type` if the class is being compiled by ngcc and is inside
                * an IIFE structure that uses a different name internally.
                */
            internalType: outputAst.Expression;
            /**
                * Number of generic type parameters of the type itself.
                */
            typeArgumentCount: number;
            /**
                * A source span for the directive type.
                */
            typeSourceSpan: ParseSourceSpan;
            /**
                * Dependencies of the directive's constructor.
                */
            deps: R3DependencyMetadata[] | 'invalid' | null;
            /**
                * Unparsed selector of the directive, or `null` if there was no selector.
                */
            selector: string | null;
            /**
                * Information about the content queries made by the directive.
                */
            queries: R3QueryMetadata[];
            /**
                * Information about the view queries made by the directive.
                */
            viewQueries: R3QueryMetadata[];
            /**
                * Mappings indicating how the directive interacts with its host element (host bindings,
                * listeners, etc).
                */
            host: R3HostMetadata;
            /**
                * Information about usage of specific lifecycle events which require special treatment in the
                * code generator.
                */
            lifecycle: {
                    /**
                        * Whether the directive uses NgOnChanges.
                        */
                    usesOnChanges: boolean;
            };
            /**
                * A mapping of inputs from class property names to binding property names, or to a tuple of
                * binding property name and class property name if the names are different.
                */
            inputs: {
                    [field: string]: string | [string, string];
            };
            /**
                * A mapping of outputs from class property names to binding property names, or to a tuple of
                * binding property name and class property name if the names are different.
                */
            outputs: {
                    [field: string]: string;
            };
            /**
                * Whether or not the component or directive inherits from another class
                */
            usesInheritance: boolean;
            /**
                * Whether or not the component or directive inherits its entire decorator from its base class.
                */
            fullInheritance: boolean;
            /**
                * Reference name under which to export the directive's type in a template,
                * if any.
                */
            exportAs: string[] | null;
            /**
                * The list of providers defined in the directive.
                */
            providers: outputAst.Expression | null;
            /**
                * Whether or not the component or directive is standalone.
                */
            isStandalone: boolean;
            /**
                * Additional directives applied to the directive host.
                */
            hostDirectives: R3HostDirectiveMetadata[] | null;
    }
    
    interface R3ExpressionFactoryMetadata extends R3ConstructorFactoryMetadata {
            expression: outputAst.Expression;
    }
    
    enum R3FactoryDelegateType {
            Class = 0,
            Function = 1
    }
    
    export type R3FactoryMetadata = R3ConstructorFactoryMetadata | R3DelegatedFnOrClassMetadata | R3ExpressionFactoryMetadata;
    
    /**
        * Information needed to compile a host directive for the render3 runtime.
        */
    export interface R3HostDirectiveMetadata {
            /** An expression representing the host directive class itself. */
            directive: R3Reference;
            /** Whether the expression referring to the host directive is a forward reference. */
            isForwardReference: boolean;
            /** Inputs from the host directive that will be exposed on the host. */
            inputs: {
                    [publicName: string]: string;
            } | null;
            /** Outputs from the host directive that will be exposed on the host. */
            outputs: {
                    [publicName: string]: string;
            } | null;
    }
    
    /**
        * Mappings indicating how the class interacts with its
        * host element (host bindings, listeners, etc).
        */
    export interface R3HostMetadata {
            /**
                * A mapping of attribute binding keys to `o.Expression`s.
                */
            attributes: {
                    [key: string]: outputAst.Expression;
            };
            /**
                * A mapping of event binding keys to unparsed expressions.
                */
            listeners: {
                    [key: string]: string;
            };
            /**
                * A mapping of property binding keys to unparsed expressions.
                */
            properties: {
                    [key: string]: string;
            };
            specialAttributes: {
                    styleAttr?: string;
                    classAttr?: string;
            };
    }
    
    export class R3Identifiers {
            static NEW_METHOD: string;
            static TRANSFORM_METHOD: string;
            static PATCH_DEPS: string;
            static core: outputAst.ExternalReference;
            static namespaceHTML: outputAst.ExternalReference;
            static namespaceMathML: outputAst.ExternalReference;
            static namespaceSVG: outputAst.ExternalReference;
            static element: outputAst.ExternalReference;
            static elementStart: outputAst.ExternalReference;
            static elementEnd: outputAst.ExternalReference;
            static advance: outputAst.ExternalReference;
            static syntheticHostProperty: outputAst.ExternalReference;
            static syntheticHostListener: outputAst.ExternalReference;
            static attribute: outputAst.ExternalReference;
            static attributeInterpolate1: outputAst.ExternalReference;
            static attributeInterpolate2: outputAst.ExternalReference;
            static attributeInterpolate3: outputAst.ExternalReference;
            static attributeInterpolate4: outputAst.ExternalReference;
            static attributeInterpolate5: outputAst.ExternalReference;
            static attributeInterpolate6: outputAst.ExternalReference;
            static attributeInterpolate7: outputAst.ExternalReference;
            static attributeInterpolate8: outputAst.ExternalReference;
            static attributeInterpolateV: outputAst.ExternalReference;
            static classProp: outputAst.ExternalReference;
            static elementContainerStart: outputAst.ExternalReference;
            static elementContainerEnd: outputAst.ExternalReference;
            static elementContainer: outputAst.ExternalReference;
            static styleMap: outputAst.ExternalReference;
            static styleMapInterpolate1: outputAst.ExternalReference;
            static styleMapInterpolate2: outputAst.ExternalReference;
            static styleMapInterpolate3: outputAst.ExternalReference;
            static styleMapInterpolate4: outputAst.ExternalReference;
            static styleMapInterpolate5: outputAst.ExternalReference;
            static styleMapInterpolate6: outputAst.ExternalReference;
            static styleMapInterpolate7: outputAst.ExternalReference;
            static styleMapInterpolate8: outputAst.ExternalReference;
            static styleMapInterpolateV: outputAst.ExternalReference;
            static classMap: outputAst.ExternalReference;
            static classMapInterpolate1: outputAst.ExternalReference;
            static classMapInterpolate2: outputAst.ExternalReference;
            static classMapInterpolate3: outputAst.ExternalReference;
            static classMapInterpolate4: outputAst.ExternalReference;
            static classMapInterpolate5: outputAst.ExternalReference;
            static classMapInterpolate6: outputAst.ExternalReference;
            static classMapInterpolate7: outputAst.ExternalReference;
            static classMapInterpolate8: outputAst.ExternalReference;
            static classMapInterpolateV: outputAst.ExternalReference;
            static styleProp: outputAst.ExternalReference;
            static stylePropInterpolate1: outputAst.ExternalReference;
            static stylePropInterpolate2: outputAst.ExternalReference;
            static stylePropInterpolate3: outputAst.ExternalReference;
            static stylePropInterpolate4: outputAst.ExternalReference;
            static stylePropInterpolate5: outputAst.ExternalReference;
            static stylePropInterpolate6: outputAst.ExternalReference;
            static stylePropInterpolate7: outputAst.ExternalReference;
            static stylePropInterpolate8: outputAst.ExternalReference;
            static stylePropInterpolateV: outputAst.ExternalReference;
            static nextContext: outputAst.ExternalReference;
            static resetView: outputAst.ExternalReference;
            static templateCreate: outputAst.ExternalReference;
            static text: outputAst.ExternalReference;
            static enableBindings: outputAst.ExternalReference;
            static disableBindings: outputAst.ExternalReference;
            static getCurrentView: outputAst.ExternalReference;
            static textInterpolate: outputAst.ExternalReference;
            static textInterpolate1: outputAst.ExternalReference;
            static textInterpolate2: outputAst.ExternalReference;
            static textInterpolate3: outputAst.ExternalReference;
            static textInterpolate4: outputAst.ExternalReference;
            static textInterpolate5: outputAst.ExternalReference;
            static textInterpolate6: outputAst.ExternalReference;
            static textInterpolate7: outputAst.ExternalReference;
            static textInterpolate8: outputAst.ExternalReference;
            static textInterpolateV: outputAst.ExternalReference;
            static restoreView: outputAst.ExternalReference;
            static pureFunction0: outputAst.ExternalReference;
            static pureFunction1: outputAst.ExternalReference;
            static pureFunction2: outputAst.ExternalReference;
            static pureFunction3: outputAst.ExternalReference;
            static pureFunction4: outputAst.ExternalReference;
            static pureFunction5: outputAst.ExternalReference;
            static pureFunction6: outputAst.ExternalReference;
            static pureFunction7: outputAst.ExternalReference;
            static pureFunction8: outputAst.ExternalReference;
            static pureFunctionV: outputAst.ExternalReference;
            static pipeBind1: outputAst.ExternalReference;
            static pipeBind2: outputAst.ExternalReference;
            static pipeBind3: outputAst.ExternalReference;
            static pipeBind4: outputAst.ExternalReference;
            static pipeBindV: outputAst.ExternalReference;
            static hostProperty: outputAst.ExternalReference;
            static property: outputAst.ExternalReference;
            static propertyInterpolate: outputAst.ExternalReference;
            static propertyInterpolate1: outputAst.ExternalReference;
            static propertyInterpolate2: outputAst.ExternalReference;
            static propertyInterpolate3: outputAst.ExternalReference;
            static propertyInterpolate4: outputAst.ExternalReference;
            static propertyInterpolate5: outputAst.ExternalReference;
            static propertyInterpolate6: outputAst.ExternalReference;
            static propertyInterpolate7: outputAst.ExternalReference;
            static propertyInterpolate8: outputAst.ExternalReference;
            static propertyInterpolateV: outputAst.ExternalReference;
            static i18n: outputAst.ExternalReference;
            static i18nAttributes: outputAst.ExternalReference;
            static i18nExp: outputAst.ExternalReference;
            static i18nStart: outputAst.ExternalReference;
            static i18nEnd: outputAst.ExternalReference;
            static i18nApply: outputAst.ExternalReference;
            static i18nPostprocess: outputAst.ExternalReference;
            static pipe: outputAst.ExternalReference;
            static projection: outputAst.ExternalReference;
            static projectionDef: outputAst.ExternalReference;
            static reference: outputAst.ExternalReference;
            static inject: outputAst.ExternalReference;
            static injectAttribute: outputAst.ExternalReference;
            static directiveInject: outputAst.ExternalReference;
            static invalidFactory: outputAst.ExternalReference;
            static invalidFactoryDep: outputAst.ExternalReference;
            static templateRefExtractor: outputAst.ExternalReference;
            static forwardRef: outputAst.ExternalReference;
            static resolveForwardRef: outputAst.ExternalReference;
            static ɵɵdefineInjectable: outputAst.ExternalReference;
            static declareInjectable: outputAst.ExternalReference;
            static InjectableDeclaration: outputAst.ExternalReference;
            static resolveWindow: outputAst.ExternalReference;
            static resolveDocument: outputAst.ExternalReference;
            static resolveBody: outputAst.ExternalReference;
            static defineComponent: outputAst.ExternalReference;
            static declareComponent: outputAst.ExternalReference;
            static setComponentScope: outputAst.ExternalReference;
            static ChangeDetectionStrategy: outputAst.ExternalReference;
            static ViewEncapsulation: outputAst.ExternalReference;
            static ComponentDeclaration: outputAst.ExternalReference;
            static FactoryDeclaration: outputAst.ExternalReference;
            static declareFactory: outputAst.ExternalReference;
            static FactoryTarget: outputAst.ExternalReference;
            static defineDirective: outputAst.ExternalReference;
            static declareDirective: outputAst.ExternalReference;
            static DirectiveDeclaration: outputAst.ExternalReference;
            static InjectorDef: outputAst.ExternalReference;
            static InjectorDeclaration: outputAst.ExternalReference;
            static defineInjector: outputAst.ExternalReference;
            static declareInjector: outputAst.ExternalReference;
            static NgModuleDeclaration: outputAst.ExternalReference;
            static ModuleWithProviders: outputAst.ExternalReference;
            static defineNgModule: outputAst.ExternalReference;
            static declareNgModule: outputAst.ExternalReference;
            static setNgModuleScope: outputAst.ExternalReference;
            static registerNgModuleType: outputAst.ExternalReference;
            static PipeDeclaration: outputAst.ExternalReference;
            static definePipe: outputAst.ExternalReference;
            static declarePipe: outputAst.ExternalReference;
            static declareClassMetadata: outputAst.ExternalReference;
            static setClassMetadata: outputAst.ExternalReference;
            static queryRefresh: outputAst.ExternalReference;
            static viewQuery: outputAst.ExternalReference;
            static loadQuery: outputAst.ExternalReference;
            static contentQuery: outputAst.ExternalReference;
            static NgOnChangesFeature: outputAst.ExternalReference;
            static InheritDefinitionFeature: outputAst.ExternalReference;
            static CopyDefinitionFeature: outputAst.ExternalReference;
            static StandaloneFeature: outputAst.ExternalReference;
            static ProvidersFeature: outputAst.ExternalReference;
            static HostDirectivesFeature: outputAst.ExternalReference;
            static listener: outputAst.ExternalReference;
            static getInheritedFactory: outputAst.ExternalReference;
            static sanitizeHtml: outputAst.ExternalReference;
            static sanitizeStyle: outputAst.ExternalReference;
            static sanitizeResourceUrl: outputAst.ExternalReference;
            static sanitizeScript: outputAst.ExternalReference;
            static sanitizeUrl: outputAst.ExternalReference;
            static sanitizeUrlOrResourceUrl: outputAst.ExternalReference;
            static trustConstantHtml: outputAst.ExternalReference;
            static trustConstantResourceUrl: outputAst.ExternalReference;
            static validateIframeAttribute: outputAst.ExternalReference;
    }
    
    export interface R3InjectableMetadata {
            name: string;
            type: R3Reference;
            internalType: outputAst.Expression;
            typeArgumentCount: number;
            providedIn: MaybeForwardRefExpression;
            useClass?: MaybeForwardRefExpression;
            useFactory?: outputAst.Expression;
            useExisting?: MaybeForwardRefExpression;
            useValue?: MaybeForwardRefExpression;
            deps?: R3DependencyMetadata[];
    }
    
    export interface R3InjectorMetadata {
            name: string;
            type: R3Reference;
            internalType: outputAst.Expression;
            providers: outputAst.Expression | null;
            imports: outputAst.Expression[];
    }
    
    /**
        * Generates Source Span object for a given R3 Type for JIT mode.
        *
        * @param kind Component or Directive.
        * @param typeName name of the Component or Directive.
        * @param sourceUrl reference to Component or Directive source.
        * @returns instance of ParseSourceSpan that represent a given Component or Directive.
        */
    export function r3JitTypeSourceSpan(kind: string, typeName: string, sourceUrl: string): ParseSourceSpan;
    
    export interface R3NgModuleDependencyMetadata extends R3TemplateDependency {
            kind: R3TemplateDependencyKind.NgModule;
    }
    
    /**
        * Metadata required by the module compiler to generate a module def (`ɵmod`) for a type.
        */
    export interface R3NgModuleMetadata {
            /**
                * An expression representing the module type being compiled.
                */
            type: R3Reference;
            /**
                * An expression representing the module type being compiled, intended for use within a class
                * definition itself.
                *
                * This can differ from the outer `type` if the class is being compiled by ngcc and is inside
                * an IIFE structure that uses a different name internally.
                */
            internalType: outputAst.Expression;
            /**
                * An expression intended for use by statements that are adjacent (i.e. tightly coupled) to but
                * not internal to a class definition.
                *
                * This can differ from the outer `type` if the class is being compiled by ngcc and is inside
                * an IIFE structure that uses a different name internally.
                */
            adjacentType: outputAst.Expression;
            /**
                * An array of expressions representing the bootstrap components specified by the module.
                */
            bootstrap: R3Reference[];
            /**
                * An array of expressions representing the directives and pipes declared by the module.
                */
            declarations: R3Reference[];
            /**
                * Those declarations which should be visible to downstream consumers. If not specified, all
                * declarations are made visible to downstream consumers.
                */
            publicDeclarationTypes: outputAst.Expression[] | null;
            /**
                * An array of expressions representing the imports of the module.
                */
            imports: R3Reference[];
            /**
                * Whether or not to include `imports` in generated type declarations.
                */
            includeImportTypes: boolean;
            /**
                * An array of expressions representing the exports of the module.
                */
            exports: R3Reference[];
            /**
                * How to emit the selector scope values (declarations, imports, exports).
                */
            selectorScopeMode: R3SelectorScopeMode;
            /**
                * Whether to generate closure wrappers for bootstrap, declarations, imports, and exports.
                */
            containsForwardDecls: boolean;
            /**
                * The set of schemas that declare elements to be allowed in the NgModule.
                */
            schemas: R3Reference[] | null;
            /** Unique ID or expression representing the unique ID of an NgModule. */
            id: outputAst.Expression | null;
    }
    
    export interface R3PartialDeclaration {
            /**
                * The minimum version of the compiler that can process this partial declaration.
                */
            minVersion: string;
            /**
                * Version number of the Angular compiler that was used to compile this declaration. The linker
                * will be able to detect which version a library is using and interpret its metadata accordingly.
                */
            version: string;
            /**
                * A reference to the `@angular/core` ES module, which allows access
                * to all Angular exports, including Ivy instructions.
                */
            ngImport: outputAst.Expression;
            /**
                * Reference to the decorated class, which is subject to this partial declaration.
                */
            type: outputAst.Expression;
    }
    
    export interface R3PipeDependencyMetadata extends R3TemplateDependency {
            kind: R3TemplateDependencyKind.Pipe;
            name: string;
    }
    
    export interface R3PipeMetadata {
            /**
                * Name of the pipe type.
                */
            name: string;
            /**
                * An expression representing a reference to the pipe itself.
                */
            type: R3Reference;
            /**
                * An expression representing the pipe being compiled, intended for use within a class definition
                * itself.
                *
                * This can differ from the outer `type` if the class is being compiled by ngcc and is inside an
                * IIFE structure that uses a different name internally.
                */
            internalType: outputAst.Expression;
            /**
                * Number of generic type parameters of the type itself.
                */
            typeArgumentCount: number;
            /**
                * Name of the pipe.
                */
            pipeName: string;
            /**
                * Dependencies of the pipe's constructor.
                */
            deps: R3DependencyMetadata[] | null;
            /**
                * Whether the pipe is marked as pure.
                */
            pure: boolean;
            /**
                * Whether the pipe is standalone.
                */
            isStandalone: boolean;
    }
    
    /**
        * Information needed to compile a query (view or content).
        */
    export interface R3QueryMetadata {
            /**
                * Name of the property on the class to update with query results.
                */
            propertyName: string;
            /**
                * Whether to read only the first matching result, or an array of results.
                */
            first: boolean;
            /**
                * Either an expression representing a type or `InjectionToken` for the query
                * predicate, or a set of string selectors.
                */
            predicate: MaybeForwardRefExpression | string[];
            /**
                * Whether to include only direct children or all descendants.
                */
            descendants: boolean;
            /**
                * If the `QueryList` should fire change event only if actual change to query was computed (vs old
                * behavior where the change was fired whenever the query was recomputed, even if the recomputed
                * query resulted in the same list.)
                */
            emitDistinctChangesOnly: boolean;
            /**
                * An expression representing a type to read from each matched node, or null if the default value
                * for a given node is to be returned.
                */
            read: outputAst.Expression | null;
            /**
                * Whether or not this query should collect only static results.
                *
                * If static is true, the query's results will be set on the component after nodes are created,
                * but before change detection runs. This means that any results that relied upon change detection
                * to run (e.g. results inside *ngIf or *ngFor views) will not be collected. Query results are
                * available in the ngOnInit hook.
                *
                * If static is false, the query's results will be set on the component after change detection
                * runs. This means that the query results can contain nodes inside *ngIf or *ngFor views, but
                * the results will not be available in the ngOnInit hook (only in the ngAfterContentInit for
                * content hooks and ngAfterViewInit for view hooks).
                */
            static: boolean;
    }
    
    export interface R3Reference {
            value: outputAst.Expression;
            type: outputAst.Expression;
    }
    
    /**
        * How the selector scope of an NgModule (its declarations, imports, and exports) should be emitted
        * as a part of the NgModule definition.
        */
    export enum R3SelectorScopeMode {
            /**
                * Emit the declarations inline into the module definition.
                *
                * This option is useful in certain contexts where it's known that JIT support is required. The
                * tradeoff here is that this emit style prevents directives and pipes from being tree-shaken if
                * they are unused, but the NgModule is used.
                */
            Inline = 0,
            /**
                * Emit the declarations using a side effectful function call, `ɵɵsetNgModuleScope`, that is
                * guarded with the `ngJitMode` flag.
                *
                * This form of emit supports JIT and can be optimized away if the `ngJitMode` flag is set to
                * false, which allows unused directives and pipes to be tree-shaken.
                */
            SideEffect = 1,
            /**
                * Don't generate selector scopes at all.
                *
                * This is useful for contexts where JIT support is known to be unnecessary.
                */
            Omit = 2
    }
    
    /**
        * Processes `Target`s with a given set of directives and performs a binding operation, which
        * returns an object similar to TypeScript's `ts.TypeChecker` that contains knowledge about the
        * target.
        */
    export class R3TargetBinder<DirectiveT extends DirectiveMeta> implements TargetBinder<DirectiveT> {
            constructor(directiveMatcher: SelectorMatcher<DirectiveT[]>);
            /**
                * Perform a binding operation on the given `Target` and return a `BoundTarget` which contains
                * metadata about the types referenced in the template.
                */
            bind(target: Target): BoundTarget<DirectiveT>;
    }
    
    /**
        * A dependency that's used within a component template.
        */
    export interface R3TemplateDependency {
            kind: R3TemplateDependencyKind;
            /**
                * The type of the dependency as an expression.
                */
            type: outputAst.Expression;
    }
    
    export enum R3TemplateDependencyKind {
            Directive = 0,
            Pipe = 1,
            NgModule = 2
    }
    
    /**
        * A dependency that's used within a component template
        */
    export type R3TemplateDependencyMetadata = R3DirectiveDependencyMetadata | R3PipeDependencyMetadata | R3NgModuleDependencyMetadata;
    
    export class ReadKeyExpr extends Expression {
            receiver: Expression;
            index: Expression;
            constructor(receiver: Expression, index: Expression, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
            set(value: Expression): WriteKeyExpr;
    }
    
    export class ReadPropExpr extends Expression {
            receiver: Expression;
            name: string;
            constructor(receiver: Expression, name: string, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
            set(value: Expression): WritePropExpr;
    }
    
    export class ReadVarExpr extends Expression {
            name: string;
            constructor(name: string, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
            set(value: Expression): WriteVarExpr;
    }
    
    class RecurseVisitor implements Visitor_2 {
            visitText(text: Text_3, context?: any): any;
            visitContainer(container: Container, context?: any): any;
            visitIcu(icu: Icu, context?: any): any;
            visitTagPlaceholder(ph: TagPlaceholder, context?: any): any;
            visitPlaceholder(ph: Placeholder, context?: any): any;
            visitIcuPlaceholder(ph: IcuPlaceholder, context?: any): any;
    }
    
    export class RecursiveAstVisitor implements AstVisitor {
            visit(ast: AST, context?: any): any;
            visitUnary(ast: Unary, context: any): any;
            visitBinary(ast: Binary, context: any): any;
            visitChain(ast: Chain, context: any): any;
            visitConditional(ast: Conditional, context: any): any;
            visitPipe(ast: BindingPipe, context: any): any;
            visitImplicitReceiver(ast: ThisReceiver, context: any): any;
            visitThisReceiver(ast: ThisReceiver, context: any): any;
            visitInterpolation(ast: Interpolation, context: any): any;
            visitKeyedRead(ast: KeyedRead, context: any): any;
            visitKeyedWrite(ast: KeyedWrite, context: any): any;
            visitLiteralArray(ast: LiteralArray, context: any): any;
            visitLiteralMap(ast: LiteralMap, context: any): any;
            visitLiteralPrimitive(ast: LiteralPrimitive, context: any): any;
            visitPrefixNot(ast: PrefixNot, context: any): any;
            visitNonNullAssert(ast: NonNullAssert, context: any): any;
            visitPropertyRead(ast: PropertyRead, context: any): any;
            visitPropertyWrite(ast: PropertyWrite, context: any): any;
            visitSafePropertyRead(ast: SafePropertyRead, context: any): any;
            visitSafeKeyedRead(ast: SafeKeyedRead, context: any): any;
            visitCall(ast: Call, context: any): any;
            visitSafeCall(ast: SafeCall, context: any): any;
            visitAll(asts: AST[], context: any): any;
    }
    
    class RecursiveAstVisitor_2 implements StatementVisitor, ExpressionVisitor {
            visitType(ast: Type, context: any): any;
            visitExpression(ast: Expression, context: any): any;
            visitBuiltinType(type: BuiltinType, context: any): any;
            visitExpressionType(type: ExpressionType, context: any): any;
            visitArrayType(type: ArrayType, context: any): any;
            visitMapType(type: MapType, context: any): any;
            visitWrappedNodeExpr(ast: WrappedNodeExpr<any>, context: any): any;
            visitTypeofExpr(ast: TypeofExpr, context: any): any;
            visitReadVarExpr(ast: ReadVarExpr, context: any): any;
            visitWriteVarExpr(ast: WriteVarExpr, context: any): any;
            visitWriteKeyExpr(ast: WriteKeyExpr, context: any): any;
            visitWritePropExpr(ast: WritePropExpr, context: any): any;
            visitInvokeFunctionExpr(ast: InvokeFunctionExpr, context: any): any;
            visitTaggedTemplateExpr(ast: TaggedTemplateExpr, context: any): any;
            visitInstantiateExpr(ast: InstantiateExpr, context: any): any;
            visitLiteralExpr(ast: LiteralExpr, context: any): any;
            visitLocalizedString(ast: LocalizedString, context: any): any;
            visitExternalExpr(ast: ExternalExpr, context: any): any;
            visitConditionalExpr(ast: ConditionalExpr, context: any): any;
            visitNotExpr(ast: NotExpr, context: any): any;
            visitFunctionExpr(ast: FunctionExpr, context: any): any;
            visitUnaryOperatorExpr(ast: UnaryOperatorExpr, context: any): any;
            visitBinaryOperatorExpr(ast: BinaryOperatorExpr, context: any): any;
            visitReadPropExpr(ast: ReadPropExpr, context: any): any;
            visitReadKeyExpr(ast: ReadKeyExpr, context: any): any;
            visitLiteralArrayExpr(ast: LiteralArrayExpr, context: any): any;
            visitLiteralMapExpr(ast: LiteralMapExpr, context: any): any;
            visitCommaExpr(ast: CommaExpr, context: any): any;
            visitAllExpressions(exprs: Expression[], context: any): void;
            visitDeclareVarStmt(stmt: DeclareVarStmt, context: any): any;
            visitDeclareFunctionStmt(stmt: DeclareFunctionStmt, context: any): any;
            visitExpressionStmt(stmt: ExpressionStatement, context: any): any;
            visitReturnStmt(stmt: ReturnStatement, context: any): any;
            visitIfStmt(stmt: IfStmt, context: any): any;
            visitAllStatements(stmts: Statement[], context: any): void;
    }
    
    export class RecursiveVisitor implements Visitor {
            constructor();
            visitElement(ast: Element_2, context: any): any;
            visitAttribute(ast: Attribute, context: any): any;
            visitText(ast: Text_2, context: any): any;
            visitComment(ast: Comment_2, context: any): any;
            visitExpansion(ast: Expansion, context: any): any;
            visitExpansionCase(ast: ExpansionCase, context: any): any;
    }
    
    /**
        * Flags passed into template functions to determine which blocks (i.e. creation, update)
        * should be executed.
        *
        * Typically, a template runs both the creation block and the update block on initialization and
        * subsequent runs only execute the update block. However, dynamically created views require that
        * the creation block be executed separately from the update block (for backwards compat).
        */
    const enum RenderFlags {
            Create = 1,
            Update = 2
    }
    
    
    /**
        * An interface for retrieving documents by URL that the compiler uses to
        * load templates.
        *
        * This is an abstract class, rather than an interface, so that it can be used
        * as injection token.
        */
    export abstract class ResourceLoader {
            abstract get(url: string): Promise<string> | string;
    }
    
    export class ReturnStatement extends Statement {
            value: Expression;
            constructor(value: Expression, sourceSpan?: ParseSourceSpan | null, leadingComments?: LeadingComment[]);
            isEquivalent(stmt: Statement): boolean;
            visitStatement(visitor: StatementVisitor, context: any): any;
    }
    
    export class SafeCall extends AST {
            receiver: AST;
            args: AST[];
            argumentSpan: AbsoluteSourceSpan;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, receiver: AST, args: AST[], argumentSpan: AbsoluteSourceSpan);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class SafeKeyedRead extends AST {
            receiver: AST;
            key: AST;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, receiver: AST, key: AST);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class SafePropertyRead extends ASTWithName {
            receiver: AST;
            name: string;
            constructor(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, nameSpan: AbsoluteSourceSpan, receiver: AST, name: string);
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export function sanitizeIdentifier(name: string): string;
    
    export interface SchemaMetadata {
            name: string;
    }
    
    enum SecurityContext {
            NONE = 0,
            HTML = 1,
            STYLE = 2,
            SCRIPT = 3,
            URL = 4,
            RESOURCE_URL = 5
    }
    
    export class SelectorContext<T = any> {
            selector: CssSelector;
            cbContext: T;
            listContext: SelectorListContext;
            notSelectors: CssSelector[];
            constructor(selector: CssSelector, cbContext: T, listContext: SelectorListContext);
            finalize(cssSelector: CssSelector, callback: ((c: CssSelector, a: T) => void) | null): boolean;
    }
    
    /**
        * Flags used to generate R3-style CSS Selectors. They are pasted from
        * core/src/render3/projection.ts because they cannot be referenced directly.
        */
    const enum SelectorFlags {
            /** Indicates this is the beginning of a new negative selector */
            NOT = 1,
            /** Mode for matching attributes */
            ATTRIBUTE = 2,
            /** Mode for matching tag names */
            ELEMENT = 4,
            /** Mode for matching class names */
            CLASS = 8
    }
    
    export class SelectorListContext {
            selectors: CssSelector[];
            alreadyMatched: boolean;
            constructor(selectors: CssSelector[]);
    }
    
    /**
        * Reads a list of CssSelectors and allows to calculate which ones
        * are contained in a given CssSelector.
        */
    export class SelectorMatcher<T = any> {
            static createNotMatcher(notSelectors: CssSelector[]): SelectorMatcher<null>;
            addSelectables(cssSelectors: CssSelector[], callbackCtxt?: T): void;
            /**
                * Find the objects that have been added via `addSelectable`
                * whose css selector is contained in the given css selector.
                * @param cssSelector A css selector
                * @param matchedCallback This callback will be called with the object handed into `addSelectable`
                * @return boolean true if a match was found
                */
            match(cssSelector: CssSelector, matchedCallback: ((c: CssSelector, a: T) => void) | null): boolean;
    }
    
    export abstract class Serializer {
            abstract write(messages: i18n.Message[], locale: string | null): string;
            abstract load(content: string, url: string): {
                    locale: string | null;
                    i18nNodesByMsgId: {
                            [msgId: string]: i18n.Node[];
                    };
            };
            abstract digest(message: i18n.Message): string;
            createNameMapper(message: i18n.Message): PlaceholderMapper | null;
    }
    
    
    export type SourceMap = {
            version: number;
            file?: string;
            sourceRoot: string;
            sources: string[];
            sourcesContent: (string | null)[];
            mappings: string;
    };
    
    class SourceMapGenerator {
            constructor(file?: string | null);
            addSource(url: string, content?: string | null): this;
            addLine(): this;
            addMapping(col0: number, sourceUrl?: string, sourceLine0?: number, sourceCol0?: number): this;
            toJSON(): SourceMap | null;
            toJsComment(): string;
    }
    
    export class SplitInterpolation {
            strings: InterpolationPiece[];
            expressions: InterpolationPiece[];
            offsets: number[];
            constructor(strings: InterpolationPiece[], expressions: InterpolationPiece[], offsets: number[]);
    }
    
    export function splitNsName(elementName: string): [string | null, string];
    
    export abstract class Statement {
            modifiers: StmtModifier;
            sourceSpan: ParseSourceSpan | null;
            leadingComments?: LeadingComment[] | undefined;
            constructor(modifiers?: StmtModifier, sourceSpan?: ParseSourceSpan | null, leadingComments?: LeadingComment[] | undefined);
            /**
                * Calculates whether this statement produces the same value as the given statement.
                * Note: We don't check Types nor ParseSourceSpans nor function arguments.
                */
            abstract isEquivalent(stmt: Statement): boolean;
            abstract visitStatement(visitor: StatementVisitor, context: any): any;
            hasModifier(modifier: StmtModifier): boolean;
            addLeadingComment(leadingComment: LeadingComment): void;
    }
    
    export interface StatementVisitor {
            visitDeclareVarStmt(stmt: DeclareVarStmt, context: any): any;
            visitDeclareFunctionStmt(stmt: DeclareFunctionStmt, context: any): any;
            visitExpressionStmt(stmt: ExpressionStatement, context: any): any;
            visitReturnStmt(stmt: ReturnStatement, context: any): any;
            visitIfStmt(stmt: IfStmt, context: any): any;
    }
    
    export enum StmtModifier {
            None = 0,
            Final = 1,
            Private = 2,
            Exported = 4,
            Static = 8
    }
    
    export const STRING_TYPE: BuiltinType;
    
    namespace t {
            export {
                    visitAll_2 as visitAll,
                    transformAll,
                    TmplAstNode as Node,
                    Comment_3 as Comment,
                    TmplAstText as Text,
                    TmplAstBoundText as BoundText,
                    TmplAstTextAttribute as TextAttribute,
                    TmplAstBoundAttribute as BoundAttribute,
                    TmplAstBoundEvent as BoundEvent,
                    TmplAstElement as Element,
                    TmplAstTemplate as Template,
                    TmplAstContent as Content,
                    TmplAstVariable as Variable,
                    TmplAstReference as Reference,
                    TmplAstIcu as Icu,
                    Visitor_3 as Visitor,
                    NullVisitor,
                    TmplAstRecursiveVisitor as RecursiveVisitor,
                    TransformVisitor
            }
    }
    
    
    export enum TagContentType {
            RAW_TEXT = 0,
            ESCAPABLE_RAW_TEXT = 1,
            PARSABLE_DATA = 2
    }
    
    export interface TagDefinition {
            closedByParent: boolean;
            implicitNamespacePrefix: string | null;
            isVoid: boolean;
            ignoreFirstLf: boolean;
            canSelfClose: boolean;
            preventNamespaceInheritance: boolean;
            isClosedByChild(name: string): boolean;
            getContentType(prefix?: string): TagContentType;
    }
    
    function taggedTemplate(tag: Expression, template: TemplateLiteral, type?: Type | null, sourceSpan?: ParseSourceSpan | null): TaggedTemplateExpr;
    
    export class TaggedTemplateExpr extends Expression {
            tag: Expression;
            template: TemplateLiteral;
            constructor(tag: Expression, template: TemplateLiteral, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    class TagPlaceholder implements Node_3 {
            tag: string;
            attrs: {
                    [k: string]: string;
            };
            startName: string;
            closeName: string;
            children: Node_3[];
            isVoid: boolean;
            sourceSpan: ParseSourceSpan;
            startSourceSpan: ParseSourceSpan | null;
            endSourceSpan: ParseSourceSpan | null;
            constructor(tag: string, attrs: {
                    [k: string]: string;
            }, startName: string, closeName: string, children: Node_3[], isVoid: boolean, sourceSpan: ParseSourceSpan, startSourceSpan: ParseSourceSpan | null, endSourceSpan: ParseSourceSpan | null);
            visit(visitor: Visitor_2, context?: any): any;
    }
    
    /**
        * A logical target for analysis, which could contain a template or other types of bindings.
        */
    export interface Target {
            template?: TmplAstNode[];
    }
    
    /**
        * Interface to the binding API, which processes a template and returns an object similar to the
        * `ts.TypeChecker`.
        *
        * The returned `BoundTarget` has an API for extracting information about the processed target.
        */
    export interface TargetBinder<D extends DirectiveMeta> {
            bind(target: Target): BoundTarget<D>;
    }
    
    /**
        * TemplateBinding refers to a particular key-value pair in a microsyntax
        * expression. A few examples are:
        *
        *   |---------------------|--------------|---------|--------------|
        *   |     expression      |     key      |  value  | binding type |
        *   |---------------------|--------------|---------|--------------|
        *   | 1. let item         |    item      |  null   |   variable   |
        *   | 2. of items         |   ngForOf    |  items  |  expression  |
        *   | 3. let x = y        |      x       |    y    |   variable   |
        *   | 4. index as i       |      i       |  index  |   variable   |
        *   | 5. trackBy: func    | ngForTrackBy |   func  |  expression  |
        *   | 6. *ngIf="cond"     |     ngIf     |   cond  |  expression  |
        *   |---------------------|--------------|---------|--------------|
        *
        * (6) is a notable exception because it is a binding from the template key in
        * the LHS of a HTML attribute to the expression in the RHS. All other bindings
        * in the example above are derived solely from the RHS.
        */
    export type TemplateBinding = VariableBinding | ExpressionBinding;
    
    export interface TemplateBindingIdentifier {
            source: string;
            span: AbsoluteSourceSpan;
    }
    
    export class TemplateBindingParseResult {
            templateBindings: TemplateBinding[];
            warnings: string[];
            errors: ParserError[];
            constructor(templateBindings: TemplateBinding[], warnings: string[], errors: ParserError[]);
    }
    
    export class TemplateLiteral {
            elements: TemplateLiteralElement[];
            expressions: Expression[];
            constructor(elements: TemplateLiteralElement[], expressions: Expression[]);
    }
    
    export class TemplateLiteralElement {
            text: string;
            sourceSpan?: ParseSourceSpan | undefined;
            rawText: string;
            constructor(text: string, sourceSpan?: ParseSourceSpan | undefined, rawText?: string);
    }
    
    class Text_2 extends NodeWithI18n {
            value: string;
            tokens: InterpolatedTextToken[];
            constructor(value: string, sourceSpan: ParseSourceSpan, tokens: InterpolatedTextToken[], i18n?: I18nMeta_2);
            visit(visitor: Visitor, context: any): any;
    }
    export { Text_2 as Text }
    
    class Text_3 implements Node_3 {
            value: string;
            sourceSpan: ParseSourceSpan;
            constructor(value: string, sourceSpan: ParseSourceSpan);
            visit(visitor: Visitor_2, context?: any): any;
    }
    
    interface TextToken extends TokenBase {
            type: TokenType_2.TEXT | TokenType_2.ESCAPABLE_RAW_TEXT | TokenType_2.RAW_TEXT;
            parts: [text: string];
    }
    
    /**
        * Receiver when something is accessed through `this` (e.g. `this.foo`). Note that this class
        * inherits from `ImplicitReceiver`, because accessing something through `this` is treated the
        * same as accessing it implicitly inside of an Angular template (e.g. `[attr.title]="this.title"`
        * is the same as `[attr.title]="title"`.). Inheriting allows for the `this` accesses to be treated
        * the same as implicit ones, except for a couple of exceptions like `$event` and `$any`.
        * TODO: we should find a way for this class not to extend from `ImplicitReceiver` in the future.
        */
    export class ThisReceiver extends ImplicitReceiver {
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    export class TmplAstBoundAttribute implements TmplAstNode {
            name: string;
            type: BindingType;
            securityContext: SecurityContext;
            value: AST;
            unit: string | null;
            sourceSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan;
            valueSpan: ParseSourceSpan | undefined;
            i18n: I18nMeta_2 | undefined;
            constructor(name: string, type: BindingType, securityContext: SecurityContext, value: AST, unit: string | null, sourceSpan: ParseSourceSpan, keySpan: ParseSourceSpan, valueSpan: ParseSourceSpan | undefined, i18n: I18nMeta_2 | undefined);
            static fromBoundElementProperty(prop: BoundElementProperty, i18n?: I18nMeta_2): TmplAstBoundAttribute;
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstBoundEvent implements TmplAstNode {
            name: string;
            type: ParsedEventType;
            handler: AST;
            target: string | null;
            phase: string | null;
            sourceSpan: ParseSourceSpan;
            handlerSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan;
            constructor(name: string, type: ParsedEventType, handler: AST, target: string | null, phase: string | null, sourceSpan: ParseSourceSpan, handlerSpan: ParseSourceSpan, keySpan: ParseSourceSpan);
            static fromParsedEvent(event: ParsedEvent): TmplAstBoundEvent;
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstBoundText implements TmplAstNode {
            value: AST;
            sourceSpan: ParseSourceSpan;
            i18n?: I18nMeta_2 | undefined;
            constructor(value: AST, sourceSpan: ParseSourceSpan, i18n?: I18nMeta_2 | undefined);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstContent implements TmplAstNode {
            selector: string;
            attributes: TmplAstTextAttribute[];
            sourceSpan: ParseSourceSpan;
            i18n?: I18nMeta_2 | undefined;
            readonly name = "ng-content";
            constructor(selector: string, attributes: TmplAstTextAttribute[], sourceSpan: ParseSourceSpan, i18n?: I18nMeta_2 | undefined);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstElement implements TmplAstNode {
            name: string;
            attributes: TmplAstTextAttribute[];
            inputs: TmplAstBoundAttribute[];
            outputs: TmplAstBoundEvent[];
            children: TmplAstNode[];
            references: TmplAstReference[];
            sourceSpan: ParseSourceSpan;
            startSourceSpan: ParseSourceSpan;
            endSourceSpan: ParseSourceSpan | null;
            i18n?: I18nMeta_2 | undefined;
            constructor(name: string, attributes: TmplAstTextAttribute[], inputs: TmplAstBoundAttribute[], outputs: TmplAstBoundEvent[], children: TmplAstNode[], references: TmplAstReference[], sourceSpan: ParseSourceSpan, startSourceSpan: ParseSourceSpan, endSourceSpan: ParseSourceSpan | null, i18n?: I18nMeta_2 | undefined);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstIcu implements TmplAstNode {
            vars: {
                    [name: string]: TmplAstBoundText;
            };
            placeholders: {
                    [name: string]: TmplAstText | TmplAstBoundText;
            };
            sourceSpan: ParseSourceSpan;
            i18n?: I18nMeta_2 | undefined;
            constructor(vars: {
                    [name: string]: TmplAstBoundText;
            }, placeholders: {
                    [name: string]: TmplAstText | TmplAstBoundText;
            }, sourceSpan: ParseSourceSpan, i18n?: I18nMeta_2 | undefined);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export interface TmplAstNode {
            sourceSpan: ParseSourceSpan;
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstRecursiveVisitor implements Visitor_3<void> {
            visitElement(element: TmplAstElement): void;
            visitTemplate(template: TmplAstTemplate): void;
            visitContent(content: TmplAstContent): void;
            visitVariable(variable: TmplAstVariable): void;
            visitReference(reference: TmplAstReference): void;
            visitTextAttribute(attribute: TmplAstTextAttribute): void;
            visitBoundAttribute(attribute: TmplAstBoundAttribute): void;
            visitBoundEvent(attribute: TmplAstBoundEvent): void;
            visitText(text: TmplAstText): void;
            visitBoundText(text: TmplAstBoundText): void;
            visitIcu(icu: TmplAstIcu): void;
    }
    
    export class TmplAstReference implements TmplAstNode {
            name: string;
            value: string;
            sourceSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan;
            valueSpan?: ParseSourceSpan | undefined;
            constructor(name: string, value: string, sourceSpan: ParseSourceSpan, keySpan: ParseSourceSpan, valueSpan?: ParseSourceSpan | undefined);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstTemplate implements TmplAstNode {
            tagName: string | null;
            attributes: TmplAstTextAttribute[];
            inputs: TmplAstBoundAttribute[];
            outputs: TmplAstBoundEvent[];
            templateAttrs: (TmplAstBoundAttribute | TmplAstTextAttribute)[];
            children: TmplAstNode[];
            references: TmplAstReference[];
            variables: TmplAstVariable[];
            sourceSpan: ParseSourceSpan;
            startSourceSpan: ParseSourceSpan;
            endSourceSpan: ParseSourceSpan | null;
            i18n?: I18nMeta_2 | undefined;
            constructor(tagName: string | null, attributes: TmplAstTextAttribute[], inputs: TmplAstBoundAttribute[], outputs: TmplAstBoundEvent[], templateAttrs: (TmplAstBoundAttribute | TmplAstTextAttribute)[], children: TmplAstNode[], references: TmplAstReference[], variables: TmplAstVariable[], sourceSpan: ParseSourceSpan, startSourceSpan: ParseSourceSpan, endSourceSpan: ParseSourceSpan | null, i18n?: I18nMeta_2 | undefined);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstText implements TmplAstNode {
            value: string;
            sourceSpan: ParseSourceSpan;
            constructor(value: string, sourceSpan: ParseSourceSpan);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    /**
        * Represents a text attribute in the template.
        *
        * `valueSpan` may not be present in cases where there is no value `<div a></div>`.
        * `keySpan` may also not be present for synthetic attributes from ICU expansions.
        */
    export class TmplAstTextAttribute implements TmplAstNode {
            name: string;
            value: string;
            sourceSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan | undefined;
            valueSpan?: ParseSourceSpan | undefined;
            i18n?: I18nMeta_2 | undefined;
            constructor(name: string, value: string, sourceSpan: ParseSourceSpan, keySpan: ParseSourceSpan | undefined, valueSpan?: ParseSourceSpan | undefined, i18n?: I18nMeta_2 | undefined);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class TmplAstVariable implements TmplAstNode {
            name: string;
            value: string;
            sourceSpan: ParseSourceSpan;
            readonly keySpan: ParseSourceSpan;
            valueSpan?: ParseSourceSpan | undefined;
            constructor(name: string, value: string, sourceSpan: ParseSourceSpan, keySpan: ParseSourceSpan, valueSpan?: ParseSourceSpan | undefined);
            visit<Result>(visitor: Visitor_3<Result>): Result;
    }
    
    export class Token {
            index: number;
            end: number;
            type: TokenType;
            numValue: number;
            strValue: string;
            constructor(index: number, end: number, type: TokenType, numValue: number, strValue: string);
            isCharacter(code: number): boolean;
            isNumber(): boolean;
            isString(): boolean;
            isOperator(operator: string): boolean;
            isIdentifier(): boolean;
            isPrivateIdentifier(): boolean;
            isKeyword(): boolean;
            isKeywordLet(): boolean;
            isKeywordAs(): boolean;
            isKeywordNull(): boolean;
            isKeywordUndefined(): boolean;
            isKeywordTrue(): boolean;
            isKeywordFalse(): boolean;
            isKeywordThis(): boolean;
            isError(): boolean;
            toNumber(): number;
            toString(): string | null;
    }
    
    interface TokenBase {
            type: TokenType_2;
            parts: string[];
            sourceSpan: ParseSourceSpan;
    }
    
    /**
        * Options that modify how the text is tokenized.
        */
    interface TokenizeOptions {
            /** Whether to tokenize ICU messages (considered as text nodes when false). */
            tokenizeExpansionForms?: boolean;
            /** How to tokenize interpolation markers. */
            interpolationConfig?: InterpolationConfig;
            /**
                * The start and end point of the text to parse within the `source` string.
                * The entire `source` string is parsed if this is not provided.
                * */
            range?: LexerRange;
            /**
                * If this text is stored in a JavaScript string, then we have to deal with escape sequences.
                *
                * **Example 1:**
                *
                * ```
                * "abc\"def\nghi"
                * ```
                *
                * - The `\"` must be converted to `"`.
                * - The `\n` must be converted to a new line character in a token,
                *   but it should not increment the current line for source mapping.
                *
                * **Example 2:**
                *
                * ```
                * "abc\
                *  def"
                * ```
                *
                * The line continuation (`\` followed by a newline) should be removed from a token
                * but the new line should increment the current line for source mapping.
                */
            escapedString?: boolean;
            /**
                * If this text is stored in an external template (e.g. via `templateUrl`) then we need to decide
                * whether or not to normalize the line-endings (from `\r\n` to `\n`) when processing ICU
                * expressions.
                *
                * If `true` then we will normalize ICU expression line endings.
                * The default is `false`, but this will be switched in a future major release.
                */
            i18nNormalizeLineEndingsInICUs?: boolean;
            /**
                * An array of characters that should be considered as leading trivia.
                * Leading trivia are characters that are not important to the developer, and so should not be
                * included in source-map segments.  A common example is whitespace.
                */
            leadingTriviaChars?: string[];
            /**
                * If true, do not convert CRLF to LF.
                */
            preserveLineEndings?: boolean;
    }
    
    
    export enum TokenType {
            Character = 0,
            Identifier = 1,
            PrivateIdentifier = 2,
            Keyword = 3,
            String = 4,
            Operator = 5,
            Number = 6,
            Error = 7
    }
    
    const enum TokenType_2 {
            TAG_OPEN_START = 0,
            TAG_OPEN_END = 1,
            TAG_OPEN_END_VOID = 2,
            TAG_CLOSE = 3,
            INCOMPLETE_TAG_OPEN = 4,
            TEXT = 5,
            ESCAPABLE_RAW_TEXT = 6,
            RAW_TEXT = 7,
            INTERPOLATION = 8,
            ENCODED_ENTITY = 9,
            COMMENT_START = 10,
            COMMENT_END = 11,
            CDATA_START = 12,
            CDATA_END = 13,
            ATTR_NAME = 14,
            ATTR_QUOTE = 15,
            ATTR_VALUE_TEXT = 16,
            ATTR_VALUE_INTERPOLATION = 17,
            DOC_TYPE = 18,
            EXPANSION_FORM_START = 19,
            EXPANSION_CASE_VALUE = 20,
            EXPANSION_CASE_EXP_START = 21,
            EXPANSION_CASE_EXP_END = 22,
            EXPANSION_FORM_END = 23,
            EOF = 24
    }
    
    function transformAll<Result extends TmplAstNode>(visitor: Visitor_3<TmplAstNode>, nodes: Result[]): Result[];
    
    class TransformVisitor implements Visitor_3<TmplAstNode> {
            visitElement(element: TmplAstElement): TmplAstNode;
            visitTemplate(template: TmplAstTemplate): TmplAstNode;
            visitContent(content: TmplAstContent): TmplAstNode;
            visitVariable(variable: TmplAstVariable): TmplAstNode;
            visitReference(reference: TmplAstReference): TmplAstNode;
            visitTextAttribute(attribute: TmplAstTextAttribute): TmplAstNode;
            visitBoundAttribute(attribute: TmplAstBoundAttribute): TmplAstNode;
            visitBoundEvent(attribute: TmplAstBoundEvent): TmplAstNode;
            visitText(text: TmplAstText): TmplAstNode;
            visitBoundText(text: TmplAstBoundText): TmplAstNode;
            visitIcu(icu: TmplAstIcu): TmplAstNode;
    }
    
    export class TreeError extends ParseError {
            elementName: string | null;
            static create(elementName: string | null, span: ParseSourceSpan, msg: string): TreeError;
            constructor(elementName: string | null, span: ParseSourceSpan, msg: string);
    }
    
    export abstract class Type {
            modifiers: TypeModifier;
            constructor(modifiers?: TypeModifier);
            abstract visitType(visitor: TypeVisitor, context: any): any;
            hasModifier(modifier: TypeModifier): boolean;
    }
    
    interface Type_2 extends Function {
            new (...args: any[]): any;
    }
    
    const Type_2: FunctionConstructor;
    
    const TYPED_NULL_EXPR: LiteralExpr;
    
    export enum TypeModifier {
            None = 0,
            Const = 1
    }
    
    export class TypeofExpr extends Expression {
            expr: Expression;
            constructor(expr: Expression, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            visitExpression(visitor: ExpressionVisitor, context: any): any;
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
    }
    
    function typeofExpr(expr: Expression): TypeofExpr;
    
    export interface TypeVisitor {
            visitBuiltinType(type: BuiltinType, context: any): any;
            visitExpressionType(type: ExpressionType, context: any): any;
            visitArrayType(type: ArrayType, context: any): any;
            visitMapType(type: MapType, context: any): any;
    }
    
    /**
        * For backwards compatibility reasons, `Unary` inherits from `Binary` and mimics the binary AST
        * node that was originally used. This inheritance relation can be deleted in some future major,
        * after consumers have been given a chance to fully support Unary.
        */
    export class Unary extends Binary {
            operator: string;
            expr: AST;
            left: never;
            right: never;
            operation: never;
            /**
                * Creates a unary minus expression "-x", represented as `Binary` using "0 - x".
                */
            static createMinus(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, expr: AST): Unary;
            /**
                * Creates a unary plus expression "+x", represented as `Binary` using "x - 0".
                */
            static createPlus(span: ParseSpan, sourceSpan: AbsoluteSourceSpan, expr: AST): Unary;
            visit(visitor: AstVisitor, context?: any): any;
    }
    
    function unary(operator: UnaryOperator, expr: Expression, type?: Type, sourceSpan?: ParseSourceSpan | null): UnaryOperatorExpr;
    
    export enum UnaryOperator {
            Minus = 0,
            Plus = 1
    }
    
    export class UnaryOperatorExpr extends Expression {
            operator: UnaryOperator;
            expr: Expression;
            parens: boolean;
            constructor(operator: UnaryOperator, expr: Expression, type?: Type | null, sourceSpan?: ParseSourceSpan | null, parens?: boolean);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    function variable(name: string, type?: Type | null, sourceSpan?: ParseSourceSpan | null): ReadVarExpr;
    
    export class VariableBinding {
            readonly sourceSpan: AbsoluteSourceSpan;
            readonly key: TemplateBindingIdentifier;
            readonly value: TemplateBindingIdentifier | null;
            /**
                * @param sourceSpan entire span of the binding.
                * @param key name of the LHS along with its span.
                * @param value optional value for the RHS along with its span.
                */
            constructor(sourceSpan: AbsoluteSourceSpan, key: TemplateBindingIdentifier, value: TemplateBindingIdentifier | null);
    }
    
    /**
        * Verifies host bindings and returns the list of errors (if any). Empty array indicates that a
        * given set of host bindings has no errors.
        *
        * @param bindings set of host bindings to verify.
        * @param sourceSpan source span where host bindings were defined.
        * @returns array of errors associated with a given set of host bindings.
        */
    export function verifyHostBindings(bindings: ParsedHostBindings, sourceSpan: ParseSourceSpan): ParseError[];
    
    export const VERSION: Version;
    
    export class Version {
            full: string;
            readonly major: string;
            readonly minor: string;
            readonly patch: string;
            constructor(full: string);
    }
    
    export enum ViewEncapsulation {
            Emulated = 0,
            None = 2,
            ShadowDom = 3
    }
    
    export function visitAll(visitor: Visitor, nodes: Node_2[], context?: any): any[];
    
    function visitAll_2<Result>(visitor: Visitor_3<Result>, nodes: TmplAstNode[]): Result[];
    
    export interface Visitor {
            visit?(node: Node_2, context: any): any;
            visitElement(element: Element_2, context: any): any;
            visitAttribute(attribute: Attribute, context: any): any;
            visitText(text: Text_2, context: any): any;
            visitComment(comment: Comment_2, context: any): any;
            visitExpansion(expansion: Expansion, context: any): any;
            visitExpansionCase(expansionCase: ExpansionCase, context: any): any;
    }
    
    interface Visitor_2 {
            visitText(text: Text_3, context?: any): any;
            visitContainer(container: Container, context?: any): any;
            visitIcu(icu: Icu, context?: any): any;
            visitTagPlaceholder(ph: TagPlaceholder, context?: any): any;
            visitPlaceholder(ph: Placeholder, context?: any): any;
            visitIcuPlaceholder(ph: IcuPlaceholder, context?: any): any;
    }
    
    interface Visitor_3<Result = any> {
            visit?(node: TmplAstNode): Result;
            visitElement(element: TmplAstElement): Result;
            visitTemplate(template: TmplAstTemplate): Result;
            visitContent(content: TmplAstContent): Result;
            visitVariable(variable: TmplAstVariable): Result;
            visitReference(reference: TmplAstReference): Result;
            visitTextAttribute(attribute: TmplAstTextAttribute): Result;
            visitBoundAttribute(attribute: TmplAstBoundAttribute): Result;
            visitBoundEvent(attribute: TmplAstBoundEvent): Result;
            visitText(text: TmplAstText): Result;
            visitBoundText(text: TmplAstBoundText): Result;
            visitIcu(icu: TmplAstIcu): Result;
    }
    
    export class WrappedNodeExpr<T> extends Expression {
            node: T;
            constructor(node: T, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    export class WriteKeyExpr extends Expression {
            receiver: Expression;
            index: Expression;
            value: Expression;
            constructor(receiver: Expression, index: Expression, value: Expression, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    export class WritePropExpr extends Expression {
            receiver: Expression;
            name: string;
            value: Expression;
            constructor(receiver: Expression, name: string, value: Expression, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
    }
    
    export class WriteVarExpr extends Expression {
            name: string;
            value: Expression;
            constructor(name: string, value: Expression, type?: Type | null, sourceSpan?: ParseSourceSpan | null);
            isEquivalent(e: Expression): boolean;
            isConstant(): boolean;
            visitExpression(visitor: ExpressionVisitor, context: any): any;
            toDeclStmt(type?: Type | null, modifiers?: StmtModifier): DeclareVarStmt;
            toConstDecl(): DeclareVarStmt;
    }
    
    export class Xliff extends Serializer {
            write(messages: i18n.Message[], locale: string | null): string;
            load(content: string, url: string): {
                    locale: string;
                    i18nNodesByMsgId: {
                            [msgId: string]: i18n.Node[];
                    };
            };
            digest(message: i18n.Message): string;
    }
    
    export class Xliff2 extends Serializer {
            write(messages: i18n.Message[], locale: string | null): string;
            load(content: string, url: string): {
                    locale: string;
                    i18nNodesByMsgId: {
                            [msgId: string]: i18n.Node[];
                    };
            };
            digest(message: i18n.Message): string;
    }
    
    export class Xmb extends Serializer {
            write(messages: i18n.Message[], locale: string | null): string;
            load(content: string, url: string): {
                    locale: string;
                    i18nNodesByMsgId: {
                            [msgId: string]: i18n.Node[];
                    };
            };
            digest(message: i18n.Message): string;
            createNameMapper(message: i18n.Message): PlaceholderMapper;
    }
    
    export class XmlParser extends Parser_2 {
            constructor();
            parse(source: string, url: string, options?: TokenizeOptions): ParseTreeResult;
    }
    
    export class Xtb extends Serializer {
            write(messages: i18n.Message[], locale: string | null): string;
            load(content: string, url: string): {
                    locale: string;
                    i18nNodesByMsgId: {
                            [msgId: string]: i18n.Node[];
                    };
            };
            digest(message: i18n.Message): string;
            createNameMapper(message: i18n.Message): PlaceholderMapper;
    }
    
    export { }
}

// Generated by dts-bundle v0.7.3
// Dependencies for this module:
//   ../../../../../rxjs

declare module '@angular/core' {
    
    
    /**
        * @license Angular v15.2.10
        * (c) 2010-2022 Google LLC. https://angular.io/
        * License: MIT
        */
    import { Observable } from 'rxjs';
    import { Subject } from 'rxjs';
    import { Subscribable } from 'rxjs';
    import { Subscription } from 'rxjs';
    
    /**
        * @description
        *
        * Represents an abstract class `T`, if applied to a concrete class it would stop being
        * instantiable.
        *
        * @publicApi
        */
    export interface AbstractType<T> extends Function {
            prototype: T;
    }
    
    /**
        * @description
        * A lifecycle hook that is called after the default change detector has
        * completed checking all content of a directive.
        *
        * @see `AfterViewChecked`
        * @see [Lifecycle hooks guide](guide/lifecycle-hooks)
        *
        * @usageNotes
        * The following snippet shows how a component can implement this interface to
        * define its own after-check functionality.
        *
        * {@example core/ts/metadata/lifecycle_hooks_spec.ts region='AfterContentChecked'}
        *
        * @publicApi
        */
    export interface AfterContentChecked {
            /**
                * A callback method that is invoked immediately after the
                * default change detector has completed checking all of the directive's
                * content.
                */
            ngAfterContentChecked(): void;
    }
    
    /**
        * @description
        * A lifecycle hook that is called after Angular has fully initialized
        * all content of a directive.
        * Define an `ngAfterContentInit()` method to handle any additional initialization tasks.
        *
        * @see `OnInit`
        * @see `AfterViewInit`
        * @see [Lifecycle hooks guide](guide/lifecycle-hooks)
        *
        * @usageNotes
        * The following snippet shows how a component can implement this interface to
        * define its own content initialization method.
        *
        * {@example core/ts/metadata/lifecycle_hooks_spec.ts region='AfterContentInit'}
        *
        * @publicApi
        */
    export interface AfterContentInit {
            /**
                * A callback method that is invoked immediately after
                * Angular has completed initialization of all of the directive's
                * content.
                * It is invoked only once when the directive is instantiated.
                */
            ngAfterContentInit(): void;
    }
    
    /**
        * @description
        * A lifecycle hook that is called after the default change detector has
        * completed checking a component's view for changes.
        *
        * @see `AfterContentChecked`
        * @see [Lifecycle hooks guide](guide/lifecycle-hooks)
        *
        * @usageNotes
        * The following snippet shows how a component can implement this interface to
        * define its own after-check functionality.
        *
        * {@example core/ts/metadata/lifecycle_hooks_spec.ts region='AfterViewChecked'}
        *
        * @publicApi
        */
    export interface AfterViewChecked {
            /**
                * A callback method that is invoked immediately after the
                * default change detector has completed one change-check cycle
                * for a component's view.
                */
            ngAfterViewChecked(): void;
    }
    
    /**
        * @description
        * A lifecycle hook that is called after Angular has fully initialized
        * a component's view.
        * Define an `ngAfterViewInit()` method to handle any additional initialization tasks.
        *
        * @see `OnInit`
        * @see `AfterContentInit`
        * @see [Lifecycle hooks guide](guide/lifecycle-hooks)
        *
        * @usageNotes
        * The following snippet shows how a component can implement this interface to
        * define its own view initialization method.
        *
        * {@example core/ts/metadata/lifecycle_hooks_spec.ts region='AfterViewInit'}
        *
        * @publicApi
        */
    export interface AfterViewInit {
            /**
                * A callback method that is invoked immediately after
                * Angular has completed initialization of a component's view.
                * It is invoked only once when the view is instantiated.
                *
                */
            ngAfterViewInit(): void;
    }
    
    /**
        * A DI token that you can use to create a virtual [provider](guide/glossary#provider)
        * that will populate the `entryComponents` field of components and NgModules
        * based on its `useValue` property value.
        * All components that are referenced in the `useValue` value (either directly
        * or in a nested array or map) are added to the `entryComponents` property.
        *
        * @usageNotes
        *
        * The following example shows how the router can populate the `entryComponents`
        * field of an NgModule based on a router configuration that refers
        * to components.
        *
        * ```typescript
        * // helper function inside the router
        * function provideRoutes(routes) {
        *   return [
        *     {provide: ROUTES, useValue: routes},
        *     {provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: routes, multi: true}
        *   ];
        * }
        *
        * // user code
        * let routes = [
        *   {path: '/root', component: RootComp},
        *   {path: '/teams', component: TeamsComp}
        * ];
        *
        * @NgModule({
        *   providers: [provideRoutes(routes)]
        * })
        * class ModuleWithRoutes {}
        * ```
        *
        * @publicApi
        * @deprecated Since 9.0.0. With Ivy, this property is no longer necessary.
        */
    export const ANALYZE_FOR_ENTRY_COMPONENTS: InjectionToken<any>;
    
    /**
        * A [DI token](guide/glossary#di-token "DI token definition") that indicates which animations
        * module has been loaded.
        * @publicApi
        */
    export const ANIMATION_MODULE_TYPE: InjectionToken<"NoopAnimations" | "BrowserAnimations">;
    
    /**
        * A [DI token](guide/glossary#di-token "DI token definition") that provides a set of callbacks to
        * be called for every component that is bootstrapped.
        *
        * Each callback must take a `ComponentRef` instance and return nothing.
        *
        * `(componentRef: ComponentRef) => void`
        *
        * @publicApi
        */
    export const APP_BOOTSTRAP_LISTENER: InjectionToken<((compRef: ComponentRef<any>) => void)[]>;
    
    /**
        * A [DI token](guide/glossary#di-token "DI token definition") representing a unique string ID, used
        * primarily for prefixing application attributes and CSS styles when
        * {@link ViewEncapsulation#Emulated ViewEncapsulation.Emulated} is being used.
        *
        * BY default, the value is randomly generated and assigned to the application by Angular.
        * To provide a custom ID value, use a DI provider <!-- TODO: provider --> to configure
        * the root {@link Injector} that uses this token.
        *
        * @publicApi
        */
    export const APP_ID: InjectionToken<string>;
    
    /**
        * A [DI token](guide/glossary#di-token "DI token definition") that you can use to provide
        * one or more initialization functions.
        *
        * The provided functions are injected at application startup and executed during
        * app initialization. If any of these functions returns a Promise or an Observable, initialization
        * does not complete until the Promise is resolved or the Observable is completed.
        *
        * You can, for example, create a factory function that loads language data
        * or an external configuration, and provide that function to the `APP_INITIALIZER` token.
        * The function is executed during the application bootstrap process,
        * and the needed data is available on startup.
        *
        * @see `ApplicationInitStatus`
        *
        * @usageNotes
        *
        * The following example illustrates how to configure a multi-provider using `APP_INITIALIZER` token
        * and a function returning a promise.
        *
        * ```
        *  function initializeApp(): Promise<any> {
        *    return new Promise((resolve, reject) => {
        *      // Do some asynchronous stuff
        *      resolve();
        *    });
        *  }
        *
        *  @NgModule({
        *   imports: [BrowserModule],
        *   declarations: [AppComponent],
        *   bootstrap: [AppComponent],
        *   providers: [{
        *     provide: APP_INITIALIZER,
        *     useFactory: () => initializeApp,
        *     multi: true
        *    }]
        *   })
        *  export class AppModule {}
        * ```
        *
        * It's also possible to configure a multi-provider using `APP_INITIALIZER` token and a function
        * returning an observable, see an example below. Note: the `HttpClient` in this example is used for
        * demo purposes to illustrate how the factory function can work with other providers available
        * through DI.
        *
        * ```
        *  function initializeAppFactory(httpClient: HttpClient): () => Observable<any> {
        *   return () => httpClient.get("https://someUrl.com/api/user")
        *     .pipe(
        *        tap(user => { ... })
        *     );
        *  }
        *
        *  @NgModule({
        *    imports: [BrowserModule, HttpClientModule],
        *    declarations: [AppComponent],
        *    bootstrap: [AppComponent],
        *    providers: [{
        *      provide: APP_INITIALIZER,
        *      useFactory: initializeAppFactory,
        *      deps: [HttpClient],
        *      multi: true
        *    }]
        *  })
        *  export class AppModule {}
        * ```
        *
        * @publicApi
        */
    export const APP_INITIALIZER: InjectionToken<readonly (() => Observable<unknown> | Promise<unknown> | void)[]>;
    
    function _appIdRandomProviderFactory(): string;
    
    /**
        * A class that reflects the state of running {@link APP_INITIALIZER} functions.
        *
        * @publicApi
        */
    export class ApplicationInitStatus {
            readonly donePromise: Promise<any>;
            readonly done = false;
            constructor(appInits: ReadonlyArray<() => Observable<unknown> | Promise<unknown> | void>);
            static ɵfac: i0.ɵɵFactoryDeclaration<ApplicationInitStatus, [{ optional: true; }]>;
            static ɵprov: i0.ɵɵInjectableDeclaration<ApplicationInitStatus>;
    }
    
    /**
        * Re-exported by `BrowserModule`, which is included automatically in the root
        * `AppModule` when you create a new app with the CLI `new` command. Eagerly injects
        * `ApplicationRef` to instantiate it.
        *
        * @publicApi
        */
    export class ApplicationModule {
            constructor(appRef: ApplicationRef);
            static ɵfac: i0.ɵɵFactoryDeclaration<ApplicationModule, never>;
            static ɵmod: i0.ɵɵNgModuleDeclaration<ApplicationModule, never, never, never>;
            static ɵinj: i0.ɵɵInjectorDeclaration<ApplicationModule>;
    }
    
    /**
        * A reference to an Angular application running on a page.
        *
        * @usageNotes
        *
        * {@a is-stable-examples}
        * ### isStable examples and caveats
        *
        * Note two important points about `isStable`, demonstrated in the examples below:
        * - the application will never be stable if you start any kind
        * of recurrent asynchronous task when the application starts
        * (for example for a polling process, started with a `setInterval`, a `setTimeout`
        * or using RxJS operators like `interval`);
        * - the `isStable` Observable runs outside of the Angular zone.
        *
        * Let's imagine that you start a recurrent task
        * (here incrementing a counter, using RxJS `interval`),
        * and at the same time subscribe to `isStable`.
        *
        * ```
        * constructor(appRef: ApplicationRef) {
        *   appRef.isStable.pipe(
        *      filter(stable => stable)
        *   ).subscribe(() => console.log('App is stable now');
        *   interval(1000).subscribe(counter => console.log(counter));
        * }
        * ```
        * In this example, `isStable` will never emit `true`,
        * and the trace "App is stable now" will never get logged.
        *
        * If you want to execute something when the app is stable,
        * you have to wait for the application to be stable
        * before starting your polling process.
        *
        * ```
        * constructor(appRef: ApplicationRef) {
        *   appRef.isStable.pipe(
        *     first(stable => stable),
        *     tap(stable => console.log('App is stable now')),
        *     switchMap(() => interval(1000))
        *   ).subscribe(counter => console.log(counter));
        * }
        * ```
        * In this example, the trace "App is stable now" will be logged
        * and then the counter starts incrementing every second.
        *
        * Note also that this Observable runs outside of the Angular zone,
        * which means that the code in the subscription
        * to this Observable will not trigger the change detection.
        *
        * Let's imagine that instead of logging the counter value,
        * you update a field of your component
        * and display it in its template.
        *
        * ```
        * constructor(appRef: ApplicationRef) {
        *   appRef.isStable.pipe(
        *     first(stable => stable),
        *     switchMap(() => interval(1000))
        *   ).subscribe(counter => this.value = counter);
        * }
        * ```
        * As the `isStable` Observable runs outside the zone,
        * the `value` field will be updated properly,
        * but the template will not be refreshed!
        *
        * You'll have to manually trigger the change detection to update the template.
        *
        * ```
        * constructor(appRef: ApplicationRef, cd: ChangeDetectorRef) {
        *   appRef.isStable.pipe(
        *     first(stable => stable),
        *     switchMap(() => interval(1000))
        *   ).subscribe(counter => {
        *     this.value = counter;
        *     cd.detectChanges();
        *   });
        * }
        * ```
        *
        * Or make the subscription callback run inside the zone.
        *
        * ```
        * constructor(appRef: ApplicationRef, zone: NgZone) {
        *   appRef.isStable.pipe(
        *     first(stable => stable),
        *     switchMap(() => interval(1000))
        *   ).subscribe(counter => zone.run(() => this.value = counter));
        * }
        * ```
        *
        * @publicApi
        */
    export class ApplicationRef {
            /**
                * Indicates whether this instance was destroyed.
                */
            get destroyed(): boolean;
            /**
                * Get a list of component types registered to this application.
                * This list is populated even before the component is created.
                */
            readonly componentTypes: Type<any>[];
            /**
                * Get a list of components registered to this application.
                */
            readonly components: ComponentRef<any>[];
            /**
                * Returns an Observable that indicates when the application is stable or unstable.
                *
                * @see  [Usage notes](#is-stable-examples) for examples and caveats when using this API.
                */
            readonly isStable: Observable<boolean>;
            /**
                * The `EnvironmentInjector` used to create this application.
                */
            get injector(): EnvironmentInjector;
            /**
                * Bootstrap a component onto the element identified by its selector or, optionally, to a
                * specified element.
                *
                * @usageNotes
                * ### Bootstrap process
                *
                * When bootstrapping a component, Angular mounts it onto a target DOM element
                * and kicks off automatic change detection. The target DOM element can be
                * provided using the `rootSelectorOrNode` argument.
                *
                * If the target DOM element is not provided, Angular tries to find one on a page
                * using the `selector` of the component that is being bootstrapped
                * (first matched element is used).
                *
                * ### Example
                *
                * Generally, we define the component to bootstrap in the `bootstrap` array of `NgModule`,
                * but it requires us to know the component while writing the application code.
                *
                * Imagine a situation where we have to wait for an API call to decide about the component to
                * bootstrap. We can use the `ngDoBootstrap` hook of the `NgModule` and call this method to
                * dynamically bootstrap a component.
                *
                * {@example core/ts/platform/platform.ts region='componentSelector'}
                *
                * Optionally, a component can be mounted onto a DOM element that does not match the
                * selector of the bootstrapped component.
                *
                * In the following example, we are providing a CSS selector to match the target element.
                *
                * {@example core/ts/platform/platform.ts region='cssSelector'}
                *
                * While in this example, we are providing reference to a DOM node.
                *
                * {@example core/ts/platform/platform.ts region='domNode'}
                */
            bootstrap<C>(component: Type<C>, rootSelectorOrNode?: string | any): ComponentRef<C>;
            /**
                * Bootstrap a component onto the element identified by its selector or, optionally, to a
                * specified element.
                *
                * @usageNotes
                * ### Bootstrap process
                *
                * When bootstrapping a component, Angular mounts it onto a target DOM element
                * and kicks off automatic change detection. The target DOM element can be
                * provided using the `rootSelectorOrNode` argument.
                *
                * If the target DOM element is not provided, Angular tries to find one on a page
                * using the `selector` of the component that is being bootstrapped
                * (first matched element is used).
                *
                * ### Example
                *
                * Generally, we define the component to bootstrap in the `bootstrap` array of `NgModule`,
                * but it requires us to know the component while writing the application code.
                *
                * Imagine a situation where we have to wait for an API call to decide about the component to
                * bootstrap. We can use the `ngDoBootstrap` hook of the `NgModule` and call this method to
                * dynamically bootstrap a component.
                *
                * {@example core/ts/platform/platform.ts region='componentSelector'}
                *
                * Optionally, a component can be mounted onto a DOM element that does not match the
                * selector of the bootstrapped component.
                *
                * In the following example, we are providing a CSS selector to match the target element.
                *
                * {@example core/ts/platform/platform.ts region='cssSelector'}
                *
                * While in this example, we are providing reference to a DOM node.
                *
                * {@example core/ts/platform/platform.ts region='domNode'}
                *
                * @deprecated Passing Component factories as the `Application.bootstrap` function argument is
                *     deprecated. Pass Component Types instead.
                */
            bootstrap<C>(componentFactory: ComponentFactory<C>, rootSelectorOrNode?: string | any): ComponentRef<C>;
            /**
                * Invoke this method to explicitly process change detection and its side-effects.
                *
                * In development mode, `tick()` also performs a second change detection cycle to ensure that no
                * further changes are detected. If additional changes are picked up during this second cycle,
                * bindings in the app have side-effects that cannot be resolved in a single change detection
                * pass.
                * In this case, Angular throws an error, since an Angular application can only have one change
                * detection pass during which all change detection must complete.
                */
            tick(): void;
            /**
                * Attaches a view so that it will be dirty checked.
                * The view will be automatically detached when it is destroyed.
                * This will throw if the view is already attached to a ViewContainer.
                */
            attachView(viewRef: ViewRef): void;
            /**
                * Detaches a view from dirty checking again.
                */
            detachView(viewRef: ViewRef): void;
            /**
                * Destroys an Angular application represented by this `ApplicationRef`. Calling this function
                * will destroy the associated environment injectors as well as all the bootstrapped components
                * with their views.
                */
            destroy(): void;
            /**
                * Returns the number of attached views.
                */
            get viewCount(): number;
            static ɵfac: i0.ɵɵFactoryDeclaration<ApplicationRef, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<ApplicationRef>;
    }
    
    /**
        * @publicApi
        */
    export function asNativeElements(debugEls: DebugElement[]): any;
    
    /**
        * Checks that there is currently a platform that contains the given token as a provider.
        *
        * @publicApi
        */
    export function assertPlatform(requiredToken: any): PlatformRef;
    
    /**
        * Type of the Attribute metadata.
        *
        * @publicApi
        */
    export interface Attribute {
            /**
                * The name of the attribute whose value can be injected.
                */
            attributeName: string;
    }
    
    /**
        * Attribute decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const Attribute: AttributeDecorator;
    
    
    /**
        * Type of the Attribute decorator / constructor function.
        *
        * @publicApi
        */
    export interface AttributeDecorator {
            /**
                * Parameter decorator for a directive constructor that designates
                * a host-element attribute whose value is injected as a constant string literal.
                *
                * @usageNotes
                *
                * Suppose we have an `<input>` element and want to know its `type`.
                *
                * ```html
                * <input type="text">
                * ```
                *
                * The following example uses the decorator to inject the string literal `text` in a directive.
                *
                * {@example core/ts/metadata/metadata.ts region='attributeMetadata'}
                *
                * The following example uses the decorator in a component constructor.
                *
                * {@example core/ts/metadata/metadata.ts region='attributeFactory'}
                *
                */
            (name: string): any;
            new (name: string): Attribute;
    }
    
    /**
        * Provides additional options to the bootstrapping process.
        *
        * @publicApi
        */
    export interface BootstrapOptions {
            /**
                * Optionally specify which `NgZone` should be used.
                *
                * - Provide your own `NgZone` instance.
                * - `zone.js` - Use default `NgZone` which requires `Zone.js`.
                * - `noop` - Use `NoopNgZone` which does nothing.
                */
            ngZone?: NgZone | 'zone.js' | 'noop';
            /**
                * Optionally specify coalescing event change detections or not.
                * Consider the following case.
                *
                * ```
                * <div (click)="doSomething()">
                *   <button (click)="doSomethingElse()"></button>
                * </div>
                * ```
                *
                * When button is clicked, because of the event bubbling, both
                * event handlers will be called and 2 change detections will be
                * triggered. We can coalesce such kind of events to only trigger
                * change detection only once.
                *
                * By default, this option will be false. So the events will not be
                * coalesced and the change detection will be triggered multiple times.
                * And if this option be set to true, the change detection will be
                * triggered async by scheduling a animation frame. So in the case above,
                * the change detection will only be triggered once.
                */
            ngZoneEventCoalescing?: boolean;
            /**
                * Optionally specify if `NgZone#run()` method invocations should be coalesced
                * into a single change detection.
                *
                * Consider the following case.
                * ```
                * for (let i = 0; i < 10; i ++) {
                *   ngZone.run(() => {
                *     // do something
                *   });
                * }
                * ```
                *
                * This case triggers the change detection multiple times.
                * With ngZoneRunCoalescing options, all change detections in an event loop trigger only once.
                * In addition, the change detection executes in requestAnimation.
                *
                */
            ngZoneRunCoalescing?: boolean;
    }
    
    
    /**
        * The strategy that the default change detector uses to detect changes.
        * When set, takes effect the next time change detection is triggered.
        *
        * @see {@link ChangeDetectorRef#usage-notes Change detection usage}
        *
        * @publicApi
        */
    export enum ChangeDetectionStrategy {
            /**
                * Use the `CheckOnce` strategy, meaning that automatic change detection is deactivated
                * until reactivated by setting the strategy to `Default` (`CheckAlways`).
                * Change detection can still be explicitly invoked.
                * This strategy applies to all child directives and cannot be overridden.
                */
            OnPush = 0,
            /**
                * Use the default `CheckAlways` strategy, in which change detection is automatic until
                * explicitly deactivated.
                */
            Default = 1
    }
    
    type ChangeDetectionStrategy_2 = number;
    
    /**
        * Base class that provides change detection functionality.
        * A change-detection tree collects all views that are to be checked for changes.
        * Use the methods to add and remove views from the tree, initiate change-detection,
        * and explicitly mark views as _dirty_, meaning that they have changed and need to be re-rendered.
        *
        * @see [Using change detection hooks](guide/lifecycle-hooks#using-change-detection-hooks)
        * @see [Defining custom change detection](guide/lifecycle-hooks#defining-custom-change-detection)
        *
        * @usageNotes
        *
        * The following examples demonstrate how to modify default change-detection behavior
        * to perform explicit detection when needed.
        *
        * ### Use `markForCheck()` with `CheckOnce` strategy
        *
        * The following example sets the `OnPush` change-detection strategy for a component
        * (`CheckOnce`, rather than the default `CheckAlways`), then forces a second check
        * after an interval. See [live demo](https://plnkr.co/edit/GC512b?p=preview).
        *
        * <code-example path="core/ts/change_detect/change-detection.ts"
        * region="mark-for-check"></code-example>
        *
        * ### Detach change detector to limit how often check occurs
        *
        * The following example defines a component with a large list of read-only data
        * that is expected to change constantly, many times per second.
        * To improve performance, we want to check and update the list
        * less often than the changes actually occur. To do that, we detach
        * the component's change detector and perform an explicit local check every five seconds.
        *
        * <code-example path="core/ts/change_detect/change-detection.ts" region="detach"></code-example>
        *
        *
        * ### Reattaching a detached component
        *
        * The following example creates a component displaying live data.
        * The component detaches its change detector from the main change detector tree
        * when the `live` property is set to false, and reattaches it when the property
        * becomes true.
        *
        * <code-example path="core/ts/change_detect/change-detection.ts" region="reattach"></code-example>
        *
        * @publicApi
        */
    export abstract class ChangeDetectorRef {
            /**
                * When a view uses the {@link ChangeDetectionStrategy#OnPush OnPush} (checkOnce)
                * change detection strategy, explicitly marks the view as changed so that
                * it can be checked again.
                *
                * Components are normally marked as dirty (in need of rerendering) when inputs
                * have changed or events have fired in the view. Call this method to ensure that
                * a component is checked even if these triggers have not occurred.
                *
                * <!-- TODO: Add a link to a chapter on OnPush components -->
                *
                */
            abstract markForCheck(): void;
            /**
                * Detaches this view from the change-detection tree.
                * A detached view is  not checked until it is reattached.
                * Use in combination with `detectChanges()` to implement local change detection checks.
                *
                * Detached views are not checked during change detection runs until they are
                * re-attached, even if they are marked as dirty.
                *
                * <!-- TODO: Add a link to a chapter on detach/reattach/local digest -->
                * <!-- TODO: Add a live demo once ref.detectChanges is merged into master -->
                *
                */
            abstract detach(): void;
            /**
                * Checks this view and its children. Use in combination with {@link ChangeDetectorRef#detach
                * detach}
                * to implement local change detection checks.
                *
                * <!-- TODO: Add a link to a chapter on detach/reattach/local digest -->
                * <!-- TODO: Add a live demo once ref.detectChanges is merged into master -->
                *
                */
            abstract detectChanges(): void;
            /**
                * Checks the change detector and its children, and throws if any changes are detected.
                *
                * Use in development mode to verify that running change detection doesn't introduce
                * other changes. Calling it in production mode is a noop.
                */
            abstract checkNoChanges(): void;
            /**
                * Re-attaches the previously detached view to the change detection tree.
                * Views are attached to the tree by default.
                *
                * <!-- TODO: Add a link to a chapter on detach/reattach/local digest -->
                *
                */
            abstract reattach(): void;
    }
    
    interface ChangeDetectorRefInterface extends ChangeDetectorRef {
    }
    
    const CHILD_HEAD = 13;
    
    const CHILD_TAIL = 14;
    
    /**
        * Configures the `Injector` to return an instance of `useClass` for a token.
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @usageNotes
        *
        * {@example core/di/ts/provider_spec.ts region='ClassProvider'}
        *
        * Note that following two providers are not equal:
        *
        * {@example core/di/ts/provider_spec.ts region='ClassProviderDifference'}
        *
        * ### Multi-value example
        *
        * {@example core/di/ts/provider_spec.ts region='MultiProviderAspect'}
        *
        * @publicApi
        */
    export interface ClassProvider extends ClassSansProvider {
            /**
                * An injection token. (Typically an instance of `Type` or `InjectionToken`, but can be `any`).
                */
            provide: any;
            /**
                * When true, injector returns an array of instances. This is useful to allow multiple
                * providers spread across many files to provide configuration information to a common token.
                */
            multi?: boolean;
    }
    
    /**
        * Configures the `Injector` to return a value by invoking a `useClass` function.
        * Base for `ClassProvider` decorator.
        *
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @publicApi
        */
    export interface ClassSansProvider {
            /**
                * Class to instantiate for the `token`.
                */
            useClass: Type<any>;
    }
    
    const CLEANUP = 7;
    
    /**
        * Low-level service for running the angular compiler during runtime
        * to create {@link ComponentFactory}s, which
        * can later be used to create and render a Component instance.
        *
        * Each `@NgModule` provides an own `Compiler` to its injector,
        * that will use the directives/pipes of the ng module for compilation
        * of components.
        *
        * @publicApi
        *
        * @deprecated
        * Ivy JIT mode doesn't require accessing this symbol.
        * See [JIT API changes due to ViewEngine deprecation](guide/deprecations#jit-api-changes) for
        * additional context.
        */
    export class Compiler {
            /**
                * Compiles the given NgModule and all of its components. All templates of the components listed
                * in `entryComponents` have to be inlined.
                */
            compileModuleSync<T>(moduleType: Type<T>): NgModuleFactory<T>;
            /**
                * Compiles the given NgModule and all of its components
                */
            compileModuleAsync<T>(moduleType: Type<T>): Promise<NgModuleFactory<T>>;
            /**
                * Same as {@link #compileModuleSync} but also creates ComponentFactories for all components.
                */
            compileModuleAndAllComponentsSync<T>(moduleType: Type<T>): ModuleWithComponentFactories<T>;
            /**
                * Same as {@link #compileModuleAsync} but also creates ComponentFactories for all components.
                */
            compileModuleAndAllComponentsAsync<T>(moduleType: Type<T>): Promise<ModuleWithComponentFactories<T>>;
            /**
                * Clears all caches.
                */
            clearCache(): void;
            /**
                * Clears the cache for the given component/ngModule.
                */
            clearCacheFor(type: Type<any>): void;
            /**
                * Returns the id for a given NgModule, if one is defined and known to the compiler.
                */
            getModuleId(moduleType: Type<any>): string | undefined;
            static ɵfac: i0.ɵɵFactoryDeclaration<Compiler, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<Compiler>;
    }
    
    /**
        * Token to provide CompilerOptions in the platform injector.
        *
        * @publicApi
        */
    export const COMPILER_OPTIONS: InjectionToken<CompilerOptions[]>;
    
    /**
        * A factory for creating a Compiler
        *
        * @publicApi
        *
        * @deprecated
        * Ivy JIT mode doesn't require accessing this symbol.
        * See [JIT API changes due to ViewEngine deprecation](guide/deprecations#jit-api-changes) for
        * additional context.
        */
    export abstract class CompilerFactory {
            abstract createCompiler(options?: CompilerOptions[]): Compiler;
    }
    
    /**
        * Options for creating a compiler.
        *
        * Note: the `useJit` and `missingTranslation` config options are not used in Ivy, passing them has
        * no effect. Those config options are deprecated since v13.
        *
        * @publicApi
        */
    export type CompilerOptions = {
            /**
                * @deprecated not used at all in Ivy, providing this config option has no effect.
                */
            useJit?: boolean;
            defaultEncapsulation?: ViewEncapsulation;
            providers?: StaticProvider[];
            /**
                * @deprecated not used at all in Ivy, providing this config option has no effect.
                */
            missingTranslation?: MissingTranslationStrategy;
            preserveWhitespaces?: boolean;
    };
    
    /**
        * Supplies configuration metadata for an Angular component.
        *
        * @publicApi
        */
    export interface Component extends Directive {
            /**
                * The change-detection strategy to use for this component.
                *
                * When a component is instantiated, Angular creates a change detector,
                * which is responsible for propagating the component's bindings.
                * The strategy is one of:
                * - `ChangeDetectionStrategy#OnPush` sets the strategy to `CheckOnce` (on demand).
                * - `ChangeDetectionStrategy#Default` sets the strategy to `CheckAlways`.
                */
            changeDetection?: ChangeDetectionStrategy;
            /**
                * Defines the set of injectable objects that are visible to its view DOM children.
                * See [example](#injecting-a-class-with-a-view-provider).
                *
                */
            viewProviders?: Provider[];
            /**
                * The module ID of the module that contains the component.
                * The component must be able to resolve relative URLs for templates and styles.
                * SystemJS exposes the `__moduleName` variable within each module.
                * In CommonJS, this can  be set to `module.id`.
                *
                */
            moduleId?: string;
            /**
                * The relative path or absolute URL of a template file for an Angular component.
                * If provided, do not supply an inline template using `template`.
                *
                */
            templateUrl?: string;
            /**
                * An inline template for an Angular component. If provided,
                * do not supply a template file using `templateUrl`.
                *
                */
            template?: string;
            /**
                * One or more relative paths or absolute URLs for files containing CSS stylesheets to use
                * in this component.
                */
            styleUrls?: string[];
            /**
                * One or more inline CSS stylesheets to use
                * in this component.
                */
            styles?: string[];
            /**
                * One or more animation `trigger()` calls, containing
                * [`state()`](api/animations/state) and `transition()` definitions.
                * See the [Animations guide](/guide/animations) and animations API documentation.
                *
                */
            animations?: any[];
            /**
                * An encapsulation policy for the component's styling.
                * Possible values:
                * - `ViewEncapsulation.Emulated`: Apply modified component styles in order to emulate
                *                                 a native Shadow DOM CSS encapsulation behavior.
                * - `ViewEncapsulation.None`: Apply component styles globally without any sort of encapsulation.
                * - `ViewEncapsulation.ShadowDom`: Use the browser's native Shadow DOM API to encapsulate styles.
                *
                * If not supplied, the value is taken from the `CompilerOptions`
                * which defaults to `ViewEncapsulation.Emulated`.
                *
                * If the policy is `ViewEncapsulation.Emulated` and the component has no
                * {@link Component#styles styles} nor {@link Component#styleUrls styleUrls},
                * the policy is automatically switched to `ViewEncapsulation.None`.
                */
            encapsulation?: ViewEncapsulation;
            /**
                * Overrides the default interpolation start and end delimiters (`{{` and `}}`).
                */
            interpolation?: [string, string];
            /**
                * A set of components that should be compiled along with
                * this component. For each component listed here,
                * Angular creates a {@link ComponentFactory} and stores it in the
                * {@link ComponentFactoryResolver}.
                * @deprecated Since 9.0.0. With Ivy, this property is no longer necessary.
                */
            entryComponents?: Array<Type<any> | any[]>;
            /**
                * True to preserve or false to remove potentially superfluous whitespace characters
                * from the compiled template. Whitespace characters are those matching the `\s`
                * character class in JavaScript regular expressions. Default is false, unless
                * overridden in compiler options.
                */
            preserveWhitespaces?: boolean;
            /**
                * Angular components marked as `standalone` do not need to be declared in an NgModule. Such
                * components directly manage their own template dependencies (components, directives, and pipes
                * used in a template) via the imports property.
                *
                * More information about standalone components, directives, and pipes can be found in [this
                * guide](guide/standalone-components).
                */
            standalone?: boolean;
            /**
                * The imports property specifies the standalone component's template dependencies — those
                * directives, components, and pipes that can be used within its template. Standalone components
                * can import other standalone components, directives, and pipes as well as existing NgModules.
                *
                * This property is only available for standalone components - specifying it for components
                * declared in an NgModule generates a compilation error.
                *
                * More information about standalone components, directives, and pipes can be found in [this
                * guide](guide/standalone-components).
                */
            imports?: (Type<any> | ReadonlyArray<any>)[];
            /**
                * The set of schemas that declare elements to be allowed in a standalone component. Elements and
                * properties that are neither Angular components nor directives must be declared in a schema.
                *
                * This property is only available for standalone components - specifying it for components
                * declared in an NgModule generates a compilation error.
                *
                * More information about standalone components, directives, and pipes can be found in [this
                * guide](guide/standalone-components).
                */
            schemas?: SchemaMetadata[];
    }
    
    /**
        * Component decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const Component: ComponentDecorator;
    
    /**
        * Component decorator interface
        *
        * @publicApi
        */
    export interface ComponentDecorator {
            /**
                * Decorator that marks a class as an Angular component and provides configuration
                * metadata that determines how the component should be processed,
                * instantiated, and used at runtime.
                *
                * Components are the most basic UI building block of an Angular app.
                * An Angular app contains a tree of Angular components.
                *
                * Angular components are a subset of directives, always associated with a template.
                * Unlike other directives, only one component can be instantiated for a given element in a
                * template.
                *
                * A component must belong to an NgModule in order for it to be available
                * to another component or application. To make it a member of an NgModule,
                * list it in the `declarations` field of the `NgModule` metadata.
                *
                * Note that, in addition to these options for configuring a directive,
                * you can control a component's runtime behavior by implementing
                * life-cycle hooks. For more information, see the
                * [Lifecycle Hooks](guide/lifecycle-hooks) guide.
                *
                * @usageNotes
                *
                * ### Setting component inputs
                *
                * The following example creates a component with two data-bound properties,
                * specified by the `inputs` value.
                *
                * <code-example path="core/ts/metadata/directives.ts" region="component-input"></code-example>
                *
                *
                * ### Setting component outputs
                *
                * The following example shows two event emitters that emit on an interval. One
                * emits an output every second, while the other emits every five seconds.
                *
                * {@example core/ts/metadata/directives.ts region='component-output-interval'}
                *
                * ### Injecting a class with a view provider
                *
                * The following simple example injects a class into a component
                * using the view provider specified in component metadata:
                *
                * ```ts
                * class Greeter {
                *    greet(name:string) {
                *      return 'Hello ' + name + '!';
                *    }
                * }
                *
                * @Directive({
                *   selector: 'needs-greeter'
                * })
                * class NeedsGreeter {
                *   greeter:Greeter;
                *
                *   constructor(greeter:Greeter) {
                *     this.greeter = greeter;
                *   }
                * }
                *
                * @Component({
                *   selector: 'greet',
                *   viewProviders: [
                *     Greeter
                *   ],
                *   template: `<needs-greeter></needs-greeter>`
                * })
                * class HelloWorld {
                * }
                *
                * ```
                *
                * ### Preserving whitespace
                *
                * Removing whitespace can greatly reduce AOT-generated code size and speed up view creation.
                * As of Angular 6, the default for `preserveWhitespaces` is false (whitespace is removed).
                * To change the default setting for all components in your application, set
                * the `preserveWhitespaces` option of the AOT compiler.
                *
                * By default, the AOT compiler removes whitespace characters as follows:
                * * Trims all whitespaces at the beginning and the end of a template.
                * * Removes whitespace-only text nodes. For example,
                *
                * ```html
                * <button>Action 1</button>  <button>Action 2</button>
                * ```
                *
                * becomes:
                *
                * ```html
                * <button>Action 1</button><button>Action 2</button>
                * ```
                *
                * * Replaces a series of whitespace characters in text nodes with a single space.
                * For example, `<span>\n some text\n</span>` becomes `<span> some text </span>`.
                * * Does NOT alter text nodes inside HTML tags such as `<pre>` or `<textarea>`,
                * where whitespace characters are significant.
                *
                * Note that these transformations can influence DOM nodes layout, although impact
                * should be minimal.
                *
                * You can override the default behavior to preserve whitespace characters
                * in certain fragments of a template. For example, you can exclude an entire
                * DOM sub-tree by using the `ngPreserveWhitespaces` attribute:
                *
                * ```html
                * <div ngPreserveWhitespaces>
                *     whitespaces are preserved here
                *     <span>    and here </span>
                * </div>
                * ```
                *
                * You can force a single space to be preserved in a text node by using `&ngsp;`,
                * which is replaced with a space character by Angular's template
                * compiler:
                *
                * ```html
                * <a>Spaces</a>&ngsp;<a>between</a>&ngsp;<a>links.</a>
                * <!-- compiled to be equivalent to:
                *  <a>Spaces</a> <a>between</a> <a>links.</a>  -->
                * ```
                *
                * Note that sequences of `&ngsp;` are still collapsed to just one space character when
                * the `preserveWhitespaces` option is set to `false`.
                *
                * ```html
                * <a>before</a>&ngsp;&ngsp;&ngsp;<a>after</a>
                * <!-- compiled to be equivalent to:
                *  <a>before</a> <a>after</a> -->
                * ```
                *
                * To preserve sequences of whitespace characters, use the
                * `ngPreserveWhitespaces` attribute.
                *
                * @Annotation
                */
            (obj: Component): TypeDecorator;
            /**
                * See the `Component` decorator.
                */
            new (obj: Component): Component;
    }
    
    interface ComponentDefFeature {
            <T>(componentDef: ɵComponentDef<T>): void;
            /**
                * Marks a feature as something that {@link InheritDefinitionFeature} will execute
                * during inheritance.
                *
                * NOTE: DO NOT SET IN ROOT OF MODULE! Doing so will result in tree-shakers/bundlers
                * identifying the change as a side effect, and the feature will be included in
                * every bundle.
                */
            ngInherit?: true;
    }
    
    interface ComponentDefinition<T> extends Omit<DirectiveDefinition<T>, 'features'> {
            /**
                * The number of nodes, local refs, and pipes in this component template.
                *
                * Used to calculate the length of this component's LView array, so we
                * can pre-fill the array and set the binding start index.
                */
            decls: number;
            /**
                * The number of bindings in this component template (including pure fn bindings).
                *
                * Used to calculate the length of this component's LView array, so we
                * can pre-fill the array and set the host binding start index.
                */
            vars: number;
            /**
                * Template function use for rendering DOM.
                *
                * This function has following structure.
                *
                * ```
                * function Template<T>(ctx:T, creationMode: boolean) {
                *   if (creationMode) {
                *     // Contains creation mode instructions.
                *   }
                *   // Contains binding update instructions
                * }
                * ```
                *
                * Common instructions are:
                * Creation mode instructions:
                *  - `elementStart`, `elementEnd`
                *  - `text`
                *  - `container`
                *  - `listener`
                *
                * Binding update instructions:
                * - `bind`
                * - `elementAttribute`
                * - `elementProperty`
                * - `elementClass`
                * - `elementStyle`
                *
                */
            template: ComponentTemplate<T>;
            /**
                * Constants for the nodes in the component's view.
                * Includes attribute arrays, local definition arrays etc.
                */
            consts?: TConstantsOrFactory;
            /**
                * An array of `ngContent[selector]` values that were found in the template.
                */
            ngContentSelectors?: string[];
            /**
                * A list of optional features to apply.
                *
                * See: {@link NgOnChangesFeature}, {@link ProvidersFeature}
                */
            features?: ComponentDefFeature[];
            /**
                * Defines template and style encapsulation options available for Component's {@link Component}.
                */
            encapsulation?: ViewEncapsulation;
            /**
                * Defines arbitrary developer-defined data to be stored on a renderer instance.
                * This is useful for renderers that delegate to other renderers.
                *
                * see: animation
                */
            data?: {
                    [kind: string]: any;
            };
            /**
                * A set of styles that the component needs to be present for component to render correctly.
                */
            styles?: string[];
            /**
                * The strategy that the default change detector uses to detect changes.
                * When set, takes effect the next time change detection is triggered.
                */
            changeDetection?: ChangeDetectionStrategy;
            /**
                * Registry of directives, components, and pipes that may be found in this component's view.
                *
                * This property is either an array of types or a function that returns the array of types. This
                * function may be necessary to support forward declarations.
                */
            dependencies?: TypeOrFactory<DependencyTypeList>;
            /**
                * The set of schemas that declare elements to be allowed in the component's template.
                */
            schemas?: SchemaMetadata[] | null;
    }
    
    /**
        * Base class for a factory that can create a component dynamically.
        * Instantiate a factory for a given type of component with `resolveComponentFactory()`.
        * Use the resulting `ComponentFactory.create()` method to create a component of that type.
        *
        * @see [Dynamic Components](guide/dynamic-component-loader)
        *
        * @publicApi
        *
        * @deprecated Angular no longer requires Component factories. Please use other APIs where
        *     Component class can be used directly.
        */
    abstract class ComponentFactory<C> {
            /**
                * The component's HTML selector.
                */
            abstract get selector(): string;
            /**
                * The type of component the factory will create.
                */
            abstract get componentType(): Type<any>;
            /**
                * Selector for all <ng-content> elements in the component.
                */
            abstract get ngContentSelectors(): string[];
            /**
                * The inputs of the component.
                */
            abstract get inputs(): {
                    propName: string;
                    templateName: string;
            }[];
            /**
                * The outputs of the component.
                */
            abstract get outputs(): {
                    propName: string;
                    templateName: string;
            }[];
            /**
                * Creates a new component.
                */
            abstract create(injector: Injector, projectableNodes?: any[][], rootSelectorOrNode?: string | any, environmentInjector?: EnvironmentInjector | NgModuleRef<any>): ComponentRef<C>;
    }
    export { ComponentFactory }
    export { ComponentFactory as ɵComponentFactory }
    
    /**
        * A simple registry that maps `Components` to generated `ComponentFactory` classes
        * that can be used to create instances of components.
        * Use to obtain the factory for a given component type,
        * then use the factory's `create()` method to create a component of that type.
        *
        * Note: since v13, dynamic component creation via
        * [`ViewContainerRef.createComponent`](api/core/ViewContainerRef#createComponent)
        * does **not** require resolving component factory: component class can be used directly.
        *
        * @publicApi
        *
        * @deprecated Angular no longer requires Component factories. Please use other APIs where
        *     Component class can be used directly.
        */
    export abstract class ComponentFactoryResolver {
            static NULL: ComponentFactoryResolver;
            /**
                * Retrieves the factory object that creates a component of the given type.
                * @param component The component type.
                */
            abstract resolveComponentFactory<T>(component: Type<T>): ComponentFactory<T>;
    }
    
    class ComponentFactoryResolver_2 extends ComponentFactoryResolver {
            /**
                * @param ngModule The NgModuleRef to which all resolved factories are bound.
                */
            constructor(ngModule?: NgModuleRef<any> | undefined);
            resolveComponentFactory<T>(component: Type<T>): ComponentFactory<T>;
    }
    
    /**
        * An interface that describes the subset of component metadata
        * that can be retrieved using the `reflectComponentType` function.
        *
        * @publicApi
        */
    export interface ComponentMirror<C> {
            /**
                * The component's HTML selector.
                */
            get selector(): string;
            /**
                * The type of component the factory will create.
                */
            get type(): Type<C>;
            /**
                * The inputs of the component.
                */
            get inputs(): ReadonlyArray<{
                    readonly propName: string;
                    readonly templateName: string;
            }>;
            /**
                * The outputs of the component.
                */
            get outputs(): ReadonlyArray<{
                    readonly propName: string;
                    readonly templateName: string;
            }>;
            /**
                * Selector for all <ng-content> elements in the component.
                */
            get ngContentSelectors(): ReadonlyArray<string>;
            /**
                * Whether this component is marked as standalone.
                * Note: an extra flag, not present in `ComponentFactory`.
                */
            get isStandalone(): boolean;
    }
    
    /**
        * Represents a component created by a `ComponentFactory`.
        * Provides access to the component instance and related objects,
        * and provides the means of destroying the instance.
        *
        * @publicApi
        */
    export abstract class ComponentRef<C> {
            /**
                * Updates a specified input name to a new value. Using this method will properly mark for check
                * component using the `OnPush` change detection strategy. It will also assure that the
                * `OnChanges` lifecycle hook runs when a dynamically created component is change-detected.
                *
                * @param name The name of an input.
                * @param value The new value of an input.
                */
            abstract setInput(name: string, value: unknown): void;
            /**
                * The host or anchor [element](guide/glossary#element) for this component instance.
                */
            abstract get location(): ElementRef;
            /**
                * The [dependency injector](guide/glossary#injector) for this component instance.
                */
            abstract get injector(): Injector;
            /**
                * This component instance.
                */
            abstract get instance(): C;
            /**
                * The [host view](guide/glossary#view-hierarchy) defined by the template
                * for this component instance.
                */
            abstract get hostView(): ViewRef;
            /**
                * The change detector for this component instance.
                */
            abstract get changeDetectorRef(): ChangeDetectorRef;
            /**
                * The type of this component (as created by a `ComponentFactory` class).
                */
            abstract get componentType(): Type<any>;
            /**
                * Destroys the component instance and all of the data structures associated with it.
                */
            abstract destroy(): void;
            /**
                * A lifecycle hook that provides additional developer-defined cleanup
                * functionality for the component.
                * @param callback A handler function that cleans up developer-defined data
                * associated with this component. Called when the `destroy()` method is invoked.
                */
            abstract onDestroy(callback: Function): void;
    }
    
    /**
        * Definition of what a template rendering function should look like for a component.
        */
    type ComponentTemplate<T> = {
            <U extends T>(rf: ɵRenderFlags, ctx: T | U): void;
    };
    
    /**
        * Configures the `Injector` to return an instance of a token.
        *
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @usageNotes
        *
        * {@example core/di/ts/provider_spec.ts region='ConstructorProvider'}
        *
        * ### Multi-value example
        *
        * {@example core/di/ts/provider_spec.ts region='MultiProviderAspect'}
        *
        * @publicApi
        */
    export interface ConstructorProvider extends ConstructorSansProvider {
            /**
                * An injection token. Typically an instance of `Type` or `InjectionToken`, but can be `any`.
                */
            provide: Type<any>;
            /**
                * When true, injector returns an array of instances. This is useful to allow multiple
                * providers spread across many files to provide configuration information to a common token.
                */
            multi?: boolean;
    }
    
    /**
        * Configures the `Injector` to return an instance of a token.
        *
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @usageNotes
        *
        * ```ts
        * @Injectable(SomeModule, {deps: []})
        * class MyService {}
        * ```
        *
        * @publicApi
        */
    export interface ConstructorSansProvider {
            /**
                * A list of `token`s to be resolved by the injector.
                */
            deps?: any[];
    }
    
    /**
        * Type of the ContentChild metadata.
        *
        * @publicApi
        */
    export type ContentChild = Query;
    
    /**
        * ContentChild decorator and metadata.
        *
        *
        * @Annotation
        *
        * @publicApi
        */
    export const ContentChild: ContentChildDecorator;
    
    /**
        * Type of the ContentChild decorator / constructor function.
        *
        * @publicApi
        */
    export interface ContentChildDecorator {
            /**
                * @description
                * Property decorator that configures a content query.
                *
                * Use to get the first element or the directive matching the selector from the content DOM.
                * If the content DOM changes, and a new child matches the selector,
                * the property will be updated.
                *
                * Content queries are set before the `ngAfterContentInit` callback is called.
                *
                * Does not retrieve elements or directives that are in other components' templates,
                * since a component's template is always a black box to its ancestors.
                *
                * **Metadata Properties**:
                *
                * * **selector** - The directive type or the name used for querying.
                * * **descendants** - If `true` (default) include all descendants of the element. If `false` then
                * only query direct children of the element.
                * * **read** - Used to read a different token from the queried element.
                * * **static** - True to resolve query results before change detection runs,
                * false to resolve after change detection. Defaults to false.
                *
                * The following selectors are supported.
                *   * Any class with the `@Component` or `@Directive` decorator
                *   * A template reference variable as a string (e.g. query `<my-component #cmp></my-component>`
                * with `@ContentChild('cmp')`)
                *   * Any provider defined in the child component tree of the current component (e.g.
                * `@ContentChild(SomeService) someService: SomeService`)
                *   * Any provider defined through a string token (e.g. `@ContentChild('someToken') someTokenVal:
                * any`)
                *   * A `TemplateRef` (e.g. query `<ng-template></ng-template>` with `@ContentChild(TemplateRef)
                * template;`)
                *
                * The following values are supported by `read`:
                *   * Any class with the `@Component` or `@Directive` decorator
                *   * Any provider defined on the injector of the component that is matched by the `selector` of
                * this query
                *   * Any provider defined through a string token (e.g. `{provide: 'token', useValue: 'val'}`)
                *   * `TemplateRef`, `ElementRef`, and `ViewContainerRef`
                *
                * @usageNotes
                *
                * {@example core/di/ts/contentChild/content_child_howto.ts region='HowTo'}
                *
                * ### Example
                *
                * {@example core/di/ts/contentChild/content_child_example.ts region='Component'}
                *
                * @Annotation
                */
            (selector: ProviderToken<unknown> | Function | string, opts?: {
                    descendants?: boolean;
                    read?: any;
                    static?: boolean;
            }): any;
            new (selector: ProviderToken<unknown> | Function | string, opts?: {
                    descendants?: boolean;
                    read?: any;
                    static?: boolean;
            }): ContentChild;
    }
    
    /**
        * Type of the ContentChildren metadata.
        *
        *
        * @Annotation
        * @publicApi
        */
    export type ContentChildren = Query;
    
    /**
        * ContentChildren decorator and metadata.
        *
        *
        * @Annotation
        * @publicApi
        */
    export const ContentChildren: ContentChildrenDecorator;
    
    /**
        * Type of the ContentChildren decorator / constructor function.
        *
        * @see `ContentChildren`.
        * @publicApi
        */
    export interface ContentChildrenDecorator {
            /**
                * @description
                * Property decorator that configures a content query.
                *
                * Use to get the `QueryList` of elements or directives from the content DOM.
                * Any time a child element is added, removed, or moved, the query list will be
                * updated, and the changes observable of the query list will emit a new value.
                *
                * Content queries are set before the `ngAfterContentInit` callback is called.
                *
                * Does not retrieve elements or directives that are in other components' templates,
                * since a component's template is always a black box to its ancestors.
                *
                * **Metadata Properties**:
                *
                * * **selector** - The directive type or the name used for querying.
                * * **descendants** - If `true` include all descendants of the element. If `false` then only
                * query direct children of the element.
                * * **emitDistinctChangesOnly** - The ` QueryList#changes` observable will emit new values only
                *   if the QueryList result has changed. When `false` the `changes` observable might emit even
                *   if the QueryList has not changed.
                *   ** Note: *** This config option is **deprecated**, it will be permanently set to `true` and
                *   removed in future versions of Angular.
                * * **read** - Used to read a different token from the queried elements.
                *
                * The following selectors are supported.
                *   * Any class with the `@Component` or `@Directive` decorator
                *   * A template reference variable as a string (e.g. query `<my-component #cmp></my-component>`
                * with `@ContentChildren('cmp')`)
                *   * Any provider defined in the child component tree of the current component (e.g.
                * `@ContentChildren(SomeService) someService: SomeService`)
                *   * Any provider defined through a string token (e.g. `@ContentChildren('someToken')
                * someTokenVal: any`)
                *   * A `TemplateRef` (e.g. query `<ng-template></ng-template>` with
                * `@ContentChildren(TemplateRef) template;`)
                *
                * In addition, multiple string selectors can be separated with a comma (e.g.
                * `@ContentChildren('cmp1,cmp2')`)
                *
                * The following values are supported by `read`:
                *   * Any class with the `@Component` or `@Directive` decorator
                *   * Any provider defined on the injector of the component that is matched by the `selector` of
                * this query
                *   * Any provider defined through a string token (e.g. `{provide: 'token', useValue: 'val'}`)
                *   * `TemplateRef`, `ElementRef`, and `ViewContainerRef`
                *
                * @usageNotes
                *
                * Here is a simple demonstration of how the `ContentChildren` decorator can be used.
                *
                * {@example core/di/ts/contentChildren/content_children_howto.ts region='HowTo'}
                *
                * ### Tab-pane example
                *
                * Here is a slightly more realistic example that shows how `ContentChildren` decorators
                * can be used to implement a tab pane component.
                *
                * {@example core/di/ts/contentChildren/content_children_example.ts region='Component'}
                *
                * @Annotation
                */
            (selector: ProviderToken<unknown> | Function | string, opts?: {
                    descendants?: boolean;
                    emitDistinctChangesOnly?: boolean;
                    read?: any;
            }): any;
            new (selector: ProviderToken<unknown> | Function | string, opts?: {
                    descendants?: boolean;
                    emitDistinctChangesOnly?: boolean;
                    read?: any;
            }): Query;
    }
    
    /**
        * Definition of what a content queries function should look like.
        */
    type ContentQueriesFunction<T> = <U extends T>(rf: ɵRenderFlags, ctx: U, directiveIndex: number) => void;
    
    const CONTEXT = 8;
    
    /**
        * Creates a `ComponentRef` instance based on provided component type and a set of options.
        *
        * @usageNotes
        *
        * The example below demonstrates how the `createComponent` function can be used
        * to create an instance of a ComponentRef dynamically and attach it to an ApplicationRef,
        * so that it gets included into change detection cycles.
        *
        * Note: the example uses standalone components, but the function can also be used for
        * non-standalone components (declared in an NgModule) as well.
        *
        * ```typescript
        * @Component({
        *   standalone: true,
        *   template: `Hello {{ name }}!`
        * })
        * class HelloComponent {
        *   name = 'Angular';
        * }
        *
        * @Component({
        *   standalone: true,
        *   template: `<div id="hello-component-host"></div>`
        * })
        * class RootComponent {}
        *
        * // Bootstrap an application.
        * const applicationRef = await bootstrapApplication(RootComponent);
        *
        * // Locate a DOM node that would be used as a host.
        * const host = document.getElementById('hello-component-host');
        *
        * // Get an `EnvironmentInjector` instance from the `ApplicationRef`.
        * const environmentInjector = applicationRef.injector;
        *
        * // We can now create a `ComponentRef` instance.
        * const componentRef = createComponent(HelloComponent, {host, environmentInjector});
        *
        * // Last step is to register the newly created ref using the `ApplicationRef` instance
        * // to include the component view into change detection cycles.
        * applicationRef.attachView(componentRef.hostView);
        * ```
        *
        * @param component Component class reference.
        * @param options Set of options to use:
        *  * `environmentInjector`: An `EnvironmentInjector` instance to be used for the component, see
        * additional info about it at https://angular.io/guide/standalone-components#environment-injectors.
        *  * `hostElement` (optional): A DOM node that should act as a host node for the component. If not
        * provided, Angular creates one based on the tag name used in the component selector (and falls
        * back to using `div` if selector doesn't have tag name info).
        *  * `elementInjector` (optional): An `ElementInjector` instance, see additional info about it at
        * https://angular.io/guide/hierarchical-dependency-injection#elementinjector.
        *  * `projectableNodes` (optional): A list of DOM nodes that should be projected through
        *                      [`<ng-content>`](api/core/ng-content) of the new component instance.
        * @returns ComponentRef instance that represents a given Component.
        *
        * @publicApi
        */
    export function createComponent<C>(component: Type<C>, options: {
            environmentInjector: EnvironmentInjector;
            hostElement?: Element;
            elementInjector?: Injector;
            projectableNodes?: Node[][];
    }): ComponentRef<C>;
    
    /**
        * Create a new environment injector.
        *
        * Learn more about environment injectors in
        * [this guide](guide/standalone-components#environment-injectors).
        *
        * @param providers An array of providers.
        * @param parent A parent environment injector.
        * @param debugName An optional name for this injector instance, which will be used in error
        *     messages.
        *
        * @publicApi
        */
    export function createEnvironmentInjector(providers: Array<Provider | EnvironmentProviders>, parent: EnvironmentInjector, debugName?: string | null): EnvironmentInjector;
    
    /**
        * Returns a new NgModuleRef instance based on the NgModule class and parent injector provided.
        *
        * @param ngModule NgModule class.
        * @param parentInjector Optional injector instance to use as a parent for the module injector. If
        *     not provided, `NullInjector` will be used instead.
        * @returns NgModuleRef that represents an NgModule instance.
        *
        * @publicApi
        */
    export function createNgModule<T>(ngModule: Type<T>, parentInjector?: Injector): NgModuleRef<T>;
    
    /**
        * The `createNgModule` function alias for backwards-compatibility.
        * Please avoid using it directly and use `createNgModule` instead.
        *
        * @deprecated Use `createNgModule` instead.
        */
    export const createNgModuleRef: typeof createNgModule;
    
    /**
        * Creates a platform.
        * Platforms must be created on launch using this function.
        *
        * @publicApi
        */
    export function createPlatform(injector: Injector): PlatformRef;
    
    /**
        * Creates a factory for a platform. Can be used to provide or override `Providers` specific to
        * your application's runtime needs, such as `PLATFORM_INITIALIZER` and `PLATFORM_ID`.
        * @param parentPlatformFactory Another platform factory to modify. Allows you to compose factories
        * to build up configurations that might be required by different libraries or parts of the
        * application.
        * @param name Identifies the new platform factory.
        * @param providers A set of dependency providers for platforms created with the new factory.
        *
        * @publicApi
        */
    export function createPlatformFactory(parentPlatformFactory: ((extraProviders?: StaticProvider[]) => PlatformRef) | null, name: string, providers?: StaticProvider[]): (extraProviders?: StaticProvider[]) => PlatformRef;
    
    
    /**
        * Expresses a single CSS Selector.
        *
        * Beginning of array
        * - First index: element name
        * - Subsequent odd indices: attr keys
        * - Subsequent even indices: attr values
        *
        * After SelectorFlags.CLASS flag
        * - Class name values
        *
        * SelectorFlags.NOT flag
        * - Changes the mode to NOT
        * - Can be combined with other flags to set the element / attr / class mode
        *
        * e.g. SelectorFlags.NOT | SelectorFlags.ELEMENT
        *
        * Example:
        * Original: `div.foo.bar[attr1=val1][attr2]`
        * Parsed: ['div', 'attr1', 'val1', 'attr2', '', SelectorFlags.CLASS, 'foo', 'bar']
        *
        * Original: 'div[attr1]:not(.foo[attr2])
        * Parsed: [
        *  'div', 'attr1', '',
        *  SelectorFlags.NOT | SelectorFlags.ATTRIBUTE 'attr2', '', SelectorFlags.CLASS, 'foo'
        * ]
        *
        * See more examples in node_selector_matcher_spec.ts
        */
    type CssSelector = (string | SelectorFlags)[];
    
    /**
        * An object literal of this type is used to represent the metadata of a constructor dependency.
        * The type itself is never referred to from generated code.
        *
        * @publicApi
        */
    type CtorDependency = {
            /**
                * If an `@Attribute` decorator is used, this represents the injected attribute's name. If the
                * attribute name is a dynamic expression instead of a string literal, this will be the unknown
                * type.
                */
            attribute?: string | unknown;
            /**
                * If `@Optional()` is used, this key is set to true.
                */
            optional?: true;
            /**
                * If `@Host` is used, this key is set to true.
                */
            host?: true;
            /**
                * If `@Self` is used, this key is set to true.
                */
            self?: true;
            /**
                * If `@SkipSelf` is used, this key is set to true.
                */
            skipSelf?: true;
    } | null;
    
    /**
        * Defines a schema that allows an NgModule to contain the following:
        * - Non-Angular elements named with dash case (`-`).
        * - Element properties named with dash case (`-`).
        * Dash case is the naming convention for custom elements.
        *
        * @publicApi
        */
    export const CUSTOM_ELEMENTS_SCHEMA: SchemaMetadata;
    
    /**
        * @publicApi
        *
        * @see [Component testing scenarios](guide/testing-components-scenarios)
        * @see [Basics of testing components](guide/testing-components-basics)
        * @see [Testing utility APIs](guide/testing-utility-apis)
        */
    export class DebugElement extends DebugNode {
            constructor(nativeNode: Element);
            /**
                * The underlying DOM element at the root of the component.
                */
            get nativeElement(): any;
            /**
                * The element tag name, if it is an element.
                */
            get name(): string;
            /**
                *  Gets a map of property names to property values for an element.
                *
                *  This map includes:
                *  - Regular property bindings (e.g. `[id]="id"`)
                *  - Host property bindings (e.g. `host: { '[id]': "id" }`)
                *  - Interpolated property bindings (e.g. `id="{{ value }}")
                *
                *  It does not include:
                *  - input property bindings (e.g. `[myCustomInput]="value"`)
                *  - attribute bindings (e.g. `[attr.role]="menu"`)
                */
            get properties(): {
                    [key: string]: any;
            };
            /**
                *  A map of attribute names to attribute values for an element.
                */
            get attributes(): {
                    [key: string]: string | null;
            };
            /**
                * The inline styles of the DOM element.
                *
                * Will be `null` if there is no `style` property on the underlying DOM element.
                *
                * @see [ElementCSSInlineStyle](https://developer.mozilla.org/en-US/docs/Web/API/ElementCSSInlineStyle/style)
                */
            get styles(): {
                    [key: string]: string | null;
            };
            /**
                * A map containing the class names on the element as keys.
                *
                * This map is derived from the `className` property of the DOM element.
                *
                * Note: The values of this object will always be `true`. The class key will not appear in the KV
                * object if it does not exist on the element.
                *
                * @see [Element.className](https://developer.mozilla.org/en-US/docs/Web/API/Element/className)
                */
            get classes(): {
                    [key: string]: boolean;
            };
            /**
                * The `childNodes` of the DOM element as a `DebugNode` array.
                *
                * @see [Node.childNodes](https://developer.mozilla.org/en-US/docs/Web/API/Node/childNodes)
                */
            get childNodes(): DebugNode[];
            /**
                * The immediate `DebugElement` children. Walk the tree by descending through `children`.
                */
            get children(): DebugElement[];
            /**
                * @returns the first `DebugElement` that matches the predicate at any depth in the subtree.
                */
            query(predicate: Predicate<DebugElement>): DebugElement;
            /**
                * @returns All `DebugElement` matches for the predicate at any depth in the subtree.
                */
            queryAll(predicate: Predicate<DebugElement>): DebugElement[];
            /**
                * @returns All `DebugNode` matches for the predicate at any depth in the subtree.
                */
            queryAllNodes(predicate: Predicate<DebugNode>): DebugNode[];
            /**
                * Triggers the event by its name if there is a corresponding listener in the element's
                * `listeners` collection.
                *
                * If the event lacks a listener or there's some other problem, consider
                * calling `nativeElement.dispatchEvent(eventObject)`.
                *
                * @param eventName The name of the event to trigger
                * @param eventObj The _event object_ expected by the handler
                *
                * @see [Testing components scenarios](guide/testing-components-scenarios#trigger-event-handler)
                */
            triggerEventHandler(eventName: string, eventObj?: any): void;
    }
    
    /**
        * @publicApi
        */
    export class DebugEventListener {
            name: string;
            callback: Function;
            constructor(name: string, callback: Function);
    }
    
    /**
        * @publicApi
        */
    export class DebugNode {
            /**
                * The underlying DOM node.
                */
            readonly nativeNode: any;
            constructor(nativeNode: Node);
            /**
                * The `DebugElement` parent. Will be `null` if this is the root element.
                */
            get parent(): DebugElement | null;
            /**
                * The host dependency injector. For example, the root element's component instance injector.
                */
            get injector(): Injector;
            /**
                * The element's own component instance, if it has one.
                */
            get componentInstance(): any;
            /**
                * An object that provides parent context for this element. Often an ancestor component instance
                * that governs this element.
                *
                * When an element is repeated within *ngFor, the context is an `NgForOf` whose `$implicit`
                * property is the value of the row instance value. For example, the `hero` in `*ngFor="let hero
                * of heroes"`.
                */
            get context(): any;
            /**
                * The callbacks attached to the component's @Output properties and/or the element's event
                * properties.
                */
            get listeners(): DebugEventListener[];
            /**
                * Dictionary of objects associated with template local variables (e.g. #foo), keyed by the local
                * variable name.
                */
            get references(): {
                    [key: string]: any;
            };
            /**
                * This component's injector lookup tokens. Includes the component itself plus the tokens that the
                * component lists in its providers metadata.
                */
            get providerTokens(): any[];
    }
    
    const DECLARATION_COMPONENT_VIEW = 16;
    
    const DECLARATION_LCONTAINER = 17;
    
    const DECLARATION_VIEW = 15;
    
    /**
        * Provide this token to set the default currency code your application uses for
        * CurrencyPipe when there is no currency code passed into it. This is only used by
        * CurrencyPipe and has no relation to locale currency. Defaults to USD if not configured.
        *
        * See the [i18n guide](guide/i18n-common-locale-id) for more information.
        *
        * <div class="alert is-helpful">
        *
        * **Deprecation notice:**
        *
        * The default currency code is currently always `USD` but this is deprecated from v9.
        *
        * **In v10 the default currency code will be taken from the current locale.**
        *
        * If you need the previous behavior then set it by creating a `DEFAULT_CURRENCY_CODE` provider in
        * your application `NgModule`:
        *
        * ```ts
        * {provide: DEFAULT_CURRENCY_CODE, useValue: 'USD'}
        * ```
        *
        * </div>
        *
        * @usageNotes
        * ### Example
        *
        * ```typescript
        * import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
        * import { AppModule } from './app/app.module';
        *
        * platformBrowserDynamic().bootstrapModule(AppModule, {
        *   providers: [{provide: DEFAULT_CURRENCY_CODE, useValue: 'EUR' }]
        * });
        * ```
        *
        * @publicApi
        */
    export const DEFAULT_CURRENCY_CODE: InjectionToken<string>;
    
    /**
        * @deprecated v4.0.0 - Should not be part of public API.
        * @publicApi
        */
    export class DefaultIterableDiffer<V> implements IterableDiffer<V>, IterableChanges<V> {
            readonly length: number;
            readonly collection: V[] | Iterable<V> | null;
            constructor(trackByFn?: TrackByFunction<V>);
            forEachItem(fn: (record: IterableChangeRecord_<V>) => void): void;
            forEachOperation(fn: (item: IterableChangeRecord<V>, previousIndex: number | null, currentIndex: number | null) => void): void;
            forEachPreviousItem(fn: (record: IterableChangeRecord_<V>) => void): void;
            forEachAddedItem(fn: (record: IterableChangeRecord_<V>) => void): void;
            forEachMovedItem(fn: (record: IterableChangeRecord_<V>) => void): void;
            forEachRemovedItem(fn: (record: IterableChangeRecord_<V>) => void): void;
            forEachIdentityChange(fn: (record: IterableChangeRecord_<V>) => void): void;
            diff(collection: NgIterable<V> | null | undefined): DefaultIterableDiffer<V> | null;
            onDestroy(): void;
            check(collection: NgIterable<V>): boolean;
            get isDirty(): boolean;
    }
    
    /**
        * @deprecated in v8, delete after v10. This API should be used only by generated code, and that
        * code should now use ɵɵdefineInjectable instead.
        * @publicApi
        */
    export const defineInjectable: typeof ɵɵdefineInjectable;
    
    type DependencyTypeList = (ɵDirectiveType<any> | ɵComponentType<any> | PipeType<any> | Type<any>)[];
    
    /**
        * Array of destroy hooks that should be executed for a view and their directive indices.
        *
        * The array is set up as a series of number/function or number/(number|function)[]:
        * - Even indices represent the context with which hooks should be called.
        * - Odd indices are the hook functions themselves. If a value at an odd index is an array,
        *   it represents the destroy hooks of a `multi` provider where:
        *     - Even indices represent the index of the provider for which we've registered a destroy hook,
        *       inside of the `multi` provider array.
        *     - Odd indices are the destroy hook functions.
        * For example:
        * LView: `[0, 1, 2, AService, 4, [BService, CService, DService]]`
        * destroyHooks: `[3, AService.ngOnDestroy, 5, [0, BService.ngOnDestroy, 2, DService.ngOnDestroy]]`
        *
        * In the example above `AService` is a type provider with an `ngOnDestroy`, whereas `BService`,
        * `CService` and `DService` are part of a `multi` provider where only `BService` and `DService`
        * have an `ngOnDestroy` hook.
        */
    type DestroyHookData = (HookEntry | HookData)[];
    
    /**
        * Destroys the current Angular platform and all Angular applications on the page.
        * Destroys all modules and listeners registered with the platform.
        *
        * @publicApi
        */
    export function destroyPlatform(): void;
    
    /**
        * Directive decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export interface Directive {
            /**
                * The CSS selector that identifies this directive in a template
                * and triggers instantiation of the directive.
                *
                * Declare as one of the following:
                *
                * - `element-name`: Select by element name.
                * - `.class`: Select by class name.
                * - `[attribute]`: Select by attribute name.
                * - `[attribute=value]`: Select by attribute name and value.
                * - `:not(sub_selector)`: Select only if the element does not match the `sub_selector`.
                * - `selector1, selector2`: Select if either `selector1` or `selector2` matches.
                *
                * Angular only allows directives to apply on CSS selectors that do not cross
                * element boundaries.
                *
                * For the following template HTML, a directive with an `input[type=text]` selector,
                * would be instantiated only on the `<input type="text">` element.
                *
                * ```html
                * <form>
                *   <input type="text">
                *   <input type="radio">
                * <form>
                * ```
                *
                */
            selector?: string;
            /**
                * Enumerates the set of data-bound input properties for a directive
                *
                * Angular automatically updates input properties during change detection.
                * The `inputs` property defines a set of `directiveProperty` to `bindingProperty`
                * configuration:
                *
                * - `directiveProperty` specifies the component property where the value is written.
                * - `bindingProperty` specifies the DOM property where the value is read from.
                *
                * When `bindingProperty` is not provided, it is assumed to be equal to `directiveProperty`.
                *
                * @usageNotes
                *
                * The following example creates a component with two data-bound properties.
                *
                * ```typescript
                * @Component({
                *   selector: 'bank-account',
                *   inputs: ['bankName', 'id: account-id'],
                *   template: `
                *     Bank Name: {{bankName}}
                *     Account Id: {{id}}
                *   `
                * })
                * class BankAccount {
                *   bankName: string;
                *   id: string;
                * }
                * ```
                *
                */
            inputs?: string[];
            /**
                * Enumerates the set of event-bound output properties.
                *
                * When an output property emits an event, an event handler attached to that event
                * in the template is invoked.
                *
                * The `outputs` property defines a set of `directiveProperty` to `bindingProperty`
                * configuration:
                *
                * - `directiveProperty` specifies the component property that emits events.
                * - `bindingProperty` specifies the DOM property the event handler is attached to.
                *
                * @usageNotes
                *
                * ```typescript
                * @Component({
                *   selector: 'child-dir',
                *   outputs: [ 'bankNameChange' ],
                *   template: `<input (input)="bankNameChange.emit($event.target.value)" />`
                * })
                * class ChildDir {
                *  bankNameChange: EventEmitter<string> = new EventEmitter<string>();
                * }
                *
                * @Component({
                *   selector: 'main',
                *   template: `
                *     {{ bankName }} <child-dir (bankNameChange)="onBankNameChange($event)"></child-dir>
                *   `
                * })
                * class MainComponent {
                *  bankName: string;
                *
                *   onBankNameChange(bankName: string) {
                *     this.bankName = bankName;
                *   }
                * }
                * ```
                *
                */
            outputs?: string[];
            /**
                * Configures the [injector](guide/glossary#injector) of this
                * directive or component with a [token](guide/glossary#di-token)
                * that maps to a [provider](guide/glossary#provider) of a dependency.
                */
            providers?: Provider[];
            /**
                * Defines the name that can be used in the template to assign this directive to a variable.
                *
                * @usageNotes
                *
                * ```ts
                * @Directive({
                *   selector: 'child-dir',
                *   exportAs: 'child'
                * })
                * class ChildDir {
                * }
                *
                * @Component({
                *   selector: 'main',
                *   template: `<child-dir #c="child"></child-dir>`
                * })
                * class MainComponent {
                * }
                * ```
                *
                */
            exportAs?: string;
            /**
                * Configures the queries that will be injected into the directive.
                *
                * Content queries are set before the `ngAfterContentInit` callback is called.
                * View queries are set before the `ngAfterViewInit` callback is called.
                *
                * @usageNotes
                *
                * The following example shows how queries are defined
                * and when their results are available in lifecycle hooks:
                *
                * ```ts
                * @Component({
                *   selector: 'someDir',
                *   queries: {
                *     contentChildren: new ContentChildren(ChildDirective),
                *     viewChildren: new ViewChildren(ChildDirective)
                *   },
                *   template: '<child-directive></child-directive>'
                * })
                * class SomeDir {
                *   contentChildren: QueryList<ChildDirective>,
                *   viewChildren: QueryList<ChildDirective>
                *
                *   ngAfterContentInit() {
                *     // contentChildren is set
                *   }
                *
                *   ngAfterViewInit() {
                *     // viewChildren is set
                *   }
                * }
                * ```
                *
                * @Annotation
                */
            queries?: {
                    [key: string]: any;
            };
            /**
                * Maps class properties to host element bindings for properties,
                * attributes, and events, using a set of key-value pairs.
                *
                * Angular automatically checks host property bindings during change detection.
                * If a binding changes, Angular updates the directive's host element.
                *
                * When the key is a property of the host element, the property value is
                * the propagated to the specified DOM property.
                *
                * When the key is a static attribute in the DOM, the attribute value
                * is propagated to the specified property in the host element.
                *
                * For event handling:
                * - The key is the DOM event that the directive listens to.
                * To listen to global events, add the target to the event name.
                * The target can be `window`, `document` or `body`.
                * - The value is the statement to execute when the event occurs. If the
                * statement evaluates to `false`, then `preventDefault` is applied on the DOM
                * event. A handler method can refer to the `$event` local variable.
                *
                */
            host?: {
                    [key: string]: string;
            };
            /**
                * When present, this directive/component is ignored by the AOT compiler.
                * It remains in distributed code, and the JIT compiler attempts to compile it
                * at run time, in the browser.
                * To ensure the correct behavior, the app must import `@angular/compiler`.
                */
            jit?: true;
            /**
                * Angular directives marked as `standalone` do not need to be declared in an NgModule. Such
                * directives don't depend on any "intermediate context" of an NgModule (ex. configured
                * providers).
                *
                * More information about standalone components, directives, and pipes can be found in [this
                * guide](guide/standalone-components).
                */
            standalone?: boolean;
            /**
                * Standalone directives that should be applied to the host whenever the directive is matched.
                * By default, none of the inputs or outputs of the host directives will be available on the host,
                * unless they are specified in the `inputs` or `outputs` properties.
                *
                * You can additionally alias inputs and outputs by putting a colon and the alias after the
                * original input or output name. For example, if a directive applied via `hostDirectives`
                * defines an input named `menuDisabled`, you can alias this to `disabled` by adding
                * `'menuDisabled: disabled'` as an entry to `inputs`.
                */
            hostDirectives?: (Type<unknown> | {
                    directive: Type<unknown>;
                    inputs?: string[];
                    outputs?: string[];
            })[];
    }
    
    /**
        * Type of the Directive metadata.
        *
        * @publicApi
        */
    export const Directive: DirectiveDecorator;
    
    /**
        * Type of the Directive decorator / constructor function.
        * @publicApi
        */
    export interface DirectiveDecorator {
            /**
                * Decorator that marks a class as an Angular directive.
                * You can define your own directives to attach custom behavior to elements in the DOM.
                *
                * The options provide configuration metadata that determines
                * how the directive should be processed, instantiated and used at
                * runtime.
                *
                * Directive classes, like component classes, can implement
                * [life-cycle hooks](guide/lifecycle-hooks) to influence their configuration and behavior.
                *
                *
                * @usageNotes
                * To define a directive, mark the class with the decorator and provide metadata.
                *
                * ```ts
                * import {Directive} from '@angular/core';
                *
                * @Directive({
                *   selector: 'my-directive',
                * })
                * export class MyDirective {
                * ...
                * }
                * ```
                *
                * ### Declaring directives
                *
                * In order to make a directive available to other components in your application, you should do
                * one of the following:
                *  - either mark the directive as [standalone](guide/standalone-components),
                *  - or declare it in an NgModule by adding it to the `declarations` and `exports` fields.
                *
                * ** Marking a directive as standalone **
                *
                * You can add the `standalone: true` flag to the Directive decorator metadata to declare it as
                * [standalone](guide/standalone-components):
                *
                * ```ts
                * @Directive({
                *   standalone: true,
                *   selector: 'my-directive',
                * })
                * class MyDirective {}
                * ```
                *
                * When marking a directive as standalone, please make sure that the directive is not already
                * declared in an NgModule.
                *
                *
                * ** Declaring a directive in an NgModule **
                *
                * Another approach is to declare a directive in an NgModule:
                *
                * ```ts
                * @Directive({
                *   selector: 'my-directive',
                * })
                * class MyDirective {}
                *
                * @NgModule({
                *   declarations: [MyDirective, SomeComponent],
                *   exports: [MyDirective], // making it available outside of this module
                * })
                * class SomeNgModule {}
                * ```
                *
                * When declaring a directive in an NgModule, please make sure that:
                *  - the directive is declared in exactly one NgModule.
                *  - the directive is not standalone.
                *  - you do not re-declare a directive imported from another module.
                *  - the directive is included into the `exports` field as well if you want this directive to be
                *    accessible for components outside of the NgModule.
                *
                *
                * @Annotation
                */
            (obj?: Directive): TypeDecorator;
            /**
                * See the `Directive` decorator.
                */
            new (obj?: Directive): Directive;
    }
    
    interface DirectiveDefFeature {
            <T>(directiveDef: ɵDirectiveDef<T>): void;
            /**
                * Marks a feature as something that {@link InheritDefinitionFeature} will execute
                * during inheritance.
                *
                * NOTE: DO NOT SET IN ROOT OF MODULE! Doing so will result in tree-shakers/bundlers
                * identifying the change as a side effect, and the feature will be included in
                * every bundle.
                */
            ngInherit?: true;
    }
    
    interface DirectiveDefinition<T> {
            /**
                * Directive type, needed to configure the injector.
                */
            type: Type<T>;
            /** The selectors that will be used to match nodes to this directive. */
            selectors?: ɵCssSelectorList;
            /**
                * A map of input names.
                *
                * The format is in: `{[actualPropertyName: string]:(string|[string, string])}`.
                *
                * Given:
                * ```
                * class MyComponent {
                *   @Input()
                *   publicInput1: string;
                *
                *   @Input('publicInput2')
                *   declaredInput2: string;
                * }
                * ```
                *
                * is described as:
                * ```
                * {
                *   publicInput1: 'publicInput1',
                *   declaredInput2: ['declaredInput2', 'publicInput2'],
                * }
                * ```
                *
                * Which the minifier may translate to:
                * ```
                * {
                *   minifiedPublicInput1: 'publicInput1',
                *   minifiedDeclaredInput2: [ 'publicInput2', 'declaredInput2'],
                * }
                * ```
                *
                * This allows the render to re-construct the minified, public, and declared names
                * of properties.
                *
                * NOTE:
                *  - Because declared and public name are usually same we only generate the array
                *    `['declared', 'public']` format when they differ.
                *  - The reason why this API and `outputs` API is not the same is that `NgOnChanges` has
                *    inconsistent behavior in that it uses declared names rather than minified or public. For
                *    this reason `NgOnChanges` will be deprecated and removed in future version and this
                *    API will be simplified to be consistent with `output`.
                */
            inputs?: {
                    [P in keyof T]?: string | [string, string];
            };
            /**
                * A map of output names.
                *
                * The format is in: `{[actualPropertyName: string]:string}`.
                *
                * Which the minifier may translate to: `{[minifiedPropertyName: string]:string}`.
                *
                * This allows the render to re-construct the minified and non-minified names
                * of properties.
                */
            outputs?: {
                    [P in keyof T]?: string;
            };
            /**
                * A list of optional features to apply.
                *
                * See: {@link NgOnChangesFeature}, {@link ProvidersFeature}, {@link InheritDefinitionFeature}
                */
            features?: DirectiveDefFeature[];
            /**
                * Function executed by the parent template to allow child directive to apply host bindings.
                */
            hostBindings?: HostBindingsFunction<T>;
            /**
                * The number of bindings in this directive `hostBindings` (including pure fn bindings).
                *
                * Used to calculate the length of the component's LView array, so we
                * can pre-fill the array and set the host binding start index.
                */
            hostVars?: number;
            /**
                * Assign static attribute values to a host element.
                *
                * This property will assign static attribute values as well as class and style
                * values to a host element. Since attribute values can consist of different types of values,
                * the `hostAttrs` array must include the values in the following format:
                *
                * attrs = [
                *   // static attributes (like `title`, `name`, `id`...)
                *   attr1, value1, attr2, value,
                *
                *   // a single namespace value (like `x:id`)
                *   NAMESPACE_MARKER, namespaceUri1, name1, value1,
                *
                *   // another single namespace value (like `x:name`)
                *   NAMESPACE_MARKER, namespaceUri2, name2, value2,
                *
                *   // a series of CSS classes that will be applied to the element (no spaces)
                *   CLASSES_MARKER, class1, class2, class3,
                *
                *   // a series of CSS styles (property + value) that will be applied to the element
                *   STYLES_MARKER, prop1, value1, prop2, value2
                * ]
                *
                * All non-class and non-style attributes must be defined at the start of the list
                * first before all class and style values are set. When there is a change in value
                * type (like when classes and styles are introduced) a marker must be used to separate
                * the entries. The marker values themselves are set via entries found in the
                * [AttributeMarker] enum.
                */
            hostAttrs?: TAttributes;
            /**
                * Function to create instances of content queries associated with a given directive.
                */
            contentQueries?: ContentQueriesFunction<T>;
            /**
                * Additional set of instructions specific to view query processing. This could be seen as a
                * set of instructions to be inserted into the template function.
                */
            viewQuery?: ViewQueriesFunction<T> | null;
            /**
                * Defines the name that can be used in the template to assign this directive to a variable.
                *
                * See: {@link Directive.exportAs}
                */
            exportAs?: string[];
            /**
                * Whether this directive/component is standalone.
                */
            standalone?: boolean;
    }
    
    type DirectiveDefList = (ɵDirectiveDef<any> | ɵComponentDef<any>)[];
    
    /**
        * Type used for directiveDefs on component definition.
        *
        * The function is necessary to be able to support forward declarations.
        */
    type DirectiveDefListOrFactory = (() => DirectiveDefList) | DirectiveDefList;
    
    /**
        * @description
        * Hook for manual bootstrapping of the application instead of using `bootstrap` array in @NgModule
        * annotation. This hook is invoked only when the `bootstrap` array is empty or not provided.
        *
        * Reference to the current application is provided as a parameter.
        *
        * See ["Bootstrapping"](guide/bootstrapping) and ["Entry components"](guide/entry-components).
        *
        * @usageNotes
        * The example below uses `ApplicationRef.bootstrap()` to render the
        * `AppComponent` on the page.
        *
        * ```typescript
        * class AppModule implements DoBootstrap {
        *   ngDoBootstrap(appRef: ApplicationRef) {
        *     appRef.bootstrap(AppComponent); // Or some other component
        *   }
        * }
        * ```
        *
        * @publicApi
        */
    export interface DoBootstrap {
            ngDoBootstrap(appRef: ApplicationRef): void;
    }
    
    /**
        * A lifecycle hook that invokes a custom change-detection function for a directive,
        * in addition to the check performed by the default change-detector.
        *
        * The default change-detection algorithm looks for differences by comparing
        * bound-property values by reference across change detection runs. You can use this
        * hook to check for and respond to changes by some other means.
        *
        * When the default change detector detects changes, it invokes `ngOnChanges()` if supplied,
        * regardless of whether you perform additional change detection.
        * Typically, you should not use both `DoCheck` and `OnChanges` to respond to
        * changes on the same input.
        *
        * @see `OnChanges`
        * @see [Lifecycle hooks guide](guide/lifecycle-hooks)
        *
        * @usageNotes
        * The following snippet shows how a component can implement this interface
        * to invoke it own change-detection cycle.
        *
        * {@example core/ts/metadata/lifecycle_hooks_spec.ts region='DoCheck'}
        *
        * For a more complete example and discussion, see
        * [Defining custom change detection](guide/lifecycle-hooks#defining-custom-change-detection).
        *
        * @publicApi
        */
    export interface DoCheck {
            /**
                * A callback method that performs change-detection, invoked
                * after the default change-detector runs.
                * See `KeyValueDiffers` and `IterableDiffers` for implementing
                * custom change checking for collections.
                *
                */
            ngDoCheck(): void;
    }
    
    /**
        * Marks that the next string is an element name.
        *
        * See `I18nMutateOpCodes` documentation.
        */
    const ELEMENT_MARKER: ELEMENT_MARKER;
    
    interface ELEMENT_MARKER {
            marker: 'element';
    }
    
    /**
        * A wrapper around a native element inside of a View.
        *
        * An `ElementRef` is backed by a render-specific element. In the browser, this is usually a DOM
        * element.
        *
        * @security Permitting direct access to the DOM can make your application more vulnerable to
        * XSS attacks. Carefully review any use of `ElementRef` in your code. For more detail, see the
        * [Security Guide](https://g.co/ng/security).
        *
        * @publicApi
        */
    export class ElementRef<T = any> {
            /**
                * The underlying native element or `null` if direct access to native elements is not supported
                * (e.g. when the application runs in a web worker).
                *
                * <div class="callout is-critical">
                *   <header>Use with caution</header>
                *   <p>
                *    Use this API as the last resort when direct access to DOM is needed. Use templating and
                *    data-binding provided by Angular instead. Alternatively you can take a look at {@link
                * Renderer2}
                *    which provides API that can safely be used even when direct access to native elements is not
                *    supported.
                *   </p>
                *   <p>
                *    Relying on direct DOM access creates tight coupling between your application and rendering
                *    layers which will make it impossible to separate the two and deploy your application into a
                *    web worker.
                *   </p>
                * </div>
                *
                */
            nativeElement: T;
            constructor(nativeElement: T);
    }
    
    const EMBEDDED_VIEW_INJECTOR = 21;
    
    /**
        * Represents an Angular [view](guide/glossary#view) in a view container.
        * An [embedded view](guide/glossary#view-hierarchy) can be referenced from a component
        * other than the hosting component whose template defines it, or it can be defined
        * independently by a `TemplateRef`.
        *
        * Properties of elements in a view can change, but the structure (number and order) of elements in
        * a view cannot. Change the structure of elements by inserting, moving, or
        * removing nested views in a view container.
        *
        * @see `ViewContainerRef`
        *
        * @usageNotes
        *
        * The following template breaks down into two separate `TemplateRef` instances,
        * an outer one and an inner one.
        *
        * ```
        * Count: {{items.length}}
        * <ul>
        *   <li *ngFor="let  item of items">{{item}}</li>
        * </ul>
        * ```
        *
        * This is the outer `TemplateRef`:
        *
        * ```
        * Count: {{items.length}}
        * <ul>
        *   <ng-template ngFor let-item [ngForOf]="items"></ng-template>
        * </ul>
        * ```
        *
        * This is the inner `TemplateRef`:
        *
        * ```
        *   <li>{{item}}</li>
        * ```
        *
        * The outer and inner `TemplateRef` instances are assembled into views as follows:
        *
        * ```
        * <!-- ViewRef: outer-0 -->
        * Count: 2
        * <ul>
        *   <ng-template view-container-ref></ng-template>
        *   <!-- ViewRef: inner-1 --><li>first</li><!-- /ViewRef: inner-1 -->
        *   <!-- ViewRef: inner-2 --><li>second</li><!-- /ViewRef: inner-2 -->
        * </ul>
        * <!-- /ViewRef: outer-0 -->
        * ```
        * @publicApi
        */
    export abstract class EmbeddedViewRef<C> extends ViewRef {
            /**
                * The context for this view, inherited from the anchor element.
                */
            abstract context: C;
            /**
                * The root nodes for this embedded view.
                */
            abstract get rootNodes(): any[];
    }
    
    /**
        * Disable Angular's development mode, which turns off assertions and other
        * checks within the framework.
        *
        * One important assertion this disables verifies that a change detection pass
        * does not result in additional changes to any bindings (also known as
        * unidirectional data flow).
        *
        * Using this method is discouraged as the Angular CLI will set production mode when using the
        * `optimization` option.
        * @see {@link cli/build ng build}
        *
        * @publicApi
        */
    export function enableProdMode(): void;
    
    /**
        * A multi-provider token for initialization functions that will run upon construction of an
        * environment injector.
        *
        * @publicApi
        */
    export const ENVIRONMENT_INITIALIZER: InjectionToken<() => void>;
    
    /**
        * An `Injector` that's part of the environment injector hierarchy, which exists outside of the
        * component tree.
        */
    export abstract class EnvironmentInjector implements Injector {
            /**
                * Retrieves an instance from the injector based on the provided token.
                * @returns The instance from the injector if defined, otherwise the `notFoundValue`.
                * @throws When the `notFoundValue` is `undefined` or `Injector.THROW_IF_NOT_FOUND`.
                */
            abstract get<T>(token: ProviderToken<T>, notFoundValue: undefined, options: InjectOptions & {
                    optional?: false;
            }): T;
            /**
                * Retrieves an instance from the injector based on the provided token.
                * @returns The instance from the injector if defined, otherwise the `notFoundValue`.
                * @throws When the `notFoundValue` is `undefined` or `Injector.THROW_IF_NOT_FOUND`.
                */
            abstract get<T>(token: ProviderToken<T>, notFoundValue: null | undefined, options: InjectOptions): T | null;
            /**
                * Retrieves an instance from the injector based on the provided token.
                * @returns The instance from the injector if defined, otherwise the `notFoundValue`.
                * @throws When the `notFoundValue` is `undefined` or `Injector.THROW_IF_NOT_FOUND`.
                */
            abstract get<T>(token: ProviderToken<T>, notFoundValue?: T, options?: InjectOptions): T;
            /**
                * Retrieves an instance from the injector based on the provided token.
                * @returns The instance from the injector if defined, otherwise the `notFoundValue`.
                * @throws When the `notFoundValue` is `undefined` or `Injector.THROW_IF_NOT_FOUND`.
                * @deprecated use object-based flags (`InjectOptions`) instead.
                */
            abstract get<T>(token: ProviderToken<T>, notFoundValue?: T, flags?: InjectFlags): T;
            /**
                * @deprecated from v4.0.0 use ProviderToken<T>
                * @suppress {duplicate}
                */
            abstract get(token: any, notFoundValue?: any): any;
            /**
                * Runs the given function in the context of this `EnvironmentInjector`.
                *
                * Within the function's stack frame, `inject` can be used to inject dependencies from this
                * injector. Note that `inject` is only usable synchronously, and cannot be used in any
                * asynchronous callbacks or after any `await` points.
                *
                * @param fn the closure to be run in the context of this injector
                * @returns the return value of the function, if any
                */
            abstract runInContext<ReturnT>(fn: () => ReturnT): ReturnT;
            abstract destroy(): void;
    }
    
    /**
        * Encapsulated `Provider`s that are only accepted during creation of an `EnvironmentInjector` (e.g.
        * in an `NgModule`).
        *
        * Using this wrapper type prevents providers which are only designed to work in
        * application/environment injectors from being accidentally included in
        * `@Component.providers` and ending up in a component injector.
        *
        * This wrapper type prevents access to the `Provider`s inside.
        *
        * @see `makeEnvironmentProviders`
        * @see `importProvidersFrom`
        *
        * @publicApi
        */
    export type EnvironmentProviders = {
            ɵbrand: 'EnvironmentProviders';
    };
    
    
    /**
        * Provides a hook for centralized exception handling.
        *
        * The default implementation of `ErrorHandler` prints error messages to the `console`. To
        * intercept error handling, write a custom exception handler that replaces this default as
        * appropriate for your app.
        *
        * @usageNotes
        * ### Example
        *
        * ```
        * class MyErrorHandler implements ErrorHandler {
        *   handleError(error) {
        *     // do something with the exception
        *   }
        * }
        *
        * @NgModule({
        *   providers: [{provide: ErrorHandler, useClass: MyErrorHandler}]
        * })
        * class MyModule {}
        * ```
        *
        * @publicApi
        */
    export class ErrorHandler {
            handleError(error: any): void;
    }
    
    /**
        * Use in components with the `@Output` directive to emit custom events
        * synchronously or asynchronously, and register handlers for those events
        * by subscribing to an instance.
        *
        * @usageNotes
        *
        * Extends
        * [RxJS `Subject`](https://rxjs.dev/api/index/class/Subject)
        * for Angular by adding the `emit()` method.
        *
        * In the following example, a component defines two output properties
        * that create event emitters. When the title is clicked, the emitter
        * emits an open or close event to toggle the current visibility state.
        *
        * ```html
        * @Component({
        *   selector: 'zippy',
        *   template: `
        *   <div class="zippy">
        *     <div (click)="toggle()">Toggle</div>
        *     <div [hidden]="!visible">
        *       <ng-content></ng-content>
        *     </div>
        *  </div>`})
        * export class Zippy {
        *   visible: boolean = true;
        *   @Output() open: EventEmitter<any> = new EventEmitter();
        *   @Output() close: EventEmitter<any> = new EventEmitter();
        *
        *   toggle() {
        *     this.visible = !this.visible;
        *     if (this.visible) {
        *       this.open.emit(null);
        *     } else {
        *       this.close.emit(null);
        *     }
        *   }
        * }
        * ```
        *
        * Access the event object with the `$event` argument passed to the output event
        * handler:
        *
        * ```html
        * <zippy (open)="onOpen($event)" (close)="onClose($event)"></zippy>
        * ```
        *
        * @see [Observables in Angular](guide/observables-in-angular)
        * @publicApi
        */
    export interface EventEmitter<T> extends Subject<T> {
            /**
                * Creates an instance of this class that can
                * deliver events synchronously or asynchronously.
                *
                * @param [isAsync=false] When true, deliver events asynchronously.
                *
                */
            new (isAsync?: boolean): EventEmitter<T>;
            /**
                * Emits an event containing a given value.
                * @param value The value to emit.
                */
            emit(value?: T): void;
            /**
                * Registers handlers for events emitted by this instance.
                * @param next When supplied, a custom handler for emitted events.
                * @param error When supplied, a custom handler for an error notification from this emitter.
                * @param complete When supplied, a custom handler for a completion notification from this
                *     emitter.
                */
            subscribe(next?: (value: T) => void, error?: (error: any) => void, complete?: () => void): Subscription;
            /**
                * Registers handlers for events emitted by this instance.
                * @param observerOrNext When supplied, a custom handler for emitted events, or an observer
                *     object.
                * @param error When supplied, a custom handler for an error notification from this emitter.
                * @param complete When supplied, a custom handler for a completion notification from this
                *     emitter.
                */
            subscribe(observerOrNext?: any, error?: any, complete?: any): Subscription;
    }
    
    /**
        * @publicApi
        */
    export const EventEmitter: {
            new (isAsync?: boolean): EventEmitter<any>;
            new <T>(isAsync?: boolean): EventEmitter<T>;
            readonly prototype: EventEmitter<any>;
    };
    
    /**
        * Configures the `Injector` to return a value of another `useExisting` token.
        *
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @usageNotes
        *
        * {@example core/di/ts/provider_spec.ts region='ExistingProvider'}
        *
        * ### Multi-value example
        *
        * {@example core/di/ts/provider_spec.ts region='MultiProviderAspect'}
        *
        * @publicApi
        */
    export interface ExistingProvider extends ExistingSansProvider {
            /**
                * An injection token. Typically an instance of `Type` or `InjectionToken`, but can be `any`.
                */
            provide: any;
            /**
                * When true, injector returns an array of instances. This is useful to allow multiple
                * providers spread across many files to provide configuration information to a common token.
                */
            multi?: boolean;
    }
    
    /**
        * Configures the `Injector` to return a value of another `useExisting` token.
        *
        * @see `ExistingProvider`
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @publicApi
        */
    export interface ExistingSansProvider {
            /**
                * Existing `token` to return. (Equivalent to `injector.get(useExisting)`)
                */
            useExisting: any;
    }
    
    /**
        * Definition of what a factory function should look like.
        */
    type FactoryFn<T> = {
            /**
                * Subclasses without an explicit constructor call through to the factory of their base
                * definition, providing it with their own constructor to instantiate.
                */
            <U extends T>(t?: Type<U>): U;
            /**
                * If no constructor to instantiate is provided, an instance of type T itself is created.
                */
            (t?: undefined): T;
    };
    
    /**
        * Configures the `Injector` to return a value by invoking a `useFactory` function.
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @usageNotes
        *
        * {@example core/di/ts/provider_spec.ts region='FactoryProvider'}
        *
        * Dependencies can also be marked as optional:
        *
        * {@example core/di/ts/provider_spec.ts region='FactoryProviderOptionalDeps'}
        *
        * ### Multi-value example
        *
        * {@example core/di/ts/provider_spec.ts region='MultiProviderAspect'}
        *
        * @publicApi
        */
    export interface FactoryProvider extends FactorySansProvider {
            /**
                * An injection token. (Typically an instance of `Type` or `InjectionToken`, but can be `any`).
                */
            provide: any;
            /**
                * When true, injector returns an array of instances. This is useful to allow multiple
                * providers spread across many files to provide configuration information to a common token.
                */
            multi?: boolean;
    }
    
    /**
        * Configures the `Injector` to return a value by invoking a `useFactory` function.
        *
        * @see `FactoryProvider`
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @publicApi
        */
    export interface FactorySansProvider {
            /**
                * A function to invoke to create a value for this `token`. The function is invoked with
                * resolved values of `token`s in the `deps` field.
                */
            useFactory: Function;
            /**
                * A list of `token`s to be resolved by the injector. The list of values is then
                * used as arguments to the `useFactory` function.
                */
            deps?: any[];
    }
    
    const FLAGS = 2;
    
    /**
        * Allows to refer to references which are not yet defined.
        *
        * For instance, `forwardRef` is used when the `token` which we need to refer to for the purposes of
        * DI is declared, but not yet defined. It is also used when the `token` which we use when creating
        * a query is not yet defined.
        *
        * @usageNotes
        * ### Example
        * {@example core/di/ts/forward_ref/forward_ref_spec.ts region='forward_ref'}
        * @publicApi
        */
    export function forwardRef(forwardRefFn: ForwardRefFn): Type<any>;
    
    /**
        * An interface that a function passed into {@link forwardRef} has to implement.
        *
        * @usageNotes
        * ### Example
        *
        * {@example core/di/ts/forward_ref/forward_ref_spec.ts region='forward_ref_fn'}
        * @publicApi
        */
    export interface ForwardRefFn {
            (): any;
    }
    
    /**
        * @publicApi
        */
    function getDebugNode(nativeNode: any): DebugNode | null;
    export { getDebugNode }
    export { getDebugNode as ɵgetDebugNode }
    
    /**
        * Returns the NgModuleFactory with the given id (specified using [@NgModule.id
        * field](api/core/NgModule#id)), if it exists and has been loaded. Factories for NgModules that do
        * not specify an `id` cannot be retrieved. Throws if an NgModule cannot be found.
        * @publicApi
        * @deprecated Use `getNgModuleById` instead.
        */
    export function getModuleFactory(id: string): NgModuleFactory<any>;
    
    /**
        * Returns the NgModule class with the given id (specified using [@NgModule.id
        * field](api/core/NgModule#id)), if it exists and has been loaded. Classes for NgModules that do
        * not specify an `id` cannot be retrieved. Throws if an NgModule cannot be found.
        * @publicApi
        */
    export function getNgModuleById<T>(id: string): Type<T>;
    
    /**
        * Returns the current platform.
        *
        * @publicApi
        */
    export function getPlatform(): PlatformRef | null;
    
    /**
        * Adapter interface for retrieving the `Testability` service associated for a
        * particular context.
        *
        * @publicApi
        */
    export interface GetTestability {
            addToWindow(registry: TestabilityRegistry): void;
            findTestabilityInTree(registry: TestabilityRegistry, elem: any, findInAncestors: boolean): Testability | null;
    }
    
    /**
        * The goal here is to make sure that the browser DOM API is the Renderer.
        * We do this by defining a subset of DOM API to be the renderer and then
        * use that at runtime for rendering.
        *
        * At runtime we can then use the DOM api directly, in server or web-worker
        * it will be easy to implement such API.
        */
    type GlobalTargetName = 'document' | 'window' | 'body';
    
    type GlobalTargetResolver = (element: any) => EventTarget;
    
    /**
        * Flag to signify that this `LContainer` may have transplanted views which need to be change
        * detected. (see: `LView[DECLARATION_COMPONENT_VIEW])`.
        *
        * This flag, once set, is never unset for the `LContainer`. This means that when unset we can skip
        * a lot of work in `refreshEmbeddedViews`. But when set we still need to verify
        * that the `MOVED_VIEWS` are transplanted and on-push.
        */
    const HAS_TRANSPLANTED_VIEWS = 2;
    
    /**
        * Array of hooks that should be executed for a view and their directive indices.
        *
        * For each node of the view, the following data is stored:
        * 1) Node index (optional)
        * 2) A series of number/function pairs where:
        *  - even indices are directive indices
        *  - odd indices are hook functions
        *
        * Special cases:
        *  - a negative directive index flags an init hook (ngOnInit, ngAfterContentInit, ngAfterViewInit)
        */
    type HookData = HookEntry[];
    
    /**
        * Information necessary to call a hook. E.g. the callback that
        * needs to invoked and the index at which to find its context.
        */
    type HookEntry = number | HookFn;
    
    /** Single hook callback function. */
    type HookFn = () => void;
    
    const HOST = 0;
    
    /**
        * Type of the Host metadata.
        *
        * @publicApi
        */
    export interface Host {
    }
    
    /**
        * Host decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const Host: HostDecorator;
    
    /**
        * Type of the HostBinding metadata.
        *
        * @publicApi
        */
    export interface HostBinding {
            /**
                * The DOM property that is bound to a data property.
                */
            hostPropertyName?: string;
    }
    
    /**
        * @Annotation
        * @publicApi
        */
    export const HostBinding: HostBindingDecorator;
    
    /**
        * Type of the HostBinding decorator / constructor function.
        *
        * @publicApi
        */
    export interface HostBindingDecorator {
            /**
                * Decorator that marks a DOM property as a host-binding property and supplies configuration
                * metadata.
                * Angular automatically checks host property bindings during change detection, and
                * if a binding changes it updates the host element of the directive.
                *
                * @usageNotes
                *
                * The following example creates a directive that sets the `valid` and `invalid`
                * properties on the DOM element that has an `ngModel` directive on it.
                *
                * ```typescript
                * @Directive({selector: '[ngModel]'})
                * class NgModelStatus {
                *   constructor(public control: NgModel) {}
                *   @HostBinding('class.valid') get valid() { return this.control.valid; }
                *   @HostBinding('class.invalid') get invalid() { return this.control.invalid; }
                * }
                *
                * @Component({
                *   selector: 'app',
                *   template: `<input [(ngModel)]="prop">`,
                * })
                * class App {
                *   prop;
                * }
                * ```
                *
                */
            (hostPropertyName?: string): any;
            new (hostPropertyName?: string): any;
    }
    
    /**
        * Stores a set of OpCodes to process `HostBindingsFunction` associated with a current view.
        *
        * In order to invoke `HostBindingsFunction` we need:
        * 1. 'elementIdx`: Index to the element associated with the `HostBindingsFunction`.
        * 2. 'directiveIdx`: Index to the directive associated with the `HostBindingsFunction`. (This will
        *    become the context for the `HostBindingsFunction` invocation.)
        * 3. `bindingRootIdx`: Location where the bindings for the `HostBindingsFunction` start. Internally
        *    `HostBindingsFunction` binding indexes start from `0` so we need to add `bindingRootIdx` to
        *    it.
        * 4. `HostBindingsFunction`: A host binding function to execute.
        *
        * The above information needs to be encoded into the `HostBindingOpCodes` in an efficient manner.
        *
        * 1. `elementIdx` is encoded into the `HostBindingOpCodes` as `~elementIdx` (so a negative number);
        * 2. `directiveIdx`
        * 3. `bindingRootIdx`
        * 4. `HostBindingsFunction` is passed in as is.
        *
        * The `HostBindingOpCodes` array contains:
        * - negative number to select the element index.
        * - followed by 1 or more of:
        *    - a number to select the directive index
        *    - a number to select the bindingRoot index
        *    - and a function to invoke.
        *
        * ## Example
        *
        * ```
        * const hostBindingOpCodes = [
        *   ~30,                               // Select element 30
        *   40, 45, MyDir.ɵdir.hostBindings    // Invoke host bindings on MyDir on element 30;
        *                                      // directiveIdx = 40; bindingRootIdx = 45;
        *   50, 55, OtherDir.ɵdir.hostBindings // Invoke host bindings on OtherDire on element 30
        *                                      // directiveIdx = 50; bindingRootIdx = 55;
        * ]
        * ```
        *
        * ## Pseudocode
        * ```
        * const hostBindingOpCodes = tView.hostBindingOpCodes;
        * if (hostBindingOpCodes === null) return;
        * for (let i = 0; i < hostBindingOpCodes.length; i++) {
        *   const opCode = hostBindingOpCodes[i] as number;
        *   if (opCode < 0) {
        *     // Negative numbers are element indexes.
        *     setSelectedIndex(~opCode);
        *   } else {
        *     // Positive numbers are NumberTuple which store bindingRootIndex and directiveIndex.
        *     const directiveIdx = opCode;
        *     const bindingRootIndx = hostBindingOpCodes[++i] as number;
        *     const hostBindingFn = hostBindingOpCodes[++i] as HostBindingsFunction<any>;
        *     setBindingRootForHostBindings(bindingRootIndx, directiveIdx);
        *     const context = lView[directiveIdx];
        *     hostBindingFn(RenderFlags.Update, context);
        *   }
        * }
        * ```
        *
        */
    interface HostBindingOpCodes extends Array<number | HostBindingsFunction<any>> {
            __brand__: 'HostBindingOpCodes';
            debug?: string[];
    }
    
    type HostBindingsFunction<T> = <U extends T>(rf: ɵRenderFlags, ctx: U) => void;
    
    /**
        * Type of the `Host` decorator / constructor function.
        *
        * @publicApi
        */
    export interface HostDecorator {
            /**
                * Parameter decorator on a view-provider parameter of a class constructor
                * that tells the DI framework to resolve the view by checking injectors of child
                * elements, and stop when reaching the host element of the current component.
                *
                * @usageNotes
                *
                * The following shows use with the `@Optional` decorator, and allows for a `null` result.
                *
                * <code-example path="core/di/ts/metadata_spec.ts" region="Host">
                * </code-example>
                *
                * For an extended example, see ["Dependency Injection
                * Guide"](guide/dependency-injection-in-action#optional).
                */
            (): any;
            new (): Host;
    }
    
    /**
        * Mapping between the public aliases of directive bindings and the underlying inputs/outputs that
        * they represent. Also serves as an allowlist of the inputs/outputs from the host directive that
        * the author has decided to expose.
        */
    type HostDirectiveBindingMap = {
            [publicName: string]: string;
    };
    
    /** Values that can be used to define a host directive through the `HostDirectivesFeature`. */
    type HostDirectiveConfig = Type<unknown> | {
            directive: Type<unknown>;
            inputs?: string[];
            outputs?: string[];
    };
    
    /** Runtime information used to configure a host directive. */
    interface HostDirectiveDef<T = unknown> {
            /** Class representing the host directive. */
            directive: Type<T>;
            /** Directive inputs that have been exposed. */
            inputs: HostDirectiveBindingMap;
            /** Directive outputs that have been exposed. */
            outputs: HostDirectiveBindingMap;
    }
    
    /**
        * Mapping between a directive that was used as a host directive
        * and the configuration that was used to define it as such.
        */
    type HostDirectiveDefs = Map<ɵDirectiveDef<unknown>, HostDirectiveDef>;
    
    /**
        * Type of the HostListener metadata.
        *
        * @publicApi
        */
    export interface HostListener {
            /**
                * The DOM event to listen for.
                */
            eventName?: string;
            /**
                * A set of arguments to pass to the handler method when the event occurs.
                */
            args?: string[];
    }
    
    /**
        * Decorator that binds a DOM event to a host listener and supplies configuration metadata.
        * Angular invokes the supplied handler method when the host element emits the specified event,
        * and updates the bound element with the result.
        *
        * If the handler method returns false, applies `preventDefault` on the bound element.
        *
        * @usageNotes
        *
        * The following example declares a directive
        * that attaches a click listener to a button and counts clicks.
        *
        * ```ts
        * @Directive({selector: 'button[counting]'})
        * class CountClicks {
        *   numberOfClicks = 0;
        *
        *   @HostListener('click', ['$event.target'])
        *   onClick(btn) {
        *     console.log('button', btn, 'number of clicks:', this.numberOfClicks++);
        *   }
        * }
        *
        * @Component({
        *   selector: 'app',
        *   template: '<button counting>Increment</button>',
        * })
        * class App {}
        *
        * ```
        *
        * The following example registers another DOM event handler that listens for `Enter` key-press
        * events on the global `window`.
        * ``` ts
        * import { HostListener, Component } from "@angular/core";
        *
        * @Component({
        *   selector: 'app',
        *   template: `<h1>Hello, you have pressed enter {{counter}} number of times!</h1> Press enter key
        * to increment the counter.
        *   <button (click)="resetCounter()">Reset Counter</button>`
        * })
        * class AppComponent {
        *   counter = 0;
        *   @HostListener('window:keydown.enter', ['$event'])
        *   handleKeyDown(event: KeyboardEvent) {
        *     this.counter++;
        *   }
        *   resetCounter() {
        *     this.counter = 0;
        *   }
        * }
        * ```
        * The list of valid key names for `keydown` and `keyup` events
        * can be found here:
        * https://www.w3.org/TR/DOM-Level-3-Events-key/#named-key-attribute-values
        *
        * Note that keys can also be combined, e.g. `@HostListener('keydown.shift.a')`.
        *
        * The global target names that can be used to prefix an event name are
        * `document:`, `window:` and `body:`.
        *
        * @Annotation
        * @publicApi
        */
    export const HostListener: HostListenerDecorator;
    
    /**
        * Type of the HostListener decorator / constructor function.
        *
        * @publicApi
        */
    export interface HostListenerDecorator {
            /**
                * Decorator that declares a DOM event to listen for,
                * and provides a handler method to run when that event occurs.
                *
                * Angular invokes the supplied handler method when the host element emits the specified event,
                * and updates the bound element with the result.
                *
                * If the handler method returns false, applies `preventDefault` on the bound element.
                */
            (eventName: string, args?: string[]): any;
            new (eventName: string, args?: string[]): any;
    }
    
    namespace i0 {
            export {
                    ɵɵinject,
                    ɵɵdefineInjectable,
                    ɵɵdefineInjector,
                    ɵɵInjectableDeclaration,
                    ɵNgModuleDef as NgModuleDef,
                    ɵɵdefineNgModule,
                    ɵɵFactoryDeclaration,
                    ɵɵInjectorDeclaration,
                    ɵɵNgModuleDeclaration,
                    ɵsetClassMetadata as setClassMetadata,
                    ɵNgModuleFactory as NgModuleFactory,
                    ɵnoSideEffects,
                    ITS_JUST_ANGULAR
            }
    }
    
    /**
        * Array storing OpCode for dynamically creating `i18n` translation DOM elements.
        *
        * This array creates a sequence of `Text` and `Comment` (as ICU anchor) DOM elements. It consists
        * of a pair of `number` and `string` pairs which encode the operations for the creation of the
        * translated block.
        *
        * The number is shifted and encoded according to `I18nCreateOpCode`
        *
        * Pseudocode:
        * ```
        * const i18nCreateOpCodes = [
        *   10 << I18nCreateOpCode.SHIFT, "Text Node add to DOM",
        *   11 << I18nCreateOpCode.SHIFT | I18nCreateOpCode.COMMENT, "Comment Node add to DOM",
        *   12 << I18nCreateOpCode.SHIFT | I18nCreateOpCode.APPEND_LATER, "Text Node added later"
        * ];
        *
        * for(var i=0; i<i18nCreateOpCodes.length; i++) {
        *   const opcode = i18NCreateOpCodes[i++];
        *   const index = opcode >> I18nCreateOpCode.SHIFT;
        *   const text = i18NCreateOpCodes[i];
        *   let node: Text|Comment;
        *   if (opcode & I18nCreateOpCode.COMMENT === I18nCreateOpCode.COMMENT) {
        *     node = lView[~index] = document.createComment(text);
        *   } else {
        *     node = lView[index] = document.createText(text);
        *   }
        *   if (opcode & I18nCreateOpCode.APPEND_EAGERLY !== I18nCreateOpCode.APPEND_EAGERLY) {
        *     parentNode.appendChild(node);
        *   }
        * }
        * ```
        */
    interface I18nCreateOpCodes extends Array<number | string>, I18nDebug {
            __brand__: 'I18nCreateOpCodes';
    }
    
    interface I18nDebug {
            /**
                * Human readable representation of the OpCode arrays.
                *
                * NOTE: This property only exists if `ngDevMode` is set to `true` and it is not present in
                * production. Its presence is purely to help debug issue in development, and should not be relied
                * on in production application.
                */
            debug?: string[];
    }
    
    /**
        * Stores a list of nodes which need to be removed.
        *
        * Numbers are indexes into the `LView`
        * - index > 0: `removeRNode(lView[0])`
        * - index < 0: `removeICU(~lView[0])`
        */
    interface I18nRemoveOpCodes extends Array<number> {
            __brand__: 'I18nRemoveOpCodes';
    }
    
    /**
        * Stores DOM operations which need to be applied to update DOM render tree due to changes in
        * expressions.
        *
        * The basic idea is that `i18nExp` OpCodes capture expression changes and update a change
        * mask bit. (Bit 1 for expression 1, bit 2 for expression 2 etc..., bit 32 for expression 32 and
        * higher.) The OpCodes then compare its own change mask against the expression change mask to
        * determine if the OpCodes should execute.
        *
        * NOTE: 32nd bit is special as it says 32nd or higher. This way if we have more than 32 bindings
        * the code still works, but with lower efficiency. (it is unlikely that a translation would have
        * more than 32 bindings.)
        *
        * These OpCodes can be used by both the i18n block as well as ICU sub-block.
        *
        * ## Example
        *
        * Assume
        * ```ts
        *   if (rf & RenderFlags.Update) {
        *    i18nExp(ctx.exp1); // If changed set mask bit 1
        *    i18nExp(ctx.exp2); // If changed set mask bit 2
        *    i18nExp(ctx.exp3); // If changed set mask bit 3
        *    i18nExp(ctx.exp4); // If changed set mask bit 4
        *    i18nApply(0);            // Apply all changes by executing the OpCodes.
        *  }
        * ```
        * We can assume that each call to `i18nExp` sets an internal `changeMask` bit depending on the
        * index of `i18nExp`.
        *
        * ### OpCodes
        * ```ts
        * <I18nUpdateOpCodes>[
        *   // The following OpCodes represent: `<div i18n-title="pre{{exp1}}in{{exp2}}post">`
        *   // If `changeMask & 0b11`
        *   //        has changed then execute update OpCodes.
        *   //        has NOT changed then skip `8` values and start processing next OpCodes.
        *   0b11, 8,
        *   // Concatenate `newValue = 'pre'+lView[bindIndex-4]+'in'+lView[bindIndex-3]+'post';`.
        *   'pre', -4, 'in', -3, 'post',
        *   // Update attribute: `elementAttribute(1, 'title', sanitizerFn(newValue));`
        *   1 << SHIFT_REF | Attr, 'title', sanitizerFn,
        *
        *   // The following OpCodes represent: `<div i18n>Hello {{exp3}}!">`
        *   // If `changeMask & 0b100`
        *   //        has changed then execute update OpCodes.
        *   //        has NOT changed then skip `4` values and start processing next OpCodes.
        *   0b100, 4,
        *   // Concatenate `newValue = 'Hello ' + lView[bindIndex -2] + '!';`.
        *   'Hello ', -2, '!',
        *   // Update text: `lView[1].textContent = newValue;`
        *   1 << SHIFT_REF | Text,
        *
        *   // The following OpCodes represent: `<div i18n>{exp4, plural, ... }">`
        *   // If `changeMask & 0b1000`
        *   //        has changed then execute update OpCodes.
        *   //        has NOT changed then skip `2` values and start processing next OpCodes.
        *   0b1000, 2,
        *   // Concatenate `newValue = lView[bindIndex -1];`.
        *   -1,
        *   // Switch ICU: `icuSwitchCase(lView[1], 0, newValue);`
        *   0 << SHIFT_ICU | 1 << SHIFT_REF | IcuSwitch,
        *
        *   // Note `changeMask & -1` is always true, so the IcuUpdate will always execute.
        *   -1, 1,
        *   // Update ICU: `icuUpdateCase(lView[1], 0);`
        *   0 << SHIFT_ICU | 1 << SHIFT_REF | IcuUpdate,
        *
        * ];
        * ```
        *
        */
    interface I18nUpdateOpCodes extends Array<string | number | SanitizerFn | null>, I18nDebug {
            __brand__: 'I18nUpdateOpCodes';
    }
    
    /**
        * Marks that the next string is comment text need for ICU.
        *
        * See `I18nMutateOpCodes` documentation.
        */
    const ICU_MARKER: ICU_MARKER;
    
    interface ICU_MARKER {
            marker: 'ICU';
    }
    
    /**
        * Array storing OpCode for dynamically creating `i18n` blocks.
        *
        * Example:
        * ```ts
        * <I18nCreateOpCode>[
        *   // For adding text nodes
        *   // ---------------------
        *   // Equivalent to:
        *   //   lView[1].appendChild(lView[0] = document.createTextNode('xyz'));
        *   'xyz', 0, 1 << SHIFT_PARENT | 0 << SHIFT_REF | AppendChild,
        *
        *   // For adding element nodes
        *   // ---------------------
        *   // Equivalent to:
        *   //   lView[1].appendChild(lView[0] = document.createElement('div'));
        *   ELEMENT_MARKER, 'div', 0, 1 << SHIFT_PARENT | 0 << SHIFT_REF | AppendChild,
        *
        *   // For adding comment nodes
        *   // ---------------------
        *   // Equivalent to:
        *   //   lView[1].appendChild(lView[0] = document.createComment(''));
        *   ICU_MARKER, '', 0, 1 << SHIFT_PARENT | 0 << SHIFT_REF | AppendChild,
        *
        *   // For moving existing nodes to a different location
        *   // --------------------------------------------------
        *   // Equivalent to:
        *   //   const node = lView[1];
        *   //   lView[2].appendChild(node);
        *   1 << SHIFT_REF | Select, 2 << SHIFT_PARENT | 0 << SHIFT_REF | AppendChild,
        *
        *   // For removing existing nodes
        *   // --------------------------------------------------
        *   //   const node = lView[1];
        *   //   removeChild(tView.data(1), node, lView);
        *   1 << SHIFT_REF | Remove,
        *
        *   // For writing attributes
        *   // --------------------------------------------------
        *   //   const node = lView[1];
        *   //   node.setAttribute('attr', 'value');
        *   1 << SHIFT_REF | Attr, 'attr', 'value'
        * ];
        * ```
        */
    interface IcuCreateOpCodes extends Array<number | string | ELEMENT_MARKER | ICU_MARKER | null>, I18nDebug {
            __brand__: 'I18nCreateOpCodes';
    }
    
    /**
        * Defines the ICU type of `select` or `plural`
        */
    const enum IcuType {
            select = 0,
            plural = 1
    }
    
    const ID = 20;
    
    /**
        * Providers that were imported from NgModules via the `importProvidersFrom` function.
        *
        * These providers are meant for use in an application injector (or other environment injectors) and
        * should not be used in component injectors.
        *
        * This type cannot be directly implemented. It's returned from the `importProvidersFrom` function
        * and serves to prevent the extracted NgModule providers from being used in the wrong contexts.
        *
        * @see `importProvidersFrom`
        *
        * @publicApi
        * @deprecated replaced by `EnvironmentProviders`
        */
    export type ImportedNgModuleProviders = EnvironmentProviders;
    
    /**
        * Collects providers from all NgModules and standalone components, including transitively imported
        * ones.
        *
        * Providers extracted via `importProvidersFrom` are only usable in an application injector or
        * another environment injector (such as a route injector). They should not be used in component
        * providers.
        *
        * More information about standalone components can be found in [this
        * guide](guide/standalone-components).
        *
        * @usageNotes
        * The results of the `importProvidersFrom` call can be used in the `bootstrapApplication` call:
        *
        * ```typescript
        * await bootstrapApplication(RootComponent, {
        *   providers: [
        *     importProvidersFrom(NgModuleOne, NgModuleTwo)
        *   ]
        * });
        * ```
        *
        * You can also use the `importProvidersFrom` results in the `providers` field of a route, when a
        * standalone component is used:
        *
        * ```typescript
        * export const ROUTES: Route[] = [
        *   {
        *     path: 'foo',
        *     providers: [
        *       importProvidersFrom(NgModuleOne, NgModuleTwo)
        *     ],
        *     component: YourStandaloneComponent
        *   }
        * ];
        * ```
        *
        * @returns Collected providers from the specified list of types.
        * @publicApi
        */
    export function importProvidersFrom(...sources: ImportProvidersSource[]): EnvironmentProviders;
    
    /**
        * A source of providers for the `importProvidersFrom` function.
        *
        * @publicApi
        */
    export type ImportProvidersSource = Type<unknown> | ModuleWithProviders<unknown> | Array<ImportProvidersSource>;
    
    /**
        * This array contains information about input properties that
        * need to be set once from attribute data. It's ordered by
        * directive index (relative to element) so it's simple to
        * look up a specific directive's initial input data.
        *
        * Within each sub-array:
        *
        * i+0: attribute name
        * i+1: minified/internal input name
        * i+2: initial value
        *
        * If a directive on a node does not have any input properties
        * that should be set from attributes, its index is set to null
        * to avoid a sparse array.
        *
        * e.g. [null, ['role-min', 'minified-input', 'button']]
        */
    type InitialInputData = (InitialInputs | null)[];
    
    /**
        * Used by InitialInputData to store input properties
        * that should be set once from attributes.
        *
        * i+0: attribute name
        * i+1: minified/internal input name
        * i+2: initial value
        *
        * e.g. ['role-min', 'minified-input', 'button']
        */
    type InitialInputs = string[];
    
    /**
        * Type of the Inject metadata.
        *
        * @publicApi
        */
    export interface Inject {
            /**
                * A [DI token](guide/glossary#di-token) that maps to the dependency to be injected.
                */
            token: any;
    }
    
    /**
        * Inject decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const Inject: InjectDecorator;
    
    /**
        * @param token A token that represents a dependency that should be injected.
        * @returns the injected value if operation is successful, `null` otherwise.
        * @throws if called outside of a supported context.
        *
        * @publicApi
        */
    export function inject<T>(token: ProviderToken<T>): T;
    
    /**
        * @param token A token that represents a dependency that should be injected.
        * @param flags Control how injection is executed. The flags correspond to injection strategies that
        *     can be specified with parameter decorators `@Host`, `@Self`, `@SkipSelf`, and `@Optional`.
        * @returns the injected value if operation is successful, `null` otherwise.
        * @throws if called outside of a supported context.
        *
        * @publicApi
        * @deprecated prefer an options object instead of `InjectFlags`
        */
    export function inject<T>(token: ProviderToken<T>, flags?: InjectFlags): T | null;
    
    /**
        * @param token A token that represents a dependency that should be injected.
        * @param options Control how injection is executed. Options correspond to injection strategies
        *     that can be specified with parameter decorators `@Host`, `@Self`, `@SkipSelf`, and
        *     `@Optional`.
        * @returns the injected value if operation is successful.
        * @throws if called outside of a supported context, or if the token is not found.
        *
        * @publicApi
        */
    export function inject<T>(token: ProviderToken<T>, options: InjectOptions & {
            optional?: false;
    }): T;
    
    /**
        * @param token A token that represents a dependency that should be injected.
        * @param options Control how injection is executed. Options correspond to injection strategies
        *     that can be specified with parameter decorators `@Host`, `@Self`, `@SkipSelf`, and
        *     `@Optional`.
        * @returns the injected value if operation is successful,  `null` if the token is not
        *     found and optional injection has been requested.
        * @throws if called outside of a supported context, or if the token is not found and optional
        *     injection was not requested.
        *
        * @publicApi
        */
    export function inject<T>(token: ProviderToken<T>, options: InjectOptions): T | null;
    
    /**
        * Type of the Injectable metadata.
        *
        * @publicApi
        */
    export interface Injectable {
            /**
                * Determines which injectors will provide the injectable.
                *
                * - `Type<any>` - associates the injectable with an `@NgModule` or other `InjectorType`. This
                * option is DEPRECATED.
                * - 'null' : Equivalent to `undefined`. The injectable is not provided in any scope automatically
                * and must be added to a `providers` array of an [@NgModule](api/core/NgModule#providers),
                * [@Component](api/core/Directive#providers) or [@Directive](api/core/Directive#providers).
                *
                * The following options specify that this injectable should be provided in one of the following
                * injectors:
                * - 'root' : The application-level injector in most apps.
                * - 'platform' : A special singleton platform injector shared by all
                * applications on the page.
                * - 'any' : Provides a unique instance in each lazy loaded module while all eagerly loaded
                * modules share one instance. This option is DEPRECATED.
                *
                */
            providedIn?: Type<any> | 'root' | 'platform' | 'any' | null;
    }
    
    /**
        * Injectable decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const Injectable: InjectableDecorator;
    
    /**
        * Type of the Injectable decorator / constructor function.
        *
        * @publicApi
        */
    export interface InjectableDecorator {
            /**
                * Decorator that marks a class as available to be
                * provided and injected as a dependency.
                *
                * @see [Introduction to Services and DI](guide/architecture-services)
                * @see [Dependency Injection Guide](guide/dependency-injection)
                *
                * @usageNotes
                *
                * Marking a class with `@Injectable` ensures that the compiler
                * will generate the necessary metadata to create the class's
                * dependencies when the class is injected.
                *
                * The following example shows how a service class is properly
                *  marked so that a supporting service can be injected upon creation.
                *
                * <code-example path="core/di/ts/metadata_spec.ts" region="Injectable"></code-example>
                *
                */
            (): TypeDecorator;
            (options?: {
                    providedIn: Type<any> | 'root' | 'platform' | 'any' | null;
            } & InjectableProvider): TypeDecorator;
            new (): Injectable;
            new (options?: {
                    providedIn: Type<any> | 'root' | 'platform' | 'any' | null;
            } & InjectableProvider): Injectable;
    }
    
    /**
        * Injectable providers used in `@Injectable` decorator.
        *
        * @publicApi
        */
    export type InjectableProvider = ValueSansProvider | ExistingSansProvider | StaticClassSansProvider | ConstructorSansProvider | FactorySansProvider | ClassSansProvider;
    
    /**
        * A `Type` which has a `ɵprov: ɵɵInjectableDeclaration` static field.
        *
        * `InjectableType`s contain their own Dependency Injection metadata and are usable in an
        * `InjectorDef`-based `StaticInjector`.
        *
        * @publicApi
        */
    export interface InjectableType<T> extends Type<T> {
            /**
                * Opaque type whose structure is highly version dependent. Do not rely on any properties.
                */
            ɵprov: unknown;
    }
    
    
    /**
        * Type of the Inject decorator / constructor function.
        *
        * @publicApi
        */
    export interface InjectDecorator {
            /**
                * Parameter decorator on a dependency parameter of a class constructor
                * that specifies a custom provider of the dependency.
                *
                * @usageNotes
                * The following example shows a class constructor that specifies a
                * custom provider of a dependency using the parameter decorator.
                *
                * When `@Inject()` is not present, the injector uses the type annotation of the
                * parameter as the provider.
                *
                * <code-example path="core/di/ts/metadata_spec.ts" region="InjectWithoutDecorator">
                * </code-example>
                *
                * @see ["Dependency Injection Guide"](guide/dependency-injection)
                *
                */
            (token: any): any;
            new (token: any): Inject;
    }
    
    /**
        * Injection flags for DI.
        *
        * @publicApi
        * @deprecated use an options object for `inject` instead.
        */
    export enum InjectFlags {
            /** Check self and check parent injector if needed */
            Default = 0,
            /**
                * Specifies that an injector should retrieve a dependency from any injector until reaching the
                * host element of the current component. (Only used with Element Injector)
                */
            Host = 1,
            /** Don't ascend to ancestors of the node requesting injection. */
            Self = 2,
            /** Skip the node that is requesting injection. */
            SkipSelf = 4,
            /** Inject `defaultValue` instead if token not found. */
            Optional = 8
    }
    
    /**
        * Creates a token that can be used in a DI Provider.
        *
        * Use an `InjectionToken` whenever the type you are injecting is not reified (does not have a
        * runtime representation) such as when injecting an interface, callable type, array or
        * parameterized type.
        *
        * `InjectionToken` is parameterized on `T` which is the type of object which will be returned by
        * the `Injector`. This provides an additional level of type safety.
        *
        * ```
        * interface MyInterface {...}
        * const myInterface = injector.get(new InjectionToken<MyInterface>('SomeToken'));
        * // myInterface is inferred to be MyInterface.
        * ```
        *
        * When creating an `InjectionToken`, you can optionally specify a factory function which returns
        * (possibly by creating) a default value of the parameterized type `T`. This sets up the
        * `InjectionToken` using this factory as a provider as if it was defined explicitly in the
        * application's root injector. If the factory function, which takes zero arguments, needs to inject
        * dependencies, it can do so using the `inject` function.
        * As you can see in the Tree-shakable InjectionToken example below.
        *
        * Additionally, if a `factory` is specified you can also specify the `providedIn` option, which
        * overrides the above behavior and marks the token as belonging to a particular `@NgModule` (note:
        * this option is now deprecated). As mentioned above, `'root'` is the default value for
        * `providedIn`.
        *
        * The `providedIn: NgModule` and `providedIn: 'any'` options are deprecated.
        *
        * @usageNotes
        * ### Basic Examples
        *
        * ### Plain InjectionToken
        *
        * {@example core/di/ts/injector_spec.ts region='InjectionToken'}
        *
        * ### Tree-shakable InjectionToken
        *
        * {@example core/di/ts/injector_spec.ts region='ShakableInjectionToken'}
        *
        *
        * @publicApi
        */
    export class InjectionToken<T> {
            protected _desc: string;
            readonly ɵprov: unknown;
            /**
                * @param _desc   Description for the token,
                *                used only for debugging purposes,
                *                it should but does not need to be unique
                * @param options Options for the token's usage, as described above
                */
            constructor(_desc: string, options?: {
                    providedIn?: Type<any> | 'root' | 'platform' | 'any' | null;
                    factory: () => T;
            });
            toString(): string;
    }
    
    /**
        * Type of the options argument to `inject`.
        *
        * @publicApi
        */
    export interface InjectOptions {
            /**
                * Use optional injection, and return `null` if the requested token is not found.
                */
            optional?: boolean;
            /**
                * Start injection at the parent of the current injector.
                */
            skipSelf?: boolean;
            /**
                * Only query the current injector for the token, and don't fall back to the parent injector if
                * it's not found.
                */
            self?: boolean;
            /**
                * Stop injection at the host component's injector. Only relevant when injecting from an element
                * injector, and a no-op for environment injectors.
                */
            host?: boolean;
    }
    
    /**
        * An InjectionToken that gets the current `Injector` for `createInjector()`-style injectors.
        *
        * Requesting this token instead of `Injector` allows `StaticInjector` to be tree-shaken from a
        * project.
        *
        * @publicApi
        */
    export const INJECTOR: InjectionToken<Injector>;
    
    /**
        * Concrete injectors implement this interface. Injectors are configured
        * with [providers](guide/glossary#provider) that associate
        * dependencies of various types with [injection tokens](guide/glossary#di-token).
        *
        * @see ["DI Providers"](guide/dependency-injection-providers).
        * @see `StaticProvider`
        *
        * @usageNotes
        *
        *  The following example creates a service injector instance.
        *
        * {@example core/di/ts/provider_spec.ts region='ConstructorProvider'}
        *
        * ### Usage example
        *
        * {@example core/di/ts/injector_spec.ts region='Injector'}
        *
        * `Injector` returns itself when given `Injector` as a token:
        *
        * {@example core/di/ts/injector_spec.ts region='injectInjector'}
        *
        * @publicApi
        */
    export abstract class Injector {
            static THROW_IF_NOT_FOUND: {};
            static NULL: Injector;
            /**
                * Retrieves an instance from the injector based on the provided token.
                * @returns The instance from the injector if defined, otherwise the `notFoundValue`.
                * @throws When the `notFoundValue` is `undefined` or `Injector.THROW_IF_NOT_FOUND`.
                */
            abstract get<T>(token: ProviderToken<T>, notFoundValue: undefined, options: InjectOptions & {
                    optional?: false;
            }): T;
            /**
                * Retrieves an instance from the injector based on the provided token.
                * @returns The instance from the injector if defined, otherwise the `notFoundValue`.
                * @throws When the `notFoundValue` is `undefined` or `Injector.THROW_IF_NOT_FOUND`.
                */
            abstract get<T>(token: ProviderToken<T>, notFoundValue: null | undefined, options: InjectOptions): T | null;
            /**
                * Retrieves an instance from the injector based on the provided token.
                * @returns The instance from the injector if defined, otherwise the `notFoundValue`.
                * @throws When the `notFoundValue` is `undefined` or `Injector.THROW_IF_NOT_FOUND`.
                */
            abstract get<T>(token: ProviderToken<T>, notFoundValue?: T, options?: InjectOptions | InjectFlags): T;
            /**
                * Retrieves an instance from the injector based on the provided token.
                * @returns The instance from the injector if defined, otherwise the `notFoundValue`.
                * @throws When the `notFoundValue` is `undefined` or `Injector.THROW_IF_NOT_FOUND`.
                * @deprecated use object-based flags (`InjectOptions`) instead.
                */
            abstract get<T>(token: ProviderToken<T>, notFoundValue?: T, flags?: InjectFlags): T;
            /**
                * @deprecated from v4.0.0 use ProviderToken<T>
                * @suppress {duplicate}
                */
            abstract get(token: any, notFoundValue?: any): any;
            /**
                * @deprecated from v5 use the new signature Injector.create(options)
                */
            static create(providers: StaticProvider[], parent?: Injector): Injector;
            /**
                * Creates a new injector instance that provides one or more dependencies,
                * according to a given type or types of `StaticProvider`.
                *
                * @param options An object with the following properties:
                * * `providers`: An array of providers of the [StaticProvider type](api/core/StaticProvider).
                * * `parent`: (optional) A parent injector.
                * * `name`: (optional) A developer-defined identifying name for the new injector.
                *
                * @returns The new injector instance.
                *
                */
            static create(options: {
                    providers: StaticProvider[];
                    parent?: Injector;
                    name?: string;
            }): Injector;
            /** @nocollapse */
            static ɵprov: unknown;
    }
    
    const INJECTOR_2 = 9;
    
    type InjectorScope = 'root' | 'platform' | 'environment';
    
    /**
        * A type which has an `InjectorDef` static field.
        *
        * `InjectorTypes` can be used to configure a `StaticInjector`.
        *
        * This is an opaque type whose structure is highly version dependent. Do not rely on any
        * properties.
        *
        * @publicApi
        */
    export interface InjectorType<T> extends Type<T> {
            ɵfac?: unknown;
            ɵinj: unknown;
    }
    
    /**
        * Describes the `InjectorDef` equivalent of a `ModuleWithProviders`, an `InjectorType` with an
        * associated array of providers.
        *
        * Objects of this type can be listed in the imports section of an `InjectorDef`.
        *
        * NOTE: This is a private type and should not be exported
        */
    interface InjectorTypeWithProviders<T> {
            ngModule: InjectorType<T>;
            providers?: (Type<any> | ValueProvider | ExistingProvider | FactoryProvider | ConstructorProvider | StaticClassProvider | ClassProvider | EnvironmentProviders | any[])[];
    }
    
    /**
        * Type of metadata for an `Input` property.
        *
        * @publicApi
        */
    export interface Input {
            /**
                * The name of the DOM property to which the input property is bound.
                */
            bindingPropertyName?: string;
    }
    
    /**
        * @Annotation
        * @publicApi
        */
    export const Input: InputDecorator;
    
    /**
        * @publicApi
        */
    export interface InputDecorator {
            /**
                * Decorator that marks a class field as an input property and supplies configuration metadata.
                * The input property is bound to a DOM property in the template. During change detection,
                * Angular automatically updates the data property with the DOM property's value.
                *
                * @usageNotes
                *
                * You can supply an optional name to use in templates when the
                * component is instantiated, that maps to the
                * name of the bound property. By default, the original
                * name of the bound property is used for input binding.
                *
                * The following example creates a component with two input properties,
                * one of which is given a special binding name.
                *
                * ```typescript
                * @Component({
                *   selector: 'bank-account',
                *   template: `
                *     Bank Name: {{bankName}}
                *     Account Id: {{id}}
                *   `
                * })
                * class BankAccount {
                *   // This property is bound using its original name.
                *   @Input() bankName: string;
                *   // this property value is bound to a different property name
                *   // when this component is instantiated in a template.
                *   @Input('account-id') id: string;
                *
                *   // this property is not bound, and is not automatically updated by Angular
                *   normalizedBankName: string;
                * }
                *
                * @Component({
                *   selector: 'app',
                *   template: `
                *     <bank-account bankName="RBC" account-id="4747"></bank-account>
                *   `
                * })
                * class App {}
                * ```
                *
                * @see [Input and Output properties](guide/inputs-outputs)
                */
            (bindingPropertyName?: string): any;
            new (bindingPropertyName?: string): any;
    }
    
    /**
        * See `TNode.insertBeforeIndex`
        */
    type InsertBeforeIndex = null | number | number[];
    
    interface InternalNgModuleRef<T> extends NgModuleRef<T> {
            _bootstrapComponents: Type<any>[];
    }
    
    interface InternalViewRef extends ViewRef {
            detachFromAppRef(): void;
            attachToAppRef(appRef: ViewRefTracker): void;
    }
    
    
    /**
        * Returns whether Angular is in development mode.
        *
        * By default, this is true, unless `enableProdMode` is invoked prior to calling this method or the
        * application is built using the Angular CLI with the `optimization` option.
        * @see {@link cli/build ng build}
        *
        * @publicApi
        */
    export function isDevMode(): boolean;
    
    /**
        * Checks whether a given Component, Directive or Pipe is marked as standalone.
        * This will return false if passed anything other than a Component, Directive, or Pipe class
        * See this guide for additional information: https://angular.io/guide/standalone-components
        *
        * @param type A reference to a Component, Directive or Pipe.
        * @publicApi
        */
    export function isStandalone(type: Type<unknown>): boolean;
    
    /**
        * Record representing the item change information.
        *
        * @publicApi
        */
    export interface IterableChangeRecord<V> {
            /** Current index of the item in `Iterable` or null if removed. */
            readonly currentIndex: number | null;
            /** Previous index of the item in `Iterable` or null if added. */
            readonly previousIndex: number | null;
            /** The item. */
            readonly item: V;
            /** Track by identity as computed by the `TrackByFunction`. */
            readonly trackById: any;
    }
    
    class IterableChangeRecord_<V> implements IterableChangeRecord<V> {
            item: V;
            trackById: any;
            currentIndex: number | null;
            previousIndex: number | null;
            constructor(item: V, trackById: any);
    }
    
    /**
        * An object describing the changes in the `Iterable` collection since last time
        * `IterableDiffer#diff()` was invoked.
        *
        * @publicApi
        */
    export interface IterableChanges<V> {
            /**
                * Iterate over all changes. `IterableChangeRecord` will contain information about changes
                * to each item.
                */
            forEachItem(fn: (record: IterableChangeRecord<V>) => void): void;
            /**
                * Iterate over a set of operations which when applied to the original `Iterable` will produce the
                * new `Iterable`.
                *
                * NOTE: These are not necessarily the actual operations which were applied to the original
                * `Iterable`, rather these are a set of computed operations which may not be the same as the
                * ones applied.
                *
                * @param record A change which needs to be applied
                * @param previousIndex The `IterableChangeRecord#previousIndex` of the `record` refers to the
                *        original `Iterable` location, where as `previousIndex` refers to the transient location
                *        of the item, after applying the operations up to this point.
                * @param currentIndex The `IterableChangeRecord#currentIndex` of the `record` refers to the
                *        original `Iterable` location, where as `currentIndex` refers to the transient location
                *        of the item, after applying the operations up to this point.
                */
            forEachOperation(fn: (record: IterableChangeRecord<V>, previousIndex: number | null, currentIndex: number | null) => void): void;
            /**
                * Iterate over changes in the order of original `Iterable` showing where the original items
                * have moved.
                */
            forEachPreviousItem(fn: (record: IterableChangeRecord<V>) => void): void;
            /** Iterate over all added items. */
            forEachAddedItem(fn: (record: IterableChangeRecord<V>) => void): void;
            /** Iterate over all moved items. */
            forEachMovedItem(fn: (record: IterableChangeRecord<V>) => void): void;
            /** Iterate over all removed items. */
            forEachRemovedItem(fn: (record: IterableChangeRecord<V>) => void): void;
            /**
                * Iterate over all items which had their identity (as computed by the `TrackByFunction`)
                * changed.
                */
            forEachIdentityChange(fn: (record: IterableChangeRecord<V>) => void): void;
    }
    
    /**
        * A strategy for tracking changes over time to an iterable. Used by {@link NgForOf} to
        * respond to changes in an iterable by effecting equivalent changes in the DOM.
        *
        * @publicApi
        */
    export interface IterableDiffer<V> {
            /**
                * Compute a difference between the previous state and the new `object` state.
                *
                * @param object containing the new value.
                * @returns an object describing the difference. The return value is only valid until the next
                * `diff()` invocation.
                */
            diff(object: NgIterable<V> | undefined | null): IterableChanges<V> | null;
    }
    
    /**
        * Provides a factory for {@link IterableDiffer}.
        *
        * @publicApi
        */
    export interface IterableDifferFactory {
            supports(objects: any): boolean;
            create<V>(trackByFn?: TrackByFunction<V>): IterableDiffer<V>;
    }
    
    /**
        * A repository of different iterable diffing strategies used by NgFor, NgClass, and others.
        *
        * @publicApi
        */
    export class IterableDiffers {
            /** @nocollapse */
            static ɵprov: unknown;
            /**
                * @deprecated v4.0.0 - Should be private
                */
            factories: IterableDifferFactory[];
            constructor(factories: IterableDifferFactory[]);
            static create(factories: IterableDifferFactory[], parent?: IterableDiffers): IterableDiffers;
            /**
                * Takes an array of {@link IterableDifferFactory} and returns a provider used to extend the
                * inherited {@link IterableDiffers} instance with the provided factories and return a new
                * {@link IterableDiffers} instance.
                *
                * @usageNotes
                * ### Example
                *
                * The following example shows how to extend an existing list of factories,
                * which will only be applied to the injector for this component and its children.
                * This step is all that's required to make a new {@link IterableDiffer} available.
                *
                * ```
                * @Component({
                *   viewProviders: [
                *     IterableDiffers.extend([new ImmutableListDiffer()])
                *   ]
                * })
                * ```
                */
            static extend(factories: IterableDifferFactory[]): StaticProvider;
            find(iterable: any): IterableDifferFactory;
    }
    
    /**
        * The existence of this constant (in this particular file) informs the Angular compiler that the
        * current program is actually @angular/core, which needs to be compiled specially.
        */
    const ITS_JUST_ANGULAR = true;
    
    /**
        * `KeyValueArray` is an array where even positions contain keys and odd positions contain values.
        *
        * `KeyValueArray` provides a very efficient way of iterating over its contents. For small
        * sets (~10) the cost of binary searching an `KeyValueArray` has about the same performance
        * characteristics that of a `Map` with significantly better memory footprint.
        *
        * If used as a `Map` the keys are stored in alphabetical order so that they can be binary searched
        * for retrieval.
        *
        * See: `keyValueArraySet`, `keyValueArrayGet`, `keyValueArrayIndexOf`, `keyValueArrayDelete`.
        */
    interface KeyValueArray<VALUE> extends Array<VALUE | string> {
            __brand__: 'array-map';
    }
    
    /**
        * Record representing the item change information.
        *
        * @publicApi
        */
    export interface KeyValueChangeRecord<K, V> {
            /**
                * Current key in the Map.
                */
            readonly key: K;
            /**
                * Current value for the key or `null` if removed.
                */
            readonly currentValue: V | null;
            /**
                * Previous value for the key or `null` if added.
                */
            readonly previousValue: V | null;
    }
    
    /**
        * An object describing the changes in the `Map` or `{[k:string]: string}` since last time
        * `KeyValueDiffer#diff()` was invoked.
        *
        * @publicApi
        */
    export interface KeyValueChanges<K, V> {
            /**
                * Iterate over all changes. `KeyValueChangeRecord` will contain information about changes
                * to each item.
                */
            forEachItem(fn: (r: KeyValueChangeRecord<K, V>) => void): void;
            /**
                * Iterate over changes in the order of original Map showing where the original items
                * have moved.
                */
            forEachPreviousItem(fn: (r: KeyValueChangeRecord<K, V>) => void): void;
            /**
                * Iterate over all keys for which values have changed.
                */
            forEachChangedItem(fn: (r: KeyValueChangeRecord<K, V>) => void): void;
            /**
                * Iterate over all added items.
                */
            forEachAddedItem(fn: (r: KeyValueChangeRecord<K, V>) => void): void;
            /**
                * Iterate over all removed items.
                */
            forEachRemovedItem(fn: (r: KeyValueChangeRecord<K, V>) => void): void;
    }
    
    /**
        * A differ that tracks changes made to an object over time.
        *
        * @publicApi
        */
    export interface KeyValueDiffer<K, V> {
            /**
                * Compute a difference between the previous state and the new `object` state.
                *
                * @param object containing the new value.
                * @returns an object describing the difference. The return value is only valid until the next
                * `diff()` invocation.
                */
            diff(object: Map<K, V>): KeyValueChanges<K, V> | null;
            /**
                * Compute a difference between the previous state and the new `object` state.
                *
                * @param object containing the new value.
                * @returns an object describing the difference. The return value is only valid until the next
                * `diff()` invocation.
                */
            diff(object: {
                    [key: string]: V;
            }): KeyValueChanges<string, V> | null;
    }
    
    /**
        * Provides a factory for {@link KeyValueDiffer}.
        *
        * @publicApi
        */
    export interface KeyValueDifferFactory {
            /**
                * Test to see if the differ knows how to diff this kind of object.
                */
            supports(objects: any): boolean;
            /**
                * Create a `KeyValueDiffer`.
                */
            create<K, V>(): KeyValueDiffer<K, V>;
    }
    
    /**
        * A repository of different Map diffing strategies used by NgClass, NgStyle, and others.
        *
        * @publicApi
        */
    export class KeyValueDiffers {
            /** @nocollapse */
            static ɵprov: unknown;
            /**
                * @deprecated v4.0.0 - Should be private.
                */
            factories: KeyValueDifferFactory[];
            constructor(factories: KeyValueDifferFactory[]);
            static create<S>(factories: KeyValueDifferFactory[], parent?: KeyValueDiffers): KeyValueDiffers;
            /**
                * Takes an array of {@link KeyValueDifferFactory} and returns a provider used to extend the
                * inherited {@link KeyValueDiffers} instance with the provided factories and return a new
                * {@link KeyValueDiffers} instance.
                *
                * @usageNotes
                * ### Example
                *
                * The following example shows how to extend an existing list of factories,
                * which will only be applied to the injector for this component and its children.
                * This step is all that's required to make a new {@link KeyValueDiffer} available.
                *
                * ```
                * @Component({
                *   viewProviders: [
                *     KeyValueDiffers.extend([new ImmutableMapDiffer()])
                *   ]
                * })
                * ```
                */
            static extend<S>(factories: KeyValueDifferFactory[]): StaticProvider;
            find(kv: any): KeyValueDifferFactory;
    }
    
    /**
        * The state associated with a container.
        *
        * This is an array so that its structure is closer to LView. This helps
        * when traversing the view tree (which is a mix of containers and component
        * views), so we can jump to viewOrContainer[NEXT] in the same way regardless
        * of type.
        */
    interface LContainer extends Array<any> {
            /**
                * The host element of this LContainer.
                *
                * The host could be an LView if this container is on a component node.
                * In that case, the component LView is its HOST.
                */
            readonly [HOST]: RElement | RComment | LView;
            /**
                * This is a type field which allows us to differentiate `LContainer` from `StylingContext` in an
                * efficient way. The value is always set to `true`
                */
            [TYPE]: true;
            /**
                * Flag to signify that this `LContainer` may have transplanted views which need to be change
                * detected. (see: `LView[DECLARATION_COMPONENT_VIEW])`.
                *
                * This flag, once set, is never unset for the `LContainer`.
                */
            [HAS_TRANSPLANTED_VIEWS]: boolean;
            /**
                * Access to the parent view is necessary so we can propagate back
                * up from inside a container to parent[NEXT].
                */
            [PARENT]: LView;
            /**
                * This allows us to jump from a container to a sibling container or component
                * view with the same parent, so we can remove listeners efficiently.
                */
            [NEXT]: LView | LContainer | null;
            /**
                * The number of direct transplanted views which need a refresh or have descendants themselves
                * that need a refresh but have not marked their ancestors as Dirty. This tells us that during
                * change detection we should still descend to find those children to refresh, even if the parents
                * are not `Dirty`/`CheckAlways`.
                */
            [TRANSPLANTED_VIEWS_TO_REFRESH]: number;
            /**
                * A collection of views created based on the underlying `<ng-template>` element but inserted into
                * a different `LContainer`. We need to track views created from a given declaration point since
                * queries collect matches from the embedded view declaration point and _not_ the insertion point.
                */
            [MOVED_VIEWS]: LView[] | null;
            /**
                * Pointer to the `TNode` which represents the host of the container.
                */
            [T_HOST]: TNode;
            /** The comment element that serves as an anchor for this LContainer. */
            readonly [NATIVE]: RComment;
            /**
                * Array of `ViewRef`s used by any `ViewContainerRef`s that point to this container.
                *
                * This is lazily initialized by `ViewContainerRef` when the first view is inserted.
                *
                * NOTE: This is stored as `any[]` because render3 should really not be aware of `ViewRef` and
                * doing so creates circular dependency.
                */
            [VIEW_REFS]: unknown[] | null;
    }
    
    /**
        * Provide this token to set the locale of your application.
        * It is used for i18n extraction, by i18n pipes (DatePipe, I18nPluralPipe, CurrencyPipe,
        * DecimalPipe and PercentPipe) and by ICU expressions.
        *
        * See the [i18n guide](guide/i18n-common-locale-id) for more information.
        *
        * @usageNotes
        * ### Example
        *
        * ```typescript
        * import { LOCALE_ID } from '@angular/core';
        * import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
        * import { AppModule } from './app/app.module';
        *
        * platformBrowserDynamic().bootstrapModule(AppModule, {
        *   providers: [{provide: LOCALE_ID, useValue: 'en-US' }]
        * });
        * ```
        *
        * @publicApi
        */
    export const LOCALE_ID: InjectionToken<string>;
    
    /**
        * Type for a function that extracts a value for a local refs.
        * Example:
        * - `<div #nativeDivEl>` - `nativeDivEl` should point to the native `<div>` element;
        * - `<ng-template #tplRef>` - `tplRef` should point to the `TemplateRef` instance;
        */
    type LocalRefExtractor = (tNode: TNodeWithLocalRefs, currentView: LView) => any;
    
    /**
        * lQueries represent a collection of individual LQuery objects tracked in a given view.
        */
    interface LQueries {
            /**
                * A collection of queries tracked in a given view.
                */
            queries: LQuery<any>[];
            /**
                * A method called when a new embedded view is created. As a result a set of LQueries applicable
                * for a new embedded view is instantiated (cloned) from the declaration view.
                * @param tView
                */
            createEmbeddedView(tView: TView): LQueries | null;
            /**
                * A method called when an embedded view is inserted into a container. As a result all impacted
                * `LQuery` objects (and associated `QueryList`) are marked as dirty.
                * @param tView
                */
            insertView(tView: TView): void;
            /**
                * A method called when an embedded view is detached from a container. As a result all impacted
                * `LQuery` objects (and associated `QueryList`) are marked as dirty.
                * @param tView
                */
            detachView(tView: TView): void;
    }
    
    /**
        * An interface that represents query-related information specific to a view instance. Most notably
        * it contains:
        * - materialized query matches;
        * - a pointer to a QueryList where materialized query results should be reported.
        */
    interface LQuery<T> {
            /**
                * Materialized query matches for a given view only (!). Results are initialized lazily so the
                * array of matches is set to `null` initially.
                */
            matches: (T | null)[] | null;
            /**
                * A QueryList where materialized query results should be reported.
                */
            queryList: QueryList<T>;
            /**
                * Clones an LQuery for an embedded view. A cloned query shares the same `QueryList` but has a
                * separate collection of materialized matches.
                */
            clone(): LQuery<T>;
            /**
                * Called when an embedded view, impacting results of this query, is inserted or removed.
                */
            setDirty(): void;
    }
    
    /**
        * `LView` stores all of the information needed to process the instructions as
        * they are invoked from the template. Each embedded view and component view has its
        * own `LView`. When processing a particular view, we set the `viewData` to that
        * `LView`. When that view is done processing, the `viewData` is set back to
        * whatever the original `viewData` was before (the parent `LView`).
        *
        * Keeping separate state for each view facilities view insertion / deletion, so we
        * don't have to edit the data array based on which views are present.
        */
    interface LView<T = unknown> extends Array<any> {
            /**
                * The node into which this `LView` is inserted.
                */
            [HOST]: RElement | null;
            /**
                * The static data for this view. We need a reference to this so we can easily walk up the
                * node tree in DI and get the TView.data array associated with a node (where the
                * directive defs are stored).
                */
            readonly [TVIEW]: TView;
            /** Flags for this view. See LViewFlags for more info. */
            [FLAGS]: LViewFlags;
            /**
                * This may store an {@link LView} or {@link LContainer}.
                *
                * `LView` - The parent view. This is needed when we exit the view and must restore the previous
                * LView. Without this, the render method would have to keep a stack of
                * views as it is recursively rendering templates.
                *
                * `LContainer` - The current view is part of a container, and is an embedded view.
                */
            [PARENT]: LView | LContainer | null;
            /**
                *
                * The next sibling LView or LContainer.
                *
                * Allows us to propagate between sibling view states that aren't in the same
                * container. Embedded views already have a node.next, but it is only set for
                * views in the same container. We need a way to link component views and views
                * across containers as well.
                */
            [NEXT]: LView | LContainer | null;
            /** Queries active for this view - nodes from a view are reported to those queries. */
            [QUERIES]: LQueries | null;
            /**
                * Store the `TNode` of the location where the current `LView` is inserted into.
                *
                * Given:
                * ```
                * <div>
                *   <ng-template><span></span></ng-template>
                * </div>
                * ```
                *
                * We end up with two `TView`s.
                * - `parent` `TView` which contains `<div><!-- anchor --></div>`
                * - `child` `TView` which contains `<span></span>`
                *
                * Typically the `child` is inserted into the declaration location of the `parent`, but it can be
                * inserted anywhere. Because it can be inserted anywhere it is not possible to store the
                * insertion information in the `TView` and instead we must store it in the `LView[T_HOST]`.
                *
                * So to determine where is our insertion parent we would execute:
                * ```
                * const parentLView = lView[PARENT];
                * const parentTNode = lView[T_HOST];
                * const insertionParent = parentLView[parentTNode.index];
                * ```
                *
                *
                * If `null`, this is the root view of an application (root component is in this view) and it has
                * no parents.
                */
            [T_HOST]: TNode | null;
            /**
                * When a view is destroyed, listeners need to be released and outputs need to be
                * unsubscribed. This context array stores both listener functions wrapped with
                * their context and output subscription instances for a particular view.
                *
                * These change per LView instance, so they cannot be stored on TView. Instead,
                * TView.cleanup saves an index to the necessary context in this array.
                *
                * After `LView` is created it is possible to attach additional instance specific functions at the
                * end of the `lView[CLEANUP]` because we know that no more `T` level cleanup functions will be
                * added here.
                */
            [CLEANUP]: any[] | null;
            /**
                * - For dynamic views, this is the context with which to render the template (e.g.
                *   `NgForContext`), or `{}` if not defined explicitly.
                * - For root view of the root component it's a reference to the component instance itself.
                * - For components, the context is a reference to the component instance itself.
                * - For inline views, the context is null.
                */
            [CONTEXT]: T;
            /** An optional Module Injector to be used as fall back after Element Injectors are consulted. */
            readonly [INJECTOR_2]: Injector | null;
            /** Factory to be used for creating Renderer. */
            [RENDERER_FACTORY]: RendererFactory;
            /** Renderer to be used for this view. */
            [RENDERER]: Renderer;
            /** An optional custom sanitizer. */
            [SANITIZER]: Sanitizer | null;
            /**
                * Reference to the first LView or LContainer beneath this LView in
                * the hierarchy.
                *
                * Necessary to store this so views can traverse through their nested views
                * to remove listeners and call onDestroy callbacks.
                */
            [CHILD_HEAD]: LView | LContainer | null;
            /**
                * The last LView or LContainer beneath this LView in the hierarchy.
                *
                * The tail allows us to quickly add a new state to the end of the view list
                * without having to propagate starting from the first child.
                */
            [CHILD_TAIL]: LView | LContainer | null;
            /**
                * View where this view's template was declared.
                *
                * The template for a dynamically created view may be declared in a different view than
                * it is inserted. We already track the "insertion view" (view where the template was
                * inserted) in LView[PARENT], but we also need access to the "declaration view"
                * (view where the template was declared). Otherwise, we wouldn't be able to call the
                * view's template function with the proper contexts. Context should be inherited from
                * the declaration view tree, not the insertion view tree.
                *
                * Example (AppComponent template):
                *
                * <ng-template #foo></ng-template>       <-- declared here -->
                * <some-comp [tpl]="foo"></some-comp>    <-- inserted inside this component -->
                *
                * The <ng-template> above is declared in the AppComponent template, but it will be passed into
                * SomeComp and inserted there. In this case, the declaration view would be the AppComponent,
                * but the insertion view would be SomeComp. When we are removing views, we would want to
                * traverse through the insertion view to clean up listeners. When we are calling the
                * template function during change detection, we need the declaration view to get inherited
                * context.
                */
            [DECLARATION_VIEW]: LView | null;
            /**
                * Points to the declaration component view, used to track transplanted `LView`s.
                *
                * See: `DECLARATION_VIEW` which points to the actual `LView` where it was declared, whereas
                * `DECLARATION_COMPONENT_VIEW` points to the component which may not be same as
                * `DECLARATION_VIEW`.
                *
                * Example:
                * ```
                * <#VIEW #myComp>
                *  <div *ngIf="true">
                *   <ng-template #myTmpl>...</ng-template>
                *  </div>
                * </#VIEW>
                * ```
                * In the above case `DECLARATION_VIEW` for `myTmpl` points to the `LView` of `ngIf` whereas
                * `DECLARATION_COMPONENT_VIEW` points to `LView` of the `myComp` which owns the template.
                *
                * The reason for this is that all embedded views are always check-always whereas the component
                * view can be check-always or on-push. When we have a transplanted view it is important to
                * determine if we have transplanted a view from check-always declaration to on-push insertion
                * point. In such a case the transplanted view needs to be added to the `LContainer` in the
                * declared `LView` and CD during the declared view CD (in addition to the CD at the insertion
                * point.) (Any transplanted views which are intra Component are of no interest because the CD
                * strategy of declaration and insertion will always be the same, because it is the same
                * component.)
                *
                * Queries already track moved views in `LView[DECLARATION_LCONTAINER]` and
                * `LContainer[MOVED_VIEWS]`. However the queries also track `LView`s which moved within the same
                * component `LView`. Transplanted views are a subset of moved views, and we use
                * `DECLARATION_COMPONENT_VIEW` to differentiate them. As in this example.
                *
                * Example showing intra component `LView` movement.
                * ```
                * <#VIEW #myComp>
                *   <div *ngIf="condition; then thenBlock else elseBlock"></div>
                *   <ng-template #thenBlock>Content to render when condition is true.</ng-template>
                *   <ng-template #elseBlock>Content to render when condition is false.</ng-template>
                * </#VIEW>
                * ```
                * The `thenBlock` and `elseBlock` is moved but not transplanted.
                *
                * Example showing inter component `LView` movement (transplanted view).
                * ```
                * <#VIEW #myComp>
                *   <ng-template #myTmpl>...</ng-template>
                *   <insertion-component [template]="myTmpl"></insertion-component>
                * </#VIEW>
                * ```
                * In the above example `myTmpl` is passed into a different component. If `insertion-component`
                * instantiates `myTmpl` and `insertion-component` is on-push then the `LContainer` needs to be
                * marked as containing transplanted views and those views need to be CD as part of the
                * declaration CD.
                *
                *
                * When change detection runs, it iterates over `[MOVED_VIEWS]` and CDs any child `LView`s where
                * the `DECLARATION_COMPONENT_VIEW` of the current component and the child `LView` does not match
                * (it has been transplanted across components.)
                *
                * Note: `[DECLARATION_COMPONENT_VIEW]` points to itself if the LView is a component view (the
                *       simplest / most common case).
                *
                * see also:
                *   - https://hackmd.io/@mhevery/rJUJsvv9H write up of the problem
                *   - `LContainer[HAS_TRANSPLANTED_VIEWS]` which marks which `LContainer` has transplanted views.
                *   - `LContainer[TRANSPLANT_HEAD]` and `LContainer[TRANSPLANT_TAIL]` storage for transplanted
                *   - `LView[DECLARATION_LCONTAINER]` similar problem for queries
                *   - `LContainer[MOVED_VIEWS]` similar problem for queries
                */
            [DECLARATION_COMPONENT_VIEW]: LView;
            /**
                * A declaration point of embedded views (ones instantiated based on the content of a
                * <ng-template>), null for other types of views.
                *
                * We need to track all embedded views created from a given declaration point so we can prepare
                * query matches in a proper order (query matches are ordered based on their declaration point and
                * _not_ the insertion point).
                */
            [DECLARATION_LCONTAINER]: LContainer | null;
            /**
                * More flags for this view. See PreOrderHookFlags for more info.
                */
            [PREORDER_HOOK_FLAGS]: PreOrderHookFlags;
            /**
                * The number of direct transplanted views which need a refresh or have descendants themselves
                * that need a refresh but have not marked their ancestors as Dirty. This tells us that during
                * change detection we should still descend to find those children to refresh, even if the parents
                * are not `Dirty`/`CheckAlways`.
                */
            [TRANSPLANTED_VIEWS_TO_REFRESH]: number;
            /** Unique ID of the view. Used for `__ngContext__` lookups in the `LView` registry. */
            [ID]: number;
            /**
                * Optional injector assigned to embedded views that takes
                * precedence over the element and module injectors.
                */
            readonly [EMBEDDED_VIEW_INJECTOR]: Injector | null;
    }
    
    /** Flags associated with an LView (saved in LView[FLAGS]) */
    const enum LViewFlags {
            /** The state of the init phase on the first 2 bits */
            InitPhaseStateIncrementer = 1,
            InitPhaseStateMask = 3,
            /**
                * Whether or not the view is in creationMode.
                *
                * This must be stored in the view rather than using `data` as a marker so that
                * we can properly support embedded views. Otherwise, when exiting a child view
                * back into the parent view, `data` will be defined and `creationMode` will be
                * improperly reported as false.
                */
            CreationMode = 4,
            /**
                * Whether or not this LView instance is on its first processing pass.
                *
                * An LView instance is considered to be on its "first pass" until it
                * has completed one creation mode run and one update mode run. At this
                * time, the flag is turned off.
                */
            FirstLViewPass = 8,
            /** Whether this view has default change detection strategy (checks always) or onPush */
            CheckAlways = 16,
            /** Whether or not this view is currently dirty (needing check) */
            Dirty = 32,
            /** Whether or not this view is currently attached to change detection tree. */
            Attached = 64,
            /** Whether or not this view is destroyed. */
            Destroyed = 128,
            /** Whether or not this view is the root view */
            IsRoot = 256,
            /**
                * Whether this moved LView was needs to be refreshed at the insertion location because the
                * declaration was dirty.
                */
            RefreshTransplantedView = 512,
            /** Indicates that the view **or any of its ancestors** have an embedded view injector. */
            HasEmbeddedViewInjector = 1024,
            /**
                * Index of the current init phase on last 21 bits
                */
            IndexWithinInitPhaseIncrementer = 2048,
            IndexWithinInitPhaseShift = 11,
            IndexWithinInitPhaseReset = 2047
    }
    
    /**
        * Wrap an array of `Provider`s into `EnvironmentProviders`, preventing them from being accidentally
        * referenced in `@Component in a component injector.
        */
    export function makeEnvironmentProviders(providers: (Provider | EnvironmentProviders)[]): EnvironmentProviders;
    
    /**
        * Use this enum at bootstrap as an option of `bootstrapModule` to define the strategy
        * that the compiler should use in case of missing translations:
        * - Error: throw if you have missing translations.
        * - Warning (default): show a warning in the console and/or shell.
        * - Ignore: do nothing.
        *
        * See the [i18n guide](guide/i18n-common-merge#report-missing-translations) for more information.
        *
        * @usageNotes
        * ### Example
        * ```typescript
        * import { MissingTranslationStrategy } from '@angular/core';
        * import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
        * import { AppModule } from './app/app.module';
        *
        * platformBrowserDynamic().bootstrapModule(AppModule, {
        *   missingTranslation: MissingTranslationStrategy.Error
        * });
        * ```
        *
        * @publicApi
        */
    export enum MissingTranslationStrategy {
            Error = 0,
            Warning = 1,
            Ignore = 2
    }
    
    /**
        * Combination of NgModuleFactory and ComponentFactories.
        *
        * @publicApi
        *
        * @deprecated
        * Ivy JIT mode doesn't require accessing this symbol.
        * See [JIT API changes due to ViewEngine deprecation](guide/deprecations#jit-api-changes) for
        * additional context.
        */
    export class ModuleWithComponentFactories<T> {
            ngModuleFactory: NgModuleFactory<T>;
            componentFactories: ComponentFactory<any>[];
            constructor(ngModuleFactory: NgModuleFactory<T>, componentFactories: ComponentFactory<any>[]);
    }
    
    /**
        * A wrapper around an NgModule that associates it with [providers](guide/glossary#provider
        * "Definition"). Usage without a generic type is deprecated.
        *
        * @see [Deprecations](guide/deprecations#modulewithproviders-type-without-a-generic)
        *
        * @publicApi
        */
    export interface ModuleWithProviders<T> {
            ngModule: Type<T>;
            providers?: Array<Provider | EnvironmentProviders>;
    }
    
    const MOVED_VIEWS = 9;
    
    type Mutable<T extends {
            [x: string]: any;
    }, K extends string> = {
            [P in K]: T[P];
    };
    
    const NATIVE = 7;
    
    const NEXT = 4;
    
    /**
        * A type describing supported iterable types.
        *
        * @publicApi
        */
    export type NgIterable<T> = Array<T> | Iterable<T>;
    
    /**
        * Type of the NgModule metadata.
        *
        * @publicApi
        */
    export interface NgModule {
            /**
                * The set of injectable objects that are available in the injector
                * of this module.
                *
                * @see [Dependency Injection guide](guide/dependency-injection)
                * @see [NgModule guide](guide/providers)
                *
                * @usageNotes
                *
                * Dependencies whose providers are listed here become available for injection
                * into any component, directive, pipe or service that is a child of this injector.
                * The NgModule used for bootstrapping uses the root injector, and can provide dependencies
                * to any part of the app.
                *
                * A lazy-loaded module has its own injector, typically a child of the app root injector.
                * Lazy-loaded services are scoped to the lazy-loaded module's injector.
                * If a lazy-loaded module also provides the `UserService`, any component created
                * within that module's context (such as by router navigation) gets the local instance
                * of the service, not the instance in the root injector.
                * Components in external modules continue to receive the instance provided by their injectors.
                *
                * ### Example
                *
                * The following example defines a class that is injected in
                * the HelloWorld NgModule:
                *
                * ```
                * class Greeter {
                *    greet(name:string) {
                *      return 'Hello ' + name + '!';
                *    }
                * }
                *
                * @NgModule({
                *   providers: [
                *     Greeter
                *   ]
                * })
                * class HelloWorld {
                *   greeter:Greeter;
                *
                *   constructor(greeter:Greeter) {
                *     this.greeter = greeter;
                *   }
                * }
                * ```
                */
            providers?: Array<Provider | EnvironmentProviders>;
            /**
                * The set of components, directives, and pipes ([declarables](guide/glossary#declarable))
                * that belong to this module.
                *
                * @usageNotes
                *
                * The set of selectors that are available to a template include those declared here, and
                * those that are exported from imported NgModules.
                *
                * Declarables must belong to exactly one module.
                * The compiler emits an error if you try to declare the same class in more than one module.
                * Be careful not to declare a class that is imported from another module.
                *
                * ### Example
                *
                * The following example allows the CommonModule to use the `NgFor`
                * directive.
                *
                * ```javascript
                * @NgModule({
                *   declarations: [NgFor]
                * })
                * class CommonModule {
                * }
                * ```
                */
            declarations?: Array<Type<any> | any[]>;
            /**
                * The set of NgModules whose exported [declarables](guide/glossary#declarable)
                * are available to templates in this module.
                *
                * @usageNotes
                *
                * A template can use exported declarables from any
                * imported module, including those from modules that are imported indirectly
                * and re-exported.
                * For example, `ModuleA` imports `ModuleB`, and also exports
                * it, which makes the declarables from `ModuleB` available
                * wherever `ModuleA` is imported.
                *
                * ### Example
                *
                * The following example allows MainModule to use anything exported by
                * `CommonModule`:
                *
                * ```javascript
                * @NgModule({
                *   imports: [CommonModule]
                * })
                * class MainModule {
                * }
                * ```
                *
                */
            imports?: Array<Type<any> | ModuleWithProviders<{}> | any[]>;
            /**
                * The set of components, directives, and pipes declared in this
                * NgModule that can be used in the template of any component that is part of an
                * NgModule that imports this NgModule. Exported declarations are the module's public API.
                *
                * A declarable belongs to one and only one NgModule.
                * A module can list another module among its exports, in which case all of that module's
                * public declaration are exported.
                *
                * @usageNotes
                *
                * Declarations are private by default.
                * If this ModuleA does not export UserComponent, then only the components within this
                * ModuleA can use UserComponent.
                *
                * ModuleA can import ModuleB and also export it, making exports from ModuleB
                * available to an NgModule that imports ModuleA.
                *
                * ### Example
                *
                * The following example exports the `NgFor` directive from CommonModule.
                *
                * ```javascript
                * @NgModule({
                *   exports: [NgFor]
                * })
                * class CommonModule {
                * }
                * ```
                */
            exports?: Array<Type<any> | any[]>;
            /**
                * The set of components to compile when this NgModule is defined,
                * so that they can be dynamically loaded into the view.
                *
                * For each component listed here, Angular creates a `ComponentFactory`
                * and stores it in the `ComponentFactoryResolver`.
                *
                * Angular automatically adds components in the module's bootstrap
                * and route definitions into the `entryComponents` list. Use this
                * option to add components that are bootstrapped
                * using one of the imperative techniques, such as `ViewContainerRef.createComponent()`.
                *
                * @see [Entry Components](guide/entry-components)
                * @deprecated
                * Since 9.0.0. With Ivy, this property is no longer necessary.
                * (You may need to keep these if building a library that will be consumed by a View Engine
                * application.)
                */
            entryComponents?: Array<Type<any> | any[]>;
            /**
                * The set of components that are bootstrapped when
                * this module is bootstrapped. The components listed here
                * are automatically added to `entryComponents`.
                */
            bootstrap?: Array<Type<any> | any[]>;
            /**
                * The set of schemas that declare elements to be allowed in the NgModule.
                * Elements and properties that are neither Angular components nor directives
                * must be declared in a schema.
                *
                * Allowed value are `NO_ERRORS_SCHEMA` and `CUSTOM_ELEMENTS_SCHEMA`.
                *
                * @security When using one of `NO_ERRORS_SCHEMA` or `CUSTOM_ELEMENTS_SCHEMA`
                * you must ensure that allowed elements and properties securely escape inputs.
                */
            schemas?: Array<SchemaMetadata | any[]>;
            /**
                * A name or path that uniquely identifies this NgModule in `getNgModuleById`.
                * If left `undefined`, the NgModule is not registered with `getNgModuleById`.
                */
            id?: string;
            /**
                * When present, this module is ignored by the AOT compiler.
                * It remains in distributed code, and the JIT compiler attempts to compile it
                * at run time, in the browser.
                * To ensure the correct behavior, the app must import `@angular/compiler`.
                */
            jit?: true;
    }
    
    /**
        * @Annotation
        * @publicApi
        */
    export const NgModule: NgModuleDecorator;
    
    /**
        * Type of the NgModule decorator / constructor function.
        *
        * @publicApi
        */
    export interface NgModuleDecorator {
            /**
                * Decorator that marks a class as an NgModule and supplies configuration metadata.
                */
            (obj?: NgModule): TypeDecorator;
            new (obj?: NgModule): NgModule;
    }
    
    /**
        * @publicApi
        *
        * @deprecated
        * This class was mostly used as a part of ViewEngine-based JIT API and is no longer needed in Ivy
        * JIT mode. See [JIT API changes due to ViewEngine deprecation](guide/deprecations#jit-api-changes)
        * for additional context. Angular provides APIs that accept NgModule classes directly (such as
        * [PlatformRef.bootstrapModule](api/core/PlatformRef#bootstrapModule) and
        * [createNgModule](api/core/createNgModule)), consider switching to those APIs instead of
        * using factory-based ones.
        */
    export abstract class NgModuleFactory<T> {
            abstract get moduleType(): Type<T>;
            abstract create(parentInjector: Injector | null): NgModuleRef<T>;
    }
    
    /**
        * Represents an instance of an `NgModule` created by an `NgModuleFactory`.
        * Provides access to the `NgModule` instance and related objects.
        *
        * @publicApi
        */
    export abstract class NgModuleRef<T> {
            /**
                * The injector that contains all of the providers of the `NgModule`.
                */
            abstract get injector(): EnvironmentInjector;
            /**
                * The resolver that can retrieve component factories in a context of this module.
                *
                * Note: since v13, dynamic component creation via
                * [`ViewContainerRef.createComponent`](api/core/ViewContainerRef#createComponent)
                * does **not** require resolving component factory: component class can be used directly.
                *
                * @deprecated Angular no longer requires Component factories. Please use other APIs where
                *     Component class can be used directly.
                */
            abstract get componentFactoryResolver(): ComponentFactoryResolver;
            /**
                * The `NgModule` instance.
                */
            abstract get instance(): T;
            /**
                * Destroys the module instance and all of the data structures associated with it.
                */
            abstract destroy(): void;
            /**
                * Registers a callback to be executed when the module is destroyed.
                */
            abstract onDestroy(callback: () => void): void;
    }
    
    /**
        * A token for third-party components that can register themselves with NgProbe.
        *
        * @publicApi
        */
    export class NgProbeToken {
            name: string;
            token: any;
            constructor(name: string, token: any);
    }
    
    /**
        * An injectable service for executing work inside or outside of the Angular zone.
        *
        * The most common use of this service is to optimize performance when starting a work consisting of
        * one or more asynchronous tasks that don't require UI updates or error handling to be handled by
        * Angular. Such tasks can be kicked off via {@link #runOutsideAngular} and if needed, these tasks
        * can reenter the Angular zone via {@link #run}.
        *
        * <!-- TODO: add/fix links to:
        *   - docs explaining zones and the use of zones in Angular and change-detection
        *   - link to runOutsideAngular/run (throughout this file!)
        *   -->
        *
        * @usageNotes
        * ### Example
        *
        * ```
        * import {Component, NgZone} from '@angular/core';
        * import {NgIf} from '@angular/common';
        *
        * @Component({
        *   selector: 'ng-zone-demo',
        *   template: `
        *     <h2>Demo: NgZone</h2>
        *
        *     <p>Progress: {{progress}}%</p>
        *     <p *ngIf="progress >= 100">Done processing {{label}} of Angular zone!</p>
        *
        *     <button (click)="processWithinAngularZone()">Process within Angular zone</button>
        *     <button (click)="processOutsideOfAngularZone()">Process outside of Angular zone</button>
        *   `,
        * })
        * export class NgZoneDemo {
        *   progress: number = 0;
        *   label: string;
        *
        *   constructor(private _ngZone: NgZone) {}
        *
        *   // Loop inside the Angular zone
        *   // so the UI DOES refresh after each setTimeout cycle
        *   processWithinAngularZone() {
        *     this.label = 'inside';
        *     this.progress = 0;
        *     this._increaseProgress(() => console.log('Inside Done!'));
        *   }
        *
        *   // Loop outside of the Angular zone
        *   // so the UI DOES NOT refresh after each setTimeout cycle
        *   processOutsideOfAngularZone() {
        *     this.label = 'outside';
        *     this.progress = 0;
        *     this._ngZone.runOutsideAngular(() => {
        *       this._increaseProgress(() => {
        *         // reenter the Angular zone and display done
        *         this._ngZone.run(() => { console.log('Outside Done!'); });
        *       });
        *     });
        *   }
        *
        *   _increaseProgress(doneCallback: () => void) {
        *     this.progress += 1;
        *     console.log(`Current progress: ${this.progress}%`);
        *
        *     if (this.progress < 100) {
        *       window.setTimeout(() => this._increaseProgress(doneCallback), 10);
        *     } else {
        *       doneCallback();
        *     }
        *   }
        * }
        * ```
        *
        * @publicApi
        */
    export class NgZone {
            readonly hasPendingMacrotasks: boolean;
            readonly hasPendingMicrotasks: boolean;
            /**
                * Whether there are no outstanding microtasks or macrotasks.
                */
            readonly isStable: boolean;
            /**
                * Notifies when code enters Angular Zone. This gets fired first on VM Turn.
                */
            readonly onUnstable: EventEmitter<any>;
            /**
                * Notifies when there is no more microtasks enqueued in the current VM Turn.
                * This is a hint for Angular to do change detection, which may enqueue more microtasks.
                * For this reason this event can fire multiple times per VM Turn.
                */
            readonly onMicrotaskEmpty: EventEmitter<any>;
            /**
                * Notifies when the last `onMicrotaskEmpty` has run and there are no more microtasks, which
                * implies we are about to relinquish VM turn.
                * This event gets called just once.
                */
            readonly onStable: EventEmitter<any>;
            /**
                * Notifies that an error has been delivered.
                */
            readonly onError: EventEmitter<any>;
            constructor({ enableLongStackTrace, shouldCoalesceEventChangeDetection, shouldCoalesceRunChangeDetection }: {
                    enableLongStackTrace?: boolean | undefined;
                    shouldCoalesceEventChangeDetection?: boolean | undefined;
                    shouldCoalesceRunChangeDetection?: boolean | undefined;
            });
            static isInAngularZone(): boolean;
            static assertInAngularZone(): void;
            static assertNotInAngularZone(): void;
            /**
                * Executes the `fn` function synchronously within the Angular zone and returns value returned by
                * the function.
                *
                * Running functions via `run` allows you to reenter Angular zone from a task that was executed
                * outside of the Angular zone (typically started via {@link #runOutsideAngular}).
                *
                * Any future tasks or microtasks scheduled from within this function will continue executing from
                * within the Angular zone.
                *
                * If a synchronous error happens it will be rethrown and not reported via `onError`.
                */
            run<T>(fn: (...args: any[]) => T, applyThis?: any, applyArgs?: any[]): T;
            /**
                * Executes the `fn` function synchronously within the Angular zone as a task and returns value
                * returned by the function.
                *
                * Running functions via `run` allows you to reenter Angular zone from a task that was executed
                * outside of the Angular zone (typically started via {@link #runOutsideAngular}).
                *
                * Any future tasks or microtasks scheduled from within this function will continue executing from
                * within the Angular zone.
                *
                * If a synchronous error happens it will be rethrown and not reported via `onError`.
                */
            runTask<T>(fn: (...args: any[]) => T, applyThis?: any, applyArgs?: any[], name?: string): T;
            /**
                * Same as `run`, except that synchronous errors are caught and forwarded via `onError` and not
                * rethrown.
                */
            runGuarded<T>(fn: (...args: any[]) => T, applyThis?: any, applyArgs?: any[]): T;
            /**
                * Executes the `fn` function synchronously in Angular's parent zone and returns value returned by
                * the function.
                *
                * Running functions via {@link #runOutsideAngular} allows you to escape Angular's zone and do
                * work that
                * doesn't trigger Angular change-detection or is subject to Angular's error handling.
                *
                * Any future tasks or microtasks scheduled from within this function will continue executing from
                * outside of the Angular zone.
                *
                * Use {@link #run} to reenter the Angular zone and do work that updates the application model.
                */
            runOutsideAngular<T>(fn: (...args: any[]) => T): T;
    }
    
    /**
        * Defines a schema that allows any property on any element.
        *
        * This schema allows you to ignore the errors related to any unknown elements or properties in a
        * template. The usage of this schema is generally discouraged because it prevents useful validation
        * and may hide real errors in your template. Consider using the `CUSTOM_ELEMENTS_SCHEMA` instead.
        *
        * @publicApi
        */
    export const NO_ERRORS_SCHEMA: SchemaMetadata;
    
    /**
        * @description
        * A lifecycle hook that is called when any data-bound property of a directive changes.
        * Define an `ngOnChanges()` method to handle the changes.
        *
        * @see `DoCheck`
        * @see `OnInit`
        * @see [Lifecycle hooks guide](guide/lifecycle-hooks)
        *
        * @usageNotes
        * The following snippet shows how a component can implement this interface to
        * define an on-changes handler for an input property.
        *
        * {@example core/ts/metadata/lifecycle_hooks_spec.ts region='OnChanges'}
        *
        * @publicApi
        */
    export interface OnChanges {
            /**
                * A callback method that is invoked immediately after the
                * default change detector has checked data-bound properties
                * if at least one has changed, and before the view and content
                * children are checked.
                * @param changes The changed properties.
                */
            ngOnChanges(changes: SimpleChanges): void;
    }
    
    /**
        * A lifecycle hook that is called when a directive, pipe, or service is destroyed.
        * Use for any custom cleanup that needs to occur when the
        * instance is destroyed.
        * @see [Lifecycle hooks guide](guide/lifecycle-hooks)
        *
        * @usageNotes
        * The following snippet shows how a component can implement this interface
        * to define its own custom clean-up method.
        *
        * {@example core/ts/metadata/lifecycle_hooks_spec.ts region='OnDestroy'}
        *
        * @publicApi
        */
    export interface OnDestroy {
            /**
                * A callback method that performs custom clean-up, invoked immediately
                * before a directive, pipe, or service instance is destroyed.
                */
            ngOnDestroy(): void;
    }
    
    /**
        * @description
        * A lifecycle hook that is called after Angular has initialized
        * all data-bound properties of a directive.
        * Define an `ngOnInit()` method to handle any additional initialization tasks.
        *
        * @see `AfterContentInit`
        * @see [Lifecycle hooks guide](guide/lifecycle-hooks)
        *
        * @usageNotes
        * The following snippet shows how a component can implement this interface to
        * define its own initialization method.
        *
        * {@example core/ts/metadata/lifecycle_hooks_spec.ts region='OnInit'}
        *
        * @publicApi
        */
    export interface OnInit {
            /**
                * A callback method that is invoked immediately after the
                * default change detector has checked the directive's
                * data-bound properties for the first time,
                * and before any of the view or content children have been checked.
                * It is invoked only once when the directive is instantiated.
                */
            ngOnInit(): void;
    }
    
    type OpaqueValue = unknown;
    
    interface OpaqueViewState {
            '__brand__': 'Brand for OpaqueViewState that nothing will match';
    }
    
    /**
        * Type of the Optional metadata.
        *
        * @publicApi
        */
    export interface Optional {
    }
    
    /**
        * Optional decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const Optional: OptionalDecorator;
    
    /**
        * Type of the Optional decorator / constructor function.
        *
        * @publicApi
        */
    export interface OptionalDecorator {
            /**
                * Parameter decorator to be used on constructor parameters,
                * which marks the parameter as being an optional dependency.
                * The DI framework provides `null` if the dependency is not found.
                *
                * Can be used together with other parameter decorators
                * that modify how dependency injection operates.
                *
                * @usageNotes
                *
                * The following code allows the possibility of a `null` result:
                *
                * <code-example path="core/di/ts/metadata_spec.ts" region="Optional">
                * </code-example>
                *
                * @see ["Dependency Injection Guide"](guide/dependency-injection).
                */
            (): any;
            new (): Optional;
    }
    
    /**
        * Type of the Output metadata.
        *
        * @publicApi
        */
    export interface Output {
            /**
                * The name of the DOM property to which the output property is bound.
                */
            bindingPropertyName?: string;
    }
    
    /**
        * @Annotation
        * @publicApi
        */
    export const Output: OutputDecorator;
    
    /**
        * Type of the Output decorator / constructor function.
        *
        * @publicApi
        */
    export interface OutputDecorator {
            /**
                * Decorator that marks a class field as an output property and supplies configuration metadata.
                * The DOM property bound to the output property is automatically updated during change detection.
                *
                * @usageNotes
                *
                * You can supply an optional name to use in templates when the
                * component is instantiated, that maps to the
                * name of the bound property. By default, the original
                * name of the bound property is used for output binding.
                *
                * See `Input` decorator for an example of providing a binding name.
                *
                * @see [Input and Output properties](guide/inputs-outputs)
                *
                */
            (bindingPropertyName?: string): any;
            new (bindingPropertyName?: string): any;
    }
    
    /**
        * A [DI token](guide/glossary#di-token "DI token definition") that indicates the root directory of
        * the application
        * @publicApi
        */
    export const PACKAGE_ROOT_URL: InjectionToken<string>;
    
    const PARENT = 3;
    
    /**
        * Type of the Pipe metadata.
        *
        * @publicApi
        */
    export interface Pipe {
            /**
                * The pipe name to use in template bindings.
                * Typically uses [lowerCamelCase](guide/glossary#case-types)
                * because the name cannot contain hyphens.
                */
            name: string;
            /**
                * When true, the pipe is pure, meaning that the
                * `transform()` method is invoked only when its input arguments
                * change. Pipes are pure by default.
                *
                * If the pipe has internal state (that is, the result
                * depends on state other than its arguments), set `pure` to false.
                * In this case, the pipe is invoked on each change-detection cycle,
                * even if the arguments have not changed.
                */
            pure?: boolean;
            /**
                * Angular pipes marked as `standalone` do not need to be declared in an NgModule. Such
                * pipes don't depend on any "intermediate context" of an NgModule (ex. configured providers).
                *
                * More information about standalone components, directives, and pipes can be found in [this
                * guide](guide/standalone-components).
                */
            standalone?: boolean;
    }
    
    /**
        * @Annotation
        * @publicApi
        */
    export const Pipe: PipeDecorator;
    
    /**
        * Type of the Pipe decorator / constructor function.
        *
        * @publicApi
        */
    export interface PipeDecorator {
            /**
                *
                * Decorator that marks a class as pipe and supplies configuration metadata.
                *
                * A pipe class must implement the `PipeTransform` interface.
                * For example, if the name is "myPipe", use a template binding expression
                * such as the following:
                *
                * ```
                * {{ exp | myPipe }}
                * ```
                *
                * The result of the expression is passed to the pipe's `transform()` method.
                *
                * A pipe must belong to an NgModule in order for it to be available
                * to a template. To make it a member of an NgModule,
                * list it in the `declarations` field of the `NgModule` metadata.
                *
                * @see [Style Guide: Pipe Names](guide/styleguide#02-09)
                *
                */
            (obj: Pipe): TypeDecorator;
            /**
                * See the `Pipe` decorator.
                */
            new (obj: Pipe): Pipe;
    }
    
    type PipeDefList = ɵPipeDef<any>[];
    
    /**
        * Type used for PipeDefs on component definition.
        *
        * The function is necessary to be able to support forward declarations.
        */
    type PipeDefListOrFactory = (() => PipeDefList) | PipeDefList;
    
    
    /**
        * An interface that is implemented by pipes in order to perform a transformation.
        * Angular invokes the `transform` method with the value of a binding
        * as the first argument, and any parameters as the second argument in list form.
        *
        * @usageNotes
        *
        * In the following example, `TruncatePipe` returns the shortened value with an added ellipses.
        *
        * <code-example path="core/ts/pipes/simple_truncate.ts" header="simple_truncate.ts"></code-example>
        *
        * Invoking `{{ 'It was the best of times' | truncate }}` in a template will produce `It was...`.
        *
        * In the following example, `TruncatePipe` takes parameters that sets the truncated length and the
        * string to append with.
        *
        * <code-example path="core/ts/pipes/truncate.ts" header="truncate.ts"></code-example>
        *
        * Invoking `{{ 'It was the best of times' | truncate:4:'....' }}` in a template will produce `It
        * was the best....`.
        *
        * @publicApi
        */
    export interface PipeTransform {
            transform(value: any, ...args: any[]): any;
    }
    
    /**
        * A subclass of `Type` which has a static `ɵpipe`:`PipeDef` field making it
        * consumable for rendering.
        */
    interface PipeType<T> extends Type<T> {
            ɵpipe: unknown;
    }
    
    /**
        * A token that indicates an opaque platform ID.
        * @publicApi
        */
    export const PLATFORM_ID: InjectionToken<Object>;
    
    /**
        * A function that is executed when a platform is initialized.
        * @publicApi
        */
    export const PLATFORM_INITIALIZER: InjectionToken<(() => void)[]>;
    
    /**
        * This platform has to be included in any other platform
        *
        * @publicApi
        */
    export const platformCore: (extraProviders?: StaticProvider[] | undefined) => PlatformRef;
    
    /**
        * The Angular platform is the entry point for Angular on a web page.
        * Each page has exactly one platform. Services (such as reflection) which are common
        * to every Angular application running on the page are bound in its scope.
        * A page's platform is initialized implicitly when a platform is created using a platform
        * factory such as `PlatformBrowser`, or explicitly by calling the `createPlatform()` function.
        *
        * @publicApi
        */
    export class PlatformRef {
            /**
                * Creates an instance of an `@NgModule` for the given platform.
                *
                * @deprecated Passing NgModule factories as the `PlatformRef.bootstrapModuleFactory` function
                *     argument is deprecated. Use the `PlatformRef.bootstrapModule` API instead.
                */
            bootstrapModuleFactory<M>(moduleFactory: NgModuleFactory<M>, options?: BootstrapOptions): Promise<NgModuleRef<M>>;
            /**
                * Creates an instance of an `@NgModule` for a given platform.
                *
                * @usageNotes
                * ### Simple Example
                *
                * ```typescript
                * @NgModule({
                *   imports: [BrowserModule]
                * })
                * class MyModule {}
                *
                * let moduleRef = platformBrowser().bootstrapModule(MyModule);
                * ```
                *
                */
            bootstrapModule<M>(moduleType: Type<M>, compilerOptions?: (CompilerOptions & BootstrapOptions) | Array<CompilerOptions & BootstrapOptions>): Promise<NgModuleRef<M>>;
            /**
                * Registers a listener to be called when the platform is destroyed.
                */
            onDestroy(callback: () => void): void;
            /**
                * Retrieves the platform {@link Injector}, which is the parent injector for
                * every Angular application on the page and provides singleton providers.
                */
            get injector(): Injector;
            /**
                * Destroys the current Angular platform and all Angular applications on the page.
                * Destroys all modules and listeners registered with the platform.
                */
            destroy(): void;
            /**
                * Indicates whether this instance was destroyed.
                */
            get destroyed(): boolean;
            static ɵfac: i0.ɵɵFactoryDeclaration<PlatformRef, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<PlatformRef>;
    }
    
    interface PlatformReflectionCapabilities {
            factory(type: Type<any>): Function;
            hasLifecycleHook(type: any, lcProperty: string): boolean;
            /**
                * Return a list of annotations/types for constructor parameters
                */
            parameters(type: Type<any>): any[][];
            /**
                * Return a list of annotations declared on the class
                */
            annotations(type: Type<any>): any[];
            /**
                * Return a object literal which describes the annotations on Class fields/properties.
                */
            propMetadata(typeOrFunc: Type<any>): {
                    [key: string]: any[];
            };
    }
    
    /**
        * A boolean-valued function over a value, possibly including context information
        * regarding that value's position in an array.
        *
        * @publicApi
        */
    export interface Predicate<T> {
            (value: T): boolean;
    }
    
    const PREORDER_HOOK_FLAGS = 18;
    
    /** More flags associated with an LView (saved in LView[PREORDER_HOOK_FLAGS]) */
    const enum PreOrderHookFlags {
            /**
             The index of the next pre-order hook to be called in the hooks array, on the first 16
             bits
                */
            IndexOfTheNextPreOrderHookMaskMask = 65535,
            /**
                * The number of init hooks that have already been called, on the last 16 bits
                */
            NumberOfInitHooksCalledIncrementer = 65536,
            NumberOfInitHooksCalledShift = 16,
            NumberOfInitHooksCalledMask = 4294901760
    }
    
    /**
        * Describes a function that is used to process provider lists (such as provider
        * overrides).
        */
    type ProcessProvidersFunction = (providers: Provider[]) => Provider[];
    
    /**
        * List of slots for a projection. A slot can be either based on a parsed CSS selector
        * which will be used to determine nodes which are projected into that slot.
        *
        * When set to "*", the slot is reserved and can be used for multi-slot projection
        * using {@link ViewContainerRef#createComponent}. The last slot that specifies the
        * wildcard selector will retrieve all projectable nodes which do not match any selector.
        */
    type ProjectionSlots = (ɵCssSelectorList | '*')[];
    
    /**
        * This mapping is necessary so we can set input properties and output listeners
        * properly at runtime when property names are minified or aliased.
        *
        * Key: unminified / public input or output name
        * Value: array containing minified / internal name and related directive index
        *
        * The value must be an array to support inputs and outputs with the same name
        * on the same node.
        */
    type PropertyAliases = {
            [key: string]: PropertyAliasValue;
    };
    
    /**
        * Store the runtime input or output names for all the directives.
        *
        * i+0: directive instance index
        * i+1: privateName
        *
        * e.g. [0, 'change-minified']
        */
    type PropertyAliasValue = (number | string)[];
    
    /**
        * Describes how the `Injector` should be configured.
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @see `StaticProvider`
        *
        * @publicApi
        */
    export type Provider = TypeProvider | ValueProvider | ClassProvider | ConstructorProvider | ExistingProvider | FactoryProvider | any[];
    
    /**
        * @description
        *
        * Token that can be used to retrieve an instance from an injector or through a query.
        *
        * @publicApi
        */
    export type ProviderToken<T> = Type<T> | AbstractType<T> | InjectionToken<T>;
    
    /**
        * Testability API.
        * `declare` keyword causes tsickle to generate externs, so these methods are
        * not renamed by Closure Compiler.
        * @publicApi
        */
    interface PublicTestability {
            isStable(): boolean;
            whenStable(callback: Function, timeout?: number, updateCallback?: Function): void;
            findProviders(using: any, provider: string, exactMatch: boolean): any[];
    }
    
    const QUERIES = 19;
    
    /**
        * Type of the Query metadata.
        *
        * @publicApi
        */
    export interface Query {
            descendants: boolean;
            emitDistinctChangesOnly: boolean;
            first: boolean;
            read: any;
            isViewQuery: boolean;
            selector: any;
            static?: boolean;
    }
    
    /**
        * Base class for query metadata.
        *
        * @see `ContentChildren`.
        * @see `ContentChild`.
        * @see `ViewChildren`.
        * @see `ViewChild`.
        *
        * @publicApi
        */
    export abstract class Query {
    }
    
    /**
        * A set of flags to be used with Queries.
        *
        * NOTE: Ensure changes here are reflected in `packages/compiler/src/render3/view/compiler.ts`
        */
    const enum QueryFlags {
            /**
                * No flags
                */
            none = 0,
            /**
                * Whether or not the query should descend into children.
                */
            descendants = 1,
            /**
                * The query can be computed statically and hence can be assigned eagerly.
                *
                * NOTE: Backwards compatibility with ViewEngine.
                */
            isStatic = 2,
            /**
                * If the `QueryList` should fire change event only if actual change to query was computed (vs old
                * behavior where the change was fired whenever the query was recomputed, even if the recomputed
                * query resulted in the same list.)
                */
            emitDistinctChangesOnly = 4
    }
    
    /**
        * An unmodifiable list of items that Angular keeps up to date when the state
        * of the application changes.
        *
        * The type of object that {@link ViewChildren}, {@link ContentChildren}, and {@link QueryList}
        * provide.
        *
        * Implements an iterable interface, therefore it can be used in both ES6
        * javascript `for (var i of items)` loops as well as in Angular templates with
        * `*ngFor="let i of myList"`.
        *
        * Changes can be observed by subscribing to the changes `Observable`.
        *
        * NOTE: In the future this class will implement an `Observable` interface.
        *
        * @usageNotes
        * ### Example
        * ```typescript
        * @Component({...})
        * class Container {
        *   @ViewChildren(Item) items:QueryList<Item>;
        * }
        * ```
        *
        * @publicApi
        */
    export class QueryList<T> implements Iterable<T> {
            readonly dirty = true;
            readonly length: number;
            readonly first: T;
            readonly last: T;
            /**
                * Returns `Observable` of `QueryList` notifying the subscriber of changes.
                */
            get changes(): Observable<any>;
            /**
                * @param emitDistinctChangesOnly Whether `QueryList.changes` should fire only when actual change
                *     has occurred. Or if it should fire when query is recomputed. (recomputing could resolve in
                *     the same result)
                */
            constructor(_emitDistinctChangesOnly?: boolean);
            /**
                * Returns the QueryList entry at `index`.
                */
            get(index: number): T | undefined;
            /**
                * See
                * [Array.map](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/map)
                */
            map<U>(fn: (item: T, index: number, array: T[]) => U): U[];
            /**
                * See
                * [Array.filter](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/filter)
                */
            filter(fn: (item: T, index: number, array: T[]) => boolean): T[];
            /**
                * See
                * [Array.find](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/find)
                */
            find(fn: (item: T, index: number, array: T[]) => boolean): T | undefined;
            /**
                * See
                * [Array.reduce](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduce)
                */
            reduce<U>(fn: (prevValue: U, curValue: T, curIndex: number, array: T[]) => U, init: U): U;
            /**
                * See
                * [Array.forEach](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach)
                */
            forEach(fn: (item: T, index: number, array: T[]) => void): void;
            /**
                * See
                * [Array.some](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some)
                */
            some(fn: (value: T, index: number, array: T[]) => boolean): boolean;
            /**
                * Returns a copy of the internal results list as an Array.
                */
            toArray(): T[];
            toString(): string;
            /**
                * Updates the stored data of the query list, and resets the `dirty` flag to `false`, so that
                * on change detection, it will not notify of changes to the queries, unless a new change
                * occurs.
                *
                * @param resultsTree The query results to store
                * @param identityAccessor Optional function for extracting stable object identity from a value
                *    in the array. This function is executed for each element of the query result list while
                *    comparing current query list with the new one (provided as a first argument of the `reset`
                *    function) to detect if the lists are different. If the function is not provided, elements
                *    are compared as is (without any pre-processing).
                */
            reset(resultsTree: Array<T | any[]>, identityAccessor?: (value: T) => unknown): void;
            /**
                * Triggers a change event by emitting on the `changes` {@link EventEmitter}.
                */
            notifyOnChanges(): void;
            /** internal */
            setDirty(): void;
            /** internal */
            destroy(): void;
            [Symbol.iterator]: () => Iterator<T>;
    }
    
    interface R3DeclareComponentFacade extends R3DeclareDirectiveFacade {
            template: string;
            isInline?: boolean;
            styles?: string[];
            dependencies?: R3DeclareTemplateDependencyFacade[];
            components?: R3DeclareDirectiveDependencyFacade[];
            directives?: R3DeclareDirectiveDependencyFacade[];
            pipes?: {
                    [pipeName: string]: OpaqueValue | (() => OpaqueValue);
            };
            viewProviders?: OpaqueValue;
            animations?: OpaqueValue;
            changeDetection?: ChangeDetectionStrategy_2;
            encapsulation?: ViewEncapsulation_2;
            interpolation?: [string, string];
            preserveWhitespaces?: boolean;
    }
    
    interface R3DeclareDependencyMetadataFacade {
            token: OpaqueValue;
            attribute?: boolean;
            host?: boolean;
            optional?: boolean;
            self?: boolean;
            skipSelf?: boolean;
    }
    
    interface R3DeclareDirectiveDependencyFacade {
            kind?: 'directive' | 'component';
            selector: string;
            type: OpaqueValue | (() => OpaqueValue);
            inputs?: string[];
            outputs?: string[];
            exportAs?: string[];
    }
    
    interface R3DeclareDirectiveFacade {
            selector?: string;
            type: Type_2;
            inputs?: {
                    [classPropertyName: string]: string | [string, string];
            };
            outputs?: {
                    [classPropertyName: string]: string;
            };
            host?: {
                    attributes?: {
                            [key: string]: OpaqueValue;
                    };
                    listeners?: {
                            [key: string]: string;
                    };
                    properties?: {
                            [key: string]: string;
                    };
                    classAttribute?: string;
                    styleAttribute?: string;
            };
            queries?: R3DeclareQueryMetadataFacade[];
            viewQueries?: R3DeclareQueryMetadataFacade[];
            providers?: OpaqueValue;
            exportAs?: string[];
            usesInheritance?: boolean;
            usesOnChanges?: boolean;
            isStandalone?: boolean;
            hostDirectives?: R3HostDirectiveMetadataFacade[] | null;
    }
    
    interface R3DeclareFactoryFacade {
            type: Type_2;
            deps: R3DeclareDependencyMetadataFacade[] | 'invalid' | null;
            target: ɵɵFactoryTarget;
    }
    
    interface R3DeclareInjectableFacade {
            type: Type_2;
            providedIn?: Type_2 | 'root' | 'platform' | 'any' | null;
            useClass?: OpaqueValue;
            useFactory?: OpaqueValue;
            useExisting?: OpaqueValue;
            useValue?: OpaqueValue;
            deps?: R3DeclareDependencyMetadataFacade[];
    }
    
    interface R3DeclareInjectorFacade {
            type: Type_2;
            imports?: OpaqueValue[];
            providers?: OpaqueValue[];
    }
    
    interface R3DeclareNgModuleDependencyFacade {
            kind: 'ngmodule';
            type: OpaqueValue | (() => OpaqueValue);
    }
    
    interface R3DeclareNgModuleFacade {
            type: Type_2;
            bootstrap?: OpaqueValue[] | (() => OpaqueValue[]);
            declarations?: OpaqueValue[] | (() => OpaqueValue[]);
            imports?: OpaqueValue[] | (() => OpaqueValue[]);
            exports?: OpaqueValue[] | (() => OpaqueValue[]);
            schemas?: OpaqueValue[];
            id?: OpaqueValue;
    }
    
    interface R3DeclarePipeDependencyFacade {
            kind?: 'pipe';
            name: string;
            type: OpaqueValue | (() => OpaqueValue);
    }
    
    interface R3DeclarePipeFacade {
            type: Type_2;
            name: string;
            pure?: boolean;
            isStandalone?: boolean;
    }
    
    interface R3DeclareQueryMetadataFacade {
            propertyName: string;
            first?: boolean;
            predicate: OpaqueValue | string[];
            descendants?: boolean;
            read?: OpaqueValue;
            static?: boolean;
            emitDistinctChangesOnly?: boolean;
    }
    
    type R3DeclareTemplateDependencyFacade = {
            kind: string;
    } & (R3DeclareDirectiveDependencyFacade | R3DeclarePipeDependencyFacade | R3DeclareNgModuleDependencyFacade);
    
    interface R3HostDirectiveMetadataFacade {
            directive: Type_2;
            inputs?: string[];
            outputs?: string[];
    }
    
    class R3Injector extends EnvironmentInjector {
            readonly parent: Injector;
            readonly source: string | null;
            readonly scopes: Set<InjectorScope>;
            /**
                * Flag indicating that this injector was previously destroyed.
                */
            get destroyed(): boolean;
            constructor(providers: Array<Provider | EnvironmentProviders>, parent: Injector, source: string | null, scopes: Set<InjectorScope>);
            /**
                * Destroy the injector and release references to every instance or provider associated with it.
                *
                * Also calls the `OnDestroy` lifecycle hooks of every instance that was created for which a
                * hook was found.
                */
            destroy(): void;
            onDestroy(callback: () => void): void;
            runInContext<ReturnT>(fn: () => ReturnT): ReturnT;
            get<T>(token: ProviderToken<T>, notFoundValue?: any, flags?: InjectFlags | InjectOptions): T;
            toString(): string;
    }
    
    interface RComment extends RNode {
            textContent: string | null;
    }
    
    interface RCssStyleDeclaration {
            removeProperty(propertyName: string): string;
            setProperty(propertyName: string, value: string | null, priority?: string): void;
    }
    
    interface RDomTokenList {
            add(token: string): void;
            remove(token: string): void;
    }
    
    /**
        * Creates an object that allows to retrieve component metadata.
        *
        * @usageNotes
        *
        * The example below demonstrates how to use the function and how the fields
        * of the returned object map to the component metadata.
        *
        * ```typescript
        * @Component({
        *   standalone: true,
        *   selector: 'foo-component',
        *   template: `
        *     <ng-content></ng-content>
        *     <ng-content select="content-selector-a"></ng-content>
        *   `,
        * })
        * class FooComponent {
        *   @Input('inputName') inputPropName: string;
        *   @Output('outputName') outputPropName = new EventEmitter<void>();
        * }
        *
        * const mirror = reflectComponentType(FooComponent);
        * expect(mirror.type).toBe(FooComponent);
        * expect(mirror.selector).toBe('foo-component');
        * expect(mirror.isStandalone).toBe(true);
        * expect(mirror.inputs).toEqual([{propName: 'inputName', templateName: 'inputPropName'}]);
        * expect(mirror.outputs).toEqual([{propName: 'outputName', templateName: 'outputPropName'}]);
        * expect(mirror.ngContentSelectors).toEqual([
        *   '*',                 // first `<ng-content>` in a template, the selector defaults to `*`
        *   'content-selector-a' // second `<ng-content>` in a template
        * ]);
        * ```
        *
        * @param component Component class reference.
        * @returns An object that allows to retrieve component metadata.
        *
        * @publicApi
        */
    export function reflectComponentType<C>(component: Type<C>): ComponentMirror<C> | null;
    
    /**
        * `Dependency` is used by the framework to extend DI.
        * This is internal to Angular and should not be used directly.
        */
    class ReflectiveDependency {
            key: ReflectiveKey;
            optional: boolean;
            visibility: Self | SkipSelf | null;
            constructor(key: ReflectiveKey, optional: boolean, visibility: Self | SkipSelf | null);
            static fromKey(key: ReflectiveKey): ReflectiveDependency;
    }
    
    /**
        * A ReflectiveDependency injection container used for instantiating objects and resolving
        * dependencies.
        *
        * An `Injector` is a replacement for a `new` operator, which can automatically resolve the
        * constructor dependencies.
        *
        * In typical use, application code asks for the dependencies in the constructor and they are
        * resolved by the `Injector`.
        *
        * @usageNotes
        * ### Example
        *
        * The following example creates an `Injector` configured to create `Engine` and `Car`.
        *
        * ```typescript
        * @Injectable()
        * class Engine {
        * }
        *
        * @Injectable()
        * class Car {
        *   constructor(public engine:Engine) {}
        * }
        *
        * var injector = ReflectiveInjector.resolveAndCreate([Car, Engine]);
        * var car = injector.get(Car);
        * expect(car instanceof Car).toBe(true);
        * expect(car.engine instanceof Engine).toBe(true);
        * ```
        *
        * Notice, we don't use the `new` operator because we explicitly want to have the `Injector`
        * resolve all of the object's dependencies automatically.
        *
        * TODO: delete in v14.
        *
        * @deprecated from v5 - slow and brings in a lot of code, Use `Injector.create` instead.
        * @publicApi
        */
    export abstract class ReflectiveInjector implements Injector {
            /**
                * Turns an array of provider definitions into an array of resolved providers.
                *
                * A resolution is a process of flattening multiple nested arrays and converting individual
                * providers into an array of `ResolvedReflectiveProvider`s.
                *
                * @usageNotes
                * ### Example
                *
                * ```typescript
                * @Injectable()
                * class Engine {
                * }
                *
                * @Injectable()
                * class Car {
                *   constructor(public engine:Engine) {}
                * }
                *
                * var providers = ReflectiveInjector.resolve([Car, [[Engine]]]);
                *
                * expect(providers.length).toEqual(2);
                *
                * expect(providers[0] instanceof ResolvedReflectiveProvider).toBe(true);
                * expect(providers[0].key.displayName).toBe("Car");
                * expect(providers[0].dependencies.length).toEqual(1);
                * expect(providers[0].factory).toBeDefined();
                *
                * expect(providers[1].key.displayName).toBe("Engine");
                * });
                * ```
                *
                */
            static resolve(providers: Provider[]): ResolvedReflectiveProvider[];
            /**
                * Resolves an array of providers and creates an injector from those providers.
                *
                * The passed-in providers can be an array of `Type`, `Provider`,
                * or a recursive array of more providers.
                *
                * @usageNotes
                * ### Example
                *
                * ```typescript
                * @Injectable()
                * class Engine {
                * }
                *
                * @Injectable()
                * class Car {
                *   constructor(public engine:Engine) {}
                * }
                *
                * var injector = ReflectiveInjector.resolveAndCreate([Car, Engine]);
                * expect(injector.get(Car) instanceof Car).toBe(true);
                * ```
                */
            static resolveAndCreate(providers: Provider[], parent?: Injector): ReflectiveInjector;
            /**
                * Creates an injector from previously resolved providers.
                *
                * This API is the recommended way to construct injectors in performance-sensitive parts.
                *
                * @usageNotes
                * ### Example
                *
                * ```typescript
                * @Injectable()
                * class Engine {
                * }
                *
                * @Injectable()
                * class Car {
                *   constructor(public engine:Engine) {}
                * }
                *
                * var providers = ReflectiveInjector.resolve([Car, Engine]);
                * var injector = ReflectiveInjector.fromResolvedProviders(providers);
                * expect(injector.get(Car) instanceof Car).toBe(true);
                * ```
                */
            static fromResolvedProviders(providers: ResolvedReflectiveProvider[], parent?: Injector): ReflectiveInjector;
            /**
                * Parent of this injector.
                *
                * <!-- TODO: Add a link to the section of the user guide talking about hierarchical injection.
                * -->
                */
            abstract get parent(): Injector | null;
            /**
                * Resolves an array of providers and creates a child injector from those providers.
                *
                * <!-- TODO: Add a link to the section of the user guide talking about hierarchical injection.
                * -->
                *
                * The passed-in providers can be an array of `Type`, `Provider`,
                * or a recursive array of more providers.
                *
                * @usageNotes
                * ### Example
                *
                * ```typescript
                * class ParentProvider {}
                * class ChildProvider {}
                *
                * var parent = ReflectiveInjector.resolveAndCreate([ParentProvider]);
                * var child = parent.resolveAndCreateChild([ChildProvider]);
                *
                * expect(child.get(ParentProvider) instanceof ParentProvider).toBe(true);
                * expect(child.get(ChildProvider) instanceof ChildProvider).toBe(true);
                * expect(child.get(ParentProvider)).toBe(parent.get(ParentProvider));
                * ```
                */
            abstract resolveAndCreateChild(providers: Provider[]): ReflectiveInjector;
            /**
                * Creates a child injector from previously resolved providers.
                *
                * <!-- TODO: Add a link to the section of the user guide talking about hierarchical injection.
                * -->
                *
                * This API is the recommended way to construct injectors in performance-sensitive parts.
                *
                * @usageNotes
                * ### Example
                *
                * ```typescript
                * class ParentProvider {}
                * class ChildProvider {}
                *
                * var parentProviders = ReflectiveInjector.resolve([ParentProvider]);
                * var childProviders = ReflectiveInjector.resolve([ChildProvider]);
                *
                * var parent = ReflectiveInjector.fromResolvedProviders(parentProviders);
                * var child = parent.createChildFromResolved(childProviders);
                *
                * expect(child.get(ParentProvider) instanceof ParentProvider).toBe(true);
                * expect(child.get(ChildProvider) instanceof ChildProvider).toBe(true);
                * expect(child.get(ParentProvider)).toBe(parent.get(ParentProvider));
                * ```
                */
            abstract createChildFromResolved(providers: ResolvedReflectiveProvider[]): ReflectiveInjector;
            /**
                * Resolves a provider and instantiates an object in the context of the injector.
                *
                * The created object does not get cached by the injector.
                *
                * @usageNotes
                * ### Example
                *
                * ```typescript
                * @Injectable()
                * class Engine {
                * }
                *
                * @Injectable()
                * class Car {
                *   constructor(public engine:Engine) {}
                * }
                *
                * var injector = ReflectiveInjector.resolveAndCreate([Engine]);
                *
                * var car = injector.resolveAndInstantiate(Car);
                * expect(car.engine).toBe(injector.get(Engine));
                * expect(car).not.toBe(injector.resolveAndInstantiate(Car));
                * ```
                */
            abstract resolveAndInstantiate(provider: Provider): any;
            /**
                * Instantiates an object using a resolved provider in the context of the injector.
                *
                * The created object does not get cached by the injector.
                *
                * @usageNotes
                * ### Example
                *
                * ```typescript
                * @Injectable()
                * class Engine {
                * }
                *
                * @Injectable()
                * class Car {
                *   constructor(public engine:Engine) {}
                * }
                *
                * var injector = ReflectiveInjector.resolveAndCreate([Engine]);
                * var carProvider = ReflectiveInjector.resolve([Car])[0];
                * var car = injector.instantiateResolved(carProvider);
                * expect(car.engine).toBe(injector.get(Engine));
                * expect(car).not.toBe(injector.instantiateResolved(carProvider));
                * ```
                */
            abstract instantiateResolved(provider: ResolvedReflectiveProvider): any;
            abstract get(token: any, notFoundValue?: any): any;
    }
    
    
    /**
        * A unique object used for retrieving items from the {@link ReflectiveInjector}.
        *
        * Keys have:
        * - a system-wide unique `id`.
        * - a `token`.
        *
        * `Key` is used internally by {@link ReflectiveInjector} because its system-wide unique `id` allows
        * the
        * injector to store created objects in a more efficient way.
        *
        * `Key` should not be created directly. {@link ReflectiveInjector} creates keys automatically when
        * resolving
        * providers.
        *
        * @deprecated No replacement
        * @publicApi
        */
    export class ReflectiveKey {
            token: Object;
            id: number;
            readonly displayName: string;
            /**
                * Private
                */
            constructor(token: Object, id: number);
            /**
                * Retrieves a `Key` for a token.
                */
            static get(token: Object): ReflectiveKey;
            /**
                * @returns the number of keys registered in the system.
                */
            static get numberOfKeys(): number;
    }
    
    /**
        * Subset of API needed for writing attributes, properties, and setting up
        * listeners on Element.
        */
    interface RElement extends RNode {
            style: RCssStyleDeclaration;
            classList: RDomTokenList;
            className: string;
            tagName: string;
            textContent: string | null;
            setAttribute(name: string, value: string | TrustedHTML | TrustedScript | TrustedScriptURL): void;
            removeAttribute(name: string): void;
            setAttributeNS(namespaceURI: string, qualifiedName: string, value: string | TrustedHTML | TrustedScript | TrustedScriptURL): void;
            addEventListener(type: string, listener: EventListener, useCapture?: boolean): void;
            removeEventListener(type: string, listener?: EventListener, options?: boolean): void;
            setProperty?(name: string, value: any): void;
    }
    
    const RENDERER = 11;
    
    /**
        * Procedural style of API needed to create elements and text nodes.
        *
        * In non-native browser environments (e.g. platforms such as web-workers), this is the
        * facade that enables element manipulation. In practice, this is implemented by `Renderer2`.
        */
    interface Renderer {
            destroy(): void;
            createComment(value: string): RComment;
            createElement(name: string, namespace?: string | null): RElement;
            createText(value: string): RText;
            /**
                * This property is allowed to be null / undefined,
                * in which case the view engine won't call it.
                * This is used as a performance optimization for production mode.
                */
            destroyNode?: ((node: RNode) => void) | null;
            appendChild(parent: RElement, newChild: RNode): void;
            insertBefore(parent: RNode, newChild: RNode, refChild: RNode | null, isMove?: boolean): void;
            removeChild(parent: RElement, oldChild: RNode, isHostElement?: boolean): void;
            selectRootElement(selectorOrNode: string | any, preserveContent?: boolean): RElement;
            parentNode(node: RNode): RElement | null;
            nextSibling(node: RNode): RNode | null;
            setAttribute(el: RElement, name: string, value: string | TrustedHTML | TrustedScript | TrustedScriptURL, namespace?: string | null): void;
            removeAttribute(el: RElement, name: string, namespace?: string | null): void;
            addClass(el: RElement, name: string): void;
            removeClass(el: RElement, name: string): void;
            setStyle(el: RElement, style: string, value: any, flags?: RendererStyleFlags2): void;
            removeStyle(el: RElement, style: string, flags?: RendererStyleFlags2): void;
            setProperty(el: RElement, name: string, value: any): void;
            setValue(node: RText | RComment, value: string): void;
            listen(target: GlobalTargetName | RNode, eventName: string, callback: (event: any) => boolean | void): () => void;
    }
    
    /**
        * Extend this base class to implement custom rendering. By default, Angular
        * renders a template into DOM. You can use custom rendering to intercept
        * rendering calls, or to render to something other than DOM.
        *
        * Create your custom renderer using `RendererFactory2`.
        *
        * Use a custom renderer to bypass Angular's templating and
        * make custom UI changes that can't be expressed declaratively.
        * For example if you need to set a property or an attribute whose name is
        * not statically known, use the `setProperty()` or
        * `setAttribute()` method.
        *
        * @publicApi
        */
    export abstract class Renderer2 {
            /**
                * Use to store arbitrary developer-defined data on a renderer instance,
                * as an object containing key-value pairs.
                * This is useful for renderers that delegate to other renderers.
                */
            abstract get data(): {
                    [key: string]: any;
            };
            /**
                * Implement this callback to destroy the renderer or the host element.
                */
            abstract destroy(): void;
            /**
                * Implement this callback to create an instance of the host element.
                * @param name An identifying name for the new element, unique within the namespace.
                * @param namespace The namespace for the new element.
                * @returns The new element.
                */
            abstract createElement(name: string, namespace?: string | null): any;
            /**
                * Implement this callback to add a comment to the DOM of the host element.
                * @param value The comment text.
                * @returns The modified element.
                */
            abstract createComment(value: string): any;
            /**
                * Implement this callback to add text to the DOM of the host element.
                * @param value The text string.
                * @returns The modified element.
                */
            abstract createText(value: string): any;
            /**
                * If null or undefined, the view engine won't call it.
                * This is used as a performance optimization for production mode.
                */
            destroyNode: ((node: any) => void) | null;
            /**
                * Appends a child to a given parent node in the host element DOM.
                * @param parent The parent node.
                * @param newChild The new child node.
                */
            abstract appendChild(parent: any, newChild: any): void;
            /**
                * Implement this callback to insert a child node at a given position in a parent node
                * in the host element DOM.
                * @param parent The parent node.
                * @param newChild The new child nodes.
                * @param refChild The existing child node before which `newChild` is inserted.
                * @param isMove Optional argument which signifies if the current `insertBefore` is a result of a
                *     move. Animation uses this information to trigger move animations. In the past the Animation
                *     would always assume that any `insertBefore` is a move. This is not strictly true because
                *     with runtime i18n it is possible to invoke `insertBefore` as a result of i18n and it should
                *     not trigger an animation move.
                */
            abstract insertBefore(parent: any, newChild: any, refChild: any, isMove?: boolean): void;
            /**
                * Implement this callback to remove a child node from the host element's DOM.
                * @param parent The parent node.
                * @param oldChild The child node to remove.
                * @param isHostElement Optionally signal to the renderer whether this element is a host element
                * or not
                */
            abstract removeChild(parent: any, oldChild: any, isHostElement?: boolean): void;
            /**
                * Implement this callback to prepare an element to be bootstrapped
                * as a root element, and return the element instance.
                * @param selectorOrNode The DOM element.
                * @param preserveContent Whether the contents of the root element
                * should be preserved, or cleared upon bootstrap (default behavior).
                * Use with `ViewEncapsulation.ShadowDom` to allow simple native
                * content projection via `<slot>` elements.
                * @returns The root element.
                */
            abstract selectRootElement(selectorOrNode: string | any, preserveContent?: boolean): any;
            /**
                * Implement this callback to get the parent of a given node
                * in the host element's DOM.
                * @param node The child node to query.
                * @returns The parent node, or null if there is no parent.
                * For WebWorkers, always returns true.
                * This is because the check is synchronous,
                * and the caller can't rely on checking for null.
                */
            abstract parentNode(node: any): any;
            /**
                * Implement this callback to get the next sibling node of a given node
                * in the host element's DOM.
                * @returns The sibling node, or null if there is no sibling.
                * For WebWorkers, always returns a value.
                * This is because the check is synchronous,
                * and the caller can't rely on checking for null.
                */
            abstract nextSibling(node: any): any;
            /**
                * Implement this callback to set an attribute value for an element in the DOM.
                * @param el The element.
                * @param name The attribute name.
                * @param value The new value.
                * @param namespace The namespace.
                */
            abstract setAttribute(el: any, name: string, value: string, namespace?: string | null): void;
            /**
                * Implement this callback to remove an attribute from an element in the DOM.
                * @param el The element.
                * @param name The attribute name.
                * @param namespace The namespace.
                */
            abstract removeAttribute(el: any, name: string, namespace?: string | null): void;
            /**
                * Implement this callback to add a class to an element in the DOM.
                * @param el The element.
                * @param name The class name.
                */
            abstract addClass(el: any, name: string): void;
            /**
                * Implement this callback to remove a class from an element in the DOM.
                * @param el The element.
                * @param name The class name.
                */
            abstract removeClass(el: any, name: string): void;
            /**
                * Implement this callback to set a CSS style for an element in the DOM.
                * @param el The element.
                * @param style The name of the style.
                * @param value The new value.
                * @param flags Flags for style variations. No flags are set by default.
                */
            abstract setStyle(el: any, style: string, value: any, flags?: RendererStyleFlags2): void;
            /**
                * Implement this callback to remove the value from a CSS style for an element in the DOM.
                * @param el The element.
                * @param style The name of the style.
                * @param flags Flags for style variations to remove, if set. ???
                */
            abstract removeStyle(el: any, style: string, flags?: RendererStyleFlags2): void;
            /**
                * Implement this callback to set the value of a property of an element in the DOM.
                * @param el The element.
                * @param name The property name.
                * @param value The new value.
                */
            abstract setProperty(el: any, name: string, value: any): void;
            /**
                * Implement this callback to set the value of a node in the host element.
                * @param node The node.
                * @param value The new value.
                */
            abstract setValue(node: any, value: string): void;
            /**
                * Implement this callback to start an event listener.
                * @param target The context in which to listen for events. Can be
                * the entire window or document, the body of the document, or a specific
                * DOM element.
                * @param eventName The event to listen for.
                * @param callback A handler function to invoke when the event occurs.
                * @returns An "unlisten" function for disposing of this handler.
                */
            abstract listen(target: 'window' | 'document' | 'body' | any, eventName: string, callback: (event: any) => boolean | void): () => void;
    }
    
    const RENDERER_FACTORY = 10;
    
    interface RendererFactory {
            createRenderer(hostElement: RElement | null, rendererType: RendererType2 | null): Renderer;
            begin?(): void;
            end?(): void;
    }
    
    /**
        * Creates and initializes a custom renderer that implements the `Renderer2` base class.
        *
        * @publicApi
        */
    export abstract class RendererFactory2 {
            /**
                * Creates and initializes a custom renderer for a host DOM element.
                * @param hostElement The element to render.
                * @param type The base class to implement.
                * @returns The new custom renderer instance.
                */
            abstract createRenderer(hostElement: any, type: RendererType2 | null): Renderer2;
            /**
                * A callback invoked when rendering has begun.
                */
            abstract begin?(): void;
            /**
                * A callback invoked when rendering has completed.
                */
            abstract end?(): void;
            /**
                * Use with animations test-only mode. Notifies the test when rendering has completed.
                * @returns The asynchronous result of the developer-defined function.
                */
            abstract whenRenderingDone?(): Promise<any>;
    }
    
    /**
        * Flags for renderer-specific style modifiers.
        * @publicApi
        */
    export enum RendererStyleFlags2 {
            /**
                * Marks a style as important.
                */
            Important = 1,
            /**
                * Marks a style as using dash case naming (this-is-dash-case).
                */
            DashCase = 2
    }
    
    /**
        * Used by `RendererFactory2` to associate custom rendering data and styles
        * with a rendering implementation.
        *  @publicApi
        */
    export interface RendererType2 {
            /**
                * A unique identifying string for the new renderer, used when creating
                * unique styles for encapsulation.
                */
            id: string;
            /**
                * The view encapsulation type, which determines how styles are applied to
                * DOM elements. One of
                * - `Emulated` (default): Emulate native scoping of styles.
                * - `Native`: Use the native encapsulation mechanism of the renderer.
                * - `ShadowDom`: Use modern [Shadow
                * DOM](https://w3c.github.io/webcomponents/spec/shadow/) and
                * create a ShadowRoot for component's host element.
                * - `None`: Do not provide any template or style encapsulation.
                */
            encapsulation: ViewEncapsulation;
            /**
                * Defines CSS styles to be stored on a renderer instance.
                */
            styles: (string | any[])[];
            /**
                * Defines arbitrary developer-defined data to be stored on a renderer instance.
                * This is useful for renderers that delegate to other renderers.
                */
            data: {
                    [kind: string]: any;
            };
    }
    
    /**
        * An internal resolved representation of a factory function created by resolving `Provider`.
        * @publicApi
        */
    export class ResolvedReflectiveFactory {
            /**
                * Factory function which can return an instance of an object represented by a key.
                */
            factory: Function;
            /**
                * Arguments (dependencies) to the `factory` function.
                */
            dependencies: ReflectiveDependency[];
            constructor(
            /**
                * Factory function which can return an instance of an object represented by a key.
                */
            factory: Function, 
            /**
                * Arguments (dependencies) to the `factory` function.
                */
            dependencies: ReflectiveDependency[]);
    }
    
    /**
        * An internal resolved representation of a `Provider` used by the `Injector`.
        *
        * @usageNotes
        * This is usually created automatically by `Injector.resolveAndCreate`.
        *
        * It can be created manually, as follows:
        *
        * ### Example
        *
        * ```typescript
        * var resolvedProviders = Injector.resolve([{ provide: 'message', useValue: 'Hello' }]);
        * var injector = Injector.fromResolvedProviders(resolvedProviders);
        *
        * expect(injector.get('message')).toEqual('Hello');
        * ```
        *
        * @publicApi
        */
    export interface ResolvedReflectiveProvider {
            /**
                * A key, usually a `Type<any>`.
                */
            key: ReflectiveKey;
            /**
                * Factory function which can return an instance of an object represented by a key.
                */
            resolvedFactories: ResolvedReflectiveFactory[];
            /**
                * Indicates if the provider is a multi-provider or a regular provider.
                */
            multiProvider: boolean;
    }
    
    /**
        * Lazily retrieves the reference value from a forwardRef.
        *
        * Acts as the identity function when given a non-forward-ref value.
        *
        * @usageNotes
        * ### Example
        *
        * {@example core/di/ts/forward_ref/forward_ref_spec.ts region='resolve_forward_ref'}
        *
        * @see `forwardRef`
        * @publicApi
        */
    export function resolveForwardRef<T>(type: T): T;
    
    /** Subset of API needed for appending elements and text nodes. */
    interface RNode {
            /**
                * Returns the parent Element, Document, or DocumentFragment
                */
            parentNode: RNode | null;
            /**
                * Returns the parent Element if there is one
                */
            parentElement: RElement | null;
            /**
                * Gets the Node immediately following this one in the parent's childNodes
                */
            nextSibling: RNode | null;
            /**
                * Removes a child from the current node and returns the removed node
                * @param oldChild the child node to remove
                */
            removeChild(oldChild: RNode): RNode;
            /**
                * Insert a child node.
                *
                * Used exclusively for adding View root nodes into ViewAnchor location.
                */
            insertBefore(newChild: RNode, refChild: RNode | null, isViewRoot: boolean): void;
            /**
                * Append a child node.
                *
                * Used exclusively for building up DOM which are static (ie not View roots)
                */
            appendChild(newChild: RNode): RNode;
    }
    
    interface RText extends RNode {
            textContent: string | null;
    }
    
    
    /**
        * The list of error codes used in runtime code of the `core` package.
        * Reserved error code range: 100-999.
        *
        * Note: the minus sign denotes the fact that a particular code has a detailed guide on
        * angular.io. This extra annotation is needed to avoid introducing a separate set to store
        * error codes which have guides, which might leak into runtime code.
        *
        * Full list of available error guides can be found at https://angular.io/errors.
        */
    const enum RuntimeErrorCode {
            EXPRESSION_CHANGED_AFTER_CHECKED = -100,
            RECURSIVE_APPLICATION_REF_TICK = 101,
            CYCLIC_DI_DEPENDENCY = -200,
            PROVIDER_NOT_FOUND = -201,
            INVALID_FACTORY_DEPENDENCY = 202,
            MISSING_INJECTION_CONTEXT = -203,
            INVALID_INJECTION_TOKEN = 204,
            INJECTOR_ALREADY_DESTROYED = 205,
            PROVIDER_IN_WRONG_CONTEXT = 207,
            MISSING_INJECTION_TOKEN = 208,
            INVALID_MULTI_PROVIDER = -209,
            MULTIPLE_COMPONENTS_MATCH = -300,
            EXPORT_NOT_FOUND = -301,
            PIPE_NOT_FOUND = -302,
            UNKNOWN_BINDING = 303,
            UNKNOWN_ELEMENT = 304,
            TEMPLATE_STRUCTURE_ERROR = 305,
            INVALID_EVENT_BINDING = 306,
            HOST_DIRECTIVE_UNRESOLVABLE = 307,
            HOST_DIRECTIVE_NOT_STANDALONE = 308,
            DUPLICATE_DIRECTITVE = 309,
            HOST_DIRECTIVE_COMPONENT = 310,
            HOST_DIRECTIVE_UNDEFINED_BINDING = 311,
            HOST_DIRECTIVE_CONFLICTING_ALIAS = 312,
            MULTIPLE_PLATFORMS = 400,
            PLATFORM_NOT_FOUND = 401,
            ERROR_HANDLER_NOT_FOUND = 402,
            BOOTSTRAP_COMPONENTS_NOT_FOUND = -403,
            PLATFORM_ALREADY_DESTROYED = 404,
            ASYNC_INITIALIZERS_STILL_RUNNING = 405,
            APPLICATION_REF_ALREADY_DESTROYED = 406,
            RENDERER_NOT_FOUND = 407,
            INVALID_I18N_STRUCTURE = 700,
            MISSING_LOCALE_DATA = 701,
            IMPORT_PROVIDERS_FROM_STANDALONE = 800,
            INVALID_DIFFER_INPUT = 900,
            NO_SUPPORTING_DIFFER_FACTORY = 901,
            VIEW_ALREADY_ATTACHED = 902,
            INVALID_INHERITANCE = 903,
            UNSAFE_VALUE_IN_RESOURCE_URL = 904,
            UNSAFE_VALUE_IN_SCRIPT = 905,
            MISSING_GENERATED_DEF = 906,
            TYPE_IS_NOT_STANDALONE = 907,
            MISSING_ZONEJS = 908,
            UNEXPECTED_ZONE_STATE = 909,
            UNSAFE_IFRAME_ATTRS = -910
    }
    
    const SANITIZER = 12;
    
    /**
        * Sanitizer is used by the views to sanitize potentially dangerous values.
        *
        * @publicApi
        */
    export abstract class Sanitizer {
            abstract sanitize(context: SecurityContext, value: {} | string | null): string | null;
            /** @nocollapse */
            static ɵprov: unknown;
    }
    
    /**
        * Function used to sanitize the value before writing it into the renderer.
        */
    type SanitizerFn = (value: any, tagName?: string, propName?: string) => string | TrustedHTML | TrustedScript | TrustedScriptURL;
    
    
    /**
        * A schema definition associated with an NgModule.
        *
        * @see `@NgModule`, `CUSTOM_ELEMENTS_SCHEMA`, `NO_ERRORS_SCHEMA`
        *
        * @param name The name of a defined schema.
        *
        * @publicApi
        */
    export interface SchemaMetadata {
            name: string;
    }
    
    
    /**
        * A SecurityContext marks a location that has dangerous security implications, e.g. a DOM property
        * like `innerHTML` that could cause Cross Site Scripting (XSS) security bugs when improperly
        * handled.
        *
        * See DomSanitizer for more details on security in Angular applications.
        *
        * @publicApi
        */
    export enum SecurityContext {
            NONE = 0,
            HTML = 1,
            STYLE = 2,
            SCRIPT = 3,
            URL = 4,
            RESOURCE_URL = 5
    }
    
    /** Flags used to build up CssSelectors */
    const enum SelectorFlags {
            /** Indicates this is the beginning of a new negative selector */
            NOT = 1,
            /** Mode for matching attributes */
            ATTRIBUTE = 2,
            /** Mode for matching tag names */
            ELEMENT = 4,
            /** Mode for matching class names */
            CLASS = 8
    }
    
    /**
        * Type of the Self metadata.
        *
        * @publicApi
        */
    export interface Self {
    }
    
    /**
        * Self decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const Self: SelfDecorator;
    
    /**
        * Type of the Self decorator / constructor function.
        *
        * @publicApi
        */
    export interface SelfDecorator {
            /**
                * Parameter decorator to be used on constructor parameters,
                * which tells the DI framework to start dependency resolution from the local injector.
                *
                * Resolution works upward through the injector hierarchy, so the children
                * of this class must configure their own providers or be prepared for a `null` result.
                *
                * @usageNotes
                *
                * In the following example, the dependency can be resolved
                * by the local injector when instantiating the class itself, but not
                * when instantiating a child.
                *
                * <code-example path="core/di/ts/metadata_spec.ts" region="Self">
                * </code-example>
                *
                * @see `SkipSelf`
                * @see `Optional`
                *
                */
            (): any;
            new (): Self;
    }
    
    /**
        * Set the {@link GetTestability} implementation used by the Angular testing framework.
        * @publicApi
        */
    export function setTestabilityGetter(getter: GetTestability): void;
    
    
    /**
        * Represents a basic change from a previous to a new value for a single
        * property on a directive instance. Passed as a value in a
        * {@link SimpleChanges} object to the `ngOnChanges` hook.
        *
        * @see `OnChanges`
        *
        * @publicApi
        */
    export class SimpleChange {
            previousValue: any;
            currentValue: any;
            firstChange: boolean;
            constructor(previousValue: any, currentValue: any, firstChange: boolean);
            /**
                * Check whether the new value is the first value assigned.
                */
            isFirstChange(): boolean;
    }
    
    /**
        * A hashtable of changes represented by {@link SimpleChange} objects stored
        * at the declared property name they belong to on a Directive or Component. This is
        * the type passed to the `ngOnChanges` hook.
        *
        * @see `OnChanges`
        *
        * @publicApi
        */
    export interface SimpleChanges {
            [propName: string]: SimpleChange;
    }
    
    /**
        * Type of the `SkipSelf` metadata.
        *
        * @publicApi
        */
    export interface SkipSelf {
    }
    
    /**
        * `SkipSelf` decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const SkipSelf: SkipSelfDecorator;
    
    /**
        * Type of the `SkipSelf` decorator / constructor function.
        *
        * @publicApi
        */
    export interface SkipSelfDecorator {
            /**
                * Parameter decorator to be used on constructor parameters,
                * which tells the DI framework to start dependency resolution from the parent injector.
                * Resolution works upward through the injector hierarchy, so the local injector
                * is not checked for a provider.
                *
                * @usageNotes
                *
                * In the following example, the dependency can be resolved when
                * instantiating a child, but not when instantiating the class itself.
                *
                * <code-example path="core/di/ts/metadata_spec.ts" region="SkipSelf">
                * </code-example>
                *
                * @see [Dependency Injection guide](guide/dependency-injection-in-action#skip).
                * @see `Self`
                * @see `Optional`
                *
                */
            (): any;
            new (): SkipSelf;
    }
    
    /**
        * Configures the `Injector` to return an instance of `useClass` for a token.
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @usageNotes
        *
        * {@example core/di/ts/provider_spec.ts region='StaticClassProvider'}
        *
        * Note that following two providers are not equal:
        *
        * {@example core/di/ts/provider_spec.ts region='StaticClassProviderDifference'}
        *
        * ### Multi-value example
        *
        * {@example core/di/ts/provider_spec.ts region='MultiProviderAspect'}
        *
        * @publicApi
        */
    export interface StaticClassProvider extends StaticClassSansProvider {
            /**
                * An injection token. Typically an instance of `Type` or `InjectionToken`, but can be `any`.
                */
            provide: any;
            /**
                * When true, injector returns an array of instances. This is useful to allow multiple
                * providers spread across many files to provide configuration information to a common token.
                */
            multi?: boolean;
    }
    
    /**
        * Configures the `Injector` to return an instance of `useClass` for a token.
        * Base for `StaticClassProvider` decorator.
        *
        * @publicApi
        */
    export interface StaticClassSansProvider {
            /**
                * An optional class to instantiate for the `token`. By default, the `provide`
                * class is instantiated.
                */
            useClass: Type<any>;
            /**
                * A list of `token`s to be resolved by the injector. The list of values is then
                * used as arguments to the `useClass` constructor.
                */
            deps: any[];
    }
    
    /**
        * Describes how an `Injector` should be configured as static (that is, without reflection).
        * A static provider provides tokens to an injector for various types of dependencies.
        *
        * @see `Injector.create()`.
        * @see ["Dependency Injection Guide"](guide/dependency-injection-providers).
        *
        * @publicApi
        */
    export type StaticProvider = ValueProvider | ExistingProvider | StaticClassProvider | ConstructorProvider | FactoryProvider | any[];
    
    const T_HOST = 6;
    
    /**
        * A combination of:
        * - Attribute names and values.
        * - Special markers acting as flags to alter attributes processing.
        * - Parsed ngProjectAs selectors.
        */
    type TAttributes = (string | ɵAttributeMarker | CssSelector)[];
    
    /**
        * Constants that are associated with a view. Includes:
        * - Attribute arrays.
        * - Local definition arrays.
        * - Translated messages (i18n).
        */
    type TConstants = (TAttributes | string)[];
    
    /**
        * Factory function that returns an array of consts. Consts can be represented as a function in
        * case any additional statements are required to define consts in the list. An example is i18n
        * where additional i18n calls are generated, which should be executed when consts are requested
        * for the first time.
        */
    type TConstantsFactory = () => TConstants;
    
    /**
        * TConstants type that describes how the `consts` field is generated on ComponentDef: it can be
        * either an array or a factory function that returns that array.
        */
    type TConstantsOrFactory = TConstants | TConstantsFactory;
    
    /** Static data for an LContainer */
    interface TContainerNode extends TNode {
            /**
                * Index in the data[] array.
                *
                * If it's -1, this is a dynamically created container node that isn't stored in
                * data[] (e.g. when you inject ViewContainerRef) .
                */
            index: number;
            child: null;
            /**
                * Container nodes will have parents unless:
                *
                * - They are the first node of a component or embedded view
                * - They are dynamically created
                */
            parent: TElementNode | TElementContainerNode | null;
            tView: TView | null;
            projection: null;
            value: null;
    }
    
    /**
        * Static data that corresponds to the instance-specific data array on an LView.
        *
        * Each node's static data is stored in tData at the same index that it's stored
        * in the data array.  Any nodes that do not have static data store a null value in
        * tData to avoid a sparse array.
        *
        * Each pipe's definition is stored here at the same index as its pipe instance in
        * the data array.
        *
        * Each host property's name is stored here at the same index as its value in the
        * data array.
        *
        * Each property binding name is stored here at the same index as its value in
        * the data array. If the binding is an interpolation, the static string values
        * are stored parallel to the dynamic values. Example:
        *
        * id="prefix {{ v0 }} a {{ v1 }} b {{ v2 }} suffix"
        *
        * LView       |   TView.data
        *------------------------
        *  v0 value   |   'a'
        *  v1 value   |   'b'
        *  v2 value   |   id � prefix � suffix
        *
        * Injector bloom filters are also stored here.
        */
    type TData = (TNode | ɵPipeDef<any> | ɵDirectiveDef<any> | ɵComponentDef<any> | number | TStylingRange | TStylingKey | ProviderToken<any> | TI18n | I18nUpdateOpCodes | TIcu | null | string)[];
    
    /** Static data for an <ng-container> */
    interface TElementContainerNode extends TNode {
            /** Index in the LView[] array. */
            index: number;
            child: TElementNode | TTextNode | TContainerNode | TElementContainerNode | TProjectionNode | null;
            parent: TElementNode | TElementContainerNode | null;
            tView: null;
            projection: null;
    }
    
    /** Static data for an element  */
    interface TElementNode extends TNode {
            /** Index in the data[] array */
            index: number;
            child: TElementNode | TTextNode | TElementContainerNode | TContainerNode | TProjectionNode | null;
            /**
                * Element nodes will have parents unless they are the first node of a component or
                * embedded view (which means their parent is in a different view and must be
                * retrieved using viewData[HOST_NODE]).
                */
            parent: TElementNode | TElementContainerNode | null;
            tView: null;
            /**
                * If this is a component TNode with projection, this will be an array of projected
                * TNodes or native nodes (see TNode.projection for more info). If it's a regular element node
                * or a component without projection, it will be null.
                */
            projection: (TNode | RNode[])[] | null;
            /**
                * Stores TagName
                */
            value: string;
    }
    
    /**
        * Represents an embedded template that can be used to instantiate embedded views.
        * To instantiate embedded views based on a template, use the `ViewContainerRef`
        * method `createEmbeddedView()`.
        *
        * Access a `TemplateRef` instance by placing a directive on an `<ng-template>`
        * element (or directive prefixed with `*`). The `TemplateRef` for the embedded view
        * is injected into the constructor of the directive,
        * using the `TemplateRef` token.
        *
        * You can also use a `Query` to find a `TemplateRef` associated with
        * a component or a directive.
        *
        * @see `ViewContainerRef`
        * @see [Navigate the Component Tree with DI](guide/dependency-injection-navtree)
        *
        * @publicApi
        */
    export abstract class TemplateRef<C> {
            /**
                * The anchor element in the parent view for this embedded view.
                *
                * The data-binding and injection contexts of embedded views created from this `TemplateRef`
                * inherit from the contexts of this location.
                *
                * Typically new embedded views are attached to the view container of this location, but in
                * advanced use-cases, the view can be attached to a different container while keeping the
                * data-binding and injection context from the original location.
                *
                */
            abstract readonly elementRef: ElementRef;
            /**
                * Instantiates an unattached embedded view based on this template.
                * @param context The data-binding context of the embedded view, as declared
                * in the `<ng-template>` usage.
                * @param injector Injector to be used within the embedded view.
                * @returns The new embedded view object.
                */
            abstract createEmbeddedView(context: C, injector?: Injector): EmbeddedViewRef<C>;
    }
    
    /**
        * The Testability service provides testing hooks that can be accessed from
        * the browser.
        *
        * Angular applications bootstrapped using an NgModule (via `@NgModule.bootstrap` field) will also
        * instantiate Testability by default (in both development and production modes).
        *
        * For applications bootstrapped using the `bootstrapApplication` function, Testability is not
        * included by default. You can include it into your applications by getting the list of necessary
        * providers using the `provideProtractorTestingSupport()` function and adding them into the
        * `options.providers` array. Example:
        *
        * ```typescript
        * import {provideProtractorTestingSupport} from '@angular/platform-browser';
        *
        * await bootstrapApplication(RootComponent, providers: [provideProtractorTestingSupport()]);
        * ```
        *
        * @publicApi
        */
    export class Testability implements PublicTestability {
            constructor(_ngZone: NgZone, registry: TestabilityRegistry, testabilityGetter: GetTestability);
            /**
                * Increases the number of pending request
                * @deprecated pending requests are now tracked with zones.
                */
            increasePendingRequestCount(): number;
            /**
                * Decreases the number of pending request
                * @deprecated pending requests are now tracked with zones
                */
            decreasePendingRequestCount(): number;
            /**
                * Whether an associated application is stable
                */
            isStable(): boolean;
            /**
                * Wait for the application to be stable with a timeout. If the timeout is reached before that
                * happens, the callback receives a list of the macro tasks that were pending, otherwise null.
                *
                * @param doneCb The callback to invoke when Angular is stable or the timeout expires
                *    whichever comes first.
                * @param timeout Optional. The maximum time to wait for Angular to become stable. If not
                *    specified, whenStable() will wait forever.
                * @param updateCb Optional. If specified, this callback will be invoked whenever the set of
                *    pending macrotasks changes. If this callback returns true doneCb will not be invoked
                *    and no further updates will be issued.
                */
            whenStable(doneCb: Function, timeout?: number, updateCb?: Function): void;
            /**
                * Get the number of pending requests
                * @deprecated pending requests are now tracked with zones
                */
            getPendingRequestCount(): number;
            /**
                * Find providers by name
                * @param using The root element to search from
                * @param provider The name of binding variable
                * @param exactMatch Whether using exactMatch
                */
            findProviders(using: any, provider: string, exactMatch: boolean): any[];
            static ɵfac: i0.ɵɵFactoryDeclaration<Testability, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<Testability>;
    }
    
    /**
        * A global registry of {@link Testability} instances for specific elements.
        * @publicApi
        */
    export class TestabilityRegistry {
            /**
                * Registers an application with a testability hook so that it can be tracked
                * @param token token of application, root element
                * @param testability Testability hook
                */
            registerApplication(token: any, testability: Testability): void;
            /**
                * Unregisters an application.
                * @param token token of application, root element
                */
            unregisterApplication(token: any): void;
            /**
                * Unregisters all applications
                */
            unregisterAllApplications(): void;
            /**
                * Get a testability hook associated with the application
                * @param elem root element
                */
            getTestability(elem: any): Testability | null;
            /**
                * Get all registered testabilities
                */
            getAllTestabilities(): Testability[];
            /**
                * Get all registered applications(root elements)
                */
            getAllRootElements(): any[];
            /**
                * Find testability of a node in the Tree
                * @param elem node
                * @param findInAncestors whether finding testability in ancestors if testability was not found in
                * current node
                */
            findTestabilityInTree(elem: Node, findInAncestors?: boolean): Testability | null;
            static ɵfac: i0.ɵɵFactoryDeclaration<TestabilityRegistry, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<TestabilityRegistry>;
    }
    
    /**
        * Store information for the i18n translation block.
        */
    interface TI18n {
            /**
                * A set of OpCodes which will create the Text Nodes and ICU anchors for the translation blocks.
                *
                * NOTE: The ICU anchors are filled in with ICU Update OpCode.
                */
            create: I18nCreateOpCodes;
            /**
                * A set of OpCodes which will be executed on each change detection to determine if any changes to
                * DOM are required.
                */
            update: I18nUpdateOpCodes;
    }
    
    interface TIcu {
            /**
                * Defines the ICU type of `select` or `plural`
                */
            type: IcuType;
            /**
                * Index in `LView` where the anchor node is stored. `<!-- ICU 0:0 -->`
                */
            anchorIdx: number;
            /**
                * Currently selected ICU case pointer.
                *
                * `lView[currentCaseLViewIndex]` stores the currently selected case. This is needed to know how
                * to clean up the current case when transitioning no the new case.
                *
                * If the value stored is:
                * `null`: No current case selected.
                *   `<0`: A flag which means that the ICU just switched and that `icuUpdate` must be executed
                *         regardless of the `mask`. (After the execution the flag is cleared)
                *   `>=0` A currently selected case index.
                */
            currentCaseLViewIndex: number;
            /**
                * A list of case values which the current ICU will try to match.
                *
                * The last value is `other`
                */
            cases: any[];
            /**
                * A set of OpCodes to apply in order to build up the DOM render tree for the ICU
                */
            create: IcuCreateOpCodes[];
            /**
                * A set of OpCodes to apply in order to destroy the DOM render tree for the ICU.
                */
            remove: I18nRemoveOpCodes[];
            /**
                * A set of OpCodes to apply in order to update the DOM render tree for the ICU bindings.
                */
            update: I18nUpdateOpCodes[];
    }
    
    /**
        * Binding data (flyweight) for a particular node that is shared between all templates
        * of a specific type.
        *
        * If a property is:
        *    - PropertyAliases: that property's data was generated and this is it
        *    - Null: that property's data was already generated and nothing was found.
        *    - Undefined: that property's data has not yet been generated
        *
        * see: https://en.wikipedia.org/wiki/Flyweight_pattern for more on the Flyweight pattern
        */
    interface TNode {
            /** The type of the TNode. See TNodeType. */
            type: TNodeType;
            /**
                * Index of the TNode in TView.data and corresponding native element in LView.
                *
                * This is necessary to get from any TNode to its corresponding native element when
                * traversing the node tree.
                *
                * If index is -1, this is a dynamically created container node or embedded view node.
                */
            index: number;
            /**
                * Insert before existing DOM node index.
                *
                * When DOM nodes are being inserted, normally they are being appended as they are created.
                * Under i18n case, the translated text nodes are created ahead of time as part of the
                * `ɵɵi18nStart` instruction which means that this `TNode` can't just be appended and instead
                * needs to be inserted using `insertBeforeIndex` semantics.
                *
                * Additionally sometimes it is necessary to insert new text nodes as a child of this `TNode`. In
                * such a case the value stores an array of text nodes to insert.
                *
                * Example:
                * ```
                * <div i18n>
                *   Hello <span>World</span>!
                * </div>
                * ```
                * In the above example the `ɵɵi18nStart` instruction can create `Hello `, `World` and `!` text
                * nodes. It can also insert `Hello ` and `!` text node as a child of `<div>`, but it can't
                * insert `World` because the `<span>` node has not yet been created. In such a case the
                * `<span>` `TNode` will have an array which will direct the `<span>` to not only insert
                * itself in front of `!` but also to insert the `World` (created by `ɵɵi18nStart`) into
                * `<span>` itself.
                *
                * Pseudo code:
                * ```
                *   if (insertBeforeIndex === null) {
                *     // append as normal
                *   } else if (Array.isArray(insertBeforeIndex)) {
                *     // First insert current `TNode` at correct location
                *     const currentNode = lView[this.index];
                *     parentNode.insertBefore(currentNode, lView[this.insertBeforeIndex[0]]);
                *     // Now append all of the children
                *     for(let i=1; i<this.insertBeforeIndex; i++) {
                *       currentNode.appendChild(lView[this.insertBeforeIndex[i]]);
                *     }
                *   } else {
                *     parentNode.insertBefore(lView[this.index], lView[this.insertBeforeIndex])
                *   }
                * ```
                * - null: Append as normal using `parentNode.appendChild`
                * - `number`: Append using
                *      `parentNode.insertBefore(lView[this.index], lView[this.insertBeforeIndex])`
                *
                * *Initialization*
                *
                * Because `ɵɵi18nStart` executes before nodes are created, on `TView.firstCreatePass` it is not
                * possible for `ɵɵi18nStart` to set the `insertBeforeIndex` value as the corresponding `TNode`
                * has not yet been created. For this reason the `ɵɵi18nStart` creates a `TNodeType.Placeholder`
                * `TNode` at that location. See `TNodeType.Placeholder` for more information.
                */
            insertBeforeIndex: InsertBeforeIndex;
            /**
                * The index of the closest injector in this node's LView.
                *
                * If the index === -1, there is no injector on this node or any ancestor node in this view.
                *
                * If the index !== -1, it is the index of this node's injector OR the index of a parent
                * injector in the same view. We pass the parent injector index down the node tree of a view so
                * it's possible to find the parent injector without walking a potentially deep node tree.
                * Injector indices are not set across view boundaries because there could be multiple component
                * hosts.
                *
                * If tNode.injectorIndex === tNode.parent.injectorIndex, then the index belongs to a parent
                * injector.
                */
            injectorIndex: number;
            /** Stores starting index of the directives. */
            directiveStart: number;
            /**
                * Stores final exclusive index of the directives.
                *
                * The area right behind the `directiveStart-directiveEnd` range is used to allocate the
                * `HostBindingFunction` `vars` (or null if no bindings.) Therefore `directiveEnd` is used to set
                * `LFrame.bindingRootIndex` before `HostBindingFunction` is executed.
                */
            directiveEnd: number;
            /**
                * Offset from the `directiveStart` at which the component (one at most) of the node is stored.
                * Set to -1 if no components have been applied to the node. Component index can be found using
                * `directiveStart + componentOffset`.
                */
            componentOffset: number;
            /**
                * Stores the last directive which had a styling instruction.
                *
                * Initial value of this is `-1` which means that no `hostBindings` styling instruction has
                * executed. As `hostBindings` instructions execute they set the value to the index of the
                * `DirectiveDef` which contained the last `hostBindings` styling instruction.
                *
                * Valid values are:
                * - `-1` No `hostBindings` instruction has executed.
                * - `directiveStart <= directiveStylingLast < directiveEnd`: Points to the `DirectiveDef` of
                * the last styling instruction which executed in the `hostBindings`.
                *
                * This data is needed so that styling instructions know which static styling data needs to be
                * collected from the `DirectiveDef.hostAttrs`. A styling instruction needs to collect all data
                * since last styling instruction.
                */
            directiveStylingLast: number;
            /**
                * Stores indexes of property bindings. This field is only set in the ngDevMode and holds
                * indexes of property bindings so TestBed can get bound property metadata for a given node.
                */
            propertyBindings: number[] | null;
            /**
                * Stores if Node isComponent, isProjected, hasContentQuery, hasClassInput and hasStyleInput
                * etc.
                */
            flags: TNodeFlags;
            /**
                * This number stores two values using its bits:
                *
                * - the index of the first provider on that node (first 16 bits)
                * - the count of view providers from the component on this node (last 16 bits)
                */
            providerIndexes: TNodeProviderIndexes;
            /**
                * The value name associated with this node.
                * if type:
                *   `TNodeType.Text`: text value
                *   `TNodeType.Element`: tag name
                *   `TNodeType.ICUContainer`: `TIcu`
                */
            value: any;
            /**
                * Attributes associated with an element. We need to store attributes to support various
                * use-cases (attribute injection, content projection with selectors, directives matching).
                * Attributes are stored statically because reading them from the DOM would be way too slow for
                * content projection and queries.
                *
                * Since attrs will always be calculated first, they will never need to be marked undefined by
                * other instructions.
                *
                * For regular attributes a name of an attribute and its value alternate in the array.
                * e.g. ['role', 'checkbox']
                * This array can contain flags that will indicate "special attributes" (attributes with
                * namespaces, attributes extracted from bindings and outputs).
                */
            attrs: TAttributes | null;
            /**
                * Same as `TNode.attrs` but contains merged data across all directive host bindings.
                *
                * We need to keep `attrs` as unmerged so that it can be used for attribute selectors.
                * We merge attrs here so that it can be used in a performant way for initial rendering.
                *
                * The `attrs` are merged in first pass in following order:
                * - Component's `hostAttrs`
                * - Directives' `hostAttrs`
                * - Template `TNode.attrs` associated with the current `TNode`.
                */
            mergedAttrs: TAttributes | null;
            /**
                * A set of local names under which a given element is exported in a template and
                * visible to queries. An entry in this array can be created for different reasons:
                * - an element itself is referenced, ex.: `<div #foo>`
                * - a component is referenced, ex.: `<my-cmpt #foo>`
                * - a directive is referenced, ex.: `<my-cmpt #foo="directiveExportAs">`.
                *
                * A given element might have different local names and those names can be associated
                * with a directive. We store local names at even indexes while odd indexes are reserved
                * for directive index in a view (or `-1` if there is no associated directive).
                *
                * Some examples:
                * - `<div #foo>` => `["foo", -1]`
                * - `<my-cmpt #foo>` => `["foo", myCmptIdx]`
                * - `<my-cmpt #foo #bar="directiveExportAs">` => `["foo", myCmptIdx, "bar", directiveIdx]`
                * - `<div #foo #bar="directiveExportAs">` => `["foo", -1, "bar", directiveIdx]`
                */
            localNames: (string | number)[] | null;
            /** Information about input properties that need to be set once from attribute data. */
            initialInputs: InitialInputData | null | undefined;
            /**
                * Input data for all directives on this node. `null` means that there are no directives with
                * inputs on this node.
                */
            inputs: PropertyAliases | null;
            /**
                * Output data for all directives on this node. `null` means that there are no directives with
                * outputs on this node.
                */
            outputs: PropertyAliases | null;
            /**
                * The TView attached to this node.
                *
                * If this TNode corresponds to an LContainer with a template (e.g. structural
                * directive), the template's TView will be stored here.
                *
                * If this TNode corresponds to an element, tView will be `null`.
                */
            tView: TView | null;
            /**
                * The next sibling node. Necessary so we can propagate through the root nodes of a view
                * to insert them or remove them from the DOM.
                */
            next: TNode | null;
            /**
                * The previous sibling node.
                * This simplifies operations when we need a pointer to the previous node.
                */
            prev: TNode | null;
            /**
                * The next projected sibling. Since in Angular content projection works on the node-by-node
                * basis the act of projecting nodes might change nodes relationship at the insertion point
                * (target view). At the same time we need to keep initial relationship between nodes as
                * expressed in content view.
                */
            projectionNext: TNode | null;
            /**
                * First child of the current node.
                *
                * For component nodes, the child will always be a ContentChild (in same view).
                * For embedded view nodes, the child will be in their child view.
                */
            child: TNode | null;
            /**
                * Parent node (in the same view only).
                *
                * We need a reference to a node's parent so we can append the node to its parent's native
                * element at the appropriate time.
                *
                * If the parent would be in a different view (e.g. component host), this property will be null.
                * It's important that we don't try to cross component boundaries when retrieving the parent
                * because the parent will change (e.g. index, attrs) depending on where the component was
                * used (and thus shouldn't be stored on TNode). In these cases, we retrieve the parent through
                * LView.node instead (which will be instance-specific).
                *
                * If this is an inline view node (V), the parent will be its container.
                */
            parent: TElementNode | TContainerNode | null;
            /**
                * List of projected TNodes for a given component host element OR index into the said nodes.
                *
                * For easier discussion assume this example:
                * `<parent>`'s view definition:
                * ```
                * <child id="c1">content1</child>
                * <child id="c2"><span>content2</span></child>
                * ```
                * `<child>`'s view definition:
                * ```
                * <ng-content id="cont1"></ng-content>
                * ```
                *
                * If `Array.isArray(projection)` then `TNode` is a host element:
                * - `projection` stores the content nodes which are to be projected.
                *    - The nodes represent categories defined by the selector: For example:
                *      `<ng-content/><ng-content select="abc"/>` would represent the heads for `<ng-content/>`
                *      and `<ng-content select="abc"/>` respectively.
                *    - The nodes we store in `projection` are heads only, we used `.next` to get their
                *      siblings.
                *    - The nodes `.next` is sorted/rewritten as part of the projection setup.
                *    - `projection` size is equal to the number of projections `<ng-content>`. The size of
                *      `c1` will be `1` because `<child>` has only one `<ng-content>`.
                * - we store `projection` with the host (`c1`, `c2`) rather than the `<ng-content>` (`cont1`)
                *   because the same component (`<child>`) can be used in multiple locations (`c1`, `c2`) and
                * as a result have different set of nodes to project.
                * - without `projection` it would be difficult to efficiently traverse nodes to be projected.
                *
                * If `typeof projection == 'number'` then `TNode` is a `<ng-content>` element:
                * - `projection` is an index of the host's `projection`Nodes.
                *   - This would return the first head node to project:
                *     `getHost(currentTNode).projection[currentTNode.projection]`.
                * - When projecting nodes the parent node retrieved may be a `<ng-content>` node, in which case
                *   the process is recursive in nature.
                *
                * If `projection` is of type `RNode[][]` than we have a collection of native nodes passed as
                * projectable nodes during dynamic component creation.
                */
            projection: (TNode | RNode[])[] | number | null;
            /**
                * A collection of all `style` static values for an element (including from host).
                *
                * This field will be populated if and when:
                *
                * - There are one or more initial `style`s on an element (e.g. `<div style="width:200px;">`)
                * - There are one or more initial `style`s on a directive/component host
                *   (e.g. `@Directive({host: {style: "width:200px;" } }`)
                */
            styles: string | null;
            /**
                * A collection of all `style` static values for an element excluding host sources.
                *
                * Populated when there are one or more initial `style`s on an element
                * (e.g. `<div style="width:200px;">`)
                * Must be stored separately from `tNode.styles` to facilitate setting directive
                * inputs that shadow the `style` property. If we used `tNode.styles` as is for shadowed inputs,
                * we would feed host styles back into directives as "inputs". If we used `tNode.attrs`, we
                * would have to concatenate the attributes on every template pass. Instead, we process once on
                * first create pass and store here.
                */
            stylesWithoutHost: string | null;
            /**
                * A `KeyValueArray` version of residual `styles`.
                *
                * When there are styling instructions than each instruction stores the static styling
                * which is of lower priority than itself. This means that there may be a higher priority
                * styling than the instruction.
                *
                * Imagine:
                * ```
                * <div style="color: highest;" my-dir>
                *
                * @Directive({
                *   host: {
                *     style: 'color: lowest; ',
                *     '[styles.color]': 'exp' // ɵɵstyleProp('color', ctx.exp);
                *   }
                * })
                * ```
                *
                * In the above case:
                * - `color: lowest` is stored with `ɵɵstyleProp('color', ctx.exp);` instruction
                * -  `color: highest` is the residual and is stored here.
                *
                * - `undefined': not initialized.
                * - `null`: initialized but `styles` is `null`
                * - `KeyValueArray`: parsed version of `styles`.
                */
            residualStyles: KeyValueArray<any> | undefined | null;
            /**
                * A collection of all class static values for an element (including from host).
                *
                * This field will be populated if and when:
                *
                * - There are one or more initial classes on an element (e.g. `<div class="one two three">`)
                * - There are one or more initial classes on an directive/component host
                *   (e.g. `@Directive({host: {class: "SOME_CLASS" } }`)
                */
            classes: string | null;
            /**
                * A collection of all class static values for an element excluding host sources.
                *
                * Populated when there are one or more initial classes on an element
                * (e.g. `<div class="SOME_CLASS">`)
                * Must be stored separately from `tNode.classes` to facilitate setting directive
                * inputs that shadow the `class` property. If we used `tNode.classes` as is for shadowed
                * inputs, we would feed host classes back into directives as "inputs". If we used
                * `tNode.attrs`, we would have to concatenate the attributes on every template pass. Instead,
                * we process once on first create pass and store here.
                */
            classesWithoutHost: string | null;
            /**
                * A `KeyValueArray` version of residual `classes`.
                *
                * Same as `TNode.residualStyles` but for classes.
                *
                * - `undefined': not initialized.
                * - `null`: initialized but `classes` is `null`
                * - `KeyValueArray`: parsed version of `classes`.
                */
            residualClasses: KeyValueArray<any> | undefined | null;
            /**
                * Stores the head/tail index of the class bindings.
                *
                * - If no bindings, the head and tail will both be 0.
                * - If there are template bindings, stores the head/tail of the class bindings in the template.
                * - If no template bindings but there are host bindings, the head value will point to the last
                *   host binding for "class" (not the head of the linked list), tail will be 0.
                *
                * See: `style_binding_list.ts` for details.
                *
                * This is used by `insertTStylingBinding` to know where the next styling binding should be
                * inserted so that they can be sorted in priority order.
                */
            classBindings: TStylingRange;
            /**
                * Stores the head/tail index of the class bindings.
                *
                * - If no bindings, the head and tail will both be 0.
                * - If there are template bindings, stores the head/tail of the style bindings in the template.
                * - If no template bindings but there are host bindings, the head value will point to the last
                *   host binding for "style" (not the head of the linked list), tail will be 0.
                *
                * See: `style_binding_list.ts` for details.
                *
                * This is used by `insertTStylingBinding` to know where the next styling binding should be
                * inserted so that they can be sorted in priority order.
                */
            styleBindings: TStylingRange;
    }
    
    /**
        * Corresponds to the TNode.flags property.
        */
    const enum TNodeFlags {
            /** Bit #1 - This bit is set if the node is a host for any directive (including a component) */
            isDirectiveHost = 1,
            /** Bit #2 - This bit is set if the node has been projected */
            isProjected = 2,
            /** Bit #3 - This bit is set if any directive on this node has content queries */
            hasContentQuery = 4,
            /** Bit #4 - This bit is set if the node has any "class" inputs */
            hasClassInput = 8,
            /** Bit #5 - This bit is set if the node has any "style" inputs */
            hasStyleInput = 16,
            /** Bit #6 This bit is set if the node has been detached by i18n */
            isDetached = 32,
            /**
                * Bit #7 - This bit is set if the node has directives with host bindings.
                *
                * This flags allows us to guard host-binding logic and invoke it only on nodes
                * that actually have directives with host bindings.
                */
            hasHostBindings = 64
    }
    
    /**
        * Corresponds to the TNode.providerIndexes property.
        */
    const enum TNodeProviderIndexes {
            /** The index of the first provider on this node is encoded on the least significant bits. */
            ProvidersStartIndexMask = 1048575,
            /**
                * The count of view providers from the component on this node is
                * encoded on the 20 most significant bits.
                */
            CptViewProvidersCountShift = 20,
            CptViewProvidersCountShifter = 1048576
    }
    
    /**
        * TNodeType corresponds to the {@link TNode} `type` property.
        *
        * NOTE: type IDs are such that we use each bit to denote a type. This is done so that we can easily
        * check if the `TNode` is of more than one type.
        *
        * `if (tNode.type === TNodeType.Text || tNode.type === TNode.Element)`
        * can be written as:
        * `if (tNode.type & (TNodeType.Text | TNodeType.Element))`
        *
        * However any given `TNode` can only be of one type.
        */
    const enum TNodeType {
            /**
                * The TNode contains information about a DOM element aka {@link RText}.
                */
            Text = 1,
            /**
                * The TNode contains information about a DOM element aka {@link RElement}.
                */
            Element = 2,
            /**
                * The TNode contains information about an {@link LContainer} for embedded views.
                */
            Container = 4,
            /**
                * The TNode contains information about an `<ng-container>` element {@link RNode}.
                */
            ElementContainer = 8,
            /**
                * The TNode contains information about an `<ng-content>` projection
                */
            Projection = 16,
            /**
                * The TNode contains information about an ICU comment used in `i18n`.
                */
            Icu = 32,
            /**
                * Special node type representing a placeholder for future `TNode` at this location.
                *
                * I18n translation blocks are created before the element nodes which they contain. (I18n blocks
                * can span over many elements.) Because i18n `TNode`s (representing text) are created first they
                * often may need to point to element `TNode`s which are not yet created. In such a case we create
                * a `Placeholder` `TNode`. This allows the i18n to structurally link the `TNode`s together
                * without knowing any information about the future nodes which will be at that location.
                *
                * On `firstCreatePass` When element instruction executes it will try to create a `TNode` at that
                * location. Seeing a `Placeholder` `TNode` already there tells the system that it should reuse
                * existing `TNode` (rather than create a new one) and just update the missing information.
                */
            Placeholder = 64,
            AnyRNode = 3,
            AnyContainer = 12
    }
    
    /**
        * Type representing a set of TNodes that can have local refs (`#foo`) placed on them.
        */
    type TNodeWithLocalRefs = TContainerNode | TElementNode | TElementContainerNode;
    
    /** Static data for an LProjectionNode  */
    interface TProjectionNode extends TNode {
            /** Index in the data[] array */
            child: null;
            /**
                * Projection nodes will have parents unless they are the first node of a component
                * or embedded view (which means their parent is in a different view and must be
                * retrieved using LView.node).
                */
            parent: TElementNode | TElementContainerNode | null;
            tView: null;
            /** Index of the projection node. (See TNode.projection for more info.) */
            projection: number;
            value: null;
    }
    
    /**
        * TQueries represent a collection of individual TQuery objects tracked in a given view. Most of the
        * methods on this interface are simple proxy methods to the corresponding functionality on TQuery.
        */
    interface TQueries {
            /**
                * Adds a new TQuery to a collection of queries tracked in a given view.
                * @param tQuery
                */
            track(tQuery: TQuery): void;
            /**
                * Returns a TQuery instance for at the given index  in the queries array.
                * @param index
                */
            getByIndex(index: number): TQuery;
            /**
                * Returns the number of queries tracked in a given view.
                */
            length: number;
            /**
                * A proxy method that iterates over all the TQueries in a given TView and calls the corresponding
                * `elementStart` on each and every TQuery.
                * @param tView
                * @param tNode
                */
            elementStart(tView: TView, tNode: TNode): void;
            /**
                * A proxy method that iterates over all the TQueries in a given TView and calls the corresponding
                * `elementEnd` on each and every TQuery.
                * @param tNode
                */
            elementEnd(tNode: TNode): void;
            /**
                * A proxy method that iterates over all the TQueries in a given TView and calls the corresponding
                * `template` on each and every TQuery.
                * @param tView
                * @param tNode
                */
            template(tView: TView, tNode: TNode): void;
            /**
                * A proxy method that iterates over all the TQueries in a given TView and calls the corresponding
                * `embeddedTView` on each and every TQuery.
                * @param tNode
                */
            embeddedTView(tNode: TNode): TQueries | null;
    }
    
    /**
        * TQuery objects represent all the query-related data that remain the same from one view instance
        * to another and can be determined on the very first template pass. Most notably TQuery holds all
        * the matches for a given view.
        */
    interface TQuery {
            /**
                * Query metadata extracted from query annotations.
                */
            metadata: TQueryMetadata;
            /**
                * Index of a query in a declaration view in case of queries propagated to en embedded view, -1
                * for queries declared in a given view. We are storing this index so we can find a parent query
                * to clone for an embedded view (when an embedded view is created).
                */
            indexInDeclarationView: number;
            /**
                * Matches collected on the first template pass. Each match is a pair of:
                * - TNode index;
                * - match index;
                *
                * A TNode index can be either:
                * - a positive number (the most common case) to indicate a matching TNode;
                * - a negative number to indicate that a given query is crossing a <ng-template> element and
                * results from views created based on TemplateRef should be inserted at this place.
                *
                * A match index is a number used to find an actual value (for a given node) when query results
                * are materialized. This index can have one of the following values:
                * - -2 - indicates that we need to read a special token (TemplateRef, ViewContainerRef etc.);
                * - -1 - indicates that we need to read a default value based on the node type (TemplateRef for
                * ng-template and ElementRef for other elements);
                * - a positive number - index of an injectable to be read from the element injector.
                */
            matches: number[] | null;
            /**
                * A flag indicating if a given query crosses an <ng-template> element. This flag exists for
                * performance reasons: we can notice that queries not crossing any <ng-template> elements will
                * have matches from a given view only (and adapt processing accordingly).
                */
            crossesNgTemplate: boolean;
            /**
                * A method call when a given query is crossing an element (or element container). This is where a
                * given TNode is matched against a query predicate.
                * @param tView
                * @param tNode
                */
            elementStart(tView: TView, tNode: TNode): void;
            /**
                * A method called when processing the elementEnd instruction - this is mostly useful to determine
                * if a given content query should match any nodes past this point.
                * @param tNode
                */
            elementEnd(tNode: TNode): void;
            /**
                * A method called when processing the template instruction. This is where a
                * given TContainerNode is matched against a query predicate.
                * @param tView
                * @param tNode
                */
            template(tView: TView, tNode: TNode): void;
            /**
                * A query-related method called when an embedded TView is created based on the content of a
                * <ng-template> element. We call this method to determine if a given query should be propagated
                * to the embedded view and if so - return a cloned TQuery for this embedded view.
                * @param tNode
                * @param childQueryIndex
                */
            embeddedTView(tNode: TNode, childQueryIndex: number): TQuery | null;
    }
    
    /**
        * An object representing query metadata extracted from query annotations.
        */
    interface TQueryMetadata {
            predicate: ProviderToken<unknown> | string[];
            read: any;
            flags: QueryFlags;
    }
    
    /**
        * A function optionally passed into the `NgForOf` directive to customize how `NgForOf` uniquely
        * identifies items in an iterable.
        *
        * `NgForOf` needs to uniquely identify items in the iterable to correctly perform DOM updates
        * when items in the iterable are reordered, new items are added, or existing items are removed.
        *
        *
        * In all of these scenarios it is usually desirable to only update the DOM elements associated
        * with the items affected by the change. This behavior is important to:
        *
        * - preserve any DOM-specific UI state (like cursor position, focus, text selection) when the
        *   iterable is modified
        * - enable animation of item addition, removal, and iterable reordering
        * - preserve the value of the `<select>` element when nested `<option>` elements are dynamically
        *   populated using `NgForOf` and the bound iterable is updated
        *
        * A common use for custom `trackBy` functions is when the model that `NgForOf` iterates over
        * contains a property with a unique identifier. For example, given a model:
        *
        * ```ts
        * class User {
        *   id: number;
        *   name: string;
        *   ...
        * }
        * ```
        * a custom `trackBy` function could look like the following:
        * ```ts
        * function userTrackBy(index, user) {
        *   return user.id;
        * }
        * ```
        *
        * A custom `trackBy` function must have several properties:
        *
        * - be [idempotent](https://en.wikipedia.org/wiki/Idempotence) (be without side effects, and always
        * return the same value for a given input)
        * - return unique value for all unique inputs
        * - be fast
        *
        * @see [`NgForOf#ngForTrackBy`](api/common/NgForOf#ngForTrackBy)
        * @publicApi
        */
    export interface TrackByFunction<T> {
            /**
                * @param index The index of the item within the iterable.
                * @param item The item in the iterable.
                */
            <U extends T>(index: number, item: T & U): any;
    }
    
    /**
        * Use this token at bootstrap to provide the content of your translation file (`xtb`,
        * `xlf` or `xlf2`) when you want to translate your application in another language.
        *
        * See the [i18n guide](guide/i18n-common-merge) for more information.
        *
        * @usageNotes
        * ### Example
        *
        * ```typescript
        * import { TRANSLATIONS } from '@angular/core';
        * import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
        * import { AppModule } from './app/app.module';
        *
        * // content of your translation file
        * const translations = '....';
        *
        * platformBrowserDynamic().bootstrapModule(AppModule, {
        *   providers: [{provide: TRANSLATIONS, useValue: translations }]
        * });
        * ```
        *
        * @publicApi
        */
    export const TRANSLATIONS: InjectionToken<string>;
    
    /**
        * Provide this token at bootstrap to set the format of your {@link TRANSLATIONS}: `xtb`,
        * `xlf` or `xlf2`.
        *
        * See the [i18n guide](guide/i18n-common-merge) for more information.
        *
        * @usageNotes
        * ### Example
        *
        * ```typescript
        * import { TRANSLATIONS_FORMAT } from '@angular/core';
        * import { platformBrowserDynamic } from '@angular/platform-browser-dynamic';
        * import { AppModule } from './app/app.module';
        *
        * platformBrowserDynamic().bootstrapModule(AppModule, {
        *   providers: [{provide: TRANSLATIONS_FORMAT, useValue: 'xlf' }]
        * });
        * ```
        *
        * @publicApi
        */
    export const TRANSLATIONS_FORMAT: InjectionToken<string>;
    
    const TRANSPLANTED_VIEWS_TO_REFRESH = 5;
    
    
    /**
        * @fileoverview
        * While Angular only uses Trusted Types internally for the time being,
        * references to Trusted Types could leak into our core.d.ts, which would force
        * anyone compiling against @angular/core to provide the @types/trusted-types
        * package in their compilation unit.
        *
        * Until https://github.com/microsoft/TypeScript/issues/30024 is resolved, we
        * will keep Angular's public API surface free of references to Trusted Types.
        * For internal and semi-private APIs that need to reference Trusted Types, the
        * minimal type definitions for the Trusted Types API provided by this module
        * should be used instead. They are marked as "declare" to prevent them from
        * being renamed by compiler optimization.
        *
        * Adapted from
        * https://github.com/DefinitelyTyped/DefinitelyTyped/blob/master/types/trusted-types/index.d.ts
        * but restricted to the API surface used within Angular.
        */
    interface TrustedHTML {
            __brand__: 'TrustedHTML';
    }
    
    interface TrustedScript {
            __brand__: 'TrustedScript';
    }
    
    interface TrustedScriptURL {
            __brand__: 'TrustedScriptURL';
    }
    
    /**
        * Value stored in the `TData` which is needed to re-concatenate the styling.
        *
        * See: `TStylingKeyPrimitive` and `TStylingStatic`
        */
    type TStylingKey = TStylingKeyPrimitive | TStylingStatic;
    
    /**
        * The primitive portion (`TStylingStatic` removed) of the value stored in the `TData` which is
        * needed to re-concatenate the styling.
        *
        * - `string`: Stores the property name. Used with `ɵɵstyleProp`/`ɵɵclassProp` instruction.
        * - `null`: Represents map, so there is no name. Used with `ɵɵstyleMap`/`ɵɵclassMap`.
        * - `false`: Represents an ignore case. This happens when `ɵɵstyleProp`/`ɵɵclassProp` instruction
        *   is combined with directive which shadows its input `@Input('class')`. That way the binding
        *   should not participate in the styling resolution.
        */
    type TStylingKeyPrimitive = string | null | false;
    
    /**
        * This is a branded number which contains previous and next index.
        *
        * When we come across styling instructions we need to store the `TStylingKey` in the correct
        * order so that we can re-concatenate the styling value in the desired priority.
        *
        * The insertion can happen either at the:
        * - end of template as in the case of coming across additional styling instruction in the template
        * - in front of the template in the case of coming across additional instruction in the
        *   `hostBindings`.
        *
        * We use `TStylingRange` to store the previous and next index into the `TData` where the template
        * bindings can be found.
        *
        * - bit 0 is used to mark that the previous index has a duplicate for current value.
        * - bit 1 is used to mark that the next index has a duplicate for the current value.
        * - bits 2-16 are used to encode the next/tail of the template.
        * - bits 17-32 are used to encode the previous/head of template.
        *
        * NODE: *duplicate* false implies that it is statically known that this binding will not collide
        * with other bindings and therefore there is no need to check other bindings. For example the
        * bindings in `<div [style.color]="exp" [style.width]="exp">` will never collide and will have
        * their bits set accordingly. Previous duplicate means that we may need to check previous if the
        * current binding is `null`. Next duplicate means that we may need to check next bindings if the
        * current binding is not `null`.
        *
        * NOTE: `0` has special significance and represents `null` as in no additional pointer.
        */
    interface TStylingRange {
            __brand__: 'TStylingRange';
    }
    
    /**
        * Store the static values for the styling binding.
        *
        * The `TStylingStatic` is just `KeyValueArray` where key `""` (stored at location 0) contains the
        * `TStylingKey` (stored at location 1). In other words this wraps the `TStylingKey` such that the
        * `""` contains the wrapped value.
        *
        * When instructions are resolving styling they may need to look forward or backwards in the linked
        * list to resolve the value. For this reason we have to make sure that he linked list also contains
        * the static values. However the list only has space for one item per styling instruction. For this
        * reason we store the static values here as part of the `TStylingKey`. This means that the
        * resolution function when looking for a value needs to first look at the binding value, and than
        * at `TStylingKey` (if it exists).
        *
        * Imagine we have:
        *
        * ```
        * <div class="TEMPLATE" my-dir>
        *
        * @Directive({
        *   host: {
        *     class: 'DIR',
        *     '[class.dynamic]': 'exp' // ɵɵclassProp('dynamic', ctx.exp);
        *   }
        * })
        * ```
        *
        * In the above case the linked list will contain one item:
        *
        * ```
        *   // assume binding location: 10 for `ɵɵclassProp('dynamic', ctx.exp);`
        *   tData[10] = <TStylingStatic>[
        *     '': 'dynamic', // This is the wrapped value of `TStylingKey`
        *     'DIR': true,   // This is the default static value of directive binding.
        *   ];
        *   tData[10 + 1] = 0; // We don't have prev/next.
        *
        *   lView[10] = undefined;     // assume `ctx.exp` is `undefined`
        *   lView[10 + 1] = undefined; // Just normalized `lView[10]`
        * ```
        *
        * So when the function is resolving styling value, it first needs to look into the linked list
        * (there is none) and than into the static `TStylingStatic` too see if there is a default value for
        * `dynamic` (there is not). Therefore it is safe to remove it.
        *
        * If setting `true` case:
        * ```
        *   lView[10] = true;     // assume `ctx.exp` is `true`
        *   lView[10 + 1] = true; // Just normalized `lView[10]`
        * ```
        * So when the function is resolving styling value, it first needs to look into the linked list
        * (there is none) and than into `TNode.residualClass` (TNode.residualStyle) which contains
        * ```
        *   tNode.residualClass = [
        *     'TEMPLATE': true,
        *   ];
        * ```
        *
        * This means that it is safe to add class.
        */
    interface TStylingStatic extends KeyValueArray<any> {
    }
    
    /** Static data for a text node */
    interface TTextNode extends TNode {
            /** Index in the data[] array */
            index: number;
            child: null;
            /**
                * Text nodes will have parents unless they are the first node of a component or
                * embedded view (which means their parent is in a different view and must be
                * retrieved using LView.node).
                */
            parent: TElementNode | TElementContainerNode | null;
            tView: null;
            projection: null;
    }
    
    const TVIEW = 1;
    
    /**
        * The static data for an LView (shared between all templates of a
        * given type).
        *
        * Stored on the `ComponentDef.tView`.
        */
    interface TView {
            /**
                * Type of `TView` (`Root`|`Component`|`Embedded`).
                */
            type: TViewType;
            /**
                * This is a blueprint used to generate LView instances for this TView. Copying this
                * blueprint is faster than creating a new LView from scratch.
                */
            blueprint: LView;
            /**
                * The template function used to refresh the view of dynamically created views
                * and components. Will be null for inline views.
                */
            template: ComponentTemplate<{}> | null;
            /**
                * A function containing query-related instructions.
                */
            viewQuery: ViewQueriesFunction<{}> | null;
            /**
                * A `TNode` representing the declaration location of this `TView` (not part of this TView).
                */
            declTNode: TNode | null;
            /** Whether or not this template has been processed in creation mode. */
            firstCreatePass: boolean;
            /**
                *  Whether or not this template has been processed in update mode (e.g. change detected)
                *
                * `firstUpdatePass` is used by styling to set up `TData` to contain metadata about the styling
                * instructions. (Mainly to build up a linked list of styling priority order.)
                *
                * Typically this function gets cleared after first execution. If exception is thrown then this
                * flag can remain turned un until there is first successful (no exception) pass. This means that
                * individual styling instructions keep track of if they have already been added to the linked
                * list to prevent double adding.
                */
            firstUpdatePass: boolean;
            /** Static data equivalent of LView.data[]. Contains TNodes, PipeDefInternal or TI18n. */
            data: TData;
            /**
                * The binding start index is the index at which the data array
                * starts to store bindings only. Saving this value ensures that we
                * will begin reading bindings at the correct point in the array when
                * we are in update mode.
                *
                * -1 means that it has not been initialized.
                */
            bindingStartIndex: number;
            /**
                * The index where the "expando" section of `LView` begins. The expando
                * section contains injectors, directive instances, and host binding values.
                * Unlike the "decls" and "vars" sections of `LView`, the length of this
                * section cannot be calculated at compile-time because directives are matched
                * at runtime to preserve locality.
                *
                * We store this start index so we know where to start checking host bindings
                * in `setHostBindings`.
                */
            expandoStartIndex: number;
            /**
                * Whether or not there are any static view queries tracked on this view.
                *
                * We store this so we know whether or not we should do a view query
                * refresh after creation mode to collect static query results.
                */
            staticViewQueries: boolean;
            /**
                * Whether or not there are any static content queries tracked on this view.
                *
                * We store this so we know whether or not we should do a content query
                * refresh after creation mode to collect static query results.
                */
            staticContentQueries: boolean;
            /**
                * A reference to the first child node located in the view.
                */
            firstChild: TNode | null;
            /**
                * Stores the OpCodes to be replayed during change-detection to process the `HostBindings`
                *
                * See `HostBindingOpCodes` for encoding details.
                */
            hostBindingOpCodes: HostBindingOpCodes | null;
            /**
                * Full registry of directives and components that may be found in this view.
                *
                * It's necessary to keep a copy of the full def list on the TView so it's possible
                * to render template functions without a host component.
                */
            directiveRegistry: DirectiveDefList | null;
            /**
                * Full registry of pipes that may be found in this view.
                *
                * The property is either an array of `PipeDefs`s or a function which returns the array of
                * `PipeDefs`s. The function is necessary to be able to support forward declarations.
                *
                * It's necessary to keep a copy of the full def list on the TView so it's possible
                * to render template functions without a host component.
                */
            pipeRegistry: PipeDefList | null;
            /**
                * Array of ngOnInit, ngOnChanges and ngDoCheck hooks that should be executed for this view in
                * creation mode.
                *
                * This array has a flat structure and contains TNode indices, directive indices (where an
                * instance can be found in `LView`) and hook functions. TNode index is followed by the directive
                * index and a hook function. If there are multiple hooks for a given TNode, the TNode index is
                * not repeated and the next lifecycle hook information is stored right after the previous hook
                * function. This is done so that at runtime the system can efficiently iterate over all of the
                * functions to invoke without having to make any decisions/lookups.
                */
            preOrderHooks: HookData | null;
            /**
                * Array of ngOnChanges and ngDoCheck hooks that should be executed for this view in update mode.
                *
                * This array has the same structure as the `preOrderHooks` one.
                */
            preOrderCheckHooks: HookData | null;
            /**
                * Array of ngAfterContentInit and ngAfterContentChecked hooks that should be executed
                * for this view in creation mode.
                *
                * Even indices: Directive index
                * Odd indices: Hook function
                */
            contentHooks: HookData | null;
            /**
                * Array of ngAfterContentChecked hooks that should be executed for this view in update
                * mode.
                *
                * Even indices: Directive index
                * Odd indices: Hook function
                */
            contentCheckHooks: HookData | null;
            /**
                * Array of ngAfterViewInit and ngAfterViewChecked hooks that should be executed for
                * this view in creation mode.
                *
                * Even indices: Directive index
                * Odd indices: Hook function
                */
            viewHooks: HookData | null;
            /**
                * Array of ngAfterViewChecked hooks that should be executed for this view in
                * update mode.
                *
                * Even indices: Directive index
                * Odd indices: Hook function
                */
            viewCheckHooks: HookData | null;
            /**
                * Array of ngOnDestroy hooks that should be executed when this view is destroyed.
                *
                * Even indices: Directive index
                * Odd indices: Hook function
                */
            destroyHooks: DestroyHookData | null;
            /**
                * When a view is destroyed, listeners need to be released and outputs need to be
                * unsubscribed. This cleanup array stores both listener data (in chunks of 4)
                * and output data (in chunks of 2) for a particular view. Combining the arrays
                * saves on memory (70 bytes per array) and on a few bytes of code size (for two
                * separate for loops).
                *
                * If it's a native DOM listener or output subscription being stored:
                * 1st index is: event name  `name = tView.cleanup[i+0]`
                * 2nd index is: index of native element or a function that retrieves global target (window,
                *               document or body) reference based on the native element:
                *    `typeof idxOrTargetGetter === 'function'`: global target getter function
                *    `typeof idxOrTargetGetter === 'number'`: index of native element
                *
                * 3rd index is: index of listener function `listener = lView[CLEANUP][tView.cleanup[i+2]]`
                * 4th index is: `useCaptureOrIndx = tView.cleanup[i+3]`
                *    `typeof useCaptureOrIndx == 'boolean' : useCapture boolean
                *    `typeof useCaptureOrIndx == 'number':
                *         `useCaptureOrIndx >= 0` `removeListener = LView[CLEANUP][useCaptureOrIndx]`
                *         `useCaptureOrIndx <  0` `subscription = LView[CLEANUP][-useCaptureOrIndx]`
                *
                * If it's an output subscription or query list destroy hook:
                * 1st index is: output unsubscribe function / query list destroy function
                * 2nd index is: index of function context in LView.cleanupInstances[]
                *               `tView.cleanup[i+0].call(lView[CLEANUP][tView.cleanup[i+1]])`
                */
            cleanup: any[] | null;
            /**
                * A list of element indices for child components that will need to be
                * refreshed when the current view has finished its check. These indices have
                * already been adjusted for the HEADER_OFFSET.
                *
                */
            components: number[] | null;
            /**
                * A collection of queries tracked in a given view.
                */
            queries: TQueries | null;
            /**
                * An array of indices pointing to directives with content queries alongside with the
                * corresponding query index. Each entry in this array is a tuple of:
                * - index of the first content query index declared by a given directive;
                * - index of a directive.
                *
                * We are storing those indexes so we can refresh content queries as part of a view refresh
                * process.
                */
            contentQueries: number[] | null;
            /**
                * Set of schemas that declare elements to be allowed inside the view.
                */
            schemas: SchemaMetadata[] | null;
            /**
                * Array of constants for the view. Includes attribute arrays, local definition arrays etc.
                * Used for directive matching, attribute bindings, local definitions and more.
                */
            consts: TConstants | null;
            /**
                * Indicates that there was an error before we managed to complete the first create pass of the
                * view. This means that the view is likely corrupted and we should try to recover it.
                */
            incompleteFirstPass: boolean;
    }
    
    /**
        * Explicitly marks `TView` as a specific type in `ngDevMode`
        *
        * It is useful to know conceptually what time of `TView` we are dealing with when
        * debugging an application (even if the runtime does not need it.) For this reason
        * we store this information in the `ngDevMode` `TView` and than use it for
        * better debugging experience.
        */
    const enum TViewType {
            /**
                * Root `TView` is the used to bootstrap components into. It is used in conjunction with
                * `LView` which takes an existing DOM node not owned by Angular and wraps it in `TView`/`LView`
                * so that other components can be loaded into it.
                */
            Root = 0,
            /**
                * `TView` associated with a Component. This would be the `TView` directly associated with the
                * component view (as opposed an `Embedded` `TView` which would be a child of `Component` `TView`)
                */
            Component = 1,
            /**
                * `TView` associated with a template. Such as `*ngIf`, `<ng-template>` etc... A `Component`
                * can have zero or more `Embedded` `TView`s.
                */
            Embedded = 2
    }
    
    /**
        * Special location which allows easy identification of type. If we have an array which was
        * retrieved from the `LView` and that array has `true` at `TYPE` location, we know it is
        * `LContainer`.
        */
    const TYPE = 1;
    
    /**
        * @description
        *
        * Represents a type that a Component or other object is instances of.
        *
        * An example of a `Type` is `MyCustomComponent` class, which in JavaScript is represented by
        * the `MyCustomComponent` constructor function.
        *
        * @publicApi
        */
    export const Type: FunctionConstructor;
    
    export interface Type<T> extends Function {
            new (...args: any[]): T;
    }
    
    type Type_2 = Function;
    
    /**
        * An interface implemented by all Angular type decorators, which allows them to be used as
        * decorators as well as Angular syntax.
        *
        * ```
        * @ng.Component({...})
        * class MyClass {...}
        * ```
        *
        * @publicApi
        */
    export interface TypeDecorator {
            /**
                * Invoke as decorator.
                */
            <T extends Type<any>>(type: T): T;
            (target: Object, propertyKey?: string | symbol, parameterIndex?: number): void;
    }
    
    type TypeOrFactory<T> = T | (() => T);
    
    /**
        * Configures the `Injector` to return an instance of `Type` when `Type' is used as the token.
        *
        * Create an instance by invoking the `new` operator and supplying additional arguments.
        * This form is a short form of `TypeProvider`;
        *
        * For more details, see the ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @usageNotes
        *
        * {@example core/di/ts/provider_spec.ts region='TypeProvider'}
        *
        * @publicApi
        */
    export interface TypeProvider extends Type<any> {
    }
    
    /**
        * Configures the `Injector` to return a value for a token.
        * @see ["Dependency Injection Guide"](guide/dependency-injection).
        *
        * @usageNotes
        *
        * ### Example
        *
        * {@example core/di/ts/provider_spec.ts region='ValueProvider'}
        *
        * ### Multi-value example
        *
        * {@example core/di/ts/provider_spec.ts region='MultiProviderAspect'}
        *
        * @publicApi
        */
    export interface ValueProvider extends ValueSansProvider {
            /**
                * An injection token. Typically an instance of `Type` or `InjectionToken`, but can be `any`.
                */
            provide: any;
            /**
                * When true, injector returns an array of instances. This is useful to allow multiple
                * providers spread across many files to provide configuration information to a common token.
                */
            multi?: boolean;
    }
    
    /**
        * Configures the `Injector` to return a value for a token.
        * Base for `ValueProvider` decorator.
        *
        * @publicApi
        */
    export interface ValueSansProvider {
            /**
                * The value to inject.
                */
            useValue: any;
    }
    
    /**
        * @publicApi
        */
    export const VERSION: Version;
    
    
    /**
        * @description Represents the version of Angular
        *
        * @publicApi
        */
    export class Version {
            full: string;
            readonly major: string;
            readonly minor: string;
            readonly patch: string;
            constructor(full: string);
    }
    
    const VIEW_REFS = 8;
    
    /**
        * Type of the ViewChild metadata.
        *
        * @publicApi
        */
    export type ViewChild = Query;
    
    /**
        * ViewChild decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const ViewChild: ViewChildDecorator;
    
    /**
        * Type of the ViewChild decorator / constructor function.
        *
        * @see `ViewChild`.
        * @publicApi
        */
    export interface ViewChildDecorator {
            /**
                * @description
                * Property decorator that configures a view query.
                * The change detector looks for the first element or the directive matching the selector
                * in the view DOM. If the view DOM changes, and a new child matches the selector,
                * the property is updated.
                *
                * View queries are set before the `ngAfterViewInit` callback is called.
                *
                * **Metadata Properties**:
                *
                * * **selector** - The directive type or the name used for querying.
                * * **read** - Used to read a different token from the queried elements.
                * * **static** - True to resolve query results before change detection runs,
                * false to resolve after change detection. Defaults to false.
                *
                *
                * The following selectors are supported.
                *   * Any class with the `@Component` or `@Directive` decorator
                *   * A template reference variable as a string (e.g. query `<my-component #cmp></my-component>`
                * with `@ViewChild('cmp')`)
                *   * Any provider defined in the child component tree of the current component (e.g.
                * `@ViewChild(SomeService) someService: SomeService`)
                *   * Any provider defined through a string token (e.g. `@ViewChild('someToken') someTokenVal:
                * any`)
                *   * A `TemplateRef` (e.g. query `<ng-template></ng-template>` with `@ViewChild(TemplateRef)
                * template;`)
                *
                * The following values are supported by `read`:
                *   * Any class with the `@Component` or `@Directive` decorator
                *   * Any provider defined on the injector of the component that is matched by the `selector` of
                * this query
                *   * Any provider defined through a string token (e.g. `{provide: 'token', useValue: 'val'}`)
                *   * `TemplateRef`, `ElementRef`, and `ViewContainerRef`
                *
                * @usageNotes
                *
                * {@example core/di/ts/viewChild/view_child_example.ts region='Component'}
                *
                * ### Example 2
                *
                * {@example core/di/ts/viewChild/view_child_howto.ts region='HowTo'}
                *
                * @Annotation
                */
            (selector: ProviderToken<unknown> | Function | string, opts?: {
                    read?: any;
                    static?: boolean;
            }): any;
            new (selector: ProviderToken<unknown> | Function | string, opts?: {
                    read?: any;
                    static?: boolean;
            }): ViewChild;
    }
    
    /**
        * Type of the ViewChildren metadata.
        *
        * @publicApi
        */
    export type ViewChildren = Query;
    
    /**
        * ViewChildren decorator and metadata.
        *
        * @Annotation
        * @publicApi
        */
    export const ViewChildren: ViewChildrenDecorator;
    
    /**
        * Type of the ViewChildren decorator / constructor function.
        *
        * @see `ViewChildren`.
        *
        * @publicApi
        */
    export interface ViewChildrenDecorator {
            /**
                * @description
                * Property decorator that configures a view query.
                *
                * Use to get the `QueryList` of elements or directives from the view DOM.
                * Any time a child element is added, removed, or moved, the query list will be updated,
                * and the changes observable of the query list will emit a new value.
                *
                * View queries are set before the `ngAfterViewInit` callback is called.
                *
                * **Metadata Properties**:
                *
                * * **selector** - The directive type or the name used for querying.
                * * **read** - Used to read a different token from the queried elements.
                * * **emitDistinctChangesOnly** - The ` QueryList#changes` observable will emit new values only
                *   if the QueryList result has changed. When `false` the `changes` observable might emit even
                *   if the QueryList has not changed.
                *   ** Note: *** This config option is **deprecated**, it will be permanently set to `true` and
                * removed in future versions of Angular.
                *
                * The following selectors are supported.
                *   * Any class with the `@Component` or `@Directive` decorator
                *   * A template reference variable as a string (e.g. query `<my-component #cmp></my-component>`
                * with `@ViewChildren('cmp')`)
                *   * Any provider defined in the child component tree of the current component (e.g.
                * `@ViewChildren(SomeService) someService!: SomeService`)
                *   * Any provider defined through a string token (e.g. `@ViewChildren('someToken')
                * someTokenVal!: any`)
                *   * A `TemplateRef` (e.g. query `<ng-template></ng-template>` with `@ViewChildren(TemplateRef)
                * template;`)
                *
                * In addition, multiple string selectors can be separated with a comma (e.g.
                * `@ViewChildren('cmp1,cmp2')`)
                *
                * The following values are supported by `read`:
                *   * Any class with the `@Component` or `@Directive` decorator
                *   * Any provider defined on the injector of the component that is matched by the `selector` of
                * this query
                *   * Any provider defined through a string token (e.g. `{provide: 'token', useValue: 'val'}`)
                *   * `TemplateRef`, `ElementRef`, and `ViewContainerRef`
                *
                * @usageNotes
                *
                * {@example core/di/ts/viewChildren/view_children_howto.ts region='HowTo'}
                *
                * ### Another example
                *
                * {@example core/di/ts/viewChildren/view_children_example.ts region='Component'}
                *
                * @Annotation
                */
            (selector: ProviderToken<unknown> | Function | string, opts?: {
                    read?: any;
                    emitDistinctChangesOnly?: boolean;
            }): any;
            new (selector: ProviderToken<unknown> | Function | string, opts?: {
                    read?: any;
                    emitDistinctChangesOnly?: boolean;
            }): ViewChildren;
    }
    
    /**
        * Represents a container where one or more views can be attached to a component.
        *
        * Can contain *host views* (created by instantiating a
        * component with the `createComponent()` method), and *embedded views*
        * (created by instantiating a `TemplateRef` with the `createEmbeddedView()` method).
        *
        * A view container instance can contain other view containers,
        * creating a [view hierarchy](guide/glossary#view-hierarchy).
        *
        * @see `ComponentRef`
        * @see `EmbeddedViewRef`
        *
        * @publicApi
        */
    export abstract class ViewContainerRef {
            /**
                * Anchor element that specifies the location of this container in the containing view.
                * Each view container can have only one anchor element, and each anchor element
                * can have only a single view container.
                *
                * Root elements of views attached to this container become siblings of the anchor element in
                * the rendered view.
                *
                * Access the `ViewContainerRef` of an element by placing a `Directive` injected
                * with `ViewContainerRef` on the element, or use a `ViewChild` query.
                *
                * <!-- TODO: rename to anchorElement -->
                */
            abstract get element(): ElementRef;
            /**
                * The [dependency injector](guide/glossary#injector) for this view container.
                */
            abstract get injector(): Injector;
            /** @deprecated No replacement */
            abstract get parentInjector(): Injector;
            /**
                * Destroys all views in this container.
                */
            abstract clear(): void;
            /**
                * Retrieves a view from this container.
                * @param index The 0-based index of the view to retrieve.
                * @returns The `ViewRef` instance, or null if the index is out of range.
                */
            abstract get(index: number): ViewRef | null;
            /**
                * Reports how many views are currently attached to this container.
                * @returns The number of views.
                */
            abstract get length(): number;
            /**
                * Instantiates an embedded view and inserts it
                * into this container.
                * @param templateRef The HTML template that defines the view.
                * @param context The data-binding context of the embedded view, as declared
                * in the `<ng-template>` usage.
                * @param options Extra configuration for the created view. Includes:
                *  * index: The 0-based index at which to insert the new view into this container.
                *           If not specified, appends the new view as the last entry.
                *  * injector: Injector to be used within the embedded view.
                *
                * @returns The `ViewRef` instance for the newly created view.
                */
            abstract createEmbeddedView<C>(templateRef: TemplateRef<C>, context?: C, options?: {
                    index?: number;
                    injector?: Injector;
            }): EmbeddedViewRef<C>;
            /**
                * Instantiates an embedded view and inserts it
                * into this container.
                * @param templateRef The HTML template that defines the view.
                * @param context The data-binding context of the embedded view, as declared
                * in the `<ng-template>` usage.
                * @param index The 0-based index at which to insert the new view into this container.
                * If not specified, appends the new view as the last entry.
                *
                * @returns The `ViewRef` instance for the newly created view.
                */
            abstract createEmbeddedView<C>(templateRef: TemplateRef<C>, context?: C, index?: number): EmbeddedViewRef<C>;
            /**
                * Instantiates a single component and inserts its host view into this container.
                *
                * @param componentType Component Type to use.
                * @param options An object that contains extra parameters:
                *  * index: the index at which to insert the new component's host view into this container.
                *           If not specified, appends the new view as the last entry.
                *  * injector: the injector to use as the parent for the new component.
                *  * ngModuleRef: an NgModuleRef of the component's NgModule, you should almost always provide
                *                 this to ensure that all expected providers are available for the component
                *                 instantiation.
                *  * environmentInjector: an EnvironmentInjector which will provide the component's environment.
                *                 you should almost always provide this to ensure that all expected providers
                *                 are available for the component instantiation. This option is intended to
                *                 replace the `ngModuleRef` parameter.
                *  * projectableNodes: list of DOM nodes that should be projected through
                *                      [`<ng-content>`](api/core/ng-content) of the new component instance.
                *
                * @returns The new `ComponentRef` which contains the component instance and the host view.
                */
            abstract createComponent<C>(componentType: Type<C>, options?: {
                    index?: number;
                    injector?: Injector;
                    ngModuleRef?: NgModuleRef<unknown>;
                    environmentInjector?: EnvironmentInjector | NgModuleRef<unknown>;
                    projectableNodes?: Node[][];
            }): ComponentRef<C>;
            /**
                * Instantiates a single component and inserts its host view into this container.
                *
                * @param componentFactory Component factory to use.
                * @param index The index at which to insert the new component's host view into this container.
                * If not specified, appends the new view as the last entry.
                * @param injector The injector to use as the parent for the new component.
                * @param projectableNodes List of DOM nodes that should be projected through
                *     [`<ng-content>`](api/core/ng-content) of the new component instance.
                * @param ngModuleRef An instance of the NgModuleRef that represent an NgModule.
                * This information is used to retrieve corresponding NgModule injector.
                *
                * @returns The new `ComponentRef` which contains the component instance and the host view.
                *
                * @deprecated Angular no longer requires component factories to dynamically create components.
                *     Use different signature of the `createComponent` method, which allows passing
                *     Component class directly.
                */
            abstract createComponent<C>(componentFactory: ComponentFactory<C>, index?: number, injector?: Injector, projectableNodes?: any[][], environmentInjector?: EnvironmentInjector | NgModuleRef<any>): ComponentRef<C>;
            /**
                * Inserts a view into this container.
                * @param viewRef The view to insert.
                * @param index The 0-based index at which to insert the view.
                * If not specified, appends the new view as the last entry.
                * @returns The inserted `ViewRef` instance.
                *
                */
            abstract insert(viewRef: ViewRef, index?: number): ViewRef;
            /**
                * Moves a view to a new location in this container.
                * @param viewRef The view to move.
                * @param index The 0-based index of the new location.
                * @returns The moved `ViewRef` instance.
                */
            abstract move(viewRef: ViewRef, currentIndex: number): ViewRef;
            /**
                * Returns the index of a view within the current container.
                * @param viewRef The view to query.
                * @returns The 0-based index of the view's position in this container,
                * or `-1` if this container doesn't contain the view.
                */
            abstract indexOf(viewRef: ViewRef): number;
            /**
                * Destroys a view attached to this container
                * @param index The 0-based index of the view to destroy.
                * If not specified, the last view in the container is removed.
                */
            abstract remove(index?: number): void;
            /**
                * Detaches a view from this container without destroying it.
                * Use along with `insert()` to move a view within the current container.
                * @param index The 0-based index of the view to detach.
                * If not specified, the last view in the container is detached.
                */
            abstract detach(index?: number): ViewRef | null;
    }
    
    
    /**
        * Defines the CSS styles encapsulation policies for the {@link Component} decorator's
        * `encapsulation` option.
        *
        * See {@link Component#encapsulation encapsulation}.
        *
        * @usageNotes
        * ### Example
        *
        * {@example core/ts/metadata/encapsulation.ts region='longform'}
        *
        * @publicApi
        */
    export enum ViewEncapsulation {
            /**
                * Emulates a native Shadow DOM encapsulation behavior by adding a specific attribute to the
                * component's host element and applying the same attribute to all the CSS selectors provided
                * via {@link Component#styles styles} or {@link Component#styleUrls styleUrls}.
                *
                * This is the default option.
                */
            Emulated = 0,
            /**
                * Doesn't provide any sort of CSS style encapsulation, meaning that all the styles provided
                * via {@link Component#styles styles} or {@link Component#styleUrls styleUrls} are applicable
                * to any HTML element of the application regardless of their host Component.
                */
            None = 2,
            /**
                * Uses the browser's native Shadow DOM API to encapsulate CSS styles, meaning that it creates
                * a ShadowRoot for the component's host element which is then used to encapsulate
                * all the Component's styling.
                */
            ShadowDom = 3
    }
    
    enum ViewEncapsulation_2 {
            Emulated = 0,
            None = 2,
            ShadowDom = 3
    }
    
    /**
        * Definition of what a view queries function should look like.
        */
    type ViewQueriesFunction<T> = <U extends T>(rf: ɵRenderFlags, ctx: U) => void;
    
    /**
        * Represents an Angular [view](guide/glossary#view "Definition").
        *
        * @see {@link ChangeDetectorRef#usage-notes Change detection usage}
        *
        * @publicApi
        */
    export abstract class ViewRef extends ChangeDetectorRef {
            /**
                * Destroys this view and all of the data structures associated with it.
                */
            abstract destroy(): void;
            /**
                * Reports whether this view has been destroyed.
                * @returns True after the `destroy()` method has been called, false otherwise.
                */
            abstract get destroyed(): boolean;
            /**
                * A lifecycle hook that provides additional developer-defined cleanup
                * functionality for views.
                * @param callback A handler function that cleans up developer-defined data
                * associated with a view. Called when the `destroy()` method is invoked.
                */
            abstract onDestroy(callback: Function): any /** TODO #9100, replace by void in a major release*/;
    }
    
    /**
        * Interface for tracking root `ViewRef`s in `ApplicationRef`.
        *
        * NOTE: Importing `ApplicationRef` here directly creates circular dependency, which is why we have
        * a subset of the `ApplicationRef` interface `ViewRefTracker` here.
        */
    interface ViewRefTracker {
            detachView(viewRef: ViewRef): void;
    }
    
    /**
        * Sanitizes the given unsafe, untrusted HTML fragment, and returns HTML text that is safe to add to
        * the DOM in a browser environment.
        */
    export function ɵ_sanitizeHtml(defaultDoc: any, unsafeHtmlInput: string): TrustedHTML | string;
    
    
    export function ɵ_sanitizeUrl(url: string): string;
    
    /**
        * Internal token to indicate whether having multiple bootstrapped platform should be allowed (only
        * one bootstrapped platform is allowed by default). This token helps to support SSR scenarios.
        */
    export const ɵALLOW_MULTIPLE_PLATFORMS: InjectionToken<boolean>;
    
    export function ɵallowSanitizationBypassAndThrow(value: any, type: ɵBypassType.Html): value is ɵSafeHtml;
    
    export function ɵallowSanitizationBypassAndThrow(value: any, type: ɵBypassType.ResourceUrl): value is ɵSafeResourceUrl;
    
    export function ɵallowSanitizationBypassAndThrow(value: any, type: ɵBypassType.Script): value is ɵSafeScript;
    
    export function ɵallowSanitizationBypassAndThrow(value: any, type: ɵBypassType.Style): value is ɵSafeStyle;
    
    export function ɵallowSanitizationBypassAndThrow(value: any, type: ɵBypassType.Url): value is ɵSafeUrl;
    
    export function ɵallowSanitizationBypassAndThrow(value: any, type: ɵBypassType): boolean;
    
    /**
        * Providers that generate a random `APP_ID_TOKEN`.
        * @publicApi
        */
    export const ɵAPP_ID_RANDOM_PROVIDER: {
            provide: InjectionToken<string>;
            useFactory: typeof _appIdRandomProviderFactory;
            deps: any[];
    };
    
    /**
        * A set of marker values to be used in the attributes arrays. These markers indicate that some
        * items are not regular attributes and the processing should be adapted accordingly.
        */
    export const enum ɵAttributeMarker {
            /**
                * An implicit marker which indicates that the value in the array are of `attributeKey`,
                * `attributeValue` format.
                *
                * NOTE: This is implicit as it is the type when no marker is present in array. We indicate that
                * it should not be present at runtime by the negative number.
                */
            ImplicitAttributes = -1,
            /**
                * Marker indicates that the following 3 values in the attributes array are:
                * namespaceUri, attributeName, attributeValue
                * in that order.
                */
            NamespaceURI = 0,
            /**
                * Signals class declaration.
                *
                * Each value following `Classes` designates a class name to include on the element.
                * ## Example:
                *
                * Given:
                * ```
                * <div class="foo bar baz">...<d/vi>
                * ```
                *
                * the generated code is:
                * ```
                * var _c1 = [AttributeMarker.Classes, 'foo', 'bar', 'baz'];
                * ```
                */
            Classes = 1,
            /**
                * Signals style declaration.
                *
                * Each pair of values following `Styles` designates a style name and value to include on the
                * element.
                * ## Example:
                *
                * Given:
                * ```
                * <div style="width:100px; height:200px; color:red">...</div>
                * ```
                *
                * the generated code is:
                * ```
                * var _c1 = [AttributeMarker.Styles, 'width', '100px', 'height'. '200px', 'color', 'red'];
                * ```
                */
            Styles = 2,
            /**
                * Signals that the following attribute names were extracted from input or output bindings.
                *
                * For example, given the following HTML:
                *
                * ```
                * <div moo="car" [foo]="exp" (bar)="doSth()">
                * ```
                *
                * the generated code is:
                *
                * ```
                * var _c1 = ['moo', 'car', AttributeMarker.Bindings, 'foo', 'bar'];
                * ```
                */
            Bindings = 3,
            /**
                * Signals that the following attribute names were hoisted from an inline-template declaration.
                *
                * For example, given the following HTML:
                *
                * ```
                * <div *ngFor="let value of values; trackBy:trackBy" dirA [dirB]="value">
                * ```
                *
                * the generated code for the `template()` instruction would include:
                *
                * ```
                * ['dirA', '', AttributeMarker.Bindings, 'dirB', AttributeMarker.Template, 'ngFor', 'ngForOf',
                * 'ngForTrackBy', 'let-value']
                * ```
                *
                * while the generated code for the `element()` instruction inside the template function would
                * include:
                *
                * ```
                * ['dirA', '', AttributeMarker.Bindings, 'dirB']
                * ```
                */
            Template = 4,
            /**
                * Signals that the following attribute is `ngProjectAs` and its value is a parsed
                * `CssSelector`.
                *
                * For example, given the following HTML:
                *
                * ```
                * <h1 attr="value" ngProjectAs="[title]">
                * ```
                *
                * the generated code for the `element()` instruction would include:
                *
                * ```
                * ['attr', 'value', AttributeMarker.ProjectAs, ['', 'title', '']]
                * ```
                */
            ProjectAs = 5,
            /**
                * Signals that the following attribute will be translated by runtime i18n
                *
                * For example, given the following HTML:
                *
                * ```
                * <div moo="car" foo="value" i18n-foo [bar]="binding" i18n-bar>
                * ```
                *
                * the generated code is:
                *
                * ```
                * var _c1 = ['moo', 'car', AttributeMarker.I18n, 'foo', 'bar'];
                */
            I18n = 6
    }
    
    /**
        * Mark `html` string as trusted.
        *
        * This function wraps the trusted string in `String` and brands it in a way which makes it
        * recognizable to {@link htmlSanitizer} to be trusted implicitly.
        *
        * @param trustedHtml `html` string which needs to be implicitly trusted.
        * @returns a `html` which has been branded to be implicitly trusted.
        */
    export function ɵbypassSanitizationTrustHtml(trustedHtml: string): ɵSafeHtml;
    
    /**
        * Mark `url` string as trusted.
        *
        * This function wraps the trusted string in `String` and brands it in a way which makes it
        * recognizable to {@link resourceUrlSanitizer} to be trusted implicitly.
        *
        * @param trustedResourceUrl `url` string which needs to be implicitly trusted.
        * @returns a `url` which has been branded to be implicitly trusted.
        */
    export function ɵbypassSanitizationTrustResourceUrl(trustedResourceUrl: string): ɵSafeResourceUrl;
    
    /**
        * Mark `script` string as trusted.
        *
        * This function wraps the trusted string in `String` and brands it in a way which makes it
        * recognizable to {@link scriptSanitizer} to be trusted implicitly.
        *
        * @param trustedScript `script` string which needs to be implicitly trusted.
        * @returns a `script` which has been branded to be implicitly trusted.
        */
    export function ɵbypassSanitizationTrustScript(trustedScript: string): ɵSafeScript;
    
    /**
        * Mark `style` string as trusted.
        *
        * This function wraps the trusted string in `String` and brands it in a way which makes it
        * recognizable to {@link styleSanitizer} to be trusted implicitly.
        *
        * @param trustedStyle `style` string which needs to be implicitly trusted.
        * @returns a `style` hich has been branded to be implicitly trusted.
        */
    export function ɵbypassSanitizationTrustStyle(trustedStyle: string): ɵSafeStyle;
    
    /**
        * Mark `url` string as trusted.
        *
        * This function wraps the trusted string in `String` and brands it in a way which makes it
        * recognizable to {@link urlSanitizer} to be trusted implicitly.
        *
        * @param trustedUrl `url` string which needs to be implicitly trusted.
        * @returns a `url`  which has been branded to be implicitly trusted.
        */
    export function ɵbypassSanitizationTrustUrl(trustedUrl: string): ɵSafeUrl;
    
    
    export const enum ɵBypassType {
            Url = "URL",
            Html = "HTML",
            ResourceUrl = "ResourceURL",
            Script = "Script",
            Style = "Style"
    }
    
    export function ɵclearResolutionOfComponentResourcesQueue(): Map<Type<any>, Component>;
    
    
    /** Coerces a value (typically a string) to a boolean. */
    export function ɵcoerceToBoolean(value: unknown): boolean;
    
    /**
        * Compile an Angular component according to its decorator metadata, and patch the resulting
        * component def (ɵcmp) onto the component type.
        *
        * Compilation may be asynchronous (due to the need to resolve URLs for the component template or
        * other resources, for example). In the event that compilation is not immediate, `compileComponent`
        * will enqueue resource resolution into a global queue and will fail to return the `ɵcmp`
        * until the global queue has been resolved with a call to `resolveComponentResources`.
        */
    export function ɵcompileComponent(type: Type<any>, metadata: Component): void;
    
    /**
        * Compile an Angular directive according to its decorator metadata, and patch the resulting
        * directive def onto the component type.
        *
        * In the event that compilation is not immediate, `compileDirective` will return a `Promise` which
        * will resolve when compilation completes and the directive becomes usable.
        */
    export function ɵcompileDirective(type: Type<any>, directive: Directive | null): void;
    
    /**
        * Compiles a module in JIT mode.
        *
        * This function automatically gets called when a class has a `@NgModule` decorator.
        */
    export function ɵcompileNgModule(moduleType: Type<any>, ngModule?: NgModule): void;
    
    /**
        * Compiles and adds the `ɵmod`, `ɵfac` and `ɵinj` properties to the module class.
        *
        * It's possible to compile a module via this API which will allow duplicate declarations in its
        * root.
        */
    export function ɵcompileNgModuleDefs(moduleType: ɵNgModuleType, ngModule: NgModule, allowDuplicateDeclarationsInRoot?: boolean): void;
    
    export function ɵcompileNgModuleFactory<M>(injector: Injector, options: CompilerOptions, moduleType: Type<M>): Promise<NgModuleFactory<M>>;
    
    export function ɵcompilePipe(type: Type<any>, meta: Pipe): void;
    
    /**
        * Runtime link information for Components.
        *
        * This is an internal data structure used by the render to link
        * components into templates.
        *
        * NOTE: Always use `defineComponent` function to create this object,
        * never create the object directly since the shape of this object
        * can change between versions.
        *
        * See: {@link defineComponent}
        */
    export interface ɵComponentDef<T> extends ɵDirectiveDef<T> {
            /**
                * Unique ID for the component. Used in view encapsulation and
                * to keep track of the injector in standalone components.
                */
            readonly id: string;
            /**
                * The View template of the component.
                */
            readonly template: ComponentTemplate<T>;
            /** Constants associated with the component's view. */
            readonly consts: TConstantsOrFactory | null;
            /**
                * An array of `ngContent[selector]` values that were found in the template.
                */
            readonly ngContentSelectors?: string[];
            /**
                * A set of styles that the component needs to be present for component to render correctly.
                */
            readonly styles: string[];
            /**
                * The number of nodes, local refs, and pipes in this component template.
                *
                * Used to calculate the length of the component's LView array, so we
                * can pre-fill the array and set the binding start index.
                */
            readonly decls: number;
            /**
                * The number of bindings in this component template (including pure fn bindings).
                *
                * Used to calculate the length of the component's LView array, so we
                * can pre-fill the array and set the host binding start index.
                */
            readonly vars: number;
            /**
                * Query-related instructions for a component.
                */
            viewQuery: ViewQueriesFunction<T> | null;
            /**
                * The view encapsulation type, which determines how styles are applied to
                * DOM elements. One of
                * - `Emulated` (default): Emulate native scoping of styles.
                * - `Native`: Use the native encapsulation mechanism of the renderer.
                * - `ShadowDom`: Use modern [ShadowDOM](https://w3c.github.io/webcomponents/spec/shadow/) and
                *   create a ShadowRoot for component's host element.
                * - `None`: Do not provide any template or style encapsulation.
                */
            readonly encapsulation: ViewEncapsulation;
            /**
                * Defines arbitrary developer-defined data to be stored on a renderer instance.
                * This is useful for renderers that delegate to other renderers.
                */
            readonly data: {
                    [kind: string]: any;
            };
            /** Whether or not this component's ChangeDetectionStrategy is OnPush */
            readonly onPush: boolean;
            /**
                * Registry of directives and components that may be found in this view.
                *
                * The property is either an array of `DirectiveDef`s or a function which returns the array of
                * `DirectiveDef`s. The function is necessary to be able to support forward declarations.
                */
            directiveDefs: DirectiveDefListOrFactory | null;
            /**
                * Registry of pipes that may be found in this view.
                *
                * The property is either an array of `PipeDefs`s or a function which returns the array of
                * `PipeDefs`s. The function is necessary to be able to support forward declarations.
                */
            pipeDefs: PipeDefListOrFactory | null;
            /**
                * Unfiltered list of all dependencies of a component, or `null` if none.
                */
            dependencies: TypeOrFactory<DependencyTypeList> | null;
            /**
                * The set of schemas that declare elements to be allowed in the component's template.
                */
            schemas: SchemaMetadata[] | null;
            /**
                * Ivy runtime uses this place to store the computed tView for the component. This gets filled on
                * the first run of component.
                */
            tView: TView | null;
            /**
                * A function added by the {@link ɵɵStandaloneFeature} and used by the framework to create
                * standalone injectors.
                */
            getStandaloneInjector: ((parentInjector: EnvironmentInjector) => EnvironmentInjector | null) | null;
            /**
                * Used to store the result of `noSideEffects` function so that it is not removed by closure
                * compiler. The property should never be read.
                */
            readonly _?: unknown;
    }
    
    /**
        * A subclass of `Type` which has a static `ɵcmp`:`ComponentDef` field making it
        * consumable for rendering.
        */
    export interface ɵComponentType<T> extends Type<T> {
            ɵcmp: unknown;
    }
    
    export class ɵConsole {
            log(message: string): void;
            warn(message: string): void;
            static ɵfac: i0.ɵɵFactoryDeclaration<ɵConsole, never>;
            static ɵprov: i0.ɵɵInjectableDeclaration<ɵConsole>;
    }
    
    export function ɵconvertToBitFlags(flags: InjectOptions | InjectFlags | undefined): InjectFlags | undefined;
    
    /**
        * Create a new `Injector` which is configured using a `defType` of `InjectorType<any>`s.
        *
        * @publicApi
        */
    export function ɵcreateInjector(defType: any, parent?: Injector | null, additionalProviders?: StaticProvider[] | null, name?: string): Injector;
    
    /**
        * A list of CssSelectors.
        *
        * A directive or component can have multiple selectors. This type is used for
        * directive defs so any of the selectors in the list will match that directive.
        *
        * Original: 'form, [ngForm]'
        * Parsed: [['form'], ['', 'ngForm', '']]
        */
    export type ɵCssSelectorList = CssSelector[];
    
    /**
        * Index of each value in currency data (used to describe CURRENCIES_EN in currencies.ts)
        */
    export const enum ɵCurrencyIndex {
            Symbol = 0,
            SymbolNarrow = 1,
            NbOfDigits = 2
    }
    
    /**
        * The locale id that the application is using by default (for translations and ICU expressions).
        */
    export const ɵDEFAULT_LOCALE_ID = "en-US";
    
    export const ɵdefaultIterableDiffers: IterableDiffers;
    
    export const ɵdefaultKeyValueDiffers: KeyValueDiffers;
    
    
    /**
        * Synchronously perform change detection on a component (and possibly its sub-components).
        *
        * This function triggers change detection in a synchronous way on a component.
        *
        * @param component The component which the change detection should be performed on.
        */
    export function ɵdetectChanges(component: {}): void;
    
    
    export function ɵdevModeEqual(a: any, b: any): boolean;
    
    /**
        * Runtime link information for Directives.
        *
        * This is an internal data structure used by the render to link
        * directives into templates.
        *
        * NOTE: Always use `defineDirective` function to create this object,
        * never create the object directly since the shape of this object
        * can change between versions.
        *
        * @param Selector type metadata specifying the selector of the directive or component
        *
        * See: {@link defineDirective}
        */
    export interface ɵDirectiveDef<T> {
            /**
                * A dictionary mapping the inputs' minified property names to their public API names, which
                * are their aliases if any, or their original unminified property names
                * (as in `@Input('alias') propertyName: any;`).
                */
            readonly inputs: {
                    [P in keyof T]: string;
            };
            /**
                * @deprecated This is only here because `NgOnChanges` incorrectly uses declared name instead of
                * public or minified name.
                */
            readonly declaredInputs: {
                    [P in keyof T]: string;
            };
            /**
                * A dictionary mapping the outputs' minified property names to their public API names, which
                * are their aliases if any, or their original unminified property names
                * (as in `@Output('alias') propertyName: any;`).
                */
            readonly outputs: {
                    [P in keyof T]: string;
            };
            /**
                * Function to create and refresh content queries associated with a given directive.
                */
            contentQueries: ContentQueriesFunction<T> | null;
            /**
                * Query-related instructions for a directive. Note that while directives don't have a
                * view and as such view queries won't necessarily do anything, there might be
                * components that extend the directive.
                */
            viewQuery: ViewQueriesFunction<T> | null;
            /**
                * Refreshes host bindings on the associated directive.
                */
            readonly hostBindings: HostBindingsFunction<T> | null;
            /**
                * The number of bindings in this directive `hostBindings` (including pure fn bindings).
                *
                * Used to calculate the length of the component's LView array, so we
                * can pre-fill the array and set the host binding start index.
                */
            readonly hostVars: number;
            /**
                * Assign static attribute values to a host element.
                *
                * This property will assign static attribute values as well as class and style
                * values to a host element. Since attribute values can consist of different types of values, the
                * `hostAttrs` array must include the values in the following format:
                *
                * attrs = [
                *   // static attributes (like `title`, `name`, `id`...)
                *   attr1, value1, attr2, value,
                *
                *   // a single namespace value (like `x:id`)
                *   NAMESPACE_MARKER, namespaceUri1, name1, value1,
                *
                *   // another single namespace value (like `x:name`)
                *   NAMESPACE_MARKER, namespaceUri2, name2, value2,
                *
                *   // a series of CSS classes that will be applied to the element (no spaces)
                *   CLASSES_MARKER, class1, class2, class3,
                *
                *   // a series of CSS styles (property + value) that will be applied to the element
                *   STYLES_MARKER, prop1, value1, prop2, value2
                * ]
                *
                * All non-class and non-style attributes must be defined at the start of the list
                * first before all class and style values are set. When there is a change in value
                * type (like when classes and styles are introduced) a marker must be used to separate
                * the entries. The marker values themselves are set via entries found in the
                * [AttributeMarker] enum.
                */
            readonly hostAttrs: TAttributes | null;
            /** Token representing the directive. Used by DI. */
            readonly type: Type<T>;
            /** Function that resolves providers and publishes them into the DI system. */
            providersResolver: (<U extends T>(def: ɵDirectiveDef<U>, processProvidersFn?: ProcessProvidersFunction) => void) | null;
            /** The selectors that will be used to match nodes to this directive. */
            readonly selectors: ɵCssSelectorList;
            /**
                * Name under which the directive is exported (for use with local references in template)
                */
            readonly exportAs: string[] | null;
            /**
                * Whether this directive (or component) is standalone.
                */
            readonly standalone: boolean;
            /**
                * Factory function used to create a new directive instance. Will be null initially.
                * Populated when the factory is first requested by directive instantiation logic.
                */
            readonly factory: FactoryFn<T> | null;
            /**
                * The features applied to this directive
                */
            readonly features: DirectiveDefFeature[] | null;
            /**
                * Function that will add the host directives to the list of matches during directive matching.
                * Patched onto the definition by the `HostDirectivesFeature`.
                * @param currentDef Definition that has been matched.
                * @param matchedDefs List of all matches for a specified node. Will be mutated to include the
                * host directives.
                * @param hostDirectiveDefs Mapping of directive definitions to their host directive
                * configuration. Host directives will be added to the map as they're being matched to the node.
                */
            findHostDirectiveDefs: ((currentDef: ɵDirectiveDef<unknown>, matchedDefs: ɵDirectiveDef<unknown>[], hostDirectiveDefs: HostDirectiveDefs) => void) | null;
            /** Additional directives to be applied whenever the directive has been matched. */
            hostDirectives: HostDirectiveDef[] | null;
            setInput: (<U extends T>(this: ɵDirectiveDef<U>, instance: U, value: any, publicName: string, privateName: string) => void) | null;
    }
    
    /**
        * A subclass of `Type` which has a static `ɵdir`:`DirectiveDef` field making it
        * consumable for rendering.
        */
    export interface ɵDirectiveType<T> extends Type<T> {
            ɵdir: unknown;
            ɵfac: unknown;
    }
    
    /**
        * Index of each type of locale data from the extra locale data array
        */
    export const enum ɵExtraLocaleDataIndex {
            ExtraDayPeriodFormats = 0,
            ExtraDayPeriodStandalone = 1,
            ExtraDayPeriodsRules = 2
    }
    
    /**
        * Finds the locale data for a given locale.
        *
        * @param locale The locale code.
        * @returns The locale data.
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        */
    export function ɵfindLocaleData(locale: string): any;
    
    /**
        * Loops over queued module definitions, if a given module definition has all of its
        * declarations resolved, it dequeues that module definition and sets the scope on
        * its declarations.
        */
    export function ɵflushModuleScopingQueueAsMuchAsPossible(): void;
    
    /**
        * Called to format a runtime error.
        * See additional info on the `message` argument type in the `RuntimeError` class description.
        */
    export function ɵformatRuntimeError<T extends number = RuntimeErrorCode>(code: T, message: null | false | string): string;
    
    export function ɵgetDebugNodeR2(_nativeNode: any): DebugNode | null;
    
    /**
        * Retrieves directive instances associated with a given DOM node. Does not include
        * component instances.
        *
        * @usageNotes
        * Given the following DOM structure:
        *
        * ```html
        * <app-root>
        *   <button my-button></button>
        *   <my-comp></my-comp>
        * </app-root>
        * ```
        *
        * Calling `getDirectives` on `<button>` will return an array with an instance of the `MyButton`
        * directive that is associated with the DOM node.
        *
        * Calling `getDirectives` on `<my-comp>` will return an empty array.
        *
        * @param node DOM node for which to get the directives.
        * @returns Array of directives associated with the node.
        *
        * @publicApi
        * @globalApi ng
        */
    export function ɵgetDirectives(node: Node): {}[];
    
    /**
        * Retrieves the host element of a component or directive instance.
        * The host element is the DOM element that matched the selector of the directive.
        *
        * @param componentOrDirective Component or directive instance for which the host
        *     element should be retrieved.
        * @returns Host element of the target.
        *
        * @publicApi
        * @globalApi ng
        */
    export function ɵgetHostElement(componentOrDirective: {}): Element;
    
    /**
        * Read the injectable def (`ɵprov`) for `type` in a way which is immune to accidentally reading
        * inherited value.
        *
        * @param type A type which may have its own (non-inherited) `ɵprov`.
        */
    export function ɵgetInjectableDef<T>(type: any): ɵɵInjectableDeclaration<T> | null;
    
    /**
        * Returns the matching `LContext` data for a given DOM node, directive or component instance.
        *
        * This function will examine the provided DOM element, component, or directive instance\'s
        * monkey-patched property to derive the `LContext` data. Once called then the monkey-patched
        * value will be that of the newly created `LContext`.
        *
        * If the monkey-patched value is the `LView` instance then the context value for that
        * target will be created and the monkey-patch reference will be updated. Therefore when this
        * function is called it may mutate the provided element\'s, component\'s or any of the associated
        * directive\'s monkey-patch values.
        *
        * If the monkey-patch value is not detected then the code will walk up the DOM until an element
        * is found which contains a monkey-patch reference. When that occurs then the provided element
        * will be updated with a new context (which is then returned). If the monkey-patch value is not
        * detected for a component/directive instance then it will throw an error (all components and
        * directives should be automatically monkey-patched by ivy).
        *
        * @param target Component, Directive or DOM Node.
        */
    export function ɵgetLContext(target: any): ɵLContext | null;
    
    /**
        * Retrieves the default currency code for the given locale.
        *
        * The default is defined as the first currency which is still in use.
        *
        * @param locale The code of the locale whose currency code we want.
        * @returns The code of the default currency for the given locale.
        *
        */
    export function ɵgetLocaleCurrencyCode(locale: string): string | null;
    
    /**
        * Retrieves the plural function used by ICU expressions to determine the plural case to use
        * for a given locale.
        * @param locale A locale code for the locale format rules to use.
        * @returns The plural function for the locale.
        * @see `NgPlural`
        * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n-overview)
        */
    export function ɵgetLocalePluralCase(locale: string): (value: number) => number;
    
    export function ɵgetSanitizationBypassType(value: any): ɵBypassType | null;
    
    /**
        * Gets the current value of the strict mode.
        */
    export function ɵgetUnknownElementStrictMode(): boolean;
    
    /**
        * Gets the current value of the strict mode.
        */
    export function ɵgetUnknownPropertyStrictMode(): boolean;
    
    
    export const ɵglobal: any;
    
    /** Returns a ChangeDetectorRef (a.k.a. a ViewRef) */
    export function ɵinjectChangeDetectorRef(flags: InjectFlags): ChangeDetectorRef;
    
    /**
        * An internal token whose presence in an injector indicates that the injector should treat itself
        * as a root scoped injector when processing requests for unknown tokens which may indicate
        * they are provided in the root scope.
        */
    export const ɵINJECTOR_SCOPE: InjectionToken<InjectorScope | null>;
    
    /**
        * Internal create application API that implements the core application creation logic and optional
        * bootstrap logic.
        *
        * Platforms (such as `platform-browser`) may require different set of application and platform
        * providers for an application to function correctly. As a result, platforms may use this function
        * internally and supply the necessary providers during the bootstrap, while exposing
        * platform-specific APIs as a part of their public API.
        *
        * @returns A promise that returns an `ApplicationRef` instance once resolved.
        */
    export function ɵinternalCreateApplication(config: {
            rootComponent?: Type<unknown>;
            appProviders?: Array<Provider | EnvironmentProviders>;
            platformProviders?: Provider[];
    }): Promise<ApplicationRef>;
    
    export interface ɵInternalEnvironmentProviders extends EnvironmentProviders {
            ɵproviders: (Provider | EnvironmentProviders)[];
            /**
                * If present, indicates that the `EnvironmentProviders` were derived from NgModule providers.
                *
                * This is used to produce clearer error messages.
                */
            ɵfromNgModule?: true;
    }
    
    export function ɵisBoundToModule<C>(cf: ComponentFactory<C>): boolean;
    
    export function ɵisEnvironmentProviders(value: Provider | EnvironmentProviders | ɵInternalEnvironmentProviders): value is ɵInternalEnvironmentProviders;
    
    export function ɵisInjectable(type: any): boolean;
    
    export function ɵisNgModule<T>(value: Type<T>): value is Type<T> & {
            ɵmod: ɵNgModuleDef<T>;
    };
    
    /**
        * Determine if the argument is an Observable
        *
        * Strictly this tests that the `obj` is `Subscribable`, since `Observable`
        * types need additional methods, such as `lift()`. But it is adequate for our
        * needs since within the Angular framework code we only ever need to use the
        * `subscribe()` method, and RxJS has mechanisms to wrap `Subscribable` objects
        * into `Observable` as needed.
        */
    export const ɵisObservable: (obj: any | Observable<any>) => obj is Observable<any>;
    
    /**
        * Determine if the argument is shaped like a Promise
        */
    export function ɵisPromise<T = any>(obj: any): obj is Promise<T>;
    
    /**
        * Determine if the argument is a Subscribable
        */
    export function ɵisSubscribable(obj: any | Subscribable<any>): obj is Subscribable<any>;
    
    /**
        * The internal view context which is specific to a given DOM element, directive or
        * component instance. Each value in here (besides the LView and element node details)
        * can be present, null or undefined. If undefined then it implies the value has not been
        * looked up yet, otherwise, if null, then a lookup was executed and nothing was found.
        *
        * Each value will get filled when the respective value is examined within the getContext
        * function. The component, element and each directive instance will share the same instance
        * of the context.
        */
    export class ɵLContext {
            /**
                * The index instance of the node.
                */
            nodeIndex: number;
            /**
                * The instance of the DOM node that is attached to the lNode.
                */
            native: RNode;
            /**
                * The instance of the Component node.
                */
            component: {} | null | undefined;
            /**
                * The list of active directives that exist on this element.
                */
            directives: any[] | null | undefined;
            /**
                * The map of local references (local reference name => element or directive instance) that
                * exist on this element.
                */
            localRefs: {
                    [key: string]: any;
            } | null | undefined;
            /** Component's parent view data. */
            get lView(): LView | null;
            constructor(
            /**
                * ID of the component's parent view data.
                */
            lViewId: number, 
            /**
                * The index instance of the node.
                */
            nodeIndex: number, 
            /**
                * The instance of the DOM node that is attached to the lNode.
                */
            native: RNode);
    }
    
    /**
        * Used to enable lifecycle hooks on the root component.
        *
        * Include this feature when calling `renderComponent` if the root component
        * you are rendering has lifecycle hooks defined. Otherwise, the hooks won't
        * be called properly.
        *
        * Example:
        *
        * ```
        * renderComponent(AppComponent, {hostFeatures: [LifecycleHooksFeature]});
        * ```
        */
    export function ɵLifecycleHooksFeature(): void;
    
    /**
        * Index of each type of locale data from the locale data array
        */
    export enum ɵLocaleDataIndex {
            LocaleId = 0,
            DayPeriodsFormat = 1,
            DayPeriodsStandalone = 2,
            DaysFormat = 3,
            DaysStandalone = 4,
            MonthsFormat = 5,
            MonthsStandalone = 6,
            Eras = 7,
            FirstDayOfWeek = 8,
            WeekendRange = 9,
            DateFormat = 10,
            TimeFormat = 11,
            DateTimeFormat = 12,
            NumberSymbols = 13,
            NumberFormats = 14,
            CurrencyCode = 15,
            CurrencySymbol = 16,
            CurrencyName = 17,
            Currencies = 18,
            Directionality = 19,
            PluralCase = 20,
            ExtraData = 21
    }
    
    /**
        * @suppress {globalThis}
        */
    export function ɵmakeDecorator<T>(name: string, props?: (...args: any[]) => any, parentClass?: any, additionalProcessing?: (type: Type<T>) => void, typeFn?: (type: Type<T>, ...args: any[]) => void): {
            new (...args: any[]): any;
            (...args: any[]): any;
            (...args: any[]): (cls: any) => any;
    };
    
    
    export const ɵNG_COMP_DEF: string;
    
    export const ɵNG_DIR_DEF: string;
    
    /**
        * If a directive is diPublic, bloomAdd sets a property on the type with this constant as
        * the key and the directive's unique ID as the value. This allows us to map directives to their
        * bloom filter bit for DI.
        */
    export const ɵNG_ELEMENT_ID: string;
    
    export const ɵNG_INJ_DEF: string;
    
    export const ɵNG_MOD_DEF: string;
    
    export const ɵNG_PIPE_DEF: string;
    
    export const ɵNG_PROV_DEF: string;
    
    /**
        * Runtime link information for NgModules.
        *
        * This is the internal data structure used by the runtime to assemble components, directives,
        * pipes, and injectors.
        *
        * NOTE: Always use `ɵɵdefineNgModule` function to create this object,
        * never create the object directly since the shape of this object
        * can change between versions.
        */
    export interface ɵNgModuleDef<T> {
            /** Token representing the module. Used by DI. */
            type: T;
            /** List of components to bootstrap. */
            bootstrap: Type<any>[] | (() => Type<any>[]);
            /** List of components, directives, and pipes declared by this module. */
            declarations: Type<any>[] | (() => Type<any>[]);
            /** List of modules or `ModuleWithProviders` imported by this module. */
            imports: Type<any>[] | (() => Type<any>[]);
            /**
                * List of modules, `ModuleWithProviders`, components, directives, or pipes exported by this
                * module.
                */
            exports: Type<any>[] | (() => Type<any>[]);
            /**
                * Cached value of computed `transitiveCompileScopes` for this module.
                *
                * This should never be read directly, but accessed via `transitiveScopesFor`.
                */
            transitiveCompileScopes: ɵNgModuleTransitiveScopes | null;
            /** The set of schemas that declare elements to be allowed in the NgModule. */
            schemas: SchemaMetadata[] | null;
            /** Unique ID for the module with which it should be registered.  */
            id: string | null;
    }
    
    export class ɵNgModuleFactory<T> extends NgModuleFactory<T> {
            moduleType: Type<T>;
            constructor(moduleType: Type<T>);
            create(parentInjector: Injector | null): NgModuleRef<T>;
    }
    
    /**
        * Represents the expansion of an `NgModule` into its scopes.
        *
        * A scope is a set of directives and pipes that are visible in a particular context. Each
        * `NgModule` has two scopes. The `compilation` scope is the set of directives and pipes that will
        * be recognized in the templates of components declared by the module. The `exported` scope is the
        * set of directives and pipes exported by a module (that is, module B's exported scope gets added
        * to module A's compilation scope when module A imports B).
        */
    export interface ɵNgModuleTransitiveScopes {
            compilation: {
                    directives: Set<any>;
                    pipes: Set<any>;
            };
            exported: {
                    directives: Set<any>;
                    pipes: Set<any>;
            };
            schemas: SchemaMetadata[] | null;
    }
    
    export interface ɵNgModuleType<T = any> extends Type<T> {
            ɵmod: ɵNgModuleDef<T>;
    }
    
    
    export interface ɵNO_CHANGE {
            __brand__: 'NO_CHANGE';
    }
    
    /** A special value which designates that a value has not changed. */
    export const ɵNO_CHANGE: ɵNO_CHANGE;
    
    /**
        * Provides a noop implementation of `NgZone` which does nothing. This zone requires explicit calls
        * to framework to perform rendering.
        */
    export class ɵNoopNgZone implements NgZone {
            readonly hasPendingMicrotasks: boolean;
            readonly hasPendingMacrotasks: boolean;
            readonly isStable: boolean;
            readonly onUnstable: EventEmitter<any>;
            readonly onMicrotaskEmpty: EventEmitter<any>;
            readonly onStable: EventEmitter<any>;
            readonly onError: EventEmitter<any>;
            run<T>(fn: (...args: any[]) => T, applyThis?: any, applyArgs?: any): T;
            runGuarded<T>(fn: (...args: any[]) => any, applyThis?: any, applyArgs?: any): T;
            runOutsideAngular<T>(fn: (...args: any[]) => T): T;
            runTask<T>(fn: (...args: any[]) => T, applyThis?: any, applyArgs?: any, name?: string): T;
    }
    
    
    /**
        * Convince closure compiler that the wrapped function has no side-effects.
        *
        * Closure compiler always assumes that `toString` has no side-effects. We use this quirk to
        * allow us to execute a function but have closure compiler mark the call as no-side-effects.
        * It is important that the return value for the `noSideEffects` function be assigned
        * to something which is retained otherwise the call to `noSideEffects` will be removed by closure
        * compiler.
        */
    export function ɵnoSideEffects<T>(fn: () => T): T;
    
    
    export const ɵNOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR: {};
    
    /**
        * Patch the definition of a component with directives and pipes from the compilation scope of
        * a given module.
        */
    export function ɵpatchComponentDefWithScope<C>(componentDef: ɵComponentDef<C>, transitiveScopes: ɵNgModuleTransitiveScopes): void;
    
    /**
        * Runtime link information for Pipes.
        *
        * This is an internal data structure used by the renderer to link
        * pipes into templates.
        *
        * NOTE: Always use `definePipe` function to create this object,
        * never create the object directly since the shape of this object
        * can change between versions.
        *
        * See: {@link definePipe}
        */
    export interface ɵPipeDef<T> {
            /** Token representing the pipe. */
            type: Type<T>;
            /**
                * Pipe name.
                *
                * Used to resolve pipe in templates.
                */
            readonly name: string;
            /**
                * Factory function used to create a new pipe instance. Will be null initially.
                * Populated when the factory is first requested by pipe instantiation logic.
                */
            factory: FactoryFn<T> | null;
            /**
                * Whether or not the pipe is pure.
                *
                * Pure pipes result only depends on the pipe input and not on internal
                * state of the pipe.
                */
            readonly pure: boolean;
            /**
                * Whether this pipe is standalone.
                */
            readonly standalone: boolean;
            onDestroy: (() => void) | null;
    }
    
    /**
        * Profiler function which the runtime will invoke before and after user code.
        */
    export interface ɵProfiler {
            (event: ɵProfilerEvent, instance: {} | null, hookOrListener?: (e?: any) => any): void;
    }
    
    
    /**
        * Profiler events is an enum used by the profiler to distinguish between different calls of user
        * code invoked throughout the application lifecycle.
        */
    export const enum ɵProfilerEvent {
            /**
                * Corresponds to the point in time before the runtime has called the template function of a
                * component with `RenderFlags.Create`.
                */
            TemplateCreateStart = 0,
            /**
                * Corresponds to the point in time after the runtime has called the template function of a
                * component with `RenderFlags.Create`.
                */
            TemplateCreateEnd = 1,
            /**
                * Corresponds to the point in time before the runtime has called the template function of a
                * component with `RenderFlags.Update`.
                */
            TemplateUpdateStart = 2,
            /**
                * Corresponds to the point in time after the runtime has called the template function of a
                * component with `RenderFlags.Update`.
                */
            TemplateUpdateEnd = 3,
            /**
                * Corresponds to the point in time before the runtime has called a lifecycle hook of a component
                * or directive.
                */
            LifecycleHookStart = 4,
            /**
                * Corresponds to the point in time after the runtime has called a lifecycle hook of a component
                * or directive.
                */
            LifecycleHookEnd = 5,
            /**
                * Corresponds to the point in time before the runtime has evaluated an expression associated with
                * an event or an output.
                */
            OutputStart = 6,
            /**
                * Corresponds to the point in time after the runtime has evaluated an expression associated with
                * an event or an output.
                */
            OutputEnd = 7
    }
    
    /**
        * Publishes a collection of default debug tools onto`window.ng`.
        *
        * These functions are available globally when Angular is in development
        * mode and are automatically stripped away from prod mode is on.
        */
    export function ɵpublishDefaultGlobalUtils(): void;
    
    /**
        * Publishes the given function to `window.ng` so that it can be
        * used from the browser console when an application is not in production.
        */
    export function ɵpublishGlobalUtil(name: string, fn: Function): void;
    
    export class ɵReflectionCapabilities implements PlatformReflectionCapabilities {
            constructor(reflect?: any);
            factory<T>(t: Type<T>): (args: any[]) => T;
            parameters(type: Type<any>): any[][];
            annotations(typeOrFunc: Type<any>): any[];
            propMetadata(typeOrFunc: any): {
                    [key: string]: any[];
            };
            ownPropMetadata(typeOrFunc: any): {
                    [key: string]: any[];
            };
            hasLifecycleHook(type: any, lcProperty: string): boolean;
    }
    
    /**
        * Register locale data to be used internally by Angular. See the
        * ["I18n guide"](guide/i18n-common-format-data-locale) to know how to import additional locale
        * data.
        *
        * The signature `registerLocaleData(data: any, extraData?: any)` is deprecated since v5.1
        */
    export function ɵregisterLocaleData(data: any, localeId?: string | any, extraData?: any): void;
    
    /**
        * ComponentFactory interface implementation.
        */
    export class ɵRender3ComponentFactory<T> extends ComponentFactory<T> {
            selector: string;
            componentType: Type<any>;
            ngContentSelectors: string[];
            isBoundToModule: boolean;
            get inputs(): {
                    propName: string;
                    templateName: string;
            }[];
            get outputs(): {
                    propName: string;
                    templateName: string;
            }[];
            /**
                * @param componentDef The component definition.
                * @param ngModule The NgModuleRef to which the factory is bound.
                */
            constructor(componentDef: ɵComponentDef<any>, ngModule?: NgModuleRef<any> | undefined);
            create(injector: Injector, projectableNodes?: any[][] | undefined, rootSelectorOrNode?: any, environmentInjector?: NgModuleRef<any> | EnvironmentInjector | undefined): ComponentRef<T>;
    }
    
    /**
        * Represents an instance of a Component created via a {@link ComponentFactory}.
        *
        * `ComponentRef` provides access to the Component Instance as well other objects related to this
        * Component Instance and allows you to destroy the Component Instance via the {@link #destroy}
        * method.
        *
        */
    export class ɵRender3ComponentRef<T> extends ComponentRef<T> {
            location: ElementRef;
            instance: T;
            hostView: ɵViewRef<T>;
            changeDetectorRef: ChangeDetectorRef;
            componentType: Type<T>;
            constructor(componentType: Type<T>, instance: T, location: ElementRef, _rootLView: LView, _tNode: TElementNode | TContainerNode | TElementContainerNode);
            setInput(name: string, value: unknown): void;
            get injector(): Injector;
            destroy(): void;
            onDestroy(callback: () => void): void;
    }
    
    export class ɵRender3NgModuleRef<T> extends NgModuleRef<T> implements InternalNgModuleRef<T> {
            _parent: Injector | null;
            _bootstrapComponents: Type<any>[];
            _r3Injector: R3Injector;
            instance: T;
            destroyCbs: (() => void)[] | null;
            readonly componentFactoryResolver: ComponentFactoryResolver_2;
            constructor(ngModuleType: Type<T>, _parent: Injector | null);
            get injector(): EnvironmentInjector;
            destroy(): void;
            onDestroy(callback: () => void): void;
    }
    
    /**
        * Flags passed into template functions to determine which blocks (i.e. creation, update)
        * should be executed.
        *
        * Typically, a template runs both the creation block and the update block on initialization and
        * subsequent runs only execute the update block. However, dynamically created views require that
        * the creation block be executed separately from the update block (for backwards compat).
        */
    export const enum ɵRenderFlags {
            Create = 1,
            Update = 2
    }
    
    export function ɵresetCompiledComponents(): void;
    
    export function ɵresetJitOptions(): void;
    
    /**
        * Used to resolve resource URLs on `@Component` when used with JIT compilation.
        *
        * Example:
        * ```
        * @Component({
        *   selector: 'my-comp',
        *   templateUrl: 'my-comp.html', // This requires asynchronous resolution
        * })
        * class MyComponent{
        * }
        *
        * // Calling `renderComponent` will fail because `renderComponent` is a synchronous process
        * // and `MyComponent`'s `@Component.templateUrl` needs to be resolved asynchronously.
        *
        * // Calling `resolveComponentResources()` will resolve `@Component.templateUrl` into
        * // `@Component.template`, which allows `renderComponent` to proceed in a synchronous manner.
        *
        * // Use browser's `fetch()` function as the default resource resolution strategy.
        * resolveComponentResources(fetch).then(() => {
        *   // After resolution all URLs have been converted into `template` strings.
        *   renderComponent(MyComponent);
        * });
        *
        * ```
        *
        * NOTE: In AOT the resolution happens during compilation, and so there should be no need
        * to call this method outside JIT mode.
        *
        * @param resourceResolver a function which is responsible for returning a `Promise` to the
        * contents of the resolved URL. Browser's `fetch()` method is a good default implementation.
        */
    export function ɵresolveComponentResources(resourceResolver: (url: string) => (Promise<string | {
            text(): Promise<string>;
    }>)): Promise<void>;
    
    /**
        * Class that represents a runtime error.
        * Formats and outputs the error message in a consistent way.
        *
        * Example:
        * ```
        *  throw new RuntimeError(
        *    RuntimeErrorCode.INJECTOR_ALREADY_DESTROYED,
        *    ngDevMode && 'Injector has already been destroyed.');
        * ```
        *
        * Note: the `message` argument contains a descriptive error message as a string in development
        * mode (when the `ngDevMode` is defined). In production mode (after tree-shaking pass), the
        * `message` argument becomes `false`, thus we account for it in the typings and the runtime logic.
        */
    export class ɵRuntimeError<T extends number = RuntimeErrorCode> extends Error {
            code: T;
            constructor(code: T, message: null | false | string);
    }
    
    /**
        * Marker interface for a value that's safe to use as HTML.
        *
        * @publicApi
        */
    export interface ɵSafeHtml extends ɵSafeValue {
    }
    
    /**
        * Marker interface for a value that's safe to use as a URL to load executable code from.
        *
        * @publicApi
        */
    export interface ɵSafeResourceUrl extends ɵSafeValue {
    }
    
    /**
        * Marker interface for a value that's safe to use as JavaScript.
        *
        * @publicApi
        */
    export interface ɵSafeScript extends ɵSafeValue {
    }
    
    /**
        * Marker interface for a value that's safe to use as style (CSS).
        *
        * @publicApi
        */
    export interface ɵSafeStyle extends ɵSafeValue {
    }
    
    /**
        * Marker interface for a value that's safe to use as a URL linking to a document.
        *
        * @publicApi
        */
    export interface ɵSafeUrl extends ɵSafeValue {
    }
    
    /**
        * Marker interface for a value that's safe to use in a particular context.
        *
        * @publicApi
        */
    export interface ɵSafeValue {
    }
    
    /**
        * Control whether the NgModule registration system enforces that each NgModule type registered has
        * a unique id.
        *
        * This is useful for testing as the NgModule registry cannot be properly reset between tests with
        * Angular's current API.
        */
    export function ɵsetAllowDuplicateNgModuleIdsForTest(allowDuplicates: boolean): void;
    
    /**
        * Adds decorator, constructor, and property metadata to a given type via static metadata fields
        * on the type.
        *
        * These metadata fields can later be read with Angular's `ReflectionCapabilities` API.
        *
        * Calls to `setClassMetadata` can be guarded by ngDevMode, resulting in the metadata assignments
        * being tree-shaken away during production builds.
        */
    export function ɵsetClassMetadata(type: Type<any>, decorators: any[] | null, ctorParameters: (() => any[]) | null, propDecorators: {
            [field: string]: any;
    } | null): void;
    
    export function ɵsetCurrentInjector(injector: Injector | null | undefined): Injector | undefined | null;
    
    
    /**
        * Tell ivy what the `document` is for this platform.
        *
        * It is only necessary to call this if the current platform is not a browser.
        *
        * @param document The object representing the global `document` in this environment.
        */
    export function ɵsetDocument(document: Document | undefined): void;
    
    
    /**
        * Sets the locale id that will be used for translations and ICU expressions.
        * This is the ivy version of `LOCALE_ID` that was defined as an injection token for the view engine
        * but is now defined as a global value.
        *
        * @param localeId
        */
    export function ɵsetLocaleId(localeId: string): void;
    
    /**
        * Sets a strict mode for JIT-compiled components to throw an error on unknown elements,
        * instead of just logging the error.
        * (for AOT-compiled ones this check happens at build time).
        */
    export function ɵsetUnknownElementStrictMode(shouldThrow: boolean): void;
    
    /**
        * Sets a strict mode for JIT-compiled components to throw an error on unknown properties,
        * instead of just logging the error.
        * (for AOT-compiled ones this check happens at build time).
        */
    export function ɵsetUnknownPropertyStrictMode(shouldThrow: boolean): void;
    
    /** Store a value in the `data` at a given `index`. */
    export function ɵstore<T>(tView: TView, lView: LView, index: number, value: T): void;
    
    
    export function ɵstringify(token: any): string;
    
    /**
        * Internal injection token that can used to access an instance of a Testability class.
        *
        * This token acts as a bridge between the core bootstrap code and the `Testability` class. This is
        * needed to ensure that there are no direct references to the `Testability` class, so it can be
        * tree-shaken away (if not referenced). For the environments/setups when the `Testability` class
        * should be available, this token is used to add a provider that references the `Testability`
        * class. Otherwise, only this token is retained in a bundle, but the `Testability` class is not.
        */
    export const ɵTESTABILITY: InjectionToken<Testability>;
    
    /**
        * Internal injection token to retrieve Testability getter class instance.
        */
    export const ɵTESTABILITY_GETTER: InjectionToken<GetTestability>;
    
    /**
        * Compute the pair of transitive scopes (compilation scope and exported scope) for a given type
        * (either a NgModule or a standalone component / directive / pipe).
        */
    export function ɵtransitiveScopesFor<T>(type: Type<T>): ɵNgModuleTransitiveScopes;
    
    /**
        * Helper function to remove all the locale data from `LOCALE_DATA`.
        */
    export function ɵunregisterLocaleData(): void;
    
    export function ɵunwrapSafeValue(value: ɵSafeValue): string;
    
    export function ɵunwrapSafeValue<T>(value: T): T;
    
    export class ɵViewRef<T> implements EmbeddedViewRef<T>, InternalViewRef, ChangeDetectorRefInterface {
            get rootNodes(): any[];
            constructor(
            /**
                * This represents `LView` associated with the component when ViewRef is a ChangeDetectorRef.
                *
                * When ViewRef is created for a dynamic component, this also represents the `LView` for the
                * component.
                *
                * For a "regular" ViewRef created for an embedded view, this is the `LView` for the embedded
                * view.
                *
                * @internal
                */
            _lView: LView, 
            /**
                * This represents the `LView` associated with the point where `ChangeDetectorRef` was
                * requested.
                *
                * This may be different from `_lView` if the `_cdRefInjectingView` is an embedded view.
                */
            _cdRefInjectingView?: LView<unknown> | undefined);
            get context(): T;
            set context(value: T);
            get destroyed(): boolean;
            destroy(): void;
            onDestroy(callback: Function): void;
            /**
                * Marks a view and all of its ancestors dirty.
                *
                * This can be used to ensure an {@link ChangeDetectionStrategy#OnPush OnPush} component is
                * checked when it needs to be re-rendered but the two normal triggers haven't marked it
                * dirty (i.e. inputs haven't changed and events haven't fired in the view).
                *
                * <!-- TODO: Add a link to a chapter on OnPush components -->
                *
                * @usageNotes
                * ### Example
                *
                * ```typescript
                * @Component({
                *   selector: 'app-root',
                *   template: `Number of ticks: {{numberOfTicks}}`
                *   changeDetection: ChangeDetectionStrategy.OnPush,
                * })
                * class AppComponent {
                *   numberOfTicks = 0;
                *
                *   constructor(private ref: ChangeDetectorRef) {
                *     setInterval(() => {
                *       this.numberOfTicks++;
                *       // the following is required, otherwise the view will not be updated
                *       this.ref.markForCheck();
                *     }, 1000);
                *   }
                * }
                * ```
                */
            markForCheck(): void;
            /**
                * Detaches the view from the change detection tree.
                *
                * Detached views will not be checked during change detection runs until they are
                * re-attached, even if they are dirty. `detach` can be used in combination with
                * {@link ChangeDetectorRef#detectChanges detectChanges} to implement local change
                * detection checks.
                *
                * <!-- TODO: Add a link to a chapter on detach/reattach/local digest -->
                * <!-- TODO: Add a live demo once ref.detectChanges is merged into master -->
                *
                * @usageNotes
                * ### Example
                *
                * The following example defines a component with a large list of readonly data.
                * Imagine the data changes constantly, many times per second. For performance reasons,
                * we want to check and update the list every five seconds. We can do that by detaching
                * the component's change detector and doing a local check every five seconds.
                *
                * ```typescript
                * class DataProvider {
                *   // in a real application the returned data will be different every time
                *   get data() {
                *     return [1,2,3,4,5];
                *   }
                * }
                *
                * @Component({
                *   selector: 'giant-list',
                *   template: `
                *     <li *ngFor="let d of dataProvider.data">Data {{d}}</li>
                *   `,
                * })
                * class GiantList {
                *   constructor(private ref: ChangeDetectorRef, private dataProvider: DataProvider) {
                *     ref.detach();
                *     setInterval(() => {
                *       this.ref.detectChanges();
                *     }, 5000);
                *   }
                * }
                *
                * @Component({
                *   selector: 'app',
                *   providers: [DataProvider],
                *   template: `
                *     <giant-list><giant-list>
                *   `,
                * })
                * class App {
                * }
                * ```
                */
            detach(): void;
            /**
                * Re-attaches a view to the change detection tree.
                *
                * This can be used to re-attach views that were previously detached from the tree
                * using {@link ChangeDetectorRef#detach detach}. Views are attached to the tree by default.
                *
                * <!-- TODO: Add a link to a chapter on detach/reattach/local digest -->
                *
                * @usageNotes
                * ### Example
                *
                * The following example creates a component displaying `live` data. The component will detach
                * its change detector from the main change detector tree when the component's live property
                * is set to false.
                *
                * ```typescript
                * class DataProvider {
                *   data = 1;
                *
                *   constructor() {
                *     setInterval(() => {
                *       this.data = this.data * 2;
                *     }, 500);
                *   }
                * }
                *
                * @Component({
                *   selector: 'live-data',
                *   inputs: ['live'],
                *   template: 'Data: {{dataProvider.data}}'
                * })
                * class LiveData {
                *   constructor(private ref: ChangeDetectorRef, private dataProvider: DataProvider) {}
                *
                *   set live(value) {
                *     if (value) {
                *       this.ref.reattach();
                *     } else {
                *       this.ref.detach();
                *     }
                *   }
                * }
                *
                * @Component({
                *   selector: 'app-root',
                *   providers: [DataProvider],
                *   template: `
                *     Live Update: <input type="checkbox" [(ngModel)]="live">
                *     <live-data [live]="live"><live-data>
                *   `,
                * })
                * class AppComponent {
                *   live = true;
                * }
                * ```
                */
            reattach(): void;
            /**
                * Checks the view and its children.
                *
                * This can also be used in combination with {@link ChangeDetectorRef#detach detach} to implement
                * local change detection checks.
                *
                * <!-- TODO: Add a link to a chapter on detach/reattach/local digest -->
                * <!-- TODO: Add a live demo once ref.detectChanges is merged into master -->
                *
                * @usageNotes
                * ### Example
                *
                * The following example defines a component with a large list of readonly data.
                * Imagine, the data changes constantly, many times per second. For performance reasons,
                * we want to check and update the list every five seconds.
                *
                * We can do that by detaching the component's change detector and doing a local change detection
                * check every five seconds.
                *
                * See {@link ChangeDetectorRef#detach detach} for more information.
                */
            detectChanges(): void;
            /**
                * Checks the change detector and its children, and throws if any changes are detected.
                *
                * This is used in development mode to verify that running change detection doesn't
                * introduce other changes.
                */
            checkNoChanges(): void;
            attachToViewContainerRef(): void;
            detachFromAppRef(): void;
            attachToAppRef(appRef: ViewRefTracker): void;
    }
    
    /**
        * URL for the XSS security documentation.
        */
    export const ɵXSS_SECURITY_URL = "https://g.co/ng/security#xss";
    
    /**
        * Advances to an element for later binding instructions.
        *
        * Used in conjunction with instructions like {@link property} to act on elements with specified
        * indices, for example those created with {@link element} or {@link elementStart}.
        *
        * ```ts
        * (rf: RenderFlags, ctx: any) => {
        *   if (rf & 1) {
        *     text(0, 'Hello');
        *     text(1, 'Goodbye')
        *     element(2, 'div');
        *   }
        *   if (rf & 2) {
        *     advance(2); // Advance twice to the <div>.
        *     property('title', 'test');
        *   }
        *  }
        * ```
        * @param delta Number of elements to advance forwards by.
        *
        * @codeGenApi
        */
    export function ɵɵadvance(delta: number): void;
    
    /**
        * Updates the value of or removes a bound attribute on an Element.
        *
        * Used in the case of `[attr.title]="value"`
        *
        * @param name name The name of the attribute.
        * @param value value The attribute is removed when value is `null` or `undefined`.
        *                  Otherwise the attribute value is set to the stringified value.
        * @param sanitizer An optional function used to sanitize the value.
        * @param namespace Optional namespace to use when setting the attribute.
        *
        * @codeGenApi
        */
    export function ɵɵattribute(name: string, value: any, sanitizer?: SanitizerFn | null, namespace?: string): typeof ɵɵattribute;
    
    /**
        *
        * Update an interpolated attribute on an element with single bound value surrounded by text.
        *
        * Used when the value passed to a property has 1 interpolated value in it:
        *
        * ```html
        * <div attr.title="prefix{{v0}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolate1('title', 'prefix', v0, 'suffix');
        * ```
        *
        * @param attrName The name of the attribute to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolate1(attrName: string, prefix: string, v0: any, suffix: string, sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolate1;
    
    /**
        *
        * Update an interpolated attribute on an element with 2 bound values surrounded by text.
        *
        * Used when the value passed to a property has 2 interpolated values in it:
        *
        * ```html
        * <div attr.title="prefix{{v0}}-{{v1}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolate2('title', 'prefix', v0, '-', v1, 'suffix');
        * ```
        *
        * @param attrName The name of the attribute to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolate2(attrName: string, prefix: string, v0: any, i0: string, v1: any, suffix: string, sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolate2;
    
    /**
        *
        * Update an interpolated attribute on an element with 3 bound values surrounded by text.
        *
        * Used when the value passed to a property has 3 interpolated values in it:
        *
        * ```html
        * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolate3(
        * 'title', 'prefix', v0, '-', v1, '-', v2, 'suffix');
        * ```
        *
        * @param attrName The name of the attribute to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolate3(attrName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, suffix: string, sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolate3;
    
    /**
        *
        * Update an interpolated attribute on an element with 4 bound values surrounded by text.
        *
        * Used when the value passed to a property has 4 interpolated values in it:
        *
        * ```html
        * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolate4(
        * 'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, 'suffix');
        * ```
        *
        * @param attrName The name of the attribute to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolate4(attrName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, suffix: string, sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolate4;
    
    /**
        *
        * Update an interpolated attribute on an element with 5 bound values surrounded by text.
        *
        * Used when the value passed to a property has 5 interpolated values in it:
        *
        * ```html
        * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolate5(
        * 'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, 'suffix');
        * ```
        *
        * @param attrName The name of the attribute to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolate5(attrName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, suffix: string, sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolate5;
    
    /**
        *
        * Update an interpolated attribute on an element with 6 bound values surrounded by text.
        *
        * Used when the value passed to a property has 6 interpolated values in it:
        *
        * ```html
        * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolate6(
        *    'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, 'suffix');
        * ```
        *
        * @param attrName The name of the attribute to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolate6(attrName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, suffix: string, sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolate6;
    
    /**
        *
        * Update an interpolated attribute on an element with 7 bound values surrounded by text.
        *
        * Used when the value passed to a property has 7 interpolated values in it:
        *
        * ```html
        * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolate7(
        *    'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, 'suffix');
        * ```
        *
        * @param attrName The name of the attribute to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param i5 Static value used for concatenation only.
        * @param v6 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolate7(attrName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, i5: string, v6: any, suffix: string, sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolate7;
    
    /**
        *
        * Update an interpolated attribute on an element with 8 bound values surrounded by text.
        *
        * Used when the value passed to a property has 8 interpolated values in it:
        *
        * ```html
        * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolate8(
        *  'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, 'suffix');
        * ```
        *
        * @param attrName The name of the attribute to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param i5 Static value used for concatenation only.
        * @param v6 Value checked for change.
        * @param i6 Static value used for concatenation only.
        * @param v7 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolate8(attrName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, i5: string, v6: any, i6: string, v7: any, suffix: string, sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolate8;
    
    /**
        * Update an interpolated attribute on an element with 9 or more bound values surrounded by text.
        *
        * Used when the number of interpolated values exceeds 8.
        *
        * ```html
        * <div
        *  title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}-{{v8}}-{{v9}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵattributeInterpolateV(
        *  'title', ['prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, '-', v9,
        *  'suffix']);
        * ```
        *
        * @param attrName The name of the attribute to update.
        * @param values The collection of values and the strings in-between those values, beginning with
        * a string prefix and ending with a string suffix.
        * (e.g. `['prefix', value0, '-', value1, '-', value2, ..., value99, 'suffix']`)
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵattributeInterpolateV(attrName: string, values: any[], sanitizer?: SanitizerFn, namespace?: string): typeof ɵɵattributeInterpolateV;
    
    /**
        * Update class bindings using an object literal or class-string on an element.
        *
        * This instruction is meant to apply styling via the `[class]="exp"` template bindings.
        * When classes are applied to the element they will then be updated with
        * respect to any styles/classes set via `classProp`. If any
        * classes are set to falsy then they will be removed from the element.
        *
        * Note that the styling instruction will not be applied until `stylingApply` is called.
        * Note that this will the provided classMap value to the host element if this function is called
        * within a host binding.
        *
        * @param classes A key/value map or string of CSS classes that will be added to the
        *        given element. Any missing classes (that have already been applied to the element
        *        beforehand) will be removed (unset) from the element's list of CSS classes.
        *
        * @codeGenApi
        */
    export function ɵɵclassMap(classes: {
            [className: string]: boolean | undefined | null;
    } | string | undefined | null): void;
    
    
    /**
        *
        * Update an interpolated class on an element with single bound value surrounded by text.
        *
        * Used when the value passed to a property has 1 interpolated value in it:
        *
        * ```html
        * <div class="prefix{{v0}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolate1('prefix', v0, 'suffix');
        * ```
        *
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolate1(prefix: string, v0: any, suffix: string): void;
    
    /**
        *
        * Update an interpolated class on an element with 2 bound values surrounded by text.
        *
        * Used when the value passed to a property has 2 interpolated values in it:
        *
        * ```html
        * <div class="prefix{{v0}}-{{v1}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolate2('prefix', v0, '-', v1, 'suffix');
        * ```
        *
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolate2(prefix: string, v0: any, i0: string, v1: any, suffix: string): void;
    
    /**
        *
        * Update an interpolated class on an element with 3 bound values surrounded by text.
        *
        * Used when the value passed to a property has 3 interpolated values in it:
        *
        * ```html
        * <div class="prefix{{v0}}-{{v1}}-{{v2}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolate3(
        * 'prefix', v0, '-', v1, '-', v2, 'suffix');
        * ```
        *
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolate3(prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, suffix: string): void;
    
    /**
        *
        * Update an interpolated class on an element with 4 bound values surrounded by text.
        *
        * Used when the value passed to a property has 4 interpolated values in it:
        *
        * ```html
        * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolate4(
        * 'prefix', v0, '-', v1, '-', v2, '-', v3, 'suffix');
        * ```
        *
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolate4(prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, suffix: string): void;
    
    /**
        *
        * Update an interpolated class on an element with 5 bound values surrounded by text.
        *
        * Used when the value passed to a property has 5 interpolated values in it:
        *
        * ```html
        * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolate5(
        * 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, 'suffix');
        * ```
        *
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolate5(prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, suffix: string): void;
    
    /**
        *
        * Update an interpolated class on an element with 6 bound values surrounded by text.
        *
        * Used when the value passed to a property has 6 interpolated values in it:
        *
        * ```html
        * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolate6(
        *    'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, 'suffix');
        * ```
        *
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolate6(prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, suffix: string): void;
    
    /**
        *
        * Update an interpolated class on an element with 7 bound values surrounded by text.
        *
        * Used when the value passed to a property has 7 interpolated values in it:
        *
        * ```html
        * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolate7(
        *    'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, 'suffix');
        * ```
        *
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param i5 Static value used for concatenation only.
        * @param v6 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolate7(prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, i5: string, v6: any, suffix: string): void;
    
    /**
        *
        * Update an interpolated class on an element with 8 bound values surrounded by text.
        *
        * Used when the value passed to a property has 8 interpolated values in it:
        *
        * ```html
        * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolate8(
        *  'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, 'suffix');
        * ```
        *
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param i5 Static value used for concatenation only.
        * @param v6 Value checked for change.
        * @param i6 Static value used for concatenation only.
        * @param v7 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolate8(prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, i5: string, v6: any, i6: string, v7: any, suffix: string): void;
    
    /**
        * Update an interpolated class on an element with 9 or more bound values surrounded by text.
        *
        * Used when the number of interpolated values exceeds 8.
        *
        * ```html
        * <div
        *  class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}-{{v8}}-{{v9}}suffix"></div>
        * ```
        *
        * Its compiled representation is:
        *
        * ```ts
        * ɵɵclassMapInterpolateV(
        *  ['prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, '-', v9,
        *  'suffix']);
        * ```
        *.
        * @param values The collection of values and the strings in-between those values, beginning with
        * a string prefix and ending with a string suffix.
        * (e.g. `['prefix', value0, '-', value1, '-', value2, ..., value99, 'suffix']`)
        * @codeGenApi
        */
    export function ɵɵclassMapInterpolateV(values: any[]): void;
    
    /**
        * Update a class binding on an element with the provided value.
        *
        * This instruction is meant to handle the `[class.foo]="exp"` case and,
        * therefore, the class binding itself must already be allocated using
        * `styling` within the creation block.
        *
        * @param prop A valid CSS class (only one).
        * @param value A true/false value which will turn the class on or off.
        *
        * Note that this will apply the provided class value to the host element if this function
        * is called within a host binding function.
        *
        * @codeGenApi
        */
    export function ɵɵclassProp(className: string, value: boolean | undefined | null): typeof ɵɵclassProp;
    
    /**
        * @publicApi
        */
    export type ɵɵComponentDeclaration<T, Selector extends String, ExportAs extends string[], InputMap extends {
            [key: string]: string;
    }, OutputMap extends {
            [key: string]: string;
    }, QueryFields extends string[], NgContentSelectors extends string[], IsStandalone extends boolean = false, HostDirectives = never> = unknown;
    
    /**
        * Registers a QueryList, associated with a content query, for later refresh (part of a view
        * refresh).
        *
        * @param directiveIndex Current directive index
        * @param predicate The type for which the query will search
        * @param flags Flags associated with the query
        * @param read What to save in the query
        * @returns QueryList<T>
        *
        * @codeGenApi
        */
    export function ɵɵcontentQuery<T>(directiveIndex: number, predicate: ProviderToken<unknown> | string[], flags: QueryFlags, read?: any): void;
    
    /**
        * Copies the fields not handled by the `ɵɵInheritDefinitionFeature` from the supertype of a
        * definition.
        *
        * This exists primarily to support ngcc migration of an existing View Engine pattern, where an
        * entire decorator is inherited from a parent to a child class. When ngcc detects this case, it
        * generates a skeleton definition on the child class, and applies this feature.
        *
        * The `ɵɵCopyDefinitionFeature` then copies any needed fields from the parent class' definition,
        * including things like the component template function.
        *
        * @param definition The definition of a child class which inherits from a parent class with its
        * own definition.
        *
        * @codeGenApi
        */
    export function ɵɵCopyDefinitionFeature(definition: ɵDirectiveDef<any> | ɵComponentDef<any>): void;
    
    /**
        * Create a component definition object.
        *
        *
        * # Example
        * ```
        * class MyComponent {
        *   // Generated by Angular Template Compiler
        *   // [Symbol] syntax will not be supported by TypeScript until v2.7
        *   static ɵcmp = defineComponent({
        *     ...
        *   });
        * }
        * ```
        * @codeGenApi
        */
    export function ɵɵdefineComponent<T>(componentDefinition: ComponentDefinition<T>): Mutable<ɵComponentDef<any>, keyof ɵComponentDef<any>>;
    
    /**
        * Create a directive definition object.
        *
        * # Example
        * ```ts
        * class MyDirective {
        *   // Generated by Angular Template Compiler
        *   // [Symbol] syntax will not be supported by TypeScript until v2.7
        *   static ɵdir = ɵɵdefineDirective({
        *     ...
        *   });
        * }
        * ```
        *
        * @codeGenApi
        */
    export function ɵɵdefineDirective<T>(directiveDefinition: DirectiveDefinition<T>): Mutable<ɵDirectiveDef<any>, keyof ɵDirectiveDef<any>>;
    
    /**
        * Construct an injectable definition which defines how a token will be constructed by the DI
        * system, and in which injectors (if any) it will be available.
        *
        * This should be assigned to a static `ɵprov` field on a type, which will then be an
        * `InjectableType`.
        *
        * Options:
        * * `providedIn` determines which injectors will include the injectable, by either associating it
        *   with an `@NgModule` or other `InjectorType`, or by specifying that this injectable should be
        *   provided in the `'root'` injector, which will be the application-level injector in most apps.
        * * `factory` gives the zero argument function which will create an instance of the injectable.
        *   The factory can call `inject` to access the `Injector` and request injection of dependencies.
        *
        * @codeGenApi
        * @publicApi This instruction has been emitted by ViewEngine for some time and is deployed to npm.
        */
    export function ɵɵdefineInjectable<T>(opts: {
            token: unknown;
            providedIn?: Type<any> | 'root' | 'platform' | 'any' | 'environment' | null;
            factory: () => T;
    }): unknown;
    
    /**
        * Construct an `InjectorDef` which configures an injector.
        *
        * This should be assigned to a static injector def (`ɵinj`) field on a type, which will then be an
        * `InjectorType`.
        *
        * Options:
        *
        * * `providers`: an optional array of providers to add to the injector. Each provider must
        *   either have a factory or point to a type which has a `ɵprov` static property (the
        *   type must be an `InjectableType`).
        * * `imports`: an optional array of imports of other `InjectorType`s or `InjectorTypeWithModule`s
        *   whose providers will also be added to the injector. Locally provided types will override
        *   providers from imports.
        *
        * @codeGenApi
        */
    export function ɵɵdefineInjector(options: {
            providers?: any[];
            imports?: any[];
    }): unknown;
    
    /**
        * @codeGenApi
        */
    export function ɵɵdefineNgModule<T>(def: {
            /** Token representing the module. Used by DI. */
            type: T;
            /** List of components to bootstrap. */
            bootstrap?: Type<any>[] | (() => Type<any>[]);
            /** List of components, directives, and pipes declared by this module. */
            declarations?: Type<any>[] | (() => Type<any>[]);
            /** List of modules or `ModuleWithProviders` imported by this module. */
            imports?: Type<any>[] | (() => Type<any>[]);
            /**
                * List of modules, `ModuleWithProviders`, components, directives, or pipes exported by this
                * module.
                */
            exports?: Type<any>[] | (() => Type<any>[]);
            /** The set of schemas that declare elements to be allowed in the NgModule. */
            schemas?: SchemaMetadata[] | null;
            /** Unique ID for the module that is used with `getModuleFactory`. */
            id?: string | null;
    }): unknown;
    
    /**
        * Create a pipe definition object.
        *
        * # Example
        * ```
        * class MyPipe implements PipeTransform {
        *   // Generated by Angular Template Compiler
        *   static ɵpipe = definePipe({
        *     ...
        *   });
        * }
        * ```
        * @param pipeDef Pipe definition generated by the compiler
        *
        * @codeGenApi
        */
    export function ɵɵdefinePipe<T>(pipeDef: {
            /** Name of the pipe. Used for matching pipes in template to pipe defs. */
            name: string;
            /** Pipe class reference. Needed to extract pipe lifecycle hooks. */
            type: Type<T>;
            /** Whether the pipe is pure. */
            pure?: boolean;
            /**
                * Whether the pipe is standalone.
                */
            standalone?: boolean;
    }): unknown;
    
    
    /**
        * @publicApi
        */
    export type ɵɵDirectiveDeclaration<T, Selector extends string, ExportAs extends string[], InputMap extends {
            [key: string]: string;
    }, OutputMap extends {
            [key: string]: string;
    }, QueryFields extends string[], NgContentSelectors extends never = never, IsStandalone extends boolean = false, HostDirectives = never> = unknown;
    
    /**
        * Returns the value associated to the given token from the injectors.
        *
        * `directiveInject` is intended to be used for directive, component and pipe factories.
        *  All other injection use `inject` which does not walk the node injector tree.
        *
        * Usage example (in factory function):
        *
        * ```ts
        * class SomeDirective {
        *   constructor(directive: DirectiveA) {}
        *
        *   static ɵdir = ɵɵdefineDirective({
        *     type: SomeDirective,
        *     factory: () => new SomeDirective(ɵɵdirectiveInject(DirectiveA))
        *   });
        * }
        * ```
        * @param token the type or token to inject
        * @param flags Injection flags
        * @returns the value from the injector or `null` when not found
        *
        * @codeGenApi
        */
    export function ɵɵdirectiveInject<T>(token: ProviderToken<T>): T;
    
    export function ɵɵdirectiveInject<T>(token: ProviderToken<T>, flags: InjectFlags): T;
    
    /**
        * Disables directive matching on element.
        *
        *  * Example:
        * ```
        * <my-comp my-directive>
        *   Should match component / directive.
        * </my-comp>
        * <div ngNonBindable>
        *   <!-- ɵɵdisableBindings() -->
        *   <my-comp my-directive>
        *     Should not match component / directive because we are in ngNonBindable.
        *   </my-comp>
        *   <!-- ɵɵenableBindings() -->
        * </div>
        * ```
        *
        * @codeGenApi
        */
    export function ɵɵdisableBindings(): void;
    
    /**
        * Creates an empty element using {@link elementStart} and {@link elementEnd}
        *
        * @param index Index of the element in the data array
        * @param name Name of the DOM Node
        * @param attrsIndex Index of the element's attributes in the `consts` array.
        * @param localRefsIndex Index of the element's local references in the `consts` array.
        * @returns This function returns itself so that it may be chained.
        *
        * @codeGenApi
        */
    export function ɵɵelement(index: number, name: string, attrsIndex?: number | null, localRefsIndex?: number): typeof ɵɵelement;
    
    /**
        * Creates an empty logical container using {@link elementContainerStart}
        * and {@link elementContainerEnd}
        *
        * @param index Index of the element in the LView array
        * @param attrsIndex Index of the container attributes in the `consts` array.
        * @param localRefsIndex Index of the container's local references in the `consts` array.
        * @returns This function returns itself so that it may be chained.
        *
        * @codeGenApi
        */
    export function ɵɵelementContainer(index: number, attrsIndex?: number | null, localRefsIndex?: number): typeof ɵɵelementContainer;
    
    /**
        * Mark the end of the <ng-container>.
        * @returns This function returns itself so that it may be chained.
        *
        * @codeGenApi
        */
    export function ɵɵelementContainerEnd(): typeof ɵɵelementContainerEnd;
    
    /**
        * Creates a logical container for other nodes (<ng-container>) backed by a comment node in the DOM.
        * The instruction must later be followed by `elementContainerEnd()` call.
        *
        * @param index Index of the element in the LView array
        * @param attrsIndex Index of the container attributes in the `consts` array.
        * @param localRefsIndex Index of the container's local references in the `consts` array.
        * @returns This function returns itself so that it may be chained.
        *
        * Even if this instruction accepts a set of attributes no actual attribute values are propagated to
        * the DOM (as a comment node can't have attributes). Attributes are here only for directive
        * matching purposes and setting initial inputs of directives.
        *
        * @codeGenApi
        */
    export function ɵɵelementContainerStart(index: number, attrsIndex?: number | null, localRefsIndex?: number): typeof ɵɵelementContainerStart;
    
    /**
        * Mark the end of the element.
        * @returns This function returns itself so that it may be chained.
        *
        * @codeGenApi
        */
    export function ɵɵelementEnd(): typeof ɵɵelementEnd;
    
    
    /**
        * Create DOM element. The instruction must later be followed by `elementEnd()` call.
        *
        * @param index Index of the element in the LView array
        * @param name Name of the DOM Node
        * @param attrsIndex Index of the element's attributes in the `consts` array.
        * @param localRefsIndex Index of the element's local references in the `consts` array.
        * @returns This function returns itself so that it may be chained.
        *
        * Attributes and localRefs are passed as an array of strings where elements with an even index
        * hold an attribute name and elements with an odd index hold an attribute value, ex.:
        * ['id', 'warning5', 'class', 'alert']
        *
        * @codeGenApi
        */
    export function ɵɵelementStart(index: number, name: string, attrsIndex?: number | null, localRefsIndex?: number): typeof ɵɵelementStart;
    
    /**
        * Enables directive matching on elements.
        *
        *  * Example:
        * ```
        * <my-comp my-directive>
        *   Should match component / directive.
        * </my-comp>
        * <div ngNonBindable>
        *   <!-- ɵɵdisableBindings() -->
        *   <my-comp my-directive>
        *     Should not match component / directive because we are in ngNonBindable.
        *   </my-comp>
        *   <!-- ɵɵenableBindings() -->
        * </div>
        * ```
        *
        * @codeGenApi
        */
    export function ɵɵenableBindings(): void;
    
    /**
        * @publicApi
        */
    export type ɵɵFactoryDeclaration<T, CtorDependencies extends CtorDependency[]> = unknown;
    
    export enum ɵɵFactoryTarget {
            Directive = 0,
            Component = 1,
            Injectable = 2,
            Pipe = 3,
            NgModule = 4
    }
    
    /**
        * Returns the current OpaqueViewState instance.
        *
        * Used in conjunction with the restoreView() instruction to save a snapshot
        * of the current view and restore it when listeners are invoked. This allows
        * walking the declaration view tree in listeners to get vars from parent views.
        *
        * @codeGenApi
        */
    export function ɵɵgetCurrentView(): OpaqueViewState;
    
    /**
        * @codeGenApi
        */
    export function ɵɵgetInheritedFactory<T>(type: Type<any>): (type: Type<T>) => T;
    
    /**
        * This feature adds the host directives behavior to a directive definition by patching a
        * function onto it. The expectation is that the runtime will invoke the function during
        * directive matching.
        *
        * For example:
        * ```ts
        * class ComponentWithHostDirective {
        *   static ɵcmp = defineComponent({
        *    type: ComponentWithHostDirective,
        *    features: [ɵɵHostDirectivesFeature([
        *      SimpleHostDirective,
        *      {directive: AdvancedHostDirective, inputs: ['foo: alias'], outputs: ['bar']},
        *    ])]
        *  });
        * }
        * ```
        *
        * @codeGenApi
        */
    export function ɵɵHostDirectivesFeature(rawHostDirectives: HostDirectiveConfig[] | (() => HostDirectiveConfig[])): (definition: ɵDirectiveDef<unknown>) => void;
    
    /**
        * Update a property on a host element. Only applies to native node properties, not inputs.
        *
        * Operates on the element selected by index via the {@link select} instruction.
        *
        * @param propName Name of property. Because it is going to DOM, this is not subject to
        *        renaming as part of minification.
        * @param value New value to write.
        * @param sanitizer An optional function used to sanitize the value.
        * @returns This function returns itself so that it may be chained
        * (e.g. `property('name', ctx.name)('title', ctx.title)`)
        *
        * @codeGenApi
        */
    export function ɵɵhostProperty<T>(propName: string, value: T, sanitizer?: SanitizerFn | null): typeof ɵɵhostProperty;
    
    /**
        *
        * Use this instruction to create a translation block that doesn't contain any placeholder.
        * It calls both {@link i18nStart} and {@link i18nEnd} in one instruction.
        *
        * The translation `message` is the value which is locale specific. The translation string may
        * contain placeholders which associate inner elements and sub-templates within the translation.
        *
        * The translation `message` placeholders are:
        * - `�{index}(:{block})�`: *Binding Placeholder*: Marks a location where an expression will be
        *   interpolated into. The placeholder `index` points to the expression binding index. An optional
        *   `block` that matches the sub-template in which it was declared.
        * - `�#{index}(:{block})�`/`�/#{index}(:{block})�`: *Element Placeholder*:  Marks the beginning
        *   and end of DOM element that were embedded in the original translation block. The placeholder
        *   `index` points to the element index in the template instructions set. An optional `block` that
        *   matches the sub-template in which it was declared.
        * - `�*{index}:{block}�`/`�/*{index}:{block}�`: *Sub-template Placeholder*: Sub-templates must be
        *   split up and translated separately in each angular template function. The `index` points to the
        *   `template` instruction index. A `block` that matches the sub-template in which it was declared.
        *
        * @param index A unique index of the translation in the static block.
        * @param messageIndex An index of the translation message from the `def.consts` array.
        * @param subTemplateIndex Optional sub-template index in the `message`.
        *
        * @codeGenApi
        */
    export function ɵɵi18n(index: number, messageIndex: number, subTemplateIndex?: number): void;
    
    /**
        * Updates a translation block or an i18n attribute when the bindings have changed.
        *
        * @param index Index of either {@link i18nStart} (translation block) or {@link i18nAttributes}
        * (i18n attribute) on which it should update the content.
        *
        * @codeGenApi
        */
    export function ɵɵi18nApply(index: number): void;
    
    /**
        * Marks a list of attributes as translatable.
        *
        * @param index A unique index in the static block
        * @param values
        *
        * @codeGenApi
        */
    export function ɵɵi18nAttributes(index: number, attrsIndex: number): void;
    
    /**
        * Translates a translation block marked by `i18nStart` and `i18nEnd`. It inserts the text/ICU nodes
        * into the render tree, moves the placeholder nodes and removes the deleted nodes.
        *
        * @codeGenApi
        */
    export function ɵɵi18nEnd(): void;
    
    /**
        * Stores the values of the bindings during each update cycle in order to determine if we need to
        * update the translated nodes.
        *
        * @param value The binding's value
        * @returns This function returns itself so that it may be chained
        * (e.g. `i18nExp(ctx.name)(ctx.title)`)
        *
        * @codeGenApi
        */
    export function ɵɵi18nExp<T>(value: T): typeof ɵɵi18nExp;
    
    /**
        * Handles message string post-processing for internationalization.
        *
        * Handles message string post-processing by transforming it from intermediate
        * format (that might contain some markers that we need to replace) to the final
        * form, consumable by i18nStart instruction. Post processing steps include:
        *
        * 1. Resolve all multi-value cases (like [�*1:1��#2:1�|�#4:1�|�5�])
        * 2. Replace all ICU vars (like "VAR_PLURAL")
        * 3. Replace all placeholders used inside ICUs in a form of {PLACEHOLDER}
        * 4. Replace all ICU references with corresponding values (like �ICU_EXP_ICU_1�)
        *    in case multiple ICUs have the same placeholder name
        *
        * @param message Raw translation string for post processing
        * @param replacements Set of replacements that should be applied
        *
        * @returns Transformed string that can be consumed by i18nStart instruction
        *
        * @codeGenApi
        */
    export function ɵɵi18nPostprocess(message: string, replacements?: {
            [key: string]: (string | string[]);
    }): string;
    
    /**
        * Marks a block of text as translatable.
        *
        * The instructions `i18nStart` and `i18nEnd` mark the translation block in the template.
        * The translation `message` is the value which is locale specific. The translation string may
        * contain placeholders which associate inner elements and sub-templates within the translation.
        *
        * The translation `message` placeholders are:
        * - `�{index}(:{block})�`: *Binding Placeholder*: Marks a location where an expression will be
        *   interpolated into. The placeholder `index` points to the expression binding index. An optional
        *   `block` that matches the sub-template in which it was declared.
        * - `�#{index}(:{block})�`/`�/#{index}(:{block})�`: *Element Placeholder*:  Marks the beginning
        *   and end of DOM element that were embedded in the original translation block. The placeholder
        *   `index` points to the element index in the template instructions set. An optional `block` that
        *   matches the sub-template in which it was declared.
        * - `�*{index}:{block}�`/`�/*{index}:{block}�`: *Sub-template Placeholder*: Sub-templates must be
        *   split up and translated separately in each angular template function. The `index` points to the
        *   `template` instruction index. A `block` that matches the sub-template in which it was declared.
        *
        * @param index A unique index of the translation in the static block.
        * @param messageIndex An index of the translation message from the `def.consts` array.
        * @param subTemplateIndex Optional sub-template index in the `message`.
        *
        * @codeGenApi
        */
    export function ɵɵi18nStart(index: number, messageIndex: number, subTemplateIndex?: number): void;
    
    /**
        * Merges the definition from a super class to a sub class.
        * @param definition The definition that is a SubClass of another directive of component
        *
        * @codeGenApi
        */
    export function ɵɵInheritDefinitionFeature(definition: ɵDirectiveDef<any> | ɵComponentDef<any>): void;
    
    /**
        * Generated instruction: injects a token from the currently active injector.
        *
        * (Additional documentation moved to `inject`, as it is the public API, and an alias for this
        * instruction)
        *
        * @see inject
        * @codeGenApi
        * @publicApi This instruction has been emitted by ViewEngine for some time and is deployed to npm.
        */
    export function ɵɵinject<T>(token: ProviderToken<T>): T;
    
    export function ɵɵinject<T>(token: ProviderToken<T>, flags?: InjectFlags): T | null;
    
    /**
        * Information about how a type or `InjectionToken` interfaces with the DI system.
        *
        * At a minimum, this includes a `factory` which defines how to create the given type `T`, possibly
        * requesting injection of other types if necessary.
        *
        * Optionally, a `providedIn` parameter specifies that the given type belongs to a particular
        * `Injector`, `NgModule`, or a special scope (e.g. `'root'`). A value of `null` indicates
        * that the injectable does not belong to any scope.
        *
        * @codeGenApi
        * @publicApi The ViewEngine compiler emits code with this type for injectables. This code is
        *   deployed to npm, and should be treated as public api.
    
        */
    export interface ɵɵInjectableDeclaration<T> {
            /**
                * Specifies that the given type belongs to a particular injector:
                * - `InjectorType` such as `NgModule`,
                * - `'root'` the root injector
                * - `'any'` all injectors.
                * - `null`, does not belong to any injector. Must be explicitly listed in the injector
                *   `providers`.
                */
            providedIn: InjectorType<any> | 'root' | 'platform' | 'any' | 'environment' | null;
            /**
                * The token to which this definition belongs.
                *
                * Note that this may not be the same as the type that the `factory` will create.
                */
            token: unknown;
            /**
                * Factory method to execute to create an instance of the injectable.
                */
            factory: (t?: Type<any>) => T;
            /**
                * In a case of no explicit injector, a location where the instance of the injectable is stored.
                */
            value: T | undefined;
    }
    
    /**
        * Facade for the attribute injection from DI.
        *
        * @codeGenApi
        */
    export function ɵɵinjectAttribute(attrNameToInject: string): string | null;
    
    /**
        * @publicApi
        */
    export type ɵɵInjectorDeclaration<T> = unknown;
    
    /**
        * Information about the providers to be included in an `Injector` as well as how the given type
        * which carries the information should be created by the DI system.
        *
        * An `InjectorDef` can import other types which have `InjectorDefs`, forming a deep nested
        * structure of providers with a defined priority (identically to how `NgModule`s also have
        * an import/dependency structure).
        *
        * NOTE: This is a private type and should not be exported
        *
        * @codeGenApi
        */
    export interface ɵɵInjectorDef<T> {
            providers: (Type<any> | ValueProvider | ExistingProvider | FactoryProvider | ConstructorProvider | StaticClassProvider | ClassProvider | EnvironmentProviders | any[])[];
            imports: (InjectorType<any> | InjectorTypeWithProviders<any>)[];
    }
    
    /**
        * Throws an error indicating that a factory function could not be generated by the compiler for a
        * particular class.
        *
        * This instruction allows the actual error message to be optimized away when ngDevMode is turned
        * off, saving bytes of generated code while still providing a good experience in dev mode.
        *
        * The name of the class is not mentioned here, but will be in the generated factory function name
        * and thus in the stack trace.
        *
        * @codeGenApi
        */
    export function ɵɵinvalidFactory(): never;
    
    /**
        * Throws an error indicating that a factory function could not be generated by the compiler for a
        * particular class.
        *
        * The name of the class is not mentioned here, but will be in the generated factory function name
        * and thus in the stack trace.
        *
        * @codeGenApi
        */
    export function ɵɵinvalidFactoryDep(index: number): never;
    
    /**
        * Adds an event listener to the current node.
        *
        * If an output exists on one of the node's directives, it also subscribes to the output
        * and saves the subscription for later cleanup.
        *
        * @param eventName Name of the event
        * @param listenerFn The function to be called when event emits
        * @param useCapture Whether or not to use capture in event listener - this argument is a reminder
        *     from the Renderer3 infrastructure and should be removed from the instruction arguments
        * @param eventTargetResolver Function that returns global target information in case this listener
        * should be attached to a global object like window, document or body
        *
        * @codeGenApi
        */
    export function ɵɵlistener(eventName: string, listenerFn: (e?: any) => any, useCapture?: boolean, eventTargetResolver?: GlobalTargetResolver): typeof ɵɵlistener;
    
    /**
        * Loads a QueryList corresponding to the current view or content query.
        *
        * @codeGenApi
        */
    export function ɵɵloadQuery<T>(): QueryList<T>;
    
    /**
        * Sets the namespace used to create elements to `null`, which forces element creation to use
        * `createElement` rather than `createElementNS`.
        *
        * @codeGenApi
        */
    export function ɵɵnamespaceHTML(): void;
    
    /**
        * Sets the namespace used to create elements to `'http://www.w3.org/1998/MathML/'` in global state.
        *
        * @codeGenApi
        */
    export function ɵɵnamespaceMathML(): void;
    
    /**
        * Sets the namespace used to create elements to `'http://www.w3.org/2000/svg'` in global state.
        *
        * @codeGenApi
        */
    export function ɵɵnamespaceSVG(): void;
    
    /**
        * Retrieves a context at the level specified and saves it as the global, contextViewData.
        * Will get the next level up if level is not specified.
        *
        * This is used to save contexts of parent views so they can be bound in embedded views, or
        * in conjunction with reference() to bind a ref from a parent view.
        *
        * @param level The relative level of the view from which to grab context compared to contextVewData
        * @returns context
        *
        * @codeGenApi
        */
    export function ɵɵnextContext<T = any>(level?: number): T;
    
    /**
        * Evaluates the class metadata declaration.
        *
        * @codeGenApi
        */
    export function ɵɵngDeclareClassMetadata(decl: {
            type: Type<any>;
            decorators: any[];
            ctorParameters?: () => any[];
            propDecorators?: {
                    [field: string]: any;
            };
    }): void;
    
    /**
        * Compiles a partial component declaration object into a full component definition object.
        *
        * @codeGenApi
        */
    export function ɵɵngDeclareComponent(decl: R3DeclareComponentFacade): unknown;
    
    /**
        * Compiles a partial directive declaration object into a full directive definition object.
        *
        * @codeGenApi
        */
    export function ɵɵngDeclareDirective(decl: R3DeclareDirectiveFacade): unknown;
    
    /**
        * Compiles a partial pipe declaration object into a full pipe definition object.
        *
        * @codeGenApi
        */
    export function ɵɵngDeclareFactory(decl: R3DeclareFactoryFacade): unknown;
    
    /**
        * Compiles a partial injectable declaration object into a full injectable definition object.
        *
        * @codeGenApi
        */
    export function ɵɵngDeclareInjectable(decl: R3DeclareInjectableFacade): unknown;
    
    /**
        * Compiles a partial injector declaration object into a full injector definition object.
        *
        * @codeGenApi
        */
    export function ɵɵngDeclareInjector(decl: R3DeclareInjectorFacade): unknown;
    
    /**
        * Compiles a partial NgModule declaration object into a full NgModule definition object.
        *
        * @codeGenApi
        */
    export function ɵɵngDeclareNgModule(decl: R3DeclareNgModuleFacade): unknown;
    
    /**
        * Compiles a partial pipe declaration object into a full pipe definition object.
        *
        * @codeGenApi
        */
    export function ɵɵngDeclarePipe(decl: R3DeclarePipeFacade): unknown;
    
    /**
        * @publicApi
        */
    export type ɵɵNgModuleDeclaration<T, Declarations, Imports, Exports> = unknown;
    
    /**
        * The NgOnChangesFeature decorates a component with support for the ngOnChanges
        * lifecycle hook, so it should be included in any component that implements
        * that hook.
        *
        * If the component or directive uses inheritance, the NgOnChangesFeature MUST
        * be included as a feature AFTER {@link InheritDefinitionFeature}, otherwise
        * inherited properties will not be propagated to the ngOnChanges lifecycle
        * hook.
        *
        * Example usage:
        *
        * ```
        * static ɵcmp = defineComponent({
        *   ...
        *   inputs: {name: 'publicName'},
        *   features: [NgOnChangesFeature]
        * });
        * ```
        *
        * @codeGenApi
        */
    export function ɵɵNgOnChangesFeature<T>(): DirectiveDefFeature;
    
    
    /**
        * Create a pipe.
        *
        * @param index Pipe index where the pipe will be stored.
        * @param pipeName The name of the pipe
        * @returns T the instance of the pipe.
        *
        * @codeGenApi
        */
    export function ɵɵpipe(index: number, pipeName: string): any;
    
    /**
        * Invokes a pipe with 1 arguments.
        *
        * This instruction acts as a guard to {@link PipeTransform#transform} invoking
        * the pipe only when an input to the pipe changes.
        *
        * @param index Pipe index where the pipe was stored on creation.
        * @param slotOffset the offset in the reserved slot space
        * @param v1 1st argument to {@link PipeTransform#transform}.
        *
        * @codeGenApi
        */
    export function ɵɵpipeBind1(index: number, slotOffset: number, v1: any): any;
    
    /**
        * Invokes a pipe with 2 arguments.
        *
        * This instruction acts as a guard to {@link PipeTransform#transform} invoking
        * the pipe only when an input to the pipe changes.
        *
        * @param index Pipe index where the pipe was stored on creation.
        * @param slotOffset the offset in the reserved slot space
        * @param v1 1st argument to {@link PipeTransform#transform}.
        * @param v2 2nd argument to {@link PipeTransform#transform}.
        *
        * @codeGenApi
        */
    export function ɵɵpipeBind2(index: number, slotOffset: number, v1: any, v2: any): any;
    
    /**
        * Invokes a pipe with 3 arguments.
        *
        * This instruction acts as a guard to {@link PipeTransform#transform} invoking
        * the pipe only when an input to the pipe changes.
        *
        * @param index Pipe index where the pipe was stored on creation.
        * @param slotOffset the offset in the reserved slot space
        * @param v1 1st argument to {@link PipeTransform#transform}.
        * @param v2 2nd argument to {@link PipeTransform#transform}.
        * @param v3 4rd argument to {@link PipeTransform#transform}.
        *
        * @codeGenApi
        */
    export function ɵɵpipeBind3(index: number, slotOffset: number, v1: any, v2: any, v3: any): any;
    
    /**
        * Invokes a pipe with 4 arguments.
        *
        * This instruction acts as a guard to {@link PipeTransform#transform} invoking
        * the pipe only when an input to the pipe changes.
        *
        * @param index Pipe index where the pipe was stored on creation.
        * @param slotOffset the offset in the reserved slot space
        * @param v1 1st argument to {@link PipeTransform#transform}.
        * @param v2 2nd argument to {@link PipeTransform#transform}.
        * @param v3 3rd argument to {@link PipeTransform#transform}.
        * @param v4 4th argument to {@link PipeTransform#transform}.
        *
        * @codeGenApi
        */
    export function ɵɵpipeBind4(index: number, slotOffset: number, v1: any, v2: any, v3: any, v4: any): any;
    
    /**
        * Invokes a pipe with variable number of arguments.
        *
        * This instruction acts as a guard to {@link PipeTransform#transform} invoking
        * the pipe only when an input to the pipe changes.
        *
        * @param index Pipe index where the pipe was stored on creation.
        * @param slotOffset the offset in the reserved slot space
        * @param values Array of arguments to pass to {@link PipeTransform#transform} method.
        *
        * @codeGenApi
        */
    export function ɵɵpipeBindV(index: number, slotOffset: number, values: [any, ...any[]]): any;
    
    /**
        * @publicApi
        */
    export type ɵɵPipeDeclaration<T, Name extends string, IsStandalone extends boolean = false> = unknown;
    
    /**
        * Inserts previously re-distributed projected nodes. This instruction must be preceded by a call
        * to the projectionDef instruction.
        *
        * @param nodeIndex
        * @param selectorIndex:
        *        - 0 when the selector is `*` (or unspecified as this is the default value),
        *        - 1 based index of the selector from the {@link projectionDef}
        *
        * @codeGenApi
        */
    export function ɵɵprojection(nodeIndex: number, selectorIndex?: number, attrs?: TAttributes): void;
    
    /**
        * Instruction to distribute projectable nodes among <ng-content> occurrences in a given template.
        * It takes all the selectors from the entire component's template and decides where
        * each projected node belongs (it re-distributes nodes among "buckets" where each "bucket" is
        * backed by a selector).
        *
        * This function requires CSS selectors to be provided in 2 forms: parsed (by a compiler) and text,
        * un-parsed form.
        *
        * The parsed form is needed for efficient matching of a node against a given CSS selector.
        * The un-parsed, textual form is needed for support of the ngProjectAs attribute.
        *
        * Having a CSS selector in 2 different formats is not ideal, but alternatives have even more
        * drawbacks:
        * - having only a textual form would require runtime parsing of CSS selectors;
        * - we can't have only a parsed as we can't re-construct textual form from it (as entered by a
        * template author).
        *
        * @param projectionSlots? A collection of projection slots. A projection slot can be based
        *        on a parsed CSS selectors or set to the wildcard selector ("*") in order to match
        *        all nodes which do not match any selector. If not specified, a single wildcard
        *        selector projection slot will be defined.
        *
        * @codeGenApi
        */
    export function ɵɵprojectionDef(projectionSlots?: ProjectionSlots): void;
    
    /**
        * Update a property on a selected element.
        *
        * Operates on the element selected by index via the {@link select} instruction.
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled
        *
        * @param propName Name of property. Because it is going to DOM, this is not subject to
        *        renaming as part of minification.
        * @param value New value to write.
        * @param sanitizer An optional function used to sanitize the value.
        * @returns This function returns itself so that it may be chained
        * (e.g. `property('name', ctx.name)('title', ctx.title)`)
        *
        * @codeGenApi
        */
    export function ɵɵproperty<T>(propName: string, value: T, sanitizer?: SanitizerFn | null): typeof ɵɵproperty;
    
    /**
        *
        * Update an interpolated property on an element with a lone bound value
        *
        * Used when the value passed to a property has 1 interpolated value in it, an no additional text
        * surrounds that interpolated value:
        *
        * ```html
        * <div title="{{v0}}"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate('title', v0);
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate(propName: string, v0: any, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate;
    
    /**
        *
        * Update an interpolated property on an element with single bound value surrounded by text.
        *
        * Used when the value passed to a property has 1 interpolated value in it:
        *
        * ```html
        * <div title="prefix{{v0}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate1('title', 'prefix', v0, 'suffix');
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate1(propName: string, prefix: string, v0: any, suffix: string, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate1;
    
    /**
        *
        * Update an interpolated property on an element with 2 bound values surrounded by text.
        *
        * Used when the value passed to a property has 2 interpolated values in it:
        *
        * ```html
        * <div title="prefix{{v0}}-{{v1}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate2('title', 'prefix', v0, '-', v1, 'suffix');
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate2(propName: string, prefix: string, v0: any, i0: string, v1: any, suffix: string, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate2;
    
    /**
        *
        * Update an interpolated property on an element with 3 bound values surrounded by text.
        *
        * Used when the value passed to a property has 3 interpolated values in it:
        *
        * ```html
        * <div title="prefix{{v0}}-{{v1}}-{{v2}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate3(
        * 'title', 'prefix', v0, '-', v1, '-', v2, 'suffix');
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate3(propName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, suffix: string, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate3;
    
    /**
        *
        * Update an interpolated property on an element with 4 bound values surrounded by text.
        *
        * Used when the value passed to a property has 4 interpolated values in it:
        *
        * ```html
        * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate4(
        * 'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, 'suffix');
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate4(propName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, suffix: string, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate4;
    
    /**
        *
        * Update an interpolated property on an element with 5 bound values surrounded by text.
        *
        * Used when the value passed to a property has 5 interpolated values in it:
        *
        * ```html
        * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate5(
        * 'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, 'suffix');
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate5(propName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, suffix: string, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate5;
    
    /**
        *
        * Update an interpolated property on an element with 6 bound values surrounded by text.
        *
        * Used when the value passed to a property has 6 interpolated values in it:
        *
        * ```html
        * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate6(
        *    'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, 'suffix');
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate6(propName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, suffix: string, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate6;
    
    /**
        *
        * Update an interpolated property on an element with 7 bound values surrounded by text.
        *
        * Used when the value passed to a property has 7 interpolated values in it:
        *
        * ```html
        * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate7(
        *    'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, 'suffix');
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param i5 Static value used for concatenation only.
        * @param v6 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate7(propName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, i5: string, v6: any, suffix: string, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate7;
    
    /**
        *
        * Update an interpolated property on an element with 8 bound values surrounded by text.
        *
        * Used when the value passed to a property has 8 interpolated values in it:
        *
        * ```html
        * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolate8(
        *  'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, 'suffix');
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update
        * @param prefix Static value used for concatenation only.
        * @param v0 Value checked for change.
        * @param i0 Static value used for concatenation only.
        * @param v1 Value checked for change.
        * @param i1 Static value used for concatenation only.
        * @param v2 Value checked for change.
        * @param i2 Static value used for concatenation only.
        * @param v3 Value checked for change.
        * @param i3 Static value used for concatenation only.
        * @param v4 Value checked for change.
        * @param i4 Static value used for concatenation only.
        * @param v5 Value checked for change.
        * @param i5 Static value used for concatenation only.
        * @param v6 Value checked for change.
        * @param i6 Static value used for concatenation only.
        * @param v7 Value checked for change.
        * @param suffix Static value used for concatenation only.
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolate8(propName: string, prefix: string, v0: any, i0: string, v1: any, i1: string, v2: any, i2: string, v3: any, i3: string, v4: any, i4: string, v5: any, i5: string, v6: any, i6: string, v7: any, suffix: string, sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolate8;
    
    /**
        * Update an interpolated property on an element with 9 or more bound values surrounded by text.
        *
        * Used when the number of interpolated values exceeds 8.
        *
        * ```html
        * <div
        *  title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}-{{v8}}-{{v9}}suffix"></div>
        * ```
        *
        * Its compiled representation is::
        *
        * ```ts
        * ɵɵpropertyInterpolateV(
        *  'title', ['prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, '-', v9,
        *  'suffix']);
        * ```
        *
        * If the property name also exists as an input property on one of the element's directives,
        * the component property will be set instead of the element property. This check must
        * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
        *
        * @param propName The name of the property to update.
        * @param values The collection of values and the strings in between those values, beginning with a
        * string prefix and ending with a string suffix.
        * (e.g. `['prefix', value0, '-', value1, '-', value2, ..., value99, 'suffix']`)
        * @param sanitizer An optional sanitizer function
        * @returns itself, so that it may be chained.
        * @codeGenApi
        */
    export function ɵɵpropertyInterpolateV(propName: string, values: any[], sanitizer?: SanitizerFn): typeof ɵɵpropertyInterpolateV;
    
    /**
        * This feature resolves the providers of a directive (or component),
        * and publish them into the DI system, making it visible to others for injection.
        *
        * For example:
        * ```ts
        * class ComponentWithProviders {
        *   constructor(private greeter: GreeterDE) {}
        *
        *   static ɵcmp = defineComponent({
        *     type: ComponentWithProviders,
        *     selectors: [['component-with-providers']],
        *    factory: () => new ComponentWithProviders(directiveInject(GreeterDE as any)),
        *    decls: 1,
        *    vars: 1,
        *    template: function(fs: RenderFlags, ctx: ComponentWithProviders) {
        *      if (fs & RenderFlags.Create) {
        *        ɵɵtext(0);
        *      }
        *      if (fs & RenderFlags.Update) {
        *        ɵɵtextInterpolate(ctx.greeter.greet());
        *      }
        *    },
        *    features: [ɵɵProvidersFeature([GreeterDE])]
        *  });
        * }
        * ```
        *
        * @param definition
        *
        * @codeGenApi
        */
    export function ɵɵProvidersFeature<T>(providers: Provider[], viewProviders?: Provider[]): (definition: ɵDirectiveDef<T>) => void;
    
    /**
        * If the value hasn't been saved, calls the pure function to store and return the
        * value. If it has been saved, returns the saved value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn Function that returns a value
        * @param thisArg Optional calling context of pureFn
        * @returns value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction0<T>(slotOffset: number, pureFn: () => T, thisArg?: any): T;
    
    /**
        * If the value of the provided exp has changed, calls the pure function to return
        * an updated value. Or if the value has not changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn Function that returns an updated value
        * @param exp Updated expression value
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction1(slotOffset: number, pureFn: (v: any) => any, exp: any, thisArg?: any): any;
    
    /**
        * If the value of any provided exp has changed, calls the pure function to return
        * an updated value. Or if no values have changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn
        * @param exp1
        * @param exp2
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction2(slotOffset: number, pureFn: (v1: any, v2: any) => any, exp1: any, exp2: any, thisArg?: any): any;
    
    /**
        * If the value of any provided exp has changed, calls the pure function to return
        * an updated value. Or if no values have changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn
        * @param exp1
        * @param exp2
        * @param exp3
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction3(slotOffset: number, pureFn: (v1: any, v2: any, v3: any) => any, exp1: any, exp2: any, exp3: any, thisArg?: any): any;
    
    /**
        * If the value of any provided exp has changed, calls the pure function to return
        * an updated value. Or if no values have changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn
        * @param exp1
        * @param exp2
        * @param exp3
        * @param exp4
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction4(slotOffset: number, pureFn: (v1: any, v2: any, v3: any, v4: any) => any, exp1: any, exp2: any, exp3: any, exp4: any, thisArg?: any): any;
    
    /**
        * If the value of any provided exp has changed, calls the pure function to return
        * an updated value. Or if no values have changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn
        * @param exp1
        * @param exp2
        * @param exp3
        * @param exp4
        * @param exp5
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction5(slotOffset: number, pureFn: (v1: any, v2: any, v3: any, v4: any, v5: any) => any, exp1: any, exp2: any, exp3: any, exp4: any, exp5: any, thisArg?: any): any;
    
    /**
        * If the value of any provided exp has changed, calls the pure function to return
        * an updated value. Or if no values have changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn
        * @param exp1
        * @param exp2
        * @param exp3
        * @param exp4
        * @param exp5
        * @param exp6
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction6(slotOffset: number, pureFn: (v1: any, v2: any, v3: any, v4: any, v5: any, v6: any) => any, exp1: any, exp2: any, exp3: any, exp4: any, exp5: any, exp6: any, thisArg?: any): any;
    
    /**
        * If the value of any provided exp has changed, calls the pure function to return
        * an updated value. Or if no values have changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn
        * @param exp1
        * @param exp2
        * @param exp3
        * @param exp4
        * @param exp5
        * @param exp6
        * @param exp7
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction7(slotOffset: number, pureFn: (v1: any, v2: any, v3: any, v4: any, v5: any, v6: any, v7: any) => any, exp1: any, exp2: any, exp3: any, exp4: any, exp5: any, exp6: any, exp7: any, thisArg?: any): any;
    
    /**
        * If the value of any provided exp has changed, calls the pure function to return
        * an updated value. Or if no values have changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn
        * @param exp1
        * @param exp2
        * @param exp3
        * @param exp4
        * @param exp5
        * @param exp6
        * @param exp7
        * @param exp8
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpureFunction8(slotOffset: number, pureFn: (v1: any, v2: any, v3: any, v4: any, v5: any, v6: any, v7: any, v8: any) => any, exp1: any, exp2: any, exp3: any, exp4: any, exp5: any, exp6: any, exp7: any, exp8: any, thisArg?: any): any;
    
    /**
        * pureFunction instruction that can support any number of bindings.
        *
        * If the value of any provided exp has changed, calls the pure function to return
        * an updated value. Or if no values have changed, returns cached value.
        *
        * @param slotOffset the offset from binding root to the reserved slot
        * @param pureFn A pure function that takes binding values and builds an object or array
        * containing those values.
        * @param exps An array of binding values
        * @param thisArg Optional calling context of pureFn
        * @returns Updated or cached value
        *
        * @codeGenApi
        */
    export function ɵɵpur