import { Directive, Inject, Input, Optional, } from '@angular/core';
import { DynamicComponentInjectorToken, } from '../component-injector';
import * as i0 from "@angular/core";
export class DynamicAttributesDirective {
    constructor(renderer, differs, injector, componentInjector) {
        this.renderer = renderer;
        this.differs = differs;
        this.injector = injector;
        this.componentInjector = componentInjector;
        this.attrsDiffer = this.differs.find({}).create();
    }
    get _attributes() {
        return (this.ndcDynamicAttributes || this.ngComponentOutletNdcDynamicAttributes);
    }
    get _nativeElement() {
        return this.componentInjector.componentRef?.location.nativeElement;
    }
    get _compType() {
        return this.componentInjector.componentRef?.componentType;
    }
    get _isCompChanged() {
        if (this.lastCompType !== this._compType) {
            this.lastCompType = this._compType;
            return true;
        }
        return false;
    }
    ngDoCheck() {
        const isCompChanged = this._isCompChanged;
        const changes = this.attrsDiffer.diff(this._attributes);
        if (changes) {
            this.lastAttrActions = this._changesToAttrActions(changes);
        }
        if (changes || (isCompChanged && this.lastAttrActions)) {
            this._updateAttributes(this.lastAttrActions);
        }
    }
    setAttribute(name, value, namespace) {
        if (this._nativeElement) {
            this.renderer.setAttribute(this._nativeElement, name, value, namespace);
        }
    }
    removeAttribute(name, namespace) {
        if (this._nativeElement) {
            this.renderer.removeAttribute(this._nativeElement, name, namespace);
        }
    }
    _updateAttributes(actions) {
        // ? Early exit if no dynamic component
        if (!this._compType) {
            return;
        }
        Object.keys(actions.set).forEach((key) => this.setAttribute(key, actions.set[key]));
        actions.remove.forEach((key) => this.removeAttribute(key));
    }
    _changesToAttrActions(changes) {
        const attrActions = {
            set: {},
            remove: [],
        };
        changes.forEachAddedItem((r) => (attrActions.set[r.key] = r.currentValue));
        changes.forEachChangedItem((r) => (attrActions.set[r.key] = r.currentValue));
        changes.forEachRemovedItem((r) => attrActions.remove.push(r.key));
        return attrActions;
    }
}
/** @nocollapse */ /** @nocollapse */ DynamicAttributesDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicAttributesDirective, deps: [{ token: i0.Renderer2 }, { token: i0.KeyValueDiffers }, { token: i0.Injector }, { token: DynamicComponentInjectorToken, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ /** @nocollapse */ DynamicAttributesDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.2", type: DynamicAttributesDirective, selector: "[ndcDynamicAttributes],[ngComponentOutletNdcDynamicAttributes]", inputs: { ndcDynamicAttributes: "ndcDynamicAttributes", ngComponentOutletNdcDynamicAttributes: "ngComponentOutletNdcDynamicAttributes" }, exportAs: ["ndcDynamicAttributes"], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicAttributesDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[ndcDynamicAttributes],[ngComponentOutletNdcDynamicAttributes]',
                    exportAs: 'ndcDynamicAttributes',
                }]
        }], ctorParameters: function () { return [{ type: i0.Renderer2 }, { type: i0.KeyValueDiffers }, { type: i0.Injector }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [DynamicComponentInjectorToken]
                }, {
                    type: Optional
                }] }]; }, propDecorators: { ndcDynamicAttributes: [{
                type: Input
            }], ngComponentOutletNdcDynamicAttributes: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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