import { Directive, ElementRef, EventEmitter, Inject, Injector, Input, Optional, Output, } from '@angular/core';
import { DynamicComponentInjectorToken, } from '../component-injector';
import { IoFactoryService } from '../io';
import { extractNgParamTypes, getCtorParamTypes } from '../util';
import * as i0 from "@angular/core";
import * as i1 from "../io";
import * as i2 from "../window-ref";
export function dynamicDirectiveDef(type, inputs, outputs) {
    return { type, inputs, outputs };
}
export class DynamicDirectivesDirective {
    constructor(iterableDiffers, ioFactoryService, windowRef, componentInjector) {
        this.iterableDiffers = iterableDiffers;
        this.ioFactoryService = ioFactoryService;
        this.windowRef = windowRef;
        this.componentInjector = componentInjector;
        this.ndcDynamicDirectivesCreated = new EventEmitter();
        this.dirRef = new Map();
        this.dirIo = new Map();
        this.dirsDiffer = this.iterableDiffers
            .find([])
            .create((_, def) => def.type);
    }
    get directives() {
        return (this.ndcDynamicDirectives || this.ngComponentOutletNdcDynamicDirectives);
    }
    get componentRef() {
        return this.componentInjector.componentRef;
    }
    get compInstance() {
        return this.componentRef && this.componentRef.instance;
    }
    get isCompChanged() {
        if (this.lastCompInstance !== this.compInstance) {
            this.lastCompInstance = this.compInstance;
            return true;
        }
        return false;
    }
    get hostInjector() {
        return this.componentRef.injector;
    }
    get hostVcr() {
        // NOTE: Accessing private APIs of Angular
        // eslint-disable-next-line @typescript-eslint/dot-notation
        return this.componentRef['_viewRef']['_viewContainerRef'];
    }
    get reflect() {
        return this.windowRef.nativeWindow.Reflect;
    }
    ngDoCheck() {
        if (this.maybeDestroyDirectives()) {
            return;
        }
        const dirsChanges = this.dirsDiffer.diff(this.directives);
        if (!dirsChanges) {
            return this.updateDirectives();
        }
        this.processDirChanges(dirsChanges);
    }
    ngOnDestroy() {
        this.destroyAllDirectives();
    }
    maybeDestroyDirectives() {
        if (this.isCompChanged || !this.componentRef) {
            this.dirsDiffer.diff([]);
            this.destroyAllDirectives();
        }
        return !this.componentRef;
    }
    processDirChanges(changes) {
        changes.forEachRemovedItem(({ item }) => this.destroyDirective(item));
        const createdDirs = [];
        changes.forEachAddedItem(({ item }) => createdDirs.push(this.initDirective(item)));
        if (createdDirs.length) {
            this.ndcDynamicDirectivesCreated.emit(createdDirs.filter(Boolean));
        }
    }
    updateDirectives() {
        this.directives.forEach((dir) => this.updateDirective(dir));
    }
    updateDirective(dirDef) {
        const io = this.dirIo.get(dirDef.type);
        io.update(dirDef.inputs, dirDef.outputs, false, false);
        io.maybeUpdate();
    }
    initDirective(dirDef) {
        if (this.dirRef.has(dirDef.type)) {
            return;
        }
        const instance = this.createDirective(dirDef.type);
        const dir = {
            instance,
            type: dirDef.type,
            injector: this.hostInjector,
            hostComponent: this.componentRef.instance,
            hostView: this.componentRef.hostView,
            location: this.componentRef.location,
            changeDetectorRef: this.componentRef.changeDetectorRef,
            onDestroy: this.componentRef.onDestroy,
        };
        this.initDirIO(dir, dirDef.inputs, dirDef.outputs);
        this.callInitHooks(instance);
        this.dirRef.set(dir.type, dir);
        return dir;
    }
    destroyAllDirectives() {
        this.dirRef.forEach((dir) => this.destroyDirRef(dir));
        this.dirRef.clear();
        this.dirIo.clear();
    }
    destroyDirective(dirDef) {
        this.destroyDirRef(this.dirRef.get(dirDef.type));
        this.dirRef.delete(dirDef.type);
        this.dirIo.delete(dirDef.type);
    }
    initDirIO(dir, inputs, outputs) {
        const io = this.ioFactoryService.create();
        io.init({ componentRef: this.dirToCompDef(dir) }, { trackOutputChanges: true });
        io.update(inputs, outputs, !!inputs, !!outputs);
        this.dirIo.set(dir.type, io);
    }
    dirToCompDef(dir) {
        return {
            changeDetectorRef: this.componentRef.changeDetectorRef,
            hostView: this.componentRef.hostView,
            location: this.componentRef.location,
            destroy: this.componentRef.destroy,
            onDestroy: this.componentRef.onDestroy,
            injector: this.componentRef.injector,
            instance: dir.instance,
            componentType: dir.type,
        };
    }
    destroyDirRef(dir) {
        const io = this.dirIo.get(dir.type);
        io.ngOnDestroy();
        if ('ngOnDestroy' in dir.instance) {
            dir.instance.ngOnDestroy();
        }
    }
    createDirective(dirType) {
        const directiveInjector = Injector.create({
            providers: [
                {
                    provide: dirType,
                    useClass: dirType,
                    deps: this.resolveDirParamTypes(dirType),
                },
                { provide: ElementRef, useValue: this.componentRef.location },
            ],
            parent: this.hostInjector,
            name: `DynamicDirectiveInjector:${dirType.name}@${this.componentRef.componentType.name}`,
        });
        return directiveInjector.get(dirType);
    }
    resolveDirParamTypes(dirType) {
        return (
        // First try Angular Compiler's metadata
        extractNgParamTypes(dirType) ??
            // Then fallback to Typescript Reflect API
            getCtorParamTypes(dirType, this.reflect) ??
            // Bailout
            []);
    }
    callInitHooks(obj) {
        this.callHook(obj, 'ngOnInit');
        this.callHook(obj, 'ngDoCheck');
        this.callHook(obj, 'ngAfterContentInit');
        this.callHook(obj, 'ngAfterContentChecked');
        this.callHook(obj, 'ngAfterViewInit');
        this.callHook(obj, 'ngAfterViewChecked');
    }
    callHook(obj, hook, args = []) {
        if (obj[hook]) {
            obj[hook](...args);
        }
    }
}
/** @nocollapse */ /** @nocollapse */ DynamicDirectivesDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicDirectivesDirective, deps: [{ token: i0.IterableDiffers }, { token: i1.IoFactoryService }, { token: i2.WindowRefService }, { token: DynamicComponentInjectorToken, optional: true }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ /** @nocollapse */ DynamicDirectivesDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "13.0.2", type: DynamicDirectivesDirective, selector: "[ndcDynamicDirectives],[ngComponentOutletNdcDynamicDirectives]", inputs: { ndcDynamicDirectives: "ndcDynamicDirectives", ngComponentOutletNdcDynamicDirectives: "ngComponentOutletNdcDynamicDirectives" }, outputs: { ndcDynamicDirectivesCreated: "ndcDynamicDirectivesCreated" }, providers: [IoFactoryService], ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.0.2", ngImport: i0, type: DynamicDirectivesDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[ndcDynamicDirectives],[ngComponentOutletNdcDynamicDirectives]',
                    providers: [IoFactoryService],
                }]
        }], ctorParameters: function () { return [{ type: i0.IterableDiffers }, { type: i1.IoFactoryService }, { type: i2.WindowRefService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [DynamicComponentInjectorToken]
                }, {
                    type: Optional
                }] }]; }, propDecorators: { ndcDynamicDirectives: [{
                type: Input
            }], ngComponentOutletNdcDynamicDirectives: [{
                type: Input
            }], ndcDynamicDirectivesCreated: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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